/*
    vhfcontestnet.c - Upload to www.vhfcontest.net
    Copyright (C) 2014-2015 Ladislav Vaiz <ok1zia@nagano.cz>

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    version 2 as published by the Free Software Foundation.

*/

#include "header.h"

#include "vhfcontestnet.h"

#include <libzia.h>

#include "bfu.h"
#include "dwdb.h"
#include "fifo.h"
#include "main.h"
#include "menu.h"
#include "subwin.h"
#include "tregex.h"



struct vhfcontestnet *init_vhfcontestnet(void){
	struct vhfcontestnet *vcn = g_new0(struct vhfcontestnet, 1);

	vcn->http = zhttp_init();
	return vcn;
}

void free_vhfcontestnet(struct vhfcontestnet *vcn){

	if (vcn->http) zhttp_free(vcn->http);
	g_free(vcn);
}

int vhfcontestnet_country(char *call){
	char dxcc[256];
	get_dxcc(dw, dxcc, call);
	z_str_uc(dxcc);

	if (strcmp(dxcc, "9A") == 0) return 5;
	if (strcmp(dxcc, "CT") == 0) return 27;
	if (strcmp(dxcc, "DL") == 0) return 3;
	if (strcmp(dxcc, "EA") == 0) return 26;
	if (strcmp(dxcc, "ES") == 0) return 16;
	if (strcmp(dxcc, "F") == 0) return 6;
	if (strcmp(dxcc, "G") == 0) return 19;
	if (strcmp(dxcc, "HA") == 0) return 28;
	if (strcmp(dxcc, "HB9") == 0) return 20;
	if (strcmp(dxcc, "I") == 0) return 7;
	if (strcmp(dxcc, "LA") == 0) return 23;
	if (strcmp(dxcc, "LY") == 0) return 17;
	if (strcmp(dxcc, "LZ") == 0) return 11;
	if (strcmp(dxcc, "OE") == 0) return 29;
	if (strcmp(dxcc, "OH") == 0) return 15;
	if (strcmp(dxcc, "OK") == 0) return 1;
	if (strcmp(dxcc, "OM") == 0) return 2;
	if (strcmp(dxcc, "ON") == 0) return 22;
	if (strcmp(dxcc, "OZ") == 0) return 13;
	if (strcmp(dxcc, "PA") == 0) return 21;
	if (strcmp(dxcc, "RA") == 0) return 25;
	if (strcmp(dxcc, "S5") == 0) return 4;
	if (strcmp(dxcc, "SM") == 0) return 14;
	if (strcmp(dxcc, "SP") == 0) return 12;
	if (strcmp(dxcc, "T9") == 0) return 9;
	if (strcmp(dxcc, "UR") == 0) return 24;
	if (strcmp(dxcc, "YL") == 0) return 18;
	if (strcmp(dxcc, "YO") == 0) return 10;
	if (strcmp(dxcc, "YU") == 0) return 8;
	if (strcmp(dxcc, "Z3") == 0) return 30;
	
	return -1;
}



void vhfcontestnet_upload(void *arg){
	if (gses->vcn) return;
	if (!ctest) return;

	menu_export_edi(arg);

	gses->vcn = init_vhfcontestnet();

	g_free(gses->vcn->status);gses->vcn->status = g_strdup(VTEXT(T_READING_LIST_OF_OPENED_CONTESTS));

	vhfcontestnet_info(NULL);

	sw_raise_or_new(SWT_LOG);
	zhttp_get(gses->vcn->http, zsel, "http://www.vhfcontest.net/index.php?kat=zavody&lang=eng", vhfcontestnet_zavody, gses->vcn);
}

void vhfcontestnet_zavody(struct zhttp *http){
	struct vhfcontestnet *vcn = (struct vhfcontestnet*)http->arg;
	char line[4096];
	int ofs, n = 0, max = 0;
    struct menu_item *mi = NULL;

	if (http->errorstr){
		g_free(vcn->status);vcn->status = g_strdup_printf(VTEXT(T_CANT_GET_LIST_OF_CONTESTS), http->errorstr);
		zhttp_free(vcn->http); vcn->http = NULL;
		//free_vhfcontestnet(vcn);
		return;
	}

	if (!(mi = new_menu(3))) return;
	mi->rtext = VTEXT(T_CHOOSE_CONTEST);

	for (ofs = http->dataofs; ofs < http->response->len; ofs++){
		char *c1 = NULL, *c2 = NULL, *d1 = NULL, *d2 = NULL;
		zbinbuf_getline(http->response, &ofs, line, sizeof(line)); 
		//dbg("line=%s\n", line);
		if (regmatch(line, "<a href=\"\\?kat=getlog\\/upload&lang=eng&zavod=([0-9]+)\">", &c1, &c2, NULL) == 0){
			//dbg("MATCH %s\n", c2);
			if (regmatch(line, "\\.<\\/td><td>([^<]+)<\\/td>", &d1, &d2, NULL) == 0){
				add_to_menu(&mi, g_strdup(d2),"", "", vhfcontestnet_contest, GINT_TO_POINTER(atoi(c2)), 0); 
				if (strlen(d2) > max) max = strlen(d2);
				n++;
			}
	 	}
		g_free(c1);
		g_free(c2);
		g_free(d1);
		g_free(d2);
	}

	if (mi->func == NULL){
		g_free(vcn->status);vcn->status = g_strdup(VTEXT(T_NO_CONTEST_AVAILABLE_FOR_UPLOAD));
		zhttp_free(vcn->http); vcn->http = NULL;
		//free_vhfcontestnet(vcn);
		return;
	}
	
    set_window_ptr(gses->win, (term->x - max)/2,(term->y - 2 - n)/2);
    do_menu_selected(mi, http, 0);
	
}

void vhfcontestnet_contest(void *arg, void *arg2){
	struct zhttp *http = (struct zhttp*)arg2;
	struct vhfcontestnet *vcn = (struct vhfcontestnet*)http->arg;
	char *url;

	vcn->ctestid = GPOINTER_TO_INT(arg);

	g_free(vcn->status);vcn->status = g_strdup(VTEXT(T_OBTAINING_CONTEST_WEB_FORM));
	
	url = g_strdup_printf("http://www.vhfcontest.net/?kat=getlog/upload&lang=eng&zavod=%d", vcn->ctestid);
	zhttp_get(http, zsel, url, vhfcontestnet_contestform, http->arg);
	g_free(url);
}

void vhfcontestnet_contestform(struct zhttp *http){
	struct vhfcontestnet *vcn = (struct vhfcontestnet*)http->arg;
	char line[4096], *c, *log;
	int ofs;
	struct band *b;

	if (http->errorstr){
		g_free(vcn->status);vcn->status = g_strdup_printf(VTEXT(T_CANT_GET_UPLOAD_FORM), http->errorstr);
		zhttp_free(vcn->http); vcn->http = NULL;
		return;
	}

	zhttp_post_free(http);
    for (ofs = http->dataofs; ofs < http->response->len; ofs++){
		char *c1 = NULL, *c2 = NULL, *c3 = NULL;
		zbinbuf_getline(http->response, &ofs, line, sizeof(line)); 
		//dbg("line=%s\n", line);
		if (regmatch(line, "<input type=[\"]*hidden[\"]* +name=[\"]*([a-zA-Z0-9]+)[\"]* +value=[\"]*([a-zA-Z0-9\\/]+)[\"]*>", &c1, &c2, &c3, NULL) == 0){
			dbg("MATCH '%s' = '%s'\n", c2, c3);
			zhttp_post_add(http, c2, c3);
	 	}
		g_free(c1);
		g_free(c2);
		g_free(c3);
	}
	zhttp_post_add(http, "zverejnit", "1");
	vcn->country = vhfcontestnet_country(ctest ? ctest->pcall : cfg->pcall); // TODO zajistit spusteni jen v kontestu
	c = g_strdup_printf("%d", vcn->country); 
	zhttp_post_add(http, "country", c);
	g_free(c);

	for (; vcn->bandi < ctest->bands->len; vcn->bandi++){
		b = (struct band *)g_ptr_array_index(ctest->bands, vcn->bandi);
		if (b->edifile != NULL) break;
	}
	if (vcn->bandi >= ctest->bands->len){
		log_addf(VTEXT(T_ALL_EDI_FILES_PROCESSED), http->errorstr);
		vhfcontestnet_ask_claimed(http);
		return;
	}

	g_free(vcn->status);vcn->status = g_strdup_printf(VTEXT(T_UPLOADING_LOG_FILE_S), z_filename(b->edifile));
	log_addf(VTEXT(T_UPLOADING_BAND_S), b->bandname);

	log = zfile_readfile(b->edifile);
	if (log == NULL){
		g_free(vcn->status);vcn->status = g_strdup_printf(VTEXT(T_CANT_READ_LOG_FILE), b->edifile);
		zhttp_free(vcn->http); vcn->http = NULL;
		//free_vhfcontestnet(vcn);
		return;
	}
	zhttp_post_add_file_mem(http, "log", z_filename(b->edifile), log);

	zhttp_post(http, zsel, "http://www.vhfcontest.net/", vhfcontestnet_sent, http->arg);
	//zhttp_post(http, zsel, "http://ok1zia.nagano.cz/tmp/post.php", vhfcontestnet_sent, http->arg);
}

void vhfcontestnet_sent(struct zhttp *http){
	struct vhfcontestnet *vcn = (struct vhfcontestnet*)http->arg;
	char *html, *txt, *c1 = NULL, *c2 = NULL;

    if (http->errorstr){
		g_free(vcn->status);vcn->status = g_strdup_printf(VTEXT(T_CANT_UPLOAD_LOG), http->errorstr);
		zhttp_free(vcn->http); vcn->http = NULL;
		//free_vhfcontestnet(vcn);
		return;
	}

	g_free(vcn->status);vcn->status = g_strdup(VTEXT(T_CONFIRMING_LOG));


	html = (char *)g_malloc(http->response->len + 1);
	zbinbuf_getstr(http->response, http->dataofs, html, http->response->len - http->dataofs + 1);

	txt = z_html2txt(html);


	if (regmatch(html, "<a href=\"([^\"]*getlog\\/yessql[^\"]*)\">", &c1, &c2, NULL) == 0){
		GString *gs = g_string_new(c2);
		z_string_replace(gs, "\r", "", ZSR_ALL);
		z_string_replace(gs, "\n", "", ZSR_ALL);
		z_string_replace(gs, " ", "%20", ZSR_ALL); // workaround, bug on vhfcontest.net
		g_string_insert(gs, 0, "http://www.vhfcontest.net/");
		zhttp_get(http, zsel, gs->str, vhfcontestnet_confirmed, http->arg);
		g_string_free(gs, TRUE);
		g_free(c1);
		g_free(c2);
	}else{
		fifo_add_lines(glog, txt);
		log_addf(VTEXT(T_RESULT_ERROR));
		g_free(vcn->status);vcn->status = g_strdup_printf(VTEXT(T_LOG_IS_NOT_VALID), http->errorstr);
		zhttp_free(vcn->http); vcn->http = NULL;
		//free_vhfcontestnet(vcn);
	}


	g_free(html);
	g_free(txt);
}


void vhfcontestnet_confirmed(struct zhttp *http){
	struct vhfcontestnet *vcn = (struct vhfcontestnet*)http->arg;

    if (http->errorstr){
		g_free(vcn->status);vcn->status = g_strdup_printf(VTEXT(T_CANT_CONFIRM_LOG), http->errorstr);
		zhttp_free(vcn->http); vcn->http = NULL;//free_vhfcontestnet(vcn);
		return;
	}

	/*log_adds("");
	log_adds("");

	html = (char *)g_malloc(http->response->len + 1);
	zbinbuf_getstr(http->response, http->dataofs, html, http->response->len - http->dataofs + 1);

	txt = z_html2txt(html);
	fifo_add_lines(glog, txt);
	*/
	log_addf("OK");

	vcn->bandi++;
	vhfcontestnet_contest(GINT_TO_POINTER(vcn->ctestid), http);

}

void vhfcontestnet_ask_claimed(struct zhttp *http){
	struct vhfcontestnet *vcn = (struct vhfcontestnet*)http->arg;
	char *url;

	g_free(vcn->status);vcn->status = g_strdup(VTEXT(T_DOWNLOADING_CLAIMED_SCORES));

	url = g_strdup_printf("http://www.vhfcontest.net/getlog/gentxtsql.php?zavod=%d&country=%d", vcn->ctestid, vcn->country);
	
	zhttp_get(http, zsel, url, vhfcontestnet_claimed, http->arg);
	g_free(url);
}

void vhfcontestnet_claimed(struct zhttp *http){
	struct vhfcontestnet *vcn = (struct vhfcontestnet*)http->arg;
	char *html, *c;
	GString *gs;

    if (http->errorstr){
		g_free(vcn->status);vcn->status = g_strdup_printf(VTEXT(T_CANT_GET_CLAIMED_SCORES), http->errorstr);
		zhttp_free(vcn->http); vcn->http = NULL;//free_vhfcontestnet(vcn);
		return;
	}


	
	html = (char *)g_malloc(http->response->len + 1);
	zbinbuf_getstr(http->response, http->dataofs, html, http->response->len - http->dataofs + 1);

	gs = g_string_new(html);
	c = z_strcasestr(gs->str, "<pre>");
	if (c != NULL) g_string_erase(gs, 0, (c - gs->str) + 5);
	c = z_strcasestr(gs->str, "</pre>");
	if (c != NULL) g_string_truncate(gs, c - gs->str);

	fifo_add_lines(glog, gs->str);

	g_string_free(gs, TRUE);
	g_free(html);

	g_free(vcn->status);vcn->status = g_strdup(VTEXT(T_LOGS_UPLOADED));
	zhttp_free(vcn->http); vcn->http = NULL;

}

void vhfcontestnet_abort(void *arg){
	if (!gses->vcn) return;
	free_vhfcontestnet(gses->vcn);
	gses->vcn = NULL;
}

void vhfcontestnet_info(void *arg1){
	struct refresh *r;
	char *c, *button;
	GString *gs;

	if (!gses || !gses->vcn) return;

	if (term->windows.next->handler	== menu_func){
		zselect_timer_new(zsel, RESOURCE_INFO_REFRESH, vhfcontestnet_info, NULL);
	}else{
		r = (struct refresh*)g_malloc(sizeof(struct refresh));
		r->win = NULL;
		r->fn = vhfcontestnet_info;
		r->data = NULL;
		r->timer = -1;

		gs = g_string_new("");
		if (gses->vcn->status != NULL) g_string_sprintfa(gs, "%s", gses->vcn->status);
		if (gses->vcn->status != NULL && gses->vcn->http != NULL) g_string_append(gs, "\n\n");
		if (gses->vcn->http != NULL){
			g_string_append(gs, VTEXT(T_HTTP_STATUS));
			zhttp_status(gses->vcn->http, gs);
			button = VTEXT(T_CANCEL);
		}else{
			button = VTEXT(T_OK);
		}
		c = g_strdup(gs->str);
		g_string_free(gs, TRUE);

		msg_box(getml(c, NULL), VTEXT(T_LOG_UPLOAD)/*VTEXT(T_NINFO)*/, AL_LEFT, c, r, 1, button, vhfcontestnet_abort, B_ENTER | B_ESC);
		r->win = term->windows.next;
		((struct dialog_data *)r->win->data)->dlg->abort = refresh_abort;
		r->timer = zselect_timer_new(zsel, RESOURCE_INFO_REFRESH, (void (*)(void *))refresh, r);
	}
}
