r"""
    This code was generated by
   ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
    |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
    |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \

    Bulk Messaging and Broadcast
    Bulk Sending is a public Twilio REST API for 1:Many Message creation up to 100 recipients. Broadcast is a public Twilio REST API for 1:Many Message creation up to 10,000 recipients via file upload.

    NOTE: This class is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
    Do not edit the class manually.
"""

from typing import Optional
from twilio.base.version import Version
from twilio.base.domain import Domain
from twilio.rest.preview_messaging.v1.broadcast import BroadcastList
from twilio.rest.preview_messaging.v1.message import MessageList


class V1(Version):

    def __init__(self, domain: Domain):
        """
        Initialize the V1 version of PreviewMessaging

        :param domain: The Twilio.preview_messaging domain
        """
        super().__init__(domain, "v1")
        self._broadcasts: Optional[BroadcastList] = None
        self._messages: Optional[MessageList] = None

    @property
    def broadcasts(self) -> BroadcastList:
        if self._broadcasts is None:
            self._broadcasts = BroadcastList(self)
        return self._broadcasts

    @property
    def messages(self) -> MessageList:
        if self._messages is None:
            self._messages = MessageList(self)
        return self._messages

    def __repr__(self) -> str:
        """
        Provide a friendly representation
        :returns: Machine friendly representation
        """
        return "<Twilio.PreviewMessaging.V1>"
