# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from tests import IntegrationTestCase
from tests.holodeck import Request
from twilio.base.exceptions import TwilioException
from twilio.http.response import Response


class UsecaseTestCase(IntegrationTestCase):

    def test_fetch_request(self):
        self.holodeck.mock(Response(500, ''))

        with self.assertRaises(TwilioException):
            self.client.messaging.v1.usecases.fetch()

        self.holodeck.assert_has_request(Request(
            'get',
            'https://messaging.twilio.com/v1/Services/Usecases',
        ))

    def test_fetch_response(self):
        self.holodeck.mock(Response(
            200,
            '''
            {
                "usecases": [
                    {
                        "usecase": "notifications",
                        "description": "Transactional notifications and Alerts for any Delivery, Account, Reminder, Order, Fraud, Security, Public Service, or Emergency announcements.",
                        "purpose": "Notify my users."
                    },
                    {
                        "usecase": "marketing",
                        "description": "Marketing messages may contain product information, offers, and calls to action to engage with your organization.",
                        "purpose": "Market my services."
                    }
                ]
            }
            '''
        ))

        actual = self.client.messaging.v1.usecases.fetch()

        self.assertIsNotNone(actual)
