#
# PySNMP MIB module IPOA-MIB (http://pysnmp.sf.net)
# ASN.1 source http://mibs.snmplabs.com:80/asn1/IPOA-MIB
# Produced by pysmi-0.0.7 at Sun Feb 14 00:18:13 2016
# On host bldfarm platform Linux version 4.1.13-100.fc21.x86_64 by user goose
# Using Python version 3.5.0 (default, Jan  5 2016, 17:11:52) 
#
( OctetString, ObjectIdentifier, Integer, ) = mibBuilder.importSymbols("ASN1", "OctetString", "ObjectIdentifier", "Integer")
( NamedValues, ) = mibBuilder.importSymbols("ASN1-ENUMERATION", "NamedValues")
( ValueSizeConstraint, ValueRangeConstraint, ConstraintsUnion, ConstraintsIntersection, SingleValueConstraint, ) = mibBuilder.importSymbols("ASN1-REFINEMENT", "ValueSizeConstraint", "ValueRangeConstraint", "ConstraintsUnion", "ConstraintsIntersection", "SingleValueConstraint")
( InterfaceIndex, InterfaceIndexOrZero, ) = mibBuilder.importSymbols("IF-MIB", "InterfaceIndex", "InterfaceIndexOrZero")
( ipNetToMediaPhysAddress, ipAdEntAddr, ipNetToMediaIfIndex, ipNetToMediaNetAddress, ) = mibBuilder.importSymbols("IP-MIB", "ipNetToMediaPhysAddress", "ipAdEntAddr", "ipNetToMediaIfIndex", "ipNetToMediaNetAddress")
( ModuleCompliance, NotificationGroup, ObjectGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ModuleCompliance", "NotificationGroup", "ObjectGroup")
( Bits, MibIdentifier, transmission, NotificationType, IpAddress, ModuleIdentity, Gauge32, TimeTicks, ObjectIdentity, Counter64, Unsigned32, MibScalar, MibTable, MibTableRow, MibTableColumn, Integer32, iso, Counter32, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "MibIdentifier", "transmission", "NotificationType", "IpAddress", "ModuleIdentity", "Gauge32", "TimeTicks", "ObjectIdentity", "Counter64", "Unsigned32", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "Integer32", "iso", "Counter32")
( DisplayString, RowStatus, TextualConvention, ) = mibBuilder.importSymbols("SNMPv2-TC", "DisplayString", "RowStatus", "TextualConvention")
ipoaMIB = ModuleIdentity((1, 3, 6, 1, 2, 1, 10, 46))
if mibBuilder.loadTexts: ipoaMIB.setLastUpdated('9802090000Z')
if mibBuilder.loadTexts: ipoaMIB.setOrganization('IETF Internetworking Over NBMA Working\n                    Group (ion)')
if mibBuilder.loadTexts: ipoaMIB.setContactInfo('Maria Greene (greene@xedia.com)\n           Xedia Corp.\n\n           Jim Luciani (jluciani@BayNetworks.com)\n           Bay Networks\n\n           Kenneth White (kennethw@vnet.ibm.com)\n           IBM Corp.\n\n           Ted Kuo (tkuo@eos.ncsu.edu)\n           Bay Networks')
if mibBuilder.loadTexts: ipoaMIB.setDescription('This module defines a portion of the management\n          information base (MIB) for managing Classical IP and\n          ARP over ATM entities.')
class IpoaEncapsType(Integer32, TextualConvention):
    subtypeSpec = Integer32.subtypeSpec+ConstraintsUnion(SingleValueConstraint(1, 2, 3,))
    namedValues = NamedValues(("llcSnap", 1), ("vcMuxed", 2), ("other", 3),)

class IpoaVpiInteger(Integer32, TextualConvention):
    subtypeSpec = Integer32.subtypeSpec+ValueRangeConstraint(0,255)

class IpoaVciInteger(Integer32, TextualConvention):
    subtypeSpec = Integer32.subtypeSpec+ValueRangeConstraint(0,65535)

class IpoaAtmAddr(OctetString, TextualConvention):
    displayHint = '1x'
    subtypeSpec = OctetString.subtypeSpec+ValueSizeConstraint(0,40)

class IpoaAtmConnKind(Integer32, TextualConvention):
    subtypeSpec = Integer32.subtypeSpec+ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4, 5,))
    namedValues = NamedValues(("pvc", 1), ("svcIncoming", 2), ("svcOutgoing", 3), ("spvcInitiator", 4), ("spvcTarget", 5),)

ipoaObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 46, 1))
ipoaNotifications = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 46, 2))
ipoaConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 46, 3))
ipoaLisTrapEnable = MibScalar((1, 3, 6, 1, 2, 1, 10, 46, 1, 1), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2,))).clone(namedValues=NamedValues(("enabled", 1), ("disabled", 2),))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ipoaLisTrapEnable.setDescription('Indicates whether ipoaLisCreate and ipoaLisDelete\n          traps should be generated by this system.\n\n          By default, this object should have the value\n          enabled(1) for systems where ATMARP Servers are\n          present and disabled(2) on systems where only\n          clients reside.')
ipoaLisTable = MibTable((1, 3, 6, 1, 2, 1, 10, 46, 1, 2), )
if mibBuilder.loadTexts: ipoaLisTable.setDescription('There is one entry in this table for every Logical IP\n          Subnet (LIS) of which this system is a member.\n\n          The bulk of the objects in an ipoaLisEntry exists\n          to control ATMARP for a particular LIS.  In a PVC only\n          environment it is implementation dependent as to\n          whether this table should be supported.')
ipoaLisEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 46, 1, 2, 1), ).setIndexNames((0, "IPOA-MIB", "ipoaLisSubnetAddr"))
if mibBuilder.loadTexts: ipoaLisEntry.setDescription('Information about a single LIS of which this system\n          is a member.\n\n          Membership in a LIS is independent of the actual ATM\n          interfaces being used.  The ipoaLisTable defines\n          all LISs that a system is a member of.  The ipAddrTable\n          and the ipoaClientTable provides the mapping from local\n          IP address to ATM interface.  The ipoaLisIfMappingTable\n          provides the mappings between Logical IP Subnets and\n          interfaces.\n          The ipoaLisTable is indexed by ipoaLisSubnetAddr (IP\n          subnet address).  An entry in the ipoaLisTable should\n          exist for each ipAddrEntry that is associated with an\n          ATM related interface used for Classical IP and ARP\n          over ATM traffic.\n\n          Its ipAdEntAddr and ipAdEntNetMask when ANDed together\n          should equal the ipoaLisSubnetAddr of the corresponding\n          ipoaLisEntry.')
ipoaLisSubnetAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 2, 1, 1), IpAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipoaLisSubnetAddr.setDescription('The IP subnet address associated with this LIS.')
ipoaLisDefaultMtu = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 2, 1, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,65535)).clone(9180)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipoaLisDefaultMtu.setDescription('The default MTU used within this LIS.  Note that the\n          actual MTU used for a VC between two members of the\n          LIS may be negotiated during connection setup and may\n          be different than this value.  The ipoaVcNegotiatedMtu\n          object indicates the actual MTU in use for a\n          particular VC.')
ipoaLisDefaultEncapsType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 2, 1, 3), IpoaEncapsType().clone('llcSnap')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipoaLisDefaultEncapsType.setDescription('The default encapsulation to use on VCs created for\n          this LIS.  Note that the actual encapsulation type may\n          be negotiated during connection setup and may be\n          different than this value.  The\n          ipoaVcNegotiatedEncapsType object indicates the actual\n          encapsulation in use for a particular VC.')
ipoaLisInactivityTimer = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 2, 1, 4), Integer32().clone(1200)).setUnits('seconds').setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipoaLisInactivityTimer.setDescription('The time, in seconds, before a call established for an\n          ipNetToMediaEntry on a client will timeout due to no\n          traffic being passed on the VC.  A value of 0 implies\n          no time out.')
ipoaLisMinHoldingTime = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 2, 1, 5), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,65535)).clone(60)).setUnits('seconds').setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipoaLisMinHoldingTime.setDescription('The minimum amount of time, in seconds, that a call\n          will remain open.  If 0 then ipoaInactivityTimer will\n          completely determine when a call is terminated.')
ipoaLisQDepth = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 2, 1, 6), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1,65535)).clone(1)).setUnits('packets').setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipoaLisQDepth.setDescription('The maximum number of outstanding requests that are\n           allowed while waiting for ATMARP replies and\n           InATMARP replies for this LIS.')
ipoaLisMaxCalls = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 2, 1, 7), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1,65535)).clone(500)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipoaLisMaxCalls.setDescription('The maximum number of SVCs that can be established\n          simultaneously for this LIS.')
ipoaLisCacheEntryAge = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 2, 1, 8), Integer32().subtype(subtypeSpec=ValueRangeConstraint(60,1200)).clone(900)).setUnits('seconds').setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipoaLisCacheEntryAge.setDescription('The time, in seconds, before an ipNetToMediaEntry will\n          age out of the table.  Note that the default value will\n          be different for a client and a server.  An ATMARP\n          Server should use a default of 1200 and a client should\n          use 900.')
ipoaLisRetries = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 2, 1, 9), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,10)).clone(2)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipoaLisRetries.setDescription('The number of times the ATMARP request will be retried\n          when no response is received in the timeout interval\n          indicated by ipoaLisTimeout.')
ipoaLisTimeout = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 2, 1, 10), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1,60)).clone(10)).setUnits('seconds').setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipoaLisTimeout.setDescription('The time to wait, in seconds, before retransmission\n          of an ARP request.')
ipoaLisDefaultPeakCellRate = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 2, 1, 11), Integer32()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipoaLisDefaultPeakCellRate.setDescription("This object is the signalling parameter that\n           should be used when setting up all best effort\n           VCCs (Virtual Channel Connections).\n           This parameter applies to the forward and\n           backward direction on a per best effort VCC basis.\n           A value of zero implies that no configured default\n           exists and that local policy should be used to\n           determine the actual default to used during\n           call setup.  ATM Signaling Support for IP over ATM\n           (RFC 1755) recommends 1/10th of the ATM interface's\n           speed.")
ipoaLisActiveVcs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 2, 1, 12), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipoaLisActiveVcs.setDescription('Number of active SVCs for this LIS.')
ipoaLisRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 2, 1, 13), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipoaLisRowStatus.setDescription("This object allows entries to be created and deleted\n          in the ipoaLisTable.\n\n          When the ipoaLisRowStatus deleted (by setting this\n          object to destroy(6)), this has the side-effect of\n          removing all entries from the ipNetToMediaTable that\n          are associated with this LIS (in other words, it\n          flushes the entity's ATMARP cache).  It also removes\n          the ipoaVcTable entries that were associated with those\n          ipNetToMediaTable entries.  Destroying the row also\n          removes the corresponding entries in the\n          ipoaArpSrvrTable, ipoaArpClientTable,\n          ipoaLisIfMappingTable, and ipoaArpRemoteSrvrTable.\n\n          Entries in both the ipNetToMediaTable and the\n          ipoaVcTable that are associated with a\n          ipoaConfigPvcEntry are not affected by changes to\n          ipoaLisRowStatus.")
ipoaLisIfMappingTable = MibTable((1, 3, 6, 1, 2, 1, 10, 46, 1, 3), )
if mibBuilder.loadTexts: ipoaLisIfMappingTable.setDescription('There is one entry in this table for every combination\n           of ipoaLisEntry and IP over ATM interface.')
ipoaLisIfMappingEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 46, 1, 3, 1), ).setIndexNames((0, "IPOA-MIB", "ipoaLisSubnetAddr"), (0, "IPOA-MIB", "ipoaLisIfMappingIfIndex"))
if mibBuilder.loadTexts: ipoaLisIfMappingEntry.setDescription('Defines an entry in the ipoaLisIfMappingTable.')
ipoaLisIfMappingIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 3, 1, 1), InterfaceIndex())
if mibBuilder.loadTexts: ipoaLisIfMappingIfIndex.setDescription('The ipAdEntIfIndex object from an ipAddrEntry\n           is used as an index to this table when its\n           ipAdEntAddr is in the subnet implied by\n           ipoaLisSubnetAddr.')
ipoaLisIfMappingRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 3, 1, 2), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipoaLisIfMappingRowStatus.setDescription('This object allows entries to be created and deleted\n          in the ipoaLisIfMappingTable.')
ipoaArpClientTable = MibTable((1, 3, 6, 1, 2, 1, 10, 46, 1, 4), )
if mibBuilder.loadTexts: ipoaArpClientTable.setDescription('The ATMARP clients running on this system.')
ipoaArpClientEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 46, 1, 4, 1), ).setIndexNames((0, "IP-MIB", "ipAdEntAddr"))
if mibBuilder.loadTexts: ipoaArpClientEntry.setDescription("Information about a single ATMARP Client.  Clients\n          can be started and stopped by adding and removing\n          entries from this table.  An entry in the\n          ipoaArpClientTable has a corresponding entry in the\n          ipAddrTable.  Both are indexed by ipAdEntAddr.\n          The ifIndex and subnet mask of a client entry are the\n          ipAddrEntry's ipAdEntIfIndex and ipAdEntNetMask,\n          respectively.\n\n          Note that adding and removing entries from this table\n          may have the same effect on the corresponding\n          ipAddrTable entry.  Row creation of an entry in this\n          table requires that either the corresponding ipAddrTable\n          entry exists or that ipAdEntIfIndex and ipAdEntNetMask\n          be specified in the creation of an ipoaArpClientEntry\n          at a minimum in order to create the corresponding\n          ipAddrEntry.  Specification of ipAdEntBcastAddr and\n          ipAdEntReasmMaxSize to complete an ipAddrEntry is\n          implementation dependent.\n          Whether a corresponding ipAddrEntry is deleted during\n          the deletion of an ipoaArpClientEntry is considered\n          implementation dependent.")
ipoaArpClientAtmAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 4, 1, 1), IpoaAtmAddr()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipoaArpClientAtmAddr.setDescription('The ATM address of the client.')
ipoaArpClientSrvrInUse = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 4, 1, 2), IpoaAtmAddr().clone(hexValue="")).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipoaArpClientSrvrInUse.setDescription('The ATM address of the ATMARP Server,\n          ipoaArpRemoteSrvrAtmAddr, in use by this client.  A\n          zero length octet string implies that communication\n          with a Remote ATMARP Server is not in effect.')
ipoaArpClientInArpInReqs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 4, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipoaArpClientInArpInReqs.setDescription('The number of InATMARP requests received by this\n          client.')
ipoaArpClientInArpOutReqs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 4, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipoaArpClientInArpOutReqs.setDescription('The number of InATMARP requests sent by this client.')
ipoaArpClientInArpInReplies = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 4, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipoaArpClientInArpInReplies.setDescription('The number of InATMARP replies received by this\n          client.')
ipoaArpClientInArpOutReplies = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 4, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipoaArpClientInArpOutReplies.setDescription('Total number of InATMARP replies sent by this client.')
ipoaArpClientInArpInvalidInReqs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 4, 1, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipoaArpClientInArpInvalidInReqs.setDescription('The number of times that this client detected an\n          invalid InATMARP request.')
ipoaArpClientInArpInvalidOutReqs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 4, 1, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipoaArpClientInArpInvalidOutReqs.setDescription('The number of times that this client did not\n          receive an InATMARP reply.')
ipoaArpClientArpInReqs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 4, 1, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipoaArpClientArpInReqs.setDescription('Total number of ATMARP requests received by this\n          client.')
ipoaArpClientArpOutReqs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 4, 1, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipoaArpClientArpOutReqs.setDescription('Total number of ATMARP requests sent by this client.')
ipoaArpClientArpInReplies = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 4, 1, 11), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipoaArpClientArpInReplies.setDescription('Total number of ATMARP replies received by this\n          client.')
ipoaArpClientArpOutReplies = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 4, 1, 12), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipoaArpClientArpOutReplies.setDescription('Total number of ATMARP replies sent by this client.')
ipoaArpClientArpInNaks = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 4, 1, 13), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipoaArpClientArpInNaks.setDescription('Total number of negative ATMARP replies\n           received by this client.')
ipoaArpClientArpOutNaks = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 4, 1, 14), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipoaArpClientArpOutNaks.setDescription('Total number of negative ATMARP replies sent by\n          this client.\n\n          Classic IP and ARP over ATM does not require an\n          ATMARP client to transmit an ATMARP_NAK upon\n          receipt of an ATMARP request from another ATMARP\n          client.  However, implementation experience has\n          shown that this error condition is somewhat easy\n          to create inadvertently by configuring one ATMARP\n          client with an ipoaArpRemoteSrvrTable entry\n          containing an ipoaArpRemoteSrvrAtmAddr value which\n          is the ATM address of another ATMARP client-only\n          system.\n\n          If an ATMARP client supports the transmission of\n          ATMARP_NAKs, then it should increment\n          ipoaArpClientArpOutNaks each time it transmits\n          an ATMARP_NAK.  Otherwise, support of this\n          object is considered optional.')
ipoaArpClientArpUnknownOps = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 4, 1, 15), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipoaArpClientArpUnknownOps.setDescription('The number of times that this client received\n           an ATMARP message with an operation code for which\n           it is not coded to support.')
ipoaArpClientArpNoSrvrResps = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 4, 1, 16), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipoaArpClientArpNoSrvrResps.setDescription('The number of times this client failed to receive\n           a response from a ATMARP Server within the\n           ipoaLisTimeout value for ipoaLisRetries times.\n           This may imply that the client will re-elect a\n           new primary ATMARP Server for this LIS from the\n           ipoaArpRemoteSrvrTable.')
ipoaArpClientRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 4, 1, 17), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipoaArpClientRowStatus.setDescription('This object allows entries to be created and\n          deleted from the ipoaArpClientTable.')
ipoaArpSrvrTable = MibTable((1, 3, 6, 1, 2, 1, 10, 46, 1, 5), )
if mibBuilder.loadTexts: ipoaArpSrvrTable.setDescription('The ATMARP Servers running on this system.')
ipoaArpSrvrEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 46, 1, 5, 1), ).setIndexNames((0, "IP-MIB", "ipAdEntAddr"), (0, "IPOA-MIB", "ipoaArpSrvrAddr"))
if mibBuilder.loadTexts: ipoaArpSrvrEntry.setDescription("Information about an ATMARP Server within a LIS.  An\n          entry in this table has two indexes: first ipAdEntAddr,\n          which is the IP address that this system uses as a\n          member of the LIS, and then ipoaArpSrvrAddr, which is\n          the ATM address of the ATMARP Server.\n\n          Entries may be created by a management application\n          using the ipoaArpSrvrRowStatus object.  Entries in this\n          table may also be created by the system and not by a\n          management application, for example via ILMI.\n\n          Entries in this table may be deleted by setting the\n          ipoaArpSrvrRowStatus object to 'destroy(6)'.  This\n          includes entries that were added by the system and not\n          by a management application.")
ipoaArpSrvrAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 5, 1, 1), IpoaAtmAddr())
if mibBuilder.loadTexts: ipoaArpSrvrAddr.setDescription('The ATM address of the ATMARP Server.')
ipoaArpSrvrLis = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 5, 1, 2), IpAddress()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipoaArpSrvrLis.setDescription('The subnet address that identifies the LIS with\n          which this server is associated.')
ipoaArpSrvrInArpInReqs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 5, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipoaArpSrvrInArpInReqs.setDescription('The number of InATMARP requests received by this\n          ATMARP Server.')
ipoaArpSrvrInArpOutReqs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 5, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipoaArpSrvrInArpOutReqs.setDescription('The number of InATMARP requests sent by this ATMARP\n          Server.')
ipoaArpSrvrInArpInReplies = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 5, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipoaArpSrvrInArpInReplies.setDescription('The number of InATMARP replies received by this\n          ATMARP Server.')
ipoaArpSrvrInArpOutReplies = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 5, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipoaArpSrvrInArpOutReplies.setDescription('The number of InATMARP replies sent by this ATMARP\n          Server.')
ipoaArpSrvrInArpInvalidInReqs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 5, 1, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipoaArpSrvrInArpInvalidInReqs.setDescription('The number of invalid InATMARP requests received by\n           this ATMARP Server.')
ipoaArpSrvrInArpInvalidOutReqs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 5, 1, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipoaArpSrvrInArpInvalidOutReqs.setDescription('The number of times that this server did not receive\n           an InATMARP reply.')
ipoaArpSrvrArpInReqs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 5, 1, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipoaArpSrvrArpInReqs.setDescription('Total number of ATMARP requests received by this\n          ATMARP Server.')
ipoaArpSrvrArpOutReplies = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 5, 1, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipoaArpSrvrArpOutReplies.setDescription('Total number of ATMARP replies sent by this ATMARP\n          Server.')
ipoaArpSrvrArpOutNaks = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 5, 1, 11), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipoaArpSrvrArpOutNaks.setDescription('Total number of negative ATMARP replies sent by this\n           ATMARP Server.')
ipoaArpSrvrArpDupIpAddrs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 5, 1, 12), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipoaArpSrvrArpDupIpAddrs.setDescription('The number of times that a duplicate IP address was\n           detected by this ATMARP Server.')
ipoaArpSrvrArpUnknownOps = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 5, 1, 13), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipoaArpSrvrArpUnknownOps.setDescription('The number of times that this ATMARP Server received\n           an ATMARP message with an operation code for which it\n           is not coded to support.')
ipoaArpSrvrRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 5, 1, 14), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipoaArpSrvrRowStatus.setDescription('This object allows entries to be created and deleted\n          from the ipoaArpSrvrTable.')
ipoaArpRemoteSrvrTable = MibTable((1, 3, 6, 1, 2, 1, 10, 46, 1, 6), )
if mibBuilder.loadTexts: ipoaArpRemoteSrvrTable.setDescription('A table of non-local ATMARP Servers associated with a\n          LIS.  An entry in this table has three indexes: first\n          the ipoaLisSubnetAddr of the LIS for which the\n          corresponding ATMARP Server provides ATMARP services,\n          then the ipoaArpRemoteSrvrAtmAddr, which is the ATM\n          address of the remote ATMARP Server, and finally the\n          ifIndex of the interface on which the VC to the ATMARP\n          Remote Server will be opened.  An ifIndex value of 0\n          should be used when a single VC is to be shared for\n          ATMARP purposes by multiple interfaces.')
ipoaArpRemoteSrvrEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 46, 1, 6, 1), ).setIndexNames((0, "IPOA-MIB", "ipoaLisSubnetAddr"), (0, "IPOA-MIB", "ipoaArpRemoteSrvrAtmAddr"), (0, "IPOA-MIB", "ipoaArpRemoteSrvrIfIndex"))
if mibBuilder.loadTexts: ipoaArpRemoteSrvrEntry.setDescription('Information about one non-local ATMARP Server.')
ipoaArpRemoteSrvrAtmAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 6, 1, 1), IpoaAtmAddr())
if mibBuilder.loadTexts: ipoaArpRemoteSrvrAtmAddr.setDescription('The ATM address of the remote ATMARP Server.')
ipoaArpRemoteSrvrRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 6, 1, 2), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipoaArpRemoteSrvrRowStatus.setDescription('This object allows entries to be created and deleted\n          from the ipoaArpRemoteSrvrTable.\n\n          Deleting an ipoaArpRemoteSrvrEntry (by setting this\n          object to destroy(6)) may affect ipoaArpClientTable\n          entries.  The object ipoaArpClientSrvrInUse in an\n          ipoaArpClientSrvrEntry may contain the ATM address\n          of an ATMARP Remote Server whose entry in the\n          ipoaArpRemoteSrvrTable is being removed.  In this\n          case, any corresponding ipoaArpClientSrvrInUse\n          objects should be at a minimum invalidated by\n          setting their values to that of a zero length\n          OCTET STRING.\n\n          The value of ipoaArpRemoteSrvrOperStatus should be\n          consistent with that of ipoaArpRemoteSrvrRowStatus.\n          For example, successfully setting the value of\n          this object to notInService(2) after its being in\n          the up(1) state should result in\n          ipoaArpRemoteSrvrOperStatus being set to down(2)\n          if currently up(1).')
ipoaArpRemoteSrvrIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 6, 1, 3), InterfaceIndexOrZero())
if mibBuilder.loadTexts: ipoaArpRemoteSrvrIfIndex.setDescription('The ifIndex of the interface that the VC to the\n           Remote ATMARP Server is associated with.')
ipoaArpRemoteSrvrIpAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 6, 1, 4), IpAddress().clone(hexValue="00000000")).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipoaArpRemoteSrvrIpAddr.setDescription("The IP Address of the Remote ATMARP Server.  A\n          value of 0.0.0.0 implies that this address isn't\n          known.")
ipoaArpRemoteSrvrAdminStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 6, 1, 5), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2,))).clone(namedValues=NamedValues(("up", 1), ("down", 2),)).clone('down')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipoaArpRemoteSrvrAdminStatus.setDescription('The desired state for use of the ATMARP Server\n           represented by an entry in this table.\n           ipoaArpRemoteSrvrAdminStatus values:\n\n           up(1)   - Attempt to activate use of the\n                     ATMARP Server represented by this\n                     entry in the ipoaArpRemoteSrvrTable.\n           down(2) - Deactivate use of this ATMARP\n                     Server.\n\n           When a managed system creates an entry in this\n           table ipoaArpRemoteSrvrAdminStatus and\n           ipoaArpRemoteSrvrOperStatus are initialized as\n           down(2) by default.')
ipoaArpRemoteSrvrOperStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 6, 1, 6), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2,))).clone(namedValues=NamedValues(("up", 1), ("down", 2),)).clone('down')).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipoaArpRemoteSrvrOperStatus.setDescription('The current operational state for use of a Remote\n           ATMARP Server.  An up(1) entry has a VC\n           established to the respective Remote ATMARP\n           Server:\n\n           up(1)  - A VC exists to Remote ATMARP Server\n                    whose IP Address is stored in\n                    ipoaArpRemoteSrvrIpAddr.  This VC can\n                    be determined by searching the\n                    ipoaVcTable using\n                    ipoaArpRemoteSrvrIfIndex (if not 0,\n                    otherwise ignore ipNetToMediaIfIndex\n                    index) and ipoaArpRemoteSrvrIpAddr.\n                    An ipoaArpClientEntry should exist\n                    with its ipoaArpClientSrvrInUse\n                    object having the same value as\n                    ipoaArpRemoteSrvrAtmAddr.\n\n          down(2) - Entry exists without an active VC to\n                    the Remote ATMARP Server.\n\n          Transition from up(1) to down(2)\n          status may affect ipoaArpClientTable entries.\n          The object ipoaArpClientSrvrInUse in an\n          ipoaArpClientSrvrEntry may contain the ATM address\n          of an ATMARP Remote Server whose entry in the\n          ipoaArpRemoteSrvrTable is being deactivated.  In\n          this case, any corresponding ipoaArpClientSrvrInUse\n          objects should be at a minimum invalidated by\n          setting their values to that of a zero length\n          OCTET STRING.\n\n          If ipoaArpRemoteSrvrAdminStatus is down(2) then\n          ipoaArpRemoteSrvrOperStatus should be down(2).\n          If ipoaArpRemoteSrvrAdminStatus is changed to\n          up(1) then ipoaArpRemoteSrvrOperStatus should\n          change to up(1) if the Remote ATMARP Server\n          entry can be activated.')
ipoaVcTable = MibTable((1, 3, 6, 1, 2, 1, 10, 46, 1, 7), )
if mibBuilder.loadTexts: ipoaVcTable.setDescription("A system that supports IP over ATM is an IP system and\n          therefore MUST support all of the appropriate tables in\n          the SNMPv2-MIB (RFC 1907), the IF-MIB (RFC 2233),\n          the IP-MIB (RFC 2011), the TCP-MIB (RFC 2012), and\n          the UDP-MIB (RFC 2013).  This includes the\n          ipNetToMediaTable (the ARP cache) that is defined\n          within the IP-MIB (RFC 2011).  The ipoaVcTable\n          keeps a set of VCs for each entry in the ARP cache\n          that was put there by an IP over ATM system acting\n          as either a host or server.  The ipoaVcTable doesn't\n          augment the ipNetToMediaTable (ARP Cache) since the\n          the correspondence between tables is not necessarily\n          one-to-one.\n\n          An ipNetToMediaPhysAddress object should contain the\n          content as defined by the IpoaAtmAddr textual\n          convention when used to hold an IPOA-MIB ATM Address.")
ipoaVcEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 46, 1, 7, 1), ).setIndexNames((0, "IP-MIB", "ipNetToMediaIfIndex"), (0, "IP-MIB", "ipNetToMediaNetAddress"), (0, "IPOA-MIB", "ipoaVcVpi"), (0, "IPOA-MIB", "ipoaVcVci"))
if mibBuilder.loadTexts: ipoaVcEntry.setDescription('A VC (permanent or switched) that this host or server\n          has opened with another member of a LIS.  Additional\n          information can be determined about the VC from the\n          ATM-MIB.\n\n          Entries in this table cannot be created by management\n          applications.\n\n          In an SVC environment, an entry is automatically added\n          by the system as the result of ATMARP processing.\n\n          In a PVC environment, an entry is automatically added\n          to this table when an entry is created in the\n          ipoaConfigPvcTable and the IP Address at the remote\n          end of the PVC is discovered using InATMARP.  An\n          entry also is added to the ipNetToMediaTable.')
ipoaVcVpi = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 7, 1, 1), IpoaVpiInteger())
if mibBuilder.loadTexts: ipoaVcVpi.setDescription('The VPI value for the Virtual Circuit.')
ipoaVcVci = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 7, 1, 2), IpoaVciInteger())
if mibBuilder.loadTexts: ipoaVcVci.setDescription('The VCI value for the Virtual Circuit.')
ipoaVcType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 7, 1, 3), IpoaAtmConnKind()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipoaVcType.setDescription('The type of the Virtual Circuit.')
ipoaVcNegotiatedEncapsType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 7, 1, 4), IpoaEncapsType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipoaVcNegotiatedEncapsType.setDescription('The encapsulation type used when communicating over\n          this circuit.')
ipoaVcNegotiatedMtu = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 7, 1, 5), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipoaVcNegotiatedMtu.setDescription('The MTU used when communicating over this circuit.')
ipoaConfigPvcTable = MibTable((1, 3, 6, 1, 2, 1, 10, 46, 1, 8), )
if mibBuilder.loadTexts: ipoaConfigPvcTable.setDescription('This table MUST be supported when PVCs are intended to\n          be supported in order to enable the setup of PVCs for\n          use by IP.')
ipoaConfigPvcEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 46, 1, 8, 1), ).setIndexNames((0, "IPOA-MIB", "ipoaConfigPvcIfIndex"), (0, "IPOA-MIB", "ipoaConfigPvcVpi"), (0, "IPOA-MIB", "ipoaConfigPvcVci"))
if mibBuilder.loadTexts: ipoaConfigPvcEntry.setDescription('Defines a single PVC that exists at this host for\n          use by IP.')
ipoaConfigPvcIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 8, 1, 1), InterfaceIndex())
if mibBuilder.loadTexts: ipoaConfigPvcIfIndex.setDescription('The ifIndex of the ATM Interface that this PVC\n           is associated with.')
ipoaConfigPvcVpi = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 8, 1, 2), IpoaVpiInteger())
if mibBuilder.loadTexts: ipoaConfigPvcVpi.setDescription('The VPI value for the Virtual Circuit.')
ipoaConfigPvcVci = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 8, 1, 3), IpoaVciInteger())
if mibBuilder.loadTexts: ipoaConfigPvcVci.setDescription('The VCI value for the Virtual Circuit.')
ipoaConfigPvcDefaultMtu = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 8, 1, 4), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,65535)).clone(9180)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipoaConfigPvcDefaultMtu.setDescription('Classical IP and ARP over ATM allows use of\n         other MTU values for PVCs but considers how a\n         value other than 9180 could be selected to be out\n         of scope.  ipoaConfigPvcDefaultMtu can be used to\n         configure the MTU to be used for the PVC.\n         Both ends MUST have the same value configured.')
ipoaConfigPvcRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 46, 1, 8, 1, 5), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipoaConfigPvcRowStatus.setDescription('This object allows rows to be created and deleted in\n         the ipoaConfigPvcTable.  Creation of an entry in this\n         table should eventually result in the creation of an\n         ipNetToMediaEntry and a corresponding ipoaVcEntry\n         after InATMARP has determined the destination address\n         of the remote system that the PVC is connected to.\n         Setting this object to destroy(6) should remove the\n         corresponding ipNetToMediaTable and ipoaVcTable\n         entries.')
ipoaTrapPrefix = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 46, 2, 0))
ipoaMtuExceeded = NotificationType((1, 3, 6, 1, 2, 1, 10, 46, 2, 0, 1)).setObjects(*(("IPOA-MIB", "ipoaVcNegotiatedMtu"),))
if mibBuilder.loadTexts: ipoaMtuExceeded.setDescription('A frame was received that exceeds the negotiated\n          MTU size.  The VPI and VCI of the VC for which this\n          condition was detected can be determined from the\n          index values for ipoaVcNegotiatedMtu.  In addition,\n          the ifIndex and IP Address can be determined as\n          well (refer to the ipoaVcTable).')
ipoaDuplicateIpAddress = NotificationType((1, 3, 6, 1, 2, 1, 10, 46, 2, 0, 2)).setObjects(*(("IPOA-MIB", "ipNetToMediaIfIndex"), ("IPOA-MIB", "ipNetToMediaNetAddress"), ("IPOA-MIB", "ipNetToMediaPhysAddress"), ("IPOA-MIB", "ipNetToMediaPhysAddress"),))
if mibBuilder.loadTexts: ipoaDuplicateIpAddress.setDescription('The ATMARP Server has detected more than one ATM end\n          point attempting to associate the same IP address with\n          different ATM addresses.')
ipoaLisCreate = NotificationType((1, 3, 6, 1, 2, 1, 10, 46, 2, 0, 3)).setObjects(*(("IPOA-MIB", "ipoaLisSubnetAddr"),))
if mibBuilder.loadTexts: ipoaLisCreate.setDescription('Generation of this trap occurs when an ipoaLisEntry is\n          created while the ipoaLisTrapEnable.0 object has the\n          value enabled(1).')
ipoaLisDelete = NotificationType((1, 3, 6, 1, 2, 1, 10, 46, 2, 0, 4)).setObjects(*(("IPOA-MIB", "ipoaLisSubnetAddr"),))
if mibBuilder.loadTexts: ipoaLisDelete.setDescription('Generation of this trap occurs when an ipoaLisEntry is\n          deleted while the ipoaLisTrapEnable.0 object has the\n          value enabled(1).')
ipoaGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 46, 3, 1))
ipoaCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 46, 3, 2))
ipoaCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 10, 46, 3, 2, 1)).setObjects(*(("IPOA-MIB", "ipoaGeneralGroup"), ("IPOA-MIB", "ipoaBasicNotificationsGroup"), ("IPOA-MIB", "ipoaClientGroup"), ("IPOA-MIB", "ipoaSrvrGroup"), ("IPOA-MIB", "ipoaSrvrNotificationsGroup"), ("IPOA-MIB", "ipoaLisNotificationsGroup"), ("IPOA-MIB", "ipoaLisTableGroup"),))
if mibBuilder.loadTexts: ipoaCompliance.setDescription('The compliance statement for agents that support the\n          IPOA-MIB.')
ipoaGeneralGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 46, 3, 1, 1)).setObjects(*(("IPOA-MIB", "ipoaVcType"), ("IPOA-MIB", "ipoaVcNegotiatedEncapsType"), ("IPOA-MIB", "ipoaVcNegotiatedMtu"), ("IPOA-MIB", "ipoaConfigPvcDefaultMtu"), ("IPOA-MIB", "ipoaConfigPvcRowStatus"),))
if mibBuilder.loadTexts: ipoaGeneralGroup.setDescription('This group is mandatory for all IP over ATM entities.')
ipoaClientGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 46, 3, 1, 2)).setObjects(*(("IPOA-MIB", "ipoaArpClientAtmAddr"), ("IPOA-MIB", "ipoaArpClientSrvrInUse"), ("IPOA-MIB", "ipoaArpClientInArpInReqs"), ("IPOA-MIB", "ipoaArpClientInArpOutReqs"), ("IPOA-MIB", "ipoaArpClientInArpInReplies"), ("IPOA-MIB", "ipoaArpClientInArpOutReplies"), ("IPOA-MIB", "ipoaArpClientInArpInvalidInReqs"), ("IPOA-MIB", "ipoaArpClientInArpInvalidOutReqs"), ("IPOA-MIB", "ipoaArpClientArpInReqs"), ("IPOA-MIB", "ipoaArpClientArpOutReqs"), ("IPOA-MIB", "ipoaArpClientArpInReplies"), ("IPOA-MIB", "ipoaArpClientArpOutReplies"), ("IPOA-MIB", "ipoaArpClientArpInNaks"), ("IPOA-MIB", "ipoaArpClientArpOutNaks"), ("IPOA-MIB", "ipoaArpClientArpUnknownOps"), ("IPOA-MIB", "ipoaArpClientArpNoSrvrResps"), ("IPOA-MIB", "ipoaArpClientRowStatus"),))
if mibBuilder.loadTexts: ipoaClientGroup.setDescription('This group is mandatory for all hosts where an IP\n          over ATM client is present.')
ipoaSrvrGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 46, 3, 1, 3)).setObjects(*(("IPOA-MIB", "ipoaArpSrvrLis"), ("IPOA-MIB", "ipoaArpSrvrInArpInReqs"), ("IPOA-MIB", "ipoaArpSrvrInArpOutReqs"), ("IPOA-MIB", "ipoaArpSrvrInArpInReplies"), ("IPOA-MIB", "ipoaArpSrvrInArpOutReplies"), ("IPOA-MIB", "ipoaArpSrvrInArpInvalidInReqs"), ("IPOA-MIB", "ipoaArpSrvrInArpInvalidOutReqs"), ("IPOA-MIB", "ipoaArpSrvrArpInReqs"), ("IPOA-MIB", "ipoaArpSrvrArpOutReplies"), ("IPOA-MIB", "ipoaArpSrvrArpOutNaks"), ("IPOA-MIB", "ipoaArpSrvrArpDupIpAddrs"), ("IPOA-MIB", "ipoaArpSrvrArpUnknownOps"), ("IPOA-MIB", "ipoaArpSrvrRowStatus"),))
if mibBuilder.loadTexts: ipoaSrvrGroup.setDescription('This group is mandatory for all hosts where ATMARP\n          Servers are present.')
ipoaBasicNotificationsGroup = NotificationGroup((1, 3, 6, 1, 2, 1, 10, 46, 3, 1, 4)).setObjects(*(("IPOA-MIB", "ipoaMtuExceeded"),))
if mibBuilder.loadTexts: ipoaBasicNotificationsGroup.setDescription('The notification which an IP over ATM entity\n          is required to implement.')
ipoaSrvrNotificationsGroup = NotificationGroup((1, 3, 6, 1, 2, 1, 10, 46, 3, 1, 5)).setObjects(*(("IPOA-MIB", "ipoaDuplicateIpAddress"),))
if mibBuilder.loadTexts: ipoaSrvrNotificationsGroup.setDescription('The notification which an IP over ATM ATMARP\n              Server is required to implement.')
ipoaLisNotificationsGroup = NotificationGroup((1, 3, 6, 1, 2, 1, 10, 46, 3, 1, 6)).setObjects(*(("IPOA-MIB", "ipoaLisCreate"), ("IPOA-MIB", "ipoaLisDelete"),))
if mibBuilder.loadTexts: ipoaLisNotificationsGroup.setDescription('The LIS-related notifications which are required\n              to be implemented by an IP over ATM ATMARP server,\n              as well as by any IP over ATM client which allows\n              ipoaLisTrapEnable to be set to enabled(1).')
ipoaLisTableGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 46, 3, 1, 7)).setObjects(*(("IPOA-MIB", "ipoaLisTrapEnable"), ("IPOA-MIB", "ipoaLisSubnetAddr"), ("IPOA-MIB", "ipoaLisDefaultMtu"), ("IPOA-MIB", "ipoaLisDefaultEncapsType"), ("IPOA-MIB", "ipoaLisInactivityTimer"), ("IPOA-MIB", "ipoaLisMinHoldingTime"), ("IPOA-MIB", "ipoaLisQDepth"), ("IPOA-MIB", "ipoaLisMaxCalls"), ("IPOA-MIB", "ipoaLisCacheEntryAge"), ("IPOA-MIB", "ipoaLisRetries"), ("IPOA-MIB", "ipoaLisTimeout"), ("IPOA-MIB", "ipoaLisDefaultPeakCellRate"), ("IPOA-MIB", "ipoaLisActiveVcs"), ("IPOA-MIB", "ipoaLisRowStatus"), ("IPOA-MIB", "ipoaLisIfMappingRowStatus"), ("IPOA-MIB", "ipoaArpRemoteSrvrRowStatus"), ("IPOA-MIB", "ipoaArpRemoteSrvrIpAddr"), ("IPOA-MIB", "ipoaArpRemoteSrvrAdminStatus"), ("IPOA-MIB", "ipoaArpRemoteSrvrOperStatus"),))
if mibBuilder.loadTexts: ipoaLisTableGroup.setDescription('This group is mandatory for all entities which\n          support IP over ATM SVCs.  Support of objects in\n          this group by IP over ATM clients which only\n          support IP over ATM PVCs is optional.')
mibBuilder.exportSymbols("IPOA-MIB", ipoaLisIfMappingTable=ipoaLisIfMappingTable, IpoaVpiInteger=IpoaVpiInteger, ipoaLisCacheEntryAge=ipoaLisCacheEntryAge, ipoaArpClientInArpInvalidOutReqs=ipoaArpClientInArpInvalidOutReqs, ipoaLisCreate=ipoaLisCreate, ipoaArpClientInArpInReqs=ipoaArpClientInArpInReqs, ipoaArpClientInArpOutReplies=ipoaArpClientInArpOutReplies, ipoaLisTableGroup=ipoaLisTableGroup, ipoaArpRemoteSrvrOperStatus=ipoaArpRemoteSrvrOperStatus, ipoaArpSrvrArpUnknownOps=ipoaArpSrvrArpUnknownOps, ipoaArpClientArpOutNaks=ipoaArpClientArpOutNaks, IpoaVciInteger=IpoaVciInteger, ipoaArpRemoteSrvrTable=ipoaArpRemoteSrvrTable, ipoaConfigPvcDefaultMtu=ipoaConfigPvcDefaultMtu, ipoaSrvrNotificationsGroup=ipoaSrvrNotificationsGroup, ipoaArpSrvrArpOutReplies=ipoaArpSrvrArpOutReplies, ipoaArpSrvrInArpInvalidInReqs=ipoaArpSrvrInArpInvalidInReqs, ipoaArpSrvrInArpInReqs=ipoaArpSrvrInArpInReqs, ipoaArpRemoteSrvrIfIndex=ipoaArpRemoteSrvrIfIndex, ipoaArpSrvrTable=ipoaArpSrvrTable, ipoaArpClientArpOutReqs=ipoaArpClientArpOutReqs, ipoaArpClientArpInReplies=ipoaArpClientArpInReplies, ipoaLisIfMappingEntry=ipoaLisIfMappingEntry, ipoaCompliances=ipoaCompliances, ipoaArpClientArpNoSrvrResps=ipoaArpClientArpNoSrvrResps, ipoaArpClientArpUnknownOps=ipoaArpClientArpUnknownOps, ipoaArpClientArpInNaks=ipoaArpClientArpInNaks, ipoaLisDefaultEncapsType=ipoaLisDefaultEncapsType, ipoaLisDelete=ipoaLisDelete, ipoaConfigPvcVci=ipoaConfigPvcVci, ipoaLisDefaultPeakCellRate=ipoaLisDefaultPeakCellRate, ipoaArpClientRowStatus=ipoaArpClientRowStatus, ipoaArpClientArpInReqs=ipoaArpClientArpInReqs, ipoaGroups=ipoaGroups, ipoaGeneralGroup=ipoaGeneralGroup, ipoaArpSrvrArpInReqs=ipoaArpSrvrArpInReqs, IpoaAtmAddr=IpoaAtmAddr, IpoaAtmConnKind=IpoaAtmConnKind, ipoaArpSrvrInArpInReplies=ipoaArpSrvrInArpInReplies, ipoaArpClientEntry=ipoaArpClientEntry, ipoaVcNegotiatedEncapsType=ipoaVcNegotiatedEncapsType, ipoaClientGroup=ipoaClientGroup, ipoaMtuExceeded=ipoaMtuExceeded, ipoaArpClientInArpOutReqs=ipoaArpClientInArpOutReqs, ipoaArpSrvrAddr=ipoaArpSrvrAddr, ipoaArpRemoteSrvrAdminStatus=ipoaArpRemoteSrvrAdminStatus, ipoaArpClientAtmAddr=ipoaArpClientAtmAddr, ipoaVcVci=ipoaVcVci, ipoaNotifications=ipoaNotifications, ipoaArpSrvrArpDupIpAddrs=ipoaArpSrvrArpDupIpAddrs, ipoaConfigPvcIfIndex=ipoaConfigPvcIfIndex, ipoaArpClientArpOutReplies=ipoaArpClientArpOutReplies, ipoaLisTrapEnable=ipoaLisTrapEnable, ipoaConfigPvcVpi=ipoaConfigPvcVpi, PYSNMP_MODULE_ID=ipoaMIB, ipoaLisRowStatus=ipoaLisRowStatus, ipoaArpSrvrLis=ipoaArpSrvrLis, IpoaEncapsType=IpoaEncapsType, ipoaLisQDepth=ipoaLisQDepth, ipoaArpSrvrInArpInvalidOutReqs=ipoaArpSrvrInArpInvalidOutReqs, ipoaSrvrGroup=ipoaSrvrGroup, ipoaLisMaxCalls=ipoaLisMaxCalls, ipoaVcVpi=ipoaVcVpi, ipoaTrapPrefix=ipoaTrapPrefix, ipoaArpClientInArpInvalidInReqs=ipoaArpClientInArpInvalidInReqs, ipoaConfigPvcEntry=ipoaConfigPvcEntry, ipoaLisRetries=ipoaLisRetries, ipoaLisDefaultMtu=ipoaLisDefaultMtu, ipoaArpSrvrEntry=ipoaArpSrvrEntry, ipoaLisIfMappingRowStatus=ipoaLisIfMappingRowStatus, ipoaMIB=ipoaMIB, ipoaConfigPvcTable=ipoaConfigPvcTable, ipoaLisMinHoldingTime=ipoaLisMinHoldingTime, ipoaArpSrvrInArpOutReplies=ipoaArpSrvrInArpOutReplies, ipoaCompliance=ipoaCompliance, ipoaArpSrvrRowStatus=ipoaArpSrvrRowStatus, ipoaArpSrvrInArpOutReqs=ipoaArpSrvrInArpOutReqs, ipoaVcTable=ipoaVcTable, ipoaArpRemoteSrvrIpAddr=ipoaArpRemoteSrvrIpAddr, ipoaLisInactivityTimer=ipoaLisInactivityTimer, ipoaArpRemoteSrvrEntry=ipoaArpRemoteSrvrEntry, ipoaArpClientInArpInReplies=ipoaArpClientInArpInReplies, ipoaArpRemoteSrvrRowStatus=ipoaArpRemoteSrvrRowStatus, ipoaObjects=ipoaObjects, ipoaArpSrvrArpOutNaks=ipoaArpSrvrArpOutNaks, ipoaLisSubnetAddr=ipoaLisSubnetAddr, ipoaConfigPvcRowStatus=ipoaConfigPvcRowStatus, ipoaBasicNotificationsGroup=ipoaBasicNotificationsGroup, ipoaVcEntry=ipoaVcEntry, ipoaVcType=ipoaVcType, ipoaLisIfMappingIfIndex=ipoaLisIfMappingIfIndex, ipoaDuplicateIpAddress=ipoaDuplicateIpAddress, ipoaLisActiveVcs=ipoaLisActiveVcs, ipoaLisTable=ipoaLisTable, ipoaLisTimeout=ipoaLisTimeout, ipoaVcNegotiatedMtu=ipoaVcNegotiatedMtu, ipoaArpClientTable=ipoaArpClientTable, ipoaLisEntry=ipoaLisEntry, ipoaArpRemoteSrvrAtmAddr=ipoaArpRemoteSrvrAtmAddr, ipoaArpClientSrvrInUse=ipoaArpClientSrvrInUse, ipoaLisNotificationsGroup=ipoaLisNotificationsGroup, ipoaConformance=ipoaConformance)
