# pylint: disable=too-many-lines,too-many-statements
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from io import IOBase
import sys
from typing import Any, AsyncIterable, Callable, Dict, IO, Optional, Type, TypeVar, Union, cast, overload

from azure.core.async_paging import AsyncItemPaged, AsyncList
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import AsyncHttpResponse
from azure.core.polling import AsyncLROPoller, AsyncNoPolling, AsyncPollingMethod
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict
from azure.mgmt.core.exceptions import ARMErrorFormat
from azure.mgmt.core.polling.async_arm_polling import AsyncARMPolling

from ... import models as _models
from ..._vendor import _convert_request
from ...operations._operations import (
    build_application_gateways_backend_health_request,
    build_application_gateways_create_or_update_request,
    build_application_gateways_delete_request,
    build_application_gateways_get_request,
    build_application_gateways_get_ssl_predefined_policy_request,
    build_application_gateways_list_all_request,
    build_application_gateways_list_available_ssl_options_request,
    build_application_gateways_list_available_ssl_predefined_policies_request,
    build_application_gateways_list_available_waf_rule_sets_request,
    build_application_gateways_list_request,
    build_application_gateways_start_request,
    build_application_gateways_stop_request,
    build_application_gateways_update_tags_request,
    build_application_security_groups_create_or_update_request,
    build_application_security_groups_delete_request,
    build_application_security_groups_get_request,
    build_application_security_groups_list_all_request,
    build_application_security_groups_list_request,
    build_available_endpoint_services_list_request,
    build_bgp_service_communities_list_request,
    build_connection_monitors_create_or_update_request,
    build_connection_monitors_delete_request,
    build_connection_monitors_get_request,
    build_connection_monitors_list_request,
    build_connection_monitors_query_request,
    build_connection_monitors_start_request,
    build_connection_monitors_stop_request,
    build_default_security_rules_get_request,
    build_default_security_rules_list_request,
    build_express_route_circuit_authorizations_create_or_update_request,
    build_express_route_circuit_authorizations_delete_request,
    build_express_route_circuit_authorizations_get_request,
    build_express_route_circuit_authorizations_list_request,
    build_express_route_circuit_peerings_create_or_update_request,
    build_express_route_circuit_peerings_delete_request,
    build_express_route_circuit_peerings_get_request,
    build_express_route_circuit_peerings_list_request,
    build_express_route_circuits_create_or_update_request,
    build_express_route_circuits_delete_request,
    build_express_route_circuits_get_peering_stats_request,
    build_express_route_circuits_get_request,
    build_express_route_circuits_get_stats_request,
    build_express_route_circuits_list_all_request,
    build_express_route_circuits_list_arp_table_request,
    build_express_route_circuits_list_request,
    build_express_route_circuits_list_routes_table_request,
    build_express_route_circuits_list_routes_table_summary_request,
    build_express_route_circuits_update_tags_request,
    build_express_route_service_providers_list_request,
    build_inbound_nat_rules_create_or_update_request,
    build_inbound_nat_rules_delete_request,
    build_inbound_nat_rules_get_request,
    build_inbound_nat_rules_list_request,
    build_load_balancer_backend_address_pools_get_request,
    build_load_balancer_backend_address_pools_list_request,
    build_load_balancer_frontend_ip_configurations_get_request,
    build_load_balancer_frontend_ip_configurations_list_request,
    build_load_balancer_load_balancing_rules_get_request,
    build_load_balancer_load_balancing_rules_list_request,
    build_load_balancer_network_interfaces_list_request,
    build_load_balancer_probes_get_request,
    build_load_balancer_probes_list_request,
    build_load_balancers_create_or_update_request,
    build_load_balancers_delete_request,
    build_load_balancers_get_request,
    build_load_balancers_list_all_request,
    build_load_balancers_list_request,
    build_load_balancers_update_tags_request,
    build_local_network_gateways_create_or_update_request,
    build_local_network_gateways_delete_request,
    build_local_network_gateways_get_request,
    build_local_network_gateways_list_request,
    build_local_network_gateways_update_tags_request,
    build_network_interface_ip_configurations_get_request,
    build_network_interface_ip_configurations_list_request,
    build_network_interface_load_balancers_list_request,
    build_network_interfaces_create_or_update_request,
    build_network_interfaces_delete_request,
    build_network_interfaces_get_effective_route_table_request,
    build_network_interfaces_get_request,
    build_network_interfaces_get_virtual_machine_scale_set_ip_configuration_request,
    build_network_interfaces_get_virtual_machine_scale_set_network_interface_request,
    build_network_interfaces_list_all_request,
    build_network_interfaces_list_effective_network_security_groups_request,
    build_network_interfaces_list_request,
    build_network_interfaces_list_virtual_machine_scale_set_ip_configurations_request,
    build_network_interfaces_list_virtual_machine_scale_set_network_interfaces_request,
    build_network_interfaces_list_virtual_machine_scale_set_vm_network_interfaces_request,
    build_network_interfaces_update_tags_request,
    build_network_management_check_dns_name_availability_request,
    build_network_security_groups_create_or_update_request,
    build_network_security_groups_delete_request,
    build_network_security_groups_get_request,
    build_network_security_groups_list_all_request,
    build_network_security_groups_list_request,
    build_network_security_groups_update_tags_request,
    build_network_watchers_check_connectivity_request,
    build_network_watchers_create_or_update_request,
    build_network_watchers_delete_request,
    build_network_watchers_get_azure_reachability_report_request,
    build_network_watchers_get_flow_log_status_request,
    build_network_watchers_get_next_hop_request,
    build_network_watchers_get_request,
    build_network_watchers_get_topology_request,
    build_network_watchers_get_troubleshooting_request,
    build_network_watchers_get_troubleshooting_result_request,
    build_network_watchers_get_vm_security_rules_request,
    build_network_watchers_list_all_request,
    build_network_watchers_list_available_providers_request,
    build_network_watchers_list_request,
    build_network_watchers_set_flow_log_configuration_request,
    build_network_watchers_update_tags_request,
    build_network_watchers_verify_ip_flow_request,
    build_operations_list_request,
    build_packet_captures_create_request,
    build_packet_captures_delete_request,
    build_packet_captures_get_request,
    build_packet_captures_get_status_request,
    build_packet_captures_list_request,
    build_packet_captures_stop_request,
    build_public_ip_addresses_create_or_update_request,
    build_public_ip_addresses_delete_request,
    build_public_ip_addresses_get_request,
    build_public_ip_addresses_get_virtual_machine_scale_set_public_ip_address_request,
    build_public_ip_addresses_list_all_request,
    build_public_ip_addresses_list_request,
    build_public_ip_addresses_list_virtual_machine_scale_set_public_ip_addresses_request,
    build_public_ip_addresses_list_virtual_machine_scale_set_vm_public_ip_addresses_request,
    build_public_ip_addresses_update_tags_request,
    build_route_filter_rules_create_or_update_request,
    build_route_filter_rules_delete_request,
    build_route_filter_rules_get_request,
    build_route_filter_rules_list_by_route_filter_request,
    build_route_filter_rules_update_request,
    build_route_filters_create_or_update_request,
    build_route_filters_delete_request,
    build_route_filters_get_request,
    build_route_filters_list_by_resource_group_request,
    build_route_filters_list_request,
    build_route_filters_update_request,
    build_route_tables_create_or_update_request,
    build_route_tables_delete_request,
    build_route_tables_get_request,
    build_route_tables_list_all_request,
    build_route_tables_list_request,
    build_route_tables_update_tags_request,
    build_routes_create_or_update_request,
    build_routes_delete_request,
    build_routes_get_request,
    build_routes_list_request,
    build_security_rules_create_or_update_request,
    build_security_rules_delete_request,
    build_security_rules_get_request,
    build_security_rules_list_request,
    build_subnets_create_or_update_request,
    build_subnets_delete_request,
    build_subnets_get_request,
    build_subnets_list_request,
    build_usages_list_request,
    build_virtual_network_gateway_connections_create_or_update_request,
    build_virtual_network_gateway_connections_delete_request,
    build_virtual_network_gateway_connections_get_request,
    build_virtual_network_gateway_connections_get_shared_key_request,
    build_virtual_network_gateway_connections_list_request,
    build_virtual_network_gateway_connections_reset_shared_key_request,
    build_virtual_network_gateway_connections_set_shared_key_request,
    build_virtual_network_gateway_connections_update_tags_request,
    build_virtual_network_gateways_create_or_update_request,
    build_virtual_network_gateways_delete_request,
    build_virtual_network_gateways_generate_vpn_profile_request,
    build_virtual_network_gateways_generatevpnclientpackage_request,
    build_virtual_network_gateways_get_advertised_routes_request,
    build_virtual_network_gateways_get_bgp_peer_status_request,
    build_virtual_network_gateways_get_learned_routes_request,
    build_virtual_network_gateways_get_request,
    build_virtual_network_gateways_get_vpn_profile_package_url_request,
    build_virtual_network_gateways_list_connections_request,
    build_virtual_network_gateways_list_request,
    build_virtual_network_gateways_reset_request,
    build_virtual_network_gateways_supported_vpn_devices_request,
    build_virtual_network_gateways_update_tags_request,
    build_virtual_network_gateways_vpn_device_configuration_script_request,
    build_virtual_network_peerings_create_or_update_request,
    build_virtual_network_peerings_delete_request,
    build_virtual_network_peerings_get_request,
    build_virtual_network_peerings_list_request,
    build_virtual_networks_check_ip_address_availability_request,
    build_virtual_networks_create_or_update_request,
    build_virtual_networks_delete_request,
    build_virtual_networks_get_request,
    build_virtual_networks_list_all_request,
    build_virtual_networks_list_request,
    build_virtual_networks_list_usage_request,
    build_virtual_networks_update_tags_request,
)
from .._vendor import NetworkManagementClientMixinABC

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore  # pylint: disable=ungrouped-imports
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]


class ApplicationGatewaysOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.network.v2017_10_01.aio.NetworkManagementClient`'s
        :attr:`application_gateways` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")
        self._api_version = input_args.pop(0) if input_args else kwargs.pop("api_version")

    async def _delete_initial(  # pylint: disable=inconsistent-return-statements
        self, resource_group_name: str, application_gateway_name: str, **kwargs: Any
    ) -> None:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_application_gateways_delete_request(
            resource_group_name=resource_group_name,
            application_gateway_name=application_gateway_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def begin_delete(
        self, resource_group_name: str, application_gateway_name: str, **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Deletes the specified application gateway.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param application_gateway_name: The name of the application gateway. Required.
        :type application_gateway_name: str
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._delete_initial(  # type: ignore
                resource_group_name=resource_group_name,
                application_gateway_name=application_gateway_name,
                api_version=api_version,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})  # type: ignore

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[None].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[None](self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    @distributed_trace_async
    async def get(
        self, resource_group_name: str, application_gateway_name: str, **kwargs: Any
    ) -> _models.ApplicationGateway:
        """Gets the specified application gateway.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param application_gateway_name: The name of the application gateway. Required.
        :type application_gateway_name: str
        :return: ApplicationGateway or the result of cls(response)
        :rtype: ~azure.mgmt.network.v2017_10_01.models.ApplicationGateway
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[_models.ApplicationGateway] = kwargs.pop("cls", None)

        _request = build_application_gateways_get_request(
            resource_group_name=resource_group_name,
            application_gateway_name=application_gateway_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("ApplicationGateway", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    async def _create_or_update_initial(
        self,
        resource_group_name: str,
        application_gateway_name: str,
        parameters: Union[_models.ApplicationGateway, IO[bytes]],
        **kwargs: Any
    ) -> _models.ApplicationGateway:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.ApplicationGateway] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IOBase, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "ApplicationGateway")

        _request = build_application_gateways_create_or_update_request(
            resource_group_name=resource_group_name,
            application_gateway_name=application_gateway_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if response.status_code == 200:
            deserialized = self._deserialize("ApplicationGateway", pipeline_response)

        if response.status_code == 201:
            deserialized = self._deserialize("ApplicationGateway", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_create_or_update(
        self,
        resource_group_name: str,
        application_gateway_name: str,
        parameters: _models.ApplicationGateway,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.ApplicationGateway]:
        """Creates or updates the specified application gateway.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param application_gateway_name: The name of the application gateway. Required.
        :type application_gateway_name: str
        :param parameters: Parameters supplied to the create or update application gateway operation.
         Required.
        :type parameters: ~azure.mgmt.network.v2017_10_01.models.ApplicationGateway
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either ApplicationGateway or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.ApplicationGateway]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_create_or_update(
        self,
        resource_group_name: str,
        application_gateway_name: str,
        parameters: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.ApplicationGateway]:
        """Creates or updates the specified application gateway.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param application_gateway_name: The name of the application gateway. Required.
        :type application_gateway_name: str
        :param parameters: Parameters supplied to the create or update application gateway operation.
         Required.
        :type parameters: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either ApplicationGateway or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.ApplicationGateway]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_create_or_update(
        self,
        resource_group_name: str,
        application_gateway_name: str,
        parameters: Union[_models.ApplicationGateway, IO[bytes]],
        **kwargs: Any
    ) -> AsyncLROPoller[_models.ApplicationGateway]:
        """Creates or updates the specified application gateway.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param application_gateway_name: The name of the application gateway. Required.
        :type application_gateway_name: str
        :param parameters: Parameters supplied to the create or update application gateway operation.
         Is either a ApplicationGateway type or a IO[bytes] type. Required.
        :type parameters: ~azure.mgmt.network.v2017_10_01.models.ApplicationGateway or IO[bytes]
        :return: An instance of AsyncLROPoller that returns either ApplicationGateway or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.ApplicationGateway]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.ApplicationGateway] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._create_or_update_initial(
                resource_group_name=resource_group_name,
                application_gateway_name=application_gateway_name,
                parameters=parameters,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("ApplicationGateway", pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.ApplicationGateway].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.ApplicationGateway](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    async def _update_tags_initial(
        self,
        resource_group_name: str,
        application_gateway_name: str,
        parameters: Union[_models.TagsObject, IO[bytes]],
        **kwargs: Any
    ) -> _models.ApplicationGateway:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.ApplicationGateway] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IOBase, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "TagsObject")

        _request = build_application_gateways_update_tags_request(
            resource_group_name=resource_group_name,
            application_gateway_name=application_gateway_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("ApplicationGateway", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_update_tags(
        self,
        resource_group_name: str,
        application_gateway_name: str,
        parameters: _models.TagsObject,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.ApplicationGateway]:
        """Updates the specified application gateway tags.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param application_gateway_name: The name of the application gateway. Required.
        :type application_gateway_name: str
        :param parameters: Parameters supplied to update application gateway tags. Required.
        :type parameters: ~azure.mgmt.network.v2017_10_01.models.TagsObject
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either ApplicationGateway or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.ApplicationGateway]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_update_tags(
        self,
        resource_group_name: str,
        application_gateway_name: str,
        parameters: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.ApplicationGateway]:
        """Updates the specified application gateway tags.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param application_gateway_name: The name of the application gateway. Required.
        :type application_gateway_name: str
        :param parameters: Parameters supplied to update application gateway tags. Required.
        :type parameters: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either ApplicationGateway or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.ApplicationGateway]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_update_tags(
        self,
        resource_group_name: str,
        application_gateway_name: str,
        parameters: Union[_models.TagsObject, IO[bytes]],
        **kwargs: Any
    ) -> AsyncLROPoller[_models.ApplicationGateway]:
        """Updates the specified application gateway tags.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param application_gateway_name: The name of the application gateway. Required.
        :type application_gateway_name: str
        :param parameters: Parameters supplied to update application gateway tags. Is either a
         TagsObject type or a IO[bytes] type. Required.
        :type parameters: ~azure.mgmt.network.v2017_10_01.models.TagsObject or IO[bytes]
        :return: An instance of AsyncLROPoller that returns either ApplicationGateway or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.ApplicationGateway]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.ApplicationGateway] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._update_tags_initial(
                resource_group_name=resource_group_name,
                application_gateway_name=application_gateway_name,
                parameters=parameters,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("ApplicationGateway", pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.ApplicationGateway].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.ApplicationGateway](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    @distributed_trace
    def list(self, resource_group_name: str, **kwargs: Any) -> AsyncIterable["_models.ApplicationGateway"]:
        """Lists all application gateways in a resource group.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :return: An iterator like instance of either ApplicationGateway or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.network.v2017_10_01.models.ApplicationGateway]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[_models.ApplicationGatewayListResult] = kwargs.pop("cls", None)

        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_application_gateways_list_request(
                    resource_group_name=resource_group_name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)

            else:
                _request = HttpRequest("GET", next_link)
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("ApplicationGatewayListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace
    def list_all(self, **kwargs: Any) -> AsyncIterable["_models.ApplicationGateway"]:
        """Gets all the application gateways in a subscription.

        :return: An iterator like instance of either ApplicationGateway or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.network.v2017_10_01.models.ApplicationGateway]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[_models.ApplicationGatewayListResult] = kwargs.pop("cls", None)

        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_application_gateways_list_all_request(
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)

            else:
                _request = HttpRequest("GET", next_link)
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("ApplicationGatewayListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    async def _start_initial(  # pylint: disable=inconsistent-return-statements
        self, resource_group_name: str, application_gateway_name: str, **kwargs: Any
    ) -> None:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_application_gateways_start_request(
            resource_group_name=resource_group_name,
            application_gateway_name=application_gateway_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def begin_start(
        self, resource_group_name: str, application_gateway_name: str, **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Starts the specified application gateway.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param application_gateway_name: The name of the application gateway. Required.
        :type application_gateway_name: str
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._start_initial(  # type: ignore
                resource_group_name=resource_group_name,
                application_gateway_name=application_gateway_name,
                api_version=api_version,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})  # type: ignore

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[None].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[None](self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    async def _stop_initial(  # pylint: disable=inconsistent-return-statements
        self, resource_group_name: str, application_gateway_name: str, **kwargs: Any
    ) -> None:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_application_gateways_stop_request(
            resource_group_name=resource_group_name,
            application_gateway_name=application_gateway_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def begin_stop(
        self, resource_group_name: str, application_gateway_name: str, **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Stops the specified application gateway in a resource group.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param application_gateway_name: The name of the application gateway. Required.
        :type application_gateway_name: str
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._stop_initial(  # type: ignore
                resource_group_name=resource_group_name,
                application_gateway_name=application_gateway_name,
                api_version=api_version,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})  # type: ignore

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[None].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[None](self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    async def _backend_health_initial(
        self, resource_group_name: str, application_gateway_name: str, *, expand: Optional[str] = None, **kwargs: Any
    ) -> Optional[_models.ApplicationGatewayBackendHealth]:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[Optional[_models.ApplicationGatewayBackendHealth]] = kwargs.pop("cls", None)

        _request = build_application_gateways_backend_health_request(
            resource_group_name=resource_group_name,
            application_gateway_name=application_gateway_name,
            subscription_id=self._config.subscription_id,
            expand=expand,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize("ApplicationGatewayBackendHealth", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def begin_backend_health(
        self, resource_group_name: str, application_gateway_name: str, *, expand: Optional[str] = None, **kwargs: Any
    ) -> AsyncLROPoller[_models.ApplicationGatewayBackendHealth]:
        """Gets the backend health of the specified application gateway in a resource group.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param application_gateway_name: The name of the application gateway. Required.
        :type application_gateway_name: str
        :keyword expand: Expands BackendAddressPool and BackendHttpSettings referenced in backend
         health. Default value is None.
        :paramtype expand: str
        :return: An instance of AsyncLROPoller that returns either ApplicationGatewayBackendHealth or
         the result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.ApplicationGatewayBackendHealth]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[_models.ApplicationGatewayBackendHealth] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._backend_health_initial(
                resource_group_name=resource_group_name,
                application_gateway_name=application_gateway_name,
                expand=expand,
                api_version=api_version,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("ApplicationGatewayBackendHealth", pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.ApplicationGatewayBackendHealth].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.ApplicationGatewayBackendHealth](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    @distributed_trace_async
    async def list_available_waf_rule_sets(self, **kwargs: Any) -> _models.ApplicationGatewayAvailableWafRuleSetsResult:
        """Lists all available web application firewall rule sets.

        :return: ApplicationGatewayAvailableWafRuleSetsResult or the result of cls(response)
        :rtype: ~azure.mgmt.network.v2017_10_01.models.ApplicationGatewayAvailableWafRuleSetsResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[_models.ApplicationGatewayAvailableWafRuleSetsResult] = kwargs.pop("cls", None)

        _request = build_application_gateways_list_available_waf_rule_sets_request(
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("ApplicationGatewayAvailableWafRuleSetsResult", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def list_available_ssl_options(self, **kwargs: Any) -> _models.ApplicationGatewayAvailableSslOptions:
        """Lists available Ssl options for configuring Ssl policy.

        :return: ApplicationGatewayAvailableSslOptions or the result of cls(response)
        :rtype: ~azure.mgmt.network.v2017_10_01.models.ApplicationGatewayAvailableSslOptions
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[_models.ApplicationGatewayAvailableSslOptions] = kwargs.pop("cls", None)

        _request = build_application_gateways_list_available_ssl_options_request(
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("ApplicationGatewayAvailableSslOptions", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def list_available_ssl_predefined_policies(
        self, **kwargs: Any
    ) -> AsyncIterable["_models.ApplicationGatewaySslPredefinedPolicy"]:
        """Lists all SSL predefined policies for configuring Ssl policy.

        :return: An iterator like instance of either ApplicationGatewaySslPredefinedPolicy or the
         result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.network.v2017_10_01.models.ApplicationGatewaySslPredefinedPolicy]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[_models.ApplicationGatewayAvailableSslPredefinedPolicies] = kwargs.pop("cls", None)

        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_application_gateways_list_available_ssl_predefined_policies_request(
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)

            else:
                _request = HttpRequest("GET", next_link)
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("ApplicationGatewayAvailableSslPredefinedPolicies", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def get_ssl_predefined_policy(
        self, predefined_policy_name: str, **kwargs: Any
    ) -> _models.ApplicationGatewaySslPredefinedPolicy:
        """Gets Ssl predefined policy with the specified policy name.

        :param predefined_policy_name: Name of Ssl predefined policy. Required.
        :type predefined_policy_name: str
        :return: ApplicationGatewaySslPredefinedPolicy or the result of cls(response)
        :rtype: ~azure.mgmt.network.v2017_10_01.models.ApplicationGatewaySslPredefinedPolicy
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[_models.ApplicationGatewaySslPredefinedPolicy] = kwargs.pop("cls", None)

        _request = build_application_gateways_get_ssl_predefined_policy_request(
            predefined_policy_name=predefined_policy_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("ApplicationGatewaySslPredefinedPolicy", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore


class ApplicationSecurityGroupsOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.network.v2017_10_01.aio.NetworkManagementClient`'s
        :attr:`application_security_groups` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")
        self._api_version = input_args.pop(0) if input_args else kwargs.pop("api_version")

    async def _delete_initial(  # pylint: disable=inconsistent-return-statements
        self, resource_group_name: str, application_security_group_name: str, **kwargs: Any
    ) -> None:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_application_security_groups_delete_request(
            resource_group_name=resource_group_name,
            application_security_group_name=application_security_group_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def begin_delete(
        self, resource_group_name: str, application_security_group_name: str, **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Deletes the specified application security group.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param application_security_group_name: The name of the application security group. Required.
        :type application_security_group_name: str
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._delete_initial(  # type: ignore
                resource_group_name=resource_group_name,
                application_security_group_name=application_security_group_name,
                api_version=api_version,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})  # type: ignore

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[None].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[None](self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    @distributed_trace_async
    async def get(
        self, resource_group_name: str, application_security_group_name: str, **kwargs: Any
    ) -> _models.ApplicationSecurityGroup:
        """Gets information about the specified application security group.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param application_security_group_name: The name of the application security group. Required.
        :type application_security_group_name: str
        :return: ApplicationSecurityGroup or the result of cls(response)
        :rtype: ~azure.mgmt.network.v2017_10_01.models.ApplicationSecurityGroup
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[_models.ApplicationSecurityGroup] = kwargs.pop("cls", None)

        _request = build_application_security_groups_get_request(
            resource_group_name=resource_group_name,
            application_security_group_name=application_security_group_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("ApplicationSecurityGroup", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    async def _create_or_update_initial(
        self,
        resource_group_name: str,
        application_security_group_name: str,
        parameters: Union[_models.ApplicationSecurityGroup, IO[bytes]],
        **kwargs: Any
    ) -> _models.ApplicationSecurityGroup:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.ApplicationSecurityGroup] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IOBase, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "ApplicationSecurityGroup")

        _request = build_application_security_groups_create_or_update_request(
            resource_group_name=resource_group_name,
            application_security_group_name=application_security_group_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if response.status_code == 200:
            deserialized = self._deserialize("ApplicationSecurityGroup", pipeline_response)

        if response.status_code == 201:
            deserialized = self._deserialize("ApplicationSecurityGroup", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_create_or_update(
        self,
        resource_group_name: str,
        application_security_group_name: str,
        parameters: _models.ApplicationSecurityGroup,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.ApplicationSecurityGroup]:
        """Creates or updates an application security group.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param application_security_group_name: The name of the application security group. Required.
        :type application_security_group_name: str
        :param parameters: Parameters supplied to the create or update ApplicationSecurityGroup
         operation. Required.
        :type parameters: ~azure.mgmt.network.v2017_10_01.models.ApplicationSecurityGroup
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either ApplicationSecurityGroup or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.ApplicationSecurityGroup]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_create_or_update(
        self,
        resource_group_name: str,
        application_security_group_name: str,
        parameters: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.ApplicationSecurityGroup]:
        """Creates or updates an application security group.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param application_security_group_name: The name of the application security group. Required.
        :type application_security_group_name: str
        :param parameters: Parameters supplied to the create or update ApplicationSecurityGroup
         operation. Required.
        :type parameters: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either ApplicationSecurityGroup or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.ApplicationSecurityGroup]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_create_or_update(
        self,
        resource_group_name: str,
        application_security_group_name: str,
        parameters: Union[_models.ApplicationSecurityGroup, IO[bytes]],
        **kwargs: Any
    ) -> AsyncLROPoller[_models.ApplicationSecurityGroup]:
        """Creates or updates an application security group.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param application_security_group_name: The name of the application security group. Required.
        :type application_security_group_name: str
        :param parameters: Parameters supplied to the create or update ApplicationSecurityGroup
         operation. Is either a ApplicationSecurityGroup type or a IO[bytes] type. Required.
        :type parameters: ~azure.mgmt.network.v2017_10_01.models.ApplicationSecurityGroup or IO[bytes]
        :return: An instance of AsyncLROPoller that returns either ApplicationSecurityGroup or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.ApplicationSecurityGroup]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.ApplicationSecurityGroup] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._create_or_update_initial(
                resource_group_name=resource_group_name,
                application_security_group_name=application_security_group_name,
                parameters=parameters,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("ApplicationSecurityGroup", pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.ApplicationSecurityGroup].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.ApplicationSecurityGroup](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    @distributed_trace
    def list_all(self, **kwargs: Any) -> AsyncIterable["_models.ApplicationSecurityGroup"]:
        """Gets all application security groups in a subscription.

        :return: An iterator like instance of either ApplicationSecurityGroup or the result of
         cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.network.v2017_10_01.models.ApplicationSecurityGroup]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[_models.ApplicationSecurityGroupListResult] = kwargs.pop("cls", None)

        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_application_security_groups_list_all_request(
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)

            else:
                _request = HttpRequest("GET", next_link)
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("ApplicationSecurityGroupListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace
    def list(self, resource_group_name: str, **kwargs: Any) -> AsyncIterable["_models.ApplicationSecurityGroup"]:
        """Gets all the application security groups in a resource group.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :return: An iterator like instance of either ApplicationSecurityGroup or the result of
         cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.network.v2017_10_01.models.ApplicationSecurityGroup]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[_models.ApplicationSecurityGroupListResult] = kwargs.pop("cls", None)

        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_application_security_groups_list_request(
                    resource_group_name=resource_group_name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)

            else:
                _request = HttpRequest("GET", next_link)
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("ApplicationSecurityGroupListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)


class NetworkManagementClientOperationsMixin(NetworkManagementClientMixinABC):
    def _api_version(self, op_name: str) -> str:  # pylint: disable=unused-argument
        try:
            return self._config.api_version
        except:  # pylint: disable=bare-except
            return ""

    @distributed_trace_async
    async def check_dns_name_availability(
        self, location: str, *, domain_name_label: str, **kwargs: Any
    ) -> _models.DnsNameAvailabilityResult:
        """Checks whether a domain name in the cloudapp.azure.com zone is available for use.

        :param location: The location of the domain name. Required.
        :type location: str
        :keyword domain_name_label: The domain name to be verified. It must conform to the following
         regular expression: ^[a-z][a-z0-9-]{1,61}[a-z0-9]$. Required.
        :paramtype domain_name_label: str
        :return: DnsNameAvailabilityResult or the result of cls(response)
        :rtype: ~azure.mgmt.network.v2017_10_01.models.DnsNameAvailabilityResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop(
            "api_version", _params.pop("api-version", self._api_version("check_dns_name_availability") or "2017-10-01")
        )
        cls: ClsType[_models.DnsNameAvailabilityResult] = kwargs.pop("cls", None)

        _request = build_network_management_check_dns_name_availability_request(
            location=location,
            subscription_id=self._config.subscription_id,
            domain_name_label=domain_name_label,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("DnsNameAvailabilityResult", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore


class AvailableEndpointServicesOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.network.v2017_10_01.aio.NetworkManagementClient`'s
        :attr:`available_endpoint_services` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")
        self._api_version = input_args.pop(0) if input_args else kwargs.pop("api_version")

    @distributed_trace
    def list(self, location: str, **kwargs: Any) -> AsyncIterable["_models.EndpointServiceResult"]:
        """List what values of endpoint services are available for use.

        :param location: The location to check available endpoint services. Required.
        :type location: str
        :return: An iterator like instance of either EndpointServiceResult or the result of
         cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.network.v2017_10_01.models.EndpointServiceResult]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[_models.EndpointServicesListResult] = kwargs.pop("cls", None)

        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_available_endpoint_services_list_request(
                    location=location,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)

            else:
                _request = HttpRequest("GET", next_link)
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("EndpointServicesListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)


class ExpressRouteCircuitAuthorizationsOperations:  # pylint: disable=name-too-long
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.network.v2017_10_01.aio.NetworkManagementClient`'s
        :attr:`express_route_circuit_authorizations` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")
        self._api_version = input_args.pop(0) if input_args else kwargs.pop("api_version")

    async def _delete_initial(  # pylint: disable=inconsistent-return-statements
        self, resource_group_name: str, circuit_name: str, authorization_name: str, **kwargs: Any
    ) -> None:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_express_route_circuit_authorizations_delete_request(
            resource_group_name=resource_group_name,
            circuit_name=circuit_name,
            authorization_name=authorization_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def begin_delete(
        self, resource_group_name: str, circuit_name: str, authorization_name: str, **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Deletes the specified authorization from the specified express route circuit.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param circuit_name: The name of the express route circuit. Required.
        :type circuit_name: str
        :param authorization_name: The name of the authorization. Required.
        :type authorization_name: str
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._delete_initial(  # type: ignore
                resource_group_name=resource_group_name,
                circuit_name=circuit_name,
                authorization_name=authorization_name,
                api_version=api_version,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})  # type: ignore

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[None].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[None](self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    @distributed_trace_async
    async def get(
        self, resource_group_name: str, circuit_name: str, authorization_name: str, **kwargs: Any
    ) -> _models.ExpressRouteCircuitAuthorization:
        """Gets the specified authorization from the specified express route circuit.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param circuit_name: The name of the express route circuit. Required.
        :type circuit_name: str
        :param authorization_name: The name of the authorization. Required.
        :type authorization_name: str
        :return: ExpressRouteCircuitAuthorization or the result of cls(response)
        :rtype: ~azure.mgmt.network.v2017_10_01.models.ExpressRouteCircuitAuthorization
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[_models.ExpressRouteCircuitAuthorization] = kwargs.pop("cls", None)

        _request = build_express_route_circuit_authorizations_get_request(
            resource_group_name=resource_group_name,
            circuit_name=circuit_name,
            authorization_name=authorization_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("ExpressRouteCircuitAuthorization", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    async def _create_or_update_initial(
        self,
        resource_group_name: str,
        circuit_name: str,
        authorization_name: str,
        authorization_parameters: Union[_models.ExpressRouteCircuitAuthorization, IO[bytes]],
        **kwargs: Any
    ) -> _models.ExpressRouteCircuitAuthorization:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.ExpressRouteCircuitAuthorization] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(authorization_parameters, (IOBase, bytes)):
            _content = authorization_parameters
        else:
            _json = self._serialize.body(authorization_parameters, "ExpressRouteCircuitAuthorization")

        _request = build_express_route_circuit_authorizations_create_or_update_request(
            resource_group_name=resource_group_name,
            circuit_name=circuit_name,
            authorization_name=authorization_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if response.status_code == 200:
            deserialized = self._deserialize("ExpressRouteCircuitAuthorization", pipeline_response)

        if response.status_code == 201:
            deserialized = self._deserialize("ExpressRouteCircuitAuthorization", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_create_or_update(
        self,
        resource_group_name: str,
        circuit_name: str,
        authorization_name: str,
        authorization_parameters: _models.ExpressRouteCircuitAuthorization,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.ExpressRouteCircuitAuthorization]:
        """Creates or updates an authorization in the specified express route circuit.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param circuit_name: The name of the express route circuit. Required.
        :type circuit_name: str
        :param authorization_name: The name of the authorization. Required.
        :type authorization_name: str
        :param authorization_parameters: Parameters supplied to the create or update express route
         circuit authorization operation. Required.
        :type authorization_parameters:
         ~azure.mgmt.network.v2017_10_01.models.ExpressRouteCircuitAuthorization
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either ExpressRouteCircuitAuthorization or
         the result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.ExpressRouteCircuitAuthorization]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_create_or_update(
        self,
        resource_group_name: str,
        circuit_name: str,
        authorization_name: str,
        authorization_parameters: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.ExpressRouteCircuitAuthorization]:
        """Creates or updates an authorization in the specified express route circuit.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param circuit_name: The name of the express route circuit. Required.
        :type circuit_name: str
        :param authorization_name: The name of the authorization. Required.
        :type authorization_name: str
        :param authorization_parameters: Parameters supplied to the create or update express route
         circuit authorization operation. Required.
        :type authorization_parameters: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Known values are: 'application/json', 'text/json'. Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either ExpressRouteCircuitAuthorization or
         the result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.ExpressRouteCircuitAuthorization]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_create_or_update(
        self,
        resource_group_name: str,
        circuit_name: str,
        authorization_name: str,
        authorization_parameters: Union[_models.ExpressRouteCircuitAuthorization, IO[bytes]],
        **kwargs: Any
    ) -> AsyncLROPoller[_models.ExpressRouteCircuitAuthorization]:
        """Creates or updates an authorization in the specified express route circuit.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param circuit_name: The name of the express route circuit. Required.
        :type circuit_name: str
        :param authorization_name: The name of the authorization. Required.
        :type authorization_name: str
        :param authorization_parameters: Parameters supplied to the create or update express route
         circuit authorization operation. Is either a ExpressRouteCircuitAuthorization type or a
         IO[bytes] type. Required.
        :type authorization_parameters:
         ~azure.mgmt.network.v2017_10_01.models.ExpressRouteCircuitAuthorization or IO[bytes]
        :return: An instance of AsyncLROPoller that returns either ExpressRouteCircuitAuthorization or
         the result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.ExpressRouteCircuitAuthorization]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.ExpressRouteCircuitAuthorization] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._create_or_update_initial(
                resource_group_name=resource_group_name,
                circuit_name=circuit_name,
                authorization_name=authorization_name,
                authorization_parameters=authorization_parameters,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("ExpressRouteCircuitAuthorization", pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.ExpressRouteCircuitAuthorization].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.ExpressRouteCircuitAuthorization](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    @distributed_trace
    def list(
        self, resource_group_name: str, circuit_name: str, **kwargs: Any
    ) -> AsyncIterable["_models.ExpressRouteCircuitAuthorization"]:
        """Gets all authorizations in an express route circuit.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param circuit_name: The name of the circuit. Required.
        :type circuit_name: str
        :return: An iterator like instance of either ExpressRouteCircuitAuthorization or the result of
         cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.network.v2017_10_01.models.ExpressRouteCircuitAuthorization]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[_models.AuthorizationListResult] = kwargs.pop("cls", None)

        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_express_route_circuit_authorizations_list_request(
                    resource_group_name=resource_group_name,
                    circuit_name=circuit_name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)

            else:
                _request = HttpRequest("GET", next_link)
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("AuthorizationListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)


class ExpressRouteCircuitPeeringsOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.network.v2017_10_01.aio.NetworkManagementClient`'s
        :attr:`express_route_circuit_peerings` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")
        self._api_version = input_args.pop(0) if input_args else kwargs.pop("api_version")

    async def _delete_initial(  # pylint: disable=inconsistent-return-statements
        self, resource_group_name: str, circuit_name: str, peering_name: str, **kwargs: Any
    ) -> None:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_express_route_circuit_peerings_delete_request(
            resource_group_name=resource_group_name,
            circuit_name=circuit_name,
            peering_name=peering_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def begin_delete(
        self, resource_group_name: str, circuit_name: str, peering_name: str, **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Deletes the specified peering from the specified express route circuit.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param circuit_name: The name of the express route circuit. Required.
        :type circuit_name: str
        :param peering_name: The name of the peering. Required.
        :type peering_name: str
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._delete_initial(  # type: ignore
                resource_group_name=resource_group_name,
                circuit_name=circuit_name,
                peering_name=peering_name,
                api_version=api_version,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})  # type: ignore

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[None].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[None](self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    @distributed_trace_async
    async def get(
        self, resource_group_name: str, circuit_name: str, peering_name: str, **kwargs: Any
    ) -> _models.ExpressRouteCircuitPeering:
        """Gets the specified authorization from the specified express route circuit.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param circuit_name: The name of the express route circuit. Required.
        :type circuit_name: str
        :param peering_name: The name of the peering. Required.
        :type peering_name: str
        :return: ExpressRouteCircuitPeering or the result of cls(response)
        :rtype: ~azure.mgmt.network.v2017_10_01.models.ExpressRouteCircuitPeering
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[_models.ExpressRouteCircuitPeering] = kwargs.pop("cls", None)

        _request = build_express_route_circuit_peerings_get_request(
            resource_group_name=resource_group_name,
            circuit_name=circuit_name,
            peering_name=peering_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("ExpressRouteCircuitPeering", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    async def _create_or_update_initial(
        self,
        resource_group_name: str,
        circuit_name: str,
        peering_name: str,
        peering_parameters: Union[_models.ExpressRouteCircuitPeering, IO[bytes]],
        **kwargs: Any
    ) -> _models.ExpressRouteCircuitPeering:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.ExpressRouteCircuitPeering] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(peering_parameters, (IOBase, bytes)):
            _content = peering_parameters
        else:
            _json = self._serialize.body(peering_parameters, "ExpressRouteCircuitPeering")

        _request = build_express_route_circuit_peerings_create_or_update_request(
            resource_group_name=resource_group_name,
            circuit_name=circuit_name,
            peering_name=peering_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if response.status_code == 200:
            deserialized = self._deserialize("ExpressRouteCircuitPeering", pipeline_response)

        if response.status_code == 201:
            deserialized = self._deserialize("ExpressRouteCircuitPeering", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_create_or_update(
        self,
        resource_group_name: str,
        circuit_name: str,
        peering_name: str,
        peering_parameters: _models.ExpressRouteCircuitPeering,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.ExpressRouteCircuitPeering]:
        """Creates or updates a peering in the specified express route circuits.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param circuit_name: The name of the express route circuit. Required.
        :type circuit_name: str
        :param peering_name: The name of the peering. Required.
        :type peering_name: str
        :param peering_parameters: Parameters supplied to the create or update express route circuit
         peering operation. Required.
        :type peering_parameters: ~azure.mgmt.network.v2017_10_01.models.ExpressRouteCircuitPeering
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either ExpressRouteCircuitPeering or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.ExpressRouteCircuitPeering]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_create_or_update(
        self,
        resource_group_name: str,
        circuit_name: str,
        peering_name: str,
        peering_parameters: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.ExpressRouteCircuitPeering]:
        """Creates or updates a peering in the specified express route circuits.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param circuit_name: The name of the express route circuit. Required.
        :type circuit_name: str
        :param peering_name: The name of the peering. Required.
        :type peering_name: str
        :param peering_parameters: Parameters supplied to the create or update express route circuit
         peering operation. Required.
        :type peering_parameters: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Known values are: 'application/json', 'text/json'. Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either ExpressRouteCircuitPeering or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.ExpressRouteCircuitPeering]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_create_or_update(
        self,
        resource_group_name: str,
        circuit_name: str,
        peering_name: str,
        peering_parameters: Union[_models.ExpressRouteCircuitPeering, IO[bytes]],
        **kwargs: Any
    ) -> AsyncLROPoller[_models.ExpressRouteCircuitPeering]:
        """Creates or updates a peering in the specified express route circuits.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param circuit_name: The name of the express route circuit. Required.
        :type circuit_name: str
        :param peering_name: The name of the peering. Required.
        :type peering_name: str
        :param peering_parameters: Parameters supplied to the create or update express route circuit
         peering operation. Is either a ExpressRouteCircuitPeering type or a IO[bytes] type. Required.
        :type peering_parameters: ~azure.mgmt.network.v2017_10_01.models.ExpressRouteCircuitPeering or
         IO[bytes]
        :return: An instance of AsyncLROPoller that returns either ExpressRouteCircuitPeering or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.ExpressRouteCircuitPeering]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.ExpressRouteCircuitPeering] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._create_or_update_initial(
                resource_group_name=resource_group_name,
                circuit_name=circuit_name,
                peering_name=peering_name,
                peering_parameters=peering_parameters,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("ExpressRouteCircuitPeering", pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.ExpressRouteCircuitPeering].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.ExpressRouteCircuitPeering](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    @distributed_trace
    def list(
        self, resource_group_name: str, circuit_name: str, **kwargs: Any
    ) -> AsyncIterable["_models.ExpressRouteCircuitPeering"]:
        """Gets all peerings in a specified express route circuit.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param circuit_name: The name of the express route circuit. Required.
        :type circuit_name: str
        :return: An iterator like instance of either ExpressRouteCircuitPeering or the result of
         cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.network.v2017_10_01.models.ExpressRouteCircuitPeering]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[_models.ExpressRouteCircuitPeeringListResult] = kwargs.pop("cls", None)

        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_express_route_circuit_peerings_list_request(
                    resource_group_name=resource_group_name,
                    circuit_name=circuit_name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)

            else:
                _request = HttpRequest("GET", next_link)
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("ExpressRouteCircuitPeeringListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)


class ExpressRouteCircuitsOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.network.v2017_10_01.aio.NetworkManagementClient`'s
        :attr:`express_route_circuits` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")
        self._api_version = input_args.pop(0) if input_args else kwargs.pop("api_version")

    async def _delete_initial(  # pylint: disable=inconsistent-return-statements
        self, resource_group_name: str, circuit_name: str, **kwargs: Any
    ) -> None:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_express_route_circuits_delete_request(
            resource_group_name=resource_group_name,
            circuit_name=circuit_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def begin_delete(self, resource_group_name: str, circuit_name: str, **kwargs: Any) -> AsyncLROPoller[None]:
        """Deletes the specified express route circuit.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param circuit_name: The name of the express route circuit. Required.
        :type circuit_name: str
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._delete_initial(  # type: ignore
                resource_group_name=resource_group_name,
                circuit_name=circuit_name,
                api_version=api_version,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})  # type: ignore

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[None].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[None](self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    @distributed_trace_async
    async def get(self, resource_group_name: str, circuit_name: str, **kwargs: Any) -> _models.ExpressRouteCircuit:
        """Gets information about the specified express route circuit.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param circuit_name: The name of express route circuit. Required.
        :type circuit_name: str
        :return: ExpressRouteCircuit or the result of cls(response)
        :rtype: ~azure.mgmt.network.v2017_10_01.models.ExpressRouteCircuit
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[_models.ExpressRouteCircuit] = kwargs.pop("cls", None)

        _request = build_express_route_circuits_get_request(
            resource_group_name=resource_group_name,
            circuit_name=circuit_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("ExpressRouteCircuit", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    async def _create_or_update_initial(
        self,
        resource_group_name: str,
        circuit_name: str,
        parameters: Union[_models.ExpressRouteCircuit, IO[bytes]],
        **kwargs: Any
    ) -> _models.ExpressRouteCircuit:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.ExpressRouteCircuit] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IOBase, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "ExpressRouteCircuit")

        _request = build_express_route_circuits_create_or_update_request(
            resource_group_name=resource_group_name,
            circuit_name=circuit_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if response.status_code == 200:
            deserialized = self._deserialize("ExpressRouteCircuit", pipeline_response)

        if response.status_code == 201:
            deserialized = self._deserialize("ExpressRouteCircuit", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_create_or_update(
        self,
        resource_group_name: str,
        circuit_name: str,
        parameters: _models.ExpressRouteCircuit,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.ExpressRouteCircuit]:
        """Creates or updates an express route circuit.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param circuit_name: The name of the circuit. Required.
        :type circuit_name: str
        :param parameters: Parameters supplied to the create or update express route circuit operation.
         Required.
        :type parameters: ~azure.mgmt.network.v2017_10_01.models.ExpressRouteCircuit
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either ExpressRouteCircuit or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.ExpressRouteCircuit]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_create_or_update(
        self,
        resource_group_name: str,
        circuit_name: str,
        parameters: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.ExpressRouteCircuit]:
        """Creates or updates an express route circuit.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param circuit_name: The name of the circuit. Required.
        :type circuit_name: str
        :param parameters: Parameters supplied to the create or update express route circuit operation.
         Required.
        :type parameters: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Known values are: 'application/json', 'text/json'. Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either ExpressRouteCircuit or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.ExpressRouteCircuit]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_create_or_update(
        self,
        resource_group_name: str,
        circuit_name: str,
        parameters: Union[_models.ExpressRouteCircuit, IO[bytes]],
        **kwargs: Any
    ) -> AsyncLROPoller[_models.ExpressRouteCircuit]:
        """Creates or updates an express route circuit.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param circuit_name: The name of the circuit. Required.
        :type circuit_name: str
        :param parameters: Parameters supplied to the create or update express route circuit operation.
         Is either a ExpressRouteCircuit type or a IO[bytes] type. Required.
        :type parameters: ~azure.mgmt.network.v2017_10_01.models.ExpressRouteCircuit or IO[bytes]
        :return: An instance of AsyncLROPoller that returns either ExpressRouteCircuit or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.ExpressRouteCircuit]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.ExpressRouteCircuit] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._create_or_update_initial(
                resource_group_name=resource_group_name,
                circuit_name=circuit_name,
                parameters=parameters,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("ExpressRouteCircuit", pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.ExpressRouteCircuit].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.ExpressRouteCircuit](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    async def _update_tags_initial(
        self,
        resource_group_name: str,
        circuit_name: str,
        parameters: Union[_models.TagsObject, IO[bytes]],
        **kwargs: Any
    ) -> _models.ExpressRouteCircuit:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.ExpressRouteCircuit] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IOBase, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "TagsObject")

        _request = build_express_route_circuits_update_tags_request(
            resource_group_name=resource_group_name,
            circuit_name=circuit_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("ExpressRouteCircuit", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_update_tags(
        self,
        resource_group_name: str,
        circuit_name: str,
        parameters: _models.TagsObject,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.ExpressRouteCircuit]:
        """Updates an express route circuit tags.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param circuit_name: The name of the circuit. Required.
        :type circuit_name: str
        :param parameters: Parameters supplied to update express route circuit tags. Required.
        :type parameters: ~azure.mgmt.network.v2017_10_01.models.TagsObject
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either ExpressRouteCircuit or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.ExpressRouteCircuit]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_update_tags(
        self,
        resource_group_name: str,
        circuit_name: str,
        parameters: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.ExpressRouteCircuit]:
        """Updates an express route circuit tags.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param circuit_name: The name of the circuit. Required.
        :type circuit_name: str
        :param parameters: Parameters supplied to update express route circuit tags. Required.
        :type parameters: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Known values are: 'application/json', 'text/json'. Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either ExpressRouteCircuit or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.ExpressRouteCircuit]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_update_tags(
        self,
        resource_group_name: str,
        circuit_name: str,
        parameters: Union[_models.TagsObject, IO[bytes]],
        **kwargs: Any
    ) -> AsyncLROPoller[_models.ExpressRouteCircuit]:
        """Updates an express route circuit tags.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param circuit_name: The name of the circuit. Required.
        :type circuit_name: str
        :param parameters: Parameters supplied to update express route circuit tags. Is either a
         TagsObject type or a IO[bytes] type. Required.
        :type parameters: ~azure.mgmt.network.v2017_10_01.models.TagsObject or IO[bytes]
        :return: An instance of AsyncLROPoller that returns either ExpressRouteCircuit or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.ExpressRouteCircuit]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.ExpressRouteCircuit] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._update_tags_initial(
                resource_group_name=resource_group_name,
                circuit_name=circuit_name,
                parameters=parameters,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("ExpressRouteCircuit", pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.ExpressRouteCircuit].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.ExpressRouteCircuit](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    async def _list_arp_table_initial(
        self, resource_group_name: str, circuit_name: str, peering_name: str, device_path: str, **kwargs: Any
    ) -> Optional[_models.ExpressRouteCircuitsArpTableListResult]:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[Optional[_models.ExpressRouteCircuitsArpTableListResult]] = kwargs.pop("cls", None)

        _request = build_express_route_circuits_list_arp_table_request(
            resource_group_name=resource_group_name,
            circuit_name=circuit_name,
            peering_name=peering_name,
            device_path=device_path,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize("ExpressRouteCircuitsArpTableListResult", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def begin_list_arp_table(
        self, resource_group_name: str, circuit_name: str, peering_name: str, device_path: str, **kwargs: Any
    ) -> AsyncLROPoller[_models.ExpressRouteCircuitsArpTableListResult]:
        """Gets the currently advertised ARP table associated with the express route circuit in a resource
        group.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param circuit_name: The name of the express route circuit. Required.
        :type circuit_name: str
        :param peering_name: The name of the peering. Required.
        :type peering_name: str
        :param device_path: The path of the device. Required.
        :type device_path: str
        :return: An instance of AsyncLROPoller that returns either
         ExpressRouteCircuitsArpTableListResult or the result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.ExpressRouteCircuitsArpTableListResult]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[_models.ExpressRouteCircuitsArpTableListResult] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._list_arp_table_initial(
                resource_group_name=resource_group_name,
                circuit_name=circuit_name,
                peering_name=peering_name,
                device_path=device_path,
                api_version=api_version,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("ExpressRouteCircuitsArpTableListResult", pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.ExpressRouteCircuitsArpTableListResult].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.ExpressRouteCircuitsArpTableListResult](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    async def _list_routes_table_initial(
        self, resource_group_name: str, circuit_name: str, peering_name: str, device_path: str, **kwargs: Any
    ) -> Optional[_models.ExpressRouteCircuitsRoutesTableListResult]:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[Optional[_models.ExpressRouteCircuitsRoutesTableListResult]] = kwargs.pop("cls", None)

        _request = build_express_route_circuits_list_routes_table_request(
            resource_group_name=resource_group_name,
            circuit_name=circuit_name,
            peering_name=peering_name,
            device_path=device_path,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize("ExpressRouteCircuitsRoutesTableListResult", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def begin_list_routes_table(
        self, resource_group_name: str, circuit_name: str, peering_name: str, device_path: str, **kwargs: Any
    ) -> AsyncLROPoller[_models.ExpressRouteCircuitsRoutesTableListResult]:
        """Gets the currently advertised routes table associated with the express route circuit in a
        resource group.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param circuit_name: The name of the express route circuit. Required.
        :type circuit_name: str
        :param peering_name: The name of the peering. Required.
        :type peering_name: str
        :param device_path: The path of the device. Required.
        :type device_path: str
        :return: An instance of AsyncLROPoller that returns either
         ExpressRouteCircuitsRoutesTableListResult or the result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.ExpressRouteCircuitsRoutesTableListResult]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[_models.ExpressRouteCircuitsRoutesTableListResult] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._list_routes_table_initial(
                resource_group_name=resource_group_name,
                circuit_name=circuit_name,
                peering_name=peering_name,
                device_path=device_path,
                api_version=api_version,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("ExpressRouteCircuitsRoutesTableListResult", pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.ExpressRouteCircuitsRoutesTableListResult].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.ExpressRouteCircuitsRoutesTableListResult](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    async def _list_routes_table_summary_initial(
        self, resource_group_name: str, circuit_name: str, peering_name: str, device_path: str, **kwargs: Any
    ) -> Optional[_models.ExpressRouteCircuitsRoutesTableSummaryListResult]:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[Optional[_models.ExpressRouteCircuitsRoutesTableSummaryListResult]] = kwargs.pop("cls", None)

        _request = build_express_route_circuits_list_routes_table_summary_request(
            resource_group_name=resource_group_name,
            circuit_name=circuit_name,
            peering_name=peering_name,
            device_path=device_path,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize("ExpressRouteCircuitsRoutesTableSummaryListResult", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def begin_list_routes_table_summary(
        self, resource_group_name: str, circuit_name: str, peering_name: str, device_path: str, **kwargs: Any
    ) -> AsyncLROPoller[_models.ExpressRouteCircuitsRoutesTableSummaryListResult]:
        """Gets the currently advertised routes table summary associated with the express route circuit in
        a resource group.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param circuit_name: The name of the express route circuit. Required.
        :type circuit_name: str
        :param peering_name: The name of the peering. Required.
        :type peering_name: str
        :param device_path: The path of the device. Required.
        :type device_path: str
        :return: An instance of AsyncLROPoller that returns either
         ExpressRouteCircuitsRoutesTableSummaryListResult or the result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.ExpressRouteCircuitsRoutesTableSummaryListResult]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[_models.ExpressRouteCircuitsRoutesTableSummaryListResult] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._list_routes_table_summary_initial(
                resource_group_name=resource_group_name,
                circuit_name=circuit_name,
                peering_name=peering_name,
                device_path=device_path,
                api_version=api_version,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("ExpressRouteCircuitsRoutesTableSummaryListResult", pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.ExpressRouteCircuitsRoutesTableSummaryListResult].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.ExpressRouteCircuitsRoutesTableSummaryListResult](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    @distributed_trace_async
    async def get_stats(
        self, resource_group_name: str, circuit_name: str, **kwargs: Any
    ) -> _models.ExpressRouteCircuitStats:
        """Gets all the stats from an express route circuit in a resource group.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param circuit_name: The name of the express route circuit. Required.
        :type circuit_name: str
        :return: ExpressRouteCircuitStats or the result of cls(response)
        :rtype: ~azure.mgmt.network.v2017_10_01.models.ExpressRouteCircuitStats
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[_models.ExpressRouteCircuitStats] = kwargs.pop("cls", None)

        _request = build_express_route_circuits_get_stats_request(
            resource_group_name=resource_group_name,
            circuit_name=circuit_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("ExpressRouteCircuitStats", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_peering_stats(
        self, resource_group_name: str, circuit_name: str, peering_name: str, **kwargs: Any
    ) -> _models.ExpressRouteCircuitStats:
        """Gets all stats from an express route circuit in a resource group.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param circuit_name: The name of the express route circuit. Required.
        :type circuit_name: str
        :param peering_name: The name of the peering. Required.
        :type peering_name: str
        :return: ExpressRouteCircuitStats or the result of cls(response)
        :rtype: ~azure.mgmt.network.v2017_10_01.models.ExpressRouteCircuitStats
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[_models.ExpressRouteCircuitStats] = kwargs.pop("cls", None)

        _request = build_express_route_circuits_get_peering_stats_request(
            resource_group_name=resource_group_name,
            circuit_name=circuit_name,
            peering_name=peering_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("ExpressRouteCircuitStats", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def list(self, resource_group_name: str, **kwargs: Any) -> AsyncIterable["_models.ExpressRouteCircuit"]:
        """Gets all the express route circuits in a resource group.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :return: An iterator like instance of either ExpressRouteCircuit or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.network.v2017_10_01.models.ExpressRouteCircuit]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[_models.ExpressRouteCircuitListResult] = kwargs.pop("cls", None)

        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_express_route_circuits_list_request(
                    resource_group_name=resource_group_name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)

            else:
                _request = HttpRequest("GET", next_link)
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("ExpressRouteCircuitListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace
    def list_all(self, **kwargs: Any) -> AsyncIterable["_models.ExpressRouteCircuit"]:
        """Gets all the express route circuits in a subscription.

        :return: An iterator like instance of either ExpressRouteCircuit or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.network.v2017_10_01.models.ExpressRouteCircuit]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[_models.ExpressRouteCircuitListResult] = kwargs.pop("cls", None)

        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_express_route_circuits_list_all_request(
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)

            else:
                _request = HttpRequest("GET", next_link)
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("ExpressRouteCircuitListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)


class ExpressRouteServiceProvidersOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.network.v2017_10_01.aio.NetworkManagementClient`'s
        :attr:`express_route_service_providers` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")
        self._api_version = input_args.pop(0) if input_args else kwargs.pop("api_version")

    @distributed_trace
    def list(self, **kwargs: Any) -> AsyncIterable["_models.ExpressRouteServiceProvider"]:
        """Gets all the available express route service providers.

        :return: An iterator like instance of either ExpressRouteServiceProvider or the result of
         cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.network.v2017_10_01.models.ExpressRouteServiceProvider]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[_models.ExpressRouteServiceProviderListResult] = kwargs.pop("cls", None)

        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_express_route_service_providers_list_request(
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)

            else:
                _request = HttpRequest("GET", next_link)
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("ExpressRouteServiceProviderListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)


class LoadBalancersOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.network.v2017_10_01.aio.NetworkManagementClient`'s
        :attr:`load_balancers` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")
        self._api_version = input_args.pop(0) if input_args else kwargs.pop("api_version")

    async def _delete_initial(  # pylint: disable=inconsistent-return-statements
        self, resource_group_name: str, load_balancer_name: str, **kwargs: Any
    ) -> None:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_load_balancers_delete_request(
            resource_group_name=resource_group_name,
            load_balancer_name=load_balancer_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def begin_delete(
        self, resource_group_name: str, load_balancer_name: str, **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Deletes the specified load balancer.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param load_balancer_name: The name of the load balancer. Required.
        :type load_balancer_name: str
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._delete_initial(  # type: ignore
                resource_group_name=resource_group_name,
                load_balancer_name=load_balancer_name,
                api_version=api_version,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})  # type: ignore

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[None].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[None](self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    @distributed_trace_async
    async def get(
        self, resource_group_name: str, load_balancer_name: str, *, expand: Optional[str] = None, **kwargs: Any
    ) -> _models.LoadBalancer:
        """Gets the specified load balancer.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param load_balancer_name: The name of the load balancer. Required.
        :type load_balancer_name: str
        :keyword expand: Expands referenced resources. Default value is None.
        :paramtype expand: str
        :return: LoadBalancer or the result of cls(response)
        :rtype: ~azure.mgmt.network.v2017_10_01.models.LoadBalancer
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[_models.LoadBalancer] = kwargs.pop("cls", None)

        _request = build_load_balancers_get_request(
            resource_group_name=resource_group_name,
            load_balancer_name=load_balancer_name,
            subscription_id=self._config.subscription_id,
            expand=expand,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("LoadBalancer", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    async def _create_or_update_initial(
        self,
        resource_group_name: str,
        load_balancer_name: str,
        parameters: Union[_models.LoadBalancer, IO[bytes]],
        **kwargs: Any
    ) -> _models.LoadBalancer:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.LoadBalancer] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IOBase, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "LoadBalancer")

        _request = build_load_balancers_create_or_update_request(
            resource_group_name=resource_group_name,
            load_balancer_name=load_balancer_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if response.status_code == 200:
            deserialized = self._deserialize("LoadBalancer", pipeline_response)

        if response.status_code == 201:
            deserialized = self._deserialize("LoadBalancer", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_create_or_update(
        self,
        resource_group_name: str,
        load_balancer_name: str,
        parameters: _models.LoadBalancer,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.LoadBalancer]:
        """Creates or updates a load balancer.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param load_balancer_name: The name of the load balancer. Required.
        :type load_balancer_name: str
        :param parameters: Parameters supplied to the create or update load balancer operation.
         Required.
        :type parameters: ~azure.mgmt.network.v2017_10_01.models.LoadBalancer
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either LoadBalancer or the result of
         cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.LoadBalancer]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_create_or_update(
        self,
        resource_group_name: str,
        load_balancer_name: str,
        parameters: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.LoadBalancer]:
        """Creates or updates a load balancer.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param load_balancer_name: The name of the load balancer. Required.
        :type load_balancer_name: str
        :param parameters: Parameters supplied to the create or update load balancer operation.
         Required.
        :type parameters: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Known values are: 'application/json', 'text/json'. Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either LoadBalancer or the result of
         cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.LoadBalancer]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_create_or_update(
        self,
        resource_group_name: str,
        load_balancer_name: str,
        parameters: Union[_models.LoadBalancer, IO[bytes]],
        **kwargs: Any
    ) -> AsyncLROPoller[_models.LoadBalancer]:
        """Creates or updates a load balancer.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param load_balancer_name: The name of the load balancer. Required.
        :type load_balancer_name: str
        :param parameters: Parameters supplied to the create or update load balancer operation. Is
         either a LoadBalancer type or a IO[bytes] type. Required.
        :type parameters: ~azure.mgmt.network.v2017_10_01.models.LoadBalancer or IO[bytes]
        :return: An instance of AsyncLROPoller that returns either LoadBalancer or the result of
         cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.LoadBalancer]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.LoadBalancer] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._create_or_update_initial(
                resource_group_name=resource_group_name,
                load_balancer_name=load_balancer_name,
                parameters=parameters,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("LoadBalancer", pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.LoadBalancer].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.LoadBalancer](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    async def _update_tags_initial(
        self,
        resource_group_name: str,
        load_balancer_name: str,
        parameters: Union[_models.TagsObject, IO[bytes]],
        **kwargs: Any
    ) -> _models.LoadBalancer:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.LoadBalancer] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IOBase, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "TagsObject")

        _request = build_load_balancers_update_tags_request(
            resource_group_name=resource_group_name,
            load_balancer_name=load_balancer_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("LoadBalancer", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_update_tags(
        self,
        resource_group_name: str,
        load_balancer_name: str,
        parameters: _models.TagsObject,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.LoadBalancer]:
        """Updates a load balancer tags.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param load_balancer_name: The name of the load balancer. Required.
        :type load_balancer_name: str
        :param parameters: Parameters supplied to update load balancer tags. Required.
        :type parameters: ~azure.mgmt.network.v2017_10_01.models.TagsObject
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either LoadBalancer or the result of
         cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.LoadBalancer]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_update_tags(
        self,
        resource_group_name: str,
        load_balancer_name: str,
        parameters: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.LoadBalancer]:
        """Updates a load balancer tags.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param load_balancer_name: The name of the load balancer. Required.
        :type load_balancer_name: str
        :param parameters: Parameters supplied to update load balancer tags. Required.
        :type parameters: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Known values are: 'application/json', 'text/json'. Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either LoadBalancer or the result of
         cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.LoadBalancer]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_update_tags(
        self,
        resource_group_name: str,
        load_balancer_name: str,
        parameters: Union[_models.TagsObject, IO[bytes]],
        **kwargs: Any
    ) -> AsyncLROPoller[_models.LoadBalancer]:
        """Updates a load balancer tags.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param load_balancer_name: The name of the load balancer. Required.
        :type load_balancer_name: str
        :param parameters: Parameters supplied to update load balancer tags. Is either a TagsObject
         type or a IO[bytes] type. Required.
        :type parameters: ~azure.mgmt.network.v2017_10_01.models.TagsObject or IO[bytes]
        :return: An instance of AsyncLROPoller that returns either LoadBalancer or the result of
         cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.LoadBalancer]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.LoadBalancer] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._update_tags_initial(
                resource_group_name=resource_group_name,
                load_balancer_name=load_balancer_name,
                parameters=parameters,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("LoadBalancer", pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.LoadBalancer].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.LoadBalancer](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    @distributed_trace
    def list_all(self, **kwargs: Any) -> AsyncIterable["_models.LoadBalancer"]:
        """Gets all the load balancers in a subscription.

        :return: An iterator like instance of either LoadBalancer or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.network.v2017_10_01.models.LoadBalancer]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[_models.LoadBalancerListResult] = kwargs.pop("cls", None)

        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_load_balancers_list_all_request(
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)

            else:
                _request = HttpRequest("GET", next_link)
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("LoadBalancerListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace
    def list(self, resource_group_name: str, **kwargs: Any) -> AsyncIterable["_models.LoadBalancer"]:
        """Gets all the load balancers in a resource group.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :return: An iterator like instance of either LoadBalancer or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.network.v2017_10_01.models.LoadBalancer]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[_models.LoadBalancerListResult] = kwargs.pop("cls", None)

        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_load_balancers_list_request(
                    resource_group_name=resource_group_name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)

            else:
                _request = HttpRequest("GET", next_link)
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("LoadBalancerListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)


class LoadBalancerBackendAddressPoolsOperations:  # pylint: disable=name-too-long
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.network.v2017_10_01.aio.NetworkManagementClient`'s
        :attr:`load_balancer_backend_address_pools` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")
        self._api_version = input_args.pop(0) if input_args else kwargs.pop("api_version")

    @distributed_trace
    def list(
        self, resource_group_name: str, load_balancer_name: str, **kwargs: Any
    ) -> AsyncIterable["_models.BackendAddressPool"]:
        """Gets all the load balancer backed address pools.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param load_balancer_name: The name of the load balancer. Required.
        :type load_balancer_name: str
        :return: An iterator like instance of either BackendAddressPool or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.network.v2017_10_01.models.BackendAddressPool]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[_models.LoadBalancerBackendAddressPoolListResult] = kwargs.pop("cls", None)

        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_load_balancer_backend_address_pools_list_request(
                    resource_group_name=resource_group_name,
                    load_balancer_name=load_balancer_name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)

            else:
                _request = HttpRequest("GET", next_link)
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("LoadBalancerBackendAddressPoolListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def get(
        self, resource_group_name: str, load_balancer_name: str, backend_address_pool_name: str, **kwargs: Any
    ) -> _models.BackendAddressPool:
        """Gets load balancer backend address pool.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param load_balancer_name: The name of the load balancer. Required.
        :type load_balancer_name: str
        :param backend_address_pool_name: The name of the backend address pool. Required.
        :type backend_address_pool_name: str
        :return: BackendAddressPool or the result of cls(response)
        :rtype: ~azure.mgmt.network.v2017_10_01.models.BackendAddressPool
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[_models.BackendAddressPool] = kwargs.pop("cls", None)

        _request = build_load_balancer_backend_address_pools_get_request(
            resource_group_name=resource_group_name,
            load_balancer_name=load_balancer_name,
            backend_address_pool_name=backend_address_pool_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("BackendAddressPool", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore


class LoadBalancerFrontendIPConfigurationsOperations:  # pylint: disable=name-too-long
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.network.v2017_10_01.aio.NetworkManagementClient`'s
        :attr:`load_balancer_frontend_ip_configurations` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")
        self._api_version = input_args.pop(0) if input_args else kwargs.pop("api_version")

    @distributed_trace
    def list(
        self, resource_group_name: str, load_balancer_name: str, **kwargs: Any
    ) -> AsyncIterable["_models.FrontendIPConfiguration"]:
        """Gets all the load balancer frontend IP configurations.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param load_balancer_name: The name of the load balancer. Required.
        :type load_balancer_name: str
        :return: An iterator like instance of either FrontendIPConfiguration or the result of
         cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.network.v2017_10_01.models.FrontendIPConfiguration]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[_models.LoadBalancerFrontendIPConfigurationListResult] = kwargs.pop("cls", None)

        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_load_balancer_frontend_ip_configurations_list_request(
                    resource_group_name=resource_group_name,
                    load_balancer_name=load_balancer_name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)

            else:
                _request = HttpRequest("GET", next_link)
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("LoadBalancerFrontendIPConfigurationListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def get(
        self, resource_group_name: str, load_balancer_name: str, frontend_ip_configuration_name: str, **kwargs: Any
    ) -> _models.FrontendIPConfiguration:
        """Gets load balancer frontend IP configuration.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param load_balancer_name: The name of the load balancer. Required.
        :type load_balancer_name: str
        :param frontend_ip_configuration_name: The name of the frontend IP configuration. Required.
        :type frontend_ip_configuration_name: str
        :return: FrontendIPConfiguration or the result of cls(response)
        :rtype: ~azure.mgmt.network.v2017_10_01.models.FrontendIPConfiguration
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[_models.FrontendIPConfiguration] = kwargs.pop("cls", None)

        _request = build_load_balancer_frontend_ip_configurations_get_request(
            resource_group_name=resource_group_name,
            load_balancer_name=load_balancer_name,
            frontend_ip_configuration_name=frontend_ip_configuration_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("FrontendIPConfiguration", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore


class InboundNatRulesOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.network.v2017_10_01.aio.NetworkManagementClient`'s
        :attr:`inbound_nat_rules` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")
        self._api_version = input_args.pop(0) if input_args else kwargs.pop("api_version")

    @distributed_trace
    def list(
        self, resource_group_name: str, load_balancer_name: str, **kwargs: Any
    ) -> AsyncIterable["_models.InboundNatRule"]:
        """Gets all the inbound nat rules in a load balancer.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param load_balancer_name: The name of the load balancer. Required.
        :type load_balancer_name: str
        :return: An iterator like instance of either InboundNatRule or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.network.v2017_10_01.models.InboundNatRule]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[_models.InboundNatRuleListResult] = kwargs.pop("cls", None)

        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_inbound_nat_rules_list_request(
                    resource_group_name=resource_group_name,
                    load_balancer_name=load_balancer_name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)

            else:
                _request = HttpRequest("GET", next_link)
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("InboundNatRuleListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    async def _delete_initial(  # pylint: disable=inconsistent-return-statements
        self, resource_group_name: str, load_balancer_name: str, inbound_nat_rule_name: str, **kwargs: Any
    ) -> None:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_inbound_nat_rules_delete_request(
            resource_group_name=resource_group_name,
            load_balancer_name=load_balancer_name,
            inbound_nat_rule_name=inbound_nat_rule_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def begin_delete(
        self, resource_group_name: str, load_balancer_name: str, inbound_nat_rule_name: str, **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Deletes the specified load balancer inbound nat rule.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param load_balancer_name: The name of the load balancer. Required.
        :type load_balancer_name: str
        :param inbound_nat_rule_name: The name of the inbound nat rule. Required.
        :type inbound_nat_rule_name: str
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._delete_initial(  # type: ignore
                resource_group_name=resource_group_name,
                load_balancer_name=load_balancer_name,
                inbound_nat_rule_name=inbound_nat_rule_name,
                api_version=api_version,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})  # type: ignore

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[None].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[None](self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    @distributed_trace_async
    async def get(
        self,
        resource_group_name: str,
        load_balancer_name: str,
        inbound_nat_rule_name: str,
        *,
        expand: Optional[str] = None,
        **kwargs: Any
    ) -> _models.InboundNatRule:
        """Gets the specified load balancer inbound nat rule.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param load_balancer_name: The name of the load balancer. Required.
        :type load_balancer_name: str
        :param inbound_nat_rule_name: The name of the inbound nat rule. Required.
        :type inbound_nat_rule_name: str
        :keyword expand: Expands referenced resources. Default value is None.
        :paramtype expand: str
        :return: InboundNatRule or the result of cls(response)
        :rtype: ~azure.mgmt.network.v2017_10_01.models.InboundNatRule
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[_models.InboundNatRule] = kwargs.pop("cls", None)

        _request = build_inbound_nat_rules_get_request(
            resource_group_name=resource_group_name,
            load_balancer_name=load_balancer_name,
            inbound_nat_rule_name=inbound_nat_rule_name,
            subscription_id=self._config.subscription_id,
            expand=expand,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("InboundNatRule", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    async def _create_or_update_initial(
        self,
        resource_group_name: str,
        load_balancer_name: str,
        inbound_nat_rule_name: str,
        inbound_nat_rule_parameters: Union[_models.InboundNatRule, IO[bytes]],
        **kwargs: Any
    ) -> _models.InboundNatRule:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.InboundNatRule] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(inbound_nat_rule_parameters, (IOBase, bytes)):
            _content = inbound_nat_rule_parameters
        else:
            _json = self._serialize.body(inbound_nat_rule_parameters, "InboundNatRule")

        _request = build_inbound_nat_rules_create_or_update_request(
            resource_group_name=resource_group_name,
            load_balancer_name=load_balancer_name,
            inbound_nat_rule_name=inbound_nat_rule_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if response.status_code == 200:
            deserialized = self._deserialize("InboundNatRule", pipeline_response)

        if response.status_code == 201:
            deserialized = self._deserialize("InboundNatRule", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_create_or_update(
        self,
        resource_group_name: str,
        load_balancer_name: str,
        inbound_nat_rule_name: str,
        inbound_nat_rule_parameters: _models.InboundNatRule,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.InboundNatRule]:
        """Creates or updates a load balancer inbound nat rule.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param load_balancer_name: The name of the load balancer. Required.
        :type load_balancer_name: str
        :param inbound_nat_rule_name: The name of the inbound nat rule. Required.
        :type inbound_nat_rule_name: str
        :param inbound_nat_rule_parameters: Parameters supplied to the create or update inbound nat
         rule operation. Required.
        :type inbound_nat_rule_parameters: ~azure.mgmt.network.v2017_10_01.models.InboundNatRule
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either InboundNatRule or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.InboundNatRule]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_create_or_update(
        self,
        resource_group_name: str,
        load_balancer_name: str,
        inbound_nat_rule_name: str,
        inbound_nat_rule_parameters: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.InboundNatRule]:
        """Creates or updates a load balancer inbound nat rule.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param load_balancer_name: The name of the load balancer. Required.
        :type load_balancer_name: str
        :param inbound_nat_rule_name: The name of the inbound nat rule. Required.
        :type inbound_nat_rule_name: str
        :param inbound_nat_rule_parameters: Parameters supplied to the create or update inbound nat
         rule operation. Required.
        :type inbound_nat_rule_parameters: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Known values are: 'application/json', 'text/json'. Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either InboundNatRule or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.InboundNatRule]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_create_or_update(
        self,
        resource_group_name: str,
        load_balancer_name: str,
        inbound_nat_rule_name: str,
        inbound_nat_rule_parameters: Union[_models.InboundNatRule, IO[bytes]],
        **kwargs: Any
    ) -> AsyncLROPoller[_models.InboundNatRule]:
        """Creates or updates a load balancer inbound nat rule.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param load_balancer_name: The name of the load balancer. Required.
        :type load_balancer_name: str
        :param inbound_nat_rule_name: The name of the inbound nat rule. Required.
        :type inbound_nat_rule_name: str
        :param inbound_nat_rule_parameters: Parameters supplied to the create or update inbound nat
         rule operation. Is either a InboundNatRule type or a IO[bytes] type. Required.
        :type inbound_nat_rule_parameters: ~azure.mgmt.network.v2017_10_01.models.InboundNatRule or
         IO[bytes]
        :return: An instance of AsyncLROPoller that returns either InboundNatRule or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.InboundNatRule]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.InboundNatRule] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._create_or_update_initial(
                resource_group_name=resource_group_name,
                load_balancer_name=load_balancer_name,
                inbound_nat_rule_name=inbound_nat_rule_name,
                inbound_nat_rule_parameters=inbound_nat_rule_parameters,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("InboundNatRule", pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.InboundNatRule].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.InboundNatRule](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )


class LoadBalancerLoadBalancingRulesOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.network.v2017_10_01.aio.NetworkManagementClient`'s
        :attr:`load_balancer_load_balancing_rules` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")
        self._api_version = input_args.pop(0) if input_args else kwargs.pop("api_version")

    @distributed_trace
    def list(
        self, resource_group_name: str, load_balancer_name: str, **kwargs: Any
    ) -> AsyncIterable["_models.LoadBalancingRule"]:
        """Gets all the load balancing rules in a load balancer.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param load_balancer_name: The name of the load balancer. Required.
        :type load_balancer_name: str
        :return: An iterator like instance of either LoadBalancingRule or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.network.v2017_10_01.models.LoadBalancingRule]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[_models.LoadBalancerLoadBalancingRuleListResult] = kwargs.pop("cls", None)

        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_load_balancer_load_balancing_rules_list_request(
                    resource_group_name=resource_group_name,
                    load_balancer_name=load_balancer_name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)

            else:
                _request = HttpRequest("GET", next_link)
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("LoadBalancerLoadBalancingRuleListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def get(
        self, resource_group_name: str, load_balancer_name: str, load_balancing_rule_name: str, **kwargs: Any
    ) -> _models.LoadBalancingRule:
        """Gets the specified load balancer load balancing rule.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param load_balancer_name: The name of the load balancer. Required.
        :type load_balancer_name: str
        :param load_balancing_rule_name: The name of the load balancing rule. Required.
        :type load_balancing_rule_name: str
        :return: LoadBalancingRule or the result of cls(response)
        :rtype: ~azure.mgmt.network.v2017_10_01.models.LoadBalancingRule
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[_models.LoadBalancingRule] = kwargs.pop("cls", None)

        _request = build_load_balancer_load_balancing_rules_get_request(
            resource_group_name=resource_group_name,
            load_balancer_name=load_balancer_name,
            load_balancing_rule_name=load_balancing_rule_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("LoadBalancingRule", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore


class LoadBalancerNetworkInterfacesOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.network.v2017_10_01.aio.NetworkManagementClient`'s
        :attr:`load_balancer_network_interfaces` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")
        self._api_version = input_args.pop(0) if input_args else kwargs.pop("api_version")

    @distributed_trace
    def list(
        self, resource_group_name: str, load_balancer_name: str, **kwargs: Any
    ) -> AsyncIterable["_models.NetworkInterface"]:
        """Gets associated load balancer network interfaces.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param load_balancer_name: The name of the load balancer. Required.
        :type load_balancer_name: str
        :return: An iterator like instance of either NetworkInterface or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.network.v2017_10_01.models.NetworkInterface]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[_models.NetworkInterfaceListResult] = kwargs.pop("cls", None)

        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_load_balancer_network_interfaces_list_request(
                    resource_group_name=resource_group_name,
                    load_balancer_name=load_balancer_name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)

            else:
                _request = HttpRequest("GET", next_link)
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("NetworkInterfaceListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)


class LoadBalancerProbesOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.network.v2017_10_01.aio.NetworkManagementClient`'s
        :attr:`load_balancer_probes` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")
        self._api_version = input_args.pop(0) if input_args else kwargs.pop("api_version")

    @distributed_trace
    def list(self, resource_group_name: str, load_balancer_name: str, **kwargs: Any) -> AsyncIterable["_models.Probe"]:
        """Gets all the load balancer probes.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param load_balancer_name: The name of the load balancer. Required.
        :type load_balancer_name: str
        :return: An iterator like instance of either Probe or the result of cls(response)
        :rtype: ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.network.v2017_10_01.models.Probe]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[_models.LoadBalancerProbeListResult] = kwargs.pop("cls", None)

        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_load_balancer_probes_list_request(
                    resource_group_name=resource_group_name,
                    load_balancer_name=load_balancer_name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)

            else:
                _request = HttpRequest("GET", next_link)
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("LoadBalancerProbeListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def get(
        self, resource_group_name: str, load_balancer_name: str, probe_name: str, **kwargs: Any
    ) -> _models.Probe:
        """Gets load balancer probe.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param load_balancer_name: The name of the load balancer. Required.
        :type load_balancer_name: str
        :param probe_name: The name of the probe. Required.
        :type probe_name: str
        :return: Probe or the result of cls(response)
        :rtype: ~azure.mgmt.network.v2017_10_01.models.Probe
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[_models.Probe] = kwargs.pop("cls", None)

        _request = build_load_balancer_probes_get_request(
            resource_group_name=resource_group_name,
            load_balancer_name=load_balancer_name,
            probe_name=probe_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("Probe", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore


class NetworkInterfacesOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.network.v2017_10_01.aio.NetworkManagementClient`'s
        :attr:`network_interfaces` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")
        self._api_version = input_args.pop(0) if input_args else kwargs.pop("api_version")

    async def _delete_initial(  # pylint: disable=inconsistent-return-statements
        self, resource_group_name: str, network_interface_name: str, **kwargs: Any
    ) -> None:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_network_interfaces_delete_request(
            resource_group_name=resource_group_name,
            network_interface_name=network_interface_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def begin_delete(
        self, resource_group_name: str, network_interface_name: str, **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Deletes the specified network interface.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param network_interface_name: The name of the network interface. Required.
        :type network_interface_name: str
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._delete_initial(  # type: ignore
                resource_group_name=resource_group_name,
                network_interface_name=network_interface_name,
                api_version=api_version,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})  # type: ignore

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[None].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[None](self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    @distributed_trace_async
    async def get(
        self, resource_group_name: str, network_interface_name: str, *, expand: Optional[str] = None, **kwargs: Any
    ) -> _models.NetworkInterface:
        """Gets information about the specified network interface.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param network_interface_name: The name of the network interface. Required.
        :type network_interface_name: str
        :keyword expand: Expands referenced resources. Default value is None.
        :paramtype expand: str
        :return: NetworkInterface or the result of cls(response)
        :rtype: ~azure.mgmt.network.v2017_10_01.models.NetworkInterface
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[_models.NetworkInterface] = kwargs.pop("cls", None)

        _request = build_network_interfaces_get_request(
            resource_group_name=resource_group_name,
            network_interface_name=network_interface_name,
            subscription_id=self._config.subscription_id,
            expand=expand,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("NetworkInterface", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    async def _create_or_update_initial(
        self,
        resource_group_name: str,
        network_interface_name: str,
        parameters: Union[_models.NetworkInterface, IO[bytes]],
        **kwargs: Any
    ) -> _models.NetworkInterface:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.NetworkInterface] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IOBase, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "NetworkInterface")

        _request = build_network_interfaces_create_or_update_request(
            resource_group_name=resource_group_name,
            network_interface_name=network_interface_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if response.status_code == 200:
            deserialized = self._deserialize("NetworkInterface", pipeline_response)

        if response.status_code == 201:
            deserialized = self._deserialize("NetworkInterface", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_create_or_update(
        self,
        resource_group_name: str,
        network_interface_name: str,
        parameters: _models.NetworkInterface,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.NetworkInterface]:
        """Creates or updates a network interface.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param network_interface_name: The name of the network interface. Required.
        :type network_interface_name: str
        :param parameters: Parameters supplied to the create or update network interface operation.
         Required.
        :type parameters: ~azure.mgmt.network.v2017_10_01.models.NetworkInterface
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either NetworkInterface or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.NetworkInterface]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_create_or_update(
        self,
        resource_group_name: str,
        network_interface_name: str,
        parameters: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.NetworkInterface]:
        """Creates or updates a network interface.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param network_interface_name: The name of the network interface. Required.
        :type network_interface_name: str
        :param parameters: Parameters supplied to the create or update network interface operation.
         Required.
        :type parameters: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Known values are: 'application/json', 'text/json'. Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either NetworkInterface or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.NetworkInterface]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_create_or_update(
        self,
        resource_group_name: str,
        network_interface_name: str,
        parameters: Union[_models.NetworkInterface, IO[bytes]],
        **kwargs: Any
    ) -> AsyncLROPoller[_models.NetworkInterface]:
        """Creates or updates a network interface.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param network_interface_name: The name of the network interface. Required.
        :type network_interface_name: str
        :param parameters: Parameters supplied to the create or update network interface operation. Is
         either a NetworkInterface type or a IO[bytes] type. Required.
        :type parameters: ~azure.mgmt.network.v2017_10_01.models.NetworkInterface or IO[bytes]
        :return: An instance of AsyncLROPoller that returns either NetworkInterface or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.NetworkInterface]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.NetworkInterface] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._create_or_update_initial(
                resource_group_name=resource_group_name,
                network_interface_name=network_interface_name,
                parameters=parameters,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("NetworkInterface", pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.NetworkInterface].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.NetworkInterface](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    async def _update_tags_initial(
        self,
        resource_group_name: str,
        network_interface_name: str,
        parameters: Union[_models.TagsObject, IO[bytes]],
        **kwargs: Any
    ) -> _models.NetworkInterface:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.NetworkInterface] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IOBase, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "TagsObject")

        _request = build_network_interfaces_update_tags_request(
            resource_group_name=resource_group_name,
            network_interface_name=network_interface_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("NetworkInterface", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_update_tags(
        self,
        resource_group_name: str,
        network_interface_name: str,
        parameters: _models.TagsObject,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.NetworkInterface]:
        """Updates a network interface tags.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param network_interface_name: The name of the network interface. Required.
        :type network_interface_name: str
        :param parameters: Parameters supplied to update network interface tags. Required.
        :type parameters: ~azure.mgmt.network.v2017_10_01.models.TagsObject
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either NetworkInterface or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.NetworkInterface]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_update_tags(
        self,
        resource_group_name: str,
        network_interface_name: str,
        parameters: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.NetworkInterface]:
        """Updates a network interface tags.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param network_interface_name: The name of the network interface. Required.
        :type network_interface_name: str
        :param parameters: Parameters supplied to update network interface tags. Required.
        :type parameters: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Known values are: 'application/json', 'text/json'. Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either NetworkInterface or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.NetworkInterface]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_update_tags(
        self,
        resource_group_name: str,
        network_interface_name: str,
        parameters: Union[_models.TagsObject, IO[bytes]],
        **kwargs: Any
    ) -> AsyncLROPoller[_models.NetworkInterface]:
        """Updates a network interface tags.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param network_interface_name: The name of the network interface. Required.
        :type network_interface_name: str
        :param parameters: Parameters supplied to update network interface tags. Is either a TagsObject
         type or a IO[bytes] type. Required.
        :type parameters: ~azure.mgmt.network.v2017_10_01.models.TagsObject or IO[bytes]
        :return: An instance of AsyncLROPoller that returns either NetworkInterface or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.NetworkInterface]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.NetworkInterface] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._update_tags_initial(
                resource_group_name=resource_group_name,
                network_interface_name=network_interface_name,
                parameters=parameters,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("NetworkInterface", pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.NetworkInterface].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.NetworkInterface](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    @distributed_trace
    def list_all(self, **kwargs: Any) -> AsyncIterable["_models.NetworkInterface"]:
        """Gets all network interfaces in a subscription.

        :return: An iterator like instance of either NetworkInterface or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.network.v2017_10_01.models.NetworkInterface]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[_models.NetworkInterfaceListResult] = kwargs.pop("cls", None)

        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_network_interfaces_list_all_request(
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)

            else:
                _request = HttpRequest("GET", next_link)
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("NetworkInterfaceListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace
    def list(self, resource_group_name: str, **kwargs: Any) -> AsyncIterable["_models.NetworkInterface"]:
        """Gets all network interfaces in a resource group.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :return: An iterator like instance of either NetworkInterface or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.network.v2017_10_01.models.NetworkInterface]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[_models.NetworkInterfaceListResult] = kwargs.pop("cls", None)

        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_network_interfaces_list_request(
                    resource_group_name=resource_group_name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)

            else:
                _request = HttpRequest("GET", next_link)
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("NetworkInterfaceListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    async def _get_effective_route_table_initial(
        self, resource_group_name: str, network_interface_name: str, **kwargs: Any
    ) -> Optional[_models.EffectiveRouteListResult]:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[Optional[_models.EffectiveRouteListResult]] = kwargs.pop("cls", None)

        _request = build_network_interfaces_get_effective_route_table_request(
            resource_group_name=resource_group_name,
            network_interface_name=network_interface_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize("EffectiveRouteListResult", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def begin_get_effective_route_table(
        self, resource_group_name: str, network_interface_name: str, **kwargs: Any
    ) -> AsyncLROPoller[_models.EffectiveRouteListResult]:
        """Gets all route tables applied to a network interface.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param network_interface_name: The name of the network interface. Required.
        :type network_interface_name: str
        :return: An instance of AsyncLROPoller that returns either EffectiveRouteListResult or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.EffectiveRouteListResult]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[_models.EffectiveRouteListResult] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._get_effective_route_table_initial(
                resource_group_name=resource_group_name,
                network_interface_name=network_interface_name,
                api_version=api_version,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("EffectiveRouteListResult", pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.EffectiveRouteListResult].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.EffectiveRouteListResult](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    async def _list_effective_network_security_groups_initial(  # pylint: disable=name-too-long
        self, resource_group_name: str, network_interface_name: str, **kwargs: Any
    ) -> Optional[_models.EffectiveNetworkSecurityGroupListResult]:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[Optional[_models.EffectiveNetworkSecurityGroupListResult]] = kwargs.pop("cls", None)

        _request = build_network_interfaces_list_effective_network_security_groups_request(
            resource_group_name=resource_group_name,
            network_interface_name=network_interface_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize("EffectiveNetworkSecurityGroupListResult", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def begin_list_effective_network_security_groups(  # pylint: disable=name-too-long
        self, resource_group_name: str, network_interface_name: str, **kwargs: Any
    ) -> AsyncLROPoller[_models.EffectiveNetworkSecurityGroupListResult]:
        """Gets all network security groups applied to a network interface.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param network_interface_name: The name of the network interface. Required.
        :type network_interface_name: str
        :return: An instance of AsyncLROPoller that returns either
         EffectiveNetworkSecurityGroupListResult or the result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.EffectiveNetworkSecurityGroupListResult]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[_models.EffectiveNetworkSecurityGroupListResult] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._list_effective_network_security_groups_initial(
                resource_group_name=resource_group_name,
                network_interface_name=network_interface_name,
                api_version=api_version,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("EffectiveNetworkSecurityGroupListResult", pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.EffectiveNetworkSecurityGroupListResult].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.EffectiveNetworkSecurityGroupListResult](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    @distributed_trace
    def list_virtual_machine_scale_set_vm_network_interfaces(  # pylint: disable=name-too-long
        self, resource_group_name: str, virtual_machine_scale_set_name: str, virtualmachine_index: str, **kwargs: Any
    ) -> AsyncIterable["_models.NetworkInterface"]:
        """Gets information about all network interfaces in a virtual machine in a virtual machine scale
        set.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param virtual_machine_scale_set_name: The name of the virtual machine scale set. Required.
        :type virtual_machine_scale_set_name: str
        :param virtualmachine_index: The virtual machine index. Required.
        :type virtualmachine_index: str
        :return: An iterator like instance of either NetworkInterface or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.network.v2017_10_01.models.NetworkInterface]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-03-30"))
        cls: ClsType[_models.NetworkInterfaceListResult] = kwargs.pop("cls", None)

        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_network_interfaces_list_virtual_machine_scale_set_vm_network_interfaces_request(
                    resource_group_name=resource_group_name,
                    virtual_machine_scale_set_name=virtual_machine_scale_set_name,
                    virtualmachine_index=virtualmachine_index,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)

            else:
                _request = HttpRequest("GET", next_link)
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("NetworkInterfaceListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace
    def list_virtual_machine_scale_set_network_interfaces(  # pylint: disable=name-too-long
        self, resource_group_name: str, virtual_machine_scale_set_name: str, **kwargs: Any
    ) -> AsyncIterable["_models.NetworkInterface"]:
        """Gets all network interfaces in a virtual machine scale set.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param virtual_machine_scale_set_name: The name of the virtual machine scale set. Required.
        :type virtual_machine_scale_set_name: str
        :return: An iterator like instance of either NetworkInterface or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.network.v2017_10_01.models.NetworkInterface]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-03-30"))
        cls: ClsType[_models.NetworkInterfaceListResult] = kwargs.pop("cls", None)

        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_network_interfaces_list_virtual_machine_scale_set_network_interfaces_request(
                    resource_group_name=resource_group_name,
                    virtual_machine_scale_set_name=virtual_machine_scale_set_name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)

            else:
                _request = HttpRequest("GET", next_link)
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("NetworkInterfaceListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def get_virtual_machine_scale_set_network_interface(  # pylint: disable=name-too-long
        self,
        resource_group_name: str,
        virtual_machine_scale_set_name: str,
        virtualmachine_index: str,
        network_interface_name: str,
        *,
        expand: Optional[str] = None,
        **kwargs: Any
    ) -> _models.NetworkInterface:
        """Get the specified network interface in a virtual machine scale set.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param virtual_machine_scale_set_name: The name of the virtual machine scale set. Required.
        :type virtual_machine_scale_set_name: str
        :param virtualmachine_index: The virtual machine index. Required.
        :type virtualmachine_index: str
        :param network_interface_name: The name of the network interface. Required.
        :type network_interface_name: str
        :keyword expand: Expands referenced resources. Default value is None.
        :paramtype expand: str
        :return: NetworkInterface or the result of cls(response)
        :rtype: ~azure.mgmt.network.v2017_10_01.models.NetworkInterface
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-03-30"))
        cls: ClsType[_models.NetworkInterface] = kwargs.pop("cls", None)

        _request = build_network_interfaces_get_virtual_machine_scale_set_network_interface_request(
            resource_group_name=resource_group_name,
            virtual_machine_scale_set_name=virtual_machine_scale_set_name,
            virtualmachine_index=virtualmachine_index,
            network_interface_name=network_interface_name,
            subscription_id=self._config.subscription_id,
            expand=expand,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("NetworkInterface", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def list_virtual_machine_scale_set_ip_configurations(  # pylint: disable=name-too-long
        self,
        resource_group_name: str,
        virtual_machine_scale_set_name: str,
        virtualmachine_index: str,
        network_interface_name: str,
        *,
        expand: Optional[str] = None,
        **kwargs: Any
    ) -> AsyncIterable["_models.NetworkInterfaceIPConfiguration"]:
        """Get the specified network interface ip configuration in a virtual machine scale set.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param virtual_machine_scale_set_name: The name of the virtual machine scale set. Required.
        :type virtual_machine_scale_set_name: str
        :param virtualmachine_index: The virtual machine index. Required.
        :type virtualmachine_index: str
        :param network_interface_name: The name of the network interface. Required.
        :type network_interface_name: str
        :keyword expand: Expands referenced resources. Default value is None.
        :paramtype expand: str
        :return: An iterator like instance of either NetworkInterfaceIPConfiguration or the result of
         cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.network.v2017_10_01.models.NetworkInterfaceIPConfiguration]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-03-30"))
        cls: ClsType[_models.NetworkInterfaceIPConfigurationListResult] = kwargs.pop("cls", None)

        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_network_interfaces_list_virtual_machine_scale_set_ip_configurations_request(
                    resource_group_name=resource_group_name,
                    virtual_machine_scale_set_name=virtual_machine_scale_set_name,
                    virtualmachine_index=virtualmachine_index,
                    network_interface_name=network_interface_name,
                    subscription_id=self._config.subscription_id,
                    expand=expand,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)

            else:
                _request = HttpRequest("GET", next_link)
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("NetworkInterfaceIPConfigurationListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def get_virtual_machine_scale_set_ip_configuration(  # pylint: disable=name-too-long
        self,
        resource_group_name: str,
        virtual_machine_scale_set_name: str,
        virtualmachine_index: str,
        network_interface_name: str,
        ip_configuration_name: str,
        *,
        expand: Optional[str] = None,
        **kwargs: Any
    ) -> _models.NetworkInterfaceIPConfiguration:
        """Get the specified network interface ip configuration in a virtual machine scale set.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param virtual_machine_scale_set_name: The name of the virtual machine scale set. Required.
        :type virtual_machine_scale_set_name: str
        :param virtualmachine_index: The virtual machine index. Required.
        :type virtualmachine_index: str
        :param network_interface_name: The name of the network interface. Required.
        :type network_interface_name: str
        :param ip_configuration_name: The name of the ip configuration. Required.
        :type ip_configuration_name: str
        :keyword expand: Expands referenced resources. Default value is None.
        :paramtype expand: str
        :return: NetworkInterfaceIPConfiguration or the result of cls(response)
        :rtype: ~azure.mgmt.network.v2017_10_01.models.NetworkInterfaceIPConfiguration
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-03-30"))
        cls: ClsType[_models.NetworkInterfaceIPConfiguration] = kwargs.pop("cls", None)

        _request = build_network_interfaces_get_virtual_machine_scale_set_ip_configuration_request(
            resource_group_name=resource_group_name,
            virtual_machine_scale_set_name=virtual_machine_scale_set_name,
            virtualmachine_index=virtualmachine_index,
            network_interface_name=network_interface_name,
            ip_configuration_name=ip_configuration_name,
            subscription_id=self._config.subscription_id,
            expand=expand,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("NetworkInterfaceIPConfiguration", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore


class NetworkInterfaceIPConfigurationsOperations:  # pylint: disable=name-too-long
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.network.v2017_10_01.aio.NetworkManagementClient`'s
        :attr:`network_interface_ip_configurations` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")
        self._api_version = input_args.pop(0) if input_args else kwargs.pop("api_version")

    @distributed_trace
    def list(
        self, resource_group_name: str, network_interface_name: str, **kwargs: Any
    ) -> AsyncIterable["_models.NetworkInterfaceIPConfiguration"]:
        """Get all ip configurations in a network interface.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param network_interface_name: The name of the network interface. Required.
        :type network_interface_name: str
        :return: An iterator like instance of either NetworkInterfaceIPConfiguration or the result of
         cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.network.v2017_10_01.models.NetworkInterfaceIPConfiguration]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[_models.NetworkInterfaceIPConfigurationListResult] = kwargs.pop("cls", None)

        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_network_interface_ip_configurations_list_request(
                    resource_group_name=resource_group_name,
                    network_interface_name=network_interface_name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)

            else:
                _request = HttpRequest("GET", next_link)
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("NetworkInterfaceIPConfigurationListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def get(
        self, resource_group_name: str, network_interface_name: str, ip_configuration_name: str, **kwargs: Any
    ) -> _models.NetworkInterfaceIPConfiguration:
        """Gets the specified network interface ip configuration.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param network_interface_name: The name of the network interface. Required.
        :type network_interface_name: str
        :param ip_configuration_name: The name of the ip configuration name. Required.
        :type ip_configuration_name: str
        :return: NetworkInterfaceIPConfiguration or the result of cls(response)
        :rtype: ~azure.mgmt.network.v2017_10_01.models.NetworkInterfaceIPConfiguration
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[_models.NetworkInterfaceIPConfiguration] = kwargs.pop("cls", None)

        _request = build_network_interface_ip_configurations_get_request(
            resource_group_name=resource_group_name,
            network_interface_name=network_interface_name,
            ip_configuration_name=ip_configuration_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("NetworkInterfaceIPConfiguration", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore


class NetworkInterfaceLoadBalancersOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.network.v2017_10_01.aio.NetworkManagementClient`'s
        :attr:`network_interface_load_balancers` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")
        self._api_version = input_args.pop(0) if input_args else kwargs.pop("api_version")

    @distributed_trace
    def list(
        self, resource_group_name: str, network_interface_name: str, **kwargs: Any
    ) -> AsyncIterable["_models.LoadBalancer"]:
        """List all load balancers in a network interface.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param network_interface_name: The name of the network interface. Required.
        :type network_interface_name: str
        :return: An iterator like instance of either LoadBalancer or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.network.v2017_10_01.models.LoadBalancer]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[_models.NetworkInterfaceLoadBalancerListResult] = kwargs.pop("cls", None)

        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_network_interface_load_balancers_list_request(
                    resource_group_name=resource_group_name,
                    network_interface_name=network_interface_name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)

            else:
                _request = HttpRequest("GET", next_link)
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("NetworkInterfaceLoadBalancerListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)


class NetworkSecurityGroupsOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.network.v2017_10_01.aio.NetworkManagementClient`'s
        :attr:`network_security_groups` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")
        self._api_version = input_args.pop(0) if input_args else kwargs.pop("api_version")

    async def _delete_initial(  # pylint: disable=inconsistent-return-statements
        self, resource_group_name: str, network_security_group_name: str, **kwargs: Any
    ) -> None:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_network_security_groups_delete_request(
            resource_group_name=resource_group_name,
            network_security_group_name=network_security_group_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def begin_delete(
        self, resource_group_name: str, network_security_group_name: str, **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Deletes the specified network security group.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param network_security_group_name: The name of the network security group. Required.
        :type network_security_group_name: str
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._delete_initial(  # type: ignore
                resource_group_name=resource_group_name,
                network_security_group_name=network_security_group_name,
                api_version=api_version,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})  # type: ignore

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[None].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[None](self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    @distributed_trace_async
    async def get(
        self, resource_group_name: str, network_security_group_name: str, *, expand: Optional[str] = None, **kwargs: Any
    ) -> _models.NetworkSecurityGroup:
        """Gets the specified network security group.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param network_security_group_name: The name of the network security group. Required.
        :type network_security_group_name: str
        :keyword expand: Expands referenced resources. Default value is None.
        :paramtype expand: str
        :return: NetworkSecurityGroup or the result of cls(response)
        :rtype: ~azure.mgmt.network.v2017_10_01.models.NetworkSecurityGroup
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[_models.NetworkSecurityGroup] = kwargs.pop("cls", None)

        _request = build_network_security_groups_get_request(
            resource_group_name=resource_group_name,
            network_security_group_name=network_security_group_name,
            subscription_id=self._config.subscription_id,
            expand=expand,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("NetworkSecurityGroup", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    async def _create_or_update_initial(
        self,
        resource_group_name: str,
        network_security_group_name: str,
        parameters: Union[_models.NetworkSecurityGroup, IO[bytes]],
        **kwargs: Any
    ) -> _models.NetworkSecurityGroup:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.NetworkSecurityGroup] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IOBase, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "NetworkSecurityGroup")

        _request = build_network_security_groups_create_or_update_request(
            resource_group_name=resource_group_name,
            network_security_group_name=network_security_group_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if response.status_code == 200:
            deserialized = self._deserialize("NetworkSecurityGroup", pipeline_response)

        if response.status_code == 201:
            deserialized = self._deserialize("NetworkSecurityGroup", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_create_or_update(
        self,
        resource_group_name: str,
        network_security_group_name: str,
        parameters: _models.NetworkSecurityGroup,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.NetworkSecurityGroup]:
        """Creates or updates a network security group in the specified resource group.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param network_security_group_name: The name of the network security group. Required.
        :type network_security_group_name: str
        :param parameters: Parameters supplied to the create or update network security group
         operation. Required.
        :type parameters: ~azure.mgmt.network.v2017_10_01.models.NetworkSecurityGroup
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either NetworkSecurityGroup or the result
         of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.NetworkSecurityGroup]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_create_or_update(
        self,
        resource_group_name: str,
        network_security_group_name: str,
        parameters: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.NetworkSecurityGroup]:
        """Creates or updates a network security group in the specified resource group.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param network_security_group_name: The name of the network security group. Required.
        :type network_security_group_name: str
        :param parameters: Parameters supplied to the create or update network security group
         operation. Required.
        :type parameters: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Known values are: 'application/json', 'text/json'. Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either NetworkSecurityGroup or the result
         of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.NetworkSecurityGroup]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_create_or_update(
        self,
        resource_group_name: str,
        network_security_group_name: str,
        parameters: Union[_models.NetworkSecurityGroup, IO[bytes]],
        **kwargs: Any
    ) -> AsyncLROPoller[_models.NetworkSecurityGroup]:
        """Creates or updates a network security group in the specified resource group.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param network_security_group_name: The name of the network security group. Required.
        :type network_security_group_name: str
        :param parameters: Parameters supplied to the create or update network security group
         operation. Is either a NetworkSecurityGroup type or a IO[bytes] type. Required.
        :type parameters: ~azure.mgmt.network.v2017_10_01.models.NetworkSecurityGroup or IO[bytes]
        :return: An instance of AsyncLROPoller that returns either NetworkSecurityGroup or the result
         of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.NetworkSecurityGroup]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.NetworkSecurityGroup] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._create_or_update_initial(
                resource_group_name=resource_group_name,
                network_security_group_name=network_security_group_name,
                parameters=parameters,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("NetworkSecurityGroup", pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.NetworkSecurityGroup].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.NetworkSecurityGroup](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    async def _update_tags_initial(
        self,
        resource_group_name: str,
        network_security_group_name: str,
        parameters: Union[_models.TagsObject, IO[bytes]],
        **kwargs: Any
    ) -> _models.NetworkSecurityGroup:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.NetworkSecurityGroup] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IOBase, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "TagsObject")

        _request = build_network_security_groups_update_tags_request(
            resource_group_name=resource_group_name,
            network_security_group_name=network_security_group_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("NetworkSecurityGroup", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_update_tags(
        self,
        resource_group_name: str,
        network_security_group_name: str,
        parameters: _models.TagsObject,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.NetworkSecurityGroup]:
        """Updates a network security group tags.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param network_security_group_name: The name of the network security group. Required.
        :type network_security_group_name: str
        :param parameters: Parameters supplied to update network security group tags. Required.
        :type parameters: ~azure.mgmt.network.v2017_10_01.models.TagsObject
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either NetworkSecurityGroup or the result
         of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.NetworkSecurityGroup]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_update_tags(
        self,
        resource_group_name: str,
        network_security_group_name: str,
        parameters: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.NetworkSecurityGroup]:
        """Updates a network security group tags.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param network_security_group_name: The name of the network security group. Required.
        :type network_security_group_name: str
        :param parameters: Parameters supplied to update network security group tags. Required.
        :type parameters: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Known values are: 'application/json', 'text/json'. Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either NetworkSecurityGroup or the result
         of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.NetworkSecurityGroup]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_update_tags(
        self,
        resource_group_name: str,
        network_security_group_name: str,
        parameters: Union[_models.TagsObject, IO[bytes]],
        **kwargs: Any
    ) -> AsyncLROPoller[_models.NetworkSecurityGroup]:
        """Updates a network security group tags.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param network_security_group_name: The name of the network security group. Required.
        :type network_security_group_name: str
        :param parameters: Parameters supplied to update network security group tags. Is either a
         TagsObject type or a IO[bytes] type. Required.
        :type parameters: ~azure.mgmt.network.v2017_10_01.models.TagsObject or IO[bytes]
        :return: An instance of AsyncLROPoller that returns either NetworkSecurityGroup or the result
         of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.NetworkSecurityGroup]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.NetworkSecurityGroup] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._update_tags_initial(
                resource_group_name=resource_group_name,
                network_security_group_name=network_security_group_name,
                parameters=parameters,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("NetworkSecurityGroup", pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.NetworkSecurityGroup].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.NetworkSecurityGroup](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    @distributed_trace
    def list_all(self, **kwargs: Any) -> AsyncIterable["_models.NetworkSecurityGroup"]:
        """Gets all network security groups in a subscription.

        :return: An iterator like instance of either NetworkSecurityGroup or the result of
         cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.network.v2017_10_01.models.NetworkSecurityGroup]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[_models.NetworkSecurityGroupListResult] = kwargs.pop("cls", None)

        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_network_security_groups_list_all_request(
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)

            else:
                _request = HttpRequest("GET", next_link)
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("NetworkSecurityGroupListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace
    def list(self, resource_group_name: str, **kwargs: Any) -> AsyncIterable["_models.NetworkSecurityGroup"]:
        """Gets all network security groups in a resource group.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :return: An iterator like instance of either NetworkSecurityGroup or the result of
         cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.network.v2017_10_01.models.NetworkSecurityGroup]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[_models.NetworkSecurityGroupListResult] = kwargs.pop("cls", None)

        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_network_security_groups_list_request(
                    resource_group_name=resource_group_name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)

            else:
                _request = HttpRequest("GET", next_link)
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("NetworkSecurityGroupListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)


class SecurityRulesOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.network.v2017_10_01.aio.NetworkManagementClient`'s
        :attr:`security_rules` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")
        self._api_version = input_args.pop(0) if input_args else kwargs.pop("api_version")

    async def _delete_initial(  # pylint: disable=inconsistent-return-statements
        self, resource_group_name: str, network_security_group_name: str, security_rule_name: str, **kwargs: Any
    ) -> None:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_security_rules_delete_request(
            resource_group_name=resource_group_name,
            network_security_group_name=network_security_group_name,
            security_rule_name=security_rule_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def begin_delete(
        self, resource_group_name: str, network_security_group_name: str, security_rule_name: str, **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Deletes the specified network security rule.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param network_security_group_name: The name of the network security group. Required.
        :type network_security_group_name: str
        :param security_rule_name: The name of the security rule. Required.
        :type security_rule_name: str
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._delete_initial(  # type: ignore
                resource_group_name=resource_group_name,
                network_security_group_name=network_security_group_name,
                security_rule_name=security_rule_name,
                api_version=api_version,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})  # type: ignore

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[None].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[None](self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    @distributed_trace_async
    async def get(
        self, resource_group_name: str, network_security_group_name: str, security_rule_name: str, **kwargs: Any
    ) -> _models.SecurityRule:
        """Get the specified network security rule.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param network_security_group_name: The name of the network security group. Required.
        :type network_security_group_name: str
        :param security_rule_name: The name of the security rule. Required.
        :type security_rule_name: str
        :return: SecurityRule or the result of cls(response)
        :rtype: ~azure.mgmt.network.v2017_10_01.models.SecurityRule
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[_models.SecurityRule] = kwargs.pop("cls", None)

        _request = build_security_rules_get_request(
            resource_group_name=resource_group_name,
            network_security_group_name=network_security_group_name,
            security_rule_name=security_rule_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("SecurityRule", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    async def _create_or_update_initial(
        self,
        resource_group_name: str,
        network_security_group_name: str,
        security_rule_name: str,
        security_rule_parameters: Union[_models.SecurityRule, IO[bytes]],
        **kwargs: Any
    ) -> _models.SecurityRule:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.SecurityRule] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(security_rule_parameters, (IOBase, bytes)):
            _content = security_rule_parameters
        else:
            _json = self._serialize.body(security_rule_parameters, "SecurityRule")

        _request = build_security_rules_create_or_update_request(
            resource_group_name=resource_group_name,
            network_security_group_name=network_security_group_name,
            security_rule_name=security_rule_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if response.status_code == 200:
            deserialized = self._deserialize("SecurityRule", pipeline_response)

        if response.status_code == 201:
            deserialized = self._deserialize("SecurityRule", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_create_or_update(
        self,
        resource_group_name: str,
        network_security_group_name: str,
        security_rule_name: str,
        security_rule_parameters: _models.SecurityRule,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.SecurityRule]:
        """Creates or updates a security rule in the specified network security group.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param network_security_group_name: The name of the network security group. Required.
        :type network_security_group_name: str
        :param security_rule_name: The name of the security rule. Required.
        :type security_rule_name: str
        :param security_rule_parameters: Parameters supplied to the create or update network security
         rule operation. Required.
        :type security_rule_parameters: ~azure.mgmt.network.v2017_10_01.models.SecurityRule
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either SecurityRule or the result of
         cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.SecurityRule]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_create_or_update(
        self,
        resource_group_name: str,
        network_security_group_name: str,
        security_rule_name: str,
        security_rule_parameters: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.SecurityRule]:
        """Creates or updates a security rule in the specified network security group.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param network_security_group_name: The name of the network security group. Required.
        :type network_security_group_name: str
        :param security_rule_name: The name of the security rule. Required.
        :type security_rule_name: str
        :param security_rule_parameters: Parameters supplied to the create or update network security
         rule operation. Required.
        :type security_rule_parameters: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Known values are: 'application/json', 'text/json'. Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either SecurityRule or the result of
         cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.SecurityRule]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_create_or_update(
        self,
        resource_group_name: str,
        network_security_group_name: str,
        security_rule_name: str,
        security_rule_parameters: Union[_models.SecurityRule, IO[bytes]],
        **kwargs: Any
    ) -> AsyncLROPoller[_models.SecurityRule]:
        """Creates or updates a security rule in the specified network security group.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param network_security_group_name: The name of the network security group. Required.
        :type network_security_group_name: str
        :param security_rule_name: The name of the security rule. Required.
        :type security_rule_name: str
        :param security_rule_parameters: Parameters supplied to the create or update network security
         rule operation. Is either a SecurityRule type or a IO[bytes] type. Required.
        :type security_rule_parameters: ~azure.mgmt.network.v2017_10_01.models.SecurityRule or
         IO[bytes]
        :return: An instance of AsyncLROPoller that returns either SecurityRule or the result of
         cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.SecurityRule]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.SecurityRule] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._create_or_update_initial(
                resource_group_name=resource_group_name,
                network_security_group_name=network_security_group_name,
                security_rule_name=security_rule_name,
                security_rule_parameters=security_rule_parameters,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("SecurityRule", pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.SecurityRule].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.SecurityRule](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    @distributed_trace
    def list(
        self, resource_group_name: str, network_security_group_name: str, **kwargs: Any
    ) -> AsyncIterable["_models.SecurityRule"]:
        """Gets all security rules in a network security group.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param network_security_group_name: The name of the network security group. Required.
        :type network_security_group_name: str
        :return: An iterator like instance of either SecurityRule or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.network.v2017_10_01.models.SecurityRule]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[_models.SecurityRuleListResult] = kwargs.pop("cls", None)

        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_security_rules_list_request(
                    resource_group_name=resource_group_name,
                    network_security_group_name=network_security_group_name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)

            else:
                _request = HttpRequest("GET", next_link)
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("SecurityRuleListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)


class DefaultSecurityRulesOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.network.v2017_10_01.aio.NetworkManagementClient`'s
        :attr:`default_security_rules` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")
        self._api_version = input_args.pop(0) if input_args else kwargs.pop("api_version")

    @distributed_trace
    def list(
        self, resource_group_name: str, network_security_group_name: str, **kwargs: Any
    ) -> AsyncIterable["_models.SecurityRule"]:
        """Gets all default security rules in a network security group.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param network_security_group_name: The name of the network security group. Required.
        :type network_security_group_name: str
        :return: An iterator like instance of either SecurityRule or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.network.v2017_10_01.models.SecurityRule]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[_models.SecurityRuleListResult] = kwargs.pop("cls", None)

        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_default_security_rules_list_request(
                    resource_group_name=resource_group_name,
                    network_security_group_name=network_security_group_name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)

            else:
                _request = HttpRequest("GET", next_link)
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("SecurityRuleListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def get(
        self, resource_group_name: str, network_security_group_name: str, default_security_rule_name: str, **kwargs: Any
    ) -> _models.SecurityRule:
        """Get the specified default network security rule.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param network_security_group_name: The name of the network security group. Required.
        :type network_security_group_name: str
        :param default_security_rule_name: The name of the default security rule. Required.
        :type default_security_rule_name: str
        :return: SecurityRule or the result of cls(response)
        :rtype: ~azure.mgmt.network.v2017_10_01.models.SecurityRule
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[_models.SecurityRule] = kwargs.pop("cls", None)

        _request = build_default_security_rules_get_request(
            resource_group_name=resource_group_name,
            network_security_group_name=network_security_group_name,
            default_security_rule_name=default_security_rule_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("SecurityRule", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore


class NetworkWatchersOperations:  # pylint: disable=too-many-public-methods
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.network.v2017_10_01.aio.NetworkManagementClient`'s
        :attr:`network_watchers` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")
        self._api_version = input_args.pop(0) if input_args else kwargs.pop("api_version")

    @overload
    async def create_or_update(
        self,
        resource_group_name: str,
        network_watcher_name: str,
        parameters: _models.NetworkWatcher,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.NetworkWatcher:
        """Creates or updates a network watcher in the specified resource group.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param network_watcher_name: The name of the network watcher. Required.
        :type network_watcher_name: str
        :param parameters: Parameters that define the network watcher resource. Required.
        :type parameters: ~azure.mgmt.network.v2017_10_01.models.NetworkWatcher
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: NetworkWatcher or the result of cls(response)
        :rtype: ~azure.mgmt.network.v2017_10_01.models.NetworkWatcher
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_or_update(
        self,
        resource_group_name: str,
        network_watcher_name: str,
        parameters: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.NetworkWatcher:
        """Creates or updates a network watcher in the specified resource group.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param network_watcher_name: The name of the network watcher. Required.
        :type network_watcher_name: str
        :param parameters: Parameters that define the network watcher resource. Required.
        :type parameters: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Known values are: 'application/json', 'text/json'. Default value is "application/json".
        :paramtype content_type: str
        :return: NetworkWatcher or the result of cls(response)
        :rtype: ~azure.mgmt.network.v2017_10_01.models.NetworkWatcher
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create_or_update(
        self,
        resource_group_name: str,
        network_watcher_name: str,
        parameters: Union[_models.NetworkWatcher, IO[bytes]],
        **kwargs: Any
    ) -> _models.NetworkWatcher:
        """Creates or updates a network watcher in the specified resource group.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param network_watcher_name: The name of the network watcher. Required.
        :type network_watcher_name: str
        :param parameters: Parameters that define the network watcher resource. Is either a
         NetworkWatcher type or a IO[bytes] type. Required.
        :type parameters: ~azure.mgmt.network.v2017_10_01.models.NetworkWatcher or IO[bytes]
        :return: NetworkWatcher or the result of cls(response)
        :rtype: ~azure.mgmt.network.v2017_10_01.models.NetworkWatcher
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.NetworkWatcher] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IOBase, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "NetworkWatcher")

        _request = build_network_watchers_create_or_update_request(
            resource_group_name=resource_group_name,
            network_watcher_name=network_watcher_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if response.status_code == 200:
            deserialized = self._deserialize("NetworkWatcher", pipeline_response)

        if response.status_code == 201:
            deserialized = self._deserialize("NetworkWatcher", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get(self, resource_group_name: str, network_watcher_name: str, **kwargs: Any) -> _models.NetworkWatcher:
        """Gets the specified network watcher by resource group.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param network_watcher_name: The name of the network watcher. Required.
        :type network_watcher_name: str
        :return: NetworkWatcher or the result of cls(response)
        :rtype: ~azure.mgmt.network.v2017_10_01.models.NetworkWatcher
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[_models.NetworkWatcher] = kwargs.pop("cls", None)

        _request = build_network_watchers_get_request(
            resource_group_name=resource_group_name,
            network_watcher_name=network_watcher_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("NetworkWatcher", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    async def _delete_initial(  # pylint: disable=inconsistent-return-statements
        self, resource_group_name: str, network_watcher_name: str, **kwargs: Any
    ) -> None:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_network_watchers_delete_request(
            resource_group_name=resource_group_name,
            network_watcher_name=network_watcher_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def begin_delete(
        self, resource_group_name: str, network_watcher_name: str, **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Deletes the specified network watcher resource.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param network_watcher_name: The name of the network watcher. Required.
        :type network_watcher_name: str
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._delete_initial(  # type: ignore
                resource_group_name=resource_group_name,
                network_watcher_name=network_watcher_name,
                api_version=api_version,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})  # type: ignore

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[None].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[None](self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    @overload
    async def update_tags(
        self,
        resource_group_name: str,
        network_watcher_name: str,
        parameters: _models.TagsObject,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.NetworkWatcher:
        """Updates a network watcher tags.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param network_watcher_name: The name of the network watcher. Required.
        :type network_watcher_name: str
        :param parameters: Parameters supplied to update network watcher tags. Required.
        :type parameters: ~azure.mgmt.network.v2017_10_01.models.TagsObject
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: NetworkWatcher or the result of cls(response)
        :rtype: ~azure.mgmt.network.v2017_10_01.models.NetworkWatcher
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_tags(
        self,
        resource_group_name: str,
        network_watcher_name: str,
        parameters: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.NetworkWatcher:
        """Updates a network watcher tags.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param network_watcher_name: The name of the network watcher. Required.
        :type network_watcher_name: str
        :param parameters: Parameters supplied to update network watcher tags. Required.
        :type parameters: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Known values are: 'application/json', 'text/json'. Default value is "application/json".
        :paramtype content_type: str
        :return: NetworkWatcher or the result of cls(response)
        :rtype: ~azure.mgmt.network.v2017_10_01.models.NetworkWatcher
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_tags(
        self,
        resource_group_name: str,
        network_watcher_name: str,
        parameters: Union[_models.TagsObject, IO[bytes]],
        **kwargs: Any
    ) -> _models.NetworkWatcher:
        """Updates a network watcher tags.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param network_watcher_name: The name of the network watcher. Required.
        :type network_watcher_name: str
        :param parameters: Parameters supplied to update network watcher tags. Is either a TagsObject
         type or a IO[bytes] type. Required.
        :type parameters: ~azure.mgmt.network.v2017_10_01.models.TagsObject or IO[bytes]
        :return: NetworkWatcher or the result of cls(response)
        :rtype: ~azure.mgmt.network.v2017_10_01.models.NetworkWatcher
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.NetworkWatcher] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IOBase, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "TagsObject")

        _request = build_network_watchers_update_tags_request(
            resource_group_name=resource_group_name,
            network_watcher_name=network_watcher_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("NetworkWatcher", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def list(self, resource_group_name: str, **kwargs: Any) -> AsyncIterable["_models.NetworkWatcher"]:
        """Gets all network watchers by resource group.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :return: An iterator like instance of either NetworkWatcher or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.network.v2017_10_01.models.NetworkWatcher]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[_models.NetworkWatcherListResult] = kwargs.pop("cls", None)

        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_network_watchers_list_request(
                    resource_group_name=resource_group_name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)

            else:
                _request = HttpRequest("GET", next_link)
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("NetworkWatcherListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace
    def list_all(self, **kwargs: Any) -> AsyncIterable["_models.NetworkWatcher"]:
        """Gets all network watchers by subscription.

        :return: An iterator like instance of either NetworkWatcher or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.network.v2017_10_01.models.NetworkWatcher]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[_models.NetworkWatcherListResult] = kwargs.pop("cls", None)

        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_network_watchers_list_all_request(
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)

            else:
                _request = HttpRequest("GET", next_link)
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("NetworkWatcherListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @overload
    async def get_topology(
        self,
        resource_group_name: str,
        network_watcher_name: str,
        parameters: _models.TopologyParameters,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.Topology:
        """Gets the current network topology by resource group.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param network_watcher_name: The name of the network watcher. Required.
        :type network_watcher_name: str
        :param parameters: Parameters that define the representation of topology. Required.
        :type parameters: ~azure.mgmt.network.v2017_10_01.models.TopologyParameters
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: Topology or the result of cls(response)
        :rtype: ~azure.mgmt.network.v2017_10_01.models.Topology
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def get_topology(
        self,
        resource_group_name: str,
        network_watcher_name: str,
        parameters: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.Topology:
        """Gets the current network topology by resource group.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param network_watcher_name: The name of the network watcher. Required.
        :type network_watcher_name: str
        :param parameters: Parameters that define the representation of topology. Required.
        :type parameters: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Known values are: 'application/json', 'text/json'. Default value is "application/json".
        :paramtype content_type: str
        :return: Topology or the result of cls(response)
        :rtype: ~azure.mgmt.network.v2017_10_01.models.Topology
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def get_topology(
        self,
        resource_group_name: str,
        network_watcher_name: str,
        parameters: Union[_models.TopologyParameters, IO[bytes]],
        **kwargs: Any
    ) -> _models.Topology:
        """Gets the current network topology by resource group.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param network_watcher_name: The name of the network watcher. Required.
        :type network_watcher_name: str
        :param parameters: Parameters that define the representation of topology. Is either a
         TopologyParameters type or a IO[bytes] type. Required.
        :type parameters: ~azure.mgmt.network.v2017_10_01.models.TopologyParameters or IO[bytes]
        :return: Topology or the result of cls(response)
        :rtype: ~azure.mgmt.network.v2017_10_01.models.Topology
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.Topology] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IOBase, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "TopologyParameters")

        _request = build_network_watchers_get_topology_request(
            resource_group_name=resource_group_name,
            network_watcher_name=network_watcher_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("Topology", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    async def _verify_ip_flow_initial(
        self,
        resource_group_name: str,
        network_watcher_name: str,
        parameters: Union[_models.VerificationIPFlowParameters, IO[bytes]],
        **kwargs: Any
    ) -> _models.VerificationIPFlowResult:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.VerificationIPFlowResult] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IOBase, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "VerificationIPFlowParameters")

        _request = build_network_watchers_verify_ip_flow_request(
            resource_group_name=resource_group_name,
            network_watcher_name=network_watcher_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if response.status_code == 200:
            deserialized = self._deserialize("VerificationIPFlowResult", pipeline_response)

        if response.status_code == 202:
            deserialized = self._deserialize("VerificationIPFlowResult", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_verify_ip_flow(
        self,
        resource_group_name: str,
        network_watcher_name: str,
        parameters: _models.VerificationIPFlowParameters,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.VerificationIPFlowResult]:
        """Verify IP flow from the specified VM to a location given the currently configured NSG rules.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param network_watcher_name: The name of the network watcher. Required.
        :type network_watcher_name: str
        :param parameters: Parameters that define the IP flow to be verified. Required.
        :type parameters: ~azure.mgmt.network.v2017_10_01.models.VerificationIPFlowParameters
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either VerificationIPFlowResult or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.VerificationIPFlowResult]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_verify_ip_flow(
        self,
        resource_group_name: str,
        network_watcher_name: str,
        parameters: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.VerificationIPFlowResult]:
        """Verify IP flow from the specified VM to a location given the currently configured NSG rules.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param network_watcher_name: The name of the network watcher. Required.
        :type network_watcher_name: str
        :param parameters: Parameters that define the IP flow to be verified. Required.
        :type parameters: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Known values are: 'application/json', 'text/json'. Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either VerificationIPFlowResult or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.VerificationIPFlowResult]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_verify_ip_flow(
        self,
        resource_group_name: str,
        network_watcher_name: str,
        parameters: Union[_models.VerificationIPFlowParameters, IO[bytes]],
        **kwargs: Any
    ) -> AsyncLROPoller[_models.VerificationIPFlowResult]:
        """Verify IP flow from the specified VM to a location given the currently configured NSG rules.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param network_watcher_name: The name of the network watcher. Required.
        :type network_watcher_name: str
        :param parameters: Parameters that define the IP flow to be verified. Is either a
         VerificationIPFlowParameters type or a IO[bytes] type. Required.
        :type parameters: ~azure.mgmt.network.v2017_10_01.models.VerificationIPFlowParameters or
         IO[bytes]
        :return: An instance of AsyncLROPoller that returns either VerificationIPFlowResult or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.VerificationIPFlowResult]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.VerificationIPFlowResult] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._verify_ip_flow_initial(
                resource_group_name=resource_group_name,
                network_watcher_name=network_watcher_name,
                parameters=parameters,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("VerificationIPFlowResult", pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.VerificationIPFlowResult].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.VerificationIPFlowResult](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    async def _get_next_hop_initial(
        self,
        resource_group_name: str,
        network_watcher_name: str,
        parameters: Union[_models.NextHopParameters, IO[bytes]],
        **kwargs: Any
    ) -> _models.NextHopResult:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.NextHopResult] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IOBase, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "NextHopParameters")

        _request = build_network_watchers_get_next_hop_request(
            resource_group_name=resource_group_name,
            network_watcher_name=network_watcher_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if response.status_code == 200:
            deserialized = self._deserialize("NextHopResult", pipeline_response)

        if response.status_code == 202:
            deserialized = self._deserialize("NextHopResult", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_get_next_hop(
        self,
        resource_group_name: str,
        network_watcher_name: str,
        parameters: _models.NextHopParameters,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.NextHopResult]:
        """Gets the next hop from the specified VM.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param network_watcher_name: The name of the network watcher. Required.
        :type network_watcher_name: str
        :param parameters: Parameters that define the source and destination endpoint. Required.
        :type parameters: ~azure.mgmt.network.v2017_10_01.models.NextHopParameters
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either NextHopResult or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.NextHopResult]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_get_next_hop(
        self,
        resource_group_name: str,
        network_watcher_name: str,
        parameters: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.NextHopResult]:
        """Gets the next hop from the specified VM.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param network_watcher_name: The name of the network watcher. Required.
        :type network_watcher_name: str
        :param parameters: Parameters that define the source and destination endpoint. Required.
        :type parameters: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Known values are: 'application/json', 'text/json'. Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either NextHopResult or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.NextHopResult]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_get_next_hop(
        self,
        resource_group_name: str,
        network_watcher_name: str,
        parameters: Union[_models.NextHopParameters, IO[bytes]],
        **kwargs: Any
    ) -> AsyncLROPoller[_models.NextHopResult]:
        """Gets the next hop from the specified VM.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param network_watcher_name: The name of the network watcher. Required.
        :type network_watcher_name: str
        :param parameters: Parameters that define the source and destination endpoint. Is either a
         NextHopParameters type or a IO[bytes] type. Required.
        :type parameters: ~azure.mgmt.network.v2017_10_01.models.NextHopParameters or IO[bytes]
        :return: An instance of AsyncLROPoller that returns either NextHopResult or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.NextHopResult]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.NextHopResult] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._get_next_hop_initial(
                resource_group_name=resource_group_name,
                network_watcher_name=network_watcher_name,
                parameters=parameters,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("NextHopResult", pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.NextHopResult].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.NextHopResult](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    async def _get_vm_security_rules_initial(
        self,
        resource_group_name: str,
        network_watcher_name: str,
        parameters: Union[_models.SecurityGroupViewParameters, IO[bytes]],
        **kwargs: Any
    ) -> _models.SecurityGroupViewResult:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.SecurityGroupViewResult] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IOBase, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "SecurityGroupViewParameters")

        _request = build_network_watchers_get_vm_security_rules_request(
            resource_group_name=resource_group_name,
            network_watcher_name=network_watcher_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if response.status_code == 200:
            deserialized = self._deserialize("SecurityGroupViewResult", pipeline_response)

        if response.status_code == 202:
            deserialized = self._deserialize("SecurityGroupViewResult", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_get_vm_security_rules(
        self,
        resource_group_name: str,
        network_watcher_name: str,
        parameters: _models.SecurityGroupViewParameters,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.SecurityGroupViewResult]:
        """Gets the configured and effective security group rules on the specified VM.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param network_watcher_name: The name of the network watcher. Required.
        :type network_watcher_name: str
        :param parameters: Parameters that define the VM to check security groups for. Required.
        :type parameters: ~azure.mgmt.network.v2017_10_01.models.SecurityGroupViewParameters
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either SecurityGroupViewResult or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.SecurityGroupViewResult]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_get_vm_security_rules(
        self,
        resource_group_name: str,
        network_watcher_name: str,
        parameters: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.SecurityGroupViewResult]:
        """Gets the configured and effective security group rules on the specified VM.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param network_watcher_name: The name of the network watcher. Required.
        :type network_watcher_name: str
        :param parameters: Parameters that define the VM to check security groups for. Required.
        :type parameters: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Known values are: 'application/json', 'text/json'. Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either SecurityGroupViewResult or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.SecurityGroupViewResult]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_get_vm_security_rules(
        self,
        resource_group_name: str,
        network_watcher_name: str,
        parameters: Union[_models.SecurityGroupViewParameters, IO[bytes]],
        **kwargs: Any
    ) -> AsyncLROPoller[_models.SecurityGroupViewResult]:
        """Gets the configured and effective security group rules on the specified VM.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param network_watcher_name: The name of the network watcher. Required.
        :type network_watcher_name: str
        :param parameters: Parameters that define the VM to check security groups for. Is either a
         SecurityGroupViewParameters type or a IO[bytes] type. Required.
        :type parameters: ~azure.mgmt.network.v2017_10_01.models.SecurityGroupViewParameters or
         IO[bytes]
        :return: An instance of AsyncLROPoller that returns either SecurityGroupViewResult or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.SecurityGroupViewResult]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.SecurityGroupViewResult] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._get_vm_security_rules_initial(
                resource_group_name=resource_group_name,
                network_watcher_name=network_watcher_name,
                parameters=parameters,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("SecurityGroupViewResult", pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.SecurityGroupViewResult].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.SecurityGroupViewResult](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    async def _get_troubleshooting_initial(
        self,
        resource_group_name: str,
        network_watcher_name: str,
        parameters: Union[_models.TroubleshootingParameters, IO[bytes]],
        **kwargs: Any
    ) -> _models.TroubleshootingResult:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.TroubleshootingResult] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IOBase, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "TroubleshootingParameters")

        _request = build_network_watchers_get_troubleshooting_request(
            resource_group_name=resource_group_name,
            network_watcher_name=network_watcher_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if response.status_code == 200:
            deserialized = self._deserialize("TroubleshootingResult", pipeline_response)

        if response.status_code == 202:
            deserialized = self._deserialize("TroubleshootingResult", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_get_troubleshooting(
        self,
        resource_group_name: str,
        network_watcher_name: str,
        parameters: _models.TroubleshootingParameters,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.TroubleshootingResult]:
        """Initiate troubleshooting on a specified resource.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param network_watcher_name: The name of the network watcher resource. Required.
        :type network_watcher_name: str
        :param parameters: Parameters that define the resource to troubleshoot. Required.
        :type parameters: ~azure.mgmt.network.v2017_10_01.models.TroubleshootingParameters
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either TroubleshootingResult or the result
         of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.TroubleshootingResult]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_get_troubleshooting(
        self,
        resource_group_name: str,
        network_watcher_name: str,
        parameters: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.TroubleshootingResult]:
        """Initiate troubleshooting on a specified resource.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param network_watcher_name: The name of the network watcher resource. Required.
        :type network_watcher_name: str
        :param parameters: Parameters that define the resource to troubleshoot. Required.
        :type parameters: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Known values are: 'application/json', 'text/json'. Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either TroubleshootingResult or the result
         of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.TroubleshootingResult]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_get_troubleshooting(
        self,
        resource_group_name: str,
        network_watcher_name: str,
        parameters: Union[_models.TroubleshootingParameters, IO[bytes]],
        **kwargs: Any
    ) -> AsyncLROPoller[_models.TroubleshootingResult]:
        """Initiate troubleshooting on a specified resource.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param network_watcher_name: The name of the network watcher resource. Required.
        :type network_watcher_name: str
        :param parameters: Parameters that define the resource to troubleshoot. Is either a
         TroubleshootingParameters type or a IO[bytes] type. Required.
        :type parameters: ~azure.mgmt.network.v2017_10_01.models.TroubleshootingParameters or IO[bytes]
        :return: An instance of AsyncLROPoller that returns either TroubleshootingResult or the result
         of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.TroubleshootingResult]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.TroubleshootingResult] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._get_troubleshooting_initial(
                resource_group_name=resource_group_name,
                network_watcher_name=network_watcher_name,
                parameters=parameters,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("TroubleshootingResult", pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.TroubleshootingResult].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.TroubleshootingResult](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    async def _get_troubleshooting_result_initial(
        self,
        resource_group_name: str,
        network_watcher_name: str,
        parameters: Union[_models.QueryTroubleshootingParameters, IO[bytes]],
        **kwargs: Any
    ) -> _models.TroubleshootingResult:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.TroubleshootingResult] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IOBase, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "QueryTroubleshootingParameters")

        _request = build_network_watchers_get_troubleshooting_result_request(
            resource_group_name=resource_group_name,
            network_watcher_name=network_watcher_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if response.status_code == 200:
            deserialized = self._deserialize("TroubleshootingResult", pipeline_response)

        if response.status_code == 202:
            deserialized = self._deserialize("TroubleshootingResult", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_get_troubleshooting_result(
        self,
        resource_group_name: str,
        network_watcher_name: str,
        parameters: _models.QueryTroubleshootingParameters,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.TroubleshootingResult]:
        """Get the last completed troubleshooting result on a specified resource.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param network_watcher_name: The name of the network watcher resource. Required.
        :type network_watcher_name: str
        :param parameters: Parameters that define the resource to query the troubleshooting result.
         Required.
        :type parameters: ~azure.mgmt.network.v2017_10_01.models.QueryTroubleshootingParameters
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either TroubleshootingResult or the result
         of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.TroubleshootingResult]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_get_troubleshooting_result(
        self,
        resource_group_name: str,
        network_watcher_name: str,
        parameters: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.TroubleshootingResult]:
        """Get the last completed troubleshooting result on a specified resource.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param network_watcher_name: The name of the network watcher resource. Required.
        :type network_watcher_name: str
        :param parameters: Parameters that define the resource to query the troubleshooting result.
         Required.
        :type parameters: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Known values are: 'application/json', 'text/json'. Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either TroubleshootingResult or the result
         of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.TroubleshootingResult]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_get_troubleshooting_result(
        self,
        resource_group_name: str,
        network_watcher_name: str,
        parameters: Union[_models.QueryTroubleshootingParameters, IO[bytes]],
        **kwargs: Any
    ) -> AsyncLROPoller[_models.TroubleshootingResult]:
        """Get the last completed troubleshooting result on a specified resource.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param network_watcher_name: The name of the network watcher resource. Required.
        :type network_watcher_name: str
        :param parameters: Parameters that define the resource to query the troubleshooting result. Is
         either a QueryTroubleshootingParameters type or a IO[bytes] type. Required.
        :type parameters: ~azure.mgmt.network.v2017_10_01.models.QueryTroubleshootingParameters or
         IO[bytes]
        :return: An instance of AsyncLROPoller that returns either TroubleshootingResult or the result
         of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.TroubleshootingResult]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.TroubleshootingResult] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._get_troubleshooting_result_initial(
                resource_group_name=resource_group_name,
                network_watcher_name=network_watcher_name,
                parameters=parameters,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("TroubleshootingResult", pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.TroubleshootingResult].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.TroubleshootingResult](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    async def _set_flow_log_configuration_initial(
        self,
        resource_group_name: str,
        network_watcher_name: str,
        parameters: Union[_models.FlowLogInformation, IO[bytes]],
        **kwargs: Any
    ) -> _models.FlowLogInformation:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.FlowLogInformation] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IOBase, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "FlowLogInformation")

        _request = build_network_watchers_set_flow_log_configuration_request(
            resource_group_name=resource_group_name,
            network_watcher_name=network_watcher_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if response.status_code == 200:
            deserialized = self._deserialize("FlowLogInformation", pipeline_response)

        if response.status_code == 202:
            deserialized = self._deserialize("FlowLogInformation", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_set_flow_log_configuration(
        self,
        resource_group_name: str,
        network_watcher_name: str,
        parameters: _models.FlowLogInformation,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.FlowLogInformation]:
        """Configures flow log on a specified resource.

        :param resource_group_name: The name of the network watcher resource group. Required.
        :type resource_group_name: str
        :param network_watcher_name: The name of the network watcher resource. Required.
        :type network_watcher_name: str
        :param parameters: Parameters that define the configuration of flow log. Required.
        :type parameters: ~azure.mgmt.network.v2017_10_01.models.FlowLogInformation
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either FlowLogInformation or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.FlowLogInformation]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_set_flow_log_configuration(
        self,
        resource_group_name: str,
        network_watcher_name: str,
        parameters: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.FlowLogInformation]:
        """Configures flow log on a specified resource.

        :param resource_group_name: The name of the network watcher resource group. Required.
        :type resource_group_name: str
        :param network_watcher_name: The name of the network watcher resource. Required.
        :type network_watcher_name: str
        :param parameters: Parameters that define the configuration of flow log. Required.
        :type parameters: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Known values are: 'application/json', 'text/json'. Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either FlowLogInformation or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.FlowLogInformation]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_set_flow_log_configuration(
        self,
        resource_group_name: str,
        network_watcher_name: str,
        parameters: Union[_models.FlowLogInformation, IO[bytes]],
        **kwargs: Any
    ) -> AsyncLROPoller[_models.FlowLogInformation]:
        """Configures flow log on a specified resource.

        :param resource_group_name: The name of the network watcher resource group. Required.
        :type resource_group_name: str
        :param network_watcher_name: The name of the network watcher resource. Required.
        :type network_watcher_name: str
        :param parameters: Parameters that define the configuration of flow log. Is either a
         FlowLogInformation type or a IO[bytes] type. Required.
        :type parameters: ~azure.mgmt.network.v2017_10_01.models.FlowLogInformation or IO[bytes]
        :return: An instance of AsyncLROPoller that returns either FlowLogInformation or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.FlowLogInformation]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.FlowLogInformation] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._set_flow_log_configuration_initial(
                resource_group_name=resource_group_name,
                network_watcher_name=network_watcher_name,
                parameters=parameters,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("FlowLogInformation", pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.FlowLogInformation].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.FlowLogInformation](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    async def _get_flow_log_status_initial(
        self,
        resource_group_name: str,
        network_watcher_name: str,
        parameters: Union[_models.FlowLogStatusParameters, IO[bytes]],
        **kwargs: Any
    ) -> _models.FlowLogInformation:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.FlowLogInformation] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IOBase, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "FlowLogStatusParameters")

        _request = build_network_watchers_get_flow_log_status_request(
            resource_group_name=resource_group_name,
            network_watcher_name=network_watcher_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if response.status_code == 200:
            deserialized = self._deserialize("FlowLogInformation", pipeline_response)

        if response.status_code == 202:
            deserialized = self._deserialize("FlowLogInformation", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_get_flow_log_status(
        self,
        resource_group_name: str,
        network_watcher_name: str,
        parameters: _models.FlowLogStatusParameters,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.FlowLogInformation]:
        """Queries status of flow log on a specified resource.

        :param resource_group_name: The name of the network watcher resource group. Required.
        :type resource_group_name: str
        :param network_watcher_name: The name of the network watcher resource. Required.
        :type network_watcher_name: str
        :param parameters: Parameters that define a resource to query flow log status. Required.
        :type parameters: ~azure.mgmt.network.v2017_10_01.models.FlowLogStatusParameters
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either FlowLogInformation or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.FlowLogInformation]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_get_flow_log_status(
        self,
        resource_group_name: str,
        network_watcher_name: str,
        parameters: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.FlowLogInformation]:
        """Queries status of flow log on a specified resource.

        :param resource_group_name: The name of the network watcher resource group. Required.
        :type resource_group_name: str
        :param network_watcher_name: The name of the network watcher resource. Required.
        :type network_watcher_name: str
        :param parameters: Parameters that define a resource to query flow log status. Required.
        :type parameters: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Known values are: 'application/json', 'text/json'. Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either FlowLogInformation or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.FlowLogInformation]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_get_flow_log_status(
        self,
        resource_group_name: str,
        network_watcher_name: str,
        parameters: Union[_models.FlowLogStatusParameters, IO[bytes]],
        **kwargs: Any
    ) -> AsyncLROPoller[_models.FlowLogInformation]:
        """Queries status of flow log on a specified resource.

        :param resource_group_name: The name of the network watcher resource group. Required.
        :type resource_group_name: str
        :param network_watcher_name: The name of the network watcher resource. Required.
        :type network_watcher_name: str
        :param parameters: Parameters that define a resource to query flow log status. Is either a
         FlowLogStatusParameters type or a IO[bytes] type. Required.
        :type parameters: ~azure.mgmt.network.v2017_10_01.models.FlowLogStatusParameters or IO[bytes]
        :return: An instance of AsyncLROPoller that returns either FlowLogInformation or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.FlowLogInformation]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.FlowLogInformation] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._get_flow_log_status_initial(
                resource_group_name=resource_group_name,
                network_watcher_name=network_watcher_name,
                parameters=parameters,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("FlowLogInformation", pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.FlowLogInformation].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.FlowLogInformation](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    async def _check_connectivity_initial(
        self,
        resource_group_name: str,
        network_watcher_name: str,
        parameters: Union[_models.ConnectivityParameters, IO[bytes]],
        **kwargs: Any
    ) -> _models.ConnectivityInformation:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.ConnectivityInformation] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IOBase, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "ConnectivityParameters")

        _request = build_network_watchers_check_connectivity_request(
            resource_group_name=resource_group_name,
            network_watcher_name=network_watcher_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if response.status_code == 200:
            deserialized = self._deserialize("ConnectivityInformation", pipeline_response)

        if response.status_code == 202:
            deserialized = self._deserialize("ConnectivityInformation", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_check_connectivity(
        self,
        resource_group_name: str,
        network_watcher_name: str,
        parameters: _models.ConnectivityParameters,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.ConnectivityInformation]:
        """Verifies the possibility of establishing a direct TCP connection from a virtual machine to a
        given endpoint including another VM or an arbitrary remote server.

        :param resource_group_name: The name of the network watcher resource group. Required.
        :type resource_group_name: str
        :param network_watcher_name: The name of the network watcher resource. Required.
        :type network_watcher_name: str
        :param parameters: Parameters that determine how the connectivity check will be performed.
         Required.
        :type parameters: ~azure.mgmt.network.v2017_10_01.models.ConnectivityParameters
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either ConnectivityInformation or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.ConnectivityInformation]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_check_connectivity(
        self,
        resource_group_name: str,
        network_watcher_name: str,
        parameters: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.ConnectivityInformation]:
        """Verifies the possibility of establishing a direct TCP connection from a virtual machine to a
        given endpoint including another VM or an arbitrary remote server.

        :param resource_group_name: The name of the network watcher resource group. Required.
        :type resource_group_name: str
        :param network_watcher_name: The name of the network watcher resource. Required.
        :type network_watcher_name: str
        :param parameters: Parameters that determine how the connectivity check will be performed.
         Required.
        :type parameters: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Known values are: 'application/json', 'text/json'. Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either ConnectivityInformation or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.ConnectivityInformation]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_check_connectivity(
        self,
        resource_group_name: str,
        network_watcher_name: str,
        parameters: Union[_models.ConnectivityParameters, IO[bytes]],
        **kwargs: Any
    ) -> AsyncLROPoller[_models.ConnectivityInformation]:
        """Verifies the possibility of establishing a direct TCP connection from a virtual machine to a
        given endpoint including another VM or an arbitrary remote server.

        :param resource_group_name: The name of the network watcher resource group. Required.
        :type resource_group_name: str
        :param network_watcher_name: The name of the network watcher resource. Required.
        :type network_watcher_name: str
        :param parameters: Parameters that determine how the connectivity check will be performed. Is
         either a ConnectivityParameters type or a IO[bytes] type. Required.
        :type parameters: ~azure.mgmt.network.v2017_10_01.models.ConnectivityParameters or IO[bytes]
        :return: An instance of AsyncLROPoller that returns either ConnectivityInformation or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.ConnectivityInformation]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.ConnectivityInformation] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._check_connectivity_initial(
                resource_group_name=resource_group_name,
                network_watcher_name=network_watcher_name,
                parameters=parameters,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("ConnectivityInformation", pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.ConnectivityInformation].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.ConnectivityInformation](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    async def _get_azure_reachability_report_initial(
        self,
        resource_group_name: str,
        network_watcher_name: str,
        parameters: Union[_models.AzureReachabilityReportParameters, IO[bytes]],
        **kwargs: Any
    ) -> _models.AzureReachabilityReport:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.AzureReachabilityReport] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IOBase, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "AzureReachabilityReportParameters")

        _request = build_network_watchers_get_azure_reachability_report_request(
            resource_group_name=resource_group_name,
            network_watcher_name=network_watcher_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if response.status_code == 200:
            deserialized = self._deserialize("AzureReachabilityReport", pipeline_response)

        if response.status_code == 202:
            deserialized = self._deserialize("AzureReachabilityReport", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_get_azure_reachability_report(
        self,
        resource_group_name: str,
        network_watcher_name: str,
        parameters: _models.AzureReachabilityReportParameters,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.AzureReachabilityReport]:
        """Gets the relative latency score for internet service providers from a specified location to
        Azure regions.

        :param resource_group_name: The name of the network watcher resource group. Required.
        :type resource_group_name: str
        :param network_watcher_name: The name of the network watcher resource. Required.
        :type network_watcher_name: str
        :param parameters: Parameters that determine Azure reachability report configuration. Required.
        :type parameters: ~azure.mgmt.network.v2017_10_01.models.AzureReachabilityReportParameters
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either AzureReachabilityReport or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.AzureReachabilityReport]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_get_azure_reachability_report(
        self,
        resource_group_name: str,
        network_watcher_name: str,
        parameters: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.AzureReachabilityReport]:
        """Gets the relative latency score for internet service providers from a specified location to
        Azure regions.

        :param resource_group_name: The name of the network watcher resource group. Required.
        :type resource_group_name: str
        :param network_watcher_name: The name of the network watcher resource. Required.
        :type network_watcher_name: str
        :param parameters: Parameters that determine Azure reachability report configuration. Required.
        :type parameters: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Known values are: 'application/json', 'text/json'. Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either AzureReachabilityReport or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.AzureReachabilityReport]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_get_azure_reachability_report(
        self,
        resource_group_name: str,
        network_watcher_name: str,
        parameters: Union[_models.AzureReachabilityReportParameters, IO[bytes]],
        **kwargs: Any
    ) -> AsyncLROPoller[_models.AzureReachabilityReport]:
        """Gets the relative latency score for internet service providers from a specified location to
        Azure regions.

        :param resource_group_name: The name of the network watcher resource group. Required.
        :type resource_group_name: str
        :param network_watcher_name: The name of the network watcher resource. Required.
        :type network_watcher_name: str
        :param parameters: Parameters that determine Azure reachability report configuration. Is either
         a AzureReachabilityReportParameters type or a IO[bytes] type. Required.
        :type parameters: ~azure.mgmt.network.v2017_10_01.models.AzureReachabilityReportParameters or
         IO[bytes]
        :return: An instance of AsyncLROPoller that returns either AzureReachabilityReport or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.AzureReachabilityReport]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.AzureReachabilityReport] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._get_azure_reachability_report_initial(
                resource_group_name=resource_group_name,
                network_watcher_name=network_watcher_name,
                parameters=parameters,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("AzureReachabilityReport", pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.AzureReachabilityReport].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.AzureReachabilityReport](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    async def _list_available_providers_initial(
        self,
        resource_group_name: str,
        network_watcher_name: str,
        parameters: Union[_models.AvailableProvidersListParameters, IO[bytes]],
        **kwargs: Any
    ) -> _models.AvailableProvidersList:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.AvailableProvidersList] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IOBase, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "AvailableProvidersListParameters")

        _request = build_network_watchers_list_available_providers_request(
            resource_group_name=resource_group_name,
            network_watcher_name=network_watcher_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if response.status_code == 200:
            deserialized = self._deserialize("AvailableProvidersList", pipeline_response)

        if response.status_code == 202:
            deserialized = self._deserialize("AvailableProvidersList", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_list_available_providers(
        self,
        resource_group_name: str,
        network_watcher_name: str,
        parameters: _models.AvailableProvidersListParameters,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.AvailableProvidersList]:
        """Lists all available internet service providers for a specified Azure region.

        :param resource_group_name: The name of the network watcher resource group. Required.
        :type resource_group_name: str
        :param network_watcher_name: The name of the network watcher resource. Required.
        :type network_watcher_name: str
        :param parameters: Parameters that scope the list of available providers. Required.
        :type parameters: ~azure.mgmt.network.v2017_10_01.models.AvailableProvidersListParameters
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either AvailableProvidersList or the result
         of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.AvailableProvidersList]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_list_available_providers(
        self,
        resource_group_name: str,
        network_watcher_name: str,
        parameters: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.AvailableProvidersList]:
        """Lists all available internet service providers for a specified Azure region.

        :param resource_group_name: The name of the network watcher resource group. Required.
        :type resource_group_name: str
        :param network_watcher_name: The name of the network watcher resource. Required.
        :type network_watcher_name: str
        :param parameters: Parameters that scope the list of available providers. Required.
        :type parameters: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Known values are: 'application/json', 'text/json'. Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either AvailableProvidersList or the result
         of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.AvailableProvidersList]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_list_available_providers(
        self,
        resource_group_name: str,
        network_watcher_name: str,
        parameters: Union[_models.AvailableProvidersListParameters, IO[bytes]],
        **kwargs: Any
    ) -> AsyncLROPoller[_models.AvailableProvidersList]:
        """Lists all available internet service providers for a specified Azure region.

        :param resource_group_name: The name of the network watcher resource group. Required.
        :type resource_group_name: str
        :param network_watcher_name: The name of the network watcher resource. Required.
        :type network_watcher_name: str
        :param parameters: Parameters that scope the list of available providers. Is either a
         AvailableProvidersListParameters type or a IO[bytes] type. Required.
        :type parameters: ~azure.mgmt.network.v2017_10_01.models.AvailableProvidersListParameters or
         IO[bytes]
        :return: An instance of AsyncLROPoller that returns either AvailableProvidersList or the result
         of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.AvailableProvidersList]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.AvailableProvidersList] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._list_available_providers_initial(
                resource_group_name=resource_group_name,
                network_watcher_name=network_watcher_name,
                parameters=parameters,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("AvailableProvidersList", pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.AvailableProvidersList].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.AvailableProvidersList](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )


class PacketCapturesOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.network.v2017_10_01.aio.NetworkManagementClient`'s
        :attr:`packet_captures` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")
        self._api_version = input_args.pop(0) if input_args else kwargs.pop("api_version")

    async def _create_initial(
        self,
        resource_group_name: str,
        network_watcher_name: str,
        packet_capture_name: str,
        parameters: Union[_models.PacketCapture, IO[bytes]],
        **kwargs: Any
    ) -> _models.PacketCaptureResult:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.PacketCaptureResult] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IOBase, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "PacketCapture")

        _request = build_packet_captures_create_request(
            resource_group_name=resource_group_name,
            network_watcher_name=network_watcher_name,
            packet_capture_name=packet_capture_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("PacketCaptureResult", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_create(
        self,
        resource_group_name: str,
        network_watcher_name: str,
        packet_capture_name: str,
        parameters: _models.PacketCapture,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.PacketCaptureResult]:
        """Create and start a packet capture on the specified VM.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param network_watcher_name: The name of the network watcher. Required.
        :type network_watcher_name: str
        :param packet_capture_name: The name of the packet capture session. Required.
        :type packet_capture_name: str
        :param parameters: Parameters that define the create packet capture operation. Required.
        :type parameters: ~azure.mgmt.network.v2017_10_01.models.PacketCapture
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either PacketCaptureResult or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.PacketCaptureResult]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_create(
        self,
        resource_group_name: str,
        network_watcher_name: str,
        packet_capture_name: str,
        parameters: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.PacketCaptureResult]:
        """Create and start a packet capture on the specified VM.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param network_watcher_name: The name of the network watcher. Required.
        :type network_watcher_name: str
        :param packet_capture_name: The name of the packet capture session. Required.
        :type packet_capture_name: str
        :param parameters: Parameters that define the create packet capture operation. Required.
        :type parameters: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Known values are: 'application/json', 'text/json'. Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either PacketCaptureResult or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.PacketCaptureResult]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_create(
        self,
        resource_group_name: str,
        network_watcher_name: str,
        packet_capture_name: str,
        parameters: Union[_models.PacketCapture, IO[bytes]],
        **kwargs: Any
    ) -> AsyncLROPoller[_models.PacketCaptureResult]:
        """Create and start a packet capture on the specified VM.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param network_watcher_name: The name of the network watcher. Required.
        :type network_watcher_name: str
        :param packet_capture_name: The name of the packet capture session. Required.
        :type packet_capture_name: str
        :param parameters: Parameters that define the create packet capture operation. Is either a
         PacketCapture type or a IO[bytes] type. Required.
        :type parameters: ~azure.mgmt.network.v2017_10_01.models.PacketCapture or IO[bytes]
        :return: An instance of AsyncLROPoller that returns either PacketCaptureResult or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.PacketCaptureResult]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.PacketCaptureResult] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._create_initial(
                resource_group_name=resource_group_name,
                network_watcher_name=network_watcher_name,
                packet_capture_name=packet_capture_name,
                parameters=parameters,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("PacketCaptureResult", pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.PacketCaptureResult].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.PacketCaptureResult](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    @distributed_trace_async
    async def get(
        self, resource_group_name: str, network_watcher_name: str, packet_capture_name: str, **kwargs: Any
    ) -> _models.PacketCaptureResult:
        """Gets a packet capture session by name.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param network_watcher_name: The name of the network watcher. Required.
        :type network_watcher_name: str
        :param packet_capture_name: The name of the packet capture session. Required.
        :type packet_capture_name: str
        :return: PacketCaptureResult or the result of cls(response)
        :rtype: ~azure.mgmt.network.v2017_10_01.models.PacketCaptureResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[_models.PacketCaptureResult] = kwargs.pop("cls", None)

        _request = build_packet_captures_get_request(
            resource_group_name=resource_group_name,
            network_watcher_name=network_watcher_name,
            packet_capture_name=packet_capture_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("PacketCaptureResult", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    async def _delete_initial(  # pylint: disable=inconsistent-return-statements
        self, resource_group_name: str, network_watcher_name: str, packet_capture_name: str, **kwargs: Any
    ) -> None:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_packet_captures_delete_request(
            resource_group_name=resource_group_name,
            network_watcher_name=network_watcher_name,
            packet_capture_name=packet_capture_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def begin_delete(
        self, resource_group_name: str, network_watcher_name: str, packet_capture_name: str, **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Deletes the specified packet capture session.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param network_watcher_name: The name of the network watcher. Required.
        :type network_watcher_name: str
        :param packet_capture_name: The name of the packet capture session. Required.
        :type packet_capture_name: str
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._delete_initial(  # type: ignore
                resource_group_name=resource_group_name,
                network_watcher_name=network_watcher_name,
                packet_capture_name=packet_capture_name,
                api_version=api_version,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})  # type: ignore

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[None].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[None](self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    async def _stop_initial(  # pylint: disable=inconsistent-return-statements
        self, resource_group_name: str, network_watcher_name: str, packet_capture_name: str, **kwargs: Any
    ) -> None:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_packet_captures_stop_request(
            resource_group_name=resource_group_name,
            network_watcher_name=network_watcher_name,
            packet_capture_name=packet_capture_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def begin_stop(
        self, resource_group_name: str, network_watcher_name: str, packet_capture_name: str, **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Stops a specified packet capture session.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param network_watcher_name: The name of the network watcher. Required.
        :type network_watcher_name: str
        :param packet_capture_name: The name of the packet capture session. Required.
        :type packet_capture_name: str
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._stop_initial(  # type: ignore
                resource_group_name=resource_group_name,
                network_watcher_name=network_watcher_name,
                packet_capture_name=packet_capture_name,
                api_version=api_version,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})  # type: ignore

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[None].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[None](self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    async def _get_status_initial(
        self, resource_group_name: str, network_watcher_name: str, packet_capture_name: str, **kwargs: Any
    ) -> _models.PacketCaptureQueryStatusResult:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[_models.PacketCaptureQueryStatusResult] = kwargs.pop("cls", None)

        _request = build_packet_captures_get_status_request(
            resource_group_name=resource_group_name,
            network_watcher_name=network_watcher_name,
            packet_capture_name=packet_capture_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if response.status_code == 200:
            deserialized = self._deserialize("PacketCaptureQueryStatusResult", pipeline_response)

        if response.status_code == 202:
            deserialized = self._deserialize("PacketCaptureQueryStatusResult", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def begin_get_status(
        self, resource_group_name: str, network_watcher_name: str, packet_capture_name: str, **kwargs: Any
    ) -> AsyncLROPoller[_models.PacketCaptureQueryStatusResult]:
        """Query the status of a running packet capture session.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param network_watcher_name: The name of the Network Watcher resource. Required.
        :type network_watcher_name: str
        :param packet_capture_name: The name given to the packet capture session. Required.
        :type packet_capture_name: str
        :return: An instance of AsyncLROPoller that returns either PacketCaptureQueryStatusResult or
         the result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.PacketCaptureQueryStatusResult]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[_models.PacketCaptureQueryStatusResult] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._get_status_initial(
                resource_group_name=resource_group_name,
                network_watcher_name=network_watcher_name,
                packet_capture_name=packet_capture_name,
                api_version=api_version,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("PacketCaptureQueryStatusResult", pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod, AsyncARMPolling(lro_delay, lro_options={"final-state-via": "location"}, **kwargs)
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.PacketCaptureQueryStatusResult].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.PacketCaptureQueryStatusResult](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    @distributed_trace
    def list(
        self, resource_group_name: str, network_watcher_name: str, **kwargs: Any
    ) -> AsyncIterable["_models.PacketCaptureResult"]:
        """Lists all packet capture sessions within the specified resource group.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param network_watcher_name: The name of the Network Watcher resource. Required.
        :type network_watcher_name: str
        :return: An iterator like instance of either PacketCaptureResult or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.network.v2017_10_01.models.PacketCaptureResult]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[_models.PacketCaptureListResult] = kwargs.pop("cls", None)

        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_packet_captures_list_request(
                    resource_group_name=resource_group_name,
                    network_watcher_name=network_watcher_name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)

            else:
                _request = HttpRequest("GET", next_link)
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("PacketCaptureListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)


class ConnectionMonitorsOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.network.v2017_10_01.aio.NetworkManagementClient`'s
        :attr:`connection_monitors` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")
        self._api_version = input_args.pop(0) if input_args else kwargs.pop("api_version")

    async def _create_or_update_initial(
        self,
        resource_group_name: str,
        network_watcher_name: str,
        connection_monitor_name: str,
        parameters: Union[_models.ConnectionMonitor, IO[bytes]],
        **kwargs: Any
    ) -> _models.ConnectionMonitorResult:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.ConnectionMonitorResult] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IOBase, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "ConnectionMonitor")

        _request = build_connection_monitors_create_or_update_request(
            resource_group_name=resource_group_name,
            network_watcher_name=network_watcher_name,
            connection_monitor_name=connection_monitor_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if response.status_code == 200:
            deserialized = self._deserialize("ConnectionMonitorResult", pipeline_response)

        if response.status_code == 201:
            deserialized = self._deserialize("ConnectionMonitorResult", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_create_or_update(
        self,
        resource_group_name: str,
        network_watcher_name: str,
        connection_monitor_name: str,
        parameters: _models.ConnectionMonitor,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.ConnectionMonitorResult]:
        """Create or update a connection monitor.

        :param resource_group_name: The name of the resource group containing Network Watcher.
         Required.
        :type resource_group_name: str
        :param network_watcher_name: The name of the Network Watcher resource. Required.
        :type network_watcher_name: str
        :param connection_monitor_name: The name of the connection monitor. Required.
        :type connection_monitor_name: str
        :param parameters: Parameters that define the operation to create a connection monitor.
         Required.
        :type parameters: ~azure.mgmt.network.v2017_10_01.models.ConnectionMonitor
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either ConnectionMonitorResult or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.ConnectionMonitorResult]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_create_or_update(
        self,
        resource_group_name: str,
        network_watcher_name: str,
        connection_monitor_name: str,
        parameters: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.ConnectionMonitorResult]:
        """Create or update a connection monitor.

        :param resource_group_name: The name of the resource group containing Network Watcher.
         Required.
        :type resource_group_name: str
        :param network_watcher_name: The name of the Network Watcher resource. Required.
        :type network_watcher_name: str
        :param connection_monitor_name: The name of the connection monitor. Required.
        :type connection_monitor_name: str
        :param parameters: Parameters that define the operation to create a connection monitor.
         Required.
        :type parameters: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Known values are: 'application/json', 'text/json'. Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either ConnectionMonitorResult or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.ConnectionMonitorResult]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_create_or_update(
        self,
        resource_group_name: str,
        network_watcher_name: str,
        connection_monitor_name: str,
        parameters: Union[_models.ConnectionMonitor, IO[bytes]],
        **kwargs: Any
    ) -> AsyncLROPoller[_models.ConnectionMonitorResult]:
        """Create or update a connection monitor.

        :param resource_group_name: The name of the resource group containing Network Watcher.
         Required.
        :type resource_group_name: str
        :param network_watcher_name: The name of the Network Watcher resource. Required.
        :type network_watcher_name: str
        :param connection_monitor_name: The name of the connection monitor. Required.
        :type connection_monitor_name: str
        :param parameters: Parameters that define the operation to create a connection monitor. Is
         either a ConnectionMonitor type or a IO[bytes] type. Required.
        :type parameters: ~azure.mgmt.network.v2017_10_01.models.ConnectionMonitor or IO[bytes]
        :return: An instance of AsyncLROPoller that returns either ConnectionMonitorResult or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.ConnectionMonitorResult]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.ConnectionMonitorResult] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._create_or_update_initial(
                resource_group_name=resource_group_name,
                network_watcher_name=network_watcher_name,
                connection_monitor_name=connection_monitor_name,
                parameters=parameters,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("ConnectionMonitorResult", pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.ConnectionMonitorResult].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.ConnectionMonitorResult](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    @distributed_trace_async
    async def get(
        self, resource_group_name: str, network_watcher_name: str, connection_monitor_name: str, **kwargs: Any
    ) -> _models.ConnectionMonitorResult:
        """Gets a connection monitor by name.

        :param resource_group_name: The name of the resource group containing Network Watcher.
         Required.
        :type resource_group_name: str
        :param network_watcher_name: The name of the Network Watcher resource. Required.
        :type network_watcher_name: str
        :param connection_monitor_name: The name of the connection monitor. Required.
        :type connection_monitor_name: str
        :return: ConnectionMonitorResult or the result of cls(response)
        :rtype: ~azure.mgmt.network.v2017_10_01.models.ConnectionMonitorResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[_models.ConnectionMonitorResult] = kwargs.pop("cls", None)

        _request = build_connection_monitors_get_request(
            resource_group_name=resource_group_name,
            network_watcher_name=network_watcher_name,
            connection_monitor_name=connection_monitor_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("ConnectionMonitorResult", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    async def _delete_initial(  # pylint: disable=inconsistent-return-statements
        self, resource_group_name: str, network_watcher_name: str, connection_monitor_name: str, **kwargs: Any
    ) -> None:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_connection_monitors_delete_request(
            resource_group_name=resource_group_name,
            network_watcher_name=network_watcher_name,
            connection_monitor_name=connection_monitor_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def begin_delete(
        self, resource_group_name: str, network_watcher_name: str, connection_monitor_name: str, **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Deletes the specified connection monitor.

        :param resource_group_name: The name of the resource group containing Network Watcher.
         Required.
        :type resource_group_name: str
        :param network_watcher_name: The name of the Network Watcher resource. Required.
        :type network_watcher_name: str
        :param connection_monitor_name: The name of the connection monitor. Required.
        :type connection_monitor_name: str
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._delete_initial(  # type: ignore
                resource_group_name=resource_group_name,
                network_watcher_name=network_watcher_name,
                connection_monitor_name=connection_monitor_name,
                api_version=api_version,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})  # type: ignore

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[None].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[None](self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    async def _stop_initial(  # pylint: disable=inconsistent-return-statements
        self, resource_group_name: str, network_watcher_name: str, connection_monitor_name: str, **kwargs: Any
    ) -> None:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_connection_monitors_stop_request(
            resource_group_name=resource_group_name,
            network_watcher_name=network_watcher_name,
            connection_monitor_name=connection_monitor_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def begin_stop(
        self, resource_group_name: str, network_watcher_name: str, connection_monitor_name: str, **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Stops the specified connection monitor.

        :param resource_group_name: The name of the resource group containing Network Watcher.
         Required.
        :type resource_group_name: str
        :param network_watcher_name: The name of the Network Watcher resource. Required.
        :type network_watcher_name: str
        :param connection_monitor_name: The name of the connection monitor. Required.
        :type connection_monitor_name: str
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._stop_initial(  # type: ignore
                resource_group_name=resource_group_name,
                network_watcher_name=network_watcher_name,
                connection_monitor_name=connection_monitor_name,
                api_version=api_version,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})  # type: ignore

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[None].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[None](self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    async def _start_initial(  # pylint: disable=inconsistent-return-statements
        self, resource_group_name: str, network_watcher_name: str, connection_monitor_name: str, **kwargs: Any
    ) -> None:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_connection_monitors_start_request(
            resource_group_name=resource_group_name,
            network_watcher_name=network_watcher_name,
            connection_monitor_name=connection_monitor_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def begin_start(
        self, resource_group_name: str, network_watcher_name: str, connection_monitor_name: str, **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Starts the specified connection monitor.

        :param resource_group_name: The name of the resource group containing Network Watcher.
         Required.
        :type resource_group_name: str
        :param network_watcher_name: The name of the Network Watcher resource. Required.
        :type network_watcher_name: str
        :param connection_monitor_name: The name of the connection monitor. Required.
        :type connection_monitor_name: str
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._start_initial(  # type: ignore
                resource_group_name=resource_group_name,
                network_watcher_name=network_watcher_name,
                connection_monitor_name=connection_monitor_name,
                api_version=api_version,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})  # type: ignore

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[None].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[None](self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    async def _query_initial(
        self, resource_group_name: str, network_watcher_name: str, connection_monitor_name: str, **kwargs: Any
    ) -> _models.ConnectionMonitorQueryResult:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[_models.ConnectionMonitorQueryResult] = kwargs.pop("cls", None)

        _request = build_connection_monitors_query_request(
            resource_group_name=resource_group_name,
            network_watcher_name=network_watcher_name,
            connection_monitor_name=connection_monitor_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if response.status_code == 200:
            deserialized = self._deserialize("ConnectionMonitorQueryResult", pipeline_response)

        if response.status_code == 202:
            deserialized = self._deserialize("ConnectionMonitorQueryResult", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def begin_query(
        self, resource_group_name: str, network_watcher_name: str, connection_monitor_name: str, **kwargs: Any
    ) -> AsyncLROPoller[_models.ConnectionMonitorQueryResult]:
        """Query a snapshot of the most recent connection states.

        :param resource_group_name: The name of the resource group containing Network Watcher.
         Required.
        :type resource_group_name: str
        :param network_watcher_name: The name of the Network Watcher resource. Required.
        :type network_watcher_name: str
        :param connection_monitor_name: The name given to the connection monitor. Required.
        :type connection_monitor_name: str
        :return: An instance of AsyncLROPoller that returns either ConnectionMonitorQueryResult or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.ConnectionMonitorQueryResult]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[_models.ConnectionMonitorQueryResult] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._query_initial(
                resource_group_name=resource_group_name,
                network_watcher_name=network_watcher_name,
                connection_monitor_name=connection_monitor_name,
                api_version=api_version,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("ConnectionMonitorQueryResult", pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.ConnectionMonitorQueryResult].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.ConnectionMonitorQueryResult](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    @distributed_trace
    def list(
        self, resource_group_name: str, network_watcher_name: str, **kwargs: Any
    ) -> AsyncIterable["_models.ConnectionMonitorResult"]:
        """Lists all connection monitors for the specified Network Watcher.

        :param resource_group_name: The name of the resource group containing Network Watcher.
         Required.
        :type resource_group_name: str
        :param network_watcher_name: The name of the Network Watcher resource. Required.
        :type network_watcher_name: str
        :return: An iterator like instance of either ConnectionMonitorResult or the result of
         cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.network.v2017_10_01.models.ConnectionMonitorResult]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[_models.ConnectionMonitorListResult] = kwargs.pop("cls", None)

        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_connection_monitors_list_request(
                    resource_group_name=resource_group_name,
                    network_watcher_name=network_watcher_name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)

            else:
                _request = HttpRequest("GET", next_link)
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("ConnectionMonitorListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)


class Operations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.network.v2017_10_01.aio.NetworkManagementClient`'s
        :attr:`operations` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")
        self._api_version = input_args.pop(0) if input_args else kwargs.pop("api_version")

    @distributed_trace
    def list(self, **kwargs: Any) -> AsyncIterable["_models.Operation"]:
        """Lists all of the available Network Rest API operations.

        :return: An iterator like instance of either Operation or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.network.v2017_10_01.models.Operation]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[_models.OperationListResult] = kwargs.pop("cls", None)

        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_operations_list_request(
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)

            else:
                _request = HttpRequest("GET", next_link)
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("OperationListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)


class PublicIPAddressesOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.network.v2017_10_01.aio.NetworkManagementClient`'s
        :attr:`public_ip_addresses` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")
        self._api_version = input_args.pop(0) if input_args else kwargs.pop("api_version")

    async def _delete_initial(  # pylint: disable=inconsistent-return-statements
        self, resource_group_name: str, public_ip_address_name: str, **kwargs: Any
    ) -> None:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_public_ip_addresses_delete_request(
            resource_group_name=resource_group_name,
            public_ip_address_name=public_ip_address_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def begin_delete(
        self, resource_group_name: str, public_ip_address_name: str, **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Deletes the specified public IP address.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param public_ip_address_name: The name of the subnet. Required.
        :type public_ip_address_name: str
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._delete_initial(  # type: ignore
                resource_group_name=resource_group_name,
                public_ip_address_name=public_ip_address_name,
                api_version=api_version,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})  # type: ignore

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[None].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[None](self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    @distributed_trace_async
    async def get(
        self, resource_group_name: str, public_ip_address_name: str, *, expand: Optional[str] = None, **kwargs: Any
    ) -> _models.PublicIPAddress:
        """Gets the specified public IP address in a specified resource group.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param public_ip_address_name: The name of the subnet. Required.
        :type public_ip_address_name: str
        :keyword expand: Expands referenced resources. Default value is None.
        :paramtype expand: str
        :return: PublicIPAddress or the result of cls(response)
        :rtype: ~azure.mgmt.network.v2017_10_01.models.PublicIPAddress
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[_models.PublicIPAddress] = kwargs.pop("cls", None)

        _request = build_public_ip_addresses_get_request(
            resource_group_name=resource_group_name,
            public_ip_address_name=public_ip_address_name,
            subscription_id=self._config.subscription_id,
            expand=expand,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("PublicIPAddress", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    async def _create_or_update_initial(
        self,
        resource_group_name: str,
        public_ip_address_name: str,
        parameters: Union[_models.PublicIPAddress, IO[bytes]],
        **kwargs: Any
    ) -> _models.PublicIPAddress:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.PublicIPAddress] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IOBase, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "PublicIPAddress")

        _request = build_public_ip_addresses_create_or_update_request(
            resource_group_name=resource_group_name,
            public_ip_address_name=public_ip_address_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if response.status_code == 200:
            deserialized = self._deserialize("PublicIPAddress", pipeline_response)

        if response.status_code == 201:
            deserialized = self._deserialize("PublicIPAddress", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_create_or_update(
        self,
        resource_group_name: str,
        public_ip_address_name: str,
        parameters: _models.PublicIPAddress,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.PublicIPAddress]:
        """Creates or updates a static or dynamic public IP address.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param public_ip_address_name: The name of the public IP address. Required.
        :type public_ip_address_name: str
        :param parameters: Parameters supplied to the create or update public IP address operation.
         Required.
        :type parameters: ~azure.mgmt.network.v2017_10_01.models.PublicIPAddress
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either PublicIPAddress or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.PublicIPAddress]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_create_or_update(
        self,
        resource_group_name: str,
        public_ip_address_name: str,
        parameters: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.PublicIPAddress]:
        """Creates or updates a static or dynamic public IP address.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param public_ip_address_name: The name of the public IP address. Required.
        :type public_ip_address_name: str
        :param parameters: Parameters supplied to the create or update public IP address operation.
         Required.
        :type parameters: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Known values are: 'application/json', 'text/json'. Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either PublicIPAddress or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.PublicIPAddress]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_create_or_update(
        self,
        resource_group_name: str,
        public_ip_address_name: str,
        parameters: Union[_models.PublicIPAddress, IO[bytes]],
        **kwargs: Any
    ) -> AsyncLROPoller[_models.PublicIPAddress]:
        """Creates or updates a static or dynamic public IP address.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param public_ip_address_name: The name of the public IP address. Required.
        :type public_ip_address_name: str
        :param parameters: Parameters supplied to the create or update public IP address operation. Is
         either a PublicIPAddress type or a IO[bytes] type. Required.
        :type parameters: ~azure.mgmt.network.v2017_10_01.models.PublicIPAddress or IO[bytes]
        :return: An instance of AsyncLROPoller that returns either PublicIPAddress or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.PublicIPAddress]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.PublicIPAddress] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._create_or_update_initial(
                resource_group_name=resource_group_name,
                public_ip_address_name=public_ip_address_name,
                parameters=parameters,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("PublicIPAddress", pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.PublicIPAddress].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.PublicIPAddress](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    async def _update_tags_initial(
        self,
        resource_group_name: str,
        public_ip_address_name: str,
        parameters: Union[_models.TagsObject, IO[bytes]],
        **kwargs: Any
    ) -> _models.PublicIPAddress:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.PublicIPAddress] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IOBase, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "TagsObject")

        _request = build_public_ip_addresses_update_tags_request(
            resource_group_name=resource_group_name,
            public_ip_address_name=public_ip_address_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("PublicIPAddress", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_update_tags(
        self,
        resource_group_name: str,
        public_ip_address_name: str,
        parameters: _models.TagsObject,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.PublicIPAddress]:
        """Updates public IP address tags.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param public_ip_address_name: The name of the public IP address. Required.
        :type public_ip_address_name: str
        :param parameters: Parameters supplied to update public IP address tags. Required.
        :type parameters: ~azure.mgmt.network.v2017_10_01.models.TagsObject
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either PublicIPAddress or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.PublicIPAddress]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_update_tags(
        self,
        resource_group_name: str,
        public_ip_address_name: str,
        parameters: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.PublicIPAddress]:
        """Updates public IP address tags.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param public_ip_address_name: The name of the public IP address. Required.
        :type public_ip_address_name: str
        :param parameters: Parameters supplied to update public IP address tags. Required.
        :type parameters: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Known values are: 'application/json', 'text/json'. Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either PublicIPAddress or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.PublicIPAddress]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_update_tags(
        self,
        resource_group_name: str,
        public_ip_address_name: str,
        parameters: Union[_models.TagsObject, IO[bytes]],
        **kwargs: Any
    ) -> AsyncLROPoller[_models.PublicIPAddress]:
        """Updates public IP address tags.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param public_ip_address_name: The name of the public IP address. Required.
        :type public_ip_address_name: str
        :param parameters: Parameters supplied to update public IP address tags. Is either a TagsObject
         type or a IO[bytes] type. Required.
        :type parameters: ~azure.mgmt.network.v2017_10_01.models.TagsObject or IO[bytes]
        :return: An instance of AsyncLROPoller that returns either PublicIPAddress or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.PublicIPAddress]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.PublicIPAddress] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._update_tags_initial(
                resource_group_name=resource_group_name,
                public_ip_address_name=public_ip_address_name,
                parameters=parameters,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("PublicIPAddress", pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.PublicIPAddress].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.PublicIPAddress](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    @distributed_trace
    def list_all(self, **kwargs: Any) -> AsyncIterable["_models.PublicIPAddress"]:
        """Gets all the public IP addresses in a subscription.

        :return: An iterator like instance of either PublicIPAddress or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.network.v2017_10_01.models.PublicIPAddress]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[_models.PublicIPAddressListResult] = kwargs.pop("cls", None)

        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_public_ip_addresses_list_all_request(
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)

            else:
                _request = HttpRequest("GET", next_link)
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("PublicIPAddressListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace
    def list(self, resource_group_name: str, **kwargs: Any) -> AsyncIterable["_models.PublicIPAddress"]:
        """Gets all public IP addresses in a resource group.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :return: An iterator like instance of either PublicIPAddress or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.network.v2017_10_01.models.PublicIPAddress]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[_models.PublicIPAddressListResult] = kwargs.pop("cls", None)

        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_public_ip_addresses_list_request(
                    resource_group_name=resource_group_name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)

            else:
                _request = HttpRequest("GET", next_link)
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("PublicIPAddressListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace
    def list_virtual_machine_scale_set_public_ip_addresses(  # pylint: disable=name-too-long
        self, resource_group_name: str, virtual_machine_scale_set_name: str, **kwargs: Any
    ) -> AsyncIterable["_models.PublicIPAddress"]:
        """Gets information about all public IP addresses on a virtual machine scale set level.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param virtual_machine_scale_set_name: The name of the virtual machine scale set. Required.
        :type virtual_machine_scale_set_name: str
        :return: An iterator like instance of either PublicIPAddress or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.network.v2017_10_01.models.PublicIPAddress]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-03-30"))
        cls: ClsType[_models.PublicIPAddressListResult] = kwargs.pop("cls", None)

        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_public_ip_addresses_list_virtual_machine_scale_set_public_ip_addresses_request(
                    resource_group_name=resource_group_name,
                    virtual_machine_scale_set_name=virtual_machine_scale_set_name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)

            else:
                _request = HttpRequest("GET", next_link)
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("PublicIPAddressListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace
    def list_virtual_machine_scale_set_vm_public_ip_addresses(  # pylint: disable=name-too-long
        self,
        resource_group_name: str,
        virtual_machine_scale_set_name: str,
        virtualmachine_index: str,
        network_interface_name: str,
        ip_configuration_name: str,
        **kwargs: Any
    ) -> AsyncIterable["_models.PublicIPAddress"]:
        """Gets information about all public IP addresses in a virtual machine IP configuration in a
        virtual machine scale set.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param virtual_machine_scale_set_name: The name of the virtual machine scale set. Required.
        :type virtual_machine_scale_set_name: str
        :param virtualmachine_index: The virtual machine index. Required.
        :type virtualmachine_index: str
        :param network_interface_name: The network interface name. Required.
        :type network_interface_name: str
        :param ip_configuration_name: The IP configuration name. Required.
        :type ip_configuration_name: str
        :return: An iterator like instance of either PublicIPAddress or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.network.v2017_10_01.models.PublicIPAddress]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-03-30"))
        cls: ClsType[_models.PublicIPAddressListResult] = kwargs.pop("cls", None)

        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_public_ip_addresses_list_virtual_machine_scale_set_vm_public_ip_addresses_request(
                    resource_group_name=resource_group_name,
                    virtual_machine_scale_set_name=virtual_machine_scale_set_name,
                    virtualmachine_index=virtualmachine_index,
                    network_interface_name=network_interface_name,
                    ip_configuration_name=ip_configuration_name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)

            else:
                _request = HttpRequest("GET", next_link)
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("PublicIPAddressListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def get_virtual_machine_scale_set_public_ip_address(  # pylint: disable=name-too-long
        self,
        resource_group_name: str,
        virtual_machine_scale_set_name: str,
        virtualmachine_index: str,
        network_interface_name: str,
        ip_configuration_name: str,
        public_ip_address_name: str,
        *,
        expand: Optional[str] = None,
        **kwargs: Any
    ) -> _models.PublicIPAddress:
        """Get the specified public IP address in a virtual machine scale set.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param virtual_machine_scale_set_name: The name of the virtual machine scale set. Required.
        :type virtual_machine_scale_set_name: str
        :param virtualmachine_index: The virtual machine index. Required.
        :type virtualmachine_index: str
        :param network_interface_name: The name of the network interface. Required.
        :type network_interface_name: str
        :param ip_configuration_name: The name of the IP configuration. Required.
        :type ip_configuration_name: str
        :param public_ip_address_name: The name of the public IP Address. Required.
        :type public_ip_address_name: str
        :keyword expand: Expands referenced resources. Default value is None.
        :paramtype expand: str
        :return: PublicIPAddress or the result of cls(response)
        :rtype: ~azure.mgmt.network.v2017_10_01.models.PublicIPAddress
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-03-30"))
        cls: ClsType[_models.PublicIPAddress] = kwargs.pop("cls", None)

        _request = build_public_ip_addresses_get_virtual_machine_scale_set_public_ip_address_request(
            resource_group_name=resource_group_name,
            virtual_machine_scale_set_name=virtual_machine_scale_set_name,
            virtualmachine_index=virtualmachine_index,
            network_interface_name=network_interface_name,
            ip_configuration_name=ip_configuration_name,
            public_ip_address_name=public_ip_address_name,
            subscription_id=self._config.subscription_id,
            expand=expand,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("PublicIPAddress", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore


class RouteFiltersOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.network.v2017_10_01.aio.NetworkManagementClient`'s
        :attr:`route_filters` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")
        self._api_version = input_args.pop(0) if input_args else kwargs.pop("api_version")

    async def _delete_initial(  # pylint: disable=inconsistent-return-statements
        self, resource_group_name: str, route_filter_name: str, **kwargs: Any
    ) -> None:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_route_filters_delete_request(
            resource_group_name=resource_group_name,
            route_filter_name=route_filter_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def begin_delete(
        self, resource_group_name: str, route_filter_name: str, **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Deletes the specified route filter.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param route_filter_name: The name of the route filter. Required.
        :type route_filter_name: str
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._delete_initial(  # type: ignore
                resource_group_name=resource_group_name,
                route_filter_name=route_filter_name,
                api_version=api_version,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})  # type: ignore

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[None].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[None](self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    @distributed_trace_async
    async def get(
        self, resource_group_name: str, route_filter_name: str, *, expand: Optional[str] = None, **kwargs: Any
    ) -> _models.RouteFilter:
        """Gets the specified route filter.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param route_filter_name: The name of the route filter. Required.
        :type route_filter_name: str
        :keyword expand: Expands referenced express route bgp peering resources. Default value is None.
        :paramtype expand: str
        :return: RouteFilter or the result of cls(response)
        :rtype: ~azure.mgmt.network.v2017_10_01.models.RouteFilter
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[_models.RouteFilter] = kwargs.pop("cls", None)

        _request = build_route_filters_get_request(
            resource_group_name=resource_group_name,
            route_filter_name=route_filter_name,
            subscription_id=self._config.subscription_id,
            expand=expand,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("RouteFilter", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    async def _create_or_update_initial(
        self,
        resource_group_name: str,
        route_filter_name: str,
        route_filter_parameters: Union[_models.RouteFilter, IO[bytes]],
        **kwargs: Any
    ) -> _models.RouteFilter:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.RouteFilter] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(route_filter_parameters, (IOBase, bytes)):
            _content = route_filter_parameters
        else:
            _json = self._serialize.body(route_filter_parameters, "RouteFilter")

        _request = build_route_filters_create_or_update_request(
            resource_group_name=resource_group_name,
            route_filter_name=route_filter_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if response.status_code == 200:
            deserialized = self._deserialize("RouteFilter", pipeline_response)

        if response.status_code == 201:
            deserialized = self._deserialize("RouteFilter", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_create_or_update(
        self,
        resource_group_name: str,
        route_filter_name: str,
        route_filter_parameters: _models.RouteFilter,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.RouteFilter]:
        """Creates or updates a route filter in a specified resource group.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param route_filter_name: The name of the route filter. Required.
        :type route_filter_name: str
        :param route_filter_parameters: Parameters supplied to the create or update route filter
         operation. Required.
        :type route_filter_parameters: ~azure.mgmt.network.v2017_10_01.models.RouteFilter
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either RouteFilter or the result of
         cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.RouteFilter]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_create_or_update(
        self,
        resource_group_name: str,
        route_filter_name: str,
        route_filter_parameters: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.RouteFilter]:
        """Creates or updates a route filter in a specified resource group.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param route_filter_name: The name of the route filter. Required.
        :type route_filter_name: str
        :param route_filter_parameters: Parameters supplied to the create or update route filter
         operation. Required.
        :type route_filter_parameters: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either RouteFilter or the result of
         cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.RouteFilter]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_create_or_update(
        self,
        resource_group_name: str,
        route_filter_name: str,
        route_filter_parameters: Union[_models.RouteFilter, IO[bytes]],
        **kwargs: Any
    ) -> AsyncLROPoller[_models.RouteFilter]:
        """Creates or updates a route filter in a specified resource group.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param route_filter_name: The name of the route filter. Required.
        :type route_filter_name: str
        :param route_filter_parameters: Parameters supplied to the create or update route filter
         operation. Is either a RouteFilter type or a IO[bytes] type. Required.
        :type route_filter_parameters: ~azure.mgmt.network.v2017_10_01.models.RouteFilter or IO[bytes]
        :return: An instance of AsyncLROPoller that returns either RouteFilter or the result of
         cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.RouteFilter]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.RouteFilter] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._create_or_update_initial(
                resource_group_name=resource_group_name,
                route_filter_name=route_filter_name,
                route_filter_parameters=route_filter_parameters,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("RouteFilter", pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.RouteFilter].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.RouteFilter](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    async def _update_initial(
        self,
        resource_group_name: str,
        route_filter_name: str,
        route_filter_parameters: Union[_models.PatchRouteFilter, IO[bytes]],
        **kwargs: Any
    ) -> _models.RouteFilter:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.RouteFilter] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(route_filter_parameters, (IOBase, bytes)):
            _content = route_filter_parameters
        else:
            _json = self._serialize.body(route_filter_parameters, "PatchRouteFilter")

        _request = build_route_filters_update_request(
            resource_group_name=resource_group_name,
            route_filter_name=route_filter_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("RouteFilter", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_update(
        self,
        resource_group_name: str,
        route_filter_name: str,
        route_filter_parameters: _models.PatchRouteFilter,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.RouteFilter]:
        """Updates a route filter in a specified resource group.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param route_filter_name: The name of the route filter. Required.
        :type route_filter_name: str
        :param route_filter_parameters: Parameters supplied to the update route filter operation.
         Required.
        :type route_filter_parameters: ~azure.mgmt.network.v2017_10_01.models.PatchRouteFilter
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either RouteFilter or the result of
         cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.RouteFilter]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_update(
        self,
        resource_group_name: str,
        route_filter_name: str,
        route_filter_parameters: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.RouteFilter]:
        """Updates a route filter in a specified resource group.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param route_filter_name: The name of the route filter. Required.
        :type route_filter_name: str
        :param route_filter_parameters: Parameters supplied to the update route filter operation.
         Required.
        :type route_filter_parameters: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either RouteFilter or the result of
         cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.RouteFilter]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_update(
        self,
        resource_group_name: str,
        route_filter_name: str,
        route_filter_parameters: Union[_models.PatchRouteFilter, IO[bytes]],
        **kwargs: Any
    ) -> AsyncLROPoller[_models.RouteFilter]:
        """Updates a route filter in a specified resource group.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param route_filter_name: The name of the route filter. Required.
        :type route_filter_name: str
        :param route_filter_parameters: Parameters supplied to the update route filter operation. Is
         either a PatchRouteFilter type or a IO[bytes] type. Required.
        :type route_filter_parameters: ~azure.mgmt.network.v2017_10_01.models.PatchRouteFilter or
         IO[bytes]
        :return: An instance of AsyncLROPoller that returns either RouteFilter or the result of
         cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.RouteFilter]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.RouteFilter] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._update_initial(
                resource_group_name=resource_group_name,
                route_filter_name=route_filter_name,
                route_filter_parameters=route_filter_parameters,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("RouteFilter", pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.RouteFilter].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.RouteFilter](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    @distributed_trace
    def list_by_resource_group(self, resource_group_name: str, **kwargs: Any) -> AsyncIterable["_models.RouteFilter"]:
        """Gets all route filters in a resource group.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :return: An iterator like instance of either RouteFilter or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.network.v2017_10_01.models.RouteFilter]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[_models.RouteFilterListResult] = kwargs.pop("cls", None)

        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_route_filters_list_by_resource_group_request(
                    resource_group_name=resource_group_name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)

            else:
                _request = HttpRequest("GET", next_link)
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("RouteFilterListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace
    def list(self, **kwargs: Any) -> AsyncIterable["_models.RouteFilter"]:
        """Gets all route filters in a subscription.

        :return: An iterator like instance of either RouteFilter or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.network.v2017_10_01.models.RouteFilter]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[_models.RouteFilterListResult] = kwargs.pop("cls", None)

        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_route_filters_list_request(
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)

            else:
                _request = HttpRequest("GET", next_link)
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("RouteFilterListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)


class RouteFilterRulesOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.network.v2017_10_01.aio.NetworkManagementClient`'s
        :attr:`route_filter_rules` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")
        self._api_version = input_args.pop(0) if input_args else kwargs.pop("api_version")

    async def _delete_initial(  # pylint: disable=inconsistent-return-statements
        self, resource_group_name: str, route_filter_name: str, rule_name: str, **kwargs: Any
    ) -> None:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_route_filter_rules_delete_request(
            resource_group_name=resource_group_name,
            route_filter_name=route_filter_name,
            rule_name=rule_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def begin_delete(
        self, resource_group_name: str, route_filter_name: str, rule_name: str, **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Deletes the specified rule from a route filter.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param route_filter_name: The name of the route filter. Required.
        :type route_filter_name: str
        :param rule_name: The name of the rule. Required.
        :type rule_name: str
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._delete_initial(  # type: ignore
                resource_group_name=resource_group_name,
                route_filter_name=route_filter_name,
                rule_name=rule_name,
                api_version=api_version,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})  # type: ignore

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[None].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[None](self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    @distributed_trace_async
    async def get(
        self, resource_group_name: str, route_filter_name: str, rule_name: str, **kwargs: Any
    ) -> _models.RouteFilterRule:
        """Gets the specified rule from a route filter.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param route_filter_name: The name of the route filter. Required.
        :type route_filter_name: str
        :param rule_name: The name of the rule. Required.
        :type rule_name: str
        :return: RouteFilterRule or the result of cls(response)
        :rtype: ~azure.mgmt.network.v2017_10_01.models.RouteFilterRule
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[_models.RouteFilterRule] = kwargs.pop("cls", None)

        _request = build_route_filter_rules_get_request(
            resource_group_name=resource_group_name,
            route_filter_name=route_filter_name,
            rule_name=rule_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("RouteFilterRule", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    async def _create_or_update_initial(
        self,
        resource_group_name: str,
        route_filter_name: str,
        rule_name: str,
        route_filter_rule_parameters: Union[_models.RouteFilterRule, IO[bytes]],
        **kwargs: Any
    ) -> _models.RouteFilterRule:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.RouteFilterRule] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(route_filter_rule_parameters, (IOBase, bytes)):
            _content = route_filter_rule_parameters
        else:
            _json = self._serialize.body(route_filter_rule_parameters, "RouteFilterRule")

        _request = build_route_filter_rules_create_or_update_request(
            resource_group_name=resource_group_name,
            route_filter_name=route_filter_name,
            rule_name=rule_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if response.status_code == 200:
            deserialized = self._deserialize("RouteFilterRule", pipeline_response)

        if response.status_code == 201:
            deserialized = self._deserialize("RouteFilterRule", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_create_or_update(
        self,
        resource_group_name: str,
        route_filter_name: str,
        rule_name: str,
        route_filter_rule_parameters: _models.RouteFilterRule,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.RouteFilterRule]:
        """Creates or updates a route in the specified route filter.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param route_filter_name: The name of the route filter. Required.
        :type route_filter_name: str
        :param rule_name: The name of the route filter rule. Required.
        :type rule_name: str
        :param route_filter_rule_parameters: Parameters supplied to the create or update route filter
         rule operation. Required.
        :type route_filter_rule_parameters: ~azure.mgmt.network.v2017_10_01.models.RouteFilterRule
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either RouteFilterRule or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.RouteFilterRule]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_create_or_update(
        self,
        resource_group_name: str,
        route_filter_name: str,
        rule_name: str,
        route_filter_rule_parameters: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.RouteFilterRule]:
        """Creates or updates a route in the specified route filter.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param route_filter_name: The name of the route filter. Required.
        :type route_filter_name: str
        :param rule_name: The name of the route filter rule. Required.
        :type rule_name: str
        :param route_filter_rule_parameters: Parameters supplied to the create or update route filter
         rule operation. Required.
        :type route_filter_rule_parameters: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either RouteFilterRule or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.RouteFilterRule]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_create_or_update(
        self,
        resource_group_name: str,
        route_filter_name: str,
        rule_name: str,
        route_filter_rule_parameters: Union[_models.RouteFilterRule, IO[bytes]],
        **kwargs: Any
    ) -> AsyncLROPoller[_models.RouteFilterRule]:
        """Creates or updates a route in the specified route filter.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param route_filter_name: The name of the route filter. Required.
        :type route_filter_name: str
        :param rule_name: The name of the route filter rule. Required.
        :type rule_name: str
        :param route_filter_rule_parameters: Parameters supplied to the create or update route filter
         rule operation. Is either a RouteFilterRule type or a IO[bytes] type. Required.
        :type route_filter_rule_parameters: ~azure.mgmt.network.v2017_10_01.models.RouteFilterRule or
         IO[bytes]
        :return: An instance of AsyncLROPoller that returns either RouteFilterRule or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.RouteFilterRule]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.RouteFilterRule] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._create_or_update_initial(
                resource_group_name=resource_group_name,
                route_filter_name=route_filter_name,
                rule_name=rule_name,
                route_filter_rule_parameters=route_filter_rule_parameters,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("RouteFilterRule", pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.RouteFilterRule].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.RouteFilterRule](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    async def _update_initial(
        self,
        resource_group_name: str,
        route_filter_name: str,
        rule_name: str,
        route_filter_rule_parameters: Union[_models.PatchRouteFilterRule, IO[bytes]],
        **kwargs: Any
    ) -> _models.RouteFilterRule:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.RouteFilterRule] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(route_filter_rule_parameters, (IOBase, bytes)):
            _content = route_filter_rule_parameters
        else:
            _json = self._serialize.body(route_filter_rule_parameters, "PatchRouteFilterRule")

        _request = build_route_filter_rules_update_request(
            resource_group_name=resource_group_name,
            route_filter_name=route_filter_name,
            rule_name=rule_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("RouteFilterRule", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_update(
        self,
        resource_group_name: str,
        route_filter_name: str,
        rule_name: str,
        route_filter_rule_parameters: _models.PatchRouteFilterRule,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.RouteFilterRule]:
        """Updates a route in the specified route filter.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param route_filter_name: The name of the route filter. Required.
        :type route_filter_name: str
        :param rule_name: The name of the route filter rule. Required.
        :type rule_name: str
        :param route_filter_rule_parameters: Parameters supplied to the update route filter rule
         operation. Required.
        :type route_filter_rule_parameters: ~azure.mgmt.network.v2017_10_01.models.PatchRouteFilterRule
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either RouteFilterRule or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.RouteFilterRule]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_update(
        self,
        resource_group_name: str,
        route_filter_name: str,
        rule_name: str,
        route_filter_rule_parameters: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.RouteFilterRule]:
        """Updates a route in the specified route filter.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param route_filter_name: The name of the route filter. Required.
        :type route_filter_name: str
        :param rule_name: The name of the route filter rule. Required.
        :type rule_name: str
        :param route_filter_rule_parameters: Parameters supplied to the update route filter rule
         operation. Required.
        :type route_filter_rule_parameters: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either RouteFilterRule or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.RouteFilterRule]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_update(
        self,
        resource_group_name: str,
        route_filter_name: str,
        rule_name: str,
        route_filter_rule_parameters: Union[_models.PatchRouteFilterRule, IO[bytes]],
        **kwargs: Any
    ) -> AsyncLROPoller[_models.RouteFilterRule]:
        """Updates a route in the specified route filter.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param route_filter_name: The name of the route filter. Required.
        :type route_filter_name: str
        :param rule_name: The name of the route filter rule. Required.
        :type rule_name: str
        :param route_filter_rule_parameters: Parameters supplied to the update route filter rule
         operation. Is either a PatchRouteFilterRule type or a IO[bytes] type. Required.
        :type route_filter_rule_parameters: ~azure.mgmt.network.v2017_10_01.models.PatchRouteFilterRule
         or IO[bytes]
        :return: An instance of AsyncLROPoller that returns either RouteFilterRule or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.RouteFilterRule]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.RouteFilterRule] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._update_initial(
                resource_group_name=resource_group_name,
                route_filter_name=route_filter_name,
                rule_name=rule_name,
                route_filter_rule_parameters=route_filter_rule_parameters,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("RouteFilterRule", pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.RouteFilterRule].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.RouteFilterRule](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    @distributed_trace
    def list_by_route_filter(
        self, resource_group_name: str, route_filter_name: str, **kwargs: Any
    ) -> AsyncIterable["_models.RouteFilterRule"]:
        """Gets all RouteFilterRules in a route filter.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param route_filter_name: The name of the route filter. Required.
        :type route_filter_name: str
        :return: An iterator like instance of either RouteFilterRule or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.network.v2017_10_01.models.RouteFilterRule]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[_models.RouteFilterRuleListResult] = kwargs.pop("cls", None)

        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_route_filter_rules_list_by_route_filter_request(
                    resource_group_name=resource_group_name,
                    route_filter_name=route_filter_name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)

            else:
                _request = HttpRequest("GET", next_link)
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("RouteFilterRuleListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)


class RouteTablesOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.network.v2017_10_01.aio.NetworkManagementClient`'s
        :attr:`route_tables` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")
        self._api_version = input_args.pop(0) if input_args else kwargs.pop("api_version")

    async def _delete_initial(  # pylint: disable=inconsistent-return-statements
        self, resource_group_name: str, route_table_name: str, **kwargs: Any
    ) -> None:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_route_tables_delete_request(
            resource_group_name=resource_group_name,
            route_table_name=route_table_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def begin_delete(
        self, resource_group_name: str, route_table_name: str, **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Deletes the specified route table.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param route_table_name: The name of the route table. Required.
        :type route_table_name: str
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._delete_initial(  # type: ignore
                resource_group_name=resource_group_name,
                route_table_name=route_table_name,
                api_version=api_version,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})  # type: ignore

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[None].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[None](self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    @distributed_trace_async
    async def get(
        self, resource_group_name: str, route_table_name: str, *, expand: Optional[str] = None, **kwargs: Any
    ) -> _models.RouteTable:
        """Gets the specified route table.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param route_table_name: The name of the route table. Required.
        :type route_table_name: str
        :keyword expand: Expands referenced resources. Default value is None.
        :paramtype expand: str
        :return: RouteTable or the result of cls(response)
        :rtype: ~azure.mgmt.network.v2017_10_01.models.RouteTable
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[_models.RouteTable] = kwargs.pop("cls", None)

        _request = build_route_tables_get_request(
            resource_group_name=resource_group_name,
            route_table_name=route_table_name,
            subscription_id=self._config.subscription_id,
            expand=expand,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("RouteTable", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    async def _create_or_update_initial(
        self,
        resource_group_name: str,
        route_table_name: str,
        parameters: Union[_models.RouteTable, IO[bytes]],
        **kwargs: Any
    ) -> _models.RouteTable:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.RouteTable] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IOBase, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "RouteTable")

        _request = build_route_tables_create_or_update_request(
            resource_group_name=resource_group_name,
            route_table_name=route_table_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if response.status_code == 200:
            deserialized = self._deserialize("RouteTable", pipeline_response)

        if response.status_code == 201:
            deserialized = self._deserialize("RouteTable", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_create_or_update(
        self,
        resource_group_name: str,
        route_table_name: str,
        parameters: _models.RouteTable,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.RouteTable]:
        """Create or updates a route table in a specified resource group.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param route_table_name: The name of the route table. Required.
        :type route_table_name: str
        :param parameters: Parameters supplied to the create or update route table operation. Required.
        :type parameters: ~azure.mgmt.network.v2017_10_01.models.RouteTable
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either RouteTable or the result of
         cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.RouteTable]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_create_or_update(
        self,
        resource_group_name: str,
        route_table_name: str,
        parameters: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.RouteTable]:
        """Create or updates a route table in a specified resource group.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param route_table_name: The name of the route table. Required.
        :type route_table_name: str
        :param parameters: Parameters supplied to the create or update route table operation. Required.
        :type parameters: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Known values are: 'application/json', 'text/json'. Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either RouteTable or the result of
         cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.RouteTable]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_create_or_update(
        self,
        resource_group_name: str,
        route_table_name: str,
        parameters: Union[_models.RouteTable, IO[bytes]],
        **kwargs: Any
    ) -> AsyncLROPoller[_models.RouteTable]:
        """Create or updates a route table in a specified resource group.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param route_table_name: The name of the route table. Required.
        :type route_table_name: str
        :param parameters: Parameters supplied to the create or update route table operation. Is either
         a RouteTable type or a IO[bytes] type. Required.
        :type parameters: ~azure.mgmt.network.v2017_10_01.models.RouteTable or IO[bytes]
        :return: An instance of AsyncLROPoller that returns either RouteTable or the result of
         cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.RouteTable]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.RouteTable] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._create_or_update_initial(
                resource_group_name=resource_group_name,
                route_table_name=route_table_name,
                parameters=parameters,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("RouteTable", pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.RouteTable].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.RouteTable](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    async def _update_tags_initial(
        self,
        resource_group_name: str,
        route_table_name: str,
        parameters: Union[_models.TagsObject, IO[bytes]],
        **kwargs: Any
    ) -> _models.RouteTable:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.RouteTable] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IOBase, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "TagsObject")

        _request = build_route_tables_update_tags_request(
            resource_group_name=resource_group_name,
            route_table_name=route_table_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("RouteTable", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_update_tags(
        self,
        resource_group_name: str,
        route_table_name: str,
        parameters: _models.TagsObject,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.RouteTable]:
        """Updates a route table tags.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param route_table_name: The name of the route table. Required.
        :type route_table_name: str
        :param parameters: Parameters supplied to update route table tags. Required.
        :type parameters: ~azure.mgmt.network.v2017_10_01.models.TagsObject
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either RouteTable or the result of
         cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.RouteTable]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_update_tags(
        self,
        resource_group_name: str,
        route_table_name: str,
        parameters: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.RouteTable]:
        """Updates a route table tags.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param route_table_name: The name of the route table. Required.
        :type route_table_name: str
        :param parameters: Parameters supplied to update route table tags. Required.
        :type parameters: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Known values are: 'application/json', 'text/json'. Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either RouteTable or the result of
         cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.RouteTable]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_update_tags(
        self,
        resource_group_name: str,
        route_table_name: str,
        parameters: Union[_models.TagsObject, IO[bytes]],
        **kwargs: Any
    ) -> AsyncLROPoller[_models.RouteTable]:
        """Updates a route table tags.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param route_table_name: The name of the route table. Required.
        :type route_table_name: str
        :param parameters: Parameters supplied to update route table tags. Is either a TagsObject type
         or a IO[bytes] type. Required.
        :type parameters: ~azure.mgmt.network.v2017_10_01.models.TagsObject or IO[bytes]
        :return: An instance of AsyncLROPoller that returns either RouteTable or the result of
         cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.RouteTable]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.RouteTable] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._update_tags_initial(
                resource_group_name=resource_group_name,
                route_table_name=route_table_name,
                parameters=parameters,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("RouteTable", pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.RouteTable].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.RouteTable](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    @distributed_trace
    def list(self, resource_group_name: str, **kwargs: Any) -> AsyncIterable["_models.RouteTable"]:
        """Gets all route tables in a resource group.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :return: An iterator like instance of either RouteTable or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.network.v2017_10_01.models.RouteTable]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[_models.RouteTableListResult] = kwargs.pop("cls", None)

        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_route_tables_list_request(
                    resource_group_name=resource_group_name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)

            else:
                _request = HttpRequest("GET", next_link)
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("RouteTableListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace
    def list_all(self, **kwargs: Any) -> AsyncIterable["_models.RouteTable"]:
        """Gets all route tables in a subscription.

        :return: An iterator like instance of either RouteTable or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.network.v2017_10_01.models.RouteTable]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[_models.RouteTableListResult] = kwargs.pop("cls", None)

        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_route_tables_list_all_request(
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)

            else:
                _request = HttpRequest("GET", next_link)
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("RouteTableListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)


class RoutesOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.network.v2017_10_01.aio.NetworkManagementClient`'s
        :attr:`routes` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")
        self._api_version = input_args.pop(0) if input_args else kwargs.pop("api_version")

    async def _delete_initial(  # pylint: disable=inconsistent-return-statements
        self, resource_group_name: str, route_table_name: str, route_name: str, **kwargs: Any
    ) -> None:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_routes_delete_request(
            resource_group_name=resource_group_name,
            route_table_name=route_table_name,
            route_name=route_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def begin_delete(
        self, resource_group_name: str, route_table_name: str, route_name: str, **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Deletes the specified route from a route table.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param route_table_name: The name of the route table. Required.
        :type route_table_name: str
        :param route_name: The name of the route. Required.
        :type route_name: str
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._delete_initial(  # type: ignore
                resource_group_name=resource_group_name,
                route_table_name=route_table_name,
                route_name=route_name,
                api_version=api_version,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})  # type: ignore

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[None].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[None](self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    @distributed_trace_async
    async def get(
        self, resource_group_name: str, route_table_name: str, route_name: str, **kwargs: Any
    ) -> _models.Route:
        """Gets the specified route from a route table.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param route_table_name: The name of the route table. Required.
        :type route_table_name: str
        :param route_name: The name of the route. Required.
        :type route_name: str
        :return: Route or the result of cls(response)
        :rtype: ~azure.mgmt.network.v2017_10_01.models.Route
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[_models.Route] = kwargs.pop("cls", None)

        _request = build_routes_get_request(
            resource_group_name=resource_group_name,
            route_table_name=route_table_name,
            route_name=route_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("Route", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    async def _create_or_update_initial(
        self,
        resource_group_name: str,
        route_table_name: str,
        route_name: str,
        route_parameters: Union[_models.Route, IO[bytes]],
        **kwargs: Any
    ) -> _models.Route:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.Route] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(route_parameters, (IOBase, bytes)):
            _content = route_parameters
        else:
            _json = self._serialize.body(route_parameters, "Route")

        _request = build_routes_create_or_update_request(
            resource_group_name=resource_group_name,
            route_table_name=route_table_name,
            route_name=route_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if response.status_code == 200:
            deserialized = self._deserialize("Route", pipeline_response)

        if response.status_code == 201:
            deserialized = self._deserialize("Route", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_create_or_update(
        self,
        resource_group_name: str,
        route_table_name: str,
        route_name: str,
        route_parameters: _models.Route,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.Route]:
        """Creates or updates a route in the specified route table.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param route_table_name: The name of the route table. Required.
        :type route_table_name: str
        :param route_name: The name of the route. Required.
        :type route_name: str
        :param route_parameters: Parameters supplied to the create or update route operation. Required.
        :type route_parameters: ~azure.mgmt.network.v2017_10_01.models.Route
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either Route or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.Route]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_create_or_update(
        self,
        resource_group_name: str,
        route_table_name: str,
        route_name: str,
        route_parameters: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.Route]:
        """Creates or updates a route in the specified route table.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param route_table_name: The name of the route table. Required.
        :type route_table_name: str
        :param route_name: The name of the route. Required.
        :type route_name: str
        :param route_parameters: Parameters supplied to the create or update route operation. Required.
        :type route_parameters: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Known values are: 'application/json', 'text/json'. Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either Route or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.Route]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_create_or_update(
        self,
        resource_group_name: str,
        route_table_name: str,
        route_name: str,
        route_parameters: Union[_models.Route, IO[bytes]],
        **kwargs: Any
    ) -> AsyncLROPoller[_models.Route]:
        """Creates or updates a route in the specified route table.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param route_table_name: The name of the route table. Required.
        :type route_table_name: str
        :param route_name: The name of the route. Required.
        :type route_name: str
        :param route_parameters: Parameters supplied to the create or update route operation. Is either
         a Route type or a IO[bytes] type. Required.
        :type route_parameters: ~azure.mgmt.network.v2017_10_01.models.Route or IO[bytes]
        :return: An instance of AsyncLROPoller that returns either Route or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.Route]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.Route] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._create_or_update_initial(
                resource_group_name=resource_group_name,
                route_table_name=route_table_name,
                route_name=route_name,
                route_parameters=route_parameters,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("Route", pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.Route].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.Route](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    @distributed_trace
    def list(self, resource_group_name: str, route_table_name: str, **kwargs: Any) -> AsyncIterable["_models.Route"]:
        """Gets all routes in a route table.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param route_table_name: The name of the route table. Required.
        :type route_table_name: str
        :return: An iterator like instance of either Route or the result of cls(response)
        :rtype: ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.network.v2017_10_01.models.Route]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[_models.RouteListResult] = kwargs.pop("cls", None)

        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_routes_list_request(
                    resource_group_name=resource_group_name,
                    route_table_name=route_table_name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)

            else:
                _request = HttpRequest("GET", next_link)
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("RouteListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)


class BgpServiceCommunitiesOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.network.v2017_10_01.aio.NetworkManagementClient`'s
        :attr:`bgp_service_communities` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")
        self._api_version = input_args.pop(0) if input_args else kwargs.pop("api_version")

    @distributed_trace
    def list(self, **kwargs: Any) -> AsyncIterable["_models.BgpServiceCommunity"]:
        """Gets all the available bgp service communities.

        :return: An iterator like instance of either BgpServiceCommunity or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.network.v2017_10_01.models.BgpServiceCommunity]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[_models.BgpServiceCommunityListResult] = kwargs.pop("cls", None)

        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_bgp_service_communities_list_request(
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)

            else:
                _request = HttpRequest("GET", next_link)
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("BgpServiceCommunityListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)


class UsagesOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.network.v2017_10_01.aio.NetworkManagementClient`'s
        :attr:`usages` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")
        self._api_version = input_args.pop(0) if input_args else kwargs.pop("api_version")

    @distributed_trace
    def list(self, location: str, **kwargs: Any) -> AsyncIterable["_models.Usage"]:
        """List network usages for a subscription.

        :param location: The location where resource usage is queried. Required.
        :type location: str
        :return: An iterator like instance of either Usage or the result of cls(response)
        :rtype: ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.network.v2017_10_01.models.Usage]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[_models.UsagesListResult] = kwargs.pop("cls", None)

        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_usages_list_request(
                    location=location,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)

            else:
                _request = HttpRequest("GET", next_link)
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("UsagesListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)


class VirtualNetworksOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.network.v2017_10_01.aio.NetworkManagementClient`'s
        :attr:`virtual_networks` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")
        self._api_version = input_args.pop(0) if input_args else kwargs.pop("api_version")

    async def _delete_initial(  # pylint: disable=inconsistent-return-statements
        self, resource_group_name: str, virtual_network_name: str, **kwargs: Any
    ) -> None:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_virtual_networks_delete_request(
            resource_group_name=resource_group_name,
            virtual_network_name=virtual_network_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def begin_delete(
        self, resource_group_name: str, virtual_network_name: str, **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Deletes the specified virtual network.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param virtual_network_name: The name of the virtual network. Required.
        :type virtual_network_name: str
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._delete_initial(  # type: ignore
                resource_group_name=resource_group_name,
                virtual_network_name=virtual_network_name,
                api_version=api_version,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})  # type: ignore

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[None].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[None](self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    @distributed_trace_async
    async def get(
        self, resource_group_name: str, virtual_network_name: str, *, expand: Optional[str] = None, **kwargs: Any
    ) -> _models.VirtualNetwork:
        """Gets the specified virtual network by resource group.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param virtual_network_name: The name of the virtual network. Required.
        :type virtual_network_name: str
        :keyword expand: Expands referenced resources. Default value is None.
        :paramtype expand: str
        :return: VirtualNetwork or the result of cls(response)
        :rtype: ~azure.mgmt.network.v2017_10_01.models.VirtualNetwork
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[_models.VirtualNetwork] = kwargs.pop("cls", None)

        _request = build_virtual_networks_get_request(
            resource_group_name=resource_group_name,
            virtual_network_name=virtual_network_name,
            subscription_id=self._config.subscription_id,
            expand=expand,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("VirtualNetwork", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    async def _create_or_update_initial(
        self,
        resource_group_name: str,
        virtual_network_name: str,
        parameters: Union[_models.VirtualNetwork, IO[bytes]],
        **kwargs: Any
    ) -> _models.VirtualNetwork:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.VirtualNetwork] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IOBase, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "VirtualNetwork")

        _request = build_virtual_networks_create_or_update_request(
            resource_group_name=resource_group_name,
            virtual_network_name=virtual_network_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if response.status_code == 200:
            deserialized = self._deserialize("VirtualNetwork", pipeline_response)

        if response.status_code == 201:
            deserialized = self._deserialize("VirtualNetwork", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_create_or_update(
        self,
        resource_group_name: str,
        virtual_network_name: str,
        parameters: _models.VirtualNetwork,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.VirtualNetwork]:
        """Creates or updates a virtual network in the specified resource group.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param virtual_network_name: The name of the virtual network. Required.
        :type virtual_network_name: str
        :param parameters: Parameters supplied to the create or update virtual network operation.
         Required.
        :type parameters: ~azure.mgmt.network.v2017_10_01.models.VirtualNetwork
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either VirtualNetwork or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.VirtualNetwork]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_create_or_update(
        self,
        resource_group_name: str,
        virtual_network_name: str,
        parameters: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.VirtualNetwork]:
        """Creates or updates a virtual network in the specified resource group.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param virtual_network_name: The name of the virtual network. Required.
        :type virtual_network_name: str
        :param parameters: Parameters supplied to the create or update virtual network operation.
         Required.
        :type parameters: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Known values are: 'application/json', 'text/json'. Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either VirtualNetwork or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.VirtualNetwork]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_create_or_update(
        self,
        resource_group_name: str,
        virtual_network_name: str,
        parameters: Union[_models.VirtualNetwork, IO[bytes]],
        **kwargs: Any
    ) -> AsyncLROPoller[_models.VirtualNetwork]:
        """Creates or updates a virtual network in the specified resource group.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param virtual_network_name: The name of the virtual network. Required.
        :type virtual_network_name: str
        :param parameters: Parameters supplied to the create or update virtual network operation. Is
         either a VirtualNetwork type or a IO[bytes] type. Required.
        :type parameters: ~azure.mgmt.network.v2017_10_01.models.VirtualNetwork or IO[bytes]
        :return: An instance of AsyncLROPoller that returns either VirtualNetwork or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.VirtualNetwork]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.VirtualNetwork] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._create_or_update_initial(
                resource_group_name=resource_group_name,
                virtual_network_name=virtual_network_name,
                parameters=parameters,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("VirtualNetwork", pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.VirtualNetwork].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.VirtualNetwork](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    async def _update_tags_initial(
        self,
        resource_group_name: str,
        virtual_network_name: str,
        parameters: Union[_models.TagsObject, IO[bytes]],
        **kwargs: Any
    ) -> _models.VirtualNetwork:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.VirtualNetwork] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IOBase, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "TagsObject")

        _request = build_virtual_networks_update_tags_request(
            resource_group_name=resource_group_name,
            virtual_network_name=virtual_network_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("VirtualNetwork", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_update_tags(
        self,
        resource_group_name: str,
        virtual_network_name: str,
        parameters: _models.TagsObject,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.VirtualNetwork]:
        """Updates a virtual network tags.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param virtual_network_name: The name of the virtual network. Required.
        :type virtual_network_name: str
        :param parameters: Parameters supplied to update virtual network tags. Required.
        :type parameters: ~azure.mgmt.network.v2017_10_01.models.TagsObject
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either VirtualNetwork or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.VirtualNetwork]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_update_tags(
        self,
        resource_group_name: str,
        virtual_network_name: str,
        parameters: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.VirtualNetwork]:
        """Updates a virtual network tags.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param virtual_network_name: The name of the virtual network. Required.
        :type virtual_network_name: str
        :param parameters: Parameters supplied to update virtual network tags. Required.
        :type parameters: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Known values are: 'application/json', 'text/json'. Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either VirtualNetwork or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.VirtualNetwork]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_update_tags(
        self,
        resource_group_name: str,
        virtual_network_name: str,
        parameters: Union[_models.TagsObject, IO[bytes]],
        **kwargs: Any
    ) -> AsyncLROPoller[_models.VirtualNetwork]:
        """Updates a virtual network tags.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param virtual_network_name: The name of the virtual network. Required.
        :type virtual_network_name: str
        :param parameters: Parameters supplied to update virtual network tags. Is either a TagsObject
         type or a IO[bytes] type. Required.
        :type parameters: ~azure.mgmt.network.v2017_10_01.models.TagsObject or IO[bytes]
        :return: An instance of AsyncLROPoller that returns either VirtualNetwork or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.VirtualNetwork]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.VirtualNetwork] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._update_tags_initial(
                resource_group_name=resource_group_name,
                virtual_network_name=virtual_network_name,
                parameters=parameters,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("VirtualNetwork", pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.VirtualNetwork].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.VirtualNetwork](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    @distributed_trace
    def list_all(self, **kwargs: Any) -> AsyncIterable["_models.VirtualNetwork"]:
        """Gets all virtual networks in a subscription.

        :return: An iterator like instance of either VirtualNetwork or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.network.v2017_10_01.models.VirtualNetwork]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[_models.VirtualNetworkListResult] = kwargs.pop("cls", None)

        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_virtual_networks_list_all_request(
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)

            else:
                _request = HttpRequest("GET", next_link)
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("VirtualNetworkListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace
    def list(self, resource_group_name: str, **kwargs: Any) -> AsyncIterable["_models.VirtualNetwork"]:
        """Gets all virtual networks in a resource group.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :return: An iterator like instance of either VirtualNetwork or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.network.v2017_10_01.models.VirtualNetwork]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[_models.VirtualNetworkListResult] = kwargs.pop("cls", None)

        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_virtual_networks_list_request(
                    resource_group_name=resource_group_name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)

            else:
                _request = HttpRequest("GET", next_link)
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("VirtualNetworkListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def check_ip_address_availability(
        self, resource_group_name: str, virtual_network_name: str, *, ip_address: Optional[str] = None, **kwargs: Any
    ) -> _models.IPAddressAvailabilityResult:
        """Checks whether a private IP address is available for use.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param virtual_network_name: The name of the virtual network. Required.
        :type virtual_network_name: str
        :keyword ip_address: The private IP address to be verified. Default value is None.
        :paramtype ip_address: str
        :return: IPAddressAvailabilityResult or the result of cls(response)
        :rtype: ~azure.mgmt.network.v2017_10_01.models.IPAddressAvailabilityResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[_models.IPAddressAvailabilityResult] = kwargs.pop("cls", None)

        _request = build_virtual_networks_check_ip_address_availability_request(
            resource_group_name=resource_group_name,
            virtual_network_name=virtual_network_name,
            subscription_id=self._config.subscription_id,
            ip_address=ip_address,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("IPAddressAvailabilityResult", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def list_usage(
        self, resource_group_name: str, virtual_network_name: str, **kwargs: Any
    ) -> AsyncIterable["_models.VirtualNetworkUsage"]:
        """Lists usage stats.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param virtual_network_name: The name of the virtual network. Required.
        :type virtual_network_name: str
        :return: An iterator like instance of either VirtualNetworkUsage or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.network.v2017_10_01.models.VirtualNetworkUsage]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[_models.VirtualNetworkListUsageResult] = kwargs.pop("cls", None)

        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_virtual_networks_list_usage_request(
                    resource_group_name=resource_group_name,
                    virtual_network_name=virtual_network_name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)

            else:
                _request = HttpRequest("GET", next_link)
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("VirtualNetworkListUsageResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)


class SubnetsOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.network.v2017_10_01.aio.NetworkManagementClient`'s
        :attr:`subnets` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")
        self._api_version = input_args.pop(0) if input_args else kwargs.pop("api_version")

    async def _delete_initial(  # pylint: disable=inconsistent-return-statements
        self, resource_group_name: str, virtual_network_name: str, subnet_name: str, **kwargs: Any
    ) -> None:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_subnets_delete_request(
            resource_group_name=resource_group_name,
            virtual_network_name=virtual_network_name,
            subnet_name=subnet_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def begin_delete(
        self, resource_group_name: str, virtual_network_name: str, subnet_name: str, **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Deletes the specified subnet.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param virtual_network_name: The name of the virtual network. Required.
        :type virtual_network_name: str
        :param subnet_name: The name of the subnet. Required.
        :type subnet_name: str
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._delete_initial(  # type: ignore
                resource_group_name=resource_group_name,
                virtual_network_name=virtual_network_name,
                subnet_name=subnet_name,
                api_version=api_version,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})  # type: ignore

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[None].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[None](self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    @distributed_trace_async
    async def get(
        self,
        resource_group_name: str,
        virtual_network_name: str,
        subnet_name: str,
        *,
        expand: Optional[str] = None,
        **kwargs: Any
    ) -> _models.Subnet:
        """Gets the specified subnet by virtual network and resource group.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param virtual_network_name: The name of the virtual network. Required.
        :type virtual_network_name: str
        :param subnet_name: The name of the subnet. Required.
        :type subnet_name: str
        :keyword expand: Expands referenced resources. Default value is None.
        :paramtype expand: str
        :return: Subnet or the result of cls(response)
        :rtype: ~azure.mgmt.network.v2017_10_01.models.Subnet
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[_models.Subnet] = kwargs.pop("cls", None)

        _request = build_subnets_get_request(
            resource_group_name=resource_group_name,
            virtual_network_name=virtual_network_name,
            subnet_name=subnet_name,
            subscription_id=self._config.subscription_id,
            expand=expand,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("Subnet", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    async def _create_or_update_initial(
        self,
        resource_group_name: str,
        virtual_network_name: str,
        subnet_name: str,
        subnet_parameters: Union[_models.Subnet, IO[bytes]],
        **kwargs: Any
    ) -> _models.Subnet:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.Subnet] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(subnet_parameters, (IOBase, bytes)):
            _content = subnet_parameters
        else:
            _json = self._serialize.body(subnet_parameters, "Subnet")

        _request = build_subnets_create_or_update_request(
            resource_group_name=resource_group_name,
            virtual_network_name=virtual_network_name,
            subnet_name=subnet_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if response.status_code == 200:
            deserialized = self._deserialize("Subnet", pipeline_response)

        if response.status_code == 201:
            deserialized = self._deserialize("Subnet", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_create_or_update(
        self,
        resource_group_name: str,
        virtual_network_name: str,
        subnet_name: str,
        subnet_parameters: _models.Subnet,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.Subnet]:
        """Creates or updates a subnet in the specified virtual network.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param virtual_network_name: The name of the virtual network. Required.
        :type virtual_network_name: str
        :param subnet_name: The name of the subnet. Required.
        :type subnet_name: str
        :param subnet_parameters: Parameters supplied to the create or update subnet operation.
         Required.
        :type subnet_parameters: ~azure.mgmt.network.v2017_10_01.models.Subnet
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either Subnet or the result of
         cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.Subnet]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_create_or_update(
        self,
        resource_group_name: str,
        virtual_network_name: str,
        subnet_name: str,
        subnet_parameters: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.Subnet]:
        """Creates or updates a subnet in the specified virtual network.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param virtual_network_name: The name of the virtual network. Required.
        :type virtual_network_name: str
        :param subnet_name: The name of the subnet. Required.
        :type subnet_name: str
        :param subnet_parameters: Parameters supplied to the create or update subnet operation.
         Required.
        :type subnet_parameters: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Known values are: 'application/json', 'text/json'. Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either Subnet or the result of
         cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.Subnet]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_create_or_update(
        self,
        resource_group_name: str,
        virtual_network_name: str,
        subnet_name: str,
        subnet_parameters: Union[_models.Subnet, IO[bytes]],
        **kwargs: Any
    ) -> AsyncLROPoller[_models.Subnet]:
        """Creates or updates a subnet in the specified virtual network.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param virtual_network_name: The name of the virtual network. Required.
        :type virtual_network_name: str
        :param subnet_name: The name of the subnet. Required.
        :type subnet_name: str
        :param subnet_parameters: Parameters supplied to the create or update subnet operation. Is
         either a Subnet type or a IO[bytes] type. Required.
        :type subnet_parameters: ~azure.mgmt.network.v2017_10_01.models.Subnet or IO[bytes]
        :return: An instance of AsyncLROPoller that returns either Subnet or the result of
         cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.Subnet]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.Subnet] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._create_or_update_initial(
                resource_group_name=resource_group_name,
                virtual_network_name=virtual_network_name,
                subnet_name=subnet_name,
                subnet_parameters=subnet_parameters,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("Subnet", pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.Subnet].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.Subnet](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    @distributed_trace
    def list(
        self, resource_group_name: str, virtual_network_name: str, **kwargs: Any
    ) -> AsyncIterable["_models.Subnet"]:
        """Gets all subnets in a virtual network.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param virtual_network_name: The name of the virtual network. Required.
        :type virtual_network_name: str
        :return: An iterator like instance of either Subnet or the result of cls(response)
        :rtype: ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.network.v2017_10_01.models.Subnet]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[_models.SubnetListResult] = kwargs.pop("cls", None)

        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_subnets_list_request(
                    resource_group_name=resource_group_name,
                    virtual_network_name=virtual_network_name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)

            else:
                _request = HttpRequest("GET", next_link)
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("SubnetListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)


class VirtualNetworkPeeringsOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.network.v2017_10_01.aio.NetworkManagementClient`'s
        :attr:`virtual_network_peerings` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")
        self._api_version = input_args.pop(0) if input_args else kwargs.pop("api_version")

    async def _delete_initial(  # pylint: disable=inconsistent-return-statements
        self, resource_group_name: str, virtual_network_name: str, virtual_network_peering_name: str, **kwargs: Any
    ) -> None:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_virtual_network_peerings_delete_request(
            resource_group_name=resource_group_name,
            virtual_network_name=virtual_network_name,
            virtual_network_peering_name=virtual_network_peering_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def begin_delete(
        self, resource_group_name: str, virtual_network_name: str, virtual_network_peering_name: str, **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Deletes the specified virtual network peering.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param virtual_network_name: The name of the virtual network. Required.
        :type virtual_network_name: str
        :param virtual_network_peering_name: The name of the virtual network peering. Required.
        :type virtual_network_peering_name: str
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._delete_initial(  # type: ignore
                resource_group_name=resource_group_name,
                virtual_network_name=virtual_network_name,
                virtual_network_peering_name=virtual_network_peering_name,
                api_version=api_version,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})  # type: ignore

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[None].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[None](self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    @distributed_trace_async
    async def get(
        self, resource_group_name: str, virtual_network_name: str, virtual_network_peering_name: str, **kwargs: Any
    ) -> _models.VirtualNetworkPeering:
        """Gets the specified virtual network peering.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param virtual_network_name: The name of the virtual network. Required.
        :type virtual_network_name: str
        :param virtual_network_peering_name: The name of the virtual network peering. Required.
        :type virtual_network_peering_name: str
        :return: VirtualNetworkPeering or the result of cls(response)
        :rtype: ~azure.mgmt.network.v2017_10_01.models.VirtualNetworkPeering
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[_models.VirtualNetworkPeering] = kwargs.pop("cls", None)

        _request = build_virtual_network_peerings_get_request(
            resource_group_name=resource_group_name,
            virtual_network_name=virtual_network_name,
            virtual_network_peering_name=virtual_network_peering_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("VirtualNetworkPeering", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    async def _create_or_update_initial(
        self,
        resource_group_name: str,
        virtual_network_name: str,
        virtual_network_peering_name: str,
        virtual_network_peering_parameters: Union[_models.VirtualNetworkPeering, IO[bytes]],
        **kwargs: Any
    ) -> _models.VirtualNetworkPeering:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.VirtualNetworkPeering] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(virtual_network_peering_parameters, (IOBase, bytes)):
            _content = virtual_network_peering_parameters
        else:
            _json = self._serialize.body(virtual_network_peering_parameters, "VirtualNetworkPeering")

        _request = build_virtual_network_peerings_create_or_update_request(
            resource_group_name=resource_group_name,
            virtual_network_name=virtual_network_name,
            virtual_network_peering_name=virtual_network_peering_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if response.status_code == 200:
            deserialized = self._deserialize("VirtualNetworkPeering", pipeline_response)

        if response.status_code == 201:
            deserialized = self._deserialize("VirtualNetworkPeering", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_create_or_update(
        self,
        resource_group_name: str,
        virtual_network_name: str,
        virtual_network_peering_name: str,
        virtual_network_peering_parameters: _models.VirtualNetworkPeering,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.VirtualNetworkPeering]:
        """Creates or updates a peering in the specified virtual network.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param virtual_network_name: The name of the virtual network. Required.
        :type virtual_network_name: str
        :param virtual_network_peering_name: The name of the peering. Required.
        :type virtual_network_peering_name: str
        :param virtual_network_peering_parameters: Parameters supplied to the create or update virtual
         network peering operation. Required.
        :type virtual_network_peering_parameters:
         ~azure.mgmt.network.v2017_10_01.models.VirtualNetworkPeering
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either VirtualNetworkPeering or the result
         of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.VirtualNetworkPeering]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_create_or_update(
        self,
        resource_group_name: str,
        virtual_network_name: str,
        virtual_network_peering_name: str,
        virtual_network_peering_parameters: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.VirtualNetworkPeering]:
        """Creates or updates a peering in the specified virtual network.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param virtual_network_name: The name of the virtual network. Required.
        :type virtual_network_name: str
        :param virtual_network_peering_name: The name of the peering. Required.
        :type virtual_network_peering_name: str
        :param virtual_network_peering_parameters: Parameters supplied to the create or update virtual
         network peering operation. Required.
        :type virtual_network_peering_parameters: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Known values are: 'application/json', 'text/json'. Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either VirtualNetworkPeering or the result
         of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.VirtualNetworkPeering]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_create_or_update(
        self,
        resource_group_name: str,
        virtual_network_name: str,
        virtual_network_peering_name: str,
        virtual_network_peering_parameters: Union[_models.VirtualNetworkPeering, IO[bytes]],
        **kwargs: Any
    ) -> AsyncLROPoller[_models.VirtualNetworkPeering]:
        """Creates or updates a peering in the specified virtual network.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param virtual_network_name: The name of the virtual network. Required.
        :type virtual_network_name: str
        :param virtual_network_peering_name: The name of the peering. Required.
        :type virtual_network_peering_name: str
        :param virtual_network_peering_parameters: Parameters supplied to the create or update virtual
         network peering operation. Is either a VirtualNetworkPeering type or a IO[bytes] type.
         Required.
        :type virtual_network_peering_parameters:
         ~azure.mgmt.network.v2017_10_01.models.VirtualNetworkPeering or IO[bytes]
        :return: An instance of AsyncLROPoller that returns either VirtualNetworkPeering or the result
         of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.VirtualNetworkPeering]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.VirtualNetworkPeering] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._create_or_update_initial(
                resource_group_name=resource_group_name,
                virtual_network_name=virtual_network_name,
                virtual_network_peering_name=virtual_network_peering_name,
                virtual_network_peering_parameters=virtual_network_peering_parameters,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("VirtualNetworkPeering", pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.VirtualNetworkPeering].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.VirtualNetworkPeering](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    @distributed_trace
    def list(
        self, resource_group_name: str, virtual_network_name: str, **kwargs: Any
    ) -> AsyncIterable["_models.VirtualNetworkPeering"]:
        """Gets all virtual network peerings in a virtual network.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param virtual_network_name: The name of the virtual network. Required.
        :type virtual_network_name: str
        :return: An iterator like instance of either VirtualNetworkPeering or the result of
         cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.network.v2017_10_01.models.VirtualNetworkPeering]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[_models.VirtualNetworkPeeringListResult] = kwargs.pop("cls", None)

        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_virtual_network_peerings_list_request(
                    resource_group_name=resource_group_name,
                    virtual_network_name=virtual_network_name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)

            else:
                _request = HttpRequest("GET", next_link)
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("VirtualNetworkPeeringListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)


class VirtualNetworkGatewaysOperations:  # pylint: disable=too-many-public-methods
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.network.v2017_10_01.aio.NetworkManagementClient`'s
        :attr:`virtual_network_gateways` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")
        self._api_version = input_args.pop(0) if input_args else kwargs.pop("api_version")

    async def _create_or_update_initial(
        self,
        resource_group_name: str,
        virtual_network_gateway_name: str,
        parameters: Union[_models.VirtualNetworkGateway, IO[bytes]],
        **kwargs: Any
    ) -> _models.VirtualNetworkGateway:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.VirtualNetworkGateway] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IOBase, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "VirtualNetworkGateway")

        _request = build_virtual_network_gateways_create_or_update_request(
            resource_group_name=resource_group_name,
            virtual_network_gateway_name=virtual_network_gateway_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if response.status_code == 200:
            deserialized = self._deserialize("VirtualNetworkGateway", pipeline_response)

        if response.status_code == 201:
            deserialized = self._deserialize("VirtualNetworkGateway", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_create_or_update(
        self,
        resource_group_name: str,
        virtual_network_gateway_name: str,
        parameters: _models.VirtualNetworkGateway,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.VirtualNetworkGateway]:
        """Creates or updates a virtual network gateway in the specified resource group.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param virtual_network_gateway_name: The name of the virtual network gateway. Required.
        :type virtual_network_gateway_name: str
        :param parameters: Parameters supplied to create or update virtual network gateway operation.
         Required.
        :type parameters: ~azure.mgmt.network.v2017_10_01.models.VirtualNetworkGateway
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either VirtualNetworkGateway or the result
         of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.VirtualNetworkGateway]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_create_or_update(
        self,
        resource_group_name: str,
        virtual_network_gateway_name: str,
        parameters: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.VirtualNetworkGateway]:
        """Creates or updates a virtual network gateway in the specified resource group.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param virtual_network_gateway_name: The name of the virtual network gateway. Required.
        :type virtual_network_gateway_name: str
        :param parameters: Parameters supplied to create or update virtual network gateway operation.
         Required.
        :type parameters: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Known values are: 'application/json', 'text/json'. Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either VirtualNetworkGateway or the result
         of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.VirtualNetworkGateway]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_create_or_update(
        self,
        resource_group_name: str,
        virtual_network_gateway_name: str,
        parameters: Union[_models.VirtualNetworkGateway, IO[bytes]],
        **kwargs: Any
    ) -> AsyncLROPoller[_models.VirtualNetworkGateway]:
        """Creates or updates a virtual network gateway in the specified resource group.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param virtual_network_gateway_name: The name of the virtual network gateway. Required.
        :type virtual_network_gateway_name: str
        :param parameters: Parameters supplied to create or update virtual network gateway operation.
         Is either a VirtualNetworkGateway type or a IO[bytes] type. Required.
        :type parameters: ~azure.mgmt.network.v2017_10_01.models.VirtualNetworkGateway or IO[bytes]
        :return: An instance of AsyncLROPoller that returns either VirtualNetworkGateway or the result
         of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.VirtualNetworkGateway]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.VirtualNetworkGateway] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._create_or_update_initial(
                resource_group_name=resource_group_name,
                virtual_network_gateway_name=virtual_network_gateway_name,
                parameters=parameters,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("VirtualNetworkGateway", pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.VirtualNetworkGateway].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.VirtualNetworkGateway](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    @distributed_trace_async
    async def get(
        self, resource_group_name: str, virtual_network_gateway_name: str, **kwargs: Any
    ) -> _models.VirtualNetworkGateway:
        """Gets the specified virtual network gateway by resource group.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param virtual_network_gateway_name: The name of the virtual network gateway. Required.
        :type virtual_network_gateway_name: str
        :return: VirtualNetworkGateway or the result of cls(response)
        :rtype: ~azure.mgmt.network.v2017_10_01.models.VirtualNetworkGateway
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[_models.VirtualNetworkGateway] = kwargs.pop("cls", None)

        _request = build_virtual_network_gateways_get_request(
            resource_group_name=resource_group_name,
            virtual_network_gateway_name=virtual_network_gateway_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("VirtualNetworkGateway", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    async def _delete_initial(  # pylint: disable=inconsistent-return-statements
        self, resource_group_name: str, virtual_network_gateway_name: str, **kwargs: Any
    ) -> None:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_virtual_network_gateways_delete_request(
            resource_group_name=resource_group_name,
            virtual_network_gateway_name=virtual_network_gateway_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def begin_delete(
        self, resource_group_name: str, virtual_network_gateway_name: str, **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Deletes the specified virtual network gateway.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param virtual_network_gateway_name: The name of the virtual network gateway. Required.
        :type virtual_network_gateway_name: str
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._delete_initial(  # type: ignore
                resource_group_name=resource_group_name,
                virtual_network_gateway_name=virtual_network_gateway_name,
                api_version=api_version,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})  # type: ignore

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod, AsyncARMPolling(lro_delay, lro_options={"final-state-via": "location"}, **kwargs)
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[None].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[None](self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    async def _update_tags_initial(
        self,
        resource_group_name: str,
        virtual_network_gateway_name: str,
        parameters: Union[_models.TagsObject, IO[bytes]],
        **kwargs: Any
    ) -> _models.VirtualNetworkGateway:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.VirtualNetworkGateway] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IOBase, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "TagsObject")

        _request = build_virtual_network_gateways_update_tags_request(
            resource_group_name=resource_group_name,
            virtual_network_gateway_name=virtual_network_gateway_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("VirtualNetworkGateway", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_update_tags(
        self,
        resource_group_name: str,
        virtual_network_gateway_name: str,
        parameters: _models.TagsObject,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.VirtualNetworkGateway]:
        """Updates a virtual network gateway tags.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param virtual_network_gateway_name: The name of the virtual network gateway. Required.
        :type virtual_network_gateway_name: str
        :param parameters: Parameters supplied to update virtual network gateway tags. Required.
        :type parameters: ~azure.mgmt.network.v2017_10_01.models.TagsObject
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either VirtualNetworkGateway or the result
         of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.VirtualNetworkGateway]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_update_tags(
        self,
        resource_group_name: str,
        virtual_network_gateway_name: str,
        parameters: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.VirtualNetworkGateway]:
        """Updates a virtual network gateway tags.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param virtual_network_gateway_name: The name of the virtual network gateway. Required.
        :type virtual_network_gateway_name: str
        :param parameters: Parameters supplied to update virtual network gateway tags. Required.
        :type parameters: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Known values are: 'application/json', 'text/json'. Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either VirtualNetworkGateway or the result
         of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.VirtualNetworkGateway]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_update_tags(
        self,
        resource_group_name: str,
        virtual_network_gateway_name: str,
        parameters: Union[_models.TagsObject, IO[bytes]],
        **kwargs: Any
    ) -> AsyncLROPoller[_models.VirtualNetworkGateway]:
        """Updates a virtual network gateway tags.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param virtual_network_gateway_name: The name of the virtual network gateway. Required.
        :type virtual_network_gateway_name: str
        :param parameters: Parameters supplied to update virtual network gateway tags. Is either a
         TagsObject type or a IO[bytes] type. Required.
        :type parameters: ~azure.mgmt.network.v2017_10_01.models.TagsObject or IO[bytes]
        :return: An instance of AsyncLROPoller that returns either VirtualNetworkGateway or the result
         of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.VirtualNetworkGateway]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.VirtualNetworkGateway] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._update_tags_initial(
                resource_group_name=resource_group_name,
                virtual_network_gateway_name=virtual_network_gateway_name,
                parameters=parameters,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("VirtualNetworkGateway", pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.VirtualNetworkGateway].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.VirtualNetworkGateway](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    @distributed_trace
    def list(self, resource_group_name: str, **kwargs: Any) -> AsyncIterable["_models.VirtualNetworkGateway"]:
        """Gets all virtual network gateways by resource group.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :return: An iterator like instance of either VirtualNetworkGateway or the result of
         cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.network.v2017_10_01.models.VirtualNetworkGateway]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[_models.VirtualNetworkGatewayListResult] = kwargs.pop("cls", None)

        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_virtual_network_gateways_list_request(
                    resource_group_name=resource_group_name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)

            else:
                _request = HttpRequest("GET", next_link)
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("VirtualNetworkGatewayListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace
    def list_connections(
        self, resource_group_name: str, virtual_network_gateway_name: str, **kwargs: Any
    ) -> AsyncIterable["_models.VirtualNetworkGatewayConnectionListEntity"]:
        """Gets all the connections in a virtual network gateway.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param virtual_network_gateway_name: The name of the virtual network gateway. Required.
        :type virtual_network_gateway_name: str
        :return: An iterator like instance of either VirtualNetworkGatewayConnectionListEntity or the
         result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.network.v2017_10_01.models.VirtualNetworkGatewayConnectionListEntity]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[_models.VirtualNetworkGatewayListConnectionsResult] = kwargs.pop("cls", None)

        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_virtual_network_gateways_list_connections_request(
                    resource_group_name=resource_group_name,
                    virtual_network_gateway_name=virtual_network_gateway_name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)

            else:
                _request = HttpRequest("GET", next_link)
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("VirtualNetworkGatewayListConnectionsResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    async def _reset_initial(
        self,
        resource_group_name: str,
        virtual_network_gateway_name: str,
        *,
        gateway_vip: Optional[str] = None,
        **kwargs: Any
    ) -> Optional[_models.VirtualNetworkGateway]:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[Optional[_models.VirtualNetworkGateway]] = kwargs.pop("cls", None)

        _request = build_virtual_network_gateways_reset_request(
            resource_group_name=resource_group_name,
            virtual_network_gateway_name=virtual_network_gateway_name,
            subscription_id=self._config.subscription_id,
            gateway_vip=gateway_vip,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize("VirtualNetworkGateway", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def begin_reset(
        self,
        resource_group_name: str,
        virtual_network_gateway_name: str,
        *,
        gateway_vip: Optional[str] = None,
        **kwargs: Any
    ) -> AsyncLROPoller[_models.VirtualNetworkGateway]:
        """Resets the primary of the virtual network gateway in the specified resource group.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param virtual_network_gateway_name: The name of the virtual network gateway. Required.
        :type virtual_network_gateway_name: str
        :keyword gateway_vip: Virtual network gateway vip address supplied to the begin reset of the
         active-active feature enabled gateway. Default value is None.
        :paramtype gateway_vip: str
        :return: An instance of AsyncLROPoller that returns either VirtualNetworkGateway or the result
         of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.VirtualNetworkGateway]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[_models.VirtualNetworkGateway] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._reset_initial(
                resource_group_name=resource_group_name,
                virtual_network_gateway_name=virtual_network_gateway_name,
                gateway_vip=gateway_vip,
                api_version=api_version,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("VirtualNetworkGateway", pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod, AsyncARMPolling(lro_delay, lro_options={"final-state-via": "location"}, **kwargs)
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.VirtualNetworkGateway].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.VirtualNetworkGateway](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    async def _generatevpnclientpackage_initial(
        self,
        resource_group_name: str,
        virtual_network_gateway_name: str,
        parameters: Union[_models.VpnClientParameters, IO[bytes]],
        **kwargs: Any
    ) -> Optional[str]:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[Optional[str]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IOBase, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "VpnClientParameters")

        _request = build_virtual_network_gateways_generatevpnclientpackage_request(
            resource_group_name=resource_group_name,
            virtual_network_gateway_name=virtual_network_gateway_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize("str", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_generatevpnclientpackage(
        self,
        resource_group_name: str,
        virtual_network_gateway_name: str,
        parameters: _models.VpnClientParameters,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[str]:
        """Generates VPN client package for P2S client of the virtual network gateway in the specified
        resource group.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param virtual_network_gateway_name: The name of the virtual network gateway. Required.
        :type virtual_network_gateway_name: str
        :param parameters: Parameters supplied to the generate virtual network gateway VPN client
         package operation. Required.
        :type parameters: ~azure.mgmt.network.v2017_10_01.models.VpnClientParameters
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either str or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[str]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_generatevpnclientpackage(
        self,
        resource_group_name: str,
        virtual_network_gateway_name: str,
        parameters: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[str]:
        """Generates VPN client package for P2S client of the virtual network gateway in the specified
        resource group.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param virtual_network_gateway_name: The name of the virtual network gateway. Required.
        :type virtual_network_gateway_name: str
        :param parameters: Parameters supplied to the generate virtual network gateway VPN client
         package operation. Required.
        :type parameters: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Known values are: 'application/json', 'text/json'. Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either str or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[str]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_generatevpnclientpackage(
        self,
        resource_group_name: str,
        virtual_network_gateway_name: str,
        parameters: Union[_models.VpnClientParameters, IO[bytes]],
        **kwargs: Any
    ) -> AsyncLROPoller[str]:
        """Generates VPN client package for P2S client of the virtual network gateway in the specified
        resource group.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param virtual_network_gateway_name: The name of the virtual network gateway. Required.
        :type virtual_network_gateway_name: str
        :param parameters: Parameters supplied to the generate virtual network gateway VPN client
         package operation. Is either a VpnClientParameters type or a IO[bytes] type. Required.
        :type parameters: ~azure.mgmt.network.v2017_10_01.models.VpnClientParameters or IO[bytes]
        :return: An instance of AsyncLROPoller that returns either str or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[str]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[str] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._generatevpnclientpackage_initial(
                resource_group_name=resource_group_name,
                virtual_network_gateway_name=virtual_network_gateway_name,
                parameters=parameters,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("str", pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod, AsyncARMPolling(lro_delay, lro_options={"final-state-via": "location"}, **kwargs)
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[str].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[str](self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    async def _generate_vpn_profile_initial(
        self,
        resource_group_name: str,
        virtual_network_gateway_name: str,
        parameters: Union[_models.VpnClientParameters, IO[bytes]],
        **kwargs: Any
    ) -> Optional[str]:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[Optional[str]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IOBase, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "VpnClientParameters")

        _request = build_virtual_network_gateways_generate_vpn_profile_request(
            resource_group_name=resource_group_name,
            virtual_network_gateway_name=virtual_network_gateway_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize("str", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_generate_vpn_profile(
        self,
        resource_group_name: str,
        virtual_network_gateway_name: str,
        parameters: _models.VpnClientParameters,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[str]:
        """Generates VPN profile for P2S client of the virtual network gateway in the specified resource
        group. Used for IKEV2 and radius based authentication.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param virtual_network_gateway_name: The name of the virtual network gateway. Required.
        :type virtual_network_gateway_name: str
        :param parameters: Parameters supplied to the generate virtual network gateway VPN client
         package operation. Required.
        :type parameters: ~azure.mgmt.network.v2017_10_01.models.VpnClientParameters
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either str or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[str]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_generate_vpn_profile(
        self,
        resource_group_name: str,
        virtual_network_gateway_name: str,
        parameters: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[str]:
        """Generates VPN profile for P2S client of the virtual network gateway in the specified resource
        group. Used for IKEV2 and radius based authentication.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param virtual_network_gateway_name: The name of the virtual network gateway. Required.
        :type virtual_network_gateway_name: str
        :param parameters: Parameters supplied to the generate virtual network gateway VPN client
         package operation. Required.
        :type parameters: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Known values are: 'application/json', 'text/json'. Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either str or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[str]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_generate_vpn_profile(
        self,
        resource_group_name: str,
        virtual_network_gateway_name: str,
        parameters: Union[_models.VpnClientParameters, IO[bytes]],
        **kwargs: Any
    ) -> AsyncLROPoller[str]:
        """Generates VPN profile for P2S client of the virtual network gateway in the specified resource
        group. Used for IKEV2 and radius based authentication.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param virtual_network_gateway_name: The name of the virtual network gateway. Required.
        :type virtual_network_gateway_name: str
        :param parameters: Parameters supplied to the generate virtual network gateway VPN client
         package operation. Is either a VpnClientParameters type or a IO[bytes] type. Required.
        :type parameters: ~azure.mgmt.network.v2017_10_01.models.VpnClientParameters or IO[bytes]
        :return: An instance of AsyncLROPoller that returns either str or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[str]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[str] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._generate_vpn_profile_initial(
                resource_group_name=resource_group_name,
                virtual_network_gateway_name=virtual_network_gateway_name,
                parameters=parameters,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("str", pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod, AsyncARMPolling(lro_delay, lro_options={"final-state-via": "location"}, **kwargs)
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[str].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[str](self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    async def _get_vpn_profile_package_url_initial(
        self, resource_group_name: str, virtual_network_gateway_name: str, **kwargs: Any
    ) -> Optional[str]:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[Optional[str]] = kwargs.pop("cls", None)

        _request = build_virtual_network_gateways_get_vpn_profile_package_url_request(
            resource_group_name=resource_group_name,
            virtual_network_gateway_name=virtual_network_gateway_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize("str", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def begin_get_vpn_profile_package_url(
        self, resource_group_name: str, virtual_network_gateway_name: str, **kwargs: Any
    ) -> AsyncLROPoller[str]:
        """Gets pre-generated VPN profile for P2S client of the virtual network gateway in the specified
        resource group. The profile needs to be generated first using generateVpnProfile.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param virtual_network_gateway_name: The name of the virtual network gateway. Required.
        :type virtual_network_gateway_name: str
        :return: An instance of AsyncLROPoller that returns either str or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[str]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[str] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._get_vpn_profile_package_url_initial(
                resource_group_name=resource_group_name,
                virtual_network_gateway_name=virtual_network_gateway_name,
                api_version=api_version,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("str", pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod, AsyncARMPolling(lro_delay, lro_options={"final-state-via": "location"}, **kwargs)
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[str].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[str](self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    async def _get_bgp_peer_status_initial(
        self, resource_group_name: str, virtual_network_gateway_name: str, *, peer: Optional[str] = None, **kwargs: Any
    ) -> Optional[_models.BgpPeerStatusListResult]:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[Optional[_models.BgpPeerStatusListResult]] = kwargs.pop("cls", None)

        _request = build_virtual_network_gateways_get_bgp_peer_status_request(
            resource_group_name=resource_group_name,
            virtual_network_gateway_name=virtual_network_gateway_name,
            subscription_id=self._config.subscription_id,
            peer=peer,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize("BgpPeerStatusListResult", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def begin_get_bgp_peer_status(
        self, resource_group_name: str, virtual_network_gateway_name: str, *, peer: Optional[str] = None, **kwargs: Any
    ) -> AsyncLROPoller[_models.BgpPeerStatusListResult]:
        """The GetBgpPeerStatus operation retrieves the status of all BGP peers.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param virtual_network_gateway_name: The name of the virtual network gateway. Required.
        :type virtual_network_gateway_name: str
        :keyword peer: The IP address of the peer to retrieve the status of. Default value is None.
        :paramtype peer: str
        :return: An instance of AsyncLROPoller that returns either BgpPeerStatusListResult or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.BgpPeerStatusListResult]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[_models.BgpPeerStatusListResult] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._get_bgp_peer_status_initial(
                resource_group_name=resource_group_name,
                virtual_network_gateway_name=virtual_network_gateway_name,
                peer=peer,
                api_version=api_version,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("BgpPeerStatusListResult", pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod, AsyncARMPolling(lro_delay, lro_options={"final-state-via": "location"}, **kwargs)
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.BgpPeerStatusListResult].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.BgpPeerStatusListResult](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    @distributed_trace_async
    async def supported_vpn_devices(
        self, resource_group_name: str, virtual_network_gateway_name: str, **kwargs: Any
    ) -> str:
        """Gets a xml format representation for supported vpn devices.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param virtual_network_gateway_name: The name of the virtual network gateway. Required.
        :type virtual_network_gateway_name: str
        :return: str or the result of cls(response)
        :rtype: str
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[str] = kwargs.pop("cls", None)

        _request = build_virtual_network_gateways_supported_vpn_devices_request(
            resource_group_name=resource_group_name,
            virtual_network_gateway_name=virtual_network_gateway_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("str", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    async def _get_learned_routes_initial(
        self, resource_group_name: str, virtual_network_gateway_name: str, **kwargs: Any
    ) -> Optional[_models.GatewayRouteListResult]:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[Optional[_models.GatewayRouteListResult]] = kwargs.pop("cls", None)

        _request = build_virtual_network_gateways_get_learned_routes_request(
            resource_group_name=resource_group_name,
            virtual_network_gateway_name=virtual_network_gateway_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize("GatewayRouteListResult", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def begin_get_learned_routes(
        self, resource_group_name: str, virtual_network_gateway_name: str, **kwargs: Any
    ) -> AsyncLROPoller[_models.GatewayRouteListResult]:
        """This operation retrieves a list of routes the virtual network gateway has learned, including
        routes learned from BGP peers.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param virtual_network_gateway_name: The name of the virtual network gateway. Required.
        :type virtual_network_gateway_name: str
        :return: An instance of AsyncLROPoller that returns either GatewayRouteListResult or the result
         of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.GatewayRouteListResult]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[_models.GatewayRouteListResult] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._get_learned_routes_initial(
                resource_group_name=resource_group_name,
                virtual_network_gateway_name=virtual_network_gateway_name,
                api_version=api_version,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("GatewayRouteListResult", pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod, AsyncARMPolling(lro_delay, lro_options={"final-state-via": "location"}, **kwargs)
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.GatewayRouteListResult].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.GatewayRouteListResult](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    async def _get_advertised_routes_initial(
        self, resource_group_name: str, virtual_network_gateway_name: str, *, peer: str, **kwargs: Any
    ) -> Optional[_models.GatewayRouteListResult]:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[Optional[_models.GatewayRouteListResult]] = kwargs.pop("cls", None)

        _request = build_virtual_network_gateways_get_advertised_routes_request(
            resource_group_name=resource_group_name,
            virtual_network_gateway_name=virtual_network_gateway_name,
            subscription_id=self._config.subscription_id,
            peer=peer,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize("GatewayRouteListResult", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def begin_get_advertised_routes(
        self, resource_group_name: str, virtual_network_gateway_name: str, *, peer: str, **kwargs: Any
    ) -> AsyncLROPoller[_models.GatewayRouteListResult]:
        """This operation retrieves a list of routes the virtual network gateway is advertising to the
        specified peer.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param virtual_network_gateway_name: The name of the virtual network gateway. Required.
        :type virtual_network_gateway_name: str
        :keyword peer: The IP address of the peer. Required.
        :paramtype peer: str
        :return: An instance of AsyncLROPoller that returns either GatewayRouteListResult or the result
         of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.GatewayRouteListResult]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[_models.GatewayRouteListResult] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._get_advertised_routes_initial(
                resource_group_name=resource_group_name,
                virtual_network_gateway_name=virtual_network_gateway_name,
                peer=peer,
                api_version=api_version,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("GatewayRouteListResult", pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod, AsyncARMPolling(lro_delay, lro_options={"final-state-via": "location"}, **kwargs)
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.GatewayRouteListResult].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.GatewayRouteListResult](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    @overload
    async def vpn_device_configuration_script(
        self,
        resource_group_name: str,
        virtual_network_gateway_connection_name: str,
        parameters: _models.VpnDeviceScriptParameters,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> str:
        """Gets a xml format representation for vpn device configuration script.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param virtual_network_gateway_connection_name: The name of the virtual network gateway
         connection for which the configuration script is generated. Required.
        :type virtual_network_gateway_connection_name: str
        :param parameters: Parameters supplied to the generate vpn device script operation. Required.
        :type parameters: ~azure.mgmt.network.v2017_10_01.models.VpnDeviceScriptParameters
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: str or the result of cls(response)
        :rtype: str
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def vpn_device_configuration_script(
        self,
        resource_group_name: str,
        virtual_network_gateway_connection_name: str,
        parameters: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> str:
        """Gets a xml format representation for vpn device configuration script.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param virtual_network_gateway_connection_name: The name of the virtual network gateway
         connection for which the configuration script is generated. Required.
        :type virtual_network_gateway_connection_name: str
        :param parameters: Parameters supplied to the generate vpn device script operation. Required.
        :type parameters: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Known values are: 'application/json', 'text/json'. Default value is "application/json".
        :paramtype content_type: str
        :return: str or the result of cls(response)
        :rtype: str
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def vpn_device_configuration_script(
        self,
        resource_group_name: str,
        virtual_network_gateway_connection_name: str,
        parameters: Union[_models.VpnDeviceScriptParameters, IO[bytes]],
        **kwargs: Any
    ) -> str:
        """Gets a xml format representation for vpn device configuration script.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param virtual_network_gateway_connection_name: The name of the virtual network gateway
         connection for which the configuration script is generated. Required.
        :type virtual_network_gateway_connection_name: str
        :param parameters: Parameters supplied to the generate vpn device script operation. Is either a
         VpnDeviceScriptParameters type or a IO[bytes] type. Required.
        :type parameters: ~azure.mgmt.network.v2017_10_01.models.VpnDeviceScriptParameters or IO[bytes]
        :return: str or the result of cls(response)
        :rtype: str
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[str] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IOBase, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "VpnDeviceScriptParameters")

        _request = build_virtual_network_gateways_vpn_device_configuration_script_request(
            resource_group_name=resource_group_name,
            virtual_network_gateway_connection_name=virtual_network_gateway_connection_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("str", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore


class VirtualNetworkGatewayConnectionsOperations:  # pylint: disable=name-too-long
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.network.v2017_10_01.aio.NetworkManagementClient`'s
        :attr:`virtual_network_gateway_connections` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")
        self._api_version = input_args.pop(0) if input_args else kwargs.pop("api_version")

    async def _create_or_update_initial(
        self,
        resource_group_name: str,
        virtual_network_gateway_connection_name: str,
        parameters: Union[_models.VirtualNetworkGatewayConnection, IO[bytes]],
        **kwargs: Any
    ) -> _models.VirtualNetworkGatewayConnection:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.VirtualNetworkGatewayConnection] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IOBase, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "VirtualNetworkGatewayConnection")

        _request = build_virtual_network_gateway_connections_create_or_update_request(
            resource_group_name=resource_group_name,
            virtual_network_gateway_connection_name=virtual_network_gateway_connection_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if response.status_code == 200:
            deserialized = self._deserialize("VirtualNetworkGatewayConnection", pipeline_response)

        if response.status_code == 201:
            deserialized = self._deserialize("VirtualNetworkGatewayConnection", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_create_or_update(
        self,
        resource_group_name: str,
        virtual_network_gateway_connection_name: str,
        parameters: _models.VirtualNetworkGatewayConnection,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.VirtualNetworkGatewayConnection]:
        """Creates or updates a virtual network gateway connection in the specified resource group.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param virtual_network_gateway_connection_name: The name of the virtual network gateway
         connection. Required.
        :type virtual_network_gateway_connection_name: str
        :param parameters: Parameters supplied to the create or update virtual network gateway
         connection operation. Required.
        :type parameters: ~azure.mgmt.network.v2017_10_01.models.VirtualNetworkGatewayConnection
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either VirtualNetworkGatewayConnection or
         the result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.VirtualNetworkGatewayConnection]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_create_or_update(
        self,
        resource_group_name: str,
        virtual_network_gateway_connection_name: str,
        parameters: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.VirtualNetworkGatewayConnection]:
        """Creates or updates a virtual network gateway connection in the specified resource group.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param virtual_network_gateway_connection_name: The name of the virtual network gateway
         connection. Required.
        :type virtual_network_gateway_connection_name: str
        :param parameters: Parameters supplied to the create or update virtual network gateway
         connection operation. Required.
        :type parameters: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Known values are: 'application/json', 'text/json'. Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either VirtualNetworkGatewayConnection or
         the result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.VirtualNetworkGatewayConnection]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_create_or_update(
        self,
        resource_group_name: str,
        virtual_network_gateway_connection_name: str,
        parameters: Union[_models.VirtualNetworkGatewayConnection, IO[bytes]],
        **kwargs: Any
    ) -> AsyncLROPoller[_models.VirtualNetworkGatewayConnection]:
        """Creates or updates a virtual network gateway connection in the specified resource group.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param virtual_network_gateway_connection_name: The name of the virtual network gateway
         connection. Required.
        :type virtual_network_gateway_connection_name: str
        :param parameters: Parameters supplied to the create or update virtual network gateway
         connection operation. Is either a VirtualNetworkGatewayConnection type or a IO[bytes] type.
         Required.
        :type parameters: ~azure.mgmt.network.v2017_10_01.models.VirtualNetworkGatewayConnection or
         IO[bytes]
        :return: An instance of AsyncLROPoller that returns either VirtualNetworkGatewayConnection or
         the result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.VirtualNetworkGatewayConnection]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.VirtualNetworkGatewayConnection] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._create_or_update_initial(
                resource_group_name=resource_group_name,
                virtual_network_gateway_connection_name=virtual_network_gateway_connection_name,
                parameters=parameters,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("VirtualNetworkGatewayConnection", pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.VirtualNetworkGatewayConnection].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.VirtualNetworkGatewayConnection](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    @distributed_trace_async
    async def get(
        self, resource_group_name: str, virtual_network_gateway_connection_name: str, **kwargs: Any
    ) -> _models.VirtualNetworkGatewayConnection:
        """Gets the specified virtual network gateway connection by resource group.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param virtual_network_gateway_connection_name: The name of the virtual network gateway
         connection. Required.
        :type virtual_network_gateway_connection_name: str
        :return: VirtualNetworkGatewayConnection or the result of cls(response)
        :rtype: ~azure.mgmt.network.v2017_10_01.models.VirtualNetworkGatewayConnection
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[_models.VirtualNetworkGatewayConnection] = kwargs.pop("cls", None)

        _request = build_virtual_network_gateway_connections_get_request(
            resource_group_name=resource_group_name,
            virtual_network_gateway_connection_name=virtual_network_gateway_connection_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("VirtualNetworkGatewayConnection", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    async def _delete_initial(  # pylint: disable=inconsistent-return-statements
        self, resource_group_name: str, virtual_network_gateway_connection_name: str, **kwargs: Any
    ) -> None:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_virtual_network_gateway_connections_delete_request(
            resource_group_name=resource_group_name,
            virtual_network_gateway_connection_name=virtual_network_gateway_connection_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def begin_delete(
        self, resource_group_name: str, virtual_network_gateway_connection_name: str, **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Deletes the specified virtual network Gateway connection.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param virtual_network_gateway_connection_name: The name of the virtual network gateway
         connection. Required.
        :type virtual_network_gateway_connection_name: str
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._delete_initial(  # type: ignore
                resource_group_name=resource_group_name,
                virtual_network_gateway_connection_name=virtual_network_gateway_connection_name,
                api_version=api_version,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})  # type: ignore

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod, AsyncARMPolling(lro_delay, lro_options={"final-state-via": "location"}, **kwargs)
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[None].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[None](self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    async def _update_tags_initial(
        self,
        resource_group_name: str,
        virtual_network_gateway_connection_name: str,
        parameters: Union[_models.TagsObject, IO[bytes]],
        **kwargs: Any
    ) -> _models.VirtualNetworkGatewayConnectionListEntity:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.VirtualNetworkGatewayConnectionListEntity] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IOBase, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "TagsObject")

        _request = build_virtual_network_gateway_connections_update_tags_request(
            resource_group_name=resource_group_name,
            virtual_network_gateway_connection_name=virtual_network_gateway_connection_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("VirtualNetworkGatewayConnectionListEntity", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_update_tags(
        self,
        resource_group_name: str,
        virtual_network_gateway_connection_name: str,
        parameters: _models.TagsObject,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.VirtualNetworkGatewayConnectionListEntity]:
        """Updates a virtual network gateway connection tags.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param virtual_network_gateway_connection_name: The name of the virtual network gateway
         connection. Required.
        :type virtual_network_gateway_connection_name: str
        :param parameters: Parameters supplied to update virtual network gateway connection tags.
         Required.
        :type parameters: ~azure.mgmt.network.v2017_10_01.models.TagsObject
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either
         VirtualNetworkGatewayConnectionListEntity or the result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.VirtualNetworkGatewayConnectionListEntity]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_update_tags(
        self,
        resource_group_name: str,
        virtual_network_gateway_connection_name: str,
        parameters: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.VirtualNetworkGatewayConnectionListEntity]:
        """Updates a virtual network gateway connection tags.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param virtual_network_gateway_connection_name: The name of the virtual network gateway
         connection. Required.
        :type virtual_network_gateway_connection_name: str
        :param parameters: Parameters supplied to update virtual network gateway connection tags.
         Required.
        :type parameters: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Known values are: 'application/json', 'text/json'. Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either
         VirtualNetworkGatewayConnectionListEntity or the result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.VirtualNetworkGatewayConnectionListEntity]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_update_tags(
        self,
        resource_group_name: str,
        virtual_network_gateway_connection_name: str,
        parameters: Union[_models.TagsObject, IO[bytes]],
        **kwargs: Any
    ) -> AsyncLROPoller[_models.VirtualNetworkGatewayConnectionListEntity]:
        """Updates a virtual network gateway connection tags.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param virtual_network_gateway_connection_name: The name of the virtual network gateway
         connection. Required.
        :type virtual_network_gateway_connection_name: str
        :param parameters: Parameters supplied to update virtual network gateway connection tags. Is
         either a TagsObject type or a IO[bytes] type. Required.
        :type parameters: ~azure.mgmt.network.v2017_10_01.models.TagsObject or IO[bytes]
        :return: An instance of AsyncLROPoller that returns either
         VirtualNetworkGatewayConnectionListEntity or the result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.VirtualNetworkGatewayConnectionListEntity]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.VirtualNetworkGatewayConnectionListEntity] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._update_tags_initial(
                resource_group_name=resource_group_name,
                virtual_network_gateway_connection_name=virtual_network_gateway_connection_name,
                parameters=parameters,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("VirtualNetworkGatewayConnectionListEntity", pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.VirtualNetworkGatewayConnectionListEntity].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.VirtualNetworkGatewayConnectionListEntity](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    async def _set_shared_key_initial(
        self,
        resource_group_name: str,
        virtual_network_gateway_connection_name: str,
        parameters: Union[_models.ConnectionSharedKey, IO[bytes]],
        **kwargs: Any
    ) -> _models.ConnectionSharedKey:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.ConnectionSharedKey] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IOBase, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "ConnectionSharedKey")

        _request = build_virtual_network_gateway_connections_set_shared_key_request(
            resource_group_name=resource_group_name,
            virtual_network_gateway_connection_name=virtual_network_gateway_connection_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if response.status_code == 200:
            deserialized = self._deserialize("ConnectionSharedKey", pipeline_response)

        if response.status_code == 201:
            deserialized = self._deserialize("ConnectionSharedKey", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_set_shared_key(
        self,
        resource_group_name: str,
        virtual_network_gateway_connection_name: str,
        parameters: _models.ConnectionSharedKey,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.ConnectionSharedKey]:
        """The Put VirtualNetworkGatewayConnectionSharedKey operation sets the virtual network gateway
        connection shared key for passed virtual network gateway connection in the specified resource
        group through Network resource provider.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param virtual_network_gateway_connection_name: The virtual network gateway connection name.
         Required.
        :type virtual_network_gateway_connection_name: str
        :param parameters: Parameters supplied to the Begin Set Virtual Network Gateway connection
         Shared key operation throughNetwork resource provider. Required.
        :type parameters: ~azure.mgmt.network.v2017_10_01.models.ConnectionSharedKey
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either ConnectionSharedKey or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.ConnectionSharedKey]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_set_shared_key(
        self,
        resource_group_name: str,
        virtual_network_gateway_connection_name: str,
        parameters: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.ConnectionSharedKey]:
        """The Put VirtualNetworkGatewayConnectionSharedKey operation sets the virtual network gateway
        connection shared key for passed virtual network gateway connection in the specified resource
        group through Network resource provider.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param virtual_network_gateway_connection_name: The virtual network gateway connection name.
         Required.
        :type virtual_network_gateway_connection_name: str
        :param parameters: Parameters supplied to the Begin Set Virtual Network Gateway connection
         Shared key operation throughNetwork resource provider. Required.
        :type parameters: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Known values are: 'application/json', 'text/json'. Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either ConnectionSharedKey or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.ConnectionSharedKey]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_set_shared_key(
        self,
        resource_group_name: str,
        virtual_network_gateway_connection_name: str,
        parameters: Union[_models.ConnectionSharedKey, IO[bytes]],
        **kwargs: Any
    ) -> AsyncLROPoller[_models.ConnectionSharedKey]:
        """The Put VirtualNetworkGatewayConnectionSharedKey operation sets the virtual network gateway
        connection shared key for passed virtual network gateway connection in the specified resource
        group through Network resource provider.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param virtual_network_gateway_connection_name: The virtual network gateway connection name.
         Required.
        :type virtual_network_gateway_connection_name: str
        :param parameters: Parameters supplied to the Begin Set Virtual Network Gateway connection
         Shared key operation throughNetwork resource provider. Is either a ConnectionSharedKey type or
         a IO[bytes] type. Required.
        :type parameters: ~azure.mgmt.network.v2017_10_01.models.ConnectionSharedKey or IO[bytes]
        :return: An instance of AsyncLROPoller that returns either ConnectionSharedKey or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.ConnectionSharedKey]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.ConnectionSharedKey] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._set_shared_key_initial(
                resource_group_name=resource_group_name,
                virtual_network_gateway_connection_name=virtual_network_gateway_connection_name,
                parameters=parameters,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("ConnectionSharedKey", pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.ConnectionSharedKey].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.ConnectionSharedKey](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    @distributed_trace_async
    async def get_shared_key(
        self, resource_group_name: str, virtual_network_gateway_connection_name: str, **kwargs: Any
    ) -> _models.ConnectionSharedKey:
        """The Get VirtualNetworkGatewayConnectionSharedKey operation retrieves information about the
        specified virtual network gateway connection shared key through Network resource provider.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param virtual_network_gateway_connection_name: The virtual network gateway connection shared
         key name. Required.
        :type virtual_network_gateway_connection_name: str
        :return: ConnectionSharedKey or the result of cls(response)
        :rtype: ~azure.mgmt.network.v2017_10_01.models.ConnectionSharedKey
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[_models.ConnectionSharedKey] = kwargs.pop("cls", None)

        _request = build_virtual_network_gateway_connections_get_shared_key_request(
            resource_group_name=resource_group_name,
            virtual_network_gateway_connection_name=virtual_network_gateway_connection_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("ConnectionSharedKey", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def list(self, resource_group_name: str, **kwargs: Any) -> AsyncIterable["_models.VirtualNetworkGatewayConnection"]:
        """The List VirtualNetworkGatewayConnections operation retrieves all the virtual network gateways
        connections created.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :return: An iterator like instance of either VirtualNetworkGatewayConnection or the result of
         cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.network.v2017_10_01.models.VirtualNetworkGatewayConnection]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[_models.VirtualNetworkGatewayConnectionListResult] = kwargs.pop("cls", None)

        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_virtual_network_gateway_connections_list_request(
                    resource_group_name=resource_group_name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)

            else:
                _request = HttpRequest("GET", next_link)
                _request = _convert_request(_request)
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("VirtualNetworkGatewayConnectionListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    async def _reset_shared_key_initial(
        self,
        resource_group_name: str,
        virtual_network_gateway_connection_name: str,
        parameters: Union[_models.ConnectionResetSharedKey, IO[bytes]],
        **kwargs: Any
    ) -> Optional[_models.ConnectionResetSharedKey]:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[Optional[_models.ConnectionResetSharedKey]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IOBase, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "ConnectionResetSharedKey")

        _request = build_virtual_network_gateway_connections_reset_shared_key_request(
            resource_group_name=resource_group_name,
            virtual_network_gateway_connection_name=virtual_network_gateway_connection_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize("ConnectionResetSharedKey", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_reset_shared_key(
        self,
        resource_group_name: str,
        virtual_network_gateway_connection_name: str,
        parameters: _models.ConnectionResetSharedKey,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.ConnectionResetSharedKey]:
        """The VirtualNetworkGatewayConnectionResetSharedKey operation resets the virtual network gateway
        connection shared key for passed virtual network gateway connection in the specified resource
        group through Network resource provider.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param virtual_network_gateway_connection_name: The virtual network gateway connection reset
         shared key Name. Required.
        :type virtual_network_gateway_connection_name: str
        :param parameters: Parameters supplied to the begin reset virtual network gateway connection
         shared key operation through network resource provider. Required.
        :type parameters: ~azure.mgmt.network.v2017_10_01.models.ConnectionResetSharedKey
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either ConnectionResetSharedKey or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.ConnectionResetSharedKey]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_reset_shared_key(
        self,
        resource_group_name: str,
        virtual_network_gateway_connection_name: str,
        parameters: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.ConnectionResetSharedKey]:
        """The VirtualNetworkGatewayConnectionResetSharedKey operation resets the virtual network gateway
        connection shared key for passed virtual network gateway connection in the specified resource
        group through Network resource provider.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param virtual_network_gateway_connection_name: The virtual network gateway connection reset
         shared key Name. Required.
        :type virtual_network_gateway_connection_name: str
        :param parameters: Parameters supplied to the begin reset virtual network gateway connection
         shared key operation through network resource provider. Required.
        :type parameters: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Known values are: 'application/json', 'text/json'. Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either ConnectionResetSharedKey or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.ConnectionResetSharedKey]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_reset_shared_key(
        self,
        resource_group_name: str,
        virtual_network_gateway_connection_name: str,
        parameters: Union[_models.ConnectionResetSharedKey, IO[bytes]],
        **kwargs: Any
    ) -> AsyncLROPoller[_models.ConnectionResetSharedKey]:
        """The VirtualNetworkGatewayConnectionResetSharedKey operation resets the virtual network gateway
        connection shared key for passed virtual network gateway connection in the specified resource
        group through Network resource provider.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param virtual_network_gateway_connection_name: The virtual network gateway connection reset
         shared key Name. Required.
        :type virtual_network_gateway_connection_name: str
        :param parameters: Parameters supplied to the begin reset virtual network gateway connection
         shared key operation through network resource provider. Is either a ConnectionResetSharedKey
         type or a IO[bytes] type. Required.
        :type parameters: ~azure.mgmt.network.v2017_10_01.models.ConnectionResetSharedKey or IO[bytes]
        :return: An instance of AsyncLROPoller that returns either ConnectionResetSharedKey or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.ConnectionResetSharedKey]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.ConnectionResetSharedKey] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._reset_shared_key_initial(
                resource_group_name=resource_group_name,
                virtual_network_gateway_connection_name=virtual_network_gateway_connection_name,
                parameters=parameters,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("ConnectionResetSharedKey", pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod, AsyncARMPolling(lro_delay, lro_options={"final-state-via": "location"}, **kwargs)
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.ConnectionResetSharedKey].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.ConnectionResetSharedKey](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )


class LocalNetworkGatewaysOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.network.v2017_10_01.aio.NetworkManagementClient`'s
        :attr:`local_network_gateways` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")
        self._api_version = input_args.pop(0) if input_args else kwargs.pop("api_version")

    async def _create_or_update_initial(
        self,
        resource_group_name: str,
        local_network_gateway_name: str,
        parameters: Union[_models.LocalNetworkGateway, IO[bytes]],
        **kwargs: Any
    ) -> _models.LocalNetworkGateway:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.LocalNetworkGateway] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IOBase, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "LocalNetworkGateway")

        _request = build_local_network_gateways_create_or_update_request(
            resource_group_name=resource_group_name,
            local_network_gateway_name=local_network_gateway_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if response.status_code == 200:
            deserialized = self._deserialize("LocalNetworkGateway", pipeline_response)

        if response.status_code == 201:
            deserialized = self._deserialize("LocalNetworkGateway", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_create_or_update(
        self,
        resource_group_name: str,
        local_network_gateway_name: str,
        parameters: _models.LocalNetworkGateway,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.LocalNetworkGateway]:
        """Creates or updates a local network gateway in the specified resource group.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param local_network_gateway_name: The name of the local network gateway. Required.
        :type local_network_gateway_name: str
        :param parameters: Parameters supplied to the create or update local network gateway operation.
         Required.
        :type parameters: ~azure.mgmt.network.v2017_10_01.models.LocalNetworkGateway
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either LocalNetworkGateway or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.LocalNetworkGateway]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_create_or_update(
        self,
        resource_group_name: str,
        local_network_gateway_name: str,
        parameters: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.LocalNetworkGateway]:
        """Creates or updates a local network gateway in the specified resource group.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param local_network_gateway_name: The name of the local network gateway. Required.
        :type local_network_gateway_name: str
        :param parameters: Parameters supplied to the create or update local network gateway operation.
         Required.
        :type parameters: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Known values are: 'application/json', 'text/json'. Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either LocalNetworkGateway or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.LocalNetworkGateway]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_create_or_update(
        self,
        resource_group_name: str,
        local_network_gateway_name: str,
        parameters: Union[_models.LocalNetworkGateway, IO[bytes]],
        **kwargs: Any
    ) -> AsyncLROPoller[_models.LocalNetworkGateway]:
        """Creates or updates a local network gateway in the specified resource group.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param local_network_gateway_name: The name of the local network gateway. Required.
        :type local_network_gateway_name: str
        :param parameters: Parameters supplied to the create or update local network gateway operation.
         Is either a LocalNetworkGateway type or a IO[bytes] type. Required.
        :type parameters: ~azure.mgmt.network.v2017_10_01.models.LocalNetworkGateway or IO[bytes]
        :return: An instance of AsyncLROPoller that returns either LocalNetworkGateway or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.LocalNetworkGateway]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.LocalNetworkGateway] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._create_or_update_initial(
                resource_group_name=resource_group_name,
                local_network_gateway_name=local_network_gateway_name,
                parameters=parameters,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("LocalNetworkGateway", pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.LocalNetworkGateway].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.LocalNetworkGateway](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    @distributed_trace_async
    async def get(
        self, resource_group_name: str, local_network_gateway_name: str, **kwargs: Any
    ) -> _models.LocalNetworkGateway:
        """Gets the specified local network gateway in a resource group.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param local_network_gateway_name: The name of the local network gateway. Required.
        :type local_network_gateway_name: str
        :return: LocalNetworkGateway or the result of cls(response)
        :rtype: ~azure.mgmt.network.v2017_10_01.models.LocalNetworkGateway
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[_models.LocalNetworkGateway] = kwargs.pop("cls", None)

        _request = build_local_network_gateways_get_request(
            resource_group_name=resource_group_name,
            local_network_gateway_name=local_network_gateway_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("LocalNetworkGateway", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    async def _delete_initial(  # pylint: disable=inconsistent-return-statements
        self, resource_group_name: str, local_network_gateway_name: str, **kwargs: Any
    ) -> None:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_local_network_gateways_delete_request(
            resource_group_name=resource_group_name,
            local_network_gateway_name=local_network_gateway_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def begin_delete(
        self, resource_group_name: str, local_network_gateway_name: str, **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Deletes the specified local network gateway.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param local_network_gateway_name: The name of the local network gateway. Required.
        :type local_network_gateway_name: str
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._delete_initial(  # type: ignore
                resource_group_name=resource_group_name,
                local_network_gateway_name=local_network_gateway_name,
                api_version=api_version,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})  # type: ignore

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod, AsyncARMPolling(lro_delay, lro_options={"final-state-via": "location"}, **kwargs)
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[None].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[None](self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    async def _update_tags_initial(
        self,
        resource_group_name: str,
        local_network_gateway_name: str,
        parameters: Union[_models.TagsObject, IO[bytes]],
        **kwargs: Any
    ) -> _models.LocalNetworkGateway:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.LocalNetworkGateway] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IOBase, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "TagsObject")

        _request = build_local_network_gateways_update_tags_request(
            resource_group_name=resource_group_name,
            local_network_gateway_name=local_network_gateway_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("LocalNetworkGateway", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_update_tags(
        self,
        resource_group_name: str,
        local_network_gateway_name: str,
        parameters: _models.TagsObject,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.LocalNetworkGateway]:
        """Updates a local network gateway tags.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param local_network_gateway_name: The name of the local network gateway. Required.
        :type local_network_gateway_name: str
        :param parameters: Parameters supplied to update local network gateway tags. Required.
        :type parameters: ~azure.mgmt.network.v2017_10_01.models.TagsObject
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either LocalNetworkGateway or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.LocalNetworkGateway]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_update_tags(
        self,
        resource_group_name: str,
        local_network_gateway_name: str,
        parameters: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.LocalNetworkGateway]:
        """Updates a local network gateway tags.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param local_network_gateway_name: The name of the local network gateway. Required.
        :type local_network_gateway_name: str
        :param parameters: Parameters supplied to update local network gateway tags. Required.
        :type parameters: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Known values are: 'application/json', 'text/json'. Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either LocalNetworkGateway or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.LocalNetworkGateway]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_update_tags(
        self,
        resource_group_name: str,
        local_network_gateway_name: str,
        parameters: Union[_models.TagsObject, IO[bytes]],
        **kwargs: Any
    ) -> AsyncLROPoller[_models.LocalNetworkGateway]:
        """Updates a local network gateway tags.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :param local_network_gateway_name: The name of the local network gateway. Required.
        :type local_network_gateway_name: str
        :param parameters: Parameters supplied to update local network gateway tags. Is either a
         TagsObject type or a IO[bytes] type. Required.
        :type parameters: ~azure.mgmt.network.v2017_10_01.models.TagsObject or IO[bytes]
        :return: An instance of AsyncLROPoller that returns either LocalNetworkGateway or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.network.v2017_10_01.models.LocalNetworkGateway]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.LocalNetworkGateway] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._update_tags_initial(
                resource_group_name=resource_group_name,
                local_network_gateway_name=local_network_gateway_name,
                parameters=parameters,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("LocalNetworkGateway", pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.LocalNetworkGateway].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.LocalNetworkGateway](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    @distributed_trace
    def list(self, resource_group_name: str, **kwargs: Any) -> AsyncIterable["_models.LocalNetworkGateway"]:
        """Gets all the local network gateways in a resource group.

        :param resource_group_name: The name of the resource group. Required.
        :type resource_group_name: str
        :return: An iterator like instance of either LocalNetworkGateway or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.network.v2017_10_01.models.LocalNetworkGateway]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._api_version or "2017-10-01"))
        cls: ClsType[_models.LocalNetworkGatewayListResult] = kwargs.pop("cls", None)

        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
   