# pylint: disable=too-many-lines,too-many-statements
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import datetime
import sys
from typing import Any, Callable, Dict, List, Optional, Type, TypeVar, cast

from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.rest import HttpRequest, HttpResponse
from azure.core.tracing.decorator import distributed_trace
from azure.core.utils import case_insensitive_dict

from .._serialization import Serializer

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore  # pylint: disable=ungrouped-imports
JSON = MutableMapping[str, Any]  # pylint: disable=unsubscriptable-object
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, HttpResponse], T, Dict[str, Any]], Any]]

_SERIALIZER = Serializer()
_SERIALIZER.client_side_validation = False


def build_timezone_get_timezone_by_id_request(  # pylint: disable=name-too-long
    format: str = "json",
    *,
    timezone_id: str,
    accept_language: Optional[str] = None,
    options: Optional[str] = None,
    time_stamp: Optional[datetime.datetime] = None,
    daylight_savings_time_from: Optional[datetime.datetime] = None,
    daylight_savings_time_lasting_years: Optional[int] = None,
    client_id: Optional[str] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "1.0"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/timezone/byId/{format}"
    path_format_arguments = {
        "format": _SERIALIZER.url("format", format, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if options is not None:
        _params["options"] = _SERIALIZER.query("options", options, "str")
    if time_stamp is not None:
        _params["timeStamp"] = _SERIALIZER.query("time_stamp", time_stamp, "iso-8601")
    if daylight_savings_time_from is not None:
        _params["transitionsFrom"] = _SERIALIZER.query(
            "daylight_savings_time_from", daylight_savings_time_from, "iso-8601"
        )
    if daylight_savings_time_lasting_years is not None:
        _params["transitionsYears"] = _SERIALIZER.query(
            "daylight_savings_time_lasting_years", daylight_savings_time_lasting_years, "int"
        )
    _params["query"] = _SERIALIZER.query("timezone_id", timezone_id, "str")

    # Construct headers
    if client_id is not None:
        _headers["x-ms-client-id"] = _SERIALIZER.header("client_id", client_id, "str")
    if accept_language is not None:
        _headers["Accept-Language"] = _SERIALIZER.header("accept_language", accept_language, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_timezone_get_timezone_by_coordinates_request(  # pylint: disable=name-too-long
    format: str = "json",
    *,
    coordinates: List[float],
    accept_language: Optional[str] = None,
    options: Optional[str] = None,
    time_stamp: Optional[datetime.datetime] = None,
    daylight_savings_time_from: Optional[datetime.datetime] = None,
    daylight_savings_time_lasting_years: Optional[int] = None,
    client_id: Optional[str] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "1.0"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/timezone/byCoordinates/{format}"
    path_format_arguments = {
        "format": _SERIALIZER.url("format", format, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if options is not None:
        _params["options"] = _SERIALIZER.query("options", options, "str")
    if time_stamp is not None:
        _params["timeStamp"] = _SERIALIZER.query("time_stamp", time_stamp, "iso-8601")
    if daylight_savings_time_from is not None:
        _params["transitionsFrom"] = _SERIALIZER.query(
            "daylight_savings_time_from", daylight_savings_time_from, "iso-8601"
        )
    if daylight_savings_time_lasting_years is not None:
        _params["transitionsYears"] = _SERIALIZER.query(
            "daylight_savings_time_lasting_years", daylight_savings_time_lasting_years, "int"
        )
    _params["query"] = _SERIALIZER.query("coordinates", coordinates, "[float]", div=",")

    # Construct headers
    if client_id is not None:
        _headers["x-ms-client-id"] = _SERIALIZER.header("client_id", client_id, "str")
    if accept_language is not None:
        _headers["Accept-Language"] = _SERIALIZER.header("accept_language", accept_language, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_timezone_get_windows_timezone_ids_request(  # pylint: disable=name-too-long
    format: str = "json", *, client_id: Optional[str] = None, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "1.0"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/timezone/enumWindows/{format}"
    path_format_arguments = {
        "format": _SERIALIZER.url("format", format, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if client_id is not None:
        _headers["x-ms-client-id"] = _SERIALIZER.header("client_id", client_id, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_timezone_get_iana_timezone_ids_request(  # pylint: disable=name-too-long
    format: str = "json", *, client_id: Optional[str] = None, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "1.0"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/timezone/enumIana/{format}"
    path_format_arguments = {
        "format": _SERIALIZER.url("format", format, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if client_id is not None:
        _headers["x-ms-client-id"] = _SERIALIZER.header("client_id", client_id, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_timezone_get_iana_version_request(
    format: str = "json", *, client_id: Optional[str] = None, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "1.0"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/timezone/ianaVersion/{format}"
    path_format_arguments = {
        "format": _SERIALIZER.url("format", format, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if client_id is not None:
        _headers["x-ms-client-id"] = _SERIALIZER.header("client_id", client_id, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_timezone_convert_windows_timezone_to_iana_request(  # pylint: disable=name-too-long
    format: str = "json",
    *,
    windows_timezone_id: str,
    windows_territory_code: Optional[str] = None,
    client_id: Optional[str] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "1.0"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/timezone/windowsToIana/{format}"
    path_format_arguments = {
        "format": _SERIALIZER.url("format", format, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    _params["query"] = _SERIALIZER.query("windows_timezone_id", windows_timezone_id, "str")
    if windows_territory_code is not None:
        _params["territory"] = _SERIALIZER.query("windows_territory_code", windows_territory_code, "str")

    # Construct headers
    if client_id is not None:
        _headers["x-ms-client-id"] = _SERIALIZER.header("client_id", client_id, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


class TimezoneOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.maps.timezone.TimezoneClient`'s
        :attr:`timezone` attribute.
    """

    def __init__(self, *args, **kwargs):
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def get_timezone_by_id(
        self,
        format: str = "json",
        *,
        timezone_id: str,
        accept_language: Optional[str] = None,
        options: Optional[str] = None,
        time_stamp: Optional[datetime.datetime] = None,
        daylight_savings_time_from: Optional[datetime.datetime] = None,
        daylight_savings_time_lasting_years: Optional[int] = None,
        **kwargs: Any
    ) -> JSON:
        """Use to get the current, historical, and future time zone information for the specified IANA
        time zone ID.

        The ``Get Timezone By ID`` API is an HTTP ``GET`` request that returns current, historical, and
        future time zone information for the specified IANA time zone ID.

        :param format: Desired format of the response. Only ``json`` format is supported. "json"
         Default value is "json".
        :type format: str
        :keyword timezone_id: The IANA time zone ID. Required.
        :paramtype timezone_id: str
        :keyword accept_language: Specifies the language code in which the timezone names should be
         returned. If no language code is provided, the response will be in "EN". Please refer to
         `Supported Languages <https://docs.microsoft.com/azure/azure-maps/supported-languages>`_ for
         details. Default value is None.
        :paramtype accept_language: str
        :keyword options: Alternatively, use alias "o". Options available for types of information
         returned in the result. Known values are: "none", "zoneInfo", "transitions", and "all". Default
         value is None.
        :paramtype options: str
        :keyword time_stamp: Alternatively, use alias "stamp", or "s". Reference time, if omitted, the
         API will use the machine time serving the request. Default value is None.
        :paramtype time_stamp: ~datetime.datetime
        :keyword daylight_savings_time_from: Alternatively, use alias "tf". The start date from which
         daylight savings time (DST) transitions are requested, only applies when "options" = all or
         "options" = transitions. Default value is None.
        :paramtype daylight_savings_time_from: ~datetime.datetime
        :keyword daylight_savings_time_lasting_years: Alternatively, use alias "ty". The number of
         years from "transitionsFrom" for which DST transitions are requested, only applies when
         "options" = all or "options" = transitions. Default value is None.
        :paramtype daylight_savings_time_lasting_years: int
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "ReferenceUtcTimestamp": "2020-02-20 00:00:00",
                    "TimeZones": [
                        {
                            "Aliases": [
                                "str"
                            ],
                            "Countries": [
                                {
                                    "Code": "str",
                                    "Name": "str"
                                }
                            ],
                            "Id": "str",
                            "Names": {
                                "Daylight": "str",
                                "Generic": "str",
                                "ISO6391LanguageCode": "str",
                                "Standard": "str"
                            },
                            "ReferenceTime": {
                                "DaylightSavings": "str",
                                "PosixTz": "str",
                                "PosixTzValidYear": 0,
                                "StandardOffset": "str",
                                "Sunrise": "2020-02-20 00:00:00",
                                "Sunset": "2020-02-20 00:00:00",
                                "Tag": "str",
                                "WallTime": "str"
                            },
                            "RepresentativePoint": {
                                "Latitude": 0.0,
                                "Longitude": 0.0
                            },
                            "TimeTransitions": [
                                {
                                    "DaylightSavings": "str",
                                    "StandardOffset": "str",
                                    "Tag": "str",
                                    "UtcEnd": "2020-02-20 00:00:00",
                                    "UtcStart": "2020-02-20 00:00:00"
                                }
                            ]
                        }
                    ],
                    "Version": "str"
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {  # pylint: disable=unsubscriptable-object
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_timezone_get_timezone_by_id_request(
            format=format,
            timezone_id=timezone_id,
            accept_language=accept_language,
            options=options,
            time_stamp=time_stamp,
            daylight_savings_time_from=daylight_savings_time_from,
            daylight_savings_time_lasting_years=daylight_savings_time_lasting_years,
            client_id=self._config.client_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace
    def get_timezone_by_coordinates(
        self,
        format: str = "json",
        *,
        coordinates: List[float],
        accept_language: Optional[str] = None,
        options: Optional[str] = None,
        time_stamp: Optional[datetime.datetime] = None,
        daylight_savings_time_from: Optional[datetime.datetime] = None,
        daylight_savings_time_lasting_years: Optional[int] = None,
        **kwargs: Any
    ) -> JSON:
        """Use to get the current, historical, and future time zone information for the specified
        latitude-longitude pair.

        The ``Get Timezone By Coordinates`` API is an HTTP ``GET`` request that returns current,
        historical, and future time zone information for a specified latitude-longitude pair. In
        addition, the API provides sunset and sunrise times for a given location.

        :param format: Desired format of the response. Only ``json`` format is supported. "json"
         Default value is "json".
        :type format: str
        :keyword coordinates: Coordinates of the point for which time zone information is requested.
         This parameter is a list of coordinates, containing a pair of coordinate(lat, long). When this
         endpoint is called directly, coordinates are passed in as a single string containing
         coordinates, separated by commas. Required.
        :paramtype coordinates: list[float]
        :keyword accept_language: Specifies the language code in which the timezone names should be
         returned. If no language code is provided, the response will be in "EN". Please refer to
         `Supported Languages <https://docs.microsoft.com/azure/azure-maps/supported-languages>`_ for
         details. Default value is None.
        :paramtype accept_language: str
        :keyword options: Alternatively, use alias "o". Options available for types of information
         returned in the result. Known values are: "none", "zoneInfo", "transitions", and "all". Default
         value is None.
        :paramtype options: str
        :keyword time_stamp: Alternatively, use alias "stamp", or "s". Reference time, if omitted, the
         API will use the machine time serving the request. Default value is None.
        :paramtype time_stamp: ~datetime.datetime
        :keyword daylight_savings_time_from: Alternatively, use alias "tf". The start date from which
         daylight savings time (DST) transitions are requested, only applies when "options" = all or
         "options" = transitions. Default value is None.
        :paramtype daylight_savings_time_from: ~datetime.datetime
        :keyword daylight_savings_time_lasting_years: Alternatively, use alias "ty". The number of
         years from "transitionsFrom" for which DST transitions are requested, only applies when
         "options" = all or "options" = transitions. Default value is None.
        :paramtype daylight_savings_time_lasting_years: int
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "ReferenceUtcTimestamp": "2020-02-20 00:00:00",
                    "TimeZones": [
                        {
                            "Aliases": [
                                "str"
                            ],
                            "Countries": [
                                {
                                    "Code": "str",
                                    "Name": "str"
                                }
                            ],
                            "Id": "str",
                            "Names": {
                                "Daylight": "str",
                                "Generic": "str",
                                "ISO6391LanguageCode": "str",
                                "Standard": "str"
                            },
                            "ReferenceTime": {
                                "DaylightSavings": "str",
                                "PosixTz": "str",
                                "PosixTzValidYear": 0,
                                "StandardOffset": "str",
                                "Sunrise": "2020-02-20 00:00:00",
                                "Sunset": "2020-02-20 00:00:00",
                                "Tag": "str",
                                "WallTime": "str"
                            },
                            "RepresentativePoint": {
                                "Latitude": 0.0,
                                "Longitude": 0.0
                            },
                            "TimeTransitions": [
                                {
                                    "DaylightSavings": "str",
                                    "StandardOffset": "str",
                                    "Tag": "str",
                                    "UtcEnd": "2020-02-20 00:00:00",
                                    "UtcStart": "2020-02-20 00:00:00"
                                }
                            ]
                        }
                    ],
                    "Version": "str"
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {  # pylint: disable=unsubscriptable-object
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_timezone_get_timezone_by_coordinates_request(
            format=format,
            coordinates=coordinates,
            accept_language=accept_language,
            options=options,
            time_stamp=time_stamp,
            daylight_savings_time_from=daylight_savings_time_from,
            daylight_savings_time_lasting_years=daylight_savings_time_lasting_years,
            client_id=self._config.client_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace
    def get_windows_timezone_ids(self, format: str = "json", **kwargs: Any) -> List[JSON]:
        """Use to get the list of Windows Time Zone IDs.

        The ``Get Windows Time Zones`` API is an HTTP ``GET`` request that returns a full list of
        Windows Time Zone IDs.

        :param format: Desired format of the response. Only ``json`` format is supported. "json"
         Default value is "json".
        :type format: str
        :return: list of JSON object
        :rtype: list[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == [
                    {
                        "IanaIds": [
                            "str"
                        ],
                        "Territory": "str",
                        "WindowsId": "str"
                    }
                ]
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {  # pylint: disable=unsubscriptable-object
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[JSON]] = kwargs.pop("cls", None)

        _request = build_timezone_get_windows_timezone_ids_request(
            format=format,
            client_id=self._config.client_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(List[JSON], deserialized), {})  # type: ignore

        return cast(List[JSON], deserialized)  # type: ignore

    @distributed_trace
    def get_iana_timezone_ids(self, format: str = "json", **kwargs: Any) -> List[JSON]:
        """Use to get the list of IANA time zone IDs.

        The ``Get IANA Time Zones`` API is an HTTP ``GET`` request that returns a full list of Internet
        Assigned Numbers Authority (IANA) time zone IDs. Updates to the IANA service are reflected in
        the system within one day.

        :param format: Desired format of the response. Only ``json`` format is supported. "json"
         Default value is "json".
        :type format: str
        :return: list of JSON object
        :rtype: list[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == [
                    {
                        "AliasOf": "str",
                        "HasZone1970Location": bool,
                        "Id": "str",
                        "IsAlias": bool
                    }
                ]
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {  # pylint: disable=unsubscriptable-object
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[JSON]] = kwargs.pop("cls", None)

        _request = build_timezone_get_iana_timezone_ids_request(
            format=format,
            client_id=self._config.client_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(List[JSON], deserialized), {})  # type: ignore

        return cast(List[JSON], deserialized)  # type: ignore

    @distributed_trace
    def get_iana_version(self, format: str = "json", **kwargs: Any) -> JSON:
        """Use to get the current IANA version number.

        The ``Get Time Zone IANA Version`` API is an HTTP ``GET`` request that returns the current
        Internet Assigned Numbers Authority (IANA) version number as Metadata.

        :param format: Desired format of the response. Only ``json`` format is supported. "json"
         Default value is "json".
        :type format: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "Version": "str"
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {  # pylint: disable=unsubscriptable-object
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        _request = build_timezone_get_iana_version_request(
            format=format,
            client_id=self._config.client_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace
    def convert_windows_timezone_to_iana(
        self,
        format: str = "json",
        *,
        windows_timezone_id: str,
        windows_territory_code: Optional[str] = None,
        **kwargs: Any
    ) -> List[JSON]:
        """Use to get the IANA ID.

        The ``Get Windows to IANA Time Zone`` API is an HTTP ``GET`` request that returns a
        corresponding Internet Assigned Numbers Authority (IANA) ID, given a valid Windows Time Zone
        ID. Multiple IANA IDs may be returned for a single Windows ID. It is possible to narrow these
        results by adding an optional territory parameter.

        :param format: Desired format of the response. Only ``json`` format is supported. "json"
         Default value is "json".
        :type format: str
        :keyword windows_timezone_id: The Windows time zone ID. Required.
        :paramtype windows_timezone_id: str
        :keyword windows_territory_code: Windows Time Zone territory code. Default value is None.
        :paramtype windows_territory_code: str
        :return: list of JSON object
        :rtype: list[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == [
                    {
                        "AliasOf": "str",
                        "HasZone1970Location": bool,
                        "Id": "str",
                        "IsAlias": bool
                    }
                ]
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {  # pylint: disable=unsubscriptable-object
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[JSON]] = kwargs.pop("cls", None)

        _request = build_timezone_convert_windows_timezone_to_iana_request(
            format=format,
            windows_timezone_id=windows_timezone_id,
            windows_territory_code=windows_territory_code,
            client_id=self._config.client_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(List[JSON], deserialized), {})  # type: ignore

        return cast(List[JSON], deserialized)  # type: ignore
