# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import Any, IO, Union

from azure.identity import DefaultAzureCredential

from azure.mgmt.web import WebSiteManagementClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-web
# USAGE
    python static_site_build_zip_deploy.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = WebSiteManagementClient(
        credential=DefaultAzureCredential(),
        subscription_id="34adfa4f-cedf-4dc0-ba29-b6d1a69ab345",
    )

    client.static_sites.begin_create_zip_deployment_for_static_site_build(
        resource_group_name="rg",
        name="testStaticSite0",
        environment_name="12",
        static_site_zip_deployment_envelope={
            "properties": {
                "apiZipUrl": "https://teststorageaccount.net/happy-sea-15afae3e-master-81828877/api-zipdeploy.zip",
                "appZipUrl": "https://teststorageaccount.net/happy-sea-15afae3e-master-81828877/app-zipdeploy.zip",
                "deploymentTitle": "Update index.html",
                "functionLanguage": "testFunctionLanguage",
                "provider": "testProvider",
            }
        },
    ).result()


# x-ms-original-file: specification/web/resource-manager/Microsoft.Web/stable/2023-12-01/examples/StaticSiteBuildZipDeploy.json
if __name__ == "__main__":
    main()
