# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model
from msrest.exceptions import HttpOperationError


class CloudError(Model):
    """CloudError.
    """

    _attribute_map = {
    }


class ErrorResponse(Model):
    """Describes the format of Error response.

    :param code: Error code
    :type code: str
    :param message: Error message indicating why the operation failed.
    :type message: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ErrorResponse, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)


class ErrorResponseException(HttpOperationError):
    """Server responsed with exception of type: 'ErrorResponse'.

    :param deserialize: A deserializer
    :param response: Server response to be deserialized.
    """

    def __init__(self, deserialize, response, *args):

        super(ErrorResponseException, self).__init__(deserialize, response, 'ErrorResponse', *args)


class LocalizableString(Model):
    """The localizable string class.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. the invariant value.
    :type value: str
    :param localized_value: the locale specific value.
    :type localized_value: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
        'localized_value': {'key': 'localizedValue', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(LocalizableString, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.localized_value = kwargs.get('localized_value', None)


class LogSettings(Model):
    """Part of MultiTenantDiagnosticSettings. Specifies the settings for a
    particular log.

    All required parameters must be populated in order to send to Azure.

    :param category: Name of a Diagnostic Log category for a resource type
     this setting is applied to. To obtain the list of Diagnostic Log
     categories for a resource, first perform a GET diagnostic settings
     operation.
    :type category: str
    :param enabled: Required. a value indicating whether this log is enabled.
    :type enabled: bool
    :param retention_policy: the retention policy for this log.
    :type retention_policy:
     ~azure.mgmt.monitor.v2016_09_01.models.RetentionPolicy
    """

    _validation = {
        'enabled': {'required': True},
    }

    _attribute_map = {
        'category': {'key': 'category', 'type': 'str'},
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'retention_policy': {'key': 'retentionPolicy', 'type': 'RetentionPolicy'},
    }

    def __init__(self, **kwargs):
        super(LogSettings, self).__init__(**kwargs)
        self.category = kwargs.get('category', None)
        self.enabled = kwargs.get('enabled', None)
        self.retention_policy = kwargs.get('retention_policy', None)


class Metric(Model):
    """A set of metric values in a time range.

    All required parameters must be populated in order to send to Azure.

    :param id: the id, resourceId, of the metric.
    :type id: str
    :param type: the resource type of the metric resource.
    :type type: str
    :param name: Required. the name and the display name of the metric, i.e.
     it is localizable string.
    :type name: ~azure.mgmt.monitor.v2016_09_01.models.LocalizableString
    :param unit: Required. the unit of the metric. Possible values include:
     'Count', 'Bytes', 'Seconds', 'CountPerSecond', 'BytesPerSecond',
     'Percent', 'MilliSeconds'
    :type unit: str or ~azure.mgmt.monitor.v2016_09_01.models.Unit
    :param data: Required. Array of data points representing the metric
     values.
    :type data: list[~azure.mgmt.monitor.v2016_09_01.models.MetricValue]
    """

    _validation = {
        'name': {'required': True},
        'unit': {'required': True},
        'data': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'LocalizableString'},
        'unit': {'key': 'unit', 'type': 'Unit'},
        'data': {'key': 'data', 'type': '[MetricValue]'},
    }

    def __init__(self, **kwargs):
        super(Metric, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.type = kwargs.get('type', None)
        self.name = kwargs.get('name', None)
        self.unit = kwargs.get('unit', None)
        self.data = kwargs.get('data', None)


class MetricSettings(Model):
    """Part of MultiTenantDiagnosticSettings. Specifies the settings for a
    particular metric.

    All required parameters must be populated in order to send to Azure.

    :param time_grain: Required. the timegrain of the metric in ISO8601
     format.
    :type time_grain: timedelta
    :param enabled: Required. a value indicating whether this timegrain is
     enabled.
    :type enabled: bool
    :param retention_policy: the retention policy for this timegrain.
    :type retention_policy:
     ~azure.mgmt.monitor.v2016_09_01.models.RetentionPolicy
    """

    _validation = {
        'time_grain': {'required': True},
        'enabled': {'required': True},
    }

    _attribute_map = {
        'time_grain': {'key': 'timeGrain', 'type': 'duration'},
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'retention_policy': {'key': 'retentionPolicy', 'type': 'RetentionPolicy'},
    }

    def __init__(self, **kwargs):
        super(MetricSettings, self).__init__(**kwargs)
        self.time_grain = kwargs.get('time_grain', None)
        self.enabled = kwargs.get('enabled', None)
        self.retention_policy = kwargs.get('retention_policy', None)


class MetricValue(Model):
    """Represents a metric value.

    All required parameters must be populated in order to send to Azure.

    :param time_stamp: Required. the timestamp for the metric value in ISO
     8601 format.
    :type time_stamp: datetime
    :param average: the average value in the time range.
    :type average: float
    :param minimum: the least value in the time range.
    :type minimum: float
    :param maximum: the greatest value in the time range.
    :type maximum: float
    :param total: the sum of all of the values in the time range.
    :type total: float
    :param count: the number of samples in the time range. Can be used to
     determine the number of values that contributed to the average value.
    :type count: long
    """

    _validation = {
        'time_stamp': {'required': True},
    }

    _attribute_map = {
        'time_stamp': {'key': 'timeStamp', 'type': 'iso-8601'},
        'average': {'key': 'average', 'type': 'float'},
        'minimum': {'key': 'minimum', 'type': 'float'},
        'maximum': {'key': 'maximum', 'type': 'float'},
        'total': {'key': 'total', 'type': 'float'},
        'count': {'key': 'count', 'type': 'long'},
    }

    def __init__(self, **kwargs):
        super(MetricValue, self).__init__(**kwargs)
        self.time_stamp = kwargs.get('time_stamp', None)
        self.average = kwargs.get('average', None)
        self.minimum = kwargs.get('minimum', None)
        self.maximum = kwargs.get('maximum', None)
        self.total = kwargs.get('total', None)
        self.count = kwargs.get('count', None)


class Resource(Model):
    """An azure resource object.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Azure resource Id
    :vartype id: str
    :ivar name: Azure resource name
    :vartype name: str
    :ivar type: Azure resource type
    :vartype type: str
    :param location: Required. Resource location
    :type location: str
    :param tags: Resource tags
    :type tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, **kwargs):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = kwargs.get('location', None)
        self.tags = kwargs.get('tags', None)


class RetentionPolicy(Model):
    """Specifies the retention policy for the log.

    All required parameters must be populated in order to send to Azure.

    :param enabled: Required. a value indicating whether the retention policy
     is enabled.
    :type enabled: bool
    :param days: Required. the number of days for the retention in days. A
     value of 0 will retain the events indefinitely.
    :type days: int
    """

    _validation = {
        'enabled': {'required': True},
        'days': {'required': True, 'minimum': 0},
    }

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'days': {'key': 'days', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(RetentionPolicy, self).__init__(**kwargs)
        self.enabled = kwargs.get('enabled', None)
        self.days = kwargs.get('days', None)


class ServiceDiagnosticSettingsResource(Resource):
    """Description of a service diagnostic setting.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Azure resource Id
    :vartype id: str
    :ivar name: Azure resource name
    :vartype name: str
    :ivar type: Azure resource type
    :vartype type: str
    :param location: Required. Resource location
    :type location: str
    :param tags: Resource tags
    :type tags: dict[str, str]
    :param storage_account_id: The resource ID of the storage account to which
     you would like to send Diagnostic Logs.
    :type storage_account_id: str
    :param service_bus_rule_id: The service bus rule ID of the service bus
     namespace in which you would like to have Event Hubs created for streaming
     Diagnostic Logs. The rule ID is of the format: '{service bus resource
     ID}/authorizationrules/{key name}'.
    :type service_bus_rule_id: str
    :param event_hub_authorization_rule_id: The resource Id for the event hub
     namespace authorization rule.
    :type event_hub_authorization_rule_id: str
    :param metrics: the list of metric settings.
    :type metrics: list[~azure.mgmt.monitor.v2016_09_01.models.MetricSettings]
    :param logs: the list of logs settings.
    :type logs: list[~azure.mgmt.monitor.v2016_09_01.models.LogSettings]
    :param workspace_id: The workspace ID (resource ID of a Log Analytics
     workspace) for a Log Analytics workspace to which you would like to send
     Diagnostic Logs. Example:
     /subscriptions/4b9e8510-67ab-4e9a-95a9-e2f1e570ea9c/resourceGroups/insights-integration/providers/Microsoft.OperationalInsights/workspaces/viruela2
    :type workspace_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'storage_account_id': {'key': 'properties.storageAccountId', 'type': 'str'},
        'service_bus_rule_id': {'key': 'properties.serviceBusRuleId', 'type': 'str'},
        'event_hub_authorization_rule_id': {'key': 'properties.eventHubAuthorizationRuleId', 'type': 'str'},
        'metrics': {'key': 'properties.metrics', 'type': '[MetricSettings]'},
        'logs': {'key': 'properties.logs', 'type': '[LogSettings]'},
        'workspace_id': {'key': 'properties.workspaceId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ServiceDiagnosticSettingsResource, self).__init__(**kwargs)
        self.storage_account_id = kwargs.get('storage_account_id', None)
        self.service_bus_rule_id = kwargs.get('service_bus_rule_id', None)
        self.event_hub_authorization_rule_id = kwargs.get('event_hub_authorization_rule_id', None)
        self.metrics = kwargs.get('metrics', None)
        self.logs = kwargs.get('logs', None)
        self.workspace_id = kwargs.get('workspace_id', None)


class ServiceDiagnosticSettingsResourcePatch(Model):
    """Service diagnostic setting resource for patch operations.

    :param tags: Resource tags
    :type tags: dict[str, str]
    :param storage_account_id: The resource ID of the storage account to which
     you would like to send Diagnostic Logs.
    :type storage_account_id: str
    :param service_bus_rule_id: The service bus rule ID of the service bus
     namespace in which you would like to have Event Hubs created for streaming
     Diagnostic Logs. The rule ID is of the format: '{service bus resource
     ID}/authorizationrules/{key name}'.
    :type service_bus_rule_id: str
    :param event_hub_authorization_rule_id: The resource Id for the event hub
     namespace authorization rule.
    :type event_hub_authorization_rule_id: str
    :param metrics: the list of metric settings.
    :type metrics: list[~azure.mgmt.monitor.v2016_09_01.models.MetricSettings]
    :param logs: the list of logs settings.
    :type logs: list[~azure.mgmt.monitor.v2016_09_01.models.LogSettings]
    :param workspace_id: The workspace ID (resource ID of a Log Analytics
     workspace) for a Log Analytics workspace to which you would like to send
     Diagnostic Logs. Example:
     /subscriptions/4b9e8510-67ab-4e9a-95a9-e2f1e570ea9c/resourceGroups/insights-integration/providers/Microsoft.OperationalInsights/workspaces/viruela2
    :type workspace_id: str
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'storage_account_id': {'key': 'properties.storageAccountId', 'type': 'str'},
        'service_bus_rule_id': {'key': 'properties.serviceBusRuleId', 'type': 'str'},
        'event_hub_authorization_rule_id': {'key': 'properties.eventHubAuthorizationRuleId', 'type': 'str'},
        'metrics': {'key': 'properties.metrics', 'type': '[MetricSettings]'},
        'logs': {'key': 'properties.logs', 'type': '[LogSettings]'},
        'workspace_id': {'key': 'properties.workspaceId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ServiceDiagnosticSettingsResourcePatch, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)
        self.storage_account_id = kwargs.get('storage_account_id', None)
        self.service_bus_rule_id = kwargs.get('service_bus_rule_id', None)
        self.event_hub_authorization_rule_id = kwargs.get('event_hub_authorization_rule_id', None)
        self.metrics = kwargs.get('metrics', None)
        self.logs = kwargs.get('logs', None)
        self.workspace_id = kwargs.get('workspace_id', None)
