#!/usr/bin/python

"""Train the system by cycling devices through all known power states."""
# (C) Copyright IBM Corp. 2008-2009
# Licensed under the GPLv2.
import discovery
import time
import datetime

STABILIZE_TIME = 5
MAX_MEASUREMENTS = 10
MAX_MEASUREMENT_TIME = 60
def set_and_test(power_domain, domains):
	"""Given a list of domains, loop through the power states of
the first domain in the list and recursively call ourself with the
rest of the list.  If the domain list is empty, collect data."""
	global STABILIZE_TIME, MAX_MEASUREMENTS, MAX_MEASUREMENT_TIME

	if len(domains) == 0:
		# Sleep a bit to let the system stabilize
		time.sleep(STABILIZE_TIME)
		before = datetime.datetime.utcnow()
		after = datetime.datetime.utcnow()
		count = 0

		while count < MAX_MEASUREMENTS and (after - before).seconds < MAX_MEASUREMENT_TIME:
			power_domain.process_snapshot()
			count = count + 1
			after = datetime.datetime.utcnow()
		return

	for state in domains[0].get_power_states():
		print ("Set device", domains[0].inventory().keys()[0], state[0])
		domains[0].set_max_power_state(state[0])
		set_and_test(power_domain, domains[1:])

def train():
	"""Train the system."""
	def stop_load_for(devices):
		"""Stop load for a selection of devices."""
		for dev in devices:
			dev.stop_load()

	def start_load(devices):
		loaded = []
		for pd in devices:
			if pd.start_load():
				loaded.append(pd)
			else:
				stop_load_for(loaded)
				return False
		return True

	if len(discovery.PWRKAP_POWER_DOMAINS) == 0:
		return

	print "Training power cap database..."

	# Set all devices to the lowest power state
	for pd in discovery.PWRKAP_POWER_DOMAINS:
		for dd in pd.domains:
			min_state = dd.get_power_states()[0]
			dd.set_max_power_state(min_state[0])

	# Start load here.
	if not start_load(discovery.PWRKAP_POWER_DOMAINS):
		print "Could not start load for testing, transition table will be less effective."
		return

	# Record load 
	for pd in discovery.PWRKAP_POWER_DOMAINS:
		doms = pd.choose_domains_for_training()
		if len(doms) > 0:
			set_and_test(pd, doms)

	# End load here.
	stop_load_for(discovery.PWRKAP_POWER_DOMAINS)

	print "...done."
	for pd in discovery.PWRKAP_POWER_DOMAINS:
		print pd.trans_store.trans_table
