#!/usr/bin/python

"""Main pwrkap daemon."""
# (C) Copyright IBM Corp. 2008-2009
# Licensed under the GPLv2.
import discovery
import controller
import pwrkap_train
import sys
import daemon

def print_help():
	"""Print command line usage."""
	print "Usage: %s [-d] [-w] [-f] [-t] [listen_port] [log_age]" % sys.argv[0]
	print "-d: Run in debug mode, i.e. don't run as a daemon."
	print "-w: Start HTTP web server."
	print "-f: Use fake devices."
	print "-t: Retrain system."
	print "listen_port: Listen for clients on this port."
	print "log_age: Keep old snapshots for this many seconds."

def main():
	"""Run main program."""
	optargs = []

	# Interpret arguments
	daemonize = True
	http = False
	load_saved = True
	for i in range(1, len(sys.argv)):
		arg = sys.argv[i]
		if arg == "-d":
			daemonize = False
		elif arg == "-w":
			http = True
		elif arg == "-f":
			print "Using fake devices."
			discovery.PWRKAP_DRIVERS = ["fake_cpudomain"]
		elif arg == "-h" or arg == "--help":
			print_help()
			return
		elif arg == "-t":
			load_saved = False
		else:
			optargs.append(sys.argv[i])

	if daemonize:
		daemon.daemonize()

	# Now gather arguments
	port = 9410
	log_age = 3600
	log_size = 2
	if len(optargs) > 0:
		port = int(optargs[0])
	if len(optargs) > 1:
		log_age = int(optargs[1])
	ctrl = controller.controller(port, log_age, log_size, http)

	# Speed things up if we're using fakedomain
	if "fake_cpudomain" in discovery.PWRKAP_DRIVERS:
		pwrkap_train.STABILIZE_TIME = 0
		pwrkap_train.MAX_MEASUREMENTS = 10
	ctrl.prepare(load_saved)
	ctrl.dump()
	ctrl.run()
	# We never return

main()
