/*
 * Copyright (c) 2005- Shinji Kashihara.
 * All rights reserved. This program are made available under
 * the terms of the Eclipse Public License v1.0 which accompanies
 * this distribution, and is available at epl-v10.html.
 */
package jp.sourceforge.mergedoc.pleiades.aspect.util;

import java.util.HashSet;
import java.util.Set;


/**
 * キーだけでなく値もハッシュとして保持するプロパティ・セットです。
 * <ul>
 * <li>containsValue が高速に動作します。
 * </ul>
 * @author cypher256
 */
@SuppressWarnings("serial")
public class ValueHashPropertySet extends CachePropertySet {

	/** 値を高速検索するためのハッシュセット */
	private final Set<String> values = new HashSet<String>();

	/**
	 * コンストラクタです。
	 * @param initialCapacity 初期容量
	 * @param comment プロパティー保存コメント
	 */
	public ValueHashPropertySet(int initialCapacity, String comment) {
		super(initialCapacity, comment);
	}

	@Override
	public synchronized boolean containsValue(Object value) {
		return values.contains(value);
	}

	@Override
	public synchronized String put(String key, String value) {
		values.add(value);
		return super.put(key, value);
	}
}
