# Tests for new raw mode features in mysqlbinlog, row mode
# TODO: Test --wait-for-data

# Delete all the binary logs
reset master;

# we need this for getting fixed timestamps inside of this test
set timestamp=1000000000;

--disable_warnings
drop table if exists t1;
--enable_warnings
CREATE TABLE t1 (c01 BIT);
INSERT INTO t1 VALUES (0);
INSERT INTO t1 VALUES (1);
DROP TABLE t1;

CREATE TABLE t1 (c01 BIT(7));
INSERT INTO t1 VALUES (1);
INSERT INTO t1 VALUES (2);
INSERT INTO t1 VALUES (4);
INSERT INTO t1 VALUES (8);
INSERT INTO t1 VALUES (16);
INSERT INTO t1 VALUES (32);
INSERT INTO t1 VALUES (64);
INSERT INTO t1 VALUES (127);
DELETE FROM t1 WHERE c01=127;
UPDATE t1 SET c01=15 WHERE c01=16;
DROP TABLE t1;

CREATE TABLE t1 (a BIT(20), b CHAR(2));
INSERT INTO t1 VALUES (b'00010010010010001001', 'ab');
DROP TABLE t1;

CREATE TABLE t1 (c02 BIT(64));
INSERT INTO t1 VALUES (1);
INSERT INTO t1 VALUES (2);
INSERT INTO t1 VALUES (128);
INSERT INTO t1 VALUES (b'1111111111111111111111111111111111111111111111111111111111111111');
DROP TABLE t1;


CREATE TABLE t1 (c03 TINYINT);
INSERT INTO t1 VALUES (1),(2),(3);
INSERT INTO t1 VALUES (-128);
UPDATE t1 SET c03=2 WHERE c03=1;
DELETE FROM t1 WHERE c03=-128;
DROP TABLE t1;

CREATE TABLE t1 (c04 TINYINT UNSIGNED);
INSERT INTO t1 VALUES (128), (255);
UPDATE t1 SET c04=2 WHERE c04=1;
DELETE FROM t1 WHERE c04=255;
DROP TABLE t1;

CREATE TABLE t1 (c06 BOOL);
INSERT INTO t1 VALUES (TRUE);
DELETE FROM t1 WHERE c06=TRUE;
DROP TABLE t1;

CREATE TABLE t1 (c07 SMALLINT);
INSERT INTO t1 VALUES (1234);
DELETE FROM t1 WHERE c07=1234;
DROP TABLE t1;

CREATE TABLE t1 (c08 SMALLINT UNSIGNED);
INSERT INTO t1 VALUES (32768), (65535);
UPDATE t1 SET c08=2 WHERE c08=32768;
DELETE FROM t1 WHERE c08=65535;
DROP TABLE t1;

CREATE TABLE t1 (c10 MEDIUMINT);
INSERT INTO t1 VALUES (12345);
DELETE FROM t1 WHERE c10=12345;
DROP TABLE t1;

CREATE TABLE t1 (c11 MEDIUMINT UNSIGNED);
INSERT INTO t1 VALUES (8388608), (16777215);
UPDATE t1 SET c11=2 WHERE c11=8388608;
DELETE FROM t1 WHERE c11=16777215;
DROP TABLE t1;

CREATE TABLE t1 (c13 INT);
INSERT INTO t1 VALUES (123456);
DELETE FROM t1 WHERE c13=123456;
DROP TABLE t1;

CREATE TABLE t1 (c14 INT UNSIGNED);
INSERT INTO t1 VALUES (2147483648), (4294967295);
UPDATE t1 SET c14=2 WHERE c14=2147483648;
DELETE FROM t1 WHERE c14=4294967295;
DROP TABLE t1;

CREATE TABLE t1 (c16 BIGINT);
INSERT INTO t1 VALUES (1234567890);
DELETE FROM t1 WHERE c16=1234567890;
DROP TABLE t1;

CREATE TABLE t1 (c17 BIGINT UNSIGNED);
INSERT INTO t1 VALUES (9223372036854775808), (18446744073709551615);
UPDATE t1 SET c17=2 WHERE c17=9223372036854775808;
DELETE FROM t1 WHERE c17=18446744073709551615;
DROP TABLE t1;

CREATE TABLE t1 (c19 FLOAT);
INSERT INTO t1 VALUES (123.2234);
DELETE FROM t1 WHERE c19>123;
DROP TABLE t1;

CREATE TABLE t1 (c22 DOUBLE);
INSERT INTO t1 VALUES (123434.22344545);
DELETE FROM t1 WHERE c22>123434;
DROP TABLE t1;

#

CREATE TABLE t1 (c25 DECIMAL(10,5));
INSERT INTO t1 VALUES (124.45);
INSERT INTO t1 VALUES (-543.21);
DELETE FROM t1 WHERE c25=124.45;
DROP TABLE t1;

#

CREATE TABLE t1 (c28 DATE);
INSERT INTO t1 VALUES ('2001-02-03');
DELETE FROM t1 WHERE c28='2001-02-03';
DROP TABLE t1;

CREATE TABLE t1 (c29 DATETIME);
INSERT INTO t1 VALUES ('2001-02-03 10:20:30');
DELETE FROM t1 WHERE c29='2001-02-03 10:20:30';
DROP TABLE t1;

CREATE TABLE t1 (c30 TIMESTAMP);
INSERT INTO t1 VALUES ('2001-02-03 10:20:30');
DELETE FROM t1 WHERE c30='2001-02-03 10:20:30';
DROP TABLE t1;

CREATE TABLE t1 (c31 TIME);
INSERT INTO t1 VALUES ('11:22:33');
DELETE FROM t1 WHERE c31='11:22:33';
DROP TABLE t1;

CREATE TABLE t1 (c32 YEAR);
INSERT INTO t1 VALUES ('2001');
DELETE FROM t1 WHERE c32=2001;
DROP TABLE t1;

#

CREATE TABLE t1 (c33 CHAR);
INSERT INTO t1 VALUES ('a');
DELETE FROM t1 WHERE c33='a';
DROP TABLE t1;

CREATE TABLE t1 (c34 CHAR(0));
INSERT INTO t1 VALUES ('');
DELETE FROM t1 WHERE c34='';
DROP TABLE t1;

CREATE TABLE t1 (c35 CHAR(1));
INSERT INTO t1 VALUES ('b');
DELETE FROM t1 WHERE c35='b';
DROP TABLE t1;

CREATE TABLE t1 (c36 CHAR(255));
INSERT INTO t1 VALUES (repeat('c',255));
DELETE FROM t1 WHERE c36>'c';
DROP TABLE t1;

#

CREATE TABLE t1 (c37 NATIONAL CHAR);
INSERT INTO t1 VALUES ('a');
DELETE FROM t1 WHERE c37='a';
DROP TABLE t1;

CREATE TABLE t1 (c38 NATIONAL CHAR(0));
INSERT INTO t1 VALUES ('');
DELETE FROM t1 WHERE c38='';
DROP TABLE t1;

CREATE TABLE t1 (c39 NATIONAL CHAR(1));
INSERT INTO t1 VALUES ('a');
DELETE FROM t1 WHERE c39='a';
DROP TABLE t1;

CREATE TABLE t1 (c40 NATIONAL CHAR(255));
INSERT INTO t1 VALUES (repeat('a', 255));
INSERT INTO t1 VALUES (repeat(_latin1 0xDF, 255));
DELETE FROM t1 WHERE c40>'a';
DROP TABLE t1;

#

CREATE TABLE t1 (c45 VARCHAR(0));
INSERT INTO t1 VALUES ('');
DELETE FROM t1 WHERE c45='';
DROP TABLE t1;

CREATE TABLE t1 (c46 VARCHAR(1));
INSERT INTO t1 VALUES ('a');
DELETE FROM t1 WHERE c46='a';
DROP TABLE t1;

CREATE TABLE t1 (c47 VARCHAR(255));
INSERT INTO t1 VALUES (repeat('a',255));
DELETE FROM t1 WHERE c47>'a';
DROP TABLE t1;

CREATE TABLE t1 (c48 VARCHAR(261));
INSERT INTO t1 VALUES (repeat('a',261));
DELETE FROM t1 WHERE c48>'a';
DROP TABLE t1;

#

CREATE TABLE t1 (c49 NATIONAL VARCHAR(0));
INSERT INTO t1 VALUES ('');
DELETE FROM t1 WHERE c49='';
DROP TABLE t1;

CREATE TABLE t1 (c50 NATIONAL VARCHAR(1));
INSERT INTO t1 VALUES ('a');
DELETE FROM t1 WHERE c50='a';
DROP TABLE t1;

CREATE TABLE t1 (c51 NATIONAL VARCHAR(255));
INSERT INTO t1 VALUES (repeat('a',255));
INSERT INTO t1 VALUES (repeat(_latin1 0xDF, 255));
DELETE FROM t1 WHERE c51>'a';
DROP TABLE t1;

CREATE TABLE t1 (c52 NATIONAL VARCHAR(261));
INSERT INTO t1 VALUES (repeat('a',261));
INSERT INTO t1 VALUES (repeat(_latin1 0xDF, 261));
DELETE FROM t1 WHERE c52>'a';
DROP TABLE t1;

#

CREATE TABLE t1 (c57 BINARY);
INSERT INTO t1 VALUES (0x00);
INSERT INTO t1 VALUES (0x02);
INSERT INTO t1 VALUES ('a');
DELETE FROM t1 WHERE c57='a';
DROP TABLE t1;

CREATE TABLE t1 (c58 BINARY(0));
INSERT INTO t1 VALUES ('');
DELETE FROM t1 WHERE c58='';
DROP TABLE t1;

CREATE TABLE t1 (c59 BINARY(1));
INSERT INTO t1 VALUES (0x00);
INSERT INTO t1 VALUES (0x02);
INSERT INTO t1 VALUES ('a');
DELETE FROM t1 WHERE c59='a';
DROP TABLE t1;

CREATE TABLE t1 (c60 BINARY(255));
INSERT INTO t1 VALUES (0x00);
INSERT INTO t1 VALUES (0x02);
INSERT INTO t1 VALUES (repeat('a\0',120));
DELETE FROM t1 WHERE c60<0x02;
DROP TABLE t1;

#

CREATE TABLE t1 (c61 VARBINARY(0));
INSERT INTO t1 VALUES ('');
DELETE FROM t1 WHERE c61='';
DROP TABLE t1;

CREATE TABLE t1 (c62 VARBINARY(1));
INSERT INTO t1 VALUES (0x00);
INSERT INTO t1 VALUES (0x02);
INSERT INTO t1 VALUES ('a');
DELETE FROM t1 WHERE c62=0x02;
DROP TABLE t1;

CREATE TABLE t1 (c63 VARBINARY(255));
INSERT INTO t1 VALUES (0x00);
INSERT INTO t1 VALUES (0x02);
INSERT INTO t1 VALUES (repeat('a\0',120));
DELETE FROM t1 WHERE c63=0x02;
DROP TABLE t1;

#
flush logs;

CREATE TABLE t1 (c65 TINYBLOB);
INSERT INTO t1 VALUES ('tinyblob1');
DELETE FROM t1 WHERE c65='tinyblob1';
DROP TABLE t1;

CREATE TABLE t1 (c68 BLOB);
INSERT INTO t1 VALUES ('blob1');
DELETE FROM t1 WHERE c68='blob1';
DROP TABLE t1;

CREATE TABLE t1 (c71 MEDIUMBLOB);
INSERT INTO t1 VALUES ('mediumblob1');
DELETE FROM t1 WHERE c71='mediumblob1';
DROP TABLE t1;

CREATE TABLE t1 (c74 LONGBLOB);
INSERT INTO t1 VALUES ('longblob1');
DELETE FROM t1 WHERE c74='longblob1';
DROP TABLE t1;

CREATE TABLE t1 (c66 TINYTEXT);
INSERT INTO t1 VALUES ('tinytext1');
DELETE FROM t1 WHERE c66='tinytext1';
DROP TABLE t1;

CREATE TABLE t1 (c69 TEXT);
INSERT INTO t1 VALUES ('text1');
DELETE FROM t1 WHERE c69='text1';
DROP TABLE t1;

CREATE TABLE t1 (c72 MEDIUMTEXT);
INSERT INTO t1 VALUES ('mediumtext1');
DELETE FROM t1 WHERE c72='mediumtext1';
DROP TABLE t1;

CREATE TABLE t1 (c75 LONGTEXT);
INSERT INTO t1 VALUES ('longtext1');
DELETE FROM t1 WHERE c75='longtext1';
DROP TABLE t1;

#

CREATE TABLE t1 (c77 ENUM('a','b','c'));
INSERT INTO t1 VALUES ('b');
DELETE FROM t1 WHERE c77='b';
DROP TABLE t1;

#

CREATE TABLE t1 (c78 SET('a','b','c','d','e','f'));
INSERT INTO t1 VALUES ('a,b');
INSERT INTO t1 VALUES ('a,c');
INSERT INTO t1 VALUES ('b,c');
INSERT INTO t1 VALUES ('a,b,c');
INSERT INTO t1 VALUES ('a,b,c,d');
INSERT INTO t1 VALUES ('a,b,c,d,e');
INSERT INTO t1 VALUES ('a,b,c,d,e,f');
DELETE FROM t1 WHERE c78='a,b';
DROP TABLE t1;

#
# Check multi-table update
#
CREATE TABLE t1 (a int NOT NULL DEFAULT 0, b int NOT NULL DEFAULT 0);
CREATE TABLE t2 (a int NOT NULL DEFAULT 0, b int NOT NULL DEFAULT 0);
INSERT INTO t1 SET a=1;
INSERT INTO t1 SET b=1;
INSERT INTO t2 SET a=1;
INSERT INTO t2 SET b=1;
UPDATE t1, t2 SET t1.a=10, t2.a=20;
DROP TABLE t1,t2;

flush logs;

let $MYSQLD_DATADIR= `select @@datadir`;

# Test reading one file in raw mode
--exec $MYSQL_BINLOG --raw --read-from-remote-server --user=root --host=127.0.0.1 --port=$MASTER_MYPORT --result-file=$MYSQLTEST_VARDIR/tmp/ master-bin.000001
--diff_files $MYSQLTEST_VARDIR/tmp/master-bin.000001 $MYSQLD_DATADIR/master-bin.000001
--remove_file $MYSQLTEST_VARDIR/tmp/master-bin.000001

# Test reading all files in raw mode
# Don't test the end file since this is still open with mysqld so will be different
--exec $MYSQL_BINLOG --raw --read-from-remote-server --to-last-log --user=root --host=127.0.0.1 --port=$MASTER_MYPORT --result-file=$MYSQLTEST_VARDIR/tmp/ master-bin.000001
--diff_files $MYSQLTEST_VARDIR/tmp/master-bin.000001 $MYSQLD_DATADIR/master-bin.000001
--diff_files $MYSQLTEST_VARDIR/tmp/master-bin.000002 $MYSQLD_DATADIR/master-bin.000002

--remove_file $MYSQLTEST_VARDIR/tmp/master-bin.000001
--remove_file $MYSQLTEST_VARDIR/tmp/master-bin.000002
--remove_file $MYSQLTEST_VARDIR/tmp/master-bin.000003


# Test output to different filename
--exec $MYSQL_BINLOG --raw --read-from-remote-server --user=root --host=127.0.0.1 --port=$MASTER_MYPORT --result-file=$MYSQLTEST_VARDIR/tmp/server1- master-bin.000001
--diff_files $MYSQLTEST_VARDIR/tmp/server1-master-bin.000001 $MYSQLD_DATADIR/master-bin.000001
--remove_file $MYSQLTEST_VARDIR/tmp/server1-master-bin.000001
