/*****************************************************************************
*
* Copyright (c) 2000 - 2013, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <StatusAttributes.h>
#include <DataNode.h>

const int StatusAttributes::DEFAULT_DURATION = 5000;

// ****************************************************************************
// Method: StatusAttributes::StatusAttributes
//
// Purpose: 
//   Init utility for the StatusAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void StatusAttributes::Init()
{
    sender = "viewer";
    clearStatus = false;
    hasUnicode = false;
    percent = 0;
    currentStage = 1;
    currentStageName = "stage1";
    maxStage = 1;
    messageType = 0;
    duration = 5000;

    StatusAttributes::SelectAll();
}

// ****************************************************************************
// Method: StatusAttributes::StatusAttributes
//
// Purpose: 
//   Copy utility for the StatusAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void StatusAttributes::Copy(const StatusAttributes &obj)
{
    sender = obj.sender;
    clearStatus = obj.clearStatus;
    statusMessage = obj.statusMessage;
    unicode = obj.unicode;
    hasUnicode = obj.hasUnicode;
    percent = obj.percent;
    currentStage = obj.currentStage;
    currentStageName = obj.currentStageName;
    maxStage = obj.maxStage;
    messageType = obj.messageType;
    duration = obj.duration;

    StatusAttributes::SelectAll();
}

// Type map format string
const char *StatusAttributes::TypeMapFormatString = STATUSATTRIBUTES_TMFS;
const AttributeGroup::private_tmfs_t StatusAttributes::TmfsStruct = {STATUSATTRIBUTES_TMFS};


// ****************************************************************************
// Method: StatusAttributes::StatusAttributes
//
// Purpose: 
//   Default constructor for the StatusAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

StatusAttributes::StatusAttributes() : 
    AttributeSubject(StatusAttributes::TypeMapFormatString)
{
    StatusAttributes::Init();
}

// ****************************************************************************
// Method: StatusAttributes::StatusAttributes
//
// Purpose: 
//   Constructor for the derived classes of StatusAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

StatusAttributes::StatusAttributes(private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    StatusAttributes::Init();
}

// ****************************************************************************
// Method: StatusAttributes::StatusAttributes
//
// Purpose: 
//   Copy constructor for the StatusAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

StatusAttributes::StatusAttributes(const StatusAttributes &obj) : 
    AttributeSubject(StatusAttributes::TypeMapFormatString)
{
    StatusAttributes::Copy(obj);
}

// ****************************************************************************
// Method: StatusAttributes::StatusAttributes
//
// Purpose: 
//   Copy constructor for derived classes of the StatusAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

StatusAttributes::StatusAttributes(const StatusAttributes &obj, private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    StatusAttributes::Copy(obj);
}

// ****************************************************************************
// Method: StatusAttributes::~StatusAttributes
//
// Purpose: 
//   Destructor for the StatusAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

StatusAttributes::~StatusAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: StatusAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the StatusAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

StatusAttributes& 
StatusAttributes::operator = (const StatusAttributes &obj)
{
    if (this == &obj) return *this;

    StatusAttributes::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: StatusAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the StatusAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
StatusAttributes::operator == (const StatusAttributes &obj) const
{
    // Create the return value
    return ((sender == obj.sender) &&
            (clearStatus == obj.clearStatus) &&
            (statusMessage == obj.statusMessage) &&
            (unicode == obj.unicode) &&
            (hasUnicode == obj.hasUnicode) &&
            (percent == obj.percent) &&
            (currentStage == obj.currentStage) &&
            (currentStageName == obj.currentStageName) &&
            (maxStage == obj.maxStage) &&
            (messageType == obj.messageType) &&
            (duration == obj.duration));
}

// ****************************************************************************
// Method: StatusAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the StatusAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
StatusAttributes::operator != (const StatusAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: StatusAttributes::TypeName
//
// Purpose: 
//   Type name method for the StatusAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const std::string
StatusAttributes::TypeName() const
{
    return "StatusAttributes";
}

// ****************************************************************************
// Method: StatusAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the StatusAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
StatusAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const StatusAttributes *tmp = (const StatusAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: StatusAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the StatusAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
StatusAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new StatusAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: StatusAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the StatusAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
StatusAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new StatusAttributes(*this);
    else
        retval = new StatusAttributes;

    return retval;
}

// ****************************************************************************
// Method: StatusAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
StatusAttributes::SelectAll()
{
    Select(ID_sender,           (void *)&sender);
    Select(ID_clearStatus,      (void *)&clearStatus);
    Select(ID_statusMessage,    (void *)&statusMessage);
    Select(ID_unicode,          (void *)&unicode);
    Select(ID_hasUnicode,       (void *)&hasUnicode);
    Select(ID_percent,          (void *)&percent);
    Select(ID_currentStage,     (void *)&currentStage);
    Select(ID_currentStageName, (void *)&currentStageName);
    Select(ID_maxStage,         (void *)&maxStage);
    Select(ID_messageType,      (void *)&messageType);
    Select(ID_duration,         (void *)&duration);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: StatusAttributes::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
StatusAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    StatusAttributes defaultObject;
    bool addToParent = false;
    // Create a node for StatusAttributes.
    DataNode *node = new DataNode("StatusAttributes");

    if(completeSave || !FieldsEqual(ID_sender, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("sender", sender));
    }

    if(completeSave || !FieldsEqual(ID_clearStatus, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("clearStatus", clearStatus));
    }

    if(completeSave || !FieldsEqual(ID_statusMessage, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("statusMessage", statusMessage));
    }

    if(completeSave || !FieldsEqual(ID_unicode, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("unicode", unicode));
    }

    if(completeSave || !FieldsEqual(ID_hasUnicode, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("hasUnicode", hasUnicode));
    }

    if(completeSave || !FieldsEqual(ID_percent, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("percent", percent));
    }

    if(completeSave || !FieldsEqual(ID_currentStage, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("currentStage", currentStage));
    }

    if(completeSave || !FieldsEqual(ID_currentStageName, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("currentStageName", currentStageName));
    }

    if(completeSave || !FieldsEqual(ID_maxStage, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("maxStage", maxStage));
    }

    if(completeSave || !FieldsEqual(ID_messageType, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("messageType", messageType));
    }

    if(completeSave || !FieldsEqual(ID_duration, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("duration", duration));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: StatusAttributes::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
StatusAttributes::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("StatusAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("sender")) != 0)
        SetSender(node->AsString());
    if((node = searchNode->GetNode("clearStatus")) != 0)
        SetClearStatus(node->AsBool());
    if((node = searchNode->GetNode("statusMessage")) != 0)
        SetStatusMessage(node->AsString());
    if((node = searchNode->GetNode("unicode")) != 0)
        SetUnicode(node->AsUnsignedCharVector());
    if((node = searchNode->GetNode("hasUnicode")) != 0)
        SetHasUnicode(node->AsBool());
    if((node = searchNode->GetNode("percent")) != 0)
        SetPercent(node->AsInt());
    if((node = searchNode->GetNode("currentStage")) != 0)
        SetCurrentStage(node->AsInt());
    if((node = searchNode->GetNode("currentStageName")) != 0)
        SetCurrentStageName(node->AsString());
    if((node = searchNode->GetNode("maxStage")) != 0)
        SetMaxStage(node->AsInt());
    if((node = searchNode->GetNode("messageType")) != 0)
        SetMessageType(node->AsInt());
    if((node = searchNode->GetNode("duration")) != 0)
        SetDuration(node->AsInt());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
StatusAttributes::SetSender(const std::string &sender_)
{
    sender = sender_;
    Select(ID_sender, (void *)&sender);
}

void
StatusAttributes::SetClearStatus(bool clearStatus_)
{
    clearStatus = clearStatus_;
    Select(ID_clearStatus, (void *)&clearStatus);
}

void
StatusAttributes::SetStatusMessage(const std::string &statusMessage_)
{
    statusMessage = statusMessage_;
    Select(ID_statusMessage, (void *)&statusMessage);
}

void
StatusAttributes::SetUnicode(const unsignedCharVector &unicode_)
{
    unicode = unicode_;
    Select(ID_unicode, (void *)&unicode);
}

void
StatusAttributes::SetHasUnicode(bool hasUnicode_)
{
    hasUnicode = hasUnicode_;
    Select(ID_hasUnicode, (void *)&hasUnicode);
}

void
StatusAttributes::SetPercent(int percent_)
{
    percent = percent_;
    Select(ID_percent, (void *)&percent);
}

void
StatusAttributes::SetCurrentStage(int currentStage_)
{
    currentStage = currentStage_;
    Select(ID_currentStage, (void *)&currentStage);
}

void
StatusAttributes::SetCurrentStageName(const std::string &currentStageName_)
{
    currentStageName = currentStageName_;
    Select(ID_currentStageName, (void *)&currentStageName);
}

void
StatusAttributes::SetMaxStage(int maxStage_)
{
    maxStage = maxStage_;
    Select(ID_maxStage, (void *)&maxStage);
}

void
StatusAttributes::SetMessageType(int messageType_)
{
    messageType = messageType_;
    Select(ID_messageType, (void *)&messageType);
}

void
StatusAttributes::SetDuration(int duration_)
{
    duration = duration_;
    Select(ID_duration, (void *)&duration);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

const std::string &
StatusAttributes::GetSender() const
{
    return sender;
}

std::string &
StatusAttributes::GetSender()
{
    return sender;
}

bool
StatusAttributes::GetClearStatus() const
{
    return clearStatus;
}

const std::string &
StatusAttributes::GetStatusMessage() const
{
    return statusMessage;
}

std::string &
StatusAttributes::GetStatusMessage()
{
    return statusMessage;
}

const unsignedCharVector &
StatusAttributes::GetUnicode() const
{
    return unicode;
}

unsignedCharVector &
StatusAttributes::GetUnicode()
{
    return unicode;
}

bool
StatusAttributes::GetHasUnicode() const
{
    return hasUnicode;
}

int
StatusAttributes::GetPercent() const
{
    return percent;
}

int
StatusAttributes::GetCurrentStage() const
{
    return currentStage;
}

const std::string &
StatusAttributes::GetCurrentStageName() const
{
    return currentStageName;
}

std::string &
StatusAttributes::GetCurrentStageName()
{
    return currentStageName;
}

int
StatusAttributes::GetMaxStage() const
{
    return maxStage;
}

int
StatusAttributes::GetMessageType() const
{
    return messageType;
}

int
StatusAttributes::GetDuration() const
{
    return duration;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
StatusAttributes::SelectSender()
{
    Select(ID_sender, (void *)&sender);
}

void
StatusAttributes::SelectStatusMessage()
{
    Select(ID_statusMessage, (void *)&statusMessage);
}

void
StatusAttributes::SelectUnicode()
{
    Select(ID_unicode, (void *)&unicode);
}

void
StatusAttributes::SelectCurrentStageName()
{
    Select(ID_currentStageName, (void *)&currentStageName);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: StatusAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
StatusAttributes::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_sender:           return "sender";
    case ID_clearStatus:      return "clearStatus";
    case ID_statusMessage:    return "statusMessage";
    case ID_unicode:          return "unicode";
    case ID_hasUnicode:       return "hasUnicode";
    case ID_percent:          return "percent";
    case ID_currentStage:     return "currentStage";
    case ID_currentStageName: return "currentStageName";
    case ID_maxStage:         return "maxStage";
    case ID_messageType:      return "messageType";
    case ID_duration:         return "duration";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: StatusAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
StatusAttributes::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_sender:           return FieldType_string;
    case ID_clearStatus:      return FieldType_bool;
    case ID_statusMessage:    return FieldType_string;
    case ID_unicode:          return FieldType_ucharVector;
    case ID_hasUnicode:       return FieldType_bool;
    case ID_percent:          return FieldType_int;
    case ID_currentStage:     return FieldType_int;
    case ID_currentStageName: return FieldType_string;
    case ID_maxStage:         return FieldType_int;
    case ID_messageType:      return FieldType_int;
    case ID_duration:         return FieldType_int;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: StatusAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
StatusAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_sender:           return "string";
    case ID_clearStatus:      return "bool";
    case ID_statusMessage:    return "string";
    case ID_unicode:          return "ucharVector";
    case ID_hasUnicode:       return "bool";
    case ID_percent:          return "int";
    case ID_currentStage:     return "int";
    case ID_currentStageName: return "string";
    case ID_maxStage:         return "int";
    case ID_messageType:      return "int";
    case ID_duration:         return "int";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: StatusAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
StatusAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const StatusAttributes &obj = *((const StatusAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_sender:
        {  // new scope
        retval = (sender == obj.sender);
        }
        break;
    case ID_clearStatus:
        {  // new scope
        retval = (clearStatus == obj.clearStatus);
        }
        break;
    case ID_statusMessage:
        {  // new scope
        retval = (statusMessage == obj.statusMessage);
        }
        break;
    case ID_unicode:
        {  // new scope
        retval = (unicode == obj.unicode);
        }
        break;
    case ID_hasUnicode:
        {  // new scope
        retval = (hasUnicode == obj.hasUnicode);
        }
        break;
    case ID_percent:
        {  // new scope
        retval = (percent == obj.percent);
        }
        break;
    case ID_currentStage:
        {  // new scope
        retval = (currentStage == obj.currentStage);
        }
        break;
    case ID_currentStageName:
        {  // new scope
        retval = (currentStageName == obj.currentStageName);
        }
        break;
    case ID_maxStage:
        {  // new scope
        retval = (maxStage == obj.maxStage);
        }
        break;
    case ID_messageType:
        {  // new scope
        retval = (messageType == obj.messageType);
        }
        break;
    case ID_duration:
        {  // new scope
        retval = (duration == obj.duration);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

