/***********************************************************************
 * config-bot.h
 ***********************************************************************
 * This file is part of the package paco
 * Copyright (C) 2004-2006 David Rosal
 * For more information visit http://paco.sourceforge.net
 ***********************************************************************/

#ifndef PACO_CONFIG_BOT_H
#define PACO_CONFIG_BOT_H

#ifdef __cplusplus
#	include <cstdio>
#	include <cstdlib>
#	include <cassert>
#	include <cerrno>
#	include <cstring>
#else
#	include <stdio.h>
#	include <stdlib.h>
#	include <assert.h>
#	include <errno.h>
#	if HAVE_STRING_H
#		if !STDC_HEADERS && HAVE_MEMORY_H
#			include <memory.h>
#		endif
#		include <string.h>
#	endif
#	if HAVE_STRINGS_H
#		include <strings.h>
#	endif
#endif

#if HAVE_SYS_TYPES_H
#	include <sys/types.h>
#endif

#if HAVE_SYS_STAT_H
#	include <sys/stat.h>
#endif

#if HAVE_INTTYPES_H
#	include <inttypes.h>
#elif HAVE_STDINT_H
#	include <stdint.h>
#endif

#if HAVE_UNISTD_H
#	include <unistd.h>
#endif

#if TIME_WITH_SYS_TIME
#	include <sys/time.h>
#	include <time.h>
#elif HAVE_SYS_TIME_H
#	include <sys/time.h>
#else
#	include <time.h>
#endif

#ifdef HAVE_SYS_WAIT_H
#   include <sys/wait.h>
#endif
#ifndef WEXITSTATUS
#  	define WEXITSTATUS(stat_val) ((unsigned)(stat_val) >> 8)
#endif
#ifndef WIFEXITED
#   define WIFEXITED(stat_val) (((stat_val) & 255) == 0)
#endif

/* The LIKELY and UNLIKELY macros let the programmer give hints to 
   the compiler about the expected result of an expression. Some compilers
   can use this information for optimizations. */

#if defined(__GNUC__) && (__GNUC__ > 2) && defined(__OPTIMIZE__)
#	define LIKELY(expr) (__builtin_expect (expr, 1))
#	define UNLIKELY(expr) (__builtin_expect (expr, 0))
#else
#	define LIKELY(expr) (expr)
#	define UNLIKELY(expr) (expr)
#endif


#endif	/* PACO_CONFIG_BOT_H */

