###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for openldap vulnerabilities USN-551-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840030);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"7.1");
  script_tag(name:"risk_factor", value:"High");
  script_xref(name: "USN", value: "551-1");
  script_cve_id("CVE-2007-5707", "CVE-2007-5708");
  script_name( "Ubuntu Update for openldap vulnerabilities USN-551-1");
  desc = "

  Vulnerability Insight:

  Thomas Sesselmann discovered that the OpenLDAP slapd server
  did not properly handle certain modify requests. A remote
  attacker could send malicious modify requests to the server
  and cause a denial of service. (CVE-2007-5707)
  
  Toby Blake discovered that slapd did not properly terminate
  an array while running as a proxy-caching server. A remote
  attacker may be able to send crafted search requests to the
  server and cause a denial of service. This issue only affects
  Ubuntu 7.04 and 7.10. (CVE-2007-5708)

  Affected Software/OS:
  openldap vulnerabilities on Ubuntu 6.06 LTS ,
  Ubuntu 6.10 ,
  Ubuntu 7.04 ,
  Ubuntu 7.10

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2007-December/000633.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of openldap vulnerabilities");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU7.04")
{

  if(isdpkgvuln(pkg:"ldap-utils", ver:"2.3.30-2ubuntu0.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libldap", ver:"2.3-0_2.3.30-2ubuntu0.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"slapd", ver:"2.3.30-2ubuntu0.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU6.06 LTS")
{

  if(isdpkgvuln(pkg:"ldap-utils", ver:"2.2.26-5ubuntu2.4", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libldap", ver:"2.2-7_2.2.26-5ubuntu2.4", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"slapd", ver:"2.2.26-5ubuntu2.4", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU6.10")
{

  if(isdpkgvuln(pkg:"ldap-utils", ver:"2.2.26-5ubuntu3.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libldap", ver:"2.2-7_2.2.26-5ubuntu3.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"slapd", ver:"2.2.26-5ubuntu3.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU7.10")
{

  if(isdpkgvuln(pkg:"ldap-utils", ver:"2.3.35-1ubuntu0.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libldap", ver:"2.3-0_2.3.35-1ubuntu0.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"slapd", ver:"2.3.35-1ubuntu0.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}