###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_ms_win_media_services_actvx_bof_vuln.nasl 537 2008-11-26 21:26:16Z nov $
#
# Microsoft Windows Media Services nskey.dll ActiveX BOF Vulnerability
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800310);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"9.3");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2008-5232");
  script_bugtraq_id(30814);
  script_name("Microsoft Windows Media Services nskey.dll ActiveX BOF Vulnerability");
  desc = "

  Overview: This host is installed with Windows Media Services and is prone to
  Buffer Overflow vulnerability.

  Vulnerability Insight:
  The flaw is caused due to an error in CallHTMLHelp method in nskey.dll file,
  which fails to perform adequate boundary checks on user-supplied input.

  Impact:
  Successful exploitation could allow execution of arbitrary code, and cause the
  victim's browser to crash.

  Impact Level: Application

  Affected Software/OS:
  Microsoft Windows Media Services on Windows NT/2000 Server.

  Fix: No solution/patch is available as on 27th November, 2008. Information
  regarding this issue will updated once the solution details are available.
  For updates refer,
  http://www.microsoft.com/windows/windowsmedia/forpros/server/server.aspx

  Workaround: Set a kill bit for the CLSID
  {2646205B-878C-11D1-B07C-0000C040BCDB}

  References:
  http://web.nvd.nist.gov/view/vuln/detail?vulnId=CVE-2008-5232
  http://downloads.securityfocus.com/vulnerabilities/exploits/30814.html.txt

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 8.0
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of Windows Media Services");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2008 Intevation GmbH");
  script_family("Buffer overflow");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("version_func.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

wmsPath = registry_get_sz(key:"SYSTEM\ControlSet001\Services\nsmonitor",
                          item:"ImagePath");
if(!wmsPath){
  exit(0);
}

wmsPath = wmsPath - "nspmon.exe" + "nskey.dll";
share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:wmsPath);
file = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:wmsPath);

wmsVer = GetVer(file:file, share:share);
if(wmsVer == NULL){
  exit(0);
}

if(version_is_less_equal(version:wmsVer, test_version:"4.1.00.3917"))
{
  # Check if Kill-Bit is set for ActiveX control
  clsid = "{2646205B-878C-11D1-B07C-0000C040BCDB}";
  regKey = "SOFTWARE\Classes\CLSID\" + clsid;
  if(registry_key_exists(key:regKey))
  {
    activeKey = "SOFTWARE\Microsoft\Internet Explorer\ActiveX Compatibility\" + clsid;
    killBit = registry_get_dword(key:activeKey, item:"Compatibility Flags");
    if(killBit && (int(killBit) == 1024)){
      exit(0);
    }
    security_warning(0);
  }
}
