/*################################################################################
# Linux Management Providers (LMP), Simple Identity Management provider package
# Copyright (C) 2007 Frederic Desmons, ETRI <desmons@etri.re.kr, desmons_frederic@yahoo.fr>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2009 Khahramon NURIDDINOV, TUIT <qahramon0786@gmail.com>
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
################################################################################*/

#ifndef OPENDRIM_IDENTITYINGROUP_H_
#define OPENDRIM_IDENTITYINGROUP_H_

#include <Association.h>

// Direct Invocation includes, may have to be adjusted
/*
#include "cmpiCIM_ManagedElement.h"
#include "CIM_ManagedElementAccess.h"
#include "cmpiCIM_Collection.h"
#include "CIM_CollectionAccess.h"
*/

const static char* OpenDRIM_IdentityInGroup_classnames[] = {"OpenDRIM_IdentityInGroup"};
static string OpenDRIM_IdentityInGroup_NAMESPACE = _NAMESPACE;
const static string Member_role = "Member";
const static char* Member_classnames[] = {"OpenDRIM_AccountIdentity"};
const static string Member_NAMESPACE = _NAMESPACE;

const static string Collection_role = "Collection";
const static char* Collection_classnames[] = {"OpenDRIM_Group"};
const static string Collection_NAMESPACE = _NAMESPACE;

class OpenDRIM_IdentityInGroup {

public:
	
	Objectpath Collection;
	bool Collection_isNULL;
	
	Objectpath Member;
	bool Member_isNULL;
	
	bool IsPrimaryGroup;
	bool IsPrimaryGroup_isNULL;
	
	OpenDRIM_IdentityInGroup() {
		Collection_isNULL = true;
		Member_isNULL = true;
		IsPrimaryGroup_isNULL = true;
	}
	
	~OpenDRIM_IdentityInGroup() {}
	
	string getKeys() const {
		return CF_toLowCase(".Collection=\"" + CF_quoteString(Collection.toString()) + "\""".Member=\"" + CF_quoteString(Member.toString()) + "\"");
	}

	int getCollection(Objectpath& value) const {
		if (Collection_isNULL==true)
			return NOT_FOUND;
		value = Collection;
		return OK;
	}
	
	int setCollection(const Objectpath& newValue) {
		Collection = newValue;
		Collection.setNamespace(Collection_NAMESPACE);
		Collection_isNULL = false;
		return OK;
	}

	int getMember(Objectpath& value) const {
		if (Member_isNULL==true)
			return NOT_FOUND;
		value = Member;
		return OK;
	}
	
	int setMember(const Objectpath& newValue) {
		Member = newValue;
		Member.setNamespace(Member_NAMESPACE);
		Member_isNULL = false;
		return OK;
	}

	int getIsPrimaryGroup(bool& value) const {
		if (IsPrimaryGroup_isNULL==true)
			return NOT_FOUND;
		value = IsPrimaryGroup;
		return OK;
	}
	
	int setIsPrimaryGroup(const bool& newValue) {
		IsPrimaryGroup = newValue;
		IsPrimaryGroup_isNULL = false;
		return OK;
	}

};

#endif /*OPENDRIM_IDENTITYINGROUP_H_*/
