/*
    Copyright (c) 2008-2009 NetAllied Systems GmbH

    This file is part of COLLADASaxFrameworkLoader.

    Licensed under the MIT Open Source License,
    for details please see LICENSE file or the website
    http://www.opensource.org/licenses/mit-license.php
*/

#include "COLLADASaxFWLStableHeaders.h"
#include "GeneratedSaxParserUtils.h"

#include "COLLADASaxFWLColladaParserAutoGen15Private.h"


// disable warning "unused variable"
#if defined(__INTEL_COMPILER) && !defined(WIN32)
template <typename T>
inline void disable_warning_unused(T &x) { (void)x; }
#    define DISABLE_WARNING_UNUSED(x) disable_warning_unused(x);
#else
#    define DISABLE_WARNING_UNUSED(x) (void)x;
#endif



namespace COLLADASaxFWL15
{


//---------------------------------------------------------------------
ColladaParserAutoGen15Private::ColladaParserAutoGen15Private( COLLADASaxFWL15::ColladaParserAutoGen15* impl, GeneratedSaxParser::IErrorHandler* errorHandler 
)    : GeneratedSaxParser::ParserTemplate<ColladaParserAutoGen15Private, ColladaParserAutoGen15>(impl, errorHandler)
{
    initFunctionMap();
    initNameMap();
}

//---------------------------------------------------------------------
ColladaParserAutoGen15Private::~ColladaParserAutoGen15Private()
{
}


//---------------------------------------------------------------------
const char* NAME_NAMESPACE_COLLADA = "http://www.collada.org/2008/03/COLLADASchema";
const char* NAME_NAMESPACE_http___www_w3_org_2001_XMLSchema = "http://www.w3.org/2001/XMLSchema";
const char* NAME_NAMESPACE_http___www_w3_org_XML_1998_namespace = "http://www.w3.org/XML/1998/namespace";
const char* NAME_NAMESPACE_mathml = "http://www.w3.org/1998/Math/MathML";
const char* NAME_NAMESPACE_http___www_w3_org_1999_xlink = "http://www.w3.org/1999/xlink";

const char* NAME_ATTRIBUTE_ALTIMG = "altimg";
const char* NAME_ATTRIBUTE_ALTTEXT = "alttext";
const char* NAME_ATTRIBUTE_ARRAY_INDEX = "array_index";
const char* NAME_ATTRIBUTE_AUTO_GENERATE = "auto_generate";
const char* NAME_ATTRIBUTE_AXIS = NAME_ELEMENT_AXIS;
const char* NAME_ATTRIBUTE_BASE = "xml:base";
const char* NAME_ATTRIBUTE_BASELINE = "baseline";
const char* NAME_ATTRIBUTE_BODY = "body";
const char* NAME_ATTRIBUTE_CAMERA_NODE = "camera_node";
const char* NAME_ATTRIBUTE_CHANNELS = "channels";
const char* NAME_ATTRIBUTE_CLASS = "class";
const char* NAME_ATTRIBUTE_CLOSED = "closed";
const char* NAME_ATTRIBUTE_CLOSED_U = "closed_u";
const char* NAME_ATTRIBUTE_CLOSED_V = "closed_v";
const char* NAME_ATTRIBUTE_CLOSURE = "closure";
const char* NAME_ATTRIBUTE_CONSTRAINT = "constraint";
const char* NAME_ATTRIBUTE_CONVEX_HULL_OF = "convex_hull_of";
const char* NAME_ATTRIBUTE_COUNT = "count";
const char* NAME_ATTRIBUTE_DEFINITIONURL = "definitionURL";
const char* NAME_ATTRIBUTE_DEGREE = "degree";
const char* NAME_ATTRIBUTE_DEGREE_U = "degree_u";
const char* NAME_ATTRIBUTE_DEGREE_V = "degree_v";
const char* NAME_ATTRIBUTE_DEPTH = "depth";
const char* NAME_ATTRIBUTE_DIGITS = "digits";
const char* NAME_ATTRIBUTE_DISPLAY = "display";
const char* NAME_ATTRIBUTE_ENABLE = "enable";
const char* NAME_ATTRIBUTE_ENCODING = "encoding";
const char* NAME_ATTRIBUTE_END = "end";
const char* NAME_ATTRIBUTE_ENTRY = "entry";
const char* NAME_ATTRIBUTE_FACE = NAME_ELEMENT_FACE;
const char* NAME_ATTRIBUTE_FORMAT = "format";
const char* NAME_ATTRIBUTE_HEIGHT = "height";
const char* NAME_ATTRIBUTE_HREF = "href";
const char* NAME_ATTRIBUTE_ID = "id";
const char* NAME_ATTRIBUTE_INDEX = "index";
const char* NAME_ATTRIBUTE_INPUT_SEMANTIC = "input_semantic";
const char* NAME_ATTRIBUTE_INPUT_SET = "input_set";
const char* NAME_ATTRIBUTE_JOINT = NAME_ELEMENT_JOINT;
const char* NAME_ATTRIBUTE_LANGUAGE = "language";
const char* NAME_ATTRIBUTE_LAYER = "layer";
const char* NAME_ATTRIBUTE_LENGTH = "length";
const char* NAME_ATTRIBUTE_LEVELS = "levels";
const char* NAME_ATTRIBUTE_LINK = NAME_ELEMENT_LINK;
const char* NAME_ATTRIBUTE_MACROS = "macros";
const char* NAME_ATTRIBUTE_MAGNITUDE = "magnitude";
const char* NAME_ATTRIBUTE_MATERIAL = "material";
const char* NAME_ATTRIBUTE_MAXINCLUSIVE = "maxInclusive";
const char* NAME_ATTRIBUTE_METER = "meter";
const char* NAME_ATTRIBUTE_METHOD = "method";
const char* NAME_ATTRIBUTE_MININCLUSIVE = "minInclusive";
const char* NAME_ATTRIBUTE_MIP = "mip";
const char* NAME_ATTRIBUTE_MIPS_GENERATE = "mips_generate";
const char* NAME_ATTRIBUTE_MIP_INDEX = "mip_index";
const char* NAME_ATTRIBUTE_MODE = "mode";
const char* NAME_ATTRIBUTE_NAME = "name";
const char* NAME_ATTRIBUTE_NARGS = "nargs";
const char* NAME_ATTRIBUTE_NODE = NAME_ELEMENT_NODE;
const char* NAME_ATTRIBUTE_OCCURRENCE = "occurrence";
const char* NAME_ATTRIBUTE_OFFSET = "offset";
const char* NAME_ATTRIBUTE_OPAQUE = "opaque";
const char* NAME_ATTRIBUTE_OPERAND = "operand";
const char* NAME_ATTRIBUTE_OPERATOR = "operator";
const char* NAME_ATTRIBUTE_OPTIONS = "options";
const char* NAME_ATTRIBUTE_ORDER = "order";
const char* NAME_ATTRIBUTE_OVERFLOW = "overflow";
const char* NAME_ATTRIBUTE_PARAM = NAME_ELEMENT_PARAM;
const char* NAME_ATTRIBUTE_PARENT = "parent";
const char* NAME_ATTRIBUTE_PASS = NAME_ELEMENT_PASS;
const char* NAME_ATTRIBUTE_PLATFORM = "platform";
const char* NAME_ATTRIBUTE_PLATFORMS = "platforms";
const char* NAME_ATTRIBUTE_POST_BEHAVIOR = "post_behavior";
const char* NAME_ATTRIBUTE_PRECISION = "precision";
const char* NAME_ATTRIBUTE_PRE_BEHAVIOR = "pre_behavior";
const char* NAME_ATTRIBUTE_PROFILE = "profile";
const char* NAME_ATTRIBUTE_PROXY = "proxy";
const char* NAME_ATTRIBUTE_RANGE = "range";
const char* NAME_ATTRIBUTE_REF = "ref";
const char* NAME_ATTRIBUTE_RESIZABLE = "resizable";
const char* NAME_ATTRIBUTE_RIGID_BODY = NAME_ELEMENT_RIGID_BODY;
const char* NAME_ATTRIBUTE_SAMPLER = NAME_ELEMENT_SAMPLER;
const char* NAME_ATTRIBUTE_SCALE = "scale";
const char* NAME_ATTRIBUTE_SCOPE = "scope";
const char* NAME_ATTRIBUTE_SEMANTIC = "semantic";
const char* NAME_ATTRIBUTE_SET = "set";
const char* NAME_ATTRIBUTE_SHARE = "share";
const char* NAME_ATTRIBUTE_SID = "sid";
const char* NAME_ATTRIBUTE_SLICE = "slice";
const char* NAME_ATTRIBUTE_SOURCE = NAME_ELEMENT_SOURCE;
const char* NAME_ATTRIBUTE_SPACE = "space";
const char* NAME_ATTRIBUTE_STAGE = "stage";
const char* NAME_ATTRIBUTE_START = "start";
const char* NAME_ATTRIBUTE_STRIDE = "stride";
const char* NAME_ATTRIBUTE_STYLE = "style";
const char* NAME_ATTRIBUTE_SYMBOL = "symbol";
const char* NAME_ATTRIBUTE_TARGET = "target";
const char* NAME_ATTRIBUTE_TEXCOORD = "texcoord";
const char* NAME_ATTRIBUTE_TEXTURE = NAME_ELEMENT_TEXTURE;
const char* NAME_ATTRIBUTE_TYPE = "type";
const char* NAME_ATTRIBUTE_TYPENAME = "typename";
const char* NAME_ATTRIBUTE_URL = "url";
const char* NAME_ATTRIBUTE_VALUE = "value";
const char* NAME_ATTRIBUTE_VERSION = "version";
const char* NAME_ATTRIBUTE_WIDTH = "width";
const char* NAME_ATTRIBUTE_XMLNS = "xmlns";
const char* NAME_ATTRIBUTE_XREF = "xref";
const char* NAME_ELEMENT_ABS = "abs";
const char* NAME_ELEMENT_ACCELERATION = "acceleration";
const char* NAME_ELEMENT_ACCELERATION____COMMON_FLOAT2_OR_PARAM_TYPE = "acceleration____common_float2_or_param_type";
const char* NAME_ELEMENT_ACCELERATION____COMMON_FLOAT_OR_PARAM_TYPE = "acceleration____common_float_or_param_type";
const char* NAME_ELEMENT_ACCESSOR = "accessor";
const char* NAME_ELEMENT_ACTIVE = "active";
const char* NAME_ELEMENT_ALPHA = "alpha";
const char* NAME_ELEMENT_ALPHA_FUNC = "alpha_func";
const char* NAME_ELEMENT_ALPHA_TEST_ENABLE = "alpha_test_enable";
const char* NAME_ELEMENT_ALPHA____GLES_TEXCOMBINER_COMMAND_ALPHA_TYPE = "alpha____gles_texcombiner_command_alpha_type";
const char* NAME_ELEMENT_ALTITUDE = "altitude";
const char* NAME_ELEMENT_AMBIENT = "ambient";
const char* NAME_ELEMENT_AMBIENT____FX_COMMON_COLOR_OR_TEXTURE_TYPE = "ambient____fx_common_color_or_texture_type";
const char* NAME_ELEMENT_AND = "and";
const char* NAME_ELEMENT_ANGLE = "angle";
const char* NAME_ELEMENT_ANGULAR = "angular";
const char* NAME_ELEMENT_ANGULAR_VELOCITY = "angular_velocity";
const char* NAME_ELEMENT_ANIMATION = "animation";
const char* NAME_ELEMENT_ANIMATION_CLIP = "animation_clip";
const char* NAME_ELEMENT_ANNOTATE = "annotate";
const char* NAME_ELEMENT_ANNOTATION = "annotation";
const char* NAME_ELEMENT_ANNOTATION_XML = "annotation_xml";
const char* NAME_ELEMENT_APPLY = "apply";
const char* NAME_ELEMENT_APPROX = "approx";
const char* NAME_ELEMENT_ARCCOS = "arccos";
const char* NAME_ELEMENT_ARCCOSH = "arccosh";
const char* NAME_ELEMENT_ARCCOT = "arccot";
const char* NAME_ELEMENT_ARCCOTH = "arccoth";
const char* NAME_ELEMENT_ARCCSC = "arccsc";
const char* NAME_ELEMENT_ARCCSCH = "arccsch";
const char* NAME_ELEMENT_ARCSEC = "arcsec";
const char* NAME_ELEMENT_ARCSECH = "arcsech";
const char* NAME_ELEMENT_ARCSIN = "arcsin";
const char* NAME_ELEMENT_ARCSINH = "arcsinh";
const char* NAME_ELEMENT_ARCTAN = "arctan";
const char* NAME_ELEMENT_ARCTANH = "arctanh";
const char* NAME_ELEMENT_ARG = "arg";
const char* NAME_ELEMENT_ARGUMENT = "argument";
const char* NAME_ELEMENT_ARGUMENT____GLES_TEXCOMBINER_ARGUMENT_ALPHA_TYPE = "argument____gles_texcombiner_argument_alpha_type";
const char* NAME_ELEMENT_ARGUMENT____GLES_TEXCOMBINER_ARGUMENT_RGB_TYPE = "argument____gles_texcombiner_argument_rgb_type";
const char* NAME_ELEMENT_ARRAY = "array";
const char* NAME_ELEMENT_ARRAY____CG_ARRAY_TYPE = "array____cg_array_type";
const char* NAME_ELEMENT_ARRAY____GLSL_ARRAY_TYPE = "array____glsl_array_type";
const char* NAME_ELEMENT_ARTICULATED_SYSTEM = "articulated_system";
const char* NAME_ELEMENT_ASPECT_RATIO = "aspect_ratio";
const char* NAME_ELEMENT_ASSET = "asset";
const char* NAME_ELEMENT_ATTACHMENT = "attachment";
const char* NAME_ELEMENT_ATTACHMENT_END = "attachment_end";
const char* NAME_ELEMENT_ATTACHMENT_FULL = "attachment_full";
const char* NAME_ELEMENT_ATTACHMENT_START = "attachment_start";
const char* NAME_ELEMENT_AUTHOR = "author";
const char* NAME_ELEMENT_AUTHORING_TOOL = "authoring_tool";
const char* NAME_ELEMENT_AUTHOR_EMAIL = "author_email";
const char* NAME_ELEMENT_AUTHOR_WEBSITE = "author_website";
const char* NAME_ELEMENT_AXIS = "axis";
const char* NAME_ELEMENT_AXIS_INFO = "axis_info";
const char* NAME_ELEMENT_AXIS_INFO____KINEMATICS_AXIS_INFO_TYPE = "axis_info____kinematics_axis_info_type";
const char* NAME_ELEMENT_AXIS_INFO____MOTION_AXIS_INFO_TYPE = "axis_info____motion_axis_info_type";
const char* NAME_ELEMENT_AXIS____AXIS_TYPE = "axis____axis_type";
const char* NAME_ELEMENT_AXIS____COMMON_SIDREF_OR_PARAM_TYPE = "axis____common_sidref_or_param_type";
const char* NAME_ELEMENT_AXIS____FLOAT3_TYPE = "axis____float3_type";
const char* NAME_ELEMENT_BACK = "back";
const char* NAME_ELEMENT_BINARY = "binary";
const char* NAME_ELEMENT_BINARY__HEX = "binary__hex";
const char* NAME_ELEMENT_BIND = "bind";
const char* NAME_ELEMENT_BIND_ATTRIBUTE = "bind_attribute";
const char* NAME_ELEMENT_BIND_JOINT_AXIS = "bind_joint_axis";
const char* NAME_ELEMENT_BIND_KINEMATICS_MODEL = "bind_kinematics_model";
const char* NAME_ELEMENT_BIND_MATERIAL = "bind_material";
const char* NAME_ELEMENT_BIND_MATERIAL_TYPE____TECHNIQUE_COMMON = "bind_material_type____technique_common";
const char* NAME_ELEMENT_BIND_SHAPE_MATRIX = "bind_shape_matrix";
const char* NAME_ELEMENT_BIND_UNIFORM = "bind_uniform";
const char* NAME_ELEMENT_BIND_VERTEX_INPUT = "bind_vertex_input";
const char* NAME_ELEMENT_BIND____KINEMATICS_BIND_TYPE = "bind____kinematics_bind_type";
const char* NAME_ELEMENT_BLEND_COLOR = "blend_color";
const char* NAME_ELEMENT_BLEND_ENABLE = "blend_enable";
const char* NAME_ELEMENT_BLEND_EQUATION = "blend_equation";
const char* NAME_ELEMENT_BLEND_EQUATION_SEPARATE = "blend_equation_separate";
const char* NAME_ELEMENT_BLEND_FUNC = "blend_func";
const char* NAME_ELEMENT_BLEND_FUNC_SEPARATE = "blend_func_separate";
const char* NAME_ELEMENT_BLINN = "blinn";
const char* NAME_ELEMENT_BOOL = "bool";
const char* NAME_ELEMENT_BOOL2 = "bool2";
const char* NAME_ELEMENT_BOOL2X1 = "bool2x1";
const char* NAME_ELEMENT_BOOL2X2 = "bool2x2";
const char* NAME_ELEMENT_BOOL2X3 = "bool2x3";
const char* NAME_ELEMENT_BOOL2X4 = "bool2x4";
const char* NAME_ELEMENT_BOOL3 = "bool3";
const char* NAME_ELEMENT_BOOL3X1 = "bool3x1";
const char* NAME_ELEMENT_BOOL3X2 = "bool3x2";
const char* NAME_ELEMENT_BOOL3X3 = "bool3x3";
const char* NAME_ELEMENT_BOOL3X4 = "bool3x4";
const char* NAME_ELEMENT_BOOL4 = "bool4";
const char* NAME_ELEMENT_BOOL4X1 = "bool4x1";
const char* NAME_ELEMENT_BOOL4X2 = "bool4x2";
const char* NAME_ELEMENT_BOOL4X3 = "bool4x3";
const char* NAME_ELEMENT_BOOL4X4 = "bool4x4";
const char* NAME_ELEMENT_BOOL_ARRAY = "bool_array";
const char* NAME_ELEMENT_BORDER_COLOR = "border_color";
const char* NAME_ELEMENT_BOX = "box";
const char* NAME_ELEMENT_BREP = "brep";
const char* NAME_ELEMENT_BVAR = "bvar";
const char* NAME_ELEMENT_BVEC2 = "bvec2";
const char* NAME_ELEMENT_BVEC3 = "bvec3";
const char* NAME_ELEMENT_BVEC4 = "bvec4";
const char* NAME_ELEMENT_CAMERA = "camera";
const char* NAME_ELEMENT_CAPSULE = "capsule";
const char* NAME_ELEMENT_CARD = "card";
const char* NAME_ELEMENT_CARTESIANPRODUCT = "cartesianproduct";
const char* NAME_ELEMENT_CEILING = "ceiling";
const char* NAME_ELEMENT_CG_PASS_TYPE____EVALUATE = "cg_pass_type____evaluate";
const char* NAME_ELEMENT_CG_PASS_TYPE____PROGRAM = "cg_pass_type____program";
const char* NAME_ELEMENT_CG_PASS_TYPE____STATES = "cg_pass_type____states";
const char* NAME_ELEMENT_CHANNEL = "channel";
const char* NAME_ELEMENT_CI = "ci";
const char* NAME_ELEMENT_CIRCLE = "circle";
const char* NAME_ELEMENT_CLIP_PLANE = "clip_plane";
const char* NAME_ELEMENT_CLIP_PLANE_ENABLE = "clip_plane_enable";
const char* NAME_ELEMENT_CN = "cn";
const char* NAME_ELEMENT_CODE = "code";
const char* NAME_ELEMENT_CODOMAIN = "codomain";
const char* NAME_ELEMENT_COLLADA = "COLLADA";
const char* NAME_ELEMENT_COLOR = "color";
const char* NAME_ELEMENT_COLOR_CLEAR = "color_clear";
const char* NAME_ELEMENT_COLOR_LOGIC_OP_ENABLE = "color_logic_op_enable";
const char* NAME_ELEMENT_COLOR_MASK = "color_mask";
const char* NAME_ELEMENT_COLOR_MATERIAL = "color_material";
const char* NAME_ELEMENT_COLOR_MATERIAL_ENABLE = "color_material_enable";
const char* NAME_ELEMENT_COLOR_MATERIAL__FACE = "color_material__face";
const char* NAME_ELEMENT_COLOR_MATERIAL__MODE = "color_material__mode";
const char* NAME_ELEMENT_COLOR_TARGET = "color_target";
const char* NAME_ELEMENT_COLOR____TARGETABLE_FLOAT3_TYPE = "color____targetable_float3_type";
const char* NAME_ELEMENT_COMMENTS = "comments";
const char* NAME_ELEMENT_COMPILER = "compiler";
const char* NAME_ELEMENT_COMPLEXES = "complexes";
const char* NAME_ELEMENT_COMPOSE = "compose";
const char* NAME_ELEMENT_CONDITION = "condition";
const char* NAME_ELEMENT_CONE = "cone";
const char* NAME_ELEMENT_CONJUGATE = "conjugate";
const char* NAME_ELEMENT_CONNECT_PARAM = "connect_param";
const char* NAME_ELEMENT_CONSTANT = "constant";
const char* NAME_ELEMENT_CONSTANT_ATTENUATION = "constant_attenuation";
const char* NAME_ELEMENT_CONSTANT____GLES_TEXTURE_CONSTANT_TYPE = "constant____gles_texture_constant_type";
const char* NAME_ELEMENT_CONTRIBUTOR = "contributor";
const char* NAME_ELEMENT_CONTROLLER = "controller";
const char* NAME_ELEMENT_CONTROL_VERTICES = "control_vertices";
const char* NAME_ELEMENT_CONVEX_MESH = "convex_mesh";
const char* NAME_ELEMENT_COPYRIGHT = "copyright";
const char* NAME_ELEMENT_COS = "cos";
const char* NAME_ELEMENT_COSH = "cosh";
const char* NAME_ELEMENT_COT = "cot";
const char* NAME_ELEMENT_COTH = "coth";
const char* NAME_ELEMENT_COVERAGE = "coverage";
const char* NAME_ELEMENT_CREATED = "created";
const char* NAME_ELEMENT_CREATE_2D = "create_2d";
const char* NAME_ELEMENT_CREATE_2D__ARRAY = "create_2d__array";
const char* NAME_ELEMENT_CREATE_2D__FORMAT = "create_2d__format";
const char* NAME_ELEMENT_CREATE_2D__FORMAT__HINT = "create_2d__format__hint";
const char* NAME_ELEMENT_CREATE_2D__INIT_FROM = "create_2d__init_from";
const char* NAME_ELEMENT_CREATE_3D = "create_3d";
const char* NAME_ELEMENT_CREATE_3D__ARRAY = "create_3d__array";
const char* NAME_ELEMENT_CREATE_3D__FORMAT = "create_3d__format";
const char* NAME_ELEMENT_CREATE_3D__FORMAT__HINT = "create_3d__format__hint";
const char* NAME_ELEMENT_CREATE_3D__INIT_FROM = "create_3d__init_from";
const char* NAME_ELEMENT_CREATE_3D__SIZE = "create_3d__size";
const char* NAME_ELEMENT_CREATE_CUBE = "create_cube";
const char* NAME_ELEMENT_CREATE_CUBE__ARRAY = "create_cube__array";
const char* NAME_ELEMENT_CREATE_CUBE__FORMAT = "create_cube__format";
const char* NAME_ELEMENT_CREATE_CUBE__FORMAT__HINT = "create_cube__format__hint";
const char* NAME_ELEMENT_CREATE_CUBE__INIT_FROM = "create_cube__init_from";
const char* NAME_ELEMENT_CREATE_CUBE__SIZE = "create_cube__size";
const char* NAME_ELEMENT_CSC = "csc";
const char* NAME_ELEMENT_CSCH = "csch";
const char* NAME_ELEMENT_CSYMBOL = "csymbol";
const char* NAME_ELEMENT_CULL_FACE = "cull_face";
const char* NAME_ELEMENT_CULL_FACE_ENABLE = "cull_face_enable";
const char* NAME_ELEMENT_CURL = "curl";
const char* NAME_ELEMENT_CURVE = "curve";
const char* NAME_ELEMENT_CURVES = "curves";
const char* NAME_ELEMENT_CYLINDER = "cylinder";
const char* NAME_ELEMENT_CYLINDER____CYLINDER_TYPE = "cylinder____cylinder_type";
const char* NAME_ELEMENT_DAMPING = "damping";
const char* NAME_ELEMENT_DECELERATION = "deceleration";
const char* NAME_ELEMENT_DECELERATION____COMMON_FLOAT2_OR_PARAM_TYPE = "deceleration____common_float2_or_param_type";
const char* NAME_ELEMENT_DECELERATION____COMMON_FLOAT_OR_PARAM_TYPE = "deceleration____common_float_or_param_type";
const char* NAME_ELEMENT_DECLARE = "declare";
const char* NAME_ELEMENT_DEGREE = NAME_ATTRIBUTE_DEGREE;
const char* NAME_ELEMENT_DENSITY = "density";
const char* NAME_ELEMENT_DEPTH_BOUNDS = "depth_bounds";
const char* NAME_ELEMENT_DEPTH_BOUNDS_ENABLE = "depth_bounds_enable";
const char* NAME_ELEMENT_DEPTH_CLAMP_ENABLE = "depth_clamp_enable";
const char* NAME_ELEMENT_DEPTH_CLEAR = "depth_clear";
const char* NAME_ELEMENT_DEPTH_FUNC = "depth_func";
const char* NAME_ELEMENT_DEPTH_MASK = "depth_mask";
const char* NAME_ELEMENT_DEPTH_RANGE = "depth_range";
const char* NAME_ELEMENT_DEPTH_TARGET = "depth_target";
const char* NAME_ELEMENT_DEPTH_TEST_ENABLE = "depth_test_enable";
const char* NAME_ELEMENT_DEST = "dest";
const char* NAME_ELEMENT_DEST_ALPHA = "dest_alpha";
const char* NAME_ELEMENT_DEST_RGB = "dest_rgb";
const char* NAME_ELEMENT_DETERMINANT = "determinant";
const char* NAME_ELEMENT_DIFF = "diff";
const char* NAME_ELEMENT_DIFFUSE = "diffuse";
const char* NAME_ELEMENT_DIRECTION = "direction";
const char* NAME_ELEMENT_DIRECTIONAL = "directional";
const char* NAME_ELEMENT_DITHER_ENABLE = "dither_enable";
const char* NAME_ELEMENT_DIVERGENCE = "divergence";
const char* NAME_ELEMENT_DIVIDE = "divide";
const char* NAME_ELEMENT_DOMAIN = "domain";
const char* NAME_ELEMENT_DOMAINOFAPPLICATION = "domainofapplication";
const char* NAME_ELEMENT_DRAW = "draw";
const char* NAME_ELEMENT_DYNAMIC = "dynamic";
const char* NAME_ELEMENT_DYNAMIC_FRICTION = "dynamic_friction";
const char* NAME_ELEMENT_EDGES = "edges";
const char* NAME_ELEMENT_EFFECT = "effect";
const char* NAME_ELEMENT_EFFECTOR_INFO = "effector_info";
const char* NAME_ELEMENT_ELLIPSE = "ellipse";
const char* NAME_ELEMENT_EMISSION = "emission";
const char* NAME_ELEMENT_EMPTYSET = "emptyset";
const char* NAME_ELEMENT_ENABLED = "enabled";
const char* NAME_ELEMENT_ENUM = "enum";
const char* NAME_ELEMENT_ENUM____GLES_ENUMERATION_TYPE = "enum____gles_enumeration_type";
const char* NAME_ELEMENT_ENUM____GL_ENUMERATION_TYPE = "enum____gl_enumeration_type";
const char* NAME_ELEMENT_ENUM____STRING = "enum____string";
const char* NAME_ELEMENT_EQ = "eq";
const char* NAME_ELEMENT_EQUATION = "equation";
const char* NAME_ELEMENT_EQUIVALENT = "equivalent";
const char* NAME_ELEMENT_EULERGAMMA = "eulergamma";
const char* NAME_ELEMENT_EVALUATE = "evaluate";
const char* NAME_ELEMENT_EVALUATE_SCENE = "evaluate_scene";
const char* NAME_ELEMENT_EXACT = "exact";
const char* NAME_ELEMENT_EXISTS = "exists";
const char* NAME_ELEMENT_EXP = "exp";
const char* NAME_ELEMENT_EXPONENTIALE = "exponentiale";
const char* NAME_ELEMENT_EXTRA = "extra";
const char* NAME_ELEMENT_FACE = "face";
const char* NAME_ELEMENT_FACES = "faces";
const char* NAME_ELEMENT_FACTORIAL = "factorial";
const char* NAME_ELEMENT_FACTOROF = "factorof";
const char* NAME_ELEMENT_FAIL = "fail";
const char* NAME_ELEMENT_FALLOFF_ANGLE = "falloff_angle";
const char* NAME_ELEMENT_FALLOFF_EXPONENT = "falloff_exponent";
const char* NAME_ELEMENT_FALSE = "false";
const char* NAME_ELEMENT_FIXED = "fixed";
const char* NAME_ELEMENT_FIXED2 = "fixed2";
const char* NAME_ELEMENT_FIXED2X1 = "fixed2x1";
const char* NAME_ELEMENT_FIXED2X2 = "fixed2x2";
const char* NAME_ELEMENT_FIXED2X3 = "fixed2x3";
const char* NAME_ELEMENT_FIXED2X4 = "fixed2x4";
const char* NAME_ELEMENT_FIXED3 = "fixed3";
const char* NAME_ELEMENT_FIXED3X1 = "fixed3x1";
const char* NAME_ELEMENT_FIXED3X2 = "fixed3x2";
const char* NAME_ELEMENT_FIXED3X3 = "fixed3x3";
const char* NAME_ELEMENT_FIXED3X4 = "fixed3x4";
const char* NAME_ELEMENT_FIXED4 = "fixed4";
const char* NAME_ELEMENT_FIXED4X1 = "fixed4x1";
const char* NAME_ELEMENT_FIXED4X2 = "fixed4x2";
const char* NAME_ELEMENT_FIXED4X3 = "fixed4x3";
const char* NAME_ELEMENT_FIXED4X4 = "fixed4x4";
const char* NAME_ELEMENT_FLOAT = "float";
const char* NAME_ELEMENT_FLOAT1X1 = "float1x1";
const char* NAME_ELEMENT_FLOAT1X2 = "float1x2";
const char* NAME_ELEMENT_FLOAT1X3 = "float1x3";
const char* NAME_ELEMENT_FLOAT1X4 = "float1x4";
const char* NAME_ELEMENT_FLOAT2 = "float2";
const char* NAME_ELEMENT_FLOAT2X1 = "float2x1";
const char* NAME_ELEMENT_FLOAT2X2 = "float2x2";
const char* NAME_ELEMENT_FLOAT2X3 = "float2x3";
const char* NAME_ELEMENT_FLOAT2X4 = "float2x4";
const char* NAME_ELEMENT_FLOAT3 = "float3";
const char* NAME_ELEMENT_FLOAT3X1 = "float3x1";
const char* NAME_ELEMENT_FLOAT3X2 = "float3x2";
const char* NAME_ELEMENT_FLOAT3X3 = "float3x3";
const char* NAME_ELEMENT_FLOAT3X4 = "float3x4";
const char* NAME_ELEMENT_FLOAT4 = "float4";
const char* NAME_ELEMENT_FLOAT4X1 = "float4x1";
const char* NAME_ELEMENT_FLOAT4X2 = "float4x2";
const char* NAME_ELEMENT_FLOAT4X3 = "float4x3";
const char* NAME_ELEMENT_FLOAT4X4 = "float4x4";
const char* NAME_ELEMENT_FLOAT_ARRAY = "float_array";
const char* NAME_ELEMENT_FLOAT____FLOAT_TYPE = "float____float_type";
const char* NAME_ELEMENT_FLOOR = "floor";
const char* NAME_ELEMENT_FOCAL = "focal";
const char* NAME_ELEMENT_FOG_COLOR = "fog_color";
const char* NAME_ELEMENT_FOG_COORD_SRC = "fog_coord_src";
const char* NAME_ELEMENT_FOG_DENSITY = "fog_density";
const char* NAME_ELEMENT_FOG_ENABLE = "fog_enable";
const char* NAME_ELEMENT_FOG_END = "fog_end";
const char* NAME_ELEMENT_FOG_MODE = "fog_mode";
const char* NAME_ELEMENT_FOG_START = "fog_start";
const char* NAME_ELEMENT_FORALL = "forall";
const char* NAME_ELEMENT_FORCE_FIELD = "force_field";
const char* NAME_ELEMENT_FORMAT = NAME_ATTRIBUTE_FORMAT;
const char* NAME_ELEMENT_FORMULA = "formula";
const char* NAME_ELEMENT_FRAME_OBJECT = "frame_object";
const char* NAME_ELEMENT_FRAME_ORIGIN = "frame_origin";
const char* NAME_ELEMENT_FRAME_TCP = "frame_tcp";
const char* NAME_ELEMENT_FRAME_TIP = "frame_tip";
const char* NAME_ELEMENT_FRONT = "front";
const char* NAME_ELEMENT_FRONT_FACE = "front_face";
const char* NAME_ELEMENT_FUNC = "func";
const char* NAME_ELEMENT_FX_COLORTARGET_TYPE____PARAM = "fx_colortarget_type____param";
const char* NAME_ELEMENT_FX_COMMON_COLOR_OR_TEXTURE_TYPE____COLOR = "fx_common_color_or_texture_type____color";
const char* NAME_ELEMENT_FX_COMMON_COLOR_OR_TEXTURE_TYPE____PARAM = "fx_common_color_or_texture_type____param";
const char* NAME_ELEMENT_FX_COMMON_FLOAT_OR_PARAM_TYPE____FLOAT = "fx_common_float_or_param_type____float";
const char* NAME_ELEMENT_FX_COMMON_FLOAT_OR_PARAM_TYPE____PARAM = "fx_common_float_or_param_type____param";
const char* NAME_ELEMENT_GCD = "gcd";
const char* NAME_ELEMENT_GEOGRAPHIC_LOCATION = "geographic_location";
const char* NAME_ELEMENT_GEOMETRY = "geometry";
const char* NAME_ELEMENT_GEQ = "geq";
const char* NAME_ELEMENT_GLES2_PASS_TYPE____EVALUATE = "gles2_pass_type____evaluate";
const char* NAME_ELEMENT_GLES2_PASS_TYPE____STATES = "gles2_pass_type____states";
const char* NAME_ELEMENT_GLES2_PROGRAM_TYPE____BIND_ATTRIBUTE = "gles2_program_type____bind_attribute";
const char* NAME_ELEMENT_GLES2_PROGRAM_TYPE____BIND_UNIFORM = "gles2_program_type____bind_uniform";
const char* NAME_ELEMENT_GLES2_SHADER_TYPE____SOURCES = "gles2_shader_type____sources";
const char* NAME_ELEMENT_GLSL_PROGRAM_TYPE____BIND_ATTRIBUTE = "glsl_program_type____bind_attribute";
const char* NAME_ELEMENT_GLSL_PROGRAM_TYPE____BIND_UNIFORM = "glsl_program_type____bind_uniform";
const char* NAME_ELEMENT_GRAD = "grad";
const char* NAME_ELEMENT_GRAVITY = "gravity";
const char* NAME_ELEMENT_GT = "gt";
const char* NAME_ELEMENT_H = "h";
const char* NAME_ELEMENT_HALF = "half";
const char* NAME_ELEMENT_HALF2 = "half2";
const char* NAME_ELEMENT_HALF2X1 = "half2x1";
const char* NAME_ELEMENT_HALF2X2 = "half2x2";
const char* NAME_ELEMENT_HALF2X3 = "half2x3";
const char* NAME_ELEMENT_HALF2X4 = "half2x4";
const char* NAME_ELEMENT_HALF3 = "half3";
const char* NAME_ELEMENT_HALF3X1 = "half3x1";
const char* NAME_ELEMENT_HALF3X2 = "half3x2";
const char* NAME_ELEMENT_HALF3X3 = "half3x3";
const char* NAME_ELEMENT_HALF3X4 = "half3x4";
const char* NAME_ELEMENT_HALF4 = "half4";
const char* NAME_ELEMENT_HALF4X1 = "half4x1";
const char* NAME_ELEMENT_HALF4X2 = "half4x2";
const char* NAME_ELEMENT_HALF4X3 = "half4x3";
const char* NAME_ELEMENT_HALF4X4 = "half4x4";
const char* NAME_ELEMENT_HALF_EXTENTS = "half_extents";
const char* NAME_ELEMENT_HEIGHT = NAME_ATTRIBUTE_HEIGHT;
const char* NAME_ELEMENT_HEX = "hex";
const char* NAME_ELEMENT_HINT = "hint";
const char* NAME_ELEMENT_HOLLOW = "hollow";
const char* NAME_ELEMENT_HYPERBOLA = "hyperbola";
const char* NAME_ELEMENT_IDENT = "ident";
const char* NAME_ELEMENT_IDREF_ARRAY = "IDREF_array";
const char* NAME_ELEMENT_IMAGE = "image";
const char* NAME_ELEMENT_IMAGER = "imager";
const char* NAME_ELEMENT_IMAGE_TYPE____INIT_FROM = "image_type____init_from";
const char* NAME_ELEMENT_IMAGE____FUNCTIONS_TYPE = "image____Functions_type";
const char* NAME_ELEMENT_IMAGE____IMAGE_TYPE = "image____image_type";
const char* NAME_ELEMENT_IMAGINARY = "imaginary";
const char* NAME_ELEMENT_IMAGINARYI = "imaginaryi";
const char* NAME_ELEMENT_IMPLIES = "implies";
const char* NAME_ELEMENT_IMPORT = "import";
const char* NAME_ELEMENT_IN = "in";
const char* NAME_ELEMENT_INCLUDE = "include";
const char* NAME_ELEMENT_INDEX = NAME_ATTRIBUTE_INDEX;
const char* NAME_ELEMENT_INDEX_OF_REFRACTION = "index_of_refraction";
const char* NAME_ELEMENT_INERTIA = "inertia";
const char* NAME_ELEMENT_INFINITY = "infinity";
const char* NAME_ELEMENT_INIT_FROM = "init_from";
const char* NAME_ELEMENT_INLINE = "inline";
const char* NAME_ELEMENT_INPUT = "input";
const char* NAME_ELEMENT_INPUT____INPUT_LOCAL_OFFSET_TYPE = "input____input_local_offset_type";
const char* NAME_ELEMENT_INPUT____INPUT_LOCAL_TYPE = "input____input_local_type";
const char* NAME_ELEMENT_INSTANCE_ANIMATION = "instance_animation";
const char* NAME_ELEMENT_INSTANCE_ARTICULATED_SYSTEM = "instance_articulated_system";
const char* NAME_ELEMENT_INSTANCE_CAMERA = "instance_camera";
const char* NAME_ELEMENT_INSTANCE_CONTROLLER = "instance_controller";
const char* NAME_ELEMENT_INSTANCE_EFFECT = "instance_effect";
const char* NAME_ELEMENT_INSTANCE_EFFECT_TYPE____SETPARAM = "instance_effect_type____setparam";
const char* NAME_ELEMENT_INSTANCE_FORCE_FIELD = "instance_force_field";
const char* NAME_ELEMENT_INSTANCE_FORMULA = "instance_formula";
const char* NAME_ELEMENT_INSTANCE_GEOMETRY = "instance_geometry";
const char* NAME_ELEMENT_INSTANCE_IMAGE = "instance_image";
const char* NAME_ELEMENT_INSTANCE_JOINT = "instance_joint";
const char* NAME_ELEMENT_INSTANCE_KINEMATICS_MODEL = "instance_kinematics_model";
const char* NAME_ELEMENT_INSTANCE_KINEMATICS_SCENE = "instance_kinematics_scene";
const char* NAME_ELEMENT_INSTANCE_LIGHT = "instance_light";
const char* NAME_ELEMENT_INSTANCE_MATERIAL = "instance_material";
const char* NAME_ELEMENT_INSTANCE_MATERIAL_TYPE____BIND = "instance_material_type____bind";
const char* NAME_ELEMENT_INSTANCE_MATERIAL____INSTANCE_MATERIAL_TYPE = "instance_material____instance_material_type";
const char* NAME_ELEMENT_INSTANCE_NODE = "instance_node";
const char* NAME_ELEMENT_INSTANCE_PHYSICS_MATERIAL = "instance_physics_material";
const char* NAME_ELEMENT_INSTANCE_PHYSICS_MODEL = "instance_physics_model";
const char* NAME_ELEMENT_INSTANCE_PHYSICS_SCENE = "instance_physics_scene";
const char* NAME_ELEMENT_INSTANCE_RIGID_BODY = "instance_rigid_body";
const char* NAME_ELEMENT_INSTANCE_RIGID_BODY_TYPE____TECHNIQUE_COMMON = "instance_rigid_body_type____technique_common";
const char* NAME_ELEMENT_INSTANCE_RIGID_BODY__TECHNIQUE_COMMON__DYNAMIC = "instance_rigid_body__technique_common__dynamic";
const char* NAME_ELEMENT_INSTANCE_RIGID_BODY__TECHNIQUE_COMMON__MASS_FRAME = "instance_rigid_body__technique_common__mass_frame";
const char* NAME_ELEMENT_INSTANCE_RIGID_BODY__TECHNIQUE_COMMON__SHAPE = "instance_rigid_body__technique_common__shape";
const char* NAME_ELEMENT_INSTANCE_RIGID_BODY__TECHNIQUE_COMMON__SHAPE__HOLLOW = "instance_rigid_body__technique_common__shape__hollow";
const char* NAME_ELEMENT_INSTANCE_RIGID_CONSTRAINT = "instance_rigid_constraint";
const char* NAME_ELEMENT_INSTANCE_VISUAL_SCENE = "instance_visual_scene";
const char* NAME_ELEMENT_INT = "int";
const char* NAME_ELEMENT_INT2 = "int2";
const char* NAME_ELEMENT_INT2X1 = "int2x1";
const char* NAME_ELEMENT_INT2X2 = "int2x2";
const char* NAME_ELEMENT_INT2X3 = "int2x3";
const char* NAME_ELEMENT_INT2X4 = "int2x4";
const char* NAME_ELEMENT_INT3 = "int3";
const char* NAME_ELEMENT_INT3X1 = "int3x1";
const char* NAME_ELEMENT_INT3X2 = "int3x2";
const char* NAME_ELEMENT_INT3X3 = "int3x3";
const char* NAME_ELEMENT_INT3X4 = "int3x4";
const char* NAME_ELEMENT_INT4 = "int4";
const char* NAME_ELEMENT_INT4X1 = "int4x1";
const char* NAME_ELEMENT_INT4X2 = "int4x2";
const char* NAME_ELEMENT_INT4X3 = "int4x3";
const char* NAME_ELEMENT_INT4X4 = "int4x4";
const char* NAME_ELEMENT_INTEGERS = "integers";
const char* NAME_ELEMENT_INTERPENETRATE = "interpenetrate";
const char* NAME_ELEMENT_INTERSECT = "intersect";
const char* NAME_ELEMENT_INTERVAL = "interval";
const char* NAME_ELEMENT_INT_ARRAY = "int_array";
const char* NAME_ELEMENT_INT____INT_TYPE = "int____int_type";
const char* NAME_ELEMENT_INT____INT_TYPE____MATHML = "int____int_type____mathml";
const char* NAME_ELEMENT_INVERSE = "inverse";
const char* NAME_ELEMENT_INVERT = "invert";
const char* NAME_ELEMENT_IVEC2 = "ivec2";
const char* NAME_ELEMENT_IVEC3 = "ivec3";
const char* NAME_ELEMENT_IVEC4 = "ivec4";
const char* NAME_ELEMENT_JERK = "jerk";
const char* NAME_ELEMENT_JERK____COMMON_FLOAT2_OR_PARAM_TYPE = "jerk____common_float2_or_param_type";
const char* NAME_ELEMENT_JERK____COMMON_FLOAT_OR_PARAM_TYPE = "jerk____common_float_or_param_type";
const char* NAME_ELEMENT_JOINT = "joint";
const char* NAME_ELEMENT_JOINTS = "joints";
const char* NAME_ELEMENT_KEYWORDS = "keywords";
const char* NAME_ELEMENT_KINEMATICS = "kinematics";
const char* NAME_ELEMENT_KINEMATICS_MODEL = "kinematics_model";
const char* NAME_ELEMENT_KINEMATICS_SCENE = "kinematics_scene";
const char* NAME_ELEMENT_LAMBDA = "lambda";
const char* NAME_ELEMENT_LAMBERT = "lambert";
const char* NAME_ELEMENT_LAPLACIAN = "laplacian";
const char* NAME_ELEMENT_LATITUDE = "latitude";
const char* NAME_ELEMENT_LAYER = NAME_ATTRIBUTE_LAYER;
const char* NAME_ELEMENT_LCM = "lcm";
const char* NAME_ELEMENT_LEQ = "leq";
const char* NAME_ELEMENT_LIBRARY_ANIMATIONS = "library_animations";
const char* NAME_ELEMENT_LIBRARY_ANIMATION_CLIPS = "library_animation_clips";
const char* NAME_ELEMENT_LIBRARY_ARTICULATED_SYSTEMS = "library_articulated_systems";
const char* NAME_ELEMENT_LIBRARY_CAMERAS = "library_cameras";
const char* NAME_ELEMENT_LIBRARY_CONTROLLERS = "library_controllers";
const char* NAME_ELEMENT_LIBRARY_EFFECTS = "library_effects";
const char* NAME_ELEMENT_LIBRARY_FORCE_FIELDS = "library_force_fields";
const char* NAME_ELEMENT_LIBRARY_FORMULAS = "library_formulas";
const char* NAME_ELEMENT_LIBRARY_GEOMETRIES = "library_geometries";
const char* NAME_ELEMENT_LIBRARY_IMAGES = "library_images";
const char* NAME_ELEMENT_LIBRARY_IMAGES__IMAGE__INIT_FROM__HEX = "library_images__image__init_from__hex";
const char* NAME_ELEMENT_LIBRARY_JOINTS = "library_joints";
const char* NAME_ELEMENT_LIBRARY_KINEMATICS_MODELS = "library_kinematics_models";
const char* NAME_ELEMENT_LIBRARY_KINEMATICS_SCENES = "library_kinematics_scenes";
const char* NAME_ELEMENT_LIBRARY_LIGHTS = "library_lights";
const char* NAME_ELEMENT_LIBRARY_MATERIALS = "library_materials";
const char* NAME_ELEMENT_LIBRARY_NODES = "library_nodes";
const char* NAME_ELEMENT_LIBRARY_PHYSICS_MATERIALS = "library_physics_materials";
const char* NAME_ELEMENT_LIBRARY_PHYSICS_MODELS = "library_physics_models";
const char* NAME_ELEMENT_LIBRARY_PHYSICS_SCENES = "library_physics_scenes";
const char* NAME_ELEMENT_LIBRARY_VISUAL_SCENES = "library_visual_scenes";
const char* NAME_ELEMENT_LIGHT = "light";
const char* NAME_ELEMENT_LIGHTING_ENABLE = "lighting_enable";
const char* NAME_ELEMENT_LIGHT_AMBIENT = "light_ambient";
const char* NAME_ELEMENT_LIGHT_CONSTANT_ATTENUATION = "light_constant_attenuation";
const char* NAME_ELEMENT_LIGHT_DIFFUSE = "light_diffuse";
const char* NAME_ELEMENT_LIGHT_ENABLE = "light_enable";
const char* NAME_ELEMENT_LIGHT_LINEAR_ATTENUATION = "light_linear_attenuation";
const char* NAME_ELEMENT_LIGHT_MODEL_AMBIENT = "light_model_ambient";
const char* NAME_ELEMENT_LIGHT_MODEL_COLOR_CONTROL = "light_model_color_control";
const char* NAME_ELEMENT_LIGHT_MODEL_LOCAL_VIEWER_ENABLE = "light_model_local_viewer_enable";
const char* NAME_ELEMENT_LIGHT_MODEL_TWO_SIDE_ENABLE = "light_model_two_side_enable";
const char* NAME_ELEMENT_LIGHT_POSITION = "light_position";
const char* NAME_ELEMENT_LIGHT_QUADRATIC_ATTENUATION = "light_quadratic_attenuation";
const char* NAME_ELEMENT_LIGHT_SPECULAR = "light_specular";
const char* NAME_ELEMENT_LIGHT_SPOT_CUTOFF = "light_spot_cutoff";
const char* NAME_ELEMENT_LIGHT_SPOT_DIRECTION = "light_spot_direction";
const char* NAME_ELEMENT_LIGHT_SPOT_EXPONENT = "light_spot_exponent";
const char* NAME_ELEMENT_LIGHT_TYPE____TECHNIQUE_COMMON = "light_type____technique_common";
const char* NAME_ELEMENT_LIGHT__TECHNIQUE_COMMON__AMBIENT = "light__technique_common__ambient";
const char* NAME_ELEMENT_LIMIT = "limit";
const char* NAME_ELEMENT_LIMITS = "limits";
const char* NAME_ELEMENT_LIMITS____JOINT_LIMITS_TYPE = "limits____joint_limits_type";
const char* NAME_ELEMENT_LIMITS____KINEMATICS_LIMITS_TYPE = "limits____kinematics_limits_type";
const char* NAME_ELEMENT_LINE = "line";
const char* NAME_ELEMENT_LINEAR = "linear";
const char* NAME_ELEMENT_LINEAR_ATTENUATION = "linear_attenuation";
const char* NAME_ELEMENT_LINES = "lines";
const char* NAME_ELEMENT_LINESTRIPS = "linestrips";
const char* NAME_ELEMENT_LINE_SMOOTH_ENABLE = "line_smooth_enable";
const char* NAME_ELEMENT_LINE_STIPPLE = "line_stipple";
const char* NAME_ELEMENT_LINE_STIPPLE_ENABLE = "line_stipple_enable";
const char* NAME_ELEMENT_LINE_WIDTH = "line_width";
const char* NAME_ELEMENT_LINK = "link";
const char* NAME_ELEMENT_LINKER = "linker";
const char* NAME_ELEMENT_LIST = "list";
const char* NAME_ELEMENT_LN = "ln";
const char* NAME_ELEMENT_LOCKED = "locked";
const char* NAME_ELEMENT_LOG = "log";
const char* NAME_ELEMENT_LOGBASE = "logbase";
const char* NAME_ELEMENT_LOGIC_OP = "logic_op";
const char* NAME_ELEMENT_LOGIC_OP_ENABLE = "logic_op_enable";
const char* NAME_ELEMENT_LONGITUDE = "longitude";
const char* NAME_ELEMENT_LOOKAT = "lookat";
const char* NAME_ELEMENT_LOWLIMIT = "lowlimit";
const char* NAME_ELEMENT_LT = "lt";
const char* NAME_ELEMENT_MAGFILTER = "magfilter";
const char* NAME_ELEMENT_MASK = "mask";
const char* NAME_ELEMENT_MASS = "mass";
const char* NAME_ELEMENT_MASS_FRAME = "mass_frame";
const char* NAME_ELEMENT_MAT2 = "mat2";
const char* NAME_ELEMENT_MAT3 = "mat3";
const char* NAME_ELEMENT_MAT4 = "mat4";
const char* NAME_ELEMENT_MATERIAL = NAME_ATTRIBUTE_MATERIAL;
const char* NAME_ELEMENT_MATERIAL_AMBIENT = "material_ambient";
const char* NAME_ELEMENT_MATERIAL_DIFFUSE = "material_diffuse";
const char* NAME_ELEMENT_MATERIAL_EMISSION = "material_emission";
const char* NAME_ELEMENT_MATERIAL_SHININESS = "material_shininess";
const char* NAME_ELEMENT_MATERIAL_SPECULAR = "material_specular";
const char* NAME_ELEMENT_MATH = "math";
const char* NAME_ELEMENT_MATRIX = "matrix";
const char* NAME_ELEMENT_MATRIXROW = "matrixrow";
const char* NAME_ELEMENT_MATRIX____MATRIX_TYPE = "matrix____matrix_type";
const char* NAME_ELEMENT_MATRIX____MATRIX_TYPE____MATHML = "matrix____matrix_type____mathml";
const char* NAME_ELEMENT_MAX = "max";
const char* NAME_ELEMENT_MAX_ANISOTROPY = "max_anisotropy";
const char* NAME_ELEMENT_MAX____ARITH_TYPE = "max____Arith_type";
const char* NAME_ELEMENT_MAX____COMMON_FLOAT_OR_PARAM_TYPE = "max____common_float_or_param_type";
const char* NAME_ELEMENT_MAX____MINMAX_TYPE = "max____minmax_type";
const char* NAME_ELEMENT_MAX____TARGETABLE_FLOAT3_TYPE = "max____targetable_float3_type";
const char* NAME_ELEMENT_MEAN = "mean";
const char* NAME_ELEMENT_MEDIAN = "median";
const char* NAME_ELEMENT_MESH = "mesh";
const char* NAME_ELEMENT_MIN = "min";
const char* NAME_ELEMENT_MINFILTER = "minfilter";
const char* NAME_ELEMENT_MINUS = "minus";
const char* NAME_ELEMENT_MIN____ARITH_TYPE = "min____Arith_type";
const char* NAME_ELEMENT_MIN____COMMON_FLOAT_OR_PARAM_TYPE = "min____common_float_or_param_type";
const char* NAME_ELEMENT_MIN____MINMAX_TYPE = "min____minmax_type";
const char* NAME_ELEMENT_MIN____TARGETABLE_FLOAT3_TYPE = "min____targetable_float3_type";
const char* NAME_ELEMENT_MIPFILTER = "mipfilter";
const char* NAME_ELEMENT_MIPS = "mips";
const char* NAME_ELEMENT_MIP_BIAS = "mip_bias";
const char* NAME_ELEMENT_MIP_MAX_LEVEL = "mip_max_level";
const char* NAME_ELEMENT_MIP_MIN_LEVEL = "mip_min_level";
const char* NAME_ELEMENT_MODE = NAME_ATTRIBUTE_MODE;
const char* NAME_ELEMENT_MODEL_VIEW_MATRIX = "model_view_matrix";
const char* NAME_ELEMENT_MODE____MODE_TYPE = "mode____mode_type";
const char* NAME_ELEMENT_MODIFIED = "modified";
const char* NAME_ELEMENT_MODIFIER = "modifier";
const char* NAME_ELEMENT_MOMENT = "moment";
const char* NAME_ELEMENT_MOMENTABOUT = "momentabout";
const char* NAME_ELEMENT_MORPH = "morph";
const char* NAME_ELEMENT_MOTION = "motion";
const char* NAME_ELEMENT_MULTISAMPLE_ENABLE = "multisample_enable";
const char* NAME_ELEMENT_NAME_ARRAY = "Name_array";
const char* NAME_ELEMENT_NATURALNUMBERS = "naturalnumbers";
const char* NAME_ELEMENT_NEQ = "neq";
const char* NAME_ELEMENT_NEWPARAM = "newparam";
const char* NAME_ELEMENT_NEWPARAM____CG_NEWPARAM_TYPE = "newparam____cg_newparam_type";
const char* NAME_ELEMENT_NEWPARAM____FORMULA_NEWPARAM_TYPE = "newparam____formula_newparam_type";
const char* NAME_ELEMENT_NEWPARAM____FX_COMMON_NEWPARAM_TYPE = "newparam____fx_common_newparam_type";
const char* NAME_ELEMENT_NEWPARAM____FX_NEWPARAM_TYPE = "newparam____fx_newparam_type";
const char* NAME_ELEMENT_NEWPARAM____GLES_NEWPARAM_TYPE = "newparam____gles_newparam_type";
const char* NAME_ELEMENT_NEWPARAM____GLSL_NEWPARAM_TYPE = "newparam____glsl_newparam_type";
const char* NAME_ELEMENT_NEWPARAM____KINEMATICS_NEWPARAM_TYPE = "newparam____kinematics_newparam_type";
const char* NAME_ELEMENT_NODE = "node";
const char* NAME_ELEMENT_NORMALIZE_ENABLE = "normalize_enable";
const char* NAME_ELEMENT_NOT = "not";
const char* NAME_ELEMENT_NOTANUMBER = "notanumber";
const char* NAME_ELEMENT_NOTIN = "notin";
const char* NAME_ELEMENT_NOTPRSUBSET = "notprsubset";
const char* NAME_ELEMENT_NOTSUBSET = "notsubset";
const char* NAME_ELEMENT_NURBS = "nurbs";
const char* NAME_ELEMENT_NURBS_SURFACE = "nurbs_surface";
const char* NAME_ELEMENT_NURBS_SURFACE_TYPE____CONTROL_VERTICES = "nurbs_surface_type____control_vertices";
const char* NAME_ELEMENT_NURBS_TYPE____CONTROL_VERTICES = "nurbs_type____control_vertices";
const char* NAME_ELEMENT_OPTICS = "optics";
const char* NAME_ELEMENT_OPTICS__TECHNIQUE_COMMON = "optics__technique_common";
const char* NAME_ELEMENT_OR = "or";
const char* NAME_ELEMENT_ORIENT = "orient";
const char* NAME_ELEMENT_ORIGIN = "origin";
const char* NAME_ELEMENT_ORIGIN____FLOAT3_TYPE = "origin____float3_type";
const char* NAME_ELEMENT_ORIGIN____ORIGIN_TYPE = "origin____origin_type";
const char* NAME_ELEMENT_ORTHOGRAPHIC = "orthographic";
const char* NAME_ELEMENT_OTHERWISE = "otherwise";
const char* NAME_ELEMENT_OUTERPRODUCT = "outerproduct";
const char* NAME_ELEMENT_P = "p";
const char* NAME_ELEMENT_PARABOLA = "parabola";
const char* NAME_ELEMENT_PARAM = "param";
const char* NAME_ELEMENT_PARAM____COMMON_PARAM_TYPE = "param____common_param_type";
const char* NAME_ELEMENT_PARAM____KINEMATICS_PARAM_TYPE = "param____kinematics_param_type";
const char* NAME_ELEMENT_PARAM____NCNAME = "param____NCName";
const char* NAME_ELEMENT_PARAM____PARAM_TYPE = "param____param_type";
const char* NAME_ELEMENT_PARTIALDIFF = "partialdiff";
const char* NAME_ELEMENT_PASS = "pass";
const char* NAME_ELEMENT_PASS____CG_PASS_TYPE = "pass____cg_pass_type";
const char* NAME_ELEMENT_PASS____GLES2_PASS_TYPE = "pass____gles2_pass_type";
const char* NAME_ELEMENT_PCURVES = "pcurves";
const char* NAME_ELEMENT_PERSPECTIVE = "perspective";
const char* NAME_ELEMENT_PH = "ph";
const char* NAME_ELEMENT_PHONG = "phong";
const char* NAME_ELEMENT_PHYSICS_MATERIAL = "physics_material";
const char* NAME_ELEMENT_PHYSICS_MATERIAL_TYPE____TECHNIQUE_COMMON = "physics_material_type____technique_common";
const char* NAME_ELEMENT_PHYSICS_MODEL = "physics_model";
const char* NAME_ELEMENT_PHYSICS_SCENE = "physics_scene";
const char* NAME_ELEMENT_PHYSICS_SCENE_TYPE____TECHNIQUE_COMMON = "physics_scene_type____technique_common";
const char* NAME_ELEMENT_PI = "pi";
const char* NAME_ELEMENT_PIECE = "piece";
const char* NAME_ELEMENT_PIECEWISE = "piecewise";
const char* NAME_ELEMENT_PLANE = "plane";
const char* NAME_ELEMENT_PLUS = "plus";
const char* NAME_ELEMENT_POINT = "point";
const char* NAME_ELEMENT_POINT_DISTANCE_ATTENUATION = "point_distance_attenuation";
const char* NAME_ELEMENT_POINT_FADE_THRESHOLD_SIZE = "point_fade_threshold_size";
const char* NAME_ELEMENT_POINT_SIZE = "point_size";
const char* NAME_ELEMENT_POINT_SIZE_ENABLE = "point_size_enable";
const char* NAME_ELEMENT_POINT_SIZE_MAX = "point_size_max";
const char* NAME_ELEMENT_POINT_SIZE_MIN = "point_size_min";
const char* NAME_ELEMENT_POINT_SMOOTH_ENABLE = "point_smooth_enable";
const char* NAME_ELEMENT_POLYGONS = "polygons";
const char* NAME_ELEMENT_POLYGON_MODE = "polygon_mode";
const char* NAME_ELEMENT_POLYGON_MODE__FACE = "polygon_mode__face";
const char* NAME_ELEMENT_POLYGON_MODE__MODE = "polygon_mode__mode";
const char* NAME_ELEMENT_POLYGON_OFFSET = "polygon_offset";
const char* NAME_ELEMENT_POLYGON_OFFSET_FILL_ENABLE = "polygon_offset_fill_enable";
const char* NAME_ELEMENT_POLYGON_OFFSET_LINE_ENABLE = "polygon_offset_line_enable";
const char* NAME_ELEMENT_POLYGON_OFFSET_POINT_ENABLE = "polygon_offset_point_enable";
const char* NAME_ELEMENT_POLYGON_SMOOTH_ENABLE = "polygon_smooth_enable";
const char* NAME_ELEMENT_POLYGON_STIPPLE_ENABLE = "polygon_stipple_enable";
const char* NAME_ELEMENT_POLYLIST = "polylist";
const char* NAME_ELEMENT_POWER = "power";
const char* NAME_ELEMENT_PRIMES = "primes";
const char* NAME_ELEMENT_PRISMATIC = "prismatic";
const char* NAME_ELEMENT_PRODUCT = "product";
const char* NAME_ELEMENT_PROFILE_BRIDGE = "profile_BRIDGE";
const char* NAME_ELEMENT_PROFILE_CG = "profile_CG";
const char* NAME_ELEMENT_PROFILE_CG_TYPE____TECHNIQUE = "profile_cg_type____technique";
const char* NAME_ELEMENT_PROFILE_CG__TECHNIQUE__PASS__PROGRAM__SHADER = "profile_CG__technique__pass__program__shader";
const char* NAME_ELEMENT_PROFILE_CG__TECHNIQUE__PASS__PROGRAM__SHADER__BIND_UNIFORM = "profile_CG__technique__pass__program__shader__bind_uniform";
const char* NAME_ELEMENT_PROFILE_CG__TECHNIQUE__PASS__PROGRAM__SHADER__BIND_UNIFORM__PARAM = "profile_CG__technique__pass__program__shader__bind_uniform__param";
const char* NAME_ELEMENT_PROFILE_CG__TECHNIQUE__PASS__PROGRAM__SHADER__SOURCES = "profile_CG__technique__pass__program__shader__sources";
const char* NAME_ELEMENT_PROFILE_COMMON = "profile_COMMON";
const char* NAME_ELEMENT_PROFILE_COMMON_TYPE____TECHNIQUE = "profile_common_type____technique";
const char* NAME_ELEMENT_PROFILE_COMMON__TECHNIQUE__CONSTANT = "profile_COMMON__technique__constant";
const char* NAME_ELEMENT_PROFILE_GLES = "profile_GLES";
const char* NAME_ELEMENT_PROFILE_GLES2 = "profile_GLES2";
const char* NAME_ELEMENT_PROFILE_GLES2_TYPE____NEWPARAM = "profile_gles2_type____newparam";
const char* NAME_ELEMENT_PROFILE_GLES2_TYPE____TECHNIQUE = "profile_gles2_type____technique";
const char* NAME_ELEMENT_PROFILE_GLES2__NEWPARAM__USERTYPE = "profile_GLES2__newparam__usertype";
const char* NAME_ELEMENT_PROFILE_GLES2__NEWPARAM__USERTYPE__SETPARAM = "profile_GLES2__newparam__usertype__setparam";
const char* NAME_ELEMENT_PROFILE_GLES2__NEWPARAM__USERTYPE__SETPARAM__ARRAY = "profile_GLES2__newparam__usertype__setparam__array";
const char* NAME_ELEMENT_PROFILE_GLES2__TECHNIQUE__PASS__PROGRAM__BIND_UNIFORM__PARAM = "profile_GLES2__technique__pass__program__bind_uniform__param";
const char* NAME_ELEMENT_PROFILE_GLES2__TECHNIQUE__PASS__STATES__BLEND_COLOR = "profile_GLES2__technique__pass__states__blend_color";
const char* NAME_ELEMENT_PROFILE_GLES2__TECHNIQUE__PASS__STATES__BLEND_ENABLE = "profile_GLES2__technique__pass__states__blend_enable";
const char* NAME_ELEMENT_PROFILE_GLES2__TECHNIQUE__PASS__STATES__BLEND_EQUATION = "profile_GLES2__technique__pass__states__blend_equation";
const char* NAME_ELEMENT_PROFILE_GLES2__TECHNIQUE__PASS__STATES__BLEND_EQUATION_SEPARATE = "profile_GLES2__technique__pass__states__blend_equation_separate";
const char* NAME_ELEMENT_PROFILE_GLES2__TECHNIQUE__PASS__STATES__BLEND_EQUATION_SEPARATE__ALPHA = "profile_GLES2__technique__pass__states__blend_equation_separate__alpha";
const char* NAME_ELEMENT_PROFILE_GLES2__TECHNIQUE__PASS__STATES__BLEND_EQUATION_SEPARATE__RGB = "profile_GLES2__technique__pass__states__blend_equation_separate__rgb";
const char* NAME_ELEMENT_PROFILE_GLES2__TECHNIQUE__PASS__STATES__BLEND_FUNC = "profile_GLES2__technique__pass__states__blend_func";
const char* NAME_ELEMENT_PROFILE_GLES2__TECHNIQUE__PASS__STATES__BLEND_FUNC_SEPARATE = "profile_GLES2__technique__pass__states__blend_func_separate";
const char* NAME_ELEMENT_PROFILE_GLES2__TECHNIQUE__PASS__STATES__BLEND_FUNC_SEPARATE__DEST_ALPHA = "profile_GLES2__technique__pass__states__blend_func_separate__dest_alpha";
const char* NAME_ELEMENT_PROFILE_GLES2__TECHNIQUE__PASS__STATES__BLEND_FUNC_SEPARATE__DEST_RGB = "profile_GLES2__technique__pass__states__blend_func_separate__dest_rgb";
const char* NAME_ELEMENT_PROFILE_GLES2__TECHNIQUE__PASS__STATES__BLEND_FUNC_SEPARATE__SRC_ALPHA = "profile_GLES2__technique__pass__states__blend_func_separate__src_alpha";
const char* NAME_ELEMENT_PROFILE_GLES2__TECHNIQUE__PASS__STATES__BLEND_FUNC_SEPARATE__SRC_RGB = "profile_GLES2__technique__pass__states__blend_func_separate__src_rgb";
const char* NAME_ELEMENT_PROFILE_GLES2__TECHNIQUE__PASS__STATES__BLEND_FUNC__DEST = "profile_GLES2__technique__pass__states__blend_func__dest";
const char* NAME_ELEMENT_PROFILE_GLES2__TECHNIQUE__PASS__STATES__BLEND_FUNC__SRC = "profile_GLES2__technique__pass__states__blend_func__src";
const char* NAME_ELEMENT_PROFILE_GLES2__TECHNIQUE__PASS__STATES__COLOR_MASK = "profile_GLES2__technique__pass__states__color_mask";
const char* NAME_ELEMENT_PROFILE_GLES2__TECHNIQUE__PASS__STATES__CULL_FACE = "profile_GLES2__technique__pass__states__cull_face";
const char* NAME_ELEMENT_PROFILE_GLES2__TECHNIQUE__PASS__STATES__CULL_FACE_ENABLE = "profile_GLES2__technique__pass__states__cull_face_enable";
const char* NAME_ELEMENT_PROFILE_GLES2__TECHNIQUE__PASS__STATES__DEPTH_FUNC = "profile_GLES2__technique__pass__states__depth_func";
const char* NAME_ELEMENT_PROFILE_GLES2__TECHNIQUE__PASS__STATES__DEPTH_MASK = "profile_GLES2__technique__pass__states__depth_mask";
const char* NAME_ELEMENT_PROFILE_GLES2__TECHNIQUE__PASS__STATES__DEPTH_RANGE = "profile_GLES2__technique__pass__states__depth_range";
const char* NAME_ELEMENT_PROFILE_GLES2__TECHNIQUE__PASS__STATES__DEPTH_TEST_ENABLE = "profile_GLES2__technique__pass__states__depth_test_enable";
const char* NAME_ELEMENT_PROFILE_GLES2__TECHNIQUE__PASS__STATES__DITHER_ENABLE = "profile_GLES2__technique__pass__states__dither_enable";
const char* NAME_ELEMENT_PROFILE_GLES2__TECHNIQUE__PASS__STATES__FRONT_FACE = "profile_GLES2__technique__pass__states__front_face";
const char* NAME_ELEMENT_PROFILE_GLES2__TECHNIQUE__PASS__STATES__LINE_WIDTH = "profile_GLES2__technique__pass__states__line_width";
const char* NAME_ELEMENT_PROFILE_GLES2__TECHNIQUE__PASS__STATES__POINT_SIZE = "profile_GLES2__technique__pass__states__point_size";
const char* NAME_ELEMENT_PROFILE_GLES2__TECHNIQUE__PASS__STATES__POLYGON_OFFSET = "profile_GLES2__technique__pass__states__polygon_offset";
const char* NAME_ELEMENT_PROFILE_GLES2__TECHNIQUE__PASS__STATES__POLYGON_OFFSET_FILL_ENABLE = "profile_GLES2__technique__pass__states__polygon_offset_fill_enable";
const char* NAME_ELEMENT_PROFILE_GLES2__TECHNIQUE__PASS__STATES__SAMPLE_ALPHA_TO_COVERAGE_ENABLE = "profile_GLES2__technique__pass__states__sample_alpha_to_coverage_enable";
const char* NAME_ELEMENT_PROFILE_GLES2__TECHNIQUE__PASS__STATES__SAMPLE_COVERAGE_ENABLE = "profile_GLES2__technique__pass__states__sample_coverage_enable";
const char* NAME_ELEMENT_PROFILE_GLES2__TECHNIQUE__PASS__STATES__SCISSOR = "profile_GLES2__technique__pass__states__scissor";
const char* NAME_ELEMENT_PROFILE_GLES2__TECHNIQUE__PASS__STATES__SCISSOR_TEST_ENABLE = "profile_GLES2__technique__pass__states__scissor_test_enable";
const char* NAME_ELEMENT_PROFILE_GLES2__TECHNIQUE__PASS__STATES__STENCIL_FUNC = "profile_GLES2__technique__pass__states__stencil_func";
const char* NAME_ELEMENT_PROFILE_GLES2__TECHNIQUE__PASS__STATES__STENCIL_FUNC_SEPARATE = "profile_GLES2__technique__pass__states__stencil_func_separate";
const char* NAME_ELEMENT_PROFILE_GLES2__TECHNIQUE__PASS__STATES__STENCIL_FUNC_SEPARATE__BACK = "profile_GLES2__technique__pass__states__stencil_func_separate__back";
const char* NAME_ELEMENT_PROFILE_GLES2__TECHNIQUE__PASS__STATES__STENCIL_FUNC_SEPARATE__FRONT = "profile_GLES2__technique__pass__states__stencil_func_separate__front";
const char* NAME_ELEMENT_PROFILE_GLES2__TECHNIQUE__PASS__STATES__STENCIL_FUNC_SEPARATE__MASK = "profile_GLES2__technique__pass__states__stencil_func_separate__mask";
const char* NAME_ELEMENT_PROFILE_GLES2__TECHNIQUE__PASS__STATES__STENCIL_FUNC_SEPARATE__REF = "profile_GLES2__technique__pass__states__stencil_func_separate__ref";
const char* NAME_ELEMENT_PROFILE_GLES2__TECHNIQUE__PASS__STATES__STENCIL_FUNC__FUNC = "profile_GLES2__technique__pass__states__stencil_func__func";
const char* NAME_ELEMENT_PROFILE_GLES2__TECHNIQUE__PASS__STATES__STENCIL_FUNC__MASK = "profile_GLES2__technique__pass__states__stencil_func__mask";
const char* NAME_ELEMENT_PROFILE_GLES2__TECHNIQUE__PASS__STATES__STENCIL_FUNC__REF = "profile_GLES2__technique__pass__states__stencil_func__ref";
const char* NAME_ELEMENT_PROFILE_GLES2__TECHNIQUE__PASS__STATES__STENCIL_MASK = "profile_GLES2__technique__pass__states__stencil_mask";
const char* NAME_ELEMENT_PROFILE_GLES2__TECHNIQUE__PASS__STATES__STENCIL_MASK_SEPARATE = "profile_GLES2__technique__pass__states__stencil_mask_separate";
const char* NAME_ELEMENT_PROFILE_GLES2__TECHNIQUE__PASS__STATES__STENCIL_MASK_SEPARATE__FACE = "profile_GLES2__technique__pass__states__stencil_mask_separate__face";
const char* NAME_ELEMENT_PROFILE_GLES2__TECHNIQUE__PASS__STATES__STENCIL_MASK_SEPARATE__MASK = "profile_GLES2__technique__pass__states__stencil_mask_separate__mask";
const char* NAME_ELEMENT_PROFILE_GLES2__TECHNIQUE__PASS__STATES__STENCIL_OP = "profile_GLES2__technique__pass__states__stencil_op";
const char* NAME_ELEMENT_PROFILE_GLES2__TECHNIQUE__PASS__STATES__STENCIL_OP_SEPARATE = "profile_GLES2__technique__pass__states__stencil_op_separate";
const char* NAME_ELEMENT_PROFILE_GLES2__TECHNIQUE__PASS__STATES__STENCIL_OP_SEPARATE__FACE = "profile_GLES2__technique__pass__states__stencil_op_separate__face";
const char* NAME_ELEMENT_PROFILE_GLES2__TECHNIQUE__PASS__STATES__STENCIL_OP_SEPARATE__FAIL = "profile_GLES2__technique__pass__states__stencil_op_separate__fail";
const char* NAME_ELEMENT_PROFILE_GLES2__TECHNIQUE__PASS__STATES__STENCIL_OP_SEPARATE__ZFAIL = "profile_GLES2__technique__pass__states__stencil_op_separate__zfail";
const char* NAME_ELEMENT_PROFILE_GLES2__TECHNIQUE__PASS__STATES__STENCIL_OP_SEPARATE__ZPASS = "profile_GLES2__technique__pass__states__stencil_op_separate__zpass";
const char* NAME_ELEMENT_PROFILE_GLES2__TECHNIQUE__PASS__STATES__STENCIL_OP__FAIL = "profile_GLES2__technique__pass__states__stencil_op__fail";
const char* NAME_ELEMENT_PROFILE_GLES2__TECHNIQUE__PASS__STATES__STENCIL_OP__ZFAIL = "profile_GLES2__technique__pass__states__stencil_op__zfail";
const char* NAME_ELEMENT_PROFILE_GLES2__TECHNIQUE__PASS__STATES__STENCIL_OP__ZPASS = "profile_GLES2__technique__pass__states__stencil_op__zpass";
const char* NAME_ELEMENT_PROFILE_GLES2__TECHNIQUE__PASS__STATES__STENCIL_TEST_ENABLE = "profile_GLES2__technique__pass__states__stencil_test_enable";
const char* NAME_ELEMENT_PROFILE_GLES_TYPE____TECHNIQUE = "profile_gles_type____technique";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS = "profile_GLES__technique__pass";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__EVALUATE = "profile_GLES__technique__pass__evaluate";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES = "profile_GLES__technique__pass__states";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__ALPHA_FUNC = "profile_GLES__technique__pass__states__alpha_func";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__ALPHA_FUNC__FUNC = "profile_GLES__technique__pass__states__alpha_func__func";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__ALPHA_FUNC__VALUE = "profile_GLES__technique__pass__states__alpha_func__value";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__ALPHA_TEST_ENABLE = "profile_GLES__technique__pass__states__alpha_test_enable";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__BLEND_ENABLE = "profile_GLES__technique__pass__states__blend_enable";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__BLEND_FUNC = "profile_GLES__technique__pass__states__blend_func";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__BLEND_FUNC__DEST = "profile_GLES__technique__pass__states__blend_func__dest";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__BLEND_FUNC__SRC = "profile_GLES__technique__pass__states__blend_func__src";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__CLIP_PLANE = "profile_GLES__technique__pass__states__clip_plane";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__CLIP_PLANE_ENABLE = "profile_GLES__technique__pass__states__clip_plane_enable";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__COLOR_LOGIC_OP_ENABLE = "profile_GLES__technique__pass__states__color_logic_op_enable";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__COLOR_MASK = "profile_GLES__technique__pass__states__color_mask";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__COLOR_MATERIAL_ENABLE = "profile_GLES__technique__pass__states__color_material_enable";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__CULL_FACE = "profile_GLES__technique__pass__states__cull_face";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__CULL_FACE_ENABLE = "profile_GLES__technique__pass__states__cull_face_enable";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__DEPTH_FUNC = "profile_GLES__technique__pass__states__depth_func";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__DEPTH_MASK = "profile_GLES__technique__pass__states__depth_mask";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__DEPTH_RANGE = "profile_GLES__technique__pass__states__depth_range";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__DEPTH_TEST_ENABLE = "profile_GLES__technique__pass__states__depth_test_enable";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__DITHER_ENABLE = "profile_GLES__technique__pass__states__dither_enable";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__FOG_COLOR = "profile_GLES__technique__pass__states__fog_color";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__FOG_DENSITY = "profile_GLES__technique__pass__states__fog_density";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__FOG_ENABLE = "profile_GLES__technique__pass__states__fog_enable";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__FOG_END = "profile_GLES__technique__pass__states__fog_end";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__FOG_MODE = "profile_GLES__technique__pass__states__fog_mode";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__FOG_START = "profile_GLES__technique__pass__states__fog_start";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__FRONT_FACE = "profile_GLES__technique__pass__states__front_face";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__LIGHTING_ENABLE = "profile_GLES__technique__pass__states__lighting_enable";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__LIGHT_AMBIENT = "profile_GLES__technique__pass__states__light_ambient";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__LIGHT_CONSTANT_ATTENUATION = "profile_GLES__technique__pass__states__light_constant_attenuation";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__LIGHT_DIFFUSE = "profile_GLES__technique__pass__states__light_diffuse";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__LIGHT_ENABLE = "profile_GLES__technique__pass__states__light_enable";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__LIGHT_LINEAR_ATTENUATION = "profile_GLES__technique__pass__states__light_linear_attenuation";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__LIGHT_MODEL_AMBIENT = "profile_GLES__technique__pass__states__light_model_ambient";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__LIGHT_MODEL_TWO_SIDE_ENABLE = "profile_GLES__technique__pass__states__light_model_two_side_enable";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__LIGHT_POSITION = "profile_GLES__technique__pass__states__light_position";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__LIGHT_QUADRATIC_ATTENUATION = "profile_GLES__technique__pass__states__light_quadratic_attenuation";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__LIGHT_SPECULAR = "profile_GLES__technique__pass__states__light_specular";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__LIGHT_SPOT_CUTOFF = "profile_GLES__technique__pass__states__light_spot_cutoff";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__LIGHT_SPOT_DIRECTION = "profile_GLES__technique__pass__states__light_spot_direction";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__LIGHT_SPOT_EXPONENT = "profile_GLES__technique__pass__states__light_spot_exponent";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__LINE_SMOOTH_ENABLE = "profile_GLES__technique__pass__states__line_smooth_enable";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__LINE_WIDTH = "profile_GLES__technique__pass__states__line_width";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__LOGIC_OP = "profile_GLES__technique__pass__states__logic_op";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__MATERIAL_AMBIENT = "profile_GLES__technique__pass__states__material_ambient";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__MATERIAL_DIFFUSE = "profile_GLES__technique__pass__states__material_diffuse";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__MATERIAL_EMISSION = "profile_GLES__technique__pass__states__material_emission";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__MATERIAL_SHININESS = "profile_GLES__technique__pass__states__material_shininess";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__MATERIAL_SPECULAR = "profile_GLES__technique__pass__states__material_specular";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__MODEL_VIEW_MATRIX = "profile_GLES__technique__pass__states__model_view_matrix";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__MULTISAMPLE_ENABLE = "profile_GLES__technique__pass__states__multisample_enable";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__NORMALIZE_ENABLE = "profile_GLES__technique__pass__states__normalize_enable";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__POINT_DISTANCE_ATTENUATION = "profile_GLES__technique__pass__states__point_distance_attenuation";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__POINT_FADE_THRESHOLD_SIZE = "profile_GLES__technique__pass__states__point_fade_threshold_size";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__POINT_SIZE = "profile_GLES__technique__pass__states__point_size";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__POINT_SIZE_MAX = "profile_GLES__technique__pass__states__point_size_max";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__POINT_SIZE_MIN = "profile_GLES__technique__pass__states__point_size_min";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__POINT_SMOOTH_ENABLE = "profile_GLES__technique__pass__states__point_smooth_enable";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__POLYGON_OFFSET = "profile_GLES__technique__pass__states__polygon_offset";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__POLYGON_OFFSET_FILL_ENABLE = "profile_GLES__technique__pass__states__polygon_offset_fill_enable";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__PROJECTION_MATRIX = "profile_GLES__technique__pass__states__projection_matrix";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__RESCALE_NORMAL_ENABLE = "profile_GLES__technique__pass__states__rescale_normal_enable";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__SAMPLE_ALPHA_TO_COVERAGE_ENABLE = "profile_GLES__technique__pass__states__sample_alpha_to_coverage_enable";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__SAMPLE_ALPHA_TO_ONE_ENABLE = "profile_GLES__technique__pass__states__sample_alpha_to_one_enable";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__SAMPLE_COVERAGE_ENABLE = "profile_GLES__technique__pass__states__sample_coverage_enable";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__SCISSOR = "profile_GLES__technique__pass__states__scissor";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__SCISSOR_TEST_ENABLE = "profile_GLES__technique__pass__states__scissor_test_enable";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__SHADE_MODEL = "profile_GLES__technique__pass__states__shade_model";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__STENCIL_FUNC = "profile_GLES__technique__pass__states__stencil_func";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__STENCIL_FUNC__FUNC = "profile_GLES__technique__pass__states__stencil_func__func";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__STENCIL_FUNC__MASK = "profile_GLES__technique__pass__states__stencil_func__mask";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__STENCIL_FUNC__REF = "profile_GLES__technique__pass__states__stencil_func__ref";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__STENCIL_MASK = "profile_GLES__technique__pass__states__stencil_mask";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__STENCIL_OP = "profile_GLES__technique__pass__states__stencil_op";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__STENCIL_OP__FAIL = "profile_GLES__technique__pass__states__stencil_op__fail";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__STENCIL_OP__ZFAIL = "profile_GLES__technique__pass__states__stencil_op__zfail";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__STENCIL_OP__ZPASS = "profile_GLES__technique__pass__states__stencil_op__zpass";
const char* NAME_ELEMENT_PROFILE_GLES__TECHNIQUE__PASS__STATES__STENCIL_TEST_ENABLE = "profile_GLES__technique__pass__states__stencil_test_enable";
const char* NAME_ELEMENT_PROFILE_GLSL = "profile_GLSL";
const char* NAME_ELEMENT_PROFILE_GLSL_TYPE____TECHNIQUE = "profile_glsl_type____technique";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS = "profile_GLSL__technique__pass";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__EVALUATE = "profile_GLSL__technique__pass__evaluate";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__PROGRAM__BIND_UNIFORM__PARAM = "profile_GLSL__technique__pass__program__bind_uniform__param";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES = "profile_GLSL__technique__pass__states";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__ALPHA_FUNC = "profile_GLSL__technique__pass__states__alpha_func";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__ALPHA_FUNC__FUNC = "profile_GLSL__technique__pass__states__alpha_func__func";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__ALPHA_FUNC__VALUE = "profile_GLSL__technique__pass__states__alpha_func__value";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__ALPHA_TEST_ENABLE = "profile_GLSL__technique__pass__states__alpha_test_enable";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__BLEND_COLOR = "profile_GLSL__technique__pass__states__blend_color";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__BLEND_ENABLE = "profile_GLSL__technique__pass__states__blend_enable";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__BLEND_EQUATION = "profile_GLSL__technique__pass__states__blend_equation";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__BLEND_EQUATION_SEPARATE = "profile_GLSL__technique__pass__states__blend_equation_separate";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__BLEND_EQUATION_SEPARATE__ALPHA = "profile_GLSL__technique__pass__states__blend_equation_separate__alpha";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__BLEND_EQUATION_SEPARATE__RGB = "profile_GLSL__technique__pass__states__blend_equation_separate__rgb";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__BLEND_FUNC = "profile_GLSL__technique__pass__states__blend_func";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__BLEND_FUNC_SEPARATE = "profile_GLSL__technique__pass__states__blend_func_separate";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__BLEND_FUNC_SEPARATE__DEST_ALPHA = "profile_GLSL__technique__pass__states__blend_func_separate__dest_alpha";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__BLEND_FUNC_SEPARATE__DEST_RGB = "profile_GLSL__technique__pass__states__blend_func_separate__dest_rgb";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__BLEND_FUNC_SEPARATE__SRC_ALPHA = "profile_GLSL__technique__pass__states__blend_func_separate__src_alpha";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__BLEND_FUNC_SEPARATE__SRC_RGB = "profile_GLSL__technique__pass__states__blend_func_separate__src_rgb";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__BLEND_FUNC__DEST = "profile_GLSL__technique__pass__states__blend_func__dest";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__BLEND_FUNC__SRC = "profile_GLSL__technique__pass__states__blend_func__src";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__CLIP_PLANE = "profile_GLSL__technique__pass__states__clip_plane";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__CLIP_PLANE_ENABLE = "profile_GLSL__technique__pass__states__clip_plane_enable";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__COLOR_LOGIC_OP_ENABLE = "profile_GLSL__technique__pass__states__color_logic_op_enable";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__COLOR_MASK = "profile_GLSL__technique__pass__states__color_mask";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__COLOR_MATERIAL_ENABLE = "profile_GLSL__technique__pass__states__color_material_enable";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__CULL_FACE = "profile_GLSL__technique__pass__states__cull_face";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__CULL_FACE_ENABLE = "profile_GLSL__technique__pass__states__cull_face_enable";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__DEPTH_FUNC = "profile_GLSL__technique__pass__states__depth_func";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__DEPTH_MASK = "profile_GLSL__technique__pass__states__depth_mask";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__DEPTH_RANGE = "profile_GLSL__technique__pass__states__depth_range";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__DEPTH_TEST_ENABLE = "profile_GLSL__technique__pass__states__depth_test_enable";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__DITHER_ENABLE = "profile_GLSL__technique__pass__states__dither_enable";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__FOG_COLOR = "profile_GLSL__technique__pass__states__fog_color";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__FOG_DENSITY = "profile_GLSL__technique__pass__states__fog_density";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__FOG_ENABLE = "profile_GLSL__technique__pass__states__fog_enable";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__FOG_END = "profile_GLSL__technique__pass__states__fog_end";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__FOG_MODE = "profile_GLSL__technique__pass__states__fog_mode";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__FOG_START = "profile_GLSL__technique__pass__states__fog_start";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__FRONT_FACE = "profile_GLSL__technique__pass__states__front_face";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__LIGHTING_ENABLE = "profile_GLSL__technique__pass__states__lighting_enable";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__LIGHT_AMBIENT = "profile_GLSL__technique__pass__states__light_ambient";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__LIGHT_CONSTANT_ATTENUATION = "profile_GLSL__technique__pass__states__light_constant_attenuation";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__LIGHT_DIFFUSE = "profile_GLSL__technique__pass__states__light_diffuse";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__LIGHT_ENABLE = "profile_GLSL__technique__pass__states__light_enable";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__LIGHT_LINEAR_ATTENUATION = "profile_GLSL__technique__pass__states__light_linear_attenuation";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__LIGHT_MODEL_AMBIENT = "profile_GLSL__technique__pass__states__light_model_ambient";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__LIGHT_MODEL_TWO_SIDE_ENABLE = "profile_GLSL__technique__pass__states__light_model_two_side_enable";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__LIGHT_POSITION = "profile_GLSL__technique__pass__states__light_position";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__LIGHT_QUADRATIC_ATTENUATION = "profile_GLSL__technique__pass__states__light_quadratic_attenuation";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__LIGHT_SPECULAR = "profile_GLSL__technique__pass__states__light_specular";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__LIGHT_SPOT_CUTOFF = "profile_GLSL__technique__pass__states__light_spot_cutoff";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__LIGHT_SPOT_DIRECTION = "profile_GLSL__technique__pass__states__light_spot_direction";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__LIGHT_SPOT_EXPONENT = "profile_GLSL__technique__pass__states__light_spot_exponent";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__LINE_SMOOTH_ENABLE = "profile_GLSL__technique__pass__states__line_smooth_enable";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__LINE_WIDTH = "profile_GLSL__technique__pass__states__line_width";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__LOGIC_OP = "profile_GLSL__technique__pass__states__logic_op";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__MATERIAL_AMBIENT = "profile_GLSL__technique__pass__states__material_ambient";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__MATERIAL_DIFFUSE = "profile_GLSL__technique__pass__states__material_diffuse";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__MATERIAL_EMISSION = "profile_GLSL__technique__pass__states__material_emission";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__MATERIAL_SHININESS = "profile_GLSL__technique__pass__states__material_shininess";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__MATERIAL_SPECULAR = "profile_GLSL__technique__pass__states__material_specular";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__MODEL_VIEW_MATRIX = "profile_GLSL__technique__pass__states__model_view_matrix";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__MULTISAMPLE_ENABLE = "profile_GLSL__technique__pass__states__multisample_enable";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__NORMALIZE_ENABLE = "profile_GLSL__technique__pass__states__normalize_enable";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__POINT_DISTANCE_ATTENUATION = "profile_GLSL__technique__pass__states__point_distance_attenuation";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__POINT_FADE_THRESHOLD_SIZE = "profile_GLSL__technique__pass__states__point_fade_threshold_size";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__POINT_SIZE = "profile_GLSL__technique__pass__states__point_size";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__POINT_SIZE_MAX = "profile_GLSL__technique__pass__states__point_size_max";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__POINT_SIZE_MIN = "profile_GLSL__technique__pass__states__point_size_min";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__POINT_SMOOTH_ENABLE = "profile_GLSL__technique__pass__states__point_smooth_enable";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__POLYGON_OFFSET = "profile_GLSL__technique__pass__states__polygon_offset";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__POLYGON_OFFSET_FILL_ENABLE = "profile_GLSL__technique__pass__states__polygon_offset_fill_enable";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__PROJECTION_MATRIX = "profile_GLSL__technique__pass__states__projection_matrix";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__RESCALE_NORMAL_ENABLE = "profile_GLSL__technique__pass__states__rescale_normal_enable";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__SAMPLE_ALPHA_TO_COVERAGE_ENABLE = "profile_GLSL__technique__pass__states__sample_alpha_to_coverage_enable";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__SAMPLE_ALPHA_TO_ONE_ENABLE = "profile_GLSL__technique__pass__states__sample_alpha_to_one_enable";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__SAMPLE_COVERAGE_ENABLE = "profile_GLSL__technique__pass__states__sample_coverage_enable";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__SCISSOR = "profile_GLSL__technique__pass__states__scissor";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__SCISSOR_TEST_ENABLE = "profile_GLSL__technique__pass__states__scissor_test_enable";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__SHADE_MODEL = "profile_GLSL__technique__pass__states__shade_model";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__STENCIL_FUNC = "profile_GLSL__technique__pass__states__stencil_func";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__STENCIL_FUNC_SEPARATE = "profile_GLSL__technique__pass__states__stencil_func_separate";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__STENCIL_FUNC_SEPARATE__BACK = "profile_GLSL__technique__pass__states__stencil_func_separate__back";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__STENCIL_FUNC_SEPARATE__FRONT = "profile_GLSL__technique__pass__states__stencil_func_separate__front";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__STENCIL_FUNC_SEPARATE__MASK = "profile_GLSL__technique__pass__states__stencil_func_separate__mask";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__STENCIL_FUNC_SEPARATE__REF = "profile_GLSL__technique__pass__states__stencil_func_separate__ref";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__STENCIL_FUNC__FUNC = "profile_GLSL__technique__pass__states__stencil_func__func";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__STENCIL_FUNC__MASK = "profile_GLSL__technique__pass__states__stencil_func__mask";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__STENCIL_FUNC__REF = "profile_GLSL__technique__pass__states__stencil_func__ref";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__STENCIL_MASK = "profile_GLSL__technique__pass__states__stencil_mask";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__STENCIL_MASK_SEPARATE = "profile_GLSL__technique__pass__states__stencil_mask_separate";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__STENCIL_MASK_SEPARATE__FACE = "profile_GLSL__technique__pass__states__stencil_mask_separate__face";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__STENCIL_MASK_SEPARATE__MASK = "profile_GLSL__technique__pass__states__stencil_mask_separate__mask";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__STENCIL_OP = "profile_GLSL__technique__pass__states__stencil_op";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__STENCIL_OP_SEPARATE = "profile_GLSL__technique__pass__states__stencil_op_separate";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__STENCIL_OP_SEPARATE__FACE = "profile_GLSL__technique__pass__states__stencil_op_separate__face";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__STENCIL_OP_SEPARATE__FAIL = "profile_GLSL__technique__pass__states__stencil_op_separate__fail";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__STENCIL_OP_SEPARATE__ZFAIL = "profile_GLSL__technique__pass__states__stencil_op_separate__zfail";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__STENCIL_OP_SEPARATE__ZPASS = "profile_GLSL__technique__pass__states__stencil_op_separate__zpass";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__STENCIL_OP__FAIL = "profile_GLSL__technique__pass__states__stencil_op__fail";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__STENCIL_OP__ZFAIL = "profile_GLSL__technique__pass__states__stencil_op__zfail";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__STENCIL_OP__ZPASS = "profile_GLSL__technique__pass__states__stencil_op__zpass";
const char* NAME_ELEMENT_PROFILE_GLSL__TECHNIQUE__PASS__STATES__STENCIL_TEST_ENABLE = "profile_GLSL__technique__pass__states__stencil_test_enable";
const char* NAME_ELEMENT_PROGRAM = "program";
const char* NAME_ELEMENT_PROGRAM____GLES2_PROGRAM_TYPE = "program____gles2_program_type";
const char* NAME_ELEMENT_PROGRAM____GLSL_PROGRAM_TYPE = "program____glsl_program_type";
const char* NAME_ELEMENT_PROJECTION_MATRIX = "projection_matrix";
const char* NAME_ELEMENT_PRSUBSET = "prsubset";
const char* NAME_ELEMENT_QUADRATIC_ATTENUATION = "quadratic_attenuation";
const char* NAME_ELEMENT_QUOTIENT = "quotient";
const char* NAME_ELEMENT_RADIUS = "radius";
const char* NAME_ELEMENT_RADIUS____FLOAT2_TYPE = "radius____float2_type";
const char* NAME_ELEMENT_RADIUS____FLOAT3_TYPE = "radius____float3_type";
const char* NAME_ELEMENT_RADIUS____FLOAT_TYPE = "radius____float_type";
const char* NAME_ELEMENT_RATIONALS = "rationals";
const char* NAME_ELEMENT_REAL = "real";
const char* NAME_ELEMENT_REALS = "reals";
const char* NAME_ELEMENT_REF = NAME_ATTRIBUTE_REF;
const char* NAME_ELEMENT_REFLECTIVE = "reflective";
const char* NAME_ELEMENT_REFLECTIVITY = "reflectivity";
const char* NAME_ELEMENT_REF_ATTACHMENT = "ref_attachment";
const char* NAME_ELEMENT_REF____ANYURI = "ref____anyURI";
const char* NAME_ELEMENT_REM = "rem";
const char* NAME_ELEMENT_RENDER = "render";
const char* NAME_ELEMENT_RENDERABLE = "renderable";
const char* NAME_ELEMENT_RENDER__INSTANCE_MATERIAL = "render__instance_material";
const char* NAME_ELEMENT_RENDER__INSTANCE_MATERIAL__BIND = "render__instance_material__bind";
const char* NAME_ELEMENT_RESCALE_NORMAL_ENABLE = "rescale_normal_enable";
const char* NAME_ELEMENT_RESTITUTION = "restitution";
const char* NAME_ELEMENT_REVISION = "revision";
const char* NAME_ELEMENT_REVOLUTE = "revolute";
const char* NAME_ELEMENT_RGB = "rgb";
const char* NAME_ELEMENT_RIGID_BODY = "rigid_body";
const char* NAME_ELEMENT_RIGID_BODY_TYPE____TECHNIQUE_COMMON = "rigid_body_type____technique_common";
const char* NAME_ELEMENT_RIGID_BODY__TECHNIQUE_COMMON__DYNAMIC = "rigid_body__technique_common__dynamic";
const char* NAME_ELEMENT_RIGID_BODY__TECHNIQUE_COMMON__MASS_FRAME = "rigid_body__technique_common__mass_frame";
const char* NAME_ELEMENT_RIGID_BODY__TECHNIQUE_COMMON__SHAPE = "rigid_body__technique_common__shape";
const char* NAME_ELEMENT_RIGID_BODY__TECHNIQUE_COMMON__SHAPE__HOLLOW = "rigid_body__technique_common__shape__hollow";
const char* NAME_ELEMENT_RIGID_CONSTRAINT = "rigid_constraint";
const char* NAME_ELEMENT_RIGID_CONSTRAINT_TYPE____TECHNIQUE_COMMON = "rigid_constraint_type____technique_common";
const char* NAME_ELEMENT_RIGID_CONSTRAINT__TECHNIQUE_COMMON__LIMITS = "rigid_constraint__technique_common__limits";
const char* NAME_ELEMENT_RIGID_CONSTRAINT__TECHNIQUE_COMMON__LIMITS__LINEAR = "rigid_constraint__technique_common__limits__linear";
const char* NAME_ELEMENT_ROOT = "root";
const char* NAME_ELEMENT_ROTATE = "rotate";
const char* NAME_ELEMENT_SAMPLER = "sampler";
const char* NAME_ELEMENT_SAMPLER1D = "sampler1D";
const char* NAME_ELEMENT_SAMPLER2D = "sampler2D";
const char* NAME_ELEMENT_SAMPLER2D____FX_SAMPLER2D_TYPE = "sampler2D____fx_sampler2D_type";
const char* NAME_ELEMENT_SAMPLER2D____GLES_SAMPLER_TYPE = "sampler2D____gles_sampler_type";
const char* NAME_ELEMENT_SAMPLER3D = "sampler3D";
const char* NAME_ELEMENT_SAMPLERCUBE = "samplerCUBE";
const char* NAME_ELEMENT_SAMPLERDEPTH = "samplerDEPTH";
const char* NAME_ELEMENT_SAMPLERRECT = "samplerRECT";
const char* NAME_ELEMENT_SAMPLER_IMAGE = "sampler_image";
const char* NAME_ELEMENT_SAMPLER_STATES = "sampler_states";
const char* NAME_ELEMENT_SAMPLE_ALPHA_TO_COVERAGE_ENABLE = "sample_alpha_to_coverage_enable";
const char* NAME_ELEMENT_SAMPLE_ALPHA_TO_ONE_ENABLE = "sample_alpha_to_one_enable";
const char* NAME_ELEMENT_SAMPLE_COVERAGE = "sample_coverage";
const char* NAME_ELEMENT_SAMPLE_COVERAGE_ENABLE = "sample_coverage_enable";
const char* NAME_ELEMENT_SAMPLE_COVERAGE__VALUE = "sample_coverage__value";
const char* NAME_ELEMENT_SCALARPRODUCT = "scalarproduct";
const char* NAME_ELEMENT_SCALE = NAME_ATTRIBUTE_SCALE;
const char* NAME_ELEMENT_SCENE = "scene";
const char* NAME_ELEMENT_SCISSOR = "scissor";
const char* NAME_ELEMENT_SCISSOR_TEST_ENABLE = "scissor_test_enable";
const char* NAME_ELEMENT_SDEV = "sdev";
const char* NAME_ELEMENT_SEC = "sec";
const char* NAME_ELEMENT_SECH = "sech";
const char* NAME_ELEMENT_SELECTOR = "selector";
const char* NAME_ELEMENT_SEMANTIC = NAME_ATTRIBUTE_SEMANTIC;
const char* NAME_ELEMENT_SEMANTICS = "semantics";
const char* NAME_ELEMENT_SEMANTIC____NCNAME = "semantic____NCName";
const char* NAME_ELEMENT_SEMANTIC____TOKEN = "semantic____token";
const char* NAME_ELEMENT_SEP = "sep";
const char* NAME_ELEMENT_SET = NAME_ATTRIBUTE_SET;
const char* NAME_ELEMENT_SETDIFF = "setdiff";
const char* NAME_ELEMENT_SETPARAM = "setparam";
const char* NAME_ELEMENT_SETPARAM____CG_SETPARAM_TYPE = "setparam____cg_setparam_type";
const char* NAME_ELEMENT_SETPARAM____FORMULA_SETPARAM_TYPE = "setparam____formula_setparam_type";
const char* NAME_ELEMENT_SETPARAM____KINEMATICS_SETPARAM_TYPE = "setparam____kinematics_setparam_type";
const char* NAME_ELEMENT_SHADER = "shader";
const char* NAME_ELEMENT_SHADER____GLES2_SHADER_TYPE = "shader____gles2_shader_type";
const char* NAME_ELEMENT_SHADER____GLSL_SHADER_TYPE = "shader____glsl_shader_type";
const char* NAME_ELEMENT_SHADE_MODEL = "shade_model";
const char* NAME_ELEMENT_SHAPE = "shape";
const char* NAME_ELEMENT_SHELLS = "shells";
const char* NAME_ELEMENT_SHININESS = "shininess";
const char* NAME_ELEMENT_SIDREF = "SIDREF";
const char* NAME_ELEMENT_SIDREF_ARRAY = "SIDREF_array";
const char* NAME_ELEMENT_SIN = "sin";
const char* NAME_ELEMENT_SINH = "sinh";
const char* NAME_ELEMENT_SIZE = "size";
const char* NAME_ELEMENT_SIZE_EXACT = "size_exact";
const char* NAME_ELEMENT_SIZE_RATIO = "size_ratio";
const char* NAME_ELEMENT_SKELETON = "skeleton";
const char* NAME_ELEMENT_SKEW = "skew";
const char* NAME_ELEMENT_SKIN = "skin";
const char* NAME_ELEMENT_SOLIDS = "solids";
const char* NAME_ELEMENT_SOURCE = "source";
const char* NAME_ELEMENT_SOURCES = "sources";
const char* NAME_ELEMENT_SOURCES____FX_SOURCES_TYPE = "sources____fx_sources_type";
const char* NAME_ELEMENT_SOURCE_DATA = "source_data";
const char* NAME_ELEMENT_SOURCE_TYPE____TECHNIQUE_COMMON = "source_type____technique_common";
const char* NAME_ELEMENT_SPECULAR = "specular";
const char* NAME_ELEMENT_SPEED = "speed";
const char* NAME_ELEMENT_SPEED____COMMON_FLOAT2_OR_PARAM_TYPE = "speed____common_float2_or_param_type";
const char* NAME_ELEMENT_SPEED____COMMON_FLOAT_OR_PARAM_TYPE = "speed____common_float_or_param_type";
const char* NAME_ELEMENT_SPHERE = "sphere";
const char* NAME_ELEMENT_SPLINE = "spline";
const char* NAME_ELEMENT_SPLINE_TYPE____CONTROL_VERTICES = "spline_type____control_vertices";
const char* NAME_ELEMENT_SPOT = "spot";
const char* NAME_ELEMENT_SPRING = "spring";
const char* NAME_ELEMENT_SPRING__LINEAR = "spring__linear";
const char* NAME_ELEMENT_SRC = "src";
const char* NAME_ELEMENT_SRC_ALPHA = "src_alpha";
const char* NAME_ELEMENT_SRC_RGB = "src_rgb";
const char* NAME_ELEMENT_STATES = "states";
const char* NAME_ELEMENT_STATIC_FRICTION = "static_friction";
const char* NAME_ELEMENT_STENCIL_CLEAR = "stencil_clear";
const char* NAME_ELEMENT_STENCIL_FUNC = "stencil_func";
const char* NAME_ELEMENT_STENCIL_FUNC_SEPARATE = "stencil_func_separate";
const char* NAME_ELEMENT_STENCIL_MASK = "stencil_mask";
const char* NAME_ELEMENT_STENCIL_MASK_SEPARATE = "stencil_mask_separate";
const char* NAME_ELEMENT_STENCIL_OP = "stencil_op";
const char* NAME_ELEMENT_STENCIL_OP_SEPARATE = "stencil_op_separate";
const char* NAME_ELEMENT_STENCIL_TARGET = "stencil_target";
const char* NAME_ELEMENT_STENCIL_TEST_ENABLE = "stencil_test_enable";
const char* NAME_ELEMENT_STIFFNESS = "stiffness";
const char* NAME_ELEMENT_STRING = "string";
const char* NAME_ELEMENT_SUBJECT = "subject";
const char* NAME_ELEMENT_SUBSET = "subset";
const char* NAME_ELEMENT_SUM = "sum";
const char* NAME_ELEMENT_SURFACE = "surface";
const char* NAME_ELEMENT_SURFACES = "surfaces";
const char* NAME_ELEMENT_SURFACE_CURVES = "surface_curves";
const char* NAME_ELEMENT_SURFACE_TYPE____CYLINDER = "surface_type____cylinder";
const char* NAME_ELEMENT_SWEPT_SURFACE = "swept_surface";
const char* NAME_ELEMENT_SWING_CONE_AND_TWIST = "swing_cone_and_twist";
const char* NAME_ELEMENT_TAN = "tan";
const char* NAME_ELEMENT_TANH = "tanh";
const char* NAME_ELEMENT_TARGET = NAME_ATTRIBUTE_TARGET;
const char* NAME_ELEMENT_TARGETS = "targets";
const char* NAME_ELEMENT_TARGET_VALUE = "target_value";
const char* NAME_ELEMENT_TECHNIQUE = "technique";
const char* NAME_ELEMENT_TECHNIQUE_COMMON = "technique_common";
const char* NAME_ELEMENT_TECHNIQUE_COMMON____FORMULA_TECHNIQUE_TYPE = "technique_common____formula_technique_type";
const char* NAME_ELEMENT_TECHNIQUE_COMMON____KINEMATICS_MODEL_TECHNIQUE_TYPE = "technique_common____kinematics_model_technique_type";
const char* NAME_ELEMENT_TECHNIQUE_COMMON____KINEMATICS_TECHNIQUE_TYPE = "technique_common____kinematics_technique_type";
const char* NAME_ELEMENT_TECHNIQUE_COMMON____MOTION_TECHNIQUE_TYPE = "technique_common____motion_technique_type";
const char* NAME_ELEMENT_TECHNIQUE_HINT = "technique_hint";
const char* NAME_ELEMENT_TECHNIQUE_OVERRIDE = "technique_override";
const char* NAME_ELEMENT_TECHNIQUE____TECHNIQUE_TYPE = "technique____technique_type";
const char* NAME_ELEMENT_TENDSTO = "tendsto";
const char* NAME_ELEMENT_TEXCOMBINER = "texcombiner";
const char* NAME_ELEMENT_TEXCOORD = NAME_ATTRIBUTE_TEXCOORD;
const char* NAME_ELEMENT_TEXENV = "texenv";
const char* NAME_ELEMENT_TEXTURE = "texture";
const char* NAME_ELEMENT_TEXTURE1D = "texture1D";
const char* NAME_ELEMENT_TEXTURE1D_ENABLE = "texture1D_enable";
const char* NAME_ELEMENT_TEXTURE2D = "texture2D";
const char* NAME_ELEMENT_TEXTURE2D_ENABLE = "texture2D_enable";
const char* NAME_ELEMENT_TEXTURE3D = "texture3D";
const char* NAME_ELEMENT_TEXTURE3D_ENABLE = "texture3D_enable";
const char* NAME_ELEMENT_TEXTURECUBE = "textureCUBE";
const char* NAME_ELEMENT_TEXTURECUBE_ENABLE = "textureCUBE_enable";
const char* NAME_ELEMENT_TEXTUREDEPTH = "textureDEPTH";
const char* NAME_ELEMENT_TEXTUREDEPTH_ENABLE = "textureDEPTH_enable";
const char* NAME_ELEMENT_TEXTURERECT = "textureRECT";
const char* NAME_ELEMENT_TEXTURERECT_ENABLE = "textureRECT_enable";
const char* NAME_ELEMENT_TEXTURE_ENV_COLOR = "texture_env_color";
const char* NAME_ELEMENT_TEXTURE_ENV_MODE = "texture_env_mode";
const char* NAME_ELEMENT_TEXTURE_PIPELINE = "texture_pipeline";
const char* NAME_ELEMENT_TIMES = "times";
const char* NAME_ELEMENT_TIME_STEP = "time_step";
const char* NAME_ELEMENT_TITLE = "title";
const char* NAME_ELEMENT_TOKEN_ARRAY = "token_array";
const char* NAME_ELEMENT_TORUS = "torus";
const char* NAME_ELEMENT_TRANSLATE = "translate";
const char* NAME_ELEMENT_TRANSPARENCY = "transparency";
const char* NAME_ELEMENT_TRANSPARENT = "transparent";
const char* NAME_ELEMENT_TRANSPOSE = "transpose";
const char* NAME_ELEMENT_TRIANGLES = "triangles";
const char* NAME_ELEMENT_TRIFANS = "trifans";
const char* NAME_ELEMENT_TRISTRIPS = "tristrips";
const char* NAME_ELEMENT_TRUE = "true";
const char* NAME_ELEMENT_UNION = "union";
const char* NAME_ELEMENT_UNIT = "unit";
const char* NAME_ELEMENT_UNNORMALIZED = "unnormalized";
const char* NAME_ELEMENT_UPLIMIT = "uplimit";
const char* NAME_ELEMENT_UP_AXIS = "up_axis";
const char* NAME_ELEMENT_USERTYPE = "usertype";
const char* NAME_ELEMENT_USERTYPE____CG_USER_TYPE = "usertype____cg_user_type";
const char* NAME_ELEMENT_V = "v";
const char* NAME_ELEMENT_VALUE = NAME_ATTRIBUTE_VALUE;
const char* NAME_ELEMENT_VALUE____COMMON_FLOAT_OR_PARAM_TYPE = "value____common_float_or_param_type";
const char* NAME_ELEMENT_VALUE____FX_SAMPLER1D_TYPE = "value____fx_sampler1D_type";
const char* NAME_ELEMENT_VALUE____FX_SAMPLER2D_TYPE = "value____fx_sampler2D_type";
const char* NAME_ELEMENT_VALUE____FX_SAMPLER3D_TYPE = "value____fx_sampler3D_type";
const char* NAME_ELEMENT_VALUE____FX_SAMPLERCUBE_TYPE = "value____fx_samplerCUBE_type";
const char* NAME_ELEMENT_VALUE____FX_SAMPLERDEPTH_TYPE = "value____fx_samplerDEPTH_type";
const char* NAME_ELEMENT_VALUE____FX_SAMPLERRECT_TYPE = "value____fx_samplerRECT_type";
const char* NAME_ELEMENT_VALUE____GLES_TEXTURE_PIPELINE_TYPE = "value____gles_texture_pipeline_type";
const char* NAME_ELEMENT_VARIANCE = "variance";
const char* NAME_ELEMENT_VCOUNT = "vcount";
const char* NAME_ELEMENT_VEC2 = "vec2";
const char* NAME_ELEMENT_VEC3 = "vec3";
const char* NAME_ELEMENT_VEC4 = "vec4";
const char* NAME_ELEMENT_VECTOR = "vector";
const char* NAME_ELEMENT_VECTORPRODUCT = "vectorproduct";
const char* NAME_ELEMENT_VELOCITY = "velocity";
const char* NAME_ELEMENT_VERTEX_WEIGHTS = "vertex_weights";
const char* NAME_ELEMENT_VERTICES = "vertices";
const char* NAME_ELEMENT_VISUAL_SCENE = "visual_scene";
const char* NAME_ELEMENT_WIRES = "wires";
const char* NAME_ELEMENT_WRAP_P = "wrap_p";
const char* NAME_ELEMENT_WRAP_S = "wrap_s";
const char* NAME_ELEMENT_WRAP_S____FX_SAMPLER_WRAP_ENUM = "wrap_s____fx_sampler_wrap_enum";
const char* NAME_ELEMENT_WRAP_S____GLES_SAMPLER_WRAP_ENUM = "wrap_s____gles_sampler_wrap_enum";
const char* NAME_ELEMENT_WRAP_T = "wrap_t";
const char* NAME_ELEMENT_WRAP_T____FX_SAMPLER_WRAP_ENUM = "wrap_t____fx_sampler_wrap_enum";
const char* NAME_ELEMENT_WRAP_T____GLES_SAMPLER_WRAP_ENUM = "wrap_t____gles_sampler_wrap_enum";
const char* NAME_ELEMENT_XFOV = "xfov";
const char* NAME_ELEMENT_XMAG = "xmag";
const char* NAME_ELEMENT_XOR = "xor";
const char* NAME_ELEMENT_YFOV = "yfov";
const char* NAME_ELEMENT_YMAG = "ymag";
const char* NAME_ELEMENT_ZFAIL = "zfail";
const char* NAME_ELEMENT_ZFAR = "zfar";
const char* NAME_ELEMENT_ZNEAR = "znear";
const char* NAME_ELEMENT_ZPASS = "zpass";



//---------------------------------------------------------------------
const COLLADA__AttributeData COLLADA__AttributeData::DEFAULT = {0, ENUM__version_enum__NOT_PRESENT, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__COLLADA( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__COLLADA( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__COLLADA( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

COLLADA__AttributeData* attributeData = newData<COLLADA__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_VERSION:
    {
bool failed;
attributeData->version = Utils::toEnum<ENUM__version_enum, StringHash, ENUM__version_enum__COUNT>(attributeValue, failed, ENUM__version_enumMap, Utils::calculateStringHash);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_COLLADA,
        HASH_ATTRIBUTE_VERSION,
        attributeValue))
{
    return false;
}

    break;
    }
    case HASH_ATTRIBUTE_BASE:
    {
bool failed;
attributeData->base = GeneratedSaxParser::Utils::toURI(&attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_COLLADA,
        HASH_ATTRIBUTE_BASE,
        attributeValue))
{
    return false;
}
if ( !failed )
    attributeData->present_attributes |= COLLADA__AttributeData::ATTRIBUTE_BASE_PRESENT;

    break;
    }
    case HASH_ATTRIBUTE_XMLNS:
    {
    // ignore

    break;
    }
    default:
    {
        StringHashPair hashPair = Utils::calculateStringHashWithNamespace( attribute );
        if ( hashPair.first != HASH_ATTRIBUTE_XMLNS )
        {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_COLLADA, attribute, attributeValue))
            {return false;}        }
        else
        {
            // ignore
        }

    }
    }
    }
}
if ((attributeData->present_attributes & COLLADA__AttributeData::ATTRIBUTE_BASE_PRESENT) == 0)
{
    attributeData->base = COLLADABU::URI("");
}
if ( attributeData->version == ENUM__version_enum__NOT_PRESENT )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_COLLADA, HASH_ATTRIBUTE_VERSION, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__COLLADA()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__COLLADA();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__COLLADA( void* attributeData )
{
    COLLADA__AttributeData* typedAttributeData = static_cast<COLLADA__AttributeData*>(attributeData);

    typedAttributeData->~COLLADA__AttributeData();

    return true;
}

//---------------------------------------------------------------------
ENUM__version_enum ColladaParserAutoGen15Private::toEnumDataPrefix_ENUM__version_enum (
    const ParserChar* prefixedBuffer,
    const ParserChar* prefixedBufferEnd,
    const ParserChar** buffer,
    const ParserChar* bufferEnd,
    bool& failed,
    const std::pair<StringHash, ENUM__version_enum>* enumMap,
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& )
)
{
    return toEnumDataPrefix<ENUM__version_enum, StringHash, ENUM__version_enum__COUNT, &toEnum_ENUM__version_enum>(prefixedBuffer, prefixedBufferEnd, buffer, bufferEnd, failed, enumMap, baseConversionFunc);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::characterData2EnumData_ENUM__version_enum (
    const ParserChar* text,
    size_t textLength,
    bool ( ColladaParserAutoGen15::*dataFunction )(const ENUM__version_enum*, size_t ),
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& )
)
{
    return characterData2EnumData<ENUM__version_enum, StringHash, ENUM__version_enum__COUNT>(text, textLength, dataFunction, ENUM__version_enumMap, baseConversionFunc, &toEnum_ENUM__version_enum, &ColladaParserAutoGen15Private::toEnumDataPrefix_ENUM__version_enum);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::dataEnumEnd_ENUM__version_enum (
    bool ( ColladaParserAutoGen15::*dataFunction )(const ENUM__version_enum*, size_t ),
    const std::pair<StringHash, ENUM__version_enum>* enumMap,
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& ),
    ENUM__version_enum (*toEnumFunc)( const ParserChar**, const ParserChar*, bool&, const std::pair<StringHash, ENUM__version_enum>* enumMap, StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& ))
)
{
    return dataEnumEnd<ENUM__version_enum, StringHash, ENUM__version_enum__COUNT>(dataFunction, enumMap, baseConversionFunc, toEnumFunc);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__asset( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__asset( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__asset( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__asset()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__asset();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__asset( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__contributor( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__contributor( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__contributor( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__contributor()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__contributor();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__contributor( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__author( const ParserChar* text, size_t textLength )
{

return mImpl->data__author(text, textLength);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__author( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__author( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__author()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__author();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__author( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__author_email( const ParserChar* text, size_t textLength )
{
if (!mLastIncompleteFragmentInCharacterData)
{
    mLastIncompleteFragmentInCharacterData = (ParserChar*)mStackMemoryManager.newObject(textLength);
    memcpy(mLastIncompleteFragmentInCharacterData, text, textLength);
    mEndOfDataInCurrentObjectOnStack = mLastIncompleteFragmentInCharacterData + textLength;
}
else
{
    ParserChar* tmp = (ParserChar*)mStackMemoryManager.growObject(textLength);
    if ( tmp != mLastIncompleteFragmentInCharacterData ) {
        mEndOfDataInCurrentObjectOnStack = (mEndOfDataInCurrentObjectOnStack - mLastIncompleteFragmentInCharacterData) + tmp;
        mLastIncompleteFragmentInCharacterData = tmp;
    }
    memcpy(mEndOfDataInCurrentObjectOnStack, text, textLength);
    mEndOfDataInCurrentObjectOnStack += textLength;
}
return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__author_email( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__author_email( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__author_email()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__author_email();
        if ( !validationResult ) return false;

    } // validation
#endif

bool returnValue = true;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
ParserError::ErrorType simpleTypeValidationResult = validate__author_email(mLastIncompleteFragmentInCharacterData, mEndOfDataInCurrentObjectOnStack - mLastIncompleteFragmentInCharacterData);
if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
{
    ParserChar msg[21];
    Utils::fillErrorMsg(msg, mLastIncompleteFragmentInCharacterData, 20);
    if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        simpleTypeValidationResult,
        0,
        msg) )
    {
        returnValue =  false;
    }
}
if (!returnValue)
{
    mStackMemoryManager.deleteObject();
    mLastIncompleteFragmentInCharacterData = 0;
    mEndOfDataInCurrentObjectOnStack = 0;
    return returnValue;
}
    } // validation
#endif
returnValue = mImpl->data__author_email(mLastIncompleteFragmentInCharacterData, mEndOfDataInCurrentObjectOnStack - mLastIncompleteFragmentInCharacterData);
mStackMemoryManager.deleteObject();
mLastIncompleteFragmentInCharacterData = 0;
mEndOfDataInCurrentObjectOnStack = 0;
return returnValue;

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__author_email( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__author_website( const ParserChar* text, size_t textLength )
{
if (!mLastIncompleteFragmentInCharacterData)
{
    mLastIncompleteFragmentInCharacterData = (ParserChar*)mStackMemoryManager.newObject(textLength);
    memcpy(mLastIncompleteFragmentInCharacterData, text, textLength);
    mEndOfDataInCurrentObjectOnStack = mLastIncompleteFragmentInCharacterData + textLength;
}
else
{
    ParserChar* tmp = (ParserChar*)mStackMemoryManager.growObject(textLength);
    if ( tmp != mLastIncompleteFragmentInCharacterData ) {
        mEndOfDataInCurrentObjectOnStack = (mEndOfDataInCurrentObjectOnStack - mLastIncompleteFragmentInCharacterData) + tmp;
        mLastIncompleteFragmentInCharacterData = tmp;
    }
    memcpy(mEndOfDataInCurrentObjectOnStack, text, textLength);
    mEndOfDataInCurrentObjectOnStack += textLength;
}
return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__author_website( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__author_website( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__author_website()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__author_website();
        if ( !validationResult ) return false;

    } // validation
#endif

bool failed;
const ParserChar* ptrForErr = mLastIncompleteFragmentInCharacterData;
DISABLE_WARNING_UNUSED(ptrForErr)
COLLADABU::URI parameter = GeneratedSaxParser::Utils::toURI((const ParserChar**)&mLastIncompleteFragmentInCharacterData, mEndOfDataInCurrentObjectOnStack, failed);
bool returnValue;
if (!failed)
{
    returnValue = mImpl->data__author_website(parameter);
}
else
    returnValue = !handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_TEXTDATA_PARSING_FAILED, HASH_ELEMENT_AUTHOR_WEBSITE, (const ParserChar*)0, mLastIncompleteFragmentInCharacterData);
if (mLastIncompleteFragmentInCharacterData)
    mStackMemoryManager.deleteObject();
mLastIncompleteFragmentInCharacterData = 0;
mEndOfDataInCurrentObjectOnStack = 0;
return returnValue;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__author_website( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__authoring_tool( const ParserChar* text, size_t textLength )
{

return mImpl->data__authoring_tool(text, textLength);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__authoring_tool( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__authoring_tool( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__authoring_tool()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__authoring_tool();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__authoring_tool( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__comments( const ParserChar* text, size_t textLength )
{

return mImpl->data__comments(text, textLength);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__comments( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__comments( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__comments()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__comments();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__comments( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__copyright( const ParserChar* text, size_t textLength )
{

return mImpl->data__copyright(text, textLength);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__copyright( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__copyright( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__copyright()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__copyright();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__copyright( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__source_data( const ParserChar* text, size_t textLength )
{
if (!mLastIncompleteFragmentInCharacterData)
{
    mLastIncompleteFragmentInCharacterData = (ParserChar*)mStackMemoryManager.newObject(textLength);
    memcpy(mLastIncompleteFragmentInCharacterData, text, textLength);
    mEndOfDataInCurrentObjectOnStack = mLastIncompleteFragmentInCharacterData + textLength;
}
else
{
    ParserChar* tmp = (ParserChar*)mStackMemoryManager.growObject(textLength);
    if ( tmp != mLastIncompleteFragmentInCharacterData ) {
        mEndOfDataInCurrentObjectOnStack = (mEndOfDataInCurrentObjectOnStack - mLastIncompleteFragmentInCharacterData) + tmp;
        mLastIncompleteFragmentInCharacterData = tmp;
    }
    memcpy(mEndOfDataInCurrentObjectOnStack, text, textLength);
    mEndOfDataInCurrentObjectOnStack += textLength;
}
return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__source_data( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__source_data( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__source_data()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__source_data();
        if ( !validationResult ) return false;

    } // validation
#endif

bool failed;
const ParserChar* ptrForErr = mLastIncompleteFragmentInCharacterData;
DISABLE_WARNING_UNUSED(ptrForErr)
COLLADABU::URI parameter = GeneratedSaxParser::Utils::toURI((const ParserChar**)&mLastIncompleteFragmentInCharacterData, mEndOfDataInCurrentObjectOnStack, failed);
bool returnValue;
if (!failed)
{
    returnValue = mImpl->data__source_data(parameter);
}
else
    returnValue = !handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_TEXTDATA_PARSING_FAILED, HASH_ELEMENT_SOURCE_DATA, (const ParserChar*)0, mLastIncompleteFragmentInCharacterData);
if (mLastIncompleteFragmentInCharacterData)
    mStackMemoryManager.deleteObject();
mLastIncompleteFragmentInCharacterData = 0;
mEndOfDataInCurrentObjectOnStack = 0;
return returnValue;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__source_data( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__coverage( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__coverage( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__coverage( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__coverage()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__coverage();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__coverage( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__geographic_location( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__geographic_location( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__geographic_location( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__geographic_location()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__geographic_location();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__geographic_location( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__longitude( const ParserChar* text, size_t textLength )
{
if (!mLastIncompleteFragmentInCharacterData)
{
    mLastIncompleteFragmentInCharacterData = (ParserChar*)mStackMemoryManager.newObject(textLength);
    memcpy(mLastIncompleteFragmentInCharacterData, text, textLength);
    mEndOfDataInCurrentObjectOnStack = mLastIncompleteFragmentInCharacterData + textLength;
}
else
{
    ParserChar* tmp = (ParserChar*)mStackMemoryManager.growObject(textLength);
    if ( tmp != mLastIncompleteFragmentInCharacterData ) {
        mEndOfDataInCurrentObjectOnStack = (mEndOfDataInCurrentObjectOnStack - mLastIncompleteFragmentInCharacterData) + tmp;
        mLastIncompleteFragmentInCharacterData = tmp;
    }
    memcpy(mEndOfDataInCurrentObjectOnStack, text, textLength);
    mEndOfDataInCurrentObjectOnStack += textLength;
}
return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__longitude( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__longitude( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__longitude()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__longitude();
        if ( !validationResult ) return false;

    } // validation
#endif

bool failed;
const ParserChar* ptrForErr = mLastIncompleteFragmentInCharacterData;
DISABLE_WARNING_UNUSED(ptrForErr)
float parameter = GeneratedSaxParser::Utils::toFloat((const ParserChar**)&mLastIncompleteFragmentInCharacterData, mEndOfDataInCurrentObjectOnStack, failed);
bool returnValue;
if (!failed)
{
    returnValue = mImpl->data__longitude(parameter);
}
else
    returnValue = !handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_TEXTDATA_PARSING_FAILED, HASH_ELEMENT_LONGITUDE, (const ParserChar*)0, mLastIncompleteFragmentInCharacterData);
if (mLastIncompleteFragmentInCharacterData)
    mStackMemoryManager.deleteObject();
mLastIncompleteFragmentInCharacterData = 0;
mEndOfDataInCurrentObjectOnStack = 0;
return returnValue;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__longitude( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__latitude( const ParserChar* text, size_t textLength )
{
if (!mLastIncompleteFragmentInCharacterData)
{
    mLastIncompleteFragmentInCharacterData = (ParserChar*)mStackMemoryManager.newObject(textLength);
    memcpy(mLastIncompleteFragmentInCharacterData, text, textLength);
    mEndOfDataInCurrentObjectOnStack = mLastIncompleteFragmentInCharacterData + textLength;
}
else
{
    ParserChar* tmp = (ParserChar*)mStackMemoryManager.growObject(textLength);
    if ( tmp != mLastIncompleteFragmentInCharacterData ) {
        mEndOfDataInCurrentObjectOnStack = (mEndOfDataInCurrentObjectOnStack - mLastIncompleteFragmentInCharacterData) + tmp;
        mLastIncompleteFragmentInCharacterData = tmp;
    }
    memcpy(mEndOfDataInCurrentObjectOnStack, text, textLength);
    mEndOfDataInCurrentObjectOnStack += textLength;
}
return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__latitude( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__latitude( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__latitude()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__latitude();
        if ( !validationResult ) return false;

    } // validation
#endif

bool failed;
const ParserChar* ptrForErr = mLastIncompleteFragmentInCharacterData;
DISABLE_WARNING_UNUSED(ptrForErr)
float parameter = GeneratedSaxParser::Utils::toFloat((const ParserChar**)&mLastIncompleteFragmentInCharacterData, mEndOfDataInCurrentObjectOnStack, failed);
bool returnValue;
if (!failed)
{
    returnValue = mImpl->data__latitude(parameter);
}
else
    returnValue = !handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_TEXTDATA_PARSING_FAILED, HASH_ELEMENT_LATITUDE, (const ParserChar*)0, mLastIncompleteFragmentInCharacterData);
if (mLastIncompleteFragmentInCharacterData)
    mStackMemoryManager.deleteObject();
mLastIncompleteFragmentInCharacterData = 0;
mEndOfDataInCurrentObjectOnStack = 0;
return returnValue;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__latitude( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
const altitude__AttributeData altitude__AttributeData::DEFAULT = {ENUM__altitude_mode_enum__relativeToGround};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__altitude( const ParserChar* text, size_t textLength )
{
if (!mLastIncompleteFragmentInCharacterData)
{
    mLastIncompleteFragmentInCharacterData = (ParserChar*)mStackMemoryManager.newObject(textLength);
    memcpy(mLastIncompleteFragmentInCharacterData, text, textLength);
    mEndOfDataInCurrentObjectOnStack = mLastIncompleteFragmentInCharacterData + textLength;
}
else
{
    ParserChar* tmp = (ParserChar*)mStackMemoryManager.growObject(textLength);
    if ( tmp != mLastIncompleteFragmentInCharacterData ) {
        mEndOfDataInCurrentObjectOnStack = (mEndOfDataInCurrentObjectOnStack - mLastIncompleteFragmentInCharacterData) + tmp;
        mLastIncompleteFragmentInCharacterData = tmp;
    }
    memcpy(mEndOfDataInCurrentObjectOnStack, text, textLength);
    mEndOfDataInCurrentObjectOnStack += textLength;
}
return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__altitude( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__altitude( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

altitude__AttributeData* attributeData = newData<altitude__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_MODE:
    {
bool failed;
attributeData->mode = Utils::toEnum<ENUM__altitude_mode_enum, StringHash, ENUM__altitude_mode_enum__COUNT>(attributeValue, failed, ENUM__altitude_mode_enumMap, Utils::calculateStringHash);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_ALTITUDE,
        HASH_ATTRIBUTE_MODE,
        attributeValue))
{
    return false;
}

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_ALTITUDE, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__altitude()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__altitude();
        if ( !validationResult ) return false;

    } // validation
#endif

bool failed;
const ParserChar* ptrForErr = mLastIncompleteFragmentInCharacterData;
DISABLE_WARNING_UNUSED(ptrForErr)
float parameter = GeneratedSaxParser::Utils::toFloat((const ParserChar**)&mLastIncompleteFragmentInCharacterData, mEndOfDataInCurrentObjectOnStack, failed);
bool returnValue;
if (!failed)
{
    returnValue = mImpl->data__altitude(parameter);
}
else
    returnValue = !handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_TEXTDATA_PARSING_FAILED, HASH_ELEMENT_ALTITUDE, (const ParserChar*)0, mLastIncompleteFragmentInCharacterData);
if (mLastIncompleteFragmentInCharacterData)
    mStackMemoryManager.deleteObject();
mLastIncompleteFragmentInCharacterData = 0;
mEndOfDataInCurrentObjectOnStack = 0;
return returnValue;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__altitude( void* attributeData )
{
    altitude__AttributeData* typedAttributeData = static_cast<altitude__AttributeData*>(attributeData);

    typedAttributeData->~altitude__AttributeData();

    return true;
}

//---------------------------------------------------------------------
ENUM__altitude_mode_enum ColladaParserAutoGen15Private::toEnumDataPrefix_ENUM__altitude_mode_enum (
    const ParserChar* prefixedBuffer,
    const ParserChar* prefixedBufferEnd,
    const ParserChar** buffer,
    const ParserChar* bufferEnd,
    bool& failed,
    const std::pair<StringHash, ENUM__altitude_mode_enum>* enumMap,
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& )
)
{
    return toEnumDataPrefix<ENUM__altitude_mode_enum, StringHash, ENUM__altitude_mode_enum__COUNT, &toEnum_ENUM__altitude_mode_enum>(prefixedBuffer, prefixedBufferEnd, buffer, bufferEnd, failed, enumMap, baseConversionFunc);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::characterData2EnumData_ENUM__altitude_mode_enum (
    const ParserChar* text,
    size_t textLength,
    bool ( ColladaParserAutoGen15::*dataFunction )(const ENUM__altitude_mode_enum*, size_t ),
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& )
)
{
    return characterData2EnumData<ENUM__altitude_mode_enum, StringHash, ENUM__altitude_mode_enum__COUNT>(text, textLength, dataFunction, ENUM__altitude_mode_enumMap, baseConversionFunc, &toEnum_ENUM__altitude_mode_enum, &ColladaParserAutoGen15Private::toEnumDataPrefix_ENUM__altitude_mode_enum);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::dataEnumEnd_ENUM__altitude_mode_enum (
    bool ( ColladaParserAutoGen15::*dataFunction )(const ENUM__altitude_mode_enum*, size_t ),
    const std::pair<StringHash, ENUM__altitude_mode_enum>* enumMap,
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& ),
    ENUM__altitude_mode_enum (*toEnumFunc)( const ParserChar**, const ParserChar*, bool&, const std::pair<StringHash, ENUM__altitude_mode_enum>* enumMap, StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& ))
)
{
    return dataEnumEnd<ENUM__altitude_mode_enum, StringHash, ENUM__altitude_mode_enum__COUNT>(dataFunction, enumMap, baseConversionFunc, toEnumFunc);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__created( const ParserChar* text, size_t textLength )
{

return mImpl->data__created(text, textLength);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__created( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__created( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__created()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__created();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__created( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__keywords( const ParserChar* text, size_t textLength )
{

return mImpl->data__keywords(text, textLength);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__keywords( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__keywords( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__keywords()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__keywords();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__keywords( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__modified( const ParserChar* text, size_t textLength )
{

return mImpl->data__modified(text, textLength);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__modified( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__modified( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__modified()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__modified();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__modified( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__revision( const ParserChar* text, size_t textLength )
{

return mImpl->data__revision(text, textLength);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__revision( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__revision( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__revision()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__revision();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__revision( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__subject( const ParserChar* text, size_t textLength )
{

return mImpl->data__subject(text, textLength);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__subject( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__subject( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__subject()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__subject();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__subject( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__title( const ParserChar* text, size_t textLength )
{

return mImpl->data__title(text, textLength);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__title( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__title( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__title()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__title();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__title( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
const unit__AttributeData unit__AttributeData::DEFAULT = {1.0E0, (const ParserChar*)"meter"};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__unit( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__unit( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__unit( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

unit__AttributeData* attributeData = newData<unit__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_METER:
    {
bool failed;
attributeData->meter = GeneratedSaxParser::Utils::toFloat(attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_UNIT,
        HASH_ATTRIBUTE_METER,
        attributeValue))
{
    return false;
}

    break;
    }
    case HASH_ATTRIBUTE_NAME:
    {

attributeData->name = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NMTOKEN(attributeData->name, strlen(attributeData->name));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_UNIT,
            HASH_ATTRIBUTE_NAME,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_UNIT, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__unit()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__unit();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__unit( void* attributeData )
{
    unit__AttributeData* typedAttributeData = static_cast<unit__AttributeData*>(attributeData);

    typedAttributeData->~unit__AttributeData();

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__up_axis( const ParserChar* text, size_t textLength )
{
if (!mLastIncompleteFragmentInCharacterData)
{
    mLastIncompleteFragmentInCharacterData = (ParserChar*)mStackMemoryManager.newObject(textLength);
    memcpy(mLastIncompleteFragmentInCharacterData, text, textLength);
    mEndOfDataInCurrentObjectOnStack = mLastIncompleteFragmentInCharacterData + textLength;
}
else
{
    ParserChar* tmp = (ParserChar*)mStackMemoryManager.growObject(textLength);
    if ( tmp != mLastIncompleteFragmentInCharacterData ) {
        mEndOfDataInCurrentObjectOnStack = (mEndOfDataInCurrentObjectOnStack - mLastIncompleteFragmentInCharacterData) + tmp;
        mLastIncompleteFragmentInCharacterData = tmp;
    }
    memcpy(mEndOfDataInCurrentObjectOnStack, text, textLength);
    mEndOfDataInCurrentObjectOnStack += textLength;
}
return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__up_axis( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__up_axis( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__up_axis()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__up_axis();
        if ( !validationResult ) return false;

    } // validation
#endif

bool failed;
ENUM__up_axis_enum parameter = Utils::toEnum<ENUM__up_axis_enum, StringHash, ENUM__up_axis_enum__COUNT>((const ParserChar**)&mLastIncompleteFragmentInCharacterData, mEndOfDataInCurrentObjectOnStack, failed, ENUM__up_axis_enumMap, Utils::calculateStringHash);
bool returnValue;
if (!failed)
{
    returnValue = mImpl->data__up_axis(parameter);
}
else
    returnValue = !handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_TEXTDATA_PARSING_FAILED, HASH_ELEMENT_UP_AXIS, (const ParserChar*)0, mLastIncompleteFragmentInCharacterData);
if (mLastIncompleteFragmentInCharacterData)
    mStackMemoryManager.deleteObject();
mLastIncompleteFragmentInCharacterData = 0;
mEndOfDataInCurrentObjectOnStack = 0;
return returnValue;

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__up_axis( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
ENUM__up_axis_enum ColladaParserAutoGen15Private::toEnumDataPrefix_ENUM__up_axis_enum (
    const ParserChar* prefixedBuffer,
    const ParserChar* prefixedBufferEnd,
    const ParserChar** buffer,
    const ParserChar* bufferEnd,
    bool& failed,
    const std::pair<StringHash, ENUM__up_axis_enum>* enumMap,
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& )
)
{
    return toEnumDataPrefix<ENUM__up_axis_enum, StringHash, ENUM__up_axis_enum__COUNT, &toEnum_ENUM__up_axis_enum>(prefixedBuffer, prefixedBufferEnd, buffer, bufferEnd, failed, enumMap, baseConversionFunc);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::characterData2EnumData_ENUM__up_axis_enum (
    const ParserChar* text,
    size_t textLength,
    bool ( ColladaParserAutoGen15::*dataFunction )(const ENUM__up_axis_enum*, size_t ),
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& )
)
{
    return characterData2EnumData<ENUM__up_axis_enum, StringHash, ENUM__up_axis_enum__COUNT>(text, textLength, dataFunction, ENUM__up_axis_enumMap, baseConversionFunc, &toEnum_ENUM__up_axis_enum, &ColladaParserAutoGen15Private::toEnumDataPrefix_ENUM__up_axis_enum);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::dataEnumEnd_ENUM__up_axis_enum (
    bool ( ColladaParserAutoGen15::*dataFunction )(const ENUM__up_axis_enum*, size_t ),
    const std::pair<StringHash, ENUM__up_axis_enum>* enumMap,
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& ),
    ENUM__up_axis_enum (*toEnumFunc)( const ParserChar**, const ParserChar*, bool&, const std::pair<StringHash, ENUM__up_axis_enum>* enumMap, StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& ))
)
{
    return dataEnumEnd<ENUM__up_axis_enum, StringHash, ENUM__up_axis_enum__COUNT>(dataFunction, enumMap, baseConversionFunc, toEnumFunc);
}

//---------------------------------------------------------------------
const extra__AttributeData extra__AttributeData::DEFAULT = {0, 0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__extra( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__extra( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__extra( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

extra__AttributeData* attributeData = newData<extra__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_ID:
    {

attributeData->id = attributeValue;

    break;
    }
    case HASH_ATTRIBUTE_NAME:
    {

attributeData->name = attributeValue;

    break;
    }
    case HASH_ATTRIBUTE_TYPE:
    {

attributeData->type = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NMTOKEN(attributeData->type, strlen(attributeData->type));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_EXTRA,
            HASH_ATTRIBUTE_TYPE,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_EXTRA, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__extra()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__extra();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__extra( void* attributeData )
{
    extra__AttributeData* typedAttributeData = static_cast<extra__AttributeData*>(attributeData);

    typedAttributeData->~extra__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const technique____technique_type__AttributeData technique____technique_type__AttributeData::DEFAULT = {0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__technique____technique_type( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__technique____technique_type( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__technique____technique_type( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

technique____technique_type__AttributeData* attributeData = newData<technique____technique_type__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_PROFILE:
    {

attributeData->profile = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NMTOKEN(attributeData->profile, strlen(attributeData->profile));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_TECHNIQUE,
            HASH_ATTRIBUTE_PROFILE,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_TECHNIQUE, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ( !attributeData->profile )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_TECHNIQUE, HASH_ATTRIBUTE_PROFILE, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__technique____technique_type()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__technique____technique_type();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__technique____technique_type( void* attributeData )
{
    technique____technique_type__AttributeData* typedAttributeData = static_cast<technique____technique_type__AttributeData*>(attributeData);

    typedAttributeData->~technique____technique_type__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const library_animations__AttributeData library_animations__AttributeData::DEFAULT = {0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__library_animations( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__library_animations( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__library_animations( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

library_animations__AttributeData* attributeData = newData<library_animations__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_ID:
    {

attributeData->id = attributeValue;

    break;
    }
    case HASH_ATTRIBUTE_NAME:
    {

attributeData->name = attributeValue;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_LIBRARY_ANIMATIONS, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__library_animations()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__library_animations();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__library_animations( void* attributeData )
{
    library_animations__AttributeData* typedAttributeData = static_cast<library_animations__AttributeData*>(attributeData);

    typedAttributeData->~library_animations__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const animation__AttributeData animation__AttributeData::DEFAULT = {0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__animation( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__animation( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__animation( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

animation__AttributeData* attributeData = newData<animation__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_ID:
    {

attributeData->id = attributeValue;

    break;
    }
    case HASH_ATTRIBUTE_NAME:
    {

attributeData->name = attributeValue;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_ANIMATION, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__animation()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__animation();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__animation( void* attributeData )
{
    animation__AttributeData* typedAttributeData = static_cast<animation__AttributeData*>(attributeData);

    typedAttributeData->~animation__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const source__AttributeData source__AttributeData::DEFAULT = {0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__source( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__source( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__source( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

source__AttributeData* attributeData = newData<source__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_ID:
    {

attributeData->id = attributeValue;

    break;
    }
    case HASH_ATTRIBUTE_NAME:
    {

attributeData->name = attributeValue;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_SOURCE, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ( !attributeData->id )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_SOURCE, HASH_ATTRIBUTE_ID, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__source()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__source();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__source( void* attributeData )
{
    source__AttributeData* typedAttributeData = static_cast<source__AttributeData*>(attributeData);

    typedAttributeData->~source__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const token_array__AttributeData token_array__AttributeData::DEFAULT = {0, 0, 0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__token_array( const ParserChar* text, size_t textLength )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
return characterData2StringData(text, textLength, &ColladaParserAutoGen15::data__token_array, 0, 0, 0);
    }
    else
    {
return characterData2StringData(text, textLength, &ColladaParserAutoGen15::data__token_array);
    }
#else
    {
return characterData2StringData(text, textLength, &ColladaParserAutoGen15::data__token_array);
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__token_array( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__token_array( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

token_array__AttributeData* attributeData = newData<token_array__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_ID:
    {

attributeData->id = attributeValue;

    break;
    }
    case HASH_ATTRIBUTE_NAME:
    {

attributeData->name = attributeValue;

    break;
    }
    case HASH_ATTRIBUTE_COUNT:
    {
bool failed;
attributeData->count = GeneratedSaxParser::Utils::toUint64(attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_TOKEN_ARRAY,
        HASH_ATTRIBUTE_COUNT,
        attributeValue))
{
    return false;
}
if ( !failed )
    attributeData->present_attributes |= token_array__AttributeData::ATTRIBUTE_COUNT_PRESENT;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_TOKEN_ARRAY, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ( (attributeData->present_attributes & token_array__AttributeData::ATTRIBUTE_COUNT_PRESENT) == 0 )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_TOKEN_ARRAY, HASH_ATTRIBUTE_COUNT, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__token_array()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__token_array();
        if ( !validationResult ) return false;

    } // validation
#endif

#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
bool returnValue = stringListDataEnd( &ColladaParserAutoGen15::data__token_array, 0, 0, 0 );
        return returnValue;
    }
    else
    {
return stringListDataEnd( &ColladaParserAutoGen15::data__token_array );
    }
#else
    {
return stringListDataEnd( &ColladaParserAutoGen15::data__token_array );
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__token_array( void* attributeData )
{
    token_array__AttributeData* typedAttributeData = static_cast<token_array__AttributeData*>(attributeData);

    typedAttributeData->~token_array__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const IDREF_array__AttributeData IDREF_array__AttributeData::DEFAULT = {0, 0, 0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__IDREF_array( const ParserChar* text, size_t textLength )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        IDREF_array__ValidationData* validationData = (IDREF_array__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
return characterData2StringData(text, textLength, &ColladaParserAutoGen15::data__IDREF_array, &validate__IDREFS__stream, &validationData->validationWholeSize, 0);
    }
    else
    {
return characterData2StringData(text, textLength, &ColladaParserAutoGen15::data__IDREF_array);
    }
#else
    {
return characterData2StringData(text, textLength, &ColladaParserAutoGen15::data__IDREF_array);
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__IDREF_array( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__IDREF_array( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

IDREF_array__AttributeData* attributeData = newData<IDREF_array__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_ID:
    {

attributeData->id = attributeValue;

    break;
    }
    case HASH_ATTRIBUTE_NAME:
    {

attributeData->name = attributeValue;

    break;
    }
    case HASH_ATTRIBUTE_COUNT:
    {
bool failed;
attributeData->count = GeneratedSaxParser::Utils::toUint64(attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_IDREF_ARRAY,
        HASH_ATTRIBUTE_COUNT,
        attributeValue))
{
    return false;
}
if ( !failed )
    attributeData->present_attributes |= IDREF_array__AttributeData::ATTRIBUTE_COUNT_PRESENT;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_IDREF_ARRAY, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ( (attributeData->present_attributes & IDREF_array__AttributeData::ATTRIBUTE_COUNT_PRESENT) == 0 )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_IDREF_ARRAY, HASH_ATTRIBUTE_COUNT, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__IDREF_array()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__IDREF_array();
        if ( !validationResult ) return false;

    } // validation
#endif

#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        IDREF_array__ValidationData* validationData = (IDREF_array__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
bool returnValue = stringListDataEnd( &ColladaParserAutoGen15::data__IDREF_array, &validate__IDREFS__streamEnd, &validationData->validationWholeSize, 0 );
        ParserError::ErrorType simpleTypeValidationResult = validate__IDREFS(0, (*(&validationData->validationWholeSize)));
        mValidationDataStack.deleteObject();
        if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
        {
            if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
                simpleTypeValidationResult,
                HASH_ELEMENT_IDREF_ARRAY,
                (ParserChar*)0, 0 ) )
            {
                return false;
            }
        }
        return returnValue;
    }
    else
    {
return stringListDataEnd( &ColladaParserAutoGen15::data__IDREF_array );
    }
#else
    {
return stringListDataEnd( &ColladaParserAutoGen15::data__IDREF_array );
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__IDREF_array( void* attributeData )
{
    IDREF_array__AttributeData* typedAttributeData = static_cast<IDREF_array__AttributeData*>(attributeData);

    typedAttributeData->~IDREF_array__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const Name_array__AttributeData Name_array__AttributeData::DEFAULT = {0, 0, 0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__Name_array( const ParserChar* text, size_t textLength )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
return characterData2StringData(text, textLength, &ColladaParserAutoGen15::data__Name_array, 0, 0, &validate__Name);
    }
    else
    {
return characterData2StringData(text, textLength, &ColladaParserAutoGen15::data__Name_array);
    }
#else
    {
return characterData2StringData(text, textLength, &ColladaParserAutoGen15::data__Name_array);
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__Name_array( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__Name_array( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

Name_array__AttributeData* attributeData = newData<Name_array__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_ID:
    {

attributeData->id = attributeValue;

    break;
    }
    case HASH_ATTRIBUTE_NAME:
    {

attributeData->name = attributeValue;

    break;
    }
    case HASH_ATTRIBUTE_COUNT:
    {
bool failed;
attributeData->count = GeneratedSaxParser::Utils::toUint64(attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_NAME_ARRAY,
        HASH_ATTRIBUTE_COUNT,
        attributeValue))
{
    return false;
}
if ( !failed )
    attributeData->present_attributes |= Name_array__AttributeData::ATTRIBUTE_COUNT_PRESENT;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_NAME_ARRAY, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ( (attributeData->present_attributes & Name_array__AttributeData::ATTRIBUTE_COUNT_PRESENT) == 0 )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_NAME_ARRAY, HASH_ATTRIBUTE_COUNT, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__Name_array()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__Name_array();
        if ( !validationResult ) return false;

    } // validation
#endif

#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
bool returnValue = stringListDataEnd( &ColladaParserAutoGen15::data__Name_array, 0, 0, &validate__Name );
        return returnValue;
    }
    else
    {
return stringListDataEnd( &ColladaParserAutoGen15::data__Name_array );
    }
#else
    {
return stringListDataEnd( &ColladaParserAutoGen15::data__Name_array );
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__Name_array( void* attributeData )
{
    Name_array__AttributeData* typedAttributeData = static_cast<Name_array__AttributeData*>(attributeData);

    typedAttributeData->~Name_array__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const bool_array__AttributeData bool_array__AttributeData::DEFAULT = {0, 0, 0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__bool_array( const ParserChar* text, size_t textLength )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
return characterData2BoolData(text, textLength, &ColladaParserAutoGen15::data__bool_array, 0, 0, 0);
    }
    else
    {
return characterData2BoolData(text, textLength, &ColladaParserAutoGen15::data__bool_array);
    }
#else
    {
return characterData2BoolData(text, textLength, &ColladaParserAutoGen15::data__bool_array);
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__bool_array( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__bool_array( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

bool_array__AttributeData* attributeData = newData<bool_array__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_ID:
    {

attributeData->id = attributeValue;

    break;
    }
    case HASH_ATTRIBUTE_NAME:
    {

attributeData->name = attributeValue;

    break;
    }
    case HASH_ATTRIBUTE_COUNT:
    {
bool failed;
attributeData->count = GeneratedSaxParser::Utils::toUint64(attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_BOOL_ARRAY,
        HASH_ATTRIBUTE_COUNT,
        attributeValue))
{
    return false;
}
if ( !failed )
    attributeData->present_attributes |= bool_array__AttributeData::ATTRIBUTE_COUNT_PRESENT;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_BOOL_ARRAY, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ( (attributeData->present_attributes & bool_array__AttributeData::ATTRIBUTE_COUNT_PRESENT) == 0 )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_BOOL_ARRAY, HASH_ATTRIBUTE_COUNT, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__bool_array()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__bool_array();
        if ( !validationResult ) return false;

    } // validation
#endif

#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
bool returnValue = boolDataEnd( &ColladaParserAutoGen15::data__bool_array, 0, 0, 0 );
        return returnValue;
    }
    else
    {
return boolDataEnd( &ColladaParserAutoGen15::data__bool_array );
    }
#else
    {
return boolDataEnd( &ColladaParserAutoGen15::data__bool_array );
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__bool_array( void* attributeData )
{
    bool_array__AttributeData* typedAttributeData = static_cast<bool_array__AttributeData*>(attributeData);

    typedAttributeData->~bool_array__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const float_array__AttributeData float_array__AttributeData::DEFAULT = {0, 0, 0, 0, 6, 38};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__float_array( const ParserChar* text, size_t textLength )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen15::data__float_array, 0, 0, 0);
    }
    else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen15::data__float_array);
    }
#else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen15::data__float_array);
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__float_array( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__float_array( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

float_array__AttributeData* attributeData = newData<float_array__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_ID:
    {

attributeData->id = attributeValue;

    break;
    }
    case HASH_ATTRIBUTE_NAME:
    {

attributeData->name = attributeValue;

    break;
    }
    case HASH_ATTRIBUTE_COUNT:
    {
bool failed;
attributeData->count = GeneratedSaxParser::Utils::toUint64(attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_FLOAT_ARRAY,
        HASH_ATTRIBUTE_COUNT,
        attributeValue))
{
    return false;
}
if ( !failed )
    attributeData->present_attributes |= float_array__AttributeData::ATTRIBUTE_COUNT_PRESENT;

    break;
    }
    case HASH_ATTRIBUTE_DIGITS:
    {
bool failed;
attributeData->digits = GeneratedSaxParser::Utils::toUint8(attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_FLOAT_ARRAY,
        HASH_ATTRIBUTE_DIGITS,
        attributeValue))
{
    return false;
}
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__digits_type(attributeData->digits);
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_FLOAT_ARRAY,
            HASH_ATTRIBUTE_DIGITS,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    case HASH_ATTRIBUTE_MAGNITUDE:
    {
bool failed;
attributeData->magnitude = GeneratedSaxParser::Utils::toSint16(attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_FLOAT_ARRAY,
        HASH_ATTRIBUTE_MAGNITUDE,
        attributeValue))
{
    return false;
}
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__magnitude_type(attributeData->magnitude);
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_FLOAT_ARRAY,
            HASH_ATTRIBUTE_MAGNITUDE,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_FLOAT_ARRAY, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ( (attributeData->present_attributes & float_array__AttributeData::ATTRIBUTE_COUNT_PRESENT) == 0 )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_FLOAT_ARRAY, HASH_ATTRIBUTE_COUNT, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__float_array()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__float_array();
        if ( !validationResult ) return false;

    } // validation
#endif

#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
bool returnValue = floatDataEnd( &ColladaParserAutoGen15::data__float_array, 0, 0, 0 );
        return returnValue;
    }
    else
    {
return floatDataEnd( &ColladaParserAutoGen15::data__float_array );
    }
#else
    {
return floatDataEnd( &ColladaParserAutoGen15::data__float_array );
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__float_array( void* attributeData )
{
    float_array__AttributeData* typedAttributeData = static_cast<float_array__AttributeData*>(attributeData);

    typedAttributeData->~float_array__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const int_array__AttributeData int_array__AttributeData::DEFAULT = {0, 0, 0, 0, -2147483647-1, 2147483647};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__int_array( const ParserChar* text, size_t textLength )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
return characterData2Sint64Data(text, textLength, &ColladaParserAutoGen15::data__int_array, 0, 0, 0);
    }
    else
    {
return characterData2Sint64Data(text, textLength, &ColladaParserAutoGen15::data__int_array);
    }
#else
    {
return characterData2Sint64Data(text, textLength, &ColladaParserAutoGen15::data__int_array);
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__int_array( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__int_array( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

int_array__AttributeData* attributeData = newData<int_array__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_ID:
    {

attributeData->id = attributeValue;

    break;
    }
    case HASH_ATTRIBUTE_NAME:
    {

attributeData->name = attributeValue;

    break;
    }
    case HASH_ATTRIBUTE_COUNT:
    {
bool failed;
attributeData->count = GeneratedSaxParser::Utils::toUint64(attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_INT_ARRAY,
        HASH_ATTRIBUTE_COUNT,
        attributeValue))
{
    return false;
}
if ( !failed )
    attributeData->present_attributes |= int_array__AttributeData::ATTRIBUTE_COUNT_PRESENT;

    break;
    }
    case HASH_ATTRIBUTE_MININCLUSIVE:
    {
bool failed;
attributeData->minInclusive = GeneratedSaxParser::Utils::toSint64(attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_INT_ARRAY,
        HASH_ATTRIBUTE_MININCLUSIVE,
        attributeValue))
{
    return false;
}

    break;
    }
    case HASH_ATTRIBUTE_MAXINCLUSIVE:
    {
bool failed;
attributeData->maxInclusive = GeneratedSaxParser::Utils::toSint64(attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_INT_ARRAY,
        HASH_ATTRIBUTE_MAXINCLUSIVE,
        attributeValue))
{
    return false;
}

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_INT_ARRAY, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ( (attributeData->present_attributes & int_array__AttributeData::ATTRIBUTE_COUNT_PRESENT) == 0 )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_INT_ARRAY, HASH_ATTRIBUTE_COUNT, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__int_array()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__int_array();
        if ( !validationResult ) return false;

    } // validation
#endif

#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
bool returnValue = sint64DataEnd( &ColladaParserAutoGen15::data__int_array, 0, 0, 0 );
        return returnValue;
    }
    else
    {
return sint64DataEnd( &ColladaParserAutoGen15::data__int_array );
    }
#else
    {
return sint64DataEnd( &ColladaParserAutoGen15::data__int_array );
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__int_array( void* attributeData )
{
    int_array__AttributeData* typedAttributeData = static_cast<int_array__AttributeData*>(attributeData);

    typedAttributeData->~int_array__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const SIDREF_array__AttributeData SIDREF_array__AttributeData::DEFAULT = {0, 0, 0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__SIDREF_array( const ParserChar* text, size_t textLength )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
return characterData2StringData(text, textLength, &ColladaParserAutoGen15::data__SIDREF_array, 0, 0, &validate__sidref_type);
    }
    else
    {
return characterData2StringData(text, textLength, &ColladaParserAutoGen15::data__SIDREF_array);
    }
#else
    {
return characterData2StringData(text, textLength, &ColladaParserAutoGen15::data__SIDREF_array);
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__SIDREF_array( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__SIDREF_array( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

SIDREF_array__AttributeData* attributeData = newData<SIDREF_array__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_ID:
    {

attributeData->id = attributeValue;

    break;
    }
    case HASH_ATTRIBUTE_NAME:
    {

attributeData->name = attributeValue;

    break;
    }
    case HASH_ATTRIBUTE_COUNT:
    {
bool failed;
attributeData->count = GeneratedSaxParser::Utils::toUint64(attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_SIDREF_ARRAY,
        HASH_ATTRIBUTE_COUNT,
        attributeValue))
{
    return false;
}
if ( !failed )
    attributeData->present_attributes |= SIDREF_array__AttributeData::ATTRIBUTE_COUNT_PRESENT;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_SIDREF_ARRAY, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ( (attributeData->present_attributes & SIDREF_array__AttributeData::ATTRIBUTE_COUNT_PRESENT) == 0 )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_SIDREF_ARRAY, HASH_ATTRIBUTE_COUNT, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__SIDREF_array()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__SIDREF_array();
        if ( !validationResult ) return false;

    } // validation
#endif

#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
bool returnValue = stringListDataEnd( &ColladaParserAutoGen15::data__SIDREF_array, 0, 0, &validate__sidref_type );
        return returnValue;
    }
    else
    {
return stringListDataEnd( &ColladaParserAutoGen15::data__SIDREF_array );
    }
#else
    {
return stringListDataEnd( &ColladaParserAutoGen15::data__SIDREF_array );
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__SIDREF_array( void* attributeData )
{
    SIDREF_array__AttributeData* typedAttributeData = static_cast<SIDREF_array__AttributeData*>(attributeData);

    typedAttributeData->~SIDREF_array__AttributeData();

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__source_type____technique_common( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__source_type____technique_common( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__source_type____technique_common( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__source_type____technique_common()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__source_type____technique_common();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__source_type____technique_common( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
const accessor__AttributeData accessor__AttributeData::DEFAULT = {0, 0, 0, 0, 1};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__accessor( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__accessor( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__accessor( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

accessor__AttributeData* attributeData = newData<accessor__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_COUNT:
    {
bool failed;
attributeData->count = GeneratedSaxParser::Utils::toUint64(attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_ACCESSOR,
        HASH_ATTRIBUTE_COUNT,
        attributeValue))
{
    return false;
}
if ( !failed )
    attributeData->present_attributes |= accessor__AttributeData::ATTRIBUTE_COUNT_PRESENT;

    break;
    }
    case HASH_ATTRIBUTE_OFFSET:
    {
bool failed;
attributeData->offset = GeneratedSaxParser::Utils::toUint64(attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_ACCESSOR,
        HASH_ATTRIBUTE_OFFSET,
        attributeValue))
{
    return false;
}

    break;
    }
    case HASH_ATTRIBUTE_SOURCE:
    {
bool failed;
attributeData->source = GeneratedSaxParser::Utils::toURI(&attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_ACCESSOR,
        HASH_ATTRIBUTE_SOURCE,
        attributeValue))
{
    return false;
}
if ( !failed )
    attributeData->present_attributes |= accessor__AttributeData::ATTRIBUTE_SOURCE_PRESENT;

    break;
    }
    case HASH_ATTRIBUTE_STRIDE:
    {
bool failed;
attributeData->stride = GeneratedSaxParser::Utils::toUint64(attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_ACCESSOR,
        HASH_ATTRIBUTE_STRIDE,
        attributeValue))
{
    return false;
}

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_ACCESSOR, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ((attributeData->present_attributes & accessor__AttributeData::ATTRIBUTE_SOURCE_PRESENT) == 0)
{
    attributeData->source = COLLADABU::URI("");
}
if ( (attributeData->present_attributes & accessor__AttributeData::ATTRIBUTE_COUNT_PRESENT) == 0 )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_ACCESSOR, HASH_ATTRIBUTE_COUNT, 0 ) )
        return false;
}
if ( (attributeData->present_attributes & accessor__AttributeData::ATTRIBUTE_SOURCE_PRESENT) == 0 )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_ACCESSOR, HASH_ATTRIBUTE_SOURCE, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__accessor()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__accessor();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__accessor( void* attributeData )
{
    accessor__AttributeData* typedAttributeData = static_cast<accessor__AttributeData*>(attributeData);

    typedAttributeData->~accessor__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const param____param_type__AttributeData param____param_type__AttributeData::DEFAULT = {0, 0, 0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__param____param_type( const ParserChar* text, size_t textLength )
{

return mImpl->data__param____param_type(text, textLength);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__param____param_type( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__param____param_type( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

param____param_type__AttributeData* attributeData = newData<param____param_type__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_NAME:
    {

attributeData->name = attributeValue;

    break;
    }
    case HASH_ATTRIBUTE_SID:
    {

attributeData->sid = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__sid_type(attributeData->sid, strlen(attributeData->sid));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_PARAM,
            HASH_ATTRIBUTE_SID,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    case HASH_ATTRIBUTE_SEMANTIC:
    {

attributeData->semantic = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NMTOKEN(attributeData->semantic, strlen(attributeData->semantic));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_PARAM,
            HASH_ATTRIBUTE_SEMANTIC,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    case HASH_ATTRIBUTE_TYPE:
    {

attributeData->type = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NMTOKEN(attributeData->type, strlen(attributeData->type));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_PARAM,
            HASH_ATTRIBUTE_TYPE,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_PARAM, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ( !attributeData->type )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_PARAM, HASH_ATTRIBUTE_TYPE, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__param____param_type()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__param____param_type();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__param____param_type( void* attributeData )
{
    param____param_type__AttributeData* typedAttributeData = static_cast<param____param_type__AttributeData*>(attributeData);

    typedAttributeData->~param____param_type__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const sampler__AttributeData sampler__AttributeData::DEFAULT = {0, ENUM__sampler_behavior_enum__NOT_PRESENT, ENUM__sampler_behavior_enum__NOT_PRESENT};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__sampler( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__sampler( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__sampler( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

sampler__AttributeData* attributeData = newData<sampler__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_ID:
    {

attributeData->id = attributeValue;

    break;
    }
    case HASH_ATTRIBUTE_PRE_BEHAVIOR:
    {
bool failed;
attributeData->pre_behavior = Utils::toEnum<ENUM__sampler_behavior_enum, StringHash, ENUM__sampler_behavior_enum__COUNT>(attributeValue, failed, ENUM__sampler_behavior_enumMap, Utils::calculateStringHash);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_SAMPLER,
        HASH_ATTRIBUTE_PRE_BEHAVIOR,
        attributeValue))
{
    return false;
}

    break;
    }
    case HASH_ATTRIBUTE_POST_BEHAVIOR:
    {
bool failed;
attributeData->post_behavior = Utils::toEnum<ENUM__sampler_behavior_enum, StringHash, ENUM__sampler_behavior_enum__COUNT>(attributeValue, failed, ENUM__sampler_behavior_enumMap, Utils::calculateStringHash);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_SAMPLER,
        HASH_ATTRIBUTE_POST_BEHAVIOR,
        attributeValue))
{
    return false;
}

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_SAMPLER, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__sampler()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__sampler();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__sampler( void* attributeData )
{
    sampler__AttributeData* typedAttributeData = static_cast<sampler__AttributeData*>(attributeData);

    typedAttributeData->~sampler__AttributeData();

    return true;
}

//---------------------------------------------------------------------
ENUM__sampler_behavior_enum ColladaParserAutoGen15Private::toEnumDataPrefix_ENUM__sampler_behavior_enum (
    const ParserChar* prefixedBuffer,
    const ParserChar* prefixedBufferEnd,
    const ParserChar** buffer,
    const ParserChar* bufferEnd,
    bool& failed,
    const std::pair<StringHash, ENUM__sampler_behavior_enum>* enumMap,
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& )
)
{
    return toEnumDataPrefix<ENUM__sampler_behavior_enum, StringHash, ENUM__sampler_behavior_enum__COUNT, &toEnum_ENUM__sampler_behavior_enum>(prefixedBuffer, prefixedBufferEnd, buffer, bufferEnd, failed, enumMap, baseConversionFunc);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::characterData2EnumData_ENUM__sampler_behavior_enum (
    const ParserChar* text,
    size_t textLength,
    bool ( ColladaParserAutoGen15::*dataFunction )(const ENUM__sampler_behavior_enum*, size_t ),
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& )
)
{
    return characterData2EnumData<ENUM__sampler_behavior_enum, StringHash, ENUM__sampler_behavior_enum__COUNT>(text, textLength, dataFunction, ENUM__sampler_behavior_enumMap, baseConversionFunc, &toEnum_ENUM__sampler_behavior_enum, &ColladaParserAutoGen15Private::toEnumDataPrefix_ENUM__sampler_behavior_enum);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::dataEnumEnd_ENUM__sampler_behavior_enum (
    bool ( ColladaParserAutoGen15::*dataFunction )(const ENUM__sampler_behavior_enum*, size_t ),
    const std::pair<StringHash, ENUM__sampler_behavior_enum>* enumMap,
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& ),
    ENUM__sampler_behavior_enum (*toEnumFunc)( const ParserChar**, const ParserChar*, bool&, const std::pair<StringHash, ENUM__sampler_behavior_enum>* enumMap, StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& ))
)
{
    return dataEnumEnd<ENUM__sampler_behavior_enum, StringHash, ENUM__sampler_behavior_enum__COUNT>(dataFunction, enumMap, baseConversionFunc, toEnumFunc);
}

//---------------------------------------------------------------------
const input____input_local_type__AttributeData input____input_local_type__AttributeData::DEFAULT = {0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__input____input_local_type( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__input____input_local_type( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__input____input_local_type( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

input____input_local_type__AttributeData* attributeData = newData<input____input_local_type__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_SEMANTIC:
    {

attributeData->semantic = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NMTOKEN(attributeData->semantic, strlen(attributeData->semantic));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_INPUT,
            HASH_ATTRIBUTE_SEMANTIC,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    case HASH_ATTRIBUTE_SOURCE:
    {

attributeData->source = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__urifragment_type(attributeData->source, strlen(attributeData->source));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_INPUT,
            HASH_ATTRIBUTE_SOURCE,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_INPUT, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ( !attributeData->semantic )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_INPUT, HASH_ATTRIBUTE_SEMANTIC, 0 ) )
        return false;
}
if ( !attributeData->source )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_INPUT, HASH_ATTRIBUTE_SOURCE, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__input____input_local_type()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__input____input_local_type();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__input____input_local_type( void* attributeData )
{
    input____input_local_type__AttributeData* typedAttributeData = static_cast<input____input_local_type__AttributeData*>(attributeData);

    typedAttributeData->~input____input_local_type__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const channel__AttributeData channel__AttributeData::DEFAULT = {0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__channel( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__channel( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__channel( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

channel__AttributeData* attributeData = newData<channel__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_SOURCE:
    {

attributeData->source = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__urifragment_type(attributeData->source, strlen(attributeData->source));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_CHANNEL,
            HASH_ATTRIBUTE_SOURCE,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    case HASH_ATTRIBUTE_TARGET:
    {

attributeData->target = attributeValue;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_CHANNEL, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ( !attributeData->source )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_CHANNEL, HASH_ATTRIBUTE_SOURCE, 0 ) )
        return false;
}
if ( !attributeData->target )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_CHANNEL, HASH_ATTRIBUTE_TARGET, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__channel()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__channel();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__channel( void* attributeData )
{
    channel__AttributeData* typedAttributeData = static_cast<channel__AttributeData*>(attributeData);

    typedAttributeData->~channel__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const library_animation_clips__AttributeData library_animation_clips__AttributeData::DEFAULT = {0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__library_animation_clips( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__library_animation_clips( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__library_animation_clips( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

library_animation_clips__AttributeData* attributeData = newData<library_animation_clips__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_ID:
    {

attributeData->id = attributeValue;

    break;
    }
    case HASH_ATTRIBUTE_NAME:
    {

attributeData->name = attributeValue;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_LIBRARY_ANIMATION_CLIPS, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__library_animation_clips()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__library_animation_clips();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__library_animation_clips( void* attributeData )
{
    library_animation_clips__AttributeData* typedAttributeData = static_cast<library_animation_clips__AttributeData*>(attributeData);

    typedAttributeData->~library_animation_clips__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const animation_clip__AttributeData animation_clip__AttributeData::DEFAULT = {0, 0, 0, 0.0E1, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__animation_clip( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__animation_clip( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__animation_clip( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

animation_clip__AttributeData* attributeData = newData<animation_clip__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_ID:
    {

attributeData->id = attributeValue;

    break;
    }
    case HASH_ATTRIBUTE_NAME:
    {

attributeData->name = attributeValue;

    break;
    }
    case HASH_ATTRIBUTE_START:
    {
bool failed;
attributeData->start = GeneratedSaxParser::Utils::toFloat(attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_ANIMATION_CLIP,
        HASH_ATTRIBUTE_START,
        attributeValue))
{
    return false;
}

    break;
    }
    case HASH_ATTRIBUTE_END:
    {
bool failed;
attributeData->end = GeneratedSaxParser::Utils::toFloat(attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_ANIMATION_CLIP,
        HASH_ATTRIBUTE_END,
        attributeValue))
{
    return false;
}
if ( !failed )
    attributeData->present_attributes |= animation_clip__AttributeData::ATTRIBUTE_END_PRESENT;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_ANIMATION_CLIP, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__animation_clip()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__animation_clip();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__animation_clip( void* attributeData )
{
    animation_clip__AttributeData* typedAttributeData = static_cast<animation_clip__AttributeData*>(attributeData);

    typedAttributeData->~animation_clip__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const instance_animation__AttributeData instance_animation__AttributeData::DEFAULT = {0, 0, 0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__instance_animation( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__instance_animation( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__instance_animation( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

instance_animation__AttributeData* attributeData = newData<instance_animation__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_URL:
    {
bool failed;
attributeData->url = GeneratedSaxParser::Utils::toURI(&attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_INSTANCE_ANIMATION,
        HASH_ATTRIBUTE_URL,
        attributeValue))
{
    return false;
}
if ( !failed )
    attributeData->present_attributes |= instance_animation__AttributeData::ATTRIBUTE_URL_PRESENT;

    break;
    }
    case HASH_ATTRIBUTE_SID:
    {

attributeData->sid = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__sid_type(attributeData->sid, strlen(attributeData->sid));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_INSTANCE_ANIMATION,
            HASH_ATTRIBUTE_SID,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    case HASH_ATTRIBUTE_NAME:
    {

attributeData->name = attributeValue;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_INSTANCE_ANIMATION, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ((attributeData->present_attributes & instance_animation__AttributeData::ATTRIBUTE_URL_PRESENT) == 0)
{
    attributeData->url = COLLADABU::URI("");
}
if ( (attributeData->present_attributes & instance_animation__AttributeData::ATTRIBUTE_URL_PRESENT) == 0 )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_INSTANCE_ANIMATION, HASH_ATTRIBUTE_URL, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__instance_animation()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__instance_animation();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__instance_animation( void* attributeData )
{
    instance_animation__AttributeData* typedAttributeData = static_cast<instance_animation__AttributeData*>(attributeData);

    typedAttributeData->~instance_animation__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const instance_formula__AttributeData instance_formula__AttributeData::DEFAULT = {0, 0, 0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__instance_formula( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__instance_formula( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__instance_formula( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

instance_formula__AttributeData* attributeData = newData<instance_formula__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_SID:
    {

attributeData->sid = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__sid_type(attributeData->sid, strlen(attributeData->sid));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_INSTANCE_FORMULA,
            HASH_ATTRIBUTE_SID,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    case HASH_ATTRIBUTE_NAME:
    {

attributeData->name = attributeValue;

    break;
    }
    case HASH_ATTRIBUTE_URL:
    {
bool failed;
attributeData->url = GeneratedSaxParser::Utils::toURI(&attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_INSTANCE_FORMULA,
        HASH_ATTRIBUTE_URL,
        attributeValue))
{
    return false;
}
if ( !failed )
    attributeData->present_attributes |= instance_formula__AttributeData::ATTRIBUTE_URL_PRESENT;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_INSTANCE_FORMULA, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ((attributeData->present_attributes & instance_formula__AttributeData::ATTRIBUTE_URL_PRESENT) == 0)
{
    attributeData->url = COLLADABU::URI("");
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__instance_formula()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__instance_formula();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__instance_formula( void* attributeData )
{
    instance_formula__AttributeData* typedAttributeData = static_cast<instance_formula__AttributeData*>(attributeData);

    typedAttributeData->~instance_formula__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const setparam____formula_setparam_type__AttributeData setparam____formula_setparam_type__AttributeData::DEFAULT = {0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__setparam____formula_setparam_type( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__setparam____formula_setparam_type( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__setparam____formula_setparam_type( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

setparam____formula_setparam_type__AttributeData* attributeData = newData<setparam____formula_setparam_type__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_REF:
    {

attributeData->ref = attributeValue;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_SETPARAM, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ( !attributeData->ref )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_SETPARAM, HASH_ATTRIBUTE_REF, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__setparam____formula_setparam_type()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__setparam____formula_setparam_type();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__setparam____formula_setparam_type( void* attributeData )
{
    setparam____formula_setparam_type__AttributeData* typedAttributeData = static_cast<setparam____formula_setparam_type__AttributeData*>(attributeData);

    typedAttributeData->~setparam____formula_setparam_type__AttributeData();

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__float____float_type( const ParserChar* text, size_t textLength )
{
if (!mLastIncompleteFragmentInCharacterData)
{
    mLastIncompleteFragmentInCharacterData = (ParserChar*)mStackMemoryManager.newObject(textLength);
    memcpy(mLastIncompleteFragmentInCharacterData, text, textLength);
    mEndOfDataInCurrentObjectOnStack = mLastIncompleteFragmentInCharacterData + textLength;
}
else
{
    ParserChar* tmp = (ParserChar*)mStackMemoryManager.growObject(textLength);
    if ( tmp != mLastIncompleteFragmentInCharacterData ) {
        mEndOfDataInCurrentObjectOnStack = (mEndOfDataInCurrentObjectOnStack - mLastIncompleteFragmentInCharacterData) + tmp;
        mLastIncompleteFragmentInCharacterData = tmp;
    }
    memcpy(mEndOfDataInCurrentObjectOnStack, text, textLength);
    mEndOfDataInCurrentObjectOnStack += textLength;
}
return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__float____float_type( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__float____float_type( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__float____float_type()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__float____float_type();
        if ( !validationResult ) return false;

    } // validation
#endif

bool failed;
const ParserChar* ptrForErr = mLastIncompleteFragmentInCharacterData;
DISABLE_WARNING_UNUSED(ptrForErr)
float parameter = GeneratedSaxParser::Utils::toFloat((const ParserChar**)&mLastIncompleteFragmentInCharacterData, mEndOfDataInCurrentObjectOnStack, failed);
bool returnValue;
if (!failed)
{
    returnValue = mImpl->data__float____float_type(parameter);
}
else
    returnValue = !handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_TEXTDATA_PARSING_FAILED, HASH_ELEMENT_FLOAT, (const ParserChar*)0, mLastIncompleteFragmentInCharacterData);
if (mLastIncompleteFragmentInCharacterData)
    mStackMemoryManager.deleteObject();
mLastIncompleteFragmentInCharacterData = 0;
mEndOfDataInCurrentObjectOnStack = 0;
return returnValue;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__float____float_type( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__int____int_type( const ParserChar* text, size_t textLength )
{
if (!mLastIncompleteFragmentInCharacterData)
{
    mLastIncompleteFragmentInCharacterData = (ParserChar*)mStackMemoryManager.newObject(textLength);
    memcpy(mLastIncompleteFragmentInCharacterData, text, textLength);
    mEndOfDataInCurrentObjectOnStack = mLastIncompleteFragmentInCharacterData + textLength;
}
else
{
    ParserChar* tmp = (ParserChar*)mStackMemoryManager.growObject(textLength);
    if ( tmp != mLastIncompleteFragmentInCharacterData ) {
        mEndOfDataInCurrentObjectOnStack = (mEndOfDataInCurrentObjectOnStack - mLastIncompleteFragmentInCharacterData) + tmp;
        mLastIncompleteFragmentInCharacterData = tmp;
    }
    memcpy(mEndOfDataInCurrentObjectOnStack, text, textLength);
    mEndOfDataInCurrentObjectOnStack += textLength;
}
return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__int____int_type( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__int____int_type( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__int____int_type()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__int____int_type();
        if ( !validationResult ) return false;

    } // validation
#endif

bool failed;
const ParserChar* ptrForErr = mLastIncompleteFragmentInCharacterData;
DISABLE_WARNING_UNUSED(ptrForErr)
sint64 parameter = GeneratedSaxParser::Utils::toSint64((const ParserChar**)&mLastIncompleteFragmentInCharacterData, mEndOfDataInCurrentObjectOnStack, failed);
bool returnValue;
if (!failed)
{
    returnValue = mImpl->data__int____int_type(parameter);
}
else
    returnValue = !handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_TEXTDATA_PARSING_FAILED, HASH_ELEMENT_INT, (const ParserChar*)0, mLastIncompleteFragmentInCharacterData);
if (mLastIncompleteFragmentInCharacterData)
    mStackMemoryManager.deleteObject();
mLastIncompleteFragmentInCharacterData = 0;
mEndOfDataInCurrentObjectOnStack = 0;
return returnValue;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__int____int_type( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__SIDREF( const ParserChar* text, size_t textLength )
{
if (!mLastIncompleteFragmentInCharacterData)
{
    mLastIncompleteFragmentInCharacterData = (ParserChar*)mStackMemoryManager.newObject(textLength);
    memcpy(mLastIncompleteFragmentInCharacterData, text, textLength);
    mEndOfDataInCurrentObjectOnStack = mLastIncompleteFragmentInCharacterData + textLength;
}
else
{
    ParserChar* tmp = (ParserChar*)mStackMemoryManager.growObject(textLength);
    if ( tmp != mLastIncompleteFragmentInCharacterData ) {
        mEndOfDataInCurrentObjectOnStack = (mEndOfDataInCurrentObjectOnStack - mLastIncompleteFragmentInCharacterData) + tmp;
        mLastIncompleteFragmentInCharacterData = tmp;
    }
    memcpy(mEndOfDataInCurrentObjectOnStack, text, textLength);
    mEndOfDataInCurrentObjectOnStack += textLength;
}
return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__SIDREF( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__SIDREF( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__SIDREF()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__SIDREF();
        if ( !validationResult ) return false;

    } // validation
#endif

bool returnValue = true;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
ParserError::ErrorType simpleTypeValidationResult = validate__sidref_type(mLastIncompleteFragmentInCharacterData, mEndOfDataInCurrentObjectOnStack - mLastIncompleteFragmentInCharacterData);
if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
{
    ParserChar msg[21];
    Utils::fillErrorMsg(msg, mLastIncompleteFragmentInCharacterData, 20);
    if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        simpleTypeValidationResult,
        0,
        msg) )
    {
        returnValue =  false;
    }
}
if (!returnValue)
{
    mStackMemoryManager.deleteObject();
    mLastIncompleteFragmentInCharacterData = 0;
    mEndOfDataInCurrentObjectOnStack = 0;
    return returnValue;
}
    } // validation
#endif
returnValue = mImpl->data__SIDREF(mLastIncompleteFragmentInCharacterData, mEndOfDataInCurrentObjectOnStack - mLastIncompleteFragmentInCharacterData);
mStackMemoryManager.deleteObject();
mLastIncompleteFragmentInCharacterData = 0;
mEndOfDataInCurrentObjectOnStack = 0;
return returnValue;

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__SIDREF( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__bool( const ParserChar* text, size_t textLength )
{
if (!mLastIncompleteFragmentInCharacterData)
{
    mLastIncompleteFragmentInCharacterData = (ParserChar*)mStackMemoryManager.newObject(textLength);
    memcpy(mLastIncompleteFragmentInCharacterData, text, textLength);
    mEndOfDataInCurrentObjectOnStack = mLastIncompleteFragmentInCharacterData + textLength;
}
else
{
    ParserChar* tmp = (ParserChar*)mStackMemoryManager.growObject(textLength);
    if ( tmp != mLastIncompleteFragmentInCharacterData ) {
        mEndOfDataInCurrentObjectOnStack = (mEndOfDataInCurrentObjectOnStack - mLastIncompleteFragmentInCharacterData) + tmp;
        mLastIncompleteFragmentInCharacterData = tmp;
    }
    memcpy(mEndOfDataInCurrentObjectOnStack, text, textLength);
    mEndOfDataInCurrentObjectOnStack += textLength;
}
return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__bool( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__bool( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__bool()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__bool();
        if ( !validationResult ) return false;

    } // validation
#endif

bool failed;
const ParserChar* ptrForErr = mLastIncompleteFragmentInCharacterData;
DISABLE_WARNING_UNUSED(ptrForErr)
bool parameter = GeneratedSaxParser::Utils::toBool((const ParserChar**)&mLastIncompleteFragmentInCharacterData, mEndOfDataInCurrentObjectOnStack, failed);
bool returnValue;
if (!failed)
{
    returnValue = mImpl->data__bool(parameter);
}
else
    returnValue = !handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_TEXTDATA_PARSING_FAILED, HASH_ELEMENT_BOOL, (const ParserChar*)0, mLastIncompleteFragmentInCharacterData);
if (mLastIncompleteFragmentInCharacterData)
    mStackMemoryManager.deleteObject();
mLastIncompleteFragmentInCharacterData = 0;
mEndOfDataInCurrentObjectOnStack = 0;
return returnValue;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__bool( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
const connect_param__AttributeData connect_param__AttributeData::DEFAULT = {0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__connect_param( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__connect_param( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__connect_param( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

connect_param__AttributeData* attributeData = newData<connect_param__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_REF:
    {

attributeData->ref = attributeValue;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_CONNECT_PARAM, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ( !attributeData->ref )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_CONNECT_PARAM, HASH_ATTRIBUTE_REF, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__connect_param()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__connect_param();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__connect_param( void* attributeData )
{
    connect_param__AttributeData* typedAttributeData = static_cast<connect_param__AttributeData*>(attributeData);

    typedAttributeData->~connect_param__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const library_cameras__AttributeData library_cameras__AttributeData::DEFAULT = {0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__library_cameras( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__library_cameras( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__library_cameras( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

library_cameras__AttributeData* attributeData = newData<library_cameras__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_ID:
    {

attributeData->id = attributeValue;

    break;
    }
    case HASH_ATTRIBUTE_NAME:
    {

attributeData->name = attributeValue;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_LIBRARY_CAMERAS, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__library_cameras()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__library_cameras();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__library_cameras( void* attributeData )
{
    library_cameras__AttributeData* typedAttributeData = static_cast<library_cameras__AttributeData*>(attributeData);

    typedAttributeData->~library_cameras__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const camera__AttributeData camera__AttributeData::DEFAULT = {0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__camera( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__camera( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__camera( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

camera__AttributeData* attributeData = newData<camera__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_ID:
    {

attributeData->id = attributeValue;

    break;
    }
    case HASH_ATTRIBUTE_NAME:
    {

attributeData->name = attributeValue;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_CAMERA, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__camera()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__camera();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__camera( void* attributeData )
{
    camera__AttributeData* typedAttributeData = static_cast<camera__AttributeData*>(attributeData);

    typedAttributeData->~camera__AttributeData();

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__optics( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__optics( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__optics( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__optics()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__optics();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__optics( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__optics__technique_common( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__optics__technique_common( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__optics__technique_common( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__optics__technique_common()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__optics__technique_common();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__optics__technique_common( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__orthographic( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__orthographic( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__orthographic( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__orthographic()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__orthographic();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__orthographic( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
const xmag__AttributeData xmag__AttributeData::DEFAULT = {0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__xmag( const ParserChar* text, size_t textLength )
{
if (!mLastIncompleteFragmentInCharacterData)
{
    mLastIncompleteFragmentInCharacterData = (ParserChar*)mStackMemoryManager.newObject(textLength);
    memcpy(mLastIncompleteFragmentInCharacterData, text, textLength);
    mEndOfDataInCurrentObjectOnStack = mLastIncompleteFragmentInCharacterData + textLength;
}
else
{
    ParserChar* tmp = (ParserChar*)mStackMemoryManager.growObject(textLength);
    if ( tmp != mLastIncompleteFragmentInCharacterData ) {
        mEndOfDataInCurrentObjectOnStack = (mEndOfDataInCurrentObjectOnStack - mLastIncompleteFragmentInCharacterData) + tmp;
        mLastIncompleteFragmentInCharacterData = tmp;
    }
    memcpy(mEndOfDataInCurrentObjectOnStack, text, textLength);
    mEndOfDataInCurrentObjectOnStack += textLength;
}
return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__xmag( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__xmag( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

xmag__AttributeData* attributeData = newData<xmag__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_SID:
    {

attributeData->sid = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__sid_type(attributeData->sid, strlen(attributeData->sid));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_XMAG,
            HASH_ATTRIBUTE_SID,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_XMAG, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__xmag()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__xmag();
        if ( !validationResult ) return false;

    } // validation
#endif

bool failed;
const ParserChar* ptrForErr = mLastIncompleteFragmentInCharacterData;
DISABLE_WARNING_UNUSED(ptrForErr)
float parameter = GeneratedSaxParser::Utils::toFloat((const ParserChar**)&mLastIncompleteFragmentInCharacterData, mEndOfDataInCurrentObjectOnStack, failed);
bool returnValue;
if (!failed)
{
    returnValue = mImpl->data__xmag(parameter);
}
else
    returnValue = !handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_TEXTDATA_PARSING_FAILED, HASH_ELEMENT_XMAG, (const ParserChar*)0, mLastIncompleteFragmentInCharacterData);
if (mLastIncompleteFragmentInCharacterData)
    mStackMemoryManager.deleteObject();
mLastIncompleteFragmentInCharacterData = 0;
mEndOfDataInCurrentObjectOnStack = 0;
return returnValue;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__xmag( void* attributeData )
{
    xmag__AttributeData* typedAttributeData = static_cast<xmag__AttributeData*>(attributeData);

    typedAttributeData->~xmag__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const ymag__AttributeData ymag__AttributeData::DEFAULT = {0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__ymag( const ParserChar* text, size_t textLength )
{
if (!mLastIncompleteFragmentInCharacterData)
{
    mLastIncompleteFragmentInCharacterData = (ParserChar*)mStackMemoryManager.newObject(textLength);
    memcpy(mLastIncompleteFragmentInCharacterData, text, textLength);
    mEndOfDataInCurrentObjectOnStack = mLastIncompleteFragmentInCharacterData + textLength;
}
else
{
    ParserChar* tmp = (ParserChar*)mStackMemoryManager.growObject(textLength);
    if ( tmp != mLastIncompleteFragmentInCharacterData ) {
        mEndOfDataInCurrentObjectOnStack = (mEndOfDataInCurrentObjectOnStack - mLastIncompleteFragmentInCharacterData) + tmp;
        mLastIncompleteFragmentInCharacterData = tmp;
    }
    memcpy(mEndOfDataInCurrentObjectOnStack, text, textLength);
    mEndOfDataInCurrentObjectOnStack += textLength;
}
return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__ymag( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__ymag( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

ymag__AttributeData* attributeData = newData<ymag__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_SID:
    {

attributeData->sid = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__sid_type(attributeData->sid, strlen(attributeData->sid));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_YMAG,
            HASH_ATTRIBUTE_SID,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_YMAG, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__ymag()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__ymag();
        if ( !validationResult ) return false;

    } // validation
#endif

bool failed;
const ParserChar* ptrForErr = mLastIncompleteFragmentInCharacterData;
DISABLE_WARNING_UNUSED(ptrForErr)
float parameter = GeneratedSaxParser::Utils::toFloat((const ParserChar**)&mLastIncompleteFragmentInCharacterData, mEndOfDataInCurrentObjectOnStack, failed);
bool returnValue;
if (!failed)
{
    returnValue = mImpl->data__ymag(parameter);
}
else
    returnValue = !handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_TEXTDATA_PARSING_FAILED, HASH_ELEMENT_YMAG, (const ParserChar*)0, mLastIncompleteFragmentInCharacterData);
if (mLastIncompleteFragmentInCharacterData)
    mStackMemoryManager.deleteObject();
mLastIncompleteFragmentInCharacterData = 0;
mEndOfDataInCurrentObjectOnStack = 0;
return returnValue;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__ymag( void* attributeData )
{
    ymag__AttributeData* typedAttributeData = static_cast<ymag__AttributeData*>(attributeData);

    typedAttributeData->~ymag__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const aspect_ratio__AttributeData aspect_ratio__AttributeData::DEFAULT = {0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__aspect_ratio( const ParserChar* text, size_t textLength )
{
if (!mLastIncompleteFragmentInCharacterData)
{
    mLastIncompleteFragmentInCharacterData = (ParserChar*)mStackMemoryManager.newObject(textLength);
    memcpy(mLastIncompleteFragmentInCharacterData, text, textLength);
    mEndOfDataInCurrentObjectOnStack = mLastIncompleteFragmentInCharacterData + textLength;
}
else
{
    ParserChar* tmp = (ParserChar*)mStackMemoryManager.growObject(textLength);
    if ( tmp != mLastIncompleteFragmentInCharacterData ) {
        mEndOfDataInCurrentObjectOnStack = (mEndOfDataInCurrentObjectOnStack - mLastIncompleteFragmentInCharacterData) + tmp;
        mLastIncompleteFragmentInCharacterData = tmp;
    }
    memcpy(mEndOfDataInCurrentObjectOnStack, text, textLength);
    mEndOfDataInCurrentObjectOnStack += textLength;
}
return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__aspect_ratio( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__aspect_ratio( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

aspect_ratio__AttributeData* attributeData = newData<aspect_ratio__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_SID:
    {

attributeData->sid = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__sid_type(attributeData->sid, strlen(attributeData->sid));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_ASPECT_RATIO,
            HASH_ATTRIBUTE_SID,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_ASPECT_RATIO, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__aspect_ratio()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__aspect_ratio();
        if ( !validationResult ) return false;

    } // validation
#endif

bool failed;
const ParserChar* ptrForErr = mLastIncompleteFragmentInCharacterData;
DISABLE_WARNING_UNUSED(ptrForErr)
float parameter = GeneratedSaxParser::Utils::toFloat((const ParserChar**)&mLastIncompleteFragmentInCharacterData, mEndOfDataInCurrentObjectOnStack, failed);
bool returnValue;
if (!failed)
{
    returnValue = mImpl->data__aspect_ratio(parameter);
}
else
    returnValue = !handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_TEXTDATA_PARSING_FAILED, HASH_ELEMENT_ASPECT_RATIO, (const ParserChar*)0, mLastIncompleteFragmentInCharacterData);
if (mLastIncompleteFragmentInCharacterData)
    mStackMemoryManager.deleteObject();
mLastIncompleteFragmentInCharacterData = 0;
mEndOfDataInCurrentObjectOnStack = 0;
return returnValue;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__aspect_ratio( void* attributeData )
{
    aspect_ratio__AttributeData* typedAttributeData = static_cast<aspect_ratio__AttributeData*>(attributeData);

    typedAttributeData->~aspect_ratio__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const znear__AttributeData znear__AttributeData::DEFAULT = {0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__znear( const ParserChar* text, size_t textLength )
{
if (!mLastIncompleteFragmentInCharacterData)
{
    mLastIncompleteFragmentInCharacterData = (ParserChar*)mStackMemoryManager.newObject(textLength);
    memcpy(mLastIncompleteFragmentInCharacterData, text, textLength);
    mEndOfDataInCurrentObjectOnStack = mLastIncompleteFragmentInCharacterData + textLength;
}
else
{
    ParserChar* tmp = (ParserChar*)mStackMemoryManager.growObject(textLength);
    if ( tmp != mLastIncompleteFragmentInCharacterData ) {
        mEndOfDataInCurrentObjectOnStack = (mEndOfDataInCurrentObjectOnStack - mLastIncompleteFragmentInCharacterData) + tmp;
        mLastIncompleteFragmentInCharacterData = tmp;
    }
    memcpy(mEndOfDataInCurrentObjectOnStack, text, textLength);
    mEndOfDataInCurrentObjectOnStack += textLength;
}
return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__znear( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__znear( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

znear__AttributeData* attributeData = newData<znear__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_SID:
    {

attributeData->sid = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__sid_type(attributeData->sid, strlen(attributeData->sid));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_ZNEAR,
            HASH_ATTRIBUTE_SID,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_ZNEAR, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__znear()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__znear();
        if ( !validationResult ) return false;

    } // validation
#endif

bool failed;
const ParserChar* ptrForErr = mLastIncompleteFragmentInCharacterData;
DISABLE_WARNING_UNUSED(ptrForErr)
float parameter = GeneratedSaxParser::Utils::toFloat((const ParserChar**)&mLastIncompleteFragmentInCharacterData, mEndOfDataInCurrentObjectOnStack, failed);
bool returnValue;
if (!failed)
{
    returnValue = mImpl->data__znear(parameter);
}
else
    returnValue = !handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_TEXTDATA_PARSING_FAILED, HASH_ELEMENT_ZNEAR, (const ParserChar*)0, mLastIncompleteFragmentInCharacterData);
if (mLastIncompleteFragmentInCharacterData)
    mStackMemoryManager.deleteObject();
mLastIncompleteFragmentInCharacterData = 0;
mEndOfDataInCurrentObjectOnStack = 0;
return returnValue;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__znear( void* attributeData )
{
    znear__AttributeData* typedAttributeData = static_cast<znear__AttributeData*>(attributeData);

    typedAttributeData->~znear__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const zfar__AttributeData zfar__AttributeData::DEFAULT = {0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__zfar( const ParserChar* text, size_t textLength )
{
if (!mLastIncompleteFragmentInCharacterData)
{
    mLastIncompleteFragmentInCharacterData = (ParserChar*)mStackMemoryManager.newObject(textLength);
    memcpy(mLastIncompleteFragmentInCharacterData, text, textLength);
    mEndOfDataInCurrentObjectOnStack = mLastIncompleteFragmentInCharacterData + textLength;
}
else
{
    ParserChar* tmp = (ParserChar*)mStackMemoryManager.growObject(textLength);
    if ( tmp != mLastIncompleteFragmentInCharacterData ) {
        mEndOfDataInCurrentObjectOnStack = (mEndOfDataInCurrentObjectOnStack - mLastIncompleteFragmentInCharacterData) + tmp;
        mLastIncompleteFragmentInCharacterData = tmp;
    }
    memcpy(mEndOfDataInCurrentObjectOnStack, text, textLength);
    mEndOfDataInCurrentObjectOnStack += textLength;
}
return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__zfar( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__zfar( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

zfar__AttributeData* attributeData = newData<zfar__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_SID:
    {

attributeData->sid = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__sid_type(attributeData->sid, strlen(attributeData->sid));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_ZFAR,
            HASH_ATTRIBUTE_SID,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_ZFAR, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__zfar()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__zfar();
        if ( !validationResult ) return false;

    } // validation
#endif

bool failed;
const ParserChar* ptrForErr = mLastIncompleteFragmentInCharacterData;
DISABLE_WARNING_UNUSED(ptrForErr)
float parameter = GeneratedSaxParser::Utils::toFloat((const ParserChar**)&mLastIncompleteFragmentInCharacterData, mEndOfDataInCurrentObjectOnStack, failed);
bool returnValue;
if (!failed)
{
    returnValue = mImpl->data__zfar(parameter);
}
else
    returnValue = !handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_TEXTDATA_PARSING_FAILED, HASH_ELEMENT_ZFAR, (const ParserChar*)0, mLastIncompleteFragmentInCharacterData);
if (mLastIncompleteFragmentInCharacterData)
    mStackMemoryManager.deleteObject();
mLastIncompleteFragmentInCharacterData = 0;
mEndOfDataInCurrentObjectOnStack = 0;
return returnValue;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__zfar( void* attributeData )
{
    zfar__AttributeData* typedAttributeData = static_cast<zfar__AttributeData*>(attributeData);

    typedAttributeData->~zfar__AttributeData();

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__perspective( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__perspective( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__perspective( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__perspective()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__perspective();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__perspective( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
const xfov__AttributeData xfov__AttributeData::DEFAULT = {0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__xfov( const ParserChar* text, size_t textLength )
{
if (!mLastIncompleteFragmentInCharacterData)
{
    mLastIncompleteFragmentInCharacterData = (ParserChar*)mStackMemoryManager.newObject(textLength);
    memcpy(mLastIncompleteFragmentInCharacterData, text, textLength);
    mEndOfDataInCurrentObjectOnStack = mLastIncompleteFragmentInCharacterData + textLength;
}
else
{
    ParserChar* tmp = (ParserChar*)mStackMemoryManager.growObject(textLength);
    if ( tmp != mLastIncompleteFragmentInCharacterData ) {
        mEndOfDataInCurrentObjectOnStack = (mEndOfDataInCurrentObjectOnStack - mLastIncompleteFragmentInCharacterData) + tmp;
        mLastIncompleteFragmentInCharacterData = tmp;
    }
    memcpy(mEndOfDataInCurrentObjectOnStack, text, textLength);
    mEndOfDataInCurrentObjectOnStack += textLength;
}
return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__xfov( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__xfov( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

xfov__AttributeData* attributeData = newData<xfov__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_SID:
    {

attributeData->sid = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__sid_type(attributeData->sid, strlen(attributeData->sid));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_XFOV,
            HASH_ATTRIBUTE_SID,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_XFOV, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__xfov()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__xfov();
        if ( !validationResult ) return false;

    } // validation
#endif

bool failed;
const ParserChar* ptrForErr = mLastIncompleteFragmentInCharacterData;
DISABLE_WARNING_UNUSED(ptrForErr)
float parameter = GeneratedSaxParser::Utils::toFloat((const ParserChar**)&mLastIncompleteFragmentInCharacterData, mEndOfDataInCurrentObjectOnStack, failed);
bool returnValue;
if (!failed)
{
    returnValue = mImpl->data__xfov(parameter);
}
else
    returnValue = !handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_TEXTDATA_PARSING_FAILED, HASH_ELEMENT_XFOV, (const ParserChar*)0, mLastIncompleteFragmentInCharacterData);
if (mLastIncompleteFragmentInCharacterData)
    mStackMemoryManager.deleteObject();
mLastIncompleteFragmentInCharacterData = 0;
mEndOfDataInCurrentObjectOnStack = 0;
return returnValue;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__xfov( void* attributeData )
{
    xfov__AttributeData* typedAttributeData = static_cast<xfov__AttributeData*>(attributeData);

    typedAttributeData->~xfov__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const yfov__AttributeData yfov__AttributeData::DEFAULT = {0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__yfov( const ParserChar* text, size_t textLength )
{
if (!mLastIncompleteFragmentInCharacterData)
{
    mLastIncompleteFragmentInCharacterData = (ParserChar*)mStackMemoryManager.newObject(textLength);
    memcpy(mLastIncompleteFragmentInCharacterData, text, textLength);
    mEndOfDataInCurrentObjectOnStack = mLastIncompleteFragmentInCharacterData + textLength;
}
else
{
    ParserChar* tmp = (ParserChar*)mStackMemoryManager.growObject(textLength);
    if ( tmp != mLastIncompleteFragmentInCharacterData ) {
        mEndOfDataInCurrentObjectOnStack = (mEndOfDataInCurrentObjectOnStack - mLastIncompleteFragmentInCharacterData) + tmp;
        mLastIncompleteFragmentInCharacterData = tmp;
    }
    memcpy(mEndOfDataInCurrentObjectOnStack, text, textLength);
    mEndOfDataInCurrentObjectOnStack += textLength;
}
return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__yfov( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__yfov( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

yfov__AttributeData* attributeData = newData<yfov__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_SID:
    {

attributeData->sid = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__sid_type(attributeData->sid, strlen(attributeData->sid));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_YFOV,
            HASH_ATTRIBUTE_SID,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_YFOV, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__yfov()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__yfov();
        if ( !validationResult ) return false;

    } // validation
#endif

bool failed;
const ParserChar* ptrForErr = mLastIncompleteFragmentInCharacterData;
DISABLE_WARNING_UNUSED(ptrForErr)
float parameter = GeneratedSaxParser::Utils::toFloat((const ParserChar**)&mLastIncompleteFragmentInCharacterData, mEndOfDataInCurrentObjectOnStack, failed);
bool returnValue;
if (!failed)
{
    returnValue = mImpl->data__yfov(parameter);
}
else
    returnValue = !handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_TEXTDATA_PARSING_FAILED, HASH_ELEMENT_YFOV, (const ParserChar*)0, mLastIncompleteFragmentInCharacterData);
if (mLastIncompleteFragmentInCharacterData)
    mStackMemoryManager.deleteObject();
mLastIncompleteFragmentInCharacterData = 0;
mEndOfDataInCurrentObjectOnStack = 0;
return returnValue;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__yfov( void* attributeData )
{
    yfov__AttributeData* typedAttributeData = static_cast<yfov__AttributeData*>(attributeData);

    typedAttributeData->~yfov__AttributeData();

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__imager( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__imager( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__imager( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__imager()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__imager();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__imager( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
const library_controllers__AttributeData library_controllers__AttributeData::DEFAULT = {0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__library_controllers( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__library_controllers( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__library_controllers( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

library_controllers__AttributeData* attributeData = newData<library_controllers__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_ID:
    {

attributeData->id = attributeValue;

    break;
    }
    case HASH_ATTRIBUTE_NAME:
    {

attributeData->name = attributeValue;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_LIBRARY_CONTROLLERS, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__library_controllers()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__library_controllers();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__library_controllers( void* attributeData )
{
    library_controllers__AttributeData* typedAttributeData = static_cast<library_controllers__AttributeData*>(attributeData);

    typedAttributeData->~library_controllers__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const controller__AttributeData controller__AttributeData::DEFAULT = {0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__controller( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__controller( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__controller( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

controller__AttributeData* attributeData = newData<controller__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_ID:
    {

attributeData->id = attributeValue;

    break;
    }
    case HASH_ATTRIBUTE_NAME:
    {

attributeData->name = attributeValue;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_CONTROLLER, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__controller()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__controller();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__controller( void* attributeData )
{
    controller__AttributeData* typedAttributeData = static_cast<controller__AttributeData*>(attributeData);

    typedAttributeData->~controller__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const skin__AttributeData skin__AttributeData::DEFAULT = {0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__skin( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__skin( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__skin( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

skin__AttributeData* attributeData = newData<skin__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_SOURCE:
    {
bool failed;
attributeData->source = GeneratedSaxParser::Utils::toURI(&attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_SKIN,
        HASH_ATTRIBUTE_SOURCE,
        attributeValue))
{
    return false;
}
if ( !failed )
    attributeData->present_attributes |= skin__AttributeData::ATTRIBUTE_SOURCE_PRESENT;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_SKIN, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ((attributeData->present_attributes & skin__AttributeData::ATTRIBUTE_SOURCE_PRESENT) == 0)
{
    attributeData->source = COLLADABU::URI("");
}
if ( (attributeData->present_attributes & skin__AttributeData::ATTRIBUTE_SOURCE_PRESENT) == 0 )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_SKIN, HASH_ATTRIBUTE_SOURCE, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__skin()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__skin();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__skin( void* attributeData )
{
    skin__AttributeData* typedAttributeData = static_cast<skin__AttributeData*>(attributeData);

    typedAttributeData->~skin__AttributeData();

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__bind_shape_matrix( const ParserChar* text, size_t textLength )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        bind_shape_matrix__ValidationData* validationData = (bind_shape_matrix__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
return characterData2FloatData(text, textLength, &ColladaParserAutoGen15::data__bind_shape_matrix, &validate__float4x4_type__stream, &validationData->validationWholeSize, 0);
    }
    else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen15::data__bind_shape_matrix);
    }
#else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen15::data__bind_shape_matrix);
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__bind_shape_matrix( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__bind_shape_matrix( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__bind_shape_matrix()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__bind_shape_matrix();
        if ( !validationResult ) return false;

    } // validation
#endif

#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        bind_shape_matrix__ValidationData* validationData = (bind_shape_matrix__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
bool returnValue = floatDataEnd( &ColladaParserAutoGen15::data__bind_shape_matrix, &validate__float4x4_type__streamEnd, &validationData->validationWholeSize, 0 );
        ParserError::ErrorType simpleTypeValidationResult = validate__float4x4_type(0, (*(&validationData->validationWholeSize)));
        mValidationDataStack.deleteObject();
        if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
        {
            if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
                simpleTypeValidationResult,
                HASH_ELEMENT_BIND_SHAPE_MATRIX,
                (ParserChar*)0, 0 ) )
            {
                return false;
            }
        }
        return returnValue;
    }
    else
    {
return floatDataEnd( &ColladaParserAutoGen15::data__bind_shape_matrix );
    }
#else
    {
return floatDataEnd( &ColladaParserAutoGen15::data__bind_shape_matrix );
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__bind_shape_matrix( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__joints( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__joints( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__joints( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__joints()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__joints();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__joints( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
const vertex_weights__AttributeData vertex_weights__AttributeData::DEFAULT = {0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__vertex_weights( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__vertex_weights( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__vertex_weights( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

vertex_weights__AttributeData* attributeData = newData<vertex_weights__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_COUNT:
    {
bool failed;
attributeData->count = GeneratedSaxParser::Utils::toUint64(attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_VERTEX_WEIGHTS,
        HASH_ATTRIBUTE_COUNT,
        attributeValue))
{
    return false;
}
if ( !failed )
    attributeData->present_attributes |= vertex_weights__AttributeData::ATTRIBUTE_COUNT_PRESENT;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_VERTEX_WEIGHTS, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ( (attributeData->present_attributes & vertex_weights__AttributeData::ATTRIBUTE_COUNT_PRESENT) == 0 )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_VERTEX_WEIGHTS, HASH_ATTRIBUTE_COUNT, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__vertex_weights()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__vertex_weights();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__vertex_weights( void* attributeData )
{
    vertex_weights__AttributeData* typedAttributeData = static_cast<vertex_weights__AttributeData*>(attributeData);

    typedAttributeData->~vertex_weights__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const input____input_local_offset_type__AttributeData input____input_local_offset_type__AttributeData::DEFAULT = {0, 0, 0, 0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__input____input_local_offset_type( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__input____input_local_offset_type( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__input____input_local_offset_type( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

input____input_local_offset_type__AttributeData* attributeData = newData<input____input_local_offset_type__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_OFFSET:
    {
bool failed;
attributeData->offset = GeneratedSaxParser::Utils::toUint64(attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_INPUT,
        HASH_ATTRIBUTE_OFFSET,
        attributeValue))
{
    return false;
}
if ( !failed )
    attributeData->present_attributes |= input____input_local_offset_type__AttributeData::ATTRIBUTE_OFFSET_PRESENT;

    break;
    }
    case HASH_ATTRIBUTE_SEMANTIC:
    {

attributeData->semantic = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NMTOKEN(attributeData->semantic, strlen(attributeData->semantic));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_INPUT,
            HASH_ATTRIBUTE_SEMANTIC,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    case HASH_ATTRIBUTE_SOURCE:
    {

attributeData->source = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__urifragment_type(attributeData->source, strlen(attributeData->source));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_INPUT,
            HASH_ATTRIBUTE_SOURCE,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    case HASH_ATTRIBUTE_SET:
    {
bool failed;
attributeData->set = GeneratedSaxParser::Utils::toUint64(attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_INPUT,
        HASH_ATTRIBUTE_SET,
        attributeValue))
{
    return false;
}
if ( !failed )
    attributeData->present_attributes |= input____input_local_offset_type__AttributeData::ATTRIBUTE_SET_PRESENT;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_INPUT, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ( (attributeData->present_attributes & input____input_local_offset_type__AttributeData::ATTRIBUTE_OFFSET_PRESENT) == 0 )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_INPUT, HASH_ATTRIBUTE_OFFSET, 0 ) )
        return false;
}
if ( !attributeData->semantic )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_INPUT, HASH_ATTRIBUTE_SEMANTIC, 0 ) )
        return false;
}
if ( !attributeData->source )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_INPUT, HASH_ATTRIBUTE_SOURCE, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__input____input_local_offset_type()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__input____input_local_offset_type();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__input____input_local_offset_type( void* attributeData )
{
    input____input_local_offset_type__AttributeData* typedAttributeData = static_cast<input____input_local_offset_type__AttributeData*>(attributeData);

    typedAttributeData->~input____input_local_offset_type__AttributeData();

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__vcount( const ParserChar* text, size_t textLength )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
return characterData2Uint64Data(text, textLength, &ColladaParserAutoGen15::data__vcount, 0, 0, 0);
    }
    else
    {
return characterData2Uint64Data(text, textLength, &ColladaParserAutoGen15::data__vcount);
    }
#else
    {
return characterData2Uint64Data(text, textLength, &ColladaParserAutoGen15::data__vcount);
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__vcount( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__vcount( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__vcount()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__vcount();
        if ( !validationResult ) return false;

    } // validation
#endif

#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
bool returnValue = uint64DataEnd( &ColladaParserAutoGen15::data__vcount, 0, 0, 0 );
        return returnValue;
    }
    else
    {
return uint64DataEnd( &ColladaParserAutoGen15::data__vcount );
    }
#else
    {
return uint64DataEnd( &ColladaParserAutoGen15::data__vcount );
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__vcount( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__v( const ParserChar* text, size_t textLength )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
return characterData2Sint64Data(text, textLength, &ColladaParserAutoGen15::data__v, 0, 0, 0);
    }
    else
    {
return characterData2Sint64Data(text, textLength, &ColladaParserAutoGen15::data__v);
    }
#else
    {
return characterData2Sint64Data(text, textLength, &ColladaParserAutoGen15::data__v);
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__v( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__v( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__v()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__v();
        if ( !validationResult ) return false;

    } // validation
#endif

#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
bool returnValue = sint64DataEnd( &ColladaParserAutoGen15::data__v, 0, 0, 0 );
        return returnValue;
    }
    else
    {
return sint64DataEnd( &ColladaParserAutoGen15::data__v );
    }
#else
    {
return sint64DataEnd( &ColladaParserAutoGen15::data__v );
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__v( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
const morph__AttributeData morph__AttributeData::DEFAULT = {0, ENUM__morph_method_enum__NORMALIZED, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__morph( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__morph( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__morph( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

morph__AttributeData* attributeData = newData<morph__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_METHOD:
    {
bool failed;
attributeData->method = Utils::toEnum<ENUM__morph_method_enum, StringHash, ENUM__morph_method_enum__COUNT>(attributeValue, failed, ENUM__morph_method_enumMap, Utils::calculateStringHash);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_MORPH,
        HASH_ATTRIBUTE_METHOD,
        attributeValue))
{
    return false;
}

    break;
    }
    case HASH_ATTRIBUTE_SOURCE:
    {
bool failed;
attributeData->source = GeneratedSaxParser::Utils::toURI(&attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_MORPH,
        HASH_ATTRIBUTE_SOURCE,
        attributeValue))
{
    return false;
}
if ( !failed )
    attributeData->present_attributes |= morph__AttributeData::ATTRIBUTE_SOURCE_PRESENT;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_MORPH, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ((attributeData->present_attributes & morph__AttributeData::ATTRIBUTE_SOURCE_PRESENT) == 0)
{
    attributeData->source = COLLADABU::URI("");
}
if ( (attributeData->present_attributes & morph__AttributeData::ATTRIBUTE_SOURCE_PRESENT) == 0 )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_MORPH, HASH_ATTRIBUTE_SOURCE, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__morph()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__morph();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__morph( void* attributeData )
{
    morph__AttributeData* typedAttributeData = static_cast<morph__AttributeData*>(attributeData);

    typedAttributeData->~morph__AttributeData();

    return true;
}

//---------------------------------------------------------------------
ENUM__morph_method_enum ColladaParserAutoGen15Private::toEnumDataPrefix_ENUM__morph_method_enum (
    const ParserChar* prefixedBuffer,
    const ParserChar* prefixedBufferEnd,
    const ParserChar** buffer,
    const ParserChar* bufferEnd,
    bool& failed,
    const std::pair<StringHash, ENUM__morph_method_enum>* enumMap,
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& )
)
{
    return toEnumDataPrefix<ENUM__morph_method_enum, StringHash, ENUM__morph_method_enum__COUNT, &toEnum_ENUM__morph_method_enum>(prefixedBuffer, prefixedBufferEnd, buffer, bufferEnd, failed, enumMap, baseConversionFunc);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::characterData2EnumData_ENUM__morph_method_enum (
    const ParserChar* text,
    size_t textLength,
    bool ( ColladaParserAutoGen15::*dataFunction )(const ENUM__morph_method_enum*, size_t ),
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& )
)
{
    return characterData2EnumData<ENUM__morph_method_enum, StringHash, ENUM__morph_method_enum__COUNT>(text, textLength, dataFunction, ENUM__morph_method_enumMap, baseConversionFunc, &toEnum_ENUM__morph_method_enum, &ColladaParserAutoGen15Private::toEnumDataPrefix_ENUM__morph_method_enum);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::dataEnumEnd_ENUM__morph_method_enum (
    bool ( ColladaParserAutoGen15::*dataFunction )(const ENUM__morph_method_enum*, size_t ),
    const std::pair<StringHash, ENUM__morph_method_enum>* enumMap,
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& ),
    ENUM__morph_method_enum (*toEnumFunc)( const ParserChar**, const ParserChar*, bool&, const std::pair<StringHash, ENUM__morph_method_enum>* enumMap, StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& ))
)
{
    return dataEnumEnd<ENUM__morph_method_enum, StringHash, ENUM__morph_method_enum__COUNT>(dataFunction, enumMap, baseConversionFunc, toEnumFunc);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__targets( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__targets( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__targets( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__targets()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__targets();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__targets( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
const library_geometries__AttributeData library_geometries__AttributeData::DEFAULT = {0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__library_geometries( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__library_geometries( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__library_geometries( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

library_geometries__AttributeData* attributeData = newData<library_geometries__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_ID:
    {

attributeData->id = attributeValue;

    break;
    }
    case HASH_ATTRIBUTE_NAME:
    {

attributeData->name = attributeValue;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_LIBRARY_GEOMETRIES, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__library_geometries()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__library_geometries();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__library_geometries( void* attributeData )
{
    library_geometries__AttributeData* typedAttributeData = static_cast<library_geometries__AttributeData*>(attributeData);

    typedAttributeData->~library_geometries__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const geometry__AttributeData geometry__AttributeData::DEFAULT = {0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__geometry( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__geometry( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__geometry( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

geometry__AttributeData* attributeData = newData<geometry__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_ID:
    {

attributeData->id = attributeValue;

    break;
    }
    case HASH_ATTRIBUTE_NAME:
    {

attributeData->name = attributeValue;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_GEOMETRY, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__geometry()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__geometry();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__geometry( void* attributeData )
{
    geometry__AttributeData* typedAttributeData = static_cast<geometry__AttributeData*>(attributeData);

    typedAttributeData->~geometry__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const convex_mesh__AttributeData convex_mesh__AttributeData::DEFAULT = {0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__convex_mesh( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__convex_mesh( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__convex_mesh( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

convex_mesh__AttributeData* attributeData = newData<convex_mesh__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_CONVEX_HULL_OF:
    {
bool failed;
attributeData->convex_hull_of = GeneratedSaxParser::Utils::toURI(&attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_CONVEX_MESH,
        HASH_ATTRIBUTE_CONVEX_HULL_OF,
        attributeValue))
{
    return false;
}
if ( !failed )
    attributeData->present_attributes |= convex_mesh__AttributeData::ATTRIBUTE_CONVEX_HULL_OF_PRESENT;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_CONVEX_MESH, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ((attributeData->present_attributes & convex_mesh__AttributeData::ATTRIBUTE_CONVEX_HULL_OF_PRESENT) == 0)
{
    attributeData->convex_hull_of = COLLADABU::URI("");
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__convex_mesh()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__convex_mesh();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__convex_mesh( void* attributeData )
{
    convex_mesh__AttributeData* typedAttributeData = static_cast<convex_mesh__AttributeData*>(attributeData);

    typedAttributeData->~convex_mesh__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const vertices__AttributeData vertices__AttributeData::DEFAULT = {0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__vertices( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__vertices( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__vertices( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

vertices__AttributeData* attributeData = newData<vertices__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_ID:
    {

attributeData->id = attributeValue;

    break;
    }
    case HASH_ATTRIBUTE_NAME:
    {

attributeData->name = attributeValue;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_VERTICES, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ( !attributeData->id )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_VERTICES, HASH_ATTRIBUTE_ID, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__vertices()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__vertices();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__vertices( void* attributeData )
{
    vertices__AttributeData* typedAttributeData = static_cast<vertices__AttributeData*>(attributeData);

    typedAttributeData->~vertices__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const lines__AttributeData lines__AttributeData::DEFAULT = {0, 0, 0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__lines( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__lines( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__lines( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

lines__AttributeData* attributeData = newData<lines__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_NAME:
    {

attributeData->name = attributeValue;

    break;
    }
    case HASH_ATTRIBUTE_COUNT:
    {
bool failed;
attributeData->count = GeneratedSaxParser::Utils::toUint64(attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_LINES,
        HASH_ATTRIBUTE_COUNT,
        attributeValue))
{
    return false;
}
if ( !failed )
    attributeData->present_attributes |= lines__AttributeData::ATTRIBUTE_COUNT_PRESENT;

    break;
    }
    case HASH_ATTRIBUTE_MATERIAL:
    {

attributeData->material = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->material, strlen(attributeData->material));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_LINES,
            HASH_ATTRIBUTE_MATERIAL,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_LINES, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ( (attributeData->present_attributes & lines__AttributeData::ATTRIBUTE_COUNT_PRESENT) == 0 )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_LINES, HASH_ATTRIBUTE_COUNT, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__lines()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__lines();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__lines( void* attributeData )
{
    lines__AttributeData* typedAttributeData = static_cast<lines__AttributeData*>(attributeData);

    typedAttributeData->~lines__AttributeData();

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__p( const ParserChar* text, size_t textLength )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
return characterData2Uint64Data(text, textLength, &ColladaParserAutoGen15::data__p, 0, 0, 0);
    }
    else
    {
return characterData2Uint64Data(text, textLength, &ColladaParserAutoGen15::data__p);
    }
#else
    {
return characterData2Uint64Data(text, textLength, &ColladaParserAutoGen15::data__p);
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__p( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__p( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__p()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__p();
        if ( !validationResult ) return false;

    } // validation
#endif

#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
bool returnValue = uint64DataEnd( &ColladaParserAutoGen15::data__p, 0, 0, 0 );
        return returnValue;
    }
    else
    {
return uint64DataEnd( &ColladaParserAutoGen15::data__p );
    }
#else
    {
return uint64DataEnd( &ColladaParserAutoGen15::data__p );
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__p( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
const linestrips__AttributeData linestrips__AttributeData::DEFAULT = {0, 0, 0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__linestrips( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__linestrips( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__linestrips( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

linestrips__AttributeData* attributeData = newData<linestrips__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_NAME:
    {

attributeData->name = attributeValue;

    break;
    }
    case HASH_ATTRIBUTE_COUNT:
    {
bool failed;
attributeData->count = GeneratedSaxParser::Utils::toUint64(attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_LINESTRIPS,
        HASH_ATTRIBUTE_COUNT,
        attributeValue))
{
    return false;
}
if ( !failed )
    attributeData->present_attributes |= linestrips__AttributeData::ATTRIBUTE_COUNT_PRESENT;

    break;
    }
    case HASH_ATTRIBUTE_MATERIAL:
    {

attributeData->material = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->material, strlen(attributeData->material));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_LINESTRIPS,
            HASH_ATTRIBUTE_MATERIAL,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_LINESTRIPS, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ( (attributeData->present_attributes & linestrips__AttributeData::ATTRIBUTE_COUNT_PRESENT) == 0 )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_LINESTRIPS, HASH_ATTRIBUTE_COUNT, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__linestrips()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__linestrips();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__linestrips( void* attributeData )
{
    linestrips__AttributeData* typedAttributeData = static_cast<linestrips__AttributeData*>(attributeData);

    typedAttributeData->~linestrips__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const polygons__AttributeData polygons__AttributeData::DEFAULT = {0, 0, 0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__polygons( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__polygons( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__polygons( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

polygons__AttributeData* attributeData = newData<polygons__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_NAME:
    {

attributeData->name = attributeValue;

    break;
    }
    case HASH_ATTRIBUTE_COUNT:
    {
bool failed;
attributeData->count = GeneratedSaxParser::Utils::toUint64(attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_POLYGONS,
        HASH_ATTRIBUTE_COUNT,
        attributeValue))
{
    return false;
}
if ( !failed )
    attributeData->present_attributes |= polygons__AttributeData::ATTRIBUTE_COUNT_PRESENT;

    break;
    }
    case HASH_ATTRIBUTE_MATERIAL:
    {

attributeData->material = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->material, strlen(attributeData->material));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_POLYGONS,
            HASH_ATTRIBUTE_MATERIAL,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_POLYGONS, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ( (attributeData->present_attributes & polygons__AttributeData::ATTRIBUTE_COUNT_PRESENT) == 0 )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_POLYGONS, HASH_ATTRIBUTE_COUNT, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__polygons()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__polygons();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__polygons( void* attributeData )
{
    polygons__AttributeData* typedAttributeData = static_cast<polygons__AttributeData*>(attributeData);

    typedAttributeData->~polygons__AttributeData();

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__ph( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__ph( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__ph( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__ph()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__ph();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__ph( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__h( const ParserChar* text, size_t textLength )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
return characterData2Uint64Data(text, textLength, &ColladaParserAutoGen15::data__h, 0, 0, 0);
    }
    else
    {
return characterData2Uint64Data(text, textLength, &ColladaParserAutoGen15::data__h);
    }
#else
    {
return characterData2Uint64Data(text, textLength, &ColladaParserAutoGen15::data__h);
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__h( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__h( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__h()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__h();
        if ( !validationResult ) return false;

    } // validation
#endif

#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
bool returnValue = uint64DataEnd( &ColladaParserAutoGen15::data__h, 0, 0, 0 );
        return returnValue;
    }
    else
    {
return uint64DataEnd( &ColladaParserAutoGen15::data__h );
    }
#else
    {
return uint64DataEnd( &ColladaParserAutoGen15::data__h );
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__h( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
const polylist__AttributeData polylist__AttributeData::DEFAULT = {0, 0, 0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__polylist( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__polylist( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__polylist( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

polylist__AttributeData* attributeData = newData<polylist__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_NAME:
    {

attributeData->name = attributeValue;

    break;
    }
    case HASH_ATTRIBUTE_COUNT:
    {
bool failed;
attributeData->count = GeneratedSaxParser::Utils::toUint64(attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_POLYLIST,
        HASH_ATTRIBUTE_COUNT,
        attributeValue))
{
    return false;
}
if ( !failed )
    attributeData->present_attributes |= polylist__AttributeData::ATTRIBUTE_COUNT_PRESENT;

    break;
    }
    case HASH_ATTRIBUTE_MATERIAL:
    {

attributeData->material = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->material, strlen(attributeData->material));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_POLYLIST,
            HASH_ATTRIBUTE_MATERIAL,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_POLYLIST, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ( (attributeData->present_attributes & polylist__AttributeData::ATTRIBUTE_COUNT_PRESENT) == 0 )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_POLYLIST, HASH_ATTRIBUTE_COUNT, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__polylist()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__polylist();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__polylist( void* attributeData )
{
    polylist__AttributeData* typedAttributeData = static_cast<polylist__AttributeData*>(attributeData);

    typedAttributeData->~polylist__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const triangles__AttributeData triangles__AttributeData::DEFAULT = {0, 0, 0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__triangles( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__triangles( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__triangles( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

triangles__AttributeData* attributeData = newData<triangles__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_NAME:
    {

attributeData->name = attributeValue;

    break;
    }
    case HASH_ATTRIBUTE_COUNT:
    {
bool failed;
attributeData->count = GeneratedSaxParser::Utils::toUint64(attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_TRIANGLES,
        HASH_ATTRIBUTE_COUNT,
        attributeValue))
{
    return false;
}
if ( !failed )
    attributeData->present_attributes |= triangles__AttributeData::ATTRIBUTE_COUNT_PRESENT;

    break;
    }
    case HASH_ATTRIBUTE_MATERIAL:
    {

attributeData->material = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->material, strlen(attributeData->material));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_TRIANGLES,
            HASH_ATTRIBUTE_MATERIAL,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_TRIANGLES, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ( (attributeData->present_attributes & triangles__AttributeData::ATTRIBUTE_COUNT_PRESENT) == 0 )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_TRIANGLES, HASH_ATTRIBUTE_COUNT, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__triangles()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__triangles();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__triangles( void* attributeData )
{
    triangles__AttributeData* typedAttributeData = static_cast<triangles__AttributeData*>(attributeData);

    typedAttributeData->~triangles__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const trifans__AttributeData trifans__AttributeData::DEFAULT = {0, 0, 0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__trifans( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__trifans( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__trifans( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

trifans__AttributeData* attributeData = newData<trifans__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_NAME:
    {

attributeData->name = attributeValue;

    break;
    }
    case HASH_ATTRIBUTE_COUNT:
    {
bool failed;
attributeData->count = GeneratedSaxParser::Utils::toUint64(attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_TRIFANS,
        HASH_ATTRIBUTE_COUNT,
        attributeValue))
{
    return false;
}
if ( !failed )
    attributeData->present_attributes |= trifans__AttributeData::ATTRIBUTE_COUNT_PRESENT;

    break;
    }
    case HASH_ATTRIBUTE_MATERIAL:
    {

attributeData->material = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->material, strlen(attributeData->material));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_TRIFANS,
            HASH_ATTRIBUTE_MATERIAL,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_TRIFANS, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ( (attributeData->present_attributes & trifans__AttributeData::ATTRIBUTE_COUNT_PRESENT) == 0 )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_TRIFANS, HASH_ATTRIBUTE_COUNT, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__trifans()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__trifans();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__trifans( void* attributeData )
{
    trifans__AttributeData* typedAttributeData = static_cast<trifans__AttributeData*>(attributeData);

    typedAttributeData->~trifans__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const tristrips__AttributeData tristrips__AttributeData::DEFAULT = {0, 0, 0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__tristrips( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__tristrips( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__tristrips( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

tristrips__AttributeData* attributeData = newData<tristrips__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_NAME:
    {

attributeData->name = attributeValue;

    break;
    }
    case HASH_ATTRIBUTE_COUNT:
    {
bool failed;
attributeData->count = GeneratedSaxParser::Utils::toUint64(attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_TRISTRIPS,
        HASH_ATTRIBUTE_COUNT,
        attributeValue))
{
    return false;
}
if ( !failed )
    attributeData->present_attributes |= tristrips__AttributeData::ATTRIBUTE_COUNT_PRESENT;

    break;
    }
    case HASH_ATTRIBUTE_MATERIAL:
    {

attributeData->material = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->material, strlen(attributeData->material));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_TRISTRIPS,
            HASH_ATTRIBUTE_MATERIAL,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_TRISTRIPS, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ( (attributeData->present_attributes & tristrips__AttributeData::ATTRIBUTE_COUNT_PRESENT) == 0 )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_TRISTRIPS, HASH_ATTRIBUTE_COUNT, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__tristrips()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__tristrips();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__tristrips( void* attributeData )
{
    tristrips__AttributeData* typedAttributeData = static_cast<tristrips__AttributeData*>(attributeData);

    typedAttributeData->~tristrips__AttributeData();

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__mesh( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__mesh( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__mesh( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__mesh()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__mesh();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__mesh( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
const spline__AttributeData spline__AttributeData::DEFAULT = {false};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__spline( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__spline( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__spline( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

spline__AttributeData* attributeData = newData<spline__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_CLOSED:
    {
bool failed;
attributeData->closed = GeneratedSaxParser::Utils::toBool(attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_SPLINE,
        HASH_ATTRIBUTE_CLOSED,
        attributeValue))
{
    return false;
}

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_SPLINE, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__spline()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__spline();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__spline( void* attributeData )
{
    spline__AttributeData* typedAttributeData = static_cast<spline__AttributeData*>(attributeData);

    typedAttributeData->~spline__AttributeData();

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__spline_type____control_vertices( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__spline_type____control_vertices( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__spline_type____control_vertices( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__spline_type____control_vertices()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__spline_type____control_vertices();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__spline_type____control_vertices( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__brep( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__brep( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__brep( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__brep()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__brep();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__brep( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__curves( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__curves( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__curves( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__curves()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__curves();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__curves( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
const curve__AttributeData curve__AttributeData::DEFAULT = {0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__curve( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__curve( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__curve( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

curve__AttributeData* attributeData = newData<curve__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_SID:
    {

attributeData->sid = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__sid_type(attributeData->sid, strlen(attributeData->sid));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_CURVE,
            HASH_ATTRIBUTE_SID,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    case HASH_ATTRIBUTE_NAME:
    {

attributeData->name = attributeValue;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_CURVE, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__curve()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__curve();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__curve( void* attributeData )
{
    curve__AttributeData* typedAttributeData = static_cast<curve__AttributeData*>(attributeData);

    typedAttributeData->~curve__AttributeData();

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__line( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__line( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__line( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__line()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__line();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__line( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__origin____float3_type( const ParserChar* text, size_t textLength )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        origin____float3_type__ValidationData* validationData = (origin____float3_type__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
return characterData2FloatData(text, textLength, &ColladaParserAutoGen15::data__origin____float3_type, &validate__float3_type__stream, &validationData->validationWholeSize, 0);
    }
    else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen15::data__origin____float3_type);
    }
#else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen15::data__origin____float3_type);
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__origin____float3_type( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__origin____float3_type( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__origin____float3_type()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__origin____float3_type();
        if ( !validationResult ) return false;

    } // validation
#endif

#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        origin____float3_type__ValidationData* validationData = (origin____float3_type__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
bool returnValue = floatDataEnd( &ColladaParserAutoGen15::data__origin____float3_type, &validate__float3_type__streamEnd, &validationData->validationWholeSize, 0 );
        ParserError::ErrorType simpleTypeValidationResult = validate__float3_type(0, (*(&validationData->validationWholeSize)));
        mValidationDataStack.deleteObject();
        if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
        {
            if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
                simpleTypeValidationResult,
                HASH_ELEMENT_ORIGIN,
                (ParserChar*)0, 0 ) )
            {
                return false;
            }
        }
        return returnValue;
    }
    else
    {
return floatDataEnd( &ColladaParserAutoGen15::data__origin____float3_type );
    }
#else
    {
return floatDataEnd( &ColladaParserAutoGen15::data__origin____float3_type );
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__origin____float3_type( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__direction( const ParserChar* text, size_t textLength )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        origin____float3_type__ValidationData* validationData = (origin____float3_type__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
return characterData2FloatData(text, textLength, &ColladaParserAutoGen15::data__direction, &validate__float3_type__stream, &validationData->validationWholeSize, 0);
    }
    else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen15::data__direction);
    }
#else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen15::data__direction);
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__direction( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__direction( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__direction()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__direction();
        if ( !validationResult ) return false;

    } // validation
#endif

#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        origin____float3_type__ValidationData* validationData = (origin____float3_type__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
bool returnValue = floatDataEnd( &ColladaParserAutoGen15::data__direction, &validate__float3_type__streamEnd, &validationData->validationWholeSize, 0 );
        ParserError::ErrorType simpleTypeValidationResult = validate__float3_type(0, (*(&validationData->validationWholeSize)));
        mValidationDataStack.deleteObject();
        if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
        {
            if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
                simpleTypeValidationResult,
                HASH_ELEMENT_DIRECTION,
                (ParserChar*)0, 0 ) )
            {
                return false;
            }
        }
        return returnValue;
    }
    else
    {
return floatDataEnd( &ColladaParserAutoGen15::data__direction );
    }
#else
    {
return floatDataEnd( &ColladaParserAutoGen15::data__direction );
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__direction( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__circle( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__circle( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__circle( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__circle()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__circle();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__circle( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__radius____float_type( const ParserChar* text, size_t textLength )
{
if (!mLastIncompleteFragmentInCharacterData)
{
    mLastIncompleteFragmentInCharacterData = (ParserChar*)mStackMemoryManager.newObject(textLength);
    memcpy(mLastIncompleteFragmentInCharacterData, text, textLength);
    mEndOfDataInCurrentObjectOnStack = mLastIncompleteFragmentInCharacterData + textLength;
}
else
{
    ParserChar* tmp = (ParserChar*)mStackMemoryManager.growObject(textLength);
    if ( tmp != mLastIncompleteFragmentInCharacterData ) {
        mEndOfDataInCurrentObjectOnStack = (mEndOfDataInCurrentObjectOnStack - mLastIncompleteFragmentInCharacterData) + tmp;
        mLastIncompleteFragmentInCharacterData = tmp;
    }
    memcpy(mEndOfDataInCurrentObjectOnStack, text, textLength);
    mEndOfDataInCurrentObjectOnStack += textLength;
}
return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__radius____float_type( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__radius____float_type( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__radius____float_type()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__radius____float_type();
        if ( !validationResult ) return false;

    } // validation
#endif

bool failed;
const ParserChar* ptrForErr = mLastIncompleteFragmentInCharacterData;
DISABLE_WARNING_UNUSED(ptrForErr)
float parameter = GeneratedSaxParser::Utils::toFloat((const ParserChar**)&mLastIncompleteFragmentInCharacterData, mEndOfDataInCurrentObjectOnStack, failed);
bool returnValue;
if (!failed)
{
    returnValue = mImpl->data__radius____float_type(parameter);
}
else
    returnValue = !handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_TEXTDATA_PARSING_FAILED, HASH_ELEMENT_RADIUS, (const ParserChar*)0, mLastIncompleteFragmentInCharacterData);
if (mLastIncompleteFragmentInCharacterData)
    mStackMemoryManager.deleteObject();
mLastIncompleteFragmentInCharacterData = 0;
mEndOfDataInCurrentObjectOnStack = 0;
return returnValue;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__radius____float_type( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__ellipse( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__ellipse( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__ellipse( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__ellipse()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__ellipse();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__ellipse( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__radius____float2_type( const ParserChar* text, size_t textLength )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        radius____float2_type__ValidationData* validationData = (radius____float2_type__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
return characterData2FloatData(text, textLength, &ColladaParserAutoGen15::data__radius____float2_type, &validate__float2_type__stream, &validationData->validationWholeSize, 0);
    }
    else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen15::data__radius____float2_type);
    }
#else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen15::data__radius____float2_type);
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__radius____float2_type( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__radius____float2_type( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__radius____float2_type()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__radius____float2_type();
        if ( !validationResult ) return false;

    } // validation
#endif

#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        radius____float2_type__ValidationData* validationData = (radius____float2_type__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
bool returnValue = floatDataEnd( &ColladaParserAutoGen15::data__radius____float2_type, &validate__float2_type__streamEnd, &validationData->validationWholeSize, 0 );
        ParserError::ErrorType simpleTypeValidationResult = validate__float2_type(0, (*(&validationData->validationWholeSize)));
        mValidationDataStack.deleteObject();
        if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
        {
            if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
                simpleTypeValidationResult,
                HASH_ELEMENT_RADIUS,
                (ParserChar*)0, 0 ) )
            {
                return false;
            }
        }
        return returnValue;
    }
    else
    {
return floatDataEnd( &ColladaParserAutoGen15::data__radius____float2_type );
    }
#else
    {
return floatDataEnd( &ColladaParserAutoGen15::data__radius____float2_type );
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__radius____float2_type( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__parabola( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__parabola( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__parabola( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__parabola()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__parabola();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__parabola( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__focal( const ParserChar* text, size_t textLength )
{
if (!mLastIncompleteFragmentInCharacterData)
{
    mLastIncompleteFragmentInCharacterData = (ParserChar*)mStackMemoryManager.newObject(textLength);
    memcpy(mLastIncompleteFragmentInCharacterData, text, textLength);
    mEndOfDataInCurrentObjectOnStack = mLastIncompleteFragmentInCharacterData + textLength;
}
else
{
    ParserChar* tmp = (ParserChar*)mStackMemoryManager.growObject(textLength);
    if ( tmp != mLastIncompleteFragmentInCharacterData ) {
        mEndOfDataInCurrentObjectOnStack = (mEndOfDataInCurrentObjectOnStack - mLastIncompleteFragmentInCharacterData) + tmp;
        mLastIncompleteFragmentInCharacterData = tmp;
    }
    memcpy(mEndOfDataInCurrentObjectOnStack, text, textLength);
    mEndOfDataInCurrentObjectOnStack += textLength;
}
return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__focal( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__focal( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__focal()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__focal();
        if ( !validationResult ) return false;

    } // validation
#endif

bool failed;
const ParserChar* ptrForErr = mLastIncompleteFragmentInCharacterData;
DISABLE_WARNING_UNUSED(ptrForErr)
float parameter = GeneratedSaxParser::Utils::toFloat((const ParserChar**)&mLastIncompleteFragmentInCharacterData, mEndOfDataInCurrentObjectOnStack, failed);
bool returnValue;
if (!failed)
{
    returnValue = mImpl->data__focal(parameter);
}
else
    returnValue = !handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_TEXTDATA_PARSING_FAILED, HASH_ELEMENT_FOCAL, (const ParserChar*)0, mLastIncompleteFragmentInCharacterData);
if (mLastIncompleteFragmentInCharacterData)
    mStackMemoryManager.deleteObject();
mLastIncompleteFragmentInCharacterData = 0;
mEndOfDataInCurrentObjectOnStack = 0;
return returnValue;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__focal( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__hyperbola( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__hyperbola( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__hyperbola( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__hyperbola()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__hyperbola();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__hyperbola( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
const nurbs__AttributeData nurbs__AttributeData::DEFAULT = {0, 0, false};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__nurbs( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__nurbs( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__nurbs( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

nurbs__AttributeData* attributeData = newData<nurbs__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_DEGREE:
    {
bool failed;
attributeData->degree = GeneratedSaxParser::Utils::toUint64(attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_NURBS,
        HASH_ATTRIBUTE_DEGREE,
        attributeValue))
{
    return false;
}
if ( !failed )
    attributeData->present_attributes |= nurbs__AttributeData::ATTRIBUTE_DEGREE_PRESENT;

    break;
    }
    case HASH_ATTRIBUTE_CLOSED:
    {
bool failed;
attributeData->closed = GeneratedSaxParser::Utils::toBool(attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_NURBS,
        HASH_ATTRIBUTE_CLOSED,
        attributeValue))
{
    return false;
}

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_NURBS, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ( (attributeData->present_attributes & nurbs__AttributeData::ATTRIBUTE_DEGREE_PRESENT) == 0 )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_NURBS, HASH_ATTRIBUTE_DEGREE, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__nurbs()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__nurbs();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__nurbs( void* attributeData )
{
    nurbs__AttributeData* typedAttributeData = static_cast<nurbs__AttributeData*>(attributeData);

    typedAttributeData->~nurbs__AttributeData();

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__nurbs_type____control_vertices( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__nurbs_type____control_vertices( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__nurbs_type____control_vertices( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__nurbs_type____control_vertices()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__nurbs_type____control_vertices();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__nurbs_type____control_vertices( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__orient( const ParserChar* text, size_t textLength )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        orient__ValidationData* validationData = (orient__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
return characterData2FloatData(text, textLength, &ColladaParserAutoGen15::data__orient, &validate__float4_type__stream, &validationData->validationWholeSize, 0);
    }
    else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen15::data__orient);
    }
#else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen15::data__orient);
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__orient( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__orient( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__orient()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__orient();
        if ( !validationResult ) return false;

    } // validation
#endif

#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        orient__ValidationData* validationData = (orient__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
bool returnValue = floatDataEnd( &ColladaParserAutoGen15::data__orient, &validate__float4_type__streamEnd, &validationData->validationWholeSize, 0 );
        ParserError::ErrorType simpleTypeValidationResult = validate__float4_type(0, (*(&validationData->validationWholeSize)));
        mValidationDataStack.deleteObject();
        if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
        {
            if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
                simpleTypeValidationResult,
                HASH_ELEMENT_ORIENT,
                (ParserChar*)0, 0 ) )
            {
                return false;
            }
        }
        return returnValue;
    }
    else
    {
return floatDataEnd( &ColladaParserAutoGen15::data__orient );
    }
#else
    {
return floatDataEnd( &ColladaParserAutoGen15::data__orient );
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__orient( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__origin____origin_type( const ParserChar* text, size_t textLength )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        origin____float3_type__ValidationData* validationData = (origin____float3_type__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
return characterData2FloatData(text, textLength, &ColladaParserAutoGen15::data__origin____origin_type, &validate__float3_type__stream, &validationData->validationWholeSize, 0);
    }
    else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen15::data__origin____origin_type);
    }
#else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen15::data__origin____origin_type);
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__origin____origin_type( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__origin____origin_type( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__origin____origin_type()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__origin____origin_type();
        if ( !validationResult ) return false;

    } // validation
#endif

#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        origin____float3_type__ValidationData* validationData = (origin____float3_type__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
bool returnValue = floatDataEnd( &ColladaParserAutoGen15::data__origin____origin_type, &validate__float3_type__streamEnd, &validationData->validationWholeSize, 0 );
        ParserError::ErrorType simpleTypeValidationResult = validate__float3_type(0, (*(&validationData->validationWholeSize)));
        mValidationDataStack.deleteObject();
        if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
        {
            if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
                simpleTypeValidationResult,
                HASH_ELEMENT_ORIGIN,
                (ParserChar*)0, 0 ) )
            {
                return false;
            }
        }
        return returnValue;
    }
    else
    {
return floatDataEnd( &ColladaParserAutoGen15::data__origin____origin_type );
    }
#else
    {
return floatDataEnd( &ColladaParserAutoGen15::data__origin____origin_type );
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__origin____origin_type( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__surface_curves( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__surface_curves( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__surface_curves( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__surface_curves()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__surface_curves();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__surface_curves( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__surfaces( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__surfaces( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__surfaces( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__surfaces()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__surfaces();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__surfaces( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
const surface__AttributeData surface__AttributeData::DEFAULT = {0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__surface( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__surface( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__surface( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

surface__AttributeData* attributeData = newData<surface__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_SID:
    {

attributeData->sid = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__sid_type(attributeData->sid, strlen(attributeData->sid));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_SURFACE,
            HASH_ATTRIBUTE_SID,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    case HASH_ATTRIBUTE_NAME:
    {

attributeData->name = attributeValue;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_SURFACE, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__surface()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__surface();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__surface( void* attributeData )
{
    surface__AttributeData* typedAttributeData = static_cast<surface__AttributeData*>(attributeData);

    typedAttributeData->~surface__AttributeData();

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__plane( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__plane( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__plane( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__plane()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__plane();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__plane( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__equation( const ParserChar* text, size_t textLength )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        orient__ValidationData* validationData = (orient__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
return characterData2FloatData(text, textLength, &ColladaParserAutoGen15::data__equation, &validate__float4_type__stream, &validationData->validationWholeSize, 0);
    }
    else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen15::data__equation);
    }
#else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen15::data__equation);
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__equation( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__equation( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__equation()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__equation();
        if ( !validationResult ) return false;

    } // validation
#endif

#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        orient__ValidationData* validationData = (orient__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
bool returnValue = floatDataEnd( &ColladaParserAutoGen15::data__equation, &validate__float4_type__streamEnd, &validationData->validationWholeSize, 0 );
        ParserError::ErrorType simpleTypeValidationResult = validate__float4_type(0, (*(&validationData->validationWholeSize)));
        mValidationDataStack.deleteObject();
        if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
        {
            if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
                simpleTypeValidationResult,
                HASH_ELEMENT_EQUATION,
                (ParserChar*)0, 0 ) )
            {
                return false;
            }
        }
        return returnValue;
    }
    else
    {
return floatDataEnd( &ColladaParserAutoGen15::data__equation );
    }
#else
    {
return floatDataEnd( &ColladaParserAutoGen15::data__equation );
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__equation( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__sphere( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__sphere( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__sphere( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__sphere()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__sphere();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__sphere( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__torus( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__torus( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__torus( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__torus()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__torus();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__torus( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__swept_surface( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__swept_surface( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__swept_surface( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__swept_surface()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__swept_surface();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__swept_surface( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__axis____float3_type( const ParserChar* text, size_t textLength )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        origin____float3_type__ValidationData* validationData = (origin____float3_type__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
return characterData2FloatData(text, textLength, &ColladaParserAutoGen15::data__axis____float3_type, &validate__float3_type__stream, &validationData->validationWholeSize, 0);
    }
    else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen15::data__axis____float3_type);
    }
#else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen15::data__axis____float3_type);
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__axis____float3_type( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__axis____float3_type( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__axis____float3_type()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__axis____float3_type();
        if ( !validationResult ) return false;

    } // validation
#endif

#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        origin____float3_type__ValidationData* validationData = (origin____float3_type__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
bool returnValue = floatDataEnd( &ColladaParserAutoGen15::data__axis____float3_type, &validate__float3_type__streamEnd, &validationData->validationWholeSize, 0 );
        ParserError::ErrorType simpleTypeValidationResult = validate__float3_type(0, (*(&validationData->validationWholeSize)));
        mValidationDataStack.deleteObject();
        if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
        {
            if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
                simpleTypeValidationResult,
                HASH_ELEMENT_AXIS,
                (ParserChar*)0, 0 ) )
            {
                return false;
            }
        }
        return returnValue;
    }
    else
    {
return floatDataEnd( &ColladaParserAutoGen15::data__axis____float3_type );
    }
#else
    {
return floatDataEnd( &ColladaParserAutoGen15::data__axis____float3_type );
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__axis____float3_type( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
const nurbs_surface__AttributeData nurbs_surface__AttributeData::DEFAULT = {0, 0, false, 0, false};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__nurbs_surface( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__nurbs_surface( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__nurbs_surface( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

nurbs_surface__AttributeData* attributeData = newData<nurbs_surface__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_DEGREE_U:
    {
bool failed;
attributeData->degree_u = GeneratedSaxParser::Utils::toUint64(attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_NURBS_SURFACE,
        HASH_ATTRIBUTE_DEGREE_U,
        attributeValue))
{
    return false;
}
if ( !failed )
    attributeData->present_attributes |= nurbs_surface__AttributeData::ATTRIBUTE_DEGREE_U_PRESENT;

    break;
    }
    case HASH_ATTRIBUTE_CLOSED_U:
    {
bool failed;
attributeData->closed_u = GeneratedSaxParser::Utils::toBool(attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_NURBS_SURFACE,
        HASH_ATTRIBUTE_CLOSED_U,
        attributeValue))
{
    return false;
}

    break;
    }
    case HASH_ATTRIBUTE_DEGREE_V:
    {
bool failed;
attributeData->degree_v = GeneratedSaxParser::Utils::toUint64(attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_NURBS_SURFACE,
        HASH_ATTRIBUTE_DEGREE_V,
        attributeValue))
{
    return false;
}
if ( !failed )
    attributeData->present_attributes |= nurbs_surface__AttributeData::ATTRIBUTE_DEGREE_V_PRESENT;

    break;
    }
    case HASH_ATTRIBUTE_CLOSED_V:
    {
bool failed;
attributeData->closed_v = GeneratedSaxParser::Utils::toBool(attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_NURBS_SURFACE,
        HASH_ATTRIBUTE_CLOSED_V,
        attributeValue))
{
    return false;
}

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_NURBS_SURFACE, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ( (attributeData->present_attributes & nurbs_surface__AttributeData::ATTRIBUTE_DEGREE_U_PRESENT) == 0 )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_NURBS_SURFACE, HASH_ATTRIBUTE_DEGREE_U, 0 ) )
        return false;
}
if ( (attributeData->present_attributes & nurbs_surface__AttributeData::ATTRIBUTE_DEGREE_V_PRESENT) == 0 )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_NURBS_SURFACE, HASH_ATTRIBUTE_DEGREE_V, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__nurbs_surface()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__nurbs_surface();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__nurbs_surface( void* attributeData )
{
    nurbs_surface__AttributeData* typedAttributeData = static_cast<nurbs_surface__AttributeData*>(attributeData);

    typedAttributeData->~nurbs_surface__AttributeData();

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__nurbs_surface_type____control_vertices( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__nurbs_surface_type____control_vertices( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__nurbs_surface_type____control_vertices( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__nurbs_surface_type____control_vertices()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__nurbs_surface_type____control_vertices();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__nurbs_surface_type____control_vertices( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__cone( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__cone( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__cone( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__cone()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__cone();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__cone( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__angle( const ParserChar* text, size_t textLength )
{
if (!mLastIncompleteFragmentInCharacterData)
{
    mLastIncompleteFragmentInCharacterData = (ParserChar*)mStackMemoryManager.newObject(textLength);
    memcpy(mLastIncompleteFragmentInCharacterData, text, textLength);
    mEndOfDataInCurrentObjectOnStack = mLastIncompleteFragmentInCharacterData + textLength;
}
else
{
    ParserChar* tmp = (ParserChar*)mStackMemoryManager.growObject(textLength);
    if ( tmp != mLastIncompleteFragmentInCharacterData ) {
        mEndOfDataInCurrentObjectOnStack = (mEndOfDataInCurrentObjectOnStack - mLastIncompleteFragmentInCharacterData) + tmp;
        mLastIncompleteFragmentInCharacterData = tmp;
    }
    memcpy(mEndOfDataInCurrentObjectOnStack, text, textLength);
    mEndOfDataInCurrentObjectOnStack += textLength;
}
return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__angle( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__angle( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__angle()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__angle();
        if ( !validationResult ) return false;

    } // validation
#endif

bool failed;
const ParserChar* ptrForErr = mLastIncompleteFragmentInCharacterData;
DISABLE_WARNING_UNUSED(ptrForErr)
float parameter = GeneratedSaxParser::Utils::toFloat((const ParserChar**)&mLastIncompleteFragmentInCharacterData, mEndOfDataInCurrentObjectOnStack, failed);
bool returnValue;
if (!failed)
{
    returnValue = mImpl->data__angle(parameter);
}
else
    returnValue = !handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_TEXTDATA_PARSING_FAILED, HASH_ELEMENT_ANGLE, (const ParserChar*)0, mLastIncompleteFragmentInCharacterData);
if (mLastIncompleteFragmentInCharacterData)
    mStackMemoryManager.deleteObject();
mLastIncompleteFragmentInCharacterData = 0;
mEndOfDataInCurrentObjectOnStack = 0;
return returnValue;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__angle( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__surface_type____cylinder( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__surface_type____cylinder( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__surface_type____cylinder( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__surface_type____cylinder()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__surface_type____cylinder();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__surface_type____cylinder( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
const edges__AttributeData edges__AttributeData::DEFAULT = {0, 0, 0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__edges( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__edges( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__edges( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

edges__AttributeData* attributeData = newData<edges__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_ID:
    {

attributeData->id = attributeValue;

    break;
    }
    case HASH_ATTRIBUTE_NAME:
    {

attributeData->name = attributeValue;

    break;
    }
    case HASH_ATTRIBUTE_COUNT:
    {
bool failed;
attributeData->count = GeneratedSaxParser::Utils::toSint32(attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_EDGES,
        HASH_ATTRIBUTE_COUNT,
        attributeValue))
{
    return false;
}
if ( !failed )
    attributeData->present_attributes |= edges__AttributeData::ATTRIBUTE_COUNT_PRESENT;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_EDGES, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ( !attributeData->id )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_EDGES, HASH_ATTRIBUTE_ID, 0 ) )
        return false;
}
if ( (attributeData->present_attributes & edges__AttributeData::ATTRIBUTE_COUNT_PRESENT) == 0 )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_EDGES, HASH_ATTRIBUTE_COUNT, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__edges()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__edges();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__edges( void* attributeData )
{
    edges__AttributeData* typedAttributeData = static_cast<edges__AttributeData*>(attributeData);

    typedAttributeData->~edges__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const wires__AttributeData wires__AttributeData::DEFAULT = {0, 0, 0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__wires( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__wires( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__wires( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

wires__AttributeData* attributeData = newData<wires__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_ID:
    {

attributeData->id = attributeValue;

    break;
    }
    case HASH_ATTRIBUTE_NAME:
    {

attributeData->name = attributeValue;

    break;
    }
    case HASH_ATTRIBUTE_COUNT:
    {
bool failed;
attributeData->count = GeneratedSaxParser::Utils::toUint64(attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_WIRES,
        HASH_ATTRIBUTE_COUNT,
        attributeValue))
{
    return false;
}
if ( !failed )
    attributeData->present_attributes |= wires__AttributeData::ATTRIBUTE_COUNT_PRESENT;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_WIRES, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ( !attributeData->id )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_WIRES, HASH_ATTRIBUTE_ID, 0 ) )
        return false;
}
if ( (attributeData->present_attributes & wires__AttributeData::ATTRIBUTE_COUNT_PRESENT) == 0 )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_WIRES, HASH_ATTRIBUTE_COUNT, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__wires()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__wires();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__wires( void* attributeData )
{
    wires__AttributeData* typedAttributeData = static_cast<wires__AttributeData*>(attributeData);

    typedAttributeData->~wires__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const faces__AttributeData faces__AttributeData::DEFAULT = {0, 0, 0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__faces( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__faces( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__faces( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

faces__AttributeData* attributeData = newData<faces__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_ID:
    {

attributeData->id = attributeValue;

    break;
    }
    case HASH_ATTRIBUTE_NAME:
    {

attributeData->name = attributeValue;

    break;
    }
    case HASH_ATTRIBUTE_COUNT:
    {
bool failed;
attributeData->count = GeneratedSaxParser::Utils::toUint64(attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_FACES,
        HASH_ATTRIBUTE_COUNT,
        attributeValue))
{
    return false;
}
if ( !failed )
    attributeData->present_attributes |= faces__AttributeData::ATTRIBUTE_COUNT_PRESENT;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_FACES, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ( !attributeData->id )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_FACES, HASH_ATTRIBUTE_ID, 0 ) )
        return false;
}
if ( (attributeData->present_attributes & faces__AttributeData::ATTRIBUTE_COUNT_PRESENT) == 0 )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_FACES, HASH_ATTRIBUTE_COUNT, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__faces()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__faces();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__faces( void* attributeData )
{
    faces__AttributeData* typedAttributeData = static_cast<faces__AttributeData*>(attributeData);

    typedAttributeData->~faces__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const pcurves__AttributeData pcurves__AttributeData::DEFAULT = {0, 0, 0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__pcurves( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__pcurves( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__pcurves( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

pcurves__AttributeData* attributeData = newData<pcurves__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_ID:
    {

attributeData->id = attributeValue;

    break;
    }
    case HASH_ATTRIBUTE_NAME:
    {

attributeData->name = attributeValue;

    break;
    }
    case HASH_ATTRIBUTE_COUNT:
    {
bool failed;
attributeData->count = GeneratedSaxParser::Utils::toUint64(attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_PCURVES,
        HASH_ATTRIBUTE_COUNT,
        attributeValue))
{
    return false;
}
if ( !failed )
    attributeData->present_attributes |= pcurves__AttributeData::ATTRIBUTE_COUNT_PRESENT;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_PCURVES, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ( !attributeData->id )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_PCURVES, HASH_ATTRIBUTE_ID, 0 ) )
        return false;
}
if ( (attributeData->present_attributes & pcurves__AttributeData::ATTRIBUTE_COUNT_PRESENT) == 0 )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_PCURVES, HASH_ATTRIBUTE_COUNT, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__pcurves()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__pcurves();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__pcurves( void* attributeData )
{
    pcurves__AttributeData* typedAttributeData = static_cast<pcurves__AttributeData*>(attributeData);

    typedAttributeData->~pcurves__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const shells__AttributeData shells__AttributeData::DEFAULT = {0, 0, 0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__shells( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__shells( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__shells( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

shells__AttributeData* attributeData = newData<shells__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_ID:
    {

attributeData->id = attributeValue;

    break;
    }
    case HASH_ATTRIBUTE_NAME:
    {

attributeData->name = attributeValue;

    break;
    }
    case HASH_ATTRIBUTE_COUNT:
    {
bool failed;
attributeData->count = GeneratedSaxParser::Utils::toUint64(attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_SHELLS,
        HASH_ATTRIBUTE_COUNT,
        attributeValue))
{
    return false;
}
if ( !failed )
    attributeData->present_attributes |= shells__AttributeData::ATTRIBUTE_COUNT_PRESENT;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_SHELLS, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ( !attributeData->id )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_SHELLS, HASH_ATTRIBUTE_ID, 0 ) )
        return false;
}
if ( (attributeData->present_attributes & shells__AttributeData::ATTRIBUTE_COUNT_PRESENT) == 0 )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_SHELLS, HASH_ATTRIBUTE_COUNT, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__shells()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__shells();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__shells( void* attributeData )
{
    shells__AttributeData* typedAttributeData = static_cast<shells__AttributeData*>(attributeData);

    typedAttributeData->~shells__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const solids__AttributeData solids__AttributeData::DEFAULT = {0, 0, 0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__solids( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__solids( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__solids( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

solids__AttributeData* attributeData = newData<solids__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_ID:
    {

attributeData->id = attributeValue;

    break;
    }
    case HASH_ATTRIBUTE_NAME:
    {

attributeData->name = attributeValue;

    break;
    }
    case HASH_ATTRIBUTE_COUNT:
    {
bool failed;
attributeData->count = GeneratedSaxParser::Utils::toUint64(attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_SOLIDS,
        HASH_ATTRIBUTE_COUNT,
        attributeValue))
{
    return false;
}
if ( !failed )
    attributeData->present_attributes |= solids__AttributeData::ATTRIBUTE_COUNT_PRESENT;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_SOLIDS, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ( !attributeData->id )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_SOLIDS, HASH_ATTRIBUTE_ID, 0 ) )
        return false;
}
if ( (attributeData->present_attributes & solids__AttributeData::ATTRIBUTE_COUNT_PRESENT) == 0 )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_SOLIDS, HASH_ATTRIBUTE_COUNT, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__solids()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__solids();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__solids( void* attributeData )
{
    solids__AttributeData* typedAttributeData = static_cast<solids__AttributeData*>(attributeData);

    typedAttributeData->~solids__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const library_effects__AttributeData library_effects__AttributeData::DEFAULT = {0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__library_effects( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__library_effects( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__library_effects( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

library_effects__AttributeData* attributeData = newData<library_effects__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_ID:
    {

attributeData->id = attributeValue;

    break;
    }
    case HASH_ATTRIBUTE_NAME:
    {

attributeData->name = attributeValue;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_LIBRARY_EFFECTS, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__library_effects()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__library_effects();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__library_effects( void* attributeData )
{
    library_effects__AttributeData* typedAttributeData = static_cast<library_effects__AttributeData*>(attributeData);

    typedAttributeData->~library_effects__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const effect__AttributeData effect__AttributeData::DEFAULT = {0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__effect( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__effect( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__effect( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

effect__AttributeData* attributeData = newData<effect__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_ID:
    {

attributeData->id = attributeValue;

    break;
    }
    case HASH_ATTRIBUTE_NAME:
    {

attributeData->name = attributeValue;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_EFFECT, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ( !attributeData->id )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_EFFECT, HASH_ATTRIBUTE_ID, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__effect()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__effect();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__effect( void* attributeData )
{
    effect__AttributeData* typedAttributeData = static_cast<effect__AttributeData*>(attributeData);

    typedAttributeData->~effect__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const annotate__AttributeData annotate__AttributeData::DEFAULT = {0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__annotate( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__annotate( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__annotate( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

annotate__AttributeData* attributeData = newData<annotate__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_NAME:
    {

attributeData->name = attributeValue;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_ANNOTATE, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ( !attributeData->name )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_ANNOTATE, HASH_ATTRIBUTE_NAME, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__annotate()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__annotate();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__annotate( void* attributeData )
{
    annotate__AttributeData* typedAttributeData = static_cast<annotate__AttributeData*>(attributeData);

    typedAttributeData->~annotate__AttributeData();

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__bool2( const ParserChar* text, size_t textLength )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        bool2__ValidationData* validationData = (bool2__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
return characterData2BoolData(text, textLength, &ColladaParserAutoGen15::data__bool2, &validate__bool2_type__stream, &validationData->validationWholeSize, 0);
    }
    else
    {
return characterData2BoolData(text, textLength, &ColladaParserAutoGen15::data__bool2);
    }
#else
    {
return characterData2BoolData(text, textLength, &ColladaParserAutoGen15::data__bool2);
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__bool2( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__bool2( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__bool2()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__bool2();
        if ( !validationResult ) return false;

    } // validation
#endif

#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        bool2__ValidationData* validationData = (bool2__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
bool returnValue = boolDataEnd( &ColladaParserAutoGen15::data__bool2, &validate__bool2_type__streamEnd, &validationData->validationWholeSize, 0 );
        ParserError::ErrorType simpleTypeValidationResult = validate__bool2_type(0, (*(&validationData->validationWholeSize)));
        mValidationDataStack.deleteObject();
        if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
        {
            if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
                simpleTypeValidationResult,
                HASH_ELEMENT_BOOL2,
                (ParserChar*)0, 0 ) )
            {
                return false;
            }
        }
        return returnValue;
    }
    else
    {
return boolDataEnd( &ColladaParserAutoGen15::data__bool2 );
    }
#else
    {
return boolDataEnd( &ColladaParserAutoGen15::data__bool2 );
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__bool2( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__bool3( const ParserChar* text, size_t textLength )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        bool3__ValidationData* validationData = (bool3__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
return characterData2BoolData(text, textLength, &ColladaParserAutoGen15::data__bool3, &validate__bool3_type__stream, &validationData->validationWholeSize, 0);
    }
    else
    {
return characterData2BoolData(text, textLength, &ColladaParserAutoGen15::data__bool3);
    }
#else
    {
return characterData2BoolData(text, textLength, &ColladaParserAutoGen15::data__bool3);
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__bool3( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__bool3( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__bool3()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__bool3();
        if ( !validationResult ) return false;

    } // validation
#endif

#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        bool3__ValidationData* validationData = (bool3__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
bool returnValue = boolDataEnd( &ColladaParserAutoGen15::data__bool3, &validate__bool3_type__streamEnd, &validationData->validationWholeSize, 0 );
        ParserError::ErrorType simpleTypeValidationResult = validate__bool3_type(0, (*(&validationData->validationWholeSize)));
        mValidationDataStack.deleteObject();
        if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
        {
            if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
                simpleTypeValidationResult,
                HASH_ELEMENT_BOOL3,
                (ParserChar*)0, 0 ) )
            {
                return false;
            }
        }
        return returnValue;
    }
    else
    {
return boolDataEnd( &ColladaParserAutoGen15::data__bool3 );
    }
#else
    {
return boolDataEnd( &ColladaParserAutoGen15::data__bool3 );
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__bool3( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__bool4( const ParserChar* text, size_t textLength )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        bool4__ValidationData* validationData = (bool4__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
return characterData2BoolData(text, textLength, &ColladaParserAutoGen15::data__bool4, &validate__bool4_type__stream, &validationData->validationWholeSize, 0);
    }
    else
    {
return characterData2BoolData(text, textLength, &ColladaParserAutoGen15::data__bool4);
    }
#else
    {
return characterData2BoolData(text, textLength, &ColladaParserAutoGen15::data__bool4);
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__bool4( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__bool4( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__bool4()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__bool4();
        if ( !validationResult ) return false;

    } // validation
#endif

#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        bool4__ValidationData* validationData = (bool4__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
bool returnValue = boolDataEnd( &ColladaParserAutoGen15::data__bool4, &validate__bool4_type__streamEnd, &validationData->validationWholeSize, 0 );
        ParserError::ErrorType simpleTypeValidationResult = validate__bool4_type(0, (*(&validationData->validationWholeSize)));
        mValidationDataStack.deleteObject();
        if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
        {
            if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
                simpleTypeValidationResult,
                HASH_ELEMENT_BOOL4,
                (ParserChar*)0, 0 ) )
            {
                return false;
            }
        }
        return returnValue;
    }
    else
    {
return boolDataEnd( &ColladaParserAutoGen15::data__bool4 );
    }
#else
    {
return boolDataEnd( &ColladaParserAutoGen15::data__bool4 );
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__bool4( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__int2( const ParserChar* text, size_t textLength )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        int2__ValidationData* validationData = (int2__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
return characterData2Sint64Data(text, textLength, &ColladaParserAutoGen15::data__int2, &validate__int2_type__stream, &validationData->validationWholeSize, 0);
    }
    else
    {
return characterData2Sint64Data(text, textLength, &ColladaParserAutoGen15::data__int2);
    }
#else
    {
return characterData2Sint64Data(text, textLength, &ColladaParserAutoGen15::data__int2);
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__int2( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__int2( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__int2()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__int2();
        if ( !validationResult ) return false;

    } // validation
#endif

#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        int2__ValidationData* validationData = (int2__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
bool returnValue = sint64DataEnd( &ColladaParserAutoGen15::data__int2, &validate__int2_type__streamEnd, &validationData->validationWholeSize, 0 );
        ParserError::ErrorType simpleTypeValidationResult = validate__int2_type(0, (*(&validationData->validationWholeSize)));
        mValidationDataStack.deleteObject();
        if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
        {
            if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
                simpleTypeValidationResult,
                HASH_ELEMENT_INT2,
                (ParserChar*)0, 0 ) )
            {
                return false;
            }
        }
        return returnValue;
    }
    else
    {
return sint64DataEnd( &ColladaParserAutoGen15::data__int2 );
    }
#else
    {
return sint64DataEnd( &ColladaParserAutoGen15::data__int2 );
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__int2( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__int3( const ParserChar* text, size_t textLength )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        int3__ValidationData* validationData = (int3__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
return characterData2Sint64Data(text, textLength, &ColladaParserAutoGen15::data__int3, &validate__int3_type__stream, &validationData->validationWholeSize, 0);
    }
    else
    {
return characterData2Sint64Data(text, textLength, &ColladaParserAutoGen15::data__int3);
    }
#else
    {
return characterData2Sint64Data(text, textLength, &ColladaParserAutoGen15::data__int3);
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__int3( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__int3( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__int3()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__int3();
        if ( !validationResult ) return false;

    } // validation
#endif

#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        int3__ValidationData* validationData = (int3__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
bool returnValue = sint64DataEnd( &ColladaParserAutoGen15::data__int3, &validate__int3_type__streamEnd, &validationData->validationWholeSize, 0 );
        ParserError::ErrorType simpleTypeValidationResult = validate__int3_type(0, (*(&validationData->validationWholeSize)));
        mValidationDataStack.deleteObject();
        if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
        {
            if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
                simpleTypeValidationResult,
                HASH_ELEMENT_INT3,
                (ParserChar*)0, 0 ) )
            {
                return false;
            }
        }
        return returnValue;
    }
    else
    {
return sint64DataEnd( &ColladaParserAutoGen15::data__int3 );
    }
#else
    {
return sint64DataEnd( &ColladaParserAutoGen15::data__int3 );
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__int3( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__int4( const ParserChar* text, size_t textLength )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        int4__ValidationData* validationData = (int4__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
return characterData2Sint64Data(text, textLength, &ColladaParserAutoGen15::data__int4, &validate__int4_type__stream, &validationData->validationWholeSize, 0);
    }
    else
    {
return characterData2Sint64Data(text, textLength, &ColladaParserAutoGen15::data__int4);
    }
#else
    {
return characterData2Sint64Data(text, textLength, &ColladaParserAutoGen15::data__int4);
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__int4( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__int4( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__int4()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__int4();
        if ( !validationResult ) return false;

    } // validation
#endif

#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        int4__ValidationData* validationData = (int4__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
bool returnValue = sint64DataEnd( &ColladaParserAutoGen15::data__int4, &validate__int4_type__streamEnd, &validationData->validationWholeSize, 0 );
        ParserError::ErrorType simpleTypeValidationResult = validate__int4_type(0, (*(&validationData->validationWholeSize)));
        mValidationDataStack.deleteObject();
        if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
        {
            if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
                simpleTypeValidationResult,
                HASH_ELEMENT_INT4,
                (ParserChar*)0, 0 ) )
            {
                return false;
            }
        }
        return returnValue;
    }
    else
    {
return sint64DataEnd( &ColladaParserAutoGen15::data__int4 );
    }
#else
    {
return sint64DataEnd( &ColladaParserAutoGen15::data__int4 );
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__int4( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__float2( const ParserChar* text, size_t textLength )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        radius____float2_type__ValidationData* validationData = (radius____float2_type__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
return characterData2FloatData(text, textLength, &ColladaParserAutoGen15::data__float2, &validate__float2_type__stream, &validationData->validationWholeSize, 0);
    }
    else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen15::data__float2);
    }
#else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen15::data__float2);
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__float2( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__float2( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__float2()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__float2();
        if ( !validationResult ) return false;

    } // validation
#endif

#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        radius____float2_type__ValidationData* validationData = (radius____float2_type__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
bool returnValue = floatDataEnd( &ColladaParserAutoGen15::data__float2, &validate__float2_type__streamEnd, &validationData->validationWholeSize, 0 );
        ParserError::ErrorType simpleTypeValidationResult = validate__float2_type(0, (*(&validationData->validationWholeSize)));
        mValidationDataStack.deleteObject();
        if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
        {
            if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
                simpleTypeValidationResult,
                HASH_ELEMENT_FLOAT2,
                (ParserChar*)0, 0 ) )
            {
                return false;
            }
        }
        return returnValue;
    }
    else
    {
return floatDataEnd( &ColladaParserAutoGen15::data__float2 );
    }
#else
    {
return floatDataEnd( &ColladaParserAutoGen15::data__float2 );
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__float2( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__float3( const ParserChar* text, size_t textLength )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        origin____float3_type__ValidationData* validationData = (origin____float3_type__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
return characterData2FloatData(text, textLength, &ColladaParserAutoGen15::data__float3, &validate__float3_type__stream, &validationData->validationWholeSize, 0);
    }
    else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen15::data__float3);
    }
#else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen15::data__float3);
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__float3( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__float3( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__float3()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__float3();
        if ( !validationResult ) return false;

    } // validation
#endif

#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        origin____float3_type__ValidationData* validationData = (origin____float3_type__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
bool returnValue = floatDataEnd( &ColladaParserAutoGen15::data__float3, &validate__float3_type__streamEnd, &validationData->validationWholeSize, 0 );
        ParserError::ErrorType simpleTypeValidationResult = validate__float3_type(0, (*(&validationData->validationWholeSize)));
        mValidationDataStack.deleteObject();
        if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
        {
            if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
                simpleTypeValidationResult,
                HASH_ELEMENT_FLOAT3,
                (ParserChar*)0, 0 ) )
            {
                return false;
            }
        }
        return returnValue;
    }
    else
    {
return floatDataEnd( &ColladaParserAutoGen15::data__float3 );
    }
#else
    {
return floatDataEnd( &ColladaParserAutoGen15::data__float3 );
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__float3( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__float4( const ParserChar* text, size_t textLength )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        orient__ValidationData* validationData = (orient__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
return characterData2FloatData(text, textLength, &ColladaParserAutoGen15::data__float4, &validate__float4_type__stream, &validationData->validationWholeSize, 0);
    }
    else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen15::data__float4);
    }
#else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen15::data__float4);
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__float4( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__float4( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__float4()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__float4();
        if ( !validationResult ) return false;

    } // validation
#endif

#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        orient__ValidationData* validationData = (orient__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
bool returnValue = floatDataEnd( &ColladaParserAutoGen15::data__float4, &validate__float4_type__streamEnd, &validationData->validationWholeSize, 0 );
        ParserError::ErrorType simpleTypeValidationResult = validate__float4_type(0, (*(&validationData->validationWholeSize)));
        mValidationDataStack.deleteObject();
        if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
        {
            if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
                simpleTypeValidationResult,
                HASH_ELEMENT_FLOAT4,
                (ParserChar*)0, 0 ) )
            {
                return false;
            }
        }
        return returnValue;
    }
    else
    {
return floatDataEnd( &ColladaParserAutoGen15::data__float4 );
    }
#else
    {
return floatDataEnd( &ColladaParserAutoGen15::data__float4 );
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__float4( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__float2x2( const ParserChar* text, size_t textLength )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        float2x2__ValidationData* validationData = (float2x2__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
return characterData2FloatData(text, textLength, &ColladaParserAutoGen15::data__float2x2, &validate__float2x2_type__stream, &validationData->validationWholeSize, 0);
    }
    else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen15::data__float2x2);
    }
#else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen15::data__float2x2);
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__float2x2( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__float2x2( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__float2x2()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__float2x2();
        if ( !validationResult ) return false;

    } // validation
#endif

#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        float2x2__ValidationData* validationData = (float2x2__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
bool returnValue = floatDataEnd( &ColladaParserAutoGen15::data__float2x2, &validate__float2x2_type__streamEnd, &validationData->validationWholeSize, 0 );
        ParserError::ErrorType simpleTypeValidationResult = validate__float2x2_type(0, (*(&validationData->validationWholeSize)));
        mValidationDataStack.deleteObject();
        if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
        {
            if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
                simpleTypeValidationResult,
                HASH_ELEMENT_FLOAT2X2,
                (ParserChar*)0, 0 ) )
            {
                return false;
            }
        }
        return returnValue;
    }
    else
    {
return floatDataEnd( &ColladaParserAutoGen15::data__float2x2 );
    }
#else
    {
return floatDataEnd( &ColladaParserAutoGen15::data__float2x2 );
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__float2x2( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__float3x3( const ParserChar* text, size_t textLength )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        float3x3__ValidationData* validationData = (float3x3__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
return characterData2FloatData(text, textLength, &ColladaParserAutoGen15::data__float3x3, &validate__float3x3_type__stream, &validationData->validationWholeSize, 0);
    }
    else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen15::data__float3x3);
    }
#else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen15::data__float3x3);
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__float3x3( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__float3x3( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__float3x3()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__float3x3();
        if ( !validationResult ) return false;

    } // validation
#endif

#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        float3x3__ValidationData* validationData = (float3x3__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
bool returnValue = floatDataEnd( &ColladaParserAutoGen15::data__float3x3, &validate__float3x3_type__streamEnd, &validationData->validationWholeSize, 0 );
        ParserError::ErrorType simpleTypeValidationResult = validate__float3x3_type(0, (*(&validationData->validationWholeSize)));
        mValidationDataStack.deleteObject();
        if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
        {
            if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
                simpleTypeValidationResult,
                HASH_ELEMENT_FLOAT3X3,
                (ParserChar*)0, 0 ) )
            {
                return false;
            }
        }
        return returnValue;
    }
    else
    {
return floatDataEnd( &ColladaParserAutoGen15::data__float3x3 );
    }
#else
    {
return floatDataEnd( &ColladaParserAutoGen15::data__float3x3 );
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__float3x3( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__float4x4( const ParserChar* text, size_t textLength )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        bind_shape_matrix__ValidationData* validationData = (bind_shape_matrix__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
return characterData2FloatData(text, textLength, &ColladaParserAutoGen15::data__float4x4, &validate__float4x4_type__stream, &validationData->validationWholeSize, 0);
    }
    else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen15::data__float4x4);
    }
#else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen15::data__float4x4);
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__float4x4( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__float4x4( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__float4x4()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__float4x4();
        if ( !validationResult ) return false;

    } // validation
#endif

#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        bind_shape_matrix__ValidationData* validationData = (bind_shape_matrix__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
bool returnValue = floatDataEnd( &ColladaParserAutoGen15::data__float4x4, &validate__float4x4_type__streamEnd, &validationData->validationWholeSize, 0 );
        ParserError::ErrorType simpleTypeValidationResult = validate__float4x4_type(0, (*(&validationData->validationWholeSize)));
        mValidationDataStack.deleteObject();
        if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
        {
            if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
                simpleTypeValidationResult,
                HASH_ELEMENT_FLOAT4X4,
                (ParserChar*)0, 0 ) )
            {
                return false;
            }
        }
        return returnValue;
    }
    else
    {
return floatDataEnd( &ColladaParserAutoGen15::data__float4x4 );
    }
#else
    {
return floatDataEnd( &ColladaParserAutoGen15::data__float4x4 );
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__float4x4( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__string( const ParserChar* text, size_t textLength )
{

return mImpl->data__string(text, textLength);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__string( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__string( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__string()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__string();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__string( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
const newparam____fx_newparam_type__AttributeData newparam____fx_newparam_type__AttributeData::DEFAULT = {0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__newparam____fx_newparam_type( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__newparam____fx_newparam_type( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__newparam____fx_newparam_type( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

newparam____fx_newparam_type__AttributeData* attributeData = newData<newparam____fx_newparam_type__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_SID:
    {

attributeData->sid = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__sid_type(attributeData->sid, strlen(attributeData->sid));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_NEWPARAM,
            HASH_ATTRIBUTE_SID,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_NEWPARAM, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ( !attributeData->sid )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_NEWPARAM, HASH_ATTRIBUTE_SID, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__newparam____fx_newparam_type()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__newparam____fx_newparam_type();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__newparam____fx_newparam_type( void* attributeData )
{
    newparam____fx_newparam_type__AttributeData* typedAttributeData = static_cast<newparam____fx_newparam_type__AttributeData*>(attributeData);

    typedAttributeData->~newparam____fx_newparam_type__AttributeData();

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__semantic____NCName( const ParserChar* text, size_t textLength )
{
if (!mLastIncompleteFragmentInCharacterData)
{
    mLastIncompleteFragmentInCharacterData = (ParserChar*)mStackMemoryManager.newObject(textLength);
    memcpy(mLastIncompleteFragmentInCharacterData, text, textLength);
    mEndOfDataInCurrentObjectOnStack = mLastIncompleteFragmentInCharacterData + textLength;
}
else
{
    ParserChar* tmp = (ParserChar*)mStackMemoryManager.growObject(textLength);
    if ( tmp != mLastIncompleteFragmentInCharacterData ) {
        mEndOfDataInCurrentObjectOnStack = (mEndOfDataInCurrentObjectOnStack - mLastIncompleteFragmentInCharacterData) + tmp;
        mLastIncompleteFragmentInCharacterData = tmp;
    }
    memcpy(mEndOfDataInCurrentObjectOnStack, text, textLength);
    mEndOfDataInCurrentObjectOnStack += textLength;
}
return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__semantic____NCName( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__semantic____NCName( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__semantic____NCName()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__semantic____NCName();
        if ( !validationResult ) return false;

    } // validation
#endif

bool returnValue = true;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
ParserError::ErrorType simpleTypeValidationResult = validate__NCName(mLastIncompleteFragmentInCharacterData, mEndOfDataInCurrentObjectOnStack - mLastIncompleteFragmentInCharacterData);
if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
{
    ParserChar msg[21];
    Utils::fillErrorMsg(msg, mLastIncompleteFragmentInCharacterData, 20);
    if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        simpleTypeValidationResult,
        0,
        msg) )
    {
        returnValue =  false;
    }
}
if (!returnValue)
{
    mStackMemoryManager.deleteObject();
    mLastIncompleteFragmentInCharacterData = 0;
    mEndOfDataInCurrentObjectOnStack = 0;
    return returnValue;
}
    } // validation
#endif
returnValue = mImpl->data__semantic____NCName(mLastIncompleteFragmentInCharacterData, mEndOfDataInCurrentObjectOnStack - mLastIncompleteFragmentInCharacterData);
mStackMemoryManager.deleteObject();
mLastIncompleteFragmentInCharacterData = 0;
mEndOfDataInCurrentObjectOnStack = 0;
return returnValue;

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__semantic____NCName( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__modifier( const ParserChar* text, size_t textLength )
{
if (!mLastIncompleteFragmentInCharacterData)
{
    mLastIncompleteFragmentInCharacterData = (ParserChar*)mStackMemoryManager.newObject(textLength);
    memcpy(mLastIncompleteFragmentInCharacterData, text, textLength);
    mEndOfDataInCurrentObjectOnStack = mLastIncompleteFragmentInCharacterData + textLength;
}
else
{
    ParserChar* tmp = (ParserChar*)mStackMemoryManager.growObject(textLength);
    if ( tmp != mLastIncompleteFragmentInCharacterData ) {
        mEndOfDataInCurrentObjectOnStack = (mEndOfDataInCurrentObjectOnStack - mLastIncompleteFragmentInCharacterData) + tmp;
        mLastIncompleteFragmentInCharacterData = tmp;
    }
    memcpy(mEndOfDataInCurrentObjectOnStack, text, textLength);
    mEndOfDataInCurrentObjectOnStack += textLength;
}
return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__modifier( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__modifier( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__modifier()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__modifier();
        if ( !validationResult ) return false;

    } // validation
#endif

bool failed;
ENUM__fx_modifier_enum parameter = Utils::toEnum<ENUM__fx_modifier_enum, StringHash, ENUM__fx_modifier_enum__COUNT>((const ParserChar**)&mLastIncompleteFragmentInCharacterData, mEndOfDataInCurrentObjectOnStack, failed, ENUM__fx_modifier_enumMap, Utils::calculateStringHash);
bool returnValue;
if (!failed)
{
    returnValue = mImpl->data__modifier(parameter);
}
else
    returnValue = !handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_TEXTDATA_PARSING_FAILED, HASH_ELEMENT_MODIFIER, (const ParserChar*)0, mLastIncompleteFragmentInCharacterData);
if (mLastIncompleteFragmentInCharacterData)
    mStackMemoryManager.deleteObject();
mLastIncompleteFragmentInCharacterData = 0;
mEndOfDataInCurrentObjectOnStack = 0;
return returnValue;

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__modifier( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
ENUM__fx_modifier_enum ColladaParserAutoGen15Private::toEnumDataPrefix_ENUM__fx_modifier_enum (
    const ParserChar* prefixedBuffer,
    const ParserChar* prefixedBufferEnd,
    const ParserChar** buffer,
    const ParserChar* bufferEnd,
    bool& failed,
    const std::pair<StringHash, ENUM__fx_modifier_enum>* enumMap,
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& )
)
{
    return toEnumDataPrefix<ENUM__fx_modifier_enum, StringHash, ENUM__fx_modifier_enum__COUNT, &toEnum_ENUM__fx_modifier_enum>(prefixedBuffer, prefixedBufferEnd, buffer, bufferEnd, failed, enumMap, baseConversionFunc);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::characterData2EnumData_ENUM__fx_modifier_enum (
    const ParserChar* text,
    size_t textLength,
    bool ( ColladaParserAutoGen15::*dataFunction )(const ENUM__fx_modifier_enum*, size_t ),
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& )
)
{
    return characterData2EnumData<ENUM__fx_modifier_enum, StringHash, ENUM__fx_modifier_enum__COUNT>(text, textLength, dataFunction, ENUM__fx_modifier_enumMap, baseConversionFunc, &toEnum_ENUM__fx_modifier_enum, &ColladaParserAutoGen15Private::toEnumDataPrefix_ENUM__fx_modifier_enum);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::dataEnumEnd_ENUM__fx_modifier_enum (
    bool ( ColladaParserAutoGen15::*dataFunction )(const ENUM__fx_modifier_enum*, size_t ),
    const std::pair<StringHash, ENUM__fx_modifier_enum>* enumMap,
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& ),
    ENUM__fx_modifier_enum (*toEnumFunc)( const ParserChar**, const ParserChar*, bool&, const std::pair<StringHash, ENUM__fx_modifier_enum>* enumMap, StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& ))
)
{
    return dataEnumEnd<ENUM__fx_modifier_enum, StringHash, ENUM__fx_modifier_enum__COUNT>(dataFunction, enumMap, baseConversionFunc, toEnumFunc);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__float2x1( const ParserChar* text, size_t textLength )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        radius____float2_type__ValidationData* validationData = (radius____float2_type__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
return characterData2FloatData(text, textLength, &ColladaParserAutoGen15::data__float2x1, &validate__float2_type__stream, &validationData->validationWholeSize, 0);
    }
    else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen15::data__float2x1);
    }
#else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen15::data__float2x1);
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__float2x1( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__float2x1( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__float2x1()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__float2x1();
        if ( !validationResult ) return false;

    } // validation
#endif

#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        radius____float2_type__ValidationData* validationData = (radius____float2_type__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
bool returnValue = floatDataEnd( &ColladaParserAutoGen15::data__float2x1, &validate__float2_type__streamEnd, &validationData->validationWholeSize, 0 );
        ParserError::ErrorType simpleTypeValidationResult = validate__float2_type(0, (*(&validationData->validationWholeSize)));
        mValidationDataStack.deleteObject();
        if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
        {
            if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
                simpleTypeValidationResult,
                HASH_ELEMENT_FLOAT2X1,
                (ParserChar*)0, 0 ) )
            {
                return false;
            }
        }
        return returnValue;
    }
    else
    {
return floatDataEnd( &ColladaParserAutoGen15::data__float2x1 );
    }
#else
    {
return floatDataEnd( &ColladaParserAutoGen15::data__float2x1 );
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__float2x1( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__float2x3( const ParserChar* text, size_t textLength )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        float2x3__ValidationData* validationData = (float2x3__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
return characterData2FloatData(text, textLength, &ColladaParserAutoGen15::data__float2x3, &validate__float2x3_type__stream, &validationData->validationWholeSize, 0);
    }
    else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen15::data__float2x3);
    }
#else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen15::data__float2x3);
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__float2x3( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__float2x3( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__float2x3()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__float2x3();
        if ( !validationResult ) return false;

    } // validation
#endif

#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        float2x3__ValidationData* validationData = (float2x3__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
bool returnValue = floatDataEnd( &ColladaParserAutoGen15::data__float2x3, &validate__float2x3_type__streamEnd, &validationData->validationWholeSize, 0 );
        ParserError::ErrorType simpleTypeValidationResult = validate__float2x3_type(0, (*(&validationData->validationWholeSize)));
        mValidationDataStack.deleteObject();
        if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
        {
            if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
                simpleTypeValidationResult,
                HASH_ELEMENT_FLOAT2X3,
                (ParserChar*)0, 0 ) )
            {
                return false;
            }
        }
        return returnValue;
    }
    else
    {
return floatDataEnd( &ColladaParserAutoGen15::data__float2x3 );
    }
#else
    {
return floatDataEnd( &ColladaParserAutoGen15::data__float2x3 );
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__float2x3( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__float2x4( const ParserChar* text, size_t textLength )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        float2x4__ValidationData* validationData = (float2x4__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
return characterData2FloatData(text, textLength, &ColladaParserAutoGen15::data__float2x4, &validate__float2x4_type__stream, &validationData->validationWholeSize, 0);
    }
    else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen15::data__float2x4);
    }
#else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen15::data__float2x4);
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__float2x4( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__float2x4( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__float2x4()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__float2x4();
        if ( !validationResult ) return false;

    } // validation
#endif

#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        float2x4__ValidationData* validationData = (float2x4__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
bool returnValue = floatDataEnd( &ColladaParserAutoGen15::data__float2x4, &validate__float2x4_type__streamEnd, &validationData->validationWholeSize, 0 );
        ParserError::ErrorType simpleTypeValidationResult = validate__float2x4_type(0, (*(&validationData->validationWholeSize)));
        mValidationDataStack.deleteObject();
        if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
        {
            if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
                simpleTypeValidationResult,
                HASH_ELEMENT_FLOAT2X4,
                (ParserChar*)0, 0 ) )
            {
                return false;
            }
        }
        return returnValue;
    }
    else
    {
return floatDataEnd( &ColladaParserAutoGen15::data__float2x4 );
    }
#else
    {
return floatDataEnd( &ColladaParserAutoGen15::data__float2x4 );
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__float2x4( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__float3x1( const ParserChar* text, size_t textLength )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        origin____float3_type__ValidationData* validationData = (origin____float3_type__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
return characterData2FloatData(text, textLength, &ColladaParserAutoGen15::data__float3x1, &validate__float3_type__stream, &validationData->validationWholeSize, 0);
    }
    else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen15::data__float3x1);
    }
#else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen15::data__float3x1);
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__float3x1( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__float3x1( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__float3x1()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__float3x1();
        if ( !validationResult ) return false;

    } // validation
#endif

#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        origin____float3_type__ValidationData* validationData = (origin____float3_type__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
bool returnValue = floatDataEnd( &ColladaParserAutoGen15::data__float3x1, &validate__float3_type__streamEnd, &validationData->validationWholeSize, 0 );
        ParserError::ErrorType simpleTypeValidationResult = validate__float3_type(0, (*(&validationData->validationWholeSize)));
        mValidationDataStack.deleteObject();
        if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
        {
            if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
                simpleTypeValidationResult,
                HASH_ELEMENT_FLOAT3X1,
                (ParserChar*)0, 0 ) )
            {
                return false;
            }
        }
        return returnValue;
    }
    else
    {
return floatDataEnd( &ColladaParserAutoGen15::data__float3x1 );
    }
#else
    {
return floatDataEnd( &ColladaParserAutoGen15::data__float3x1 );
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__float3x1( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__float3x2( const ParserChar* text, size_t textLength )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        float3x2__ValidationData* validationData = (float3x2__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
return characterData2FloatData(text, textLength, &ColladaParserAutoGen15::data__float3x2, &validate__float3x2_type__stream, &validationData->validationWholeSize, 0);
    }
    else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen15::data__float3x2);
    }
#else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen15::data__float3x2);
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__float3x2( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__float3x2( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__float3x2()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__float3x2();
        if ( !validationResult ) return false;

    } // validation
#endif

#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        float3x2__ValidationData* validationData = (float3x2__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
bool returnValue = floatDataEnd( &ColladaParserAutoGen15::data__float3x2, &validate__float3x2_type__streamEnd, &validationData->validationWholeSize, 0 );
        ParserError::ErrorType simpleTypeValidationResult = validate__float3x2_type(0, (*(&validationData->validationWholeSize)));
        mValidationDataStack.deleteObject();
        if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
        {
            if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
                simpleTypeValidationResult,
                HASH_ELEMENT_FLOAT3X2,
                (ParserChar*)0, 0 ) )
            {
                return false;
            }
        }
        return returnValue;
    }
    else
    {
return floatDataEnd( &ColladaParserAutoGen15::data__float3x2 );
    }
#else
    {
return floatDataEnd( &ColladaParserAutoGen15::data__float3x2 );
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__float3x2( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__float3x4( const ParserChar* text, size_t textLength )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        float3x4__ValidationData* validationData = (float3x4__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
return characterData2FloatData(text, textLength, &ColladaParserAutoGen15::data__float3x4, &validate__float3x4_type__stream, &validationData->validationWholeSize, 0);
    }
    else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen15::data__float3x4);
    }
#else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen15::data__float3x4);
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__float3x4( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__float3x4( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__float3x4()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__float3x4();
        if ( !validationResult ) return false;

    } // validation
#endif

#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        float3x4__ValidationData* validationData = (float3x4__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
bool returnValue = floatDataEnd( &ColladaParserAutoGen15::data__float3x4, &validate__float3x4_type__streamEnd, &validationData->validationWholeSize, 0 );
        ParserError::ErrorType simpleTypeValidationResult = validate__float3x4_type(0, (*(&validationData->validationWholeSize)));
        mValidationDataStack.deleteObject();
        if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
        {
            if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
                simpleTypeValidationResult,
                HASH_ELEMENT_FLOAT3X4,
                (ParserChar*)0, 0 ) )
            {
                return false;
            }
        }
        return returnValue;
    }
    else
    {
return floatDataEnd( &ColladaParserAutoGen15::data__float3x4 );
    }
#else
    {
return floatDataEnd( &ColladaParserAutoGen15::data__float3x4 );
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__float3x4( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__float4x1( const ParserChar* text, size_t textLength )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        orient__ValidationData* validationData = (orient__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
return characterData2FloatData(text, textLength, &ColladaParserAutoGen15::data__float4x1, &validate__float4_type__stream, &validationData->validationWholeSize, 0);
    }
    else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen15::data__float4x1);
    }
#else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen15::data__float4x1);
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__float4x1( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__float4x1( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__float4x1()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__float4x1();
        if ( !validationResult ) return false;

    } // validation
#endif

#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        orient__ValidationData* validationData = (orient__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
bool returnValue = floatDataEnd( &ColladaParserAutoGen15::data__float4x1, &validate__float4_type__streamEnd, &validationData->validationWholeSize, 0 );
        ParserError::ErrorType simpleTypeValidationResult = validate__float4_type(0, (*(&validationData->validationWholeSize)));
        mValidationDataStack.deleteObject();
        if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
        {
            if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
                simpleTypeValidationResult,
                HASH_ELEMENT_FLOAT4X1,
                (ParserChar*)0, 0 ) )
            {
                return false;
            }
        }
        return returnValue;
    }
    else
    {
return floatDataEnd( &ColladaParserAutoGen15::data__float4x1 );
    }
#else
    {
return floatDataEnd( &ColladaParserAutoGen15::data__float4x1 );
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__float4x1( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__float4x2( const ParserChar* text, size_t textLength )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        float4x2__ValidationData* validationData = (float4x2__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
return characterData2FloatData(text, textLength, &ColladaParserAutoGen15::data__float4x2, &validate__float4x2_type__stream, &validationData->validationWholeSize, 0);
    }
    else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen15::data__float4x2);
    }
#else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen15::data__float4x2);
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__float4x2( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__float4x2( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__float4x2()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__float4x2();
        if ( !validationResult ) return false;

    } // validation
#endif

#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        float4x2__ValidationData* validationData = (float4x2__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
bool returnValue = floatDataEnd( &ColladaParserAutoGen15::data__float4x2, &validate__float4x2_type__streamEnd, &validationData->validationWholeSize, 0 );
        ParserError::ErrorType simpleTypeValidationResult = validate__float4x2_type(0, (*(&validationData->validationWholeSize)));
        mValidationDataStack.deleteObject();
        if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
        {
            if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
                simpleTypeValidationResult,
                HASH_ELEMENT_FLOAT4X2,
                (ParserChar*)0, 0 ) )
            {
                return false;
            }
        }
        return returnValue;
    }
    else
    {
return floatDataEnd( &ColladaParserAutoGen15::data__float4x2 );
    }
#else
    {
return floatDataEnd( &ColladaParserAutoGen15::data__float4x2 );
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__float4x2( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__float4x3( const ParserChar* text, size_t textLength )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        float4x3__ValidationData* validationData = (float4x3__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
return characterData2FloatData(text, textLength, &ColladaParserAutoGen15::data__float4x3, &validate__float4x3_type__stream, &validationData->validationWholeSize, 0);
    }
    else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen15::data__float4x3);
    }
#else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen15::data__float4x3);
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__float4x3( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__float4x3( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__float4x3()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__float4x3();
        if ( !validationResult ) return false;

    } // validation
#endif

#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        float4x3__ValidationData* validationData = (float4x3__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
bool returnValue = floatDataEnd( &ColladaParserAutoGen15::data__float4x3, &validate__float4x3_type__streamEnd, &validationData->validationWholeSize, 0 );
        ParserError::ErrorType simpleTypeValidationResult = validate__float4x3_type(0, (*(&validationData->validationWholeSize)));
        mValidationDataStack.deleteObject();
        if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
        {
            if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
                simpleTypeValidationResult,
                HASH_ELEMENT_FLOAT4X3,
                (ParserChar*)0, 0 ) )
            {
                return false;
            }
        }
        return returnValue;
    }
    else
    {
return floatDataEnd( &ColladaParserAutoGen15::data__float4x3 );
    }
#else
    {
return floatDataEnd( &ColladaParserAutoGen15::data__float4x3 );
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__float4x3( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__sampler1D( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__sampler1D( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__sampler1D( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__sampler1D()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__sampler1D();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__sampler1D( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
const instance_image__AttributeData instance_image__AttributeData::DEFAULT = {0, 0, 0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__instance_image( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__instance_image( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__instance_image( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

instance_image__AttributeData* attributeData = newData<instance_image__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_URL:
    {
bool failed;
attributeData->url = GeneratedSaxParser::Utils::toURI(&attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_INSTANCE_IMAGE,
        HASH_ATTRIBUTE_URL,
        attributeValue))
{
    return false;
}
if ( !failed )
    attributeData->present_attributes |= instance_image__AttributeData::ATTRIBUTE_URL_PRESENT;

    break;
    }
    case HASH_ATTRIBUTE_SID:
    {

attributeData->sid = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__sid_type(attributeData->sid, strlen(attributeData->sid));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_INSTANCE_IMAGE,
            HASH_ATTRIBUTE_SID,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    case HASH_ATTRIBUTE_NAME:
    {

attributeData->name = attributeValue;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_INSTANCE_IMAGE, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ((attributeData->present_attributes & instance_image__AttributeData::ATTRIBUTE_URL_PRESENT) == 0)
{
    attributeData->url = COLLADABU::URI("");
}
if ( (attributeData->present_attributes & instance_image__AttributeData::ATTRIBUTE_URL_PRESENT) == 0 )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_INSTANCE_IMAGE, HASH_ATTRIBUTE_URL, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__instance_image()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__instance_image();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__instance_image( void* attributeData )
{
    instance_image__AttributeData* typedAttributeData = static_cast<instance_image__AttributeData*>(attributeData);

    typedAttributeData->~instance_image__AttributeData();

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__wrap_s____fx_sampler_wrap_enum( const ParserChar* text, size_t textLength )
{
if (!mLastIncompleteFragmentInCharacterData)
{
    mLastIncompleteFragmentInCharacterData = (ParserChar*)mStackMemoryManager.newObject(textLength);
    memcpy(mLastIncompleteFragmentInCharacterData, text, textLength);
    mEndOfDataInCurrentObjectOnStack = mLastIncompleteFragmentInCharacterData + textLength;
}
else
{
    ParserChar* tmp = (ParserChar*)mStackMemoryManager.growObject(textLength);
    if ( tmp != mLastIncompleteFragmentInCharacterData ) {
        mEndOfDataInCurrentObjectOnStack = (mEndOfDataInCurrentObjectOnStack - mLastIncompleteFragmentInCharacterData) + tmp;
        mLastIncompleteFragmentInCharacterData = tmp;
    }
    memcpy(mEndOfDataInCurrentObjectOnStack, text, textLength);
    mEndOfDataInCurrentObjectOnStack += textLength;
}
return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__wrap_s____fx_sampler_wrap_enum( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__wrap_s____fx_sampler_wrap_enum( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__wrap_s____fx_sampler_wrap_enum()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__wrap_s____fx_sampler_wrap_enum();
        if ( !validationResult ) return false;

    } // validation
#endif

bool failed;
ENUM__fx_sampler_wrap_enum parameter = Utils::toEnum<ENUM__fx_sampler_wrap_enum, StringHash, ENUM__fx_sampler_wrap_enum__COUNT>((const ParserChar**)&mLastIncompleteFragmentInCharacterData, mEndOfDataInCurrentObjectOnStack, failed, ENUM__fx_sampler_wrap_enumMap, Utils::calculateStringHash);
bool returnValue;
if (!failed)
{
    returnValue = mImpl->data__wrap_s____fx_sampler_wrap_enum(parameter);
}
else
    returnValue = !handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_TEXTDATA_PARSING_FAILED, HASH_ELEMENT_WRAP_S, (const ParserChar*)0, mLastIncompleteFragmentInCharacterData);
if (mLastIncompleteFragmentInCharacterData)
    mStackMemoryManager.deleteObject();
mLastIncompleteFragmentInCharacterData = 0;
mEndOfDataInCurrentObjectOnStack = 0;
return returnValue;

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__wrap_s____fx_sampler_wrap_enum( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
ENUM__fx_sampler_wrap_enum ColladaParserAutoGen15Private::toEnumDataPrefix_ENUM__fx_sampler_wrap_enum (
    const ParserChar* prefixedBuffer,
    const ParserChar* prefixedBufferEnd,
    const ParserChar** buffer,
    const ParserChar* bufferEnd,
    bool& failed,
    const std::pair<StringHash, ENUM__fx_sampler_wrap_enum>* enumMap,
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& )
)
{
    return toEnumDataPrefix<ENUM__fx_sampler_wrap_enum, StringHash, ENUM__fx_sampler_wrap_enum__COUNT, &toEnum_ENUM__fx_sampler_wrap_enum>(prefixedBuffer, prefixedBufferEnd, buffer, bufferEnd, failed, enumMap, baseConversionFunc);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::characterData2EnumData_ENUM__fx_sampler_wrap_enum (
    const ParserChar* text,
    size_t textLength,
    bool ( ColladaParserAutoGen15::*dataFunction )(const ENUM__fx_sampler_wrap_enum*, size_t ),
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& )
)
{
    return characterData2EnumData<ENUM__fx_sampler_wrap_enum, StringHash, ENUM__fx_sampler_wrap_enum__COUNT>(text, textLength, dataFunction, ENUM__fx_sampler_wrap_enumMap, baseConversionFunc, &toEnum_ENUM__fx_sampler_wrap_enum, &ColladaParserAutoGen15Private::toEnumDataPrefix_ENUM__fx_sampler_wrap_enum);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::dataEnumEnd_ENUM__fx_sampler_wrap_enum (
    bool ( ColladaParserAutoGen15::*dataFunction )(const ENUM__fx_sampler_wrap_enum*, size_t ),
    const std::pair<StringHash, ENUM__fx_sampler_wrap_enum>* enumMap,
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& ),
    ENUM__fx_sampler_wrap_enum (*toEnumFunc)( const ParserChar**, const ParserChar*, bool&, const std::pair<StringHash, ENUM__fx_sampler_wrap_enum>* enumMap, StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& ))
)
{
    return dataEnumEnd<ENUM__fx_sampler_wrap_enum, StringHash, ENUM__fx_sampler_wrap_enum__COUNT>(dataFunction, enumMap, baseConversionFunc, toEnumFunc);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__wrap_t____fx_sampler_wrap_enum( const ParserChar* text, size_t textLength )
{
if (!mLastIncompleteFragmentInCharacterData)
{
    mLastIncompleteFragmentInCharacterData = (ParserChar*)mStackMemoryManager.newObject(textLength);
    memcpy(mLastIncompleteFragmentInCharacterData, text, textLength);
    mEndOfDataInCurrentObjectOnStack = mLastIncompleteFragmentInCharacterData + textLength;
}
else
{
    ParserChar* tmp = (ParserChar*)mStackMemoryManager.growObject(textLength);
    if ( tmp != mLastIncompleteFragmentInCharacterData ) {
        mEndOfDataInCurrentObjectOnStack = (mEndOfDataInCurrentObjectOnStack - mLastIncompleteFragmentInCharacterData) + tmp;
        mLastIncompleteFragmentInCharacterData = tmp;
    }
    memcpy(mEndOfDataInCurrentObjectOnStack, text, textLength);
    mEndOfDataInCurrentObjectOnStack += textLength;
}
return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__wrap_t____fx_sampler_wrap_enum( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__wrap_t____fx_sampler_wrap_enum( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__wrap_t____fx_sampler_wrap_enum()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__wrap_t____fx_sampler_wrap_enum();
        if ( !validationResult ) return false;

    } // validation
#endif

bool failed;
ENUM__fx_sampler_wrap_enum parameter = Utils::toEnum<ENUM__fx_sampler_wrap_enum, StringHash, ENUM__fx_sampler_wrap_enum__COUNT>((const ParserChar**)&mLastIncompleteFragmentInCharacterData, mEndOfDataInCurrentObjectOnStack, failed, ENUM__fx_sampler_wrap_enumMap, Utils::calculateStringHash);
bool returnValue;
if (!failed)
{
    returnValue = mImpl->data__wrap_t____fx_sampler_wrap_enum(parameter);
}
else
    returnValue = !handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_TEXTDATA_PARSING_FAILED, HASH_ELEMENT_WRAP_T, (const ParserChar*)0, mLastIncompleteFragmentInCharacterData);
if (mLastIncompleteFragmentInCharacterData)
    mStackMemoryManager.deleteObject();
mLastIncompleteFragmentInCharacterData = 0;
mEndOfDataInCurrentObjectOnStack = 0;
return returnValue;

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__wrap_t____fx_sampler_wrap_enum( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__wrap_p( const ParserChar* text, size_t textLength )
{
if (!mLastIncompleteFragmentInCharacterData)
{
    mLastIncompleteFragmentInCharacterData = (ParserChar*)mStackMemoryManager.newObject(textLength);
    memcpy(mLastIncompleteFragmentInCharacterData, text, textLength);
    mEndOfDataInCurrentObjectOnStack = mLastIncompleteFragmentInCharacterData + textLength;
}
else
{
    ParserChar* tmp = (ParserChar*)mStackMemoryManager.growObject(textLength);
    if ( tmp != mLastIncompleteFragmentInCharacterData ) {
        mEndOfDataInCurrentObjectOnStack = (mEndOfDataInCurrentObjectOnStack - mLastIncompleteFragmentInCharacterData) + tmp;
        mLastIncompleteFragmentInCharacterData = tmp;
    }
    memcpy(mEndOfDataInCurrentObjectOnStack, text, textLength);
    mEndOfDataInCurrentObjectOnStack += textLength;
}
return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__wrap_p( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__wrap_p( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__wrap_p()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__wrap_p();
        if ( !validationResult ) return false;

    } // validation
#endif

bool failed;
ENUM__fx_sampler_wrap_enum parameter = Utils::toEnum<ENUM__fx_sampler_wrap_enum, StringHash, ENUM__fx_sampler_wrap_enum__COUNT>((const ParserChar**)&mLastIncompleteFragmentInCharacterData, mEndOfDataInCurrentObjectOnStack, failed, ENUM__fx_sampler_wrap_enumMap, Utils::calculateStringHash);
bool returnValue;
if (!failed)
{
    returnValue = mImpl->data__wrap_p(parameter);
}
else
    returnValue = !handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_TEXTDATA_PARSING_FAILED, HASH_ELEMENT_WRAP_P, (const ParserChar*)0, mLastIncompleteFragmentInCharacterData);
if (mLastIncompleteFragmentInCharacterData)
    mStackMemoryManager.deleteObject();
mLastIncompleteFragmentInCharacterData = 0;
mEndOfDataInCurrentObjectOnStack = 0;
return returnValue;

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__wrap_p( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__minfilter( const ParserChar* text, size_t textLength )
{
if (!mLastIncompleteFragmentInCharacterData)
{
    mLastIncompleteFragmentInCharacterData = (ParserChar*)mStackMemoryManager.newObject(textLength);
    memcpy(mLastIncompleteFragmentInCharacterData, text, textLength);
    mEndOfDataInCurrentObjectOnStack = mLastIncompleteFragmentInCharacterData + textLength;
}
else
{
    ParserChar* tmp = (ParserChar*)mStackMemoryManager.growObject(textLength);
    if ( tmp != mLastIncompleteFragmentInCharacterData ) {
        mEndOfDataInCurrentObjectOnStack = (mEndOfDataInCurrentObjectOnStack - mLastIncompleteFragmentInCharacterData) + tmp;
        mLastIncompleteFragmentInCharacterData = tmp;
    }
    memcpy(mEndOfDataInCurrentObjectOnStack, text, textLength);
    mEndOfDataInCurrentObjectOnStack += textLength;
}
return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__minfilter( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__minfilter( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__minfilter()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__minfilter();
        if ( !validationResult ) return false;

    } // validation
#endif

bool failed;
ENUM__fx_sampler_min_filter_enum parameter = Utils::toEnum<ENUM__fx_sampler_min_filter_enum, StringHash, ENUM__fx_sampler_min_filter_enum__COUNT>((const ParserChar**)&mLastIncompleteFragmentInCharacterData, mEndOfDataInCurrentObjectOnStack, failed, ENUM__fx_sampler_min_filter_enumMap, Utils::calculateStringHash);
bool returnValue;
if (!failed)
{
    returnValue = mImpl->data__minfilter(parameter);
}
else
    returnValue = !handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_TEXTDATA_PARSING_FAILED, HASH_ELEMENT_MINFILTER, (const ParserChar*)0, mLastIncompleteFragmentInCharacterData);
if (mLastIncompleteFragmentInCharacterData)
    mStackMemoryManager.deleteObject();
mLastIncompleteFragmentInCharacterData = 0;
mEndOfDataInCurrentObjectOnStack = 0;
return returnValue;

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__minfilter( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
ENUM__fx_sampler_min_filter_enum ColladaParserAutoGen15Private::toEnumDataPrefix_ENUM__fx_sampler_min_filter_enum (
    const ParserChar* prefixedBuffer,
    const ParserChar* prefixedBufferEnd,
    const ParserChar** buffer,
    const ParserChar* bufferEnd,
    bool& failed,
    const std::pair<StringHash, ENUM__fx_sampler_min_filter_enum>* enumMap,
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& )
)
{
    return toEnumDataPrefix<ENUM__fx_sampler_min_filter_enum, StringHash, ENUM__fx_sampler_min_filter_enum__COUNT, &toEnum_ENUM__fx_sampler_min_filter_enum>(prefixedBuffer, prefixedBufferEnd, buffer, bufferEnd, failed, enumMap, baseConversionFunc);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::characterData2EnumData_ENUM__fx_sampler_min_filter_enum (
    const ParserChar* text,
    size_t textLength,
    bool ( ColladaParserAutoGen15::*dataFunction )(const ENUM__fx_sampler_min_filter_enum*, size_t ),
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& )
)
{
    return characterData2EnumData<ENUM__fx_sampler_min_filter_enum, StringHash, ENUM__fx_sampler_min_filter_enum__COUNT>(text, textLength, dataFunction, ENUM__fx_sampler_min_filter_enumMap, baseConversionFunc, &toEnum_ENUM__fx_sampler_min_filter_enum, &ColladaParserAutoGen15Private::toEnumDataPrefix_ENUM__fx_sampler_min_filter_enum);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::dataEnumEnd_ENUM__fx_sampler_min_filter_enum (
    bool ( ColladaParserAutoGen15::*dataFunction )(const ENUM__fx_sampler_min_filter_enum*, size_t ),
    const std::pair<StringHash, ENUM__fx_sampler_min_filter_enum>* enumMap,
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& ),
    ENUM__fx_sampler_min_filter_enum (*toEnumFunc)( const ParserChar**, const ParserChar*, bool&, const std::pair<StringHash, ENUM__fx_sampler_min_filter_enum>* enumMap, StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& ))
)
{
    return dataEnumEnd<ENUM__fx_sampler_min_filter_enum, StringHash, ENUM__fx_sampler_min_filter_enum__COUNT>(dataFunction, enumMap, baseConversionFunc, toEnumFunc);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__magfilter( const ParserChar* text, size_t textLength )
{
if (!mLastIncompleteFragmentInCharacterData)
{
    mLastIncompleteFragmentInCharacterData = (ParserChar*)mStackMemoryManager.newObject(textLength);
    memcpy(mLastIncompleteFragmentInCharacterData, text, textLength);
    mEndOfDataInCurrentObjectOnStack = mLastIncompleteFragmentInCharacterData + textLength;
}
else
{
    ParserChar* tmp = (ParserChar*)mStackMemoryManager.growObject(textLength);
    if ( tmp != mLastIncompleteFragmentInCharacterData ) {
        mEndOfDataInCurrentObjectOnStack = (mEndOfDataInCurrentObjectOnStack - mLastIncompleteFragmentInCharacterData) + tmp;
        mLastIncompleteFragmentInCharacterData = tmp;
    }
    memcpy(mEndOfDataInCurrentObjectOnStack, text, textLength);
    mEndOfDataInCurrentObjectOnStack += textLength;
}
return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__magfilter( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__magfilter( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__magfilter()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__magfilter();
        if ( !validationResult ) return false;

    } // validation
#endif

bool failed;
ENUM__fx_sampler_mag_filter_enum parameter = Utils::toEnum<ENUM__fx_sampler_mag_filter_enum, StringHash, ENUM__fx_sampler_mag_filter_enum__COUNT>((const ParserChar**)&mLastIncompleteFragmentInCharacterData, mEndOfDataInCurrentObjectOnStack, failed, ENUM__fx_sampler_mag_filter_enumMap, Utils::calculateStringHash);
bool returnValue;
if (!failed)
{
    returnValue = mImpl->data__magfilter(parameter);
}
else
    returnValue = !handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_TEXTDATA_PARSING_FAILED, HASH_ELEMENT_MAGFILTER, (const ParserChar*)0, mLastIncompleteFragmentInCharacterData);
if (mLastIncompleteFragmentInCharacterData)
    mStackMemoryManager.deleteObject();
mLastIncompleteFragmentInCharacterData = 0;
mEndOfDataInCurrentObjectOnStack = 0;
return returnValue;

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__magfilter( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
ENUM__fx_sampler_mag_filter_enum ColladaParserAutoGen15Private::toEnumDataPrefix_ENUM__fx_sampler_mag_filter_enum (
    const ParserChar* prefixedBuffer,
    const ParserChar* prefixedBufferEnd,
    const ParserChar** buffer,
    const ParserChar* bufferEnd,
    bool& failed,
    const std::pair<StringHash, ENUM__fx_sampler_mag_filter_enum>* enumMap,
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& )
)
{
    return toEnumDataPrefix<ENUM__fx_sampler_mag_filter_enum, StringHash, ENUM__fx_sampler_mag_filter_enum__COUNT, &toEnum_ENUM__fx_sampler_mag_filter_enum>(prefixedBuffer, prefixedBufferEnd, buffer, bufferEnd, failed, enumMap, baseConversionFunc);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::characterData2EnumData_ENUM__fx_sampler_mag_filter_enum (
    const ParserChar* text,
    size_t textLength,
    bool ( ColladaParserAutoGen15::*dataFunction )(const ENUM__fx_sampler_mag_filter_enum*, size_t ),
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& )
)
{
    return characterData2EnumData<ENUM__fx_sampler_mag_filter_enum, StringHash, ENUM__fx_sampler_mag_filter_enum__COUNT>(text, textLength, dataFunction, ENUM__fx_sampler_mag_filter_enumMap, baseConversionFunc, &toEnum_ENUM__fx_sampler_mag_filter_enum, &ColladaParserAutoGen15Private::toEnumDataPrefix_ENUM__fx_sampler_mag_filter_enum);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::dataEnumEnd_ENUM__fx_sampler_mag_filter_enum (
    bool ( ColladaParserAutoGen15::*dataFunction )(const ENUM__fx_sampler_mag_filter_enum*, size_t ),
    const std::pair<StringHash, ENUM__fx_sampler_mag_filter_enum>* enumMap,
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& ),
    ENUM__fx_sampler_mag_filter_enum (*toEnumFunc)( const ParserChar**, const ParserChar*, bool&, const std::pair<StringHash, ENUM__fx_sampler_mag_filter_enum>* enumMap, StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& ))
)
{
    return dataEnumEnd<ENUM__fx_sampler_mag_filter_enum, StringHash, ENUM__fx_sampler_mag_filter_enum__COUNT>(dataFunction, enumMap, baseConversionFunc, toEnumFunc);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__mipfilter( const ParserChar* text, size_t textLength )
{
if (!mLastIncompleteFragmentInCharacterData)
{
    mLastIncompleteFragmentInCharacterData = (ParserChar*)mStackMemoryManager.newObject(textLength);
    memcpy(mLastIncompleteFragmentInCharacterData, text, textLength);
    mEndOfDataInCurrentObjectOnStack = mLastIncompleteFragmentInCharacterData + textLength;
}
else
{
    ParserChar* tmp = (ParserChar*)mStackMemoryManager.growObject(textLength);
    if ( tmp != mLastIncompleteFragmentInCharacterData ) {
        mEndOfDataInCurrentObjectOnStack = (mEndOfDataInCurrentObjectOnStack - mLastIncompleteFragmentInCharacterData) + tmp;
        mLastIncompleteFragmentInCharacterData = tmp;
    }
    memcpy(mEndOfDataInCurrentObjectOnStack, text, textLength);
    mEndOfDataInCurrentObjectOnStack += textLength;
}
return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__mipfilter( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__mipfilter( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__mipfilter()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__mipfilter();
        if ( !validationResult ) return false;

    } // validation
#endif

bool failed;
ENUM__fx_sampler_mip_filter_enum parameter = Utils::toEnum<ENUM__fx_sampler_mip_filter_enum, StringHash, ENUM__fx_sampler_mip_filter_enum__COUNT>((const ParserChar**)&mLastIncompleteFragmentInCharacterData, mEndOfDataInCurrentObjectOnStack, failed, ENUM__fx_sampler_mip_filter_enumMap, Utils::calculateStringHash);
bool returnValue;
if (!failed)
{
    returnValue = mImpl->data__mipfilter(parameter);
}
else
    returnValue = !handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_TEXTDATA_PARSING_FAILED, HASH_ELEMENT_MIPFILTER, (const ParserChar*)0, mLastIncompleteFragmentInCharacterData);
if (mLastIncompleteFragmentInCharacterData)
    mStackMemoryManager.deleteObject();
mLastIncompleteFragmentInCharacterData = 0;
mEndOfDataInCurrentObjectOnStack = 0;
return returnValue;

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__mipfilter( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
ENUM__fx_sampler_mip_filter_enum ColladaParserAutoGen15Private::toEnumDataPrefix_ENUM__fx_sampler_mip_filter_enum (
    const ParserChar* prefixedBuffer,
    const ParserChar* prefixedBufferEnd,
    const ParserChar** buffer,
    const ParserChar* bufferEnd,
    bool& failed,
    const std::pair<StringHash, ENUM__fx_sampler_mip_filter_enum>* enumMap,
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& )
)
{
    return toEnumDataPrefix<ENUM__fx_sampler_mip_filter_enum, StringHash, ENUM__fx_sampler_mip_filter_enum__COUNT, &toEnum_ENUM__fx_sampler_mip_filter_enum>(prefixedBuffer, prefixedBufferEnd, buffer, bufferEnd, failed, enumMap, baseConversionFunc);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::characterData2EnumData_ENUM__fx_sampler_mip_filter_enum (
    const ParserChar* text,
    size_t textLength,
    bool ( ColladaParserAutoGen15::*dataFunction )(const ENUM__fx_sampler_mip_filter_enum*, size_t ),
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& )
)
{
    return characterData2EnumData<ENUM__fx_sampler_mip_filter_enum, StringHash, ENUM__fx_sampler_mip_filter_enum__COUNT>(text, textLength, dataFunction, ENUM__fx_sampler_mip_filter_enumMap, baseConversionFunc, &toEnum_ENUM__fx_sampler_mip_filter_enum, &ColladaParserAutoGen15Private::toEnumDataPrefix_ENUM__fx_sampler_mip_filter_enum);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::dataEnumEnd_ENUM__fx_sampler_mip_filter_enum (
    bool ( ColladaParserAutoGen15::*dataFunction )(const ENUM__fx_sampler_mip_filter_enum*, size_t ),
    const std::pair<StringHash, ENUM__fx_sampler_mip_filter_enum>* enumMap,
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& ),
    ENUM__fx_sampler_mip_filter_enum (*toEnumFunc)( const ParserChar**, const ParserChar*, bool&, const std::pair<StringHash, ENUM__fx_sampler_mip_filter_enum>* enumMap, StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& ))
)
{
    return dataEnumEnd<ENUM__fx_sampler_mip_filter_enum, StringHash, ENUM__fx_sampler_mip_filter_enum__COUNT>(dataFunction, enumMap, baseConversionFunc, toEnumFunc);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__border_color( const ParserChar* text, size_t textLength )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        border_color__ValidationData* validationData = (border_color__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
return characterData2FloatData(text, textLength, &ColladaParserAutoGen15::data__border_color, &validate__fx_color_type__stream, &validationData->validationWholeSize, 0);
    }
    else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen15::data__border_color);
    }
#else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen15::data__border_color);
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__border_color( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__border_color( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__border_color()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__border_color();
        if ( !validationResult ) return false;

    } // validation
#endif

#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        border_color__ValidationData* validationData = (border_color__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
bool returnValue = floatDataEnd( &ColladaParserAutoGen15::data__border_color, &validate__fx_color_type__streamEnd, &validationData->validationWholeSize, 0 );
        ParserError::ErrorType simpleTypeValidationResult = validate__fx_color_type(0, (*(&validationData->validationWholeSize)));
        mValidationDataStack.deleteObject();
        if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
        {
            if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
                simpleTypeValidationResult,
                HASH_ELEMENT_BORDER_COLOR,
                (ParserChar*)0, 0 ) )
            {
                return false;
            }
        }
        return returnValue;
    }
    else
    {
return floatDataEnd( &ColladaParserAutoGen15::data__border_color );
    }
#else
    {
return floatDataEnd( &ColladaParserAutoGen15::data__border_color );
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__border_color( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__mip_max_level( const ParserChar* text, size_t textLength )
{
if (!mLastIncompleteFragmentInCharacterData)
{
    mLastIncompleteFragmentInCharacterData = (ParserChar*)mStackMemoryManager.newObject(textLength);
    memcpy(mLastIncompleteFragmentInCharacterData, text, textLength);
    mEndOfDataInCurrentObjectOnStack = mLastIncompleteFragmentInCharacterData + textLength;
}
else
{
    ParserChar* tmp = (ParserChar*)mStackMemoryManager.growObject(textLength);
    if ( tmp != mLastIncompleteFragmentInCharacterData ) {
        mEndOfDataInCurrentObjectOnStack = (mEndOfDataInCurrentObjectOnStack - mLastIncompleteFragmentInCharacterData) + tmp;
        mLastIncompleteFragmentInCharacterData = tmp;
    }
    memcpy(mEndOfDataInCurrentObjectOnStack, text, textLength);
    mEndOfDataInCurrentObjectOnStack += textLength;
}
return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__mip_max_level( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__mip_max_level( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__mip_max_level()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__mip_max_level();
        if ( !validationResult ) return false;

    } // validation
#endif

bool failed;
const ParserChar* ptrForErr = mLastIncompleteFragmentInCharacterData;
DISABLE_WARNING_UNUSED(ptrForErr)
uint8 parameter = GeneratedSaxParser::Utils::toUint8((const ParserChar**)&mLastIncompleteFragmentInCharacterData, mEndOfDataInCurrentObjectOnStack, failed);
bool returnValue;
if (!failed)
{
    returnValue = mImpl->data__mip_max_level(parameter);
}
else
    returnValue = !handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_TEXTDATA_PARSING_FAILED, HASH_ELEMENT_MIP_MAX_LEVEL, (const ParserChar*)0, mLastIncompleteFragmentInCharacterData);
if (mLastIncompleteFragmentInCharacterData)
    mStackMemoryManager.deleteObject();
mLastIncompleteFragmentInCharacterData = 0;
mEndOfDataInCurrentObjectOnStack = 0;
return returnValue;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__mip_max_level( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__mip_min_level( const ParserChar* text, size_t textLength )
{
if (!mLastIncompleteFragmentInCharacterData)
{
    mLastIncompleteFragmentInCharacterData = (ParserChar*)mStackMemoryManager.newObject(textLength);
    memcpy(mLastIncompleteFragmentInCharacterData, text, textLength);
    mEndOfDataInCurrentObjectOnStack = mLastIncompleteFragmentInCharacterData + textLength;
}
else
{
    ParserChar* tmp = (ParserChar*)mStackMemoryManager.growObject(textLength);
    if ( tmp != mLastIncompleteFragmentInCharacterData ) {
        mEndOfDataInCurrentObjectOnStack = (mEndOfDataInCurrentObjectOnStack - mLastIncompleteFragmentInCharacterData) + tmp;
        mLastIncompleteFragmentInCharacterData = tmp;
    }
    memcpy(mEndOfDataInCurrentObjectOnStack, text, textLength);
    mEndOfDataInCurrentObjectOnStack += textLength;
}
return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__mip_min_level( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__mip_min_level( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__mip_min_level()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__mip_min_level();
        if ( !validationResult ) return false;

    } // validation
#endif

bool failed;
const ParserChar* ptrForErr = mLastIncompleteFragmentInCharacterData;
DISABLE_WARNING_UNUSED(ptrForErr)
uint8 parameter = GeneratedSaxParser::Utils::toUint8((const ParserChar**)&mLastIncompleteFragmentInCharacterData, mEndOfDataInCurrentObjectOnStack, failed);
bool returnValue;
if (!failed)
{
    returnValue = mImpl->data__mip_min_level(parameter);
}
else
    returnValue = !handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_TEXTDATA_PARSING_FAILED, HASH_ELEMENT_MIP_MIN_LEVEL, (const ParserChar*)0, mLastIncompleteFragmentInCharacterData);
if (mLastIncompleteFragmentInCharacterData)
    mStackMemoryManager.deleteObject();
mLastIncompleteFragmentInCharacterData = 0;
mEndOfDataInCurrentObjectOnStack = 0;
return returnValue;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__mip_min_level( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__mip_bias( const ParserChar* text, size_t textLength )
{
if (!mLastIncompleteFragmentInCharacterData)
{
    mLastIncompleteFragmentInCharacterData = (ParserChar*)mStackMemoryManager.newObject(textLength);
    memcpy(mLastIncompleteFragmentInCharacterData, text, textLength);
    mEndOfDataInCurrentObjectOnStack = mLastIncompleteFragmentInCharacterData + textLength;
}
else
{
    ParserChar* tmp = (ParserChar*)mStackMemoryManager.growObject(textLength);
    if ( tmp != mLastIncompleteFragmentInCharacterData ) {
        mEndOfDataInCurrentObjectOnStack = (mEndOfDataInCurrentObjectOnStack - mLastIncompleteFragmentInCharacterData) + tmp;
        mLastIncompleteFragmentInCharacterData = tmp;
    }
    memcpy(mEndOfDataInCurrentObjectOnStack, text, textLength);
    mEndOfDataInCurrentObjectOnStack += textLength;
}
return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__mip_bias( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__mip_bias( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__mip_bias()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__mip_bias();
        if ( !validationResult ) return false;

    } // validation
#endif

bool failed;
const ParserChar* ptrForErr = mLastIncompleteFragmentInCharacterData;
DISABLE_WARNING_UNUSED(ptrForErr)
float parameter = GeneratedSaxParser::Utils::toFloat((const ParserChar**)&mLastIncompleteFragmentInCharacterData, mEndOfDataInCurrentObjectOnStack, failed);
bool returnValue;
if (!failed)
{
    returnValue = mImpl->data__mip_bias(parameter);
}
else
    returnValue = !handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_TEXTDATA_PARSING_FAILED, HASH_ELEMENT_MIP_BIAS, (const ParserChar*)0, mLastIncompleteFragmentInCharacterData);
if (mLastIncompleteFragmentInCharacterData)
    mStackMemoryManager.deleteObject();
mLastIncompleteFragmentInCharacterData = 0;
mEndOfDataInCurrentObjectOnStack = 0;
return returnValue;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__mip_bias( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__max_anisotropy( const ParserChar* text, size_t textLength )
{
if (!mLastIncompleteFragmentInCharacterData)
{
    mLastIncompleteFragmentInCharacterData = (ParserChar*)mStackMemoryManager.newObject(textLength);
    memcpy(mLastIncompleteFragmentInCharacterData, text, textLength);
    mEndOfDataInCurrentObjectOnStack = mLastIncompleteFragmentInCharacterData + textLength;
}
else
{
    ParserChar* tmp = (ParserChar*)mStackMemoryManager.growObject(textLength);
    if ( tmp != mLastIncompleteFragmentInCharacterData ) {
        mEndOfDataInCurrentObjectOnStack = (mEndOfDataInCurrentObjectOnStack - mLastIncompleteFragmentInCharacterData) + tmp;
        mLastIncompleteFragmentInCharacterData = tmp;
    }
    memcpy(mEndOfDataInCurrentObjectOnStack, text, textLength);
    mEndOfDataInCurrentObjectOnStack += textLength;
}
return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__max_anisotropy( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__max_anisotropy( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__max_anisotropy()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__max_anisotropy();
        if ( !validationResult ) return false;

    } // validation
#endif

bool failed;
const ParserChar* ptrForErr = mLastIncompleteFragmentInCharacterData;
DISABLE_WARNING_UNUSED(ptrForErr)
uint32 parameter = GeneratedSaxParser::Utils::toUint32((const ParserChar**)&mLastIncompleteFragmentInCharacterData, mEndOfDataInCurrentObjectOnStack, failed);
bool returnValue;
if (!failed)
{
    returnValue = mImpl->data__max_anisotropy(parameter);
}
else
    returnValue = !handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_TEXTDATA_PARSING_FAILED, HASH_ELEMENT_MAX_ANISOTROPY, (const ParserChar*)0, mLastIncompleteFragmentInCharacterData);
if (mLastIncompleteFragmentInCharacterData)
    mStackMemoryManager.deleteObject();
mLastIncompleteFragmentInCharacterData = 0;
mEndOfDataInCurrentObjectOnStack = 0;
return returnValue;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__max_anisotropy( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__sampler2D____fx_sampler2D_type( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__sampler2D____fx_sampler2D_type( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__sampler2D____fx_sampler2D_type( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__sampler2D____fx_sampler2D_type()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__sampler2D____fx_sampler2D_type();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__sampler2D____fx_sampler2D_type( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__sampler3D( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__sampler3D( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__sampler3D( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__sampler3D()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__sampler3D();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__sampler3D( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__samplerCUBE( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__samplerCUBE( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__samplerCUBE( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__samplerCUBE()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__samplerCUBE();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__samplerCUBE( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__samplerRECT( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__samplerRECT( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__samplerRECT( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__samplerRECT()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__samplerRECT();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__samplerRECT( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__samplerDEPTH( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__samplerDEPTH( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__samplerDEPTH( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__samplerDEPTH()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__samplerDEPTH();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__samplerDEPTH( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__enum____string( const ParserChar* text, size_t textLength )
{

return mImpl->data__enum____string(text, textLength);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__enum____string( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__enum____string( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__enum____string()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__enum____string();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__enum____string( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
const profile_COMMON__AttributeData profile_COMMON__AttributeData::DEFAULT = {0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__profile_COMMON( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__profile_COMMON( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__profile_COMMON( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

profile_COMMON__AttributeData* attributeData = newData<profile_COMMON__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_ID:
    {

attributeData->id = attributeValue;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_PROFILE_COMMON, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__profile_COMMON()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__profile_COMMON();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__profile_COMMON( void* attributeData )
{
    profile_COMMON__AttributeData* typedAttributeData = static_cast<profile_COMMON__AttributeData*>(attributeData);

    typedAttributeData->~profile_COMMON__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const newparam____fx_common_newparam_type__AttributeData newparam____fx_common_newparam_type__AttributeData::DEFAULT = {0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__newparam____fx_common_newparam_type( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__newparam____fx_common_newparam_type( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__newparam____fx_common_newparam_type( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

newparam____fx_common_newparam_type__AttributeData* attributeData = newData<newparam____fx_common_newparam_type__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_SID:
    {

attributeData->sid = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__sid_type(attributeData->sid, strlen(attributeData->sid));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_NEWPARAM,
            HASH_ATTRIBUTE_SID,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_NEWPARAM, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ( !attributeData->sid )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_NEWPARAM, HASH_ATTRIBUTE_SID, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__newparam____fx_common_newparam_type()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__newparam____fx_common_newparam_type();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__newparam____fx_common_newparam_type( void* attributeData )
{
    newparam____fx_common_newparam_type__AttributeData* typedAttributeData = static_cast<newparam____fx_common_newparam_type__AttributeData*>(attributeData);

    typedAttributeData->~newparam____fx_common_newparam_type__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const profile_common_type____technique__AttributeData profile_common_type____technique__AttributeData::DEFAULT = {0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__profile_common_type____technique( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__profile_common_type____technique( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__profile_common_type____technique( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

profile_common_type____technique__AttributeData* attributeData = newData<profile_common_type____technique__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_ID:
    {

attributeData->id = attributeValue;

    break;
    }
    case HASH_ATTRIBUTE_SID:
    {

attributeData->sid = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__sid_type(attributeData->sid, strlen(attributeData->sid));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_TECHNIQUE,
            HASH_ATTRIBUTE_SID,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_TECHNIQUE, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ( !attributeData->sid )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_TECHNIQUE, HASH_ATTRIBUTE_SID, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__profile_common_type____technique()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__profile_common_type____technique();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__profile_common_type____technique( void* attributeData )
{
    profile_common_type____technique__AttributeData* typedAttributeData = static_cast<profile_common_type____technique__AttributeData*>(attributeData);

    typedAttributeData->~profile_common_type____technique__AttributeData();

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__profile_COMMON__technique__constant( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__profile_COMMON__technique__constant( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__profile_COMMON__technique__constant( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__profile_COMMON__technique__constant()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__profile_COMMON__technique__constant();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__profile_COMMON__technique__constant( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__emission( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__emission( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__emission( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__emission()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__emission();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__emission( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
const fx_common_color_or_texture_type____color__AttributeData fx_common_color_or_texture_type____color__AttributeData::DEFAULT = {0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__fx_common_color_or_texture_type____color( const ParserChar* text, size_t textLength )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        border_color__ValidationData* validationData = (border_color__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
return characterData2FloatData(text, textLength, &ColladaParserAutoGen15::data__fx_common_color_or_texture_type____color, &validate__fx_color_type__stream, &validationData->validationWholeSize, 0);
    }
    else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen15::data__fx_common_color_or_texture_type____color);
    }
#else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen15::data__fx_common_color_or_texture_type____color);
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__fx_common_color_or_texture_type____color( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__fx_common_color_or_texture_type____color( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

fx_common_color_or_texture_type____color__AttributeData* attributeData = newData<fx_common_color_or_texture_type____color__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_SID:
    {

attributeData->sid = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__sid_type(attributeData->sid, strlen(attributeData->sid));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_COLOR,
            HASH_ATTRIBUTE_SID,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_COLOR, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__fx_common_color_or_texture_type____color()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__fx_common_color_or_texture_type____color();
        if ( !validationResult ) return false;

    } // validation
#endif

#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        border_color__ValidationData* validationData = (border_color__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
bool returnValue = floatDataEnd( &ColladaParserAutoGen15::data__fx_common_color_or_texture_type____color, &validate__fx_color_type__streamEnd, &validationData->validationWholeSize, 0 );
        ParserError::ErrorType simpleTypeValidationResult = validate__fx_color_type(0, (*(&validationData->validationWholeSize)));
        mValidationDataStack.deleteObject();
        if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
        {
            if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
                simpleTypeValidationResult,
                HASH_ELEMENT_COLOR,
                (ParserChar*)0, 0 ) )
            {
                return false;
            }
        }
        return returnValue;
    }
    else
    {
return floatDataEnd( &ColladaParserAutoGen15::data__fx_common_color_or_texture_type____color );
    }
#else
    {
return floatDataEnd( &ColladaParserAutoGen15::data__fx_common_color_or_texture_type____color );
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__fx_common_color_or_texture_type____color( void* attributeData )
{
    fx_common_color_or_texture_type____color__AttributeData* typedAttributeData = static_cast<fx_common_color_or_texture_type____color__AttributeData*>(attributeData);

    typedAttributeData->~fx_common_color_or_texture_type____color__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const fx_common_color_or_texture_type____param__AttributeData fx_common_color_or_texture_type____param__AttributeData::DEFAULT = {0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__fx_common_color_or_texture_type____param( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__fx_common_color_or_texture_type____param( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__fx_common_color_or_texture_type____param( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

fx_common_color_or_texture_type____param__AttributeData* attributeData = newData<fx_common_color_or_texture_type____param__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_REF:
    {

attributeData->ref = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->ref, strlen(attributeData->ref));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_PARAM,
            HASH_ATTRIBUTE_REF,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_PARAM, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ( !attributeData->ref )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_PARAM, HASH_ATTRIBUTE_REF, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__fx_common_color_or_texture_type____param()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__fx_common_color_or_texture_type____param();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__fx_common_color_or_texture_type____param( void* attributeData )
{
    fx_common_color_or_texture_type____param__AttributeData* typedAttributeData = static_cast<fx_common_color_or_texture_type____param__AttributeData*>(attributeData);

    typedAttributeData->~fx_common_color_or_texture_type____param__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const texture__AttributeData texture__AttributeData::DEFAULT = {0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__texture( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__texture( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__texture( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

texture__AttributeData* attributeData = newData<texture__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_TEXTURE:
    {

attributeData->texture = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->texture, strlen(attributeData->texture));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_TEXTURE,
            HASH_ATTRIBUTE_TEXTURE,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    case HASH_ATTRIBUTE_TEXCOORD:
    {

attributeData->texcoord = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->texcoord, strlen(attributeData->texcoord));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_TEXTURE,
            HASH_ATTRIBUTE_TEXCOORD,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_TEXTURE, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ( !attributeData->texture )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_TEXTURE, HASH_ATTRIBUTE_TEXTURE, 0 ) )
        return false;
}
if ( !attributeData->texcoord )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_TEXTURE, HASH_ATTRIBUTE_TEXCOORD, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__texture()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__texture();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__texture( void* attributeData )
{
    texture__AttributeData* typedAttributeData = static_cast<texture__AttributeData*>(attributeData);

    typedAttributeData->~texture__AttributeData();

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__reflective( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__reflective( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__reflective( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__reflective()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__reflective();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__reflective( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__reflectivity( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__reflectivity( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__reflectivity( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__reflectivity()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__reflectivity();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__reflectivity( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
const fx_common_float_or_param_type____float__AttributeData fx_common_float_or_param_type____float__AttributeData::DEFAULT = {0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__fx_common_float_or_param_type____float( const ParserChar* text, size_t textLength )
{
if (!mLastIncompleteFragmentInCharacterData)
{
    mLastIncompleteFragmentInCharacterData = (ParserChar*)mStackMemoryManager.newObject(textLength);
    memcpy(mLastIncompleteFragmentInCharacterData, text, textLength);
    mEndOfDataInCurrentObjectOnStack = mLastIncompleteFragmentInCharacterData + textLength;
}
else
{
    ParserChar* tmp = (ParserChar*)mStackMemoryManager.growObject(textLength);
    if ( tmp != mLastIncompleteFragmentInCharacterData ) {
        mEndOfDataInCurrentObjectOnStack = (mEndOfDataInCurrentObjectOnStack - mLastIncompleteFragmentInCharacterData) + tmp;
        mLastIncompleteFragmentInCharacterData = tmp;
    }
    memcpy(mEndOfDataInCurrentObjectOnStack, text, textLength);
    mEndOfDataInCurrentObjectOnStack += textLength;
}
return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__fx_common_float_or_param_type____float( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__fx_common_float_or_param_type____float( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

fx_common_float_or_param_type____float__AttributeData* attributeData = newData<fx_common_float_or_param_type____float__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_SID:
    {

attributeData->sid = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__sid_type(attributeData->sid, strlen(attributeData->sid));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_FLOAT,
            HASH_ATTRIBUTE_SID,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_FLOAT, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__fx_common_float_or_param_type____float()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__fx_common_float_or_param_type____float();
        if ( !validationResult ) return false;

    } // validation
#endif

bool failed;
const ParserChar* ptrForErr = mLastIncompleteFragmentInCharacterData;
DISABLE_WARNING_UNUSED(ptrForErr)
float parameter = GeneratedSaxParser::Utils::toFloat((const ParserChar**)&mLastIncompleteFragmentInCharacterData, mEndOfDataInCurrentObjectOnStack, failed);
bool returnValue;
if (!failed)
{
    returnValue = mImpl->data__fx_common_float_or_param_type____float(parameter);
}
else
    returnValue = !handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_TEXTDATA_PARSING_FAILED, HASH_ELEMENT_FLOAT, (const ParserChar*)0, mLastIncompleteFragmentInCharacterData);
if (mLastIncompleteFragmentInCharacterData)
    mStackMemoryManager.deleteObject();
mLastIncompleteFragmentInCharacterData = 0;
mEndOfDataInCurrentObjectOnStack = 0;
return returnValue;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__fx_common_float_or_param_type____float( void* attributeData )
{
    fx_common_float_or_param_type____float__AttributeData* typedAttributeData = static_cast<fx_common_float_or_param_type____float__AttributeData*>(attributeData);

    typedAttributeData->~fx_common_float_or_param_type____float__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const fx_common_float_or_param_type____param__AttributeData fx_common_float_or_param_type____param__AttributeData::DEFAULT = {0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__fx_common_float_or_param_type____param( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__fx_common_float_or_param_type____param( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__fx_common_float_or_param_type____param( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

fx_common_float_or_param_type____param__AttributeData* attributeData = newData<fx_common_float_or_param_type____param__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_REF:
    {

attributeData->ref = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->ref, strlen(attributeData->ref));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_PARAM,
            HASH_ATTRIBUTE_REF,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_PARAM, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ( !attributeData->ref )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_PARAM, HASH_ATTRIBUTE_REF, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__fx_common_float_or_param_type____param()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__fx_common_float_or_param_type____param();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__fx_common_float_or_param_type____param( void* attributeData )
{
    fx_common_float_or_param_type____param__AttributeData* typedAttributeData = static_cast<fx_common_float_or_param_type____param__AttributeData*>(attributeData);

    typedAttributeData->~fx_common_float_or_param_type____param__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const transparent__AttributeData transparent__AttributeData::DEFAULT = {ENUM__fx_opaque_enum__A_ONE};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__transparent( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__transparent( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__transparent( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

transparent__AttributeData* attributeData = newData<transparent__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_OPAQUE:
    {
bool failed;
attributeData->opaque = Utils::toEnum<ENUM__fx_opaque_enum, StringHash, ENUM__fx_opaque_enum__COUNT>(attributeValue, failed, ENUM__fx_opaque_enumMap, Utils::calculateStringHash);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_TRANSPARENT,
        HASH_ATTRIBUTE_OPAQUE,
        attributeValue))
{
    return false;
}

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_TRANSPARENT, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__transparent()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__transparent();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__transparent( void* attributeData )
{
    transparent__AttributeData* typedAttributeData = static_cast<transparent__AttributeData*>(attributeData);

    typedAttributeData->~transparent__AttributeData();

    return true;
}

//---------------------------------------------------------------------
ENUM__fx_opaque_enum ColladaParserAutoGen15Private::toEnumDataPrefix_ENUM__fx_opaque_enum (
    const ParserChar* prefixedBuffer,
    const ParserChar* prefixedBufferEnd,
    const ParserChar** buffer,
    const ParserChar* bufferEnd,
    bool& failed,
    const std::pair<StringHash, ENUM__fx_opaque_enum>* enumMap,
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& )
)
{
    return toEnumDataPrefix<ENUM__fx_opaque_enum, StringHash, ENUM__fx_opaque_enum__COUNT, &toEnum_ENUM__fx_opaque_enum>(prefixedBuffer, prefixedBufferEnd, buffer, bufferEnd, failed, enumMap, baseConversionFunc);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::characterData2EnumData_ENUM__fx_opaque_enum (
    const ParserChar* text,
    size_t textLength,
    bool ( ColladaParserAutoGen15::*dataFunction )(const ENUM__fx_opaque_enum*, size_t ),
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& )
)
{
    return characterData2EnumData<ENUM__fx_opaque_enum, StringHash, ENUM__fx_opaque_enum__COUNT>(text, textLength, dataFunction, ENUM__fx_opaque_enumMap, baseConversionFunc, &toEnum_ENUM__fx_opaque_enum, &ColladaParserAutoGen15Private::toEnumDataPrefix_ENUM__fx_opaque_enum);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::dataEnumEnd_ENUM__fx_opaque_enum (
    bool ( ColladaParserAutoGen15::*dataFunction )(const ENUM__fx_opaque_enum*, size_t ),
    const std::pair<StringHash, ENUM__fx_opaque_enum>* enumMap,
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& ),
    ENUM__fx_opaque_enum (*toEnumFunc)( const ParserChar**, const ParserChar*, bool&, const std::pair<StringHash, ENUM__fx_opaque_enum>* enumMap, StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& ))
)
{
    return dataEnumEnd<ENUM__fx_opaque_enum, StringHash, ENUM__fx_opaque_enum__COUNT>(dataFunction, enumMap, baseConversionFunc, toEnumFunc);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__transparency( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__transparency( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__transparency( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__transparency()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__transparency();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__transparency( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__index_of_refraction( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__index_of_refraction( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__index_of_refraction( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__index_of_refraction()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__index_of_refraction();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__index_of_refraction( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__lambert( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__lambert( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__lambert( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__lambert()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__lambert();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__lambert( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__ambient____fx_common_color_or_texture_type( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__ambient____fx_common_color_or_texture_type( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__ambient____fx_common_color_or_texture_type( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__ambient____fx_common_color_or_texture_type()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__ambient____fx_common_color_or_texture_type();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__ambient____fx_common_color_or_texture_type( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__diffuse( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__diffuse( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__diffuse( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__diffuse()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__diffuse();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__diffuse( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__phong( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__phong( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__phong( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__phong()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__phong();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__phong( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__specular( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__specular( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__specular( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__specular()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__specular();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__specular( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__shininess( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__shininess( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__shininess( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__shininess()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__shininess();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__shininess( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__blinn( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__blinn( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__blinn( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__blinn()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__blinn();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__blinn( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
const profile_BRIDGE__AttributeData profile_BRIDGE__AttributeData::DEFAULT = {0, 0, 0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__profile_BRIDGE( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__profile_BRIDGE( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__profile_BRIDGE( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

profile_BRIDGE__AttributeData* attributeData = newData<profile_BRIDGE__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_ID:
    {

attributeData->id = attributeValue;

    break;
    }
    case HASH_ATTRIBUTE_PLATFORM:
    {

attributeData->platform = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->platform, strlen(attributeData->platform));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_PROFILE_BRIDGE,
            HASH_ATTRIBUTE_PLATFORM,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    case HASH_ATTRIBUTE_URL:
    {
bool failed;
attributeData->url = GeneratedSaxParser::Utils::toURI(&attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_PROFILE_BRIDGE,
        HASH_ATTRIBUTE_URL,
        attributeValue))
{
    return false;
}
if ( !failed )
    attributeData->present_attributes |= profile_BRIDGE__AttributeData::ATTRIBUTE_URL_PRESENT;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_PROFILE_BRIDGE, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ((attributeData->present_attributes & profile_BRIDGE__AttributeData::ATTRIBUTE_URL_PRESENT) == 0)
{
    attributeData->url = COLLADABU::URI("");
}
if ( (attributeData->present_attributes & profile_BRIDGE__AttributeData::ATTRIBUTE_URL_PRESENT) == 0 )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_PROFILE_BRIDGE, HASH_ATTRIBUTE_URL, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__profile_BRIDGE()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__profile_BRIDGE();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__profile_BRIDGE( void* attributeData )
{
    profile_BRIDGE__AttributeData* typedAttributeData = static_cast<profile_BRIDGE__AttributeData*>(attributeData);

    typedAttributeData->~profile_BRIDGE__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const profile_GLES2__AttributeData profile_GLES2__AttributeData::DEFAULT = {0, 0, 0, GeneratedSaxParser::XSList<ParserString>()};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__profile_GLES2( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__profile_GLES2( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__profile_GLES2( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

profile_GLES2__AttributeData* attributeData = newData<profile_GLES2__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_ID:
    {

attributeData->id = attributeValue;

    break;
    }
    case HASH_ATTRIBUTE_LANGUAGE:
    {

attributeData->language = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->language, strlen(attributeData->language));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_PROFILE_GLES2,
            HASH_ATTRIBUTE_LANGUAGE,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    case HASH_ATTRIBUTE_PLATFORMS:
    {
bool failed;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
failed = !characterData2StringList(attributeValue, attributeData->platforms, &validate__Name, HASH_ELEMENT_PROFILE_GLES2, HASH_ATTRIBUTE_PLATFORMS);
    }
    else
    {
failed = !characterData2StringList(attributeValue, attributeData->platforms);
    }
#else
    {
failed = !characterData2StringList(attributeValue, attributeData->platforms);
    } // validation
#endif
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_PROFILE_GLES2,
        HASH_ATTRIBUTE_PLATFORMS,
        attributeValue))
{
    return false;
}

if ( !failed )
    attributeData->present_attributes |= profile_GLES2__AttributeData::ATTRIBUTE_PLATFORMS_PRESENT;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_PROFILE_GLES2, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ((attributeData->present_attributes & profile_GLES2__AttributeData::ATTRIBUTE_PLATFORMS_PRESENT) == 0)
{
    attributeData->platforms = GeneratedSaxParser::XSList<ParserString>();
}
if ( !attributeData->language )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_PROFILE_GLES2, HASH_ATTRIBUTE_LANGUAGE, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__profile_GLES2()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__profile_GLES2();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__profile_GLES2( void* attributeData )
{
    profile_GLES2__AttributeData* typedAttributeData = static_cast<profile_GLES2__AttributeData*>(attributeData);
    if (typedAttributeData->platforms.data)
    {
        mStackMemoryManager.deleteObject();
    }


    typedAttributeData->~profile_GLES2__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const include__AttributeData include__AttributeData::DEFAULT = {0, 0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__include( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__include( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__include( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

include__AttributeData* attributeData = newData<include__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_SID:
    {

attributeData->sid = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__sid_type(attributeData->sid, strlen(attributeData->sid));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_INCLUDE,
            HASH_ATTRIBUTE_SID,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    case HASH_ATTRIBUTE_URL:
    {
bool failed;
attributeData->url = GeneratedSaxParser::Utils::toURI(&attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_INCLUDE,
        HASH_ATTRIBUTE_URL,
        attributeValue))
{
    return false;
}
if ( !failed )
    attributeData->present_attributes |= include__AttributeData::ATTRIBUTE_URL_PRESENT;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_INCLUDE, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ((attributeData->present_attributes & include__AttributeData::ATTRIBUTE_URL_PRESENT) == 0)
{
    attributeData->url = COLLADABU::URI("");
}
if ( !attributeData->sid )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_INCLUDE, HASH_ATTRIBUTE_SID, 0 ) )
        return false;
}
if ( (attributeData->present_attributes & include__AttributeData::ATTRIBUTE_URL_PRESENT) == 0 )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_INCLUDE, HASH_ATTRIBUTE_URL, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__include()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__include();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__include( void* attributeData )
{
    include__AttributeData* typedAttributeData = static_cast<include__AttributeData*>(attributeData);

    typedAttributeData->~include__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const code__AttributeData code__AttributeData::DEFAULT = {0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__code( const ParserChar* text, size_t textLength )
{

return mImpl->data__code(text, textLength);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__code( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__code( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

code__AttributeData* attributeData = newData<code__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_SID:
    {

attributeData->sid = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__sid_type(attributeData->sid, strlen(attributeData->sid));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_CODE,
            HASH_ATTRIBUTE_SID,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_CODE, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__code()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__code();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__code( void* attributeData )
{
    code__AttributeData* typedAttributeData = static_cast<code__AttributeData*>(attributeData);

    typedAttributeData->~code__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const profile_gles2_type____newparam__AttributeData profile_gles2_type____newparam__AttributeData::DEFAULT = {0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__profile_gles2_type____newparam( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__profile_gles2_type____newparam( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__profile_gles2_type____newparam( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

profile_gles2_type____newparam__AttributeData* attributeData = newData<profile_gles2_type____newparam__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_SID:
    {

attributeData->sid = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__sid_type(attributeData->sid, strlen(attributeData->sid));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_NEWPARAM,
            HASH_ATTRIBUTE_SID,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_NEWPARAM, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ( !attributeData->sid )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_NEWPARAM, HASH_ATTRIBUTE_SID, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__profile_gles2_type____newparam()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__profile_gles2_type____newparam();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__profile_gles2_type____newparam( void* attributeData )
{
    profile_gles2_type____newparam__AttributeData* typedAttributeData = static_cast<profile_gles2_type____newparam__AttributeData*>(attributeData);

    typedAttributeData->~profile_gles2_type____newparam__AttributeData();

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__bvec2( const ParserChar* text, size_t textLength )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        bool2__ValidationData* validationData = (bool2__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
return characterData2BoolData(text, textLength, &ColladaParserAutoGen15::data__bvec2, &validate__bool2_type__stream, &validationData->validationWholeSize, 0);
    }
    else
    {
return characterData2BoolData(text, textLength, &ColladaParserAutoGen15::data__bvec2);
    }
#else
    {
return characterData2BoolData(text, textLength, &ColladaParserAutoGen15::data__bvec2);
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__bvec2( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__bvec2( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__bvec2()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__bvec2();
        if ( !validationResult ) return false;

    } // validation
#endif

#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        bool2__ValidationData* validationData = (bool2__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
bool returnValue = boolDataEnd( &ColladaParserAutoGen15::data__bvec2, &validate__bool2_type__streamEnd, &validationData->validationWholeSize, 0 );
        ParserError::ErrorType simpleTypeValidationResult = validate__bool2_type(0, (*(&validationData->validationWholeSize)));
        mValidationDataStack.deleteObject();
        if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
        {
            if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
                simpleTypeValidationResult,
                HASH_ELEMENT_BVEC2,
                (ParserChar*)0, 0 ) )
            {
                return false;
            }
        }
        return returnValue;
    }
    else
    {
return boolDataEnd( &ColladaParserAutoGen15::data__bvec2 );
    }
#else
    {
return boolDataEnd( &ColladaParserAutoGen15::data__bvec2 );
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__bvec2( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__bvec3( const ParserChar* text, size_t textLength )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        bool3__ValidationData* validationData = (bool3__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
return characterData2BoolData(text, textLength, &ColladaParserAutoGen15::data__bvec3, &validate__bool3_type__stream, &validationData->validationWholeSize, 0);
    }
    else
    {
return characterData2BoolData(text, textLength, &ColladaParserAutoGen15::data__bvec3);
    }
#else
    {
return characterData2BoolData(text, textLength, &ColladaParserAutoGen15::data__bvec3);
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__bvec3( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__bvec3( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__bvec3()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__bvec3();
        if ( !validationResult ) return false;

    } // validation
#endif

#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        bool3__ValidationData* validationData = (bool3__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
bool returnValue = boolDataEnd( &ColladaParserAutoGen15::data__bvec3, &validate__bool3_type__streamEnd, &validationData->validationWholeSize, 0 );
        ParserError::ErrorType simpleTypeValidationResult = validate__bool3_type(0, (*(&validationData->validationWholeSize)));
        mValidationDataStack.deleteObject();
        if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
        {
            if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
                simpleTypeValidationResult,
                HASH_ELEMENT_BVEC3,
                (ParserChar*)0, 0 ) )
            {
                return false;
            }
        }
        return returnValue;
    }
    else
    {
return boolDataEnd( &ColladaParserAutoGen15::data__bvec3 );
    }
#else
    {
return boolDataEnd( &ColladaParserAutoGen15::data__bvec3 );
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__bvec3( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__bvec4( const ParserChar* text, size_t textLength )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        bool4__ValidationData* validationData = (bool4__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
return characterData2BoolData(text, textLength, &ColladaParserAutoGen15::data__bvec4, &validate__bool4_type__stream, &validationData->validationWholeSize, 0);
    }
    else
    {
return characterData2BoolData(text, textLength, &ColladaParserAutoGen15::data__bvec4);
    }
#else
    {
return characterData2BoolData(text, textLength, &ColladaParserAutoGen15::data__bvec4);
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__bvec4( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__bvec4( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__bvec4()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__bvec4();
        if ( !validationResult ) return false;

    } // validation
#endif

#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        bool4__ValidationData* validationData = (bool4__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
bool returnValue = boolDataEnd( &ColladaParserAutoGen15::data__bvec4, &validate__bool4_type__streamEnd, &validationData->validationWholeSize, 0 );
        ParserError::ErrorType simpleTypeValidationResult = validate__bool4_type(0, (*(&validationData->validationWholeSize)));
        mValidationDataStack.deleteObject();
        if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
        {
            if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
                simpleTypeValidationResult,
                HASH_ELEMENT_BVEC4,
                (ParserChar*)0, 0 ) )
            {
                return false;
            }
        }
        return returnValue;
    }
    else
    {
return boolDataEnd( &ColladaParserAutoGen15::data__bvec4 );
    }
#else
    {
return boolDataEnd( &ColladaParserAutoGen15::data__bvec4 );
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__bvec4( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__vec2( const ParserChar* text, size_t textLength )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        radius____float2_type__ValidationData* validationData = (radius____float2_type__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
return characterData2FloatData(text, textLength, &ColladaParserAutoGen15::data__vec2, &validate__float2_type__stream, &validationData->validationWholeSize, 0);
    }
    else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen15::data__vec2);
    }
#else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen15::data__vec2);
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__vec2( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__vec2( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__vec2()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__vec2();
        if ( !validationResult ) return false;

    } // validation
#endif

#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        radius____float2_type__ValidationData* validationData = (radius____float2_type__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
bool returnValue = floatDataEnd( &ColladaParserAutoGen15::data__vec2, &validate__float2_type__streamEnd, &validationData->validationWholeSize, 0 );
        ParserError::ErrorType simpleTypeValidationResult = validate__float2_type(0, (*(&validationData->validationWholeSize)));
        mValidationDataStack.deleteObject();
        if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
        {
            if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
                simpleTypeValidationResult,
                HASH_ELEMENT_VEC2,
                (ParserChar*)0, 0 ) )
            {
                return false;
            }
        }
        return returnValue;
    }
    else
    {
return floatDataEnd( &ColladaParserAutoGen15::data__vec2 );
    }
#else
    {
return floatDataEnd( &ColladaParserAutoGen15::data__vec2 );
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__vec2( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__vec3( const ParserChar* text, size_t textLength )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        origin____float3_type__ValidationData* validationData = (origin____float3_type__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
return characterData2FloatData(text, textLength, &ColladaParserAutoGen15::data__vec3, &validate__float3_type__stream, &validationData->validationWholeSize, 0);
    }
    else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen15::data__vec3);
    }
#else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen15::data__vec3);
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__vec3( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__vec3( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__vec3()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__vec3();
        if ( !validationResult ) return false;

    } // validation
#endif

#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        origin____float3_type__ValidationData* validationData = (origin____float3_type__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
bool returnValue = floatDataEnd( &ColladaParserAutoGen15::data__vec3, &validate__float3_type__streamEnd, &validationData->validationWholeSize, 0 );
        ParserError::ErrorType simpleTypeValidationResult = validate__float3_type(0, (*(&validationData->validationWholeSize)));
        mValidationDataStack.deleteObject();
        if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
        {
            if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
                simpleTypeValidationResult,
                HASH_ELEMENT_VEC3,
                (ParserChar*)0, 0 ) )
            {
                return false;
            }
        }
        return returnValue;
    }
    else
    {
return floatDataEnd( &ColladaParserAutoGen15::data__vec3 );
    }
#else
    {
return floatDataEnd( &ColladaParserAutoGen15::data__vec3 );
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__vec3( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__vec4( const ParserChar* text, size_t textLength )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        orient__ValidationData* validationData = (orient__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
return characterData2FloatData(text, textLength, &ColladaParserAutoGen15::data__vec4, &validate__float4_type__stream, &validationData->validationWholeSize, 0);
    }
    else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen15::data__vec4);
    }
#else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen15::data__vec4);
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__vec4( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__vec4( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__vec4()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__vec4();
        if ( !validationResult ) return false;

    } // validation
#endif

#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        orient__ValidationData* validationData = (orient__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
bool returnValue = floatDataEnd( &ColladaParserAutoGen15::data__vec4, &validate__float4_type__streamEnd, &validationData->validationWholeSize, 0 );
        ParserError::ErrorType simpleTypeValidationResult = validate__float4_type(0, (*(&validationData->validationWholeSize)));
        mValidationDataStack.deleteObject();
        if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
        {
            if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
                simpleTypeValidationResult,
                HASH_ELEMENT_VEC4,
                (ParserChar*)0, 0 ) )
            {
                return false;
            }
        }
        return returnValue;
    }
    else
    {
return floatDataEnd( &ColladaParserAutoGen15::data__vec4 );
    }
#else
    {
return floatDataEnd( &ColladaParserAutoGen15::data__vec4 );
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__vec4( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__mat2( const ParserChar* text, size_t textLength )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        float2x2__ValidationData* validationData = (float2x2__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
return characterData2FloatData(text, textLength, &ColladaParserAutoGen15::data__mat2, &validate__float2x2_type__stream, &validationData->validationWholeSize, 0);
    }
    else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen15::data__mat2);
    }
#else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen15::data__mat2);
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__mat2( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__mat2( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__mat2()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__mat2();
        if ( !validationResult ) return false;

    } // validation
#endif

#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        float2x2__ValidationData* validationData = (float2x2__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
bool returnValue = floatDataEnd( &ColladaParserAutoGen15::data__mat2, &validate__float2x2_type__streamEnd, &validationData->validationWholeSize, 0 );
        ParserError::ErrorType simpleTypeValidationResult = validate__float2x2_type(0, (*(&validationData->validationWholeSize)));
        mValidationDataStack.deleteObject();
        if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
        {
            if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
                simpleTypeValidationResult,
                HASH_ELEMENT_MAT2,
                (ParserChar*)0, 0 ) )
            {
                return false;
            }
        }
        return returnValue;
    }
    else
    {
return floatDataEnd( &ColladaParserAutoGen15::data__mat2 );
    }
#else
    {
return floatDataEnd( &ColladaParserAutoGen15::data__mat2 );
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__mat2( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__mat3( const ParserChar* text, size_t textLength )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        float3x3__ValidationData* validationData = (float3x3__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
return characterData2FloatData(text, textLength, &ColladaParserAutoGen15::data__mat3, &validate__float3x3_type__stream, &validationData->validationWholeSize, 0);
    }
    else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen15::data__mat3);
    }
#else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen15::data__mat3);
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__mat3( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__mat3( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__mat3()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__mat3();
        if ( !validationResult ) return false;

    } // validation
#endif

#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        float3x3__ValidationData* validationData = (float3x3__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
bool returnValue = floatDataEnd( &ColladaParserAutoGen15::data__mat3, &validate__float3x3_type__streamEnd, &validationData->validationWholeSize, 0 );
        ParserError::ErrorType simpleTypeValidationResult = validate__float3x3_type(0, (*(&validationData->validationWholeSize)));
        mValidationDataStack.deleteObject();
        if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
        {
            if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
                simpleTypeValidationResult,
                HASH_ELEMENT_MAT3,
                (ParserChar*)0, 0 ) )
            {
                return false;
            }
        }
        return returnValue;
    }
    else
    {
return floatDataEnd( &ColladaParserAutoGen15::data__mat3 );
    }
#else
    {
return floatDataEnd( &ColladaParserAutoGen15::data__mat3 );
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__mat3( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__mat4( const ParserChar* text, size_t textLength )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        bind_shape_matrix__ValidationData* validationData = (bind_shape_matrix__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
return characterData2FloatData(text, textLength, &ColladaParserAutoGen15::data__mat4, &validate__float4x4_type__stream, &validationData->validationWholeSize, 0);
    }
    else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen15::data__mat4);
    }
#else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen15::data__mat4);
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__mat4( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__mat4( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__mat4()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__mat4();
        if ( !validationResult ) return false;

    } // validation
#endif

#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        bind_shape_matrix__ValidationData* validationData = (bind_shape_matrix__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
bool returnValue = floatDataEnd( &ColladaParserAutoGen15::data__mat4, &validate__float4x4_type__streamEnd, &validationData->validationWholeSize, 0 );
        ParserError::ErrorType simpleTypeValidationResult = validate__float4x4_type(0, (*(&validationData->validationWholeSize)));
        mValidationDataStack.deleteObject();
        if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
        {
            if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
                simpleTypeValidationResult,
                HASH_ELEMENT_MAT4,
                (ParserChar*)0, 0 ) )
            {
                return false;
            }
        }
        return returnValue;
    }
    else
    {
return floatDataEnd( &ColladaParserAutoGen15::data__mat4 );
    }
#else
    {
return floatDataEnd( &ColladaParserAutoGen15::data__mat4 );
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__mat4( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__ivec2( const ParserChar* text, size_t textLength )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        int2__ValidationData* validationData = (int2__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
return characterData2Sint64Data(text, textLength, &ColladaParserAutoGen15::data__ivec2, &validate__int2_type__stream, &validationData->validationWholeSize, 0);
    }
    else
    {
return characterData2Sint64Data(text, textLength, &ColladaParserAutoGen15::data__ivec2);
    }
#else
    {
return characterData2Sint64Data(text, textLength, &ColladaParserAutoGen15::data__ivec2);
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__ivec2( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__ivec2( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__ivec2()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__ivec2();
        if ( !validationResult ) return false;

    } // validation
#endif

#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        int2__ValidationData* validationData = (int2__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
bool returnValue = sint64DataEnd( &ColladaParserAutoGen15::data__ivec2, &validate__int2_type__streamEnd, &validationData->validationWholeSize, 0 );
        ParserError::ErrorType simpleTypeValidationResult = validate__int2_type(0, (*(&validationData->validationWholeSize)));
        mValidationDataStack.deleteObject();
        if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
        {
            if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
                simpleTypeValidationResult,
                HASH_ELEMENT_IVEC2,
                (ParserChar*)0, 0 ) )
            {
                return false;
            }
        }
        return returnValue;
    }
    else
    {
return sint64DataEnd( &ColladaParserAutoGen15::data__ivec2 );
    }
#else
    {
return sint64DataEnd( &ColladaParserAutoGen15::data__ivec2 );
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__ivec2( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__ivec3( const ParserChar* text, size_t textLength )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        int3__ValidationData* validationData = (int3__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
return characterData2Sint64Data(text, textLength, &ColladaParserAutoGen15::data__ivec3, &validate__int3_type__stream, &validationData->validationWholeSize, 0);
    }
    else
    {
return characterData2Sint64Data(text, textLength, &ColladaParserAutoGen15::data__ivec3);
    }
#else
    {
return characterData2Sint64Data(text, textLength, &ColladaParserAutoGen15::data__ivec3);
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__ivec3( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__ivec3( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__ivec3()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__ivec3();
        if ( !validationResult ) return false;

    } // validation
#endif

#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        int3__ValidationData* validationData = (int3__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
bool returnValue = sint64DataEnd( &ColladaParserAutoGen15::data__ivec3, &validate__int3_type__streamEnd, &validationData->validationWholeSize, 0 );
        ParserError::ErrorType simpleTypeValidationResult = validate__int3_type(0, (*(&validationData->validationWholeSize)));
        mValidationDataStack.deleteObject();
        if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
        {
            if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
                simpleTypeValidationResult,
                HASH_ELEMENT_IVEC3,
                (ParserChar*)0, 0 ) )
            {
                return false;
            }
        }
        return returnValue;
    }
    else
    {
return sint64DataEnd( &ColladaParserAutoGen15::data__ivec3 );
    }
#else
    {
return sint64DataEnd( &ColladaParserAutoGen15::data__ivec3 );
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__ivec3( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__ivec4( const ParserChar* text, size_t textLength )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        int4__ValidationData* validationData = (int4__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
return characterData2Sint64Data(text, textLength, &ColladaParserAutoGen15::data__ivec4, &validate__int4_type__stream, &validationData->validationWholeSize, 0);
    }
    else
    {
return characterData2Sint64Data(text, textLength, &ColladaParserAutoGen15::data__ivec4);
    }
#else
    {
return characterData2Sint64Data(text, textLength, &ColladaParserAutoGen15::data__ivec4);
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__ivec4( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__ivec4( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__ivec4()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__ivec4();
        if ( !validationResult ) return false;

    } // validation
#endif

#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        int4__ValidationData* validationData = (int4__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
bool returnValue = sint64DataEnd( &ColladaParserAutoGen15::data__ivec4, &validate__int4_type__streamEnd, &validationData->validationWholeSize, 0 );
        ParserError::ErrorType simpleTypeValidationResult = validate__int4_type(0, (*(&validationData->validationWholeSize)));
        mValidationDataStack.deleteObject();
        if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
        {
            if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
                simpleTypeValidationResult,
                HASH_ELEMENT_IVEC4,
                (ParserChar*)0, 0 ) )
            {
                return false;
            }
        }
        return returnValue;
    }
    else
    {
return sint64DataEnd( &ColladaParserAutoGen15::data__ivec4 );
    }
#else
    {
return sint64DataEnd( &ColladaParserAutoGen15::data__ivec4 );
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__ivec4( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__enum____gl_enumeration_type( const ParserChar* text, size_t textLength )
{
if (!mLastIncompleteFragmentInCharacterData)
{
    mLastIncompleteFragmentInCharacterData = (ParserChar*)mStackMemoryManager.newObject(textLength);
    memcpy(mLastIncompleteFragmentInCharacterData, text, textLength);
    mEndOfDataInCurrentObjectOnStack = mLastIncompleteFragmentInCharacterData + textLength;
}
else
{
    ParserChar* tmp = (ParserChar*)mStackMemoryManager.growObject(textLength);
    if ( tmp != mLastIncompleteFragmentInCharacterData ) {
        mEndOfDataInCurrentObjectOnStack = (mEndOfDataInCurrentObjectOnStack - mLastIncompleteFragmentInCharacterData) + tmp;
        mLastIncompleteFragmentInCharacterData = tmp;
    }
    memcpy(mEndOfDataInCurrentObjectOnStack, text, textLength);
    mEndOfDataInCurrentObjectOnStack += textLength;
}
return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__enum____gl_enumeration_type( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__enum____gl_enumeration_type( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__enum____gl_enumeration_type()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__enum____gl_enumeration_type();
        if ( !validationResult ) return false;

    } // validation
#endif

bool failed;
const ParserChar* ptrForErr = mLastIncompleteFragmentInCharacterData;
DISABLE_WARNING_UNUSED(ptrForErr)
UNION__gl_enumeration_type parameter = toUnion_UNION__gl_enumeration_type( mLastIncompleteFragmentInCharacterData, (size_t)(mEndOfDataInCurrentObjectOnStack - mLastIncompleteFragmentInCharacterData), failed );
bool returnValue;
if (!failed)
{
    returnValue = mImpl->data__enum____gl_enumeration_type(parameter);
}
else
    returnValue = !handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_TEXTDATA_PARSING_FAILED, HASH_ELEMENT_ENUM, (const ParserChar*)0, mLastIncompleteFragmentInCharacterData);
if (mLastIncompleteFragmentInCharacterData)
    mStackMemoryManager.deleteObject();
mLastIncompleteFragmentInCharacterData = 0;
mEndOfDataInCurrentObjectOnStack = 0;
return returnValue;

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__enum____gl_enumeration_type( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
ENUM__gl_blend_enum ColladaParserAutoGen15Private::toEnumDataPrefix_ENUM__gl_blend_enum (
    const ParserChar* prefixedBuffer,
    const ParserChar* prefixedBufferEnd,
    const ParserChar** buffer,
    const ParserChar* bufferEnd,
    bool& failed,
    const std::pair<StringHash, ENUM__gl_blend_enum>* enumMap,
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& )
)
{
    return toEnumDataPrefix<ENUM__gl_blend_enum, StringHash, ENUM__gl_blend_enum__COUNT, &toEnum_ENUM__gl_blend_enum>(prefixedBuffer, prefixedBufferEnd, buffer, bufferEnd, failed, enumMap, baseConversionFunc);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::characterData2EnumData_ENUM__gl_blend_enum (
    const ParserChar* text,
    size_t textLength,
    bool ( ColladaParserAutoGen15::*dataFunction )(const ENUM__gl_blend_enum*, size_t ),
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& )
)
{
    return characterData2EnumData<ENUM__gl_blend_enum, StringHash, ENUM__gl_blend_enum__COUNT>(text, textLength, dataFunction, ENUM__gl_blend_enumMap, baseConversionFunc, &toEnum_ENUM__gl_blend_enum, &ColladaParserAutoGen15Private::toEnumDataPrefix_ENUM__gl_blend_enum);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::dataEnumEnd_ENUM__gl_blend_enum (
    bool ( ColladaParserAutoGen15::*dataFunction )(const ENUM__gl_blend_enum*, size_t ),
    const std::pair<StringHash, ENUM__gl_blend_enum>* enumMap,
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& ),
    ENUM__gl_blend_enum (*toEnumFunc)( const ParserChar**, const ParserChar*, bool&, const std::pair<StringHash, ENUM__gl_blend_enum>* enumMap, StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& ))
)
{
    return dataEnumEnd<ENUM__gl_blend_enum, StringHash, ENUM__gl_blend_enum__COUNT>(dataFunction, enumMap, baseConversionFunc, toEnumFunc);
}

//---------------------------------------------------------------------
ENUM__gl_face_enum ColladaParserAutoGen15Private::toEnumDataPrefix_ENUM__gl_face_enum (
    const ParserChar* prefixedBuffer,
    const ParserChar* prefixedBufferEnd,
    const ParserChar** buffer,
    const ParserChar* bufferEnd,
    bool& failed,
    const std::pair<StringHash, ENUM__gl_face_enum>* enumMap,
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& )
)
{
    return toEnumDataPrefix<ENUM__gl_face_enum, StringHash, ENUM__gl_face_enum__COUNT, &toEnum_ENUM__gl_face_enum>(prefixedBuffer, prefixedBufferEnd, buffer, bufferEnd, failed, enumMap, baseConversionFunc);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::characterData2EnumData_ENUM__gl_face_enum (
    const ParserChar* text,
    size_t textLength,
    bool ( ColladaParserAutoGen15::*dataFunction )(const ENUM__gl_face_enum*, size_t ),
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& )
)
{
    return characterData2EnumData<ENUM__gl_face_enum, StringHash, ENUM__gl_face_enum__COUNT>(text, textLength, dataFunction, ENUM__gl_face_enumMap, baseConversionFunc, &toEnum_ENUM__gl_face_enum, &ColladaParserAutoGen15Private::toEnumDataPrefix_ENUM__gl_face_enum);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::dataEnumEnd_ENUM__gl_face_enum (
    bool ( ColladaParserAutoGen15::*dataFunction )(const ENUM__gl_face_enum*, size_t ),
    const std::pair<StringHash, ENUM__gl_face_enum>* enumMap,
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& ),
    ENUM__gl_face_enum (*toEnumFunc)( const ParserChar**, const ParserChar*, bool&, const std::pair<StringHash, ENUM__gl_face_enum>* enumMap, StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& ))
)
{
    return dataEnumEnd<ENUM__gl_face_enum, StringHash, ENUM__gl_face_enum__COUNT>(dataFunction, enumMap, baseConversionFunc, toEnumFunc);
}

//---------------------------------------------------------------------
ENUM__gl_blend_equation_enum ColladaParserAutoGen15Private::toEnumDataPrefix_ENUM__gl_blend_equation_enum (
    const ParserChar* prefixedBuffer,
    const ParserChar* prefixedBufferEnd,
    const ParserChar** buffer,
    const ParserChar* bufferEnd,
    bool& failed,
    const std::pair<StringHash, ENUM__gl_blend_equation_enum>* enumMap,
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& )
)
{
    return toEnumDataPrefix<ENUM__gl_blend_equation_enum, StringHash, ENUM__gl_blend_equation_enum__COUNT, &toEnum_ENUM__gl_blend_equation_enum>(prefixedBuffer, prefixedBufferEnd, buffer, bufferEnd, failed, enumMap, baseConversionFunc);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::characterData2EnumData_ENUM__gl_blend_equation_enum (
    const ParserChar* text,
    size_t textLength,
    bool ( ColladaParserAutoGen15::*dataFunction )(const ENUM__gl_blend_equation_enum*, size_t ),
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& )
)
{
    return characterData2EnumData<ENUM__gl_blend_equation_enum, StringHash, ENUM__gl_blend_equation_enum__COUNT>(text, textLength, dataFunction, ENUM__gl_blend_equation_enumMap, baseConversionFunc, &toEnum_ENUM__gl_blend_equation_enum, &ColladaParserAutoGen15Private::toEnumDataPrefix_ENUM__gl_blend_equation_enum);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::dataEnumEnd_ENUM__gl_blend_equation_enum (
    bool ( ColladaParserAutoGen15::*dataFunction )(const ENUM__gl_blend_equation_enum*, size_t ),
    const std::pair<StringHash, ENUM__gl_blend_equation_enum>* enumMap,
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& ),
    ENUM__gl_blend_equation_enum (*toEnumFunc)( const ParserChar**, const ParserChar*, bool&, const std::pair<StringHash, ENUM__gl_blend_equation_enum>* enumMap, StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& ))
)
{
    return dataEnumEnd<ENUM__gl_blend_equation_enum, StringHash, ENUM__gl_blend_equation_enum__COUNT>(dataFunction, enumMap, baseConversionFunc, toEnumFunc);
}

//---------------------------------------------------------------------
ENUM__gl_func_enum ColladaParserAutoGen15Private::toEnumDataPrefix_ENUM__gl_func_enum (
    const ParserChar* prefixedBuffer,
    const ParserChar* prefixedBufferEnd,
    const ParserChar** buffer,
    const ParserChar* bufferEnd,
    bool& failed,
    const std::pair<StringHash, ENUM__gl_func_enum>* enumMap,
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& )
)
{
    return toEnumDataPrefix<ENUM__gl_func_enum, StringHash, ENUM__gl_func_enum__COUNT, &toEnum_ENUM__gl_func_enum>(prefixedBuffer, prefixedBufferEnd, buffer, bufferEnd, failed, enumMap, baseConversionFunc);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::characterData2EnumData_ENUM__gl_func_enum (
    const ParserChar* text,
    size_t textLength,
    bool ( ColladaParserAutoGen15::*dataFunction )(const ENUM__gl_func_enum*, size_t ),
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& )
)
{
    return characterData2EnumData<ENUM__gl_func_enum, StringHash, ENUM__gl_func_enum__COUNT>(text, textLength, dataFunction, ENUM__gl_func_enumMap, baseConversionFunc, &toEnum_ENUM__gl_func_enum, &ColladaParserAutoGen15Private::toEnumDataPrefix_ENUM__gl_func_enum);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::dataEnumEnd_ENUM__gl_func_enum (
    bool ( ColladaParserAutoGen15::*dataFunction )(const ENUM__gl_func_enum*, size_t ),
    const std::pair<StringHash, ENUM__gl_func_enum>* enumMap,
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& ),
    ENUM__gl_func_enum (*toEnumFunc)( const ParserChar**, const ParserChar*, bool&, const std::pair<StringHash, ENUM__gl_func_enum>* enumMap, StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& ))
)
{
    return dataEnumEnd<ENUM__gl_func_enum, StringHash, ENUM__gl_func_enum__COUNT>(dataFunction, enumMap, baseConversionFunc, toEnumFunc);
}

//---------------------------------------------------------------------
ENUM__gl_stencil_op_enum ColladaParserAutoGen15Private::toEnumDataPrefix_ENUM__gl_stencil_op_enum (
    const ParserChar* prefixedBuffer,
    const ParserChar* prefixedBufferEnd,
    const ParserChar** buffer,
    const ParserChar* bufferEnd,
    bool& failed,
    const std::pair<StringHash, ENUM__gl_stencil_op_enum>* enumMap,
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& )
)
{
    return toEnumDataPrefix<ENUM__gl_stencil_op_enum, StringHash, ENUM__gl_stencil_op_enum__COUNT, &toEnum_ENUM__gl_stencil_op_enum>(prefixedBuffer, prefixedBufferEnd, buffer, bufferEnd, failed, enumMap, baseConversionFunc);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::characterData2EnumData_ENUM__gl_stencil_op_enum (
    const ParserChar* text,
    size_t textLength,
    bool ( ColladaParserAutoGen15::*dataFunction )(const ENUM__gl_stencil_op_enum*, size_t ),
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& )
)
{
    return characterData2EnumData<ENUM__gl_stencil_op_enum, StringHash, ENUM__gl_stencil_op_enum__COUNT>(text, textLength, dataFunction, ENUM__gl_stencil_op_enumMap, baseConversionFunc, &toEnum_ENUM__gl_stencil_op_enum, &ColladaParserAutoGen15Private::toEnumDataPrefix_ENUM__gl_stencil_op_enum);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::dataEnumEnd_ENUM__gl_stencil_op_enum (
    bool ( ColladaParserAutoGen15::*dataFunction )(const ENUM__gl_stencil_op_enum*, size_t ),
    const std::pair<StringHash, ENUM__gl_stencil_op_enum>* enumMap,
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& ),
    ENUM__gl_stencil_op_enum (*toEnumFunc)( const ParserChar**, const ParserChar*, bool&, const std::pair<StringHash, ENUM__gl_stencil_op_enum>* enumMap, StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& ))
)
{
    return dataEnumEnd<ENUM__gl_stencil_op_enum, StringHash, ENUM__gl_stencil_op_enum__COUNT>(dataFunction, enumMap, baseConversionFunc, toEnumFunc);
}

//---------------------------------------------------------------------
ENUM__gl_material_enum ColladaParserAutoGen15Private::toEnumDataPrefix_ENUM__gl_material_enum (
    const ParserChar* prefixedBuffer,
    const ParserChar* prefixedBufferEnd,
    const ParserChar** buffer,
    const ParserChar* bufferEnd,
    bool& failed,
    const std::pair<StringHash, ENUM__gl_material_enum>* enumMap,
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& )
)
{
    return toEnumDataPrefix<ENUM__gl_material_enum, StringHash, ENUM__gl_material_enum__COUNT, &toEnum_ENUM__gl_material_enum>(prefixedBuffer, prefixedBufferEnd, buffer, bufferEnd, failed, enumMap, baseConversionFunc);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::characterData2EnumData_ENUM__gl_material_enum (
    const ParserChar* text,
    size_t textLength,
    bool ( ColladaParserAutoGen15::*dataFunction )(const ENUM__gl_material_enum*, size_t ),
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& )
)
{
    return characterData2EnumData<ENUM__gl_material_enum, StringHash, ENUM__gl_material_enum__COUNT>(text, textLength, dataFunction, ENUM__gl_material_enumMap, baseConversionFunc, &toEnum_ENUM__gl_material_enum, &ColladaParserAutoGen15Private::toEnumDataPrefix_ENUM__gl_material_enum);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::dataEnumEnd_ENUM__gl_material_enum (
    bool ( ColladaParserAutoGen15::*dataFunction )(const ENUM__gl_material_enum*, size_t ),
    const std::pair<StringHash, ENUM__gl_material_enum>* enumMap,
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& ),
    ENUM__gl_material_enum (*toEnumFunc)( const ParserChar**, const ParserChar*, bool&, const std::pair<StringHash, ENUM__gl_material_enum>* enumMap, StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& ))
)
{
    return dataEnumEnd<ENUM__gl_material_enum, StringHash, ENUM__gl_material_enum__COUNT>(dataFunction, enumMap, baseConversionFunc, toEnumFunc);
}

//---------------------------------------------------------------------
ENUM__gl_fog_enum ColladaParserAutoGen15Private::toEnumDataPrefix_ENUM__gl_fog_enum (
    const ParserChar* prefixedBuffer,
    const ParserChar* prefixedBufferEnd,
    const ParserChar** buffer,
    const ParserChar* bufferEnd,
    bool& failed,
    const std::pair<StringHash, ENUM__gl_fog_enum>* enumMap,
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& )
)
{
    return toEnumDataPrefix<ENUM__gl_fog_enum, StringHash, ENUM__gl_fog_enum__COUNT, &toEnum_ENUM__gl_fog_enum>(prefixedBuffer, prefixedBufferEnd, buffer, bufferEnd, failed, enumMap, baseConversionFunc);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::characterData2EnumData_ENUM__gl_fog_enum (
    const ParserChar* text,
    size_t textLength,
    bool ( ColladaParserAutoGen15::*dataFunction )(const ENUM__gl_fog_enum*, size_t ),
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& )
)
{
    return characterData2EnumData<ENUM__gl_fog_enum, StringHash, ENUM__gl_fog_enum__COUNT>(text, textLength, dataFunction, ENUM__gl_fog_enumMap, baseConversionFunc, &toEnum_ENUM__gl_fog_enum, &ColladaParserAutoGen15Private::toEnumDataPrefix_ENUM__gl_fog_enum);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::dataEnumEnd_ENUM__gl_fog_enum (
    bool ( ColladaParserAutoGen15::*dataFunction )(const ENUM__gl_fog_enum*, size_t ),
    const std::pair<StringHash, ENUM__gl_fog_enum>* enumMap,
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& ),
    ENUM__gl_fog_enum (*toEnumFunc)( const ParserChar**, const ParserChar*, bool&, const std::pair<StringHash, ENUM__gl_fog_enum>* enumMap, StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& ))
)
{
    return dataEnumEnd<ENUM__gl_fog_enum, StringHash, ENUM__gl_fog_enum__COUNT>(dataFunction, enumMap, baseConversionFunc, toEnumFunc);
}

//---------------------------------------------------------------------
ENUM__gl_fog_coord_src_enum ColladaParserAutoGen15Private::toEnumDataPrefix_ENUM__gl_fog_coord_src_enum (
    const ParserChar* prefixedBuffer,
    const ParserChar* prefixedBufferEnd,
    const ParserChar** buffer,
    const ParserChar* bufferEnd,
    bool& failed,
    const std::pair<StringHash, ENUM__gl_fog_coord_src_enum>* enumMap,
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& )
)
{
    return toEnumDataPrefix<ENUM__gl_fog_coord_src_enum, StringHash, ENUM__gl_fog_coord_src_enum__COUNT, &toEnum_ENUM__gl_fog_coord_src_enum>(prefixedBuffer, prefixedBufferEnd, buffer, bufferEnd, failed, enumMap, baseConversionFunc);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::characterData2EnumData_ENUM__gl_fog_coord_src_enum (
    const ParserChar* text,
    size_t textLength,
    bool ( ColladaParserAutoGen15::*dataFunction )(const ENUM__gl_fog_coord_src_enum*, size_t ),
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& )
)
{
    return characterData2EnumData<ENUM__gl_fog_coord_src_enum, StringHash, ENUM__gl_fog_coord_src_enum__COUNT>(text, textLength, dataFunction, ENUM__gl_fog_coord_src_enumMap, baseConversionFunc, &toEnum_ENUM__gl_fog_coord_src_enum, &ColladaParserAutoGen15Private::toEnumDataPrefix_ENUM__gl_fog_coord_src_enum);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::dataEnumEnd_ENUM__gl_fog_coord_src_enum (
    bool ( ColladaParserAutoGen15::*dataFunction )(const ENUM__gl_fog_coord_src_enum*, size_t ),
    const std::pair<StringHash, ENUM__gl_fog_coord_src_enum>* enumMap,
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& ),
    ENUM__gl_fog_coord_src_enum (*toEnumFunc)( const ParserChar**, const ParserChar*, bool&, const std::pair<StringHash, ENUM__gl_fog_coord_src_enum>* enumMap, StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& ))
)
{
    return dataEnumEnd<ENUM__gl_fog_coord_src_enum, StringHash, ENUM__gl_fog_coord_src_enum__COUNT>(dataFunction, enumMap, baseConversionFunc, toEnumFunc);
}

//---------------------------------------------------------------------
ENUM__gl_front_face_enum ColladaParserAutoGen15Private::toEnumDataPrefix_ENUM__gl_front_face_enum (
    const ParserChar* prefixedBuffer,
    const ParserChar* prefixedBufferEnd,
    const ParserChar** buffer,
    const ParserChar* bufferEnd,
    bool& failed,
    const std::pair<StringHash, ENUM__gl_front_face_enum>* enumMap,
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& )
)
{
    return toEnumDataPrefix<ENUM__gl_front_face_enum, StringHash, ENUM__gl_front_face_enum__COUNT, &toEnum_ENUM__gl_front_face_enum>(prefixedBuffer, prefixedBufferEnd, buffer, bufferEnd, failed, enumMap, baseConversionFunc);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::characterData2EnumData_ENUM__gl_front_face_enum (
    const ParserChar* text,
    size_t textLength,
    bool ( ColladaParserAutoGen15::*dataFunction )(const ENUM__gl_front_face_enum*, size_t ),
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& )
)
{
    return characterData2EnumData<ENUM__gl_front_face_enum, StringHash, ENUM__gl_front_face_enum__COUNT>(text, textLength, dataFunction, ENUM__gl_front_face_enumMap, baseConversionFunc, &toEnum_ENUM__gl_front_face_enum, &ColladaParserAutoGen15Private::toEnumDataPrefix_ENUM__gl_front_face_enum);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::dataEnumEnd_ENUM__gl_front_face_enum (
    bool ( ColladaParserAutoGen15::*dataFunction )(const ENUM__gl_front_face_enum*, size_t ),
    const std::pair<StringHash, ENUM__gl_front_face_enum>* enumMap,
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& ),
    ENUM__gl_front_face_enum (*toEnumFunc)( const ParserChar**, const ParserChar*, bool&, const std::pair<StringHash, ENUM__gl_front_face_enum>* enumMap, StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& ))
)
{
    return dataEnumEnd<ENUM__gl_front_face_enum, StringHash, ENUM__gl_front_face_enum__COUNT>(dataFunction, enumMap, baseConversionFunc, toEnumFunc);
}

//---------------------------------------------------------------------
ENUM__gl_light_model_color_control_enum ColladaParserAutoGen15Private::toEnumDataPrefix_ENUM__gl_light_model_color_control_enum (
    const ParserChar* prefixedBuffer,
    const ParserChar* prefixedBufferEnd,
    const ParserChar** buffer,
    const ParserChar* bufferEnd,
    bool& failed,
    const std::pair<StringHash, ENUM__gl_light_model_color_control_enum>* enumMap,
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& )
)
{
    return toEnumDataPrefix<ENUM__gl_light_model_color_control_enum, StringHash, ENUM__gl_light_model_color_control_enum__COUNT, &toEnum_ENUM__gl_light_model_color_control_enum>(prefixedBuffer, prefixedBufferEnd, buffer, bufferEnd, failed, enumMap, baseConversionFunc);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::characterData2EnumData_ENUM__gl_light_model_color_control_enum (
    const ParserChar* text,
    size_t textLength,
    bool ( ColladaParserAutoGen15::*dataFunction )(const ENUM__gl_light_model_color_control_enum*, size_t ),
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& )
)
{
    return characterData2EnumData<ENUM__gl_light_model_color_control_enum, StringHash, ENUM__gl_light_model_color_control_enum__COUNT>(text, textLength, dataFunction, ENUM__gl_light_model_color_control_enumMap, baseConversionFunc, &toEnum_ENUM__gl_light_model_color_control_enum, &ColladaParserAutoGen15Private::toEnumDataPrefix_ENUM__gl_light_model_color_control_enum);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::dataEnumEnd_ENUM__gl_light_model_color_control_enum (
    bool ( ColladaParserAutoGen15::*dataFunction )(const ENUM__gl_light_model_color_control_enum*, size_t ),
    const std::pair<StringHash, ENUM__gl_light_model_color_control_enum>* enumMap,
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& ),
    ENUM__gl_light_model_color_control_enum (*toEnumFunc)( const ParserChar**, const ParserChar*, bool&, const std::pair<StringHash, ENUM__gl_light_model_color_control_enum>* enumMap, StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& ))
)
{
    return dataEnumEnd<ENUM__gl_light_model_color_control_enum, StringHash, ENUM__gl_light_model_color_control_enum__COUNT>(dataFunction, enumMap, baseConversionFunc, toEnumFunc);
}

//---------------------------------------------------------------------
ENUM__gl_logic_op_enum ColladaParserAutoGen15Private::toEnumDataPrefix_ENUM__gl_logic_op_enum (
    const ParserChar* prefixedBuffer,
    const ParserChar* prefixedBufferEnd,
    const ParserChar** buffer,
    const ParserChar* bufferEnd,
    bool& failed,
    const std::pair<StringHash, ENUM__gl_logic_op_enum>* enumMap,
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& )
)
{
    return toEnumDataPrefix<ENUM__gl_logic_op_enum, StringHash, ENUM__gl_logic_op_enum__COUNT, &toEnum_ENUM__gl_logic_op_enum>(prefixedBuffer, prefixedBufferEnd, buffer, bufferEnd, failed, enumMap, baseConversionFunc);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::characterData2EnumData_ENUM__gl_logic_op_enum (
    const ParserChar* text,
    size_t textLength,
    bool ( ColladaParserAutoGen15::*dataFunction )(const ENUM__gl_logic_op_enum*, size_t ),
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& )
)
{
    return characterData2EnumData<ENUM__gl_logic_op_enum, StringHash, ENUM__gl_logic_op_enum__COUNT>(text, textLength, dataFunction, ENUM__gl_logic_op_enumMap, baseConversionFunc, &toEnum_ENUM__gl_logic_op_enum, &ColladaParserAutoGen15Private::toEnumDataPrefix_ENUM__gl_logic_op_enum);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::dataEnumEnd_ENUM__gl_logic_op_enum (
    bool ( ColladaParserAutoGen15::*dataFunction )(const ENUM__gl_logic_op_enum*, size_t ),
    const std::pair<StringHash, ENUM__gl_logic_op_enum>* enumMap,
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& ),
    ENUM__gl_logic_op_enum (*toEnumFunc)( const ParserChar**, const ParserChar*, bool&, const std::pair<StringHash, ENUM__gl_logic_op_enum>* enumMap, StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& ))
)
{
    return dataEnumEnd<ENUM__gl_logic_op_enum, StringHash, ENUM__gl_logic_op_enum__COUNT>(dataFunction, enumMap, baseConversionFunc, toEnumFunc);
}

//---------------------------------------------------------------------
ENUM__gl_polygon_mode_enum ColladaParserAutoGen15Private::toEnumDataPrefix_ENUM__gl_polygon_mode_enum (
    const ParserChar* prefixedBuffer,
    const ParserChar* prefixedBufferEnd,
    const ParserChar** buffer,
    const ParserChar* bufferEnd,
    bool& failed,
    const std::pair<StringHash, ENUM__gl_polygon_mode_enum>* enumMap,
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& )
)
{
    return toEnumDataPrefix<ENUM__gl_polygon_mode_enum, StringHash, ENUM__gl_polygon_mode_enum__COUNT, &toEnum_ENUM__gl_polygon_mode_enum>(prefixedBuffer, prefixedBufferEnd, buffer, bufferEnd, failed, enumMap, baseConversionFunc);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::characterData2EnumData_ENUM__gl_polygon_mode_enum (
    const ParserChar* text,
    size_t textLength,
    bool ( ColladaParserAutoGen15::*dataFunction )(const ENUM__gl_polygon_mode_enum*, size_t ),
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& )
)
{
    return characterData2EnumData<ENUM__gl_polygon_mode_enum, StringHash, ENUM__gl_polygon_mode_enum__COUNT>(text, textLength, dataFunction, ENUM__gl_polygon_mode_enumMap, baseConversionFunc, &toEnum_ENUM__gl_polygon_mode_enum, &ColladaParserAutoGen15Private::toEnumDataPrefix_ENUM__gl_polygon_mode_enum);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::dataEnumEnd_ENUM__gl_polygon_mode_enum (
    bool ( ColladaParserAutoGen15::*dataFunction )(const ENUM__gl_polygon_mode_enum*, size_t ),
    const std::pair<StringHash, ENUM__gl_polygon_mode_enum>* enumMap,
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& ),
    ENUM__gl_polygon_mode_enum (*toEnumFunc)( const ParserChar**, const ParserChar*, bool&, const std::pair<StringHash, ENUM__gl_polygon_mode_enum>* enumMap, StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& ))
)
{
    return dataEnumEnd<ENUM__gl_polygon_mode_enum, StringHash, ENUM__gl_polygon_mode_enum__COUNT>(dataFunction, enumMap, baseConversionFunc, toEnumFunc);
}

//---------------------------------------------------------------------
ENUM__gl_shade_model_enum ColladaParserAutoGen15Private::toEnumDataPrefix_ENUM__gl_shade_model_enum (
    const ParserChar* prefixedBuffer,
    const ParserChar* prefixedBufferEnd,
    const ParserChar** buffer,
    const ParserChar* bufferEnd,
    bool& failed,
    const std::pair<StringHash, ENUM__gl_shade_model_enum>* enumMap,
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& )
)
{
    return toEnumDataPrefix<ENUM__gl_shade_model_enum, StringHash, ENUM__gl_shade_model_enum__COUNT, &toEnum_ENUM__gl_shade_model_enum>(prefixedBuffer, prefixedBufferEnd, buffer, bufferEnd, failed, enumMap, baseConversionFunc);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::characterData2EnumData_ENUM__gl_shade_model_enum (
    const ParserChar* text,
    size_t textLength,
    bool ( ColladaParserAutoGen15::*dataFunction )(const ENUM__gl_shade_model_enum*, size_t ),
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& )
)
{
    return characterData2EnumData<ENUM__gl_shade_model_enum, StringHash, ENUM__gl_shade_model_enum__COUNT>(text, textLength, dataFunction, ENUM__gl_shade_model_enumMap, baseConversionFunc, &toEnum_ENUM__gl_shade_model_enum, &ColladaParserAutoGen15Private::toEnumDataPrefix_ENUM__gl_shade_model_enum);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::dataEnumEnd_ENUM__gl_shade_model_enum (
    bool ( ColladaParserAutoGen15::*dataFunction )(const ENUM__gl_shade_model_enum*, size_t ),
    const std::pair<StringHash, ENUM__gl_shade_model_enum>* enumMap,
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& ),
    ENUM__gl_shade_model_enum (*toEnumFunc)( const ParserChar**, const ParserChar*, bool&, const std::pair<StringHash, ENUM__gl_shade_model_enum>* enumMap, StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& ))
)
{
    return dataEnumEnd<ENUM__gl_shade_model_enum, StringHash, ENUM__gl_shade_model_enum__COUNT>(dataFunction, enumMap, baseConversionFunc, toEnumFunc);
}

//---------------------------------------------------------------------
UNION__gl_enumeration_type ColladaParserAutoGen15Private::toUnionPrefix_UNION__gl_enumeration_type (
    const ParserChar* prefixedBuffer,
    const ParserChar* prefixedBufferEnd,
    const ParserChar** buffer,
    const ParserChar* bufferEnd,
    bool& failed
)
{
    return toDataPrefix<UNION__gl_enumeration_type>(prefixedBuffer, prefixedBufferEnd, buffer, bufferEnd, failed, toUnion_UNION__gl_enumeration_type);
}

//---------------------------------------------------------------------
const profile_GLES2__newparam__usertype__AttributeData profile_GLES2__newparam__usertype__AttributeData::DEFAULT = {0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__profile_GLES2__newparam__usertype( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__profile_GLES2__newparam__usertype( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__profile_GLES2__newparam__usertype( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

profile_GLES2__newparam__usertype__AttributeData* attributeData = newData<profile_GLES2__newparam__usertype__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_TYPENAME:
    {

attributeData->_typename = attributeValue;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_USERTYPE, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ( !attributeData->_typename )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_USERTYPE, HASH_ATTRIBUTE_TYPENAME, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__profile_GLES2__newparam__usertype()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__profile_GLES2__newparam__usertype();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__profile_GLES2__newparam__usertype( void* attributeData )
{
    profile_GLES2__newparam__usertype__AttributeData* typedAttributeData = static_cast<profile_GLES2__newparam__usertype__AttributeData*>(attributeData);

    typedAttributeData->~profile_GLES2__newparam__usertype__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const profile_GLES2__newparam__usertype__setparam__AttributeData profile_GLES2__newparam__usertype__setparam__AttributeData::DEFAULT = {0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__profile_GLES2__newparam__usertype__setparam( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__profile_GLES2__newparam__usertype__setparam( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__profile_GLES2__newparam__usertype__setparam( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

profile_GLES2__newparam__usertype__setparam__AttributeData* attributeData = newData<profile_GLES2__newparam__usertype__setparam__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_REF:
    {

attributeData->ref = attributeValue;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_SETPARAM, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ( !attributeData->ref )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_SETPARAM, HASH_ATTRIBUTE_REF, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__profile_GLES2__newparam__usertype__setparam()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__profile_GLES2__newparam__usertype__setparam();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__profile_GLES2__newparam__usertype__setparam( void* attributeData )
{
    profile_GLES2__newparam__usertype__setparam__AttributeData* typedAttributeData = static_cast<profile_GLES2__newparam__usertype__setparam__AttributeData*>(attributeData);

    typedAttributeData->~profile_GLES2__newparam__usertype__setparam__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const profile_GLES2__newparam__usertype__setparam__array__AttributeData profile_GLES2__newparam__usertype__setparam__array__AttributeData::DEFAULT = {0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__profile_GLES2__newparam__usertype__setparam__array( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__profile_GLES2__newparam__usertype__setparam__array( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__profile_GLES2__newparam__usertype__setparam__array( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

profile_GLES2__newparam__usertype__setparam__array__AttributeData* attributeData = newData<profile_GLES2__newparam__usertype__setparam__array__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_LENGTH:
    {
bool failed;
attributeData->length = GeneratedSaxParser::Utils::toUint64(attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_ARRAY,
        HASH_ATTRIBUTE_LENGTH,
        attributeValue))
{
    return false;
}
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__positiveInteger(attributeData->length);
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_ARRAY,
            HASH_ATTRIBUTE_LENGTH,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif
if ( !failed )
    attributeData->present_attributes |= profile_GLES2__newparam__usertype__setparam__array__AttributeData::ATTRIBUTE_LENGTH_PRESENT;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_ARRAY, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ( (attributeData->present_attributes & profile_GLES2__newparam__usertype__setparam__array__AttributeData::ATTRIBUTE_LENGTH_PRESENT) == 0 )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_ARRAY, HASH_ATTRIBUTE_LENGTH, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__profile_GLES2__newparam__usertype__setparam__array()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__profile_GLES2__newparam__usertype__setparam__array();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__profile_GLES2__newparam__usertype__setparam__array( void* attributeData )
{
    profile_GLES2__newparam__usertype__setparam__array__AttributeData* typedAttributeData = static_cast<profile_GLES2__newparam__usertype__setparam__array__AttributeData*>(attributeData);

    typedAttributeData->~profile_GLES2__newparam__usertype__setparam__array__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const profile_gles2_type____technique__AttributeData profile_gles2_type____technique__AttributeData::DEFAULT = {0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__profile_gles2_type____technique( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__profile_gles2_type____technique( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__profile_gles2_type____technique( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

profile_gles2_type____technique__AttributeData* attributeData = newData<profile_gles2_type____technique__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_ID:
    {

attributeData->id = attributeValue;

    break;
    }
    case HASH_ATTRIBUTE_SID:
    {

attributeData->sid = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__sid_type(attributeData->sid, strlen(attributeData->sid));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_TECHNIQUE,
            HASH_ATTRIBUTE_SID,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_TECHNIQUE, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ( !attributeData->sid )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_TECHNIQUE, HASH_ATTRIBUTE_SID, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__profile_gles2_type____technique()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__profile_gles2_type____technique();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__profile_gles2_type____technique( void* attributeData )
{
    profile_gles2_type____technique__AttributeData* typedAttributeData = static_cast<profile_gles2_type____technique__AttributeData*>(attributeData);

    typedAttributeData->~profile_gles2_type____technique__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const pass____gles2_pass_type__AttributeData pass____gles2_pass_type__AttributeData::DEFAULT = {0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__pass____gles2_pass_type( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__pass____gles2_pass_type( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__pass____gles2_pass_type( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

pass____gles2_pass_type__AttributeData* attributeData = newData<pass____gles2_pass_type__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_SID:
    {

attributeData->sid = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__sid_type(attributeData->sid, strlen(attributeData->sid));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_PASS,
            HASH_ATTRIBUTE_SID,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_PASS, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__pass____gles2_pass_type()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__pass____gles2_pass_type();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__pass____gles2_pass_type( void* attributeData )
{
    pass____gles2_pass_type__AttributeData* typedAttributeData = static_cast<pass____gles2_pass_type__AttributeData*>(attributeData);

    typedAttributeData->~pass____gles2_pass_type__AttributeData();

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__gles2_pass_type____states( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__gles2_pass_type____states( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__gles2_pass_type____states( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__gles2_pass_type____states()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__gles2_pass_type____states();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__gles2_pass_type____states( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
const profile_GLES2__technique__pass__states__blend_color__AttributeData profile_GLES2__technique__pass__states__blend_color__AttributeData::DEFAULT = {0, GeneratedSaxParser::XSList<float>(), 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__profile_GLES2__technique__pass__states__blend_color( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__profile_GLES2__technique__pass__states__blend_color( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__profile_GLES2__technique__pass__states__blend_color( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

profile_GLES2__technique__pass__states__blend_color__AttributeData* attributeData = newData<profile_GLES2__technique__pass__states__blend_color__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_VALUE:
    {
bool failed;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
failed = !characterData2FloatList(attributeValue, attributeData->value, 0, HASH_ELEMENT_BLEND_COLOR, HASH_ATTRIBUTE_VALUE);
    }
    else
    {
failed = !characterData2FloatList(attributeValue, attributeData->value);
    }
#else
    {
failed = !characterData2FloatList(attributeValue, attributeData->value);
    } // validation
#endif
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_BLEND_COLOR,
        HASH_ATTRIBUTE_VALUE,
        attributeValue))
{
    return false;
}
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__float4_type(attributeData->value.data, attributeData->value.size);
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_BLEND_COLOR,
            HASH_ATTRIBUTE_VALUE,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

if ( !failed )
    attributeData->present_attributes |= profile_GLES2__technique__pass__states__blend_color__AttributeData::ATTRIBUTE_VALUE_PRESENT;

    break;
    }
    case HASH_ATTRIBUTE_PARAM:
    {

attributeData->param = attributeValue;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_BLEND_COLOR, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ((attributeData->present_attributes & profile_GLES2__technique__pass__states__blend_color__AttributeData::ATTRIBUTE_VALUE_PRESENT) == 0)
{
    bool failed;
    failed = !characterData2FloatList("0.0E1 0.0E1 0.0E1 0.0E1", attributeData->value);
    if ( !failed )
    attributeData->present_attributes |= profile_GLES2__technique__pass__states__blend_color__AttributeData::ATTRIBUTE_VALUE_PRESENT;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__profile_GLES2__technique__pass__states__blend_color()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__profile_GLES2__technique__pass__states__blend_color();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__profile_GLES2__technique__pass__states__blend_color( void* attributeData )
{
    profile_GLES2__technique__pass__states__blend_color__AttributeData* typedAttributeData = static_cast<profile_GLES2__technique__pass__states__blend_color__AttributeData*>(attributeData);
    if (typedAttributeData->value.data)
    {
        mStackMemoryManager.deleteObject();
    }


    typedAttributeData->~profile_GLES2__technique__pass__states__blend_color__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const profile_GLES2__technique__pass__states__blend_equation__AttributeData profile_GLES2__technique__pass__states__blend_equation__AttributeData::DEFAULT = {ENUM__gl_blend_equation_enum__FUNC_ADD, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__profile_GLES2__technique__pass__states__blend_equation( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__profile_GLES2__technique__pass__states__blend_equation( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__profile_GLES2__technique__pass__states__blend_equation( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

profile_GLES2__technique__pass__states__blend_equation__AttributeData* attributeData = newData<profile_GLES2__technique__pass__states__blend_equation__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_VALUE:
    {
bool failed;
attributeData->value = Utils::toEnum<ENUM__gl_blend_equation_enum, StringHash, ENUM__gl_blend_equation_enum__COUNT>(attributeValue, failed, ENUM__gl_blend_equation_enumMap, Utils::calculateStringHash);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_BLEND_EQUATION,
        HASH_ATTRIBUTE_VALUE,
        attributeValue))
{
    return false;
}

    break;
    }
    case HASH_ATTRIBUTE_PARAM:
    {

attributeData->param = attributeValue;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_BLEND_EQUATION, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__profile_GLES2__technique__pass__states__blend_equation()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__profile_GLES2__technique__pass__states__blend_equation();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__profile_GLES2__technique__pass__states__blend_equation( void* attributeData )
{
    profile_GLES2__technique__pass__states__blend_equation__AttributeData* typedAttributeData = static_cast<profile_GLES2__technique__pass__states__blend_equation__AttributeData*>(attributeData);

    typedAttributeData->~profile_GLES2__technique__pass__states__blend_equation__AttributeData();

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__profile_GLES2__technique__pass__states__blend_equation_separate( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__profile_GLES2__technique__pass__states__blend_equation_separate( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__profile_GLES2__technique__pass__states__blend_equation_separate( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__profile_GLES2__technique__pass__states__blend_equation_separate()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__profile_GLES2__technique__pass__states__blend_equation_separate();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__profile_GLES2__technique__pass__states__blend_equation_separate( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
const profile_GLES2__technique__pass__states__blend_equation_separate__rgb__AttributeData profile_GLES2__technique__pass__states__blend_equation_separate__rgb__AttributeData::DEFAULT = {ENUM__gl_blend_equation_enum__FUNC_ADD, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__profile_GLES2__technique__pass__states__blend_equation_separate__rgb( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__profile_GLES2__technique__pass__states__blend_equation_separate__rgb( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__profile_GLES2__technique__pass__states__blend_equation_separate__rgb( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

profile_GLES2__technique__pass__states__blend_equation_separate__rgb__AttributeData* attributeData = newData<profile_GLES2__technique__pass__states__blend_equation_separate__rgb__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_VALUE:
    {
bool failed;
attributeData->value = Utils::toEnum<ENUM__gl_blend_equation_enum, StringHash, ENUM__gl_blend_equation_enum__COUNT>(attributeValue, failed, ENUM__gl_blend_equation_enumMap, Utils::calculateStringHash);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_RGB,
        HASH_ATTRIBUTE_VALUE,
        attributeValue))
{
    return false;
}

    break;
    }
    case HASH_ATTRIBUTE_PARAM:
    {

attributeData->param = attributeValue;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_RGB, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__profile_GLES2__technique__pass__states__blend_equation_separate__rgb()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__profile_GLES2__technique__pass__states__blend_equation_separate__rgb();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__profile_GLES2__technique__pass__states__blend_equation_separate__rgb( void* attributeData )
{
    profile_GLES2__technique__pass__states__blend_equation_separate__rgb__AttributeData* typedAttributeData = static_cast<profile_GLES2__technique__pass__states__blend_equation_separate__rgb__AttributeData*>(attributeData);

    typedAttributeData->~profile_GLES2__technique__pass__states__blend_equation_separate__rgb__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const profile_GLES2__technique__pass__states__blend_equation_separate__alpha__AttributeData profile_GLES2__technique__pass__states__blend_equation_separate__alpha__AttributeData::DEFAULT = {ENUM__gl_blend_equation_enum__FUNC_ADD, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__profile_GLES2__technique__pass__states__blend_equation_separate__alpha( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__profile_GLES2__technique__pass__states__blend_equation_separate__alpha( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__profile_GLES2__technique__pass__states__blend_equation_separate__alpha( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

profile_GLES2__technique__pass__states__blend_equation_separate__alpha__AttributeData* attributeData = newData<profile_GLES2__technique__pass__states__blend_equation_separate__alpha__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_VALUE:
    {
bool failed;
attributeData->value = Utils::toEnum<ENUM__gl_blend_equation_enum, StringHash, ENUM__gl_blend_equation_enum__COUNT>(attributeValue, failed, ENUM__gl_blend_equation_enumMap, Utils::calculateStringHash);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_ALPHA,
        HASH_ATTRIBUTE_VALUE,
        attributeValue))
{
    return false;
}

    break;
    }
    case HASH_ATTRIBUTE_PARAM:
    {

attributeData->param = attributeValue;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_ALPHA, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__profile_GLES2__technique__pass__states__blend_equation_separate__alpha()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__profile_GLES2__technique__pass__states__blend_equation_separate__alpha();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__profile_GLES2__technique__pass__states__blend_equation_separate__alpha( void* attributeData )
{
    profile_GLES2__technique__pass__states__blend_equation_separate__alpha__AttributeData* typedAttributeData = static_cast<profile_GLES2__technique__pass__states__blend_equation_separate__alpha__AttributeData*>(attributeData);

    typedAttributeData->~profile_GLES2__technique__pass__states__blend_equation_separate__alpha__AttributeData();

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__profile_GLES2__technique__pass__states__blend_func( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__profile_GLES2__technique__pass__states__blend_func( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__profile_GLES2__technique__pass__states__blend_func( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__profile_GLES2__technique__pass__states__blend_func()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__profile_GLES2__technique__pass__states__blend_func();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__profile_GLES2__technique__pass__states__blend_func( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
const profile_GLES2__technique__pass__states__blend_func__src__AttributeData profile_GLES2__technique__pass__states__blend_func__src__AttributeData::DEFAULT = {ENUM__gl_blend_enum__ONE, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__profile_GLES2__technique__pass__states__blend_func__src( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__profile_GLES2__technique__pass__states__blend_func__src( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__profile_GLES2__technique__pass__states__blend_func__src( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

profile_GLES2__technique__pass__states__blend_func__src__AttributeData* attributeData = newData<profile_GLES2__technique__pass__states__blend_func__src__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_VALUE:
    {
bool failed;
attributeData->value = Utils::toEnum<ENUM__gl_blend_enum, StringHash, ENUM__gl_blend_enum__COUNT>(attributeValue, failed, ENUM__gl_blend_enumMap, Utils::calculateStringHash);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_SRC,
        HASH_ATTRIBUTE_VALUE,
        attributeValue))
{
    return false;
}

    break;
    }
    case HASH_ATTRIBUTE_PARAM:
    {

attributeData->param = attributeValue;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_SRC, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__profile_GLES2__technique__pass__states__blend_func__src()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__profile_GLES2__technique__pass__states__blend_func__src();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__profile_GLES2__technique__pass__states__blend_func__src( void* attributeData )
{
    profile_GLES2__technique__pass__states__blend_func__src__AttributeData* typedAttributeData = static_cast<profile_GLES2__technique__pass__states__blend_func__src__AttributeData*>(attributeData);

    typedAttributeData->~profile_GLES2__technique__pass__states__blend_func__src__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const profile_GLES2__technique__pass__states__blend_func__dest__AttributeData profile_GLES2__technique__pass__states__blend_func__dest__AttributeData::DEFAULT = {ENUM__gl_blend_enum__ZERO, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__profile_GLES2__technique__pass__states__blend_func__dest( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__profile_GLES2__technique__pass__states__blend_func__dest( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__profile_GLES2__technique__pass__states__blend_func__dest( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

profile_GLES2__technique__pass__states__blend_func__dest__AttributeData* attributeData = newData<profile_GLES2__technique__pass__states__blend_func__dest__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_VALUE:
    {
bool failed;
attributeData->value = Utils::toEnum<ENUM__gl_blend_enum, StringHash, ENUM__gl_blend_enum__COUNT>(attributeValue, failed, ENUM__gl_blend_enumMap, Utils::calculateStringHash);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_DEST,
        HASH_ATTRIBUTE_VALUE,
        attributeValue))
{
    return false;
}

    break;
    }
    case HASH_ATTRIBUTE_PARAM:
    {

attributeData->param = attributeValue;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_DEST, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__profile_GLES2__technique__pass__states__blend_func__dest()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__profile_GLES2__technique__pass__states__blend_func__dest();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__profile_GLES2__technique__pass__states__blend_func__dest( void* attributeData )
{
    profile_GLES2__technique__pass__states__blend_func__dest__AttributeData* typedAttributeData = static_cast<profile_GLES2__technique__pass__states__blend_func__dest__AttributeData*>(attributeData);

    typedAttributeData->~profile_GLES2__technique__pass__states__blend_func__dest__AttributeData();

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__profile_GLES2__technique__pass__states__blend_func_separate( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__profile_GLES2__technique__pass__states__blend_func_separate( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__profile_GLES2__technique__pass__states__blend_func_separate( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__profile_GLES2__technique__pass__states__blend_func_separate()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__profile_GLES2__technique__pass__states__blend_func_separate();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__profile_GLES2__technique__pass__states__blend_func_separate( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
const profile_GLES2__technique__pass__states__blend_func_separate__src_rgb__AttributeData profile_GLES2__technique__pass__states__blend_func_separate__src_rgb__AttributeData::DEFAULT = {ENUM__gl_blend_enum__ONE, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__profile_GLES2__technique__pass__states__blend_func_separate__src_rgb( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__profile_GLES2__technique__pass__states__blend_func_separate__src_rgb( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__profile_GLES2__technique__pass__states__blend_func_separate__src_rgb( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

profile_GLES2__technique__pass__states__blend_func_separate__src_rgb__AttributeData* attributeData = newData<profile_GLES2__technique__pass__states__blend_func_separate__src_rgb__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_VALUE:
    {
bool failed;
attributeData->value = Utils::toEnum<ENUM__gl_blend_enum, StringHash, ENUM__gl_blend_enum__COUNT>(attributeValue, failed, ENUM__gl_blend_enumMap, Utils::calculateStringHash);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_SRC_RGB,
        HASH_ATTRIBUTE_VALUE,
        attributeValue))
{
    return false;
}

    break;
    }
    case HASH_ATTRIBUTE_PARAM:
    {

attributeData->param = attributeValue;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_SRC_RGB, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__profile_GLES2__technique__pass__states__blend_func_separate__src_rgb()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__profile_GLES2__technique__pass__states__blend_func_separate__src_rgb();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__profile_GLES2__technique__pass__states__blend_func_separate__src_rgb( void* attributeData )
{
    profile_GLES2__technique__pass__states__blend_func_separate__src_rgb__AttributeData* typedAttributeData = static_cast<profile_GLES2__technique__pass__states__blend_func_separate__src_rgb__AttributeData*>(attributeData);

    typedAttributeData->~profile_GLES2__technique__pass__states__blend_func_separate__src_rgb__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const profile_GLES2__technique__pass__states__blend_func_separate__dest_rgb__AttributeData profile_GLES2__technique__pass__states__blend_func_separate__dest_rgb__AttributeData::DEFAULT = {ENUM__gl_blend_enum__ZERO, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__profile_GLES2__technique__pass__states__blend_func_separate__dest_rgb( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__profile_GLES2__technique__pass__states__blend_func_separate__dest_rgb( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__profile_GLES2__technique__pass__states__blend_func_separate__dest_rgb( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

profile_GLES2__technique__pass__states__blend_func_separate__dest_rgb__AttributeData* attributeData = newData<profile_GLES2__technique__pass__states__blend_func_separate__dest_rgb__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_VALUE:
    {
bool failed;
attributeData->value = Utils::toEnum<ENUM__gl_blend_enum, StringHash, ENUM__gl_blend_enum__COUNT>(attributeValue, failed, ENUM__gl_blend_enumMap, Utils::calculateStringHash);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_DEST_RGB,
        HASH_ATTRIBUTE_VALUE,
        attributeValue))
{
    return false;
}

    break;
    }
    case HASH_ATTRIBUTE_PARAM:
    {

attributeData->param = attributeValue;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_DEST_RGB, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__profile_GLES2__technique__pass__states__blend_func_separate__dest_rgb()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__profile_GLES2__technique__pass__states__blend_func_separate__dest_rgb();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__profile_GLES2__technique__pass__states__blend_func_separate__dest_rgb( void* attributeData )
{
    profile_GLES2__technique__pass__states__blend_func_separate__dest_rgb__AttributeData* typedAttributeData = static_cast<profile_GLES2__technique__pass__states__blend_func_separate__dest_rgb__AttributeData*>(attributeData);

    typedAttributeData->~profile_GLES2__technique__pass__states__blend_func_separate__dest_rgb__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const profile_GLES2__technique__pass__states__blend_func_separate__src_alpha__AttributeData profile_GLES2__technique__pass__states__blend_func_separate__src_alpha__AttributeData::DEFAULT = {ENUM__gl_blend_enum__ONE, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__profile_GLES2__technique__pass__states__blend_func_separate__src_alpha( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__profile_GLES2__technique__pass__states__blend_func_separate__src_alpha( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__profile_GLES2__technique__pass__states__blend_func_separate__src_alpha( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

profile_GLES2__technique__pass__states__blend_func_separate__src_alpha__AttributeData* attributeData = newData<profile_GLES2__technique__pass__states__blend_func_separate__src_alpha__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_VALUE:
    {
bool failed;
attributeData->value = Utils::toEnum<ENUM__gl_blend_enum, StringHash, ENUM__gl_blend_enum__COUNT>(attributeValue, failed, ENUM__gl_blend_enumMap, Utils::calculateStringHash);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_SRC_ALPHA,
        HASH_ATTRIBUTE_VALUE,
        attributeValue))
{
    return false;
}

    break;
    }
    case HASH_ATTRIBUTE_PARAM:
    {

attributeData->param = attributeValue;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_SRC_ALPHA, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__profile_GLES2__technique__pass__states__blend_func_separate__src_alpha()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__profile_GLES2__technique__pass__states__blend_func_separate__src_alpha();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__profile_GLES2__technique__pass__states__blend_func_separate__src_alpha( void* attributeData )
{
    profile_GLES2__technique__pass__states__blend_func_separate__src_alpha__AttributeData* typedAttributeData = static_cast<profile_GLES2__technique__pass__states__blend_func_separate__src_alpha__AttributeData*>(attributeData);

    typedAttributeData->~profile_GLES2__technique__pass__states__blend_func_separate__src_alpha__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const profile_GLES2__technique__pass__states__blend_func_separate__dest_alpha__AttributeData profile_GLES2__technique__pass__states__blend_func_separate__dest_alpha__AttributeData::DEFAULT = {ENUM__gl_blend_enum__ZERO, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__profile_GLES2__technique__pass__states__blend_func_separate__dest_alpha( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__profile_GLES2__technique__pass__states__blend_func_separate__dest_alpha( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__profile_GLES2__technique__pass__states__blend_func_separate__dest_alpha( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

profile_GLES2__technique__pass__states__blend_func_separate__dest_alpha__AttributeData* attributeData = newData<profile_GLES2__technique__pass__states__blend_func_separate__dest_alpha__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_VALUE:
    {
bool failed;
attributeData->value = Utils::toEnum<ENUM__gl_blend_enum, StringHash, ENUM__gl_blend_enum__COUNT>(attributeValue, failed, ENUM__gl_blend_enumMap, Utils::calculateStringHash);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_DEST_ALPHA,
        HASH_ATTRIBUTE_VALUE,
        attributeValue))
{
    return false;
}

    break;
    }
    case HASH_ATTRIBUTE_PARAM:
    {

attributeData->param = attributeValue;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_DEST_ALPHA, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__profile_GLES2__technique__pass__states__blend_func_separate__dest_alpha()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__profile_GLES2__technique__pass__states__blend_func_separate__dest_alpha();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__profile_GLES2__technique__pass__states__blend_func_separate__dest_alpha( void* attributeData )
{
    profile_GLES2__technique__pass__states__blend_func_separate__dest_alpha__AttributeData* typedAttributeData = static_cast<profile_GLES2__technique__pass__states__blend_func_separate__dest_alpha__AttributeData*>(attributeData);

    typedAttributeData->~profile_GLES2__technique__pass__states__blend_func_separate__dest_alpha__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const profile_GLES2__technique__pass__states__color_mask__AttributeData profile_GLES2__technique__pass__states__color_mask__AttributeData::DEFAULT = {0, GeneratedSaxParser::XSList<bool>(), 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__profile_GLES2__technique__pass__states__color_mask( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__profile_GLES2__technique__pass__states__color_mask( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__profile_GLES2__technique__pass__states__color_mask( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

profile_GLES2__technique__pass__states__color_mask__AttributeData* attributeData = newData<profile_GLES2__technique__pass__states__color_mask__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_VALUE:
    {
bool failed;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
failed = !characterData2BoolList(attributeValue, attributeData->value, 0, HASH_ELEMENT_COLOR_MASK, HASH_ATTRIBUTE_VALUE);
    }
    else
    {
failed = !characterData2BoolList(attributeValue, attributeData->value);
    }
#else
    {
failed = !characterData2BoolList(attributeValue, attributeData->value);
    } // validation
#endif
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_COLOR_MASK,
        HASH_ATTRIBUTE_VALUE,
        attributeValue))
{
    return false;
}
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__bool4_type(attributeData->value.data, attributeData->value.size);
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_COLOR_MASK,
            HASH_ATTRIBUTE_VALUE,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

if ( !failed )
    attributeData->present_attributes |= profile_GLES2__technique__pass__states__color_mask__AttributeData::ATTRIBUTE_VALUE_PRESENT;

    break;
    }
    case HASH_ATTRIBUTE_PARAM:
    {

attributeData->param = attributeValue;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_COLOR_MASK, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ((attributeData->present_attributes & profile_GLES2__technique__pass__states__color_mask__AttributeData::ATTRIBUTE_VALUE_PRESENT) == 0)
{
    bool failed;
    failed = !characterData2BoolList("true true true true", attributeData->value);
    if ( !failed )
    attributeData->present_attributes |= profile_GLES2__technique__pass__states__color_mask__AttributeData::ATTRIBUTE_VALUE_PRESENT;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__profile_GLES2__technique__pass__states__color_mask()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__profile_GLES2__technique__pass__states__color_mask();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__profile_GLES2__technique__pass__states__color_mask( void* attributeData )
{
    profile_GLES2__technique__pass__states__color_mask__AttributeData* typedAttributeData = static_cast<profile_GLES2__technique__pass__states__color_mask__AttributeData*>(attributeData);
    if (typedAttributeData->value.data)
    {
        mStackMemoryManager.deleteObject();
    }


    typedAttributeData->~profile_GLES2__technique__pass__states__color_mask__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const profile_GLES2__technique__pass__states__cull_face__AttributeData profile_GLES2__technique__pass__states__cull_face__AttributeData::DEFAULT = {ENUM__gl_face_enum__BACK, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__profile_GLES2__technique__pass__states__cull_face( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__profile_GLES2__technique__pass__states__cull_face( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__profile_GLES2__technique__pass__states__cull_face( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

profile_GLES2__technique__pass__states__cull_face__AttributeData* attributeData = newData<profile_GLES2__technique__pass__states__cull_face__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_VALUE:
    {
bool failed;
attributeData->value = Utils::toEnum<ENUM__gl_face_enum, StringHash, ENUM__gl_face_enum__COUNT>(attributeValue, failed, ENUM__gl_face_enumMap, Utils::calculateStringHash);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_CULL_FACE,
        HASH_ATTRIBUTE_VALUE,
        attributeValue))
{
    return false;
}

    break;
    }
    case HASH_ATTRIBUTE_PARAM:
    {

attributeData->param = attributeValue;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_CULL_FACE, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__profile_GLES2__technique__pass__states__cull_face()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__profile_GLES2__technique__pass__states__cull_face();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__profile_GLES2__technique__pass__states__cull_face( void* attributeData )
{
    profile_GLES2__technique__pass__states__cull_face__AttributeData* typedAttributeData = static_cast<profile_GLES2__technique__pass__states__cull_face__AttributeData*>(attributeData);

    typedAttributeData->~profile_GLES2__technique__pass__states__cull_face__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const profile_GLES2__technique__pass__states__depth_func__AttributeData profile_GLES2__technique__pass__states__depth_func__AttributeData::DEFAULT = {ENUM__gl_func_enum__ALWAYS, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__profile_GLES2__technique__pass__states__depth_func( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__profile_GLES2__technique__pass__states__depth_func( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__profile_GLES2__technique__pass__states__depth_func( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

profile_GLES2__technique__pass__states__depth_func__AttributeData* attributeData = newData<profile_GLES2__technique__pass__states__depth_func__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_VALUE:
    {
bool failed;
attributeData->value = Utils::toEnum<ENUM__gl_func_enum, StringHash, ENUM__gl_func_enum__COUNT>(attributeValue, failed, ENUM__gl_func_enumMap, Utils::calculateStringHash);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_DEPTH_FUNC,
        HASH_ATTRIBUTE_VALUE,
        attributeValue))
{
    return false;
}

    break;
    }
    case HASH_ATTRIBUTE_PARAM:
    {

attributeData->param = attributeValue;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_DEPTH_FUNC, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__profile_GLES2__technique__pass__states__depth_func()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__profile_GLES2__technique__pass__states__depth_func();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__profile_GLES2__technique__pass__states__depth_func( void* attributeData )
{
    profile_GLES2__technique__pass__states__depth_func__AttributeData* typedAttributeData = static_cast<profile_GLES2__technique__pass__states__depth_func__AttributeData*>(attributeData);

    typedAttributeData->~profile_GLES2__technique__pass__states__depth_func__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const profile_GLES2__technique__pass__states__depth_mask__AttributeData profile_GLES2__technique__pass__states__depth_mask__AttributeData::DEFAULT = {true, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__profile_GLES2__technique__pass__states__depth_mask( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__profile_GLES2__technique__pass__states__depth_mask( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__profile_GLES2__technique__pass__states__depth_mask( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

profile_GLES2__technique__pass__states__depth_mask__AttributeData* attributeData = newData<profile_GLES2__technique__pass__states__depth_mask__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_VALUE:
    {
bool failed;
attributeData->value = GeneratedSaxParser::Utils::toBool(attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_DEPTH_MASK,
        HASH_ATTRIBUTE_VALUE,
        attributeValue))
{
    return false;
}

    break;
    }
    case HASH_ATTRIBUTE_PARAM:
    {

attributeData->param = attributeValue;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_DEPTH_MASK, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__profile_GLES2__technique__pass__states__depth_mask()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__profile_GLES2__technique__pass__states__depth_mask();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__profile_GLES2__technique__pass__states__depth_mask( void* attributeData )
{
    profile_GLES2__technique__pass__states__depth_mask__AttributeData* typedAttributeData = static_cast<profile_GLES2__technique__pass__states__depth_mask__AttributeData*>(attributeData);

    typedAttributeData->~profile_GLES2__technique__pass__states__depth_mask__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const profile_GLES2__technique__pass__states__depth_range__AttributeData profile_GLES2__technique__pass__states__depth_range__AttributeData::DEFAULT = {0, GeneratedSaxParser::XSList<float>(), 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__profile_GLES2__technique__pass__states__depth_range( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__profile_GLES2__technique__pass__states__depth_range( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__profile_GLES2__technique__pass__states__depth_range( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

profile_GLES2__technique__pass__states__depth_range__AttributeData* attributeData = newData<profile_GLES2__technique__pass__states__depth_range__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_VALUE:
    {
bool failed;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
failed = !characterData2FloatList(attributeValue, attributeData->value, 0, HASH_ELEMENT_DEPTH_RANGE, HASH_ATTRIBUTE_VALUE);
    }
    else
    {
failed = !characterData2FloatList(attributeValue, attributeData->value);
    }
#else
    {
failed = !characterData2FloatList(attributeValue, attributeData->value);
    } // validation
#endif
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_DEPTH_RANGE,
        HASH_ATTRIBUTE_VALUE,
        attributeValue))
{
    return false;
}
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__float2_type(attributeData->value.data, attributeData->value.size);
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_DEPTH_RANGE,
            HASH_ATTRIBUTE_VALUE,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

if ( !failed )
    attributeData->present_attributes |= profile_GLES2__technique__pass__states__depth_range__AttributeData::ATTRIBUTE_VALUE_PRESENT;

    break;
    }
    case HASH_ATTRIBUTE_PARAM:
    {

attributeData->param = attributeValue;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_DEPTH_RANGE, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ((attributeData->present_attributes & profile_GLES2__technique__pass__states__depth_range__AttributeData::ATTRIBUTE_VALUE_PRESENT) == 0)
{
    bool failed;
    failed = !characterData2FloatList("0.0E1 1.0E0", attributeData->value);
    if ( !failed )
    attributeData->present_attributes |= profile_GLES2__technique__pass__states__depth_range__AttributeData::ATTRIBUTE_VALUE_PRESENT;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__profile_GLES2__technique__pass__states__depth_range()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__profile_GLES2__technique__pass__states__depth_range();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__profile_GLES2__technique__pass__states__depth_range( void* attributeData )
{
    profile_GLES2__technique__pass__states__depth_range__AttributeData* typedAttributeData = static_cast<profile_GLES2__technique__pass__states__depth_range__AttributeData*>(attributeData);
    if (typedAttributeData->value.data)
    {
        mStackMemoryManager.deleteObject();
    }


    typedAttributeData->~profile_GLES2__technique__pass__states__depth_range__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const profile_GLES2__technique__pass__states__front_face__AttributeData profile_GLES2__technique__pass__states__front_face__AttributeData::DEFAULT = {ENUM__gl_front_face_enum__CCW, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__profile_GLES2__technique__pass__states__front_face( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__profile_GLES2__technique__pass__states__front_face( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__profile_GLES2__technique__pass__states__front_face( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

profile_GLES2__technique__pass__states__front_face__AttributeData* attributeData = newData<profile_GLES2__technique__pass__states__front_face__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_VALUE:
    {
bool failed;
attributeData->value = Utils::toEnum<ENUM__gl_front_face_enum, StringHash, ENUM__gl_front_face_enum__COUNT>(attributeValue, failed, ENUM__gl_front_face_enumMap, Utils::calculateStringHash);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_FRONT_FACE,
        HASH_ATTRIBUTE_VALUE,
        attributeValue))
{
    return false;
}

    break;
    }
    case HASH_ATTRIBUTE_PARAM:
    {

attributeData->param = attributeValue;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_FRONT_FACE, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__profile_GLES2__technique__pass__states__front_face()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__profile_GLES2__technique__pass__states__front_face();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__profile_GLES2__technique__pass__states__front_face( void* attributeData )
{
    profile_GLES2__technique__pass__states__front_face__AttributeData* typedAttributeData = static_cast<profile_GLES2__technique__pass__states__front_face__AttributeData*>(attributeData);

    typedAttributeData->~profile_GLES2__technique__pass__states__front_face__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const profile_GLES2__technique__pass__states__line_width__AttributeData profile_GLES2__technique__pass__states__line_width__AttributeData::DEFAULT = {1.0E0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__profile_GLES2__technique__pass__states__line_width( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__profile_GLES2__technique__pass__states__line_width( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__profile_GLES2__technique__pass__states__line_width( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

profile_GLES2__technique__pass__states__line_width__AttributeData* attributeData = newData<profile_GLES2__technique__pass__states__line_width__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_VALUE:
    {
bool failed;
attributeData->value = GeneratedSaxParser::Utils::toFloat(attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_LINE_WIDTH,
        HASH_ATTRIBUTE_VALUE,
        attributeValue))
{
    return false;
}

    break;
    }
    case HASH_ATTRIBUTE_PARAM:
    {

attributeData->param = attributeValue;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_LINE_WIDTH, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__profile_GLES2__technique__pass__states__line_width()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__profile_GLES2__technique__pass__states__line_width();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__profile_GLES2__technique__pass__states__line_width( void* attributeData )
{
    profile_GLES2__technique__pass__states__line_width__AttributeData* typedAttributeData = static_cast<profile_GLES2__technique__pass__states__line_width__AttributeData*>(attributeData);

    typedAttributeData->~profile_GLES2__technique__pass__states__line_width__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const profile_GLES2__technique__pass__states__polygon_offset__AttributeData profile_GLES2__technique__pass__states__polygon_offset__AttributeData::DEFAULT = {0, GeneratedSaxParser::XSList<float>(), 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__profile_GLES2__technique__pass__states__polygon_offset( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__profile_GLES2__technique__pass__states__polygon_offset( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__profile_GLES2__technique__pass__states__polygon_offset( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

profile_GLES2__technique__pass__states__polygon_offset__AttributeData* attributeData = newData<profile_GLES2__technique__pass__states__polygon_offset__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_VALUE:
    {
bool failed;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
failed = !characterData2FloatList(attributeValue, attributeData->value, 0, HASH_ELEMENT_POLYGON_OFFSET, HASH_ATTRIBUTE_VALUE);
    }
    else
    {
failed = !characterData2FloatList(attributeValue, attributeData->value);
    }
#else
    {
failed = !characterData2FloatList(attributeValue, attributeData->value);
    } // validation
#endif
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_POLYGON_OFFSET,
        HASH_ATTRIBUTE_VALUE,
        attributeValue))
{
    return false;
}
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__float2_type(attributeData->value.data, attributeData->value.size);
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_POLYGON_OFFSET,
            HASH_ATTRIBUTE_VALUE,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

if ( !failed )
    attributeData->present_attributes |= profile_GLES2__technique__pass__states__polygon_offset__AttributeData::ATTRIBUTE_VALUE_PRESENT;

    break;
    }
    case HASH_ATTRIBUTE_PARAM:
    {

attributeData->param = attributeValue;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_POLYGON_OFFSET, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ((attributeData->present_attributes & profile_GLES2__technique__pass__states__polygon_offset__AttributeData::ATTRIBUTE_VALUE_PRESENT) == 0)
{
    bool failed;
    failed = !characterData2FloatList("0.0E1 0.0E1", attributeData->value);
    if ( !failed )
    attributeData->present_attributes |= profile_GLES2__technique__pass__states__polygon_offset__AttributeData::ATTRIBUTE_VALUE_PRESENT;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__profile_GLES2__technique__pass__states__polygon_offset()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__profile_GLES2__technique__pass__states__polygon_offset();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__profile_GLES2__technique__pass__states__polygon_offset( void* attributeData )
{
    profile_GLES2__technique__pass__states__polygon_offset__AttributeData* typedAttributeData = static_cast<profile_GLES2__technique__pass__states__polygon_offset__AttributeData*>(attributeData);
    if (typedAttributeData->value.data)
    {
        mStackMemoryManager.deleteObject();
    }


    typedAttributeData->~profile_GLES2__technique__pass__states__polygon_offset__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const profile_GLES2__technique__pass__states__point_size__AttributeData profile_GLES2__technique__pass__states__point_size__AttributeData::DEFAULT = {1.0E0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__profile_GLES2__technique__pass__states__point_size( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__profile_GLES2__technique__pass__states__point_size( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__profile_GLES2__technique__pass__states__point_size( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

profile_GLES2__technique__pass__states__point_size__AttributeData* attributeData = newData<profile_GLES2__technique__pass__states__point_size__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_VALUE:
    {
bool failed;
attributeData->value = GeneratedSaxParser::Utils::toFloat(attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_POINT_SIZE,
        HASH_ATTRIBUTE_VALUE,
        attributeValue))
{
    return false;
}

    break;
    }
    case HASH_ATTRIBUTE_PARAM:
    {

attributeData->param = attributeValue;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_POINT_SIZE, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__profile_GLES2__technique__pass__states__point_size()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__profile_GLES2__technique__pass__states__point_size();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__profile_GLES2__technique__pass__states__point_size( void* attributeData )
{
    profile_GLES2__technique__pass__states__point_size__AttributeData* typedAttributeData = static_cast<profile_GLES2__technique__pass__states__point_size__AttributeData*>(attributeData);

    typedAttributeData->~profile_GLES2__technique__pass__states__point_size__AttributeData();

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__sample_coverage( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__sample_coverage( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__sample_coverage( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__sample_coverage()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__sample_coverage();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__sample_coverage( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
const sample_coverage__value__AttributeData sample_coverage__value__AttributeData::DEFAULT = {0, 0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__sample_coverage__value( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__sample_coverage__value( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__sample_coverage__value( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

sample_coverage__value__AttributeData* attributeData = newData<sample_coverage__value__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_VALUE:
    {
bool failed;
attributeData->value = GeneratedSaxParser::Utils::toFloat(attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_VALUE,
        HASH_ATTRIBUTE_VALUE,
        attributeValue))
{
    return false;
}
if ( !failed )
    attributeData->present_attributes |= sample_coverage__value__AttributeData::ATTRIBUTE_VALUE_PRESENT;

    break;
    }
    case HASH_ATTRIBUTE_PARAM:
    {

attributeData->param = attributeValue;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_VALUE, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__sample_coverage__value()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__sample_coverage__value();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__sample_coverage__value( void* attributeData )
{
    sample_coverage__value__AttributeData* typedAttributeData = static_cast<sample_coverage__value__AttributeData*>(attributeData);

    typedAttributeData->~sample_coverage__value__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const invert__AttributeData invert__AttributeData::DEFAULT = {0, 0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__invert( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__invert( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__invert( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

invert__AttributeData* attributeData = newData<invert__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_VALUE:
    {
bool failed;
attributeData->value = GeneratedSaxParser::Utils::toBool(attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_INVERT,
        HASH_ATTRIBUTE_VALUE,
        attributeValue))
{
    return false;
}
if ( !failed )
    attributeData->present_attributes |= invert__AttributeData::ATTRIBUTE_VALUE_PRESENT;

    break;
    }
    case HASH_ATTRIBUTE_PARAM:
    {

attributeData->param = attributeValue;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_INVERT, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__invert()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__invert();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__invert( void* attributeData )
{
    invert__AttributeData* typedAttributeData = static_cast<invert__AttributeData*>(attributeData);

    typedAttributeData->~invert__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const profile_GLES2__technique__pass__states__scissor__AttributeData profile_GLES2__technique__pass__states__scissor__AttributeData::DEFAULT = {0, GeneratedSaxParser::XSList<sint64>(), 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__profile_GLES2__technique__pass__states__scissor( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__profile_GLES2__technique__pass__states__scissor( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__profile_GLES2__technique__pass__states__scissor( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

profile_GLES2__technique__pass__states__scissor__AttributeData* attributeData = newData<profile_GLES2__technique__pass__states__scissor__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_VALUE:
    {
bool failed;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
failed = !characterData2Sint64List(attributeValue, attributeData->value, 0, HASH_ELEMENT_SCISSOR, HASH_ATTRIBUTE_VALUE);
    }
    else
    {
failed = !characterData2Sint64List(attributeValue, attributeData->value);
    }
#else
    {
failed = !characterData2Sint64List(attributeValue, attributeData->value);
    } // validation
#endif
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_SCISSOR,
        HASH_ATTRIBUTE_VALUE,
        attributeValue))
{
    return false;
}
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__int4_type(attributeData->value.data, attributeData->value.size);
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_SCISSOR,
            HASH_ATTRIBUTE_VALUE,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

if ( !failed )
    attributeData->present_attributes |= profile_GLES2__technique__pass__states__scissor__AttributeData::ATTRIBUTE_VALUE_PRESENT;

    break;
    }
    case HASH_ATTRIBUTE_PARAM:
    {

attributeData->param = attributeValue;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_SCISSOR, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ((attributeData->present_attributes & profile_GLES2__technique__pass__states__scissor__AttributeData::ATTRIBUTE_VALUE_PRESENT) == 0)
{
    attributeData->value = GeneratedSaxParser::XSList<sint64>();
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__profile_GLES2__technique__pass__states__scissor()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__profile_GLES2__technique__pass__states__scissor();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__profile_GLES2__technique__pass__states__scissor( void* attributeData )
{
    profile_GLES2__technique__pass__states__scissor__AttributeData* typedAttributeData = static_cast<profile_GLES2__technique__pass__states__scissor__AttributeData*>(attributeData);
    if (typedAttributeData->value.data)
    {
        mStackMemoryManager.deleteObject();
    }


    typedAttributeData->~profile_GLES2__technique__pass__states__scissor__AttributeData();

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__profile_GLES2__technique__pass__states__stencil_func( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__profile_GLES2__technique__pass__states__stencil_func( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__profile_GLES2__technique__pass__states__stencil_func( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__profile_GLES2__technique__pass__states__stencil_func()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__profile_GLES2__technique__pass__states__stencil_func();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__profile_GLES2__technique__pass__states__stencil_func( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
const profile_GLES2__technique__pass__states__stencil_func__func__AttributeData profile_GLES2__technique__pass__states__stencil_func__func__AttributeData::DEFAULT = {ENUM__gl_func_enum__ALWAYS, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__profile_GLES2__technique__pass__states__stencil_func__func( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__profile_GLES2__technique__pass__states__stencil_func__func( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__profile_GLES2__technique__pass__states__stencil_func__func( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

profile_GLES2__technique__pass__states__stencil_func__func__AttributeData* attributeData = newData<profile_GLES2__technique__pass__states__stencil_func__func__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_VALUE:
    {
bool failed;
attributeData->value = Utils::toEnum<ENUM__gl_func_enum, StringHash, ENUM__gl_func_enum__COUNT>(attributeValue, failed, ENUM__gl_func_enumMap, Utils::calculateStringHash);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_FUNC,
        HASH_ATTRIBUTE_VALUE,
        attributeValue))
{
    return false;
}

    break;
    }
    case HASH_ATTRIBUTE_PARAM:
    {

attributeData->param = attributeValue;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_FUNC, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__profile_GLES2__technique__pass__states__stencil_func__func()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__profile_GLES2__technique__pass__states__stencil_func__func();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__profile_GLES2__technique__pass__states__stencil_func__func( void* attributeData )
{
    profile_GLES2__technique__pass__states__stencil_func__func__AttributeData* typedAttributeData = static_cast<profile_GLES2__technique__pass__states__stencil_func__func__AttributeData*>(attributeData);

    typedAttributeData->~profile_GLES2__technique__pass__states__stencil_func__func__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const profile_GLES2__technique__pass__states__stencil_func__ref__AttributeData profile_GLES2__technique__pass__states__stencil_func__ref__AttributeData::DEFAULT = {0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__profile_GLES2__technique__pass__states__stencil_func__ref( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__profile_GLES2__technique__pass__states__stencil_func__ref( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__profile_GLES2__technique__pass__states__stencil_func__ref( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

profile_GLES2__technique__pass__states__stencil_func__ref__AttributeData* attributeData = newData<profile_GLES2__technique__pass__states__stencil_func__ref__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_VALUE:
    {
bool failed;
attributeData->value = GeneratedSaxParser::Utils::toUint8(attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_REF,
        HASH_ATTRIBUTE_VALUE,
        attributeValue))
{
    return false;
}

    break;
    }
    case HASH_ATTRIBUTE_PARAM:
    {

attributeData->param = attributeValue;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_REF, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__profile_GLES2__technique__pass__states__stencil_func__ref()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__profile_GLES2__technique__pass__states__stencil_func__ref();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__profile_GLES2__technique__pass__states__stencil_func__ref( void* attributeData )
{
    profile_GLES2__technique__pass__states__stencil_func__ref__AttributeData* typedAttributeData = static_cast<profile_GLES2__technique__pass__states__stencil_func__ref__AttributeData*>(attributeData);

    typedAttributeData->~profile_GLES2__technique__pass__states__stencil_func__ref__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const profile_GLES2__technique__pass__states__stencil_func__mask__AttributeData profile_GLES2__technique__pass__states__stencil_func__mask__AttributeData::DEFAULT = {255, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__profile_GLES2__technique__pass__states__stencil_func__mask( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__profile_GLES2__technique__pass__states__stencil_func__mask( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__profile_GLES2__technique__pass__states__stencil_func__mask( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

profile_GLES2__technique__pass__states__stencil_func__mask__AttributeData* attributeData = newData<profile_GLES2__technique__pass__states__stencil_func__mask__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_VALUE:
    {
bool failed;
attributeData->value = GeneratedSaxParser::Utils::toUint8(attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_MASK,
        HASH_ATTRIBUTE_VALUE,
        attributeValue))
{
    return false;
}

    break;
    }
    case HASH_ATTRIBUTE_PARAM:
    {

attributeData->param = attributeValue;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_MASK, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__profile_GLES2__technique__pass__states__stencil_func__mask()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__profile_GLES2__technique__pass__states__stencil_func__mask();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__profile_GLES2__technique__pass__states__stencil_func__mask( void* attributeData )
{
    profile_GLES2__technique__pass__states__stencil_func__mask__AttributeData* typedAttributeData = static_cast<profile_GLES2__technique__pass__states__stencil_func__mask__AttributeData*>(attributeData);

    typedAttributeData->~profile_GLES2__technique__pass__states__stencil_func__mask__AttributeData();

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__profile_GLES2__technique__pass__states__stencil_func_separate( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__profile_GLES2__technique__pass__states__stencil_func_separate( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__profile_GLES2__technique__pass__states__stencil_func_separate( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__profile_GLES2__technique__pass__states__stencil_func_separate()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__profile_GLES2__technique__pass__states__stencil_func_separate();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__profile_GLES2__technique__pass__states__stencil_func_separate( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
const profile_GLES2__technique__pass__states__stencil_func_separate__front__AttributeData profile_GLES2__technique__pass__states__stencil_func_separate__front__AttributeData::DEFAULT = {ENUM__gl_func_enum__ALWAYS, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__profile_GLES2__technique__pass__states__stencil_func_separate__front( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__profile_GLES2__technique__pass__states__stencil_func_separate__front( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__profile_GLES2__technique__pass__states__stencil_func_separate__front( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

profile_GLES2__technique__pass__states__stencil_func_separate__front__AttributeData* attributeData = newData<profile_GLES2__technique__pass__states__stencil_func_separate__front__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_VALUE:
    {
bool failed;
attributeData->value = Utils::toEnum<ENUM__gl_func_enum, StringHash, ENUM__gl_func_enum__COUNT>(attributeValue, failed, ENUM__gl_func_enumMap, Utils::calculateStringHash);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_FRONT,
        HASH_ATTRIBUTE_VALUE,
        attributeValue))
{
    return false;
}

    break;
    }
    case HASH_ATTRIBUTE_PARAM:
    {

attributeData->param = attributeValue;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_FRONT, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__profile_GLES2__technique__pass__states__stencil_func_separate__front()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__profile_GLES2__technique__pass__states__stencil_func_separate__front();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__profile_GLES2__technique__pass__states__stencil_func_separate__front( void* attributeData )
{
    profile_GLES2__technique__pass__states__stencil_func_separate__front__AttributeData* typedAttributeData = static_cast<profile_GLES2__technique__pass__states__stencil_func_separate__front__AttributeData*>(attributeData);

    typedAttributeData->~profile_GLES2__technique__pass__states__stencil_func_separate__front__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const profile_GLES2__technique__pass__states__stencil_func_separate__back__AttributeData profile_GLES2__technique__pass__states__stencil_func_separate__back__AttributeData::DEFAULT = {ENUM__gl_func_enum__ALWAYS, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__profile_GLES2__technique__pass__states__stencil_func_separate__back( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__profile_GLES2__technique__pass__states__stencil_func_separate__back( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__profile_GLES2__technique__pass__states__stencil_func_separate__back( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

profile_GLES2__technique__pass__states__stencil_func_separate__back__AttributeData* attributeData = newData<profile_GLES2__technique__pass__states__stencil_func_separate__back__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_VALUE:
    {
bool failed;
attributeData->value = Utils::toEnum<ENUM__gl_func_enum, StringHash, ENUM__gl_func_enum__COUNT>(attributeValue, failed, ENUM__gl_func_enumMap, Utils::calculateStringHash);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_BACK,
        HASH_ATTRIBUTE_VALUE,
        attributeValue))
{
    return false;
}

    break;
    }
    case HASH_ATTRIBUTE_PARAM:
    {

attributeData->param = attributeValue;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_BACK, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__profile_GLES2__technique__pass__states__stencil_func_separate__back()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__profile_GLES2__technique__pass__states__stencil_func_separate__back();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__profile_GLES2__technique__pass__states__stencil_func_separate__back( void* attributeData )
{
    profile_GLES2__technique__pass__states__stencil_func_separate__back__AttributeData* typedAttributeData = static_cast<profile_GLES2__technique__pass__states__stencil_func_separate__back__AttributeData*>(attributeData);

    typedAttributeData->~profile_GLES2__technique__pass__states__stencil_func_separate__back__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const profile_GLES2__technique__pass__states__stencil_func_separate__ref__AttributeData profile_GLES2__technique__pass__states__stencil_func_separate__ref__AttributeData::DEFAULT = {0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__profile_GLES2__technique__pass__states__stencil_func_separate__ref( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__profile_GLES2__technique__pass__states__stencil_func_separate__ref( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__profile_GLES2__technique__pass__states__stencil_func_separate__ref( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

profile_GLES2__technique__pass__states__stencil_func_separate__ref__AttributeData* attributeData = newData<profile_GLES2__technique__pass__states__stencil_func_separate__ref__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_VALUE:
    {
bool failed;
attributeData->value = GeneratedSaxParser::Utils::toUint8(attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_REF,
        HASH_ATTRIBUTE_VALUE,
        attributeValue))
{
    return false;
}

    break;
    }
    case HASH_ATTRIBUTE_PARAM:
    {

attributeData->param = attributeValue;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_REF, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__profile_GLES2__technique__pass__states__stencil_func_separate__ref()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__profile_GLES2__technique__pass__states__stencil_func_separate__ref();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__profile_GLES2__technique__pass__states__stencil_func_separate__ref( void* attributeData )
{
    profile_GLES2__technique__pass__states__stencil_func_separate__ref__AttributeData* typedAttributeData = static_cast<profile_GLES2__technique__pass__states__stencil_func_separate__ref__AttributeData*>(attributeData);

    typedAttributeData->~profile_GLES2__technique__pass__states__stencil_func_separate__ref__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const profile_GLES2__technique__pass__states__stencil_func_separate__mask__AttributeData profile_GLES2__technique__pass__states__stencil_func_separate__mask__AttributeData::DEFAULT = {255, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__profile_GLES2__technique__pass__states__stencil_func_separate__mask( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__profile_GLES2__technique__pass__states__stencil_func_separate__mask( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__profile_GLES2__technique__pass__states__stencil_func_separate__mask( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

profile_GLES2__technique__pass__states__stencil_func_separate__mask__AttributeData* attributeData = newData<profile_GLES2__technique__pass__states__stencil_func_separate__mask__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_VALUE:
    {
bool failed;
attributeData->value = GeneratedSaxParser::Utils::toUint8(attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_MASK,
        HASH_ATTRIBUTE_VALUE,
        attributeValue))
{
    return false;
}

    break;
    }
    case HASH_ATTRIBUTE_PARAM:
    {

attributeData->param = attributeValue;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_MASK, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__profile_GLES2__technique__pass__states__stencil_func_separate__mask()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__profile_GLES2__technique__pass__states__stencil_func_separate__mask();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__profile_GLES2__technique__pass__states__stencil_func_separate__mask( void* attributeData )
{
    profile_GLES2__technique__pass__states__stencil_func_separate__mask__AttributeData* typedAttributeData = static_cast<profile_GLES2__technique__pass__states__stencil_func_separate__mask__AttributeData*>(attributeData);

    typedAttributeData->~profile_GLES2__technique__pass__states__stencil_func_separate__mask__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const profile_GLES2__technique__pass__states__stencil_mask__AttributeData profile_GLES2__technique__pass__states__stencil_mask__AttributeData::DEFAULT = {4294967295ULL, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__profile_GLES2__technique__pass__states__stencil_mask( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__profile_GLES2__technique__pass__states__stencil_mask( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__profile_GLES2__technique__pass__states__stencil_mask( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

profile_GLES2__technique__pass__states__stencil_mask__AttributeData* attributeData = newData<profile_GLES2__technique__pass__states__stencil_mask__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_VALUE:
    {
bool failed;
attributeData->value = GeneratedSaxParser::Utils::toSint64(attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_STENCIL_MASK,
        HASH_ATTRIBUTE_VALUE,
        attributeValue))
{
    return false;
}

    break;
    }
    case HASH_ATTRIBUTE_PARAM:
    {

attributeData->param = attributeValue;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_STENCIL_MASK, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__profile_GLES2__technique__pass__states__stencil_mask()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__profile_GLES2__technique__pass__states__stencil_mask();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__profile_GLES2__technique__pass__states__stencil_mask( void* attributeData )
{
    profile_GLES2__technique__pass__states__stencil_mask__AttributeData* typedAttributeData = static_cast<profile_GLES2__technique__pass__states__stencil_mask__AttributeData*>(attributeData);

    typedAttributeData->~profile_GLES2__technique__pass__states__stencil_mask__AttributeData();

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__profile_GLES2__technique__pass__states__stencil_mask_separate( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__profile_GLES2__technique__pass__states__stencil_mask_separate( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__profile_GLES2__technique__pass__states__stencil_mask_separate( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__profile_GLES2__technique__pass__states__stencil_mask_separate()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__profile_GLES2__technique__pass__states__stencil_mask_separate();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__profile_GLES2__technique__pass__states__stencil_mask_separate( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
const profile_GLES2__technique__pass__states__stencil_mask_separate__face__AttributeData profile_GLES2__technique__pass__states__stencil_mask_separate__face__AttributeData::DEFAULT = {ENUM__gl_face_enum__FRONT_AND_BACK, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__profile_GLES2__technique__pass__states__stencil_mask_separate__face( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__profile_GLES2__technique__pass__states__stencil_mask_separate__face( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__profile_GLES2__technique__pass__states__stencil_mask_separate__face( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

profile_GLES2__technique__pass__states__stencil_mask_separate__face__AttributeData* attributeData = newData<profile_GLES2__technique__pass__states__stencil_mask_separate__face__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_VALUE:
    {
bool failed;
attributeData->value = Utils::toEnum<ENUM__gl_face_enum, StringHash, ENUM__gl_face_enum__COUNT>(attributeValue, failed, ENUM__gl_face_enumMap, Utils::calculateStringHash);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_FACE,
        HASH_ATTRIBUTE_VALUE,
        attributeValue))
{
    return false;
}

    break;
    }
    case HASH_ATTRIBUTE_PARAM:
    {

attributeData->param = attributeValue;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_FACE, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__profile_GLES2__technique__pass__states__stencil_mask_separate__face()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__profile_GLES2__technique__pass__states__stencil_mask_separate__face();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__profile_GLES2__technique__pass__states__stencil_mask_separate__face( void* attributeData )
{
    profile_GLES2__technique__pass__states__stencil_mask_separate__face__AttributeData* typedAttributeData = static_cast<profile_GLES2__technique__pass__states__stencil_mask_separate__face__AttributeData*>(attributeData);

    typedAttributeData->~profile_GLES2__technique__pass__states__stencil_mask_separate__face__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const profile_GLES2__technique__pass__states__stencil_mask_separate__mask__AttributeData profile_GLES2__technique__pass__states__stencil_mask_separate__mask__AttributeData::DEFAULT = {255, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__profile_GLES2__technique__pass__states__stencil_mask_separate__mask( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__profile_GLES2__technique__pass__states__stencil_mask_separate__mask( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__profile_GLES2__technique__pass__states__stencil_mask_separate__mask( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

profile_GLES2__technique__pass__states__stencil_mask_separate__mask__AttributeData* attributeData = newData<profile_GLES2__technique__pass__states__stencil_mask_separate__mask__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_VALUE:
    {
bool failed;
attributeData->value = GeneratedSaxParser::Utils::toUint8(attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_MASK,
        HASH_ATTRIBUTE_VALUE,
        attributeValue))
{
    return false;
}

    break;
    }
    case HASH_ATTRIBUTE_PARAM:
    {

attributeData->param = attributeValue;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_MASK, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__profile_GLES2__technique__pass__states__stencil_mask_separate__mask()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__profile_GLES2__technique__pass__states__stencil_mask_separate__mask();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__profile_GLES2__technique__pass__states__stencil_mask_separate__mask( void* attributeData )
{
    profile_GLES2__technique__pass__states__stencil_mask_separate__mask__AttributeData* typedAttributeData = static_cast<profile_GLES2__technique__pass__states__stencil_mask_separate__mask__AttributeData*>(attributeData);

    typedAttributeData->~profile_GLES2__technique__pass__states__stencil_mask_separate__mask__AttributeData();

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__profile_GLES2__technique__pass__states__stencil_op( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__profile_GLES2__technique__pass__states__stencil_op( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__profile_GLES2__technique__pass__states__stencil_op( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__profile_GLES2__technique__pass__states__stencil_op()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__profile_GLES2__technique__pass__states__stencil_op();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__profile_GLES2__technique__pass__states__stencil_op( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
const profile_GLES2__technique__pass__states__stencil_op__fail__AttributeData profile_GLES2__technique__pass__states__stencil_op__fail__AttributeData::DEFAULT = {ENUM__gl_stencil_op_enum__KEEP, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__profile_GLES2__technique__pass__states__stencil_op__fail( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__profile_GLES2__technique__pass__states__stencil_op__fail( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__profile_GLES2__technique__pass__states__stencil_op__fail( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

profile_GLES2__technique__pass__states__stencil_op__fail__AttributeData* attributeData = newData<profile_GLES2__technique__pass__states__stencil_op__fail__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_VALUE:
    {
bool failed;
attributeData->value = Utils::toEnum<ENUM__gl_stencil_op_enum, StringHash, ENUM__gl_stencil_op_enum__COUNT>(attributeValue, failed, ENUM__gl_stencil_op_enumMap, Utils::calculateStringHash);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_FAIL,
        HASH_ATTRIBUTE_VALUE,
        attributeValue))
{
    return false;
}

    break;
    }
    case HASH_ATTRIBUTE_PARAM:
    {

attributeData->param = attributeValue;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_FAIL, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__profile_GLES2__technique__pass__states__stencil_op__fail()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__profile_GLES2__technique__pass__states__stencil_op__fail();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__profile_GLES2__technique__pass__states__stencil_op__fail( void* attributeData )
{
    profile_GLES2__technique__pass__states__stencil_op__fail__AttributeData* typedAttributeData = static_cast<profile_GLES2__technique__pass__states__stencil_op__fail__AttributeData*>(attributeData);

    typedAttributeData->~profile_GLES2__technique__pass__states__stencil_op__fail__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const profile_GLES2__technique__pass__states__stencil_op__zfail__AttributeData profile_GLES2__technique__pass__states__stencil_op__zfail__AttributeData::DEFAULT = {ENUM__gl_stencil_op_enum__KEEP, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__profile_GLES2__technique__pass__states__stencil_op__zfail( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__profile_GLES2__technique__pass__states__stencil_op__zfail( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__profile_GLES2__technique__pass__states__stencil_op__zfail( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

profile_GLES2__technique__pass__states__stencil_op__zfail__AttributeData* attributeData = newData<profile_GLES2__technique__pass__states__stencil_op__zfail__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_VALUE:
    {
bool failed;
attributeData->value = Utils::toEnum<ENUM__gl_stencil_op_enum, StringHash, ENUM__gl_stencil_op_enum__COUNT>(attributeValue, failed, ENUM__gl_stencil_op_enumMap, Utils::calculateStringHash);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_ZFAIL,
        HASH_ATTRIBUTE_VALUE,
        attributeValue))
{
    return false;
}

    break;
    }
    case HASH_ATTRIBUTE_PARAM:
    {

attributeData->param = attributeValue;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_ZFAIL, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__profile_GLES2__technique__pass__states__stencil_op__zfail()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__profile_GLES2__technique__pass__states__stencil_op__zfail();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__profile_GLES2__technique__pass__states__stencil_op__zfail( void* attributeData )
{
    profile_GLES2__technique__pass__states__stencil_op__zfail__AttributeData* typedAttributeData = static_cast<profile_GLES2__technique__pass__states__stencil_op__zfail__AttributeData*>(attributeData);

    typedAttributeData->~profile_GLES2__technique__pass__states__stencil_op__zfail__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const profile_GLES2__technique__pass__states__stencil_op__zpass__AttributeData profile_GLES2__technique__pass__states__stencil_op__zpass__AttributeData::DEFAULT = {ENUM__gl_stencil_op_enum__KEEP, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__profile_GLES2__technique__pass__states__stencil_op__zpass( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__profile_GLES2__technique__pass__states__stencil_op__zpass( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__profile_GLES2__technique__pass__states__stencil_op__zpass( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

profile_GLES2__technique__pass__states__stencil_op__zpass__AttributeData* attributeData = newData<profile_GLES2__technique__pass__states__stencil_op__zpass__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_VALUE:
    {
bool failed;
attributeData->value = Utils::toEnum<ENUM__gl_stencil_op_enum, StringHash, ENUM__gl_stencil_op_enum__COUNT>(attributeValue, failed, ENUM__gl_stencil_op_enumMap, Utils::calculateStringHash);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_ZPASS,
        HASH_ATTRIBUTE_VALUE,
        attributeValue))
{
    return false;
}

    break;
    }
    case HASH_ATTRIBUTE_PARAM:
    {

attributeData->param = attributeValue;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_ZPASS, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__profile_GLES2__technique__pass__states__stencil_op__zpass()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__profile_GLES2__technique__pass__states__stencil_op__zpass();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__profile_GLES2__technique__pass__states__stencil_op__zpass( void* attributeData )
{
    profile_GLES2__technique__pass__states__stencil_op__zpass__AttributeData* typedAttributeData = static_cast<profile_GLES2__technique__pass__states__stencil_op__zpass__AttributeData*>(attributeData);

    typedAttributeData->~profile_GLES2__technique__pass__states__stencil_op__zpass__AttributeData();

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__profile_GLES2__technique__pass__states__stencil_op_separate( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__profile_GLES2__technique__pass__states__stencil_op_separate( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__profile_GLES2__technique__pass__states__stencil_op_separate( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__profile_GLES2__technique__pass__states__stencil_op_separate()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__profile_GLES2__technique__pass__states__stencil_op_separate();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__profile_GLES2__technique__pass__states__stencil_op_separate( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
const profile_GLES2__technique__pass__states__stencil_op_separate__face__AttributeData profile_GLES2__technique__pass__states__stencil_op_separate__face__AttributeData::DEFAULT = {ENUM__gl_face_enum__FRONT_AND_BACK, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__profile_GLES2__technique__pass__states__stencil_op_separate__face( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__profile_GLES2__technique__pass__states__stencil_op_separate__face( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__profile_GLES2__technique__pass__states__stencil_op_separate__face( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

profile_GLES2__technique__pass__states__stencil_op_separate__face__AttributeData* attributeData = newData<profile_GLES2__technique__pass__states__stencil_op_separate__face__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_VALUE:
    {
bool failed;
attributeData->value = Utils::toEnum<ENUM__gl_face_enum, StringHash, ENUM__gl_face_enum__COUNT>(attributeValue, failed, ENUM__gl_face_enumMap, Utils::calculateStringHash);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_FACE,
        HASH_ATTRIBUTE_VALUE,
        attributeValue))
{
    return false;
}

    break;
    }
    case HASH_ATTRIBUTE_PARAM:
    {

attributeData->param = attributeValue;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_FACE, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__profile_GLES2__technique__pass__states__stencil_op_separate__face()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__profile_GLES2__technique__pass__states__stencil_op_separate__face();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__profile_GLES2__technique__pass__states__stencil_op_separate__face( void* attributeData )
{
    profile_GLES2__technique__pass__states__stencil_op_separate__face__AttributeData* typedAttributeData = static_cast<profile_GLES2__technique__pass__states__stencil_op_separate__face__AttributeData*>(attributeData);

    typedAttributeData->~profile_GLES2__technique__pass__states__stencil_op_separate__face__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const profile_GLES2__technique__pass__states__stencil_op_separate__fail__AttributeData profile_GLES2__technique__pass__states__stencil_op_separate__fail__AttributeData::DEFAULT = {ENUM__gl_stencil_op_enum__KEEP, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__profile_GLES2__technique__pass__states__stencil_op_separate__fail( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__profile_GLES2__technique__pass__states__stencil_op_separate__fail( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__profile_GLES2__technique__pass__states__stencil_op_separate__fail( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

profile_GLES2__technique__pass__states__stencil_op_separate__fail__AttributeData* attributeData = newData<profile_GLES2__technique__pass__states__stencil_op_separate__fail__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_VALUE:
    {
bool failed;
attributeData->value = Utils::toEnum<ENUM__gl_stencil_op_enum, StringHash, ENUM__gl_stencil_op_enum__COUNT>(attributeValue, failed, ENUM__gl_stencil_op_enumMap, Utils::calculateStringHash);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_FAIL,
        HASH_ATTRIBUTE_VALUE,
        attributeValue))
{
    return false;
}

    break;
    }
    case HASH_ATTRIBUTE_PARAM:
    {

attributeData->param = attributeValue;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_FAIL, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__profile_GLES2__technique__pass__states__stencil_op_separate__fail()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__profile_GLES2__technique__pass__states__stencil_op_separate__fail();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__profile_GLES2__technique__pass__states__stencil_op_separate__fail( void* attributeData )
{
    profile_GLES2__technique__pass__states__stencil_op_separate__fail__AttributeData* typedAttributeData = static_cast<profile_GLES2__technique__pass__states__stencil_op_separate__fail__AttributeData*>(attributeData);

    typedAttributeData->~profile_GLES2__technique__pass__states__stencil_op_separate__fail__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const profile_GLES2__technique__pass__states__stencil_op_separate__zfail__AttributeData profile_GLES2__technique__pass__states__stencil_op_separate__zfail__AttributeData::DEFAULT = {ENUM__gl_stencil_op_enum__KEEP, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__profile_GLES2__technique__pass__states__stencil_op_separate__zfail( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__profile_GLES2__technique__pass__states__stencil_op_separate__zfail( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__profile_GLES2__technique__pass__states__stencil_op_separate__zfail( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

profile_GLES2__technique__pass__states__stencil_op_separate__zfail__AttributeData* attributeData = newData<profile_GLES2__technique__pass__states__stencil_op_separate__zfail__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_VALUE:
    {
bool failed;
attributeData->value = Utils::toEnum<ENUM__gl_stencil_op_enum, StringHash, ENUM__gl_stencil_op_enum__COUNT>(attributeValue, failed, ENUM__gl_stencil_op_enumMap, Utils::calculateStringHash);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_ZFAIL,
        HASH_ATTRIBUTE_VALUE,
        attributeValue))
{
    return false;
}

    break;
    }
    case HASH_ATTRIBUTE_PARAM:
    {

attributeData->param = attributeValue;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_ZFAIL, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__profile_GLES2__technique__pass__states__stencil_op_separate__zfail()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__profile_GLES2__technique__pass__states__stencil_op_separate__zfail();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__profile_GLES2__technique__pass__states__stencil_op_separate__zfail( void* attributeData )
{
    profile_GLES2__technique__pass__states__stencil_op_separate__zfail__AttributeData* typedAttributeData = static_cast<profile_GLES2__technique__pass__states__stencil_op_separate__zfail__AttributeData*>(attributeData);

    typedAttributeData->~profile_GLES2__technique__pass__states__stencil_op_separate__zfail__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const profile_GLES2__technique__pass__states__stencil_op_separate__zpass__AttributeData profile_GLES2__technique__pass__states__stencil_op_separate__zpass__AttributeData::DEFAULT = {ENUM__gl_stencil_op_enum__KEEP, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__profile_GLES2__technique__pass__states__stencil_op_separate__zpass( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__profile_GLES2__technique__pass__states__stencil_op_separate__zpass( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__profile_GLES2__technique__pass__states__stencil_op_separate__zpass( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

profile_GLES2__technique__pass__states__stencil_op_separate__zpass__AttributeData* attributeData = newData<profile_GLES2__technique__pass__states__stencil_op_separate__zpass__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_VALUE:
    {
bool failed;
attributeData->value = Utils::toEnum<ENUM__gl_stencil_op_enum, StringHash, ENUM__gl_stencil_op_enum__COUNT>(attributeValue, failed, ENUM__gl_stencil_op_enumMap, Utils::calculateStringHash);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_ZPASS,
        HASH_ATTRIBUTE_VALUE,
        attributeValue))
{
    return false;
}

    break;
    }
    case HASH_ATTRIBUTE_PARAM:
    {

attributeData->param = attributeValue;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_ZPASS, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__profile_GLES2__technique__pass__states__stencil_op_separate__zpass()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__profile_GLES2__technique__pass__states__stencil_op_separate__zpass();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__profile_GLES2__technique__pass__states__stencil_op_separate__zpass( void* attributeData )
{
    profile_GLES2__technique__pass__states__stencil_op_separate__zpass__AttributeData* typedAttributeData = static_cast<profile_GLES2__technique__pass__states__stencil_op_separate__zpass__AttributeData*>(attributeData);

    typedAttributeData->~profile_GLES2__technique__pass__states__stencil_op_separate__zpass__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const profile_GLES2__technique__pass__states__blend_enable__AttributeData profile_GLES2__technique__pass__states__blend_enable__AttributeData::DEFAULT = {false, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__profile_GLES2__technique__pass__states__blend_enable( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__profile_GLES2__technique__pass__states__blend_enable( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__profile_GLES2__technique__pass__states__blend_enable( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

profile_GLES2__technique__pass__states__blend_enable__AttributeData* attributeData = newData<profile_GLES2__technique__pass__states__blend_enable__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_VALUE:
    {
bool failed;
attributeData->value = GeneratedSaxParser::Utils::toBool(attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_BLEND_ENABLE,
        HASH_ATTRIBUTE_VALUE,
        attributeValue))
{
    return false;
}

    break;
    }
    case HASH_ATTRIBUTE_PARAM:
    {

attributeData->param = attributeValue;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_BLEND_ENABLE, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__profile_GLES2__technique__pass__states__blend_enable()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__profile_GLES2__technique__pass__states__blend_enable();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__profile_GLES2__technique__pass__states__blend_enable( void* attributeData )
{
    profile_GLES2__technique__pass__states__blend_enable__AttributeData* typedAttributeData = static_cast<profile_GLES2__technique__pass__states__blend_enable__AttributeData*>(attributeData);

    typedAttributeData->~profile_GLES2__technique__pass__states__blend_enable__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const profile_GLES2__technique__pass__states__cull_face_enable__AttributeData profile_GLES2__technique__pass__states__cull_face_enable__AttributeData::DEFAULT = {false, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__profile_GLES2__technique__pass__states__cull_face_enable( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__profile_GLES2__technique__pass__states__cull_face_enable( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__profile_GLES2__technique__pass__states__cull_face_enable( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

profile_GLES2__technique__pass__states__cull_face_enable__AttributeData* attributeData = newData<profile_GLES2__technique__pass__states__cull_face_enable__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_VALUE:
    {
bool failed;
attributeData->value = GeneratedSaxParser::Utils::toBool(attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_CULL_FACE_ENABLE,
        HASH_ATTRIBUTE_VALUE,
        attributeValue))
{
    return false;
}

    break;
    }
    case HASH_ATTRIBUTE_PARAM:
    {

attributeData->param = attributeValue;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_CULL_FACE_ENABLE, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__profile_GLES2__technique__pass__states__cull_face_enable()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__profile_GLES2__technique__pass__states__cull_face_enable();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__profile_GLES2__technique__pass__states__cull_face_enable( void* attributeData )
{
    profile_GLES2__technique__pass__states__cull_face_enable__AttributeData* typedAttributeData = static_cast<profile_GLES2__technique__pass__states__cull_face_enable__AttributeData*>(attributeData);

    typedAttributeData->~profile_GLES2__technique__pass__states__cull_face_enable__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const profile_GLES2__technique__pass__states__depth_test_enable__AttributeData profile_GLES2__technique__pass__states__depth_test_enable__AttributeData::DEFAULT = {false, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__profile_GLES2__technique__pass__states__depth_test_enable( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__profile_GLES2__technique__pass__states__depth_test_enable( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__profile_GLES2__technique__pass__states__depth_test_enable( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

profile_GLES2__technique__pass__states__depth_test_enable__AttributeData* attributeData = newData<profile_GLES2__technique__pass__states__depth_test_enable__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_VALUE:
    {
bool failed;
attributeData->value = GeneratedSaxParser::Utils::toBool(attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_DEPTH_TEST_ENABLE,
        HASH_ATTRIBUTE_VALUE,
        attributeValue))
{
    return false;
}

    break;
    }
    case HASH_ATTRIBUTE_PARAM:
    {

attributeData->param = attributeValue;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_DEPTH_TEST_ENABLE, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__profile_GLES2__technique__pass__states__depth_test_enable()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__profile_GLES2__technique__pass__states__depth_test_enable();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__profile_GLES2__technique__pass__states__depth_test_enable( void* attributeData )
{
    profile_GLES2__technique__pass__states__depth_test_enable__AttributeData* typedAttributeData = static_cast<profile_GLES2__technique__pass__states__depth_test_enable__AttributeData*>(attributeData);

    typedAttributeData->~profile_GLES2__technique__pass__states__depth_test_enable__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const profile_GLES2__technique__pass__states__dither_enable__AttributeData profile_GLES2__technique__pass__states__dither_enable__AttributeData::DEFAULT = {true, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__profile_GLES2__technique__pass__states__dither_enable( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__profile_GLES2__technique__pass__states__dither_enable( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__profile_GLES2__technique__pass__states__dither_enable( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

profile_GLES2__technique__pass__states__dither_enable__AttributeData* attributeData = newData<profile_GLES2__technique__pass__states__dither_enable__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_VALUE:
    {
bool failed;
attributeData->value = GeneratedSaxParser::Utils::toBool(attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_DITHER_ENABLE,
        HASH_ATTRIBUTE_VALUE,
        attributeValue))
{
    return false;
}

    break;
    }
    case HASH_ATTRIBUTE_PARAM:
    {

attributeData->param = attributeValue;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_DITHER_ENABLE, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__profile_GLES2__technique__pass__states__dither_enable()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__profile_GLES2__technique__pass__states__dither_enable();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__profile_GLES2__technique__pass__states__dither_enable( void* attributeData )
{
    profile_GLES2__technique__pass__states__dither_enable__AttributeData* typedAttributeData = static_cast<profile_GLES2__technique__pass__states__dither_enable__AttributeData*>(attributeData);

    typedAttributeData->~profile_GLES2__technique__pass__states__dither_enable__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const profile_GLES2__technique__pass__states__polygon_offset_fill_enable__AttributeData profile_GLES2__technique__pass__states__polygon_offset_fill_enable__AttributeData::DEFAULT = {false, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__profile_GLES2__technique__pass__states__polygon_offset_fill_enable( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__profile_GLES2__technique__pass__states__polygon_offset_fill_enable( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__profile_GLES2__technique__pass__states__polygon_offset_fill_enable( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

profile_GLES2__technique__pass__states__polygon_offset_fill_enable__AttributeData* attributeData = newData<profile_GLES2__technique__pass__states__polygon_offset_fill_enable__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_VALUE:
    {
bool failed;
attributeData->value = GeneratedSaxParser::Utils::toBool(attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_POLYGON_OFFSET_FILL_ENABLE,
        HASH_ATTRIBUTE_VALUE,
        attributeValue))
{
    return false;
}

    break;
    }
    case HASH_ATTRIBUTE_PARAM:
    {

attributeData->param = attributeValue;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_POLYGON_OFFSET_FILL_ENABLE, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__profile_GLES2__technique__pass__states__polygon_offset_fill_enable()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__profile_GLES2__technique__pass__states__polygon_offset_fill_enable();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__profile_GLES2__technique__pass__states__polygon_offset_fill_enable( void* attributeData )
{
    profile_GLES2__technique__pass__states__polygon_offset_fill_enable__AttributeData* typedAttributeData = static_cast<profile_GLES2__technique__pass__states__polygon_offset_fill_enable__AttributeData*>(attributeData);

    typedAttributeData->~profile_GLES2__technique__pass__states__polygon_offset_fill_enable__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const point_size_enable__AttributeData point_size_enable__AttributeData::DEFAULT = {false, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__point_size_enable( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__point_size_enable( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__point_size_enable( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

point_size_enable__AttributeData* attributeData = newData<point_size_enable__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_VALUE:
    {
bool failed;
attributeData->value = GeneratedSaxParser::Utils::toBool(attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_POINT_SIZE_ENABLE,
        HASH_ATTRIBUTE_VALUE,
        attributeValue))
{
    return false;
}

    break;
    }
    case HASH_ATTRIBUTE_PARAM:
    {

attributeData->param = attributeValue;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_POINT_SIZE_ENABLE, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__point_size_enable()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__point_size_enable();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__point_size_enable( void* attributeData )
{
    point_size_enable__AttributeData* typedAttributeData = static_cast<point_size_enable__AttributeData*>(attributeData);

    typedAttributeData->~point_size_enable__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const profile_GLES2__technique__pass__states__sample_alpha_to_coverage_enable__AttributeData profile_GLES2__technique__pass__states__sample_alpha_to_coverage_enable__AttributeData::DEFAULT = {false, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__profile_GLES2__technique__pass__states__sample_alpha_to_coverage_enable( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__profile_GLES2__technique__pass__states__sample_alpha_to_coverage_enable( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__profile_GLES2__technique__pass__states__sample_alpha_to_coverage_enable( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

profile_GLES2__technique__pass__states__sample_alpha_to_coverage_enable__AttributeData* attributeData = newData<profile_GLES2__technique__pass__states__sample_alpha_to_coverage_enable__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_VALUE:
    {
bool failed;
attributeData->value = GeneratedSaxParser::Utils::toBool(attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_SAMPLE_ALPHA_TO_COVERAGE_ENABLE,
        HASH_ATTRIBUTE_VALUE,
        attributeValue))
{
    return false;
}

    break;
    }
    case HASH_ATTRIBUTE_PARAM:
    {

attributeData->param = attributeValue;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_SAMPLE_ALPHA_TO_COVERAGE_ENABLE, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__profile_GLES2__technique__pass__states__sample_alpha_to_coverage_enable()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__profile_GLES2__technique__pass__states__sample_alpha_to_coverage_enable();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__profile_GLES2__technique__pass__states__sample_alpha_to_coverage_enable( void* attributeData )
{
    profile_GLES2__technique__pass__states__sample_alpha_to_coverage_enable__AttributeData* typedAttributeData = static_cast<profile_GLES2__technique__pass__states__sample_alpha_to_coverage_enable__AttributeData*>(attributeData);

    typedAttributeData->~profile_GLES2__technique__pass__states__sample_alpha_to_coverage_enable__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const profile_GLES2__technique__pass__states__sample_coverage_enable__AttributeData profile_GLES2__technique__pass__states__sample_coverage_enable__AttributeData::DEFAULT = {false, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__profile_GLES2__technique__pass__states__sample_coverage_enable( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__profile_GLES2__technique__pass__states__sample_coverage_enable( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__profile_GLES2__technique__pass__states__sample_coverage_enable( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

profile_GLES2__technique__pass__states__sample_coverage_enable__AttributeData* attributeData = newData<profile_GLES2__technique__pass__states__sample_coverage_enable__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_VALUE:
    {
bool failed;
attributeData->value = GeneratedSaxParser::Utils::toBool(attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_SAMPLE_COVERAGE_ENABLE,
        HASH_ATTRIBUTE_VALUE,
        attributeValue))
{
    return false;
}

    break;
    }
    case HASH_ATTRIBUTE_PARAM:
    {

attributeData->param = attributeValue;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_SAMPLE_COVERAGE_ENABLE, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__profile_GLES2__technique__pass__states__sample_coverage_enable()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__profile_GLES2__technique__pass__states__sample_coverage_enable();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__profile_GLES2__technique__pass__states__sample_coverage_enable( void* attributeData )
{
    profile_GLES2__technique__pass__states__sample_coverage_enable__AttributeData* typedAttributeData = static_cast<profile_GLES2__technique__pass__states__sample_coverage_enable__AttributeData*>(attributeData);

    typedAttributeData->~profile_GLES2__technique__pass__states__sample_coverage_enable__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const profile_GLES2__technique__pass__states__scissor_test_enable__AttributeData profile_GLES2__technique__pass__states__scissor_test_enable__AttributeData::DEFAULT = {false, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__profile_GLES2__technique__pass__states__scissor_test_enable( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__profile_GLES2__technique__pass__states__scissor_test_enable( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__profile_GLES2__technique__pass__states__scissor_test_enable( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

profile_GLES2__technique__pass__states__scissor_test_enable__AttributeData* attributeData = newData<profile_GLES2__technique__pass__states__scissor_test_enable__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_VALUE:
    {
bool failed;
attributeData->value = GeneratedSaxParser::Utils::toBool(attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_SCISSOR_TEST_ENABLE,
        HASH_ATTRIBUTE_VALUE,
        attributeValue))
{
    return false;
}

    break;
    }
    case HASH_ATTRIBUTE_PARAM:
    {

attributeData->param = attributeValue;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_SCISSOR_TEST_ENABLE, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__profile_GLES2__technique__pass__states__scissor_test_enable()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__profile_GLES2__technique__pass__states__scissor_test_enable();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__profile_GLES2__technique__pass__states__scissor_test_enable( void* attributeData )
{
    profile_GLES2__technique__pass__states__scissor_test_enable__AttributeData* typedAttributeData = static_cast<profile_GLES2__technique__pass__states__scissor_test_enable__AttributeData*>(attributeData);

    typedAttributeData->~profile_GLES2__technique__pass__states__scissor_test_enable__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const profile_GLES2__technique__pass__states__stencil_test_enable__AttributeData profile_GLES2__technique__pass__states__stencil_test_enable__AttributeData::DEFAULT = {false, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__profile_GLES2__technique__pass__states__stencil_test_enable( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__profile_GLES2__technique__pass__states__stencil_test_enable( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__profile_GLES2__technique__pass__states__stencil_test_enable( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

profile_GLES2__technique__pass__states__stencil_test_enable__AttributeData* attributeData = newData<profile_GLES2__technique__pass__states__stencil_test_enable__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_VALUE:
    {
bool failed;
attributeData->value = GeneratedSaxParser::Utils::toBool(attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_STENCIL_TEST_ENABLE,
        HASH_ATTRIBUTE_VALUE,
        attributeValue))
{
    return false;
}

    break;
    }
    case HASH_ATTRIBUTE_PARAM:
    {

attributeData->param = attributeValue;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_STENCIL_TEST_ENABLE, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__profile_GLES2__technique__pass__states__stencil_test_enable()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__profile_GLES2__technique__pass__states__stencil_test_enable();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__profile_GLES2__technique__pass__states__stencil_test_enable( void* attributeData )
{
    profile_GLES2__technique__pass__states__stencil_test_enable__AttributeData* typedAttributeData = static_cast<profile_GLES2__technique__pass__states__stencil_test_enable__AttributeData*>(attributeData);

    typedAttributeData->~profile_GLES2__technique__pass__states__stencil_test_enable__AttributeData();

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__program____gles2_program_type( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__program____gles2_program_type( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__program____gles2_program_type( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__program____gles2_program_type()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__program____gles2_program_type();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__program____gles2_program_type( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
const shader____gles2_shader_type__AttributeData shader____gles2_shader_type__AttributeData::DEFAULT = {ENUM__fx_pipeline_stage_enum__NOT_PRESENT};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__shader____gles2_shader_type( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__shader____gles2_shader_type( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__shader____gles2_shader_type( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

shader____gles2_shader_type__AttributeData* attributeData = newData<shader____gles2_shader_type__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_STAGE:
    {
bool failed;
attributeData->stage = Utils::toEnum<ENUM__fx_pipeline_stage_enum, StringHash, ENUM__fx_pipeline_stage_enum__COUNT>(attributeValue, failed, ENUM__fx_pipeline_stage_enumMap, Utils::calculateStringHash);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_SHADER,
        HASH_ATTRIBUTE_STAGE,
        attributeValue))
{
    return false;
}

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_SHADER, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ( attributeData->stage == ENUM__fx_pipeline_stage_enum__NOT_PRESENT )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_SHADER, HASH_ATTRIBUTE_STAGE, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__shader____gles2_shader_type()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__shader____gles2_shader_type();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__shader____gles2_shader_type( void* attributeData )
{
    shader____gles2_shader_type__AttributeData* typedAttributeData = static_cast<shader____gles2_shader_type__AttributeData*>(attributeData);

    typedAttributeData->~shader____gles2_shader_type__AttributeData();

    return true;
}

//---------------------------------------------------------------------
ENUM__fx_pipeline_stage_enum ColladaParserAutoGen15Private::toEnumDataPrefix_ENUM__fx_pipeline_stage_enum (
    const ParserChar* prefixedBuffer,
    const ParserChar* prefixedBufferEnd,
    const ParserChar** buffer,
    const ParserChar* bufferEnd,
    bool& failed,
    const std::pair<StringHash, ENUM__fx_pipeline_stage_enum>* enumMap,
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& )
)
{
    return toEnumDataPrefix<ENUM__fx_pipeline_stage_enum, StringHash, ENUM__fx_pipeline_stage_enum__COUNT, &toEnum_ENUM__fx_pipeline_stage_enum>(prefixedBuffer, prefixedBufferEnd, buffer, bufferEnd, failed, enumMap, baseConversionFunc);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::characterData2EnumData_ENUM__fx_pipeline_stage_enum (
    const ParserChar* text,
    size_t textLength,
    bool ( ColladaParserAutoGen15::*dataFunction )(const ENUM__fx_pipeline_stage_enum*, size_t ),
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& )
)
{
    return characterData2EnumData<ENUM__fx_pipeline_stage_enum, StringHash, ENUM__fx_pipeline_stage_enum__COUNT>(text, textLength, dataFunction, ENUM__fx_pipeline_stage_enumMap, baseConversionFunc, &toEnum_ENUM__fx_pipeline_stage_enum, &ColladaParserAutoGen15Private::toEnumDataPrefix_ENUM__fx_pipeline_stage_enum);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::dataEnumEnd_ENUM__fx_pipeline_stage_enum (
    bool ( ColladaParserAutoGen15::*dataFunction )(const ENUM__fx_pipeline_stage_enum*, size_t ),
    const std::pair<StringHash, ENUM__fx_pipeline_stage_enum>* enumMap,
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& ),
    ENUM__fx_pipeline_stage_enum (*toEnumFunc)( const ParserChar**, const ParserChar*, bool&, const std::pair<StringHash, ENUM__fx_pipeline_stage_enum>* enumMap, StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& ))
)
{
    return dataEnumEnd<ENUM__fx_pipeline_stage_enum, StringHash, ENUM__fx_pipeline_stage_enum__COUNT>(dataFunction, enumMap, baseConversionFunc, toEnumFunc);
}

//---------------------------------------------------------------------
const gles2_shader_type____sources__AttributeData gles2_shader_type____sources__AttributeData::DEFAULT = {(const ParserChar*)"main"};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__gles2_shader_type____sources( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__gles2_shader_type____sources( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__gles2_shader_type____sources( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

gles2_shader_type____sources__AttributeData* attributeData = newData<gles2_shader_type____sources__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_ENTRY:
    {

attributeData->entry = attributeValue;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_SOURCES, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__gles2_shader_type____sources()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__gles2_shader_type____sources();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__gles2_shader_type____sources( void* attributeData )
{
    gles2_shader_type____sources__AttributeData* typedAttributeData = static_cast<gles2_shader_type____sources__AttributeData*>(attributeData);

    typedAttributeData->~gles2_shader_type____sources__AttributeData();

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__inline( const ParserChar* text, size_t textLength )
{

return mImpl->data__inline(text, textLength);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__inline( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__inline( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__inline()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__inline();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__inline( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
const import__AttributeData import__AttributeData::DEFAULT = {0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__import( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__import( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__import( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

import__AttributeData* attributeData = newData<import__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_REF:
    {

attributeData->ref = attributeValue;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_IMPORT, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ( !attributeData->ref )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_IMPORT, HASH_ATTRIBUTE_REF, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__import()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__import();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__import( void* attributeData )
{
    import__AttributeData* typedAttributeData = static_cast<import__AttributeData*>(attributeData);

    typedAttributeData->~import__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const compiler__AttributeData compiler__AttributeData::DEFAULT = {0, 0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__compiler( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__compiler( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__compiler( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

compiler__AttributeData* attributeData = newData<compiler__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_PLATFORM:
    {

attributeData->platform = attributeValue;

    break;
    }
    case HASH_ATTRIBUTE_TARGET:
    {

attributeData->target = attributeValue;

    break;
    }
    case HASH_ATTRIBUTE_OPTIONS:
    {

attributeData->options = attributeValue;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_COMPILER, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ( !attributeData->platform )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_COMPILER, HASH_ATTRIBUTE_PLATFORM, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__compiler()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__compiler();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__compiler( void* attributeData )
{
    compiler__AttributeData* typedAttributeData = static_cast<compiler__AttributeData*>(attributeData);

    typedAttributeData->~compiler__AttributeData();

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__binary( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__binary( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__binary( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__binary()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__binary();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__binary( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__ref____anyURI( const ParserChar* text, size_t textLength )
{
if (!mLastIncompleteFragmentInCharacterData)
{
    mLastIncompleteFragmentInCharacterData = (ParserChar*)mStackMemoryManager.newObject(textLength);
    memcpy(mLastIncompleteFragmentInCharacterData, text, textLength);
    mEndOfDataInCurrentObjectOnStack = mLastIncompleteFragmentInCharacterData + textLength;
}
else
{
    ParserChar* tmp = (ParserChar*)mStackMemoryManager.growObject(textLength);
    if ( tmp != mLastIncompleteFragmentInCharacterData ) {
        mEndOfDataInCurrentObjectOnStack = (mEndOfDataInCurrentObjectOnStack - mLastIncompleteFragmentInCharacterData) + tmp;
        mLastIncompleteFragmentInCharacterData = tmp;
    }
    memcpy(mEndOfDataInCurrentObjectOnStack, text, textLength);
    mEndOfDataInCurrentObjectOnStack += textLength;
}
return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__ref____anyURI( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__ref____anyURI( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__ref____anyURI()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__ref____anyURI();
        if ( !validationResult ) return false;

    } // validation
#endif

bool failed;
const ParserChar* ptrForErr = mLastIncompleteFragmentInCharacterData;
DISABLE_WARNING_UNUSED(ptrForErr)
COLLADABU::URI parameter = GeneratedSaxParser::Utils::toURI((const ParserChar**)&mLastIncompleteFragmentInCharacterData, mEndOfDataInCurrentObjectOnStack, failed);
bool returnValue;
if (!failed)
{
    returnValue = mImpl->data__ref____anyURI(parameter);
}
else
    returnValue = !handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_TEXTDATA_PARSING_FAILED, HASH_ELEMENT_REF, (const ParserChar*)0, mLastIncompleteFragmentInCharacterData);
if (mLastIncompleteFragmentInCharacterData)
    mStackMemoryManager.deleteObject();
mLastIncompleteFragmentInCharacterData = 0;
mEndOfDataInCurrentObjectOnStack = 0;
return returnValue;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__ref____anyURI( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
const binary__hex__AttributeData binary__hex__AttributeData::DEFAULT = {0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__binary__hex( const ParserChar* text, size_t textLength )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
return characterData2Uint8Data(text, textLength, &ColladaParserAutoGen15::data__binary__hex, 0, 0, 0);
    }
    else
    {
return characterData2Uint8Data(text, textLength, &ColladaParserAutoGen15::data__binary__hex);
    }
#else
    {
return characterData2Uint8Data(text, textLength, &ColladaParserAutoGen15::data__binary__hex);
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__binary__hex( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__binary__hex( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

binary__hex__AttributeData* attributeData = newData<binary__hex__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_FORMAT:
    {

attributeData->format = attributeValue;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_HEX, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__binary__hex()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__binary__hex();
        if ( !validationResult ) return false;

    } // validation
#endif

#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
bool returnValue = uint8DataEnd( &ColladaParserAutoGen15::data__binary__hex, 0, 0, 0 );
        return returnValue;
    }
    else
    {
return uint8DataEnd( &ColladaParserAutoGen15::data__binary__hex );
    }
#else
    {
return uint8DataEnd( &ColladaParserAutoGen15::data__binary__hex );
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__binary__hex( void* attributeData )
{
    binary__hex__AttributeData* typedAttributeData = static_cast<binary__hex__AttributeData*>(attributeData);

    typedAttributeData->~binary__hex__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const linker__AttributeData linker__AttributeData::DEFAULT = {0, 0, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__linker( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__linker( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__linker( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

linker__AttributeData* attributeData = newData<linker__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_PLATFORM:
    {

attributeData->platform = attributeValue;

    break;
    }
    case HASH_ATTRIBUTE_TARGET:
    {

attributeData->target = attributeValue;

    break;
    }
    case HASH_ATTRIBUTE_OPTIONS:
    {

attributeData->options = attributeValue;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_LINKER, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ( !attributeData->platform )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_LINKER, HASH_ATTRIBUTE_PLATFORM, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__linker()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__linker();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__linker( void* attributeData )
{
    linker__AttributeData* typedAttributeData = static_cast<linker__AttributeData*>(attributeData);

    typedAttributeData->~linker__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const gles2_program_type____bind_attribute__AttributeData gles2_program_type____bind_attribute__AttributeData::DEFAULT = {0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__gles2_program_type____bind_attribute( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__gles2_program_type____bind_attribute( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__gles2_program_type____bind_attribute( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

gles2_program_type____bind_attribute__AttributeData* attributeData = newData<gles2_program_type____bind_attribute__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_SYMBOL:
    {

attributeData->symbol = attributeValue;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_BIND_ATTRIBUTE, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ( !attributeData->symbol )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_BIND_ATTRIBUTE, HASH_ATTRIBUTE_SYMBOL, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__gles2_program_type____bind_attribute()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__gles2_program_type____bind_attribute();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__gles2_program_type____bind_attribute( void* attributeData )
{
    gles2_program_type____bind_attribute__AttributeData* typedAttributeData = static_cast<gles2_program_type____bind_attribute__AttributeData*>(attributeData);

    typedAttributeData->~gles2_program_type____bind_attribute__AttributeData();

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__semantic____token( const ParserChar* text, size_t textLength )
{

return mImpl->data__semantic____token(text, textLength);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__semantic____token( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__semantic____token( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__semantic____token()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__semantic____token();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__semantic____token( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
const gles2_program_type____bind_uniform__AttributeData gles2_program_type____bind_uniform__AttributeData::DEFAULT = {0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__gles2_program_type____bind_uniform( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__gles2_program_type____bind_uniform( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__gles2_program_type____bind_uniform( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

gles2_program_type____bind_uniform__AttributeData* attributeData = newData<gles2_program_type____bind_uniform__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_SYMBOL:
    {

attributeData->symbol = attributeValue;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_BIND_UNIFORM, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ( !attributeData->symbol )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_BIND_UNIFORM, HASH_ATTRIBUTE_SYMBOL, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__gles2_program_type____bind_uniform()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__gles2_program_type____bind_uniform();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__gles2_program_type____bind_uniform( void* attributeData )
{
    gles2_program_type____bind_uniform__AttributeData* typedAttributeData = static_cast<gles2_program_type____bind_uniform__AttributeData*>(attributeData);

    typedAttributeData->~gles2_program_type____bind_uniform__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const profile_GLES2__technique__pass__program__bind_uniform__param__AttributeData profile_GLES2__technique__pass__program__bind_uniform__param__AttributeData::DEFAULT = {0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__profile_GLES2__technique__pass__program__bind_uniform__param( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__profile_GLES2__technique__pass__program__bind_uniform__param( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__profile_GLES2__technique__pass__program__bind_uniform__param( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

profile_GLES2__technique__pass__program__bind_uniform__param__AttributeData* attributeData = newData<profile_GLES2__technique__pass__program__bind_uniform__param__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_REF:
    {

attributeData->ref = attributeValue;
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
    ParserError::ErrorType simpleTypeValidationResult = validate__NCName(attributeData->ref, strlen(attributeData->ref));
    if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
    {
        if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
            simpleTypeValidationResult,
            HASH_ELEMENT_PARAM,
            HASH_ATTRIBUTE_REF,
            attributeValue) )
        {
            return false;
        }
    }
    } // validation
#endif

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_PARAM, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ( !attributeData->ref )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_PARAM, HASH_ATTRIBUTE_REF, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__profile_GLES2__technique__pass__program__bind_uniform__param()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__profile_GLES2__technique__pass__program__bind_uniform__param();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__profile_GLES2__technique__pass__program__bind_uniform__param( void* attributeData )
{
    profile_GLES2__technique__pass__program__bind_uniform__param__AttributeData* typedAttributeData = static_cast<profile_GLES2__technique__pass__program__bind_uniform__param__AttributeData*>(attributeData);

    typedAttributeData->~profile_GLES2__technique__pass__program__bind_uniform__param__AttributeData();

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__gles2_pass_type____evaluate( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__gles2_pass_type____evaluate( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__gles2_pass_type____evaluate( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__gles2_pass_type____evaluate()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__gles2_pass_type____evaluate();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__gles2_pass_type____evaluate( void* attributeData )
{
    return true;
}

//---------------------------------------------------------------------
const color_target__AttributeData color_target__AttributeData::DEFAULT = {0, 0, ENUM__image_face_enum__POSITIVE_X, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__color_target( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__color_target( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__color_target( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

color_target__AttributeData* attributeData = newData<color_target__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_INDEX:
    {
bool failed;
attributeData->index = GeneratedSaxParser::Utils::toUint64(attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_COLOR_TARGET,
        HASH_ATTRIBUTE_INDEX,
        attributeValue))
{
    return false;
}

    break;
    }
    case HASH_ATTRIBUTE_MIP:
    {
bool failed;
attributeData->mip = GeneratedSaxParser::Utils::toUint64(attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_COLOR_TARGET,
        HASH_ATTRIBUTE_MIP,
        attributeValue))
{
    return false;
}

    break;
    }
    case HASH_ATTRIBUTE_FACE:
    {
bool failed;
attributeData->face = Utils::toEnum<ENUM__image_face_enum, StringHash, ENUM__image_face_enum__COUNT>(attributeValue, failed, ENUM__image_face_enumMap, Utils::calculateStringHash);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_COLOR_TARGET,
        HASH_ATTRIBUTE_FACE,
        attributeValue))
{
    return false;
}

    break;
    }
    case HASH_ATTRIBUTE_SLICE:
    {
bool failed;
attributeData->slice = GeneratedSaxParser::Utils::toUint64(attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_COLOR_TARGET,
        HASH_ATTRIBUTE_SLICE,
        attributeValue))
{
    return false;
}

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_COLOR_TARGET, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__color_target()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__color_target();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__color_target( void* attributeData )
{
    color_target__AttributeData* typedAttributeData = static_cast<color_target__AttributeData*>(attributeData);

    typedAttributeData->~color_target__AttributeData();

    return true;
}

//---------------------------------------------------------------------
ENUM__image_face_enum ColladaParserAutoGen15Private::toEnumDataPrefix_ENUM__image_face_enum (
    const ParserChar* prefixedBuffer,
    const ParserChar* prefixedBufferEnd,
    const ParserChar** buffer,
    const ParserChar* bufferEnd,
    bool& failed,
    const std::pair<StringHash, ENUM__image_face_enum>* enumMap,
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& )
)
{
    return toEnumDataPrefix<ENUM__image_face_enum, StringHash, ENUM__image_face_enum__COUNT, &toEnum_ENUM__image_face_enum>(prefixedBuffer, prefixedBufferEnd, buffer, bufferEnd, failed, enumMap, baseConversionFunc);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::characterData2EnumData_ENUM__image_face_enum (
    const ParserChar* text,
    size_t textLength,
    bool ( ColladaParserAutoGen15::*dataFunction )(const ENUM__image_face_enum*, size_t ),
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& )
)
{
    return characterData2EnumData<ENUM__image_face_enum, StringHash, ENUM__image_face_enum__COUNT>(text, textLength, dataFunction, ENUM__image_face_enumMap, baseConversionFunc, &toEnum_ENUM__image_face_enum, &ColladaParserAutoGen15Private::toEnumDataPrefix_ENUM__image_face_enum);
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::dataEnumEnd_ENUM__image_face_enum (
    bool ( ColladaParserAutoGen15::*dataFunction )(const ENUM__image_face_enum*, size_t ),
    const std::pair<StringHash, ENUM__image_face_enum>* enumMap,
    StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& ),
    ENUM__image_face_enum (*toEnumFunc)( const ParserChar**, const ParserChar*, bool&, const std::pair<StringHash, ENUM__image_face_enum>* enumMap, StringHash (*baseConversionFunc)( const ParserChar**, const ParserChar*, bool& ))
)
{
    return dataEnumEnd<ENUM__image_face_enum, StringHash, ENUM__image_face_enum__COUNT>(dataFunction, enumMap, baseConversionFunc, toEnumFunc);
}

//---------------------------------------------------------------------
const fx_colortarget_type____param__AttributeData fx_colortarget_type____param__AttributeData::DEFAULT = {0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__fx_colortarget_type____param( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__fx_colortarget_type____param( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__fx_colortarget_type____param( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

fx_colortarget_type____param__AttributeData* attributeData = newData<fx_colortarget_type____param__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_REF:
    {

attributeData->ref = attributeValue;

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_PARAM, attribute, attributeValue))
            {return false;}
    }
    }
    }
}
if ( !attributeData->ref )
{
    if ( handleError ( ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_REQUIRED_ATTRIBUTE_MISSING, HASH_ELEMENT_PARAM, HASH_ATTRIBUTE_REF, 0 ) )
        return false;
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__fx_colortarget_type____param()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__fx_colortarget_type____param();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__fx_colortarget_type____param( void* attributeData )
{
    fx_colortarget_type____param__AttributeData* typedAttributeData = static_cast<fx_colortarget_type____param__AttributeData*>(attributeData);

    typedAttributeData->~fx_colortarget_type____param__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const depth_target__AttributeData depth_target__AttributeData::DEFAULT = {0, 0, ENUM__image_face_enum__POSITIVE_X, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__depth_target( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__depth_target( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__depth_target( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

depth_target__AttributeData* attributeData = newData<depth_target__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_INDEX:
    {
bool failed;
attributeData->index = GeneratedSaxParser::Utils::toUint64(attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_DEPTH_TARGET,
        HASH_ATTRIBUTE_INDEX,
        attributeValue))
{
    return false;
}

    break;
    }
    case HASH_ATTRIBUTE_MIP:
    {
bool failed;
attributeData->mip = GeneratedSaxParser::Utils::toUint64(attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_DEPTH_TARGET,
        HASH_ATTRIBUTE_MIP,
        attributeValue))
{
    return false;
}

    break;
    }
    case HASH_ATTRIBUTE_FACE:
    {
bool failed;
attributeData->face = Utils::toEnum<ENUM__image_face_enum, StringHash, ENUM__image_face_enum__COUNT>(attributeValue, failed, ENUM__image_face_enumMap, Utils::calculateStringHash);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_DEPTH_TARGET,
        HASH_ATTRIBUTE_FACE,
        attributeValue))
{
    return false;
}

    break;
    }
    case HASH_ATTRIBUTE_SLICE:
    {
bool failed;
attributeData->slice = GeneratedSaxParser::Utils::toUint64(attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_DEPTH_TARGET,
        HASH_ATTRIBUTE_SLICE,
        attributeValue))
{
    return false;
}

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_DEPTH_TARGET, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__depth_target()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__depth_target();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__depth_target( void* attributeData )
{
    depth_target__AttributeData* typedAttributeData = static_cast<depth_target__AttributeData*>(attributeData);

    typedAttributeData->~depth_target__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const stencil_target__AttributeData stencil_target__AttributeData::DEFAULT = {0, 0, ENUM__image_face_enum__POSITIVE_X, 0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__stencil_target( const ParserChar* text, size_t textLength )
{
    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__stencil_target( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__stencil_target( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

stencil_target__AttributeData* attributeData = newData<stencil_target__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_INDEX:
    {
bool failed;
attributeData->index = GeneratedSaxParser::Utils::toUint64(attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_STENCIL_TARGET,
        HASH_ATTRIBUTE_INDEX,
        attributeValue))
{
    return false;
}

    break;
    }
    case HASH_ATTRIBUTE_MIP:
    {
bool failed;
attributeData->mip = GeneratedSaxParser::Utils::toUint64(attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_STENCIL_TARGET,
        HASH_ATTRIBUTE_MIP,
        attributeValue))
{
    return false;
}

    break;
    }
    case HASH_ATTRIBUTE_FACE:
    {
bool failed;
attributeData->face = Utils::toEnum<ENUM__image_face_enum, StringHash, ENUM__image_face_enum__COUNT>(attributeValue, failed, ENUM__image_face_enumMap, Utils::calculateStringHash);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_STENCIL_TARGET,
        HASH_ATTRIBUTE_FACE,
        attributeValue))
{
    return false;
}

    break;
    }
    case HASH_ATTRIBUTE_SLICE:
    {
bool failed;
attributeData->slice = GeneratedSaxParser::Utils::toUint64(attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_STENCIL_TARGET,
        HASH_ATTRIBUTE_SLICE,
        attributeValue))
{
    return false;
}

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_STENCIL_TARGET, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__stencil_target()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__stencil_target();
        if ( !validationResult ) return false;

    } // validation
#endif

    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__stencil_target( void* attributeData )
{
    stencil_target__AttributeData* typedAttributeData = static_cast<stencil_target__AttributeData*>(attributeData);

    typedAttributeData->~stencil_target__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const color_clear__AttributeData color_clear__AttributeData::DEFAULT = {0};

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_data__color_clear( const ParserChar* text, size_t textLength )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        border_color__ValidationData* validationData = (border_color__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
return characterData2FloatData(text, textLength, &ColladaParserAutoGen15::data__color_clear, &validate__fx_color_type__stream, &validationData->validationWholeSize, 0);
    }
    else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen15::data__color_clear);
    }
#else
    {
return characterData2FloatData(text, textLength, &ColladaParserAutoGen15::data__color_clear);
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preBegin__color_clear( const ParserAttributes& attributes, void ** attributeDataPtr, void ** validationDataPtr )
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateBegin__color_clear( attributes, attributeDataPtr, validationDataPtr );
        if ( !validationResult ) return false;

    } // validation
#endif

color_clear__AttributeData* attributeData = newData<color_clear__AttributeData>(attributeDataPtr);

const ParserChar** attributeArray = attributes.attributes;
if ( attributeArray )
{
    while (true)
    {
        const ParserChar * attribute = *attributeArray;
        if ( !attribute )
            break;
        StringHash hash = GeneratedSaxParser::Utils::calculateStringHash(attribute);
        attributeArray++;
        if ( !attributeArray )
            return false;
        const ParserChar* attributeValue = *attributeArray;
        attributeArray++;


    switch ( hash )
    {
    case HASH_ATTRIBUTE_INDEX:
    {
bool failed;
attributeData->index = GeneratedSaxParser::Utils::toUint64(attributeValue, failed);
if ( failed && handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
        ParserError::ERROR_ATTRIBUTE_PARSING_FAILED,
        HASH_ELEMENT_COLOR_CLEAR,
        HASH_ATTRIBUTE_INDEX,
        attributeValue))
{
    return false;
}

    break;
    }
    default:
    {
        if ( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL, ParserError::ERROR_UNKNOWN_ATTRIBUTE, HASH_ELEMENT_COLOR_CLEAR, attribute, attributeValue))
            {return false;}
    }
    }
    }
}


    return true;
}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_preEnd__color_clear()
{
#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {

        bool validationResult = _validateEnd__color_clear();
        if ( !validationResult ) return false;

    } // validation
#endif

#ifdef GENERATEDSAXPARSER_VALIDATION
    if ( mValidate )
    {
        border_color__ValidationData* validationData = (border_color__ValidationData*)mValidationDataStack.top();
        DISABLE_WARNING_UNUSED(validationData)
bool returnValue = floatDataEnd( &ColladaParserAutoGen15::data__color_clear, &validate__fx_color_type__streamEnd, &validationData->validationWholeSize, 0 );
        ParserError::ErrorType simpleTypeValidationResult = validate__fx_color_type(0, (*(&validationData->validationWholeSize)));
        mValidationDataStack.deleteObject();
        if (simpleTypeValidationResult != ParserError::SIMPLE_TYPE_VALIDATION_OK)
        {
            if( handleError(ParserError::SEVERITY_ERROR_NONCRITICAL,
                simpleTypeValidationResult,
                HASH_ELEMENT_COLOR_CLEAR,
                (ParserChar*)0, 0 ) )
            {
                return false;
            }
        }
        return returnValue;
    }
    else
    {
return floatDataEnd( &ColladaParserAutoGen15::data__color_clear );
    }
#else
    {
return floatDataEnd( &ColladaParserAutoGen15::data__color_clear );
    } // validation
#endif

}

//---------------------------------------------------------------------
bool ColladaParserAutoGen15Private::_freeAttributes__color_clear( void* attributeData )
{
    color_clear__AttributeData* typedAttributeData = static_cast<color_clear__AttributeData*>(attributeData);

    typedAttributeData->~color_clear__AttributeData();

    return true;
}

//---------------------------------------------------------------------
const stencil_clear__AttributeData stencil_clear__AttributeData::DEFAULT = {0};

//-----------------------------------------------------------