import QtQuick 1.0
import oif 1.0

Item {
    width: 1000
    height: 600

    Rectangle {
        id: sky

        anchors.fill: parent

        gradient: Gradient {
            GradientStop { position: 0.0; color: "lightsteelblue" }
            GradientStop { position: 0.6; color: "linen" }
        }
    }

    OIFRotateArea {
        id: rotate

        anchors.fill: parent

        subscription {
            touches.start: 2
        }

        onGestureStart: {
            initial_angle = turbine.angle
        }

        onGestureEnd: {
            turbine.velocity = gesture.attributes["angular velocity"]*1000*(180/Math.PI)/62.5
            clouds.velocity += gesture.attributes["angular velocity"]*50
        }
    }

    property real initial_angle
    Binding {
        target: turbine
        property: "angle"
        value: initial_angle + (rotate.angle.current-rotate.angle.initial)*(180/Math.PI)
        when: rotate.active
    }

    Image {
        id: turbine

        property alias velocity: fan_animation.velocity
        property alias friction: fan_animation.friction
        property alias angle: fan.rotation
        property bool free: !rotate.active

        smooth: true
        source: "turbine.png"
        anchors.bottom: parent.bottom
        anchors.left: parent.left
        anchors.leftMargin: 50
        height: parent.height*0.7
        width: sourceSize.width/sourceSize.height*height

        Item {
            id: fan

            property real radius: parent.height/2

            x: -radius+turbine.width*0.65
            y: -radius+turbine.height*0.035
            width: radius*2
            height: radius*2

            Repeater {
                id: repeater
                model: 3
                delegate: Image {
                    source: "blade.png"
                    smooth: true
                    width: fan.radius*0.97
                    height: sourceSize.height/sourceSize.width*width
                    transform: Rotation { origin.x: fan.radius-x; origin.y: height/2; axis { x: 0; y: 0; z: 1 } angle: index/repeater.count*360 }
                    y: (fan.height-height)/2
                }
            }

            transform: Rotation { origin.x: fan.radius; origin.y: fan.radius; axis { x: 0; y: 1; z: 0 } angle: 60 }
            rotation: 50

            Timer {
                id: fan_animation

                property real velocity: 0
                property real friction: 0.1

                interval: 16
                repeat: true
                running: velocity != 0 && turbine.free
                onTriggered: {fan.rotation += velocity; velocity -= velocity/Math.abs(velocity)*friction}
            }
        }
    }

    Item {
        id: clouds
        property real velocity: 0.1

        anchors.fill: parent
        anchors.leftMargin: turbine.width

        Timer {
            interval: 800
            repeat: true
            running: true
            onTriggered: cloud_template.createObject(clouds)
        }

        Component {
            id: cloud_template

            Image {
                id: cloud

                source: "cloud.png"
                x: Math.random()*100
                y: Math.random()*clouds.height
                scale: Math.random()+0.5
                smooth: true
                opacity: 0
                Component.onCompleted: opacity = Math.random()+0.2
                Behavior on opacity {NumberAnimation { duration: 1000; easing.type: Easing.InOutQuad }}

                Timer {
                    property real velocity: clouds.velocity*cloud.scale

                    interval: 16
                    repeat: true
                    running: true
                    onTriggered: cloud.x += velocity
                }
            }
        }
    }

}
