function mv(from, to) {
  for (let [key, value] of Object.entries(from)) {
    to[key] = value;
  }
}

function clear(obj) {
  for (let key of Array.from(Object.keys(obj))) {
    delete obj[key];
  }
}

module.exports = function stealth(cacheObject, cb) {
  let orig = Object.create(null);

  mv(cacheObject, orig)
  clear(cacheObject)

  let res = cb();

  clear(cacheObject)
  mv(orig, cacheObject)

  return res;
};
