# emacs: -*- mode: python; py-indent-offset: 4; indent-tabs-mode: nil -*-
# vi: set ft=python sts=4 ts=4 sw=4 et:

import numpy as np


# number of scans in design (rows in design matrix)
N_ROWS = 191


# This is the alternative design to the standard, here called
# 'description'
# subj3_evt_fonc1.txt
altdescr = {'block':'''time,sentence,speaker
2.0,SSt,SSp
5.33,SSt,SSp
8.67,SSt,SSp
12.0,SSt,SSp
15.33,SSt,SSp
18.67,SSt,SSp
31.0,SSt,SSp
34.33,SSt,SSp
37.67,SSt,SSp
41.0,SSt,SSp
44.33,SSt,SSp
47.67,SSt,SSp
60.0,SSt,DSp
63.33,SSt,DSp
66.67,SSt,DSp
70.0,SSt,DSp
73.33,SSt,DSp
76.67,SSt,DSp
89.0,DSt,SSp
92.33,DSt,SSp
95.67,DSt,SSp
99.0,DSt,SSp
102.33,DSt,SSp
105.67,DSt,SSp
118.0,DSt,DSp
121.33,DSt,DSp
124.67,DSt,DSp
128.0,DSt,DSp
131.33,DSt,DSp
134.67,DSt,DSp
147.0,DSt,DSp
150.33,DSt,DSp
153.67,DSt,DSp
157.0,DSt,DSp
160.33,DSt,DSp
163.67,DSt,DSp
176.0,DSt,SSp
179.33,DSt,SSp
182.67,DSt,SSp
186.0,DSt,SSp
189.33,DSt,SSp
192.67,DSt,SSp
205.0,SSt,DSp
208.33,SSt,DSp
211.67,SSt,DSp
215.0,SSt,DSp
218.33,SSt,DSp
221.67,SSt,DSp
234.0,SSt,DSp
237.33,SSt,DSp
240.67,SSt,DSp
244.0,SSt,DSp
247.33,SSt,DSp
250.67,SSt,DSp
263.0,DSt,SSp
266.33,DSt,SSp
269.67,DSt,SSp
273.0,DSt,SSp
276.33,DSt,SSp
279.67,DSt,SSp
292.0,SSt,SSp
295.33,SSt,SSp
298.67,SSt,SSp
302.0,SSt,SSp
305.33,SSt,SSp
308.67,SSt,SSp
321.0,DSt,DSp
324.33,DSt,DSp
327.67,DSt,DSp
331.0,DSt,DSp
334.33,DSt,DSp
337.67,DSt,DSp
350.0,SSt,SSp
353.33,SSt,SSp
356.67,SSt,SSp
360.0,SSt,SSp
363.33,SSt,SSp
366.67,SSt,SSp
379.0,DSt,SSp
382.33,DSt,SSp
385.67,DSt,SSp
389.0,DSt,SSp
392.33,DSt,SSp
395.67,DSt,SSp
408.0,SSt,DSp
411.33,SSt,DSp
414.67,SSt,DSp
418.0,SSt,DSp
421.33,SSt,DSp
424.67,SSt,DSp
437.0,DSt,DSp
440.33,DSt,DSp
443.67,DSt,DSp
447.0,DSt,DSp
450.33,DSt,DSp
453.67,DSt,DSp''',
'event':'''time,sentence,speaker
2.0,DSt,DSp
5.33,SSt,SSp
8.67,DSt,SSp
12.0,DSt,DSp
15.33,SSt,DSp
18.67,DSt,SSp
22.0,SSt,SSp
25.33,DSt,SSp
28.67,SSt,SSp
32.0,SSt,DSp
35.33,SSt,SSp
38.67,SSt,DSp
42.0,DSt,DSp
45.33,SSt,SSp
48.67,DSt,SSp
52.0,SSt,DSp
55.33,SSt,SSp
58.67,DSt,SSp
62.0,DSt,DSp
65.33,SSt,SSp
68.67,DSt,SSp
72.0,SSt,SSp
75.33,SSt,DSp
78.67,DSt,DSp
82.0,SSt,SSp
85.33,DSt,DSp
88.67,SSt,SSp
92.0,DSt,DSp
95.33,DSt,SSp
98.67,DSt,DSp
102.0,DSt,SSp
105.33,SSt,SSp
108.67,SSt,DSp
112.0,DSt,DSp
115.33,SSt,DSp
118.67,SSt,SSp
122.0,DSt,SSp
125.33,DSt,DSp
128.67,DSt,SSp
132.0,DSt,DSp
135.33,DSt,SSp
138.67,SSt,DSp
142.0,DSt,DSp
145.33,SSt,SSp
148.67,SSt,DSp
152.0,SSt,SSp
155.33,SSt,DSp
158.67,SSt,SSp
162.0,SSt,DSp
165.33,DSt,SSp
168.67,SSt,SSp
172.0,DSt,SSp
175.33,DSt,DSp
178.67,SSt,SSp
182.0,DSt,DSp
185.33,SSt,DSp
188.67,SSt,SSp
192.0,SSt,DSp
195.33,SSt,SSp
198.67,DSt,DSp
202.0,SSt,DSp
205.33,DSt,SSp
208.67,DSt,DSp
212.0,SSt,SSp
215.33,SSt,DSp
218.67,DSt,SSp
222.0,SSt,SSp
225.33,DSt,DSp
228.67,SSt,SSp
232.0,DSt,DSp
235.33,DSt,SSp
238.67,DSt,DSp
242.0,SSt,SSp
245.33,DSt,DSp
248.67,SSt,DSp
252.0,DSt,SSp
255.33,DSt,DSp
258.67,SSt,DSp
262.0,DSt,DSp
265.33,DSt,SSp
268.67,DSt,DSp
272.0,DSt,SSp
275.33,DSt,DSp
278.67,SSt,SSp
282.0,DSt,SSp
285.33,SSt,DSp
288.67,DSt,DSp
292.0,DSt,SSp
295.33,SSt,DSp
298.67,DSt,DSp
302.0,DSt,SSp
305.33,SSt,DSp
308.67,DSt,SSp
312.0,SSt,DSp
315.33,SSt,SSp
318.67,DSt,SSp
322.0,SSt,SSp
325.33,DSt,DSp
328.67,SSt,SSp
332.0,SSt,DSp
335.33,SSt,SSp
338.67,DSt,SSp
342.0,DSt,DSp
345.33,SSt,DSp
348.67,DSt,DSp
352.0,SSt,DSp
355.33,SSt,SSp
358.67,DSt,DSp
362.0,SSt,DSp
365.33,DSt,SSp
368.67,SSt,DSp
372.0,DSt,SSp
375.33,DSt,DSp
378.67,DSt,SSp
382.0,SSt,SSp
385.33,SSt,DSp
388.67,DSt,SSp
392.0,SSt,SSp
395.33,SSt,DSp
398.67,DSt,SSp
402.0,DSt,DSp
405.33,DSt,SSp
408.67,SSt,SSp
412.0,DSt,SSp
415.33,SSt,SSp
418.67,DSt,DSp
422.0,DSt,SSp
425.33,SSt,DSp
428.67,SSt,SSp
432.0,DSt,DSp
435.33,SSt,DSp
438.67,SSt,SSp
442.0,DSt,DSp
445.33,SSt,DSp
448.67,DSt,SSp
452.0,DSt,DSp
455.33,SSt,DSp
458.67,DSt,SSp
462.0,SSt,SSp
465.33,DSt,DSp
468.67,SSt,SSp'''}

# convert altdescr to recarray for convenience
converters = float, str, str
for key, value in altdescr.items():
    lines = value.split('\n')
    names = lines.pop(0).strip().split(',')
    dtype = np.dtype(zip(names, ('f8', 'S3', 'S3')))
    rec = np.recarray(shape=(len(lines),), dtype=dtype)
    for i, line in enumerate(lines):
        vals = line.strip().split(',')
        for name, val, conv in zip(names, vals, converters):
            rec[i][name] = conv(val)
    altdescr[key] = rec


# standard analysis onsets
event_dict = {1:'SSt_SSp', 2:'SSt_DSp', 3:'DSt_SSp', 4:'DSt_DSp'}

descriptions = {'event':"""
  2.00    4 
  5.33    1 
  8.67    3 
 12.00    4 
 15.33    2 
 18.67    3 
 22.00    1 
 25.33    3 
 28.67    1 
 32.00    2 
 35.33    1 
 38.67    2 
 42.00    4 
 45.33    1 
 48.67    3 
 52.00    2 
 55.33    1 
 58.67    3 
 62.00    4 
 65.33    1 
 68.67    3 
 72.00    1 
 75.33    2 
 78.67    4 
 82.00    1 
 85.33    4 
 88.67    1 
 92.00    4 
 95.33    3 
 98.67    4 
102.00    3 
105.33    1 
108.67    2 
112.00    4 
115.33    2 
118.67    1 
122.00    3 
125.33    4 
128.67    3 
132.00    4 
135.33    3 
138.67    2 
142.00    4 
145.33    1 
148.67    2 
152.00    1 
155.33    2 
158.67    1 
162.00    2 
165.33    3 
168.67    1 
172.00    3 
175.33    4 
178.67    1 
182.00    4 
185.33    2 
188.67    1 
192.00    2 
195.33    1 
198.67    4 
202.00    2 
205.33    3 
208.67    4 
212.00    1 
215.33    2 
218.67    3 
222.00    1 
225.33    4 
228.67    1 
232.00    4 
235.33    3 
238.67    4 
242.00    1 
245.33    4 
248.67    2 
252.00    3 
255.33    4 
258.67    2 
262.00    4 
265.33    3 
268.67    4 
272.00    3 
275.33    4 
278.67    1 
282.00    3 
285.33    2 
288.67    4 
292.00    3 
295.33    2 
298.67    4 
302.00    3 
305.33    2 
308.67    3 
312.00    2 
315.33    1 
318.67    3 
322.00    1 
325.33    4 
328.67    1 
332.00    2 
335.33    1 
338.67    3 
342.00    4 
345.33    2 
348.67    4 
352.00    2 
355.33    1 
358.67    4 
362.00    2 
365.33    3 
368.67    2 
372.00    3 
375.33    4 
378.67    3 
382.00    1 
385.33    2 
388.67    3 
392.00    1 
395.33    2 
398.67    3 
402.00    4 
405.33    3 
408.67    1 
412.00    3 
415.33    1 
418.67    4 
422.00    3 
425.33    2 
428.67    1 
432.00    4 
435.33    2 
438.67    1 
442.00    4 
445.33    2 
448.67    3 
452.00    4 
455.33    2 
458.67    3 
462.00    1 
465.33    4 
468.67    1 
""",
# subj3_bloc_fonc3.txt
'block':"""
  2.00    1 
  5.33    1 
  8.67    1 
 12.00    1 
 15.33    1 
 18.67    1 
 31.00    1 
 34.33    1 
 37.67    1 
 41.00    1 
 44.33    1 
 47.67    1 
 60.00    2 
 63.33    2 
 66.67    2 
 70.00    2 
 73.33    2 
 76.67    2 
 89.00    3 
 92.33    3 
 95.67    3 
 99.00    3 
102.33    3 
105.67    3 
118.00    4 
121.33    4 
124.67    4 
128.00    4 
131.33    4 
134.67    4 
147.00    4 
150.33    4 
153.67    4 
157.00    4 
160.33    4 
163.67    4 
176.00    3 
179.33    3 
182.67    3 
186.00    3 
189.33    3 
192.67    3 
205.00    2 
208.33    2 
211.67    2 
215.00    2 
218.33    2 
221.67    2 
234.00    2 
237.33    2 
240.67    2 
244.00    2 
247.33    2 
250.67    2 
263.00    3 
266.33    3 
269.67    3 
273.00    3 
276.33    3 
279.67    3 
292.00    1 
295.33    1 
298.67    1 
302.00    1 
305.33    1 
308.67    1 
321.00    4 
324.33    4 
327.67    4 
331.00    4 
334.33    4 
337.67    4 
350.00    1 
353.33    1 
356.67    1 
360.00    1 
363.33    1 
366.67    1 
379.00    3 
382.33    3 
385.67    3 
389.00    3 
392.33    3 
395.67    3 
408.00    2 
411.33    2 
414.67    2 
418.00    2 
421.33    2 
424.67    2 
437.00    4 
440.33    4 
443.67    4 
447.00    4 
450.33    4 
453.67    4 
"""}

# convert to record array for convenience
dtype = np.dtype([('time', np.float), ('event', 'S7')])
for key, txt in descriptions.items():
    vals = np.fromstring(txt, sep='\t').reshape(-1, 2)
    full_def = np.zeros((vals.shape[0],), dtype=dtype)
    for i, row in enumerate(vals):
        full_def[i]['time' ] = row[0]
        full_def[i]['event'] = event_dict[row[1]]
    descriptions[key] = full_def


# fmristat designs, probably saved from matlab to ascii
fmristat = {'block':
"""
   0.0000000000000000e+00	   1.7972165294585549e-07	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	  -7.0891758549395515e-07	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	   1.0000000000000000e+00	  -1.0000000000000000e+00	   1.0000000000000000e+00	  -1.0000000000000000e+00	  -0.0000000000000000e+00	  -3.9964378119605467e+07	
   2.4177346180074877e-02	   5.9438222395961854e-03	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	  -1.7549188213126270e-02	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	   1.0000000000000000e+00	  -9.8947368421052628e-01	   9.7905817174515231e-01	  -9.6875229625309800e-01	  -0.0000000000000000e+00	  -3.9964295632754065e+07	
   2.9724288489710671e-01	   6.7859854151592250e-02	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	  -1.2825364543031706e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	   1.0000000000000000e+00	  -9.7894736842105268e-01	   9.5833795013850420e-01	  -9.3816241434611469e-01	  -0.0000000000000000e+00	  -3.9964008717195466e+07	
   2.5803044610535053e-01	   2.0702131854989700e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	  -2.2538113774670057e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	   1.0000000000000000e+00	  -9.6842105263157896e-01	   9.3783933518005547e-01	  -9.0822335617436944e-01	  -0.0000000000000000e+00	  -3.9963382251577556e+07	
   1.5480779827902719e-02	   3.5555300272627366e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	  -1.5615934487315666e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	   1.0000000000000000e+00	  -9.5789473684210524e-01	   9.1756232686980610e-01	  -8.7892812363318262e-01	  -0.0000000000000000e+00	  -3.9962264238541424e+07	
  -8.5092843112443153e-02	   4.1993036162424330e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	  -1.0730035819227872e-03	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	   1.0000000000000000e+00	  -9.4736842105263153e-01	   8.9750692520775610e-01	  -8.5026971861787415e-01	  -0.0000000000000000e+00	  -3.9960523102045782e+07	
  -6.7344467282778389e-02	   3.9648730685263067e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	   6.4795239339487262e-02	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	   1.0000000000000000e+00	  -9.3684210526315792e-01	   8.7767313019390591e-01	  -8.2224114302376450e-01	  -0.0000000000000000e+00	  -3.9958030461220443e+07	
  -3.0859121798647051e-02	   3.4988988278635952e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	   5.1950746816847776e-02	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	   1.0000000000000000e+00	  -9.2631578947368420e-01	   8.5806094182825488e-01	  -7.9483539874617293e-01	  -0.0000000000000000e+00	  -3.9954647886381753e+07	
  -1.0398603799754021e-02	   3.0094602992319508e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	   6.9200680125590358e-02	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	   1.0000000000000000e+00	  -9.1578947368421049e-01	   8.3867036011080320e-01	  -7.6804548768041980e-01	  -0.0000000000000000e+00	  -3.9950228902413361e+07	
  -2.8261891016884526e-03	   1.9842544809308393e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	   1.7957629818392778e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	   1.0000000000000000e+00	  -9.0526315789473688e-01	   8.1950138504155134e-01	  -7.4186441172182538e-01	  -0.0000000000000000e+00	  -3.9944630184490673e+07	
  -6.5240578331303358e-04	   4.1333332231519290e-02	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	   2.2566882506564701e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	   1.0000000000000000e+00	  -8.9473684210526316e-01	   8.0055401662049863e-01	  -7.1628517276570935e-01	  -0.0000000000000000e+00	  -3.9937731831733234e+07	
  -1.3230474301884534e-04	  -8.9013361783352618e-02	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	   1.0200288654363485e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	   1.0000000000000000e+00	  -8.8421052631578945e-01	   7.8182825484764540e-01	  -6.9130077270739165e-01	  -0.0000000000000000e+00	  -3.9929402377448291e+07	
  -2.2763919031965966e-05	  -1.1818776925247122e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	  -3.3071814284000439e-02	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	   1.0000000000000000e+00	  -8.7368421052631584e-01	   7.6332409972299176e-01	  -6.6690421344219286e-01	  -0.0000000000000000e+00	  -3.9919467169778965e+07	
   1.1766933934135151e-01	  -5.9145813637303944e-02	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	  -1.1704903409713198e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	   1.0000000000000000e+00	  -8.6315789473684212e-01	   7.4504155124653748e-01	  -6.4308849686543235e-01	  -0.0000000000000000e+00	  -3.9907786847505786e+07	
   3.3915151685855366e-01	   7.8487423349090008e-02	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	  -2.2055846003109769e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	   1.0000000000000000e+00	  -8.5263157894736841e-01	   7.2698060941828258e-01	  -6.1984662487243036e-01	  -0.0000000000000000e+00	  -3.9894241441418923e+07	
   1.5626897220672240e-01	   2.5758459445421755e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	  -2.3727553274059962e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	   1.0000000000000000e+00	  -8.4210526315789469e-01	   7.0914127423822704e-01	  -5.9717159935850694e-01	  -0.0000000000000000e+00	  -3.9878693250274450e+07	
  -4.5889761416029337e-02	   3.9139980364646210e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	  -9.7047116711321060e-02	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	   1.0000000000000000e+00	  -8.3157894736842108e-01	   6.9152354570637120e-01	  -5.7505642221898245e-01	  -0.0000000000000000e+00	  -3.9860998616045773e+07	
  -8.5485466293479639e-02	   4.1644987530692945e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	   3.5079498059630163e-02	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	   1.0000000000000000e+00	  -8.2105263157894737e-01	   6.7412742382271473e-01	  -5.5349409534917626e-01	  -0.0000000000000000e+00	  -3.9841029804515697e+07	
  -5.1613987307140528e-02	   3.7656626544155047e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	   6.4995785276060730e-02	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	   1.0000000000000000e+00	  -8.1052631578947365e-01	   6.5695290858725752e-01	  -5.3247762064440873e-01	  -0.0000000000000000e+00	  -3.9818654567553706e+07	
  -2.0586709118519942e-02	   3.3320587820969133e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	   4.7437405355933771e-02	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	   1.0000000000000000e+00	  -8.0000000000000004e-01	   6.4000000000000012e-01	  -5.1200000000000012e-01	  -0.0000000000000000e+00	  -3.9793725269769594e+07	
  -6.3149871015004810e-03	   2.6901760355826837e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	   1.0881647626783833e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	   1.0000000000000000e+00	  -7.8947368421052633e-01	   6.2326869806094187e-01	  -4.9205423531126991e-01	  -0.0000000000000000e+00	  -3.9766099107882999e+07	
  -1.5998995910758370e-03	   1.3858542822449937e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	   2.1519290836378713e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	   1.0000000000000000e+00	  -7.7894736842105261e-01	   6.0675900277008310e-01	  -4.7263332847353839e-01	  -0.0000000000000000e+00	  -3.9735647326953202e+07	
  -3.4949313513852877e-04	  -1.9968098640650647e-02	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	   1.9284674322244838e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	   1.0000000000000000e+00	  -7.6842105263157889e-01	   5.9047091412742370e-01	  -4.5373028138212557e-01	  -0.0000000000000000e+00	  -3.9702236464460857e+07	
  -6.7774195098072875e-05	  -1.1325358183759204e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	   3.7893132438445457e-02	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	   1.0000000000000000e+00	  -7.5789473684210529e-01	   5.7440443213296399e-01	  -4.3533809593235173e-01	  -0.0000000000000000e+00	  -3.9665728276365325e+07	
   5.6890986261887112e-03	  -1.0696208513639913e-01	   2.4632390461375082e-03	   0.0000000000000000e+00	   0.0000000000000000e+00	  -5.6615568209656034e-02	  -7.8171058742844777e-03	   0.0000000000000000e+00	   0.0000000000000000e+00	   1.0000000000000000e+00	  -7.4736842105263157e-01	   5.5855955678670355e-01	  -4.1744977401953637e-01	  -0.0000000000000000e+00	  -3.9625947171426475e+07	
   2.4618481081097995e-01	  -6.1272673063231448e-02	   4.8820311055440317e-02	   0.0000000000000000e+00	   0.0000000000000000e+00	  -5.8086735980862475e-02	  -1.0183399555242575e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	   1.0000000000000000e+00	  -7.3684210526315785e-01	   5.4293628808864258e-01	  -4.0005831753899979e-01	  -0.0000000000000000e+00	  -3.9582766803961083e+07	
   2.9953964554960644e-01	  -2.5547441406802145e-02	   1.7507033112252593e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	  -3.0993666067196276e-02	  -2.1612831441918828e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	   1.0000000000000000e+00	  -7.2631578947368425e-01	   5.2753462603878121e-01	  -3.8315672838606218e-01	  -0.0000000000000000e+00	  -3.9536072560850807e+07	
   5.7109131744450661e-02	  -8.4051340693276771e-03	   3.2987495754170404e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	  -1.1758010932446473e-02	  -1.8320362885086547e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	   1.0000000000000000e+00	  -7.1578947368421053e-01	   5.1235457063711909e-01	  -3.6673800845604315e-01	  -0.0000000000000000e+00	  -3.9485728182394587e+07	
  -7.8184230485700307e-02	  -2.2938316718133949e-03	   4.1619910711870090e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	  -3.5232574314479738e-03	  -2.7189893305956774e-02	   0.0000000000000000e+00	   0.0000000000000000e+00	   1.0000000000000000e+00	  -7.0526315789473681e-01	   4.9739612188365645e-01	  -3.5079515964426300e-01	  -0.0000000000000000e+00	  -3.9431584623730086e+07	
  -7.4737010936004322e-02	  -5.3798391262850328e-04	   4.0522771221040943e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	  -8.8267150904121708e-04	   5.8945294122267095e-02	   0.0000000000000000e+00	   0.0000000000000000e+00	   1.0000000000000000e+00	  -6.9473684210526321e-01	   4.8265927977839340e-01	  -3.3532118384604176e-01	  -0.0000000000000000e+00	  -3.9373503040717266e+07	
  -3.7125986784173719e-02	  -1.1129983958096788e-04	   3.5823603012410249e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	  -1.9175152461996296e-04	   5.6583906662152982e-02	   0.0000000000000000e+00	   0.0000000000000000e+00	   1.0000000000000000e+00	  -6.8421052631578949e-01	   4.6814404432132967e-01	  -3.2030908295669924e-01	  -0.0000000000000000e+00	  -3.9311345987254620e+07	
  -1.3178061904414793e-02	  -2.0616437121920034e-05	   3.1330364005523526e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	  -3.6864262677767610e-05	   5.6795794533862881e-02	   0.0000000000000000e+00	   0.0000000000000000e+00	   1.0000000000000000e+00	  -6.7368421052631577e-01	   4.5385041551246535e-01	  -3.0575185887155559e-01	  -0.0000000000000000e+00	  -3.9244973542355932e+07	
  -3.7205065395061786e-03	  -3.5244398305267092e-06	   2.2498345090173064e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	  -6.4936311517650639e-06	   1.5701149313902130e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	   1.0000000000000000e+00	  -6.6315789473684206e-01	   4.3977839335180047e-01	  -2.9164251348593084e-01	  -0.0000000000000000e+00	  -3.9174248924560487e+07	
  -8.8460183856306875e-04	  -5.1822314315757625e-07	   7.3882604017788261e-02	   0.0000000000000000e+00	   0.0000000000000000e+00	  -9.7632309208494808e-07	   2.2974705727631178e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	   1.0000000000000000e+00	  -6.5263157894736845e-01	   4.2592797783933523e-01	  -2.7797404869514508e-01	  -0.0000000000000000e+00	  -3.9099039317975588e+07	
  -1.8370553324891862e-04	   0.0000000000000000e+00	  -7.0043906737830369e-02	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	   1.3510500812682708e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	   1.0000000000000000e+00	  -6.4210526315789473e-01	   4.1229916897506924e-01	  -2.6473946639451817e-01	  -0.0000000000000000e+00	  -3.9019207925871357e+07	
  -3.4179300052400812e-05	   0.0000000000000000e+00	  -1.2022600095442171e-01	   1.4728700311903286e-05	   0.0000000000000000e+00	   0.0000000000000000e+00	  -1.3519940771543261e-02	  -5.5984441974886700e-05	   0.0000000000000000e+00	   1.0000000000000000e+00	  -6.3157894736842102e-01	   3.9889196675900274e-01	  -2.5193176847937016e-01	  -0.0000000000000000e+00	  -3.8934600623322882e+07	
   6.1977227981245921e-02	   0.0000000000000000e+00	  -8.9600939014954029e-02	   1.1919836474499302e-02	   0.0000000000000000e+00	   0.0000000000000000e+00	  -6.4884679517546728e-02	  -3.2555493185429440e-02	   0.0000000000000000e+00	   1.0000000000000000e+00	  -6.2105263157894741e-01	   3.8570637119113577e-01	  -2.3954395684502119e-01	  -0.0000000000000000e+00	  -3.8845083451900810e+07	
   3.2914194698808724e-01	   0.0000000000000000e+00	  -4.4610650244984916e-02	   9.0274941429971764e-02	   0.0000000000000000e+00	   0.0000000000000000e+00	  -4.7586436324094594e-02	  -1.5426326998121220e-01	   0.0000000000000000e+00	   1.0000000000000000e+00	  -6.1052631578947369e-01	   3.7274238227146816e-01	  -2.2756903338679108e-01	  -0.0000000000000000e+00	  -3.8750522818035603e+07	
   2.0869631953634510e-01	   0.0000000000000000e+00	  -1.6794634932976529e-02	   2.3929665270590575e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	  -2.1745661626648261e-02	  -2.2651021459888929e-01	   0.0000000000000000e+00	   1.0000000000000000e+00	  -5.9999999999999998e-01	   3.5999999999999999e-01	  -2.1599999999999997e-01	  -0.0000000000000000e+00	  -3.8650779152144141e+07	
  -1.8988164869436275e-02	   0.0000000000000000e+00	  -5.1018176378398936e-03	   3.7764046922164829e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	  -7.4407761527462875e-03	  -1.2483558646645473e-01	   0.0000000000000000e+00	   1.0000000000000000e+00	  -5.8947368421052626e-01	   3.4747922437673123e-01	  -2.0482985857996788e-01	  -0.0000000000000000e+00	  -3.8545724148709796e+07	
  -8.7172921748424712e-02	   0.0000000000000000e+00	  -1.3055419048209041e-03	   4.2010747575335811e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	  -2.0641445077479018e-03	   2.0039325175152698e-02	   0.0000000000000000e+00	   1.0000000000000000e+00	  -5.7894736842105265e-01	   3.3518005540166207e-01	  -1.9405161102201490e-01	  -0.0000000000000000e+00	  -3.8435214400087699e+07	
  -5.9479346491040953e-02	   0.0000000000000000e+00	  -2.9049537695812611e-04	   3.8676128528650705e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	  -4.8684122664065948e-04	   6.6822940192205887e-02	   0.0000000000000000e+00	   1.0000000000000000e+00	  -5.6842105263157894e-01	   3.2310249307479222e-01	  -1.8365825922146084e-01	  -0.0000000000000000e+00	  -3.8319113881397702e+07	
  -2.5344894340844023e-02	   0.0000000000000000e+00	  -5.7519918573519355e-05	   3.4173267838996024e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	  -1.0071519927700912e-04	   4.8590711578671605e-02	   0.0000000000000000e+00	   1.0000000000000000e+00	  -5.5789473684210522e-01	   3.1124653739612185e-01	  -1.7364280507362584e-01	  -0.0000000000000000e+00	  -3.8197280698436156e+07	
  -8.1360247239318281e-03	   0.0000000000000000e+00	  -1.0271890012879138e-05	   2.8635449602721674e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	  -1.8603553893817027e-05	   8.6957892817575433e-02	   0.0000000000000000e+00	   1.0000000000000000e+00	  -5.4736842105263162e-01	   2.9961218836565101e-01	  -1.6399825047383004e-01	  -0.0000000000000000e+00	  -3.8069578593331799e+07	
  -2.1329811439999668e-03	   0.0000000000000000e+00	  -1.5726052562367482e-06	   1.6942030072831732e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	  -2.9207518307516431e-06	   1.9932735803028329e-01	   0.0000000000000000e+00	   1.0000000000000000e+00	  -5.3684210526315790e-01	   2.8819944598337949e-01	  -1.5471759731739321e-01	  -0.0000000000000000e+00	  -3.7935869323744483e+07	
  -4.7868580374672127e-04	   0.0000000000000000e+00	  -2.4393255686410929e-07	   9.7342091717260160e-03	   0.0000000000000000e+00	   0.0000000000000000e+00	  -4.6354368728304449e-07	   2.1317803332965357e-01	   0.0000000000000000e+00	   1.0000000000000000e+00	  -5.2631578947368418e-01	   2.7700831024930744e-01	  -1.4579384749963548e-01	  -0.0000000000000000e+00	  -3.7796023122095928e+07	
  -9.4885576906897671e-05	   0.0000000000000000e+00	   0.0000000000000000e+00	  -1.0342703349042752e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	   6.8989839045089055e-02	   0.0000000000000000e+00	   1.0000000000000000e+00	  -5.1578947368421058e-01	   2.6603878116343493e-01	  -1.3722000291587699e-01	  -0.0000000000000000e+00	  -3.7649889965446725e+07	
   4.6549987495046264e-04	   0.0000000000000000e+00	   0.0000000000000000e+00	  -1.1370885399932430e-01	   7.7849954623234125e-04	   0.0000000000000000e+00	   0.0000000000000000e+00	  -4.6780737173119882e-02	  -2.6406827272240662e-03	   1.0000000000000000e+00	  -5.0526315789473686e-01	   2.5529085872576179e-01	  -1.2898906546143754e-01	  -0.0000000000000000e+00	  -3.7497316265670031e+07	
   1.8286923577271125e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	  -7.0505792246302060e-02	   3.3178956057083007e-02	   0.0000000000000000e+00	   0.0000000000000000e+00	  -6.2077599161047464e-02	  -7.6128408846089957e-02	   1.0000000000000000e+00	  -4.9473684210526314e-01	   2.4476454293628808e-01	  -1.2109403703163725e-01	  -0.0000000000000000e+00	  -3.7338169264406279e+07	
   3.2815365238396688e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	  -3.1075379328076348e-02	   1.4440180014681392e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	  -3.6293517323374769e-02	  -1.9992737502479768e-01	   1.0000000000000000e+00	  -4.8421052631578948e-01	   2.3445983379501387e-01	  -1.1352791952179618e-01	  -0.0000000000000000e+00	  -3.7172326619055934e+07	
   1.0472734947167857e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	  -1.0670392954156069e-02	   3.0145227582186795e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	  -1.4579521804191179e-02	  -2.0462195254207211e-01	   1.0000000000000000e+00	  -4.7368421052631576e-01	   2.2437673130193903e-01	  -1.0628371482723427e-01	  -0.0000000000000000e+00	  -3.6999660033267289e+07	
  -6.5414735178786182e-02	   0.0000000000000000e+00	   0.0000000000000000e+00	  -3.0133373947628865e-03	   4.0816930917890015e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	  -4.5547919780519388e-03	  -5.7811109467925295e-02	   1.0000000000000000e+00	  -4.6315789473684210e-01	   2.1451523545706372e-01	  -9.9354424843271616e-02	  -0.0000000000000000e+00	  -3.6820030059284538e+07	
  -8.1039296440989866e-02	   0.0000000000000000e+00	   0.0000000000000000e+00	  -7.2674473172627254e-04	   4.1235355967765930e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	  -1.1786336808960263e-03	   4.9499274042558168e-02	   1.0000000000000000e+00	  -4.5263157894736844e-01	   2.0487534626038784e-01	  -9.2733051465228172e-02	  -0.0000000000000000e+00	  -3.6633274691983856e+07	
  -4.4087905632133433e-02	   0.0000000000000000e+00	   0.0000000000000000e+00	  -1.5386856254847681e-04	   3.6716665813617538e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	  -2.6278123722066446e-04	   6.1468774353944371e-02	   1.0000000000000000e+00	  -4.4210526315789472e-01	   1.9545706371191135e-01	  -8.6412596588423957e-02	  -0.0000000000000000e+00	  -3.6439258355741180e+07	
  -1.6550422413122053e-02	   0.0000000000000000e+00	   0.0000000000000000e+00	  -2.9267163684834725e-05	   3.2392301620679653e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	  -5.2002150652398645e-05	   4.9847666173530675e-02	   1.0000000000000000e+00	  -4.3157894736842106e-01	   1.8626038781163437e-01	  -8.0386062108179043e-02	  -0.0000000000000000e+00	  -3.6237849955159605e+07	
  -4.8645759144098875e-03	   0.0000000000000000e+00	   0.0000000000000000e+00	  -5.0502559169199467e-06	   2.4859549248739221e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	  -9.2540988607474148e-06	   1.3286328271100897e-01	   1.0000000000000000e+00	  -4.2105263157894735e-01	   1.7728531855955676e-01	  -7.4646449919813368e-02	  -0.0000000000000000e+00	  -3.6028915291220829e+07	
  -1.1930031026986410e-03	   0.0000000000000000e+00	   0.0000000000000000e+00	  -7.5235207367785176e-07	   1.0653571529948751e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	  -1.4109555146948659e-06	   2.2584550280153473e-01	   1.0000000000000000e+00	  -4.1052631578947368e-01	   1.6853185595567868e-01	  -6.9186761918647033e-02	  -0.0000000000000000e+00	  -3.5812314029410847e+07	
  -2.5396202412826985e-04	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	  -4.6832193791313273e-02	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	   1.6614010275431002e-01	   1.0000000000000000e+00	  -4.0000000000000002e-01	   1.6000000000000003e-01	  -6.4000000000000015e-02	  -0.0000000000000000e+00	  -3.5587902398848765e+07	
  -4.8220518125413127e-05	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	  -1.1871326011304753e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	   1.0090386571392081e-02	   1.0000000000000000e+00	  -3.8947368421052631e-01	   1.5168975069252078e-01	  -5.9079166059192299e-02	  -0.0000000000000000e+00	  -3.5355541558413237e+07	
   2.4169016536933870e-02	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	  -9.2791475308364513e-02	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	  -8.0004825585489200e-02	   1.0000000000000000e+00	  -3.7894736842105264e-01	   1.4360110803324100e-01	  -5.4417261991543966e-02	  -0.0000000000000000e+00	  -3.5115099058204055e+07	
   2.9724155612227232e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	   1.5270927425803231e-02	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	  -1.8135969165363014e-01	   1.0000000000000000e+00	  -3.6842105263157893e-01	   1.3573407202216065e-01	  -5.0007289692374973e-02	  -0.0000000000000000e+00	  -3.4866436158003025e+07	
   2.5803024806313540e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	   1.8621478092052027e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	  -2.5150110948521948e-01	   1.0000000000000000e+00	  -3.5789473684210527e-01	   1.2808864265927977e-01	  -4.5842251057005394e-02	  -0.0000000000000000e+00	  -3.4609428135132596e+07	
   1.5480751995147656e-02	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	   3.4898126191507456e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	  -1.6555402474497252e-01	   1.0000000000000000e+00	  -3.4736842105263160e-01	   1.2066481994459835e-01	  -4.1915147980755220e-02	  -0.0000000000000000e+00	  -3.4343941110639565e+07	
  -8.5092846828545440e-02	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	   4.1819492389675139e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	  -3.7787005240121178e-03	   1.0000000000000000e+00	  -3.3684210526315789e-01	   1.1346260387811634e-01	  -3.8218982358944449e-02	  -0.0000000000000000e+00	  -3.4069813706143320e+07	
  -6.7344467282778389e-02	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	   3.9609103273326435e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	   6.4137932796112615e-02	   1.0000000000000000e+00	  -3.2631578947368423e-01	   1.0648199445983381e-01	  -3.4746756086893135e-02	  -0.0000000000000000e+00	  -3.3786908936772466e+07	
  -3.0859121798647051e-02	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	   3.4980970938405542e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	   5.1811469414551475e-02	   1.0000000000000000e+00	  -3.1578947368421051e-01	   9.9722991689750684e-02	  -3.1491471059921269e-02	  -0.0000000000000000e+00	  -3.3495079538397674e+07	
  -1.0398603799754021e-02	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	   3.0093145263337484e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	   6.9174443414894288e-02	   1.0000000000000000e+00	  -3.0526315789473685e-01	   9.3185595567867041e-02	  -2.8446129173348884e-02	  -0.0000000000000000e+00	  -3.3194207260061242e+07	
  -2.8261891016884526e-03	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	   1.9842318427908845e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	   1.7957211533156259e-01	   1.0000000000000000e+00	  -2.9473684210526313e-01	   8.6869806094182808e-02	  -2.5603732322495985e-02	  -0.0000000000000000e+00	  -3.2884149286440846e+07	
  -6.5240578331303358e-04	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	   4.1332976227096016e-02	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	   2.2566815140637572e-01	   1.0000000000000000e+00	  -2.8421052631578947e-01	   8.0775623268698055e-02	  -2.2957282402682605e-02	  -0.0000000000000000e+00	  -3.2564763542401820e+07	
  -1.3230474301884534e-04	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	  -8.9013361783352618e-02	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	   1.0200288654363485e-01	   1.0000000000000000e+00	  -2.7368421052631581e-01	   7.4903047091412753e-02	  -2.0499781309228755e-02	  -0.0000000000000000e+00	  -3.2235910996290851e+07	
  -2.2763919031965966e-05	   0.0000000000000000e+00	   0.0000000000000000e+00	   1.5963017835031278e-04	  -1.1834739943082154e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	  -5.7534210508715421e-04	  -3.2496472178913285e-02	   1.0000000000000000e+00	  -2.6315789473684209e-01	   6.9252077562326861e-02	  -1.8224230937454435e-02	  -0.0000000000000000e+00	  -3.1897453852406133e+07	
   1.1766933934135151e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	   2.0909077918752295e-02	  -8.0054891556056232e-02	   0.0000000000000000e+00	   0.0000000000000000e+00	  -5.2504663312063840e-02	  -6.4544370785068139e-02	   1.0000000000000000e+00	  -2.5263157894736843e-01	   6.3822714681440448e-02	  -1.6123633182679693e-02	  -0.0000000000000000e+00	  -3.1549256225830898e+07	
   3.3915151685855366e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	   1.1591503626231370e-01	  -3.7427612913223690e-02	   0.0000000000000000e+00	   0.0000000000000000e+00	  -1.7866822805253882e-01	  -4.1890231978558873e-02	   1.0000000000000000e+00	  -2.4210526315789474e-01	   5.8614958448753467e-02	  -1.4190989940224523e-02	  -0.0000000000000000e+00	  -3.1191183393587172e+07	
   1.5626897220672240e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	   2.7102589539944072e-01	  -1.3441300945223146e-02	   0.0000000000000000e+00	   0.0000000000000000e+00	  -2.1937554065255879e-01	  -1.7899992088040828e-02	   1.0000000000000000e+00	  -2.3157894736842105e-01	   5.3628808864265930e-02	  -1.2419303105408952e-02	  -0.0000000000000000e+00	  -3.0823097233739205e+07	
  -4.5889761416029337e-02	   0.0000000000000000e+00	   0.0000000000000000e+00	   3.9533355560952921e-01	  -3.9337519630671123e-03	   0.0000000000000000e+00	   0.0000000000000000e+00	  -9.1202571282810271e-02	  -5.8445454285107907e-03	   1.0000000000000000e+00	  -2.2105263157894736e-01	   4.8864265927977837e-02	  -1.0801574573552995e-02	  -0.0000000000000000e+00	  -3.0444855215506077e+07	
  -8.5485466293479639e-02	   0.0000000000000000e+00	   0.0000000000000000e+00	   4.1742655305133147e-01	  -9.7667774440200706e-04	   0.0000000000000000e+00	   0.0000000000000000e+00	   3.6644079357620526e-02	  -1.5645812979903574e-03	   1.0000000000000000e+00	  -2.1052631578947367e-01	   4.4321329639889190e-02	  -9.3308062399766710e-03	  -0.0000000000000000e+00	  -3.0056331771375515e+07	
  -5.1613987307140528e-02	   0.0000000000000000e+00	   0.0000000000000000e+00	   3.7677806853318929e-01	  -2.1180309163878829e-04	   0.0000000000000000e+00	   0.0000000000000000e+00	   6.5354184877135096e-02	  -3.5839960107434895e-04	   1.0000000000000000e+00	  -2.0000000000000001e-01	   4.0000000000000008e-02	  -8.0000000000000019e-03	  -0.0000000000000000e+00	  -2.9657376031923760e+07	
  -2.0586709118519942e-02	   0.0000000000000000e+00	   0.0000000000000000e+00	   3.3324698528225988e-01	  -4.1107072568475722e-05	   0.0000000000000000e+00	   0.0000000000000000e+00	   4.7509924533272796e-02	  -7.2519177339011736e-05	   1.0000000000000000e+00	  -1.8947368421052632e-01	   3.5900277008310250e-02	  -6.8021577489429958e-03	  -0.0000000000000000e+00	  -2.9247849788508385e+07	
  -6.3149871015004810e-03	   0.0000000000000000e+00	   0.0000000000000000e+00	   2.6902481763940428e-01	  -7.2140811359126060e-06	   0.0000000000000000e+00	   0.0000000000000000e+00	   1.0882962004244967e-01	  -1.3143774611327210e-05	   1.0000000000000000e+00	  -1.7894736842105263e-01	   3.2022160664819943e-02	  -5.7302813821256742e-03	  -0.0000000000000000e+00	  -2.8827620597817719e+07	
  -1.5998995910758370e-03	   0.0000000000000000e+00	   0.0000000000000000e+00	   1.3858651749072567e-01	  -1.0892662263073478e-06	   0.0000000000000000e+00	   0.0000000000000000e+00	   2.1519494147264256e-01	  -2.0331088554603621e-06	   1.0000000000000000e+00	  -1.6842105263157894e-01	   2.8365650969529085e-02	  -4.7773727948680561e-03	  -0.0000000000000000e+00	  -2.8396549759912662e+07	
  -3.4949313513852877e-04	   0.0000000000000000e+00	   0.0000000000000000e+00	  -1.9968098640650647e-02	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	   1.9284674322244838e-01	   0.0000000000000000e+00	   1.0000000000000000e+00	  -1.5789473684210525e-01	   2.4930747922437671e-02	  -3.9364338824901587e-03	  -0.0000000000000000e+00	  -2.7954504561053500e+07	
  -6.7774195098072875e-05	   0.0000000000000000e+00	   0.0000000000000000e+00	  -1.1325358183759204e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	   3.7893132438445457e-02	   0.0000000000000000e+00	   1.0000000000000000e+00	  -1.4736842105263157e-01	   2.1717451523545702e-02	  -3.2004665403119982e-03	  -0.0000000000000000e+00	  -2.7501342752012245e+07	
   5.6890986261887112e-03	   0.0000000000000000e+00	   2.4632390461375082e-03	  -1.0696208513639913e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	  -7.8171058742844777e-03	  -5.6615568209656034e-02	   0.0000000000000000e+00	   1.0000000000000000e+00	  -1.3684210526315790e-01	   1.8725761772853188e-02	  -2.5624726636535944e-03	  -0.0000000000000000e+00	  -2.7036898926030204e+07	
   2.4618481081097995e-01	   0.0000000000000000e+00	   4.8820311055440317e-02	  -6.1272673063231448e-02	   0.0000000000000000e+00	   0.0000000000000000e+00	  -1.0183399555242575e-01	  -5.8086735980862475e-02	   0.0000000000000000e+00	   1.0000000000000000e+00	  -1.2631578947368421e-01	   1.5955678670360112e-02	  -2.0154541478349616e-03	  -0.0000000000000000e+00	  -2.6561044027604885e+07	
   2.9953964554960644e-01	   0.0000000000000000e+00	   1.7507033112252593e-01	  -2.5547441406802145e-02	   0.0000000000000000e+00	   0.0000000000000000e+00	  -2.1612831441918828e-01	  -3.0993666067196276e-02	   0.0000000000000000e+00	   1.0000000000000000e+00	  -1.1578947368421053e-01	   1.3407202216066482e-02	  -1.5524128881761190e-03	  -0.0000000000000000e+00	  -2.6073662987834934e+07	
   5.7109131744450661e-02	   0.0000000000000000e+00	   3.2987495754170404e-01	  -8.4051340693276771e-03	   0.0000000000000000e+00	   0.0000000000000000e+00	  -1.8320362885086547e-01	  -1.1758010932446473e-02	   0.0000000000000000e+00	   1.0000000000000000e+00	  -1.0526315789473684e-01	   1.1080332409972297e-02	  -1.1663507799970839e-03	  -0.0000000000000000e+00	  -2.5574620168755420e+07	
  -7.8184230485700307e-02	   0.0000000000000000e+00	   4.1619910711870090e-01	  -2.2938316718133949e-03	   0.0000000000000000e+00	   0.0000000000000000e+00	  -2.7189893305956774e-02	  -3.5232574314479738e-03	   0.0000000000000000e+00	   1.0000000000000000e+00	  -9.4736842105263161e-02	   8.9750692520775624e-03	  -8.5026971861787448e-04	  -0.0000000000000000e+00	  -2.5063768014097415e+07	
  -7.4737010936004322e-02	   0.0000000000000000e+00	   4.0522771221040943e-01	  -5.3798391262850328e-04	   0.0000000000000000e+00	   0.0000000000000000e+00	   5.8945294122267095e-02	  -8.8267150904121708e-04	   0.0000000000000000e+00	   1.0000000000000000e+00	  -8.4210526315789472e-02	   7.0914127423822712e-03	  -5.9717159935850702e-04	  -0.0000000000000000e+00	  -2.4540960104356453e+07	
  -3.7125986784173719e-02	   0.0000000000000000e+00	   3.5823603012410249e-01	  -1.1129983958096788e-04	   0.0000000000000000e+00	   0.0000000000000000e+00	   5.6583906662152982e-02	  -1.9175152461996296e-04	   0.0000000000000000e+00	   1.0000000000000000e+00	  -7.3684210526315783e-02	   5.4293628808864255e-03	  -4.0005831753899977e-04	  -0.0000000000000000e+00	  -2.4006064559022680e+07	
  -1.3178061904414793e-02	   0.0000000000000000e+00	   3.1330364005523526e-01	  -2.0616437121920034e-05	   0.0000000000000000e+00	   0.0000000000000000e+00	   5.6795794533862881e-02	  -3.6864262677767610e-05	   0.0000000000000000e+00	   1.0000000000000000e+00	  -6.3157894736842107e-02	   3.9889196675900280e-03	  -2.5193176847937020e-04	  -0.0000000000000000e+00	  -2.3458940367557507e+07	
  -3.7205065395061786e-03	   0.0000000000000000e+00	   2.2498345090173064e-01	  -3.5244398305267092e-06	   0.0000000000000000e+00	   0.0000000000000000e+00	   1.5701149313902130e-01	  -6.4936311517650639e-06	   0.0000000000000000e+00	   1.0000000000000000e+00	  -5.2631578947368418e-02	   2.7700831024930744e-03	  -1.4579384749963548e-04	  -0.0000000000000000e+00	  -2.2899451906451862e+07	
  -8.8460183856306875e-04	   0.0000000000000000e+00	   7.3882604017788261e-02	  -5.1822314315757625e-07	   0.0000000000000000e+00	   0.0000000000000000e+00	   2.2974705727631178e-01	  -9.7632309208494808e-07	   0.0000000000000000e+00	   1.0000000000000000e+00	  -4.2105263157894736e-02	   1.7728531855955678e-03	  -7.4646449919813377e-05	  -0.0000000000000000e+00	  -2.2327463736216143e+07	
  -1.8370553324891862e-04	   0.0000000000000000e+00	  -7.0043906737830369e-02	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	   1.3510500812682708e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	   1.0000000000000000e+00	  -3.1578947368421054e-02	   9.9722991689750701e-04	  -3.1491471059921275e-05	  -0.0000000000000000e+00	  -2.1742838455218170e+07	
  -3.4179300052400812e-05	   0.0000000000000000e+00	  -1.2021127225410981e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	  -1.3575925213518148e-02	   0.0000000000000000e+00	   0.0000000000000000e+00	   1.0000000000000000e+00	  -2.1052631578947368e-02	   4.4321329639889195e-04	  -9.3308062399766721e-06	  -0.0000000000000000e+00	  -2.1145430968515009e+07	
   6.1977227981245921e-02	   0.0000000000000000e+00	  -7.7681102540454725e-02	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	  -9.7440172702976169e-02	   0.0000000000000000e+00	   0.0000000000000000e+00	   1.0000000000000000e+00	  -1.0526315789473684e-02	   1.1080332409972299e-04	  -1.1663507799970840e-06	  -0.0000000000000000e+00	  -2.0535093915450227e+07	
   3.2914194698808724e-01	   0.0000000000000000e+00	   4.5664291184986848e-02	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	  -2.0184970630530680e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	   1.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	  -1.9911701609588567e+07	
   2.0869631953634510e-01	   0.0000000000000000e+00	   2.2250201777292919e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	  -2.4825587622553755e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	   1.0000000000000000e+00	   1.0526315789473684e-02	   1.1080332409972299e-04	   1.1663507799970840e-06	   1.1663507799970840e-06	  -1.9275125611193918e+07	
  -1.8988164869436275e-02	   0.0000000000000000e+00	   3.7253865158380839e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	  -1.3227636261920103e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	   1.0000000000000000e+00	   2.1052631578947368e-02	   4.4321329639889195e-04	   9.3308062399766721e-06	   9.3308062399766721e-06	  -1.8625232264776390e+07	
  -8.7172921748424712e-02	   0.0000000000000000e+00	   4.1880193384853720e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	   1.7975180667404809e-02	   0.0000000000000000e+00	   0.0000000000000000e+00	   1.0000000000000000e+00	   3.1578947368421054e-02	   9.9722991689750701e-04	   3.1491471059921275e-05	   3.1491471059921275e-05	  -1.7961888448384833e+07	
  -5.9479346491040953e-02	   0.0000000000000000e+00	   3.8647078990954892e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	   6.6336098965565221e-02	   0.0000000000000000e+00	   0.0000000000000000e+00	   1.0000000000000000e+00	   4.2105263157894736e-02	   1.7728531855955678e-03	   7.4646449919813377e-05	   7.4646449919813377e-05	  -1.7284953087222628e+07	
  -2.5344894340844023e-02	   0.0000000000000000e+00	   3.4167515847138674e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	   4.8489996379394593e-02	   0.0000000000000000e+00	   0.0000000000000000e+00	   1.0000000000000000e+00	   5.2631578947368418e-02	   2.7700831024930744e-03	   1.4579384749963548e-04	   1.4579384749963548e-04	  -1.6594301290707462e+07	
  -8.1360247239318281e-03	   0.0000000000000000e+00	   2.8634422413720390e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	   8.6939289263681607e-02	   0.0000000000000000e+00	   0.0000000000000000e+00	   1.0000000000000000e+00	   6.3157894736842107e-02	   3.9889196675900280e-03	   2.5193176847937020e-04	   2.5193176847937020e-04	  -1.5889801689018261e+07	
  -2.1329811439999668e-03	   0.0000000000000000e+00	   1.6941872812306108e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	   1.9932443727845253e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	   1.0000000000000000e+00	   7.3684210526315783e-02	   5.4293628808864255e-03	   4.0005831753899977e-04	   4.0005831753899977e-04	  -1.5171332894279920e+07	
  -4.7868580374672127e-04	   0.0000000000000000e+00	   9.7339652391691400e-03	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	   2.1317756978596630e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	   1.0000000000000000e+00	   8.4210526315789472e-02	   7.0914127423822712e-03	   5.9717159935850702e-04	   5.9717159935850702e-04	  -1.4438759648172289e+07	
  -9.4885576906897671e-05	   0.0000000000000000e+00	  -1.0342703349042752e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	   6.8989839045089055e-02	   0.0000000000000000e+00	   0.0000000000000000e+00	   1.0000000000000000e+00	   9.4736842105263161e-02	   8.9750692520775624e-03	   8.5026971861787448e-04	   8.5026971861787448e-04	  -1.3691952932217911e+07	
   4.6549987495046264e-04	   0.0000000000000000e+00	  -1.1370885399932430e-01	   7.7849954623234125e-04	   0.0000000000000000e+00	   0.0000000000000000e+00	  -4.6780737173119882e-02	  -2.6406827272240662e-03	   0.0000000000000000e+00	   1.0000000000000000e+00	   1.0526315789473684e-01	   1.1080332409972297e-02	   1.1663507799970839e-03	   1.1663507799970839e-03	  -1.2930769741141085e+07	
   1.8286923577271125e-01	   0.0000000000000000e+00	  -7.0505792246302060e-02	   3.3178956057083007e-02	   0.0000000000000000e+00	   0.0000000000000000e+00	  -6.2077599161047464e-02	  -7.6128408846089957e-02	   0.0000000000000000e+00	   1.0000000000000000e+00	   1.1578947368421053e-01	   1.3407202216066482e-02	   1.5524128881761190e-03	   1.5524128881761190e-03	  -1.2155081930344526e+07	
   3.2815365238396688e-01	   0.0000000000000000e+00	  -3.1075379328076348e-02	   1.4440180014681392e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	  -3.6293517323374769e-02	  -1.9992737502479768e-01	   0.0000000000000000e+00	   1.0000000000000000e+00	   1.2631578947368421e-01	   1.5955678670360112e-02	   2.0154541478349616e-03	   2.0154541478349616e-03	  -1.1364771600352474e+07	
   1.0472734947167857e-01	   0.0000000000000000e+00	  -1.0670392954156069e-02	   3.0145227582186795e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	  -1.4579521804191179e-02	  -2.0462195254207211e-01	   0.0000000000000000e+00	   1.0000000000000000e+00	   1.3684210526315790e-01	   1.8725761772853188e-02	   2.5624726636535944e-03	   2.5624726636535944e-03	  -1.0559703577307537e+07	
  -6.5414735178786182e-02	   0.0000000000000000e+00	  -3.0133373947628865e-03	   4.0816930917890015e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	  -4.5547919780519388e-03	  -5.7811109467925295e-02	   0.0000000000000000e+00	   1.0000000000000000e+00	   1.4736842105263157e-01	   2.1717451523545702e-02	   3.2004665403119982e-03	   3.2004665403119982e-03	  -9.7397521797204204e+06	
  -8.1039296440989866e-02	   0.0000000000000000e+00	  -7.2674473172627254e-04	   4.1235355967765930e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	  -1.1786336808960263e-03	   4.9499274042558168e-02	   0.0000000000000000e+00	   1.0000000000000000e+00	   1.5789473684210525e-01	   2.4930747922437671e-02	   3.9364338824901587e-03	   3.9364338824901587e-03	  -8.9047886006812230e+06	
  -4.4087905632133433e-02	   0.0000000000000000e+00	  -1.5386856254847681e-04	   3.6716665813617538e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	  -2.6278123722066446e-04	   6.1468774353944371e-02	   0.0000000000000000e+00	   1.0000000000000000e+00	   1.6842105263157894e-01	   2.8365650969529085e-02	   4.7773727948680561e-03	   4.7773727948680561e-03	  -8.0546743582526855e+06	
  -1.6550422413122053e-02	   0.0000000000000000e+00	  -2.9267163684834725e-05	   3.2392301620679653e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	  -5.2002150652398645e-05	   4.9847666173530675e-02	   0.0000000000000000e+00	   1.0000000000000000e+00	   1.7894736842105263e-01	   3.2022160664819943e-02	   5.7302813821256742e-03	   5.7302813821256742e-03	  -7.1892840764447525e+06	
  -4.8645759144098875e-03	   0.0000000000000000e+00	  -5.0502559169199467e-06	   2.4859549248739221e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	  -9.2540988607474148e-06	   1.3286328271100897e-01	   0.0000000000000000e+00	   1.0000000000000000e+00	   1.8947368421052632e-01	   3.5900277008310250e-02	   6.8021577489429958e-03	   6.8021577489429958e-03	  -6.3084860786178336e+06	
  -1.1930031026986410e-03	   0.0000000000000000e+00	  -7.5235207367785176e-07	   1.0653571529948751e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	  -1.4109555146948659e-06	   2.2584550280153473e-01	   0.0000000000000000e+00	   1.0000000000000000e+00	   2.0000000000000001e-01	   4.0000000000000008e-02	   8.0000000000000019e-03	   8.0000000000000019e-03	  -5.4121575398616791e+06	
  -2.5396202412826985e-04	   0.0000000000000000e+00	   0.0000000000000000e+00	  -4.6832193791313273e-02	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	   1.6614010275431002e-01	   0.0000000000000000e+00	   1.0000000000000000e+00	   2.1052631578947367e-01	   4.4321329639889190e-02	   9.3308062399766710e-03	   9.3308062399766710e-03	  -4.5001672449266911e+06	
  -4.8220518125413127e-05	   1.7972165294585549e-07	   0.0000000000000000e+00	  -1.1871343983470048e-01	   0.0000000000000000e+00	  -7.0891758549395515e-07	   0.0000000000000000e+00	   1.0091095488977575e-02	   0.0000000000000000e+00	   1.0000000000000000e+00	   2.2105263157894736e-01	   4.8864265927977837e-02	   1.0801574573552995e-02	   1.0801574573552995e-02	  -3.5723705129204541e+06	
   2.4169016536933870e-02	   5.9438222395961854e-03	   0.0000000000000000e+00	  -9.8735297547960704e-02	   0.0000000000000000e+00	  -1.7549188213126270e-02	   0.0000000000000000e+00	  -6.2455637372362927e-02	   0.0000000000000000e+00	   1.0000000000000000e+00	   2.3157894736842105e-01	   5.3628808864265930e-02	   1.2419303105408952e-02	   1.2419303105408952e-02	  -2.6286213762276992e+06	
   2.9724155612227232e-01	   6.7859854151592250e-02	   0.0000000000000000e+00	  -5.2588926725789020e-02	   0.0000000000000000e+00	  -1.2825364543031706e-01	   0.0000000000000000e+00	  -5.3106046223313087e-02	   0.0000000000000000e+00	   1.0000000000000000e+00	   2.4210526315789474e-01	   5.8614958448753467e-02	   1.4190989940224523e-02	   1.4190989940224523e-02	  -1.6688142544999197e+06	
   2.5803024806313540e-01	   2.0702131854989700e-01	   0.0000000000000000e+00	  -2.0806537629376717e-02	   0.0000000000000000e+00	  -2.2538113774670057e-01	   0.0000000000000000e+00	  -2.6119971738518863e-02	   0.0000000000000000e+00	   1.0000000000000000e+00	   2.5263157894736843e-01	   6.3822714681440448e-02	   1.6123633182679693e-02	   1.6123633182679693e-02	  -6.9281623238137364e+05	
   1.5480751995147656e-02	   3.5555300272627366e-01	   0.0000000000000000e+00	  -6.5717408111991144e-03	   0.0000000000000000e+00	  -1.5615934487315666e-01	   0.0000000000000000e+00	  -9.3946798718158985e-03	   0.0000000000000000e+00	   1.0000000000000000e+00	   2.6315789473684209e-01	   6.9252077562326861e-02	   1.8224230937454435e-02	   1.8224230937454435e-02	   2.9950556338893622e+05	
  -8.5092846828545440e-02	   4.1993036162424330e-01	   0.0000000000000000e+00	  -1.7354377274918880e-03	   0.0000000000000000e+00	  -1.0730035819227872e-03	   0.0000000000000000e+00	  -2.7056969420893432e-03	   0.0000000000000000e+00	   1.0000000000000000e+00	   2.7368421052631581e-01	   7.4903047091412753e-02	   2.0499781309228755e-02	   2.0499781309228755e-02	   1.3082802235329971e+06	
  -6.7344467282778389e-02	   3.9648730685263067e-01	   0.0000000000000000e+00	  -3.9627411936631822e-04	   0.0000000000000000e+00	   6.4795239339487262e-02	   0.0000000000000000e+00	  -6.5730654337462586e-04	   0.0000000000000000e+00	   1.0000000000000000e+00	   2.8421052631578947e-01	   8.0775623268698055e-02	   2.2957282402682605e-02	   2.2957282402682605e-02	   2.3336263527088910e+06	
  -3.0859121798647051e-02	   3.4988988278635952e-01	   0.0000000000000000e+00	  -8.0173402304067263e-05	   0.0000000000000000e+00	   5.1950746816847776e-02	   0.0000000000000000e+00	  -1.3927740229629913e-04	   0.0000000000000000e+00	   1.0000000000000000e+00	   2.9473684210526313e-01	   8.6869806094182808e-02	   2.5603732322495985e-02	   2.5603732322495985e-02	   3.3756763413345665e+06	
  -1.0398603799754021e-02	   3.0094602992319508e-01	   0.0000000000000000e+00	  -1.4577289820257387e-05	   0.0000000000000000e+00	   6.9200680125590358e-02	   0.0000000000000000e+00	  -2.6236710696081891e-05	   0.0000000000000000e+00	   1.0000000000000000e+00	   3.0526315789473685e-01	   9.3185595567867041e-02	   2.8446129173348884e-02	   2.8446129173348884e-02	   4.4345758976545855e+06	
  -2.8261891016884526e-03	   1.9842544809308393e-01	   0.0000000000000000e+00	  -2.2638139954898488e-06	   0.0000000000000000e+00	   1.7957629818392778e-01	   0.0000000000000000e+00	  -4.1828523652043875e-06	   0.0000000000000000e+00	   1.0000000000000000e+00	   3.1578947368421051e-01	   9.9722991689750684e-02	   3.1491471059921269e-02	   3.1491471059921269e-02	   5.5104500529150888e+06	
  -6.5240578331303358e-04	   4.1333332231519290e-02	   0.0000000000000000e+00	  -3.5600442327298116e-07	   0.0000000000000000e+00	   2.2566882506564701e-01	   0.0000000000000000e+00	  -6.7365927127104966e-07	   0.0000000000000000e+00	   1.0000000000000000e+00	   3.2631578947368423e-01	   1.0648199445983381e-01	   3.4746756086893135e-02	   3.4746756086893135e-02	   6.6034118503785804e+06	
  -1.3230474301884534e-04	  -8.9013361783352618e-02	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	   1.0200288654363485e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	   1.0000000000000000e+00	   3.3684210526315789e-01	   1.1346260387811634e-01	   3.8218982358944449e-02	   3.8218982358944449e-02	   7.7135919904695749e+06	
  -2.2763919031965966e-05	  -1.1834739943082154e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	   1.5963017835031278e-04	  -3.2496472178913285e-02	   0.0000000000000000e+00	   0.0000000000000000e+00	  -5.7534210508715421e-04	   1.0000000000000000e+00	   3.4736842105263160e-01	   1.2066481994459835e-01	   4.1915147980755220e-02	   4.1915147980755220e-02	   8.8411533235496357e+06	
   1.1766933934135151e-01	  -8.0054891556056232e-02	   0.0000000000000000e+00	   0.0000000000000000e+00	   2.0909077918752295e-02	  -6.4544370785068139e-02	   0.0000000000000000e+00	   0.0000000000000000e+00	  -5.2504663312063840e-02	   1.0000000000000000e+00	   3.5789473684210527e-01	   1.2808864265927977e-01	   4.5842251057005394e-02	   4.5842251057005394e-02	   9.9862234019981027e+06	
   3.3915151685855366e-01	  -3.7427612913223690e-02	   0.0000000000000000e+00	   0.0000000000000000e+00	   1.1591503626231370e-01	  -4.1890231978558873e-02	   0.0000000000000000e+00	   0.0000000000000000e+00	  -1.7866822805253882e-01	   1.0000000000000000e+00	   3.6842105263157893e-01	   1.3573407202216065e-01	   5.0007289692374973e-02	   5.0007289692374973e-02	   1.1148932302210726e+07	
   1.5626897220672240e-01	  -1.3441300945223146e-02	   0.0000000000000000e+00	   0.0000000000000000e+00	   2.7102589539944072e-01	  -1.7899992088040828e-02	   0.0000000000000000e+00	   0.0000000000000000e+00	  -2.1937554065255879e-01	   1.0000000000000000e+00	   3.7894736842105264e-01	   1.4360110803324100e-01	   5.4417261991543966e-02	   5.4417261991543966e-02	   1.2329372176345021e+07	
  -4.5889761416029337e-02	  -3.9337519630671123e-03	   0.0000000000000000e+00	   0.0000000000000000e+00	   3.9533355560952921e-01	  -5.8445454285107907e-03	   0.0000000000000000e+00	   0.0000000000000000e+00	  -9.1202571282810271e-02	   1.0000000000000000e+00	   3.8947368421052631e-01	   1.5168975069252078e-01	   5.9079166059192299e-02	   5.9079166059192299e-02	   1.3527680857389219e+07	
  -8.5485466293479639e-02	  -9.7667774440200706e-04	   0.0000000000000000e+00	   0.0000000000000000e+00	   4.1742655305133147e-01	  -1.5645812979903574e-03	   0.0000000000000000e+00	   0.0000000000000000e+00	   3.6644079357620526e-02	   1.0000000000000000e+00	   4.0000000000000002e-01	   1.6000000000000003e-01	   6.4000000000000015e-02	   6.4000000000000015e-02	   1.4744013954299904e+07	
  -5.1613987307140528e-02	  -2.1180309163878829e-04	   0.0000000000000000e+00	   0.0000000000000000e+00	   3.7677806853318929e-01	  -3.5839960107434895e-04	   0.0000000000000000e+00	   0.0000000000000000e+00	   6.5354184877135096e-02	   1.0000000000000000e+00	   4.1052631578947368e-01	   1.6853185595567868e-01	   6.9186761918647033e-02	   6.9186761918647033e-02	   1.5978502905917309e+07	
  -2.0586709118519942e-02	  -4.1107072568475722e-05	   0.0000000000000000e+00	   0.0000000000000000e+00	   3.3324698528225988e-01	  -7.2519177339011736e-05	   0.0000000000000000e+00	   0.0000000000000000e+00	   4.7509924533272796e-02	   1.0000000000000000e+00	   4.2105263157894735e-01	   1.7728531855955676e-01	   7.4646449919813368e-02	   7.4646449919813368e-02	   1.7231268692723721e+07	
  -6.3149871015004810e-03	  -7.2140811359126060e-06	   0.0000000000000000e+00	   0.0000000000000000e+00	   2.6902481763940428e-01	  -1.3143774611327210e-05	   0.0000000000000000e+00	   0.0000000000000000e+00	   1.0882962004244967e-01	   1.0000000000000000e+00	   4.3157894736842106e-01	   1.8626038781163437e-01	   8.0386062108179043e-02	   8.0386062108179043e-02	   1.8502441721045829e+07	
  -1.5998995910758370e-03	  -1.0892662263073478e-06	   0.0000000000000000e+00	   0.0000000000000000e+00	   1.3858651749072567e-01	  -2.0331088554603621e-06	   0.0000000000000000e+00	   0.0000000000000000e+00	   2.1519494147264256e-01	   1.0000000000000000e+00	   4.4210526315789472e-01	   1.9545706371191135e-01	   8.6412596588423957e-02	   8.6412596588423957e-02	   1.9792148664706565e+07	
  -3.4949313513852877e-04	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	  -1.9968098640650647e-02	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	   1.9284674322244838e-01	   1.0000000000000000e+00	   4.5263157894736844e-01	   2.0487534626038784e-01	   9.2733051465228172e-02	   9.2733051465228172e-02	   2.1100520328300230e+07	
  -6.7774195098072875e-05	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	  -1.1325358183759204e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	   3.7893132438445457e-02	   1.0000000000000000e+00	   4.6315789473684210e-01	   2.1451523545706372e-01	   9.9354424843271616e-02	   9.9354424843271616e-02	   2.2427701408503219e+07	
   5.6890986261887112e-03	   2.4632390461375082e-03	   0.0000000000000000e+00	   0.0000000000000000e+00	  -1.0696208513639913e-01	  -7.8171058742844777e-03	   0.0000000000000000e+00	   0.0000000000000000e+00	  -5.6615568209656034e-02	   1.0000000000000000e+00	   4.7368421052631576e-01	   2.2437673130193903e-01	   1.0628371482723427e-01	   1.0628371482723427e-01	   2.3773807935681403e+07	
   2.4618481081097995e-01	   4.8820311055440317e-02	   0.0000000000000000e+00	   0.0000000000000000e+00	  -6.1272673063231448e-02	  -1.0183399555242575e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	  -5.8086735980862475e-02	   1.0000000000000000e+00	   4.8421052631578948e-01	   2.3445983379501387e-01	   1.1352791952179618e-01	   1.1352791952179618e-01	   2.5138965494905464e+07	
   2.9953964554960644e-01	   1.7507033112252593e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	  -2.5547441406802145e-02	  -2.1612831441918828e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	  -3.0993666067196276e-02	   1.0000000000000000e+00	   4.9473684210526314e-01	   2.4476454293628808e-01	   1.2109403703163725e-01	   1.2109403703163725e-01	   2.6523310263039686e+07	
   5.7109131744450661e-02	   3.2987495754170404e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	  -8.4051340693276771e-03	  -1.8320362885086547e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	  -1.1758010932446473e-02	   1.0000000000000000e+00	   5.0526315789473686e-01	   2.5529085872576179e-01	   1.2898906546143754e-01	   1.2898906546143754e-01	   2.7926978180642635e+07	
  -7.8184230485700307e-02	   4.1619910711870090e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	  -2.2938316718133949e-03	  -2.7189893305956774e-02	   0.0000000000000000e+00	   0.0000000000000000e+00	  -3.5232574314479738e-03	   1.0000000000000000e+00	   5.1578947368421058e-01	   2.6603878116343493e-01	   1.3722000291587699e-01	   1.3722000291587699e-01	   2.9350100892358869e+07	
  -7.4737010936004322e-02	   4.0522771221040943e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	  -5.3798391262850328e-04	   5.8945294122267095e-02	   0.0000000000000000e+00	   0.0000000000000000e+00	  -8.8267150904121708e-04	   1.0000000000000000e+00	   5.2631578947368418e-01	   2.7700831024930744e-01	   1.4579384749963548e-01	   1.4579384749963548e-01	   3.0792791682040647e+07	
  -3.7125986784173719e-02	   3.5823603012410249e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	  -1.1129983958096788e-04	   5.6583906662152982e-02	   0.0000000000000000e+00	   0.0000000000000000e+00	  -1.9175152461996296e-04	   1.0000000000000000e+00	   5.3684210526315790e-01	   2.8819944598337949e-01	   1.5471759731739321e-01	   1.5471759731739321e-01	   3.2255188890072003e+07	
  -1.3178061904414793e-02	   3.1330364005523526e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	  -2.0616437121920034e-05	   5.6795794533862881e-02	   0.0000000000000000e+00	   0.0000000000000000e+00	  -3.6864262677767610e-05	   1.0000000000000000e+00	   5.4736842105263162e-01	   2.9961218836565101e-01	   1.6399825047383004e-01	   1.6399825047383004e-01	   3.3737424698033422e+07	
  -3.7205065395061786e-03	   2.2498345090173064e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	  -3.5244398305267092e-06	   1.5701149313902130e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	  -6.4936311517650639e-06	   1.0000000000000000e+00	   5.5789473684210522e-01	   3.1124653739612185e-01	   1.7364280507362584e-01	   1.7364280507362584e-01	   3.5239632326350734e+07	
  -8.8460183856306875e-04	   7.3882604017788261e-02	   0.0000000000000000e+00	   0.0000000000000000e+00	  -5.1822314315757625e-07	   2.2974705727631178e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	  -9.7632309208494808e-07	   1.0000000000000000e+00	   5.6842105263157894e-01	   3.2310249307479222e-01	   1.8365825922146084e-01	   1.8365825922146084e-01	   3.6761934819881216e+07	
  -1.8370553324891862e-04	  -7.0043906737830369e-02	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	   1.3510500812682708e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	   1.0000000000000000e+00	   5.7894736842105265e-01	   3.3518005540166207e-01	   1.9405161102201490e-01	   1.9405161102201490e-01	   3.8304448683193475e+07	
  -3.4179300052400812e-05	  -1.2022600095442171e-01	   0.0000000000000000e+00	   1.4728700311903286e-05	   0.0000000000000000e+00	  -1.3519940771543261e-02	   0.0000000000000000e+00	  -5.5984441974886700e-05	   0.0000000000000000e+00	   1.0000000000000000e+00	   5.8947368421052626e-01	   3.4747922437673123e-01	   2.0482985857996788e-01	   2.0482985857996788e-01	   3.9867328474246711e+07	
   6.1977227981245921e-02	  -8.9600939014954029e-02	   0.0000000000000000e+00	   1.1919836474499302e-02	   0.0000000000000000e+00	  -6.4884679517546728e-02	   0.0000000000000000e+00	  -3.2555493185429440e-02	   0.0000000000000000e+00	   1.0000000000000000e+00	   5.9999999999999998e-01	   3.5999999999999999e-01	   2.1599999999999997e-01	   2.1599999999999997e-01	   4.1450727994291037e+07	
   3.2914194698808724e-01	  -4.4610650244984916e-02	   0.0000000000000000e+00	   9.0274941429971764e-02	   0.0000000000000000e+00	  -4.7586436324094594e-02	   0.0000000000000000e+00	  -1.5426326998121220e-01	   0.0000000000000000e+00	   1.0000000000000000e+00	   6.1052631578947369e-01	   3.7274238227146816e-01	   2.2756903338679108e-01	   2.2756903338679108e-01	   4.3054756450479880e+07	
   2.0869631953634510e-01	  -1.6794634932976529e-02	   0.0000000000000000e+00	   2.3929665270590575e-01	   0.0000000000000000e+00	  -2.1745661626648261e-02	   0.0000000000000000e+00	  -2.2651021459888929e-01	   0.0000000000000000e+00	   1.0000000000000000e+00	   6.2105263157894741e-01	   3.8570637119113577e-01	   2.3954395684502119e-01	   2.3954395684502119e-01	   4.4679530292131960e+07	
  -1.8988164869436275e-02	  -5.1018176378398936e-03	   0.0000000000000000e+00	   3.7764046922164829e-01	   0.0000000000000000e+00	  -7.4407761527462875e-03	   0.0000000000000000e+00	  -1.2483558646645473e-01	   0.0000000000000000e+00	   1.0000000000000000e+00	   6.3157894736842102e-01	   3.9889196675900274e-01	   2.5193176847937016e-01	   2.5193176847937016e-01	   4.6325184495605588e+07	
  -8.7172921748424712e-02	  -1.3055419048209041e-03	   0.0000000000000000e+00	   4.2010747575335811e-01	   0.0000000000000000e+00	  -2.0641445077479018e-03	   0.0000000000000000e+00	   2.0039325175152698e-02	   0.0000000000000000e+00	   1.0000000000000000e+00	   6.4210526315789473e-01	   4.1229916897506924e-01	   2.6473946639451817e-01	   2.6473946639451817e-01	   4.7991846162983879e+07	
  -5.9479346491040953e-02	  -2.9049537695812611e-04	   0.0000000000000000e+00	   3.8676128528650705e-01	   0.0000000000000000e+00	  -4.8684122664065948e-04	   0.0000000000000000e+00	   6.6822940192205887e-02	   0.0000000000000000e+00	   1.0000000000000000e+00	   6.5263157894736845e-01	   4.2592797783933523e-01	   2.7797404869514508e-01	   2.7797404869514508e-01	   4.9679642121459484e+07	
  -2.5344894340844023e-02	  -5.7519918573519355e-05	   0.0000000000000000e+00	   3.4173267838996024e-01	   0.0000000000000000e+00	  -1.0071519927700912e-04	   0.0000000000000000e+00	   4.8590711578671605e-02	   0.0000000000000000e+00	   1.0000000000000000e+00	   6.6315789473684206e-01	   4.3977839335180047e-01	   2.9164251348593084e-01	   2.9164251348593084e-01	   5.1388713588894203e+07	
  -8.1360247239318281e-03	  -1.0271890012879138e-05	   0.0000000000000000e+00	   2.8635449602721674e-01	   0.0000000000000000e+00	  -1.8603553893817027e-05	   0.0000000000000000e+00	   8.6957892817575433e-02	   0.0000000000000000e+00	   1.0000000000000000e+00	   6.7368421052631577e-01	   4.5385041551246535e-01	   3.0575185887155559e-01	   3.0575185887155559e-01	   5.3119190209192812e+07	
  -2.1329811439999668e-03	  -1.5726052562367482e-06	   0.0000000000000000e+00	   1.6942030072831732e-01	   0.0000000000000000e+00	  -2.9207518307516431e-06	   0.0000000000000000e+00	   1.9932735803028329e-01	   0.0000000000000000e+00	   1.0000000000000000e+00	   6.8421052631578949e-01	   4.6814404432132967e-01	   3.2030908295669924e-01	   3.2030908295669924e-01	   5.4871193086425975e+07	
  -4.7868580374672127e-04	  -2.4393255686410929e-07	   0.0000000000000000e+00	   9.7342091717260160e-03	   0.0000000000000000e+00	  -4.6354368728304449e-07	   0.0000000000000000e+00	   2.1317803332965357e-01	   0.0000000000000000e+00	   1.0000000000000000e+00	   6.9473684210526321e-01	   4.8265927977839340e-01	   3.3532118384604176e-01	   3.3532118384604176e-01	   5.6644850124556869e+07	
  -9.4885576906897671e-05	   0.0000000000000000e+00	   0.0000000000000000e+00	  -1.0342703349042752e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	   6.8989839045089055e-02	   0.0000000000000000e+00	   1.0000000000000000e+00	   7.0526315789473681e-01	   4.9739612188365645e-01	   3.5079515964426300e-01	   3.5079515964426300e-01	   5.8440306078570858e+07	
   4.6549987495046264e-04	   0.0000000000000000e+00	   7.7849954623234125e-04	  -1.1370885399932430e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	  -2.6406827272240662e-03	  -4.6780737173119882e-02	   0.0000000000000000e+00	   1.0000000000000000e+00	   7.1578947368421053e-01	   5.1235457063711909e-01	   3.6673800845604315e-01	   3.6673800845604315e-01	   6.0257698738376126e+07	
   1.8286923577271125e-01	   0.0000000000000000e+00	   3.3178956057083007e-02	  -7.0505792246302060e-02	   0.0000000000000000e+00	   0.0000000000000000e+00	  -7.6128408846089957e-02	  -6.2077599161047464e-02	   0.0000000000000000e+00	   1.0000000000000000e+00	   7.2631578947368425e-01	   5.2753462603878121e-01	   3.8315672838606218e-01	   3.8315672838606218e-01	   6.2097159447418898e+07	
   3.2815365238396688e-01	   0.0000000000000000e+00	   1.4440180014681392e-01	  -3.1075379328076348e-02	   0.0000000000000000e+00	   0.0000000000000000e+00	  -1.9992737502479768e-01	  -3.6293517323374769e-02	   0.0000000000000000e+00	   1.0000000000000000e+00	   7.3684210526315785e-01	   5.4293628808864258e-01	   4.0005831753899979e-01	   4.0005831753899979e-01	   6.3958803792432591e+07	
   1.0472734947167857e-01	   0.0000000000000000e+00	   3.0145227582186795e-01	  -1.0670392954156069e-02	   0.0000000000000000e+00	   0.0000000000000000e+00	  -2.0462195254207211e-01	  -1.4579521804191179e-02	   0.0000000000000000e+00	   1.0000000000000000e+00	   7.4736842105263157e-01	   5.5855955678670355e-01	   4.1744977401953637e-01	   4.1744977401953637e-01	   6.5842753707203761e+07	
  -6.5414735178786182e-02	   0.0000000000000000e+00	   4.0816930917890015e-01	  -3.0133373947628865e-03	   0.0000000000000000e+00	   0.0000000000000000e+00	  -5.7811109467925295e-02	  -4.5547919780519388e-03	   0.0000000000000000e+00	   1.0000000000000000e+00	   7.5789473684210529e-01	   5.7440443213296399e-01	   4.3533809593235173e-01	   4.3533809593235173e-01	   6.7749140587336496e+07	
  -8.1039296440989866e-02	   0.0000000000000000e+00	   4.1235355967765930e-01	  -7.2674473172627254e-04	   0.0000000000000000e+00	   0.0000000000000000e+00	   4.9499274042558168e-02	  -1.1786336808960263e-03	   0.0000000000000000e+00	   1.0000000000000000e+00	   7.6842105263157889e-01	   5.9047091412742370e-01	   4.5373028138212557e-01	   4.5373028138212557e-01	   6.9678108008850276e+07	
  -4.4087905632133433e-02	   0.0000000000000000e+00	   3.6716665813617538e-01	  -1.5386856254847681e-04	   0.0000000000000000e+00	   0.0000000000000000e+00	   6.1468774353944371e-02	  -2.6278123722066446e-04	   0.0000000000000000e+00	   1.0000000000000000e+00	   7.7894736842105261e-01	   6.0675900277008310e-01	   4.7263332847353839e-01	   4.7263332847353839e-01	   7.1629787035486892e+07	
  -1.6550422413122053e-02	   0.0000000000000000e+00	   3.2392301620679653e-01	  -2.9267163684834725e-05	   0.0000000000000000e+00	   0.0000000000000000e+00	   4.9847666173530675e-02	  -5.2002150652398645e-05	   0.0000000000000000e+00	   1.0000000000000000e+00	   7.8947368421052633e-01	   6.2326869806094187e-01	   4.9205423531126991e-01	   4.9205423531126991e-01	   7.3604299627690956e+07	
  -4.8645759144098875e-03	   0.0000000000000000e+00	   2.4859549248739221e-01	  -5.0502559169199467e-06	   0.0000000000000000e+00	   0.0000000000000000e+00	   1.3286328271100897e-01	  -9.2540988607474148e-06	   0.0000000000000000e+00	   1.0000000000000000e+00	   8.0000000000000004e-01	   6.4000000000000012e-01	   5.1200000000000012e-01	   5.1200000000000012e-01	   7.5601781557119071e+07	
  -1.1930031026986410e-03	   0.0000000000000000e+00	   1.0653571529948751e-01	  -7.5235207367785176e-07	   0.0000000000000000e+00	   0.0000000000000000e+00	   2.2584550280153473e-01	  -1.4109555146948659e-06	   0.0000000000000000e+00	   1.0000000000000000e+00	   8.1052631578947365e-01	   6.5695290858725752e-01	   5.3247762064440873e-01	   5.3247762064440873e-01	   7.7622359293640539e+07	
  -2.5396202412826985e-04	   0.0000000000000000e+00	  -4.6832193791313273e-02	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	   1.6614010275431002e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	   1.0000000000000000e+00	   8.2105263157894737e-01	   6.7412742382271473e-01	   5.5349409534917626e-01	   5.5349409534917626e-01	   7.9666160208791256e+07	
  -4.8220518125413127e-05	   0.0000000000000000e+00	  -1.1871343983470048e-01	   0.0000000000000000e+00	   1.7972165294585549e-07	   0.0000000000000000e+00	   1.0091095488977575e-02	   0.0000000000000000e+00	  -7.0891758549395515e-07	   1.0000000000000000e+00	   8.3157894736842108e-01	   6.9152354570637120e-01	   5.7505642221898245e-01	   5.7505642221898245e-01	   8.1733321542241797e+07	
   2.4169016536933870e-02	   0.0000000000000000e+00	  -9.8735297547960704e-02	   0.0000000000000000e+00	   5.9438222395961854e-03	   0.0000000000000000e+00	  -6.2455637372362927e-02	   0.0000000000000000e+00	  -1.7549188213126270e-02	   1.0000000000000000e+00	   8.4210526315789469e-01	   7.0914127423822704e-01	   5.9717159935850694e-01	   5.9717159935850694e-01	   8.3823983214631885e+07	
   2.9724155612227232e-01	   0.0000000000000000e+00	  -5.2588926725789020e-02	   0.0000000000000000e+00	   6.7859854151592250e-02	   0.0000000000000000e+00	  -5.3106046223313087e-02	   0.0000000000000000e+00	  -1.2825364543031706e-01	   1.0000000000000000e+00	   8.5263157894736841e-01	   7.2698060941828258e-01	   6.1984662487243036e-01	   6.1984662487243036e-01	   8.5938269240893766e+07	
   2.5803024806313540e-01	   0.0000000000000000e+00	  -2.0806537629376717e-02	   0.0000000000000000e+00	   2.0702131854989700e-01	   0.0000000000000000e+00	  -2.6119971738518863e-02	   0.0000000000000000e+00	  -2.2538113774670057e-01	   1.0000000000000000e+00	   8.6315789473684212e-01	   7.4504155124653748e-01	   6.4308849686543235e-01	   6.4308849686543235e-01	   8.8076292616174176e+07	
   1.5480751995147656e-02	   0.0000000000000000e+00	  -6.5717408111991144e-03	   0.0000000000000000e+00	   3.5555300272627366e-01	   0.0000000000000000e+00	  -9.3946798718158985e-03	   0.0000000000000000e+00	  -1.5615934487315666e-01	   1.0000000000000000e+00	   8.7368421052631584e-01	   7.6332409972299176e-01	   6.6690421344219286e-01	   6.6690421344219286e-01	   9.0238174707291275e+07	
  -8.5092846828545440e-02	   0.0000000000000000e+00	  -1.7354377274918880e-03	   0.0000000000000000e+00	   4.1993036162424330e-01	   0.0000000000000000e+00	  -2.7056969420893432e-03	   0.0000000000000000e+00	  -1.0730035819227872e-03	   1.0000000000000000e+00	   8.8421052631578945e-01	   7.8182825484764540e-01	   6.9130077270739165e-01	   6.9130077270739165e-01	   9.2424069093082637e+07	
  -6.7344467282778389e-02	   0.0000000000000000e+00	  -3.9627411936631822e-04	   0.0000000000000000e+00	   3.9648730685263067e-01	   0.0000000000000000e+00	  -6.5730654337462586e-04	   0.0000000000000000e+00	   6.4795239339487262e-02	   1.0000000000000000e+00	   8.9473684210526316e-01	   8.0055401662049863e-01	   7.1628517276570935e-01	   7.1628517276570935e-01	   9.4634114440171003e+07	
  -3.0859121798647051e-02	   0.0000000000000000e+00	  -8.0173402304067263e-05	   0.0000000000000000e+00	   3.4988988278635952e-01	   0.0000000000000000e+00	  -1.3927740229629913e-04	   0.0000000000000000e+00	   5.1950746816847776e-02	   1.0000000000000000e+00	   9.0526315789473688e-01	   8.1950138504155134e-01	   7.4186441172182538e-01	   7.4186441172182538e-01	   9.6868439125350088e+07	
  -1.0398603799754021e-02	   0.0000000000000000e+00	  -1.4577289820257387e-05	   0.0000000000000000e+00	   3.0094602992319508e-01	   0.0000000000000000e+00	  -2.6236710696081891e-05	   0.0000000000000000e+00	   6.9200680125590358e-02	   1.0000000000000000e+00	   9.1578947368421049e-01	   8.3867036011080320e-01	   7.6804548768041980e-01	   7.6804548768041980e-01	   9.9127162507476807e+07	
  -2.8261891016884526e-03	   0.0000000000000000e+00	  -2.2638139954898488e-06	   0.0000000000000000e+00	   1.9842544809308393e-01	   0.0000000000000000e+00	  -4.1828523652043875e-06	   0.0000000000000000e+00	   1.7957629818392778e-01	   1.0000000000000000e+00	   9.2631578947368420e-01	   8.5806094182825488e-01	   7.9483539874617293e-01	   7.9483539874617293e-01	   1.0141041149911594e+08	
  -6.5240578331303358e-04	   0.0000000000000000e+00	  -3.5600442327298116e-07	   0.0000000000000000e+00	   4.1333332231519290e-02	   0.0000000000000000e+00	  -6.7365927127104966e-07	   0.0000000000000000e+00	   2.2566882506564701e-01	   1.0000000000000000e+00	   9.3684210526315792e-01	   8.7767313019390591e-01	   8.2224114302376450e-01	   8.2224114302376450e-01	   1.0371832633873191e+08	
  -1.3230474301884534e-04	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	  -8.9013361783352618e-02	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	   1.0200288654363485e-01	   1.0000000000000000e+00	   9.4736842105263153e-01	   8.9750692520775610e-01	   8.5026971861787415e-01	   8.5026971861787415e-01	   1.0605103777870619e+08	
  -2.4138787293590782e-05	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	  -1.1834739943082154e-01	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	  -3.2496472178913285e-02	   1.0000000000000000e+00	   9.5789473684210524e-01	   9.1756232686980610e-01	   8.7892812363318262e-01	   8.7892812363318262e-01	   1.0840866954560232e+08	
  -4.0326882503041127e-06	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	  -8.0054891556056232e-02	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	  -6.4544370785068139e-02	   1.0000000000000000e+00	   9.6842105263157896e-01	   9.3783933518005547e-01	   9.0822335617436944e-01	   9.0822335617436944e-01	   1.1079135118806735e+08	
  -6.2527588338813119e-07	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	  -3.7427612913223690e-02	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	  -4.1890231978558873e-02	   1.0000000000000000e+00	   9.7894736842105268e-01	   9.5833795013850420e-01	   9.3816241434611469e-01	   9.3816241434611469e-01	   1.1319921057647294e+08	
  -9.0937220696952162e-08	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	  -1.3441300945223146e-02	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	  -1.7899992088040828e-02	   1.0000000000000000e+00	   9.8947368421052628e-01	   9.7905817174515231e-01	   9.6875229625309800e-01	   9.6875229625309800e-01	   1.1563238092136064e+08	
  -1.2510669177246911e-08	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	  -3.9337519630671123e-03	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	  -5.8445454285107907e-03	   1.0000000000000000e+00	   1.0000000000000000e+00	   1.0000000000000000e+00	   1.0000000000000000e+00	   1.0000000000000000e+00	   1.1809099716453132e+08	
""",
'event':"""0.0000000000000000e+00	   1.7972165294585549e-07	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	  -7.0891758549395515e-07	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	   1.0000000000000000e+00	  -1.0000000000000000e+00	   1.0000000000000000e+00	  -1.0000000000000000e+00	  -0.0000000000000000e+00	  -3.9964378119605467e+07	
   2.4177346180074877e-02	   5.9438222395961854e-03	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	  -1.7549188213126270e-02	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	   1.0000000000000000e+00	  -9.8947368421052628e-01	   9.7905817174515231e-01	  -9.6875229625309800e-01	  -0.0000000000000000e+00	  -3.9964295632754065e+07	
   2.9724288489710671e-01	   6.6691877390710710e-02	   0.0000000000000000e+00	   1.1679767608815418e-03	   0.0000000000000000e+00	  -1.2437298949140786e-01	   0.0000000000000000e+00	  -3.8806559389091872e-03	   0.0000000000000000e+00	   1.0000000000000000e+00	  -9.7894736842105268e-01	   9.5833795013850420e-01	  -9.3816241434611469e-01	  -0.0000000000000000e+00	  -3.9964008717195466e+07	
   2.5803044610535053e-01	   1.6919887664583222e-01	   0.0000000000000000e+00	   3.7738862474685671e-02	   8.3579429379114777e-05	  -1.4115599824277203e-01	   0.0000000000000000e+00	  -8.3918434149865523e-02	  -3.0670535406300835e-04	   1.0000000000000000e+00	  -9.6842105263157896e-01	   9.3783933518005547e-01	  -9.0822335617436944e-01	  -0.0000000000000000e+00	  -3.9963382251577556e+07	
   1.5480779827902719e-02	   2.0115527889004484e-01	   1.7972165294585549e-07	   1.3671413001462854e-01	   1.7683414099947323e-02	   5.0427887160567904e-02	  -7.0891758549395515e-07	  -1.6094050000148924e-01	  -4.5646023114649811e-02	   1.0000000000000000e+00	  -9.5789473684210524e-01	   9.1756232686980610e-01	  -8.7892812363318262e-01	  -0.0000000000000000e+00	  -3.9962264238541424e+07	
  -8.5092843112443153e-02	   1.0826831140941834e-01	   5.9438222395961854e-03	   2.0428516922367393e-01	   1.0143305875155482e-01	   1.9784723228238235e-01	  -1.7549188213126270e-02	  -2.7801642355785985e-02	  -1.5356940529539287e-01	   1.0000000000000000e+00	  -9.4736842105263153e-01	   8.9750692520775610e-01	  -8.5026971861787415e-01	  -0.0000000000000000e+00	  -3.9960523102045782e+07	
  -6.7344467282778389e-02	  -1.5192826604774678e-02	   6.6691877390710710e-02	   1.5192563333963566e-01	   1.9306262272705899e-01	   1.1100114773388517e-01	  -1.2437298949140786e-01	   1.7226230721222197e-01	  -9.4095226115212052e-02	   1.0000000000000000e+00	  -9.3684210526315792e-01	   8.7767313019390591e-01	  -8.2224114302376450e-01	  -0.0000000000000000e+00	  -3.9958030461220443e+07	
  -3.0859121798647051e-02	  -5.9611929791310761e-02	   1.6919887664583222e-01	   5.7816980815322772e-02	   1.8256953454589439e-01	  -3.1066893522055071e-03	  -1.4115599824277203e-01	   7.1597287908986007e-02	   1.2430944114877630e-01	   1.0000000000000000e+00	  -9.2631578947368420e-01	   8.5806094182825488e-01	  -7.9483539874617293e-01	  -0.0000000000000000e+00	  -3.9954647886381753e+07	
  -1.0398603799754021e-02	  -2.7212216744210212e-02	   2.0115527889004484e-01	   8.2514000683269279e-02	   6.2172560915691455e-02	  -8.0658471772627749e-02	   5.0427887160567904e-02	  -1.3400726359739601e-01	   1.8779179630281093e-01	   1.0000000000000000e+00	  -9.1578947368421049e-01	   8.3867036011080320e-01	  -7.6804548768041980e-01	  -0.0000000000000000e+00	  -3.9950228902413361e+07	
  -2.8261891016884526e-03	   8.0209005576718964e-02	   1.0826831140941834e-01	   1.5740056826346380e-01	  -4.0075556165366157e-02	  -1.7757047085784922e-01	   1.9784723228238235e-01	  -7.7253408640873558e-02	   6.5434351891749037e-02	   1.0000000000000000e+00	  -9.0526315789473688e-01	   8.1950138504155134e-01	  -7.4186441172182538e-01	  -0.0000000000000000e+00	  -3.9944630184490673e+07	
  -6.5240578331303358e-04	   1.8671873839475647e-01	  -1.5192826604774678e-02	   1.8910188123201388e-01	  -5.8371983911825132e-02	  -1.0812787798155156e-01	   1.1100114773388517e-01	   2.2488780400294686e-02	  -2.2042096632510385e-02	   1.0000000000000000e+00	  -8.9473684210526316e-01	   8.0055401662049863e-01	  -7.1628517276570935e-01	  -0.0000000000000000e+00	  -3.9937731831733234e+07	
  -1.3230474301884534e-04	   2.1815823789069552e-01	  -5.9611929791310761e-02	   1.7834064442664524e-01	  -3.6309461213591215e-02	   3.7153406706898165e-02	  -3.1066893522055071e-03	   2.8801918432358464e-04	  -3.3403546593305647e-02	   1.0000000000000000e+00	  -8.8421052631578945e-01	   7.8182825484764540e-01	  -6.9130077270739165e-01	  -0.0000000000000000e+00	  -3.9929402377448291e+07	
  -2.4138787293590782e-05	   1.9836539362542779e-01	  -2.7212216744210212e-02	   1.4361396913677585e-01	  -1.5388981806849873e-02	   2.6005752171882255e-02	  -8.0658471772627749e-02	   7.2486302997612467e-02	  -1.8697604146125976e-02	   1.0000000000000000e+00	  -8.7368421052631584e-01	   7.6332409972299176e-01	  -6.6690421344219286e-01	  -0.0000000000000000e+00	  -3.9919467169778965e+07	
  -4.0326882503041127e-06	   1.7004278105755538e-01	   8.0209005576718964e-02	   5.4586736964392375e-02	  -5.0386096958458283e-03	   1.9894509103233610e-02	  -1.7757047085784922e-01	   1.6459230660036478e-01	  -7.0993673209910615e-03	   1.0000000000000000e+00	  -8.6315789473684212e-01	   7.4504155124653748e-01	  -6.4308849686543235e-01	  -0.0000000000000000e+00	  -3.9907786847505786e+07	
  -6.2527588338813119e-07	   1.5905651853639177e-01	   1.8671873839475647e-01	  -4.3729264683742025e-02	  -1.3582822198243730e-03	   2.9690484600776099e-02	  -1.0812787798155156e-01	   8.1402624180322181e-02	  -2.1023200711287751e-03	   1.0000000000000000e+00	  -8.5263157894736841e-01	   7.2698060941828258e-01	  -6.1984662487243036e-01	  -0.0000000000000000e+00	  -3.9894241441418923e+07	
  -9.0937220696952162e-08	   1.5296388884063916e-01	   2.1815823789069552e-01	  -7.0669011124139827e-02	  -2.3041555027059071e-04	  -1.9050509451844708e-02	   3.7153406706898165e-02	  -1.6936932112187754e-02	  -8.2546236142740852e-04	   1.0000000000000000e+00	  -8.4210526315789469e-01	   7.0914127423822704e-01	  -5.9717159935850694e-01	  -0.0000000000000000e+00	  -3.9878693250274450e+07	
  -1.2510669177246911e-08	   1.3156558369691071e-01	   1.9836521390377485e-01	  -4.8243261570625216e-02	   1.7619353944818051e-02	   5.8662420655810149e-02	   2.6006461089467747e-02	  -3.9900023154498407e-02	  -4.5757060072061179e-02	   1.0000000000000000e+00	  -8.3157894736842108e-01	   6.9152354570637120e-01	  -5.7505642221898245e-01	  -0.0000000000000000e+00	  -3.9860998616045773e+07	
  -1.6393707816718330e-09	   5.6345100753362388e-02	   1.6409895881795919e-01	  -2.2078293686281818e-02	   1.0142127575894735e-01	   1.4129609867630374e-01	   3.7443697316359881e-02	  -2.5355446281368068e-02	  -1.5359059365486832e-01	   1.0000000000000000e+00	  -8.2105263157894737e-01	   6.7412742382271473e-01	  -5.5349409534917626e-01	  -0.0000000000000000e+00	  -3.9841029804515697e+07	
   0.0000000000000000e+00	   2.1793115828660697e-02	   9.2364641145681062e-02	  -6.5326696738188961e-03	   1.9306063649818450e-01	  -4.4755355088080082e-02	   1.5406347409218396e-01	  -1.4349982160473887e-02	  -9.4098902995715231e-02	   1.0000000000000000e+00	  -8.1052631578947365e-01	   6.5695290858725752e-01	  -5.3247762064440873e-01	  -0.0000000000000000e+00	  -3.9818654567553706e+07	
   0.0000000000000000e+00	   9.8253021885668562e-02	  -1.6151408375813942e-02	   3.5551552001175248e-02	   1.8256922374919074e-01	  -1.5854644388003486e-01	   1.2179878343686432e-01	  -8.7221277924167465e-02	   1.2430885212834518e-01	   1.0000000000000000e+00	  -8.0000000000000004e-01	   6.4000000000000012e-01	  -5.1200000000000012e-01	  -0.0000000000000000e+00	  -3.9793725269769594e+07	
   0.0000000000000000e+00	   1.5285476691215422e-01	  -5.1906460814839753e-02	   1.3618602296187249e-01	   6.2172560915691455e-02	   1.0428163142958963e-02	  -3.7410780701822063e-02	  -1.6179738022522952e-01	   1.8779179630281093e-01	   1.0000000000000000e+00	  -7.8947368421052633e-01	   6.2326869806094187e-01	  -4.9205423531126991e-01	  -0.0000000000000000e+00	  -3.9766099107882999e+07	
   0.0000000000000000e+00	   9.2123146236351552e-02	   4.3566025855902690e-02	   2.0417342571709904e-01	  -4.0075556165366157e-02	   1.5492344253726803e-01	  -1.9257135068834524e-01	  -2.7992687684244611e-02	   6.5434351891749037e-02	   1.0000000000000000e+00	  -7.7894736842105261e-01	   6.0675900277008310e-01	  -4.7263332847353839e-01	  -0.0000000000000000e+00	  -3.9735647326953202e+07	
   0.0000000000000000e+00	   4.3796418122361118e-02	   1.6335668776978365e-01	   1.5190460181838772e-01	  -5.8371983911825132e-02	  -2.3844844859590569e-02	  -1.2547873944576943e-01	   1.7222491478578517e-01	  -2.2042096632510385e-02	   1.0000000000000000e+00	  -7.6842105263157889e-01	   5.9047091412742370e-01	  -4.5373028138212557e-01	  -0.0000000000000000e+00	  -3.9702236464460857e+07	
   0.0000000000000000e+00	   1.0731574615492825e-01	   1.7131918900642060e-01	   5.7813335883083829e-02	  -3.6225881784212099e-02	  -1.4725941503564760e-01	   1.0971897950965598e-01	   7.1590601234367446e-02	  -3.3710251947368652e-02	   1.0000000000000000e+00	  -7.5789473684210529e-01	   5.7440443213296399e-01	  -4.3533809593235173e-01	  -0.0000000000000000e+00	  -3.9665728276365325e+07	
   0.0000000000000000e+00	   1.5573172071478419e-01	   5.8767500060305407e-02	   8.2513236906691323e-02	   2.2944322930974499e-03	   1.4557849361264199e-02	   1.8280522986076542e-01	  -1.3400765344253551e-01	  -6.4343627260775790e-02	   1.0000000000000000e+00	  -7.4736842105263157e-01	   5.5855955678670355e-01	  -4.1744977401953637e-01	  -0.0000000000000000e+00	  -3.9625947171426475e+07	
   0.0000000000000000e+00	   9.2876336967603779e-02	  -4.0940490403193273e-02	   1.5145674602386761e-01	   9.6394449055709000e-02	   1.5610593317834112e-01	   6.4060815922217310e-02	  -5.9704220427747284e-02	  -1.6066877261638393e-01	   1.0000000000000000e+00	  -7.3684210526315785e-01	   5.4293628808864258e-01	  -4.0005831753899979e-01	  -0.0000000000000000e+00	  -3.9582766803961083e+07	
   0.0000000000000000e+00	   4.3966158171504059e-02	  -5.8562755482215997e-02	   1.2357798060218469e-01	   1.9170434050723462e-01	  -2.3561230111389816e-02	  -2.2363103807147941e-02	   1.4298111395279336e-01	  -9.6197546186340827e-02	   1.0000000000000000e+00	  -7.2631578947368425e-01	   5.2753462603878121e-01	  -3.8315672838606218e-01	  -0.0000000000000000e+00	  -3.9536072560850807e+07	
   0.0000000000000000e+00	   1.0743314279239796e-01	  -3.6346923353920750e-02	   4.6880630255498698e-02	   1.8225553956624468e-01	  -1.4750697456160872e-01	  -3.3469379096026097e-02	   5.7525583277230091e-02	   1.2379068414141191e-01	   1.0000000000000000e+00	  -7.1578947368421053e-01	   5.1235457063711909e-01	  -3.6673800845604315e-01	  -0.0000000000000000e+00	  -3.9485728182394587e+07	
   0.0000000000000000e+00	   1.7342100106436448e-01	  -1.5395432111407833e-02	   7.9172820261359550e-02	   6.2108500760562180e-02	  -3.1076518586638784e-02	  -1.8710358075597799e-02	  -1.3888208416444467e-01	   1.8768075934539957e-01	   1.0000000000000000e+00	  -7.0526315789473681e-01	   4.9739612188365645e-01	  -3.5079515964426300e-01	  -0.0000000000000000e+00	  -3.9431584623730086e+07	
   0.0000000000000000e+00	   1.8836666274578873e-01	   9.0412327752404948e-04	   1.5060359477864796e-01	  -4.0087339157973620e-02	   2.0087749204929978e-02	  -2.4650588642972794e-02	  -6.1056568037803557e-02	   6.5413163532273583e-02	   1.0000000000000000e+00	  -6.9473684210526321e-01	   4.8265927977839340e-01	  -3.3532118384604176e-01	  -0.0000000000000000e+00	  -3.9373503040717266e+07	
   0.0000000000000000e+00	   1.7033690350785233e-01	   6.5333595170886341e-02	   1.2222121849978677e-01	  -5.7205993379818069e-02	   6.7165332648059933e-03	  -1.2647530956253664e-01	   1.4654443959756816e-01	  -2.5926429451922754e-02	   1.0000000000000000e+00	  -6.8421052631578949e-01	   4.6814404432132967e-01	  -3.2030908295669924e-01	  -0.0000000000000000e+00	  -3.9311345987254620e+07	
   0.0000000000000000e+00	   1.2080380069246013e-01	   1.6888488166618251e-01	   9.1046164371871487e-03	   1.4290904643907976e-03	   1.1795846482993963e-01	  -1.4167475525013642e-01	   1.4137877394480627e-01	  -1.1732256976360228e-01	   1.0000000000000000e+00	  -6.7368421052631577e-01	   4.5385041551246535e-01	  -3.0575185887155559e-01	  -0.0000000000000000e+00	  -3.9244973542355932e+07	
   0.0000000000000000e+00	   3.4438283090011089e-02	   2.0109121873491556e-01	  -5.7547939779479883e-02	   1.2132532792943161e-01	   1.0628739055560422e-01	   5.0316850203156537e-02	   2.2046370825158240e-02	  -1.7963881306520071e-01	   1.0000000000000000e+00	  -6.6315789473684206e-01	   4.3977839335180047e-01	  -2.9164251348593084e-01	  -0.0000000000000000e+00	  -3.9174248924560487e+07	
   0.0000000000000000e+00	   4.0022795171004232e-02	   1.0825652841681087e-01	  -5.3682663711252271e-02	   2.0519038176742430e-01	  -1.1232513118570334e-01	   1.9782604392290690e-01	  -3.3256958790873037e-02	  -5.2450197889903322e-02	   1.0000000000000000e+00	  -6.5263157894736845e-01	   4.2592797783933523e-01	  -2.7797404869514508e-01	  -0.0000000000000000e+00	  -3.9099039317975588e+07	
   0.0000000000000000e+00	   1.2832572296168343e-01	  -1.5194812833649152e-02	  -2.8536438078967347e-02	   2.1609125174964045e-01	  -1.3020736704049873e-01	   1.1099747085338199e-01	  -2.9598523553562982e-02	   4.9667653588594499e-02	   1.0000000000000000e+00	  -6.4210526315789473e-01	   4.1229916897506924e-01	  -2.6473946639451817e-01	  -0.0000000000000000e+00	  -3.9019207925871357e+07	
   0.0000000000000000e+00	   1.8184513174486536e-01	  -5.9695820017393535e-02	  -1.0973501903449952e-02	   1.8904657943619874e-01	   3.7431734389739568e-03	  -2.8005730185736164e-03	  -1.4136948114045254e-02	   1.3534261454652096e-02	   1.0000000000000000e+00	  -6.3157894736842102e-01	   3.9889196675900274e-01	  -2.5193176847937016e-01	  -0.0000000000000000e+00	  -3.8934600623322882e+07	
   0.0000000000000000e+00	   1.8297564804199995e-01	  -4.4895630844157534e-02	  -3.3474510048147358e-03	   1.6457432378185066e-01	   7.3077581806167691e-03	  -3.5012448657977931e-02	  -4.8882834141059702e-03	   3.1604772410185444e-02	   1.0000000000000000e+00	  -6.2105263157894741e-01	   3.8570637119113577e-01	  -2.3954395684502119e-01	  -0.0000000000000000e+00	  -3.8845083451900810e+07	
   0.0000000000000000e+00	   1.5906034912211336e-01	  -2.1224053174835857e-02	   5.0895817281502252e-03	   1.5686116396855940e-01	   3.0344329995368825e-02	  -2.4001065562456333e-02	  -1.8903568932038005e-02	   1.2354060555552715e-02	   1.0000000000000000e+00	  -6.1052631578947369e-01	   3.7274238227146816e-01	  -2.2756903338679108e-01	  -0.0000000000000000e+00	  -3.8750522818035603e+07	
   0.0000000000000000e+00	   9.1006358925856679e-02	  -7.5118610931840489e-03	   6.6503092049194315e-02	   1.5068813391684041e-01	   1.5196115402105520e-01	  -1.0151995927430326e-02	  -1.2469031978554224e-01	  -1.6259604460167863e-02	   1.0000000000000000e+00	  -5.9999999999999998e-01	   3.5999999999999999e-01	  -2.1599999999999997e-01	  -0.0000000000000000e+00	  -3.8650779152144141e+07	
   0.0000000000000000e+00	  -1.6548982784842764e-02	  -2.1501591298845458e-03	   1.6924530473158547e-01	   1.4967622644336245e-01	   1.2158673178356291e-01	  -3.2376002920126139e-03	  -1.4152794707912439e-01	   2.3518729348581235e-02	   1.0000000000000000e+00	  -5.8947368421052626e-01	   3.4747922437673123e-01	  -2.0482985857996788e-01	  -0.0000000000000000e+00	  -3.8545724148709796e+07	
   0.0000000000000000e+00	  -6.9653755348263402e-02	  -5.2147702654514955e-04	   2.1883206296378127e-01	   1.5065005938590567e-01	   8.1234965378308831e-03	  -8.4483521185395067e-04	   4.7698190340317581e-03	  -1.3036681841290393e-02	   1.0000000000000000e+00	  -5.7894736842105265e-01	   3.3518005540166207e-01	  -1.9405161102201490e-01	  -0.0000000000000000e+00	  -3.8435214400087699e+07	
   0.0000000000000000e+00	  -5.1934993648663420e-02	  -1.1065424034858019e-04	   2.0970028089474685e-01	   1.4213240863825227e-01	  -5.6572321965554090e-02	  -1.8901221960316596e-04	   4.4275793878134018e-02	   1.2279296363450445e-02	   1.0000000000000000e+00	  -5.6842105263157894e-01	   3.2310249307479222e-01	  -1.8365825922146084e-01	  -0.0000000000000000e+00	  -3.8319113881397702e+07	
   0.0000000000000000e+00	   3.6983956204560908e-02	   1.1469452396336173e-03	   1.7786979612228432e-01	   8.4685026232228552e-02	  -1.5576017970246842e-01	  -3.9180483653459804e-03	   1.6905921618673117e-02	   1.4363154029705605e-01	   1.0000000000000000e+00	  -5.5789473684210522e-01	   3.1124653739612185e-01	  -1.7364280507362584e-01	  -0.0000000000000000e+00	  -3.8197280698436156e+07	
   0.0000000000000000e+00	   1.5794822030965477e-01	   3.7735217542446728e-02	   1.2287402532520451e-01	  -1.8335073917085422e-02	  -1.5574704890232346e-01	  -8.3925120824484084e-02	   1.2150945715063380e-01	   1.1850262633718094e-01	   1.0000000000000000e+00	  -5.4736842105263162e-01	   2.9961218836565101e-01	  -1.6399825047383004e-01	  -0.0000000000000000e+00	  -3.8069578593331799e+07	
   0.0000000000000000e+00	   1.9775021803465878e-01	   1.3671372568135648e-01	   1.7276930071533921e-02	  -5.2433983812670809e-02	   4.5441320718522388e-02	  -1.6094230768179973e-01	   1.5277934764483300e-01	  -3.8266562162837352e-02	   1.0000000000000000e+00	  -5.3684210526315790e-01	   2.8819944598337949e-01	  -1.5471759731739321e-01	  -0.0000000000000000e+00	  -3.7935869323744483e+07	
   0.0000000000000000e+00	   1.0740337717159122e-01	   2.1022899146327012e-01	  -6.1299609340202010e-02	   4.3454282349327800e-02	   1.9647369631285061e-01	  -4.5350830568912259e-02	   4.1433286329292704e-02	  -1.9276239601680384e-01	   1.0000000000000000e+00	  -5.2631578947368418e-01	   2.7700831024930744e-01	  -1.4579384749963548e-01	  -0.0000000000000000e+00	  -3.7796023122095928e+07	
   0.0000000000000000e+00	  -1.4215621414284001e-02	   2.1744953396946481e-01	  -6.5883845005009184e-02	   1.6333565624853574e-01	   1.0679948462033843e-01	   5.1769973659723287e-02	  -3.2194092559940712e-02	  -1.2551613187220623e-01	   1.0000000000000000e+00	  -5.1578947368421058e-01	   2.6603878116343493e-01	  -1.3722000291587699e-01	  -0.0000000000000000e+00	  -3.7649889965446725e+07	
   0.0000000000000000e+00	  -2.1994108886333741e-02	   1.8927699498646933e-01	  -3.8376040914096646e-02	   1.7131554407418167e-01	  -8.6784250650728478e-02	   1.4359723816079500e-02	  -3.6947852239381268e-02	   1.0971229283503742e-01	   1.0000000000000000e+00	  -5.0526315789473686e-01	   2.5529085872576179e-01	  -1.2898906546143754e-01	  -0.0000000000000000e+00	  -3.7497316265670031e+07	
   0.0000000000000000e+00	   9.1811869144260094e-02	   1.4695496983703263e-01	   1.7729552665523007e-03	   5.8767095727033349e-02	  -1.9596499367135350e-01	   7.7361832482246623e-02	  -6.5188462472629743e-02	   1.8280342218045492e-01	   1.0000000000000000e+00	  -4.9473684210526314e-01	   2.4476454293628808e-01	  -1.2109403703163725e-01	  -0.0000000000000000e+00	  -3.7338169264406279e+07	
   0.0000000000000000e+00	   1.8306002678261177e-01	   5.5439888209612029e-02	   9.6283794815360410e-02	  -3.4996668163597089e-02	  -5.1804741027097784e-02	   1.6594465421042104e-01	  -1.6085778483598709e-01	   4.6511627709091036e-02	   1.0000000000000000e+00	  -4.8421052631578948e-01	   2.3445983379501387e-01	  -1.1352791952179618e-01	  -0.0000000000000000e+00	  -3.7172326619055934e+07	
   0.0000000000000000e+00	   1.4324579548557007e-01	  -4.3540479342225637e-02	   1.9285128574686822e-01	   8.1291219084947131e-03	   1.6599096722370082e-01	   8.1719954474456569e-02	  -1.0011559455168681e-01	  -1.4673609329855580e-01	   1.0000000000000000e+00	  -4.7368421052631576e-01	   2.2437673130193903e-01	  -1.0628371482723427e-01	  -0.0000000000000000e+00	  -3.6999660033267289e+07	
   0.0000000000000000e+00	   1.7927959210752555e-02	  -7.0631859780513950e-02	   2.1999075710869140e-01	   1.3293553272129058e-01	   1.5227812176683891e-01	  -1.6871688629898421e-02	   3.9865563316927824e-02	  -1.7493208269286115e-01	   1.0000000000000000e+00	  -4.6315789473684210e-01	   2.1451523545706372e-01	  -9.9354424843271616e-02	  -0.0000000000000000e+00	  -3.6820030059284538e+07	
   0.0000000000000000e+00	  -5.4721786079557348e-02	  -4.8236631544414314e-02	   1.9882222644191866e-01	   2.0344308115693138e-01	   2.6089110109824766e-02	  -3.9887978142612079e-02	   2.6738451663599842e-02	  -1.3927785112094214e-02	   1.0000000000000000e+00	  -4.5263157894736844e-01	   2.0487534626038784e-01	  -9.2733051465228172e-02	  -0.0000000000000000e+00	  -3.6633274691983856e+07	
   0.0000000000000000e+00	  -5.2939077440154893e-02	  -2.2077204420055511e-02	   1.7014165230529651e-01	   2.0466167119890102e-01	  -3.2091590291564463e-02	  -2.5353413172512607e-02	   2.0062332963361327e-02	   3.7176426557142955e-02	   1.0000000000000000e+00	  -4.4210526315789472e-01	   1.9545706371191135e-01	  -8.6412596588423957e-02	  -0.0000000000000000e+00	  -3.6439258355741180e+07	
   0.0000000000000000e+00	  -2.8368684258698883e-02	  -6.5326696738188961e-03	   1.5907556382876520e-01	   1.7651151390245995e-01	  -2.9318585685865400e-02	  -1.4349982160473887e-02	   2.9724200146709720e-02	   1.4803601547544343e-02	   1.0000000000000000e+00	  -4.3157894736842106e-01	   1.8626038781163437e-01	  -8.0386062108179043e-02	  -0.0000000000000000e+00	  -3.6237849955159605e+07	
   0.0000000000000000e+00	  -1.0939995492063020e-02	   3.5551552001175248e-02	   1.5296722297617443e-01	   1.2264360977493392e-01	  -1.4078391306374482e-02	  -8.7221277924167465e-02	  -1.9044411797657257e-02	   1.2068399478920640e-01	   1.0000000000000000e+00	  -4.2105263157894735e-01	   1.7728531855955676e-01	  -7.4646449919813368e-02	  -0.0000000000000000e+00	  -3.6028915291220829e+07	
   0.0000000000000000e+00	  -3.3414050335288385e-03	   1.3618602296187249e-01	   1.3156598803018277e-01	   3.4896284016351968e-02	  -4.8773371649446359e-03	  -1.6179738022522952e-01	   5.8664228336120644e-02	   1.0702228757277181e-01	   1.0000000000000000e+00	  -4.1052631578947368e-01	   1.6853185595567868e-01	  -6.9186761918647033e-02	  -0.0000000000000000e+00	  -3.5812314029410847e+07	
   0.0000000000000000e+00	   5.0906709943765328e-03	   2.0417342571709904e-01	   5.0401278513766204e-02	   4.0121666418745344e-02	  -1.8901535823182544e-02	  -2.7992687684244611e-02	   1.5884528688943000e-01	  -1.1215730732557562e-01	   1.0000000000000000e+00	  -4.0000000000000002e-01	   1.6000000000000003e-01	  -6.4000000000000015e-02	  -0.0000000000000000e+00	  -3.5587902398848765e+07	
   0.0000000000000000e+00	   6.6503092049194315e-02	   1.5190460181838772e-01	  -4.4898761562050013e-02	   1.2717679149317535e-01	  -1.2469031978554224e-01	   1.7222491478578517e-01	   7.9617634403327781e-02	  -1.2629299555565593e-01	   1.0000000000000000e+00	  -3.8947368421052631e-01	   1.5168975069252078e-01	  -5.9079166059192299e-02	  -0.0000000000000000e+00	  -3.5355541558413237e+07	
   0.0000000000000000e+00	   1.6924530473158547e-01	   5.7813335883083829e-02	  -7.0945854760163657e-02	   1.4410960340571496e-01	  -1.4152794707912439e-01	   7.1590601234367446e-02	  -1.7390445637262820e-02	   8.7667705243026917e-02	   1.0000000000000000e+00	  -3.7894736842105264e-01	   1.4360110803324100e-01	  -5.4417261991543966e-02	  -0.0000000000000000e+00	  -3.5115099058204055e+07	
   0.0000000000000000e+00	   2.1883206296378127e-01	   8.2513416628344272e-02	  -4.8300691699543583e-02	   4.6262102082296433e-02	   4.7698190340317581e-03	  -1.3400836236012101e-01	  -3.9999015100023447e-02	   1.6824935694483101e-01	   1.0000000000000000e+00	  -3.6842105263157893e-01	   1.3573407202216065e-01	  -5.0007289692374973e-02	  -0.0000000000000000e+00	  -3.4866436158003025e+07	
   0.0000000000000000e+00	   2.0970028089474685e-01	   1.5740056826346380e-01	  -2.2088987412662978e-02	  -4.5224820101560564e-02	   4.4275793878134018e-02	  -7.7253408640873558e-02	  -2.5374601531988065e-02	   5.8145972351154811e-02	   1.0000000000000000e+00	  -3.5789473684210527e-01	   1.2808864265927977e-01	  -4.5842251057005394e-02	  -0.0000000000000000e+00	  -3.4609428135132596e+07	
   0.0000000000000000e+00	   1.7903777288316586e-01	   1.8910188123201388e-01	  -7.7026326635749130e-03	  -5.9751297652897432e-02	   1.3025265679763930e-02	   2.2488780400294686e-02	  -1.0473003102067882e-02	  -2.4181809130075956e-02	   1.0000000000000000e+00	  -3.4736842105263160e-01	   1.2066481994459835e-01	  -4.1915147980755220e-02	  -0.0000000000000000e+00	  -3.4343941110639565e+07	
   0.0000000000000000e+00	   1.6061288779989019e-01	   1.7842422385602436e-01	  -2.1876212702140792e-03	  -3.6627101125479865e-02	   3.7591023000768276e-02	  -1.8686169739423706e-05	  -3.3034327947330652e-03	  -3.3928990275288611e-02	   1.0000000000000000e+00	  -3.3684210526315789e-01	   1.1346260387811634e-01	  -3.8218982358944449e-02	  -0.0000000000000000e+00	  -3.4069813706143320e+07	
   0.0000000000000000e+00	   1.5399106008616245e-01	   1.6129738323672316e-01	  -5.2792733110310866e-04	  -1.5453626016904153e-02	  -8.1611523566562372e-03	   2.6840279882962656e-02	  -8.5758914132577559e-04	  -1.8809739866262339e-02	   1.0000000000000000e+00	  -3.2631578947368423e-01	   1.0648199445983381e-01	  -3.4746756086893135e-02	  -0.0000000000000000e+00	  -3.3786908936772466e+07	
   0.0000000000000000e+00	   1.4298555988347192e-01	   1.5601979571594721e-01	   5.8320787330212983e-03	  -5.0503926884532951e-03	   1.3631643973506719e-02	   1.1022901304971910e-02	  -1.7740233541584896e-02	  -7.1205556804665180e-03	   1.0000000000000000e+00	  -3.1578947368421051e-01	   9.9722991689750684e-02	  -3.1491471059921269e-02	  -0.0000000000000000e+00	  -3.3495079538397674e+07	
   0.0000000000000000e+00	   8.6041788334626473e-02	   1.4933335804331696e-01	   6.6670845869462786e-02	  -1.3602684486988478e-03	   1.4006821465228125e-01	  -1.2692601934889872e-02	  -1.2441038191784466e-01	  -2.1059969516319570e-03	   1.0000000000000000e+00	  -3.0526315789473685e-01	   9.3185595567867041e-02	  -2.8446129173348884e-02	  -0.0000000000000000e+00	  -3.3194207260061242e+07	
   0.0000000000000000e+00	   1.9357360471847010e-02	   1.1190052342175456e-01	   1.6927881114297239e-01	  -3.1430577635336443e-04	   3.4956141023667744e-02	   1.0737250903658854e-01	  -1.4146939027145361e-01	  -5.1934602779551791e-04	   1.0000000000000000e+00	  -2.9473684210526313e-01	   8.6869806094182808e-02	  -2.5603732322495985e-02	  -0.0000000000000000e+00	  -3.2884149286440846e+07	
   0.0000000000000000e+00	   6.6603362128221322e-02	   1.3929299345066239e-02	   2.1883810893506717e-01	  -6.3880433476327442e-05	  -1.5354899403779046e-01	   1.4789177314831253e-01	   4.7807652831930933e-03	  -1.1174587499686113e-04	   1.0000000000000000e+00	  -2.8421052631578947e-01	   8.0775623268698055e-02	  -2.2957282402682605e-02	  -0.0000000000000000e+00	  -3.2564763542401820e+07	
   0.0000000000000000e+00	   1.4630748208767322e-01	  -6.2153849851647971e-02	   2.0970137016097318e-01	   5.9320392469887186e-03	  -6.6992599968341504e-02	   4.0078905610380966e-02	   4.4277826986989482e-02	  -1.7570376572601729e-02	   1.0000000000000000e+00	  -2.7368421052631581e-01	   7.4903047091412753e-02	  -2.0499781309228755e-02	  -0.0000000000000000e+00	  -3.2235910996290851e+07	
   0.0000000000000000e+00	   1.2219866686111240e-01	  -6.6072630346525565e-02	   1.7786979612228432e-01	   6.6689891161836240e-02	   1.4084140145522778e-01	  -3.2511422854075087e-02	   1.6905921618673117e-02	  -1.2437666637191104e-01	   1.0000000000000000e+00	  -2.6315789473684209e-01	   6.9252077562326861e-02	  -1.8224230937454435e-02	  -0.0000000000000000e+00	  -3.1897453852406133e+07	
   0.0000000000000000e+00	   4.6562990343610049e-02	  -3.8496771687101639e-02	   1.2287402532520451e-01	   1.6928214527850768e-01	   5.7000139595247135e-02	  -3.6706390367607596e-02	   1.2150945715063380e-01	  -1.4146329261726617e-01	   1.0000000000000000e+00	  -2.5263157894736843e-01	   6.3822714681440448e-02	  -1.6123633182679693e-02	  -0.0000000000000000e+00	  -3.1549256225830898e+07	
   0.0000000000000000e+00	   7.9108176051305282e-02	  -1.5916909137952982e-02	   1.7276930071533921e-02	   2.1883869298999215e-01	  -1.3899421988458102e-01	  -1.9555193287451748e-02	   1.5277934764483300e-01	   4.7818640459180925e-03	   1.0000000000000000e+00	  -2.4210526315789474e-01	   5.8614958448753467e-02	  -1.4190989940224523e-02	  -0.0000000000000000e+00	  -3.1191183393587172e+07	
   0.0000000000000000e+00	   1.5059181178604050e-01	   7.9346903717546994e-04	  -6.1299609340202010e-02	   2.0970137016097318e-01	  -6.1077756397279012e-02	  -2.4839600862575958e-02	   4.1433286329292704e-02	   4.4277826986989482e-02	   1.0000000000000000e+00	  -2.3157894736842105e-01	   5.3628808864265930e-02	  -1.2419303105408952e-02	  -0.0000000000000000e+00	  -3.0823097233739205e+07	
   0.0000000000000000e+00	   1.2338720903179384e-01	   6.5312563649638417e-02	  -6.5883845005009184e-02	   1.7786979612228432e-01	   1.4266010677815580e-01	  -1.2651270198897344e-01	  -3.2194092559940712e-02	   1.6905921618673117e-02	   1.0000000000000000e+00	  -2.2105263157894736e-01	   4.8864265927977837e-02	  -1.0801574573552995e-02	  -0.0000000000000000e+00	  -3.0444855215506077e+07	
   0.0000000000000000e+00	   4.6843168115169163e-02	   1.6896481616332268e-01	  -3.8459620343475762e-02	   1.2287402532520451e-01	   5.7459750774509627e-02	  -1.4198814727881801e-01	  -3.6641146885318263e-02	   1.2150945715063380e-01	   1.0000000000000000e+00	  -2.1052631578947367e-01	   4.4321329639889190e-02	  -9.3308062399766710e-03	  -0.0000000000000000e+00	  -3.0056331771375515e+07	
   0.0000000000000000e+00	   7.9166369956801597e-02	   2.1877404877993789e-01	  -1.5910458833395022e-02	   1.7276930071533921e-02	  -1.3889483809391651e-01	   4.6697283257817260e-03	  -1.9542439357979925e-02	   1.5277934764483300e-01	   1.0000000000000000e+00	  -2.0000000000000001e-01	   4.0000000000000008e-02	  -8.0000000000000019e-03	  -0.0000000000000000e+00	  -2.9657376031923760e+07	
   0.0000000000000000e+00	   1.5654632775201785e-01	   2.0968958716836569e-01	  -5.1492639361944087e-03	  -6.1299609340202010e-02	  -7.8607789359785296e-02	   4.4256638627514028e-02	  -7.2883795405942276e-03	   4.1433286329292704e-02	   1.0000000000000000e+00	  -1.8947368421052632e-01	   3.5900277008310250e-02	  -6.8021577489429958e-03	  -0.0000000000000000e+00	  -2.9247849788508385e+07	
   0.0000000000000000e+00	   1.8891309589049748e-01	   1.7786780989340983e-01	  -1.3793137410722976e-03	  -6.4715868244127644e-02	   2.2171450106160298e-02	   1.6902244738169939e-02	  -2.1397124975655688e-03	  -3.6074748498849903e-02	   1.0000000000000000e+00	  -1.7894736842105263e-01	   3.2022160664819943e-02	  -5.7302813821256742e-03	  -0.0000000000000000e+00	  -2.8827620597817719e+07	
   0.0000000000000000e+00	   1.7830349308301938e-01	   1.2295729395787997e-01	  -3.1763991188864764e-04	  -7.2075786879009091e-04	   2.2277570203424468e-04	   1.2120216277613968e-01	  -5.2544368198296078e-04	  -1.2055958103518379e-01	   1.0000000000000000e+00	  -1.6842105263157894e-01	   2.8365650969529085e-02	  -4.7773727948680561e-03	  -0.0000000000000000e+00	  -2.8396549759912662e+07	
   0.0000000000000000e+00	   1.4360733911056495e-01	   3.4960344171481243e-02	  -6.4464488401335120e-05	   1.2080367118123352e-01	   7.2474257985726140e-02	   1.0713332453018319e-01	  -1.1284463772185742e-04	  -1.8048293935946916e-01	   1.0000000000000000e+00	  -1.5789473684210525e-01	   2.4930747922437671e-02	  -3.9364338824901587e-03	  -0.0000000000000000e+00	  -2.7954504561053500e+07	
   0.0000000000000000e+00	   5.4585647698166068e-02	   4.0133449411352815e-02	   5.9320392469887186e-03	   1.9913590528747951e-01	   1.6459027349150931e-01	  -1.1213611896610017e-01	  -1.7570376572601729e-02	  -3.5090021896380212e-02	   1.0000000000000000e+00	  -1.4736842105263157e-01	   2.1717451523545702e-02	  -3.2004665403119982e-03	  -0.0000000000000000e+00	  -2.7501342752012245e+07	
   0.0000000000000000e+00	  -4.3729264683742025e-02	   1.2717877772204980e-01	   6.6689891161836240e-02	   1.5054631959856335e-01	   8.1402624180322181e-02	  -1.2628931867515275e-01	  -1.2437666637191104e-01	   1.7012259471465641e-01	   1.0000000000000000e+00	  -1.3684210526315790e-01	   1.8725761772853188e-02	  -2.5624726636535944e-03	  -0.0000000000000000e+00	  -2.7036898926030204e+07	
   0.0000000000000000e+00	  -7.0585431694760711e-02	   1.4410991420241864e-01	   1.6919856584912857e-01	   5.7499340903434129e-02	  -1.7243637466250763e-02	   8.7668294263458041e-02	  -1.4115658726320315e-01	   7.1071844227003050e-02	   1.0000000000000000e+00	  -1.2631578947368421e-01	   1.5955678670360112e-02	  -2.0154541478349616e-03	  -0.0000000000000000e+00	  -2.6561044027604885e+07	
   0.0000000000000000e+00	  -3.0559847470677894e-02	   4.6262281803949382e-02	   2.0115527889004484e-01	   8.2449176751562048e-02	  -8.5546046269148218e-02	   1.6824864802724551e-01	   5.0427887160567904e-02	  -1.3411869039994689e-01	   1.0000000000000000e+00	  -1.1578947368421053e-01	   1.3407202216066482e-02	  -1.5524128881761190e-03	  -0.0000000000000000e+00	  -2.6073662987834934e+07	
   0.0000000000000000e+00	   7.9354765065273003e-02	  -3.9280997861964380e-02	   1.0826831140941834e-01	   1.5144496303126015e-01	  -1.7892485157676094e-01	   4.0596784138028544e-02	   1.9784723228238235e-01	  -5.9725408787222739e-02	   1.0000000000000000e+00	  -1.0526315789473684e-01	   1.1080332409972297e-02	  -1.1663507799970839e-03	  -0.0000000000000000e+00	  -2.5574620168755420e+07	
   0.0000000000000000e+00	   1.8536197629235854e-01	   6.9405797378132780e-03	  -1.4024849843893137e-02	   1.2240801761242869e-01	  -1.0456455233677675e-01	  -1.4855479862148382e-01	   1.0712049179497599e-01	   1.4685809301119937e-01	   1.0000000000000000e+00	  -9.4736842105263161e-02	   8.9750692520775624e-03	  -8.5026971861787448e-04	  -0.0000000000000000e+00	  -2.5063768014097415e+07	
   0.0000000000000000e+00	   1.8046580350176308e-01	   1.3257177552035235e-01	  -2.1956646746004206e-02	   9.1414569841093644e-03	   1.2069989202041136e-01	  -1.7508498851806065e-01	  -8.6718418148008028e-02	   1.4144342840666449e-01	   1.0000000000000000e+00	  -8.4210526315789472e-02	   7.0914127423822712e-03	  -5.9717159935850702e-04	  -0.0000000000000000e+00	  -2.4540960104356453e+07	
   0.0000000000000000e+00	   7.9327867962882714e-02	   1.8570165287314069e-01	   9.1818499170470996e-02	  -5.7541130031616032e-02	   1.4128889296442082e-01	   3.1618147294305565e-02	  -1.9595294865946716e-01	   2.2057706919459078e-02	   1.0000000000000000e+00	  -7.3684210526315783e-02	   5.4293628808864255e-03	  -4.0005831753899977e-04	  -0.0000000000000000e+00	  -2.4006064559022680e+07	
   0.0000000000000000e+00	   6.1245759079613778e-02	   1.0321791872096504e-01	   1.8306111604883807e-01	  -4.7737752205429779e-02	  -8.8326098732102454e-02	   1.9072667660191583e-01	  -5.1802707918242319e-02	  -5.0804113895143846e-02	   1.0000000000000000e+00	  -6.3157894736842107e-02	   3.9889196675900280e-03	  -2.5193176847937020e-04	  -0.0000000000000000e+00	  -2.3458940367557507e+07	
   0.0000000000000000e+00	   1.3583758405486746e-01	  -1.6553095053473525e-02	   1.4324579548557007e-01	   3.8155439311743367e-02	  -1.2005537111306841e-01	   1.0889515078225322e-01	   1.6599096722370082e-01	  -1.5397151304497084e-01	   1.0000000000000000e+00	  -5.2631578947368418e-02	   2.7700831024930744e-03	  -1.4579384749963548e-04	  -0.0000000000000000e+00	  -2.2899451906451862e+07	
   0.0000000000000000e+00	   1.8399529087474989e-01	  -6.0009814997043241e-02	   1.7927959210752555e-02	   1.5830895417176138e-01	   6.9807737309865725e-03	  -3.3193300259380166e-03	   1.5227812176683891e-01	  -1.5559965171088030e-01	   1.0000000000000000e+00	  -4.2105263157894736e-02	   1.7728531855955678e-03	  -7.4646449919813377e-05	  -0.0000000000000000e+00	  -2.2327463736216143e+07	
   0.0000000000000000e+00	   1.8349712506854510e-01	  -4.4959690999286810e-02	  -5.4721606357904400e-02	   2.1549106226352449e-01	   8.1525933924707084e-03	  -3.5123485615389298e-02	   2.6088401192239274e-02	  -1.0571045060238371e-04	   1.0000000000000000e+00	  -3.1578947368421054e-02	   9.9722991689750701e-04	  -3.1491471059921275e-05	  -0.0000000000000000e+00	  -2.1742838455218170e+07	
   0.0000000000000000e+00	   1.5917100336246193e-01	  -2.1235836167443324e-02	  -4.6995255200558708e-02	   2.0884712964952720e-01	   3.0533342214971990e-02	  -2.4022253921931792e-02	  -4.9640778504690730e-02	   4.2923446268077758e-02	   1.0000000000000000e+00	  -2.1052631578947368e-02	   4.4321329639889195e-04	  -9.3308062399766721e-06	  -0.0000000000000000e+00	  -2.1145430968515009e+07	
   0.0000000000000000e+00	   9.1027390447104617e-02	  -7.5138473220585237e-03	   3.8323193132011824e-02	   1.7884898754164946e-01	   1.5199854644749200e-01	  -1.0155672807933508e-02	  -1.5369157517727328e-01	   1.2707935385629556e-02	   1.0000000000000000e+00	  -1.0526315789473684e-02	   1.1080332409972299e-04	  -1.1663507799970840e-06	  -0.0000000000000000e+00	  -2.0535093915450227e+07	
   0.0000000000000000e+00	  -1.6461758423224705e-02	  -2.1504699265882049e-03	   1.5825888115376921e-01	   1.6057573645626430e-01	   1.2128671310411847e-01	  -3.2381893124437317e-03	  -1.5523438954914651e-01	   3.7525779518478949e-02	   1.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	   0.0000000000000000e+00	  -1.9911701609588567e+07	
   0.0000000000000000e+00	  -5.1969936915044021e-02	  -5.2147702654514955e-04	   1.9781369413486305e-01	   1.5398460978160450e-01	  -3.7520718896508438e-02	  -8.4483521185395067e-04	   4.5551258913208763e-02	  -8.1739062861280725e-03	   1.0000000000000000e+00	   1.0526315789473684e-02	   1.1080332409972299e-04	   1.1663507799970840e-06	   1.1663507799970840e-06	  -1.9275125611193918e+07	
   0.0000000000000000e+00	   4.3554242863295220e-02	  -1.1065424034858019e-04	   1.0741516016419869e-01	   1.4892829285684181e-01	  -1.9259253904782070e-01	  -1.8901221960316596e-04	   1.9649488467232606e-01	  -3.9195773484750167e-03	   1.0000000000000000e+00	   2.1052631578947368e-02	   4.4321329639889195e-04	   9.3308062399766721e-06	   9.3308062399766721e-06	  -1.8625232264776390e+07	
   0.0000000000000000e+00	   1.6335470154090917e-01	   1.1469452396336173e-03	  -1.5381611946291066e-02	   1.5156568896445566e-01	  -1.2548241632627261e-01	  -3.9180483653459804e-03	   1.1068381743975080e-01	   1.9575881099782574e-02	   1.0000000000000000e+00	   3.1578947368421054e-02	   9.9722991689750701e-04	   3.1491471059921275e-05	   3.1491471059921275e-05	  -1.7961888448384833e+07	
   0.0000000000000000e+00	   1.7131887820971695e-01	   3.7735217542446728e-02	  -5.9649081134936638e-02	   1.5081737464299355e-01	   1.0971839048922487e-01	  -8.3925120824484084e-02	  -3.1719328344948406e-03	  -2.2281423069238762e-02	   1.0000000000000000e+00	   4.2105263157894736e-02	   1.7728531855955678e-03	   7.4646449919813377e-05	   7.4646449919813377e-05	  -1.7284953087222628e+07	
   0.0000000000000000e+00	   5.8767500060305407e-02	   1.3671354595970353e-01	  -2.7218846770421114e-02	   1.3104469072529057e-01	   1.8280522986076542e-01	  -1.6094159876421424e-01	  -8.0670516784514076e-02	   5.7818684206681195e-02	   1.0000000000000000e+00	   5.2631578947368418e-02	   2.7700831024930744e-03	   1.4579384749963548e-04	   1.4579384749963548e-04	  -1.6594301290707462e+07	
   0.0000000000000000e+00	  -4.0940490403193273e-02	   2.0428516922367393e-01	   8.0207916310492663e-02	   5.6234446513013805e-02	   6.4060815922217310e-02	  -2.7801642355785985e-02	  -1.7757250396670465e-01	   1.4110708645670056e-01	   1.0000000000000000e+00	   6.3157894736842107e-02	   3.9889196675900280e-03	   2.5193176847937020e-04	   2.5193176847937020e-04	  -1.5889801689018261e+07	
   0.0000000000000000e+00	  -5.8562755482215997e-02	   1.5192563333963566e-01	   1.8555076163387493e-01	   2.1772084307412773e-02	  -2.2363103807147941e-02	   1.7226230721222197e-01	  -1.0424722204264238e-01	  -4.4792747514516867e-02	   1.0000000000000000e+00	   7.3684210526315783e-02	   5.4293628808864255e-03	   4.0005831753899977e-04	   4.0005831753899977e-04	  -1.5171332894279920e+07	
   0.0000000000000000e+00	  -3.6346923353920750e-02	   5.7816980815322772e-02	   1.8041937541600986e-01	   9.8332956382808728e-02	  -3.3469379096026097e-02	   7.1597287908986007e-02	   1.2107184085676369e-01	  -1.5885983590871644e-01	   1.0000000000000000e+00	   8.4210526315789472e-02	   7.0914127423822712e-03	   5.9717159935850702e-04	   5.9717159935850702e-04	  -1.4438759648172289e+07	
   0.0000000000000000e+00	  -1.5395611833060778e-02	   8.2513820961616330e-02	   6.1651263610799256e-02	   1.7053741723552357e-01	  -1.8709649158012306e-02	  -1.3400655467981051e-01	   1.8694625217337149e-01	  -3.5218249816830346e-02	   1.0000000000000000e+00	   9.4736842105263161e-02	   8.9750692520775624e-03	   8.5026971861787448e-04	   8.5026971861787448e-04	  -1.3691952932217911e+07	
   0.0000000000000000e+00	  -5.0396989620721359e-03	   1.5145674602386761e-01	  -3.4242388166118555e-02	   1.8761238274831019e-01	  -7.1014004298465220e-03	  -5.9704220427747284e-02	   4.7696151459019592e-02	   1.8903225455001421e-02	   1.0000000000000000e+00	   1.0526315789473684e-01	   1.1080332409972297e-02	   1.1663507799970839e-03	   1.1663507799970839e-03	  -1.2930769741141085e+07	
   0.0000000000000000e+00	  -1.3582822198243730e-03	   1.2241000384130316e-01	   8.2988619576376543e-03	   1.7133514021959093e-01	  -2.1023200711287751e-03	   1.4686176989170255e-01	  -1.4645247855035504e-01	   2.5522625776960533e-03	   1.0000000000000000e+00	   1.1578947368421053e-01	   1.3407202216066482e-02	   1.5524128881761190e-03	   1.5524128881761190e-03	  -1.2155081930344526e+07	
   0.0000000000000000e+00	  -3.1399497964970549e-04	   9.1417677808130239e-03	   1.3296934992938117e-01	   1.5842526652967609e-01	  -5.1875700736440022e-04	   1.4144401742709561e-01	  -1.7487293686475924e-01	   3.4287590206035223e-02	   1.0000000000000000e+00	   1.2631578947368421e-01	   1.5955678670360112e-02	   2.0154541478349616e-03	   2.0154541478349616e-03	  -1.1364771600352474e+07	
   0.0000000000000000e+00	  -6.4060155129273298e-05	  -5.7541309753268981e-02	   2.0344912712821728e-01	   1.5346313275505935e-01	  -1.1103695741136719e-04	   2.2058415837044570e-02	  -1.3916838862932879e-02	  -9.0187414979820118e-03	   1.0000000000000000e+00	   1.3684210526315790e-01	   1.8725761772853188e-02	   2.5624726636535944e-03	   2.5624726636535944e-03	  -1.0559703577307537e+07	
   0.0000000000000000e+00	  -1.1782992607466748e-05	  -5.3681574445025963e-02	   2.0466276046512732e-01	   1.4881763861649322e-01	  -2.1188359475456707e-05	  -3.3254925682017572e-02	   3.7178459665998420e-02	  -4.1085895680781741e-03	   1.0000000000000000e+00	   1.4736842105263157e-01	   2.1717451523545702e-02	   3.2004665403119982e-03	   3.2004665403119982e-03	  -9.7397521797204204e+06	
   0.0000000000000000e+00	   1.1659905320070671e-03	  -2.8536438078967347e-02	   1.7651151390245995e-01	   1.5154465744320772e-01	  -3.8843328194123690e-03	  -2.9598523553562982e-02	   1.4803601547544343e-02	   1.9538488673345775e-02	   1.0000000000000000e+00	   1.5789473684210525e-01	   2.4930747922437671e-02	   3.9364338824901587e-03	   3.9364338824901587e-03	  -8.9047886006812230e+06	
   0.0000000000000000e+00	   3.7738551677982013e-02	  -1.0973501903449952e-02	   1.2264360977493392e-01	   1.5081372971075463e-01	  -8.3919023170296647e-02	  -1.4136948114045254e-02	   1.2068399478920640e-01	  -2.2288109743857323e-02	   1.0000000000000000e+00	   1.6842105263157894e-01	   2.8365650969529085e-02	   4.7773727948680561e-03	   4.7773727948680561e-03	  -8.0546743582526855e+06	
   0.0000000000000000e+00	   1.3671413001462854e-01	  -3.3474510048147358e-03	   3.4896284016351968e-02	   1.3104392694871261e-01	  -1.6094050000148924e-01	  -4.8882834141059702e-03	   1.0702228757277181e-01	   5.7818294361541699e-02	   1.0000000000000000e+00	   1.7894736842105263e-01	   3.2022160664819943e-02	   5.7302813821256742e-03	   5.7302813821256742e-03	  -7.1892840764447525e+06	
   0.0000000000000000e+00	   2.0428516922367393e-01	   5.0895817281502252e-03	   4.0121666418745344e-02	   5.0290624273417621e-02	  -2.7801642355785985e-02	  -1.8903568932038005e-02	  -1.1215730732557562e-01	   1.5865627466982682e-01	   1.0000000000000000e+00	   1.8947368421052632e-01	   3.5900277008310250e-02	   6.8021577489429958e-03	   6.8021577489429958e-03	  -6.3084860786178336e+06	
   0.0000000000000000e+00	   1.5075765657875412e-01	   6.6503092049194315e-02	   1.2717679149317535e-01	  -4.3751816322416398e-02	   1.7614296315113115e-01	  -1.2469031978554224e-01	  -1.2629299555565593e-01	   7.5699586037981811e-02	   1.0000000000000000e+00	   2.0000000000000001e-01	   4.0000000000000008e-02	   8.0000000000000019e-03	   8.0000000000000019e-03	  -5.4121575398616791e+06	
   0.0000000000000000e+00	   2.0078118340637101e-02	   1.6916172530220636e-01	   1.4419318283509408e-01	  -3.3210637217716936e-02	   1.5551572205885153e-01	  -1.4122124172506137e-01	   8.7360999888963911e-02	  -1.0131556646174690e-01	   1.0000000000000000e+00	   2.1052631578947367e-01	   4.4321329639889190e-02	   9.3308062399766710e-03	   9.3308062399766710e-03	  -4.5001672449266911e+06	
   0.0000000000000000e+00	  -5.4200309053012201e-02	   2.0114882858548688e-01	   6.3945516182243756e-02	   8.8412854260159948e-02	   2.6933945321678716e-02	   5.0415133231096074e-02	   1.2260333383018120e-01	  -2.0094061386423767e-01	   1.0000000000000000e+00	   2.2105263157894736e-01	   4.8864265927977837e-02	   1.0801574573552995e-02	   1.0801574573552995e-02	  -3.5723705129204541e+06	
   0.0000000000000000e+00	  -5.2828423199806310e-02	   1.1421104438278823e-01	   5.6208238649994260e-02	   1.8219618181101094e-01	  -3.1902578071961299e-02	   1.8029601096040063e-01	  -9.5423432944238051e-02	  -5.3176243887774047e-02	   1.0000000000000000e+00	   2.3157894736842105e-01	   5.3628808864265930e-02	   1.2419303105408952e-02	   1.2419303105408952e-02	  -2.6286213762276992e+06	
   0.0000000000000000e+00	  -2.8347652737450959e-02	   5.1499050785936029e-02	   1.3331132507416155e-01	   1.4422300067606075e-01	  -2.9281193259428608e-02	  -1.3371841757522693e-02	  -1.1827703524528801e-01	   1.6178930411015408e-01	   1.0000000000000000e+00	   2.4210526315789474e-01	   5.8614958448753467e-02	   1.4190989940224523e-02	   1.4190989940224523e-02	  -1.6688142544999197e+06	
   0.0000000000000000e+00	  -1.0936350559824077e-02	   1.0950336742514234e-01	   1.4602601284979363e-01	   5.5629359545108691e-02	  -1.4071704631755921e-02	  -1.4395598224091452e-01	   9.0073745519424694e-02	   6.8293855114252955e-02	   1.0000000000000000e+00	   2.5263157894736843e-01	   6.3822714681440448e-02	   1.6123633182679693e-02	   1.6123633182679693e-02	  -6.9281623238137364e+05	
   0.0000000000000000e+00	  -3.3410007002567768e-03	   1.5625982776754024e-01	   6.4402348998734621e-02	   8.1985713908860280e-02	  -4.8755294846341453e-03	   1.5414729585004479e-02	   1.2333603332189878e-01	  -1.3486343490355079e-01	   1.0000000000000000e+00	   2.6315789473684209e-01	   6.9252077562326861e-02	   1.8224230937454435e-02	   1.8224230937454435e-02	   2.9950556338893622e+05	
   0.0000000000000000e+00	  -8.5315124521965287e-04	   9.2988080474178669e-02	   5.6307109897735373e-02	   1.5134500251729271e-01	  -1.3523476100562744e-03	   1.5629697850679977e-01	  -9.5255609084110349e-02	  -5.9895265756205913e-02	   1.0000000000000000e+00	   2.7368421052631581e-01	   7.4903047091412753e-02	   2.0499781309228755e-02	   2.0499781309228755e-02	   1.3082802235329971e+06	
   0.0000000000000000e+00	  -1.8878534151638908e-04	   4.3987189692751984e-02	   1.3449834712741654e-01	   1.2238897232005523e-01	  -3.1733029413437370e-04	  -2.3523837684953017e-02	  -1.2212397563826358e-01	   1.4682437746526575e-01	   1.0000000000000000e+00	   2.8421052631578947e-01	   8.0775623268698055e-02	   2.2957282402682605e-02	   2.2957282402682605e-02	   2.3336263527088910e+06	
   0.0000000000000000e+00	  -3.7151343625874653e-05	   1.0743678772463691e-01	   1.8368463003063548e-01	   9.1381228485740811e-03	  -6.5243482289333469e-05	  -1.4750028788699016e-01	   6.4681143778096140e-03	   1.4143733075247705e-01	   1.0000000000000000e+00	   2.9473684210526313e-01	   8.6869806094182808e-02	   2.5603732322495985e-02	   2.5603732322495985e-02	   3.3756763413345665e+06	
   0.0000000000000000e+00	  -6.4503045579590711e-06	   1.7342158511928946e-01	   1.8343364896834086e-01	  -5.7541893808193988e-02	  -1.2753929471824879e-05	  -3.1075419823913791e-02	   8.0426551977843541e-03	   2.2057317074319575e-02	   1.0000000000000000e+00	   3.0526315789473685e-01	   9.3185595567867041e-02	   2.8446129173348884e-02	   2.8446129173348884e-02	   4.4345758976545855e+06	
   0.0000000000000000e+00	   5.9427329733698778e-03	   1.8836666274578873e-01	   1.5915922036985447e-01	  -5.3681574445025963e-02	  -1.7551221321981732e-02	   2.0087749204929978e-02	   3.0512153855496535e-02	  -3.3254925682017572e-02	   1.0000000000000000e+00	   3.1578947368421051e-01	   9.9722991689750684e-02	   3.1491471059921269e-02	   3.1491471059921269e-02	   5.5104500529150888e+06	
   0.0000000000000000e+00	   6.6691877390710710e-02	   1.7033690350785233e-01	   9.2193380979111672e-02	  -2.8536438078967347e-02	  -1.2437298949140786e-01	   6.7165332648059933e-03	   1.4811421362807964e-01	  -2.9598523553562982e-02	   1.0000000000000000e+00	   3.2631578947368423e-01	   1.0648199445983381e-01	   3.4746756086893135e-02	   3.4746756086893135e-02	   6.6034118503785804e+06	
   0.0000000000000000e+00	   1.6928245607521133e-01	   1.2072022126308102e-01	   2.1193213825378192e-02	  -1.0973501903449952e-02	  -1.4146270359683505e-01	   1.1826517018400264e-01	   3.7674395287884840e-02	  -1.4136948114045254e-02	   1.0000000000000000e+00	   3.3684210526315789e-01	   1.1346260387811634e-01	   3.8218982358944449e-02	   3.8218982358944449e-02	   7.7135919904695749e+06	
   0.0000000000000000e+00	   2.1883869298999215e-01	   1.6754868990063766e-02	   6.7060778999637194e-02	  -3.3474510048147358e-03	   4.7818640459180925e-03	   1.5193341367025404e-01	  -1.5281519578334787e-01	  -4.8882834141059702e-03	   1.0000000000000000e+00	   3.4736842105263160e-01	   1.2066481994459835e-01	   4.1915147980755220e-02	   4.1915147980755220e-02	   8.8411533235496357e+06	
   0.0000000000000000e+00	   2.0970137016097318e-01	  -6.1410263580550593e-02	   1.4640635333541432e-01	   5.0895817281502252e-03	   4.4277826986989482e-02	   4.1244274109689540e-02	  -6.6824776108213801e-02	  -1.8903568932038005e-02	   1.0000000000000000e+00	   3.5789473684210527e-01	   1.2808864265927977e-01	   4.5842251057005394e-02	   4.5842251057005394e-02	   9.9862234019981027e+06	
   0.0000000000000000e+00	   1.7903777288316586e-01	  -6.5904876526257108e-02	   1.2104973539260432e-01	   6.6503092049194315e-02	   1.3025265679763930e-02	  -3.2231484986377505e-02	   1.4475577294007058e-01	  -1.2469031978554224e-01	   1.0000000000000000e+00	   3.6842105263157893e-01	   1.3573407202216065e-01	   5.0007289692374973e-02	   5.0007289692374973e-02	   1.1148932302210726e+07	
   0.0000000000000000e+00	   1.6061288779989019e-01	  -3.8379685846335589e-02	   8.8274620044596595e-03	   1.6916172530220636e-01	   3.7591023000768276e-02	  -3.6954538913999829e-02	   1.4092467139930009e-01	  -1.4122124172506137e-01	   1.0000000000000000e+00	   3.7894736842105264e-01	   1.4360110803324100e-01	   5.4417261991543966e-02	   5.4417261991543966e-02	   1.2329372176345021e+07	
   0.0000000000000000e+00	   1.5399123980781540e-01	   1.7723712116272938e-03	  -5.7605369908398249e-02	   2.0114864886383393e-01	  -8.1618612742417312e-03	  -6.5189561235354729e-02	   2.1947378879633203e-02	   5.0415842148681569e-02	   1.0000000000000000e+00	   3.8947368421052631e-01	   1.5168975069252078e-01	   5.9079166059192299e-02	   5.9079166059192299e-02	   1.3527680857389219e+07	
   0.0000000000000000e+00	   1.4892938212306811e-01	   9.6283794815360410e-02	  -5.3693357437633427e-02	   1.0826722214319204e-01	  -3.9175442396195519e-03	  -1.6085778483598709e-01	  -3.3276114041493027e-02	   1.9784519917352689e-01	   1.0000000000000000e+00	   4.0000000000000002e-01	   1.6000000000000003e-01	   6.4000000000000015e-02	   6.4000000000000015e-02	   1.4744013954299904e+07	
   0.0000000000000000e+00	   1.5156568896445566e-01	   1.9168330898598668e-01	  -2.7370447546960278e-02	  -1.5192826604774678e-02	   1.9575881099782574e-02	  -9.6234938612777626e-02	  -3.3482856372975350e-02	   1.1100114773388517e-01	   1.0000000000000000e+00	   4.1052631578947368e-01	   1.6853185595567868e-01	   6.9186761918647033e-02	   6.9186761918647033e-02	   1.5978502905917309e+07	
   0.0000000000000000e+00	   1.5081737464299355e-01	   1.8225189463400573e-01	   2.6765049774532063e-02	  -5.9611929791310761e-02	  -2.2281423069238762e-02	   1.2378399746679335e-01	  -9.8055971284341889e-02	  -3.1066893522055071e-03	   1.0000000000000000e+00	   4.2105263157894735e-01	   1.7728531855955676e-01	   7.4646449919813368e-02	   7.4646449919813368e-02	   1.7231268692723721e+07	
   0.0000000000000000e+00	   1.3104451100363762e-01	   6.2108096427290121e-02	   1.3336649928816086e-01	  -2.7212216744210212e-02	   5.7819393124266691e-02	   1.8767895166508908e-01	  -1.6582807449800971e-01	  -8.0658471772627749e-02	   1.0000000000000000e+00	   4.3157894736842106e-01	   1.8626038781163437e-01	   8.0386062108179043e-02	   8.0386062108179043e-02	   1.8502441721045829e+07	
   0.0000000000000000e+00	   5.0290624273417621e-02	  -3.4143516918377435e-02	   2.0343092871222798e-01	   8.0209005576718964e-02	   1.5865627466982682e-01	   4.7863975319147309e-02	  -2.9156023074697720e-02	  -1.7757047085784922e-01	   1.0000000000000000e+00	   4.4210526315789472e-01	   1.9545706371191135e-01	   8.6412596588423957e-02	   8.6412596588423957e-02	   1.9792148664706565e+07	
   0.0000000000000000e+00	  -4.4919793083297938e-02	   8.3179072500111015e-03	   1.5056887123723772e-01	   1.8671873839475647e-01	   7.9580241976890995e-02	  -1.4641876300442142e-01	   1.7582563285699679e-01	  -1.0812787798155156e-01	   1.0000000000000000e+00	   4.5263157894736844e-01	   2.0487534626038784e-01	   9.2733051465228172e-02	   9.2733051465228172e-02	   2.1100520328300230e+07	
   0.0000000000000000e+00	  -7.0949499692402607e-02	   1.3297268406491647e-01	   2.0040966997011227e-02	   2.1815823789069552e-01	  -1.7397132311881381e-02	  -1.7486683921057181e-01	   1.5545047857656219e-01	   3.7153406706898165e-02	   1.0000000000000000e+00	   4.6315789473684210e-01	   2.1451523545706372e-01	   9.9354424843271616e-02	   9.9354424843271616e-02	   2.2427701408503219e+07	
   0.0000000000000000e+00	  -4.8301096032815641e-02	   2.0344971118314231e-01	  -5.4206939079223103e-02	   1.9836521390377485e-01	  -4.0000822780333935e-02	  -1.3915740100207880e-02	   2.6921900309792385e-02	   2.6006461089467747e-02	   1.0000000000000000e+00	   4.7368421052631576e-01	   2.2437673130193903e-01	   1.0628371482723427e-01	   1.0628371482723427e-01	   2.3773807935681403e+07	
   0.0000000000000000e+00	  -1.6145165173066793e-02	   2.0466276046512732e-01	  -5.2829512466032617e-02	   1.6409895881795919e-01	  -4.2923789745114335e-02	   3.7178459665998420e-02	  -3.1904611180816757e-02	   3.7443697316359881e-02	   1.0000000000000000e+00	   4.8421052631578948e-01	   2.3445983379501387e-01	   1.1352791952179618e-01	   1.1352791952179618e-01	   2.5138965494905464e+07	
   0.0000000000000000e+00	   5.8989244727135799e-02	   1.7651151390245995e-01	  -2.8347652737450959e-02	   9.3532617906562601e-02	  -1.3484599259347574e-01	   1.4803601547544343e-02	  -2.9281193259428608e-02	   1.5018281815327478e-01	   1.0000000000000000e+00	   4.9473684210526314e-01	   2.4476454293628808e-01	   1.2109403703163725e-01	   1.2109403703163725e-01	   2.6523310263039686e+07	
   0.0000000000000000e+00	   1.6701125537561815e-01	   1.2264360977493392e-01	  -1.0936350559824077e-02	   2.1503874669492613e-02	  -1.4445943103750508e-01	   1.2068399478920640e-01	  -1.4071704631755921e-02	   3.8187054641061799e-02	   1.0000000000000000e+00	   5.0526315789473686e-01	   2.5529085872576179e-01	   1.2898906546143754e-01	   1.2898906546143754e-01	   2.7926978180642635e+07	
   0.0000000000000000e+00	   2.0062717183728879e-01	   3.4896284016351968e-02	  -3.3408209786038308e-03	   6.7124255099841462e-02	   4.9571006936827623e-02	   1.0702228757277181e-01	  -4.8762384022196393e-03	  -1.5270525758866149e-01	   1.0000000000000000e+00	   5.1578947368421058e-01	   2.6603878116343493e-01	   1.3722000291587699e-01	   1.3722000291587699e-01	   2.9350100892358869e+07	
   0.0000000000000000e+00	   1.0815656790284345e-01	   4.0121666418745344e-02	   5.0906709943765328e-03	   1.4641813632802181e-01	   1.9765618695392373e-01	  -1.1215730732557562e-01	  -1.8901535823182544e-02	  -6.6803587748738347e-02	   1.0000000000000000e+00	   5.2631578947368418e-01	   2.7700831024930744e-01	   1.4579384749963548e-01	   1.4579384749963548e-01	   3.0792791682040647e+07	
   0.0000000000000000e+00	  -1.5213858126022602e-02	   1.2834476825405688e-01	   6.6503092049194315e-02	   1.2105172162147879e-01	   1.1096375530744837e-01	  -1.3017365149456511e-01	  -1.2469031978554224e-01	   1.4475944982057376e-01	   1.0000000000000000e+00	   5.3684210526315790e-01	   2.8819944598337949e-01	   1.5471759731739321e-01	   1.5471759731739321e-01	   3.2255188890072003e+07	
   0.0000000000000000e+00	  -5.9699154152928820e-02	   1.8184846588040063e-01	   1.6924530473158547e-01	   8.8277728011633191e-03	  -2.8066706727610594e-03	   3.7492710931613937e-03	  -1.4152794707912439e-01	   1.4092526041973122e-01	   1.0000000000000000e+00	   5.4736842105263162e-01	   2.9961218836565101e-01	   1.6399825047383004e-01	   1.6399825047383004e-01	   3.3737424698033422e+07	
   0.0000000000000000e+00	  -4.4896214899082541e-02	   1.8297623209692498e-01	   2.1883206296378127e-01	  -5.7605190186745300e-02	  -3.5013547420702930e-02	   7.3088569433417683e-03	   4.7698190340317581e-03	   2.1946669962047711e-02	   1.0000000000000000e+00	   5.5789473684210522e-01	   3.1124653739612185e-01	   1.7364280507362584e-01	   1.7364280507362584e-01	   3.5239632326350734e+07	
   0.0000000000000000e+00	  -2.1224053174835857e-02	   1.5906034912211336e-01	   2.0970028089474685e-01	  -4.7749535198037242e-02	  -2.4001065562456333e-02	   3.0344329995368825e-02	   4.4275793878134018e-02	  -5.0825302254619301e-02	   1.0000000000000000e+00	   5.6842105263157894e-01	   3.2310249307479222e-01	   1.8365825922146084e-01	   1.8365825922146084e-01	   3.6761934819881216e+07	
   0.0000000000000000e+00	  -7.5118610931840489e-03	   9.1006358925856679e-02	   1.7903777288316586e-01	   3.8153453082868889e-02	  -1.0151995927430326e-02	   1.5196115402105520e-01	   1.3025265679763930e-02	  -1.5397518992547402e-01	   1.0000000000000000e+00	   5.7894736842105265e-01	   3.3518005540166207e-01	   1.9405161102201490e-01	   1.9405161102201490e-01	   3.8304448683193475e+07	
   0.0000000000000000e+00	  -2.0665797005054313e-03	  -1.6548982784842764e-02	   1.6061288779989019e-01	   1.5822506394567862e-01	  -3.5443056460756225e-03	   1.2158673178356291e-01	   3.7591023000768276e-02	  -1.5529353537724841e-01	   1.0000000000000000e+00	   5.8947368421052626e-01	   3.4747922437673123e-01	   2.0482985857996788e-01	   2.0482985857996788e-01	   3.9867328474246711e+07	
   0.0000000000000000e+00	   1.7161937073402172e-02	  -6.9653755348263402e-02	   1.5399106008616245e-01	   1.9780764816357715e-01	  -4.6490858326503764e-02	   8.1234965378308831e-03	  -8.1611523566562372e-03	   4.5540312664047428e-02	   1.0000000000000000e+00	   5.9999999999999998e-01	   3.5999999999999999e-01	   2.1599999999999997e-01	   2.1599999999999997e-01	   4.1450727994291037e+07	
   0.0000000000000000e+00	   1.0132240451120625e-01	  -5.1934993648663420e-02	   1.4298555988347192e-01	   1.0741407089797238e-01	  -1.5375841751499603e-01	  -5.6572321965554090e-02	   1.3631643973506719e-02	   1.9649285156347063e-01	   1.0000000000000000e+00	   6.1052631578947369e-01	   3.7274238227146816e-01	   2.2756903338679108e-01	   2.2756903338679108e-01	   4.3054756450479880e+07	
   0.0000000000000000e+00	   1.9304159120581105e-01	   3.6983956204560908e-02	   8.6041788334626473e-02	  -1.5381611946291066e-02	  -9.4132618541648852e-02	  -1.5576017970246842e-01	   1.4006821465228125e-01	   1.1068381743975080e-01	   1.0000000000000000e+00	   6.2105263157894741e-01	   3.8570637119113577e-01	   2.3954395684502119e-01	   2.3954395684502119e-01	   4.4679530292131960e+07	
   0.0000000000000000e+00	   1.8264946904303456e-01	   1.5794822030965477e-01	   1.9357360471847010e-02	  -5.9732660564315754e-02	   1.2399604912009474e-01	  -1.5574704890232346e-01	   3.4956141023667744e-02	  -2.8652274804318320e-03	   1.0000000000000000e+00	   6.3157894736842102e-01	   3.9889196675900274e-01	   2.5193176847937016e-01	   2.5193176847937016e-01	   4.6325184495605588e+07	
   0.0000000000000000e+00	   7.9855390960713771e-02	   1.9775039775631173e-01	   6.6603362128221322e-02	  -4.4902260870368436e-02	   1.4214467442543610e-01	   4.5440611800936892e-02	  -1.5354899403779046e-01	  -3.5024493669864265e-02	   1.0000000000000000e+00	   6.4210526315789473e-01	   4.1229916897506924e-01	   2.6473946639451817e-01	   2.6473946639451817e-01	   4.7991846162983879e+07	
   0.0000000000000000e+00	   6.1357502586188668e-02	   1.1334719941118741e-01	   1.4630748208767322e-01	  -2.1225142441062165e-02	  -8.8135053403643832e-02	   1.7892450809972435e-01	  -6.6992599968341504e-02	  -2.4003098671311795e-02	   1.0000000000000000e+00	   6.5263157894736845e-01	   4.2592797783933523e-01	   2.7797404869514508e-01	   2.7797404869514508e-01	   4.9679642121459484e+07	
   0.0000000000000000e+00	   1.3469063881523385e-01	   5.1308279215545170e-02	   1.2219866686111240e-01	  -7.5118610931840489e-03	  -1.1613732274772244e-01	  -1.3692848932160245e-02	   1.4084140145522778e-01	  -1.0151995927430326e-02	   1.0000000000000000e+00	   6.6315789473684206e-01	   4.3977839335180047e-01	   2.9164251348593084e-01	   2.9164251348593084e-01	   5.1388713588894203e+07	
   0.0000000000000000e+00	   1.4626007333230318e-01	   1.0946590528481281e-01	   4.6562990343610049e-02	  -2.0665797005054313e-03	   9.0905894555470657e-02	  -1.4402181474363498e-01	   5.7000139595247135e-02	  -3.5443056460756225e-03	   1.0000000000000000e+00	   6.7368421052631577e-01	   4.5385041551246535e-01	   3.0575185887155559e-01	   3.0575185887155559e-01	   5.3119190209192812e+07	
   0.0000000000000000e+00	   4.6783579108841580e-02	   1.5625301801967639e-01	   7.9108355772958230e-02	   1.7161937073402172e-02	   1.6909419215668495e-01	   1.5403393490703639e-02	  -1.3899492880216652e-01	  -4.6490858326503764e-02	   1.0000000000000000e+00	   6.8421052631578949e-01	   4.6814404432132967e-01	   3.2030908295669924e-01	   3.2030908295669924e-01	   5.4871193086425975e+07	
   0.0000000000000000e+00	  -4.5114165861211988e-02	   8.7043168968356177e-02	   1.5653563402563669e-01	   1.0132240451120625e-01	   5.8334984570757975e-02	   1.7384413361107057e-01	  -7.8626944610405286e-02	  -1.5375841751499603e-01	   1.0000000000000000e+00	   6.9473684210526321e-01	   4.8265927977839340e-01	   3.3532118384604176e-01	   3.3532118384604176e-01	   5.6644850124556869e+07	
   0.0000000000000000e+00	  -5.8562289370767968e-02	  -2.2704687697958727e-02	   1.8891110966162300e-01	   1.9304159120581105e-01	  -2.8025072642548346e-02	   1.0084915180645485e-01	   2.2167773225657120e-02	  -9.4132618541648852e-02	   1.0000000000000000e+00	   7.0526315789473681e-01	   4.9739612188365645e-01	   3.5079515964426300e-01	   3.5079515964426300e-01	   5.8440306078570858e+07	
   0.0000000000000000e+00	   1.1154062814447488e-03	  -6.1845668350574423e-02	   1.7838676171569481e-01	   1.8256588961365544e-01	  -1.1784073775053558e-01	  -6.0375842901551121e-03	  -8.4518672459887964e-05	   1.2430275447415774e-01	   1.0000000000000000e+00	   7.1578947368421053e-01	   5.1235457063711909e-01	   3.6673800845604315e-01	   3.6673800845604315e-01	   6.0257698738376126e+07	
   0.0000000000000000e+00	   1.2126126777430234e-01	  -4.5417107870702682e-02	   1.6129075321051228e-01	   6.2171976860766448e-02	  -1.7974985002261207e-01	  -3.5857283869831884e-02	   2.6828234871076329e-02	   1.8779069754008593e-01	   1.0000000000000000e+00	   7.2631578947368425e-01	   5.2753462603878121e-01	   3.8315672838606218e-01	   3.8315672838606218e-01	   6.2097159447418898e+07	
   0.0000000000000000e+00	   2.0517859877481684e-01	  -2.1334707415184437e-02	   1.5601870644972088e-01	  -4.0075556165366157e-02	  -5.2471386249378776e-02	  -2.4190077782059498e-02	   1.1020868196116446e-02	   6.5434351891749037e-02	   1.0000000000000000e+00	   7.3684210526315785e-01	   5.4293628808864258e-01	   4.0005831753899979e-01	   4.0005831753899979e-01	   6.3958803792432591e+07	
   0.0000000000000000e+00	   2.1608926552076596e-01	  -7.5328926144319734e-03	   1.4933335804331696e-01	  -5.7204007150943592e-02	   4.9663976708091320e-02	  -1.0189388353867119e-02	  -1.2692601934889872e-02	  -2.5922752571419572e-02	   1.0000000000000000e+00	   7.4736842105263157e-01	   5.5855955678670355e-01	   4.1744977401953637e-01	   4.1744977401953637e-01	   6.5842753707203761e+07	
   0.0000000000000000e+00	   1.8896268921011594e-01	  -2.1538040621234878e-03	   1.1198410285113368e-01	   1.4294012610944554e-03	   1.3840377788283981e-02	  -3.2442869666311747e-03	   1.0706580368252554e-01	  -1.1732198074317117e-01	   1.0000000000000000e+00	   7.5789473684210529e-01	   5.7440443213296399e-01	   4.3533809593235173e-01	   4.3533809593235173e-01	   6.7749140587336496e+07	
   0.0000000000000000e+00	   1.4689090968190335e-01	  -5.2188135981721137e-04	   3.1612713445013561e-02	   1.2132514820777866e-01	   7.7250795524835256e-02	  -8.4664289216444095e-04	   1.0224575003366272e-01	  -1.7963810414761522e-01	   1.0000000000000000e+00	   7.6842105263157889e-01	   5.9047091412742370e-01	   4.5373028138212557e-01	   4.5373028138212557e-01	   6.9678108008850276e+07	
   0.0000000000000000e+00	   5.5428105217004565e-02	   5.8331679992476050e-03	   3.9279208899906853e-02	   1.9924655952782810e-01	   1.6592346585094558e-01	  -1.7738200432729435e-02	  -1.1349049968501190e-01	  -3.4901009676777048e-02	   1.0000000000000000e+00	   7.7894736842105261e-01	   6.0675900277008310e-01	   4.7263332847353839e-01	   4.7263332847353839e-01	   7.1629787035486892e+07	
   0.0000000000000000e+00	  -4.2374488810218575e-02	   6.6670845869462786e-02	   1.2698999238053343e-01	   1.4939937435892975e-01	   7.7835621655044193e-02	  -1.2441038191784466e-01	  -1.2660664896928714e-01	   1.7404064308000236e-01	   1.0000000000000000e+00	   7.8947368421052633e-01	   6.2326869806094187e-01	   4.9205423531126991e-01	   4.9205423531126991e-01	   7.3604299627690956e+07	
   0.0000000000000000e+00	  -3.2893308102531944e-02	   1.6919523171359327e-01	   1.4407276285879275e-01	   1.9847702790366510e-02	  -1.0079071180019505e-01	  -1.4116268491739059e-01	   8.7603050781168701e-02	   1.5469025969742412e-01	   1.0000000000000000e+00	   8.0000000000000004e-01	   6.4000000000000012e-01	   5.1200000000000012e-01	   5.1200000000000012e-01	   7.5601781557119071e+07	
   0.0000000000000000e+00	   8.8477498470214216e-02	   2.0115487455677278e-01	   4.6255472056085531e-02	  -3.6580955108194153e-02	  -2.0082847814410132e-01	   5.0426079480257409e-02	   1.6823731193294467e-01	  -1.8823114750382463e-02	   1.0000000000000000e+00	   8.1052631578947365e-01	   6.5695290858725752e-01	   5.3247762064440873e-01	   5.3247762064440873e-01	   7.7622359293640539e+07	
   0.0000000000000000e+00	   1.8220796480361842e-01	   1.1421213364901453e-01	  -4.5225909367786872e-02	   4.8592852559141052e-02	  -5.3155055528298592e-02	   1.8029804406925609e-01	   5.8143939242299353e-02	  -1.8549317172682961e-01	   1.0000000000000000e+00	   8.2105263157894737e-01	   6.7412742382271473e-01	   5.5349409534917626e-01	   5.5349409534917626e-01	   7.9666160208791256e+07	
   0.0000000000000000e+00	   1.4422498690493521e-01	   5.1499050785936029e-02	  -5.9751297652897432e-02	   1.6471298376073357e-01	   1.6179298099065725e-01	  -1.3371841757522693e-02	  -2.4181809130075956e-02	  -1.2338009625514385e-01	   1.0000000000000000e+00	   8.3157894736842108e-01	   6.9152354570637120e-01	   5.7505642221898245e-01	   5.7505642221898245e-01	   8.1733321542241797e+07	
   0.0000000000000000e+00	   5.5629670341812348e-02	   1.0950336742514234e-01	  -3.6627101125479865e-02	   1.7171645261874577e-01	   6.8294444134684051e-02	  -1.4395598224091452e-01	  -3.3928990275288611e-02	   1.0993044214252626e-01	   1.0000000000000000e+00	   8.4210526315789469e-01	   7.0914127423822704e-01	   5.9717159935850694e-01	   5.9717159935850694e-01	   8.3823983214631885e+07	
   0.0000000000000000e+00	   8.1985713908860280e-02	   1.5625982776754024e-01	  -1.5453626016904153e-02	   7.6514974315381998e-02	  -1.3486343490355079e-01	   1.5414729585004479e-02	  -1.8809739866262339e-02	   1.3727024370352697e-01	   1.0000000000000000e+00	   8.5263157894736841e-01	   7.2698060941828258e-01	   6.1984662487243036e-01	   6.1984662487243036e-01	   8.5938269240893766e+07	
   0.0000000000000000e+00	   1.5134500251729271e-01	   9.2988080474178669e-02	  -5.0503926884532951e-03	   6.0504351340969015e-02	  -5.9895265756205913e-02	   1.5629697850679977e-01	  -7.1205556804665180e-03	  -8.9487401013700105e-02	   1.0000000000000000e+00	   8.6315789473684212e-01	   7.4504155124653748e-01	   6.4308849686543235e-01	   6.4308849686543235e-01	   8.8076292616174176e+07	
   0.0000000000000000e+00	   1.2238897232005523e-01	   4.3987189692751984e-02	  -1.9229168781730597e-04	   1.3450185347371746e-01	   1.4682437746526575e-01	  -2.3523837684953017e-02	  -5.9866528905411446e-03	  -1.1645465304185681e-01	   1.0000000000000000e+00	   8.7368421052631584e-01	   7.6332409972299176e-01	   6.6690421344219286e-01	   6.6690421344219286e-01	   9.0238174707291275e+07	
   0.0000000000000000e+00	   9.1381228485740811e-03	   1.0735320829525780e-01	   3.7424556698332306e-02	   1.4630650141805643e-01	   1.4143733075247705e-01	  -1.4719358253292714e-01	  -8.4437780177661043e-02	   9.0533945719118311e-02	   1.0000000000000000e+00	   8.8421052631578945e-01	   7.8182825484764540e-01	   6.9130077270739165e-01	   6.9130077270739165e-01	   9.2424069093082637e+07	
   0.0000000000000000e+00	  -5.7541893808193988e-02	   1.5573835074099510e-01	   1.3665006985949926e-01	   6.4460363182578001e-02	   2.2057317074319575e-02	   1.4569894373150526e-02	  -1.6105153695890059e-01	   1.2343612403014882e-01	   1.0000000000000000e+00	   8.9473684210526316e-01	   8.0055401662049863e-01	   7.1628517276570935e-01	   7.1628517276570935e-01	   9.4634114440171003e+07	
   0.0000000000000000e+00	  -5.3681574445025963e-02	   9.2877426233830093e-02	   2.0427338623106647e-01	   5.6317803624116536e-02	  -3.3254925682017572e-02	   1.5610796628719659e-01	  -2.7822830715261444e-02	  -9.5236453833490359e-02	   1.0000000000000000e+00	   9.0526315789473688e-01	   8.1950138504155134e-01	   7.4186441172182538e-01	   7.4186441172182538e-01	   9.6868439125350088e+07	
   0.0000000000000000e+00	  -2.8536438078967347e-02	   4.3966158171504059e-02	   1.5192364711076117e-01	   1.3333235659540948e-01	  -2.9598523553562982e-02	  -2.3561230111389816e-02	   1.7225863033171879e-01	  -1.1823964281885121e-01	   1.0000000000000000e+00	   9.1578947368421049e-01	   8.3867036011080320e-01	   7.6804548768041980e-01	   7.6804548768041980e-01	   9.9127162507476807e+07	
   0.0000000000000000e+00	  -1.0889922474070838e-02	   1.0734956336301885e-01	   5.7816670018619114e-02	   1.4594607835265347e-01	  -1.4443653468108263e-02	  -1.4720026920754570e-01	   7.1596698888554883e-02	   9.0387137548106261e-02	   1.0000000000000000e+00	   9.2631578947368420e-01	   8.5806094182825488e-01	   7.9483539874617293e-01	   7.9483539874617293e-01	   1.0141041149911594e+08	
   0.0000000000000000e+00	   1.4335783373479641e-02	   1.5573758696441714e-01	   8.2513820961616330e-02	   4.6719698675365254e-02	  -5.0533597611170288e-02	   1.4569504528011028e-02	  -1.3400655467981051e-01	   1.6898244628168810e-01	   1.0000000000000000e+00	   9.3684210526315792e-01	   8.7767313019390591e-01	   8.2224114302376450e-01	   8.2224114302376450e-01	   1.0371832633873191e+08	
   0.0000000000000000e+00	   1.0057881824010886e-01	   8.6933603994233902e-02	   1.5145674602386761e-01	  -3.9182126614223267e-02	  -1.5492378601430459e-01	   1.7365715450032285e-01	  -5.9704220427747284e-02	   4.0764607998156246e-02	   1.0000000000000000e+00	   9.4736842105263153e-01	   8.9750692520775610e-01	   8.5026971861787415e-01	   8.5026971861787415e-01	   1.0605103777870619e+08	
   0.0000000000000000e+00	   1.9404181414642413e-01	  -2.2725719219206651e-02	   1.2241000384130316e-01	   6.9596250301867321e-03	  -9.8293212348255610e-02	   1.0081175938001805e-01	   1.4686176989170255e-01	  -1.4852108307555020e-01	   1.0000000000000000e+00	   9.5789473684210524e-01	   9.1756232686980610e-01	   8.7892812363318262e-01	   8.7892812363318262e-01	   1.0840866954560232e+08	
   0.0000000000000000e+00	   2.2027124567695419e-01	  -6.1849313282813366e-02	   9.1417677808130239e-03	   1.3257510965588765e-01	   4.0325763516621441e-02	  -6.0442709647736733e-03	   1.4144401742709561e-01	  -1.7507889086387318e-01	   1.0000000000000000e+00	   9.6842105263157896e-01	   9.3783933518005547e-01	   9.0822335617436944e-01	   9.0822335617436944e-01	   1.1079135118806735e+08	
   0.0000000000000000e+00	   1.9888006090410909e-01	  -4.5417691925627689e-02	  -5.7541309753268981e-02	   1.8570223692806570e-01	   2.6839251289435345e-02	  -3.5858382632556876e-02	   2.2058415837044570e-02	   3.1619246057030564e-02	   1.0000000000000000e+00	   9.7894736842105268e-01	   9.5833795013850420e-01	   9.3816241434611469e-01	   9.3816241434611469e-01	   1.1319921057647294e+08	
   0.0000000000000000e+00	   1.6420852379208145e-01	  -2.1334707415184437e-02	  -5.3681574445025963e-02	   1.0321791872096504e-01	   3.7630676427107587e-02	  -2.4190077782059498e-02	  -3.3254925682017572e-02	   1.9072667660191583e-01	   1.0000000000000000e+00	   9.8947368421052628e-01	   9.7905817174515231e-01	   9.6875229625309800e-01	   9.6875229625309800e-01	   1.1563238092136064e+08	
   0.0000000000000000e+00	   9.2385672666928986e-02	  -7.5328926144319734e-03	  -2.8536438078967347e-02	  -1.6553095053473525e-02	   1.5410086651862076e-01	  -1.0189388353867119e-02	  -2.9598523553562982e-02	   1.0889515078225322e-01	   1.0000000000000000e+00	   1.0000000000000000e+00	   1.0000000000000000e+00	   1.0000000000000000e+00	   1.0000000000000000e+00	   1.1809099716453132e+08	
"""}

# convert to arrays for convenience
for key, val in fmristat.items():
    fmristat[key] = np.fromstring(val, sep='\t').reshape(N_ROWS,-1).T


# time vector
time_vector = np.arange(N_ROWS)*2.5+1.25
