# Fluent Bit & Governance

Fluent Bit is a CNCF sub-project under the umbrella of Fluentd.



## Your organization is not yet a maintainer

The following items describes the global process for an individual to become a maintainer:

* Express interest to maintainers that your organization is interested in becoming a
  maintainer. Becoming a maintainer generally means that you are going to be spending substantial
  time on Fluent Bit for the foreseeable future. You should have domain expertise and be extremely
  proficient in C. Ultimately your goal is to become a maintainer that will represent your
  organization.
* We will expect you to start contributing increasingly complicated PRs, under the guidance
  of the existing maintainers.
* We may ask you to do some PRs from our backlog.
* As you gain experience with the code base and our standards, we will ask you to do code reviews
  for incoming PRs (i.e., all maintainers are expected to shoulder a proportional share of
  community reviews).
* After a period of approximately 6-8 months of working together and making sure we see eye to eye,
  the existing maintainers will confer and decide whether to grant maintainer status or not.
  We make no guarantees on the length of time this will take, but 6-8 months is the approximate
  goal.

Note that maintainer status is primary assigned to the individual, the organization that support his work gets an _honor title_ of _maintainer organization_, but If the maintainer moves to a new organization the _honor title_ is transferred. 

## Maintainer responsibilities

* Monitor Slack (delayed response is perfectly acceptable).
* Triage GitHub issues and perform pull request reviews for other maintainers and the community.
* Triage build issues - file issues for known flaky builds or bugs, and either fix or find someone
  to fix any master build breakages.
* Make sure that ongoing PRs are moving forward at the right pace or closing them.
* In general continue to be willing to spend at least 25% of ones time working on Fluent Bit (~1.25
  business days per week).

## When does a maintainer lose maintainer status

If a maintainer is no longer interested or cannot perform the maintainer duties listed above, they
should volunteer to quit the existing role.

## Conflict resolution and voting

In general, we prefer that technical issues and maintainer membership are amicably worked out
between the persons involved. If a dispute cannot be decided independently, the maintainers can be
called in to decide an issue. If the maintainers themselves cannot decide an issue, the issue will
be resolved by voting. 