<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/collectors/proc.plugin/integrations/memory_usage.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/collectors/proc.plugin/metadata.yaml"
sidebar_label: "Memory Usage"
learn_status: "Published"
learn_rel_path: "Data Collection/Linux Systems/Memory"
most_popular: False
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# Memory Usage


<img src="https://netdata.cloud/img/linuxserver.svg" width="150"/>


Plugin: proc.plugin
Module: /proc/meminfo

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview

`/proc/meminfo` provides detailed information about the system's current memory usage. It includes information
about different types of memory, RAM, Swap, ZSwap, HugePages, Transparent HugePages (THP), Kernel memory,
SLAB memory, memory mappings, and more.

Monitoring /proc/meminfo can be useful for:

- **Performance Tuning**: Understanding your system's memory usage can help you make decisions about system
  tuning and optimization. For example, if your system is frequently low on free memory, it might benefit
  from more RAM.

- **Troubleshooting**: If your system is experiencing problems, `/proc/meminfo` can provide clues about
  whether memory usage is a factor. For example, if your system is slow and cached swap is high, it could
  mean that your system is swapping out a lot of memory to disk, which can degrade performance.

- **Capacity Planning**: By monitoring memory usage over time, you can understand trends and make informed
  decisions about future capacity needs.




This collector is supported on all platforms.

This collector only supports collecting metrics from a single instance of this integration.


### Default Behavior

#### Auto-Detection

This integration doesn't support auto-detection.

#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

The default configuration for this integration is not expected to impose a significant performance impact on the system.


## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.



### Per Memory Usage instance



This scope has no labels.

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| system.ram | free, used, cached, buffers | MiB |
| mem.available | avail | MiB |
| mem.swap | free, used | MiB |
| mem.swap_cached | cached | MiB |
| mem.zswap | in-ram, on-disk | MiB |
| mem.hwcorrupt | HardwareCorrupted | MiB |
| mem.commited | Commited_AS | MiB |
| mem.writeback | Dirty, Writeback, FuseWriteback, NfsWriteback, Bounce | MiB |
| mem.kernel | Slab, KernelStack, PageTables, VmallocUsed, Percpu | MiB |
| mem.slab | reclaimable, unreclaimable | MiB |
| mem.hugepages | free, used, surplus, reserved | MiB |
| mem.thp | anonymous, shmem | MiB |
| mem.thp_details | ShmemPmdMapped, FileHugePages, FilePmdMapped | MiB |
| mem.reclaiming | Active, Inactive, Active(anon), Inactive(anon), Active(file), Inactive(file), Unevictable, Mlocked | MiB |
| mem.high_low | high_used, low_used, high_free, low_free | MiB |
| mem.cma | used, free | MiB |
| mem.directmaps | 4k, 2m, 4m, 1g | MiB |



## Alerts


The following alerts are available:

| Alert name  | On metric | Description |
|:------------|:----------|:------------|
| [ ram_in_use ](https://github.com/netdata/netdata/blob/master/health/health.d/ram.conf) | system.ram | system memory utilization |
| [ ram_available ](https://github.com/netdata/netdata/blob/master/health/health.d/ram.conf) | mem.available | percentage of estimated amount of RAM available for userspace processes, without causing swapping |
| [ used_swap ](https://github.com/netdata/netdata/blob/master/health/health.d/swap.conf) | mem.swap | swap memory utilization |
| [ 1hour_memory_hw_corrupted ](https://github.com/netdata/netdata/blob/master/health/health.d/memory.conf) | mem.hwcorrupt | amount of memory corrupted due to a hardware failure |


## Setup

### Prerequisites

No action required.

### Configuration

#### File

There is no configuration file.
#### Options



There are no configuration options.

#### Examples
There are no configuration examples.


