/*
    Copyright (c) 2013 Evan Wies <evan@neomantra.net>
    Copyright (c) 2013 GoPivotal, Inc.  All rights reserved.

    Permission is hereby granted, free of charge, to any person obtaining a copy
    of this software and associated documentation files (the "Software"),
    to deal in the Software without restriction, including without limitation
    the rights to use, copy, modify, merge, publish, distribute, sublicense,
    and/or sell copies of the Software, and to permit persons to whom
    the Software is furnished to do so, subject to the following conditions:

    The above copyright notice and this permission notice shall be included
    in all copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
    THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
    FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
    IN THE SOFTWARE.
*/

#include "../nn.h"

#include "../inproc.h"
#include "../ipc.h"
#include "../tcp.h"

#include "../pair.h"
#include "../pubsub.h"
#include "../reqrep.h"
#include "../pipeline.h"
#include "../survey.h"
#include "../bus.h"

#include <string.h>

static const struct nn_symbol_properties sym_value_names [] = {
    {NN_NS_NAMESPACE, "NN_NS_NAMESPACE", NN_NS_NAMESPACE,
        NN_TYPE_NONE, NN_UNIT_NONE},
    {NN_NS_VERSION, "NN_NS_VERSION", NN_NS_NAMESPACE,
        NN_TYPE_NONE, NN_UNIT_NONE},
    {NN_NS_DOMAIN, "NN_NS_DOMAIN", NN_NS_NAMESPACE,
        NN_TYPE_NONE, NN_UNIT_NONE},
    {NN_NS_TRANSPORT, "NN_NS_TRANSPORT", NN_NS_NAMESPACE,
        NN_TYPE_NONE, NN_UNIT_NONE},
    {NN_NS_PROTOCOL, "NN_NS_PROTOCOL", NN_NS_NAMESPACE,
        NN_TYPE_NONE, NN_UNIT_NONE},
    {NN_NS_OPTION_LEVEL, "NN_NS_OPTION_LEVEL", NN_NS_NAMESPACE,
        NN_TYPE_NONE, NN_UNIT_NONE},
    {NN_NS_SOCKET_OPTION, "NN_NS_SOCKET_OPTION", NN_NS_NAMESPACE,
        NN_TYPE_NONE, NN_UNIT_NONE},
    {NN_NS_TRANSPORT_OPTION, "NN_NS_TRANSPORT_OPTION", NN_NS_NAMESPACE,
        NN_TYPE_NONE, NN_UNIT_NONE},
    {NN_NS_OPTION_TYPE, "NN_NS_OPTION_TYPE", NN_NS_NAMESPACE,
        NN_TYPE_NONE, NN_UNIT_NONE},
	 {NN_NS_OPTION_UNIT, "NN_NS_OPTION_UNIT", NN_NS_NAMESPACE,
			NN_TYPE_NONE, NN_UNIT_NONE},
    {NN_NS_FLAG, "NN_NS_FLAG", NN_NS_NAMESPACE,
        NN_TYPE_NONE, NN_UNIT_NONE},
    {NN_NS_ERROR, "NN_NS_ERROR", NN_NS_NAMESPACE,
        NN_TYPE_NONE, NN_UNIT_NONE},
    {NN_NS_LIMIT, "NN_NS_LIMIT", NN_NS_NAMESPACE,
        NN_TYPE_NONE, NN_UNIT_NONE},

    {NN_TYPE_NONE, "NN_TYPE_NONE", NN_NS_OPTION_TYPE,
        NN_TYPE_NONE, NN_UNIT_NONE},
    {NN_TYPE_INT, "NN_TYPE_INT", NN_NS_OPTION_TYPE,
        NN_TYPE_NONE, NN_UNIT_NONE},
    {NN_TYPE_STR, "NN_TYPE_STR", NN_NS_OPTION_TYPE,
        NN_TYPE_NONE, NN_UNIT_NONE},

    {NN_UNIT_NONE, "NN_UNIT_NONE", NN_NS_OPTION_UNIT,
        NN_TYPE_NONE, NN_UNIT_NONE},
    {NN_UNIT_BYTES, "NN_UNIT_BYTES", NN_NS_OPTION_UNIT,
        NN_TYPE_NONE, NN_UNIT_NONE},
    {NN_UNIT_MILLISECONDS, "NN_UNIT_MILLISECONDS", NN_NS_OPTION_UNIT,
        NN_TYPE_NONE, NN_UNIT_NONE},
    {NN_UNIT_PRIORITY, "NN_UNIT_PRIORITY", NN_NS_OPTION_UNIT,
        NN_TYPE_NONE, NN_UNIT_NONE},
    {NN_UNIT_BOOLEAN, "NN_UNIT_BOOLEAN", NN_NS_OPTION_UNIT,
        NN_TYPE_NONE, NN_UNIT_NONE},

    {NN_VERSION_CURRENT, "NN_VERSION_CURRENT", NN_NS_VERSION,
        NN_TYPE_NONE, NN_UNIT_NONE},
    {NN_VERSION_REVISION, "NN_VERSION_REVISION", NN_NS_VERSION,
        NN_TYPE_NONE, NN_UNIT_NONE},
    {NN_VERSION_AGE, "NN_VERSION_AGE", NN_NS_VERSION,
        NN_TYPE_NONE, NN_UNIT_NONE},

    {AF_SP, "AF_SP", NN_NS_DOMAIN,
        NN_TYPE_NONE, NN_UNIT_NONE},
    {AF_SP_RAW, "AF_SP_RAW", NN_NS_DOMAIN,
        NN_TYPE_NONE, NN_UNIT_NONE},

    {NN_INPROC, "NN_INPROC", NN_NS_TRANSPORT,
        NN_TYPE_NONE, NN_UNIT_NONE},
    {NN_IPC, "NN_IPC", NN_NS_TRANSPORT,
        NN_TYPE_NONE, NN_UNIT_NONE},
    {NN_TCP, "NN_TCP", NN_NS_TRANSPORT,
        NN_TYPE_NONE, NN_UNIT_NONE},

    {NN_PAIR, "NN_PAIR", NN_NS_PROTOCOL,
        NN_TYPE_NONE, NN_UNIT_NONE},
    {NN_PUB, "NN_PUB", NN_NS_PROTOCOL,
        NN_TYPE_NONE, NN_UNIT_NONE},
    {NN_SUB, "NN_SUB", NN_NS_PROTOCOL,
        NN_TYPE_NONE, NN_UNIT_NONE},
    {NN_REP, "NN_REP", NN_NS_PROTOCOL,
        NN_TYPE_NONE, NN_UNIT_NONE},
    {NN_REQ, "NN_REQ", NN_NS_PROTOCOL,
        NN_TYPE_NONE, NN_UNIT_NONE},
    {NN_PUSH, "NN_PUSH", NN_NS_PROTOCOL,
        NN_TYPE_NONE, NN_UNIT_NONE},
    {NN_PULL, "NN_PULL", NN_NS_PROTOCOL,
        NN_TYPE_NONE, NN_UNIT_NONE},
    {NN_SURVEYOR, "NN_SURVEYOR", NN_NS_PROTOCOL,
        NN_TYPE_NONE, NN_UNIT_NONE},
    {NN_RESPONDENT, "NN_RESPONDENT", NN_NS_PROTOCOL,
        NN_TYPE_NONE, NN_UNIT_NONE},
    {NN_BUS, "NN_BUS", NN_NS_PROTOCOL,
        NN_TYPE_NONE, NN_UNIT_NONE},

    {NN_SOCKADDR_MAX, "NN_SOCKADDR_MAX", NN_NS_LIMIT,
        NN_TYPE_NONE, NN_UNIT_NONE},

    {NN_SOL_SOCKET, "NN_SOL_SOCKET", NN_NS_OPTION_LEVEL,
        NN_TYPE_NONE, NN_UNIT_NONE},

    {NN_LINGER, "NN_LINGER", NN_NS_SOCKET_OPTION,
        NN_TYPE_INT, NN_UNIT_MILLISECONDS},
    {NN_SNDBUF, "NN_SNDBUF", NN_NS_SOCKET_OPTION,
        NN_TYPE_INT, NN_UNIT_BYTES},
    {NN_RCVBUF, "NN_RCVBUF", NN_NS_SOCKET_OPTION,
        NN_TYPE_INT, NN_UNIT_BYTES},
    {NN_SNDTIMEO, "NN_SNDTIMEO", NN_NS_SOCKET_OPTION,
        NN_TYPE_INT, NN_UNIT_MILLISECONDS},
    {NN_RCVTIMEO, "NN_RCVTIMEO", NN_NS_SOCKET_OPTION,
        NN_TYPE_INT, NN_UNIT_MILLISECONDS},
    {NN_RECONNECT_IVL, "NN_RECONNECT_IVL", NN_NS_SOCKET_OPTION,
        NN_TYPE_INT, NN_UNIT_MILLISECONDS},
    {NN_RECONNECT_IVL_MAX, "NN_RECONNECT_IVL_MAX", NN_NS_SOCKET_OPTION,
        NN_TYPE_INT, NN_UNIT_MILLISECONDS},
    {NN_SNDPRIO, "NN_SNDPRIO", NN_NS_SOCKET_OPTION,
        NN_TYPE_INT, NN_UNIT_PRIORITY},
    {NN_SNDFD, "NN_SNDFD", NN_NS_SOCKET_OPTION,
        NN_TYPE_INT, NN_UNIT_NONE},
    {NN_RCVFD, "NN_RCVFD", NN_NS_SOCKET_OPTION,
        NN_TYPE_INT, NN_UNIT_NONE},
    {NN_DOMAIN, "NN_DOMAIN", NN_NS_SOCKET_OPTION,
        NN_TYPE_INT, NN_UNIT_NONE},
    {NN_PROTOCOL, "NN_PROTOCOL", NN_NS_SOCKET_OPTION,
        NN_TYPE_INT, NN_UNIT_NONE},
    {NN_IPV4ONLY, "NN_IPV4ONLY", NN_NS_SOCKET_OPTION,
        NN_TYPE_INT, NN_UNIT_BOOLEAN},
    {NN_SOCKET_NAME, "NN_SOCKET_NAME", NN_NS_SOCKET_OPTION,
        NN_TYPE_STR, NN_UNIT_NONE},

    {NN_SUB_SUBSCRIBE, "NN_SUB_SUBSCRIBE", NN_NS_TRANSPORT_OPTION,
        NN_TYPE_STR, NN_UNIT_NONE},
    {NN_SUB_UNSUBSCRIBE, "NN_SUB_UNSUBSCRIBE", NN_NS_TRANSPORT_OPTION,
        NN_TYPE_STR, NN_UNIT_NONE},
    {NN_REQ_RESEND_IVL, "NN_REQ_RESEND_IVL", NN_NS_TRANSPORT_OPTION,
        NN_TYPE_INT, NN_UNIT_MILLISECONDS},
    {NN_SURVEYOR_DEADLINE, "NN_SURVEYOR_DEADLINE", NN_NS_TRANSPORT_OPTION,
        NN_TYPE_INT, NN_UNIT_MILLISECONDS},
    {NN_TCP_NODELAY, "NN_TCP_NODELAY", NN_NS_TRANSPORT_OPTION,
        NN_TYPE_INT, NN_UNIT_BOOLEAN},

    {NN_DONTWAIT, "NN_DONTWAIT", NN_NS_FLAG,
        NN_TYPE_NONE, NN_UNIT_NONE},

    {EADDRINUSE, "EADDRINUSE", NN_NS_ERROR, NN_TYPE_NONE, NN_UNIT_NONE},
    {EADDRNOTAVAIL, "EADDRNOTAVAIL", NN_NS_ERROR, NN_TYPE_NONE, NN_UNIT_NONE},
    {EAFNOSUPPORT, "EAFNOSUPPORT", NN_NS_ERROR, NN_TYPE_NONE, NN_UNIT_NONE},
    {EAGAIN, "EAGAIN", NN_NS_ERROR, NN_TYPE_NONE, NN_UNIT_NONE},
    {EBADF, "EBADF", NN_NS_ERROR, NN_TYPE_NONE, NN_UNIT_NONE},
    {ECONNREFUSED, "ECONNREFUSED", NN_NS_ERROR, NN_TYPE_NONE, NN_UNIT_NONE},
    {EFAULT, "EFAULT", NN_NS_ERROR, NN_TYPE_NONE, NN_UNIT_NONE},
    {EFSM, "EFSM", NN_NS_ERROR, NN_TYPE_NONE, NN_UNIT_NONE},
    {EINPROGRESS, "EINPROGRESS", NN_NS_ERROR, NN_TYPE_NONE, NN_UNIT_NONE},
    {EINTR, "EINTR", NN_NS_ERROR, NN_TYPE_NONE, NN_UNIT_NONE},
    {EINVAL, "EINVAL", NN_NS_ERROR, NN_TYPE_NONE, NN_UNIT_NONE},
    {EMFILE, "EMFILE", NN_NS_ERROR, NN_TYPE_NONE, NN_UNIT_NONE},
    {ENAMETOOLONG, "ENAMETOOLONG", NN_NS_ERROR, NN_TYPE_NONE, NN_UNIT_NONE},
    {ENETDOWN, "ENETDOWN", NN_NS_ERROR, NN_TYPE_NONE, NN_UNIT_NONE},
    {ENOBUFS, "ENOBUFS", NN_NS_ERROR, NN_TYPE_NONE, NN_UNIT_NONE},
    {ENODEV, "ENODEV", NN_NS_ERROR, NN_TYPE_NONE, NN_UNIT_NONE},
    {ENOMEM, "ENOMEM", NN_NS_ERROR, NN_TYPE_NONE, NN_UNIT_NONE},
    {ENOPROTOOPT, "ENOPROTOOPT", NN_NS_ERROR, NN_TYPE_NONE, NN_UNIT_NONE},
    {ENOTSOCK, "ENOTSOCK", NN_NS_ERROR, NN_TYPE_NONE, NN_UNIT_NONE},
    {ENOTSUP, "ENOTSUP", NN_NS_ERROR, NN_TYPE_NONE, NN_UNIT_NONE},
    {EPROTO, "EPROTO", NN_NS_ERROR, NN_TYPE_NONE, NN_UNIT_NONE},
    {EPROTONOSUPPORT, "EPROTONOSUPPORT", NN_NS_ERROR, NN_TYPE_NONE, NN_UNIT_NONE},
    {ETERM, "ETERM", NN_NS_ERROR, NN_TYPE_NONE, NN_UNIT_NONE},
    {ETIMEDOUT, "ETIMEDOUT", NN_NS_ERROR, NN_TYPE_NONE, NN_UNIT_NONE},
    {EACCES, "EACCES" , NN_NS_ERROR, NN_TYPE_NONE, NN_UNIT_NONE},
    {ECONNABORTED, "ECONNABORTED", NN_NS_ERROR, NN_TYPE_NONE, NN_UNIT_NONE},
    {ECONNRESET, "ECONNRESET", NN_NS_ERROR, NN_TYPE_NONE, NN_UNIT_NONE},
    {EHOSTUNREACH, "EHOSTUNREACH", NN_NS_ERROR, NN_TYPE_NONE, NN_UNIT_NONE},
    {EMSGSIZE, "EMSGSIZE", NN_NS_ERROR, NN_TYPE_NONE, NN_UNIT_NONE},
    {ENETRESET, "ENETRESET", NN_NS_ERROR, NN_TYPE_NONE, NN_UNIT_NONE},
    {ENETUNREACH, "ENETUNREACH", NN_NS_ERROR, NN_TYPE_NONE, NN_UNIT_NONE},
    {ENOTCONN, "ENOTCONN", NN_NS_ERROR, NN_TYPE_NONE, NN_UNIT_NONE},
};

const int SYM_VALUE_NAMES_LEN = (sizeof (sym_value_names) /
    sizeof (sym_value_names [0]));


const char *nn_symbol (int i, int *value)
{
    const struct nn_symbol_properties *svn;
    if (i < 0 || i >= SYM_VALUE_NAMES_LEN) {
        errno = EINVAL;
        return NULL;
    }

    svn = &sym_value_names [i];
    if (value)
        *value = svn->value;
    return svn->name;
}

int nn_symbol_info (int i, struct nn_symbol_properties *buf, int buflen)
{
    if (i < 0 || i >= SYM_VALUE_NAMES_LEN) {
        return 0;
    }
    if (buflen > (int)sizeof (struct nn_symbol_properties)) {
        buflen = (int)sizeof (struct nn_symbol_properties);
    }
    memcpy(buf, &sym_value_names [i], buflen);
    return buflen;
}

