#ifndef DNOTIFY_WATCHERBASE_H
#define DNOTIFY_WATCHERBASE_H

#include <fcntl.h>

#include <set>
#include <string>

#include "compat.h"
#include "watcher.h"
#include "state.h"

// Watches the root of a Maildir++ tree or Maildir for sub-Maildir creates,
// deletes, and renames
class watcher_base : public watcher
{
  public:
	watcher_base(struct dnotify_state* state);
	virtual ~watcher_base();

	virtual void process_event(int fd);

  private:
	// Watch for sub-Maildir creates, deletes, and renames
	static const long notify = DN_CREATE | DN_RENAME | DN_DELETE | DN_MULTISHOT;

	struct dnotify_state* state;
	int fd;
	std::set<std::string> maildirs;

	void refresh_maildirs();
	int start_watch(const char* dir);
	void stop_watch(int fd);
};

#endif // DNOTIFY_WATCHERBASE_H
