/*
 * Decompiled with CFR 0.152.
 */
package Display;

import Display.AddComponent;
import Tree.BuildTree;
import Tree.MathObject;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Stack;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import org.nfunk.jep.ParseException;

public class FocListener
implements FocusListener {
    private AddComponent addComponent;
    private String oldContent;

    public FocListener() {
    }

    public FocListener(AddComponent addComponent) {
        this.addComponent = addComponent;
    }

    public void setAddComponent(AddComponent addComponent) {
        this.addComponent = addComponent;
    }

    public void focusGained(FocusEvent evt) {
        JTextField target = (JTextField)evt.getSource();
        target.setBorder(new EtchedBorder());
        this.oldContent = target.getText();
    }

    public void focusLost(FocusEvent evt) {
        JTextField target = (JTextField)evt.getSource();
        if (target.getText().length() > 0) {
            target.setBorder(new EmptyBorder(target.getInsets()));
        }
        if (!this.oldContent.equals(target.getText())) {
            String newContent = target.getText();
            target.setText(this.oldContent);
            this.addComponent.saveState(true);
            target.setText(newContent);
        }
        try {
            Stack boxStack = BuildTree.parseString(target.getText(), new Stack());
            Stack outputStack = new Stack();
            for (int i = 0; i < boxStack.size(); ++i) {
                outputStack.push(boxStack.get(i));
            }
            if (outputStack.size() > 1) {
                MathObject tree = (MathObject)outputStack.pop();
                BuildTree.toTree(tree, outputStack);
                JPanel parent = (JPanel)target.getParent();
                int j = AddComponent.getComponentPosition(parent, target);
                parent.remove(target);
                this.addComponent.pasteTree(parent, j, tree, 0);
            }
        }
        catch (ParseException ex) {
            // empty catch block
        }
    }
}

