/*  Maverick Model 3D
 * 
 *  Copyright (c) 2004-2007 Kevin Worcester
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, 
 *  USA.
 *
 *  See the COPYING file for full license text.
 */


#ifndef __ROTATETOOL_H
#define __ROTATETOOL_H

#include "tool.h"
#include <QtGui/QKeySequence>
#include <QtWidgets/QMainWindow>
#include "rotatetoolwidget.h"

class Model;
class RotatePoint;

class RotateTool : public Tool, public RotateToolWidget::Observer
{
   public:
      RotateTool();
      virtual ~RotateTool();

      int getToolCount() { return 1; };
      const char * getName( int arg );
      void activated( int arg, Model * model, QMainWindow * mainwin );
      void deactivated();
      void setModel( Model * model );

      bool getKeyBinding( int arg, int & keyBinding ) { keyBinding = Qt::Key_R; return true; };
 
      bool isManipulation() { return true; };

      void mouseButtonDown( Parent * parent, int buttonState, int x, int y );
      void mouseButtonUp( Parent * parent, int buttonState, int x, int y );
      void mouseButtonMove( Parent * parent, int buttonState, int x, int y );
      const char ** getPixmap();

      // RotateToolWidget::Observer
      void setXValue( double newValue );
      void setYValue( double newValue );
      void setZValue( double newValue );

   protected:
      Model * m_model;

      Matrix m_viewMatrix;
      Matrix m_viewInverse;

      double diffToAngle( double opposite, double adjacent );
      double adjustToNearest( double angle );
      void getRotateCoords( Tool::Parent * );

      double m_startAngle;

      double m_originX;
      double m_originY;

      double m_coords[4];

      bool m_tracking;

      RotatePoint * m_rotatePoint;
      RotateToolWidget * m_widget;
};

#endif // __ROTATETOOL_H
