/*
 * This file is part of the Ubuntu TV Media Scanner
 * Copyright (C) 2012-2013 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact: Jim Hodapp <jim.hodapp@canonical.com>
 * Authored by: Mathias Hasselmann <mathias@openismus.com>
 */
#include "grlmediascanner/logging.h"

// Standard Library
#include <string>

// Media Scanner
#include "mediascanner/logging.h"

GRL_LOG_DOMAIN(grl_media_scanner_log_domain);

namespace mediascanner {
namespace logging {

class GriloMessageSink : public MessageSink {
public:
    explicit GriloMessageSink(GrlLogLevel level)
        : level_(level) {
    }

    void Report(const std::string &domain_name, const std::string &message) {
        grl_log(grl_media_scanner_log_domain, level_, "",
                "%s: %s", domain_name.c_str(), message.c_str());
    }

private:
    const GrlLogLevel level_;
};

} // namespace logging
} // namespace mediascanner

void grl_media_scanner_logging_init() {
    GRL_LOG_DOMAIN_INIT(grl_media_scanner_log_domain, "media_scanner");

    // Avoid recursion when already capturing GLib messages,
    // like our unit tests are doing.
    if (mediascanner::logging::is_capturing_glib_messages())
        return;

    using mediascanner::logging::GriloMessageSink;
    using mediascanner::logging::MessageSinkPtr;

    mediascanner::logging::error()->set_message_sink
            (MessageSinkPtr(new GriloMessageSink(GRL_LOG_LEVEL_ERROR)));
    mediascanner::logging::warning()->set_message_sink
            (MessageSinkPtr(new GriloMessageSink(GRL_LOG_LEVEL_WARNING)));
    mediascanner::logging::info()->set_message_sink
            (MessageSinkPtr(new GriloMessageSink(GRL_LOG_LEVEL_INFO)));
    mediascanner::logging::debug()->set_message_sink
            (MessageSinkPtr(new GriloMessageSink(GRL_LOG_LEVEL_DEBUG)));
    mediascanner::logging::trace()->set_message_sink
            (MessageSinkPtr(new GriloMessageSink(GRL_LOG_LEVEL_DEBUG)));
}
