/* Generated by re2c 3.1 on Thu May 30 05:16:46 2024 */
#line 1 "parser/tokenizer.re"
#include <limits>

#include <lfortran/parser/parser_exception.h>
#include <lfortran/parser/tokenizer.h>
#include <lfortran/parser/parser.tab.hh>
#include <libasr/bigint.h>

namespace LCompilers::LFortran {

void Tokenizer::set_string(const std::string &str)
{
    // The input string must be NULL terminated, otherwise the tokenizer will
    // not detect the end of string. After C++11, the std::string is guaranteed
    // to end with \0, but we check this here just in case.
    LCOMPILERS_ASSERT(str[str.size()] == '\0');
    cur = (unsigned char *)(&str[0]);
    string_start = cur;
    cur_line = cur;
    line_num = 1;
}

template<int base>
bool adddgt(uint64_t &u, uint64_t d)
{
    if (u > (std::numeric_limits<uint64_t>::max() - d) / base) {
        return false;
    }
    u = u * base + d;
    return true;
}

bool lex_dec(const unsigned char *s, const unsigned char *e, uint64_t &u)
{
    for (u = 0; s < e; ++s) {
        if (!adddgt<10>(u, *s - 0x30u)) {
            return false;
        }
    }
    return true;
}

// Tokenizes integer of the kind 1234_ikind into `u` and `suffix`
// s ... the start of the integer
// e ... the character after the end
bool lex_int(const unsigned char *s, const unsigned char *e, uint64_t &u,
    Str &suffix)
{
    for (u = 0; s < e; ++s) {
        if (*s == '_') {
            s++;
            suffix.p = (char*) s;
            suffix.n = e-s;
            return true;
        } else if (!adddgt<10>(u, *s - 0x30u)) {
            return false;
        }
    }
    suffix.p = nullptr;
    suffix.n = 0;
    return true;
}

void lex_int_large(Allocator &al, const unsigned char *s,
    const unsigned char *e, BigInt::BigInt &u, Str &suffix)
{
    uint64_t ui;
    if (lex_int(s, e, ui, suffix)) {
        if (ui <= BigInt::MAX_SMALL_INT) {
            u.from_smallint(ui);
            return;
        }
    }
    const unsigned char *start = s;
    for (; s < e; ++s) {
        if (*s == '_') {
            s++;
            suffix.p = (char*) s;
            suffix.n = e-s;

            Str num;
            num.p = (char*)start;
            num.n = s-start-1;
            u.from_largeint(al, num);
            return;
        }
    }
    suffix.p = nullptr;
    suffix.n = 0;
    Str num;
    num.p = (char*)start;
    num.n = e-start;
    u.from_largeint(al, num);
}

uint64_t parse_int(const unsigned char *s)
{
    while (*s == ' ') s++;
    uint64_t u;
    for (u = 0; ; ++s) {
        if (*s >= '0' && *s <= '9') {
            if (!adddgt<10>(u, *s - 0x30u)) {
                return false;
            }
        } else {
            return u;
        }
    }
}

#define KW(x) token(yylval.string); RET(KW_##x);
#define RET(x) token_loc(loc); last_token=yytokentype::x; return yytokentype::x;
#define WARN_REL(x) add_rel_warning(diagnostics, fixed_form, yytokentype::TK_##x);

#define TK_TRIVIA(X) {                              \
    line_num++; cur_line=cur;                       \
    token(yylval.string);                           \
    token_loc(loc);                                 \
    if (last_token == yytokentype::TK_NEWLINE) {    \
        return yytokentype::X;                      \
    } else {                                        \
        last_token=yytokentype::TK_NEWLINE;         \
        return yytokentype::TK_EOLCOMMENT;          \
    }                                               \
}

void Tokenizer::add_rel_warning(diag::Diagnostics &diagnostics, bool fixed_form, int rel_token) const {
    if (!fixed_form) {
        static const std::map<int, std::pair<std::string, std::string>> m = {
            {yytokentype::TK_EQ, {"==", ".eq."}},
            {yytokentype::TK_NE, {"/=", ".ne."}},
            {yytokentype::TK_LT, {"<",  ".lt."}},
            {yytokentype::TK_GT, {">",  ".gt."}},
            {yytokentype::TK_LE, {"<=", ".le."}},
            {yytokentype::TK_GE, {">=", ".ge."}},
        };
        const std::string rel_new = m.at(rel_token).first;
        const std::string rel_old = m.at(rel_token).second;
        Location loc;
        token_loc(loc);
        diagnostics.tokenizer_style_label(
            "Use '" + rel_new + "' instead of '" + rel_old + "'",
            {loc},
            "help: write this as '" + rel_new + "'");
    }
}

int Tokenizer::lex(Allocator &al, YYSTYPE &yylval, Location &loc, diag::Diagnostics &diagnostics)
{
    if (enddo_state == 1) {
        enddo_state = 2;
        KW(END_DO)
    } else if (enddo_state == 2) {
        enddo_insert_count--;
        if (enddo_insert_count > 0) {
            enddo_state = 1;
        } else {
            enddo_state = 0;
            token_loc(loc); line_num++; cur_line=cur;
            last_token = yytokentype::TK_NEWLINE;
        }
        return yytokentype::TK_NEWLINE;
    }
    for (;;) {
        tok = cur;

        /*
        Re2c has excellent documentation at:

        https://re2c.org/manual/manual_c.html

        The first paragraph there explains the basics:

        * If multiple rules match, the longest match takes precedence
        * If multiple rules match the same string, the earlier rule takes
          precedence
        * Default rule `*` should always be defined, it has the lowest priority
          regardless of its place and matches any code unit
        * We use the "Sentinel character" method for end of input:
            * The end of the input text is denoted with a null character \x00
            * Thus the null character cannot be part of the input otherwise
            * There is one rule to match \x00 to end the parser
            * No other rule is allowed to match \x00, otherwise the re2c block
              would parse past the end of the string and segfaults
            * A special case of the previous point are negated character
              ranges, such as [^"\x00], where one must include \x00 in it to
              ensure this rule does not match \x00 (all other rules simply do
              not mention \x00)
            * See the "Handling the end of input" section in the re2c
              documentation for more info

        The re2c block interacts with the rest of the code via just one pointer
        variable `cur`. On entering the re2c block, the `cur` variable must
        point to the first character of the token to be tokenized by the block.
        The re2c block below then executes on its own until a rule is matched:
        the action in {} is then executed. In that action `cur` points to the
        first character of the next token.

        Before the re2c block we save the current `cur` into `tok`, so that we
        can use `tok` and `cur` in the action in {} to extract the token that
        corresponds to the rule that got matched:

        * `tok` points to the first character of the token
        * `cur-1` points to the last character of the token
        * `cur` points to the first character of the next token
        * `cur-tok` is the length of the token

        In the action, we do one of:

        * call `continue` which executes another cycle in the for loop (which
          will parse the next token); we use this to skip a token
        * call `return` which returns from this function; we return a token
        * throw an exception (terminates the tokenizer)

        In the first two cases, `cur` points to first character of the next
        token, which becomes `tok` at the next iteration of the loop (either
        right away after `continue` or after the `lex` function is called again
        after `return`).

        See the manual for more details.
        */


        // These two variables are needed by the re2c block below internally,
        // initialization is not needed. One can think of them as local
        // variables of the re2c block.
        unsigned char *mar, *ctxmar;
        
#line 231 "parser/tokenizer.cpp"
{
	unsigned char yych;
	unsigned int yyaccept = 0;
	static const unsigned char yybm[] = {
		/* table 1 .. 8: 0 */
		  0,   2,   2,   2,   2,   2,   2,   2, 
		  2,   3,   3,   3,   2,   3,   2,   2, 
		  2,   2,   2,   2,   2,   2,   2,   2, 
		  2,   2,   2,   2,   2,   2,   2,   2, 
		  3,   2,   2,   2,   2,   2,   2,   0, 
		  2,   2,   2,   2,   2,   2,   2,   2, 
		242, 242, 210, 210, 210, 210, 210, 210, 
		146, 146,   2,   2,   2,   2,   2,   2, 
		  2, 150, 150, 150, 150, 150, 150,  22, 
		 22,  22,  22,  22,  22,  22,  22,  22, 
		 22,  22,  22,  22,  22,  22,  22,  22, 
		 22,  22,  22,   2,   2,   2,   2,  26, 
		  2, 150, 150, 150, 150, 150, 150,  22, 
		 22,  22,  22,  22,  22,  22,  22,  22, 
		 22,  22,  22,  22,  22,  22,  22,  22, 
		 22,  22,  22,   2,   2,   2,   2,   2, 
		  2,   2,   2,   2,   2,   2,   2,   2, 
		  2,   2,   2,   2,   2,   2,   2,   2, 
		  2,   2,   2,   2,   2,   2,   2,   2, 
		  2,   2,   2,   2,   2,   2,   2,   2, 
		  2,   2,   2,   2,   2,   2,   2,   2, 
		  2,   2,   2,   2,   2,   2,   2,   2, 
		  2,   2,   2,   2,   2,   2,   2,   2, 
		  2,   2,   2,   2,   2,   2,   2,   2, 
		  2,   2,   2,   2,   2,   2,   2,   2, 
		  2,   2,   2,   2,   2,   2,   2,   2, 
		  2,   2,   2,   2,   2,   2,   2,   2, 
		  2,   2,   2,   2,   2,   2,   2,   2, 
		  2,   2,   2,   2,   2,   2,   2,   2, 
		  2,   2,   2,   2,   2,   2,   2,   2, 
		  2,   2,   2,   2,   2,   2,   2,   2, 
		  2,   2,   2,   2,   2,   2,   2,   2, 
		/* table 9 .. 13: 256 */
		  0, 192, 192, 192, 192, 192, 192, 192, 
		192, 200, 128, 200, 192, 200, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		200, 192,  64, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		240, 240, 240, 240, 240, 240, 240, 240, 
		240, 240, 192, 192, 192, 192, 192, 192, 
		192, 224, 224, 224, 224, 224, 224, 224, 
		224, 224, 224, 224, 224, 224, 224, 224, 
		224, 224, 224, 224, 224, 224, 224, 224, 
		224, 224, 224, 192, 192, 192, 192, 192, 
		192, 224, 224, 224, 224, 224, 224, 224, 
		224, 224, 224, 224, 224, 224, 224, 224, 
		224, 224, 224, 224, 224, 224, 224, 224, 
		224, 224, 224, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
	};
	yych = *cur;
	if (yybm[256+yych] & 8) {
		goto yy4;
	}
	switch (yych) {
		case 0x00: goto yy1;
		case '\t':
		case '\n': goto yy5;
		case ' ':
		case '!': goto yy6;
		case '"': goto yy7;
		case '#': goto yy8;
		case '%': goto yy9;
		case '&': goto yy10;
		case '\'': goto yy11;
		case '(': goto yy12;
		case ')': goto yy13;
		case '*': goto yy14;
		case '+': goto yy15;
		case ',': goto yy16;
		case '-': goto yy17;
		case '.': goto yy18;
		case '/': goto yy19;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy20;
		case ':': goto yy22;
		case ';': goto yy23;
		case '<': goto yy24;
		case '=': goto yy25;
		case '>': goto yy27;
		case 'A':
		case 'a': goto yy28;
		case 'B':
		case 'b': goto yy30;
		case 'C':
		case 'c': goto yy31;
		case 'D':
		case 'd': goto yy32;
		case 'E':
		case 'e': goto yy33;
		case 'F':
		case 'f': goto yy34;
		case 'G':
		case 'g': goto yy35;
		case 'H':
		case 'J':
		case 'X':
		case 'Y':
		case '_':
		case 'h':
		case 'j':
		case 'x':
		case 'y': goto yy36;
		case 'I':
		case 'i': goto yy38;
		case 'K':
		case 'k': goto yy39;
		case 'L':
		case 'l': goto yy40;
		case 'M':
		case 'm': goto yy41;
		case 'N':
		case 'n': goto yy42;
		case 'O':
		case 'o': goto yy43;
		case 'P':
		case 'p': goto yy44;
		case 'Q':
		case 'q': goto yy45;
		case 'R':
		case 'r': goto yy46;
		case 'S':
		case 's': goto yy47;
		case 'T':
		case 't': goto yy48;
		case 'U':
		case 'u': goto yy49;
		case 'V':
		case 'v': goto yy50;
		case 'W':
		case 'w': goto yy51;
		case 'Z':
		case 'z': goto yy52;
		case '[': goto yy53;
		case ']': goto yy55;
		case '{': goto yy56;
		case '|': goto yy57;
		case '}': goto yy58;
		default: goto yy2;
	}
yy1:
	++cur;
#line 265 "parser/tokenizer.re"
	{ RET(END_OF_FILE); }
#line 405 "parser/tokenizer.cpp"
yy2:
	++cur;
yy3:
#line 256 "parser/tokenizer.re"
	{ token_loc(loc);
                std::string t = token();
                throw parser_local::TokenizerError(diag::Diagnostic(
                    "Token '" + t + "' is not recognized",
                    diag::Level::Error, diag::Stage::Tokenizer, {
                        diag::Label("token not recognized", {loc})
                    })
                );
            }
#line 419 "parser/tokenizer.cpp"
yy4:
	yych = *++cur;
	if (yybm[256+yych] & 8) {
		goto yy4;
	}
#line 266 "parser/tokenizer.re"
	{ continue; }
#line 427 "parser/tokenizer.cpp"
yy5:
	++cur;
#line 522 "parser/tokenizer.re"
	{
                if (enddo_newline_process) {
                    enddo_newline_process = false;
                    enddo_state = 1;
                    return yytokentype::TK_NEWLINE;
                } else {
                    enddo_newline_process = false;
                    enddo_insert_count = 0;
                    token_loc(loc); line_num++; cur_line=cur;
                    last_token = yytokentype::TK_NEWLINE;
                    return yytokentype::TK_NEWLINE;
                }
            }
#line 444 "parser/tokenizer.cpp"
yy6:
	yyaccept = 0;
	yych = *(mar = ++cur);
	if (yych <= '$') {
		if (yych <= 0x00) goto yy3;
		if (yych <= '#') goto yy60;
		goto yy63;
	} else {
		if (yych == 'L') goto yy64;
		goto yy60;
	}
yy7:
	yyaccept = 0;
	yych = *(mar = ++cur);
	if (yych <= 0x00) goto yy3;
	goto yy66;
yy8:
	yyaccept = 0;
	yych = *(mar = ++cur);
	if (yych <= 0x00) goto yy3;
	goto yy71;
yy9:
	++cur;
#line 557 "parser/tokenizer.re"
	{ RET(TK_PERCENT) }
#line 470 "parser/tokenizer.cpp"
yy10:
	yyaccept = 0;
	yych = *(mar = ++cur);
	if (yych <= '\f') {
		if (yych <= 0x08) goto yy3;
		if (yych <= '\v') goto yy78;
		goto yy3;
	} else {
		if (yych <= '\r') goto yy78;
		if (yych <= 0x1F) goto yy3;
		if (yych <= '!') goto yy78;
		goto yy3;
	}
yy11:
	yyaccept = 0;
	yych = *(mar = ++cur);
	if (yych <= 0x00) goto yy3;
	goto yy83;
yy12:
	yych = *++cur;
	if (yych == '/') {
		ctxmar = cur;
		goto yy85;
	}
#line 537 "parser/tokenizer.re"
	{ RET(TK_LPAREN) }
#line 497 "parser/tokenizer.cpp"
yy13:
	++cur;
#line 545 "parser/tokenizer.re"
	{ RET(TK_RPAREN) }
#line 502 "parser/tokenizer.cpp"
yy14:
	yych = *++cur;
	if (yych == '*') goto yy86;
#line 559 "parser/tokenizer.re"
	{ RET(TK_STAR) }
#line 508 "parser/tokenizer.cpp"
yy15:
	++cur;
#line 551 "parser/tokenizer.re"
	{ RET(TK_PLUS) }
#line 513 "parser/tokenizer.cpp"
yy16:
	++cur;
#line 558 "parser/tokenizer.re"
	{ RET(TK_COMMA) }
#line 518 "parser/tokenizer.cpp"
yy17:
	++cur;
#line 552 "parser/tokenizer.re"
	{ RET(TK_MINUS) }
#line 523 "parser/tokenizer.cpp"
yy18:
	yyaccept = 0;
	yych = *(mar = ++cur);
	switch (yych) {
		case '.': goto yy87;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy88;
		case 'A':
		case 'a': goto yy91;
		case 'B':
		case 'C':
		case 'D':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'M':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'U':
		case 'V':
		case 'W':
		case 'Y':
		case 'Z':
		case 'b':
		case 'c':
		case 'd':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'm':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 'u':
		case 'v':
		case 'w':
		case 'y':
		case 'z': goto yy92;
		case 'E':
		case 'e': goto yy94;
		case 'F':
		case 'f': goto yy95;
		case 'G':
		case 'g': goto yy96;
		case 'L':
		case 'l': goto yy97;
		case 'N':
		case 'n': goto yy98;
		case 'O':
		case 'o': goto yy99;
		case 'T':
		case 't': goto yy100;
		case 'X':
		case 'x': goto yy101;
		default: goto yy3;
	}
yy19:
	yych = *++cur;
	if (yych <= '.') {
		if (yych == ')') goto yy102;
	} else {
		if (yych <= '/') goto yy103;
		if (yych == '=') goto yy104;
	}
#line 556 "parser/tokenizer.re"
	{ RET(TK_SLASH) }
#line 603 "parser/tokenizer.cpp"
yy20:
	yyaccept = 1;
	yych = *(mar = ++cur);
	if (yybm[256+yych] & 16) {
		goto yy20;
	}
	if (yych <= ' ') {
		if (yych <= '\v') {
			if (yych == '\t') {
				ctxmar = cur;
				goto yy105;
			}
			if (yych >= '\v') {
				ctxmar = cur;
				goto yy105;
			}
		} else {
			if (yych == '\r') {
				ctxmar = cur;
				goto yy105;
			}
			if (yych >= ' ') {
				ctxmar = cur;
				goto yy105;
			}
		}
	} else {
		if (yych <= 'E') {
			if (yych == '.') {
				ctxmar = cur;
				goto yy106;
			}
			if (yych >= 'D') goto yy107;
		} else {
			if (yych <= '_') {
				if (yych >= '_') goto yy108;
			} else {
				if (yych <= 'c') goto yy21;
				if (yych <= 'e') goto yy107;
			}
		}
	}
yy21:
#line 644 "parser/tokenizer.re"
	{
                lex_int_large(al, tok, cur,
                    yylval.int_suffix.int_n,
                    yylval.int_suffix.int_kind);
                RET(TK_INTEGER)
            }
#line 654 "parser/tokenizer.cpp"
yy22:
	yych = *++cur;
	if (yych == ':') goto yy109;
#line 554 "parser/tokenizer.re"
	{ RET(TK_COLON) }
#line 660 "parser/tokenizer.cpp"
yy23:
	++cur;
#line 555 "parser/tokenizer.re"
	{ RET(TK_SEMICOLON) }
#line 665 "parser/tokenizer.cpp"
yy24:
	yych = *++cur;
	if (yych == '=') goto yy110;
#line 576 "parser/tokenizer.re"
	{ RET(TK_LT) }
#line 671 "parser/tokenizer.cpp"
yy25:
	yych = *++cur;
	if (yych <= '<') goto yy26;
	if (yych <= '=') goto yy111;
	if (yych <= '>') goto yy112;
yy26:
#line 553 "parser/tokenizer.re"
	{ RET(TK_EQUAL) }
#line 680 "parser/tokenizer.cpp"
yy27:
	yych = *++cur;
	if (yych == '=') goto yy113;
#line 582 "parser/tokenizer.re"
	{ RET(TK_GT) }
#line 686 "parser/tokenizer.cpp"
yy28:
	yych = *++cur;
	if (yych <= 'S') {
		if (yych <= 'K') {
			if (yych == 'B') goto yy114;
			goto yy37;
		} else {
			if (yych <= 'L') goto yy115;
			if (yych <= 'R') goto yy37;
			goto yy116;
		}
	} else {
		if (yych <= 'k') {
			if (yych == 'b') goto yy114;
			goto yy37;
		} else {
			if (yych <= 'l') goto yy115;
			if (yych == 's') goto yy116;
			goto yy37;
		}
	}
yy29:
#line 728 "parser/tokenizer.re"
	{ token(yylval.string); RET(TK_NAME) }
#line 711 "parser/tokenizer.cpp"
yy30:
	yyaccept = 2;
	yych = *(mar = ++cur);
	if (yych <= 'I') {
		if (yych <= '\'') {
			if (yych == '"') goto yy118;
			if (yych <= '&') goto yy37;
			goto yy119;
		} else {
			if (yych == 'A') goto yy120;
			if (yych <= 'H') goto yy37;
			goto yy121;
		}
	} else {
		if (yych <= 'a') {
			if (yych == 'L') goto yy122;
			if (yych <= '`') goto yy37;
			goto yy120;
		} else {
			if (yych <= 'i') {
				if (yych <= 'h') goto yy37;
				goto yy121;
			} else {
				if (yych == 'l') goto yy122;
				goto yy37;
			}
		}
	}
yy31:
	yych = *++cur;
	switch (yych) {
		case 'A':
		case 'a': goto yy123;
		case 'H':
		case 'h': goto yy124;
		case 'L':
		case 'l': goto yy125;
		case 'O':
		case 'o': goto yy126;
		case 'R':
		case 'r': goto yy127;
		case 'Y':
		case 'y': goto yy128;
		default: goto yy37;
	}
yy32:
	yych = *++cur;
	if (yych <= 'O') {
		if (yych <= 'E') {
			if (yych == 'A') goto yy129;
			if (yych <= 'D') goto yy37;
			goto yy130;
		} else {
			if (yych == 'I') goto yy131;
			if (yych <= 'N') goto yy37;
			goto yy132;
		}
	} else {
		if (yych <= 'e') {
			if (yych == 'a') goto yy129;
			if (yych <= 'd') goto yy37;
			goto yy130;
		} else {
			if (yych <= 'i') {
				if (yych <= 'h') goto yy37;
				goto yy131;
			} else {
				if (yych == 'o') goto yy132;
				goto yy37;
			}
		}
	}
yy33:
	yych = *++cur;
	switch (yych) {
		case 'L':
		case 'l': goto yy134;
		case 'N':
		case 'n': goto yy135;
		case 'Q':
		case 'q': goto yy136;
		case 'R':
		case 'r': goto yy137;
		case 'V':
		case 'v': goto yy138;
		case 'X':
		case 'x': goto yy139;
		default: goto yy37;
	}
yy34:
	yych = *++cur;
	switch (yych) {
		case 'I':
		case 'i': goto yy140;
		case 'L':
		case 'l': goto yy141;
		case 'O':
		case 'o': goto yy142;
		case 'U':
		case 'u': goto yy143;
		default: goto yy37;
	}
yy35:
	yych = *++cur;
	if (yych <= 'O') {
		if (yych == 'E') goto yy144;
		if (yych <= 'N') goto yy37;
		goto yy145;
	} else {
		if (yych <= 'e') {
			if (yych <= 'd') goto yy37;
			goto yy144;
		} else {
			if (yych == 'o') goto yy145;
			goto yy37;
		}
	}
yy36:
	yych = *++cur;
yy37:
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
	goto yy29;
yy38:
	yych = *++cur;
	if (yych <= 'S') {
		if (yych <= 'L') {
			if (yych == 'F') goto yy147;
			goto yy37;
		} else {
			if (yych <= 'M') goto yy148;
			if (yych <= 'N') goto yy149;
			if (yych <= 'R') goto yy37;
			goto yy151;
		}
	} else {
		if (yych <= 'm') {
			if (yych == 'f') goto yy147;
			if (yych <= 'l') goto yy37;
			goto yy148;
		} else {
			if (yych <= 'n') goto yy149;
			if (yych == 's') goto yy151;
			goto yy37;
		}
	}
yy39:
	yych = *++cur;
	if (yych == 'I') goto yy152;
	if (yych == 'i') goto yy152;
	goto yy37;
yy40:
	yych = *++cur;
	if (yych <= 'O') {
		if (yych == 'E') goto yy153;
		if (yych <= 'N') goto yy37;
		goto yy154;
	} else {
		if (yych <= 'e') {
			if (yych <= 'd') goto yy37;
			goto yy153;
		} else {
			if (yych == 'o') goto yy154;
			goto yy37;
		}
	}
yy41:
	yych = *++cur;
	if (yych <= 'O') {
		if (yych == 'E') goto yy155;
		if (yych <= 'N') goto yy37;
		goto yy156;
	} else {
		if (yych <= 'e') {
			if (yych <= 'd') goto yy37;
			goto yy155;
		} else {
			if (yych == 'o') goto yy156;
			goto yy37;
		}
	}
yy42:
	yych = *++cur;
	if (yych <= 'U') {
		if (yych <= 'E') {
			if (yych == 'A') goto yy157;
			if (yych <= 'D') goto yy37;
			goto yy158;
		} else {
			if (yych == 'O') goto yy159;
			if (yych <= 'T') goto yy37;
			goto yy160;
		}
	} else {
		if (yych <= 'e') {
			if (yych == 'a') goto yy157;
			if (yych <= 'd') goto yy37;
			goto yy158;
		} else {
			if (yych <= 'o') {
				if (yych <= 'n') goto yy37;
				goto yy159;
			} else {
				if (yych == 'u') goto yy160;
				goto yy37;
			}
		}
	}
yy43:
	yyaccept = 2;
	yych = *(mar = ++cur);
	if (yych <= 'P') {
		if (yych <= '\'') {
			if (yych == '"') goto yy161;
			if (yych <= '&') goto yy37;
			goto yy162;
		} else {
			if (yych == 'N') goto yy163;
			if (yych <= 'O') goto yy37;
			goto yy164;
		}
	} else {
		if (yych <= 'n') {
			if (yych == 'U') goto yy165;
			if (yych <= 'm') goto yy37;
			goto yy163;
		} else {
			if (yych <= 'p') {
				if (yych <= 'o') goto yy37;
				goto yy164;
			} else {
				if (yych == 'u') goto yy165;
				goto yy37;
			}
		}
	}
yy44:
	yych = *++cur;
	if (yych <= 'U') {
		if (yych <= 'O') {
			if (yych == 'A') goto yy166;
			if (yych <= 'N') goto yy37;
			goto yy167;
		} else {
			if (yych == 'R') goto yy168;
			if (yych <= 'T') goto yy37;
			goto yy169;
		}
	} else {
		if (yych <= 'o') {
			if (yych == 'a') goto yy166;
			if (yych <= 'n') goto yy37;
			goto yy167;
		} else {
			if (yych <= 'r') {
				if (yych <= 'q') goto yy37;
				goto yy168;
			} else {
				if (yych == 'u') goto yy169;
				goto yy37;
			}
		}
	}
yy45:
	yych = *++cur;
	if (yych == 'U') goto yy170;
	if (yych == 'u') goto yy170;
	goto yy37;
yy46:
	yych = *++cur;
	if (yych <= 'E') {
		if (yych == 'A') goto yy171;
		if (yych <= 'D') goto yy37;
		goto yy172;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy37;
			goto yy171;
		} else {
			if (yych == 'e') goto yy172;
			goto yy37;
		}
	}
yy47:
	yych = *++cur;
	switch (yych) {
		case 'A':
		case 'a': goto yy173;
		case 'E':
		case 'e': goto yy174;
		case 'H':
		case 'h': goto yy175;
		case 'O':
		case 'o': goto yy176;
		case 'T':
		case 't': goto yy177;
		case 'U':
		case 'u': goto yy178;
		case 'Y':
		case 'y': goto yy179;
		default: goto yy37;
	}
yy48:
	yych = *++cur;
	switch (yych) {
		case 'A':
		case 'a': goto yy180;
		case 'E':
		case 'e': goto yy181;
		case 'H':
		case 'h': goto yy182;
		case 'O':
		case 'o': goto yy183;
		case 'Y':
		case 'y': goto yy184;
		default: goto yy37;
	}
yy49:
	yych = *++cur;
	if (yych <= 'S') {
		if (yych == 'N') goto yy185;
		if (yych <= 'R') goto yy37;
		goto yy186;
	} else {
		if (yych <= 'n') {
			if (yych <= 'm') goto yy37;
			goto yy185;
		} else {
			if (yych == 's') goto yy186;
			goto yy37;
		}
	}
yy50:
	yych = *++cur;
	if (yych <= 'O') {
		if (yych == 'A') goto yy187;
		if (yych <= 'N') goto yy37;
		goto yy188;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy37;
			goto yy187;
		} else {
			if (yych == 'o') goto yy188;
			goto yy37;
		}
	}
yy51:
	yych = *++cur;
	if (yych <= 'R') {
		if (yych <= 'G') {
			if (yych == 'A') goto yy189;
			goto yy37;
		} else {
			if (yych <= 'H') goto yy190;
			if (yych <= 'Q') goto yy37;
			goto yy191;
		}
	} else {
		if (yych <= 'g') {
			if (yych == 'a') goto yy189;
			goto yy37;
		} else {
			if (yych <= 'h') goto yy190;
			if (yych == 'r') goto yy191;
			goto yy37;
		}
	}
yy52:
	yyaccept = 2;
	yych = *(mar = ++cur);
	if (yych == '"') goto yy192;
	if (yych == '\'') goto yy193;
	goto yy37;
yy53:
	++cur;
yy54:
#line 546 "parser/tokenizer.re"
	{ RET(TK_LBRACKET) }
#line 1093 "parser/tokenizer.cpp"
yy55:
	++cur;
#line 547 "parser/tokenizer.re"
	{ RET(TK_RBRACKET) }
#line 1098 "parser/tokenizer.cpp"
yy56:
	++cur;
#line 548 "parser/tokenizer.re"
	{ RET(TK_LBRACE) }
#line 1103 "parser/tokenizer.cpp"
yy57:
	++cur;
#line 560 "parser/tokenizer.re"
	{ RET(TK_VBAR) }
#line 1108 "parser/tokenizer.cpp"
yy58:
	++cur;
#line 549 "parser/tokenizer.re"
	{ RET(TK_RBRACE) }
#line 1113 "parser/tokenizer.cpp"
yy59:
	yych = *++cur;
yy60:
	if (yybm[256+yych] & 64) {
		goto yy59;
	}
	if (yych >= 0x01) goto yy62;
yy61:
	cur = mar;
	if (yyaccept <= 7) {
		if (yyaccept <= 3) {
			if (yyaccept <= 1) {
				if (yyaccept == 0) {
					goto yy3;
				} else {
					goto yy21;
				}
			} else {
				if (yyaccept == 2) {
					goto yy29;
				} else {
					goto yy67;
				}
			}
		} else {
			if (yyaccept <= 5) {
				if (yyaccept == 4) {
					goto yy80;
				} else {
					goto yy84;
				}
			} else {
				if (yyaccept == 6) {
					goto yy54;
				} else {
					goto yy90;
				}
			}
		}
	} else {
		if (yyaccept <= 11) {
			if (yyaccept <= 9) {
				if (yyaccept == 8) {
					goto yy133;
				} else {
					goto yy150;
				}
			} else {
				if (yyaccept == 10) {
					goto yy258;
				} else {
					goto yy681;
				}
			}
		} else {
			if (yyaccept <= 13) {
				if (yyaccept == 12) {
					goto yy815;
				} else {
					goto yy969;
				}
			} else {
				goto yy1040;
			}
		}
	}
yy62:
	++cur;
#line 666 "parser/tokenizer.re"
	{
                line_num++; cur_line=cur;
                token(yylval.string);
                yylval.string.n--;
                token_loc(loc);
                if (last_token == yytokentype::TK_NEWLINE) {
                    return yytokentype::TK_COMMENT;
                } else {
                    last_token=yytokentype::TK_NEWLINE;
                    return yytokentype::TK_EOLCOMMENT;
                }
            }
#line 1195 "parser/tokenizer.cpp"
yy63:
	yych = *++cur;
	if (yych == 'O') goto yy194;
	if (yych == 'o') goto yy194;
	goto yy60;
yy64:
	yych = *++cur;
	if (yych == 'F') goto yy195;
	goto yy60;
yy65:
	yych = *++cur;
yy66:
	if (yybm[256+yych] & 128) {
		goto yy65;
	}
	if (yych <= 0x00) goto yy61;
	yyaccept = 3;
	yych = *(mar = ++cur);
	if (yych == '"') goto yy65;
yy67:
#line 724 "parser/tokenizer.re"
	{ token_str(al, yylval.string, '"'); RET(TK_STRING) }
#line 1218 "parser/tokenizer.cpp"
yy68:
	yych = *++cur;
yy69:
	if (yych <= 0x00) goto yy61;
	if (yych == '\n') goto yy72;
	goto yy68;
yy70:
	yych = *++cur;
yy71:
	if (yych <= 0x1F) {
		if (yych <= '\n') {
			if (yych <= 0x00) goto yy61;
			if (yych <= 0x08) goto yy68;
			if (yych <= '\t') goto yy70;
		} else {
			if (yych == '\f') goto yy68;
			if (yych <= '\r') goto yy70;
			goto yy68;
		}
	} else {
		if (yych <= 'e') {
			if (yych <= ' ') goto yy70;
			if (yych <= 'c') goto yy68;
			if (yych <= 'd') goto yy73;
			goto yy74;
		} else {
			if (yych <= 'i') {
				if (yych <= 'h') goto yy68;
				goto yy75;
			} else {
				if (yych == 'l') goto yy76;
				goto yy68;
			}
		}
	}
yy72:
	++cur;
#line 716 "parser/tokenizer.re"
	{
                Location loc; token_loc(loc);
                diagnostics.tokenizer_warning_label(
                    "Unsupported macro", {loc},
                    "Ignored");
                line_num++; cur_line=cur; continue;
            }
#line 1264 "parser/tokenizer.cpp"
yy73:
	yych = *++cur;
	if (yych == 'e') goto yy196;
	goto yy69;
yy74:
	yych = *++cur;
	if (yych == 'l') goto yy197;
	if (yych == 'n') goto yy198;
	goto yy69;
yy75:
	yych = *++cur;
	if (yych == 'f') goto yy199;
	goto yy69;
yy76:
	yych = *++cur;
	if (yych == 'i') goto yy200;
	goto yy69;
yy77:
	yych = *++cur;
yy78:
	if (yych <= '\f') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy61;
			goto yy77;
		} else {
			if (yych <= '\n') goto yy79;
			if (yych <= '\v') goto yy77;
			goto yy61;
		}
	} else {
		if (yych <= 0x1F) {
			if (yych <= '\r') goto yy77;
			goto yy61;
		} else {
			if (yych <= ' ') goto yy77;
			if (yych <= '!') goto yy81;
			goto yy61;
		}
	}
yy79:
	yyaccept = 4;
	yych = *(mar = ++cur);
	if (yybm[0+yych] & 1) {
		goto yy79;
	}
	if (yych <= 0x1F) goto yy80;
	if (yych <= '!') goto yy81;
	if (yych == '&') goto yy201;
yy80:
#line 658 "parser/tokenizer.re"
	{
                line_num++; cur_line=cur; continue;
            }
#line 1318 "parser/tokenizer.cpp"
yy81:
	yych = *++cur;
	if (yych <= 0x00) goto yy61;
	if (yych == '\n') goto yy79;
	goto yy81;
yy82:
	yych = *++cur;
yy83:
	if (yybm[0+yych] & 2) {
		goto yy82;
	}
	if (yych <= 0x00) goto yy61;
	yyaccept = 5;
	yych = *(mar = ++cur);
	if (yych == '\'') goto yy82;
yy84:
#line 725 "parser/tokenizer.re"
	{ token_str(al, yylval.string, '\''); RET(TK_STRING) }
#line 1337 "parser/tokenizer.cpp"
yy85:
	yyaccept = 6;
	yych = *(mar = ++cur);
	if (yych <= 0x1F) {
		if (yych <= '\n') {
			if (yych == '\t') goto yy202;
			goto yy54;
		} else {
			if (yych == '\f') goto yy54;
			if (yych <= '\r') goto yy202;
			goto yy54;
		}
	} else {
		if (yych <= '.') {
			if (yych <= ' ') goto yy202;
			if (yych == ')') goto yy203;
			goto yy54;
		} else {
			if (yych <= '/') goto yy204;
			if (yych == '=') goto yy205;
			goto yy54;
		}
	}
yy86:
	++cur;
#line 565 "parser/tokenizer.re"
	{ RET(TK_POW) }
#line 1365 "parser/tokenizer.cpp"
yy87:
	++cur;
#line 563 "parser/tokenizer.re"
	{ RET(TK_DBL_DOT) }
#line 1370 "parser/tokenizer.cpp"
yy88:
	yyaccept = 7;
	yych = *(mar = ++cur);
yy89:
	if (yych <= 'E') {
		if (yych <= '/') goto yy90;
		if (yych <= '9') goto yy88;
		if (yych >= 'D') goto yy107;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto yy206;
		} else {
			if (yych <= 'c') goto yy90;
			if (yych <= 'e') goto yy107;
		}
	}
yy90:
#line 615 "parser/tokenizer.re"
	{ token(yylval.string); RET(TK_REAL) }
#line 1390 "parser/tokenizer.cpp"
yy91:
	yych = *++cur;
	if (yych == 'N') goto yy208;
	if (yych == 'n') goto yy208;
	goto yy93;
yy92:
	yych = *++cur;
yy93:
	if (yybm[0+yych] & 4) {
		goto yy92;
	}
	if (yych == '.') goto yy207;
	goto yy61;
yy94:
	yych = *++cur;
	if (yych == 'Q') goto yy209;
	if (yych == 'q') goto yy209;
	goto yy93;
yy95:
	yych = *++cur;
	if (yych == 'A') goto yy210;
	if (yych == 'a') goto yy210;
	goto yy93;
yy96:
	yych = *++cur;
	if (yych <= 'T') {
		if (yych == 'E') goto yy211;
		if (yych <= 'S') goto yy93;
		goto yy212;
	} else {
		if (yych <= 'e') {
			if (yych <= 'd') goto yy93;
			goto yy211;
		} else {
			if (yych == 't') goto yy212;
			goto yy93;
		}
	}
yy97:
	yych = *++cur;
	if (yych <= 'T') {
		if (yych == 'E') goto yy213;
		if (yych <= 'S') goto yy93;
		goto yy214;
	} else {
		if (yych <= 'e') {
			if (yych <= 'd') goto yy93;
			goto yy213;
		} else {
			if (yych == 't') goto yy214;
			goto yy93;
		}
	}
yy98:
	yych = *++cur;
	if (yych <= 'O') {
		if (yych == 'E') goto yy215;
		if (yych <= 'N') goto yy93;
		goto yy216;
	} else {
		if (yych <= 'e') {
			if (yych <= 'd') goto yy93;
			goto yy215;
		} else {
			if (yych == 'o') goto yy216;
			goto yy93;
		}
	}
yy99:
	yych = *++cur;
	if (yych == 'R') goto yy217;
	if (yych == 'r') goto yy217;
	goto yy93;
yy100:
	yych = *++cur;
	if (yych == 'R') goto yy218;
	if (yych == 'r') goto yy218;
	goto yy93;
yy101:
	yych = *++cur;
	if (yych == 'O') goto yy219;
	if (yych == 'o') goto yy219;
	goto yy93;
yy102:
	++cur;
#line 550 "parser/tokenizer.re"
	{ RET(TK_RBRACKET_OLD) }
#line 1478 "parser/tokenizer.cpp"
yy103:
	++cur;
#line 566 "parser/tokenizer.re"
	{ RET(TK_CONCAT) }
#line 1483 "parser/tokenizer.cpp"
yy104:
	++cur;
#line 573 "parser/tokenizer.re"
	{ RET(TK_NE) }
#line 1488 "parser/tokenizer.cpp"
yy105:
	yych = *++cur;
	if (yych <= 0x1F) {
		if (yych <= '\n') {
			if (yych == '\t') goto yy105;
			goto yy61;
		} else {
			if (yych == '\f') goto yy61;
			if (yych <= '\r') goto yy105;
			goto yy61;
		}
	} else {
		if (yych <= '^') {
			if (yych <= ' ') goto yy105;
			if (yych <= '@') goto yy61;
			if (yych <= 'Z') goto yy220;
			goto yy61;
		} else {
			if (yych == '`') goto yy61;
			if (yych <= 'z') goto yy220;
			goto yy61;
		}
	}
yy106:
	yyaccept = 7;
	yych = *(mar = ++cur);
	if (yych <= 'Z') {
		if (yych <= '@') goto yy89;
		if (yych <= 'C') goto yy221;
		if (yych <= 'E') goto yy223;
		goto yy221;
	} else {
		if (yych <= 'c') {
			if (yych <= '`') goto yy89;
			goto yy221;
		} else {
			if (yych <= 'e') goto yy223;
			if (yych <= 'z') goto yy221;
			goto yy89;
		}
	}
yy107:
	yych = *++cur;
	if (yych <= ',') {
		if (yych == '+') goto yy224;
		goto yy61;
	} else {
		if (yych <= '-') goto yy224;
		if (yych <= '/') goto yy61;
		if (yych <= '9') goto yy225;
		goto yy61;
	}
yy108:
	yych = *++cur;
	if (yych <= '9') {
		if (yych <= '&') {
			if (yych == '"') goto yy65;
			goto yy61;
		} else {
			if (yych <= '\'') goto yy82;
			if (yych <= '/') goto yy61;
			goto yy226;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy61;
			if (yych <= 'Z') goto yy227;
			goto yy61;
		} else {
			if (yych == '`') goto yy61;
			if (yych <= 'z') goto yy227;
			goto yy61;
		}
	}
yy109:
	++cur;
#line 564 "parser/tokenizer.re"
	{ RET(TK_DBL_COLON) }
#line 1567 "parser/tokenizer.cpp"
yy110:
	++cur;
#line 579 "parser/tokenizer.re"
	{ RET(TK_LE) }
#line 1572 "parser/tokenizer.cpp"
yy111:
	++cur;
#line 570 "parser/tokenizer.re"
	{ RET(TK_EQ) }
#line 1577 "parser/tokenizer.cpp"
yy112:
	++cur;
#line 567 "parser/tokenizer.re"
	{ RET(TK_ARROW) }
#line 1582 "parser/tokenizer.cpp"
yy113:
	++cur;
#line 585 "parser/tokenizer.re"
	{ RET(TK_GE) }
#line 1587 "parser/tokenizer.cpp"
yy114:
	yych = *++cur;
	if (yych == 'S') goto yy228;
	if (yych == 's') goto yy228;
	goto yy37;
yy115:
	yych = *++cur;
	if (yych == 'L') goto yy229;
	if (yych == 'l') goto yy229;
	goto yy37;
yy116:
	yych = *++cur;
	if (yych <= 'Y') {
		if (yych == 'S') goto yy231;
		if (yych <= 'X') goto yy37;
		goto yy232;
	} else {
		if (yych <= 's') {
			if (yych <= 'r') goto yy37;
			goto yy231;
		} else {
			if (yych == 'y') goto yy232;
			goto yy37;
		}
	}
yy117:
	yyaccept = 2;
	yych = *(mar = ++cur);
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych <= '&') {
		if (yych == '"') goto yy65;
		goto yy29;
	} else {
		if (yych <= '\'') goto yy82;
		if (yych == '_') goto yy117;
		goto yy29;
	}
yy118:
	yych = *++cur;
	if (yybm[0+yych] & 32) {
		goto yy233;
	}
	goto yy61;
yy119:
	yych = *++cur;
	if (yych <= '/') goto yy61;
	if (yych <= '1') goto yy234;
	goto yy61;
yy120:
	yych = *++cur;
	if (yych == 'C') goto yy235;
	if (yych == 'c') goto yy235;
	goto yy37;
yy121:
	yych = *++cur;
	if (yych == 'N') goto yy236;
	if (yych == 'n') goto yy236;
	goto yy37;
yy122:
	yych = *++cur;
	if (yych == 'O') goto yy237;
	if (yych == 'o') goto yy237;
	goto yy37;
yy123:
	yych = *++cur;
	if (yych <= 'S') {
		if (yych == 'L') goto yy238;
		if (yych <= 'R') goto yy37;
		goto yy239;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy37;
			goto yy238;
		} else {
			if (yych == 's') goto yy239;
			goto yy37;
		}
	}
yy124:
	yych = *++cur;
	if (yych == 'A') goto yy240;
	if (yych == 'a') goto yy240;
	goto yy37;
yy125:
	yych = *++cur;
	if (yych <= 'O') {
		if (yych == 'A') goto yy241;
		if (yych <= 'N') goto yy37;
		goto yy242;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy37;
			goto yy241;
		} else {
			if (yych == 'o') goto yy242;
			goto yy37;
		}
	}
yy126:
	yych = *++cur;
	if (yych <= 'N') {
		if (yych <= 'D') {
			if (yych <= 'C') goto yy37;
			goto yy243;
		} else {
			if (yych <= 'L') goto yy37;
			if (yych <= 'M') goto yy244;
			goto yy245;
		}
	} else {
		if (yych <= 'l') {
			if (yych == 'd') goto yy243;
			goto yy37;
		} else {
			if (yych <= 'm') goto yy244;
			if (yych <= 'n') goto yy245;
			goto yy37;
		}
	}
yy127:
	yych = *++cur;
	if (yych == 'I') goto yy246;
	if (yych == 'i') goto yy246;
	goto yy37;
yy128:
	yych = *++cur;
	if (yych == 'C') goto yy247;
	if (yych == 'c') goto yy247;
	goto yy37;
yy129:
	yych = *++cur;
	if (yych == 'T') goto yy248;
	if (yych == 't') goto yy248;
	goto yy37;
yy130:
	yych = *++cur;
	if (yych <= 'F') {
		if (yych == 'A') goto yy249;
		if (yych <= 'E') goto yy37;
		goto yy250;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy37;
			goto yy249;
		} else {
			if (yych == 'f') goto yy250;
			goto yy37;
		}
	}
yy131:
	yych = *++cur;
	if (yych == 'M') goto yy251;
	if (yych == 'm') goto yy251;
	goto yy37;
yy132:
	yyaccept = 8;
	yych = *(mar = ++cur);
	if (yybm[0+yych] & 8) {
		goto yy117;
	}
	if (yych <= '@') {
		if (yych <= '\f') {
			if (yych <= '\t') {
				if (yych >= '\t') {
					ctxmar = cur;
					goto yy252;
				}
			} else {
				if (yych == '\v') {
					ctxmar = cur;
					goto yy252;
				}
			}
		} else {
			if (yych <= ' ') {
				if (yych <= '\r') {
					ctxmar = cur;
					goto yy252;
				}
				if (yych >= ' ') {
					ctxmar = cur;
					goto yy252;
				}
			} else {
				if (yych <= '/') goto yy133;
				if (yych <= '9') goto yy36;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'V') {
				if (yych == 'U') goto yy253;
				goto yy36;
			} else {
				if (yych <= 'W') goto yy254;
				if (yych <= 'Z') goto yy36;
			}
		} else {
			if (yych <= 'v') {
				if (yych == 'u') goto yy253;
				goto yy36;
			} else {
				if (yych <= 'w') goto yy254;
				if (yych <= 'z') goto yy36;
			}
		}
	}
yy133:
#line 308 "parser/tokenizer.re"
	{ KW(DO) }
#line 1800 "parser/tokenizer.cpp"
yy134:
	yych = *++cur;
	if (yych <= 'S') {
		if (yych == 'E') goto yy255;
		if (yych <= 'R') goto yy37;
		goto yy256;
	} else {
		if (yych <= 'e') {
			if (yych <= 'd') goto yy37;
			goto yy255;
		} else {
			if (yych == 's') goto yy256;
			goto yy37;
		}
	}
yy135:
	yych = *++cur;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych <= 'C') goto yy37;
			goto yy257;
		} else {
			if (yych <= 'S') goto yy37;
			if (yych <= 'T') goto yy259;
			goto yy260;
		}
	} else {
		if (yych <= 's') {
			if (yych == 'd') goto yy257;
			goto yy37;
		} else {
			if (yych <= 't') goto yy259;
			if (yych <= 'u') goto yy260;
			goto yy37;
		}
	}
yy136:
	yych = *++cur;
	if (yych == 'U') goto yy261;
	if (yych == 'u') goto yy261;
	goto yy37;
yy137:
	yych = *++cur;
	if (yych == 'R') goto yy262;
	if (yych == 'r') goto yy262;
	goto yy37;
yy138:
	yych = *++cur;
	if (yych == 'E') goto yy263;
	if (yych == 'e') goto yy263;
	goto yy37;
yy139:
	yych = *++cur;
	if (yych <= 'T') {
		if (yych == 'I') goto yy264;
		if (yych <= 'S') goto yy37;
		goto yy265;
	} else {
		if (yych <= 'i') {
			if (yych <= 'h') goto yy37;
			goto yy264;
		} else {
			if (yych == 't') goto yy265;
			goto yy37;
		}
	}
yy140:
	yych = *++cur;
	if (yych <= 'N') {
		if (yych == 'L') goto yy266;
		if (yych <= 'M') goto yy37;
		goto yy267;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy37;
			goto yy266;
		} else {
			if (yych == 'n') goto yy267;
			goto yy37;
		}
	}
yy141:
	yych = *++cur;
	if (yych == 'U') goto yy268;
	if (yych == 'u') goto yy268;
	goto yy37;
yy142:
	yych = *++cur;
	if (yych == 'R') goto yy269;
	if (yych == 'r') goto yy269;
	goto yy37;
yy143:
	yych = *++cur;
	if (yych == 'N') goto yy270;
	if (yych == 'n') goto yy270;
	goto yy37;
yy144:
	yych = *++cur;
	if (yych == 'N') goto yy271;
	if (yych == 'n') goto yy271;
	goto yy37;
yy145:
	yych = *++cur;
	if (yybm[0+yych] & 8) {
		goto yy117;
	}
	if (yych <= 'T') {
		if (yych <= '9') {
			if (yych >= '0') goto yy36;
		} else {
			if (yych <= '@') goto yy146;
			if (yych <= 'S') goto yy36;
			goto yy272;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy36;
			if (yych >= 'a') goto yy36;
		} else {
			if (yych <= 't') goto yy272;
			if (yych <= 'z') goto yy36;
		}
	}
yy146:
#line 425 "parser/tokenizer.re"
	{ KW(GO) }
#line 1927 "parser/tokenizer.cpp"
yy147:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 427 "parser/tokenizer.re"
	{ KW(IF) }
#line 1936 "parser/tokenizer.cpp"
yy148:
	yych = *++cur;
	if (yych <= 'P') {
		if (yych == 'A') goto yy273;
		if (yych <= 'O') goto yy37;
		goto yy274;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy37;
			goto yy273;
		} else {
			if (yych == 'p') goto yy274;
			goto yy37;
		}
	}
yy149:
	yyaccept = 9;
	yych = *(mar = ++cur);
	if (yybm[0+yych] & 8) {
		goto yy117;
	}
	if (yych <= 'P') {
		if (yych <= ' ') {
			if (yych <= '\v') {
				if (yych == '\t') goto yy275;
				if (yych >= '\v') goto yy275;
			} else {
				if (yych == '\r') goto yy275;
				if (yych >= ' ') goto yy275;
			}
		} else {
			if (yych <= 'B') {
				if (yych <= '/') goto yy150;
				if (yych <= '9') goto yy36;
				if (yych >= 'A') goto yy36;
			} else {
				if (yych <= 'C') goto yy276;
				if (yych == 'O') goto yy277;
				goto yy36;
			}
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'T') {
				if (yych <= 'Q') goto yy278;
				if (yych <= 'R') goto yy36;
				if (yych <= 'S') goto yy279;
				goto yy280;
			} else {
				if (yych <= 'Z') goto yy36;
				if (yych <= '`') goto yy150;
				if (yych <= 'b') goto yy36;
				goto yy276;
			}
		} else {
			if (yych <= 'q') {
				if (yych == 'o') goto yy277;
				if (yych <= 'p') goto yy36;
				goto yy278;
			} else {
				if (yych <= 's') {
					if (yych <= 'r') goto yy36;
					goto yy279;
				} else {
					if (yych <= 't') goto yy280;
					if (yych <= 'z') goto yy36;
				}
			}
		}
	}
yy150:
#line 432 "parser/tokenizer.re"
	{ KW(IN) }
#line 2010 "parser/tokenizer.cpp"
yy151:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 442 "parser/tokenizer.re"
	{ KW(IS) }
#line 2019 "parser/tokenizer.cpp"
yy152:
	yych = *++cur;
	if (yych == 'N') goto yy281;
	if (yych == 'n') goto yy281;
	goto yy37;
yy153:
	yych = *++cur;
	if (yych == 'N') goto yy282;
	if (yych == 'n') goto yy282;
	goto yy37;
yy154:
	yych = *++cur;
	if (yych <= 'G') {
		if (yych == 'C') goto yy283;
		if (yych <= 'F') goto yy37;
		goto yy284;
	} else {
		if (yych <= 'c') {
			if (yych <= 'b') goto yy37;
			goto yy283;
		} else {
			if (yych == 'g') goto yy284;
			goto yy37;
		}
	}
yy155:
	yych = *++cur;
	if (yych == 'M') goto yy285;
	if (yych == 'm') goto yy285;
	goto yy37;
yy156:
	yych = *++cur;
	if (yych <= 'L') {
		if (yych == 'D') goto yy286;
		if (yych <= 'K') goto yy37;
		goto yy287;
	} else {
		if (yych <= 'd') {
			if (yych <= 'c') goto yy37;
			goto yy286;
		} else {
			if (yych == 'l') goto yy287;
			goto yy37;
		}
	}
yy157:
	yych = *++cur;
	if (yych == 'M') goto yy288;
	if (yych == 'm') goto yy288;
	goto yy37;
yy158:
	yych = *++cur;
	if (yych == 'W') goto yy289;
	if (yych == 'w') goto yy289;
	goto yy37;
yy159:
	yych = *++cur;
	if (yych <= 'P') {
		if (yych == 'N') goto yy290;
		if (yych <= 'O') goto yy37;
		goto yy291;
	} else {
		if (yych <= 'n') {
			if (yych <= 'm') goto yy37;
			goto yy290;
		} else {
			if (yych == 'p') goto yy291;
			goto yy37;
		}
	}
yy160:
	yych = *++cur;
	if (yych == 'L') goto yy292;
	if (yych == 'l') goto yy292;
	goto yy37;
yy161:
	yych = *++cur;
	if (yybm[0+yych] & 64) {
		goto yy293;
	}
	goto yy61;
yy162:
	yych = *++cur;
	if (yych <= '/') goto yy61;
	if (yych <= '7') goto yy294;
	goto yy61;
yy163:
	yych = *++cur;
	if (yych == 'L') goto yy295;
	if (yych == 'l') goto yy295;
	goto yy37;
yy164:
	yych = *++cur;
	if (yych <= 'T') {
		if (yych == 'E') goto yy296;
		if (yych <= 'S') goto yy37;
		goto yy297;
	} else {
		if (yych <= 'e') {
			if (yych <= 'd') goto yy37;
			goto yy296;
		} else {
			if (yych == 't') goto yy297;
			goto yy37;
		}
	}
yy165:
	yych = *++cur;
	if (yych == 'T') goto yy298;
	if (yych == 't') goto yy298;
	goto yy37;
yy166:
	yych = *++cur;
	if (yych <= 'S') {
		if (yych <= 'Q') goto yy37;
		if (yych <= 'R') goto yy299;
		goto yy300;
	} else {
		if (yych <= 'q') goto yy37;
		if (yych <= 'r') goto yy299;
		if (yych <= 's') goto yy300;
		goto yy37;
	}
yy167:
	yych = *++cur;
	if (yych <= 'S') {
		if (yych == 'I') goto yy301;
		if (yych <= 'R') goto yy37;
		goto yy302;
	} else {
		if (yych <= 'i') {
			if (yych <= 'h') goto yy37;
			goto yy301;
		} else {
			if (yych == 's') goto yy302;
			goto yy37;
		}
	}
yy168:
	yych = *++cur;
	if (yych <= 'O') {
		if (yych <= 'H') {
			if (yych == 'E') goto yy303;
			goto yy37;
		} else {
			if (yych <= 'I') goto yy304;
			if (yych <= 'N') goto yy37;
			goto yy305;
		}
	} else {
		if (yych <= 'h') {
			if (yych == 'e') goto yy303;
			goto yy37;
		} else {
			if (yych <= 'i') goto yy304;
			if (yych == 'o') goto yy305;
			goto yy37;
		}
	}
yy169:
	yych = *++cur;
	if (yych <= 'R') {
		if (yych == 'B') goto yy306;
		if (yych <= 'Q') goto yy37;
		goto yy307;
	} else {
		if (yych <= 'b') {
			if (yych <= 'a') goto yy37;
			goto yy306;
		} else {
			if (yych == 'r') goto yy307;
			goto yy37;
		}
	}
yy170:
	yych = *++cur;
	if (yych == 'I') goto yy308;
	if (yych == 'i') goto yy308;
	goto yy37;
yy171:
	yych = *++cur;
	if (yych == 'N') goto yy309;
	if (yych == 'n') goto yy309;
	goto yy37;
yy172:
	yych = *++cur;
	switch (yych) {
		case 'A':
		case 'a': goto yy310;
		case 'C':
		case 'c': goto yy311;
		case 'D':
		case 'd': goto yy312;
		case 'Q':
		case 'q': goto yy313;
		case 'S':
		case 's': goto yy314;
		case 'T':
		case 't': goto yy315;
		case 'W':
		case 'w': goto yy316;
		default: goto yy37;
	}
yy173:
	yych = *++cur;
	if (yych == 'V') goto yy317;
	if (yych == 'v') goto yy317;
	goto yy37;
yy174:
	yych = *++cur;
	if (yych <= 'Q') {
		if (yych == 'L') goto yy318;
		if (yych <= 'P') goto yy37;
		goto yy319;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy37;
			goto yy318;
		} else {
			if (yych == 'q') goto yy319;
			goto yy37;
		}
	}
yy175:
	yych = *++cur;
	if (yych == 'A') goto yy320;
	if (yych == 'a') goto yy320;
	goto yy37;
yy176:
	yych = *++cur;
	if (yych == 'U') goto yy321;
	if (yych == 'u') goto yy321;
	goto yy37;
yy177:
	yych = *++cur;
	if (yych <= 'O') {
		if (yych == 'A') goto yy322;
		if (yych <= 'N') goto yy37;
		goto yy323;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy37;
			goto yy322;
		} else {
			if (yych == 'o') goto yy323;
			goto yy37;
		}
	}
yy178:
	yych = *++cur;
	if (yych == 'B') goto yy324;
	if (yych == 'b') goto yy324;
	goto yy37;
yy179:
	yych = *++cur;
	if (yych == 'N') goto yy325;
	if (yych == 'n') goto yy325;
	goto yy37;
yy180:
	yych = *++cur;
	if (yych == 'R') goto yy326;
	if (yych == 'r') goto yy326;
	goto yy37;
yy181:
	yych = *++cur;
	if (yych <= 'M') {
		if (yych == 'A') goto yy327;
		if (yych <= 'L') goto yy37;
		goto yy328;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy37;
			goto yy327;
		} else {
			if (yych == 'm') goto yy328;
			goto yy37;
		}
	}
yy182:
	yych = *++cur;
	if (yych == 'E') goto yy329;
	if (yych == 'e') goto yy329;
	goto yy37;
yy183:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 510 "parser/tokenizer.re"
	{ KW(TO) }
#line 2311 "parser/tokenizer.cpp"
yy184:
	yych = *++cur;
	if (yych == 'P') goto yy330;
	if (yych == 'p') goto yy330;
	goto yy37;
yy185:
	yych = *++cur;
	if (yych == 'F') goto yy331;
	if (yych == 'f') goto yy331;
	goto yy37;
yy186:
	yych = *++cur;
	if (yych == 'E') goto yy332;
	if (yych == 'e') goto yy332;
	goto yy37;
yy187:
	yych = *++cur;
	if (yych == 'L') goto yy333;
	if (yych == 'l') goto yy333;
	goto yy37;
yy188:
	yych = *++cur;
	if (yych == 'L') goto yy334;
	if (yych == 'l') goto yy334;
	goto yy37;
yy189:
	yych = *++cur;
	if (yych == 'I') goto yy335;
	if (yych == 'i') goto yy335;
	goto yy37;
yy190:
	yych = *++cur;
	if (yych <= 'I') {
		if (yych == 'E') goto yy336;
		if (yych <= 'H') goto yy37;
		goto yy337;
	} else {
		if (yych <= 'e') {
			if (yych <= 'd') goto yy37;
			goto yy336;
		} else {
			if (yych == 'i') goto yy337;
			goto yy37;
		}
	}
yy191:
	yych = *++cur;
	if (yych == 'I') goto yy338;
	if (yych == 'i') goto yy338;
	goto yy37;
yy192:
	yych = *++cur;
	if (yych == '"') goto yy61;
	goto yy340;
yy193:
	yych = *++cur;
	if (yych == '\'') goto yy61;
	goto yy342;
yy194:
	yych = *++cur;
	if (yych == 'M') goto yy343;
	if (yych == 'm') goto yy343;
	goto yy60;
yy195:
	yych = *++cur;
	if (yych == '$') goto yy344;
	goto yy60;
yy196:
	yych = *++cur;
	if (yych == 'f') goto yy345;
	goto yy69;
yy197:
	yych = *++cur;
	if (yych == 'i') goto yy346;
	if (yych == 's') goto yy347;
	goto yy69;
yy198:
	yych = *++cur;
	if (yych == 'd') goto yy348;
	goto yy69;
yy199:
	yych = *++cur;
	if (yych == 'd') goto yy349;
	goto yy69;
yy200:
	yych = *++cur;
	if (yych == 'n') goto yy350;
	goto yy69;
yy201:
	++cur;
	goto yy80;
yy202:
	yych = *++cur;
	if (yych <= '\f') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy61;
			goto yy202;
		} else {
			if (yych == '\v') goto yy202;
			goto yy61;
		}
	} else {
		if (yych <= ' ') {
			if (yych <= '\r') goto yy202;
			if (yych <= 0x1F) goto yy61;
			goto yy202;
		} else {
			if (yych == ')') goto yy351;
			goto yy61;
		}
	}
yy203:
	++cur;
	cur -= 2;
#line 539 "parser/tokenizer.re"
	{ RET(TK_LPAREN) }
#line 2428 "parser/tokenizer.cpp"
yy204:
	yych = *++cur;
	if (yych == ')') goto yy354;
	goto yy353;
yy205:
	++cur;
	cur -= 2;
#line 538 "parser/tokenizer.re"
	{ RET(TK_LPAREN) }
#line 2438 "parser/tokenizer.cpp"
yy206:
	yych = *++cur;
	if (yych <= 'Z') {
		if (yych <= '/') goto yy61;
		if (yych <= '9') goto yy355;
		if (yych <= '@') goto yy61;
		goto yy356;
	} else {
		if (yych <= '_') {
			if (yych <= '^') goto yy61;
			goto yy356;
		} else {
			if (yych <= '`') goto yy61;
			if (yych <= 'z') goto yy356;
			goto yy61;
		}
	}
yy207:
	++cur;
#line 727 "parser/tokenizer.re"
	{ token(yylval.string); RET(TK_DEF_OP) }
#line 2460 "parser/tokenizer.cpp"
yy208:
	yych = *++cur;
	if (yych == 'D') goto yy357;
	if (yych == 'd') goto yy357;
	goto yy93;
yy209:
	yych = *++cur;
	if (yych <= 'U') {
		if (yych == '.') goto yy358;
		goto yy93;
	} else {
		if (yych <= 'V') goto yy359;
		if (yych == 'v') goto yy359;
		goto yy93;
	}
yy210:
	yych = *++cur;
	if (yych == 'L') goto yy360;
	if (yych == 'l') goto yy360;
	goto yy93;
yy211:
	yych = *++cur;
	if (yych == '.') goto yy361;
	goto yy93;
yy212:
	yych = *++cur;
	if (yych == '.') goto yy362;
	goto yy93;
yy213:
	yych = *++cur;
	if (yych == '.') goto yy363;
	goto yy93;
yy214:
	yych = *++cur;
	if (yych == '.') goto yy364;
	goto yy93;
yy215:
	yych = *++cur;
	if (yych <= 'P') {
		if (yych == '.') goto yy365;
		goto yy93;
	} else {
		if (yych <= 'Q') goto yy366;
		if (yych == 'q') goto yy366;
		goto yy93;
	}
yy216:
	yych = *++cur;
	if (yych == 'T') goto yy367;
	if (yych == 't') goto yy367;
	goto yy93;
yy217:
	yych = *++cur;
	if (yych == '.') goto yy368;
	goto yy93;
yy218:
	yych = *++cur;
	if (yych == 'U') goto yy369;
	if (yych == 'u') goto yy369;
	goto yy93;
yy219:
	yych = *++cur;
	if (yych == 'R') goto yy370;
	if (yych == 'r') goto yy370;
	goto yy93;
yy220:
	yych = *++cur;
	if (yybm[0+yych] & 16) {
		goto yy220;
	}
	cur = ctxmar;
#line 616 "parser/tokenizer.re"
	{
                if (last_token == yytokentype::TK_NEWLINE) {
                    uint64_t u;
                    if (lex_int(tok, cur, u, yylval.int_suffix.int_kind)) {
                            yylval.n = u;
                            if (enddo_label_stack[enddo_label_stack.size()-1] == u) {
                                while (enddo_label_stack[enddo_label_stack.size()-1] == u) {
                                    enddo_label_stack.pop_back();
                                    enddo_insert_count++;
                                }
                                enddo_newline_process = true;
                            } else {
                                enddo_newline_process = false;
                            }
                            RET(TK_LABEL)
                    } else {
                        token_loc(loc);
                        std::string t = token();
                        throw LFortran::parser_local::TokenizerError("Integer '" + t + "' too large",
                            loc);
                    }
                } else {
                    lex_int_large(al, tok, cur,
                        yylval.int_suffix.int_n,
                        yylval.int_suffix.int_kind);
                    RET(TK_INTEGER)
                }
            }
#line 2561 "parser/tokenizer.cpp"
yy221:
	yych = *++cur;
yy222:
	if (yych <= '@') {
		if (yych == '.') goto yy371;
		goto yy61;
	} else {
		if (yych <= 'Z') goto yy221;
		if (yych <= '`') goto yy61;
		if (yych <= 'z') goto yy221;
		goto yy61;
	}
yy223:
	yych = *++cur;
	if (yych <= ',') {
		if (yych != '+') goto yy222;
	} else {
		if (yych <= '-') goto yy224;
		if (yych <= '/') goto yy222;
		if (yych <= '9') goto yy225;
		goto yy222;
	}
yy224:
	yych = *++cur;
	if (yych <= '/') goto yy61;
	if (yych >= ':') goto yy61;
yy225:
	yyaccept = 7;
	yych = *(mar = ++cur);
	if (yych <= '/') goto yy90;
	if (yych <= '9') goto yy225;
	if (yych == '_') goto yy206;
	goto yy90;
yy226:
	yyaccept = 1;
	yych = *(mar = ++cur);
	if (yych <= '\r') {
		if (yych <= '\n') {
			if (yych == '\t') {
				ctxmar = cur;
				goto yy105;
			}
			goto yy21;
		} else {
			if (yych == '\f') goto yy21;
			ctxmar = cur;
			goto yy105;
		}
	} else {
		if (yych <= '-') {
			if (yych == ' ') {
				ctxmar = cur;
				goto yy105;
			}
			goto yy21;
		} else {
			if (yych <= '.') {
				ctxmar = cur;
				goto yy372;
			}
			if (yych <= '/') goto yy21;
			if (yych <= '9') goto yy226;
			goto yy21;
		}
	}
yy227:
	yyaccept = 1;
	yych = *(mar = ++cur);
	if (yych <= '-') {
		if (yych <= '\v') {
			if (yych == '\t') {
				ctxmar = cur;
				goto yy105;
			}
			if (yych <= '\n') goto yy21;
			ctxmar = cur;
			goto yy105;
		} else {
			if (yych <= '\r') {
				if (yych <= '\f') goto yy21;
				ctxmar = cur;
				goto yy105;
			} else {
				if (yych == ' ') {
					ctxmar = cur;
					goto yy105;
				}
				goto yy21;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '/') {
				if (yych <= '.') {
					ctxmar = cur;
					goto yy372;
				}
				goto yy21;
			} else {
				if (yych <= '9') goto yy227;
				if (yych <= '@') goto yy21;
				goto yy227;
			}
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy21;
				goto yy227;
			} else {
				if (yych <= '`') goto yy21;
				if (yych <= 'z') goto yy227;
				goto yy21;
			}
		}
	}
yy228:
	yych = *++cur;
	if (yych == 'T') goto yy373;
	if (yych == 't') goto yy373;
	goto yy37;
yy229:
	yych = *++cur;
	if (yybm[0+yych] & 8) {
		goto yy117;
	}
	if (yych <= 'O') {
		if (yych <= '9') {
			if (yych >= '0') goto yy36;
		} else {
			if (yych <= '@') goto yy230;
			if (yych <= 'N') goto yy36;
			goto yy374;
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'Z') goto yy36;
			if (yych >= 'a') goto yy36;
		} else {
			if (yych <= 'o') goto yy374;
			if (yych <= 'z') goto yy36;
		}
	}
yy230:
#line 270 "parser/tokenizer.re"
	{ KW(ALL) }
#line 2706 "parser/tokenizer.cpp"
yy231:
	yych = *++cur;
	if (yych <= 'O') {
		if (yych == 'I') goto yy375;
		if (yych <= 'N') goto yy37;
		goto yy376;
	} else {
		if (yych <= 'i') {
			if (yych <= 'h') goto yy37;
			goto yy375;
		} else {
			if (yych == 'o') goto yy376;
			goto yy37;
		}
	}
yy232:
	yych = *++cur;
	if (yych == 'N') goto yy377;
	if (yych == 'n') goto yy377;
	goto yy37;
yy233:
	yych = *++cur;
	if (yybm[0+yych] & 32) {
		goto yy233;
	}
	if (yych == '"') goto yy378;
	goto yy61;
yy234:
	yych = *++cur;
	if (yych == '\'') goto yy379;
	if (yych <= '/') goto yy61;
	if (yych <= '1') goto yy234;
	goto yy61;
yy235:
	yych = *++cur;
	if (yych == 'K') goto yy380;
	if (yych == 'k') goto yy380;
	goto yy37;
yy236:
	yych = *++cur;
	if (yych == 'D') goto yy381;
	if (yych == 'd') goto yy381;
	goto yy37;
yy237:
	yych = *++cur;
	if (yych == 'C') goto yy382;
	if (yych == 'c') goto yy382;
	goto yy37;
yy238:
	yych = *++cur;
	if (yych == 'L') goto yy383;
	if (yych == 'l') goto yy383;
	goto yy37;
yy239:
	yych = *++cur;
	if (yych == 'E') goto yy384;
	if (yych == 'e') goto yy384;
	goto yy37;
yy240:
	yych = *++cur;
	if (yych <= 'R') {
		if (yych == 'N') goto yy385;
		if (yych <= 'Q') goto yy37;
		goto yy386;
	} else {
		if (yych <= 'n') {
			if (yych <= 'm') goto yy37;
			goto yy385;
		} else {
			if (yych == 'r') goto yy386;
			goto yy37;
		}
	}
yy241:
	yych = *++cur;
	if (yych == 'S') goto yy387;
	if (yych == 's') goto yy387;
	goto yy37;
yy242:
	yych = *++cur;
	if (yych == 'S') goto yy388;
	if (yych == 's') goto yy388;
	goto yy37;
yy243:
	yych = *++cur;
	if (yych == 'I') goto yy389;
	if (yych == 'i') goto yy389;
	goto yy37;
yy244:
	yych = *++cur;
	if (yych <= 'P') {
		if (yych == 'M') goto yy390;
		if (yych <= 'O') goto yy37;
		goto yy391;
	} else {
		if (yych <= 'm') {
			if (yych <= 'l') goto yy37;
			goto yy390;
		} else {
			if (yych == 'p') goto yy391;
			goto yy37;
		}
	}
yy245:
	yych = *++cur;
	if (yych <= 'T') {
		if (yych == 'C') goto yy392;
		if (yych <= 'S') goto yy37;
		goto yy393;
	} else {
		if (yych <= 'c') {
			if (yych <= 'b') goto yy37;
			goto yy392;
		} else {
			if (yych == 't') goto yy393;
			goto yy37;
		}
	}
yy246:
	yych = *++cur;
	if (yych == 'T') goto yy394;
	if (yych == 't') goto yy394;
	goto yy37;
yy247:
	yych = *++cur;
	if (yych == 'L') goto yy395;
	if (yych == 'l') goto yy395;
	goto yy37;
yy248:
	yych = *++cur;
	if (yych == 'A') goto yy396;
	if (yych == 'a') goto yy396;
	goto yy37;
yy249:
	yych = *++cur;
	if (yych == 'L') goto yy397;
	if (yych == 'l') goto yy397;
	goto yy37;
yy250:
	yych = *++cur;
	if (yych <= 'E') {
		if (yych == 'A') goto yy398;
		if (yych <= 'D') goto yy37;
		goto yy399;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy37;
			goto yy398;
		} else {
			if (yych == 'e') goto yy399;
			goto yy37;
		}
	}
yy251:
	yych = *++cur;
	if (yych == 'E') goto yy400;
	if (yych == 'e') goto yy400;
	goto yy37;
yy252:
	yych = *++cur;
	if (yych <= '\f') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy61;
			goto yy252;
		} else {
			if (yych == '\v') goto yy252;
			goto yy61;
		}
	} else {
		if (yych <= ' ') {
			if (yych <= '\r') goto yy252;
			if (yych <= 0x1F) goto yy61;
			goto yy252;
		} else {
			if (yych <= '/') goto yy61;
			if (yych <= '9') goto yy401;
			goto yy61;
		}
	}
yy253:
	yych = *++cur;
	if (yych == 'B') goto yy403;
	if (yych == 'b') goto yy403;
	goto yy37;
yy254:
	yych = *++cur;
	if (yych == 'H') goto yy404;
	if (yych == 'h') goto yy404;
	goto yy37;
yy255:
	yych = *++cur;
	if (yych == 'M') goto yy405;
	if (yych == 'm') goto yy405;
	goto yy37;
yy256:
	yych = *++cur;
	if (yych == 'E') goto yy406;
	if (yych == 'e') goto yy406;
	goto yy37;
yy257:
	yyaccept = 10;
	yych = *(mar = ++cur);
	if (yybm[0+yych] & 8) {
		goto yy117;
	}
	switch (yych) {
		case '\t':
		case '\v':
		case '\r': goto yy408;
		case ' ': goto yy410;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'G':
		case 'H':
		case 'J':
		case 'K':
		case 'L':
		case 'N':
		case 'O':
		case 'Q':
		case 'R':
		case 'U':
		case 'V':
		case 'X':
		case 'Y':
		case 'Z':
		case 'g':
		case 'h':
		case 'j':
		case 'k':
		case 'l':
		case 'n':
		case 'o':
		case 'q':
		case 'r':
		case 'u':
		case 'v':
		case 'x':
		case 'y':
		case 'z': goto yy36;
		case 'A':
		case 'a': goto yy411;
		case 'B':
		case 'b': goto yy412;
		case 'C':
		case 'c': goto yy413;
		case 'D':
		case 'd': goto yy414;
		case 'E':
		case 'e': goto yy415;
		case 'F':
		case 'f': goto yy416;
		case 'I':
		case 'i': goto yy417;
		case 'M':
		case 'm': goto yy418;
		case 'P':
		case 'p': goto yy419;
		case 'S':
		case 's': goto yy420;
		case 'T':
		case 't': goto yy421;
		case 'W':
		case 'w': goto yy422;
		default: goto yy258;
	}
yy258:
#line 318 "parser/tokenizer.re"
	{ KW(END) }
#line 2984 "parser/tokenizer.cpp"
yy259:
	yych = *++cur;
	if (yych == 'R') goto yy423;
	if (yych == 'r') goto yy423;
	goto yy37;
yy260:
	yych = *++cur;
	if (yych == 'M') goto yy424;
	if (yych == 'm') goto yy424;
	goto yy37;
yy261:
	yych = *++cur;
	if (yych == 'I') goto yy426;
	if (yych == 'i') goto yy426;
	goto yy37;
yy262:
	yych = *++cur;
	if (yych <= 'O') {
		if (yych == 'M') goto yy427;
		if (yych <= 'N') goto yy37;
		goto yy428;
	} else {
		if (yych <= 'm') {
			if (yych <= 'l') goto yy37;
			goto yy427;
		} else {
			if (yych == 'o') goto yy428;
			goto yy37;
		}
	}
yy263:
	yych = *++cur;
	if (yych == 'N') goto yy429;
	if (yych == 'n') goto yy429;
	goto yy37;
yy264:
	yych = *++cur;
	if (yych == 'T') goto yy430;
	if (yych == 't') goto yy430;
	goto yy37;
yy265:
	yych = *++cur;
	if (yych == 'E') goto yy431;
	if (yych == 'e') goto yy431;
	goto yy37;
yy266:
	yych = *++cur;
	if (yych == 'E') goto yy432;
	if (yych == 'e') goto yy432;
	goto yy37;
yy267:
	yych = *++cur;
	if (yych == 'A') goto yy433;
	if (yych == 'a') goto yy433;
	goto yy37;
yy268:
	yych = *++cur;
	if (yych == 'S') goto yy434;
	if (yych == 's') goto yy434;
	goto yy37;
yy269:
	yych = *++cur;
	if (yych <= 'M') {
		if (yych == 'A') goto yy435;
		if (yych <= 'L') goto yy37;
		goto yy436;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy37;
			goto yy435;
		} else {
			if (yych == 'm') goto yy436;
			goto yy37;
		}
	}
yy270:
	yych = *++cur;
	if (yych == 'C') goto yy438;
	if (yych == 'c') goto yy438;
	goto yy37;
yy271:
	yych = *++cur;
	if (yych == 'E') goto yy439;
	if (yych == 'e') goto yy439;
	goto yy37;
yy272:
	yych = *++cur;
	if (yych == 'O') goto yy440;
	if (yych == 'o') goto yy440;
	goto yy37;
yy273:
	yych = *++cur;
	if (yych == 'G') goto yy441;
	if (yych == 'g') goto yy441;
	goto yy37;
yy274:
	yych = *++cur;
	if (yych <= 'U') {
		if (yych <= 'N') {
			if (yych == 'L') goto yy442;
			goto yy37;
		} else {
			if (yych <= 'O') goto yy443;
			if (yych <= 'T') goto yy37;
			goto yy444;
		}
	} else {
		if (yych <= 'n') {
			if (yych == 'l') goto yy442;
			goto yy37;
		} else {
			if (yych <= 'o') goto yy443;
			if (yych == 'u') goto yy444;
			goto yy37;
		}
	}
yy275:
	yych = *++cur;
	if (yych <= '\r') {
		if (yych <= '\n') {
			if (yych == '\t') goto yy275;
			goto yy61;
		} else {
			if (yych == '\f') goto yy61;
			goto yy275;
		}
	} else {
		if (yych <= 'N') {
			if (yych == ' ') goto yy275;
			goto yy61;
		} else {
			if (yych <= 'O') goto yy445;
			if (yych == 'o') goto yy445;
			goto yy61;
		}
	}
yy276:
	yych = *++cur;
	if (yych == 'L') goto yy446;
	if (yych == 'l') goto yy446;
	goto yy37;
yy277:
	yych = *++cur;
	if (yych == 'U') goto yy447;
	if (yych == 'u') goto yy447;
	goto yy37;
yy278:
	yych = *++cur;
	if (yych == 'U') goto yy448;
	if (yych == 'u') goto yy448;
	goto yy37;
yy279:
	yych = *++cur;
	if (yych == 'T') goto yy449;
	if (yych == 't') goto yy449;
	goto yy37;
yy280:
	yych = *++cur;
	if (yych <= 'R') {
		if (yych == 'E') goto yy450;
		if (yych <= 'Q') goto yy37;
		goto yy451;
	} else {
		if (yych <= 'e') {
			if (yych <= 'd') goto yy37;
			goto yy450;
		} else {
			if (yych == 'r') goto yy451;
			goto yy37;
		}
	}
yy281:
	yych = *++cur;
	if (yych == 'D') goto yy452;
	if (yych == 'd') goto yy452;
	goto yy37;
yy282:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 444 "parser/tokenizer.re"
	{ KW(LEN) }
#line 3169 "parser/tokenizer.cpp"
yy283:
	yych = *++cur;
	if (yych == 'A') goto yy453;
	if (yych == 'a') goto yy453;
	goto yy37;
yy284:
	yych = *++cur;
	if (yych == 'I') goto yy454;
	if (yych == 'i') goto yy454;
	goto yy37;
yy285:
	yych = *++cur;
	if (yych == 'O') goto yy455;
	if (yych == 'o') goto yy455;
	goto yy37;
yy286:
	yych = *++cur;
	if (yych == 'U') goto yy456;
	if (yych == 'u') goto yy456;
	goto yy37;
yy287:
	yych = *++cur;
	if (yych == 'D') goto yy457;
	if (yych == 'd') goto yy457;
	goto yy37;
yy288:
	yych = *++cur;
	if (yych == 'E') goto yy458;
	if (yych == 'e') goto yy458;
	goto yy37;
yy289:
	yych = *++cur;
	if (yych == '_') goto yy460;
	goto yy37;
yy290:
	yych = *++cur;
	if (yych <= '^') {
		if (yych == 'E') goto yy461;
		goto yy37;
	} else {
		if (yych <= '_') goto yy462;
		if (yych == 'e') goto yy461;
		goto yy37;
	}
yy291:
	yych = *++cur;
	if (yych == 'A') goto yy463;
	if (yych == 'a') goto yy463;
	goto yy37;
yy292:
	yych = *++cur;
	if (yych == 'L') goto yy464;
	if (yych == 'l') goto yy464;
	goto yy37;
yy293:
	yych = *++cur;
	if (yybm[0+yych] & 64) {
		goto yy293;
	}
	if (yych == '"') goto yy465;
	goto yy61;
yy294:
	yych = *++cur;
	if (yych == '\'') goto yy466;
	if (yych <= '/') goto yy61;
	if (yych <= '7') goto yy294;
	goto yy61;
yy295:
	yych = *++cur;
	if (yych == 'Y') goto yy467;
	if (yych == 'y') goto yy467;
	goto yy37;
yy296:
	yych = *++cur;
	if (yych <= 'R') {
		if (yych == 'N') goto yy468;
		if (yych <= 'Q') goto yy37;
		goto yy469;
	} else {
		if (yych <= 'n') {
			if (yych <= 'm') goto yy37;
			goto yy468;
		} else {
			if (yych == 'r') goto yy469;
			goto yy37;
		}
	}
yy297:
	yych = *++cur;
	if (yych == 'I') goto yy470;
	if (yych == 'i') goto yy470;
	goto yy37;
yy298:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 464 "parser/tokenizer.re"
	{ KW(OUT) }
#line 3270 "parser/tokenizer.cpp"
yy299:
	yych = *++cur;
	if (yych == 'A') goto yy471;
	if (yych == 'a') goto yy471;
	goto yy37;
yy300:
	yych = *++cur;
	if (yych == 'S') goto yy472;
	if (yych == 's') goto yy472;
	goto yy37;
yy301:
	yych = *++cur;
	if (yych == 'N') goto yy473;
	if (yych == 'n') goto yy473;
	goto yy37;
yy302:
	yych = *++cur;
	if (yych == 'T') goto yy474;
	if (yych == 't') goto yy474;
	goto yy37;
yy303:
	yych = *++cur;
	if (yych == 'C') goto yy475;
	if (yych == 'c') goto yy475;
	goto yy37;
yy304:
	yych = *++cur;
	if (yych <= 'V') {
		if (yych == 'N') goto yy476;
		if (yych <= 'U') goto yy37;
		goto yy477;
	} else {
		if (yych <= 'n') {
			if (yych <= 'm') goto yy37;
			goto yy476;
		} else {
			if (yych == 'v') goto yy477;
			goto yy37;
		}
	}
yy305:
	yych = *++cur;
	if (yych <= 'T') {
		if (yych <= 'F') {
			if (yych == 'C') goto yy478;
			goto yy37;
		} else {
			if (yych <= 'G') goto yy479;
			if (yych <= 'S') goto yy37;
			goto yy480;
		}
	} else {
		if (yych <= 'f') {
			if (yych == 'c') goto yy478;
			goto yy37;
		} else {
			if (yych <= 'g') goto yy479;
			if (yych == 't') goto yy480;
			goto yy37;
		}
	}
yy306:
	yych = *++cur;
	if (yych == 'L') goto yy481;
	if (yych == 'l') goto yy481;
	goto yy37;
yy307:
	yych = *++cur;
	if (yych == 'E') goto yy482;
	if (yych == 'e') goto yy482;
	goto yy37;
yy308:
	yych = *++cur;
	if (yych == 'E') goto yy483;
	if (yych == 'e') goto yy483;
	goto yy37;
yy309:
	yych = *++cur;
	if (yych == 'K') goto yy484;
	if (yych == 'k') goto yy484;
	goto yy37;
yy310:
	yych = *++cur;
	if (yych <= 'L') {
		if (yych == 'D') goto yy485;
		if (yych <= 'K') goto yy37;
		goto yy486;
	} else {
		if (yych <= 'd') {
			if (yych <= 'c') goto yy37;
			goto yy485;
		} else {
			if (yych == 'l') goto yy486;
			goto yy37;
		}
	}
yy311:
	yych = *++cur;
	if (yych == 'U') goto yy487;
	if (yych == 'u') goto yy487;
	goto yy37;
yy312:
	yych = *++cur;
	if (yych == 'U') goto yy488;
	if (yych == 'u') goto yy488;
	goto yy37;
yy313:
	yych = *++cur;
	if (yych == 'U') goto yy489;
	if (yych == 'u') goto yy489;
	goto yy37;
yy314:
	yych = *++cur;
	if (yych == 'U') goto yy490;
	if (yych == 'u') goto yy490;
	goto yy37;
yy315:
	yych = *++cur;
	if (yych == 'U') goto yy491;
	if (yych == 'u') goto yy491;
	goto yy37;
yy316:
	yych = *++cur;
	if (yych == 'I') goto yy492;
	if (yych == 'i') goto yy492;
	goto yy37;
yy317:
	yych = *++cur;
	if (yych == 'E') goto yy493;
	if (yych == 'e') goto yy493;
	goto yy37;
yy318:
	yych = *++cur;
	if (yych == 'E') goto yy494;
	if (yych == 'e') goto yy494;
	goto yy37;
yy319:
	yych = *++cur;
	if (yych == 'U') goto yy495;
	if (yych == 'u') goto yy495;
	goto yy37;
yy320:
	yych = *++cur;
	if (yych == 'R') goto yy496;
	if (yych == 'r') goto yy496;
	goto yy37;
yy321:
	yych = *++cur;
	if (yych == 'R') goto yy497;
	if (yych == 'r') goto yy497;
	goto yy37;
yy322:
	yych = *++cur;
	if (yych == 'T') goto yy498;
	if (yych == 't') goto yy498;
	goto yy37;
yy323:
	yych = *++cur;
	if (yych == 'P') goto yy499;
	if (yych == 'p') goto yy499;
	goto yy37;
yy324:
	yych = *++cur;
	if (yych <= 'R') {
		if (yych == 'M') goto yy500;
		if (yych <= 'Q') goto yy37;
		goto yy501;
	} else {
		if (yych <= 'm') {
			if (yych <= 'l') goto yy37;
			goto yy500;
		} else {
			if (yych == 'r') goto yy501;
			goto yy37;
		}
	}
yy325:
	yych = *++cur;
	if (yych == 'C') goto yy502;
	if (yych == 'c') goto yy502;
	goto yy37;
yy326:
	yych = *++cur;
	if (yych == 'G') goto yy504;
	if (yych == 'g') goto yy504;
	goto yy37;
yy327:
	yych = *++cur;
	if (yych == 'M') goto yy505;
	if (yych == 'm') goto yy505;
	goto yy37;
yy328:
	yych = *++cur;
	if (yych == 'P') goto yy506;
	if (yych == 'p') goto yy506;
	goto yy37;
yy329:
	yych = *++cur;
	if (yych == 'N') goto yy507;
	if (yych == 'n') goto yy507;
	goto yy37;
yy330:
	yych = *++cur;
	if (yych == 'E') goto yy508;
	if (yych == 'e') goto yy508;
	goto yy37;
yy331:
	yych = *++cur;
	if (yych == 'O') goto yy509;
	if (yych == 'o') goto yy509;
	goto yy37;
yy332:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 513 "parser/tokenizer.re"
	{ KW(USE) }
#line 3490 "parser/tokenizer.cpp"
yy333:
	yych = *++cur;
	if (yych == 'U') goto yy510;
	if (yych == 'u') goto yy510;
	goto yy37;
yy334:
	yych = *++cur;
	if (yych == 'A') goto yy511;
	if (yych == 'a') goto yy511;
	goto yy37;
yy335:
	yych = *++cur;
	if (yych == 'T') goto yy512;
	if (yych == 't') goto yy512;
	goto yy37;
yy336:
	yych = *++cur;
	if (yych == 'R') goto yy513;
	if (yych == 'r') goto yy513;
	goto yy37;
yy337:
	yych = *++cur;
	if (yych == 'L') goto yy514;
	if (yych == 'l') goto yy514;
	goto yy37;
yy338:
	yych = *++cur;
	if (yych == 'T') goto yy515;
	if (yych == 't') goto yy515;
	goto yy37;
yy339:
	yych = *++cur;
yy340:
	if (yybm[0+yych] & 128) {
		goto yy339;
	}
	if (yych == '"') goto yy516;
	goto yy61;
yy341:
	yych = *++cur;
yy342:
	if (yych <= '9') {
		if (yych == '\'') goto yy517;
		if (yych <= '/') goto yy61;
		goto yy341;
	} else {
		if (yych <= 'F') {
			if (yych <= '@') goto yy61;
			goto yy341;
		} else {
			if (yych <= '`') goto yy61;
			if (yych <= 'f') goto yy341;
			goto yy61;
		}
	}
yy343:
	yych = *++cur;
	if (yych == 'P') goto yy518;
	if (yych == 'p') goto yy518;
	goto yy60;
yy344:
	yych = *++cur;
	if (yych <= 0x00) goto yy61;
	if (yych == '\n') goto yy519;
	goto yy344;
yy345:
	yych = *++cur;
	if (yych == 'i') goto yy520;
	goto yy69;
yy346:
	yych = *++cur;
	if (yych == 'f') goto yy521;
	goto yy69;
yy347:
	yych = *++cur;
	if (yych == 'e') goto yy522;
	goto yy69;
yy348:
	yych = *++cur;
	if (yych == 'i') goto yy523;
	goto yy69;
yy349:
	yych = *++cur;
	if (yych == 'e') goto yy524;
	goto yy69;
yy350:
	yych = *++cur;
	if (yych == 'e') goto yy525;
	goto yy69;
yy351:
	++cur;
	cur = ctxmar;
#line 541 "parser/tokenizer.re"
	{ RET(TK_LPAREN) }
#line 3585 "parser/tokenizer.cpp"
yy352:
	yych = *++cur;
yy353:
	if (yych <= '\f') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy61;
			goto yy352;
		} else {
			if (yych == '\v') goto yy352;
			goto yy61;
		}
	} else {
		if (yych <= ' ') {
			if (yych <= '\r') goto yy352;
			if (yych <= 0x1F) goto yy61;
			goto yy352;
		} else {
			if (yych == ')') goto yy526;
			goto yy61;
		}
	}
yy354:
	++cur;
	cur -= 3;
#line 544 "parser/tokenizer.re"
	{ RET(TK_LPAREN) }
#line 3612 "parser/tokenizer.cpp"
yy355:
	yych = *++cur;
	if (yych <= '/') goto yy90;
	if (yych <= '9') goto yy355;
	goto yy90;
yy356:
	yych = *++cur;
	if (yych <= 'Z') {
		if (yych <= '/') goto yy90;
		if (yych <= '9') goto yy356;
		if (yych <= '@') goto yy90;
		goto yy356;
	} else {
		if (yych <= '_') {
			if (yych <= '^') goto yy90;
			goto yy356;
		} else {
			if (yych <= '`') goto yy90;
			if (yych <= 'z') goto yy356;
			goto yy90;
		}
	}
yy357:
	yych = *++cur;
	if (yych == '.') goto yy527;
	goto yy93;
yy358:
	++cur;
#line 571 "parser/tokenizer.re"
	{ WARN_REL(EQ) RET(TK_EQ) }
#line 3643 "parser/tokenizer.cpp"
yy359:
	yych = *++cur;
	if (yych == '.') goto yy528;
	goto yy93;
yy360:
	yych = *++cur;
	if (yych == 'S') goto yy529;
	if (yych == 's') goto yy529;
	goto yy93;
yy361:
	++cur;
#line 586 "parser/tokenizer.re"
	{ WARN_REL(GE) RET(TK_GE) }
#line 3657 "parser/tokenizer.cpp"
yy362:
	++cur;
#line 583 "parser/tokenizer.re"
	{ WARN_REL(GT) RET(TK_GT) }
#line 3662 "parser/tokenizer.cpp"
yy363:
	++cur;
#line 580 "parser/tokenizer.re"
	{ WARN_REL(LE) RET(TK_LE) }
#line 3667 "parser/tokenizer.cpp"
yy364:
	++cur;
#line 577 "parser/tokenizer.re"
	{ WARN_REL(LT) RET(TK_LT) }
#line 3672 "parser/tokenizer.cpp"
yy365:
	++cur;
#line 574 "parser/tokenizer.re"
	{ WARN_REL(NE) RET(TK_NE) }
#line 3677 "parser/tokenizer.cpp"
yy366:
	yych = *++cur;
	if (yych == 'V') goto yy530;
	if (yych == 'v') goto yy530;
	goto yy93;
yy367:
	yych = *++cur;
	if (yych == '.') goto yy531;
	goto yy93;
yy368:
	++cur;
#line 592 "parser/tokenizer.re"
	{ RET(TK_OR) }
#line 3691 "parser/tokenizer.cpp"
yy369:
	yych = *++cur;
	if (yych == 'E') goto yy532;
	if (yych == 'e') goto yy532;
	goto yy93;
yy370:
	yych = *++cur;
	if (yych == '.') goto yy533;
	goto yy93;
yy371:
	++cur;
	cur = ctxmar;
#line 607 "parser/tokenizer.re"
	{
                lex_int_large(al, tok, cur,
                    yylval.int_suffix.int_n,
                    yylval.int_suffix.int_kind);
                RET(TK_INTEGER)
            }
#line 3711 "parser/tokenizer.cpp"
yy372:
	yych = *++cur;
	if (yych == '.') goto yy61;
	goto yy222;
yy373:
	yych = *++cur;
	if (yych == 'R') goto yy534;
	if (yych == 'r') goto yy534;
	goto yy37;
yy374:
	yych = *++cur;
	if (yych == 'C') goto yy535;
	if (yych == 'c') goto yy535;
	goto yy37;
yy375:
	yych = *++cur;
	if (yych == 'G') goto yy536;
	if (yych == 'g') goto yy536;
	goto yy37;
yy376:
	yych = *++cur;
	if (yych == 'C') goto yy537;
	if (yych == 'c') goto yy537;
	goto yy37;
yy377:
	yych = *++cur;
	if (yych == 'C') goto yy538;
	if (yych == 'c') goto yy538;
	goto yy37;
yy378:
	++cur;
#line 651 "parser/tokenizer.re"
	{ token(yylval.string); RET(TK_BOZ_CONSTANT) }
#line 3745 "parser/tokenizer.cpp"
yy379:
	++cur;
#line 652 "parser/tokenizer.re"
	{ token(yylval.string); RET(TK_BOZ_CONSTANT) }
#line 3750 "parser/tokenizer.cpp"
yy380:
	yych = *++cur;
	if (yych == 'S') goto yy539;
	if (yych == 's') goto yy539;
	goto yy37;
yy381:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 278 "parser/tokenizer.re"
	{ KW(BIND) }
#line 3764 "parser/tokenizer.cpp"
yy382:
	yych = *++cur;
	if (yych == 'K') goto yy540;
	if (yych == 'k') goto yy540;
	goto yy37;
yy383:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 280 "parser/tokenizer.re"
	{ KW(CALL) }
#line 3778 "parser/tokenizer.cpp"
yy384:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 281 "parser/tokenizer.re"
	{ KW(CASE) }
#line 3787 "parser/tokenizer.cpp"
yy385:
	yych = *++cur;
	if (yych == 'G') goto yy541;
	if (yych == 'g') goto yy541;
	goto yy37;
yy386:
	yych = *++cur;
	if (yych == 'A') goto yy542;
	if (yych == 'a') goto yy542;
	goto yy37;
yy387:
	yych = *++cur;
	if (yych == 'S') goto yy543;
	if (yych == 's') goto yy543;
	goto yy37;
yy388:
	yych = *++cur;
	if (yych == 'E') goto yy544;
	if (yych == 'e') goto yy544;
	goto yy37;
yy389:
	yych = *++cur;
	if (yych == 'M') goto yy545;
	if (yych == 'm') goto yy545;
	goto yy37;
yy390:
	yych = *++cur;
	if (yych == 'O') goto yy546;
	if (yych == 'o') goto yy546;
	goto yy37;
yy391:
	yych = *++cur;
	if (yych == 'L') goto yy547;
	if (yych == 'l') goto yy547;
	goto yy37;
yy392:
	yych = *++cur;
	if (yych == 'U') goto yy548;
	if (yych == 'u') goto yy548;
	goto yy37;
yy393:
	yych = *++cur;
	if (yych <= 'I') {
		if (yych == 'A') goto yy549;
		if (yych <= 'H') goto yy37;
		goto yy550;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy37;
			goto yy549;
		} else {
			if (yych == 'i') goto yy550;
			goto yy37;
		}
	}
yy394:
	yych = *++cur;
	if (yych == 'I') goto yy551;
	if (yych == 'i') goto yy551;
	goto yy37;
yy395:
	yych = *++cur;
	if (yych == 'E') goto yy552;
	if (yych == 'e') goto yy552;
	goto yy37;
yy396:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 296 "parser/tokenizer.re"
	{ KW(DATA) }
#line 3861 "parser/tokenizer.cpp"
yy397:
	yych = *++cur;
	if (yych == 'L') goto yy553;
	if (yych == 'l') goto yy553;
	goto yy37;
yy398:
	yych = *++cur;
	if (yych == 'U') goto yy554;
	if (yych == 'u') goto yy554;
	goto yy37;
yy399:
	yych = *++cur;
	if (yych == 'R') goto yy555;
	if (yych == 'r') goto yy555;
	goto yy37;
yy400:
	yych = *++cur;
	if (yych == 'N') goto yy556;
	if (yych == 'n') goto yy556;
	goto yy37;
yy401:
	yych = *++cur;
	if (yych <= '/') goto yy402;
	if (yych <= '9') goto yy401;
yy402:
	cur = ctxmar;
#line 301 "parser/tokenizer.re"
	{
                // This is a label do statement, we have to match the
                // corresponding continue base "end do".
                uint64_t n = parse_int(cur);
                enddo_label_stack.push_back(n);
                KW(DO);
            }
#line 3896 "parser/tokenizer.cpp"
yy403:
	yych = *++cur;
	if (yych == 'L') goto yy557;
	if (yych == 'l') goto yy557;
	goto yy37;
yy404:
	yych = *++cur;
	if (yych == 'I') goto yy558;
	if (yych == 'i') goto yy558;
	goto yy37;
yy405:
	yych = *++cur;
	if (yych == 'E') goto yy559;
	if (yych == 'e') goto yy559;
	goto yy37;
yy406:
	yych = *++cur;
	if (yybm[0+yych] & 8) {
		goto yy117;
	}
	if (yych <= 'W') {
		if (yych <= '@') {
			if (yych <= '/') goto yy407;
			if (yych <= '9') goto yy36;
		} else {
			if (yych == 'I') goto yy560;
			if (yych <= 'V') goto yy36;
			goto yy561;
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'Z') goto yy36;
			if (yych <= '`') goto yy407;
			if (yych <= 'h') goto yy36;
			goto yy560;
		} else {
			if (yych == 'w') goto yy561;
			if (yych <= 'z') goto yy36;
		}
	}
yy407:
#line 314 "parser/tokenizer.re"
	{ KW(ELSE) }
#line 3940 "parser/tokenizer.cpp"
yy408:
	yych = *++cur;
yy409:
	switch (yych) {
		case '\t':
		case '\v':
		case '\r':
		case ' ': goto yy408;
		case 'A':
		case 'a': goto yy562;
		case 'B':
		case 'b': goto yy563;
		case 'C':
		case 'c': goto yy564;
		case 'D':
		case 'd': goto yy565;
		case 'E':
		case 'e': goto yy566;
		case 'F':
		case 'f': goto yy567;
		case 'I':
		case 'i': goto yy568;
		case 'M':
		case 'm': goto yy569;
		case 'P':
		case 'p': goto yy570;
		case 'S':
		case 's': goto yy571;
		case 'T':
		case 't': goto yy572;
		case 'W':
		case 'w': goto yy573;
		default: goto yy61;
	}
yy410:
	yych = *++cur;
	if (yych == 'F') goto yy574;
	if (yych == 'f') goto yy574;
	goto yy409;
yy411:
	yych = *++cur;
	if (yych == 'S') goto yy575;
	if (yych == 's') goto yy575;
	goto yy37;
yy412:
	yych = *++cur;
	if (yych == 'L') goto yy576;
	if (yych == 'l') goto yy576;
	goto yy37;
yy413:
	yych = *++cur;
	if (yych == 'R') goto yy577;
	if (yych == 'r') goto yy577;
	goto yy37;
yy414:
	yych = *++cur;
	if (yych == 'O') goto yy578;
	if (yych == 'o') goto yy578;
	goto yy37;
yy415:
	yych = *++cur;
	if (yych == 'N') goto yy579;
	if (yych == 'n') goto yy579;
	goto yy37;
yy416:
	yych = *++cur;
	if (yych <= 'U') {
		if (yych <= 'N') {
			if (yych == 'I') goto yy580;
			goto yy37;
		} else {
			if (yych <= 'O') goto yy581;
			if (yych <= 'T') goto yy37;
			goto yy582;
		}
	} else {
		if (yych <= 'n') {
			if (yych == 'i') goto yy580;
			goto yy37;
		} else {
			if (yych <= 'o') goto yy581;
			if (yych == 'u') goto yy582;
			goto yy37;
		}
	}
yy417:
	yych = *++cur;
	if (yych <= 'N') {
		if (yych == 'F') goto yy583;
		if (yych <= 'M') goto yy37;
		goto yy584;
	} else {
		if (yych <= 'f') {
			if (yych <= 'e') goto yy37;
			goto yy583;
		} else {
			if (yych == 'n') goto yy584;
			goto yy37;
		}
	}
yy418:
	yych = *++cur;
	if (yych == 'O') goto yy585;
	if (yych == 'o') goto yy585;
	goto yy37;
yy419:
	yych = *++cur;
	if (yych == 'R') goto yy586;
	if (yych == 'r') goto yy586;
	goto yy37;
yy420:
	yych = *++cur;
	if (yych <= 'U') {
		if (yych == 'E') goto yy587;
		if (yych <= 'T') goto yy37;
		goto yy588;
	} else {
		if (yych <= 'e') {
			if (yych <= 'd') goto yy37;
			goto yy587;
		} else {
			if (yych == 'u') goto yy588;
			goto yy37;
		}
	}
yy421:
	yych = *++cur;
	if (yych <= 'Y') {
		if (yych == 'E') goto yy589;
		if (yych <= 'X') goto yy37;
		goto yy590;
	} else {
		if (yych <= 'e') {
			if (yych <= 'd') goto yy37;
			goto yy589;
		} else {
			if (yych == 'y') goto yy590;
			goto yy37;
		}
	}
yy422:
	yych = *++cur;
	if (yych == 'H') goto yy591;
	if (yych == 'h') goto yy591;
	goto yy37;
yy423:
	yych = *++cur;
	if (yych == 'Y') goto yy592;
	if (yych == 'y') goto yy592;
	goto yy37;
yy424:
	yych = *++cur;
	if (yybm[0+yych] & 8) {
		goto yy117;
	}
	if (yych <= 'E') {
		if (yych <= '9') {
			if (yych >= '0') goto yy36;
		} else {
			if (yych <= '@') goto yy425;
			if (yych <= 'D') goto yy36;
			goto yy593;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy36;
			if (yych >= 'a') goto yy36;
		} else {
			if (yych <= 'e') goto yy593;
			if (yych <= 'z') goto yy36;
		}
	}
yy425:
#line 395 "parser/tokenizer.re"
	{ KW(ENUM) }
#line 4116 "parser/tokenizer.cpp"
yy426:
	yych = *++cur;
	if (yych == 'V') goto yy594;
	if (yych == 'v') goto yy594;
	goto yy37;
yy427:
	yych = *++cur;
	if (yych == 'S') goto yy595;
	if (yych == 's') goto yy595;
	goto yy37;
yy428:
	yych = *++cur;
	if (yych == 'R') goto yy596;
	if (yych == 'r') goto yy596;
	goto yy37;
yy429:
	yych = *++cur;
	if (yych == 'T') goto yy597;
	if (yych == 't') goto yy597;
	goto yy37;
yy430:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 401 "parser/tokenizer.re"
	{ KW(EXIT) }
#line 4145 "parser/tokenizer.cpp"
yy431:
	yych = *++cur;
	if (yych <= 'R') {
		if (yych == 'N') goto yy598;
		if (yych <= 'Q') goto yy37;
		goto yy599;
	} else {
		if (yych <= 'n') {
			if (yych <= 'm') goto yy37;
			goto yy598;
		} else {
			if (yych == 'r') goto yy599;
			goto yy37;
		}
	}
yy432:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 404 "parser/tokenizer.re"
	{ KW(FILE) }
#line 4169 "parser/tokenizer.cpp"
yy433:
	yych = *++cur;
	if (yych == 'L') goto yy600;
	if (yych == 'l') goto yy600;
	goto yy37;
yy434:
	yych = *++cur;
	if (yych == 'H') goto yy601;
	if (yych == 'h') goto yy601;
	goto yy37;
yy435:
	yych = *++cur;
	if (yych == 'L') goto yy602;
	if (yych == 'l') goto yy602;
	goto yy37;
yy436:
	yych = *++cur;
	if (yybm[0+yych] & 8) {
		goto yy117;
	}
	if (yych <= 'T') {
		if (yych <= '@') {
			if (yych <= '/') goto yy437;
			if (yych <= '9') goto yy36;
		} else {
			if (yych <= 'A') goto yy603;
			if (yych <= 'S') goto yy36;
			goto yy604;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy36;
			if (yych >= 'a') goto yy603;
		} else {
			if (yych == 't') goto yy604;
			if (yych <= 'z') goto yy36;
		}
	}
yy437:
#line 421 "parser/tokenizer.re"
	{ KW(FORM) }
#line 4211 "parser/tokenizer.cpp"
yy438:
	yych = *++cur;
	if (yych == 'T') goto yy605;
	if (yych == 't') goto yy605;
	goto yy37;
yy439:
	yych = *++cur;
	if (yych == 'R') goto yy606;
	if (yych == 'r') goto yy606;
	goto yy37;
yy440:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 426 "parser/tokenizer.re"
	{ KW(GOTO) }
#line 4230 "parser/tokenizer.cpp"
yy441:
	yych = *++cur;
	if (yych == 'E') goto yy607;
	if (yych == 'e') goto yy607;
	goto yy37;
yy442:
	yych = *++cur;
	if (yych == 'I') goto yy608;
	if (yych == 'i') goto yy608;
	goto yy37;
yy443:
	yych = *++cur;
	if (yych == 'R') goto yy609;
	if (yych == 'r') goto yy609;
	goto yy37;
yy444:
	yych = *++cur;
	if (yych == 'R') goto yy610;
	if (yych == 'r') goto yy610;
	goto yy37;
yy445:
	yych = *++cur;
	if (yych == 'U') goto yy611;
	if (yych == 'u') goto yy611;
	goto yy61;
yy446:
	yych = *++cur;
	if (yych == 'U') goto yy612;
	if (yych == 'u') goto yy612;
	goto yy37;
yy447:
	yych = *++cur;
	if (yych == 'T') goto yy613;
	if (yych == 't') goto yy613;
	goto yy37;
yy448:
	yych = *++cur;
	if (yych == 'I') goto yy614;
	if (yych == 'i') goto yy614;
	goto yy37;
yy449:
	yych = *++cur;
	if (yych == 'A') goto yy615;
	if (yych == 'a') goto yy615;
	goto yy37;
yy450:
	yych = *++cur;
	if (yych <= 'R') {
		if (yych <= 'M') {
			if (yych == 'G') goto yy616;
			goto yy37;
		} else {
			if (yych <= 'N') goto yy617;
			if (yych <= 'Q') goto yy37;
			goto yy618;
		}
	} else {
		if (yych <= 'm') {
			if (yych == 'g') goto yy616;
			goto yy37;
		} else {
			if (yych <= 'n') goto yy617;
			if (yych == 'r') goto yy618;
			goto yy37;
		}
	}
yy451:
	yych = *++cur;
	if (yych == 'I') goto yy619;
	if (yych == 'i') goto yy619;
	goto yy37;
yy452:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 443 "parser/tokenizer.re"
	{ KW(KIND) }
#line 4310 "parser/tokenizer.cpp"
yy453:
	yych = *++cur;
	if (yych == 'L') goto yy620;
	if (yych == 'l') goto yy620;
	goto yy37;
yy454:
	yych = *++cur;
	if (yych == 'C') goto yy621;
	if (yych == 'c') goto yy621;
	goto yy37;
yy455:
	yych = *++cur;
	if (yych == 'R') goto yy622;
	if (yych == 'r') goto yy622;
	goto yy37;
yy456:
	yych = *++cur;
	if (yych == 'L') goto yy623;
	if (yych == 'l') goto yy623;
	goto yy37;
yy457:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 450 "parser/tokenizer.re"
	{ KW(MOLD) }
#line 4339 "parser/tokenizer.cpp"
yy458:
	yych = *++cur;
	if (yybm[0+yych] & 8) {
		goto yy117;
	}
	if (yych <= 'L') {
		if (yych <= '9') {
			if (yych >= '0') goto yy36;
		} else {
			if (yych <= '@') goto yy459;
			if (yych <= 'K') goto yy36;
			goto yy624;
		}
	} else {
		if (yych <= 'k') {
			if (yych <= 'Z') goto yy36;
			if (yych >= 'a') goto yy36;
		} else {
			if (yych <= 'l') goto yy624;
			if (yych <= 'z') goto yy36;
		}
	}
yy459:
#line 451 "parser/tokenizer.re"
	{ KW(NAME) }
#line 4365 "parser/tokenizer.cpp"
yy460:
	yyaccept = 2;
	yych = *(mar = ++cur);
	if (yych <= '\'') {
		if (yych == '"') goto yy65;
		if (yych <= '&') goto yy37;
		goto yy82;
	} else {
		if (yych <= 'I') {
			if (yych <= 'H') goto yy37;
			goto yy625;
		} else {
			if (yych == 'i') goto yy625;
			goto yy37;
		}
	}
yy461:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 458 "parser/tokenizer.re"
	{ KW(NONE) }
#line 4390 "parser/tokenizer.cpp"
yy462:
	yyaccept = 2;
	yych = *(mar = ++cur);
	if (yych <= 'O') {
		if (yych <= '\'') {
			if (yych == '"') goto yy65;
			if (yych <= '&') goto yy37;
			goto yy82;
		} else {
			if (yych == 'I') goto yy626;
			if (yych <= 'N') goto yy37;
			goto yy627;
		}
	} else {
		if (yych <= 'i') {
			if (yych == 'R') goto yy628;
			if (yych <= 'h') goto yy37;
			goto yy626;
		} else {
			if (yych <= 'o') {
				if (yych <= 'n') goto yy37;
				goto yy627;
			} else {
				if (yych == 'r') goto yy628;
				goto yy37;
			}
		}
	}
yy463:
	yych = *++cur;
	if (yych == 'S') goto yy629;
	if (yych == 's') goto yy629;
	goto yy37;
yy464:
	yych = *++cur;
	if (yych == 'I') goto yy630;
	if (yych == 'i') goto yy630;
	goto yy37;
yy465:
	++cur;
#line 653 "parser/tokenizer.re"
	{ token(yylval.string); RET(TK_BOZ_CONSTANT) }
#line 4433 "parser/tokenizer.cpp"
yy466:
	++cur;
#line 654 "parser/tokenizer.re"
	{ token(yylval.string); RET(TK_BOZ_CONSTANT) }
#line 4438 "parser/tokenizer.cpp"
yy467:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 460 "parser/tokenizer.re"
	{ KW(ONLY) }
#line 4447 "parser/tokenizer.cpp"
yy468:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 461 "parser/tokenizer.re"
	{ KW(OPEN) }
#line 4456 "parser/tokenizer.cpp"
yy469:
	yych = *++cur;
	if (yych == 'A') goto yy631;
	if (yych == 'a') goto yy631;
	goto yy37;
yy470:
	yych = *++cur;
	if (yych == 'O') goto yy632;
	if (yych == 'o') goto yy632;
	goto yy37;
yy471:
	yych = *++cur;
	if (yych == 'M') goto yy633;
	if (yych == 'm') goto yy633;
	goto yy37;
yy472:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 466 "parser/tokenizer.re"
	{ KW(PASS) }
#line 4480 "parser/tokenizer.cpp"
yy473:
	yych = *++cur;
	if (yych == 'T') goto yy634;
	if (yych == 't') goto yy634;
	goto yy37;
yy474:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 468 "parser/tokenizer.re"
	{ KW(POST) }
#line 4494 "parser/tokenizer.cpp"
yy475:
	yych = *++cur;
	if (yych == 'I') goto yy635;
	if (yych == 'i') goto yy635;
	goto yy37;
yy476:
	yych = *++cur;
	if (yych == 'T') goto yy636;
	if (yych == 't') goto yy636;
	goto yy37;
yy477:
	yych = *++cur;
	if (yych == 'A') goto yy637;
	if (yych == 'a') goto yy637;
	goto yy37;
yy478:
	yych = *++cur;
	if (yych == 'E') goto yy638;
	if (yych == 'e') goto yy638;
	goto yy37;
yy479:
	yych = *++cur;
	if (yych == 'R') goto yy639;
	if (yych == 'r') goto yy639;
	goto yy37;
yy480:
	yych = *++cur;
	if (yych == 'E') goto yy640;
	if (yych == 'e') goto yy640;
	goto yy37;
yy481:
	yych = *++cur;
	if (yych == 'I') goto yy641;
	if (yych == 'i') goto yy641;
	goto yy37;
yy482:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 476 "parser/tokenizer.re"
	{ KW(PURE) }
#line 4538 "parser/tokenizer.cpp"
yy483:
	yych = *++cur;
	if (yych == 'T') goto yy642;
	if (yych == 't') goto yy642;
	goto yy37;
yy484:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 478 "parser/tokenizer.re"
	{ KW(RANK) }
#line 4552 "parser/tokenizer.cpp"
yy485:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 479 "parser/tokenizer.re"
	{ KW(READ) }
#line 4561 "parser/tokenizer.cpp"
yy486:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 480 "parser/tokenizer.re"
	{KW(REAL) }
#line 4570 "parser/tokenizer.cpp"
yy487:
	yych = *++cur;
	if (yych == 'R') goto yy643;
	if (yych == 'r') goto yy643;
	goto yy37;
yy488:
	yych = *++cur;
	if (yych == 'C') goto yy644;
	if (yych == 'c') goto yy644;
	goto yy37;
yy489:
	yych = *++cur;
	if (yych == 'I') goto yy645;
	if (yych == 'i') goto yy645;
	goto yy37;
yy490:
	yych = *++cur;
	if (yych == 'L') goto yy646;
	if (yych == 'l') goto yy646;
	goto yy37;
yy491:
	yych = *++cur;
	if (yych == 'R') goto yy647;
	if (yych == 'r') goto yy647;
	goto yy37;
yy492:
	yych = *++cur;
	if (yych == 'N') goto yy648;
	if (yych == 'n') goto yy648;
	goto yy37;
yy493:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 488 "parser/tokenizer.re"
	{ KW(SAVE) }
#line 4609 "parser/tokenizer.cpp"
yy494:
	yych = *++cur;
	if (yych == 'C') goto yy649;
	if (yych == 'c') goto yy649;
	goto yy37;
yy495:
	yych = *++cur;
	if (yych == 'E') goto yy650;
	if (yych == 'e') goto yy650;
	goto yy37;
yy496:
	yych = *++cur;
	if (yych == 'E') goto yy651;
	if (yych == 'e') goto yy651;
	goto yy37;
yy497:
	yych = *++cur;
	if (yych == 'C') goto yy652;
	if (yych == 'c') goto yy652;
	goto yy37;
yy498:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 496 "parser/tokenizer.re"
	{ KW(STAT) }
#line 4638 "parser/tokenizer.cpp"
yy499:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 497 "parser/tokenizer.re"
	{ KW(STOP) }
#line 4647 "parser/tokenizer.cpp"
yy500:
	yych = *++cur;
	if (yych == 'O') goto yy653;
	if (yych == 'o') goto yy653;
	goto yy37;
yy501:
	yych = *++cur;
	if (yych == 'O') goto yy654;
	if (yych == 'o') goto yy654;
	goto yy37;
yy502:
	yych = *++cur;
	if (yybm[0+yych] & 8) {
		goto yy117;
	}
	if (yych <= 'T') {
		if (yych <= 'H') {
			if (yych <= '9') {
				if (yych >= '0') goto yy36;
			} else {
				if (yych <= '@') goto yy503;
				if (yych <= 'A') goto yy655;
				goto yy36;
			}
		} else {
			if (yych <= 'L') {
				if (yych <= 'I') goto yy656;
				goto yy36;
			} else {
				if (yych <= 'M') goto yy657;
				if (yych <= 'S') goto yy36;
				goto yy658;
			}
		}
	} else {
		if (yych <= 'i') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy36;
			} else {
				if (yych <= 'a') goto yy655;
				if (yych <= 'h') goto yy36;
				goto yy656;
			}
		} else {
			if (yych <= 's') {
				if (yych == 'm') goto yy657;
				goto yy36;
			} else {
				if (yych <= 't') goto yy658;
				if (yych <= 'z') goto yy36;
			}
		}
	}
yy503:
#line 500 "parser/tokenizer.re"
	{ KW(SYNC) }
#line 4704 "parser/tokenizer.cpp"
yy504:
	yych = *++cur;
	if (yych == 'E') goto yy659;
	if (yych == 'e') goto yy659;
	goto yy37;
yy505:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy660;
#line 506 "parser/tokenizer.re"
	{ KW(TEAM) }
#line 4718 "parser/tokenizer.cpp"
yy506:
	yych = *++cur;
	if (yych == 'L') goto yy661;
	if (yych == 'l') goto yy661;
	goto yy37;
yy507:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 509 "parser/tokenizer.re"
	{ KW(THEN) }
#line 4732 "parser/tokenizer.cpp"
yy508:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 511 "parser/tokenizer.re"
	{ KW(TYPE) }
#line 4741 "parser/tokenizer.cpp"
yy509:
	yych = *++cur;
	if (yych == 'R') goto yy662;
	if (yych == 'r') goto yy662;
	goto yy37;
yy510:
	yych = *++cur;
	if (yych == 'E') goto yy663;
	if (yych == 'e') goto yy663;
	goto yy37;
yy511:
	yych = *++cur;
	if (yych == 'T') goto yy664;
	if (yych == 't') goto yy664;
	goto yy37;
yy512:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 516 "parser/tokenizer.re"
	{ KW(WAIT) }
#line 4765 "parser/tokenizer.cpp"
yy513:
	yych = *++cur;
	if (yych == 'E') goto yy665;
	if (yych == 'e') goto yy665;
	goto yy37;
yy514:
	yych = *++cur;
	if (yych == 'E') goto yy666;
	if (yych == 'e') goto yy666;
	goto yy37;
yy515:
	yych = *++cur;
	if (yych == 'E') goto yy667;
	if (yych == 'e') goto yy667;
	goto yy37;
yy516:
	++cur;
#line 655 "parser/tokenizer.re"
	{ token(yylval.string); RET(TK_BOZ_CONSTANT) }
#line 4785 "parser/tokenizer.cpp"
yy517:
	++cur;
#line 656 "parser/tokenizer.re"
	{ token(yylval.string); RET(TK_BOZ_CONSTANT) }
#line 4790 "parser/tokenizer.cpp"
yy518:
	yych = *++cur;
	if (yych <= '\v') {
		if (yych == '\t') goto yy670;
		if (yych <= '\n') goto yy669;
		goto yy670;
	} else {
		if (yych <= '\r') {
			if (yych <= '\f') goto yy669;
			goto yy670;
		} else {
			if (yych == ' ') goto yy670;
			goto yy669;
		}
	}
yy519:
	++cur;
	cur -= 1;
#line 664 "parser/tokenizer.re"
	{ TK_TRIVIA(TK_PRAGMA_DECL) }
#line 4811 "parser/tokenizer.cpp"
yy520:
	yych = *++cur;
	if (yych == 'n') goto yy672;
	goto yy69;
yy521:
	yych = *++cur;
	if (yych <= '\v') {
		if (yych == '\t') goto yy673;
		if (yych <= '\n') goto yy69;
		goto yy673;
	} else {
		if (yych <= '\r') {
			if (yych <= '\f') goto yy69;
			goto yy673;
		} else {
			if (yych == ' ') goto yy673;
			goto yy69;
		}
	}
yy522:
	yych = *++cur;
	if (yych <= '\v') {
		if (yych <= 0x08) {
			if (yych <= 0x00) goto yy61;
			goto yy68;
		} else {
			if (yych == '\n') goto yy674;
			goto yy522;
		}
	} else {
		if (yych <= '\r') {
			if (yych <= '\f') goto yy68;
			goto yy522;
		} else {
			if (yych == ' ') goto yy522;
			goto yy68;
		}
	}
yy523:
	yych = *++cur;
	if (yych == 'f') goto yy675;
	goto yy69;
yy524:
	yych = *++cur;
	if (yych == 'f') goto yy676;
	goto yy69;
yy525:
	yych = *++cur;
	if (yych <= '\v') {
		if (yych == '\t') goto yy677;
		if (yych <= '\n') goto yy69;
		goto yy677;
	} else {
		if (yych <= '\r') {
			if (yych <= '\f') goto yy69;
			goto yy677;
		} else {
			if (yych == ' ') goto yy677;
			goto yy69;
		}
	}
yy526:
	++cur;
	cur = ctxmar;
#line 543 "parser/tokenizer.re"
	{ RET(TK_LPAREN) }
#line 4878 "parser/tokenizer.cpp"
yy527:
	++cur;
#line 591 "parser/tokenizer.re"
	{ RET(TK_AND) }
#line 4883 "parser/tokenizer.cpp"
yy528:
	++cur;
#line 594 "parser/tokenizer.re"
	{ RET(TK_EQV) }
#line 4888 "parser/tokenizer.cpp"
yy529:
	yych = *++cur;
	if (yych == 'E') goto yy678;
	if (yych == 'e') goto yy678;
	goto yy93;
yy530:
	yych = *++cur;
	if (yych == '.') goto yy679;
	goto yy93;
yy531:
	++cur;
#line 590 "parser/tokenizer.re"
	{ RET(TK_NOT) }
#line 4902 "parser/tokenizer.cpp"
yy532:
	yych = *++cur;
	if (yych == '.') goto yy680;
	goto yy93;
yy533:
	++cur;
#line 593 "parser/tokenizer.re"
	{ RET(TK_XOR) }
#line 4911 "parser/tokenizer.cpp"
yy534:
	yych = *++cur;
	if (yych == 'A') goto yy682;
	if (yych == 'a') goto yy682;
	goto yy37;
yy535:
	yych = *++cur;
	if (yych == 'A') goto yy683;
	if (yych == 'a') goto yy683;
	goto yy37;
yy536:
	yych = *++cur;
	if (yych == 'N') goto yy684;
	if (yych == 'n') goto yy684;
	goto yy37;
yy537:
	yych = *++cur;
	if (yych == 'I') goto yy686;
	if (yych == 'i') goto yy686;
	goto yy37;
yy538:
	yych = *++cur;
	if (yych == 'H') goto yy687;
	if (yych == 'h') goto yy687;
	goto yy37;
yy539:
	yych = *++cur;
	if (yych == 'P') goto yy688;
	if (yych == 'p') goto yy688;
	goto yy37;
yy540:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 279 "parser/tokenizer.re"
	{ KW(BLOCK) }
#line 4950 "parser/tokenizer.cpp"
yy541:
	yych = *++cur;
	if (yych == 'E') goto yy689;
	if (yych == 'e') goto yy689;
	goto yy37;
yy542:
	yych = *++cur;
	if (yych == 'C') goto yy691;
	if (yych == 'c') goto yy691;
	goto yy37;
yy543:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 285 "parser/tokenizer.re"
	{ KW(CLASS) }
#line 4969 "parser/tokenizer.cpp"
yy544:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 286 "parser/tokenizer.re"
	{ KW(CLOSE) }
#line 4978 "parser/tokenizer.cpp"
yy545:
	yych = *++cur;
	if (yych == 'E') goto yy692;
	if (yych == 'e') goto yy692;
	goto yy37;
yy546:
	yych = *++cur;
	if (yych == 'N') goto yy693;
	if (yych == 'n') goto yy693;
	goto yy37;
yy547:
	yych = *++cur;
	if (yych == 'E') goto yy694;
	if (yych == 'e') goto yy694;
	goto yy37;
yy548:
	yych = *++cur;
	if (yych == 'R') goto yy695;
	if (yych == 'r') goto yy695;
	goto yy37;
yy549:
	yych = *++cur;
	if (yych == 'I') goto yy696;
	if (yych == 'i') goto yy696;
	goto yy37;
yy550:
	yych = *++cur;
	if (yych <= 'N') {
		if (yych == 'G') goto yy697;
		if (yych <= 'M') goto yy37;
		goto yy698;
	} else {
		if (yych <= 'g') {
			if (yych <= 'f') goto yy37;
			goto yy697;
		} else {
			if (yych == 'n') goto yy698;
			goto yy37;
		}
	}
yy551:
	yych = *++cur;
	if (yych == 'C') goto yy699;
	if (yych == 'c') goto yy699;
	goto yy37;
yy552:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 295 "parser/tokenizer.re"
	{ KW(CYCLE) }
#line 5032 "parser/tokenizer.cpp"
yy553:
	yych = *++cur;
	if (yych == 'O') goto yy700;
	if (yych == 'o') goto yy700;
	goto yy37;
yy554:
	yych = *++cur;
	if (yych == 'L') goto yy701;
	if (yych == 'l') goto yy701;
	goto yy37;
yy555:
	yych = *++cur;
	if (yych == 'R') goto yy702;
	if (yych == 'r') goto yy702;
	goto yy37;
yy556:
	yych = *++cur;
	if (yych == 'S') goto yy703;
	if (yych == 's') goto yy703;
	goto yy37;
yy557:
	yych = *++cur;
	if (yych == 'E') goto yy704;
	if (yych == 'e') goto yy704;
	goto yy37;
yy558:
	yych = *++cur;
	if (yych == 'L') goto yy706;
	if (yych == 'l') goto yy706;
	goto yy37;
yy559:
	yych = *++cur;
	if (yych == 'N') goto yy707;
	if (yych == 'n') goto yy707;
	goto yy37;
yy560:
	yych = *++cur;
	if (yych == 'F') goto yy708;
	if (yych == 'f') goto yy708;
	goto yy37;
yy561:
	yych = *++cur;
	if (yych == 'H') goto yy709;
	if (yych == 'h') goto yy709;
	goto yy37;
yy562:
	yych = *++cur;
	if (yych == 'S') goto yy710;
	if (yych == 's') goto yy710;
	goto yy61;
yy563:
	yych = *++cur;
	if (yych == 'L') goto yy711;
	if (yych == 'l') goto yy711;
	goto yy61;
yy564:
	yych = *++cur;
	if (yych == 'R') goto yy712;
	if (yych == 'r') goto yy712;
	goto yy61;
yy565:
	yych = *++cur;
	if (yych == 'O') goto yy713;
	if (yych == 'o') goto yy713;
	goto yy61;
yy566:
	yych = *++cur;
	if (yych == 'N') goto yy714;
	if (yych == 'n') goto yy714;
	goto yy61;
yy567:
	yych = *++cur;
	if (yych <= 'U') {
		if (yych == 'O') goto yy715;
		if (yych <= 'T') goto yy61;
		goto yy716;
	} else {
		if (yych <= 'o') {
			if (yych <= 'n') goto yy61;
			goto yy715;
		} else {
			if (yych == 'u') goto yy716;
			goto yy61;
		}
	}
yy568:
	yych = *++cur;
	if (yych <= 'N') {
		if (yych == 'F') goto yy717;
		if (yych <= 'M') goto yy61;
		goto yy718;
	} else {
		if (yych <= 'f') {
			if (yych <= 'e') goto yy61;
			goto yy717;
		} else {
			if (yych == 'n') goto yy718;
			goto yy61;
		}
	}
yy569:
	yych = *++cur;
	if (yych == 'O') goto yy719;
	if (yych == 'o') goto yy719;
	goto yy61;
yy570:
	yych = *++cur;
	if (yych == 'R') goto yy720;
	if (yych == 'r') goto yy720;
	goto yy61;
yy571:
	yych = *++cur;
	if (yych <= 'U') {
		if (yych == 'E') goto yy721;
		if (yych <= 'T') goto yy61;
		goto yy722;
	} else {
		if (yych <= 'e') {
			if (yych <= 'd') goto yy61;
			goto yy721;
		} else {
			if (yych == 'u') goto yy722;
			goto yy61;
		}
	}
yy572:
	yych = *++cur;
	if (yych <= 'Y') {
		if (yych == 'E') goto yy723;
		if (yych <= 'X') goto yy61;
		goto yy724;
	} else {
		if (yych <= 'e') {
			if (yych <= 'd') goto yy61;
			goto yy723;
		} else {
			if (yych == 'y') goto yy724;
			goto yy61;
		}
	}
yy573:
	yych = *++cur;
	if (yych == 'H') goto yy725;
	if (yych == 'h') goto yy725;
	goto yy61;
yy574:
	yych = *++cur;
	if (yych <= 'U') {
		if (yych <= 'N') {
			if (yych == 'I') goto yy726;
			goto yy61;
		} else {
			if (yych <= 'O') goto yy715;
			if (yych <= 'T') goto yy61;
			goto yy716;
		}
	} else {
		if (yych <= 'n') {
			if (yych == 'i') goto yy726;
			goto yy61;
		} else {
			if (yych <= 'o') goto yy715;
			if (yych == 'u') goto yy716;
			goto yy61;
		}
	}
yy575:
	yych = *++cur;
	if (yych == 'S') goto yy727;
	if (yych == 's') goto yy727;
	goto yy37;
yy576:
	yych = *++cur;
	if (yych == 'O') goto yy728;
	if (yych == 'o') goto yy728;
	goto yy37;
yy577:
	yych = *++cur;
	if (yych == 'I') goto yy729;
	if (yych == 'i') goto yy729;
	goto yy37;
yy578:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 380 "parser/tokenizer.re"
	{
                if (enddo_newline_process) {
                    KW(CONTINUE)
                } else {
                    KW(ENDDO)
                }
            }
#line 5228 "parser/tokenizer.cpp"
yy579:
	yych = *++cur;
	if (yych == 'U') goto yy730;
	if (yych == 'u') goto yy730;
	goto yy37;
yy580:
	yych = *++cur;
	if (yych == 'L') goto yy731;
	if (yych == 'l') goto yy731;
	goto yy37;
yy581:
	yych = *++cur;
	if (yych == 'R') goto yy732;
	if (yych == 'r') goto yy732;
	goto yy37;
yy582:
	yych = *++cur;
	if (yych == 'N') goto yy733;
	if (yych == 'n') goto yy733;
	goto yy37;
yy583:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 365 "parser/tokenizer.re"
	{ KW(ENDIF) }
#line 5257 "parser/tokenizer.cpp"
yy584:
	yych = *++cur;
	if (yych == 'T') goto yy734;
	if (yych == 't') goto yy734;
	goto yy37;
yy585:
	yych = *++cur;
	if (yych == 'D') goto yy735;
	if (yych == 'd') goto yy735;
	goto yy37;
yy586:
	yych = *++cur;
	if (yych == 'O') goto yy736;
	if (yych == 'o') goto yy736;
	goto yy37;
yy587:
	yych = *++cur;
	if (yych == 'L') goto yy737;
	if (yych == 'l') goto yy737;
	goto yy37;
yy588:
	yych = *++cur;
	if (yych == 'B') goto yy738;
	if (yych == 'b') goto yy738;
	goto yy37;
yy589:
	yych = *++cur;
	if (yych == 'A') goto yy739;
	if (yych == 'a') goto yy739;
	goto yy37;
yy590:
	yych = *++cur;
	if (yych == 'P') goto yy740;
	if (yych == 'p') goto yy740;
	goto yy37;
yy591:
	yych = *++cur;
	if (yych == 'E') goto yy741;
	if (yych == 'e') goto yy741;
	goto yy37;
yy592:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 394 "parser/tokenizer.re"
	{ KW(ENTRY) }
#line 5306 "parser/tokenizer.cpp"
yy593:
	yych = *++cur;
	if (yych == 'R') goto yy742;
	if (yych == 'r') goto yy742;
	goto yy37;
yy594:
	yych = *++cur;
	if (yych == 'A') goto yy743;
	if (yych == 'a') goto yy743;
	goto yy37;
yy595:
	yych = *++cur;
	if (yych == 'G') goto yy744;
	if (yych == 'g') goto yy744;
	goto yy37;
yy596:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 399 "parser/tokenizer.re"
	{ KW(ERROR) }
#line 5330 "parser/tokenizer.cpp"
yy597:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 400 "parser/tokenizer.re"
	{ KW(EVENT) }
#line 5339 "parser/tokenizer.cpp"
yy598:
	yych = *++cur;
	if (yych == 'D') goto yy745;
	if (yych == 'd') goto yy745;
	goto yy37;
yy599:
	yych = *++cur;
	if (yych == 'N') goto yy746;
	if (yych == 'n') goto yy746;
	goto yy37;
yy600:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 405 "parser/tokenizer.re"
	{ KW(FINAL) }
#line 5358 "parser/tokenizer.cpp"
yy601:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 406 "parser/tokenizer.re"
	{ KW(FLUSH) }
#line 5367 "parser/tokenizer.cpp"
yy602:
	yych = *++cur;
	if (yych == 'L') goto yy747;
	if (yych == 'l') goto yy747;
	goto yy37;
yy603:
	yych = *++cur;
	if (yych == 'T') goto yy748;
	if (yych == 't') goto yy748;
	goto yy37;
yy604:
	yych = *++cur;
	if (yych == 'E') goto yy750;
	if (yych == 'e') goto yy750;
	goto yy37;
yy605:
	yych = *++cur;
	if (yych == 'I') goto yy751;
	if (yych == 'i') goto yy751;
	goto yy37;
yy606:
	yych = *++cur;
	if (yych == 'I') goto yy752;
	if (yych == 'i') goto yy752;
	goto yy37;
yy607:
	yych = *++cur;
	if (yych == 'S') goto yy753;
	if (yych == 's') goto yy753;
	goto yy37;
yy608:
	yych = *++cur;
	if (yych == 'C') goto yy754;
	if (yych == 'c') goto yy754;
	goto yy37;
yy609:
	yych = *++cur;
	if (yych == 'T') goto yy755;
	if (yych == 't') goto yy755;
	goto yy37;
yy610:
	yych = *++cur;
	if (yych == 'E') goto yy756;
	if (yych == 'e') goto yy756;
	goto yy37;
yy611:
	yych = *++cur;
	if (yych == 'T') goto yy757;
	if (yych == 't') goto yy757;
	goto yy61;
yy612:
	yych = *++cur;
	if (yych == 'D') goto yy758;
	if (yych == 'd') goto yy758;
	goto yy37;
yy613:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 434 "parser/tokenizer.re"
	{ KW(INOUT) }
#line 5431 "parser/tokenizer.cpp"
yy614:
	yych = *++cur;
	if (yych == 'R') goto yy759;
	if (yych == 'r') goto yy759;
	goto yy37;
yy615:
	yych = *++cur;
	if (yych == 'N') goto yy760;
	if (yych == 'n') goto yy760;
	goto yy37;
yy616:
	yych = *++cur;
	if (yych == 'E') goto yy761;
	if (yych == 'e') goto yy761;
	goto yy37;
yy617:
	yych = *++cur;
	if (yych == 'T') goto yy762;
	if (yych == 't') goto yy762;
	goto yy37;
yy618:
	yych = *++cur;
	if (yych == 'F') goto yy763;
	if (yych == 'f') goto yy763;
	goto yy37;
yy619:
	yych = *++cur;
	if (yych == 'N') goto yy764;
	if (yych == 'n') goto yy764;
	goto yy37;
yy620:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy765;
#line 445 "parser/tokenizer.re"
	{ KW(LOCAL) }
#line 5470 "parser/tokenizer.cpp"
yy621:
	yych = *++cur;
	if (yych == 'A') goto yy766;
	if (yych == 'a') goto yy766;
	goto yy37;
yy622:
	yych = *++cur;
	if (yych == 'Y') goto yy767;
	if (yych == 'y') goto yy767;
	goto yy37;
yy623:
	yych = *++cur;
	if (yych == 'E') goto yy768;
	if (yych == 'e') goto yy768;
	goto yy37;
yy624:
	yych = *++cur;
	if (yych == 'I') goto yy769;
	if (yych == 'i') goto yy769;
	goto yy37;
yy625:
	yych = *++cur;
	if (yych == 'N') goto yy770;
	if (yych == 'n') goto yy770;
	goto yy37;
yy626:
	yych = *++cur;
	if (yych == 'N') goto yy771;
	if (yych == 'n') goto yy771;
	goto yy37;
yy627:
	yych = *++cur;
	if (yych == 'V') goto yy772;
	if (yych == 'v') goto yy772;
	goto yy37;
yy628:
	yych = *++cur;
	if (yych == 'E') goto yy773;
	if (yych == 'e') goto yy773;
	goto yy37;
yy629:
	yych = *++cur;
	if (yych == 'S') goto yy774;
	if (yych == 's') goto yy774;
	goto yy37;
yy630:
	yych = *++cur;
	if (yych == 'F') goto yy775;
	if (yych == 'f') goto yy775;
	goto yy37;
yy631:
	yych = *++cur;
	if (yych == 'T') goto yy776;
	if (yych == 't') goto yy776;
	goto yy37;
yy632:
	yych = *++cur;
	if (yych == 'N') goto yy777;
	if (yych == 'n') goto yy777;
	goto yy37;
yy633:
	yych = *++cur;
	if (yych == 'E') goto yy778;
	if (yych == 'e') goto yy778;
	goto yy37;
yy634:
	yych = *++cur;
	if (yych == 'E') goto yy779;
	if (yych == 'e') goto yy779;
	goto yy37;
yy635:
	yych = *++cur;
	if (yych == 'S') goto yy780;
	if (yych == 's') goto yy780;
	goto yy37;
yy636:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 470 "parser/tokenizer.re"
	{ KW(PRINT) }
#line 5554 "parser/tokenizer.cpp"
yy637:
	yych = *++cur;
	if (yych == 'T') goto yy781;
	if (yych == 't') goto yy781;
	goto yy37;
yy638:
	yych = *++cur;
	if (yych == 'D') goto yy782;
	if (yych == 'd') goto yy782;
	goto yy37;
yy639:
	yych = *++cur;
	if (yych == 'A') goto yy783;
	if (yych == 'a') goto yy783;
	goto yy37;
yy640:
	yych = *++cur;
	if (yych == 'C') goto yy784;
	if (yych == 'c') goto yy784;
	goto yy37;
yy641:
	yych = *++cur;
	if (yych == 'C') goto yy785;
	if (yych == 'c') goto yy785;
	goto yy37;
yy642:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 477 "parser/tokenizer.re"
	{ KW(QUIET) }
#line 5588 "parser/tokenizer.cpp"
yy643:
	yych = *++cur;
	if (yych == 'S') goto yy786;
	if (yych == 's') goto yy786;
	goto yy37;
yy644:
	yych = *++cur;
	if (yych == 'E') goto yy787;
	if (yych == 'e') goto yy787;
	goto yy37;
yy645:
	yych = *++cur;
	if (yych == 'R') goto yy788;
	if (yych == 'r') goto yy788;
	goto yy37;
yy646:
	yych = *++cur;
	if (yych == 'T') goto yy789;
	if (yych == 't') goto yy789;
	goto yy37;
yy647:
	yych = *++cur;
	if (yych == 'N') goto yy790;
	if (yych == 'n') goto yy790;
	goto yy37;
yy648:
	yych = *++cur;
	if (yych == 'D') goto yy791;
	if (yych == 'd') goto yy791;
	goto yy37;
yy649:
	yych = *++cur;
	if (yych == 'T') goto yy792;
	if (yych == 't') goto yy792;
	goto yy37;
yy650:
	yych = *++cur;
	if (yych == 'N') goto yy794;
	if (yych == 'n') goto yy794;
	goto yy37;
yy651:
	yych = *++cur;
	if (yych == 'D') goto yy795;
	if (yych == 'd') goto yy795;
	goto yy37;
yy652:
	yych = *++cur;
	if (yych == 'E') goto yy796;
	if (yych == 'e') goto yy796;
	goto yy37;
yy653:
	yych = *++cur;
	if (yych == 'D') goto yy797;
	if (yych == 'd') goto yy797;
	goto yy37;
yy654:
	yych = *++cur;
	if (yych == 'U') goto yy798;
	if (yych == 'u') goto yy798;
	goto yy37;
yy655:
	yych = *++cur;
	if (yych == 'L') goto yy799;
	if (yych == 'l') goto yy799;
	goto yy37;
yy656:
	yych = *++cur;
	if (yych == 'M') goto yy800;
	if (yych == 'm') goto yy800;
	goto yy37;
yy657:
	yych = *++cur;
	if (yych == 'E') goto yy801;
	if (yych == 'e') goto yy801;
	goto yy37;
yy658:
	yych = *++cur;
	if (yych == 'E') goto yy802;
	if (yych == 'e') goto yy802;
	goto yy37;
yy659:
	yych = *++cur;
	if (yych == 'T') goto yy803;
	if (yych == 't') goto yy803;
	goto yy37;
yy660:
	yyaccept = 2;
	yych = *(mar = ++cur);
	if (yych <= '\'') {
		if (yych == '"') goto yy65;
		if (yych <= '&') goto yy37;
		goto yy82;
	} else {
		if (yych <= 'N') {
			if (yych <= 'M') goto yy37;
			goto yy804;
		} else {
			if (yych == 'n') goto yy804;
			goto yy37;
		}
	}
yy661:
	yych = *++cur;
	if (yych == 'A') goto yy805;
	if (yych == 'a') goto yy805;
	goto yy37;
yy662:
	yych = *++cur;
	if (yych == 'M') goto yy806;
	if (yych == 'm') goto yy806;
	goto yy37;
yy663:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 514 "parser/tokenizer.re"
	{ KW(VALUE) }
#line 5708 "parser/tokenizer.cpp"
yy664:
	yych = *++cur;
	if (yych == 'I') goto yy807;
	if (yych == 'i') goto yy807;
	goto yy37;
yy665:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 517 "parser/tokenizer.re"
	{ KW(WHERE) }
#line 5722 "parser/tokenizer.cpp"
yy666:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 518 "parser/tokenizer.re"
	{ KW(WHILE) }
#line 5731 "parser/tokenizer.cpp"
yy667:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 519 "parser/tokenizer.re"
	{ KW(WRITE) }
#line 5740 "parser/tokenizer.cpp"
yy668:
	yych = *++cur;
yy669:
	if (yych <= 0x00) goto yy61;
	if (yych == '\n') goto yy671;
	goto yy668;
yy670:
	yych = *++cur;
	if (yych <= '\r') {
		if (yych <= '\t') {
			if (yych <= 0x00) goto yy61;
			if (yych <= 0x08) goto yy668;
			goto yy670;
		} else {
			if (yych <= '\n') goto yy671;
			if (yych == '\f') goto yy668;
			goto yy670;
		}
	} else {
		if (yych <= 'D') {
			if (yych == ' ') goto yy670;
			goto yy668;
		} else {
			if (yych <= 'E') goto yy808;
			if (yych == 'e') goto yy808;
			goto yy668;
		}
	}
yy671:
	++cur;
	cur -= 1;
#line 663 "parser/tokenizer.re"
	{ TK_TRIVIA(TK_OMP) }
#line 5774 "parser/tokenizer.cpp"
yy672:
	yych = *++cur;
	if (yych == 'e') goto yy809;
	goto yy69;
yy673:
	yych = *++cur;
	if (yych <= 0x00) goto yy61;
	if (yych == '\n') goto yy810;
	goto yy673;
yy674:
	++cur;
#line 694 "parser/tokenizer.re"
	{
                Location loc; token_loc(loc);
                diagnostics.tokenizer_warning_label(
                    "#else ignored", {loc},
                    "help: use the '--cpp' command line option to preprocess it");
                line_num++; cur_line=cur; continue;
            }
#line 5794 "parser/tokenizer.cpp"
yy675:
	yych = *++cur;
	if (yych <= '\v') {
		if (yych <= 0x08) {
			if (yych <= 0x00) goto yy61;
			goto yy68;
		} else {
			if (yych == '\n') goto yy811;
			goto yy675;
		}
	} else {
		if (yych <= '\r') {
			if (yych <= '\f') goto yy68;
			goto yy675;
		} else {
			if (yych == ' ') goto yy675;
			goto yy68;
		}
	}
yy676:
	yych = *++cur;
	if (yych <= '\v') {
		if (yych == '\t') goto yy812;
		if (yych <= '\n') goto yy69;
		goto yy812;
	} else {
		if (yych <= '\r') {
			if (yych <= '\f') goto yy69;
			goto yy812;
		} else {
			if (yych == ' ') goto yy812;
			goto yy69;
		}
	}
yy677:
	yych = *++cur;
	if (yych <= 0x00) goto yy61;
	if (yych == '\n') goto yy813;
	goto yy677;
yy678:
	yych = *++cur;
	if (yych == '.') goto yy814;
	goto yy93;
yy679:
	++cur;
#line 595 "parser/tokenizer.re"
	{ RET(TK_NEQV) }
#line 5842 "parser/tokenizer.cpp"
yy680:
	yyaccept = 11;
	yych = *(mar = ++cur);
	if (yych == '_') goto yy816;
yy681:
#line 599 "parser/tokenizer.re"
	{ RET(TK_TRUE) }
#line 5850 "parser/tokenizer.cpp"
yy682:
	yych = *++cur;
	if (yych == 'C') goto yy817;
	if (yych == 'c') goto yy817;
	goto yy37;
yy683:
	yych = *++cur;
	if (yych == 'T') goto yy818;
	if (yych == 't') goto yy818;
	goto yy37;
yy684:
	yych = *++cur;
	if (yybm[0+yych] & 8) {
		goto yy117;
	}
	if (yych <= 'M') {
		if (yych <= '9') {
			if (yych >= '0') goto yy36;
		} else {
			if (yych <= '@') goto yy685;
			if (yych <= 'L') goto yy36;
			goto yy819;
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'Z') goto yy36;
			if (yych >= 'a') goto yy36;
		} else {
			if (yych <= 'm') goto yy819;
			if (yych <= 'z') goto yy36;
		}
	}
yy685:
#line 273 "parser/tokenizer.re"
	{ KW(ASSIGN) }
#line 5886 "parser/tokenizer.cpp"
yy686:
	yych = *++cur;
	if (yych == 'A') goto yy820;
	if (yych == 'a') goto yy820;
	goto yy37;
yy687:
	yych = *++cur;
	if (yych == 'R') goto yy821;
	if (yych == 'r') goto yy821;
	goto yy37;
yy688:
	yych = *++cur;
	if (yych == 'A') goto yy822;
	if (yych == 'a') goto yy822;
	goto yy37;
yy689:
	yych = *++cur;
	if (yybm[0+yych] & 8) {
		goto yy117;
	}
	if (yych <= 'T') {
		if (yych <= '9') {
			if (yych >= '0') goto yy36;
		} else {
			if (yych <= '@') goto yy690;
			if (yych <= 'S') goto yy36;
			goto yy823;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy36;
			if (yych >= 'a') goto yy36;
		} else {
			if (yych <= 't') goto yy823;
			if (yych <= 'z') goto yy36;
		}
	}
yy690:
#line 282 "parser/tokenizer.re"
	{ KW(CHANGE) }
#line 5927 "parser/tokenizer.cpp"
yy691:
	yych = *++cur;
	if (yych == 'T') goto yy824;
	if (yych == 't') goto yy824;
	goto yy37;
yy692:
	yych = *++cur;
	if (yych == 'N') goto yy825;
	if (yych == 'n') goto yy825;
	goto yy37;
yy693:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 288 "parser/tokenizer.re"
	{ KW(COMMON) }
#line 5946 "parser/tokenizer.cpp"
yy694:
	yych = *++cur;
	if (yych == 'X') goto yy826;
	if (yych == 'x') goto yy826;
	goto yy37;
yy695:
	yych = *++cur;
	if (yych == 'R') goto yy827;
	if (yych == 'r') goto yy827;
	goto yy37;
yy696:
	yych = *++cur;
	if (yych == 'N') goto yy828;
	if (yych == 'n') goto yy828;
	goto yy37;
yy697:
	yych = *++cur;
	if (yych == 'U') goto yy829;
	if (yych == 'u') goto yy829;
	goto yy37;
yy698:
	yych = *++cur;
	if (yych == 'U') goto yy830;
	if (yych == 'u') goto yy830;
	goto yy37;
yy699:
	yych = *++cur;
	if (yych == 'A') goto yy831;
	if (yych == 'a') goto yy831;
	goto yy37;
yy700:
	yych = *++cur;
	if (yych == 'C') goto yy832;
	if (yych == 'c') goto yy832;
	goto yy37;
yy701:
	yych = *++cur;
	if (yych == 'T') goto yy833;
	if (yych == 't') goto yy833;
	goto yy37;
yy702:
	yych = *++cur;
	if (yych == 'E') goto yy834;
	if (yych == 'e') goto yy834;
	goto yy37;
yy703:
	yych = *++cur;
	if (yych == 'I') goto yy835;
	if (yych == 'i') goto yy835;
	goto yy37;
yy704:
	yych = *++cur;
	if (yybm[0+yych] & 8) {
		goto yy117;
	}
	if (yych <= 'P') {
		if (yych <= '@') {
			if (yych <= '/') goto yy705;
			if (yych <= '9') goto yy36;
		} else {
			if (yych == 'C') goto yy836;
			if (yych <= 'O') goto yy36;
			goto yy837;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy36;
			if (yych <= '`') goto yy705;
			if (yych <= 'b') goto yy36;
			goto yy836;
		} else {
			if (yych == 'p') goto yy837;
			if (yych <= 'z') goto yy36;
		}
	}
yy705:
#line 310 "parser/tokenizer.re"
	{ KW(DOUBLE) }
#line 6025 "parser/tokenizer.cpp"
yy706:
	yych = *++cur;
	if (yych == 'E') goto yy838;
	if (yych == 'e') goto yy838;
	goto yy37;
yy707:
	yych = *++cur;
	if (yych == 'T') goto yy839;
	if (yych == 't') goto yy839;
	goto yy37;
yy708:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 315 "parser/tokenizer.re"
	{ KW(ELSEIF) }
#line 6044 "parser/tokenizer.cpp"
yy709:
	yych = *++cur;
	if (yych == 'E') goto yy840;
	if (yych == 'e') goto yy840;
	goto yy37;
yy710:
	yych = *++cur;
	if (yych == 'S') goto yy841;
	if (yych == 's') goto yy841;
	goto yy61;
yy711:
	yych = *++cur;
	if (yych == 'O') goto yy842;
	if (yych == 'o') goto yy842;
	goto yy61;
yy712:
	yych = *++cur;
	if (yych == 'I') goto yy843;
	if (yych == 'i') goto yy843;
	goto yy61;
yy713:
	++cur;
#line 373 "parser/tokenizer.re"
	{
                if (enddo_newline_process) {
                    KW(CONTINUE)
                } else {
                    KW(END_DO)
                }
            }
#line 6075 "parser/tokenizer.cpp"
yy714:
	yych = *++cur;
	if (yych == 'U') goto yy844;
	if (yych == 'u') goto yy844;
	goto yy61;
yy715:
	yych = *++cur;
	if (yych == 'R') goto yy845;
	if (yych == 'r') goto yy845;
	goto yy61;
yy716:
	yych = *++cur;
	if (yych == 'N') goto yy846;
	if (yych == 'n') goto yy846;
	goto yy61;
yy717:
	++cur;
#line 364 "parser/tokenizer.re"
	{ KW(END_IF) }
#line 6095 "parser/tokenizer.cpp"
yy718:
	yych = *++cur;
	if (yych == 'T') goto yy847;
	if (yych == 't') goto yy847;
	goto yy61;
yy719:
	yych = *++cur;
	if (yych == 'D') goto yy848;
	if (yych == 'd') goto yy848;
	goto yy61;
yy720:
	yych = *++cur;
	if (yych == 'O') goto yy849;
	if (yych == 'o') goto yy849;
	goto yy61;
yy721:
	yych = *++cur;
	if (yych == 'L') goto yy850;
	if (yych == 'l') goto yy850;
	goto yy61;
yy722:
	yych = *++cur;
	if (yych == 'B') goto yy851;
	if (yych == 'b') goto yy851;
	goto yy61;
yy723:
	yych = *++cur;
	if (yych == 'A') goto yy852;
	if (yych == 'a') goto yy852;
	goto yy61;
yy724:
	yych = *++cur;
	if (yych == 'P') goto yy853;
	if (yych == 'p') goto yy853;
	goto yy61;
yy725:
	yych = *++cur;
	if (yych == 'E') goto yy854;
	if (yych == 'e') goto yy854;
	goto yy61;
yy726:
	yych = *++cur;
	if (yych == 'L') goto yy855;
	if (yych == 'l') goto yy855;
	goto yy61;
yy727:
	yych = *++cur;
	if (yych == 'O') goto yy856;
	if (yych == 'o') goto yy856;
	goto yy37;
yy728:
	yych = *++cur;
	if (yych == 'C') goto yy857;
	if (yych == 'c') goto yy857;
	goto yy37;
yy729:
	yych = *++cur;
	if (yych == 'T') goto yy858;
	if (yych == 't') goto yy858;
	goto yy37;
yy730:
	yych = *++cur;
	if (yych == 'M') goto yy859;
	if (yych == 'm') goto yy859;
	goto yy37;
yy731:
	yych = *++cur;
	if (yych == 'E') goto yy860;
	if (yych == 'e') goto yy860;
	goto yy37;
yy732:
	yych = *++cur;
	if (yych == 'A') goto yy861;
	if (yych == 'a') goto yy861;
	goto yy37;
yy733:
	yych = *++cur;
	if (yych == 'C') goto yy862;
	if (yych == 'c') goto yy862;
	goto yy37;
yy734:
	yych = *++cur;
	if (yych == 'E') goto yy863;
	if (yych == 'e') goto yy863;
	goto yy37;
yy735:
	yych = *++cur;
	if (yych == 'U') goto yy864;
	if (yych == 'u') goto yy864;
	goto yy37;
yy736:
	yych = *++cur;
	if (yych <= 'G') {
		if (yych == 'C') goto yy865;
		if (yych <= 'F') goto yy37;
		goto yy866;
	} else {
		if (yych <= 'c') {
			if (yych <= 'b') goto yy37;
			goto yy865;
		} else {
			if (yych == 'g') goto yy866;
			goto yy37;
		}
	}
yy737:
	yych = *++cur;
	if (yych == 'E') goto yy867;
	if (yych == 'e') goto yy867;
	goto yy37;
yy738:
	yych = *++cur;
	if (yych <= 'R') {
		if (yych == 'M') goto yy868;
		if (yych <= 'Q') goto yy37;
		goto yy869;
	} else {
		if (yych <= 'm') {
			if (yych <= 'l') goto yy37;
			goto yy868;
		} else {
			if (yych == 'r') goto yy869;
			goto yy37;
		}
	}
yy739:
	yych = *++cur;
	if (yych == 'M') goto yy870;
	if (yych == 'm') goto yy870;
	goto yy37;
yy740:
	yych = *++cur;
	if (yych == 'E') goto yy871;
	if (yych == 'e') goto yy871;
	goto yy37;
yy741:
	yych = *++cur;
	if (yych == 'R') goto yy872;
	if (yych == 'r') goto yy872;
	goto yy37;
yy742:
	yych = *++cur;
	if (yych == 'A') goto yy873;
	if (yych == 'a') goto yy873;
	goto yy37;
yy743:
	yych = *++cur;
	if (yych == 'L') goto yy874;
	if (yych == 'l') goto yy874;
	goto yy37;
yy744:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 398 "parser/tokenizer.re"
	{ KW(ERRMSG) }
#line 6254 "parser/tokenizer.cpp"
yy745:
	yych = *++cur;
	if (yych == 'S') goto yy875;
	if (yych == 's') goto yy875;
	goto yy37;
yy746:
	yych = *++cur;
	if (yych == 'A') goto yy876;
	if (yych == 'a') goto yy876;
	goto yy37;
yy747:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 407 "parser/tokenizer.re"
	{ KW(FORALL) }
#line 6273 "parser/tokenizer.cpp"
yy748:
	yych = *++cur;
	if (yybm[0+yych] & 8) {
		goto yy117;
	}
	if (yych <= 'T') {
		if (yych <= '9') {
			if (yych >= '0') goto yy36;
		} else {
			if (yych <= '@') goto yy749;
			if (yych <= 'S') goto yy36;
			goto yy877;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy36;
			if (yych >= 'a') goto yy36;
		} else {
			if (yych <= 't') goto yy877;
			if (yych <= 'z') goto yy36;
		}
	}
yy749:
#line 408 "parser/tokenizer.re"
	{
                if (last_token == yytokentype::TK_LABEL) {
                    unsigned char *start;
                    lex_format(cur, loc, start);
                    yylval.string.p = (char*) start;
                    yylval.string.n = cur-start-1;
                    RET(TK_FORMAT)
                } else {
                    token(yylval.string);
                    RET(TK_NAME)
                }
            }
#line 6310 "parser/tokenizer.cpp"
yy750:
	yych = *++cur;
	if (yych == 'A') goto yy878;
	if (yych == 'a') goto yy878;
	goto yy37;
yy751:
	yych = *++cur;
	if (yych == 'O') goto yy879;
	if (yych == 'o') goto yy879;
	goto yy37;
yy752:
	yych = *++cur;
	if (yych == 'C') goto yy880;
	if (yych == 'c') goto yy880;
	goto yy37;
yy753:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 428 "parser/tokenizer.re"
	{ KW(IMAGES) }
#line 6334 "parser/tokenizer.cpp"
yy754:
	yych = *++cur;
	if (yych == 'I') goto yy881;
	if (yych == 'i') goto yy881;
	goto yy37;
yy755:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 430 "parser/tokenizer.re"
	{ KW(IMPORT) }
#line 6348 "parser/tokenizer.cpp"
yy756:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 431 "parser/tokenizer.re"
	{ KW(IMPURE) }
#line 6357 "parser/tokenizer.cpp"
yy757:
	++cur;
#line 435 "parser/tokenizer.re"
	{ KW(IN_OUT) }
#line 6362 "parser/tokenizer.cpp"
yy758:
	yych = *++cur;
	if (yych == 'E') goto yy882;
	if (yych == 'e') goto yy882;
	goto yy37;
yy759:
	yych = *++cur;
	if (yych == 'E') goto yy883;
	if (yych == 'e') goto yy883;
	goto yy37;
yy760:
	yych = *++cur;
	if (yych == 'T') goto yy884;
	if (yych == 't') goto yy884;
	goto yy37;
yy761:
	yych = *++cur;
	if (yych == 'R') goto yy885;
	if (yych == 'r') goto yy885;
	goto yy37;
yy762:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 439 "parser/tokenizer.re"
	{ KW(INTENT) }
#line 6391 "parser/tokenizer.cpp"
yy763:
	yych = *++cur;
	if (yych == 'A') goto yy886;
	if (yych == 'a') goto yy886;
	goto yy37;
yy764:
	yych = *++cur;
	if (yych == 'S') goto yy887;
	if (yych == 's') goto yy887;
	goto yy37;
yy765:
	yyaccept = 2;
	yych = *(mar = ++cur);
	if (yych <= '\'') {
		if (yych == '"') goto yy65;
		if (yych <= '&') goto yy37;
		goto yy82;
	} else {
		if (yych <= 'I') {
			if (yych <= 'H') goto yy37;
			goto yy888;
		} else {
			if (yych == 'i') goto yy888;
			goto yy37;
		}
	}
yy766:
	yych = *++cur;
	if (yych == 'L') goto yy889;
	if (yych == 'l') goto yy889;
	goto yy37;
yy767:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 448 "parser/tokenizer.re"
	{ KW(MEMORY) }
#line 6431 "parser/tokenizer.cpp"
yy768:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 449 "parser/tokenizer.re"
	{ KW(MODULE) }
#line 6440 "parser/tokenizer.cpp"
yy769:
	yych = *++cur;
	if (yych == 'S') goto yy890;
	if (yych == 's') goto yy890;
	goto yy37;
yy770:
	yych = *++cur;
	if (yych == 'D') goto yy891;
	if (yych == 'd') goto yy891;
	goto yy37;
yy771:
	yych = *++cur;
	if (yych == 'T') goto yy892;
	if (yych == 't') goto yy892;
	goto yy37;
yy772:
	yych = *++cur;
	if (yych == 'E') goto yy893;
	if (yych == 'e') goto yy893;
	goto yy37;
yy773:
	yych = *++cur;
	if (yych == 'C') goto yy894;
	if (yych == 'c') goto yy894;
	goto yy37;
yy774:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 454 "parser/tokenizer.re"
	{ KW(NOPASS) }
#line 6474 "parser/tokenizer.cpp"
yy775:
	yych = *++cur;
	if (yych == 'Y') goto yy895;
	if (yych == 'y') goto yy895;
	goto yy37;
yy776:
	yych = *++cur;
	if (yych == 'O') goto yy896;
	if (yych == 'o') goto yy896;
	goto yy37;
yy777:
	yych = *++cur;
	if (yych == 'A') goto yy897;
	if (yych == 'a') goto yy897;
	goto yy37;
yy778:
	yych = *++cur;
	if (yych == 'T') goto yy898;
	if (yych == 't') goto yy898;
	goto yy37;
yy779:
	yych = *++cur;
	if (yych == 'R') goto yy899;
	if (yych == 'r') goto yy899;
	goto yy37;
yy780:
	yych = *++cur;
	if (yych == 'I') goto yy900;
	if (yych == 'i') goto yy900;
	goto yy37;
yy781:
	yych = *++cur;
	if (yych == 'E') goto yy901;
	if (yych == 'e') goto yy901;
	goto yy37;
yy782:
	yych = *++cur;
	if (yych == 'U') goto yy902;
	if (yych == 'u') goto yy902;
	goto yy37;
yy783:
	yych = *++cur;
	if (yych == 'M') goto yy903;
	if (yych == 'm') goto yy903;
	goto yy37;
yy784:
	yych = *++cur;
	if (yych == 'T') goto yy904;
	if (yych == 't') goto yy904;
	goto yy37;
yy785:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 475 "parser/tokenizer.re"
	{ KW(PUBLIC) }
#line 6533 "parser/tokenizer.cpp"
yy786:
	yych = *++cur;
	if (yych == 'I') goto yy905;
	if (yych == 'i') goto yy905;
	goto yy37;
yy787:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 482 "parser/tokenizer.re"
	{ KW(REDUCE) }
#line 6547 "parser/tokenizer.cpp"
yy788:
	yych = *++cur;
	if (yych == 'E') goto yy906;
	if (yych == 'e') goto yy906;
	goto yy37;
yy789:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 485 "parser/tokenizer.re"
	{ KW(RESULT) }
#line 6561 "parser/tokenizer.cpp"
yy790:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 486 "parser/tokenizer.re"
	{ KW(RETURN) }
#line 6570 "parser/tokenizer.cpp"
yy791:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 487 "parser/tokenizer.re"
	{ KW(REWIND) }
#line 6579 "parser/tokenizer.cpp"
yy792:
	yych = *++cur;
	if (yybm[0+yych] & 8) {
		goto yy117;
	}
	if (yych <= 'T') {
		if (yych <= 'B') {
			if (yych <= '/') goto yy793;
			if (yych <= '9') goto yy36;
			if (yych >= 'A') goto yy36;
		} else {
			if (yych <= 'Q') {
				if (yych <= 'C') goto yy908;
				goto yy36;
			} else {
				if (yych <= 'R') goto yy909;
				if (yych <= 'S') goto yy36;
				goto yy910;
			}
		}
	} else {
		if (yych <= 'q') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy36;
			} else {
				if (yych == 'c') goto yy908;
				goto yy36;
			}
		} else {
			if (yych <= 's') {
				if (yych <= 'r') goto yy909;
				goto yy36;
			} else {
				if (yych <= 't') goto yy910;
				if (yych <= 'z') goto yy36;
			}
		}
	}
yy793:
#line 489 "parser/tokenizer.re"
	{ KW(SELECT) }
#line 6621 "parser/tokenizer.cpp"
yy794:
	yych = *++cur;
	if (yych == 'C') goto yy911;
	if (yych == 'c') goto yy911;
	goto yy37;
yy795:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 494 "parser/tokenizer.re"
	{ KW(SHARED) }
#line 6635 "parser/tokenizer.cpp"
yy796:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 495 "parser/tokenizer.re"
	{ KW(SOURCE) }
#line 6644 "parser/tokenizer.cpp"
yy797:
	yych = *++cur;
	if (yych == 'U') goto yy912;
	if (yych == 'u') goto yy912;
	goto yy37;
yy798:
	yych = *++cur;
	if (yych == 'T') goto yy913;
	if (yych == 't') goto yy913;
	goto yy37;
yy799:
	yych = *++cur;
	if (yych == 'L') goto yy914;
	if (yych == 'l') goto yy914;
	goto yy37;
yy800:
	yych = *++cur;
	if (yych == 'A') goto yy915;
	if (yych == 'a') goto yy915;
	goto yy37;
yy801:
	yych = *++cur;
	if (yych == 'M') goto yy916;
	if (yych == 'm') goto yy916;
	goto yy37;
yy802:
	yych = *++cur;
	if (yych == 'A') goto yy917;
	if (yych == 'a') goto yy917;
	goto yy37;
yy803:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 505 "parser/tokenizer.re"
	{ KW(TARGET) }
#line 6683 "parser/tokenizer.cpp"
yy804:
	yych = *++cur;
	if (yych == 'U') goto yy918;
	if (yych == 'u') goto yy918;
	goto yy37;
yy805:
	yych = *++cur;
	if (yych == 'T') goto yy919;
	if (yych == 't') goto yy919;
	goto yy37;
yy806:
	yych = *++cur;
	if (yych == 'A') goto yy920;
	if (yych == 'a') goto yy920;
	goto yy37;
yy807:
	yych = *++cur;
	if (yych == 'L') goto yy921;
	if (yych == 'l') goto yy921;
	goto yy37;
yy808:
	yych = *++cur;
	if (yych == 'N') goto yy922;
	if (yych == 'n') goto yy922;
	goto yy669;
yy809:
	yych = *++cur;
	if (yych <= '\v') {
		if (yych == '\t') goto yy923;
		if (yych <= '\n') goto yy69;
		goto yy923;
	} else {
		if (yych <= '\r') {
			if (yych <= '\f') goto yy69;
			goto yy923;
		} else {
			if (yych == ' ') goto yy923;
			goto yy69;
		}
	}
yy810:
	++cur;
#line 687 "parser/tokenizer.re"
	{
                Location loc; token_loc(loc);
                diagnostics.tokenizer_warning_label(
                    "#elif ignored", {loc},
                    "help: use the '--cpp' command line option to preprocess it");
                line_num++; cur_line=cur; continue;
            }
#line 6734 "parser/tokenizer.cpp"
yy811:
	++cur;
#line 701 "parser/tokenizer.re"
	{
                Location loc; token_loc(loc);
                diagnostics.tokenizer_warning_label(
                    "#endif ignored", {loc},
                    "help: use the '--cpp' command line option to preprocess it");
                line_num++; cur_line=cur; continue;
            }
#line 6745 "parser/tokenizer.cpp"
yy812:
	yych = *++cur;
	if (yych <= 0x00) goto yy61;
	if (yych == '\n') goto yy924;
	goto yy812;
yy813:
	++cur;
#line 679 "parser/tokenizer.re"
	{ line_num++; cur_line=cur; continue; }
#line 6755 "parser/tokenizer.cpp"
yy814:
	yyaccept = 12;
	yych = *(mar = ++cur);
	if (yych == '_') goto yy925;
yy815:
#line 600 "parser/tokenizer.re"
	{ RET(TK_FALSE) }
#line 6763 "parser/tokenizer.cpp"
yy816:
	yych = *++cur;
	if (yych <= 'Z') {
		if (yych <= '/') goto yy61;
		if (yych <= '9') goto yy926;
		if (yych <= '@') goto yy61;
		goto yy927;
	} else {
		if (yych <= '_') {
			if (yych <= '^') goto yy61;
			goto yy927;
		} else {
			if (yych <= '`') goto yy61;
			if (yych <= 'z') goto yy927;
			goto yy61;
		}
	}
yy817:
	yych = *++cur;
	if (yych == 'T') goto yy928;
	if (yych == 't') goto yy928;
	goto yy37;
yy818:
	yych = *++cur;
	if (yych <= 'E') {
		if (yych == 'A') goto yy929;
		if (yych <= 'D') goto yy37;
		goto yy930;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy37;
			goto yy929;
		} else {
			if (yych == 'e') goto yy930;
			goto yy37;
		}
	}
yy819:
	yych = *++cur;
	if (yych == 'E') goto yy931;
	if (yych == 'e') goto yy931;
	goto yy37;
yy820:
	yych = *++cur;
	if (yych == 'T') goto yy932;
	if (yych == 't') goto yy932;
	goto yy37;
yy821:
	yych = *++cur;
	if (yych == 'O') goto yy933;
	if (yych == 'o') goto yy933;
	goto yy37;
yy822:
	yych = *++cur;
	if (yych == 'C') goto yy934;
	if (yych == 'c') goto yy934;
	goto yy37;
yy823:
	yych = *++cur;
	if (yych == 'E') goto yy935;
	if (yych == 'e') goto yy935;
	goto yy37;
yy824:
	yych = *++cur;
	if (yych == 'E') goto yy936;
	if (yych == 'e') goto yy936;
	goto yy37;
yy825:
	yych = *++cur;
	if (yych == 'S') goto yy937;
	if (yych == 's') goto yy937;
	goto yy37;
yy826:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 289 "parser/tokenizer.re"
	{ KW(COMPLEX) }
#line 6844 "parser/tokenizer.cpp"
yy827:
	yych = *++cur;
	if (yych == 'E') goto yy938;
	if (yych == 'e') goto yy938;
	goto yy37;
yy828:
	yych = *++cur;
	if (yych == 'S') goto yy939;
	if (yych == 's') goto yy939;
	goto yy37;
yy829:
	yych = *++cur;
	if (yych == 'O') goto yy940;
	if (yych == 'o') goto yy940;
	goto yy37;
yy830:
	yych = *++cur;
	if (yych == 'E') goto yy941;
	if (yych == 'e') goto yy941;
	goto yy37;
yy831:
	yych = *++cur;
	if (yych == 'L') goto yy942;
	if (yych == 'l') goto yy942;
	goto yy37;
yy832:
	yych = *++cur;
	if (yych == 'A') goto yy943;
	if (yych == 'a') goto yy943;
	goto yy37;
yy833:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 298 "parser/tokenizer.re"
	{ KW(DEFAULT) }
#line 6883 "parser/tokenizer.cpp"
yy834:
	yych = *++cur;
	if (yych == 'D') goto yy944;
	if (yych == 'd') goto yy944;
	goto yy37;
yy835:
	yych = *++cur;
	if (yych == 'O') goto yy945;
	if (yych == 'o') goto yy945;
	goto yy37;
yy836:
	yych = *++cur;
	if (yych == 'O') goto yy946;
	if (yych == 'o') goto yy946;
	goto yy37;
yy837:
	yych = *++cur;
	if (yych == 'R') goto yy947;
	if (yych == 'r') goto yy947;
	goto yy37;
yy838:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 309 "parser/tokenizer.re"
	{ KW(DOWHILE) }
#line 6912 "parser/tokenizer.cpp"
yy839:
	yych = *++cur;
	if (yych == 'A') goto yy948;
	if (yych == 'a') goto yy948;
	goto yy37;
yy840:
	yych = *++cur;
	if (yych == 'R') goto yy949;
	if (yych == 'r') goto yy949;
	goto yy37;
yy841:
	yych = *++cur;
	if (yych == 'O') goto yy950;
	if (yych == 'o') goto yy950;
	goto yy61;
yy842:
	yych = *++cur;
	if (yych == 'C') goto yy951;
	if (yych == 'c') goto yy951;
	goto yy61;
yy843:
	yych = *++cur;
	if (yych == 'T') goto yy952;
	if (yych == 't') goto yy952;
	goto yy61;
yy844:
	yych = *++cur;
	if (yych == 'M') goto yy953;
	if (yych == 'm') goto yy953;
	goto yy61;
yy845:
	yych = *++cur;
	if (yych == 'A') goto yy954;
	if (yych == 'a') goto yy954;
	goto yy61;
yy846:
	yych = *++cur;
	if (yych == 'C') goto yy955;
	if (yych == 'c') goto yy955;
	goto yy61;
yy847:
	yych = *++cur;
	if (yych == 'E') goto yy956;
	if (yych == 'e') goto yy956;
	goto yy61;
yy848:
	yych = *++cur;
	if (yych == 'U') goto yy957;
	if (yych == 'u') goto yy957;
	goto yy61;
yy849:
	yych = *++cur;
	if (yych <= 'G') {
		if (yych == 'C') goto yy958;
		if (yych <= 'F') goto yy61;
		goto yy959;
	} else {
		if (yych <= 'c') {
			if (yych <= 'b') goto yy61;
			goto yy958;
		} else {
			if (yych == 'g') goto yy959;
			goto yy61;
		}
	}
yy850:
	yych = *++cur;
	if (yych == 'E') goto yy960;
	if (yych == 'e') goto yy960;
	goto yy61;
yy851:
	yych = *++cur;
	if (yych <= 'R') {
		if (yych == 'M') goto yy961;
		if (yych <= 'Q') goto yy61;
		goto yy962;
	} else {
		if (yych <= 'm') {
			if (yych <= 'l') goto yy61;
			goto yy961;
		} else {
			if (yych == 'r') goto yy962;
			goto yy61;
		}
	}
yy852:
	yych = *++cur;
	if (yych == 'M') goto yy963;
	if (yych == 'm') goto yy963;
	goto yy61;
yy853:
	yych = *++cur;
	if (yych == 'E') goto yy964;
	if (yych == 'e') goto yy964;
	goto yy61;
yy854:
	yych = *++cur;
	if (yych == 'R') goto yy965;
	if (yych == 'r') goto yy965;
	goto yy61;
yy855:
	yych = *++cur;
	if (yych == 'E') goto yy966;
	if (yych == 'e') goto yy966;
	goto yy61;
yy856:
	yych = *++cur;
	if (yych == 'C') goto yy967;
	if (yych == 'c') goto yy967;
	goto yy37;
yy857:
	yych = *++cur;
	if (yych == 'K') goto yy968;
	if (yych == 'k') goto yy968;
	goto yy37;
yy858:
	yych = *++cur;
	if (yych == 'I') goto yy970;
	if (yych == 'i') goto yy970;
	goto yy37;
yy859:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 347 "parser/tokenizer.re"
	{ KW(ENDENUM) }
#line 7041 "parser/tokenizer.cpp"
yy860:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 392 "parser/tokenizer.re"
	{ KW(ENDFILE) }
#line 7050 "parser/tokenizer.cpp"
yy861:
	yych = *++cur;
	if (yych == 'L') goto yy971;
	if (yych == 'l') goto yy971;
	goto yy37;
yy862:
	yych = *++cur;
	if (yych == 'T') goto yy972;
	if (yych == 't') goto yy972;
	goto yy37;
yy863:
	yych = *++cur;
	if (yych == 'R') goto yy973;
	if (yych == 'r') goto yy973;
	goto yy37;
yy864:
	yych = *++cur;
	if (yych == 'L') goto yy974;
	if (yych == 'l') goto yy974;
	goto yy37;
yy865:
	yych = *++cur;
	if (yych == 'E') goto yy975;
	if (yych == 'e') goto yy975;
	goto yy37;
yy866:
	yych = *++cur;
	if (yych == 'R') goto yy976;
	if (yych == 'r') goto yy976;
	goto yy37;
yy867:
	yych = *++cur;
	if (yych == 'C') goto yy977;
	if (yych == 'c') goto yy977;
	goto yy37;
yy868:
	yych = *++cur;
	if (yych == 'O') goto yy978;
	if (yych == 'o') goto yy978;
	goto yy37;
yy869:
	yych = *++cur;
	if (yych == 'O') goto yy979;
	if (yych == 'o') goto yy979;
	goto yy37;
yy870:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 359 "parser/tokenizer.re"
	{ KW(ENDTEAM) }
#line 7104 "parser/tokenizer.cpp"
yy871:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 371 "parser/tokenizer.re"
	{ KW(ENDTYPE) }
#line 7113 "parser/tokenizer.cpp"
yy872:
	yych = *++cur;
	if (yych == 'E') goto yy980;
	if (yych == 'e') goto yy980;
	goto yy37;
yy873:
	yych = *++cur;
	if (yych == 'T') goto yy981;
	if (yych == 't') goto yy981;
	goto yy37;
yy874:
	yych = *++cur;
	if (yych == 'E') goto yy982;
	if (yych == 'e') goto yy982;
	goto yy37;
yy875:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 402 "parser/tokenizer.re"
	{ KW(EXTENDS) }
#line 7137 "parser/tokenizer.cpp"
yy876:
	yych = *++cur;
	if (yych == 'L') goto yy983;
	if (yych == 'l') goto yy983;
	goto yy37;
yy877:
	yych = *++cur;
	if (yych == 'E') goto yy984;
	if (yych == 'e') goto yy984;
	goto yy37;
yy878:
	yych = *++cur;
	if (yych == 'M') goto yy985;
	if (yych == 'm') goto yy985;
	goto yy37;
yy879:
	yych = *++cur;
	if (yych == 'N') goto yy986;
	if (yych == 'n') goto yy986;
	goto yy37;
yy880:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 424 "parser/tokenizer.re"
	{ KW(GENERIC) }
#line 7166 "parser/tokenizer.cpp"
yy881:
	yych = *++cur;
	if (yych == 'T') goto yy987;
	if (yych == 't') goto yy987;
	goto yy37;
yy882:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 433 "parser/tokenizer.re"
	{ KW(INCLUDE) }
#line 7180 "parser/tokenizer.cpp"
yy883:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 436 "parser/tokenizer.re"
	{ KW(INQUIRE) }
#line 7189 "parser/tokenizer.cpp"
yy884:
	yych = *++cur;
	if (yych == 'I') goto yy988;
	if (yych == 'i') goto yy988;
	goto yy37;
yy885:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 438 "parser/tokenizer.re"
	{ KW(INTEGER) }
#line 7203 "parser/tokenizer.cpp"
yy886:
	yych = *++cur;
	if (yych == 'C') goto yy989;
	if (yych == 'c') goto yy989;
	goto yy37;
yy887:
	yych = *++cur;
	if (yych == 'I') goto yy990;
	if (yych == 'i') goto yy990;
	goto yy37;
yy888:
	yych = *++cur;
	if (yych == 'N') goto yy991;
	if (yych == 'n') goto yy991;
	goto yy37;
yy889:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 447 "parser/tokenizer.re"
	{ KW(LOGICAL) }
#line 7227 "parser/tokenizer.cpp"
yy890:
	yych = *++cur;
	if (yych == 'T') goto yy992;
	if (yych == 't') goto yy992;
	goto yy37;
yy891:
	yych = *++cur;
	if (yych == 'E') goto yy993;
	if (yych == 'e') goto yy993;
	goto yy37;
yy892:
	yych = *++cur;
	if (yych == 'R') goto yy994;
	if (yych == 'r') goto yy994;
	goto yy37;
yy893:
	yych = *++cur;
	if (yych == 'R') goto yy995;
	if (yych == 'r') goto yy995;
	goto yy37;
yy894:
	yych = *++cur;
	if (yych == 'U') goto yy996;
	if (yych == 'u') goto yy996;
	goto yy37;
yy895:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 459 "parser/tokenizer.re"
	{ KW(NULLIFY) }
#line 7261 "parser/tokenizer.cpp"
yy896:
	yych = *++cur;
	if (yych == 'R') goto yy997;
	if (yych == 'r') goto yy997;
	goto yy37;
yy897:
	yych = *++cur;
	if (yych == 'L') goto yy998;
	if (yych == 'l') goto yy998;
	goto yy37;
yy898:
	yych = *++cur;
	if (yych == 'E') goto yy999;
	if (yych == 'e') goto yy999;
	goto yy37;
yy899:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 467 "parser/tokenizer.re"
	{ KW(POINTER) }
#line 7285 "parser/tokenizer.cpp"
yy900:
	yych = *++cur;
	if (yych == 'O') goto yy1000;
	if (yych == 'o') goto yy1000;
	goto yy37;
yy901:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 471 "parser/tokenizer.re"
	{ KW(PRIVATE) }
#line 7299 "parser/tokenizer.cpp"
yy902:
	yych = *++cur;
	if (yych == 'R') goto yy1001;
	if (yych == 'r') goto yy1001;
	goto yy37;
yy903:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 473 "parser/tokenizer.re"
	{ KW(PROGRAM) }
#line 7313 "parser/tokenizer.cpp"
yy904:
	yych = *++cur;
	if (yych == 'E') goto yy1002;
	if (yych == 'e') goto yy1002;
	goto yy37;
yy905:
	yych = *++cur;
	if (yych == 'V') goto yy1003;
	if (yych == 'v') goto yy1003;
	goto yy37;
yy906:
	yych = *++cur;
	if (yybm[0+yych] & 8) {
		goto yy117;
	}
	if (yych <= 'M') {
		if (yych <= '9') {
			if (yych >= '0') goto yy36;
		} else {
			if (yych <= '@') goto yy907;
			if (yych <= 'L') goto yy36;
			goto yy1004;
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'Z') goto yy36;
			if (yych >= 'a') goto yy36;
		} else {
			if (yych <= 'm') goto yy1004;
			if (yych <= 'z') goto yy36;
		}
	}
yy907:
#line 484 "parser/tokenizer.re"
	{ KW(REQUIRE) }
#line 7349 "parser/tokenizer.cpp"
yy908:
	yych = *++cur;
	if (yych == 'A') goto yy1005;
	if (yych == 'a') goto yy1005;
	goto yy37;
yy909:
	yych = *++cur;
	if (yych == 'A') goto yy1006;
	if (yych == 'a') goto yy1006;
	goto yy37;
yy910:
	yych = *++cur;
	if (yych == 'Y') goto yy1007;
	if (yych == 'y') goto yy1007;
	goto yy37;
yy911:
	yych = *++cur;
	if (yych == 'E') goto yy1008;
	if (yych == 'e') goto yy1008;
	goto yy37;
yy912:
	yych = *++cur;
	if (yych == 'L') goto yy1009;
	if (yych == 'l') goto yy1009;
	goto yy37;
yy913:
	yych = *++cur;
	if (yych == 'I') goto yy1010;
	if (yych == 'i') goto yy1010;
	goto yy37;
yy914:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 501 "parser/tokenizer.re"
	{ KW(SYNC_ALL) }
#line 7388 "parser/tokenizer.cpp"
yy915:
	yych = *++cur;
	if (yych == 'G') goto yy1011;
	if (yych == 'g') goto yy1011;
	goto yy37;
yy916:
	yych = *++cur;
	if (yych == 'O') goto yy1012;
	if (yych == 'o') goto yy1012;
	goto yy37;
yy917:
	yych = *++cur;
	if (yych == 'M') goto yy1013;
	if (yych == 'm') goto yy1013;
	goto yy37;
yy918:
	yych = *++cur;
	if (yych == 'M') goto yy1014;
	if (yych == 'm') goto yy1014;
	goto yy37;
yy919:
	yych = *++cur;
	if (yych == 'E') goto yy1015;
	if (yych == 'e') goto yy1015;
	goto yy37;
yy920:
	yych = *++cur;
	if (yych == 'T') goto yy1016;
	if (yych == 't') goto yy1016;
	goto yy37;
yy921:
	yych = *++cur;
	if (yych == 'E') goto yy1017;
	if (yych == 'e') goto yy1017;
	goto yy37;
yy922:
	yych = *++cur;
	if (yych == 'D') goto yy1018;
	if (yych == 'd') goto yy1018;
	goto yy669;
yy923:
	yych = *++cur;
	if (yych <= 0x00) goto yy61;
	if (yych == '\n') goto yy1019;
	goto yy923;
yy924:
	++cur;
#line 680 "parser/tokenizer.re"
	{
                Location loc; token_loc(loc);
                diagnostics.tokenizer_warning_label(
                    "#ifdef ignored", {loc},
                    "help: use the '--cpp' command line option to preprocess it");
                line_num++; cur_line=cur; continue;
            }
#line 7444 "parser/tokenizer.cpp"
yy925:
	yych = *++cur;
	if (yych <= 'Z') {
		if (yych <= '/') goto yy61;
		if (yych <= '9') goto yy1020;
		if (yych <= '@') goto yy61;
		goto yy1021;
	} else {
		if (yych <= '_') {
			if (yych <= '^') goto yy61;
			goto yy1021;
		} else {
			if (yych <= '`') goto yy61;
			if (yych <= 'z') goto yy1021;
			goto yy61;
		}
	}
yy926:
	yych = *++cur;
	if (yych <= '/') goto yy681;
	if (yych <= '9') goto yy926;
	goto yy681;
yy927:
	yych = *++cur;
	if (yych <= 'Z') {
		if (yych <= '/') goto yy681;
		if (yych <= '9') goto yy927;
		if (yych <= '@') goto yy681;
		goto yy927;
	} else {
		if (yych <= '_') {
			if (yych <= '^') goto yy681;
			goto yy927;
		} else {
			if (yych <= '`') goto yy681;
			if (yych <= 'z') goto yy927;
			goto yy681;
		}
	}
yy928:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 269 "parser/tokenizer.re"
	{ KW(ABSTRACT) }
#line 7492 "parser/tokenizer.cpp"
yy929:
	yych = *++cur;
	if (yych == 'B') goto yy1022;
	if (yych == 'b') goto yy1022;
	goto yy37;
yy930:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 272 "parser/tokenizer.re"
	{ KW(ALLOCATE) }
#line 7506 "parser/tokenizer.cpp"
yy931:
	yych = *++cur;
	if (yych == 'N') goto yy1023;
	if (yych == 'n') goto yy1023;
	goto yy37;
yy932:
	yych = *++cur;
	if (yych == 'E') goto yy1024;
	if (yych == 'e') goto yy1024;
	goto yy37;
yy933:
	yych = *++cur;
	if (yych == 'N') goto yy1025;
	if (yych == 'n') goto yy1025;
	goto yy37;
yy934:
	yych = *++cur;
	if (yych == 'E') goto yy1026;
	if (yych == 'e') goto yy1026;
	goto yy37;
yy935:
	yych = *++cur;
	if (yych == 'A') goto yy1027;
	if (yych == 'a') goto yy1027;
	goto yy37;
yy936:
	yych = *++cur;
	if (yych == 'R') goto yy1028;
	if (yych == 'r') goto yy1028;
	goto yy37;
yy937:
	yych = *++cur;
	if (yych == 'I') goto yy1029;
	if (yych == 'i') goto yy1029;
	goto yy37;
yy938:
	yych = *++cur;
	if (yych == 'N') goto yy1030;
	if (yych == 'n') goto yy1030;
	goto yy37;
yy939:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 291 "parser/tokenizer.re"
	{ KW(CONTAINS) }
#line 7555 "parser/tokenizer.cpp"
yy940:
	yych = *++cur;
	if (yych == 'U') goto yy1031;
	if (yych == 'u') goto yy1031;
	goto yy37;
yy941:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 293 "parser/tokenizer.re"
	{ KW(CONTINUE) }
#line 7569 "parser/tokenizer.cpp"
yy942:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 294 "parser/tokenizer.re"
	{ KW(CRITICAL) }
#line 7578 "parser/tokenizer.cpp"
yy943:
	yych = *++cur;
	if (yych == 'T') goto yy1032;
	if (yych == 't') goto yy1032;
	goto yy37;
yy944:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 299 "parser/tokenizer.re"
	{ KW(DEFERRED) }
#line 7592 "parser/tokenizer.cpp"
yy945:
	yych = *++cur;
	if (yych == 'N') goto yy1033;
	if (yych == 'n') goto yy1033;
	goto yy37;
yy946:
	yych = *++cur;
	if (yych == 'M') goto yy1034;
	if (yych == 'm') goto yy1034;
	goto yy37;
yy947:
	yych = *++cur;
	if (yych == 'E') goto yy1035;
	if (yych == 'e') goto yy1035;
	goto yy37;
yy948:
	yych = *++cur;
	if (yych == 'L') goto yy1036;
	if (yych == 'l') goto yy1036;
	goto yy37;
yy949:
	yych = *++cur;
	if (yych == 'E') goto yy1037;
	if (yych == 'e') goto yy1037;
	goto yy37;
yy950:
	yych = *++cur;
	if (yych == 'C') goto yy1038;
	if (yych == 'c') goto yy1038;
	goto yy61;
yy951:
	yych = *++cur;
	if (yych == 'K') goto yy1039;
	if (yych == 'k') goto yy1039;
	goto yy61;
yy952:
	yych = *++cur;
	if (yych == 'I') goto yy1041;
	if (yych == 'i') goto yy1041;
	goto yy61;
yy953:
	++cur;
#line 346 "parser/tokenizer.re"
	{ KW(END_ENUM) }
#line 7637 "parser/tokenizer.cpp"
yy954:
	yych = *++cur;
	if (yych == 'L') goto yy1042;
	if (yych == 'l') goto yy1042;
	goto yy61;
yy955:
	yych = *++cur;
	if (yych == 'T') goto yy1043;
	if (yych == 't') goto yy1043;
	goto yy61;
yy956:
	yych = *++cur;
	if (yych == 'R') goto yy1044;
	if (yych == 'r') goto yy1044;
	goto yy61;
yy957:
	yych = *++cur;
	if (yych == 'L') goto yy1045;
	if (yych == 'l') goto yy1045;
	goto yy61;
yy958:
	yych = *++cur;
	if (yych == 'E') goto yy1046;
	if (yych == 'e') goto yy1046;
	goto yy61;
yy959:
	yych = *++cur;
	if (yych == 'R') goto yy1047;
	if (yych == 'r') goto yy1047;
	goto yy61;
yy960:
	yych = *++cur;
	if (yych == 'C') goto yy1048;
	if (yych == 'c') goto yy1048;
	goto yy61;
yy961:
	yych = *++cur;
	if (yych == 'O') goto yy1049;
	if (yych == 'o') goto yy1049;
	goto yy61;
yy962:
	yych = *++cur;
	if (yych == 'O') goto yy1050;
	if (yych == 'o') goto yy1050;
	goto yy61;
yy963:
	++cur;
#line 358 "parser/tokenizer.re"
	{ KW(END_TEAM) }
#line 7687 "parser/tokenizer.cpp"
yy964:
	++cur;
#line 370 "parser/tokenizer.re"
	{ KW(END_TYPE) }
#line 7692 "parser/tokenizer.cpp"
yy965:
	yych = *++cur;
	if (yych == 'E') goto yy1051;
	if (yych == 'e') goto yy1051;
	goto yy61;
yy966:
	++cur;
#line 391 "parser/tokenizer.re"
	{ KW(END_FILE) }
#line 7702 "parser/tokenizer.cpp"
yy967:
	yych = *++cur;
	if (yych == 'I') goto yy1052;
	if (yych == 'i') goto yy1052;
	goto yy37;
yy968:
	yyaccept = 13;
	yych = *(mar = ++cur);
	if (yybm[0+yych] & 8) {
		goto yy117;
	}
	if (yych <= '/') {
		if (yych <= '\v') {
			if (yych == '\t') goto yy1053;
			if (yych >= '\v') goto yy1053;
		} else {
			if (yych <= '\r') {
				if (yych >= '\r') goto yy1053;
			} else {
				if (yych == ' ') goto yy1053;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy36;
			} else {
				if (yych == 'D') goto yy1054;
				goto yy36;
			}
		} else {
			if (yych <= 'c') {
				if (yych >= 'a') goto yy36;
			} else {
				if (yych <= 'd') goto yy1054;
				if (yych <= 'z') goto yy36;
			}
		}
	}
yy969:
#line 330 "parser/tokenizer.re"
	{ KW(ENDBLOCK) }
#line 7745 "parser/tokenizer.cpp"
yy970:
	yych = *++cur;
	if (yych == 'C') goto yy1055;
	if (yych == 'c') goto yy1055;
	goto yy37;
yy971:
	yych = *++cur;
	if (yych == 'L') goto yy1056;
	if (yych == 'l') goto yy1056;
	goto yy37;
yy972:
	yych = *++cur;
	if (yych == 'I') goto yy1057;
	if (yych == 'i') goto yy1057;
	goto yy37;
yy973:
	yych = *++cur;
	if (yych == 'F') goto yy1058;
	if (yych == 'f') goto yy1058;
	goto yy37;
yy974:
	yych = *++cur;
	if (yych == 'E') goto yy1059;
	if (yych == 'e') goto yy1059;
	goto yy37;
yy975:
	yych = *++cur;
	if (yych == 'D') goto yy1060;
	if (yych == 'd') goto yy1060;
	goto yy37;
yy976:
	yych = *++cur;
	if (yych == 'A') goto yy1061;
	if (yych == 'a') goto yy1061;
	goto yy37;
yy977:
	yych = *++cur;
	if (yych == 'T') goto yy1062;
	if (yych == 't') goto yy1062;
	goto yy37;
yy978:
	yych = *++cur;
	if (yych == 'D') goto yy1063;
	if (yych == 'd') goto yy1063;
	goto yy37;
yy979:
	yych = *++cur;
	if (yych == 'U') goto yy1064;
	if (yych == 'u') goto yy1064;
	goto yy37;
yy980:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 389 "parser/tokenizer.re"
	{ KW(ENDWHERE) }
#line 7804 "parser/tokenizer.cpp"
yy981:
	yych = *++cur;
	if (yych == 'O') goto yy1065;
	if (yych == 'o') goto yy1065;
	goto yy37;
yy982:
	yych = *++cur;
	if (yych == 'N') goto yy1066;
	if (yych == 'n') goto yy1066;
	goto yy37;
yy983:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 403 "parser/tokenizer.re"
	{ KW(EXTERNAL) }
#line 7823 "parser/tokenizer.cpp"
yy984:
	yych = *++cur;
	if (yych == 'D') goto yy1067;
	if (yych == 'd') goto yy1067;
	goto yy37;
yy985:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 422 "parser/tokenizer.re"
	{ KW(FORM_TEAM) }
#line 7837 "parser/tokenizer.cpp"
yy986:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 423 "parser/tokenizer.re"
	{ KW(FUNCTION) }
#line 7846 "parser/tokenizer.cpp"
yy987:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 429 "parser/tokenizer.re"
	{ KW(IMPLICIT) }
#line 7855 "parser/tokenizer.cpp"
yy988:
	yych = *++cur;
	if (yych == 'A') goto yy1068;
	if (yych == 'a') goto yy1068;
	goto yy37;
yy989:
	yych = *++cur;
	if (yych == 'E') goto yy1069;
	if (yych == 'e') goto yy1069;
	goto yy37;
yy990:
	yych = *++cur;
	if (yych == 'C') goto yy1070;
	if (yych == 'c') goto yy1070;
	goto yy37;
yy991:
	yych = *++cur;
	if (yych == 'I') goto yy1071;
	if (yych == 'i') goto yy1071;
	goto yy37;
yy992:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 452 "parser/tokenizer.re"
	{ KW(NAMELIST) }
#line 7884 "parser/tokenizer.cpp"
yy993:
	yych = *++cur;
	if (yych == 'X') goto yy1072;
	if (yych == 'x') goto yy1072;
	goto yy37;
yy994:
	yych = *++cur;
	if (yych == 'I') goto yy1073;
	if (yych == 'i') goto yy1073;
	goto yy37;
yy995:
	yych = *++cur;
	if (yych == 'R') goto yy1074;
	if (yych == 'r') goto yy1074;
	goto yy37;
yy996:
	yych = *++cur;
	if (yych == 'R') goto yy1075;
	if (yych == 'r') goto yy1075;
	goto yy37;
yy997:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 462 "parser/tokenizer.re"
	{ KW(OPERATOR) }
#line 7913 "parser/tokenizer.cpp"
yy998:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 463 "parser/tokenizer.re"
	{ KW(OPTIONAL) }
#line 7922 "parser/tokenizer.cpp"
yy999:
	yych = *++cur;
	if (yych == 'R') goto yy1076;
	if (yych == 'r') goto yy1076;
	goto yy37;
yy1000:
	yych = *++cur;
	if (yych == 'N') goto yy1077;
	if (yych == 'n') goto yy1077;
	goto yy37;
yy1001:
	yych = *++cur;
	if (yych == 'E') goto yy1078;
	if (yych == 'e') goto yy1078;
	goto yy37;
yy1002:
	yych = *++cur;
	if (yych == 'D') goto yy1079;
	if (yych == 'd') goto yy1079;
	goto yy37;
yy1003:
	yych = *++cur;
	if (yych == 'E') goto yy1080;
	if (yych == 'e') goto yy1080;
	goto yy37;
yy1004:
	yych = *++cur;
	if (yych == 'E') goto yy1081;
	if (yych == 'e') goto yy1081;
	goto yy37;
yy1005:
	yych = *++cur;
	if (yych == 'S') goto yy1082;
	if (yych == 's') goto yy1082;
	goto yy37;
yy1006:
	yych = *++cur;
	if (yych == 'N') goto yy1083;
	if (yych == 'n') goto yy1083;
	goto yy37;
yy1007:
	yych = *++cur;
	if (yych == 'P') goto yy1084;
	if (yych == 'p') goto yy1084;
	goto yy37;
yy1008:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 493 "parser/tokenizer.re"
	{ KW(SEQUENCE) }
#line 7976 "parser/tokenizer.cpp"
yy1009:
	yych = *++cur;
	if (yych == 'E') goto yy1085;
	if (yych == 'e') goto yy1085;
	goto yy37;
yy1010:
	yych = *++cur;
	if (yych == 'N') goto yy1086;
	if (yych == 'n') goto yy1086;
	goto yy37;
yy1011:
	yych = *++cur;
	if (yych == 'E') goto yy1087;
	if (yych == 'e') goto yy1087;
	goto yy37;
yy1012:
	yych = *++cur;
	if (yych == 'R') goto yy1088;
	if (yych == 'r') goto yy1088;
	goto yy37;
yy1013:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 504 "parser/tokenizer.re"
	{ KW(SYNC_TEAM) }
#line 8005 "parser/tokenizer.cpp"
yy1014:
	yych = *++cur;
	if (yych == 'B') goto yy1089;
	if (yych == 'b') goto yy1089;
	goto yy37;
yy1015:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 508 "parser/tokenizer.re"
	{ KW(TEMPLATE) }
#line 8019 "parser/tokenizer.cpp"
yy1016:
	yych = *++cur;
	if (yych == 'T') goto yy1090;
	if (yych == 't') goto yy1090;
	goto yy37;
yy1017:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 515 "parser/tokenizer.re"
	{ KW(VOLATILE) }
#line 8033 "parser/tokenizer.cpp"
yy1018:
	yych = *++cur;
	if (yych <= 0x00) goto yy61;
	if (yych == '\n') goto yy1091;
	goto yy1018;
yy1019:
	++cur;
#line 708 "parser/tokenizer.re"
	{
                Location loc; token_loc(loc);
                diagnostics.tokenizer_warning_label(
                    "#define ignored", {loc},
                    "help: use the '--cpp' command line option to preprocess it");
                line_num++; cur_line=cur; continue;
            }
#line 8049 "parser/tokenizer.cpp"
yy1020:
	yych = *++cur;
	if (yych <= '/') goto yy815;
	if (yych <= '9') goto yy1020;
	goto yy815;
yy1021:
	yych = *++cur;
	if (yych <= 'Z') {
		if (yych <= '/') goto yy815;
		if (yych <= '9') goto yy1021;
		if (yych <= '@') goto yy815;
		goto yy1021;
	} else {
		if (yych <= '_') {
			if (yych <= '^') goto yy815;
			goto yy1021;
		} else {
			if (yych <= '`') goto yy815;
			if (yych <= 'z') goto yy1021;
			goto yy815;
		}
	}
yy1022:
	yych = *++cur;
	if (yych == 'L') goto yy1092;
	if (yych == 'l') goto yy1092;
	goto yy37;
yy1023:
	yych = *++cur;
	if (yych == 'T') goto yy1093;
	if (yych == 't') goto yy1093;
	goto yy37;
yy1024:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 275 "parser/tokenizer.re"
	{ KW(ASSOCIATE) }
#line 8090 "parser/tokenizer.cpp"
yy1025:
	yych = *++cur;
	if (yych == 'O') goto yy1094;
	if (yych == 'o') goto yy1094;
	goto yy37;
yy1026:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 277 "parser/tokenizer.re"
	{ KW(BACKSPACE) }
#line 8104 "parser/tokenizer.cpp"
yy1027:
	yych = *++cur;
	if (yych == 'M') goto yy1095;
	if (yych == 'm') goto yy1095;
	goto yy37;
yy1028:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 284 "parser/tokenizer.re"
	{ KW(CHARACTER) }
#line 8118 "parser/tokenizer.cpp"
yy1029:
	yych = *++cur;
	if (yych == 'O') goto yy1096;
	if (yych == 'o') goto yy1096;
	goto yy37;
yy1030:
	yych = *++cur;
	if (yych == 'T') goto yy1097;
	if (yych == 't') goto yy1097;
	goto yy37;
yy1031:
	yych = *++cur;
	if (yych == 'S') goto yy1098;
	if (yych == 's') goto yy1098;
	goto yy37;
yy1032:
	yych = *++cur;
	if (yych == 'E') goto yy1099;
	if (yych == 'e') goto yy1099;
	goto yy37;
yy1033:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 300 "parser/tokenizer.re"
	{ KW(DIMENSION) }
#line 8147 "parser/tokenizer.cpp"
yy1034:
	yych = *++cur;
	if (yych == 'P') goto yy1100;
	if (yych == 'p') goto yy1100;
	goto yy37;
yy1035:
	yych = *++cur;
	if (yych == 'C') goto yy1101;
	if (yych == 'c') goto yy1101;
	goto yy37;
yy1036:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 313 "parser/tokenizer.re"
	{ KW(ELEMENTAL) }
#line 8166 "parser/tokenizer.cpp"
yy1037:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 316 "parser/tokenizer.re"
	{ KW(ELSEWHERE) }
#line 8175 "parser/tokenizer.cpp"
yy1038:
	yych = *++cur;
	if (yych == 'I') goto yy1102;
	if (yych == 'i') goto yy1102;
	goto yy61;
yy1039:
	yyaccept = 14;
	yych = *(mar = ++cur);
	if (yych <= '\r') {
		if (yych <= '\n') {
			if (yych == '\t') goto yy1103;
		} else {
			if (yych != '\f') goto yy1103;
		}
	} else {
		if (yych <= 'C') {
			if (yych == ' ') goto yy1103;
		} else {
			if (yych <= 'D') goto yy1104;
			if (yych == 'd') goto yy1104;
		}
	}
yy1040:
#line 329 "parser/tokenizer.re"
	{ KW(END_BLOCK) }
#line 8201 "parser/tokenizer.cpp"
yy1041:
	yych = *++cur;
	if (yych == 'C') goto yy1105;
	if (yych == 'c') goto yy1105;
	goto yy61;
yy1042:
	yych = *++cur;
	if (yych == 'L') goto yy1106;
	if (yych == 'l') goto yy1106;
	goto yy61;
yy1043:
	yych = *++cur;
	if (yych == 'I') goto yy1107;
	if (yych == 'i') goto yy1107;
	goto yy61;
yy1044:
	yych = *++cur;
	if (yych == 'F') goto yy1108;
	if (yych == 'f') goto yy1108;
	goto yy61;
yy1045:
	yych = *++cur;
	if (yych == 'E') goto yy1109;
	if (yych == 'e') goto yy1109;
	goto yy61;
yy1046:
	yych = *++cur;
	if (yych == 'D') goto yy1110;
	if (yych == 'd') goto yy1110;
	goto yy61;
yy1047:
	yych = *++cur;
	if (yych == 'A') goto yy1111;
	if (yych == 'a') goto yy1111;
	goto yy61;
yy1048:
	yych = *++cur;
	if (yych == 'T') goto yy1112;
	if (yych == 't') goto yy1112;
	goto yy61;
yy1049:
	yych = *++cur;
	if (yych == 'D') goto yy1113;
	if (yych == 'd') goto yy1113;
	goto yy61;
yy1050:
	yych = *++cur;
	if (yych == 'U') goto yy1114;
	if (yych == 'u') goto yy1114;
	goto yy61;
yy1051:
	++cur;
#line 388 "parser/tokenizer.re"
	{ KW(END_WHERE) }
#line 8256 "parser/tokenizer.cpp"
yy1052:
	yych = *++cur;
	if (yych == 'A') goto yy1115;
	if (yych == 'a') goto yy1115;
	goto yy37;
yy1053:
	yych = *++cur;
	if (yych <= '\r') {
		if (yych <= '\n') {
			if (yych == '\t') goto yy1053;
			goto yy61;
		} else {
			if (yych == '\f') goto yy61;
			goto yy1053;
		}
	} else {
		if (yych <= 'C') {
			if (yych == ' ') goto yy1053;
			goto yy61;
		} else {
			if (yych <= 'D') goto yy1116;
			if (yych == 'd') goto yy1116;
			goto yy61;
		}
	}
yy1054:
	yych = *++cur;
	if (yych == 'A') goto yy1117;
	if (yych == 'a') goto yy1117;
	goto yy37;
yy1055:
	yych = *++cur;
	if (yych == 'A') goto yy1118;
	if (yych == 'a') goto yy1118;
	goto yy37;
yy1056:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 362 "parser/tokenizer.re"
	{ KW(ENDFORALL) }
#line 8300 "parser/tokenizer.cpp"
yy1057:
	yych = *++cur;
	if (yych == 'O') goto yy1119;
	if (yych == 'o') goto yy1119;
	goto yy37;
yy1058:
	yych = *++cur;
	if (yych == 'A') goto yy1120;
	if (yych == 'a') goto yy1120;
	goto yy37;
yy1059:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 324 "parser/tokenizer.re"
	{ KW(ENDMODULE) }
#line 8319 "parser/tokenizer.cpp"
yy1060:
	yych = *++cur;
	if (yych == 'U') goto yy1121;
	if (yych == 'u') goto yy1121;
	goto yy37;
yy1061:
	yych = *++cur;
	if (yych == 'M') goto yy1122;
	if (yych == 'm') goto yy1122;
	goto yy37;
yy1062:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 350 "parser/tokenizer.re"
	{ KW(ENDSELECT) }
#line 8338 "parser/tokenizer.cpp"
yy1063:
	yych = *++cur;
	if (yych == 'U') goto yy1123;
	if (yych == 'u') goto yy1123;
	goto yy37;
yy1064:
	yych = *++cur;
	if (yych == 'T') goto yy1124;
	if (yych == 't') goto yy1124;
	goto yy37;
yy1065:
	yych = *++cur;
	if (yych == 'R') goto yy1125;
	if (yych == 'r') goto yy1125;
	goto yy37;
yy1066:
	yych = *++cur;
	if (yych == 'C') goto yy1126;
	if (yych == 'c') goto yy1126;
	goto yy37;
yy1067:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 420 "parser/tokenizer.re"
	{ KW(FORMATTED) }
#line 8367 "parser/tokenizer.cpp"
yy1068:
	yych = *++cur;
	if (yych == 'T') goto yy1127;
	if (yych == 't') goto yy1127;
	goto yy37;
yy1069:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 440 "parser/tokenizer.re"
	{ KW(INTERFACE) }
#line 8381 "parser/tokenizer.cpp"
yy1070:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 441 "parser/tokenizer.re"
	{ KW(INTRINSIC) }
#line 8390 "parser/tokenizer.cpp"
yy1071:
	yych = *++cur;
	if (yych == 'T') goto yy1128;
	if (yych == 't') goto yy1128;
	goto yy37;
yy1072:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 453 "parser/tokenizer.re"
	{ KW(NEW_INDEX) }
#line 8404 "parser/tokenizer.cpp"
yy1073:
	yych = *++cur;
	if (yych == 'N') goto yy1129;
	if (yych == 'n') goto yy1129;
	goto yy37;
yy1074:
	yych = *++cur;
	if (yych == 'I') goto yy1130;
	if (yych == 'i') goto yy1130;
	goto yy37;
yy1075:
	yych = *++cur;
	if (yych == 'S') goto yy1131;
	if (yych == 's') goto yy1131;
	goto yy37;
yy1076:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 465 "parser/tokenizer.re"
	{ KW(PARAMETER) }
#line 8428 "parser/tokenizer.cpp"
yy1077:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 469 "parser/tokenizer.re"
	{ KW(PRECISION) }
#line 8437 "parser/tokenizer.cpp"
yy1078:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 472 "parser/tokenizer.re"
	{ KW(PROCEDURE) }
#line 8446 "parser/tokenizer.cpp"
yy1079:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 474 "parser/tokenizer.re"
	{ KW(PROTECTED) }
#line 8455 "parser/tokenizer.cpp"
yy1080:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 481 "parser/tokenizer.re"
	{ KW(RECURSIVE) }
#line 8464 "parser/tokenizer.cpp"
yy1081:
	yych = *++cur;
	if (yych == 'N') goto yy1132;
	if (yych == 'n') goto yy1132;
	goto yy37;
yy1082:
	yych = *++cur;
	if (yych == 'E') goto yy1133;
	if (yych == 'e') goto yy1133;
	goto yy37;
yy1083:
	yych = *++cur;
	if (yych == 'K') goto yy1134;
	if (yych == 'k') goto yy1134;
	goto yy37;
yy1084:
	yych = *++cur;
	if (yych == 'E') goto yy1135;
	if (yych == 'e') goto yy1135;
	goto yy37;
yy1085:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 498 "parser/tokenizer.re"
	{ KW(SUBMODULE) }
#line 8493 "parser/tokenizer.cpp"
yy1086:
	yych = *++cur;
	if (yych == 'E') goto yy1136;
	if (yych == 'e') goto yy1136;
	goto yy37;
yy1087:
	yych = *++cur;
	if (yych == 'S') goto yy1137;
	if (yych == 's') goto yy1137;
	goto yy37;
yy1088:
	yych = *++cur;
	if (yych == 'Y') goto yy1138;
	if (yych == 'y') goto yy1138;
	goto yy37;
yy1089:
	yych = *++cur;
	if (yych == 'E') goto yy1139;
	if (yych == 'e') goto yy1139;
	goto yy37;
yy1090:
	yych = *++cur;
	if (yych == 'E') goto yy1140;
	if (yych == 'e') goto yy1140;
	goto yy37;
yy1091:
	++cur;
	cur -= 1;
#line 662 "parser/tokenizer.re"
	{ TK_TRIVIA(TK_OMP_END) }
#line 8524 "parser/tokenizer.cpp"
yy1092:
	yych = *++cur;
	if (yych == 'E') goto yy1141;
	if (yych == 'e') goto yy1141;
	goto yy37;
yy1093:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 274 "parser/tokenizer.re"
	{ KW(ASSIGNMENT) }
#line 8538 "parser/tokenizer.cpp"
yy1094:
	yych = *++cur;
	if (yych == 'U') goto yy1142;
	if (yych == 'u') goto yy1142;
	goto yy37;
yy1095:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 283 "parser/tokenizer.re"
	{ KW(CHANGE_TEAM) }
#line 8552 "parser/tokenizer.cpp"
yy1096:
	yych = *++cur;
	if (yych == 'N') goto yy1143;
	if (yych == 'n') goto yy1143;
	goto yy37;
yy1097:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 290 "parser/tokenizer.re"
	{ KW(CONCURRENT) }
#line 8566 "parser/tokenizer.cpp"
yy1098:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 292 "parser/tokenizer.re"
	{ KW(CONTIGUOUS) }
#line 8575 "parser/tokenizer.cpp"
yy1099:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 297 "parser/tokenizer.re"
	{ KW(DEALLOCATE) }
#line 8584 "parser/tokenizer.cpp"
yy1100:
	yych = *++cur;
	if (yych == 'L') goto yy1144;
	if (yych == 'l') goto yy1144;
	goto yy37;
yy1101:
	yych = *++cur;
	if (yych == 'I') goto yy1145;
	if (yych == 'i') goto yy1145;
	goto yy37;
yy1102:
	yych = *++cur;
	if (yych == 'A') goto yy1146;
	if (yych == 'a') goto yy1146;
	goto yy61;
yy1103:
	yych = *++cur;
	if (yych <= '\r') {
		if (yych <= '\n') {
			if (yych == '\t') goto yy1103;
			goto yy61;
		} else {
			if (yych == '\f') goto yy61;
			goto yy1103;
		}
	} else {
		if (yych <= 'C') {
			if (yych == ' ') goto yy1103;
			goto yy61;
		} else {
			if (yych <= 'D') goto yy1147;
			if (yych == 'd') goto yy1147;
			goto yy61;
		}
	}
yy1104:
	yych = *++cur;
	if (yych == 'A') goto yy1148;
	if (yych == 'a') goto yy1148;
	goto yy61;
yy1105:
	yych = *++cur;
	if (yych == 'A') goto yy1149;
	if (yych == 'a') goto yy1149;
	goto yy61;
yy1106:
	++cur;
#line 361 "parser/tokenizer.re"
	{ KW(END_FORALL) }
#line 8634 "parser/tokenizer.cpp"
yy1107:
	yych = *++cur;
	if (yych == 'O') goto yy1150;
	if (yych == 'o') goto yy1150;
	goto yy61;
yy1108:
	yych = *++cur;
	if (yych == 'A') goto yy1151;
	if (yych == 'a') goto yy1151;
	goto yy61;
yy1109:
	++cur;
#line 323 "parser/tokenizer.re"
	{ KW(END_MODULE) }
#line 8649 "parser/tokenizer.cpp"
yy1110:
	yych = *++cur;
	if (yych == 'U') goto yy1152;
	if (yych == 'u') goto yy1152;
	goto yy61;
yy1111:
	yych = *++cur;
	if (yych == 'M') goto yy1153;
	if (yych == 'm') goto yy1153;
	goto yy61;
yy1112:
	++cur;
#line 349 "parser/tokenizer.re"
	{ KW(END_SELECT) }
#line 8664 "parser/tokenizer.cpp"
yy1113:
	yych = *++cur;
	if (yych == 'U') goto yy1154;
	if (yych == 'u') goto yy1154;
	goto yy61;
yy1114:
	yych = *++cur;
	if (yych == 'T') goto yy1155;
	if (yych == 't') goto yy1155;
	goto yy61;
yy1115:
	yych = *++cur;
	if (yych == 'T') goto yy1156;
	if (yych == 't') goto yy1156;
	goto yy37;
yy1116:
	yych = *++cur;
	if (yych == 'A') goto yy1157;
	if (yych == 'a') goto yy1157;
	goto yy61;
yy1117:
	yych = *++cur;
	if (yych == 'T') goto yy1158;
	if (yych == 't') goto yy1158;
	goto yy37;
yy1118:
	yych = *++cur;
	if (yych == 'L') goto yy1159;
	if (yych == 'l') goto yy1159;
	goto yy37;
yy1119:
	yych = *++cur;
	if (yych == 'N') goto yy1160;
	if (yych == 'n') goto yy1160;
	goto yy37;
yy1120:
	yych = *++cur;
	if (yych == 'C') goto yy1161;
	if (yych == 'c') goto yy1161;
	goto yy37;
yy1121:
	yych = *++cur;
	if (yych == 'R') goto yy1162;
	if (yych == 'r') goto yy1162;
	goto yy37;
yy1122:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 321 "parser/tokenizer.re"
	{ KW(ENDPROGRAM) }
#line 8718 "parser/tokenizer.cpp"
yy1123:
	yych = *++cur;
	if (yych == 'L') goto yy1163;
	if (yych == 'l') goto yy1163;
	goto yy37;
yy1124:
	yych = *++cur;
	if (yych == 'I') goto yy1164;
	if (yych == 'i') goto yy1164;
	goto yy37;
yy1125:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 396 "parser/tokenizer.re"
	{ KW(ENUMERATOR) }
#line 8737 "parser/tokenizer.cpp"
yy1126:
	yych = *++cur;
	if (yych == 'E') goto yy1165;
	if (yych == 'e') goto yy1165;
	goto yy37;
yy1127:
	yych = *++cur;
	if (yych == 'E') goto yy1166;
	if (yych == 'e') goto yy1166;
	goto yy37;
yy1128:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 446 "parser/tokenizer.re"
	{ KW(LOCAL_INIT) }
#line 8756 "parser/tokenizer.cpp"
yy1129:
	yych = *++cur;
	if (yych == 'S') goto yy1167;
	if (yych == 's') goto yy1167;
	goto yy37;
yy1130:
	yych = *++cur;
	if (yych == 'D') goto yy1168;
	if (yych == 'd') goto yy1168;
	goto yy37;
yy1131:
	yych = *++cur;
	if (yych == 'I') goto yy1169;
	if (yych == 'i') goto yy1169;
	goto yy37;
yy1132:
	yych = *++cur;
	if (yych == 'T') goto yy1170;
	if (yych == 't') goto yy1170;
	goto yy37;
yy1133:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 490 "parser/tokenizer.re"
	{ KW(SELECT_CASE) }
#line 8785 "parser/tokenizer.cpp"
yy1134:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 491 "parser/tokenizer.re"
	{ KW(SELECT_RANK) }
#line 8794 "parser/tokenizer.cpp"
yy1135:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 492 "parser/tokenizer.re"
	{ KW(SELECT_TYPE) }
#line 8803 "parser/tokenizer.cpp"
yy1136:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 499 "parser/tokenizer.re"
	{ KW(SUBROUTINE) }
#line 8812 "parser/tokenizer.cpp"
yy1137:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 502 "parser/tokenizer.re"
	{ KW(SYNC_IMAGES) }
#line 8821 "parser/tokenizer.cpp"
yy1138:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 503 "parser/tokenizer.re"
	{ KW(SYNC_MEMORY) }
#line 8830 "parser/tokenizer.cpp"
yy1139:
	yych = *++cur;
	if (yych == 'R') goto yy1171;
	if (yych == 'r') goto yy1171;
	goto yy37;
yy1140:
	yych = *++cur;
	if (yych == 'D') goto yy1172;
	if (yych == 'd') goto yy1172;
	goto yy37;
yy1141:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 271 "parser/tokenizer.re"
	{ KW(ALLOCATABLE) }
#line 8849 "parser/tokenizer.cpp"
yy1142:
	yych = *++cur;
	if (yych == 'S') goto yy1173;
	if (yych == 's') goto yy1173;
	goto yy37;
yy1143:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 287 "parser/tokenizer.re"
	{ KW(CODIMENSION) }
#line 8863 "parser/tokenizer.cpp"
yy1144:
	yych = *++cur;
	if (yych == 'E') goto yy1174;
	if (yych == 'e') goto yy1174;
	goto yy37;
yy1145:
	yych = *++cur;
	if (yych == 'S') goto yy1175;
	if (yych == 's') goto yy1175;
	goto yy37;
yy1146:
	yych = *++cur;
	if (yych == 'T') goto yy1176;
	if (yych == 't') goto yy1176;
	goto yy61;
yy1147:
	yych = *++cur;
	if (yych == 'A') goto yy1177;
	if (yych == 'a') goto yy1177;
	goto yy61;
yy1148:
	yych = *++cur;
	if (yych == 'T') goto yy1178;
	if (yych == 't') goto yy1178;
	goto yy61;
yy1149:
	yych = *++cur;
	if (yych == 'L') goto yy1179;
	if (yych == 'l') goto yy1179;
	goto yy61;
yy1150:
	yych = *++cur;
	if (yych == 'N') goto yy1180;
	if (yych == 'n') goto yy1180;
	goto yy61;
yy1151:
	yych = *++cur;
	if (yych == 'C') goto yy1181;
	if (yych == 'c') goto yy1181;
	goto yy61;
yy1152:
	yych = *++cur;
	if (yych == 'R') goto yy1182;
	if (yych == 'r') goto yy1182;
	goto yy61;
yy1153:
	++cur;
#line 320 "parser/tokenizer.re"
	{ KW(END_PROGRAM) }
#line 8913 "parser/tokenizer.cpp"
yy1154:
	yych = *++cur;
	if (yych == 'L') goto yy1183;
	if (yych == 'l') goto yy1183;
	goto yy61;
yy1155:
	yych = *++cur;
	if (yych == 'I') goto yy1184;
	if (yych == 'i') goto yy1184;
	goto yy61;
yy1156:
	yych = *++cur;
	if (yych == 'E') goto yy1185;
	if (yych == 'e') goto yy1185;
	goto yy37;
yy1157:
	yych = *++cur;
	if (yych == 'T') goto yy1186;
	if (yych == 't') goto yy1186;
	goto yy61;
yy1158:
	yych = *++cur;
	if (yych == 'A') goto yy1187;
	if (yych == 'a') goto yy1187;
	goto yy37;
yy1159:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 356 "parser/tokenizer.re"
	{ KW(ENDCRITICAL) }
#line 8947 "parser/tokenizer.cpp"
yy1160:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 341 "parser/tokenizer.re"
	{ KW(ENDFUNCTION) }
#line 8956 "parser/tokenizer.cpp"
yy1161:
	yych = *++cur;
	if (yych == 'E') goto yy1188;
	if (yych == 'e') goto yy1188;
	goto yy37;
yy1162:
	yych = *++cur;
	if (yych == 'E') goto yy1189;
	if (yych == 'e') goto yy1189;
	goto yy37;
yy1163:
	yych = *++cur;
	if (yych == 'E') goto yy1190;
	if (yych == 'e') goto yy1190;
	goto yy37;
yy1164:
	yych = *++cur;
	if (yych == 'N') goto yy1191;
	if (yych == 'n') goto yy1191;
	goto yy37;
yy1165:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 397 "parser/tokenizer.re"
	{ KW(EQUIVALENCE) }
#line 8985 "parser/tokenizer.cpp"
yy1166:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 437 "parser/tokenizer.re"
	{ KW(INSTANTIATE) }
#line 8994 "parser/tokenizer.cpp"
yy1167:
	yych = *++cur;
	if (yych == 'I') goto yy1192;
	if (yych == 'i') goto yy1192;
	goto yy37;
yy1168:
	yych = *++cur;
	if (yych == 'A') goto yy1193;
	if (yych == 'a') goto yy1193;
	goto yy37;
yy1169:
	yych = *++cur;
	if (yych == 'V') goto yy1194;
	if (yych == 'v') goto yy1194;
	goto yy37;
yy1170:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 483 "parser/tokenizer.re"
	{ KW(REQUIREMENT) }
#line 9018 "parser/tokenizer.cpp"
yy1171:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 507 "parser/tokenizer.re"
	{ KW(TEAM_NUMBER) }
#line 9027 "parser/tokenizer.cpp"
yy1172:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 512 "parser/tokenizer.re"
	{ KW(UNFORMATTED) }
#line 9036 "parser/tokenizer.cpp"
yy1173:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 276 "parser/tokenizer.re"
	{ KW(ASYNCHRONOUS) }
#line 9045 "parser/tokenizer.cpp"
yy1174:
	yych = *++cur;
	if (yych == 'X') goto yy1195;
	if (yych == 'x') goto yy1195;
	goto yy37;
yy1175:
	yych = *++cur;
	if (yych == 'I') goto yy1196;
	if (yych == 'i') goto yy1196;
	goto yy37;
yy1176:
	yych = *++cur;
	if (yych == 'E') goto yy1197;
	if (yych == 'e') goto yy1197;
	goto yy61;
yy1177:
	yych = *++cur;
	if (yych == 'T') goto yy1198;
	if (yych == 't') goto yy1198;
	goto yy61;
yy1178:
	yych = *++cur;
	if (yych == 'A') goto yy1199;
	if (yych == 'a') goto yy1199;
	goto yy61;
yy1179:
	++cur;
#line 355 "parser/tokenizer.re"
	{ KW(END_CRITICAL) }
#line 9075 "parser/tokenizer.cpp"
yy1180:
	++cur;
#line 340 "parser/tokenizer.re"
	{ KW(END_FUNCTION) }
#line 9080 "parser/tokenizer.cpp"
yy1181:
	yych = *++cur;
	if (yych == 'E') goto yy1200;
	if (yych == 'e') goto yy1200;
	goto yy61;
yy1182:
	yych = *++cur;
	if (yych == 'E') goto yy1201;
	if (yych == 'e') goto yy1201;
	goto yy61;
yy1183:
	yych = *++cur;
	if (yych == 'E') goto yy1202;
	if (yych == 'e') goto yy1202;
	goto yy61;
yy1184:
	yych = *++cur;
	if (yych == 'N') goto yy1203;
	if (yych == 'n') goto yy1203;
	goto yy61;
yy1185:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 353 "parser/tokenizer.re"
	{ KW(ENDASSOCIATE) }
#line 9109 "parser/tokenizer.cpp"
yy1186:
	yych = *++cur;
	if (yych == 'A') goto yy1204;
	if (yych == 'a') goto yy1204;
	goto yy61;
yy1187:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 335 "parser/tokenizer.re"
	{ KW(ENDBLOCKDATA) }
#line 9123 "parser/tokenizer.cpp"
yy1188:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 368 "parser/tokenizer.re"
	{ KW(ENDINTERFACE) }
#line 9132 "parser/tokenizer.cpp"
yy1189:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 344 "parser/tokenizer.re"
	{ KW(ENDPROCEDURE) }
#line 9141 "parser/tokenizer.cpp"
yy1190:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 327 "parser/tokenizer.re"
	{ KW(ENDSUBMODULE) }
#line 9150 "parser/tokenizer.cpp"
yy1191:
	yych = *++cur;
	if (yych == 'E') goto yy1205;
	if (yych == 'e') goto yy1205;
	goto yy37;
yy1192:
	yych = *++cur;
	if (yych == 'C') goto yy1206;
	if (yych == 'c') goto yy1206;
	goto yy37;
yy1193:
	yych = *++cur;
	if (yych == 'B') goto yy1207;
	if (yych == 'b') goto yy1207;
	goto yy37;
yy1194:
	yych = *++cur;
	if (yych == 'E') goto yy1208;
	if (yych == 'e') goto yy1208;
	goto yy37;
yy1195:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 312 "parser/tokenizer.re"
	{ KW(DOUBLE_COMPLEX) }
#line 9179 "parser/tokenizer.cpp"
yy1196:
	yych = *++cur;
	if (yych == 'O') goto yy1209;
	if (yych == 'o') goto yy1209;
	goto yy37;
yy1197:
	++cur;
#line 352 "parser/tokenizer.re"
	{ KW(END_ASSOCIATE) }
#line 9189 "parser/tokenizer.cpp"
yy1198:
	yych = *++cur;
	if (yych == 'A') goto yy1210;
	if (yych == 'a') goto yy1210;
	goto yy61;
yy1199:
	++cur;
#line 334 "parser/tokenizer.re"
	{ KW(END_BLOCK_DATA) }
#line 9199 "parser/tokenizer.cpp"
yy1200:
	++cur;
#line 367 "parser/tokenizer.re"
	{ KW(END_INTERFACE) }
#line 9204 "parser/tokenizer.cpp"
yy1201:
	++cur;
#line 343 "parser/tokenizer.re"
	{ KW(END_PROCEDURE) }
#line 9209 "parser/tokenizer.cpp"
yy1202:
	++cur;
#line 326 "parser/tokenizer.re"
	{ KW(END_SUBMODULE) }
#line 9214 "parser/tokenizer.cpp"
yy1203:
	yych = *++cur;
	if (yych == 'E') goto yy1211;
	if (yych == 'e') goto yy1211;
	goto yy61;
yy1204:
	++cur;
#line 333 "parser/tokenizer.re"
	{ KW(END_BLOCK_DATA) }
#line 9224 "parser/tokenizer.cpp"
yy1205:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 338 "parser/tokenizer.re"
	{ KW(ENDSUBROUTINE) }
#line 9233 "parser/tokenizer.cpp"
yy1206:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 455 "parser/tokenizer.re"
	{ KW(NON_INTRINSIC) }
#line 9242 "parser/tokenizer.cpp"
yy1207:
	yych = *++cur;
	if (yych == 'L') goto yy1212;
	if (yych == 'l') goto yy1212;
	goto yy37;
yy1208:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 457 "parser/tokenizer.re"
	{ KW(NON_RECURSIVE) }
#line 9256 "parser/tokenizer.cpp"
yy1209:
	yych = *++cur;
	if (yych == 'N') goto yy1213;
	if (yych == 'n') goto yy1213;
	goto yy37;
yy1210:
	++cur;
#line 332 "parser/tokenizer.re"
	{ KW(END_BLOCK_DATA) }
#line 9266 "parser/tokenizer.cpp"
yy1211:
	++cur;
#line 337 "parser/tokenizer.re"
	{ KW(END_SUBROUTINE) }
#line 9271 "parser/tokenizer.cpp"
yy1212:
	yych = *++cur;
	if (yych == 'E') goto yy1214;
	if (yych == 'e') goto yy1214;
	goto yy37;
yy1213:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 311 "parser/tokenizer.re"
	{ KW(DOUBLE_PRECISION) }
#line 9285 "parser/tokenizer.cpp"
yy1214:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy117;
#line 456 "parser/tokenizer.re"
	{ KW(NON_OVERRIDABLE) }
#line 9294 "parser/tokenizer.cpp"
}
#line 729 "parser/tokenizer.re"

    }
}

std::string token(unsigned char *tok, unsigned char* cur)
{
    return std::string((char *)tok, cur - tok);
}

void token_loc(Location &loc)
{
    loc.first = 1;
    loc.last = 1;
}

void lex_format(unsigned char *&cur, Location &loc,
        unsigned char *&start) {
    int num_paren = 0;
    for (;;) {
        unsigned char *tok = cur;
        unsigned char *mar;
        
#line 9319 "parser/tokenizer.cpp"
{
	unsigned char yych;
	unsigned int yyaccept = 0;
	static const unsigned char yybm[] = {
		  0,  52,  52,  52,  52,  52,  52,  52, 
		 52, 190,  44, 190,  52, 190,  52,  52, 
		 52,  52,  52,  52,  52,  52,  52,  52, 
		 52,  52,  52,  52,  52,  52,  52,  52, 
		190,  52,  48,  52,  52,  52,  52,  20, 
		 52,  52,  52,  52,  52,  52,  52,  52, 
		244, 244, 244, 244, 244, 244, 244, 244, 
		244, 244,  52,  52,  52,  52,  52,  52, 
		 52,  52,  52,  52,  52,  52,  52,  52, 
		 52,  52,  52,  52,  52,  52,  52,  52, 
		 52,  52,  52,  52,  52,  52,  52,  52, 
		 52,  52,  52,  52,  52,  52,  52,  52, 
		 52,  52,  52,  52,  52,  52,  52,  52, 
		 52,  52,  52,  52,  52,  52,  52,  52, 
		 52,  52,  52,  52,  52,  52,  52,  52, 
		 52,  52,  52,  52,  52,  52,  52,  52, 
		 52,  52,  52,  52,  52,  52,  52,  52, 
		 52,  52,  52,  52,  52,  52,  52,  52, 
		 52,  52,  52,  52,  52,  52,  52,  52, 
		 52,  52,  52,  52,  52,  52,  52,  52, 
		 52,  52,  52,  52,  52,  52,  52,  52, 
		 52,  52,  52,  52,  52,  52,  52,  52, 
		 52,  52,  52,  52,  52,  52,  52,  52, 
		 52,  52,  52,  52,  52,  52,  52,  52, 
		 52,  52,  52,  52,  52,  52,  52,  52, 
		 52,  52,  52,  52,  52,  52,  52,  52, 
		 52,  52,  52,  52,  52,  52,  52,  52, 
		 52,  52,  52,  52,  52,  52,  52,  52, 
		 52,  52,  52,  52,  52,  52,  52,  52, 
		 52,  52,  52,  52,  52,  52,  52,  52, 
		 52,  52,  52,  52,  52,  52,  52,  52, 
		 52,  52,  52,  52,  52,  52,  52,  52, 
	};
	yych = *cur;
	if (yybm[0+yych] & 2) {
		goto yy1219;
	}
	switch (yych) {
		case 0x00: goto yy1216;
		case '"': goto yy1221;
		case '&': goto yy1222;
		case '\'': goto yy1223;
		case '(': goto yy1224;
		case ')': goto yy1225;
		case '*': goto yy1226;
		case ',': goto yy1227;
		case '-': goto yy1228;
		case '/':
		case ':': goto yy1229;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy1231;
		case 'A':
		case 'a': goto yy1232;
		case 'B':
		case 'I':
		case 'O':
		case 'Z':
		case 'b':
		case 'i':
		case 'o':
		case 'z': goto yy1234;
		case 'D':
		case 'F':
		case 'd':
		case 'f': goto yy1235;
		case 'E':
		case 'e': goto yy1236;
		case 'G':
		case 'g': goto yy1237;
		case 'L':
		case 'l': goto yy1238;
		case 'P':
		case 'p': goto yy1239;
		case 'T':
		case 't': goto yy1240;
		case 'X':
		case 'x': goto yy1241;
		default: goto yy1217;
	}
yy1216:
	++cur;
#line 823 "parser/tokenizer.re"
	{
                token_loc(loc);
                std::string t = token(tok, cur);
                throw LFortran::parser_local::TokenizerError(
                    "End of file not expected in `format` statement '" + t + "'", loc);
            }
#line 9420 "parser/tokenizer.cpp"
yy1217:
	++cur;
yy1218:
#line 789 "parser/tokenizer.re"
	{
                token_loc(loc);
                std::string t = token(tok, cur);
                throw LFortran::parser_local::TokenizerError("Token '" + t
                    + "' is not recognized in `format` statement", loc);
            }
#line 9431 "parser/tokenizer.cpp"
yy1219:
	yyaccept = 0;
	yych = *(mar = ++cur);
	if (yybm[0+yych] & 2) {
		goto yy1219;
	}
	switch (yych) {
		case 'A':
		case 'a': goto yy1232;
		case 'B':
		case 'I':
		case 'O':
		case 'Z':
		case 'b':
		case 'i':
		case 'o':
		case 'z': goto yy1242;
		case 'D':
		case 'F':
		case 'd':
		case 'f': goto yy1244;
		case 'E':
		case 'e': goto yy1245;
		case 'G':
		case 'g': goto yy1246;
		case 'L':
		case 'l': goto yy1247;
		case 'P':
		case 'p': goto yy1239;
		case 'X':
		case 'x': goto yy1241;
		default: goto yy1220;
	}
yy1220:
#line 829 "parser/tokenizer.re"
	{ continue; }
#line 9468 "parser/tokenizer.cpp"
yy1221:
	yyaccept = 1;
	yych = *(mar = ++cur);
	if (yych <= 0x00) goto yy1218;
	goto yy1249;
yy1222:
	yyaccept = 1;
	yych = *(mar = ++cur);
	if (yych <= '\f') {
		if (yych <= 0x08) goto yy1218;
		if (yych <= '\v') goto yy1252;
		goto yy1218;
	} else {
		if (yych <= '\r') goto yy1252;
		if (yych <= 0x1F) goto yy1218;
		if (yych <= '!') goto yy1252;
		goto yy1218;
	}
yy1223:
	yyaccept = 1;
	yych = *(mar = ++cur);
	if (yych <= 0x00) goto yy1218;
	goto yy1257;
yy1224:
	++cur;
#line 795 "parser/tokenizer.re"
	{
                if (num_paren == 0) {
                    num_paren++;
                    start = cur;
                    continue;
                } else {
                    cur--;
                    unsigned char *tmp;
                    lex_format(cur, loc, tmp);
                    continue;
                }
            }
#line 9507 "parser/tokenizer.cpp"
yy1225:
	++cur;
#line 819 "parser/tokenizer.re"
	{
                LCOMPILERS_ASSERT(num_paren == 1);
                return;
            }
#line 9515 "parser/tokenizer.cpp"
yy1226:
	yyaccept = 1;
	yych = *(mar = ++cur);
	if (yych <= '\f') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy1218;
			goto yy1259;
		} else {
			if (yych == '\v') goto yy1259;
			goto yy1218;
		}
	} else {
		if (yych <= ' ') {
			if (yych <= '\r') goto yy1259;
			if (yych <= 0x1F) goto yy1218;
			goto yy1259;
		} else {
			if (yych == '(') goto yy1260;
			goto yy1218;
		}
	}
yy1227:
	++cur;
#line 830 "parser/tokenizer.re"
	{ continue; }
#line 9541 "parser/tokenizer.cpp"
yy1228:
	++cur;
#line 834 "parser/tokenizer.re"
	{ continue; }
#line 9546 "parser/tokenizer.cpp"
yy1229:
	++cur;
yy1230:
#line 836 "parser/tokenizer.re"
	{ continue; }
#line 9552 "parser/tokenizer.cpp"
yy1231:
	yyaccept = 1;
	yych = *(mar = ++cur);
	switch (yych) {
		case '\t':
		case '\v':
		case '\r':
		case ' ':
		case '(':
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'I':
		case 'L':
		case 'O':
		case 'P':
		case 'X':
		case 'Z':
		case 'a':
		case 'b':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'i':
		case 'l':
		case 'o':
		case 'p':
		case 'x':
		case 'z': goto yy1262;
		case '/': goto yy1229;
		default: goto yy1218;
	}
yy1232:
	yych = *++cur;
	if (yych <= '\f') {
		if (yych <= '\t') {
			if (yych >= '\t') goto yy1232;
		} else {
			if (yych == '\v') goto yy1232;
		}
	} else {
		if (yych <= ' ') {
			if (yych <= '\r') goto yy1232;
			if (yych >= ' ') goto yy1232;
		} else {
			if (yych <= '/') goto yy1233;
			if (yych <= '9') goto yy1265;
		}
	}
yy1233:
#line 835 "parser/tokenizer.re"
	{ continue; }
#line 9619 "parser/tokenizer.cpp"
yy1234:
	yyaccept = 1;
	yych = *(mar = ++cur);
	if (yych <= '\f') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy1218;
			goto yy1242;
		} else {
			if (yych == '\v') goto yy1242;
			goto yy1218;
		}
	} else {
		if (yych <= ' ') {
			if (yych <= '\r') goto yy1242;
			if (yych <= 0x1F) goto yy1218;
			goto yy1242;
		} else {
			if (yych <= '/') goto yy1218;
			if (yych <= '9') goto yy1266;
			goto yy1218;
		}
	}
yy1235:
	yyaccept = 1;
	yych = *(mar = ++cur);
	if (yych <= '\f') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy1218;
			goto yy1244;
		} else {
			if (yych == '\v') goto yy1244;
			goto yy1218;
		}
	} else {
		if (yych <= ' ') {
			if (yych <= '\r') goto yy1244;
			if (yych <= 0x1F) goto yy1218;
			goto yy1244;
		} else {
			if (yych <= '/') goto yy1218;
			if (yych <= '9') goto yy1267;
			goto yy1218;
		}
	}
yy1236:
	yyaccept = 1;
	yych = *(mar = ++cur);
	if (yych <= 'M') {
		if (yych <= '\f') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy1218;
				goto yy1245;
			} else {
				if (yych == '\v') goto yy1245;
				goto yy1218;
			}
		} else {
			if (yych <= ' ') {
				if (yych <= '\r') goto yy1245;
				if (yych <= 0x1F) goto yy1218;
				goto yy1245;
			} else {
				if (yych <= '/') goto yy1218;
				if (yych <= '9') goto yy1268;
				goto yy1218;
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'S') {
				if (yych <= 'N') goto yy1269;
				if (yych <= 'R') goto yy1218;
				goto yy1269;
			} else {
				if (yych == 'X') goto yy1269;
				goto yy1218;
			}
		} else {
			if (yych <= 's') {
				if (yych <= 'n') goto yy1269;
				if (yych <= 'r') goto yy1218;
				goto yy1269;
			} else {
				if (yych == 'x') goto yy1269;
				goto yy1218;
			}
		}
	}
yy1237:
	yyaccept = 1;
	yych = *(mar = ++cur);
	if (yych <= '\f') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy1218;
			goto yy1246;
		} else {
			if (yych == '\v') goto yy1246;
			goto yy1218;
		}
	} else {
		if (yych <= ' ') {
			if (yych <= '\r') goto yy1246;
			if (yych <= 0x1F) goto yy1218;
			goto yy1246;
		} else {
			if (yych <= '/') goto yy1218;
			if (yych <= '9') goto yy1270;
			goto yy1218;
		}
	}
yy1238:
	yyaccept = 1;
	yych = *(mar = ++cur);
	if (yych <= '\f') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy1218;
			goto yy1247;
		} else {
			if (yych == '\v') goto yy1247;
			goto yy1218;
		}
	} else {
		if (yych <= ' ') {
			if (yych <= '\r') goto yy1247;
			if (yych <= 0x1F) goto yy1218;
			goto yy1247;
		} else {
			if (yych <= '/') goto yy1218;
			if (yych <= '9') goto yy1265;
			goto yy1218;
		}
	}
yy1239:
	yyaccept = 2;
	yych = *(mar = ++cur);
	if (yych <= '\r') {
		if (yych <= '\n') {
			if (yych == '\t') goto yy1271;
			goto yy1233;
		} else {
			if (yych == '\f') goto yy1233;
			goto yy1271;
		}
	} else {
		if (yych <= 'D') {
			if (yych == ' ') goto yy1271;
			goto yy1233;
		} else {
			if (yych <= 'F') goto yy1244;
			if (yych <= 'd') goto yy1233;
			if (yych <= 'f') goto yy1244;
			goto yy1233;
		}
	}
yy1240:
	yyaccept = 1;
	yych = *(mar = ++cur);
	if (yych <= '\f') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy1218;
			goto yy1272;
		} else {
			if (yych == '\v') goto yy1272;
			goto yy1218;
		}
	} else {
		if (yych <= ' ') {
			if (yych <= '\r') goto yy1272;
			if (yych <= 0x1F) goto yy1218;
			goto yy1272;
		} else {
			if (yych <= '/') goto yy1218;
			if (yych <= '9') goto yy1273;
			goto yy1218;
		}
	}
yy1241:
	++cur;
	goto yy1233;
yy1242:
	yych = *++cur;
	if (yych <= '\f') {
		if (yych <= '\t') {
			if (yych >= '\t') goto yy1242;
		} else {
			if (yych == '\v') goto yy1242;
		}
	} else {
		if (yych <= ' ') {
			if (yych <= '\r') goto yy1242;
			if (yych >= ' ') goto yy1242;
		} else {
			if (yych <= '/') goto yy1243;
			if (yych <= '9') goto yy1266;
		}
	}
yy1243:
	cur = mar;
	if (yyaccept <= 3) {
		if (yyaccept <= 1) {
			if (yyaccept == 0) {
				goto yy1220;
			} else {
				goto yy1218;
			}
		} else {
			if (yyaccept == 2) {
				goto yy1233;
			} else {
				goto yy1250;
			}
		}
	} else {
		if (yyaccept <= 5) {
			if (yyaccept == 4) {
				goto yy1254;
			} else {
				goto yy1258;
			}
		} else {
			goto yy1230;
		}
	}
yy1244:
	yych = *++cur;
	if (yych <= '\f') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy1243;
			goto yy1244;
		} else {
			if (yych == '\v') goto yy1244;
			goto yy1243;
		}
	} else {
		if (yych <= ' ') {
			if (yych <= '\r') goto yy1244;
			if (yych <= 0x1F) goto yy1243;
			goto yy1244;
		} else {
			if (yych <= '/') goto yy1243;
			if (yych <= '9') goto yy1267;
			goto yy1243;
		}
	}
yy1245:
	yych = *++cur;
	if (yych <= 'M') {
		if (yych <= '\f') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy1243;
				goto yy1245;
			} else {
				if (yych == '\v') goto yy1245;
				goto yy1243;
			}
		} else {
			if (yych <= ' ') {
				if (yych <= '\r') goto yy1245;
				if (yych <= 0x1F) goto yy1243;
				goto yy1245;
			} else {
				if (yych <= '/') goto yy1243;
				if (yych <= '9') goto yy1268;
				goto yy1243;
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'S') {
				if (yych <= 'N') goto yy1269;
				if (yych <= 'R') goto yy1243;
				goto yy1269;
			} else {
				if (yych == 'X') goto yy1269;
				goto yy1243;
			}
		} else {
			if (yych <= 's') {
				if (yych <= 'n') goto yy1269;
				if (yych <= 'r') goto yy1243;
				goto yy1269;
			} else {
				if (yych == 'x') goto yy1269;
				goto yy1243;
			}
		}
	}
yy1246:
	yych = *++cur;
	if (yych <= '\f') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy1243;
			goto yy1246;
		} else {
			if (yych == '\v') goto yy1246;
			goto yy1243;
		}
	} else {
		if (yych <= ' ') {
			if (yych <= '\r') goto yy1246;
			if (yych <= 0x1F) goto yy1243;
			goto yy1246;
		} else {
			if (yych <= '/') goto yy1243;
			if (yych <= '9') goto yy1270;
			goto yy1243;
		}
	}
yy1247:
	yych = *++cur;
	if (yych <= '\f') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy1243;
			goto yy1247;
		} else {
			if (yych == '\v') goto yy1247;
			goto yy1243;
		}
	} else {
		if (yych <= ' ') {
			if (yych <= '\r') goto yy1247;
			if (yych <= 0x1F) goto yy1243;
			goto yy1247;
		} else {
			if (yych <= '/') goto yy1243;
			if (yych <= '9') goto yy1265;
			goto yy1243;
		}
	}
yy1248:
	yych = *++cur;
yy1249:
	if (yybm[0+yych] & 4) {
		goto yy1248;
	}
	if (yych <= 0x00) goto yy1243;
	yyaccept = 3;
	yych = *(mar = ++cur);
	if (yych == '"') goto yy1248;
yy1250:
#line 832 "parser/tokenizer.re"
	{ continue; }
#line 9962 "parser/tokenizer.cpp"
yy1251:
	yych = *++cur;
yy1252:
	if (yych <= '\f') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy1243;
			goto yy1251;
		} else {
			if (yych <= '\n') goto yy1253;
			if (yych <= '\v') goto yy1251;
			goto yy1243;
		}
	} else {
		if (yych <= 0x1F) {
			if (yych <= '\r') goto yy1251;
			goto yy1243;
		} else {
			if (yych <= ' ') goto yy1251;
			if (yych <= '!') goto yy1255;
			goto yy1243;
		}
	}
yy1253:
	yyaccept = 4;
	yych = *(mar = ++cur);
	if (yybm[0+yych] & 8) {
		goto yy1253;
	}
	if (yych <= 0x1F) goto yy1254;
	if (yych <= '!') goto yy1255;
	if (yych == '&') goto yy1274;
yy1254:
#line 831 "parser/tokenizer.re"
	{ continue; }
#line 9997 "parser/tokenizer.cpp"
yy1255:
	yych = *++cur;
	if (yybm[0+yych] & 16) {
		goto yy1255;
	}
	if (yych <= 0x00) goto yy1243;
	goto yy1253;
yy1256:
	yych = *++cur;
yy1257:
	if (yybm[0+yych] & 32) {
		goto yy1256;
	}
	if (yych <= 0x00) goto yy1243;
	yyaccept = 5;
	yych = *(mar = ++cur);
	if (yych == '\'') goto yy1256;
yy1258:
#line 833 "parser/tokenizer.re"
	{ continue; }
#line 10018 "parser/tokenizer.cpp"
yy1259:
	yych = *++cur;
	if (yych <= '\f') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy1243;
			goto yy1259;
		} else {
			if (yych == '\v') goto yy1259;
			goto yy1243;
		}
	} else {
		if (yych <= ' ') {
			if (yych <= '\r') goto yy1259;
			if (yych <= 0x1F) goto yy1243;
			goto yy1259;
		} else {
			if (yych != '(') goto yy1243;
		}
	}
yy1260:
	++cur;
#line 813 "parser/tokenizer.re"
	{
                cur--;
                unsigned char *tmp;
                lex_format(cur, loc, tmp);
                continue;
            }
#line 10047 "parser/tokenizer.cpp"
yy1261:
	yych = *++cur;
yy1262:
	if (yybm[0+yych] & 64) {
		goto yy1264;
	}
	switch (yych) {
		case '\t':
		case '\v':
		case '\r':
		case ' ': goto yy1261;
		case '(': goto yy1263;
		case 'A':
		case 'a': goto yy1232;
		case 'B':
		case 'I':
		case 'O':
		case 'Z':
		case 'b':
		case 'i':
		case 'o':
		case 'z': goto yy1242;
		case 'D':
		case 'F':
		case 'd':
		case 'f': goto yy1244;
		case 'E':
		case 'e': goto yy1245;
		case 'G':
		case 'g': goto yy1246;
		case 'L':
		case 'l': goto yy1247;
		case 'P':
		case 'p': goto yy1239;
		case 'X':
		case 'x': goto yy1241;
		default: goto yy1243;
	}
yy1263:
	++cur;
#line 807 "parser/tokenizer.re"
	{
                cur--;
                unsigned char *tmp;
                lex_format(cur, loc, tmp);
                continue;
            }
#line 10095 "parser/tokenizer.cpp"
yy1264:
	yych = *++cur;
	if (yybm[0+yych] & 64) {
		goto yy1264;
	}
	switch (yych) {
		case '\t':
		case '\v':
		case '\r':
		case ' ': goto yy1261;
		case '(': goto yy1263;
		case '/': goto yy1229;
		case 'A':
		case 'a': goto yy1232;
		case 'B':
		case 'I':
		case 'O':
		case 'Z':
		case 'b':
		case 'i':
		case 'o':
		case 'z': goto yy1242;
		case 'D':
		case 'F':
		case 'd':
		case 'f': goto yy1244;
		case 'E':
		case 'e': goto yy1245;
		case 'G':
		case 'g': goto yy1246;
		case 'L':
		case 'l': goto yy1247;
		case 'P':
		case 'p': goto yy1239;
		case 'X':
		case 'x': goto yy1241;
		default: goto yy1243;
	}
yy1265:
	yyaccept = 2;
	yych = *(mar = ++cur);
	if (yych <= '\f') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy1233;
			goto yy1247;
		} else {
			if (yych == '\v') goto yy1247;
			goto yy1233;
		}
	} else {
		if (yych <= ' ') {
			if (yych <= '\r') goto yy1247;
			if (yych <= 0x1F) goto yy1233;
			goto yy1247;
		} else {
			if (yych <= '/') goto yy1233;
			if (yych <= '9') goto yy1265;
			goto yy1233;
		}
	}
yy1266:
	yyaccept = 2;
	yych = *(mar = ++cur);
	if (yybm[0+yych] & 128) {
		goto yy1266;
	}
	if (yych == '.') goto yy1247;
	goto yy1233;
yy1267:
	yych = *++cur;
	if (yych <= '\r') {
		if (yych <= '\n') {
			if (yych == '\t') goto yy1267;
			goto yy1243;
		} else {
			if (yych == '\f') goto yy1243;
			goto yy1267;
		}
	} else {
		if (yych <= '-') {
			if (yych == ' ') goto yy1267;
			goto yy1243;
		} else {
			if (yych <= '.') goto yy1247;
			if (yych <= '/') goto yy1243;
			if (yych <= '9') goto yy1267;
			goto yy1243;
		}
	}
yy1268:
	yych = *++cur;
	if (yych <= '\r') {
		if (yych <= '\n') {
			if (yych == '\t') goto yy1268;
			goto yy1243;
		} else {
			if (yych == '\f') goto yy1243;
			goto yy1268;
		}
	} else {
		if (yych <= '-') {
			if (yych == ' ') goto yy1268;
			goto yy1243;
		} else {
			if (yych <= '.') goto yy1275;
			if (yych <= '/') goto yy1243;
			if (yych <= '9') goto yy1268;
			goto yy1243;
		}
	}
yy1269:
	yych = *++cur;
	if (yych <= '\f') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy1243;
			goto yy1269;
		} else {
			if (yych == '\v') goto yy1269;
			goto yy1243;
		}
	} else {
		if (yych <= ' ') {
			if (yych <= '\r') goto yy1269;
			if (yych <= 0x1F) goto yy1243;
			goto yy1269;
		} else {
			if (yych <= '/') goto yy1243;
			if (yych <= '9') goto yy1268;
			goto yy1243;
		}
	}
yy1270:
	yyaccept = 2;
	yych = *(mar = ++cur);
	if (yych <= '\r') {
		if (yych <= '\n') {
			if (yych == '\t') goto yy1270;
			goto yy1233;
		} else {
			if (yych == '\f') goto yy1233;
			goto yy1270;
		}
	} else {
		if (yych <= '-') {
			if (yych == ' ') goto yy1270;
			goto yy1233;
		} else {
			if (yych <= '.') goto yy1275;
			if (yych <= '/') goto yy1233;
			if (yych <= '9') goto yy1270;
			goto yy1233;
		}
	}
yy1271:
	yych = *++cur;
	if (yych <= '\r') {
		if (yych <= '\n') {
			if (yych == '\t') goto yy1271;
			goto yy1243;
		} else {
			if (yych == '\f') goto yy1243;
			goto yy1271;
		}
	} else {
		if (yych <= 'D') {
			if (yych == ' ') goto yy1271;
			goto yy1243;
		} else {
			if (yych <= 'F') goto yy1244;
			if (yych <= 'd') goto yy1243;
			if (yych <= 'f') goto yy1244;
			goto yy1243;
		}
	}
yy1272:
	yych = *++cur;
	if (yych <= '\f') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy1243;
			goto yy1272;
		} else {
			if (yych == '\v') goto yy1272;
			goto yy1243;
		}
	} else {
		if (yych <= ' ') {
			if (yych <= '\r') goto yy1272;
			if (yych <= 0x1F) goto yy1243;
			goto yy1272;
		} else {
			if (yych <= '/') goto yy1243;
			if (yych >= ':') goto yy1243;
		}
	}
yy1273:
	yych = *++cur;
	if (yych <= 'R') {
		if (yych == 'L') goto yy1279;
		if (yych <= 'Q') goto yy1277;
		goto yy1279;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy1277;
			goto yy1279;
		} else {
			if (yych == 'r') goto yy1279;
			goto yy1277;
		}
	}
yy1274:
	++cur;
	goto yy1254;
yy1275:
	yych = *++cur;
	if (yych <= '\f') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy1243;
			goto yy1275;
		} else {
			if (yych == '\v') goto yy1275;
			goto yy1243;
		}
	} else {
		if (yych <= ' ') {
			if (yych <= '\r') goto yy1275;
			if (yych <= 0x1F) goto yy1243;
			goto yy1275;
		} else {
			if (yych <= '/') goto yy1243;
			if (yych <= '9') goto yy1280;
			goto yy1243;
		}
	}
yy1276:
	yych = *++cur;
yy1277:
	if (yych <= '\f') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy1243;
			goto yy1276;
		} else {
			if (yych == '\v') goto yy1276;
			goto yy1243;
		}
	} else {
		if (yych <= ' ') {
			if (yych <= '\r') goto yy1276;
			if (yych <= 0x1F) goto yy1243;
			goto yy1276;
		} else {
			if (yych <= '/') goto yy1243;
			if (yych >= ':') goto yy1243;
		}
	}
yy1278:
	yyaccept = 6;
	yych = *(mar = ++cur);
	if (yych <= '/') {
		if (yych <= '\v') {
			if (yych == '\t') goto yy1276;
			if (yych <= '\n') goto yy1230;
			goto yy1276;
		} else {
			if (yych <= '\r') {
				if (yych <= '\f') goto yy1230;
				goto yy1276;
			} else {
				if (yych == ' ') goto yy1276;
				goto yy1230;
			}
		}
	} else {
		if (yych <= 'R') {
			if (yych <= 'K') {
				if (yych <= '9') goto yy1278;
				goto yy1230;
			} else {
				if (yych <= 'L') goto yy1279;
				if (yych <= 'Q') goto yy1230;
			}
		} else {
			if (yych <= 'l') {
				if (yych <= 'k') goto yy1230;
			} else {
				if (yych != 'r') goto yy1230;
			}
		}
	}
yy1279:
	yych = *++cur;
	if (yych <= '\f') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy1243;
			goto yy1279;
		} else {
			if (yych == '\v') goto yy1279;
			goto yy1243;
		}
	} else {
		if (yych <= ' ') {
			if (yych <= '\r') goto yy1279;
			if (yych <= 0x1F) goto yy1243;
			goto yy1279;
		} else {
			if (yych <= '/') goto yy1243;
			if (yych <= '9') goto yy1281;
			goto yy1243;
		}
	}
yy1280:
	yyaccept = 2;
	yych = *(mar = ++cur);
	if (yych <= 0x1F) {
		if (yych <= '\n') {
			if (yych == '\t') goto yy1280;
			goto yy1233;
		} else {
			if (yych == '\f') goto yy1233;
			if (yych <= '\r') goto yy1280;
			goto yy1233;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= ' ') goto yy1280;
			if (yych <= '/') goto yy1233;
			if (yych <= '9') goto yy1280;
			goto yy1233;
		} else {
			if (yych <= 'E') goto yy1247;
			if (yych == 'e') goto yy1247;
			goto yy1233;
		}
	}
yy1281:
	yyaccept = 6;
	yych = *(mar = ++cur);
	if (yych <= '\f') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy1230;
			goto yy1279;
		} else {
			if (yych == '\v') goto yy1279;
			goto yy1230;
		}
	} else {
		if (yych <= ' ') {
			if (yych <= '\r') goto yy1279;
			if (yych <= 0x1F) goto yy1230;
			goto yy1279;
		} else {
			if (yych <= '/') goto yy1230;
			if (yych <= '9') goto yy1281;
			goto yy1230;
		}
	}
}
#line 837 "parser/tokenizer.re"

    }
}

} // namespace LCompilers::LFortran
