/* IMSpector - Instant Messenger Transparent Proxy Service
 * http://www.imspector.org/
 * (c) Lawrence Manning <lawrence@aslak.net>, 2006
 * 
 * Contributions from:
 *     Ryan Wagoner <ryan@wgnrs.dynu.com>, 2006
 *     Simon Brassington <simon@the-brassingtons.co.uk>, 2007
 *          
 * Released under the GPL v2. */

struct mysockaddr
{
#if defined (__linux__)
	__SOCKADDR_COMMON (sa_);
#else
	unsigned char   sa_len;
	sa_family_t  sa_family;
#endif
	char sa_data[STRING_SIZE];
};

class Socket
{
	public:
		Socket(int domainin, int typein);
		~Socket();
		bool listensocket(std::string localaddress);
		bool awaitconnection(class Socket &clientsocket, std::string &clientaddress);
		std::string getredirectaddress(void);
		bool connectsocket(std::string remoteaddress, std::string interface);

#ifdef HAVE_SSL
		bool enablessl(SSL_CTX *ctx);
		bool sslaccept(void);
		bool sslconnect(void);
		std::string getpeercommonname(void);
		int getvalidatecertresult(void);
#endif
		int senddata(const char *buffer, int length);
		bool sendalldata(const char *buffer, int length);
		int sendline(const char *string, int length);
		int recvdata(char *buffer, int length);
		bool recvalldata(char *buffer, int length);
		int recvline(char *string, int length);
		int getfd(void);
		void closesocket(void);
		
	private:
		void setfd(int fdin);
		struct mysockaddr stringtosockaddr(std::string address);
		std::string sockaddrtostring(struct mysockaddr *pmyname);
	
		int domain, type;
		int fd;
		
#ifdef HAVE_SSL
		SSL *ssl;
		X509 *peercert;
#endif
};
