# SPDX-License-Identifier: Apache-2.0
# SPDX-FileCopyrightText: Zygmunt Krynicki
DEBIAN_RELEASES += 12
DEBIAN_12_CODENAME = bookworm

.PHONY: all
all:: debian-cloud-12.$(GARDEN_ARCH).qcow2 debian-cloud-12.$(GARDEN_ARCH).run

.PHONY: fetch
fetch: $(GARDEN_DL_DIR)/debian/debian-12-genericcloud-$(call map_to_debian_arch,$(GARDEN_ARCH))-daily.qcow2

$(GARDEN_DL_DIR)/debian/debian-12-genericcloud-amd64-daily.qcow2 $(GARDEN_DL_DIR)/debian/debian-12-genericcloud-arm64-daily.qcow2: $(GARDEN_DL_DIR)/debian/debian-12-genericcloud-%-daily.qcow2: | $(GARDEN_DL_DIR)/debian
	$(strip $(WGET) \
		--no-clobber \
		--directory-prefix=$(firstword $|)/ \
		https://cloud.debian.org/images/cloud/$(DEBIAN_12_CODENAME)/daily/latest/debian-12-genericcloud-$*-daily.qcow2)

$(GARDEN_DL_DIR)/debian/debian-cloud-12.x86_64.qcow2: | $(GARDEN_DL_DIR)/debian $(GARDEN_DL_DIR)/debian/debian-12-genericcloud-amd64-daily.qcow2
	ln -sf $(notdir $(word 2,$|)) $@

$(GARDEN_DL_DIR)/debian/debian-cloud-12.aarch64.qcow2: | $(GARDEN_DL_DIR)/debian $(GARDEN_DL_DIR)/debian/debian-12-genericcloud-arm64-daily.qcow2
	ln -sf $(notdir $(word 2,$|)) $@

.PHONY: clean
clean::
	rm -f $(GARDEN_DL_DIR)/debian/debian-cloud-12.*.qcow2

.PHONY: distclean
distclean::
	rm -f $(GARDEN_DL_DIR)/debian/debian-12-genericcloud-*.qcow2
