/*
 *  JLib - Jacob's Library.
 *  Copyright (C) 2003, 2004  Juan Carlos Seijo Prez
 * 
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 * 
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 * 
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 *  Juan Carlos Seijo Prez
 *  jacob@mainreactor.net
 */

///////////////////////////////////////////////////////////////////////////////
// @author: Juan Carlos Seijo Prez
// @date: 20/10/2003
// @description: Consola de texto para OpenGL independiente de la plataforma.
///////////////////////////////////////////////////////////////////////////////

#ifndef _JGLCONSOLEFONT_INCLUDED
#define _JGLCONSOLEFONT_INCLUDED

#include <JLib/Util/JTypes.h>
const u8 JGLCONSOLEFONT1[256][8] = {
{0x00,0x00,0x00,0x40,0x80,0x80,0x80,0x40,},
{0x00,0x00,0x00,0x80,0x80,0x80,0x80,0x80,},
{0x00,0x00,0x00,0xc0,0x80,0xc0,0x40,0xc0,},
{0x00,0x00,0x00,0xc0,0x40,0xc0,0x40,0xc0,},
{0x00,0x00,0x00,0x40,0x40,0xc0,0x80,0x80,},
{0x00,0x00,0x00,0xc0,0x40,0xc0,0x80,0xc0,},
{0x00,0x00,0x00,0xc0,0xc0,0xc0,0x80,0x80,},
{0x00,0x00,0x00,0x80,0x80,0x80,0x40,0xc0,},
{0x00,0x00,0x00,0x40,0x80,0x40,0x80,0x40,},
{0x00,0x00,0x00,0x40,0x40,0xc0,0xc0,0xc0,},
{0x00,0x00,0x00,0x90,0xa0,0xa0,0xa0,0x90,},
{0x00,0x00,0x00,0x90,0x90,0x90,0x90,0x90,},
{0x00,0x00,0x00,0xb0,0xa0,0xb0,0x90,0xb0,},
{0x00,0x00,0x00,0xb0,0x90,0xb0,0x90,0xb0,},
{0x00,0x00,0x00,0x90,0x90,0xb0,0xa0,0xa0,},
{0x00,0x00,0x00,0xb0,0x90,0xb0,0xa0,0xb0,},
{0x00,0x00,0x00,0x98,0x98,0x98,0x90,0x90,},
{0x00,0x00,0x00,0x90,0x90,0x90,0x88,0x98,},
{0x00,0x00,0x00,0x98,0x98,0x80,0x98,0x98,},
{0x00,0x00,0x00,0x88,0x88,0x98,0x98,0x98,},
{0x00,0x00,0x00,0xc8,0x90,0xd0,0x50,0xc8,},
{0x00,0x00,0x00,0xd0,0x90,0xd0,0x50,0xd0,},
{0x00,0x00,0x00,0xd8,0x90,0xd8,0x48,0xd8,},
{0x00,0x00,0x00,0xd8,0x88,0xd8,0x48,0xd8,},
{0x00,0x00,0x00,0xc8,0x88,0xd8,0x50,0xd0,},
{0x00,0x00,0x00,0xd8,0x88,0xd8,0x50,0xd8,},
{0x00,0x00,0x00,0xd8,0x98,0xd8,0x50,0xd0,},
{0x00,0x00,0x00,0xd0,0x90,0xd0,0x48,0xd8,},
{0x00,0x00,0x00,0xc8,0x90,0xc8,0x50,0xc8,},
{0x00,0x00,0x00,0xc8,0x88,0xd8,0x58,0xd8,},
{0x00,0x00,0x00,0xc8,0x50,0xd0,0x50,0xc8,},
{0x00,0x00,0x00,0xd0,0x50,0xd0,0x50,0xd0,},
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,},
{0x00,0x10,0x00,0x10,0x10,0x20,0x20,0x20,},
{0x00,0x00,0x00,0x00,0x00,0x28,0x6c,0x6c,},
{0x00,0x44,0xfe,0x44,0x44,0x44,0xfe,0x44,},
{0x00,0x10,0x7c,0x12,0x7c,0x90,0x7c,0x10,},
{0x00,0x04,0x4a,0x24,0x10,0x48,0xa4,0x40,},
{0x00,0x70,0x8c,0x88,0x54,0x20,0x40,0x38,},
{0x00,0x00,0x00,0x00,0x00,0x10,0x30,0x30,},
{0x00,0x18,0x20,0x20,0x20,0x20,0x10,0x08,},
{0x00,0x20,0x10,0x08,0x08,0x08,0x08,0x30,},
{0x00,0x00,0x54,0x38,0x7c,0x38,0x54,0x00,},
{0x00,0x00,0x10,0x10,0x7c,0x10,0x10,0x00,},
{0x00,0x10,0x30,0x20,0x00,0x00,0x00,0x00,},
{0x00,0x00,0x00,0x00,0x7c,0x00,0x00,0x00,},
{0x00,0x30,0x30,0x00,0x00,0x00,0x00,0x00,},
{0x00,0x00,0x40,0x20,0x10,0x08,0x04,0x00,},
{0x00,0xbc,0x42,0xa2,0x92,0x8a,0x84,0x7a,},
{0x00,0x08,0x08,0x28,0x18,0x08,0x08,0x08,},
{0x00,0x7e,0x80,0x40,0x3c,0x02,0x84,0x78,},
{0x00,0x60,0x90,0x88,0x04,0x3c,0x04,0xfc,},
{0x00,0x02,0x02,0x3e,0x42,0x82,0x82,0x82,},
{0x00,0xf0,0x08,0x04,0x02,0xfc,0x80,0xfe,},
{0x00,0x3c,0x42,0x82,0x84,0xf8,0x80,0x70,},
{0x00,0x80,0x80,0x40,0x20,0x1c,0x02,0xfe,},
{0x00,0x7c,0x82,0x82,0x82,0x7c,0x82,0x7c,},
{0x00,0xe0,0x10,0x08,0x7c,0x82,0x82,0x7c,},
{0x00,0x30,0x30,0x00,0x00,0x30,0x30,0x00,},
{0x00,0x10,0x30,0x20,0x00,0x30,0x30,0x00,},
{0x00,0x08,0x10,0x20,0x40,0x20,0x10,0x08,},
{0x00,0x00,0x00,0x7c,0x00,0x7c,0x00,0x00,},
{0x00,0x20,0x10,0x08,0x04,0x08,0x10,0x20,},
{0x00,0x10,0x00,0x10,0x18,0x04,0x44,0x38,},
{0x00,0x38,0x40,0x9c,0xaa,0x92,0x44,0x38,},
{0x00,0x82,0x82,0x82,0x7e,0x22,0x12,0x0c,},
{0x00,0xfc,0x82,0x84,0xf8,0x84,0x82,0xfc,},
{0x00,0x7e,0x80,0x80,0x40,0x20,0x10,0x0e,},
{0x00,0xfc,0x82,0x82,0x84,0x88,0x90,0xe0,},
{0x00,0xfe,0x80,0x80,0x7c,0x20,0x10,0x0e,},
{0x00,0x80,0x80,0x80,0x78,0x20,0x10,0x0e,},
{0x00,0x7c,0x82,0x82,0x46,0x20,0x10,0x0e,},
{0x00,0x82,0x82,0x82,0xfe,0x82,0x82,0x82,},
{0x00,0xfe,0x10,0x10,0x10,0x10,0x10,0xfe,},
{0x00,0x7c,0x82,0x82,0x44,0x08,0x10,0xe0,},
{0x00,0x82,0x84,0x88,0x90,0xe0,0x90,0x88,},
{0x00,0xfe,0x80,0x80,0x40,0x20,0x10,0x08,},
{0x00,0x82,0x82,0x8a,0x96,0xa2,0xc0,0x80,},
{0x00,0x82,0x86,0x8a,0x92,0xa0,0xc0,0x80,},
{0x00,0x70,0x88,0x84,0x82,0x42,0x22,0x1c,},
{0x00,0x80,0x80,0xf0,0x88,0x84,0x82,0xfc,},
{0x00,0x72,0x8c,0x8c,0x82,0x42,0x22,0x1c,},
{0x00,0x82,0x84,0x88,0xf0,0x88,0x84,0xf8,},
{0x00,0xf0,0x08,0x04,0x38,0x40,0x20,0x1e,},
{0x00,0x08,0x08,0x08,0x08,0x08,0x08,0xfe,},
{0x00,0x7c,0x82,0x82,0x82,0x82,0x82,0x82,},
{0x00,0x06,0x0a,0x12,0x22,0x42,0x82,0x82,},
{0x00,0x12,0x36,0x5a,0x92,0x82,0x82,0x82,},
{0x00,0x82,0x44,0x28,0x10,0x28,0x44,0x82,},
{0x00,0xe0,0x10,0x08,0x14,0x22,0x42,0x42,},
{0x00,0xfe,0x40,0x20,0x10,0x08,0x04,0xfe,},
{0x00,0x38,0x20,0x20,0x20,0x20,0x20,0x38,},
{0x00,0x00,0x04,0x08,0x10,0x20,0x40,0x00,},
{0x00,0x38,0x08,0x08,0x08,0x08,0x08,0x38,},
{0x00,0x00,0x00,0x00,0x00,0x44,0x28,0x10,},
{0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,},
{0x00,0x00,0x00,0x00,0x00,0x08,0x18,0x30,},
{0x00,0x7e,0x82,0x7e,0x02,0x1c,0x00,0x00,},
{0x00,0xfc,0x82,0x84,0xf8,0x80,0x80,0x00,},
{0x00,0x7e,0x80,0x40,0x3e,0x00,0x00,0x00,},
{0x00,0x7e,0x82,0x42,0x3e,0x02,0x02,0x00,},
{0x00,0x38,0x40,0xfc,0x42,0x3c,0x00,0x00,},
{0x00,0x80,0x80,0x70,0x20,0x1e,0x00,0x00,},
{0x00,0x38,0x04,0x7e,0x84,0x78,0x00,0x00,},
{0x00,0x82,0x82,0x84,0xf8,0x80,0x00,0x00,},
{0x00,0xfe,0x08,0x08,0x10,0x00,0x08,0x00,},
{0x00,0x78,0x84,0x82,0x0c,0x00,0x08,0x00,},
{0x00,0x82,0x84,0xf8,0x90,0x88,0x00,0x00,},
{0x00,0x3e,0x40,0x80,0x80,0x80,0x00,0x00,},
{0x00,0x82,0x82,0x42,0x2a,0x14,0x00,0x00,},
{0x00,0x82,0x82,0x84,0xc8,0xb0,0x00,0x00,},
{0x00,0x78,0x84,0x82,0x42,0x3c,0x00,0x00,},
{0x00,0x80,0xf8,0x84,0x82,0xfc,0x00,0x00,},
{0x00,0x02,0x7e,0x82,0x42,0x3c,0x00,0x00,},
{0x00,0x80,0x80,0xc0,0xa0,0x9e,0x00,0x00,},
{0x00,0xf8,0x04,0x18,0x20,0x1e,0x00,0x00,},
{0x00,0x06,0x08,0x10,0x10,0xf8,0x10,0x00,},
{0x00,0x7c,0x82,0x82,0x82,0x82,0x00,0x00,},
{0x00,0x0e,0x12,0x22,0x42,0x82,0x00,0x00,},
{0x00,0x2c,0x52,0x82,0x82,0x82,0x00,0x00,},
{0x00,0x82,0x44,0x38,0x44,0x82,0x00,0x00,},
{0x00,0xe0,0x10,0x08,0x14,0x22,0x00,0x00,},
{0x00,0x3e,0x20,0x10,0x08,0xf8,0x00,0x00,},
{0x00,0x18,0x20,0x20,0x40,0x20,0x20,0x18,},
{0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,},
{0x00,0x30,0x08,0x08,0x04,0x08,0x08,0x30,},
{0x00,0x00,0x00,0x00,0x0c,0x92,0x60,0x00,},
{0x00,0x00,0xd1,0x8a,0xca,0x92,0xc9,0x00,},
{0x00,0x3e,0x40,0xf8,0x40,0xfc,0x20,0x1e,},
{0x00,0x00,0x00,0x99,0x91,0x9b,0x8b,0x9b,},
{0x00,0x60,0x30,0x18,0x00,0x00,0x00,0x00,},
{0x00,0x60,0x90,0x10,0x38,0x10,0x12,0x0c,},
{0x00,0xcc,0x66,0x33,0x00,0x00,0x00,0x00,},
{0x00,0x54,0x00,0x00,0x00,0x00,0x00,0x00,},
{0x00,0x10,0x10,0x10,0x10,0x38,0x7c,0x10,},
{0x00,0x10,0x7c,0x10,0x10,0x10,0x7c,0x10,},
{0x00,0x00,0x00,0x00,0x00,0x00,0x28,0x10,},
{0x00,0x8a,0x55,0x2a,0x10,0x48,0xa4,0x42,},
{0x00,0xfc,0x02,0x7c,0x80,0x7e,0x10,0x38,},
{0x00,0x10,0x20,0x40,0x20,0x10,0x00,0x00,},
{0x00,0x78,0x44,0x44,0x74,0x44,0x44,0x78,},
{0x00,0x00,0x00,0x8a,0x8a,0x9a,0x92,0x92,},
{0x00,0xfe,0x80,0x7c,0x02,0xfe,0x10,0x38,},
{0x00,0x00,0x00,0x8b,0x89,0x9b,0x91,0x93,},
{0x00,0x00,0x00,0x89,0x89,0x9b,0x92,0x92,},
{0x00,0x00,0x00,0x00,0x00,0x0c,0x18,0x30,},
{0x00,0x00,0x00,0x00,0x00,0x60,0x30,0x18,},
{0x00,0x00,0x00,0x00,0x00,0x24,0x48,0x90,},
{0x00,0x00,0x00,0x00,0x00,0x48,0x24,0x12,},
{0x00,0x00,0x38,0x7c,0x7c,0x7c,0x38,0x00,},
{0x00,0x00,0x00,0x00,0xfe,0x00,0x00,0x00,},
{0x00,0x00,0x00,0x00,0xff,0x00,0x00,0x00,},
{0x00,0x00,0x00,0x00,0x00,0x08,0x54,0x20,},
{0x00,0x00,0x00,0x00,0x00,0x4a,0x4e,0xea,},
{0x00,0xfc,0x02,0x7c,0x80,0x7e,0x10,0x38,},
{0x00,0x10,0x08,0x04,0x08,0x10,0x00,0x00,},
{0x00,0x6e,0x90,0x90,0x9c,0x92,0x92,0x6c,},
{0x00,0x00,0x00,0x9a,0x8a,0x9a,0x91,0x9b,},
{0x00,0xfe,0x80,0x78,0x04,0xfc,0x10,0x38,},
{0x00,0x38,0x10,0x38,0x44,0xee,0x00,0x44,},
{0x00,0x00,0x00,0x99,0x9a,0x9a,0x92,0x91,},
{0x00,0x20,0x20,0x20,0x10,0x10,0x00,0x10,},
{0x00,0x10,0x7c,0x80,0x40,0x20,0x1e,0x08,},
{0x00,0x7e,0x20,0x10,0x7c,0x20,0x24,0x18,},
{0x00,0x00,0x54,0x28,0x44,0x28,0x54,0x00,},
{0x38,0x10,0x7c,0x10,0xfe,0x10,0x28,0xc6,},
{0x00,0x10,0x10,0x10,0x00,0x10,0x10,0x10,},
{0x00,0xf0,0x0c,0x32,0x4c,0xb0,0x40,0x3c,},
{0x00,0x00,0x00,0x00,0x00,0x00,0x6c,0x6c,},
{0x00,0x38,0x44,0xba,0xa2,0xba,0x44,0x38,},
{0x00,0x00,0x00,0x00,0x38,0x38,0x08,0x30,},
{0x00,0x00,0x12,0x24,0x48,0x24,0x12,0x00,},
{0x00,0x00,0x04,0x04,0x7c,0x00,0x00,0x00,},
{0x00,0x7c,0xaa,0xaa,0xb2,0xaa,0x92,0x7c,},
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,},
{0x00,0x00,0x00,0x93,0x91,0x93,0x8a,0x9b,},
{0x00,0x00,0x00,0x00,0x30,0x48,0x48,0x30,},
{0x00,0x7c,0x00,0x10,0x10,0x7c,0x10,0x10,},
{0x00,0x00,0x00,0x3c,0x10,0x08,0x24,0x18,},
{0x00,0x00,0x00,0x30,0x08,0x18,0x08,0x38,},
{0x00,0x00,0x00,0x00,0x00,0x20,0x10,0x08,},
{0x00,0x80,0x80,0x84,0xf8,0x88,0x88,0x00,},
{0x00,0xe8,0x28,0x28,0x68,0xa8,0xa8,0x7c,},
{0x00,0x00,0x00,0x00,0x30,0x30,0x00,0x00,},
{0x00,0x18,0x08,0x00,0x00,0x00,0x00,0x00,},
{0x00,0x00,0x00,0x38,0x10,0x10,0x30,0x10,},
{0x00,0x00,0x00,0x10,0x28,0x28,0x28,0x10,},
{0x00,0x00,0x48,0x24,0x12,0x24,0x48,0x00,},
{0x00,0x82,0x4e,0x2a,0x10,0x48,0x44,0x42,},
{0x00,0x86,0x44,0x22,0x16,0x48,0x44,0x42,},
{0x00,0x82,0x4e,0xea,0x50,0xc8,0x44,0xc2,},
{0x00,0x38,0x44,0x40,0x30,0x10,0x00,0x10,},
{0x00,0x82,0x7e,0x22,0x12,0x0c,0x04,0x08,},
{0x00,0x82,0x7e,0x22,0x12,0x0c,0x04,0x02,},
{0x00,0x82,0x7e,0x22,0x12,0x0c,0x0a,0x04,},
{0x00,0x82,0x7e,0x22,0x12,0x0c,0x14,0x0a,},
{0x00,0x82,0x7e,0x22,0x12,0x0c,0x00,0x12,},
{0x00,0x82,0x7e,0x22,0x12,0x0c,0x12,0x0c,},
{0x00,0x8e,0xf8,0x48,0x4c,0x28,0x28,0x1e,},
{0x00,0x18,0x08,0x7e,0x80,0x40,0x20,0x1e,},
{0x00,0xfe,0x40,0x38,0x10,0x0e,0x04,0x08,},
{0x00,0xfe,0x40,0x38,0x10,0x0e,0x04,0x02,},
{0x00,0xfe,0x40,0x38,0x10,0x0e,0x0a,0x04,},
{0x00,0xfe,0x40,0x38,0x10,0x0e,0x00,0x12,},
{0x00,0xfe,0x10,0x10,0x10,0xfe,0x08,0x10,},
{0x00,0xfe,0x10,0x10,0x10,0xfe,0x10,0x08,},
{0x00,0xfe,0x10,0x10,0x10,0xfe,0x28,0x10,},
{0x00,0xfe,0x10,0x10,0x10,0xfe,0x00,0x44,},
{0x00,0x78,0x44,0x44,0x74,0x44,0x44,0x78,},
{0x00,0x82,0x86,0x8a,0x92,0xa0,0xc0,0x9e,},
{0x00,0x78,0x84,0x82,0x42,0x3c,0x08,0x10,},
{0x00,0x78,0x84,0x82,0x42,0x3c,0x08,0x04,},
{0x00,0x78,0x84,0x82,0x42,0x3c,0x14,0x08,},
{0x00,0x78,0x84,0x82,0x42,0x3c,0x14,0x0a,},
{0x00,0x78,0x84,0x82,0x42,0x3c,0x00,0x12,},
{0x00,0x00,0x44,0x28,0x10,0x28,0x44,0x00,},
{0x00,0xb0,0x48,0xa4,0x92,0x4a,0x24,0x1a,},
{0x00,0x7c,0x82,0x82,0x82,0x82,0x10,0x20,},
{0x00,0x7c,0x82,0x82,0x82,0x82,0x10,0x08,},
{0x00,0x7c,0x82,0x82,0x82,0x82,0x28,0x10,},
{0x00,0x7c,0x82,0x82,0x82,0x82,0x00,0x44,},
{0x00,0xe0,0x10,0x18,0x24,0x42,0x52,0x08,},
{0x00,0xfc,0x40,0x70,0x48,0x70,0x40,0xfc,},
{0x00,0xb8,0x84,0x84,0x88,0x90,0x48,0x30,},
{0x00,0x7e,0x82,0x7e,0x02,0x1c,0x08,0x10,},
{0x00,0x7e,0x82,0x7e,0x02,0x1c,0x08,0x04,},
{0x00,0x7e,0x82,0x7e,0x02,0x1c,0x14,0x08,},
{0x00,0x7e,0x82,0x7e,0x02,0x1c,0x28,0x14,},
{0x00,0x7e,0x82,0x7e,0x02,0x1c,0x00,0x24,},
{0x00,0x7e,0x82,0x7e,0x02,0x1c,0x24,0x18,},
{0x00,0x7c,0x90,0x7c,0x12,0x6c,0x00,0x00,},
{0x00,0x18,0x08,0x7e,0x80,0x40,0x20,0x1e,},
{0x00,0x38,0x40,0xfc,0x42,0x3c,0x10,0x20,},
{0x00,0x38,0x40,0xfc,0x42,0x3c,0x08,0x04,},
{0x00,0x38,0x40,0xfc,0x42,0x3c,0x28,0x10,},
{0x00,0x38,0x40,0xfc,0x42,0x3c,0x00,0x24,},
{0x00,0xfe,0x08,0x08,0x10,0x00,0x08,0x10,},
{0x00,0xfe,0x08,0x08,0x10,0x00,0x08,0x04,},
{0x00,0xfe,0x08,0x08,0x10,0x00,0x28,0x10,},
{0x00,0xfe,0x08,0x08,0x10,0x00,0x00,0x48,},
{0x00,0x7c,0x82,0x82,0x7c,0x28,0x4c,0x32,},
{0x00,0x82,0x82,0x84,0xc8,0xb0,0x00,0xf0,},
{0x00,0x78,0x84,0x82,0x42,0x3c,0x10,0x20,},
{0x00,0x78,0x84,0x82,0x42,0x3c,0x08,0x04,},
{0x00,0x78,0x84,0x82,0x42,0x3c,0x14,0x08,},
{0x00,0x78,0x84,0x82,0x42,0x3c,0x28,0x14,},
{0x00,0x78,0x84,0x82,0x42,0x3c,0x00,0x12,},
{0x00,0x00,0x10,0x00,0x7c,0x00,0x10,0x00,},
{0x00,0xf8,0xe4,0x9a,0x46,0x3e,0x00,0x00,},
{0x00,0x7c,0x82,0x82,0x82,0x82,0x10,0x20,},
{0x00,0x7c,0x82,0x82,0x82,0x82,0x10,0x08,},
{0x00,0x7c,0x82,0x82,0x82,0x82,0x28,0x10,},
{0x00,0x7c,0x82,0x82,0x82,0x82,0x00,0x44,},
{0x00,0xe0,0x10,0x18,0x24,0x42,0x10,0x08,},
{0x00,0xc0,0x5c,0x62,0x62,0x62,0x5c,0xc0,},
{0x00,0x00,0x00,0xdb,0x89,0xdb,0x52,0xdb,},
};

const u8 JGLCONSOLEFONT2[256][8] = {
{0x00,0x00,0x00,0x40,0x80,0x80,0x80,0x40,},
{0x00,0x00,0x00,0x80,0x80,0x80,0x80,0x80,},
{0x00,0x00,0x00,0xc0,0x80,0xc0,0x40,0xc0,},
{0x00,0x00,0x00,0xc0,0x40,0xc0,0x40,0xc0,},
{0x00,0x00,0x00,0x40,0x40,0xc0,0x80,0x80,},
{0x00,0x00,0x00,0xc0,0x40,0xc0,0x80,0xc0,},
{0x00,0x00,0x00,0xc0,0xc0,0xc0,0x80,0x80,},
{0x00,0x00,0x00,0x80,0x80,0x80,0x40,0xc0,},
{0x00,0x00,0x00,0x40,0x80,0x40,0x80,0x40,},
{0x00,0x00,0x00,0x40,0x40,0xc0,0xc0,0xc0,},
{0x00,0x00,0x00,0x90,0xa0,0xa0,0xa0,0x90,},
{0x00,0x00,0x00,0x90,0x90,0x90,0x90,0x90,},
{0x00,0x00,0x00,0xb0,0xa0,0xb0,0x90,0xb0,},
{0x00,0x00,0x00,0xb0,0x90,0xb0,0x90,0xb0,},
{0x00,0x00,0x00,0x90,0x90,0xb0,0xa0,0xa0,},
{0x00,0x00,0x00,0xb0,0x90,0xb0,0xa0,0xb0,},
{0x00,0x00,0x00,0x98,0x98,0x98,0x90,0x90,},
{0x00,0x00,0x00,0x90,0x90,0x90,0x88,0x98,},
{0x00,0x00,0x00,0x98,0x98,0x80,0x98,0x98,},
{0x00,0x00,0x00,0x88,0x88,0x98,0x98,0x98,},
{0x00,0x00,0x00,0xc8,0x90,0xd0,0x50,0xc8,},
{0x00,0x00,0x00,0xd0,0x90,0xd0,0x50,0xd0,},
{0x00,0x00,0x00,0xd8,0x90,0xd8,0x48,0xd8,},
{0x00,0x00,0x00,0xd8,0x88,0xd8,0x48,0xd8,},
{0x00,0x00,0x00,0xc8,0x88,0xd8,0x50,0xd0,},
{0x00,0x00,0x00,0xd8,0x88,0xd8,0x50,0xd8,},
{0x00,0x00,0x00,0xd8,0x98,0xd8,0x50,0xd0,},
{0x00,0x00,0x00,0xd0,0x90,0xd0,0x48,0xd8,},
{0x00,0x00,0x00,0xc8,0x90,0xc8,0x50,0xc8,},
{0x00,0x00,0x00,0xc8,0x88,0xd8,0x58,0xd8,},
{0x00,0x00,0x00,0xc8,0x50,0xd0,0x50,0xc8,},
{0x00,0x00,0x00,0xd0,0x50,0xd0,0x50,0xd0,},
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,},
{0x00,0x10,0x00,0x10,0x10,0x20,0x20,0x20,},
{0x00,0x00,0x00,0x00,0x00,0x28,0x6c,0x6c,},
{0x00,0x44,0xfe,0x44,0x44,0x44,0xfe,0x44,},
{0x00,0x10,0x7c,0x12,0x7c,0x90,0x7c,0x10,},
{0x00,0x04,0x4a,0x24,0x10,0x48,0xa4,0x40,},
{0x00,0x70,0x8c,0x88,0x54,0x20,0x40,0x38,},
{0x00,0x00,0x00,0x00,0x00,0x10,0x30,0x30,},
{0x00,0x18,0x20,0x20,0x20,0x20,0x10,0x08,},
{0x00,0x20,0x10,0x08,0x08,0x08,0x08,0x30,},
{0x00,0x00,0x54,0x38,0x7c,0x38,0x54,0x00,},
{0x00,0x00,0x10,0x10,0x7c,0x10,0x10,0x00,},
{0x00,0x10,0x30,0x20,0x00,0x00,0x00,0x00,},
{0x00,0x00,0x00,0x00,0x7c,0x00,0x00,0x00,},
{0x00,0x30,0x30,0x00,0x00,0x00,0x00,0x00,},
{0x00,0x00,0x40,0x20,0x10,0x08,0x04,0x00,},
{0x00,0x7c,0xfe,0xb2,0x9a,0x8e,0xfe,0x7c,},
{0x00,0x08,0x08,0x08,0x08,0x38,0x38,0x18,},
{0x00,0xfe,0xfe,0xe0,0x7c,0x0e,0xfe,0x7c,},
{0x00,0x7c,0xfe,0x86,0x1e,0x06,0xfe,0xfe,},
{0x00,0x06,0x06,0xfe,0xfe,0xc6,0xc6,0xc6,},
{0x00,0xfe,0xfe,0x06,0xfe,0xc0,0xfe,0xfe,},
{0x00,0x7c,0xfe,0xc6,0xfc,0xc0,0xfe,0x7e,},
{0x00,0x30,0x30,0x30,0x18,0x0c,0xfe,0xfe,},
{0x00,0x7c,0xfe,0xc6,0x7c,0xc6,0xfe,0x7c,},
{0x00,0x30,0x18,0x7c,0xfe,0xc6,0xfe,0x7c,},
{0x00,0x30,0x30,0x00,0x00,0x30,0x30,0x00,},
{0x00,0x10,0x30,0x20,0x00,0x30,0x30,0x00,},
{0x00,0x08,0x10,0x20,0x40,0x20,0x10,0x08,},
{0x00,0x00,0x00,0x7c,0x00,0x7c,0x00,0x00,},
{0x00,0x20,0x10,0x08,0x04,0x08,0x10,0x20,},
{0x00,0x10,0x00,0x10,0x18,0x04,0x44,0x38,},
{0x00,0x38,0x40,0x9c,0xaa,0x92,0x44,0x38,},
{0x00,0x82,0x82,0xfe,0xfe,0x82,0xfe,0x7c,},
{0x00,0xfc,0xfe,0x84,0xf8,0x84,0xfe,0xfc,},
{0x00,0x7e,0xfe,0x80,0x80,0x80,0xfe,0x7e,},
{0x00,0xfc,0xfe,0x82,0x82,0x82,0xfe,0xfc,},
{0x00,0x7e,0xfe,0x80,0xfc,0x80,0xfe,0x7e,},
{0x00,0x80,0x80,0x80,0xf8,0x80,0xfe,0x7e,},
{0x00,0x7c,0xfe,0x82,0x8e,0x80,0xfe,0x7e,},
{0x00,0x82,0x82,0xfe,0xfe,0x82,0x82,0x82,},
{0x00,0xfe,0xfe,0x10,0x10,0x10,0xfe,0xfe,},
{0x00,0x7c,0xfe,0x82,0x02,0x02,0xfe,0xfc,},
{0x00,0x86,0x8c,0x98,0x90,0xf0,0x98,0x8c,},
{0x00,0xfe,0xfe,0x80,0x80,0x80,0x80,0x80,},
{0x00,0x82,0x82,0x82,0x92,0xba,0xee,0xc6,},
{0x00,0x86,0x8e,0x9a,0xb2,0xe2,0xc2,0x82,},
{0x00,0x7c,0xfe,0x82,0x82,0x82,0xfe,0x7c,},
{0x00,0x80,0x80,0xfc,0xfe,0x82,0xfe,0xfc,},
{0x00,0x7a,0xfc,0x8a,0x82,0x82,0xfe,0x7c,},
{0x00,0x82,0x86,0xfc,0xfe,0x82,0xfe,0xfc,},
{0x00,0xfc,0xfe,0x02,0x7c,0x80,0xfe,0x7e,},
{0x00,0x10,0x10,0x10,0x10,0x10,0xfe,0xfe,},
{0x00,0x7c,0xfe,0x82,0x82,0x82,0x82,0x82,},
{0x00,0x38,0x6c,0xc6,0x82,0x82,0x82,0x82,},
{0x00,0x28,0x7c,0xd6,0x92,0x92,0x82,0x82,},
{0x00,0xc6,0x6c,0x38,0x38,0x6c,0xc6,0x82,},
{0x00,0x10,0x10,0x10,0x38,0x6c,0xc6,0x82,},
{0x00,0xfe,0xfe,0x60,0x38,0x0c,0xfe,0xfe,},
{0x00,0x38,0x38,0x20,0x20,0x20,0x38,0x38,},
{0x00,0x06,0x0c,0x18,0x30,0x60,0xc0,0x80,},
{0x00,0x38,0x38,0x08,0x08,0x08,0x38,0x38,},
{0x00,0x00,0x00,0x00,0x44,0x6c,0x38,0x10,},
{0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,},
{0x00,0x00,0x00,0x00,0x08,0x18,0x38,0x70,},
{0x00,0x7e,0xfe,0x82,0x7e,0x02,0x3c,0x00,},
{0x00,0xfc,0xfe,0x82,0x82,0xfc,0x80,0x80,},
{0x00,0x7e,0xfe,0x80,0x80,0x7e,0x00,0x00,},
{0x00,0x7e,0xfe,0x82,0x82,0x7e,0x02,0x02,},
{0x00,0x7e,0xfe,0x80,0xfe,0x82,0x7c,0x00,},
{0x00,0x80,0x80,0xf8,0x80,0xfe,0x7e,0x00,},
{0x00,0xfc,0xfe,0x02,0x7e,0x82,0x7c,0x00,},
{0x00,0x82,0x82,0xfe,0xfc,0x80,0x80,0x80,},
{0x00,0x38,0x38,0x10,0x10,0x10,0x00,0x10,},
{0x00,0x78,0xfc,0x84,0x04,0x04,0x00,0x04,},
{0x00,0x86,0x8c,0xf8,0xf0,0x98,0x80,0x80,},
{0x00,0x38,0x78,0x40,0x40,0x40,0x40,0x40,},
{0x00,0x82,0x82,0xfe,0xfe,0x6c,0x00,0x00,},
{0x00,0x82,0x82,0xc2,0xfe,0xbc,0x00,0x00,},
{0x00,0x7c,0xfe,0x82,0x82,0x7c,0x00,0x00,},
{0x00,0x80,0xfc,0xfe,0x82,0xfc,0x00,0x00,},
{0x00,0x02,0x7e,0xfe,0x82,0x7e,0x00,0x00,},
{0x00,0x80,0x80,0xc0,0xfe,0xbe,0x00,0x00,},
{0x00,0xfc,0xfe,0x3c,0x60,0x3e,0x00,0x00,},
{0x00,0x1c,0x3c,0x20,0x20,0xf8,0x20,0x20,},
{0x00,0x7c,0xfe,0x82,0x82,0x82,0x00,0x00,},
{0x00,0x10,0x38,0x6c,0xc6,0x82,0x00,0x00,},
{0x00,0x7c,0xd6,0x92,0x82,0x82,0x00,0x00,},
{0x00,0xc6,0x6c,0x7c,0xc6,0x82,0x00,0x00,},
{0x00,0x10,0x10,0x7c,0xfe,0x82,0x00,0x00,},
{0x00,0x7e,0x7e,0x30,0x08,0xfc,0x00,0x00,},
{0x00,0x18,0x38,0x20,0x40,0x20,0x38,0x18,},
{0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,},
{0x00,0x30,0x38,0x08,0x04,0x08,0x38,0x30,},
{0x00,0x00,0x00,0x00,0x0c,0x92,0x60,0x00,},
{0x00,0x00,0xd1,0x8a,0xca,0x92,0xc9,0x00,},
{0x00,0x3e,0x40,0xf8,0x40,0xfc,0x20,0x1e,},
{0x00,0x00,0x00,0x99,0x91,0x9b,0x8b,0x9b,},
{0x00,0x60,0x30,0x18,0x00,0x00,0x00,0x00,},
{0x00,0x60,0x90,0x10,0x38,0x10,0x12,0x0c,},
{0x00,0xcc,0x66,0x33,0x00,0x00,0x00,0x00,},
{0x00,0x54,0x00,0x00,0x00,0x00,0x00,0x00,},
{0x00,0x10,0x10,0x10,0x10,0x38,0x7c,0x10,},
{0x00,0x10,0x7c,0x10,0x10,0x10,0x7c,0x10,},
{0x00,0x00,0x00,0x00,0x00,0x00,0x28,0x10,},
{0x00,0x8a,0x55,0x2a,0x10,0x48,0xa4,0x42,},
{0x00,0xfc,0x02,0x7c,0x80,0x7e,0x10,0x38,},
{0x00,0x10,0x20,0x40,0x20,0x10,0x00,0x00,},
{0x00,0x78,0x44,0x44,0x74,0x44,0x44,0x78,},
{0x00,0x00,0x00,0x8a,0x8a,0x9a,0x92,0x92,},
{0x00,0xfe,0x80,0x7c,0x02,0xfe,0x10,0x38,},
{0x00,0x00,0x00,0x8b,0x89,0x9b,0x91,0x93,},
{0x00,0x00,0x00,0x89,0x89,0x9b,0x92,0x92,},
{0x00,0x00,0x00,0x00,0x00,0x0c,0x18,0x30,},
{0x00,0x00,0x00,0x00,0x00,0x60,0x30,0x18,},
{0x00,0x00,0x00,0x00,0x00,0x24,0x48,0x90,},
{0x00,0x00,0x00,0x00,0x00,0x48,0x24,0x12,},
{0x00,0x00,0x38,0x7c,0x7c,0x7c,0x38,0x00,},
{0x00,0x00,0x00,0x00,0xfe,0x00,0x00,0x00,},
{0x00,0x00,0x00,0x00,0xff,0x00,0x00,0x00,},
{0x00,0x00,0x00,0x00,0x00,0x08,0x54,0x20,},
{0x00,0x00,0x00,0x00,0x00,0x4a,0x4e,0xea,},
{0x00,0xfc,0x02,0x7c,0x80,0x7e,0x10,0x38,},
{0x00,0x10,0x08,0x04,0x08,0x10,0x00,0x00,},
{0x00,0x6e,0x90,0x90,0x9c,0x92,0x92,0x6c,},
{0x00,0x00,0x00,0x9a,0x8a,0x9a,0x91,0x9b,},
{0x00,0xfe,0x80,0x78,0x04,0xfc,0x10,0x38,},
{0x00,0x38,0x10,0x38,0x44,0xee,0x00,0x44,},
{0x00,0x00,0x00,0x99,0x9a,0x9a,0x92,0x91,},
{0x00,0x20,0x20,0x20,0x10,0x10,0x00,0x10,},
{0x00,0x10,0x7c,0x80,0x40,0x20,0x1e,0x08,},
{0x00,0x7e,0x20,0x10,0x7c,0x20,0x24,0x18,},
{0x00,0x00,0x54,0x28,0x44,0x28,0x54,0x00,},
{0x38,0x10,0x7c,0x10,0xfe,0x10,0x28,0xc6,},
{0x00,0x10,0x10,0x10,0x00,0x10,0x10,0x10,},
{0x00,0xf0,0x0c,0x32,0x4c,0xb0,0x40,0x3c,},
{0x00,0x00,0x00,0x00,0x00,0x00,0x6c,0x6c,},
{0x00,0x38,0x44,0xba,0xa2,0xba,0x44,0x38,},
{0x00,0x00,0x00,0x00,0x38,0x38,0x08,0x30,},
{0x00,0x00,0x12,0x24,0x48,0x24,0x12,0x00,},
{0x00,0x00,0x04,0x04,0x7c,0x00,0x00,0x00,},
{0x00,0x7c,0xaa,0xaa,0xb2,0xaa,0x92,0x7c,},
{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,},
{0x00,0x00,0x00,0x93,0x91,0x93,0x8a,0x9b,},
{0x00,0x00,0x00,0x00,0x30,0x48,0x48,0x30,},
{0x00,0x7c,0x00,0x10,0x10,0x7c,0x10,0x10,},
{0x00,0x00,0x00,0x3c,0x10,0x08,0x24,0x18,},
{0x00,0x00,0x00,0x30,0x08,0x18,0x08,0x38,},
{0x00,0x00,0x00,0x00,0x00,0x20,0x10,0x08,},
{0x00,0x80,0x80,0x84,0xf8,0x88,0x88,0x00,},
{0x00,0xe8,0x28,0x28,0x68,0xa8,0xa8,0x7c,},
{0x00,0x00,0x00,0x00,0x30,0x30,0x00,0x00,},
{0x00,0x18,0x08,0x00,0x00,0x00,0x00,0x00,},
{0x00,0x00,0x00,0x38,0x10,0x10,0x30,0x10,},
{0x00,0x00,0x00,0x10,0x28,0x28,0x28,0x10,},
{0x00,0x00,0x48,0x24,0x12,0x24,0x48,0x00,},
{0x00,0x82,0x4e,0x2a,0x10,0x48,0x44,0x42,},
{0x00,0x86,0x44,0x22,0x16,0x48,0x44,0x42,},
{0x00,0x82,0x4e,0xea,0x50,0xc8,0x44,0xc2,},
{0x00,0x38,0x44,0x40,0x30,0x10,0x00,0x10,},
{0x00,0x82,0xfe,0xfe,0x82,0x7c,0x10,0x20,},
{0x00,0x82,0xfe,0xfe,0x82,0x7c,0x10,0x08,},
{0x00,0x82,0xfe,0xfe,0x82,0x7c,0x28,0x10,},
{0x00,0x82,0xfe,0xfe,0x82,0x7c,0x48,0x34,},
{0x00,0x82,0xfe,0xfe,0x82,0x7c,0x00,0x44,},
{0x00,0x82,0xfe,0xfe,0x82,0x7c,0x28,0x38,},
{0x00,0x8e,0xf8,0x48,0x4c,0x28,0x28,0x1e,},
{0x00,0x18,0x08,0x7e,0x80,0x40,0x20,0x1e,},
{0x00,0x7e,0x80,0xf8,0x80,0x7e,0x04,0x08,},
{0x00,0x7e,0x80,0xf8,0x80,0x7e,0x04,0x02,},
{0x00,0x7e,0x80,0xf8,0x80,0x7e,0x0a,0x04,},
{0x00,0x7e,0x80,0xf8,0x80,0x7e,0x00,0x12,},
{0x00,0xfe,0x10,0x10,0x10,0xfe,0x08,0x10,},
{0x00,0xfe,0x10,0x10,0x10,0xfe,0x10,0x08,},
{0x00,0xfe,0x10,0x10,0x10,0xfe,0x28,0x10,},
{0x00,0xfe,0x10,0x10,0x10,0xfe,0x00,0x44,},
{0x00,0x78,0x44,0x44,0x74,0x44,0x44,0x78,},
{0x00,0x86,0x8e,0x9a,0xb2,0xe2,0xc2,0xba,},
{0x00,0x7c,0x82,0x82,0x82,0x7c,0x10,0x20,},
{0x00,0x7c,0x82,0x82,0x82,0x7c,0x10,0x08,},
{0x00,0x7c,0x82,0x82,0x82,0x7c,0x28,0x10,},
{0x00,0x7c,0x82,0x82,0x82,0x7c,0x48,0x34,},
{0x00,0x7c,0x82,0x82,0x82,0x7c,0x00,0x44,},
{0x00,0x00,0x44,0x28,0x10,0x28,0x44,0x00,},
{0x00,0xb0,0x48,0xa4,0x92,0x4a,0x24,0x1a,},
{0x00,0x7c,0x82,0x82,0x82,0x82,0x10,0x20,},
{0x00,0x7c,0x82,0x82,0x82,0x82,0x10,0x08,},
{0x00,0x7c,0x82,0x82,0x82,0x82,0x28,0x10,},
{0x00,0x7c,0x82,0x82,0x82,0x82,0x00,0x44,},
{0x00,0xe0,0x10,0x18,0x24,0x42,0x52,0x08,},
{0x00,0xfc,0x40,0x70,0x48,0x70,0x40,0xfc,},
{0x00,0xb8,0x84,0x84,0x88,0x90,0x48,0x30,},
{0x00,0x7e,0x82,0x7e,0x02,0x1c,0x08,0x10,},
{0x00,0x7e,0x82,0x7e,0x02,0x1c,0x08,0x04,},
{0x00,0x7e,0x82,0x7e,0x02,0x1c,0x14,0x08,},
{0x00,0x7e,0x82,0x7e,0x02,0x1c,0x28,0x14,},
{0x00,0x7e,0x82,0x7e,0x02,0x1c,0x00,0x24,},
{0x00,0x7e,0x82,0x7e,0x02,0x1c,0x24,0x18,},
{0x00,0x7c,0x90,0x7c,0x12,0x6c,0x00,0x00,},
{0x00,0x18,0x08,0x7e,0x80,0x40,0x20,0x1e,},
{0x00,0x7e,0x80,0xfe,0x82,0x7c,0x10,0x20,},
{0x00,0x7e,0x80,0xfe,0x82,0x7c,0x08,0x04,},
{0x00,0x7e,0x80,0xfe,0x82,0x7c,0x28,0x10,},
{0x00,0x7e,0x80,0xfe,0x82,0x7c,0x00,0x24,},
{0x00,0x38,0x38,0x10,0x10,0x00,0x10,0x20,},
{0x00,0x38,0x38,0x10,0x10,0x00,0x10,0x08,},
{0x00,0x38,0x38,0x10,0x10,0x00,0x28,0x10,},
{0x00,0x38,0x38,0x10,0x10,0x00,0x00,0x44,},
{0x00,0x7c,0x82,0x82,0x7c,0x28,0x4c,0x32,},
{0x00,0x82,0x82,0xc2,0xfe,0xbc,0x00,0x7c,},
{0x00,0x7c,0x82,0x82,0x82,0x7c,0x10,0x20,},
{0x00,0x7c,0x82,0x82,0x82,0x7c,0x10,0x08,},
{0x00,0x7c,0x82,0x82,0x82,0x7c,0x28,0x10,},
{0x00,0x7c,0x82,0x82,0x82,0x7c,0x48,0x34,},
{0x00,0x7c,0x82,0x82,0x82,0x7c,0x00,0x44,},
{0x00,0x00,0x10,0x00,0x7c,0x00,0x10,0x00,},
{0x00,0xf8,0xe4,0x9a,0x46,0x3e,0x00,0x00,},
{0x00,0x7c,0x82,0x82,0x82,0x82,0x10,0x20,},
{0x00,0x7c,0x82,0x82,0x82,0x82,0x10,0x08,},
{0x00,0x7c,0x82,0x82,0x82,0x82,0x28,0x10,},
{0x00,0x7c,0x82,0x82,0x82,0x82,0x00,0x44,},
{0x00,0xe0,0x10,0x18,0x24,0x42,0x10,0x08,},
{0x00,0xc0,0x5c,0x62,0x62,0x62,0x5c,0xc0,},
{0x00,0x00,0x00,0xdb,0x89,0xdb,0x52,0xdb,},
};

#endif  // _JGLCONSOLEFONT_INCLUDED
