{- This module was generated from data in the Kate syntax
   highlighting file cpp.xml, version 1.9, by Alex Turbov (i.zaufi@gmail.com) -}

module Text.Highlighting.Kate.Syntax.Cpp
          (highlight, parseExpression, syntaxName, syntaxExtensions)
where
import Text.Highlighting.Kate.Types
import Text.Highlighting.Kate.Common
import qualified Text.Highlighting.Kate.Syntax.Isocpp
import Text.ParserCombinators.Parsec hiding (State)
import Control.Monad.State
import Data.Char (isSpace)
import qualified Data.Set as Set

-- | Full name of language.
syntaxName :: String
syntaxName = "C++"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.c++;*.cxx;*.cpp;*.cc;*.C;*.h;*.hh;*.H;*.h++;*.hxx;*.hpp;*.hcc;*.moc"

-- | Highlight source code using this syntax definition.
highlight :: String -> [SourceLine]
highlight input = evalState (mapM parseSourceLine $ lines input) startingState

parseSourceLine :: String -> State SyntaxState SourceLine
parseSourceLine = mkParseSourceLine (parseExpression Nothing)

-- | Parse an expression using appropriate local context.
parseExpression :: Maybe (String,String)
                -> KateParser Token
parseExpression mbcontext = do
  (lang,cont) <- maybe currentContext return mbcontext
  result <- parseRules (lang,cont)
  optional $ do eof
                updateState $ \st -> st{ synStPrevChar = '\n' }
                pEndLine
  return result

startingState = SyntaxState {synStContexts = [("C++","Normal")], synStLineNumber = 0, synStPrevChar = '\n', synStPrevNonspace = False, synStContinuation = False, synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

pEndLine = do
  updateState $ \st -> st{ synStPrevNonspace = False }
  context <- currentContext
  contexts <- synStContexts `fmap` getState
  st <- getState
  if length contexts >= 2
    then case context of
      _ | synStContinuation st -> updateState $ \st -> st{ synStContinuation = False }
      ("C++","Normal") -> return ()
      ("C++","DetectQt4Extensions") -> return ()
      ("C++","QtClassMember") -> (popContext) >> pEndLine
      ("C++","DetectNSEnd") -> (popContext) >> pEndLine
      _ -> return ()
    else return ()

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  updateState $ \st -> st { synStPrevChar = last txt
                          , synStPrevNonspace = synStPrevNonspace st || not (all isSpace txt) }
  return (attr, txt)

list_Qt4Macros = Set.fromList $ words $ "emit signals slots foreach forever SIGNAL SLOT qApp Q_DECLARE_TR_FUNCTIONS Q_CLASSINFO Q_DISABLE_COPY Q_EMIT Q_ENUMS Q_FLAGS Q_INTERFACES Q_INVOKABLE Q_OBJECT Q_PROPERTY Q_SIGNAL Q_SIGNALS Q_SLOT Q_SLOTS Q_DECLARE_METATYPE QT_NO_CAST_FROM_BYTEARRAY QT_NO_CAST_FROM_ASCII QT_NO_CAST_TO_ASCII QT_NO_URL_CAST_FROM_STRING QT_USE_QSTRINGBUILDER QBENCHMARK QBENCHMARK_ONCE QCOMPARE QEXPECT_FAIL QFAIL QFETCH QSKIP QTEST QTEST_APPLESS_MAIN QTEST_MAIN QTEST_NOOP_MAIN QVERIFY2 QVERIFY QWARN QAXCLASS QAXFACTORY_BEGIN QAXFACTORY_DEFAULT QAXFACTORY_END QAXFACTORY_EXPORT QAXTYPE QDESIGNER_WIDGET_EXPORT QML_DECLARE_TYPE QML_DECLARE_TYPEINFO QTWEBKIT_VERSION QTWEBKIT_VERSION_CHECK QTWEBKIT_VERSION_STR Q_ARG Q_RETURN_ARG Q_ATOMIC_INT_FETCH_AND_ADD_IS_ALWAYS_NATIVE Q_ATOMIC_INT_FETCH_AND_ADD_IS_NOT_NATIVE Q_ATOMIC_INT_FETCH_AND_ADD_IS_SOMETIMES_NATIVE Q_ATOMIC_INT_FETCH_AND_ADD_IS_WAIT_FREE Q_ATOMIC_INT_FETCH_AND_STORE_IS_ALWAYS_NATIVE Q_ATOMIC_INT_FETCH_AND_STORE_IS_NOT_NATIVE Q_ATOMIC_INT_FETCH_AND_STORE_IS_SOMETIMES_NATIVE Q_ATOMIC_INT_FETCH_AND_STORE_IS_WAIT_FREE Q_ATOMIC_INT_REFERENCE_COUNTING_IS_ALWAYS_NATIVE Q_ATOMIC_INT_REFERENCE_COUNTING_IS_NOT_NATIVE Q_ATOMIC_INT_REFERENCE_COUNTING_IS_SOMETIMES_NATIVE Q_ATOMIC_INT_REFERENCE_COUNTING_IS_WAIT_FREE Q_ATOMIC_INT_TEST_AND_SET_IS_ALWAYS_NATIVE Q_ATOMIC_INT_TEST_AND_SET_IS_NOT_NATIVE Q_ATOMIC_INT_TEST_AND_SET_IS_SOMETIMES_NATIVE Q_ATOMIC_INT_TEST_AND_SET_IS_WAIT_FREE Q_DECLARE_EXTENSION_INTERFACE Q_DECLARE_INTERFACE Q_EXPORT_PLUGIN2 Q_IMPORT_PLUGIN Q_NOREPLY Q_SCRIPT_DECLARE_QMETAOBJECT QWIDGETSIZE_MAX QT3_SUPPORT QT3_SUPPORT_CONSTRUCTOR QT3_SUPPORT_VARIABLE QT3_SUPPORT_WARNINGS QT_ARCH_X86_64 QT_ASCII_CAST_WARN QT_ASCII_CAST_WARN_CONSTRUCTOR QT_BUILD_KEY QT_BUILD_KEY_COMPAT QT_CATCH QT_COMPAT QT_COMPAT_WARNINGS QT_DEBUG QT_DEPRECATED QT_DEPRECATED_CONSTRUCTOR QT_DEPRECATED_VARIABLE QT_EDITION QT_EDITION_ACADEMIC QT_EDITION_CONSOLE QT_EDITION_DESKTOP QT_EDITION_DESKTOPLIGHT QT_EDITION_EDUCATIONAL QT_EDITION_EVALUATION QT_EDITION_OPENSOURCE QT_EDITION_UNIVERSAL QT_ENSURE_STACK_ALIGNED_FOR_SSE QT_FASTCALL QT_FORWARD_DECLARE_CLASS QT_FORWARD_DECLARE_STRUCT QT_HAVE_ARMV6 QT_LARGEFILE_SUPPORT QT_LICENSED_MODULE QT_LINKED_OPENSSL QT_LINUXBASE QT_MAC_USE_COCOA QT_MOC_COMPAT QT_MODULE QT_MODULE_ACTIVEQT QT_MODULE_CORE QT_MODULE_DBUS QT_MODULE_DECLARATIVE QT_MODULE_GRAPHICSVIEW QT_MODULE_GUI QT_MODULE_HELP QT_MODULE_MULTIMEDIA QT_MODULE_NETWORK QT_MODULE_OPENGL QT_MODULE_OPENVG QT_MODULE_QT3SUPPORT QT_MODULE_QT3SUPPORTLIGHT QT_MODULE_SCRIPT QT_MODULE_SCRIPTTOOLS QT_MODULE_SQL QT_MODULE_SVG QT_MODULE_TEST QT_MODULE_XML QT_MODULE_XMLPATTERNS QT_NO_ACCESSIBILITY QT_NO_ANIMATION QT_NO_ARM_EABI QT_NO_BEARERMANAGEMENT QT_NO_BUTTONGROUP QT_NO_CALENDARWIDGET QT_NO_CLIPBOARD QT_NO_CODECS QT_NO_COLORDIALOG QT_NO_COLUMNVIEW QT_NO_COMBOBOX QT_NO_COMPLETER QT_NO_CONCURRENT QT_NO_CONCURRENT_FILTER QT_NO_CONCURRENT_MAP QT_NO_CONTEXTMENU QT_NO_COP QT_NO_CRASHHANDLER QT_NO_CUPS QT_NO_DATAWIDGETMAPPER QT_NO_DATESTRING QT_NO_DATETIMEEDIT QT_NO_DBUS QT_NO_DEBUG QT_NO_DEBUG_STREAM QT_NO_DECLARATIVE QT_NO_DIAL QT_NO_DIRMODEL QT_NO_DOCKWIDGET QT_NO_DRAGANDDROP QT_NO_EGL QT_NO_ERRORMESSAGE QT_NO_EXCEPTIONS QT_NO_FILEDIALOG QT_NO_FILESYSTEMMODEL QT_NO_FONTCOMBOBOX QT_NO_FONTCONFIG QT_NO_FONTDIALOG QT_NO_FPU QT_NO_FSCOMPLETER QT_NO_FTP QT_NO_GETIFADDRS QT_NO_GRAPHICSEFFECT QT_NO_GRAPHICSSVGITEM QT_NO_GRAPHICSVIEW QT_NO_GSTREAMER QT_NO_HOSTINFO QT_NO_HTTP QT_NO_ICD QT_NO_IM QT_NO_IMAGEFORMAT_JPEG QT_NO_IMAGEFORMAT_MNG QT_NO_IMAGEFORMAT_PNG QT_NO_IMAGEFORMAT_TIFF QT_NO_IMAGEFORMAT_XPM QT_NO_INPUTDIALOG QT_NO_ITEMVIEWS QT_NO_LIBRARY QT_NO_LISTVIEW QT_NO_LISTWIDGET QT_NO_LPR QT_NO_MAINWINDOW QT_NO_MDIAREA QT_NO_MENU QT_NO_MENUBAR QT_NO_MITSHM QT_NO_MULTIMEDIA QT_NO_NAS QT_NO_NETWORKDISKCACHE QT_NO_OPENGL QT_NO_OPENVG QT_NO_PAINT_DEBUG QT_NO_PHONON QT_NO_PHONON_EFFECTWIDGET QT_NO_PHONON_PLATFORMPLUGIN QT_NO_PHONON_SEEKSLIDER QT_NO_PHONON_SETTINGSGROUP QT_NO_PHONON_VIDEOPLAYER QT_NO_PHONON_VOLUMEFADEREFFECT QT_NO_PHONON_VOLUMESLIDER QT_NO_PRINTDIALOG QT_NO_PRINTER QT_NO_PRINTPREVIEWDIALOG QT_NO_PRINTPREVIEWWIDGET QT_NO_PROCESS QT_NO_PROGRESSDIALOG QT_NO_PROXYMODEL QT_NO_PULSEAUDIO QT_NO_QDEBUG_MACRO QT_NO_QFUTURE QT_NO_QWARNING_MACRO QT_NO_QWS_CURSOR QT_NO_QWS_DECORATION_STYLED QT_NO_QWS_DECORATION_WINDOWS QT_NO_QWS_DYNAMICSCREENTRANSFORMATION QT_NO_QWS_INPUTMETHODS QT_NO_QWS_MANAGER QT_NO_QWS_MULTIPROCESS QT_NO_QWS_SOUNDSERVER QT_NO_QWS_TRANSFORMED QT_NO_QWS_VNC QT_NO_RAWFONT QT_NO_S60 QT_NO_SCRIPT QT_NO_SCRIPTTOOLS QT_NO_SCROLLAREA QT_NO_SCROLLBAR QT_NO_SESSIONMANAGER QT_NO_SHAPE QT_NO_SHAREDMEMORY QT_NO_SOCKS5 QT_NO_SOFTKEYMANAGER QT_NO_SORTFILTERPROXYMODEL QT_NO_SPINBOX QT_NO_SPLITTER QT_NO_STANDARDITEMMODEL QT_NO_STATEMACHINE QT_NO_STL_WCHAR QT_NO_STRINGLISTMODEL QT_NO_STYLE_CDE QT_NO_STYLE_CLEANLOOKS QT_NO_STYLE_GTK QT_NO_STYLE_PLASTIQUE QT_NO_STYLE_S60 QT_NO_STYLE_STYLESHEET QT_NO_STYLE_WINDOWSCE QT_NO_STYLE_WINDOWSMOBILE QT_NO_STYLE_WINDOWSVISTA QT_NO_STYLE_WINDOWSXP QT_NO_SVG QT_NO_SVGGENERATOR QT_NO_SVGRENDERER QT_NO_SVGWIDGET QT_NO_SXE QT_NO_SYNTAXHIGHLIGHTER QT_NO_SYSTEMSEMAPHORE QT_NO_TABBAR QT_NO_TABDIALOG QT_NO_TABLET QT_NO_TABLEVIEW QT_NO_TABLEWIDGET QT_NO_TABWIDGET QT_NO_TEMPLATE_TEMPLATE_PARAMETERS QT_NO_TEXTBROWSER QT_NO_TEXTCODECPLUGIN QT_NO_TEXTEDIT QT_NO_TEXTODFWRITER QT_NO_TOOLBAR QT_NO_TOOLBOX QT_NO_TOOLBUTTON QT_NO_TRANSLATION_UTF8 QT_NO_TREEVIEW QT_NO_TREEWIDGET QT_NO_UNDOGROUP QT_NO_UNDOSTACK QT_NO_UNDOVIEW QT_NO_WARNINGS QT_NO_WEBKIT QT_NO_WHATSTHIS QT_NO_WIN_ACTIVEQT QT_NO_WIZARD QT_NO_WORKSPACE QT_NO_XCURSOR QT_NO_XFIXES QT_NO_XINERAMA QT_NO_XINPUT QT_NO_XKB QT_NO_XMLPATTERNS QT_NO_XMLSTREAMREADER QT_NO_XMLSTREAMWRITER QT_NO_XRANDR QT_NO_XRENDER QT_NO_XSYNC QT_NO_XVIDEO QT_NO_ZLIB QT_PACKAGEDATE_STR QT_PACKAGE_TAG QT_POINTER_SIZE QT_PREPEND_NAMESPACE QT_PRODUCT_LICENSE QT_PRODUCT_LICENSEE QT_RETHROW QT_STATIC_CONST QT_STATIC_CONST_IMPL QT_STRINGIFY QT_STRINGIFY2 QT_SUPPORTS QT_SYMBIAN_SUPPORTS_ADVANCED_POINTER QT_SYMBIAN_SUPPORTS_SGIMAGE QT_THROW QT_TRANSLATE_NOOP QT_TRANSLATE_NOOP3 QT_TRANSLATE_NOOP3_UTF8 QT_TRANSLATE_NOOP_UTF8 QT_TRAP_THROWING QT_TRID_NOOP QT_TRY QT_TRYCATCH_ERROR QT_TRYCATCH_LEAVING QT_TR_NOOP QT_TR_NOOP_UTF8 QT_USE_MATH_H_FLOATS QT_USE_NAMESPACE QT_VERSION QT_VERSION_CHECK QT_VERSION_STR QT_VISIBILITY_AVAILABLE QT_WA QT_WA_INLINE QT_WIN_CALLBACK QT_USE_NAMESPACE QT_BEGIN_NAMESPACE QT_END_NAMESPACE QT_BEGIN_HEADER QT_END_HEADER Q_ALIGNOF Q_ASSERT Q_ASSERT_X Q_BIG_ENDIAN Q_BROKEN_DEBUG_STREAM Q_BROKEN_TEMPLATE_SPECIALIZATION Q_BYTE_ORDER Q_CANNOT_DELETE_CONSTANT Q_CC_BOR Q_CC_CDS Q_CC_CLANG Q_CC_COMEAU Q_CC_DEC Q_CC_DIAB Q_CC_EDG Q_CC_GCCE Q_CC_GHS Q_CC_GNU Q_CC_HIGHC Q_CC_HP Q_CC_HPACC Q_CC_INTEL Q_CC_KAI Q_CC_MINGW Q_CC_MIPS Q_CC_MSVC Q_CC_MSVC_NET Q_CC_MWERKS Q_CC_NOKIAX86 Q_CC_OC Q_CC_PGI Q_CC_RVCT Q_CC_SUN Q_CC_SYM Q_CC_USLC Q_CC_WAT Q_CC_XLC Q_CHECK_PTR Q_CLEANUP_RESOURCE Q_COMPILER_AUTO_TYPE Q_COMPILER_CLASS_ENUM Q_COMPILER_CONSTEXPR Q_COMPILER_DECLTYPE Q_COMPILER_DEFAULT_DELETE_MEMBERS Q_COMPILER_EXTERN_TEMPLATES Q_COMPILER_INITIALIZER_LISTS Q_COMPILER_LAMBDA Q_COMPILER_MANGLES_RETURN_TYPE Q_COMPILER_RVALUE_REFS Q_COMPILER_UNICODE_STRINGS Q_COMPILER_VARIADIC_TEMPLATES Q_CONSTRUCTOR_FUNCTION Q_CONSTRUCTOR_FUNCTION0 Q_C_CALLBACKS Q_D Q_DECLARE_FLAGS Q_DECLARE_INCOMPATIBLE_FLAGS Q_DECLARE_OPERATORS_FOR_FLAGS Q_DECLARE_PRIVATE Q_DECLARE_PRIVATE_D Q_DECLARE_PUBLIC Q_DECLARE_SHARED Q_DECLARE_SHARED_STL Q_DECLARE_TYPEINFO Q_DECLARE_TYPEINFO_BODY Q_DECL_ALIGN Q_DECL_CONSTEXPR Q_DECL_CONSTRUCTOR_DEPRECATED Q_DECL_DEPRECATED Q_DECL_FINAL Q_DECL_HIDDEN Q_DECL_IMPORT Q_DECL_OVERRIDE Q_DECL_NOEXCEPT Q_DECL_NOTHROW Q_NULLPTR Q_DECL_VARIABLE_DEPRECATED Q_DESTRUCTOR_FUNCTION Q_DESTRUCTOR_FUNCTION0 Q_DISABLE_COPY Q_DUMMY_COMPARISON_OPERATOR Q_FOREACH Q_FOREVER Q_FULL_TEMPLATE_INSTANTIATION Q_FUNC_INFO Q_GLOBAL_STATIC Q_GLOBAL_STATIC_INIT Q_GLOBAL_STATIC_WITH_ARGS Q_GLOBAL_STATIC_WITH_INITIALIZER Q_INIT_RESOURCE Q_INIT_RESOURCE_EXTERN Q_INLINE_TEMPLATE Q_INT64_C Q_LIKELY Q_LITTLE_ENDIAN Q_NO_BOOL_TYPE Q_NO_DATA_RELOCATION Q_NO_DECLARED_NOT_DEFINED Q_NO_DEPRECATED_CONSTRUCTORS Q_NO_EXPLICIT_KEYWORD Q_NO_PACKED_REFERENCE Q_NO_POSIX_SIGNALS Q_NO_TEMPLATE_FRIENDS Q_NO_USING_KEYWORD Q_OF_ELF Q_OS_AIX Q_OS_BSD4 Q_OS_BSDI Q_OS_CYGWIN Q_OS_DARWIN Q_OS_DARWIN32 Q_OS_DARWIN64 Q_OS_DGUX Q_OS_DYNIX Q_OS_FREEBSD Q_OS_HPUX Q_OS_HURD Q_OS_INTEGRITY Q_OS_IRIX Q_OS_LINUX Q_OS_LYNX Q_OS_MAC Q_OS_MAC32 Q_OS_MAC64 Q_OS_MACX Q_OS_MSDOS Q_OS_NACL Q_OS_NETBSD Q_OS_OPENBSD Q_OS_OS2 Q_OS_OS2EMX Q_OS_OSF Q_OS_QNX Q_OS_RELIANT Q_OS_SCO Q_OS_SOLARIS Q_OS_SYMBIAN Q_OS_ULTRIX Q_OS_UNIX Q_OS_UNIXWARE Q_OS_VXWORKS Q_OS_WIN Q_OS_WIN32 Q_OS_WIN64 Q_OS_WINCE Q_OUTOFLINE_TEMPLATE Q_PACKED Q_Q Q_REQUIRED_RESULT Q_SYMBIAN_FIXED_POINTER_CURSORS Q_SYMBIAN_HAS_EXTENDED_BITMAP_TYPE Q_SYMBIAN_SEMITRANSPARENT_BG_SURFACE Q_SYMBIAN_SUPPORTS_FIXNATIVEORIENTATION Q_SYMBIAN_SUPPORTS_MULTIPLE_SCREENS Q_SYMBIAN_SUPPORTS_SURFACES Q_SYMBIAN_TRANSITION_EFFECTS Q_SYMBIAN_WINDOW_SIZE_CACHE Q_TEMPLATEDLL Q_TYPENAME Q_TYPEOF Q_UINT64_C Q_UNLIKELY Q_UNUSED Q_WRONG_SB_CTYPE_MACROS Q_WS_MAC Q_WS_MAC32 Q_WS_MAC64 Q_WS_MACX Q_WS_PM Q_WS_S60 Q_WS_WIN Q_WS_WIN16 Q_WS_WIN32 Q_WS_WIN64 Q_WS_WINCE Q_WS_WINCE_WM Q_WS_X11 Q_COMPLEX_TYPE Q_PRIMITIVE_TYPE Q_STATIC_TYPE Q_MOVABLE_TYPE Q_DUMMY_TYPE"
list_Qt4Classes = Set.fromList $ words $ "QAbstractAnimation QAbstractButton QAbstractEventDispatcher QAbstractExtensionFactory QAbstractExtensionManager QAbstractFileEngine QAbstractFileEngineHandler QAbstractFileEngineIterator QAbstractFontEngine QAbstractFormBuilder QAbstractGraphicsShapeItem QAbstractItemDelegate QAbstractItemModel QAbstractItemView QAbstractListModel QAbstractMessageHandler QAbstractNetworkCache QAbstractPrintDialog QAbstractProxyModel QAbstractScrollArea QAbstractSlider QAbstractSocket QAbstractSpinBox QAbstractState QAbstractTableModel QAbstractTextDocumentLayout QAbstractTransition QAbstractUriResolver QAbstractVideoBuffer QAbstractVideoSurface QAbstractXmlNodeModel QAbstractXmlReceiver QAccessible QAccessibleBridge QAccessibleBridgePlugin QAccessibleEvent QAccessibleInterface QAccessibleObject QAccessiblePlugin QAccessibleWidget QAction QActionEvent QActionGroup QAnimationGroup QApplication QAtomicInt QAtomicPointer QAudioDeviceInfo QAudioFormat QAudioInput QAudioOutput QAuthenticator QAxAggregated QAxBase QAxBindable QAxFactory QAxObject QAxScript QAxScriptEngine QAxScriptManager QAxWidget QBasicTimer QBitArray QBitmap QBoxLayout QBool QBrush QBuffer QButtonGroup QByteArray QByteArrayMatcher QCache QCalendarWidget QCDEStyle QChar QCheckBox QChildEvent QCleanlooksStyle QClipboard QCloseEvent QColor QColorDialog QColormap QColumnView QComboBox QCommandLinkButton QCommonStyle QCompleter QConicalGradient QContextMenuEvent QContiguousCache QCopChannel QCoreApplication QCryptographicHash QCursor QCustomRasterPaintDevice QDataStream QDataWidgetMapper QDate QDateEdit QDateTime QDateTimeEdit QDBusAbstractAdaptor QDBusAbstractInterface QDBusArgument QDBusConnection QDBusConnectionInterface QDBusContext QDBusError QDBusInterface QDBusMessage QDBusObjectPath QDBusPendingCall QDBusPendingCallWatcher QDBusPendingReply QDBusReply QDBusServiceWatcher QDBusSignature QDBusUnixFileDescriptor QDBusVariant QDebug QDeclarativeComponent QDeclarativeContext QDeclarativeEngine QDeclarativeError QDeclarativeExpression QDeclarativeExtensionPlugin QDeclarativeImageProvider QDeclarativeItem QDeclarativeListProperty QDeclarativeListReference QDeclarativeNetworkAccessManagerFactory QDeclarativeParserStatus QDeclarativeProperty QDeclarativePropertyMap QDeclarativePropertyValueSource QDeclarativeScriptString QDeclarativeView QDecoration QDecorationDefault QDecorationFactory QDecorationPlugin QDesignerActionEditorInterface QDesignerContainerExtension QDesignerCustomWidgetCollectionInterface QDesignerCustomWidgetInterface QDesignerDynamicPropertySheetExtension QDesignerFormEditorInterface QDesignerFormWindowCursorInterface QDesignerFormWindowInterface QDesignerFormWindowManagerInterface QDesignerMemberSheetExtension QDesignerObjectInspectorInterface QDesignerPropertyEditorInterface QDesignerPropertySheetExtension QDesignerTaskMenuExtension QDesignerWidgetBoxInterface QDesktopServices QDesktopWidget QDial QDialog QDialogButtonBox QDir QDirectPainter QDirIterator QDockWidget QDomAttr QDomCDATASection QDomCharacterData QDomComment QDomDocument QDomDocumentFragment QDomDocumentType QDomElement QDomEntity QDomEntityReference QDomImplementation QDomNamedNodeMap QDomNode QDomNodeList QDomNotation QDomProcessingInstruction QDomText QDoubleSpinBox QDoubleValidator QDrag QDragEnterEvent QDragLeaveEvent QDragMoveEvent QDropEvent QDynamicPropertyChangeEvent QEasingCurve QElapsedTimer QErrorMessage QEvent QEventLoop QEventTransition QExplicitlySharedDataPointer QExtensionFactory QExtensionManager QFile QFileDialog QFileIconProvider QFileInfo QFileOpenEvent QFileSystemModel QFileSystemWatcher QFinalState QFlag QFlags QFocusEvent QFocusFrame QFont QFontComboBox QFontDatabase QFontDialog QFontEngineInfo QFontEnginePlugin QFontInfo QFontMetrics QFontMetricsF QFormBuilder QFormLayout QFrame QFSFileEngine QFtp QFuture QFutureIterator QFutureSynchronizer QFutureWatcher QGenericArgument QGenericMatrix QGenericPlugin QGenericPluginFactory QGenericReturnArgument QGesture QGestureEvent QGestureRecognizer QGLBuffer QGLColormap QGLContext QGLFormat QGLFramebufferObject QGLFramebufferObjectFormat QGLFunctions QGLPixelBuffer QGLShader QGLShaderProgram QGLWidget QGlyphRun QGradient QGraphicsAnchor QGraphicsAnchorLayout QGraphicsBlurEffect QGraphicsColorizeEffect QGraphicsDropShadowEffect QGraphicsEffect QGraphicsEllipseItem QGraphicsGridLayout QGraphicsItem QGraphicsItemAnimation QGraphicsItemGroup QGraphicsLayout QGraphicsLayoutItem QGraphicsLinearLayout QGraphicsLineItem QGraphicsObject QGraphicsOpacityEffect QGraphicsPathItem QGraphicsPixmapItem QGraphicsPolygonItem QGraphicsProxyWidget QGraphicsRectItem QGraphicsRotation QGraphicsScale QGraphicsScene QGraphicsSceneContextMenuEvent QGraphicsSceneDragDropEvent QGraphicsSceneEvent QGraphicsSceneHelpEvent QGraphicsSceneHoverEvent QGraphicsSceneMouseEvent QGraphicsSceneMoveEvent QGraphicsSceneResizeEvent QGraphicsSceneWheelEvent QGraphicsSimpleTextItem QGraphicsSvgItem QGraphicsTextItem QGraphicsTransform QGraphicsView QGraphicsWebView QGraphicsWidget QGridLayout QGroupBox QGtkStyle QHash QHashIterator QHBoxLayout QHeaderView QHelpContentItem QHelpContentModel QHelpContentWidget QHelpEngine QHelpEngineCore QHelpEvent QHelpIndexModel QHelpIndexWidget QHelpSearchEngine QHelpSearchQuery QHelpSearchQueryWidget QHelpSearchResultWidget QHideEvent QHistoryState QHostAddress QHostInfo QHoverEvent QHttpMultiPart QHttpPart QIcon QIconDragEvent QIconEngine QIconEnginePlugin QIconEnginePluginV2 QIconEngineV2 QIdentityProxyModel QImage QImageIOHandler QImageIOPlugin QImageReader QImageWriter QInputContext QInputContextFactory QInputContextPlugin QInputDialog QInputEvent QInputMethodEvent QIntValidator QIODevice QItemDelegate QItemEditorCreator QItemEditorCreatorBase QItemEditorFactory QItemSelection QItemSelectionModel QItemSelectionRange QKbdDriverFactory QKbdDriverPlugin QKeyEvent QKeyEventTransition QKeySequence QLabel QLatin1Char QLatin1String QLayout QLayoutItem QLCDNumber QLibrary QLibraryInfo QLine QLinearGradient QLineEdit QLineF QLinkedList QLinkedListIterator QList QListIterator QListView QListWidget QListWidgetItem QLocale QLocalServer QLocalSocket QMacCocoaViewContainer QMacNativeWidget QMacPasteboardMime QMacStyle QMainWindow QMap QMapIterator QMargins QMatrix4x4 QMdiArea QMdiSubWindow QMenu QMenuBar QMessageBox QMetaClassInfo QMetaEnum QMetaMethod QMetaObject QMetaProperty QMetaType QMimeData QModelIndex QMotifStyle QMouseDriverFactory QMouseDriverPlugin QMouseEvent QMouseEventTransition QMoveEvent QMovie QMultiHash QMultiMap QMutableHashIterator QMutableLinkedListIterator QMutableListIterator QMutableMapIterator QMutableSetIterator QMutableVectorIterator QMutex QMutexLocker QNetworkAccessManager QNetworkAddressEntry QNetworkCacheMetaData QNetworkConfiguration QNetworkConfigurationManager QNetworkCookie QNetworkCookieJar QNetworkDiskCache QNetworkInterface QNetworkProxy QNetworkProxyFactory QNetworkProxyQuery QNetworkReply QNetworkRequest QNetworkSession QObject QObjectCleanupHandler QPageSetupDialog QPaintDevice QPaintEngine QPaintEngineState QPainter QPainterPath QPainterPathStroker QPaintEvent QPair QPalette QPanGesture QParallelAnimationGroup QPauseAnimation QPen QPersistentModelIndex QPicture QPinchGesture QPixmap QPixmapCache QPlainTextDocumentLayout QPlainTextEdit QPlastiqueStyle QPlatformCursor QPlatformCursorImage QPlatformFontDatabase QPlatformWindowFormat QPluginLoader QPoint QPointer QPointF QPolygon QPolygonF QPrintDialog QPrintEngine QPrinter QPrinterInfo QPrintPreviewDialog QPrintPreviewWidget QProcess QProcessEnvironment QProgressBar QProgressDialog QPropertyAnimation QProxyScreen QProxyScreenCursor QProxyStyle QPushButton QQuaternion QQueue QRadialGradient QRadioButton QRasterPaintEngine QRawFont QReadLocker QReadWriteLock QRect QRectF QRegExp QRegExpValidator QRegion QResizeEvent QResource QRubberBand QRunnable QS60MainApplication QS60MainAppUi QS60MainDocument QS60Style QScopedArrayPointer QScopedPointer QScopedValueRollback QScreen QScreenCursor QScreenDriverFactory QScreenDriverPlugin QScriptable QScriptClass QScriptClassPropertyIterator QScriptContext QScriptContextInfo QScriptEngine QScriptEngineAgent QScriptEngineDebugger QScriptExtensionPlugin QScriptProgram QScriptString QScriptSyntaxCheckResult QScriptValue QScriptValueIterator QScrollArea QScrollBar QSemaphore QSequentialAnimationGroup QSessionManager QSet QSetIterator QSettings QSharedData QSharedDataPointer QSharedMemory QSharedPointer QShortcut QShortcutEvent QShowEvent QSignalMapper QSignalSpy QSignalTransition QSimpleXmlNodeModel QSize QSizeF QSizeGrip QSizePolicy QSlider QSocketNotifier QSortFilterProxyModel QSound QSourceLocation QSpacerItem QSpinBox QSplashScreen QSplitter QSplitterHandle QSqlDatabase QSqlDriver QSqlDriverCreator QSqlDriverCreatorBase QSqlDriverPlugin QSqlError QSqlField QSqlIndex QSqlQuery QSqlQueryModel QSqlRecord QSqlRelation QSqlRelationalDelegate QSqlRelationalTableModel QSqlResult QSqlTableModel QSslCertificate QSslCipher QSslConfiguration QSslError QSslKey QSslSocket QStack QStackedLayout QStackedWidget QStandardItem QStandardItemEditorCreator QStandardItemModel QState QStateMachine QStaticText QStatusBar QStatusTipEvent QString QStringList QStringListModel QStringMatcher QStringRef QStyle QStyledItemDelegate QStyleFactory QStyleHintReturn QStyleHintReturnMask QStyleHintReturnVariant QStyleOption QStyleOptionButton QStyleOptionComboBox QStyleOptionComplex QStyleOptionDockWidget QStyleOptionFocusRect QStyleOptionFrame QStyleOptionFrameV2 QStyleOptionFrameV3 QStyleOptionGraphicsItem QStyleOptionGroupBox QStyleOptionHeader QStyleOptionMenuItem QStyleOptionProgressBar QStyleOptionProgressBarV2 QStyleOptionQ3DockWindow QStyleOptionQ3ListView QStyleOptionQ3ListViewItem QStyleOptionRubberBand QStyleOptionSizeGrip QStyleOptionSlider QStyleOptionSpinBox QStyleOptionTab QStyleOptionTabBarBase QStyleOptionTabBarBaseV2 QStyleOptionTabV2 QStyleOptionTabV3 QStyleOptionTabWidgetFrame QStyleOptionTabWidgetFrameV2 QStyleOptionTitleBar QStyleOptionToolBar QStyleOptionToolBox QStyleOptionToolBoxV2 QStyleOptionToolButton QStyleOptionViewItem QStyleOptionViewItemV2 QStyleOptionViewItemV3 QStyleOptionViewItemV4 QStylePainter QStylePlugin QSupportedWritingSystems QSvgGenerator QSvgRenderer QSvgWidget QSwipeGesture QSymbianEvent QSymbianGraphicsSystemHelper QSyntaxHighlighter QSysInfo QSystemLocale QSystemSemaphore QSystemTrayIcon QTabBar QTabletEvent QTableView QTableWidget QTableWidgetItem QTableWidgetSelectionRange QTabWidget QTapAndHoldGesture QTapGesture QTcpServer QTcpSocket QTemporaryFile QTestEventList QTextBlock QTextBlockFormat QTextBlockGroup QTextBlockUserData QTextBoundaryFinder QTextBrowser QTextCharFormat QTextCodec QTextCodecPlugin QTextCursor QTextDecoder QTextDocument QTextDocumentFragment QTextDocumentWriter QTextEdit QTextEncoder QTextFormat QTextFragment QTextFrame QTextFrameFormat QTextImageFormat QTextInlineObject QTextItem QTextLayout QTextLength QTextLine QTextList QTextListFormat QTextObject QTextObjectInterface QTextOption QTextStream QTextTable QTextTableCell QTextTableCellFormat QTextTableFormat QThread QThreadPool QThreadStorage QTileRules QTime QTimeEdit QTimeLine QTimer QTimerEvent QToolBar QToolBox QToolButton QToolTip QTouchEvent QTransform QTranslator QTreeView QTreeWidget QTreeWidgetItem QTreeWidgetItemIterator QUdpSocket QUiLoader QUndoCommand QUndoGroup QUndoStack QUndoView QUrl QUrlInfo QUuid QValidator QVariant QVariantAnimation QVarLengthArray QVBoxLayout QVector QVector2D QVector3D QVector4D QVectorIterator QVideoFrame QVideoSurfaceFormat QWaitCondition QWeakPointer QWebDatabase QWebElement QWebElementCollection QWebFrame QWebHistory QWebHistoryInterface QWebHistoryItem QWebHitTestResult QWebInspector QWebPage QWebPluginFactory QWebSecurityOrigin QWebSettings QWebView QWhatsThis QWhatsThisClickedEvent QWheelEvent QWidget QWidgetAction QWidgetItem QWindowsMime QWindowsStyle QWindowStateChangeEvent QWindowsVistaStyle QWindowsXPStyle QWizard QWizardPage QWriteLocker QWSCalibratedMouseHandler QWSClient QWSEmbedWidget QWSEvent QWSGLWindowSurface QWSInputMethod QWSKeyboardHandler QWSMouseHandler QWSPointerCalibrationData QWSScreenSaver QWSServer QWSWindow QX11EmbedContainer QX11EmbedWidget QX11Info QXmlAttributes QXmlContentHandler QXmlDeclHandler QXmlDefaultHandler QXmlDTDHandler QXmlEntityResolver QXmlErrorHandler QXmlFormatter QXmlInputSource QXmlItem QXmlLexicalHandler QXmlLocator QXmlName QXmlNamePool QXmlNamespaceSupport QXmlNodeModelIndex QXmlParseException QXmlQuery QXmlReader QXmlResultItems QXmlSchema QXmlSchemaValidator QXmlSerializer QXmlSimpleReader QXmlStreamAttribute QXmlStreamAttributes QXmlStreamEntityDeclaration QXmlStreamEntityResolver QXmlStreamNamespaceDeclaration QXmlStreamNotationDeclaration QXmlStreamReader QXmlStreamWriter Qt QTest QtConcurrent Phonon QFileInfoList QMutableStringListIterator QTouchEventSequence QStringListIterator QStringBuilder QWidgetList"
list_Qt4Func = Set.fromList $ words $ "connect disconnect staticMetaObject tr trUtf8 qFindChildren qobject_cast qAbs qBound qCritical qDebug qFatal qFuzzyCompare qFuzzyCompare qInstallMsgHandler qMacVersion qMakePair qMax qMin qPrintable qRound64 qRound qVersion qWarning q_check_ptr qgetenv qrand qsrand qtTrId qt_set_sequence_auto_mnemonic qt_symbian_exception2Error qt_symbian_exception2LeaveL qt_symbian_throwIfError qBinaryFind qCopy qCopyBackward qCount qDeleteAll qEqual qFill qFind qGreater qLess qLowerBound qSort qStableSort qSwap qUpperBound qChecksum qCompress qUncompress qsnprintf qstrcmp qstrcpy qstrdup qstricmp qstrlen qstrncmp qstrncpy qstrnicmp qstrnlen qvsnprintf qHash qMetaTypeId qRegisterMetaType qRegisterMetaType qRegisterMetaTypeStreamOperators qAlpha qBlue qGray qGray qGreen qRed qRgb qRgba qAddPostRoutine qmlInfo qmlRegisterInterface qmlRegisterType qmlRegisterType qmlRegisterTypeNotAvailable qmlRegisterUncreatableType qWebKitMajorVersion qWebKitMinorVersion qWebKitVersion qt_extension qDBusRegisterMetaType qdbus_cast"
list_Qt4Types = Set.fromList $ words $ "QtMsgHandler QtMsgType QObjectList qint8 qint16 qint32 qint64 qlonglong qptrdiff qreal quint8 quint16 quint32 quint64 quintptr qulonglong uchar uint ulong ushort Q_PID QRgb qScriptConnect qScriptDisconnect qScriptRegisterMetaType qScriptRegisterSequenceMetaType qScriptValueFromSequence qScriptValueToSequence WId"


parseRules ("C++","Normal") =
  (((parseRules ("C++","DetectQt4Extensions")))
   <|>
   ((Text.Highlighting.Kate.Syntax.Isocpp.parseExpression (Just ("ISO C++",""))))
   <|>
   (currentContext >>= \x -> guard (x == ("C++","Normal")) >> pDefault >>= withAttribute NormalTok))

parseRules ("C++","DetectQt4Extensions") =
  (((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_Qt4Types >>= withAttribute DataTypeTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_Qt4Classes >>= withAttribute OtherTok) >>~ pushContext ("C++","QtClassMember"))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_Qt4Func >>= withAttribute FunctionTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_Qt4Macros >>= withAttribute KeywordTok))
   <|>
   (currentContext >>= \x -> guard (x == ("C++","DetectQt4Extensions")) >> pDefault >>= withAttribute NormalTok))

parseRules ("C++","QtClassMember") =
  (((parseRules ("C++","DetectNSEnd")))
   <|>
   (currentContext >>= \x -> guard (x == ("C++","QtClassMember")) >> pDefault >>= withAttribute OtherTok))

parseRules ("C++","DetectNSEnd") =
  (((pDetectIdentifier >>= withAttribute NormalTok))
   <|>
   ((lookAhead (pAnyChar "!% &()+-/.*<=>?[]{|}~^,;") >> (popContext) >> currentContext >>= parseRules))
   <|>
   ((lookAhead (pAnyChar " ") >> currentContext >>= parseRules))
   <|>
   (currentContext >>= \x -> guard (x == ("C++","DetectNSEnd")) >> pDefault >>= withAttribute NormalTok))

parseRules ("ISO C++", _) = Text.Highlighting.Kate.Syntax.Isocpp.parseExpression Nothing

parseRules x = parseRules ("C++","Normal") <|> fail ("Unknown context" ++ show x)
