/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.MetadataStore;
import loci.formats.RandomAccessStream;
import loci.formats.TiffTools;
import loci.formats.in.BaseTiffReader;

public class ImprovisionTiffReader
extends BaseTiffReader {
    private String[] cNames;
    private int pixelSizeT;

    public ImprovisionTiffReader() {
        super("Improvision TIFF", new String[]{"tif", "tiff"});
    }

    public boolean isThisType(String name, boolean open) {
        if (!super.isThisType(name, open)) {
            return false;
        }
        if (!open) {
            return true;
        }
        try {
            RandomAccessStream ras = new RandomAccessStream(name);
            Hashtable ifd = TiffTools.getFirstIFD(ras);
            ras.close();
            if (ifd == null) {
                return false;
            }
            String comment = (String)ifd.get(new Integer(270));
            return comment == null ? false : comment.indexOf("Improvision") != -1;
        }
        catch (IOException exc) {
            if (debug) {
                this.trace(exc);
            }
            return false;
        }
    }

    protected void initStandardMetadata() throws FormatException, IOException {
        int i;
        super.initStandardMetadata();
        this.put("Improvision", "yes");
        String comment = (String)this.getMeta("Comment");
        if (comment != null) {
            StringTokenizer st = new StringTokenizer(comment, "\n");
            while (st.hasMoreTokens()) {
                String line = st.nextToken();
                int equals = line.indexOf("=");
                if (equals < 0) continue;
                String key = line.substring(0, equals);
                String value = line.substring(equals + 1);
                this.addMeta(key, value);
            }
            this.metadata.remove("Comment");
        }
        String tz = (String)this.getMeta("TotalZPlanes");
        String tc = (String)this.getMeta("TotalChannels");
        String tt = (String)this.getMeta("TotalTimepoints");
        if (tz == null) {
            tz = "1";
        }
        if (tc == null) {
            tc = "1";
        }
        if (tt == null) {
            tt = "1";
        }
        this.core.sizeZ[0] = Integer.parseInt(tz);
        this.core.sizeC[0] = Integer.parseInt(tc);
        this.core.sizeT[0] = Integer.parseInt(tt);
        if (this.core.sizeZ[0] * this.core.sizeC[0] * this.core.sizeT[0] < this.core.imageCount[0]) {
            this.core.sizeC[0] = this.core.imageCount[0];
        }
        long[] stamps = new long[this.ifds.length];
        int[][] coords = new int[this.ifds.length][3];
        this.cNames = new String[this.core.sizeC[0]];
        for (int i2 = 0; i2 < this.ifds.length; ++i2) {
            comment = (String)TiffTools.getIFDValue(this.ifds[i2], 270);
            comment = comment.replaceAll("\r\n", "\n");
            comment = comment.replaceAll("\r", "\n");
            StringTokenizer st = new StringTokenizer(comment, "\n");
            String channelName = null;
            while (st.hasMoreTokens()) {
                int ndx;
                String line = st.nextToken();
                int equals = line.indexOf("=");
                if (equals < 0) continue;
                String key = line.substring(0, equals);
                String value = line.substring(equals + 1);
                if (key.equals("TimeStampMicroSeconds")) {
                    stamps[i2] = Long.parseLong(value);
                    continue;
                }
                if (key.equals("ZPlane")) {
                    coords[i2][0] = Integer.parseInt(value);
                    continue;
                }
                if (key.equals("ChannelNo")) {
                    coords[i2][1] = Integer.parseInt(value);
                    continue;
                }
                if (key.equals("TimepointName")) {
                    coords[i2][2] = Integer.parseInt(value);
                    continue;
                }
                if (key.equals("ChannelName")) {
                    channelName = value;
                    continue;
                }
                if (!key.equals("ChannelNo") || this.cNames[ndx = Integer.parseInt(value)] != null) continue;
                this.cNames[ndx] = channelName;
            }
        }
        long sum = 0L;
        for (i = 1; i < stamps.length; ++i) {
            long diff = stamps[i] - stamps[i - 1];
            if (diff <= 0L) continue;
            sum += diff;
        }
        this.pixelSizeT = (int)(sum / (long)this.core.sizeT[0]);
        this.core.currentOrder[0] = "XY";
        for (i = 1; i < coords.length; ++i) {
            int zDiff = coords[i][0] - coords[i - 1][0];
            int cDiff = coords[i][1] - coords[i - 1][1];
            int tDiff = coords[i][2] - coords[i - 1][2];
            if (zDiff > 0 && this.core.currentOrder[0].indexOf("Z") < 0) {
                this.core.currentOrder[0] = this.core.currentOrder[0] + "Z";
            }
            if (cDiff > 0 && this.core.currentOrder[0].indexOf("C") < 0) {
                this.core.currentOrder[0] = this.core.currentOrder[0] + "C";
            }
            if (tDiff > 0 && this.core.currentOrder[0].indexOf("T") < 0) {
                this.core.currentOrder[0] = this.core.currentOrder[0] + "T";
            }
            if (this.core.currentOrder[0].length() == 5) break;
        }
        if (this.core.currentOrder[0].indexOf("Z") < 0) {
            this.core.currentOrder[0] = this.core.currentOrder[0] + "Z";
        }
        if (this.core.currentOrder[0].indexOf("C") < 0) {
            this.core.currentOrder[0] = this.core.currentOrder[0] + "C";
        }
        if (this.core.currentOrder[0].indexOf("T") < 0) {
            this.core.currentOrder[0] = this.core.currentOrder[0] + "T";
        }
    }

    protected void initMetadataStore() {
        super.initMetadataStore();
        MetadataStore store = this.getMetadataStore();
        FormatTools.populatePixels(store, this);
        float fx = Float.parseFloat((String)this.getMeta("XCalibrationMicrons"));
        float fy = Float.parseFloat((String)this.getMeta("YCalibrationMicrons"));
        float fz = Float.parseFloat((String)this.getMeta("ZCalibrationMicrons"));
        store.setDimensions(new Float(fx), new Float(fy), new Float(fz), null, new Float((double)this.pixelSizeT / 1000000.0), null);
    }
}

