/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.ssec.mcidas.adde;

import edu.wisc.ssec.mcidas.adde.AddeDatasetURL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AddePointURL
extends AddeDatasetURL {
    public static final String KEY_SELECT = "SELECT";
    public static final String KEY_PARAM = "PARAM";
    public static final String KEY_MAX = "MAX";
    public static final String KEY_NUM = "NUM";
    public static final String KEY_POS = "POS";
    private String selectClause = "";
    private String params = "";
    private int max = 1;
    private String pos = "X";

    public AddePointURL() {
    }

    public AddePointURL(String host, String requestType, String group, String descriptor) {
        this(host, requestType, group, descriptor, null);
    }

    public AddePointURL(String host, String requestType, String group, String descriptor, String query) {
        super(host, requestType, group, descriptor, query);
    }

    public AddePointURL(String host, String requestType, String group, String descriptor, String position, String select, String paramList, int maxNum) {
        super(host, requestType, group, descriptor);
        this.pos = position;
        this.selectClause = this.selectClause;
        this.params = paramList;
        this.max = maxNum;
    }

    public String getSelectClause() {
        return this.selectClause;
    }

    public void setSelectClause(String value) {
        this.selectClause = value;
    }

    public String getParams() {
        return this.params;
    }

    public void setParams(String value) {
        this.params = value;
    }

    public int getMaxNumber() {
        return this.max;
    }

    public void setMaxNumber(int value) {
        this.max = value;
    }

    public String getPosition() {
        return this.pos;
    }

    public void setPosition(String value) {
        this.pos = value;
    }

    protected String makeQuery() {
        StringBuffer buf = new StringBuffer(super.makeQuery());
        if (!this.getSelectClause().equals("")) {
            this.appendKeyValue(buf, KEY_SELECT, this.getSelectClause());
        }
        if (!this.getParams().equals("")) {
            this.appendKeyValue(buf, KEY_PARAM, this.getParams());
        }
        this.appendKeyValue(buf, KEY_MAX, String.valueOf(this.getMaxNumber()));
        this.appendKeyValue(buf, KEY_POS, this.getPosition());
        return buf.toString();
    }

    public static AddePointURL decodeURL(String baseURL) {
        Pattern pattern = Pattern.compile("(.*)://(.*)/(.*)\\?(.*)");
        Matcher matcher = pattern.matcher(baseURL);
        boolean ok = matcher.find();
        if (!ok) {
            return null;
        }
        int numGroups = matcher.groupCount();
        if (numGroups >= 3) {
            String protocol = matcher.group(1);
            String requestType = matcher.group(3);
            if (!protocol.equals("adde") || !requestType.toLowerCase().startsWith("point")) {
                return null;
            }
            AddePointURL apu = new AddePointURL();
            apu.setHost(matcher.group(2));
            apu.setRequestType(requestType);
            if (numGroups > 3) {
                String query = matcher.group(4);
                apu.parseQuery(query);
            }
            return apu;
        }
        return null;
    }

    protected void parseQuery(String query) {
        super.parseQuery(query);
        String test = this.getValue(query, KEY_SELECT);
        if (test != null) {
            this.setSelectClause(test);
        }
        if ((test = this.getValue(query, KEY_PARAM)) != null) {
            this.setParams(test);
        }
        if ((test = this.getValue(query, KEY_POS)) != null) {
            this.setPosition(test);
        }
        if ((test = this.getValue(query, KEY_MAX)) != null) {
            this.setMaxNumber(Integer.parseInt(test));
        }
        if ((test = this.getValue(query, KEY_NUM)) != null) {
            int num = this.max;
            if (test.equalsIgnoreCase("ALL")) {
                num = 99999;
            } else {
                try {
                    num = Integer.parseInt(test);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            this.setMaxNumber(num);
        }
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            AddePointURL url = AddePointURL.decodeURL(args[0]);
            System.out.println(url.getURLString());
        }
    }
}

