/* $Id$ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __ENUMERATION_TYPE_HPP_INCLUDED
#define __ENUMERATION_TYPE_HPP_INCLUDED

#include "frontend/ast/TypeDeclaration.hpp"
#include "frontend/ast/FunctionDeclaration.hpp"

namespace ast {


//! one VHDL enumeration type.
/** This class represents one VHDL enumeration type.
 */
class EnumerationType : public TypeDeclaration {
public:
	//! c'tor
	/** @param declName name of the declared type.
          * @param elems declared enumeration elements. These are 
	  *        Function declarations, which will be marked as
	  *        builtins and will return the value of the 
	  *        EnumerationElement.
          * @param loc location of the declaration.
          */
	EnumerationType(
		std::string* declName,
		std::list<FunctionDeclaration*> *elems,
		Location loc
		) : 	TypeDeclaration(declName, loc, BASE_TYPE_ENUM),
			elements(elems) {}

	//! Accept a Visitor.
 	/** All leaf AST nodes need to implement this method.
         *
         *  @param visitor the Visitor that can visit this node.
         */
	virtual void accept(Visitor& visitor) {
		visitor.visit(*this);
	}

	/** Put a textual representation of the AstNode on the stream.
	 *  @param stream stream to put the textual representation to.
	 */
	virtual void put(std::ostream &stream) const {
		assert(this->name);
		stream << "EnumerationType " << *this->name;
	}

	/** declared enumeration elements, i.e. the resulting identity 
	 *  functions (builtins) that yield the enumeration value.
	 */
	std::list<FunctionDeclaration*> *elements;
};

}; /* namespace ast */

#endif /* __ENUMERATION_TYPE_HPP_INCLUDED */
