# Arch Linux - Print the sinling package names required by the given package
# USAGE: archlinux_dependencies_siblings $package
# RETURN: a list of package names,
#         one per line
archlinux_dependencies_siblings() {
	local package
	package="$1"

	local required_siblings
	required_siblings=$(dependencies_list_siblings "$package")
	# Return early if the current package does not require any sibling
	if [ -z "$required_siblings" ]; then
		return 0
	fi

	local sibling dependencies_siblings_list required_packages
	while read -r sibling; do
		required_package=$(package_id "$sibling")
		dependencies_siblings_list="$dependencies_siblings_list
		$required_package"
	done <<- EOL
	$(printf '%s' "$required_siblings")
	EOL

	printf '%s' "$dependencies_siblings_list" | list_clean
}

