#!/bin/sh

oneTimeSetUp() {
	# Load the ./play.it library
	export LIB_ONLY=1
	. lib/libplayit2.sh
}

test_archlinux_metadata_file_install() {
	local \
		metadata_file_install metadata_file_install_expected \
		PKG_MAIN_POSTINST_RUN PKG_MAIN_PRERM_RUN \
		PKG_MAIN_POSTINST_WARNINGS

	PKG_MAIN_POSTINST_RUN="# Link common files shared by the games series
ln --symbolic '/usr/share/games/heroes-chronicles/data' '/usr/share/games/heroes-chronicles-3'
ln --symbolic '/usr/share/games/heroes-chronicles/mp3' '/usr/share/games/heroes-chronicles-3'"
	PKG_MAIN_PRERM_RUN="# Delete links to common files shared by the games series
rm '/usr/share/games/heroes-chronicles-3/mp3'
rm '/usr/share/games/heroes-chronicles-3/data'"
	metadata_file_install=$(archlinux_metadata_file_install 'PKG_MAIN')
	metadata_file_install_expected="post_install() {
# Link common files shared by the games series
ln --symbolic '/usr/share/games/heroes-chronicles/data' '/usr/share/games/heroes-chronicles-3'
ln --symbolic '/usr/share/games/heroes-chronicles/mp3' '/usr/share/games/heroes-chronicles-3'
}

post_upgrade() {
post_install
}
pre_remove() {
# Delete links to common files shared by the games series
rm '/usr/share/games/heroes-chronicles-3/mp3'
rm '/usr/share/games/heroes-chronicles-3/data'
}

pre_upgrade() {
pre_remove
}"
	assertEquals "$metadata_file_install_expected" "$metadata_file_install"
	unset PKG_MAIN_POSTINST_RUN PKG_MAIN_PRERM_RUN

	PKG_MAIN_POSTINST_WARNINGS='You may need to generate the ja_JP.UTF-8 locale for the configuration program to run
You need a MIDI synthetiser for music to play in the game (you can use timidity++ or fluidsynth if you don’t have a hardware synthetiser)'
	metadata_file_install=$(archlinux_metadata_file_install 'PKG_MAIN')
	metadata_file_install_expected='post_install() {
printf "Warning: %s\n" "You may need to generate the ja_JP.UTF-8 locale for the configuration program to run"
printf "Warning: %s\n" "You need a MIDI synthetiser for music to play in the game (you can use timidity++ or fluidsynth if you don’t have a hardware synthetiser)"
}

post_upgrade() {
post_install
}'
	assertEquals "$metadata_file_install_expected" "$metadata_file_install"

}

test_archlinux_field_pkgdesc() {
	local field_pkgdesc script_version GAME_NAME PKG_MAIN_DESCRIPTION

	script_version='19700101.1'
	GAME_NAME='Alpha Centauri'
	PKG_MAIN_DESCRIPTION='French localization'
	field_pkgdesc=$(archlinux_field_pkgdesc 'PKG_MAIN')
	assertEquals 'Alpha Centauri - French localization - ./play.it script version 19700101.1' "$field_pkgdesc"
	unset PKG_MAIN_DESCRIPTION

	field_pkgdesc=$(archlinux_field_pkgdesc 'PKG_MAIN')
	assertEquals 'Alpha Centauri - ./play.it script version 19700101.1' "$field_pkgdesc"
}
