/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.browser.detail;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.HashMap;
import javax.swing.JPanel;
import javax.swing.tree.TreePath;
import org.gjt.jclasslib.browser.AbstractDetailPane;
import org.gjt.jclasslib.browser.BrowserServices;
import org.gjt.jclasslib.browser.BrowserTreeNode;
import org.gjt.jclasslib.browser.detail.FixedListDetailPane;
import org.gjt.jclasslib.browser.detail.constants.ConstantClassInfoDetailPane;
import org.gjt.jclasslib.browser.detail.constants.ConstantDoubleInfoDetailPane;
import org.gjt.jclasslib.browser.detail.constants.ConstantFloatInfoDetailPane;
import org.gjt.jclasslib.browser.detail.constants.ConstantIntegerInfoDetailPane;
import org.gjt.jclasslib.browser.detail.constants.ConstantLongInfoDetailPane;
import org.gjt.jclasslib.browser.detail.constants.ConstantNameAndTypeInfoDetailPane;
import org.gjt.jclasslib.browser.detail.constants.ConstantReferenceDetailPane;
import org.gjt.jclasslib.browser.detail.constants.ConstantStringInfoDetailPane;
import org.gjt.jclasslib.browser.detail.constants.ConstantUtf8InfoDetailPane;
import org.gjt.jclasslib.structures.CPInfo;
import org.gjt.jclasslib.structures.constants.ConstantClassInfo;
import org.gjt.jclasslib.structures.constants.ConstantDoubleInfo;
import org.gjt.jclasslib.structures.constants.ConstantFloatInfo;
import org.gjt.jclasslib.structures.constants.ConstantIntegerInfo;
import org.gjt.jclasslib.structures.constants.ConstantLongInfo;
import org.gjt.jclasslib.structures.constants.ConstantNameAndTypeInfo;
import org.gjt.jclasslib.structures.constants.ConstantReference;
import org.gjt.jclasslib.structures.constants.ConstantStringInfo;
import org.gjt.jclasslib.structures.constants.ConstantUtf8Info;

public class ConstantPoolDetailPane
extends AbstractDetailPane {
    private static final String SCREEN_CONSTANT_UTF8_INFO = "ConstantUtf8Info";
    private static final String SCREEN_CONSTANT_UNKNOWN = "ConstantUnknown";
    private static final String SCREEN_CONSTANT_CLASS_INFO = "ConstantClassInfo";
    private static final String SCREEN_CONSTANT_DOUBLE_INFO = "ConstantDoubleInfo";
    private static final String SCREEN_CONSTANT_LONG_INFO = "ConstantLongInfo";
    private static final String SCREEN_CONSTANT_FLOAT_INFO = "ConstantFloatInfo";
    private static final String SCREEN_CONSTANT_INTEGER_INFO = "ConstantIntegerInfo";
    private static final String SCREEN_CONSTANT_NAME_AND_TYPE_INFO = "ConstantNameAndTypeInfo";
    private static final String SCREEN_CONSTANT_STRING_INFO = "ConstantStringInfo";
    private static final String SCREEN_CONSTANT_REFERENCE = "ConstantReference";
    private HashMap constantTypeToDetailPane;

    public ConstantPoolDetailPane(BrowserServices browserServices) {
        super(browserServices);
    }

    protected void setupComponent() {
        this.setLayout(new CardLayout());
        this.constantTypeToDetailPane = new HashMap();
        JPanel jPanel = new JPanel();
        jPanel.setBackground(Color.blue);
        this.add((Component)jPanel, SCREEN_CONSTANT_UNKNOWN);
        this.addScreen(new ConstantUtf8InfoDetailPane(this.services), SCREEN_CONSTANT_UTF8_INFO);
        this.addScreen(new ConstantClassInfoDetailPane(this.services), SCREEN_CONSTANT_CLASS_INFO);
        this.addScreen(new ConstantDoubleInfoDetailPane(this.services), SCREEN_CONSTANT_DOUBLE_INFO);
        this.addScreen(new ConstantLongInfoDetailPane(this.services), SCREEN_CONSTANT_LONG_INFO);
        this.addScreen(new ConstantFloatInfoDetailPane(this.services), SCREEN_CONSTANT_FLOAT_INFO);
        this.addScreen(new ConstantIntegerInfoDetailPane(this.services), SCREEN_CONSTANT_INTEGER_INFO);
        this.addScreen(new ConstantNameAndTypeInfoDetailPane(this.services), SCREEN_CONSTANT_NAME_AND_TYPE_INFO);
        this.addScreen(new ConstantStringInfoDetailPane(this.services), SCREEN_CONSTANT_STRING_INFO);
        this.addScreen(new ConstantReferenceDetailPane(this.services), SCREEN_CONSTANT_REFERENCE);
    }

    public void show(TreePath treePath) {
        int n = ((BrowserTreeNode)treePath.getLastPathComponent()).getIndex();
        CPInfo cPInfo = this.services.getClassFile().getConstantPool()[n];
        String string = null;
        if (cPInfo instanceof ConstantUtf8Info) {
            string = SCREEN_CONSTANT_UTF8_INFO;
        } else if (cPInfo instanceof ConstantClassInfo) {
            string = SCREEN_CONSTANT_CLASS_INFO;
        } else if (cPInfo instanceof ConstantDoubleInfo) {
            string = SCREEN_CONSTANT_DOUBLE_INFO;
        } else if (cPInfo instanceof ConstantLongInfo) {
            string = SCREEN_CONSTANT_LONG_INFO;
        } else if (cPInfo instanceof ConstantFloatInfo) {
            string = SCREEN_CONSTANT_FLOAT_INFO;
        } else if (cPInfo instanceof ConstantIntegerInfo) {
            string = SCREEN_CONSTANT_INTEGER_INFO;
        } else if (cPInfo instanceof ConstantNameAndTypeInfo) {
            string = SCREEN_CONSTANT_NAME_AND_TYPE_INFO;
        } else if (cPInfo instanceof ConstantStringInfo) {
            string = SCREEN_CONSTANT_STRING_INFO;
        } else if (cPInfo instanceof ConstantReference) {
            string = SCREEN_CONSTANT_REFERENCE;
        }
        CardLayout cardLayout = (CardLayout)this.getLayout();
        if (string == null) {
            cardLayout.show(this, SCREEN_CONSTANT_UNKNOWN);
        } else {
            AbstractDetailPane abstractDetailPane = (AbstractDetailPane)this.constantTypeToDetailPane.get(string);
            abstractDetailPane.show(treePath);
            cardLayout.show(this, string);
        }
    }

    private void addScreen(AbstractDetailPane abstractDetailPane, String string) {
        if (abstractDetailPane instanceof FixedListDetailPane) {
            this.add((Component)((FixedListDetailPane)abstractDetailPane).getScrollPane(), string);
        } else {
            this.add((Component)abstractDetailPane, string);
        }
        this.constantTypeToDetailPane.put(string, abstractDetailPane);
    }
}

