# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
import sys
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

import msrest.serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models
if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore
JSON = MutableMapping[str, Any]  # pylint: disable=unsubscriptable-object


class AlertResultList(msrest.serialization.Model):
    """AlertResultList.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar next_link:
    :vartype next_link: str
    :ivar value: Required.
    :vartype value: list[~azure.ai.metricsadvisor.models.AnomalyAlert]
    """

    _validation = {
        "next_link": {"readonly": True},
        "value": {"required": True},
    }

    _attribute_map = {
        "next_link": {"key": "@nextLink", "type": "str"},
        "value": {"key": "value", "type": "[AnomalyAlert]"},
    }

    def __init__(self, *, value: List["_models.AnomalyAlert"], **kwargs):
        """
        :keyword value: Required.
        :paramtype value: list[~azure.ai.metricsadvisor.models.AnomalyAlert]
        """
        super().__init__(**kwargs)
        self.next_link = None
        self.value = value


class AnomalyAlert(msrest.serialization.Model):
    """AnomalyAlert.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: alert id.
    :vartype id: str
    :ivar timestamp: anomaly time.
    :vartype timestamp: ~datetime.datetime
    :ivar created_time: created time.
    :vartype created_time: ~datetime.datetime
    :ivar modified_time: modified time.
    :vartype modified_time: ~datetime.datetime
    """

    _validation = {
        "id": {"readonly": True},
        "timestamp": {"readonly": True},
        "created_time": {"readonly": True},
        "modified_time": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "alertId", "type": "str"},
        "timestamp": {"key": "timestamp", "type": "iso-8601"},
        "created_time": {"key": "createdTime", "type": "iso-8601"},
        "modified_time": {"key": "modifiedTime", "type": "iso-8601"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.timestamp = None
        self.created_time = None
        self.modified_time = None


class AnomalyAlertConfiguration(msrest.serialization.Model):
    """AnomalyAlertConfiguration.

    All required parameters must be populated in order to send to Azure.

    :ivar id: anomaly alerting configuration unique id.
    :vartype id: str
    :ivar name: anomaly alerting configuration name. Required.
    :vartype name: str
    :ivar description: anomaly alerting configuration description.
    :vartype description: str
    :ivar cross_metrics_operator: cross metrics operator

     should be specified when setting up multiple metric alerting configurations. Known values are:
     "AND", "OR", and "XOR".
    :vartype cross_metrics_operator: str or
     ~azure.ai.metricsadvisor.models.MetricAnomalyAlertConfigurationsOperator
    :ivar dimensions_to_split_alert: dimensions used to split alert.
    :vartype dimensions_to_split_alert: list[str]
    :ivar hook_ids: hook unique ids. Required.
    :vartype hook_ids: list[str]
    :ivar metric_alert_configurations: Anomaly alerting configurations. Required.
    :vartype metric_alert_configurations:
     list[~azure.ai.metricsadvisor.models.MetricAlertConfiguration]
    """

    _validation = {
        "name": {"required": True},
        "dimensions_to_split_alert": {"unique": True},
        "hook_ids": {"required": True, "unique": True},
        "metric_alert_configurations": {"required": True, "unique": True},
    }

    _attribute_map = {
        "id": {"key": "anomalyAlertingConfigurationId", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "cross_metrics_operator": {"key": "crossMetricsOperator", "type": "str"},
        "dimensions_to_split_alert": {"key": "splitAlertByDimensions", "type": "[str]"},
        "hook_ids": {"key": "hookIds", "type": "[str]"},
        "metric_alert_configurations": {"key": "metricAlertingConfigurations", "type": "[MetricAlertConfiguration]"},
    }

    def __init__(
        self,
        *,
        name: str,
        hook_ids: List[str],
        metric_alert_configurations: List["_models.MetricAlertConfiguration"],
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        description: str = "",
        cross_metrics_operator: Optional[Union[str, "_models.MetricAnomalyAlertConfigurationsOperator"]] = None,
        dimensions_to_split_alert: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword id: anomaly alerting configuration unique id.
        :paramtype id: str
        :keyword name: anomaly alerting configuration name. Required.
        :paramtype name: str
        :keyword description: anomaly alerting configuration description.
        :paramtype description: str
        :keyword cross_metrics_operator: cross metrics operator

         should be specified when setting up multiple metric alerting configurations. Known values are:
         "AND", "OR", and "XOR".
        :paramtype cross_metrics_operator: str or
         ~azure.ai.metricsadvisor.models.MetricAnomalyAlertConfigurationsOperator
        :keyword dimensions_to_split_alert: dimensions used to split alert.
        :paramtype dimensions_to_split_alert: list[str]
        :keyword hook_ids: hook unique ids. Required.
        :paramtype hook_ids: list[str]
        :keyword metric_alert_configurations: Anomaly alerting configurations. Required.
        :paramtype metric_alert_configurations:
         list[~azure.ai.metricsadvisor.models.MetricAlertConfiguration]
        """
        super().__init__(**kwargs)
        self.id = id
        self.name = name
        self.description = description
        self.cross_metrics_operator = cross_metrics_operator
        self.dimensions_to_split_alert = dimensions_to_split_alert
        self.hook_ids = hook_ids
        self.metric_alert_configurations = metric_alert_configurations


class AnomalyAlertingConfigurationList(msrest.serialization.Model):
    """AnomalyAlertingConfigurationList.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value:
    :vartype value: list[~azure.ai.metricsadvisor.models.AnomalyAlertConfiguration]
    :ivar next_link:
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[AnomalyAlertConfiguration]"},
        "next_link": {"key": "@nextLink", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class AnomalyDetectionConfiguration(msrest.serialization.Model):
    """AnomalyDetectionConfiguration.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: anomaly detection configuration unique id.
    :vartype id: str
    :ivar name: anomaly detection configuration name. Required.
    :vartype name: str
    :ivar description: anomaly detection configuration description.
    :vartype description: str
    :ivar metric_id: metric unique id. Required.
    :vartype metric_id: str
    :ivar whole_series_detection_condition: Required.
    :vartype whole_series_detection_condition:
     ~azure.ai.metricsadvisor.models.MetricDetectionCondition
    :ivar series_group_detection_conditions: detection configuration for series group.
    :vartype series_group_detection_conditions:
     list[~azure.ai.metricsadvisor.models.MetricSeriesGroupDetectionCondition]
    :ivar series_detection_conditions: detection configuration for specific series.
    :vartype series_detection_conditions:
     list[~azure.ai.metricsadvisor.models.MetricSingleSeriesDetectionCondition]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"required": True},
        "metric_id": {"required": True},
        "whole_series_detection_condition": {"required": True},
        "series_group_detection_conditions": {"unique": True},
        "series_detection_conditions": {"unique": True},
    }

    _attribute_map = {
        "id": {"key": "anomalyDetectionConfigurationId", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "metric_id": {"key": "metricId", "type": "str"},
        "whole_series_detection_condition": {"key": "wholeMetricConfiguration", "type": "MetricDetectionCondition"},
        "series_group_detection_conditions": {
            "key": "dimensionGroupOverrideConfigurations",
            "type": "[MetricSeriesGroupDetectionCondition]",
        },
        "series_detection_conditions": {
            "key": "seriesOverrideConfigurations",
            "type": "[MetricSingleSeriesDetectionCondition]",
        },
    }

    def __init__(
        self,
        *,
        name: str,
        metric_id: str,
        whole_series_detection_condition: "_models.MetricDetectionCondition",
        description: str = "",
        series_group_detection_conditions: Optional[List["_models.MetricSeriesGroupDetectionCondition"]] = None,
        series_detection_conditions: Optional[List["_models.MetricSingleSeriesDetectionCondition"]] = None,
        **kwargs
    ):
        """
        :keyword name: anomaly detection configuration name. Required.
        :paramtype name: str
        :keyword description: anomaly detection configuration description.
        :paramtype description: str
        :keyword metric_id: metric unique id. Required.
        :paramtype metric_id: str
        :keyword whole_series_detection_condition: Required.
        :paramtype whole_series_detection_condition:
         ~azure.ai.metricsadvisor.models.MetricDetectionCondition
        :keyword series_group_detection_conditions: detection configuration for series group.
        :paramtype series_group_detection_conditions:
         list[~azure.ai.metricsadvisor.models.MetricSeriesGroupDetectionCondition]
        :keyword series_detection_conditions: detection configuration for specific series.
        :paramtype series_detection_conditions:
         list[~azure.ai.metricsadvisor.models.MetricSingleSeriesDetectionCondition]
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = name
        self.description = description
        self.metric_id = metric_id
        self.whole_series_detection_condition = whole_series_detection_condition
        self.series_group_detection_conditions = series_group_detection_conditions
        self.series_detection_conditions = series_detection_conditions


class AnomalyDetectionConfigurationList(msrest.serialization.Model):
    """AnomalyDetectionConfigurationList.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value:
    :vartype value: list[~azure.ai.metricsadvisor.models.AnomalyDetectionConfiguration]
    :ivar next_link:
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[AnomalyDetectionConfiguration]"},
        "next_link": {"key": "@nextLink", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class AnomalyDimensionList(msrest.serialization.Model):
    """AnomalyDimensionList.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar next_link:
    :vartype next_link: str
    :ivar value: Required.
    :vartype value: list[str]
    """

    _validation = {
        "next_link": {"readonly": True},
        "value": {"required": True},
    }

    _attribute_map = {
        "next_link": {"key": "@nextLink", "type": "str"},
        "value": {"key": "value", "type": "[str]"},
    }

    def __init__(self, *, value: List[str], **kwargs):
        """
        :keyword value: Required.
        :paramtype value: list[str]
        """
        super().__init__(**kwargs)
        self.next_link = None
        self.value = value


class MetricFeedback(msrest.serialization.Model):
    """MetricFeedback.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AnomalyFeedback, ChangePointFeedback, CommentFeedback, PeriodFeedback

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar feedback_type: feedback type. Required. Known values are: "Anomaly", "ChangePoint",
     "Period", and "Comment".
    :vartype feedback_type: str or ~azure.ai.metricsadvisor.models.FeedbackType
    :ivar id: feedback unique id.
    :vartype id: str
    :ivar created_time: feedback created time.
    :vartype created_time: ~datetime.datetime
    :ivar user_principal: user who gives this feedback.
    :vartype user_principal: str
    :ivar metric_id: metric unique id. Required.
    :vartype metric_id: str
    :ivar dimension_key: metric dimension filter. Required.
    :vartype dimension_key: dict[str, str]
    """

    _validation = {
        "feedback_type": {"required": True},
        "id": {"readonly": True},
        "created_time": {"readonly": True},
        "user_principal": {"readonly": True},
        "metric_id": {"required": True},
        "dimension_key": {"required": True},
    }

    _attribute_map = {
        "feedback_type": {"key": "feedbackType", "type": "str"},
        "id": {"key": "feedbackId", "type": "str"},
        "created_time": {"key": "createdTime", "type": "iso-8601"},
        "user_principal": {"key": "userPrincipal", "type": "str"},
        "metric_id": {"key": "metricId", "type": "str"},
        "dimension_key": {"key": "dimensionFilter.dimension", "type": "{str}"},
    }

    _subtype_map = {
        "feedback_type": {
            "Anomaly": "AnomalyFeedback",
            "ChangePoint": "ChangePointFeedback",
            "Comment": "CommentFeedback",
            "Period": "PeriodFeedback",
        }
    }

    def __init__(self, *, metric_id: str, dimension_key: Dict[str, str], **kwargs):
        """
        :keyword metric_id: metric unique id. Required.
        :paramtype metric_id: str
        :keyword dimension_key: metric dimension filter. Required.
        :paramtype dimension_key: dict[str, str]
        """
        super().__init__(**kwargs)
        self.feedback_type = None  # type: Optional[str]
        self.id = None
        self.created_time = None
        self.user_principal = None
        self.metric_id = metric_id
        self.dimension_key = dimension_key


class AnomalyFeedback(MetricFeedback):  # pylint: disable=too-many-instance-attributes
    """AnomalyFeedback.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar feedback_type: feedback type. Required. Known values are: "Anomaly", "ChangePoint",
     "Period", and "Comment".
    :vartype feedback_type: str or ~azure.ai.metricsadvisor.models.FeedbackType
    :ivar id: feedback unique id.
    :vartype id: str
    :ivar created_time: feedback created time.
    :vartype created_time: ~datetime.datetime
    :ivar user_principal: user who gives this feedback.
    :vartype user_principal: str
    :ivar metric_id: metric unique id. Required.
    :vartype metric_id: str
    :ivar dimension_key: metric dimension filter. Required.
    :vartype dimension_key: dict[str, str]
    :ivar start_time: the start timestamp of feedback time range. Required.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: the end timestamp of feedback time range, when equals to startTime means only
     one timestamp. Required.
    :vartype end_time: ~datetime.datetime
    :ivar anomaly_detection_configuration_id: the corresponding anomaly detection configuration of
     this feedback.
    :vartype anomaly_detection_configuration_id: str
    :ivar anomaly_detection_configuration_snapshot:
    :vartype anomaly_detection_configuration_snapshot:
     ~azure.ai.metricsadvisor.models.AnomalyDetectionConfiguration
    :ivar value: Required. Known values are: "AutoDetect", "Anomaly", and "NotAnomaly".
    :vartype value: str or ~azure.ai.metricsadvisor.models.AnomalyValue
    """

    _validation = {
        "feedback_type": {"required": True},
        "id": {"readonly": True},
        "created_time": {"readonly": True},
        "user_principal": {"readonly": True},
        "metric_id": {"required": True},
        "dimension_key": {"required": True},
        "start_time": {"required": True},
        "end_time": {"required": True},
        "value": {"required": True},
    }

    _attribute_map = {
        "feedback_type": {"key": "feedbackType", "type": "str"},
        "id": {"key": "feedbackId", "type": "str"},
        "created_time": {"key": "createdTime", "type": "iso-8601"},
        "user_principal": {"key": "userPrincipal", "type": "str"},
        "metric_id": {"key": "metricId", "type": "str"},
        "dimension_key": {"key": "dimensionFilter.dimension", "type": "{str}"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
        "anomaly_detection_configuration_id": {"key": "anomalyDetectionConfigurationId", "type": "str"},
        "anomaly_detection_configuration_snapshot": {
            "key": "anomalyDetectionConfigurationSnapshot",
            "type": "AnomalyDetectionConfiguration",
        },
        "value": {"key": "value.anomalyValue", "type": "str"},
    }

    def __init__(
        self,
        *,
        metric_id: str,
        dimension_key: Dict[str, str],
        start_time: datetime.datetime,
        end_time: datetime.datetime,
        value: Union[str, "_models.AnomalyValue"],
        anomaly_detection_configuration_id: Optional[str] = None,
        anomaly_detection_configuration_snapshot: Optional["_models.AnomalyDetectionConfiguration"] = None,
        **kwargs
    ):
        """
        :keyword metric_id: metric unique id. Required.
        :paramtype metric_id: str
        :keyword dimension_key: metric dimension filter. Required.
        :paramtype dimension_key: dict[str, str]
        :keyword start_time: the start timestamp of feedback time range. Required.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: the end timestamp of feedback time range, when equals to startTime means
         only one timestamp. Required.
        :paramtype end_time: ~datetime.datetime
        :keyword anomaly_detection_configuration_id: the corresponding anomaly detection configuration
         of this feedback.
        :paramtype anomaly_detection_configuration_id: str
        :keyword anomaly_detection_configuration_snapshot:
        :paramtype anomaly_detection_configuration_snapshot:
         ~azure.ai.metricsadvisor.models.AnomalyDetectionConfiguration
        :keyword value: Required. Known values are: "AutoDetect", "Anomaly", and "NotAnomaly".
        :paramtype value: str or ~azure.ai.metricsadvisor.models.AnomalyValue
        """
        super().__init__(metric_id=metric_id, dimension_key=dimension_key, **kwargs)
        self.feedback_type = "Anomaly"  # type: str
        self.start_time = start_time
        self.end_time = end_time
        self.anomaly_detection_configuration_id = anomaly_detection_configuration_id
        self.anomaly_detection_configuration_snapshot = anomaly_detection_configuration_snapshot
        self.value = value


class AnomalyIncident(msrest.serialization.Model):  # pylint: disable=too-many-instance-attributes
    """AnomalyIncident.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar data_feed_id: data feed unique id

     only return for alerting anomaly result.
    :vartype data_feed_id: str
    :ivar metric_id: metric unique id

     only return for alerting incident result.
    :vartype metric_id: str
    :ivar detection_configuration_id: anomaly detection configuration unique id

     only return for alerting incident result.
    :vartype detection_configuration_id: str
    :ivar id: incident id. Required.
    :vartype id: str
    :ivar start_time: incident start time. Required.
    :vartype start_time: ~datetime.datetime
    :ivar last_time: incident last time. Required.
    :vartype last_time: ~datetime.datetime
    :ivar severity: max severity of latest anomalies in the incident. Required. Known values are:
     "Low", "Medium", and "High".
    :vartype severity: str or ~azure.ai.metricsadvisor.models.AnomalySeverity
    :ivar status: incident status

     only return for alerting incident result. Known values are: "Active" and "Resolved".
    :vartype status: str or ~azure.ai.metricsadvisor.models.AnomalyIncidentStatus
    :ivar value_of_root_node: value of the root node.
    :vartype value_of_root_node: float
    :ivar expected_value_of_root_node: expected value of the root node given by smart detector.
    :vartype expected_value_of_root_node: float
    :ivar dimension_key: dimension specified for series group. Required.
    :vartype dimension_key: dict[str, str]
    """

    _validation = {
        "data_feed_id": {"readonly": True},
        "metric_id": {"readonly": True},
        "detection_configuration_id": {"readonly": True},
        "id": {"required": True},
        "start_time": {"required": True},
        "last_time": {"required": True},
        "severity": {"required": True},
        "status": {"readonly": True},
        "value_of_root_node": {"readonly": True},
        "expected_value_of_root_node": {"readonly": True},
        "dimension_key": {"required": True},
    }

    _attribute_map = {
        "data_feed_id": {"key": "dataFeedId", "type": "str"},
        "metric_id": {"key": "metricId", "type": "str"},
        "detection_configuration_id": {"key": "anomalyDetectionConfigurationId", "type": "str"},
        "id": {"key": "incidentId", "type": "str"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "last_time": {"key": "lastTime", "type": "iso-8601"},
        "severity": {"key": "property.maxSeverity", "type": "str"},
        "status": {"key": "property.incidentStatus", "type": "str"},
        "value_of_root_node": {"key": "property.valueOfRootNode", "type": "float"},
        "expected_value_of_root_node": {"key": "property.expectedValueOfRootNode", "type": "float"},
        "dimension_key": {"key": "rootNode.dimension", "type": "{str}"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        start_time: datetime.datetime,
        last_time: datetime.datetime,
        severity: Union[str, "_models.AnomalySeverity"],
        dimension_key: Dict[str, str],
        **kwargs
    ):
        """
        :keyword id: incident id. Required.
        :paramtype id: str
        :keyword start_time: incident start time. Required.
        :paramtype start_time: ~datetime.datetime
        :keyword last_time: incident last time. Required.
        :paramtype last_time: ~datetime.datetime
        :keyword severity: max severity of latest anomalies in the incident. Required. Known values
         are: "Low", "Medium", and "High".
        :paramtype severity: str or ~azure.ai.metricsadvisor.models.AnomalySeverity
        :keyword dimension_key: dimension specified for series group. Required.
        :paramtype dimension_key: dict[str, str]
        """
        super().__init__(**kwargs)
        self.data_feed_id = None
        self.metric_id = None
        self.detection_configuration_id = None
        self.id = id
        self.start_time = start_time
        self.last_time = last_time
        self.severity = severity
        self.status = None
        self.value_of_root_node = None
        self.expected_value_of_root_node = None
        self.dimension_key = dimension_key


class AnomalyResultList(msrest.serialization.Model):
    """AnomalyResultList.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar next_link:
    :vartype next_link: str
    :ivar value: Required.
    :vartype value: list[~azure.ai.metricsadvisor.models.DataPointAnomaly]
    """

    _validation = {
        "next_link": {"readonly": True},
        "value": {"required": True},
    }

    _attribute_map = {
        "next_link": {"key": "@nextLink", "type": "str"},
        "value": {"key": "value", "type": "[DataPointAnomaly]"},
    }

    def __init__(self, *, value: List["_models.DataPointAnomaly"], **kwargs):
        """
        :keyword value: Required.
        :paramtype value: list[~azure.ai.metricsadvisor.models.DataPointAnomaly]
        """
        super().__init__(**kwargs)
        self.next_link = None
        self.value = value


class AzureApplicationInsightsDataFeedSource(msrest.serialization.Model):
    """AzureApplicationInsightsDataFeedSource.

    All required parameters must be populated in order to send to Azure.

    :ivar azure_cloud: The Azure cloud that this Azure Application Insights in.
    :vartype azure_cloud: str
    :ivar application_id: The application id of this Azure Application Insights.
    :vartype application_id: str
    :ivar api_key: The API Key that can access this Azure Application Insights.
    :vartype api_key: str
    :ivar query: The statement to query this Azure Application Insights. Required.
    :vartype query: str
    """

    _validation = {
        "query": {"required": True},
    }

    _attribute_map = {
        "azure_cloud": {"key": "azureCloud", "type": "str"},
        "application_id": {"key": "applicationId", "type": "str"},
        "api_key": {"key": "apiKey", "type": "str"},
        "query": {"key": "query", "type": "str"},
    }

    def __init__(
        self,
        *,
        query: str,
        azure_cloud: Optional[str] = None,
        application_id: Optional[str] = None,
        api_key: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword azure_cloud: The Azure cloud that this Azure Application Insights in.
        :paramtype azure_cloud: str
        :keyword application_id: The application id of this Azure Application Insights.
        :paramtype application_id: str
        :keyword api_key: The API Key that can access this Azure Application Insights.
        :paramtype api_key: str
        :keyword query: The statement to query this Azure Application Insights. Required.
        :paramtype query: str
        """
        super().__init__(**kwargs)
        self.azure_cloud = azure_cloud
        self.application_id = application_id
        self.api_key = api_key
        self.query = query


class AzureBlobDataFeedSource(msrest.serialization.Model):
    """AzureBlobDataFeedSource.

    All required parameters must be populated in order to send to Azure.

    :ivar connection_string: The connection string of this Azure Blob.
    :vartype connection_string: str
    :ivar container: The container name in this Azure Blob. Required.
    :vartype container: str
    :ivar blob_template: The path template in this container. Required.
    :vartype blob_template: str
    """

    _validation = {
        "container": {"required": True},
        "blob_template": {"required": True},
    }

    _attribute_map = {
        "connection_string": {"key": "connectionString", "type": "str"},
        "container": {"key": "container", "type": "str"},
        "blob_template": {"key": "blobTemplate", "type": "str"},
    }

    def __init__(self, *, container: str, blob_template: str, connection_string: Optional[str] = None, **kwargs):
        """
        :keyword connection_string: The connection string of this Azure Blob.
        :paramtype connection_string: str
        :keyword container: The container name in this Azure Blob. Required.
        :paramtype container: str
        :keyword blob_template: The path template in this container. Required.
        :paramtype blob_template: str
        """
        super().__init__(**kwargs)
        self.connection_string = connection_string
        self.container = container
        self.blob_template = blob_template


class AzureCosmosDbDataFeedSource(msrest.serialization.Model):
    """AzureCosmosDbDataFeedSource.

    All required parameters must be populated in order to send to Azure.

    :ivar connection_string: The connection string of this Azure CosmosDB.
    :vartype connection_string: str
    :ivar sql_query: The statement to query this collection. Required.
    :vartype sql_query: str
    :ivar database: A database name in this Azure CosmosDB. Required.
    :vartype database: str
    :ivar collection_id: A collection id in this database. Required.
    :vartype collection_id: str
    """

    _validation = {
        "sql_query": {"required": True},
        "database": {"required": True},
        "collection_id": {"required": True},
    }

    _attribute_map = {
        "connection_string": {"key": "connectionString", "type": "str"},
        "sql_query": {"key": "sqlQuery", "type": "str"},
        "database": {"key": "database", "type": "str"},
        "collection_id": {"key": "collectionId", "type": "str"},
    }

    def __init__(
        self, *, sql_query: str, database: str, collection_id: str, connection_string: Optional[str] = None, **kwargs
    ):
        """
        :keyword connection_string: The connection string of this Azure CosmosDB.
        :paramtype connection_string: str
        :keyword sql_query: The statement to query this collection. Required.
        :paramtype sql_query: str
        :keyword database: A database name in this Azure CosmosDB. Required.
        :paramtype database: str
        :keyword collection_id: A collection id in this database. Required.
        :paramtype collection_id: str
        """
        super().__init__(**kwargs)
        self.connection_string = connection_string
        self.sql_query = sql_query
        self.database = database
        self.collection_id = collection_id


class AzureDataExplorerDataFeedSource(msrest.serialization.Model):
    """AzureDataExplorerDataFeedSource.

    All required parameters must be populated in order to send to Azure.

    :ivar connection_string: The connection string of this database.
    :vartype connection_string: str
    :ivar query: The script to query this database. Required.
    :vartype query: str
    """

    _validation = {
        "query": {"required": True},
    }

    _attribute_map = {
        "connection_string": {"key": "connectionString", "type": "str"},
        "query": {"key": "query", "type": "str"},
    }

    def __init__(self, *, query: str, connection_string: Optional[str] = None, **kwargs):
        """
        :keyword connection_string: The connection string of this database.
        :paramtype connection_string: str
        :keyword query: The script to query this database. Required.
        :paramtype query: str
        """
        super().__init__(**kwargs)
        self.connection_string = connection_string
        self.query = query


class AzureDataLakeStorageGen2DataFeedSource(msrest.serialization.Model):
    """AzureDataLakeStorageGen2DataFeedSource.

    All required parameters must be populated in order to send to Azure.

    :ivar account_name: The account name of this Azure Data Lake.
    :vartype account_name: str
    :ivar account_key: The account key that can access this Azure Data Lake.
    :vartype account_key: str
    :ivar file_system_name: The file system (container) name in this Azure Data Lake. Required.
    :vartype file_system_name: str
    :ivar directory_template: The directory template under this file system. Required.
    :vartype directory_template: str
    :ivar file_template: The file template. Required.
    :vartype file_template: str
    """

    _validation = {
        "file_system_name": {"required": True},
        "directory_template": {"required": True},
        "file_template": {"required": True},
    }

    _attribute_map = {
        "account_name": {"key": "accountName", "type": "str"},
        "account_key": {"key": "accountKey", "type": "str"},
        "file_system_name": {"key": "fileSystemName", "type": "str"},
        "directory_template": {"key": "directoryTemplate", "type": "str"},
        "file_template": {"key": "fileTemplate", "type": "str"},
    }

    def __init__(
        self,
        *,
        file_system_name: str,
        directory_template: str,
        file_template: str,
        account_name: Optional[str] = None,
        account_key: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword account_name: The account name of this Azure Data Lake.
        :paramtype account_name: str
        :keyword account_key: The account key that can access this Azure Data Lake.
        :paramtype account_key: str
        :keyword file_system_name: The file system (container) name in this Azure Data Lake. Required.
        :paramtype file_system_name: str
        :keyword directory_template: The directory template under this file system. Required.
        :paramtype directory_template: str
        :keyword file_template: The file template. Required.
        :paramtype file_template: str
        """
        super().__init__(**kwargs)
        self.account_name = account_name
        self.account_key = account_key
        self.file_system_name = file_system_name
        self.directory_template = directory_template
        self.file_template = file_template


class AzureEventHubsDataFeedSource(msrest.serialization.Model):
    """AzureEventHubsDataFeedSource.

    All required parameters must be populated in order to send to Azure.

    :ivar connection_string: The connection string of this Azure Event Hubs.
    :vartype connection_string: str
    :ivar consumer_group: The consumer group to be used in this data feed. Required.
    :vartype consumer_group: str
    """

    _validation = {
        "consumer_group": {"required": True},
    }

    _attribute_map = {
        "connection_string": {"key": "connectionString", "type": "str"},
        "consumer_group": {"key": "consumerGroup", "type": "str"},
    }

    def __init__(self, *, consumer_group: str, connection_string: Optional[str] = None, **kwargs):
        """
        :keyword connection_string: The connection string of this Azure Event Hubs.
        :paramtype connection_string: str
        :keyword consumer_group: The consumer group to be used in this data feed. Required.
        :paramtype consumer_group: str
        """
        super().__init__(**kwargs)
        self.connection_string = connection_string
        self.consumer_group = consumer_group


class AzureLogAnalyticsDataFeedSource(msrest.serialization.Model):
    """AzureLogAnalyticsDataFeedSource.

    All required parameters must be populated in order to send to Azure.

    :ivar tenant_id: The tenant id of service principal that have access to this Log Analytics.
    :vartype tenant_id: str
    :ivar client_id: The client id of service principal that have access to this Log Analytics.
    :vartype client_id: str
    :ivar client_secret: The client secret of service principal that have access to this Log
     Analytics.
    :vartype client_secret: str
    :ivar workspace_id: The workspace id of this Log Analytics. Required.
    :vartype workspace_id: str
    :ivar query: The KQL (Kusto Query Language) query to fetch data from this Log Analytics.
     Required.
    :vartype query: str
    """

    _validation = {
        "workspace_id": {"required": True},
        "query": {"required": True},
    }

    _attribute_map = {
        "tenant_id": {"key": "tenantId", "type": "str"},
        "client_id": {"key": "clientId", "type": "str"},
        "client_secret": {"key": "clientSecret", "type": "str"},
        "workspace_id": {"key": "workspaceId", "type": "str"},
        "query": {"key": "query", "type": "str"},
    }

    def __init__(
        self,
        *,
        workspace_id: str,
        query: str,
        tenant_id: Optional[str] = None,
        client_id: Optional[str] = None,
        client_secret: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword tenant_id: The tenant id of service principal that have access to this Log Analytics.
        :paramtype tenant_id: str
        :keyword client_id: The client id of service principal that have access to this Log Analytics.
        :paramtype client_id: str
        :keyword client_secret: The client secret of service principal that have access to this Log
         Analytics.
        :paramtype client_secret: str
        :keyword workspace_id: The workspace id of this Log Analytics. Required.
        :paramtype workspace_id: str
        :keyword query: The KQL (Kusto Query Language) query to fetch data from this Log Analytics.
         Required.
        :paramtype query: str
        """
        super().__init__(**kwargs)
        self.tenant_id = tenant_id
        self.client_id = client_id
        self.client_secret = client_secret
        self.workspace_id = workspace_id
        self.query = query


class AzureTableDataFeedSource(msrest.serialization.Model):
    """AzureTableDataFeedSource.

    All required parameters must be populated in order to send to Azure.

    :ivar connection_string: The connection string of this Azure Table.
    :vartype connection_string: str
    :ivar table: A table name in this Azure Table. Required.
    :vartype table: str
    :ivar query: The statement to query this table. Please find syntax and details from Azure Table
     documents. Required.
    :vartype query: str
    """

    _validation = {
        "table": {"required": True},
        "query": {"required": True},
    }

    _attribute_map = {
        "connection_string": {"key": "connectionString", "type": "str"},
        "table": {"key": "table", "type": "str"},
        "query": {"key": "query", "type": "str"},
    }

    def __init__(self, *, table: str, query: str, connection_string: Optional[str] = None, **kwargs):
        """
        :keyword connection_string: The connection string of this Azure Table.
        :paramtype connection_string: str
        :keyword table: A table name in this Azure Table. Required.
        :paramtype table: str
        :keyword query: The statement to query this table. Please find syntax and details from Azure
         Table documents. Required.
        :paramtype query: str
        """
        super().__init__(**kwargs)
        self.connection_string = connection_string
        self.table = table
        self.query = query


class ChangePointFeedback(MetricFeedback):
    """ChangePointFeedback.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar feedback_type: feedback type. Required. Known values are: "Anomaly", "ChangePoint",
     "Period", and "Comment".
    :vartype feedback_type: str or ~azure.ai.metricsadvisor.models.FeedbackType
    :ivar id: feedback unique id.
    :vartype id: str
    :ivar created_time: feedback created time.
    :vartype created_time: ~datetime.datetime
    :ivar user_principal: user who gives this feedback.
    :vartype user_principal: str
    :ivar metric_id: metric unique id. Required.
    :vartype metric_id: str
    :ivar dimension_key: metric dimension filter. Required.
    :vartype dimension_key: dict[str, str]
    :ivar start_time: the start timestamp of feedback time range. Required.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: the end timestamp of feedback time range, when equals to startTime means only
     one timestamp. Required.
    :vartype end_time: ~datetime.datetime
    :ivar value: Required. Known values are: "AutoDetect", "ChangePoint", and "NotChangePoint".
    :vartype value: str or ~azure.ai.metricsadvisor.models.ChangePointValue
    """

    _validation = {
        "feedback_type": {"required": True},
        "id": {"readonly": True},
        "created_time": {"readonly": True},
        "user_principal": {"readonly": True},
        "metric_id": {"required": True},
        "dimension_key": {"required": True},
        "start_time": {"required": True},
        "end_time": {"required": True},
        "value": {"required": True},
    }

    _attribute_map = {
        "feedback_type": {"key": "feedbackType", "type": "str"},
        "id": {"key": "feedbackId", "type": "str"},
        "created_time": {"key": "createdTime", "type": "iso-8601"},
        "user_principal": {"key": "userPrincipal", "type": "str"},
        "metric_id": {"key": "metricId", "type": "str"},
        "dimension_key": {"key": "dimensionFilter.dimension", "type": "{str}"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
        "value": {"key": "value.changePointValue", "type": "str"},
    }

    def __init__(
        self,
        *,
        metric_id: str,
        dimension_key: Dict[str, str],
        start_time: datetime.datetime,
        end_time: datetime.datetime,
        value: Union[str, "_models.ChangePointValue"],
        **kwargs
    ):
        """
        :keyword metric_id: metric unique id. Required.
        :paramtype metric_id: str
        :keyword dimension_key: metric dimension filter. Required.
        :paramtype dimension_key: dict[str, str]
        :keyword start_time: the start timestamp of feedback time range. Required.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: the end timestamp of feedback time range, when equals to startTime means
         only one timestamp. Required.
        :paramtype end_time: ~datetime.datetime
        :keyword value: Required. Known values are: "AutoDetect", "ChangePoint", and "NotChangePoint".
        :paramtype value: str or ~azure.ai.metricsadvisor.models.ChangePointValue
        """
        super().__init__(metric_id=metric_id, dimension_key=dimension_key, **kwargs)
        self.feedback_type = "ChangePoint"  # type: str
        self.start_time = start_time
        self.end_time = end_time
        self.value = value


class ChangeThresholdCondition(msrest.serialization.Model):
    """ChangeThresholdCondition.

    :ivar change_percentage: change percentage, value range : [0, +∞).
    :vartype change_percentage: float
    :ivar shift_point: shift point, value range : [1, +∞).
    :vartype shift_point: int
    :ivar within_range: if the withinRange = true, detected data is abnormal when the value falls
     in the range, in this case anomalyDetectorDirection must be Both
     if the withinRange = false, detected data is abnormal when the value falls out of the range.
    :vartype within_range: bool
    :ivar anomaly_detector_direction: detection direction. Known values are: "Both", "Down", and
     "Up".
    :vartype anomaly_detector_direction: str or
     ~azure.ai.metricsadvisor.models.AnomalyDetectorDirection
    :ivar suppress_condition:
    :vartype suppress_condition: ~azure.ai.metricsadvisor.models.SuppressCondition
    """

    _attribute_map = {
        "change_percentage": {"key": "changePercentage", "type": "float"},
        "shift_point": {"key": "shiftPoint", "type": "int"},
        "within_range": {"key": "withinRange", "type": "bool"},
        "anomaly_detector_direction": {"key": "anomalyDetectorDirection", "type": "str"},
        "suppress_condition": {"key": "suppressCondition", "type": "SuppressCondition"},
    }

    def __init__(
        self,
        *,
        change_percentage: Optional[float] = None,
        shift_point: Optional[int] = None,
        within_range: Optional[bool] = None,
        anomaly_detector_direction: Optional[Union[str, "_models.AnomalyDetectorDirection"]] = None,
        suppress_condition: Optional["_models.SuppressCondition"] = None,
        **kwargs
    ):
        """
        :keyword change_percentage: change percentage, value range : [0, +∞).
        :paramtype change_percentage: float
        :keyword shift_point: shift point, value range : [1, +∞).
        :paramtype shift_point: int
        :keyword within_range: if the withinRange = true, detected data is abnormal when the value
         falls in the range, in this case anomalyDetectorDirection must be Both
         if the withinRange = false, detected data is abnormal when the value falls out of the range.
        :paramtype within_range: bool
        :keyword anomaly_detector_direction: detection direction. Known values are: "Both", "Down", and
         "Up".
        :paramtype anomaly_detector_direction: str or
         ~azure.ai.metricsadvisor.models.AnomalyDetectorDirection
        :keyword suppress_condition:
        :paramtype suppress_condition: ~azure.ai.metricsadvisor.models.SuppressCondition
        """
        super().__init__(**kwargs)
        self.change_percentage = change_percentage
        self.shift_point = shift_point
        self.within_range = within_range
        self.anomaly_detector_direction = anomaly_detector_direction
        self.suppress_condition = suppress_condition


class CommentFeedback(MetricFeedback):
    """CommentFeedback.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar feedback_type: feedback type. Required. Known values are: "Anomaly", "ChangePoint",
     "Period", and "Comment".
    :vartype feedback_type: str or ~azure.ai.metricsadvisor.models.FeedbackType
    :ivar id: feedback unique id.
    :vartype id: str
    :ivar created_time: feedback created time.
    :vartype created_time: ~datetime.datetime
    :ivar user_principal: user who gives this feedback.
    :vartype user_principal: str
    :ivar metric_id: metric unique id. Required.
    :vartype metric_id: str
    :ivar dimension_key: metric dimension filter. Required.
    :vartype dimension_key: dict[str, str]
    :ivar start_time: the start timestamp of feedback time range.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: the end timestamp of feedback time range, when equals to startTime means only
     one timestamp.
    :vartype end_time: ~datetime.datetime
    :ivar value: the comment string. Required.
    :vartype value: str
    """

    _validation = {
        "feedback_type": {"required": True},
        "id": {"readonly": True},
        "created_time": {"readonly": True},
        "user_principal": {"readonly": True},
        "metric_id": {"required": True},
        "dimension_key": {"required": True},
        "value": {"required": True},
    }

    _attribute_map = {
        "feedback_type": {"key": "feedbackType", "type": "str"},
        "id": {"key": "feedbackId", "type": "str"},
        "created_time": {"key": "createdTime", "type": "iso-8601"},
        "user_principal": {"key": "userPrincipal", "type": "str"},
        "metric_id": {"key": "metricId", "type": "str"},
        "dimension_key": {"key": "dimensionFilter.dimension", "type": "{str}"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
        "value": {"key": "value.commentValue", "type": "str"},
    }

    def __init__(
        self,
        *,
        metric_id: str,
        dimension_key: Dict[str, str],
        value: str,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword metric_id: metric unique id. Required.
        :paramtype metric_id: str
        :keyword dimension_key: metric dimension filter. Required.
        :paramtype dimension_key: dict[str, str]
        :keyword start_time: the start timestamp of feedback time range.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: the end timestamp of feedback time range, when equals to startTime means
         only one timestamp.
        :paramtype end_time: ~datetime.datetime
        :keyword value: the comment string. Required.
        :paramtype value: str
        """
        super().__init__(metric_id=metric_id, dimension_key=dimension_key, **kwargs)
        self.feedback_type = "Comment"  # type: str
        self.start_time = start_time
        self.end_time = end_time
        self.value = value


class DataFeed(msrest.serialization.Model):  # pylint: disable=too-many-instance-attributes
    """DataFeed.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar data_source_type: data source type. Required. Known values are:
     "AzureApplicationInsights", "AzureBlob", "AzureCosmosDB", "AzureDataExplorer",
     "AzureDataLakeStorageGen2", "AzureEventHubs", "AzureLogAnalytics", "AzureTable", "InfluxDB",
     "MongoDB", "MySql", "PostgreSql", and "SqlServer".
    :vartype data_source_type: str or ~azure.ai.metricsadvisor.models.DatasourceType
    :ivar id: data feed unique id.
    :vartype id: str
    :ivar name: data feed name. Required.
    :vartype name: str
    :ivar data_feed_description: data feed description.
    :vartype data_feed_description: str
    :ivar granularity_name: granularity of the time series. Required. Known values are: "Yearly",
     "Monthly", "Weekly", "Daily", "Hourly", "Minutely", and "Custom".
    :vartype granularity_name: str or ~azure.ai.metricsadvisor.models.DataFeedGranularityType
    :ivar granularity_amount: if granularity is custom,it is required.
    :vartype granularity_amount: int
    :ivar metrics: measure list. Required.
    :vartype metrics: list[~azure.ai.metricsadvisor.models.DataFeedMetric]
    :ivar dimension: dimension list.
    :vartype dimension: list[~azure.ai.metricsadvisor.models.DataFeedDimension]
    :ivar timestamp_column: user-defined timestamp column. if timestampColumn is null, start time
     of every time slice will be used as default value.
    :vartype timestamp_column: str
    :ivar data_start_from: ingestion start time. Required.
    :vartype data_start_from: ~datetime.datetime
    :ivar start_offset_in_seconds: the time that the beginning of data ingestion task will delay
     for every data slice according to this offset.
    :vartype start_offset_in_seconds: int
    :ivar max_concurrency: the max concurrency of data ingestion queries against user data source.
     0 means no limitation.
    :vartype max_concurrency: int
    :ivar min_retry_interval_in_seconds: the min retry interval for failed data ingestion tasks.
    :vartype min_retry_interval_in_seconds: int
    :ivar stop_retry_after_in_seconds: stop retry data ingestion after the data slice first
     schedule time in seconds.
    :vartype stop_retry_after_in_seconds: int
    :ivar need_rollup: mark if the data feed need rollup. Known values are: "NoRollup",
     "NeedRollup", and "AlreadyRollup".
    :vartype need_rollup: str or ~azure.ai.metricsadvisor.models.DataFeedRollupType
    :ivar roll_up_method: roll up method. Known values are: "None", "Sum", "Max", "Min", "Avg", and
     "Count".
    :vartype roll_up_method: str or ~azure.ai.metricsadvisor.models.DataFeedAutoRollupMethod
    :ivar roll_up_columns: roll up columns.
    :vartype roll_up_columns: list[str]
    :ivar all_up_identification: the identification value for the row of calculated all-up value.
    :vartype all_up_identification: str
    :ivar fill_missing_point_type: the type of fill missing point for anomaly detection. Known
     values are: "SmartFilling", "PreviousValue", "CustomValue", and "NoFilling".
    :vartype fill_missing_point_type: str or
     ~azure.ai.metricsadvisor.models.DatasourceMissingDataPointFillType
    :ivar fill_missing_point_value: the value of fill missing point for anomaly detection.
    :vartype fill_missing_point_value: float
    :ivar access_mode: data feed access mode, default is Private. Known values are: "Private" and
     "Public".
    :vartype access_mode: str or ~azure.ai.metricsadvisor.models.DataFeedAccessMode
    :ivar admins: data feed administrator.
    :vartype admins: list[str]
    :ivar viewers: data feed viewer.
    :vartype viewers: list[str]
    :ivar is_admin: the query user is one of data feed administrator or not.
    :vartype is_admin: bool
    :ivar creator: data feed creator.
    :vartype creator: str
    :ivar status: data feed status. Known values are: "Active" and "Paused".
    :vartype status: str or ~azure.ai.metricsadvisor.models.DataFeedStatus
    :ivar created_time: data feed created time.
    :vartype created_time: ~datetime.datetime
    :ivar action_link_template: action link for alert.
    :vartype action_link_template: str
    :ivar authentication_type: authentication type for corresponding data source. Known values are:
     "Basic", "ManagedIdentity", "AzureSQLConnectionString", "DataLakeGen2SharedKey",
     "ServicePrincipal", and "ServicePrincipalInKV".
    :vartype authentication_type: str or
     ~azure.ai.metricsadvisor.models.DatasourceAuthenticationType
    :ivar credential_id: The credential entity id.
    :vartype credential_id: str
    :ivar data_source_parameter: Any object.
    :vartype data_source_parameter: JSON
    """

    _validation = {
        "data_source_type": {"required": True},
        "id": {"readonly": True},
        "name": {"required": True},
        "granularity_name": {"required": True},
        "metrics": {"required": True, "unique": True},
        "dimension": {"unique": True},
        "data_start_from": {"required": True},
        "roll_up_columns": {"unique": True},
        "admins": {"unique": True},
        "viewers": {"unique": True},
        "is_admin": {"readonly": True},
        "creator": {"readonly": True},
        "created_time": {"readonly": True},
    }

    _attribute_map = {
        "data_source_type": {"key": "dataSourceType", "type": "str"},
        "id": {"key": "dataFeedId", "type": "str"},
        "name": {"key": "dataFeedName", "type": "str"},
        "data_feed_description": {"key": "dataFeedDescription", "type": "str"},
        "granularity_name": {"key": "granularityName", "type": "str"},
        "granularity_amount": {"key": "granularityAmount", "type": "int"},
        "metrics": {"key": "metrics", "type": "[DataFeedMetric]"},
        "dimension": {"key": "dimension", "type": "[DataFeedDimension]"},
        "timestamp_column": {"key": "timestampColumn", "type": "str"},
        "data_start_from": {"key": "dataStartFrom", "type": "iso-8601"},
        "start_offset_in_seconds": {"key": "startOffsetInSeconds", "type": "int"},
        "max_concurrency": {"key": "maxConcurrency", "type": "int"},
        "min_retry_interval_in_seconds": {"key": "minRetryIntervalInSeconds", "type": "int"},
        "stop_retry_after_in_seconds": {"key": "stopRetryAfterInSeconds", "type": "int"},
        "need_rollup": {"key": "needRollup", "type": "str"},
        "roll_up_method": {"key": "rollUpMethod", "type": "str"},
        "roll_up_columns": {"key": "rollUpColumns", "type": "[str]"},
        "all_up_identification": {"key": "allUpIdentification", "type": "str"},
        "fill_missing_point_type": {"key": "fillMissingPointType", "type": "str"},
        "fill_missing_point_value": {"key": "fillMissingPointValue", "type": "float"},
        "access_mode": {"key": "viewMode", "type": "str"},
        "admins": {"key": "admins", "type": "[str]"},
        "viewers": {"key": "viewers", "type": "[str]"},
        "is_admin": {"key": "isAdmin", "type": "bool"},
        "creator": {"key": "creator", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "created_time": {"key": "createdTime", "type": "iso-8601"},
        "action_link_template": {"key": "actionLinkTemplate", "type": "str"},
        "authentication_type": {"key": "authenticationType", "type": "str"},
        "credential_id": {"key": "credentialId", "type": "str"},
        "data_source_parameter": {"key": "dataSourceParameter", "type": "object"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        name: str,
        granularity_name: Union[str, "_models.DataFeedGranularityType"],
        metrics: List["_models.DataFeedMetric"],
        data_start_from: datetime.datetime,
        data_feed_description: str = "",
        granularity_amount: Optional[int] = None,
        dimension: Optional[List["_models.DataFeedDimension"]] = None,
        timestamp_column: str = "",
        start_offset_in_seconds: int = 0,
        max_concurrency: int = -1,
        min_retry_interval_in_seconds: int = -1,
        stop_retry_after_in_seconds: int = -1,
        need_rollup: Union[str, "_models.DataFeedRollupType"] = "NoRollup",
        roll_up_method: Union[str, "_models.DataFeedAutoRollupMethod"] = "None",
        roll_up_columns: Optional[List[str]] = None,
        all_up_identification: Optional[str] = None,
        fill_missing_point_type: Union[str, "_models.DatasourceMissingDataPointFillType"] = "SmartFilling",
        fill_missing_point_value: Optional[float] = None,
        access_mode: Union[str, "_models.DataFeedAccessMode"] = "Private",
        admins: Optional[List[str]] = None,
        viewers: Optional[List[str]] = None,
        status: Optional[Union[str, "_models.DataFeedStatus"]] = None,
        action_link_template: str = "",
        authentication_type: Union[str, "_models.DatasourceAuthenticationType"] = "Basic",
        credential_id: Optional[str] = None,
        data_source_parameter: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword name: data feed name. Required.
        :paramtype name: str
        :keyword data_feed_description: data feed description.
        :paramtype data_feed_description: str
        :keyword granularity_name: granularity of the time series. Required. Known values are:
         "Yearly", "Monthly", "Weekly", "Daily", "Hourly", "Minutely", and "Custom".
        :paramtype granularity_name: str or ~azure.ai.metricsadvisor.models.DataFeedGranularityType
        :keyword granularity_amount: if granularity is custom,it is required.
        :paramtype granularity_amount: int
        :keyword metrics: measure list. Required.
        :paramtype metrics: list[~azure.ai.metricsadvisor.models.DataFeedMetric]
        :keyword dimension: dimension list.
        :paramtype dimension: list[~azure.ai.metricsadvisor.models.DataFeedDimension]
        :keyword timestamp_column: user-defined timestamp column. if timestampColumn is null, start
         time of every time slice will be used as default value.
        :paramtype timestamp_column: str
        :keyword data_start_from: ingestion start time. Required.
        :paramtype data_start_from: ~datetime.datetime
        :keyword start_offset_in_seconds: the time that the beginning of data ingestion task will delay
         for every data slice according to this offset.
        :paramtype start_offset_in_seconds: int
        :keyword max_concurrency: the max concurrency of data ingestion queries against user data
         source. 0 means no limitation.
        :paramtype max_concurrency: int
        :keyword min_retry_interval_in_seconds: the min retry interval for failed data ingestion tasks.
        :paramtype min_retry_interval_in_seconds: int
        :keyword stop_retry_after_in_seconds: stop retry data ingestion after the data slice first
         schedule time in seconds.
        :paramtype stop_retry_after_in_seconds: int
        :keyword need_rollup: mark if the data feed need rollup. Known values are: "NoRollup",
         "NeedRollup", and "AlreadyRollup".
        :paramtype need_rollup: str or ~azure.ai.metricsadvisor.models.DataFeedRollupType
        :keyword roll_up_method: roll up method. Known values are: "None", "Sum", "Max", "Min", "Avg",
         and "Count".
        :paramtype roll_up_method: str or ~azure.ai.metricsadvisor.models.DataFeedAutoRollupMethod
        :keyword roll_up_columns: roll up columns.
        :paramtype roll_up_columns: list[str]
        :keyword all_up_identification: the identification value for the row of calculated all-up
         value.
        :paramtype all_up_identification: str
        :keyword fill_missing_point_type: the type of fill missing point for anomaly detection. Known
         values are: "SmartFilling", "PreviousValue", "CustomValue", and "NoFilling".
        :paramtype fill_missing_point_type: str or
         ~azure.ai.metricsadvisor.models.DatasourceMissingDataPointFillType
        :keyword fill_missing_point_value: the value of fill missing point for anomaly detection.
        :paramtype fill_missing_point_value: float
        :keyword access_mode: data feed access mode, default is Private. Known values are: "Private"
         and "Public".
        :paramtype access_mode: str or ~azure.ai.metricsadvisor.models.DataFeedAccessMode
        :keyword admins: data feed administrator.
        :paramtype admins: list[str]
        :keyword viewers: data feed viewer.
        :paramtype viewers: list[str]
        :keyword status: data feed status. Known values are: "Active" and "Paused".
        :paramtype status: str or ~azure.ai.metricsadvisor.models.DataFeedStatus
        :keyword action_link_template: action link for alert.
        :paramtype action_link_template: str
        :keyword authentication_type: authentication type for corresponding data source. Known values
         are: "Basic", "ManagedIdentity", "AzureSQLConnectionString", "DataLakeGen2SharedKey",
         "ServicePrincipal", and "ServicePrincipalInKV".
        :paramtype authentication_type: str or
         ~azure.ai.metricsadvisor.models.DatasourceAuthenticationType
        :keyword credential_id: The credential entity id.
        :paramtype credential_id: str
        :keyword data_source_parameter: Any object.
        :paramtype data_source_parameter: JSON
        """
        super().__init__(**kwargs)
        self.data_source_type = None  # type: Optional[str]
        self.id = None
        self.name = name
        self.data_feed_description = data_feed_description
        self.granularity_name = granularity_name
        self.granularity_amount = granularity_amount
        self.metrics = metrics
        self.dimension = dimension
        self.timestamp_column = timestamp_column
        self.data_start_from = data_start_from
        self.start_offset_in_seconds = start_offset_in_seconds
        self.max_concurrency = max_concurrency
        self.min_retry_interval_in_seconds = min_retry_interval_in_seconds
        self.stop_retry_after_in_seconds = stop_retry_after_in_seconds
        self.need_rollup = need_rollup
        self.roll_up_method = roll_up_method
        self.roll_up_columns = roll_up_columns
        self.all_up_identification = all_up_identification
        self.fill_missing_point_type = fill_missing_point_type
        self.fill_missing_point_value = fill_missing_point_value
        self.access_mode = access_mode
        self.admins = admins
        self.viewers = viewers
        self.is_admin = None
        self.creator = None
        self.status = status
        self.created_time = None
        self.action_link_template = action_link_template
        self.authentication_type = authentication_type
        self.credential_id = credential_id
        self.data_source_parameter = data_source_parameter


class DataFeedDimension(msrest.serialization.Model):
    """DataFeedDimension.

    All required parameters must be populated in order to send to Azure.

    :ivar name: dimension name. Required.
    :vartype name: str
    :ivar display_name: dimension display name.
    :vartype display_name: str
    """

    _validation = {
        "name": {"required": True},
        "display_name": {"pattern": r"[.a-zA-Z0-9_-]+"},
    }

    _attribute_map = {
        "name": {"key": "dimensionName", "type": "str"},
        "display_name": {"key": "dimensionDisplayName", "type": "str"},
    }

    def __init__(self, *, name: str, display_name: Optional[str] = None, **kwargs):
        """
        :keyword name: dimension name. Required.
        :paramtype name: str
        :keyword display_name: dimension display name.
        :paramtype display_name: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.display_name = display_name


class DataFeedIngestionProgress(msrest.serialization.Model):
    """DataFeedIngestionProgress.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar latest_success_timestamp: the timestamp of latest success ingestion job.
     null indicates not available.
    :vartype latest_success_timestamp: ~datetime.datetime
    :ivar latest_active_timestamp: the timestamp of latest ingestion job with status update.
     null indicates not available.
    :vartype latest_active_timestamp: ~datetime.datetime
    """

    _validation = {
        "latest_success_timestamp": {"readonly": True},
        "latest_active_timestamp": {"readonly": True},
    }

    _attribute_map = {
        "latest_success_timestamp": {"key": "latestSuccessTimestamp", "type": "iso-8601"},
        "latest_active_timestamp": {"key": "latestActiveTimestamp", "type": "iso-8601"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.latest_success_timestamp = None
        self.latest_active_timestamp = None


class DataFeedIngestionStatus(msrest.serialization.Model):
    """DataFeedIngestionStatus.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar timestamp: data slice timestamp.
    :vartype timestamp: ~datetime.datetime
    :ivar status: latest ingestion task status for this data slice.
    :vartype status: str
    :ivar message: the trimmed message of last ingestion job.
    :vartype message: str
    """

    _validation = {
        "timestamp": {"readonly": True},
        "status": {"readonly": True},
        "message": {"readonly": True},
    }

    _attribute_map = {
        "timestamp": {"key": "timestamp", "type": "iso-8601"},
        "status": {"key": "status", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.timestamp = None
        self.status = None
        self.message = None


class DataFeedList(msrest.serialization.Model):
    """DataFeedList.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar next_link:
    :vartype next_link: str
    :ivar value:
    :vartype value: list[~azure.ai.metricsadvisor.models.DataFeed]
    """

    _validation = {
        "next_link": {"readonly": True},
        "value": {"readonly": True},
    }

    _attribute_map = {
        "next_link": {"key": "@nextLink", "type": "str"},
        "value": {"key": "value", "type": "[DataFeed]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.next_link = None
        self.value = None


class DataFeedMetric(msrest.serialization.Model):
    """DataFeedMetric.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: metric id.
    :vartype id: str
    :ivar name: metric name. Required.
    :vartype name: str
    :ivar display_name: metric display name.
    :vartype display_name: str
    :ivar description: metric description.
    :vartype description: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"required": True},
        "display_name": {"pattern": r"[.a-zA-Z0-9_-]+"},
    }

    _attribute_map = {
        "id": {"key": "metricId", "type": "str"},
        "name": {"key": "metricName", "type": "str"},
        "display_name": {"key": "metricDisplayName", "type": "str"},
        "description": {"key": "metricDescription", "type": "str"},
    }

    def __init__(self, *, name: str, display_name: Optional[str] = None, description: Optional[str] = None, **kwargs):
        """
        :keyword name: metric name. Required.
        :paramtype name: str
        :keyword display_name: metric display name.
        :paramtype display_name: str
        :keyword description: metric description.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = name
        self.display_name = display_name
        self.description = description


class DataPointAnomaly(msrest.serialization.Model):  # pylint: disable=too-many-instance-attributes
    """DataPointAnomaly.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar data_feed_id: data feed unique id

     only return for alerting anomaly result.
    :vartype data_feed_id: str
    :ivar metric_id: metric unique id

     only return for alerting anomaly result.
    :vartype metric_id: str
    :ivar detection_configuration_id: anomaly detection configuration unique id

     only return for alerting anomaly result.
    :vartype detection_configuration_id: str
    :ivar timestamp: anomaly time. Required.
    :vartype timestamp: ~datetime.datetime
    :ivar created_time: created time

     only return for alerting result.
    :vartype created_time: ~datetime.datetime
    :ivar modified_time: modified time

     only return for alerting result.
    :vartype modified_time: ~datetime.datetime
    :ivar dimension: dimension specified for series. Required.
    :vartype dimension: dict[str, str]
    :ivar severity: anomaly severity. Required. Known values are: "Low", "Medium", and "High".
    :vartype severity: str or ~azure.ai.metricsadvisor.models.AnomalySeverity
    :ivar status: anomaly status

     only return for alerting anomaly result.
    :vartype status: str
    :ivar value: value of the anomaly.
    :vartype value: float
    :ivar expected_value: expected value of the anomaly given by smart detector.
    :vartype expected_value: float
    """

    _validation = {
        "data_feed_id": {"readonly": True},
        "metric_id": {"readonly": True},
        "detection_configuration_id": {"readonly": True},
        "timestamp": {"required": True},
        "created_time": {"readonly": True},
        "modified_time": {"readonly": True},
        "dimension": {"required": True},
        "severity": {"required": True},
        "status": {"readonly": True},
        "value": {"readonly": True},
        "expected_value": {"readonly": True},
    }

    _attribute_map = {
        "data_feed_id": {"key": "dataFeedId", "type": "str"},
        "metric_id": {"key": "metricId", "type": "str"},
        "detection_configuration_id": {"key": "anomalyDetectionConfigurationId", "type": "str"},
        "timestamp": {"key": "timestamp", "type": "iso-8601"},
        "created_time": {"key": "createdTime", "type": "iso-8601"},
        "modified_time": {"key": "modifiedTime", "type": "iso-8601"},
        "dimension": {"key": "dimension", "type": "{str}"},
        "severity": {"key": "property.anomalySeverity", "type": "str"},
        "status": {"key": "property.anomalyStatus", "type": "str"},
        "value": {"key": "property.value", "type": "float"},
        "expected_value": {"key": "property.expectedValue", "type": "float"},
    }

    def __init__(
        self,
        *,
        timestamp: datetime.datetime,
        dimension: Dict[str, str],
        severity: Union[str, "_models.AnomalySeverity"],
        **kwargs
    ):
        """
        :keyword timestamp: anomaly time. Required.
        :paramtype timestamp: ~datetime.datetime
        :keyword dimension: dimension specified for series. Required.
        :paramtype dimension: dict[str, str]
        :keyword severity: anomaly severity. Required. Known values are: "Low", "Medium", and "High".
        :paramtype severity: str or ~azure.ai.metricsadvisor.models.AnomalySeverity
        """
        super().__init__(**kwargs)
        self.data_feed_id = None
        self.metric_id = None
        self.detection_configuration_id = None
        self.timestamp = timestamp
        self.created_time = None
        self.modified_time = None
        self.dimension = dimension
        self.severity = severity
        self.status = None
        self.value = None
        self.expected_value = None


class DatasourceCredential(msrest.serialization.Model):
    """DatasourceCredential.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    DatasourceSqlConnectionString, DatasourceDataLakeGen2SharedKey, DatasourceServicePrincipal,
    DatasourceServicePrincipalInKeyVault

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar credential_type: Type of data source credential. Required. Known values are:
     "AzureSQLConnectionString", "DataLakeGen2SharedKey", "ServicePrincipal", and
     "ServicePrincipalInKV".
    :vartype credential_type: str or ~azure.ai.metricsadvisor.models.DatasourceCredentialType
    :ivar id: Unique id of data source credential.
    :vartype id: str
    :ivar name: Name of data source credential. Required.
    :vartype name: str
    :ivar description: Description of data source credential.
    :vartype description: str
    """

    _validation = {
        "credential_type": {"required": True},
        "id": {"readonly": True},
        "name": {"required": True},
    }

    _attribute_map = {
        "credential_type": {"key": "dataSourceCredentialType", "type": "str"},
        "id": {"key": "dataSourceCredentialId", "type": "str"},
        "name": {"key": "dataSourceCredentialName", "type": "str"},
        "description": {"key": "dataSourceCredentialDescription", "type": "str"},
    }

    _subtype_map = {
        "credential_type": {
            "AzureSQLConnectionString": "DatasourceSqlConnectionString",
            "DataLakeGen2SharedKey": "DatasourceDataLakeGen2SharedKey",
            "ServicePrincipal": "DatasourceServicePrincipal",
            "ServicePrincipalInKV": "DatasourceServicePrincipalInKeyVault",
        }
    }

    def __init__(self, *, name: str, description: Optional[str] = None, **kwargs):
        """
        :keyword name: Name of data source credential. Required.
        :paramtype name: str
        :keyword description: Description of data source credential.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.credential_type = None  # type: Optional[str]
        self.id = None
        self.name = name
        self.description = description


class DataSourceCredentialList(msrest.serialization.Model):
    """DataSourceCredentialList.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar next_link:
    :vartype next_link: str
    :ivar value:
    :vartype value: list[~azure.ai.metricsadvisor.models.DatasourceCredential]
    """

    _validation = {
        "next_link": {"readonly": True},
        "value": {"readonly": True, "unique": True},
    }

    _attribute_map = {
        "next_link": {"key": "@nextLink", "type": "str"},
        "value": {"key": "value", "type": "[DatasourceCredential]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.next_link = None
        self.value = None


class DatasourceDataLakeGen2SharedKey(DatasourceCredential):
    """DatasourceDataLakeGen2SharedKey.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar credential_type: Type of data source credential. Required. Known values are:
     "AzureSQLConnectionString", "DataLakeGen2SharedKey", "ServicePrincipal", and
     "ServicePrincipalInKV".
    :vartype credential_type: str or ~azure.ai.metricsadvisor.models.DatasourceCredentialType
    :ivar id: Unique id of data source credential.
    :vartype id: str
    :ivar name: Name of data source credential. Required.
    :vartype name: str
    :ivar description: Description of data source credential.
    :vartype description: str
    :ivar account_key: The account key to access the Azure Data Lake Storage Gen2.
    :vartype account_key: str
    """

    _validation = {
        "credential_type": {"required": True},
        "id": {"readonly": True},
        "name": {"required": True},
    }

    _attribute_map = {
        "credential_type": {"key": "dataSourceCredentialType", "type": "str"},
        "id": {"key": "dataSourceCredentialId", "type": "str"},
        "name": {"key": "dataSourceCredentialName", "type": "str"},
        "description": {"key": "dataSourceCredentialDescription", "type": "str"},
        "account_key": {"key": "parameters.accountKey", "type": "str"},
    }

    def __init__(self, *, name: str, description: Optional[str] = None, account_key: Optional[str] = None, **kwargs):
        """
        :keyword name: Name of data source credential. Required.
        :paramtype name: str
        :keyword description: Description of data source credential.
        :paramtype description: str
        :keyword account_key: The account key to access the Azure Data Lake Storage Gen2.
        :paramtype account_key: str
        """
        super().__init__(name=name, description=description, **kwargs)
        self.credential_type = "DataLakeGen2SharedKey"  # type: str
        self.account_key = account_key


class DatasourceServicePrincipal(DatasourceCredential):
    """DatasourceServicePrincipal.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar credential_type: Type of data source credential. Required. Known values are:
     "AzureSQLConnectionString", "DataLakeGen2SharedKey", "ServicePrincipal", and
     "ServicePrincipalInKV".
    :vartype credential_type: str or ~azure.ai.metricsadvisor.models.DatasourceCredentialType
    :ivar id: Unique id of data source credential.
    :vartype id: str
    :ivar name: Name of data source credential. Required.
    :vartype name: str
    :ivar description: Description of data source credential.
    :vartype description: str
    :ivar client_id: The client id of the service principal. Required.
    :vartype client_id: str
    :ivar client_secret: The client secret of the service principal.
    :vartype client_secret: str
    :ivar tenant_id: The tenant id of the service principal. Required.
    :vartype tenant_id: str
    """

    _validation = {
        "credential_type": {"required": True},
        "id": {"readonly": True},
        "name": {"required": True},
        "client_id": {"required": True},
        "tenant_id": {"required": True},
    }

    _attribute_map = {
        "credential_type": {"key": "dataSourceCredentialType", "type": "str"},
        "id": {"key": "dataSourceCredentialId", "type": "str"},
        "name": {"key": "dataSourceCredentialName", "type": "str"},
        "description": {"key": "dataSourceCredentialDescription", "type": "str"},
        "client_id": {"key": "parameters.clientId", "type": "str"},
        "client_secret": {"key": "parameters.clientSecret", "type": "str"},
        "tenant_id": {"key": "parameters.tenantId", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: str,
        client_id: str,
        tenant_id: str,
        description: Optional[str] = None,
        client_secret: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: Name of data source credential. Required.
        :paramtype name: str
        :keyword description: Description of data source credential.
        :paramtype description: str
        :keyword client_id: The client id of the service principal. Required.
        :paramtype client_id: str
        :keyword client_secret: The client secret of the service principal.
        :paramtype client_secret: str
        :keyword tenant_id: The tenant id of the service principal. Required.
        :paramtype tenant_id: str
        """
        super().__init__(name=name, description=description, **kwargs)
        self.credential_type = "ServicePrincipal"  # type: str
        self.client_id = client_id
        self.client_secret = client_secret
        self.tenant_id = tenant_id


class DatasourceServicePrincipalInKeyVault(DatasourceCredential):
    """DatasourceServicePrincipalInKeyVault.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar credential_type: Type of data source credential. Required. Known values are:
     "AzureSQLConnectionString", "DataLakeGen2SharedKey", "ServicePrincipal", and
     "ServicePrincipalInKV".
    :vartype credential_type: str or ~azure.ai.metricsadvisor.models.DatasourceCredentialType
    :ivar id: Unique id of data source credential.
    :vartype id: str
    :ivar name: Name of data source credential. Required.
    :vartype name: str
    :ivar description: Description of data source credential.
    :vartype description: str
    :ivar key_vault_endpoint: The Key Vault endpoint that storing the service principal. Required.
    :vartype key_vault_endpoint: str
    :ivar key_vault_client_id: The Client Id to access the Key Vault. Required.
    :vartype key_vault_client_id: str
    :ivar key_vault_client_secret: The Client Secret to access the Key Vault.
    :vartype key_vault_client_secret: str
    :ivar service_principal_id_name_in_kv: The secret name of the service principal's client Id in
     the Key Vault. Required.
    :vartype service_principal_id_name_in_kv: str
    :ivar service_principal_secret_name_in_kv: The secret name of the service principal's client
     secret in the Key Vault. Required.
    :vartype service_principal_secret_name_in_kv: str
    :ivar tenant_id: The tenant id of your service principal. Required.
    :vartype tenant_id: str
    """

    _validation = {
        "credential_type": {"required": True},
        "id": {"readonly": True},
        "name": {"required": True},
        "key_vault_endpoint": {"required": True},
        "key_vault_client_id": {"required": True},
        "service_principal_id_name_in_kv": {"required": True},
        "service_principal_secret_name_in_kv": {"required": True},
        "tenant_id": {"required": True},
    }

    _attribute_map = {
        "credential_type": {"key": "dataSourceCredentialType", "type": "str"},
        "id": {"key": "dataSourceCredentialId", "type": "str"},
        "name": {"key": "dataSourceCredentialName", "type": "str"},
        "description": {"key": "dataSourceCredentialDescription", "type": "str"},
        "key_vault_endpoint": {"key": "parameters.keyVaultEndpoint", "type": "str"},
        "key_vault_client_id": {"key": "parameters.keyVaultClientId", "type": "str"},
        "key_vault_client_secret": {"key": "parameters.keyVaultClientSecret", "type": "str"},
        "service_principal_id_name_in_kv": {"key": "parameters.servicePrincipalIdNameInKV", "type": "str"},
        "service_principal_secret_name_in_kv": {"key": "parameters.servicePrincipalSecretNameInKV", "type": "str"},
        "tenant_id": {"key": "parameters.tenantId", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: str,
        key_vault_endpoint: str,
        key_vault_client_id: str,
        service_principal_id_name_in_kv: str,
        service_principal_secret_name_in_kv: str,
        tenant_id: str,
        description: Optional[str] = None,
        key_vault_client_secret: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: Name of data source credential. Required.
        :paramtype name: str
        :keyword description: Description of data source credential.
        :paramtype description: str
        :keyword key_vault_endpoint: The Key Vault endpoint that storing the service principal.
         Required.
        :paramtype key_vault_endpoint: str
        :keyword key_vault_client_id: The Client Id to access the Key Vault. Required.
        :paramtype key_vault_client_id: str
        :keyword key_vault_client_secret: The Client Secret to access the Key Vault.
        :paramtype key_vault_client_secret: str
        :keyword service_principal_id_name_in_kv: The secret name of the service principal's client Id
         in the Key Vault. Required.
        :paramtype service_principal_id_name_in_kv: str
        :keyword service_principal_secret_name_in_kv: The secret name of the service principal's client
         secret in the Key Vault. Required.
        :paramtype service_principal_secret_name_in_kv: str
        :keyword tenant_id: The tenant id of your service principal. Required.
        :paramtype tenant_id: str
        """
        super().__init__(name=name, description=description, **kwargs)
        self.credential_type = "ServicePrincipalInKV"  # type: str
        self.key_vault_endpoint = key_vault_endpoint
        self.key_vault_client_id = key_vault_client_id
        self.key_vault_client_secret = key_vault_client_secret
        self.service_principal_id_name_in_kv = service_principal_id_name_in_kv
        self.service_principal_secret_name_in_kv = service_principal_secret_name_in_kv
        self.tenant_id = tenant_id


class DatasourceSqlConnectionString(DatasourceCredential):
    """DatasourceSqlConnectionString.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar credential_type: Type of data source credential. Required. Known values are:
     "AzureSQLConnectionString", "DataLakeGen2SharedKey", "ServicePrincipal", and
     "ServicePrincipalInKV".
    :vartype credential_type: str or ~azure.ai.metricsadvisor.models.DatasourceCredentialType
    :ivar id: Unique id of data source credential.
    :vartype id: str
    :ivar name: Name of data source credential. Required.
    :vartype name: str
    :ivar description: Description of data source credential.
    :vartype description: str
    :ivar connection_string: The connection string to access the Azure SQL.
    :vartype connection_string: str
    """

    _validation = {
        "credential_type": {"required": True},
        "id": {"readonly": True},
        "name": {"required": True},
    }

    _attribute_map = {
        "credential_type": {"key": "dataSourceCredentialType", "type": "str"},
        "id": {"key": "dataSourceCredentialId", "type": "str"},
        "name": {"key": "dataSourceCredentialName", "type": "str"},
        "description": {"key": "dataSourceCredentialDescription", "type": "str"},
        "connection_string": {"key": "parameters.connectionString", "type": "str"},
    }

    def __init__(
        self, *, name: str, description: Optional[str] = None, connection_string: Optional[str] = None, **kwargs
    ):
        """
        :keyword name: Name of data source credential. Required.
        :paramtype name: str
        :keyword description: Description of data source credential.
        :paramtype description: str
        :keyword connection_string: The connection string to access the Azure SQL.
        :paramtype connection_string: str
        """
        super().__init__(name=name, description=description, **kwargs)
        self.credential_type = "AzureSQLConnectionString"  # type: str
        self.connection_string = connection_string


class DetectionAnomalyFilterCondition(msrest.serialization.Model):
    """DetectionAnomalyFilterCondition.

    :ivar dimension_filter: dimension filter.
    :vartype dimension_filter: list[~azure.ai.metricsadvisor.models.DimensionGroupIdentity]
    :ivar severity_filter:
    :vartype severity_filter: ~azure.ai.metricsadvisor.models.SeverityFilterCondition
    """

    _validation = {
        "dimension_filter": {"unique": True},
    }

    _attribute_map = {
        "dimension_filter": {"key": "dimensionFilter", "type": "[DimensionGroupIdentity]"},
        "severity_filter": {"key": "severityFilter", "type": "SeverityFilterCondition"},
    }

    def __init__(
        self,
        *,
        dimension_filter: Optional[List["_models.DimensionGroupIdentity"]] = None,
        severity_filter: Optional["_models.SeverityFilterCondition"] = None,
        **kwargs
    ):
        """
        :keyword dimension_filter: dimension filter.
        :paramtype dimension_filter: list[~azure.ai.metricsadvisor.models.DimensionGroupIdentity]
        :keyword severity_filter:
        :paramtype severity_filter: ~azure.ai.metricsadvisor.models.SeverityFilterCondition
        """
        super().__init__(**kwargs)
        self.dimension_filter = dimension_filter
        self.severity_filter = severity_filter


class DetectionIncidentFilterCondition(msrest.serialization.Model):
    """DetectionIncidentFilterCondition.

    :ivar dimension_filter: dimension filter.
    :vartype dimension_filter: list[~azure.ai.metricsadvisor.models.DimensionGroupIdentity]
    """

    _validation = {
        "dimension_filter": {"unique": True},
    }

    _attribute_map = {
        "dimension_filter": {"key": "dimensionFilter", "type": "[DimensionGroupIdentity]"},
    }

    def __init__(self, *, dimension_filter: Optional[List["_models.DimensionGroupIdentity"]] = None, **kwargs):
        """
        :keyword dimension_filter: dimension filter.
        :paramtype dimension_filter: list[~azure.ai.metricsadvisor.models.DimensionGroupIdentity]
        """
        super().__init__(**kwargs)
        self.dimension_filter = dimension_filter


class DimensionGroupIdentity(msrest.serialization.Model):
    """DimensionGroupIdentity.

    All required parameters must be populated in order to send to Azure.

    :ivar dimension: dimension specified for series group. Required.
    :vartype dimension: dict[str, str]
    """

    _validation = {
        "dimension": {"required": True},
    }

    _attribute_map = {
        "dimension": {"key": "dimension", "type": "{str}"},
    }

    def __init__(self, *, dimension: Dict[str, str], **kwargs):
        """
        :keyword dimension: dimension specified for series group. Required.
        :paramtype dimension: dict[str, str]
        """
        super().__init__(**kwargs)
        self.dimension = dimension


class NotificationHook(msrest.serialization.Model):
    """NotificationHook.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    EmailNotificationHook, WebNotificationHook

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar hook_type: hook type. Required.
    :vartype hook_type: str
    :ivar id: Hook unique id.
    :vartype id: str
    :ivar name: hook unique name.
    :vartype name: str
    :ivar description: hook description.
    :vartype description: str
    :ivar external_link: hook external link.
    :vartype external_link: str
    :ivar admins: hook administrators.
    :vartype admins: list[str]
    """

    _validation = {
        "hook_type": {"required": True},
        "id": {"readonly": True},
        "admins": {"unique": True},
    }

    _attribute_map = {
        "hook_type": {"key": "hookType", "type": "str"},
        "id": {"key": "hookId", "type": "str"},
        "name": {"key": "hookName", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "external_link": {"key": "externalLink", "type": "str"},
        "admins": {"key": "admins", "type": "[str]"},
    }

    _subtype_map = {"hook_type": {"Email": "EmailNotificationHook", "Webhook": "WebNotificationHook"}}

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        description: str = "",
        external_link: str = "",
        admins: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword name: hook unique name.
        :paramtype name: str
        :keyword description: hook description.
        :paramtype description: str
        :keyword external_link: hook external link.
        :paramtype external_link: str
        :keyword admins: hook administrators.
        :paramtype admins: list[str]
        """
        super().__init__(**kwargs)
        self.hook_type = None  # type: Optional[str]
        self.id = None
        self.name = name
        self.description = description
        self.external_link = external_link
        self.admins = admins


class EmailNotificationHook(NotificationHook):
    """EmailNotificationHook.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar hook_type: hook type. Required.
    :vartype hook_type: str
    :ivar id: Hook unique id.
    :vartype id: str
    :ivar name: hook unique name.
    :vartype name: str
    :ivar description: hook description.
    :vartype description: str
    :ivar external_link: hook external link.
    :vartype external_link: str
    :ivar admins: hook administrators.
    :vartype admins: list[str]
    :ivar emails_to_alert: Email TO: list.
    :vartype emails_to_alert: list[str]
    """

    _validation = {
        "hook_type": {"required": True},
        "id": {"readonly": True},
        "admins": {"unique": True},
        "emails_to_alert": {"unique": True},
    }

    _attribute_map = {
        "hook_type": {"key": "hookType", "type": "str"},
        "id": {"key": "hookId", "type": "str"},
        "name": {"key": "hookName", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "external_link": {"key": "externalLink", "type": "str"},
        "admins": {"key": "admins", "type": "[str]"},
        "emails_to_alert": {"key": "hookParameter.toList", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        description: str = "",
        external_link: str = "",
        admins: Optional[List[str]] = None,
        emails_to_alert: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword name: hook unique name.
        :paramtype name: str
        :keyword description: hook description.
        :paramtype description: str
        :keyword external_link: hook external link.
        :paramtype external_link: str
        :keyword admins: hook administrators.
        :paramtype admins: list[str]
        :keyword emails_to_alert: Email TO: list.
        :paramtype emails_to_alert: list[str]
        """
        super().__init__(name=name, description=description, external_link=external_link, admins=admins, **kwargs)
        self.hook_type = "Email"  # type: str
        self.emails_to_alert = emails_to_alert


class EnrichmentStatus(msrest.serialization.Model):
    """EnrichmentStatus.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar timestamp: data slice timestamp.
    :vartype timestamp: ~datetime.datetime
    :ivar status: latest enrichment status for this data slice.
    :vartype status: str
    :ivar message: the trimmed message describes details of the enrichment status.
    :vartype message: str
    """

    _validation = {
        "timestamp": {"readonly": True},
        "status": {"readonly": True},
        "message": {"readonly": True},
    }

    _attribute_map = {
        "timestamp": {"key": "timestamp", "type": "iso-8601"},
        "status": {"key": "status", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.timestamp = None
        self.status = None
        self.message = None


class EnrichmentStatusList(msrest.serialization.Model):
    """EnrichmentStatusList.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar next_link:
    :vartype next_link: str
    :ivar value:
    :vartype value: list[~azure.ai.metricsadvisor.models.EnrichmentStatus]
    """

    _validation = {
        "next_link": {"readonly": True},
        "value": {"readonly": True},
    }

    _attribute_map = {
        "next_link": {"key": "@nextLink", "type": "str"},
        "value": {"key": "value", "type": "[EnrichmentStatus]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.next_link = None
        self.value = None


class HardThresholdCondition(msrest.serialization.Model):
    """HardThresholdCondition.

    :ivar lower_bound: lower bound

     should be specified when anomalyDetectorDirection is Both or Down.
    :vartype lower_bound: float
    :ivar upper_bound: upper bound

     should be specified when anomalyDetectorDirection is Both or Up.
    :vartype upper_bound: float
    :ivar anomaly_detector_direction: detection direction. Known values are: "Both", "Down", and
     "Up".
    :vartype anomaly_detector_direction: str or
     ~azure.ai.metricsadvisor.models.AnomalyDetectorDirection
    :ivar suppress_condition:
    :vartype suppress_condition: ~azure.ai.metricsadvisor.models.SuppressCondition
    """

    _attribute_map = {
        "lower_bound": {"key": "lowerBound", "type": "float"},
        "upper_bound": {"key": "upperBound", "type": "float"},
        "anomaly_detector_direction": {"key": "anomalyDetectorDirection", "type": "str"},
        "suppress_condition": {"key": "suppressCondition", "type": "SuppressCondition"},
    }

    def __init__(
        self,
        *,
        lower_bound: Optional[float] = None,
        upper_bound: Optional[float] = None,
        anomaly_detector_direction: Optional[Union[str, "_models.AnomalyDetectorDirection"]] = None,
        suppress_condition: Optional["_models.SuppressCondition"] = None,
        **kwargs
    ):
        """
        :keyword lower_bound: lower bound

         should be specified when anomalyDetectorDirection is Both or Down.
        :paramtype lower_bound: float
        :keyword upper_bound: upper bound

         should be specified when anomalyDetectorDirection is Both or Up.
        :paramtype upper_bound: float
        :keyword anomaly_detector_direction: detection direction. Known values are: "Both", "Down", and
         "Up".
        :paramtype anomaly_detector_direction: str or
         ~azure.ai.metricsadvisor.models.AnomalyDetectorDirection
        :keyword suppress_condition:
        :paramtype suppress_condition: ~azure.ai.metricsadvisor.models.SuppressCondition
        """
        super().__init__(**kwargs)
        self.lower_bound = lower_bound
        self.upper_bound = upper_bound
        self.anomaly_detector_direction = anomaly_detector_direction
        self.suppress_condition = suppress_condition


class HookList(msrest.serialization.Model):
    """HookList.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar next_link:
    :vartype next_link: str
    :ivar value:
    :vartype value: list[~azure.ai.metricsadvisor.models.NotificationHook]
    """

    _validation = {
        "next_link": {"readonly": True},
        "value": {"readonly": True, "unique": True},
    }

    _attribute_map = {
        "next_link": {"key": "@nextLink", "type": "str"},
        "value": {"key": "value", "type": "[NotificationHook]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.next_link = None
        self.value = None


class IncidentResultList(msrest.serialization.Model):
    """IncidentResultList.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar next_link:
    :vartype next_link: str
    :ivar value: Required.
    :vartype value: list[~azure.ai.metricsadvisor.models.AnomalyIncident]
    """

    _validation = {
        "next_link": {"readonly": True},
        "value": {"required": True},
    }

    _attribute_map = {
        "next_link": {"key": "@nextLink", "type": "str"},
        "value": {"key": "value", "type": "[AnomalyIncident]"},
    }

    def __init__(self, *, value: List["_models.AnomalyIncident"], **kwargs):
        """
        :keyword value: Required.
        :paramtype value: list[~azure.ai.metricsadvisor.models.AnomalyIncident]
        """
        super().__init__(**kwargs)
        self.next_link = None
        self.value = value


class IncidentRootCause(msrest.serialization.Model):
    """IncidentRootCause.

    All required parameters must be populated in order to send to Azure.

    :ivar root_cause: Required.
    :vartype root_cause: ~azure.ai.metricsadvisor.models.DimensionGroupIdentity
    :ivar path: drilling down path from query anomaly to root cause. Required.
    :vartype path: list[str]
    :ivar score: score of the root cause. Required.
    :vartype score: float
    :ivar description: description of the root cause. Required.
    :vartype description: str
    """

    _validation = {
        "root_cause": {"required": True},
        "path": {"required": True},
        "score": {"required": True},
        "description": {"required": True},
    }

    _attribute_map = {
        "root_cause": {"key": "rootCause", "type": "DimensionGroupIdentity"},
        "path": {"key": "path", "type": "[str]"},
        "score": {"key": "score", "type": "float"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(
        self, *, root_cause: "_models.DimensionGroupIdentity", path: List[str], score: float, description: str, **kwargs
    ):
        """
        :keyword root_cause: Required.
        :paramtype root_cause: ~azure.ai.metricsadvisor.models.DimensionGroupIdentity
        :keyword path: drilling down path from query anomaly to root cause. Required.
        :paramtype path: list[str]
        :keyword score: score of the root cause. Required.
        :paramtype score: float
        :keyword description: description of the root cause. Required.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.root_cause = root_cause
        self.path = path
        self.score = score
        self.description = description


class InfluxDbDataFeedSource(msrest.serialization.Model):
    """InfluxDbDataFeedSource.

    All required parameters must be populated in order to send to Azure.

    :ivar connection_string: The connection string of this InfluxDB.
    :vartype connection_string: str
    :ivar database: A database name.
    :vartype database: str
    :ivar user_name: The user name of the account that can access this database.
    :vartype user_name: str
    :ivar password: The password of the account that can access this database.
    :vartype password: str
    :ivar query: The script to query this database. Required.
    :vartype query: str
    """

    _validation = {
        "query": {"required": True},
    }

    _attribute_map = {
        "connection_string": {"key": "connectionString", "type": "str"},
        "database": {"key": "database", "type": "str"},
        "user_name": {"key": "userName", "type": "str"},
        "password": {"key": "password", "type": "str"},
        "query": {"key": "query", "type": "str"},
    }

    def __init__(
        self,
        *,
        query: str,
        connection_string: Optional[str] = None,
        database: Optional[str] = None,
        user_name: Optional[str] = None,
        password: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword connection_string: The connection string of this InfluxDB.
        :paramtype connection_string: str
        :keyword database: A database name.
        :paramtype database: str
        :keyword user_name: The user name of the account that can access this database.
        :paramtype user_name: str
        :keyword password: The password of the account that can access this database.
        :paramtype password: str
        :keyword query: The script to query this database. Required.
        :paramtype query: str
        """
        super().__init__(**kwargs)
        self.connection_string = connection_string
        self.database = database
        self.user_name = user_name
        self.password = password
        self.query = query


class IngestionStatusList(msrest.serialization.Model):
    """IngestionStatusList.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar next_link:
    :vartype next_link: str
    :ivar value:
    :vartype value: list[~azure.ai.metricsadvisor.models.DataFeedIngestionStatus]
    """

    _validation = {
        "next_link": {"readonly": True},
        "value": {"readonly": True},
    }

    _attribute_map = {
        "next_link": {"key": "@nextLink", "type": "str"},
        "value": {"key": "value", "type": "[DataFeedIngestionStatus]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.next_link = None
        self.value = None


class MetricAlertConfiguration(msrest.serialization.Model):
    """MetricAlertConfiguration.

    All required parameters must be populated in order to send to Azure.

    :ivar detection_configuration_id: Anomaly detection configuration unique id. Required.
    :vartype detection_configuration_id: str
    :ivar anomaly_scope_type: Anomaly scope. Required. Known values are: "All", "Dimension", and
     "TopN".
    :vartype anomaly_scope_type: str or ~azure.ai.metricsadvisor.models.MetricAnomalyAlertScopeType
    :ivar negation_operation: Negation operation.
    :vartype negation_operation: bool
    :ivar dimension_anomaly_scope:
    :vartype dimension_anomaly_scope: ~azure.ai.metricsadvisor.models.DimensionGroupIdentity
    :ivar top_n_anomaly_scope:
    :vartype top_n_anomaly_scope: ~azure.ai.metricsadvisor.models.TopNGroupScope
    :ivar severity_filter:
    :vartype severity_filter: ~azure.ai.metricsadvisor.models.SeverityCondition
    :ivar alert_snooze_condition:
    :vartype alert_snooze_condition:
     ~azure.ai.metricsadvisor.models.MetricAnomalyAlertSnoozeCondition
    :ivar value_filter:
    :vartype value_filter: ~azure.ai.metricsadvisor.models.MetricBoundaryCondition
    """

    _validation = {
        "detection_configuration_id": {"required": True},
        "anomaly_scope_type": {"required": True},
    }

    _attribute_map = {
        "detection_configuration_id": {"key": "anomalyDetectionConfigurationId", "type": "str"},
        "anomaly_scope_type": {"key": "anomalyScopeType", "type": "str"},
        "negation_operation": {"key": "negationOperation", "type": "bool"},
        "dimension_anomaly_scope": {"key": "dimensionAnomalyScope", "type": "DimensionGroupIdentity"},
        "top_n_anomaly_scope": {"key": "topNAnomalyScope", "type": "TopNGroupScope"},
        "severity_filter": {"key": "severityFilter", "type": "SeverityCondition"},
        "alert_snooze_condition": {"key": "snoozeFilter", "type": "MetricAnomalyAlertSnoozeCondition"},
        "value_filter": {"key": "valueFilter", "type": "MetricBoundaryCondition"},
    }

    def __init__(
        self,
        *,
        detection_configuration_id: str,
        anomaly_scope_type: Union[str, "_models.MetricAnomalyAlertScopeType"],
        negation_operation: bool = False,
        dimension_anomaly_scope: Optional["_models.DimensionGroupIdentity"] = None,
        top_n_anomaly_scope: Optional["_models.TopNGroupScope"] = None,
        severity_filter: Optional["_models.SeverityCondition"] = None,
        alert_snooze_condition: Optional["_models.MetricAnomalyAlertSnoozeCondition"] = None,
        value_filter: Optional["_models.MetricBoundaryCondition"] = None,
        **kwargs
    ):
        """
        :keyword detection_configuration_id: Anomaly detection configuration unique id. Required.
        :paramtype detection_configuration_id: str
        :keyword anomaly_scope_type: Anomaly scope. Required. Known values are: "All", "Dimension", and
         "TopN".
        :paramtype anomaly_scope_type: str or
         ~azure.ai.metricsadvisor.models.MetricAnomalyAlertScopeType
        :keyword negation_operation: Negation operation.
        :paramtype negation_operation: bool
        :keyword dimension_anomaly_scope:
        :paramtype dimension_anomaly_scope: ~azure.ai.metricsadvisor.models.DimensionGroupIdentity
        :keyword top_n_anomaly_scope:
        :paramtype top_n_anomaly_scope: ~azure.ai.metricsadvisor.models.TopNGroupScope
        :keyword severity_filter:
        :paramtype severity_filter: ~azure.ai.metricsadvisor.models.SeverityCondition
        :keyword alert_snooze_condition:
        :paramtype alert_snooze_condition:
         ~azure.ai.metricsadvisor.models.MetricAnomalyAlertSnoozeCondition
        :keyword value_filter:
        :paramtype value_filter: ~azure.ai.metricsadvisor.models.MetricBoundaryCondition
        """
        super().__init__(**kwargs)
        self.detection_configuration_id = detection_configuration_id
        self.anomaly_scope_type = anomaly_scope_type
        self.negation_operation = negation_operation
        self.dimension_anomaly_scope = dimension_anomaly_scope
        self.top_n_anomaly_scope = top_n_anomaly_scope
        self.severity_filter = severity_filter
        self.alert_snooze_condition = alert_snooze_condition
        self.value_filter = value_filter


class MetricAnomalyAlertSnoozeCondition(msrest.serialization.Model):
    """MetricAnomalyAlertSnoozeCondition.

    All required parameters must be populated in order to send to Azure.

    :ivar auto_snooze: snooze point count, value range : [0, +∞). Required.
    :vartype auto_snooze: int
    :ivar snooze_scope: snooze scope. Required. Known values are: "Metric" and "Series".
    :vartype snooze_scope: str or ~azure.ai.metricsadvisor.models.SnoozeScope
    :ivar only_for_successive: only snooze for successive anomalies. Required.
    :vartype only_for_successive: bool
    """

    _validation = {
        "auto_snooze": {"required": True},
        "snooze_scope": {"required": True},
        "only_for_successive": {"required": True},
    }

    _attribute_map = {
        "auto_snooze": {"key": "autoSnooze", "type": "int"},
        "snooze_scope": {"key": "snoozeScope", "type": "str"},
        "only_for_successive": {"key": "onlyForSuccessive", "type": "bool"},
    }

    def __init__(
        self, *, auto_snooze: int, snooze_scope: Union[str, "_models.SnoozeScope"], only_for_successive: bool, **kwargs
    ):
        """
        :keyword auto_snooze: snooze point count, value range : [0, +∞). Required.
        :paramtype auto_snooze: int
        :keyword snooze_scope: snooze scope. Required. Known values are: "Metric" and "Series".
        :paramtype snooze_scope: str or ~azure.ai.metricsadvisor.models.SnoozeScope
        :keyword only_for_successive: only snooze for successive anomalies. Required.
        :paramtype only_for_successive: bool
        """
        super().__init__(**kwargs)
        self.auto_snooze = auto_snooze
        self.snooze_scope = snooze_scope
        self.only_for_successive = only_for_successive


class MetricBoundaryCondition(msrest.serialization.Model):
    """MetricBoundaryCondition.

    All required parameters must be populated in order to send to Azure.

    :ivar lower: lower bound

     should be specified when direction is Both or Down.
    :vartype lower: float
    :ivar upper: upper bound

     should be specified when direction is Both or Up.
    :vartype upper: float
    :ivar direction: value filter direction. Required.
    :vartype direction: str
    :ivar companion_metric_id: the other metric unique id used for value filter.
    :vartype companion_metric_id: str
    :ivar trigger_for_missing: trigger alert when the corresponding point is missing in the other
     metric

     should be specified only when using other metric to filter.
    :vartype trigger_for_missing: bool
    """

    _validation = {
        "direction": {"required": True},
    }

    _attribute_map = {
        "lower": {"key": "lower", "type": "float"},
        "upper": {"key": "upper", "type": "float"},
        "direction": {"key": "direction", "type": "str"},
        "companion_metric_id": {"key": "metricId", "type": "str"},
        "trigger_for_missing": {"key": "triggerForMissing", "type": "bool"},
    }

    def __init__(
        self,
        *,
        direction: str,
        lower: Optional[float] = None,
        upper: Optional[float] = None,
        companion_metric_id: Optional[str] = None,
        trigger_for_missing: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword lower: lower bound

         should be specified when direction is Both or Down.
        :paramtype lower: float
        :keyword upper: upper bound

         should be specified when direction is Both or Up.
        :paramtype upper: float
        :keyword direction: value filter direction. Required.
        :paramtype direction: str
        :keyword companion_metric_id: the other metric unique id used for value filter.
        :paramtype companion_metric_id: str
        :keyword trigger_for_missing: trigger alert when the corresponding point is missing in the
         other metric

         should be specified only when using other metric to filter.
        :paramtype trigger_for_missing: bool
        """
        super().__init__(**kwargs)
        self.lower = lower
        self.upper = upper
        self.direction = direction
        self.companion_metric_id = companion_metric_id
        self.trigger_for_missing = trigger_for_missing


class MetricDataList(msrest.serialization.Model):
    """MetricDataList.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value:
    :vartype value: list[~azure.ai.metricsadvisor.models.MetricSeriesData]
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[MetricSeriesData]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.value = None


class MetricDetectionCondition(msrest.serialization.Model):
    """MetricDetectionCondition.

    :ivar condition_operator: condition operator

     should be specified when combining multiple detection conditions. Known values are: "AND" and
     "OR".
    :vartype condition_operator: str or ~azure.ai.metricsadvisor.models.DetectionConditionOperator
    :ivar smart_detection_condition:
    :vartype smart_detection_condition: ~azure.ai.metricsadvisor.models.SmartDetectionCondition
    :ivar hard_threshold_condition:
    :vartype hard_threshold_condition: ~azure.ai.metricsadvisor.models.HardThresholdCondition
    :ivar change_threshold_condition:
    :vartype change_threshold_condition: ~azure.ai.metricsadvisor.models.ChangeThresholdCondition
    """

    _attribute_map = {
        "condition_operator": {"key": "conditionOperator", "type": "str"},
        "smart_detection_condition": {"key": "smartDetectionCondition", "type": "SmartDetectionCondition"},
        "hard_threshold_condition": {"key": "hardThresholdCondition", "type": "HardThresholdCondition"},
        "change_threshold_condition": {"key": "changeThresholdCondition", "type": "ChangeThresholdCondition"},
    }

    def __init__(
        self,
        *,
        condition_operator: Optional[Union[str, "_models.DetectionConditionOperator"]] = None,
        smart_detection_condition: Optional["_models.SmartDetectionCondition"] = None,
        hard_threshold_condition: Optional["_models.HardThresholdCondition"] = None,
        change_threshold_condition: Optional["_models.ChangeThresholdCondition"] = None,
        **kwargs
    ):
        """
        :keyword condition_operator: condition operator

         should be specified when combining multiple detection conditions. Known values are: "AND" and
         "OR".
        :paramtype condition_operator: str or
         ~azure.ai.metricsadvisor.models.DetectionConditionOperator
        :keyword smart_detection_condition:
        :paramtype smart_detection_condition: ~azure.ai.metricsadvisor.models.SmartDetectionCondition
        :keyword hard_threshold_condition:
        :paramtype hard_threshold_condition: ~azure.ai.metricsadvisor.models.HardThresholdCondition
        :keyword change_threshold_condition:
        :paramtype change_threshold_condition: ~azure.ai.metricsadvisor.models.ChangeThresholdCondition
        """
        super().__init__(**kwargs)
        self.condition_operator = condition_operator
        self.smart_detection_condition = smart_detection_condition
        self.hard_threshold_condition = hard_threshold_condition
        self.change_threshold_condition = change_threshold_condition


class MetricDimensionList(msrest.serialization.Model):
    """MetricDimensionList.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar next_link:
    :vartype next_link: str
    :ivar value:
    :vartype value: list[str]
    """

    _validation = {
        "next_link": {"readonly": True},
        "value": {"readonly": True, "unique": True},
    }

    _attribute_map = {
        "next_link": {"key": "@nextLink", "type": "str"},
        "value": {"key": "value", "type": "[str]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.next_link = None
        self.value = None


class MetricEnrichedSeriesData(msrest.serialization.Model):
    """MetricEnrichedSeriesData.

    All required parameters must be populated in order to send to Azure.

    :ivar timestamps: timestamps of the series. Required.
    :vartype timestamps: list[~datetime.datetime]
    :ivar values: values of the series. Required.
    :vartype values: list[float]
    :ivar is_anomaly: whether points of the series are anomalies. Required.
    :vartype is_anomaly: list[bool]
    :ivar periods: period calculated on each point of the series. Required.
    :vartype periods: list[int]
    :ivar expected_values: expected values of the series given by smart detector. Required.
    :vartype expected_values: list[float]
    :ivar lower_bounds: lower boundary list of the series given by smart detector. Required.
    :vartype lower_bounds: list[float]
    :ivar upper_bounds: upper boundary list of the series given by smart detector. Required.
    :vartype upper_bounds: list[float]
    :ivar series_key: dimension specified for series group. Required.
    :vartype series_key: dict[str, str]
    """

    _validation = {
        "timestamps": {"required": True},
        "values": {"required": True},
        "is_anomaly": {"required": True},
        "periods": {"required": True},
        "expected_values": {"required": True},
        "lower_bounds": {"required": True},
        "upper_bounds": {"required": True},
        "series_key": {"required": True},
    }

    _attribute_map = {
        "timestamps": {"key": "timestampList", "type": "[iso-8601]"},
        "values": {"key": "valueList", "type": "[float]"},
        "is_anomaly": {"key": "isAnomalyList", "type": "[bool]"},
        "periods": {"key": "periodList", "type": "[int]"},
        "expected_values": {"key": "expectedValueList", "type": "[float]"},
        "lower_bounds": {"key": "lowerBoundaryList", "type": "[float]"},
        "upper_bounds": {"key": "upperBoundaryList", "type": "[float]"},
        "series_key": {"key": "series.dimension", "type": "{str}"},
    }

    def __init__(
        self,
        *,
        timestamps: List[datetime.datetime],
        values: List[float],
        is_anomaly: List[bool],
        periods: List[int],
        expected_values: List[float],
        lower_bounds: List[float],
        upper_bounds: List[float],
        series_key: Dict[str, str],
        **kwargs
    ):
        """
        :keyword timestamps: timestamps of the series. Required.
        :paramtype timestamps: list[~datetime.datetime]
        :keyword values: values of the series. Required.
        :paramtype values: list[float]
        :keyword is_anomaly: whether points of the series are anomalies. Required.
        :paramtype is_anomaly: list[bool]
        :keyword periods: period calculated on each point of the series. Required.
        :paramtype periods: list[int]
        :keyword expected_values: expected values of the series given by smart detector. Required.
        :paramtype expected_values: list[float]
        :keyword lower_bounds: lower boundary list of the series given by smart detector. Required.
        :paramtype lower_bounds: list[float]
        :keyword upper_bounds: upper boundary list of the series given by smart detector. Required.
        :paramtype upper_bounds: list[float]
        :keyword series_key: dimension specified for series group. Required.
        :paramtype series_key: dict[str, str]
        """
        super().__init__(**kwargs)
        self.timestamps = timestamps
        self.values = values
        self.is_anomaly = is_anomaly
        self.periods = periods
        self.expected_values = expected_values
        self.lower_bounds = lower_bounds
        self.upper_bounds = upper_bounds
        self.series_key = series_key


class MetricFeedbackList(msrest.serialization.Model):
    """MetricFeedbackList.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar next_link:
    :vartype next_link: str
    :ivar value:
    :vartype value: list[~azure.ai.metricsadvisor.models.MetricFeedback]
    """

    _validation = {
        "next_link": {"readonly": True},
        "value": {"readonly": True},
    }

    _attribute_map = {
        "next_link": {"key": "@nextLink", "type": "str"},
        "value": {"key": "value", "type": "[MetricFeedback]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.next_link = None
        self.value = None


class MetricSeriesData(msrest.serialization.Model):
    """MetricSeriesData.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar timestamps: timestamps of the data related to this time series.
    :vartype timestamps: list[~datetime.datetime]
    :ivar values: values of the data related to this time series.
    :vartype values: list[float]
    :ivar series_key: dimension specified for series group.
    :vartype series_key: dict[str, str]
    :ivar metric_id:
    :vartype metric_id: str
    """

    _validation = {
        "timestamps": {"readonly": True},
        "values": {"readonly": True},
        "metric_id": {"readonly": True},
    }

    _attribute_map = {
        "timestamps": {"key": "timestampList", "type": "[iso-8601]"},
        "values": {"key": "valueList", "type": "[float]"},
        "series_key": {"key": "id.dimension", "type": "{str}"},
        "metric_id": {"key": "id.metricId", "type": "str"},
    }

    def __init__(self, *, series_key: Optional[Dict[str, str]] = None, **kwargs):
        """
        :keyword series_key: dimension specified for series group.
        :paramtype series_key: dict[str, str]
        """
        super().__init__(**kwargs)
        self.timestamps = None
        self.values = None
        self.series_key = series_key
        self.metric_id = None


class MetricSeriesDefinition(msrest.serialization.Model):
    """MetricSeriesDefinition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar metric_id: metric unique id.
    :vartype metric_id: str
    :ivar dimension: dimension name and value pair.
    :vartype dimension: dict[str, str]
    """

    _validation = {
        "metric_id": {"readonly": True},
        "dimension": {"readonly": True},
    }

    _attribute_map = {
        "metric_id": {"key": "metricId", "type": "str"},
        "dimension": {"key": "dimension", "type": "{str}"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.metric_id = None
        self.dimension = None


class MetricSeriesGroupDetectionCondition(msrest.serialization.Model):
    """MetricSeriesGroupDetectionCondition.

    All required parameters must be populated in order to send to Azure.

    :ivar condition_operator: condition operator

     should be specified when combining multiple detection conditions. Known values are: "AND" and
     "OR".
    :vartype condition_operator: str or ~azure.ai.metricsadvisor.models.DetectionConditionOperator
    :ivar smart_detection_condition:
    :vartype smart_detection_condition: ~azure.ai.metricsadvisor.models.SmartDetectionCondition
    :ivar hard_threshold_condition:
    :vartype hard_threshold_condition: ~azure.ai.metricsadvisor.models.HardThresholdCondition
    :ivar change_threshold_condition:
    :vartype change_threshold_condition: ~azure.ai.metricsadvisor.models.ChangeThresholdCondition
    :ivar series_group_key: dimension specified for series group. Required.
    :vartype series_group_key: dict[str, str]
    """

    _validation = {
        "series_group_key": {"required": True},
    }

    _attribute_map = {
        "condition_operator": {"key": "conditionOperator", "type": "str"},
        "smart_detection_condition": {"key": "smartDetectionCondition", "type": "SmartDetectionCondition"},
        "hard_threshold_condition": {"key": "hardThresholdCondition", "type": "HardThresholdCondition"},
        "change_threshold_condition": {"key": "changeThresholdCondition", "type": "ChangeThresholdCondition"},
        "series_group_key": {"key": "group.dimension", "type": "{str}"},
    }

    def __init__(
        self,
        *,
        series_group_key: Dict[str, str],
        condition_operator: Optional[Union[str, "_models.DetectionConditionOperator"]] = None,
        smart_detection_condition: Optional["_models.SmartDetectionCondition"] = None,
        hard_threshold_condition: Optional["_models.HardThresholdCondition"] = None,
        change_threshold_condition: Optional["_models.ChangeThresholdCondition"] = None,
        **kwargs
    ):
        """
        :keyword condition_operator: condition operator

         should be specified when combining multiple detection conditions. Known values are: "AND" and
         "OR".
        :paramtype condition_operator: str or
         ~azure.ai.metricsadvisor.models.DetectionConditionOperator
        :keyword smart_detection_condition:
        :paramtype smart_detection_condition: ~azure.ai.metricsadvisor.models.SmartDetectionCondition
        :keyword hard_threshold_condition:
        :paramtype hard_threshold_condition: ~azure.ai.metricsadvisor.models.HardThresholdCondition
        :keyword change_threshold_condition:
        :paramtype change_threshold_condition: ~azure.ai.metricsadvisor.models.ChangeThresholdCondition
        :keyword series_group_key: dimension specified for series group. Required.
        :paramtype series_group_key: dict[str, str]
        """
        super().__init__(**kwargs)
        self.condition_operator = condition_operator
        self.smart_detection_condition = smart_detection_condition
        self.hard_threshold_condition = hard_threshold_condition
        self.change_threshold_condition = change_threshold_condition
        self.series_group_key = series_group_key


class MetricSeriesList(msrest.serialization.Model):
    """MetricSeriesList.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar next_link:
    :vartype next_link: str
    :ivar value:
    :vartype value: list[~azure.ai.metricsadvisor.models.MetricSeriesDefinition]
    """

    _validation = {
        "next_link": {"readonly": True},
        "value": {"readonly": True},
    }

    _attribute_map = {
        "next_link": {"key": "@nextLink", "type": "str"},
        "value": {"key": "value", "type": "[MetricSeriesDefinition]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.next_link = None
        self.value = None


class MetricSingleSeriesDetectionCondition(msrest.serialization.Model):
    """MetricSingleSeriesDetectionCondition.

    All required parameters must be populated in order to send to Azure.

    :ivar condition_operator: condition operator

     should be specified when combining multiple detection conditions. Known values are: "AND" and
     "OR".
    :vartype condition_operator: str or ~azure.ai.metricsadvisor.models.DetectionConditionOperator
    :ivar smart_detection_condition:
    :vartype smart_detection_condition: ~azure.ai.metricsadvisor.models.SmartDetectionCondition
    :ivar hard_threshold_condition:
    :vartype hard_threshold_condition: ~azure.ai.metricsadvisor.models.HardThresholdCondition
    :ivar change_threshold_condition:
    :vartype change_threshold_condition: ~azure.ai.metricsadvisor.models.ChangeThresholdCondition
    :ivar series_key: dimension specified for series group. Required.
    :vartype series_key: dict[str, str]
    """

    _validation = {
        "series_key": {"required": True},
    }

    _attribute_map = {
        "condition_operator": {"key": "conditionOperator", "type": "str"},
        "smart_detection_condition": {"key": "smartDetectionCondition", "type": "SmartDetectionCondition"},
        "hard_threshold_condition": {"key": "hardThresholdCondition", "type": "HardThresholdCondition"},
        "change_threshold_condition": {"key": "changeThresholdCondition", "type": "ChangeThresholdCondition"},
        "series_key": {"key": "series.dimension", "type": "{str}"},
    }

    def __init__(
        self,
        *,
        series_key: Dict[str, str],
        condition_operator: Optional[Union[str, "_models.DetectionConditionOperator"]] = None,
        smart_detection_condition: Optional["_models.SmartDetectionCondition"] = None,
        hard_threshold_condition: Optional["_models.HardThresholdCondition"] = None,
        change_threshold_condition: Optional["_models.ChangeThresholdCondition"] = None,
        **kwargs
    ):
        """
        :keyword condition_operator: condition operator

         should be specified when combining multiple detection conditions. Known values are: "AND" and
         "OR".
        :paramtype condition_operator: str or
         ~azure.ai.metricsadvisor.models.DetectionConditionOperator
        :keyword smart_detection_condition:
        :paramtype smart_detection_condition: ~azure.ai.metricsadvisor.models.SmartDetectionCondition
        :keyword hard_threshold_condition:
        :paramtype hard_threshold_condition: ~azure.ai.metricsadvisor.models.HardThresholdCondition
        :keyword change_threshold_condition:
        :paramtype change_threshold_condition: ~azure.ai.metricsadvisor.models.ChangeThresholdCondition
        :keyword series_key: dimension specified for series group. Required.
        :paramtype series_key: dict[str, str]
        """
        super().__init__(**kwargs)
        self.condition_operator = condition_operator
        self.smart_detection_condition = smart_detection_condition
        self.hard_threshold_condition = hard_threshold_condition
        self.change_threshold_condition = change_threshold_condition
        self.series_key = series_key


class MongoDbDataFeedSource(msrest.serialization.Model):
    """MongoDbDataFeedSource.

    All required parameters must be populated in order to send to Azure.

    :ivar connection_string: The connection string of this MongoDB.
    :vartype connection_string: str
    :ivar database: A database name in this MongoDB.
    :vartype database: str
    :ivar command: The script to query this database. Required.
    :vartype command: str
    """

    _validation = {
        "command": {"required": True},
    }

    _attribute_map = {
        "connection_string": {"key": "connectionString", "type": "str"},
        "database": {"key": "database", "type": "str"},
        "command": {"key": "command", "type": "str"},
    }

    def __init__(
        self, *, command: str, connection_string: Optional[str] = None, database: Optional[str] = None, **kwargs
    ):
        """
        :keyword connection_string: The connection string of this MongoDB.
        :paramtype connection_string: str
        :keyword database: A database name in this MongoDB.
        :paramtype database: str
        :keyword command: The script to query this database. Required.
        :paramtype command: str
        """
        super().__init__(**kwargs)
        self.connection_string = connection_string
        self.database = database
        self.command = command


class PeriodFeedback(MetricFeedback):
    """PeriodFeedback.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar feedback_type: feedback type. Required. Known values are: "Anomaly", "ChangePoint",
     "Period", and "Comment".
    :vartype feedback_type: str or ~azure.ai.metricsadvisor.models.FeedbackType
    :ivar id: feedback unique id.
    :vartype id: str
    :ivar created_time: feedback created time.
    :vartype created_time: ~datetime.datetime
    :ivar user_principal: user who gives this feedback.
    :vartype user_principal: str
    :ivar metric_id: metric unique id. Required.
    :vartype metric_id: str
    :ivar dimension_key: metric dimension filter. Required.
    :vartype dimension_key: dict[str, str]
    :ivar period_type: the type of setting period. Required. Known values are: "AutoDetect" and
     "AssignValue".
    :vartype period_type: str or ~azure.ai.metricsadvisor.models.PeriodType
    :ivar value: the number of intervals a period contains, when no period set to 0. Required.
    :vartype value: int
    """

    _validation = {
        "feedback_type": {"required": True},
        "id": {"readonly": True},
        "created_time": {"readonly": True},
        "user_principal": {"readonly": True},
        "metric_id": {"required": True},
        "dimension_key": {"required": True},
        "period_type": {"required": True},
        "value": {"required": True},
    }

    _attribute_map = {
        "feedback_type": {"key": "feedbackType", "type": "str"},
        "id": {"key": "feedbackId", "type": "str"},
        "created_time": {"key": "createdTime", "type": "iso-8601"},
        "user_principal": {"key": "userPrincipal", "type": "str"},
        "metric_id": {"key": "metricId", "type": "str"},
        "dimension_key": {"key": "dimensionFilter.dimension", "type": "{str}"},
        "period_type": {"key": "value.periodType", "type": "str"},
        "value": {"key": "value.periodValue", "type": "int"},
    }

    def __init__(
        self,
        *,
        metric_id: str,
        dimension_key: Dict[str, str],
        period_type: Union[str, "_models.PeriodType"],
        value: int = 0,
        **kwargs
    ):
        """
        :keyword metric_id: metric unique id. Required.
        :paramtype metric_id: str
        :keyword dimension_key: metric dimension filter. Required.
        :paramtype dimension_key: dict[str, str]
        :keyword period_type: the type of setting period. Required. Known values are: "AutoDetect" and
         "AssignValue".
        :paramtype period_type: str or ~azure.ai.metricsadvisor.models.PeriodType
        :keyword value: the number of intervals a period contains, when no period set to 0. Required.
        :paramtype value: int
        """
        super().__init__(metric_id=metric_id, dimension_key=dimension_key, **kwargs)
        self.feedback_type = "Period"  # type: str
        self.period_type = period_type
        self.value = value


class RootCauseList(msrest.serialization.Model):
    """RootCauseList.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required.
    :vartype value: list[~azure.ai.metricsadvisor.models.IncidentRootCause]
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[IncidentRootCause]"},
    }

    def __init__(self, *, value: List["_models.IncidentRootCause"], **kwargs):
        """
        :keyword value: Required.
        :paramtype value: list[~azure.ai.metricsadvisor.models.IncidentRootCause]
        """
        super().__init__(**kwargs)
        self.value = value


class SeriesIdentity(msrest.serialization.Model):
    """SeriesIdentity.

    All required parameters must be populated in order to send to Azure.

    :ivar dimension: dimension specified for series. Required.
    :vartype dimension: dict[str, str]
    """

    _validation = {
        "dimension": {"required": True},
    }

    _attribute_map = {
        "dimension": {"key": "dimension", "type": "{str}"},
    }

    def __init__(self, *, dimension: Dict[str, str], **kwargs):
        """
        :keyword dimension: dimension specified for series. Required.
        :paramtype dimension: dict[str, str]
        """
        super().__init__(**kwargs)
        self.dimension = dimension


class SeriesResultList(msrest.serialization.Model):
    """SeriesResultList.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required.
    :vartype value: list[~azure.ai.metricsadvisor.models.MetricEnrichedSeriesData]
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[MetricEnrichedSeriesData]"},
    }

    def __init__(self, *, value: List["_models.MetricEnrichedSeriesData"], **kwargs):
        """
        :keyword value: Required.
        :paramtype value: list[~azure.ai.metricsadvisor.models.MetricEnrichedSeriesData]
        """
        super().__init__(**kwargs)
        self.value = value


class SeverityCondition(msrest.serialization.Model):
    """SeverityCondition.

    All required parameters must be populated in order to send to Azure.

    :ivar min_alert_severity: min alert severity. Required. Known values are: "Low", "Medium", and
     "High".
    :vartype min_alert_severity: str or ~azure.ai.metricsadvisor.models.AnomalySeverity
    :ivar max_alert_severity: max alert severity. Required. Known values are: "Low", "Medium", and
     "High".
    :vartype max_alert_severity: str or ~azure.ai.metricsadvisor.models.AnomalySeverity
    """

    _validation = {
        "min_alert_severity": {"required": True},
        "max_alert_severity": {"required": True},
    }

    _attribute_map = {
        "min_alert_severity": {"key": "minAlertSeverity", "type": "str"},
        "max_alert_severity": {"key": "maxAlertSeverity", "type": "str"},
    }

    def __init__(
        self,
        *,
        min_alert_severity: Union[str, "_models.AnomalySeverity"],
        max_alert_severity: Union[str, "_models.AnomalySeverity"],
        **kwargs
    ):
        """
        :keyword min_alert_severity: min alert severity. Required. Known values are: "Low", "Medium",
         and "High".
        :paramtype min_alert_severity: str or ~azure.ai.metricsadvisor.models.AnomalySeverity
        :keyword max_alert_severity: max alert severity. Required. Known values are: "Low", "Medium",
         and "High".
        :paramtype max_alert_severity: str or ~azure.ai.metricsadvisor.models.AnomalySeverity
        """
        super().__init__(**kwargs)
        self.min_alert_severity = min_alert_severity
        self.max_alert_severity = max_alert_severity


class SeverityFilterCondition(msrest.serialization.Model):
    """SeverityFilterCondition.

    All required parameters must be populated in order to send to Azure.

    :ivar min: min severity. Required. Known values are: "Low", "Medium", and "High".
    :vartype min: str or ~azure.ai.metricsadvisor.models.AnomalySeverity
    :ivar max: max severity. Required. Known values are: "Low", "Medium", and "High".
    :vartype max: str or ~azure.ai.metricsadvisor.models.AnomalySeverity
    """

    _validation = {
        "min": {"required": True},
        "max": {"required": True},
    }

    _attribute_map = {
        "min": {"key": "min", "type": "str"},
        "max": {"key": "max", "type": "str"},
    }

    def __init__(
        self,
        *,
        min: Union[str, "_models.AnomalySeverity"],  # pylint: disable=redefined-builtin
        max: Union[str, "_models.AnomalySeverity"],  # pylint: disable=redefined-builtin
        **kwargs
    ):
        """
        :keyword min: min severity. Required. Known values are: "Low", "Medium", and "High".
        :paramtype min: str or ~azure.ai.metricsadvisor.models.AnomalySeverity
        :keyword max: max severity. Required. Known values are: "Low", "Medium", and "High".
        :paramtype max: str or ~azure.ai.metricsadvisor.models.AnomalySeverity
        """
        super().__init__(**kwargs)
        self.min = min
        self.max = max


class SmartDetectionCondition(msrest.serialization.Model):
    """SmartDetectionCondition.

    :ivar sensitivity: sensitivity, value range : (0, 100].
    :vartype sensitivity: float
    :ivar anomaly_detector_direction: detection direction. Known values are: "Both", "Down", and
     "Up".
    :vartype anomaly_detector_direction: str or
     ~azure.ai.metricsadvisor.models.AnomalyDetectorDirection
    :ivar suppress_condition:
    :vartype suppress_condition: ~azure.ai.metricsadvisor.models.SuppressCondition
    """

    _attribute_map = {
        "sensitivity": {"key": "sensitivity", "type": "float"},
        "anomaly_detector_direction": {"key": "anomalyDetectorDirection", "type": "str"},
        "suppress_condition": {"key": "suppressCondition", "type": "SuppressCondition"},
    }

    def __init__(
        self,
        *,
        sensitivity: Optional[float] = None,
        anomaly_detector_direction: Optional[Union[str, "_models.AnomalyDetectorDirection"]] = None,
        suppress_condition: Optional["_models.SuppressCondition"] = None,
        **kwargs
    ):
        """
        :keyword sensitivity: sensitivity, value range : (0, 100].
        :paramtype sensitivity: float
        :keyword anomaly_detector_direction: detection direction. Known values are: "Both", "Down", and
         "Up".
        :paramtype anomaly_detector_direction: str or
         ~azure.ai.metricsadvisor.models.AnomalyDetectorDirection
        :keyword suppress_condition:
        :paramtype suppress_condition: ~azure.ai.metricsadvisor.models.SuppressCondition
        """
        super().__init__(**kwargs)
        self.sensitivity = sensitivity
        self.anomaly_detector_direction = anomaly_detector_direction
        self.suppress_condition = suppress_condition


class SuppressCondition(msrest.serialization.Model):
    """SuppressCondition.

    :ivar min_number: min point number, value range : [1, +∞).
    :vartype min_number: int
    :ivar min_ratio: min point ratio, value range : (0, 100].
    :vartype min_ratio: float
    """

    _attribute_map = {
        "min_number": {"key": "minNumber", "type": "int"},
        "min_ratio": {"key": "minRatio", "type": "float"},
    }

    def __init__(self, *, min_number: Optional[int] = None, min_ratio: Optional[float] = None, **kwargs):
        """
        :keyword min_number: min point number, value range : [1, +∞).
        :paramtype min_number: int
        :keyword min_ratio: min point ratio, value range : (0, 100].
        :paramtype min_ratio: float
        """
        super().__init__(**kwargs)
        self.min_number = min_number
        self.min_ratio = min_ratio


class TopNGroupScope(msrest.serialization.Model):
    """TopNGroupScope.

    All required parameters must be populated in order to send to Azure.

    :ivar top: top N, value range : [1, +∞). Required.
    :vartype top: int
    :ivar period: point count used to look back, value range : [1, +∞). Required.
    :vartype period: int
    :ivar min_top_count: min count should be in top N, value range : [1, +∞)

     should be less than or equal to period. Required.
    :vartype min_top_count: int
    """

    _validation = {
        "top": {"required": True},
        "period": {"required": True},
        "min_top_count": {"required": True},
    }

    _attribute_map = {
        "top": {"key": "top", "type": "int"},
        "period": {"key": "period", "type": "int"},
        "min_top_count": {"key": "minTopCount", "type": "int"},
    }

    def __init__(self, *, top: int, period: int, min_top_count: int, **kwargs):
        """
        :keyword top: top N, value range : [1, +∞). Required.
        :paramtype top: int
        :keyword period: point count used to look back, value range : [1, +∞). Required.
        :paramtype period: int
        :keyword min_top_count: min count should be in top N, value range : [1, +∞)

         should be less than or equal to period. Required.
        :paramtype min_top_count: int
        """
        super().__init__(**kwargs)
        self.top = top
        self.period = period
        self.min_top_count = min_top_count


class WebNotificationHook(NotificationHook):  # pylint: disable=too-many-instance-attributes
    """WebNotificationHook.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar hook_type: hook type. Required.
    :vartype hook_type: str
    :ivar id: Hook unique id.
    :vartype id: str
    :ivar name: hook unique name.
    :vartype name: str
    :ivar description: hook description.
    :vartype description: str
    :ivar external_link: hook external link.
    :vartype external_link: str
    :ivar admins: hook administrators.
    :vartype admins: list[str]
    :ivar endpoint: API address, will be called when alert is triggered, only support POST method
     via SSL.
    :vartype endpoint: str
    :ivar username: (Deprecated) The username, if using basic authentication.
    :vartype username: str
    :ivar password: (Deprecated) The password, if using basic authentication.
    :vartype password: str
    :ivar certificate_key: The certificate key/URL, if using client certificate, please read
     documents for more informations.
    :vartype certificate_key: str
    :ivar certificate_password: The certificate password, if using client certificate, please read
     documents for more informations.
    :vartype certificate_password: str
    """

    _validation = {
        "hook_type": {"required": True},
        "id": {"readonly": True},
        "admins": {"unique": True},
    }

    _attribute_map = {
        "hook_type": {"key": "hookType", "type": "str"},
        "id": {"key": "hookId", "type": "str"},
        "name": {"key": "hookName", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "external_link": {"key": "externalLink", "type": "str"},
        "admins": {"key": "admins", "type": "[str]"},
        "endpoint": {"key": "hookParameter.endpoint", "type": "str"},
        "username": {"key": "hookParameter.username", "type": "str"},
        "password": {"key": "hookParameter.password", "type": "str"},
        "certificate_key": {"key": "hookParameter.certificateKey", "type": "str"},
        "certificate_password": {"key": "hookParameter.certificatePassword", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        description: str = "",
        external_link: str = "",
        admins: Optional[List[str]] = None,
        endpoint: Optional[str] = None,
        username: Optional[str] = None,
        password: Optional[str] = None,
        certificate_key: Optional[str] = None,
        certificate_password: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: hook unique name.
        :paramtype name: str
        :keyword description: hook description.
        :paramtype description: str
        :keyword external_link: hook external link.
        :paramtype external_link: str
        :keyword admins: hook administrators.
        :paramtype admins: list[str]
        :keyword endpoint: API address, will be called when alert is triggered, only support POST
         method via SSL.
        :paramtype endpoint: str
        :keyword username: (Deprecated) The username, if using basic authentication.
        :paramtype username: str
        :keyword password: (Deprecated) The password, if using basic authentication.
        :paramtype password: str
        :keyword certificate_key: The certificate key/URL, if using client certificate, please read
         documents for more informations.
        :paramtype certificate_key: str
        :keyword certificate_password: The certificate password, if using client certificate, please
         read documents for more informations.
        :paramtype certificate_password: str
        """
        super().__init__(name=name, description=description, external_link=external_link, admins=admins, **kwargs)
        self.hook_type = "Webhook"  # type: str
        self.endpoint = endpoint
        self.username = username
        self.password = password
        self.certificate_key = certificate_key
        self.certificate_password = certificate_password
