/* NVTV life -- Dirk Thierbach <dthierbach@gmx.de>
 *
 * This file is part of nvtv, a tool for tv-output on NVidia cards.
 * 
 * nvtv is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * nvtv is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
 *
 * $Id$
 *
 * Contents:
 *
 * Main test file for life tests of gui (on simulated hardware)
 *
 */

#include "local.h" /* before everything else */

#include <stdio.h>
#include <stdlib.h>
#include <getopt.h>
#include <stdarg.h>

#include "backend.h"
#include "back_test.h"
#include "back_unix.h"

#include "tester.h"

/* -------- Options -------- */

Bool testopt_snoop = FALSE;
Bool testopt_log = TRUE;
Bool testopt_dump = FALSE;

int testopt_default = 0;

void life_usage (void)
{
  fprintf (stderr,
      "usage: life card encoder heads [nvtv options]\n\n");
  exit (1);
}

/* ---------- */

char* card_arg;

Bool 
back_root_avail (void) 
{
  return TRUE;
}

CardPtr 
back_root_init (void)
{
  return back_test_init (card_arg);
}

Bool 
back_nvdev_avail (Bool force)
{
  return TRUE;
}

CardPtr 
back_nvdev_init (void)
{
  return back_test_init (card_arg);
}

Bool 
back_client_avail (void) 
{
  return TRUE;
}

CardPtr
back_client_init (void)
{
  return back_test_init (card_arg);
}

Bool back_win_avail (void)
{
  return TRUE;
}

CardPtr back_win_init (void)
{
  return back_test_init (card_arg);
}

/* ---------- */

int main (int argc, char *argv [])
{
  if (argc < 4) life_usage ();
  configSetup (argv[1], argv[2], argv[3]);
  card_arg = argv[1];
  argv[3] = argv[0];
  xmain (argc - 3, argv + 3);
}

