---
layout: "docs"
page_title: "Drivers: Singularity"
sidebar_current: "docs-drivers-community-Singularity"
description: |-
  The Singularity task driver is used to run application containers using Singularity.
---

# Singularity Driver

Name: `Singularity`

The `Singularity` driver provides an interface for using Singularity for running application
containers. You can download the external Singularity driver [here][Singularity-driver].


## Task Configuration

```hcl
task "lolcow" {
  driver = "Singularity"

  config {
     // this example run an image from sylabs container library with the
     // canonical example of lolcow
     image = "library://sylabsed/examples/lolcow:latest"
     // command can be run, exec or test
     command = "run"
  }
}
```

The `Singularity` driver supports the following configuration in the job spec:

* `image` - The Singularity image to run. It can be a local path or a supported URI.

    ```hcl
    config {
      image = "library://sylabsed/examples/lolcow:latest"
    }
    ```

* `verbose` - (Optional) Enables extra verbosity in the Singularity runtime logging.
Defaults to `false`.

    ```hcl
    config {
      verbose = "false"
    }
    ```

* `debug` - (Optional) Enables extra debug output in the Singularity runtime
  logging. Defaults to `false`.

    ```hcl
    config {
      debug = "false"
    }
    ```

* `command` - Singularity command action; can be `run`, `exec` or `test`.

    ```hcl
    config {
      command = "run"
    }
    ```

* `args` - (Optional) Singularity command action arguments, when trying to pass arguments to `run`, `exec` or `test`.
Multiple args can be given by a comma separated list.

    ```hcl
    config {
      args = [ "echo", "hello Cloud" ]
    }
    ```

* [`binds`][bind] - (Optional) A user-bind path specification. This spec has the format `src[:dest[:opts]]`, where src and
dest are outside and inside paths.  If dest is not given, it is set equal to src.
Mount options ('opts') may be specified as 'ro' (read-only) or 'rw' (read/write, which
is the default). Multiple bind paths can be given by a comma separated list.

    ```hcl
    config {
      bind = [ "host/path:/container/path" ]
    }
    ```

* [`overlay`][overlay] - (Optional) Singularity command action flag, to enable an overlayFS image for persistent data
storage or as read-only layer of container.  Multiple overlay paths can be given by a comma separated list.

    ```hcl
    config {
      overlay = [ "host/path/to/overlay" ]
    }
    ```

* [`security`][security] - (Optional) Allows the root user to leverage security modules such as
SELinux, AppArmor, and seccomp within your Singularity container.
You can also change the UID and GID of the user within the container at runtime.

    ```hcl
    config {
      security = [ "uid:1000 " ]
    }
    ```

* `contain` - (Optional) Use minimal `/dev` and empty other directories (e.g. /tmp and $HOME) instead of sharing filesystems from your host.

    ```hcl
    config {
      contain = "false"
    }
    ```

* `workdir` - (Optional) Working directory to be used for `/tmp`, `/var/tmp` and $HOME (if -c/--contain was also used).

    ```hcl
    config {
      workdir = "/path/to/folder"
    }
    ```

* `pwd` - (Optional) Initial working directory for payload process inside the container.

    ```hcl
    config {
      pwd = "/path/to/folder"
    }
    ```

## Networking

Currently the `Singularity` driver only supports host networking. For more detailed instructions on how to set up networking options, please refer to the `Singularity` user guides [singularity-network]

## Client Requirements

The `Singularity` driver requires the following:

* 64-bit Linux host
* The `linux_amd64` Nomad binary
* The Singularity driver binary placed in the [plugin_dir][plugin_dir] directory.
* [`Singularity`][Singularity] v3.1.1+ to be installed

## Plugin Options<a id="plugin_options"></a>

* `enabled` - The `Singularity` driver may be disabled on hosts by setting this option to `false` (defaults to `true`).

* `singularity_cache` - The location in which all containers are stored (commonly defaults to `/var/lib/singularity`). See [`Singularity-cache`][Singularity-cache] for more details.

An example of using these plugin options with the new [plugin
syntax][plugin] is shown below:

```hcl
plugin "nomad-driver-Singularity" {
  config {
    enabled = true
    singularity_path = "/var/lib/singularity"
  }
}
```
Please note the plugin name should match whatever name you have specified for the external driver in the [plugin_dir][plugin_dir] directory.

## Client Attributes

The `Singularity` driver will set the following client attributes:

* `driver.singularity` - Set to `1` if Singularity is found  and enabled on the host node.
* `driver.singularity.version` - Version of `Singularity` e.g.: `3.1.0`.

## Resource Isolation

This driver supports CPU and memory isolation via the `Singularity` cgroups feature. Network
isolation is supported via `--net` and `--network` feature (Singularity v3.1.1+ required).

[Singularity-driver]: https://github.com/sylabs/nomad-driver-singularity
[Singularity_man]: https://linuxcontainers.org/Singularity/manpages/man5/Singularity.container.conf.5.html#lbAM
[plugin]: /docs/configuration/plugin.html
[plugin_dir]: /docs/configuration/index.html#plugin_dir
[plugin-options]: #plugin_options
[Singularity]: https://github.com/sylabs/singularity
[Singularity-cache]: https://www.sylabs.io/guides/3.1/user-guide/appendix.html#c

[bind]: https://www.sylabs.io/guides/3.1/user-guide/bind_paths_and_mounts.html
[security]: https://www.sylabs.io/guides/3.1/user-guide/security_options.html
[overlay]: https://www.sylabs.io/guides/3.1/user-guide/persistent_overlays.html
[singularity-network]: https://www.sylabs.io/guides/3.1/user-guide/networking.html
