---
layout: "docs"
page_title: "Commands: operator keyring"
sidebar_current: "docs-commands-operator-keyring"
---

# Command: operator keyring

The `operator keyring` command is used to examine and modify the encryption keys
used in Nomad server. It is capable of distributing new encryption keys to the
cluster, retiring old encryption keys, and changing the keys used by the cluster
to encrypt messages.

Nomad allows multiple encryption keys to be in use simultaneously. This is
intended to provide a transition state while the cluster converges. It is the
responsibility of the operator to ensure that only the required encryption keys
are installed on the cluster. You can review the installed keys using the
`-list` argument, and remove unneeded keys with `-remove`.

All operations performed by this command can only be run against server nodes
and will effect the entire cluster.

All variations of the `keyring` command return 0 if all nodes reply and there
are no errors. If any node fails to reply or reports failure, the exit code
will be 1.

## Usage

```plaintext
nomad operator keyring [options]
```

Only one actionable argument may be specified per run, including `-list`,
`-install`, `-remove`, and `-use`.

The list of available flags are:

- `-list` - List all keys currently in use within the cluster.

- `-install` - Install a new encryption key. This will broadcast the new key to
  all members in the cluster.

- `-use` - Change the primary encryption key, which is used to encrypt messages.
  The key must already be installed before this operation can succeed.

- `-remove` - Remove the given key from the cluster. This operation may only be
  performed on keys which are not currently the primary key.

## Output

The output of the `nomad operator keyring -list` command consolidates
information from all the Nomad servers from all datacenters and regions to
provide a simple and easy to understand view of the cluster.

```shell
$ nomad operator keyring -list
==> Gathering installed encryption keys...
Key
PGm64/neoebUBqYR/lZTbA==
```
