#pragma once

// Generated by grammar/asdl_cpp.py

#include <libasr/alloc.h>
#include <libasr/location.h>
#include <libasr/colors.h>
#include <libasr/containers.h>
#include <libasr/exception.h>
#include <libasr/asr_scopes.h>
#include <libasr/string_utils.h>
#include <libasr/asr_base_visitor.h>


namespace LCompilers::ASR {
/******************************************************************************/
// Expression Type (`expr_type`) visitor
static inline ASR::ttype_t* expr_type0(const ASR::expr_t *f)
{
    LCOMPILERS_ASSERT(f != nullptr);
    switch (f->type) {
        case ASR::exprType::IfExp: { return ((ASR::IfExp_t*)f)->m_type; }
        case ASR::exprType::ComplexConstructor: { return ((ASR::ComplexConstructor_t*)f)->m_type; }
        case ASR::exprType::NamedExpr: { return ((ASR::NamedExpr_t*)f)->m_type; }
        case ASR::exprType::FunctionCall: { return ((ASR::FunctionCall_t*)f)->m_type; }
        case ASR::exprType::IntrinsicElementalFunction: { return ((ASR::IntrinsicElementalFunction_t*)f)->m_type; }
        case ASR::exprType::IntrinsicArrayFunction: { return ((ASR::IntrinsicArrayFunction_t*)f)->m_type; }
        case ASR::exprType::IntrinsicImpureFunction: { return ((ASR::IntrinsicImpureFunction_t*)f)->m_type; }
        case ASR::exprType::TypeInquiry: { return ((ASR::TypeInquiry_t*)f)->m_type; }
        case ASR::exprType::StructConstructor: { return ((ASR::StructConstructor_t*)f)->m_type; }
        case ASR::exprType::StructConstant: { return ((ASR::StructConstant_t*)f)->m_type; }
        case ASR::exprType::EnumConstructor: { return ((ASR::EnumConstructor_t*)f)->m_type; }
        case ASR::exprType::UnionConstructor: { return ((ASR::UnionConstructor_t*)f)->m_type; }
        case ASR::exprType::ImpliedDoLoop: { return ((ASR::ImpliedDoLoop_t*)f)->m_type; }
        case ASR::exprType::IntegerConstant: { return ((ASR::IntegerConstant_t*)f)->m_type; }
        case ASR::exprType::IntegerBitNot: { return ((ASR::IntegerBitNot_t*)f)->m_type; }
        case ASR::exprType::IntegerUnaryMinus: { return ((ASR::IntegerUnaryMinus_t*)f)->m_type; }
        case ASR::exprType::IntegerCompare: { return ((ASR::IntegerCompare_t*)f)->m_type; }
        case ASR::exprType::IntegerBinOp: { return ((ASR::IntegerBinOp_t*)f)->m_type; }
        case ASR::exprType::UnsignedIntegerConstant: { return ((ASR::UnsignedIntegerConstant_t*)f)->m_type; }
        case ASR::exprType::UnsignedIntegerUnaryMinus: { return ((ASR::UnsignedIntegerUnaryMinus_t*)f)->m_type; }
        case ASR::exprType::UnsignedIntegerBitNot: { return ((ASR::UnsignedIntegerBitNot_t*)f)->m_type; }
        case ASR::exprType::UnsignedIntegerCompare: { return ((ASR::UnsignedIntegerCompare_t*)f)->m_type; }
        case ASR::exprType::UnsignedIntegerBinOp: { return ((ASR::UnsignedIntegerBinOp_t*)f)->m_type; }
        case ASR::exprType::RealConstant: { return ((ASR::RealConstant_t*)f)->m_type; }
        case ASR::exprType::RealUnaryMinus: { return ((ASR::RealUnaryMinus_t*)f)->m_type; }
        case ASR::exprType::RealCompare: { return ((ASR::RealCompare_t*)f)->m_type; }
        case ASR::exprType::RealBinOp: { return ((ASR::RealBinOp_t*)f)->m_type; }
        case ASR::exprType::RealCopySign: { return ((ASR::RealCopySign_t*)f)->m_type; }
        case ASR::exprType::ComplexConstant: { return ((ASR::ComplexConstant_t*)f)->m_type; }
        case ASR::exprType::ComplexUnaryMinus: { return ((ASR::ComplexUnaryMinus_t*)f)->m_type; }
        case ASR::exprType::ComplexCompare: { return ((ASR::ComplexCompare_t*)f)->m_type; }
        case ASR::exprType::ComplexBinOp: { return ((ASR::ComplexBinOp_t*)f)->m_type; }
        case ASR::exprType::LogicalConstant: { return ((ASR::LogicalConstant_t*)f)->m_type; }
        case ASR::exprType::LogicalNot: { return ((ASR::LogicalNot_t*)f)->m_type; }
        case ASR::exprType::LogicalCompare: { return ((ASR::LogicalCompare_t*)f)->m_type; }
        case ASR::exprType::LogicalBinOp: { return ((ASR::LogicalBinOp_t*)f)->m_type; }
        case ASR::exprType::ListConstant: { return ((ASR::ListConstant_t*)f)->m_type; }
        case ASR::exprType::ListLen: { return ((ASR::ListLen_t*)f)->m_type; }
        case ASR::exprType::ListConcat: { return ((ASR::ListConcat_t*)f)->m_type; }
        case ASR::exprType::ListCompare: { return ((ASR::ListCompare_t*)f)->m_type; }
        case ASR::exprType::ListCount: { return ((ASR::ListCount_t*)f)->m_type; }
        case ASR::exprType::SetConstant: { return ((ASR::SetConstant_t*)f)->m_type; }
        case ASR::exprType::SetLen: { return ((ASR::SetLen_t*)f)->m_type; }
        case ASR::exprType::TupleConstant: { return ((ASR::TupleConstant_t*)f)->m_type; }
        case ASR::exprType::TupleLen: { return ((ASR::TupleLen_t*)f)->m_type; }
        case ASR::exprType::TupleCompare: { return ((ASR::TupleCompare_t*)f)->m_type; }
        case ASR::exprType::TupleConcat: { return ((ASR::TupleConcat_t*)f)->m_type; }
        case ASR::exprType::StringConstant: { return ((ASR::StringConstant_t*)f)->m_type; }
        case ASR::exprType::StringConcat: { return ((ASR::StringConcat_t*)f)->m_type; }
        case ASR::exprType::StringRepeat: { return ((ASR::StringRepeat_t*)f)->m_type; }
        case ASR::exprType::StringLen: { return ((ASR::StringLen_t*)f)->m_type; }
        case ASR::exprType::StringItem: { return ((ASR::StringItem_t*)f)->m_type; }
        case ASR::exprType::StringSection: { return ((ASR::StringSection_t*)f)->m_type; }
        case ASR::exprType::StringCompare: { return ((ASR::StringCompare_t*)f)->m_type; }
        case ASR::exprType::StringContains: { return ((ASR::StringContains_t*)f)->m_type; }
        case ASR::exprType::StringOrd: { return ((ASR::StringOrd_t*)f)->m_type; }
        case ASR::exprType::StringChr: { return ((ASR::StringChr_t*)f)->m_type; }
        case ASR::exprType::StringFormat: { return ((ASR::StringFormat_t*)f)->m_type; }
        case ASR::exprType::StringPhysicalCast: { return ((ASR::StringPhysicalCast_t*)f)->m_type; }
        case ASR::exprType::CPtrCompare: { return ((ASR::CPtrCompare_t*)f)->m_type; }
        case ASR::exprType::SymbolicCompare: { return ((ASR::SymbolicCompare_t*)f)->m_type; }
        case ASR::exprType::DictConstant: { return ((ASR::DictConstant_t*)f)->m_type; }
        case ASR::exprType::DictLen: { return ((ASR::DictLen_t*)f)->m_type; }
        case ASR::exprType::Var: {
            ASR::symbol_t *s = ((ASR::Var_t*)f)->m_v;
            if (s->type == ASR::symbolType::ExternalSymbol) {
                ASR::ExternalSymbol_t *e = ASR::down_cast<ASR::ExternalSymbol_t>(s);
                LCOMPILERS_ASSERT(e->m_external);
                LCOMPILERS_ASSERT(!ASR::is_a<ASR::ExternalSymbol_t>(*e->m_external));
                s = e->m_external;
            }
            if (s->type == ASR::symbolType::Function) {
                return ASR::down_cast<ASR::Function_t>(s)->m_function_signature;
            } else if( s->type == ASR::symbolType::Variable ) {
                return ASR::down_cast<ASR::Variable_t>(s)->m_type;
            } else {
                // ICE: only Function and Variable have types, this symbol
                // does not have a type
                LCOMPILERS_ASSERT_MSG(false, std::to_string(s->type));
            }
            return nullptr;
        }
        case ASR::exprType::FunctionParam: { return ((ASR::FunctionParam_t*)f)->m_type; }
        case ASR::exprType::ArrayConstructor: { return ((ASR::ArrayConstructor_t*)f)->m_type; }
        case ASR::exprType::ArrayConstant: { return ((ASR::ArrayConstant_t*)f)->m_type; }
        case ASR::exprType::ArrayItem: { return ((ASR::ArrayItem_t*)f)->m_type; }
        case ASR::exprType::ArraySection: { return ((ASR::ArraySection_t*)f)->m_type; }
        case ASR::exprType::ArraySize: { return ((ASR::ArraySize_t*)f)->m_type; }
        case ASR::exprType::ArrayBound: { return ((ASR::ArrayBound_t*)f)->m_type; }
        case ASR::exprType::ArrayTranspose: { return ((ASR::ArrayTranspose_t*)f)->m_type; }
        case ASR::exprType::ArrayPack: { return ((ASR::ArrayPack_t*)f)->m_type; }
        case ASR::exprType::ArrayReshape: { return ((ASR::ArrayReshape_t*)f)->m_type; }
        case ASR::exprType::ArrayBroadcast: { return ((ASR::ArrayBroadcast_t*)f)->m_type; }
        case ASR::exprType::BitCast: { return ((ASR::BitCast_t*)f)->m_type; }
        case ASR::exprType::StructInstanceMember: { return ((ASR::StructInstanceMember_t*)f)->m_type; }
        case ASR::exprType::StructStaticMember: { return ((ASR::StructStaticMember_t*)f)->m_type; }
        case ASR::exprType::EnumStaticMember: { return ((ASR::EnumStaticMember_t*)f)->m_type; }
        case ASR::exprType::UnionInstanceMember: { return ((ASR::UnionInstanceMember_t*)f)->m_type; }
        case ASR::exprType::EnumName: { return ((ASR::EnumName_t*)f)->m_type; }
        case ASR::exprType::EnumValue: { return ((ASR::EnumValue_t*)f)->m_type; }
        case ASR::exprType::OverloadedCompare: { return ((ASR::OverloadedCompare_t*)f)->m_type; }
        case ASR::exprType::OverloadedBinOp: { return expr_type0(((ASR::OverloadedBinOp_t*)f)->m_overloaded); }
        case ASR::exprType::OverloadedUnaryMinus: { return ((ASR::OverloadedUnaryMinus_t*)f)->m_type; }
        case ASR::exprType::OverloadedStringConcat: { return ((ASR::OverloadedStringConcat_t*)f)->m_type; }
        case ASR::exprType::Cast: { return ((ASR::Cast_t*)f)->m_type; }
        case ASR::exprType::ArrayPhysicalCast: { return ((ASR::ArrayPhysicalCast_t*)f)->m_type; }
        case ASR::exprType::ComplexRe: { return ((ASR::ComplexRe_t*)f)->m_type; }
        case ASR::exprType::ComplexIm: { return ((ASR::ComplexIm_t*)f)->m_type; }
        case ASR::exprType::DictItem: { return ((ASR::DictItem_t*)f)->m_type; }
        case ASR::exprType::CLoc: { return ((ASR::CLoc_t*)f)->m_type; }
        case ASR::exprType::PointerToCPtr: { return ((ASR::PointerToCPtr_t*)f)->m_type; }
        case ASR::exprType::GetPointer: { return ((ASR::GetPointer_t*)f)->m_type; }
        case ASR::exprType::ListItem: { return ((ASR::ListItem_t*)f)->m_type; }
        case ASR::exprType::TupleItem: { return ((ASR::TupleItem_t*)f)->m_type; }
        case ASR::exprType::ListSection: { return ((ASR::ListSection_t*)f)->m_type; }
        case ASR::exprType::ListRepeat: { return ((ASR::ListRepeat_t*)f)->m_type; }
        case ASR::exprType::DictPop: { return ((ASR::DictPop_t*)f)->m_type; }
        case ASR::exprType::SetPop: { return ((ASR::SetPop_t*)f)->m_type; }
        case ASR::exprType::IntegerBitLen: { return ((ASR::IntegerBitLen_t*)f)->m_type; }
        case ASR::exprType::Ichar: { return ((ASR::Ichar_t*)f)->m_type; }
        case ASR::exprType::Iachar: { return ((ASR::Iachar_t*)f)->m_type; }
        case ASR::exprType::SizeOfType: { return ((ASR::SizeOfType_t*)f)->m_type; }
        case ASR::exprType::PointerNullConstant: { return ((ASR::PointerNullConstant_t*)f)->m_type; }
        case ASR::exprType::PointerAssociated: { return ((ASR::PointerAssociated_t*)f)->m_type; }
        case ASR::exprType::RealSqrt: { return ((ASR::RealSqrt_t*)f)->m_type; }
        case ASR::exprType::ArrayIsContiguous: { return ((ASR::ArrayIsContiguous_t*)f)->m_type; }
        default : throw LCompilersException("Not implemented");
    }
}



}
