#pragma once

// Generated by grammar/asdl_cpp.py

#include <libasr/alloc.h>
#include <libasr/location.h>
#include <libasr/colors.h>
#include <libasr/containers.h>
#include <libasr/exception.h>
#include <libasr/asr_scopes.h>
#include <libasr/string_utils.h>
#include <libasr/asr_base_visitor.h>


namespace LCompilers::ASR {
/******************************************************************************/
// Expression and statement Duplicator class

template <class StructType>
class BaseExprStmtDuplicator {
public:
    StructType& self() { return static_cast<StructType&>(*this); }

    Allocator &al;
    bool success;
    bool allow_procedure_calls;
    bool allow_reshape;

    BaseExprStmtDuplicator(Allocator& al_) : al(al_), success(false), allow_procedure_calls(true), allow_reshape(true) {}


    ASR::asr_t* duplicate_Allocate(Allocate_t* x) {
        Vec<alloc_arg_t> m_args;
        m_args.reserve(al, x->n_args);
        for (size_t i = 0; i < x->n_args; i++) {
            ASR::alloc_arg_t alloc_arg_copy;
            alloc_arg_copy.loc = x->m_args[i].loc;
            alloc_arg_copy.m_a = self().duplicate_expr(x->m_args[i].m_a);
            alloc_arg_copy.m_len_expr = self().duplicate_expr(x->m_args[i].m_len_expr);
            alloc_arg_copy.m_type = self().duplicate_ttype(x->m_args[i].m_type);
            alloc_arg_copy.n_dims = x->m_args[i].n_dims;
            Vec<ASR::dimension_t> dims_copy;
            dims_copy.reserve(al, alloc_arg_copy.n_dims);
            for (size_t j = 0; j < alloc_arg_copy.n_dims; j++) {
                ASR::dimension_t dim_copy;
                dim_copy.loc = x->m_args[i].m_dims[j].loc;
                dim_copy.m_start = self().duplicate_expr(x->m_args[i].m_dims[j].m_start);
                dim_copy.m_length = self().duplicate_expr(x->m_args[i].m_dims[j].m_length);
                dims_copy.push_back(al, dim_copy);
            }
            alloc_arg_copy.m_dims = dims_copy.p;
            m_args.push_back(al, alloc_arg_copy);
        }
        expr_t* m_stat = self().duplicate_expr(x->m_stat);
        expr_t* m_errmsg = self().duplicate_expr(x->m_errmsg);
        expr_t* m_source = self().duplicate_expr(x->m_source);
        return make_Allocate_t(al, x->base.base.loc, m_args.p, x->n_args, m_stat, m_errmsg, m_source);
    }


    ASR::asr_t* duplicate_ReAlloc(ReAlloc_t* x) {
        Vec<alloc_arg_t> m_args;
        m_args.reserve(al, x->n_args);
        for (size_t i = 0; i < x->n_args; i++) {
            ASR::alloc_arg_t alloc_arg_copy;
            alloc_arg_copy.loc = x->m_args[i].loc;
            alloc_arg_copy.m_a = self().duplicate_expr(x->m_args[i].m_a);
            alloc_arg_copy.m_len_expr = self().duplicate_expr(x->m_args[i].m_len_expr);
            alloc_arg_copy.m_type = self().duplicate_ttype(x->m_args[i].m_type);
            alloc_arg_copy.n_dims = x->m_args[i].n_dims;
            Vec<ASR::dimension_t> dims_copy;
            dims_copy.reserve(al, alloc_arg_copy.n_dims);
            for (size_t j = 0; j < alloc_arg_copy.n_dims; j++) {
                ASR::dimension_t dim_copy;
                dim_copy.loc = x->m_args[i].m_dims[j].loc;
                dim_copy.m_start = self().duplicate_expr(x->m_args[i].m_dims[j].m_start);
                dim_copy.m_length = self().duplicate_expr(x->m_args[i].m_dims[j].m_length);
                dims_copy.push_back(al, dim_copy);
            }
            alloc_arg_copy.m_dims = dims_copy.p;
            m_args.push_back(al, alloc_arg_copy);
        }
        return make_ReAlloc_t(al, x->base.base.loc, m_args.p, x->n_args);
    }


    ASR::asr_t* duplicate_Assign(Assign_t* x) {
        return make_Assign_t(al, x->base.base.loc, x->m_label, x->m_variable);
    }


    ASR::asr_t* duplicate_Assignment(Assignment_t* x) {
        expr_t* m_target = self().duplicate_expr(x->m_target);
        expr_t* m_value = self().duplicate_expr(x->m_value);
        stmt_t* m_overloaded = self().duplicate_stmt(x->m_overloaded);
        return make_Assignment_t(al, x->base.base.loc, m_target, m_value, m_overloaded);
    }


    ASR::asr_t* duplicate_Associate(Associate_t* x) {
        expr_t* m_target = self().duplicate_expr(x->m_target);
        expr_t* m_value = self().duplicate_expr(x->m_value);
        return make_Associate_t(al, x->base.base.loc, m_target, m_value);
    }


    ASR::asr_t* duplicate_Cycle(Cycle_t* x) {
        return make_Cycle_t(al, x->base.base.loc, x->m_stmt_name);
    }


    ASR::asr_t* duplicate_ExplicitDeallocate(ExplicitDeallocate_t* x) {
        Vec<expr_t*> m_vars;
        m_vars.reserve(al, x->n_vars);
        for (size_t i = 0; i < x->n_vars; i++) {
            m_vars.push_back(al, self().duplicate_expr(x->m_vars[i]));
        }
        return make_ExplicitDeallocate_t(al, x->base.base.loc, m_vars.p, x->n_vars);
    }


    ASR::asr_t* duplicate_ImplicitDeallocate(ImplicitDeallocate_t* x) {
        Vec<expr_t*> m_vars;
        m_vars.reserve(al, x->n_vars);
        for (size_t i = 0; i < x->n_vars; i++) {
            m_vars.push_back(al, self().duplicate_expr(x->m_vars[i]));
        }
        return make_ImplicitDeallocate_t(al, x->base.base.loc, m_vars.p, x->n_vars);
    }


    ASR::asr_t* duplicate_DoConcurrentLoop(DoConcurrentLoop_t* x) {
        Vec<do_loop_head_t> m_head;
        m_head.reserve(al, x->n_head);
        for (size_t i = 0; i < x->n_head; i++) {
            ASR::do_loop_head_t head;
            head.loc = x->m_head[i].loc;
            head.m_v = duplicate_expr(x->m_head[i].m_v);
            head.m_start = duplicate_expr(x->m_head[i].m_start);
            head.m_end = duplicate_expr(x->m_head[i].m_end);
            head.m_increment = duplicate_expr(x->m_head[i].m_increment);
            m_head.push_back(al, head);
        }
        Vec<expr_t*> m_shared;
        m_shared.reserve(al, x->n_shared);
        for (size_t i = 0; i < x->n_shared; i++) {
            m_shared.push_back(al, self().duplicate_expr(x->m_shared[i]));
        }
        Vec<expr_t*> m_local;
        m_local.reserve(al, x->n_local);
        for (size_t i = 0; i < x->n_local; i++) {
            m_local.push_back(al, self().duplicate_expr(x->m_local[i]));
        }
        Vec<stmt_t*> m_body;
        m_body.reserve(al, x->n_body);
        for (size_t i = 0; i < x->n_body; i++) {
            m_body.push_back(al, self().duplicate_stmt(x->m_body[i]));
        }
        return make_DoConcurrentLoop_t(al, x->base.base.loc, m_head.p, x->n_head, m_shared.p, x->n_shared, m_local.p, x->n_local, x->m_reduction, x->n_reduction, m_body.p, x->n_body);
    }


    ASR::asr_t* duplicate_DoLoop(DoLoop_t* x) {
        ASR::do_loop_head_t m_head;
        m_head.loc = x->m_head.loc;
        m_head.m_v = duplicate_expr(x->m_head.m_v);
        m_head.m_start = duplicate_expr(x->m_head.m_start);
        m_head.m_end = duplicate_expr(x->m_head.m_end);
        m_head.m_increment = duplicate_expr(x->m_head.m_increment);
        Vec<stmt_t*> m_body;
        m_body.reserve(al, x->n_body);
        for (size_t i = 0; i < x->n_body; i++) {
            m_body.push_back(al, self().duplicate_stmt(x->m_body[i]));
        }
        Vec<stmt_t*> m_orelse;
        m_orelse.reserve(al, x->n_orelse);
        for (size_t i = 0; i < x->n_orelse; i++) {
            m_orelse.push_back(al, self().duplicate_stmt(x->m_orelse[i]));
        }
        return make_DoLoop_t(al, x->base.base.loc, x->m_name, m_head, m_body.p, x->n_body, m_orelse.p, x->n_orelse);
    }


    ASR::asr_t* duplicate_ErrorStop(ErrorStop_t* x) {
        expr_t* m_code = self().duplicate_expr(x->m_code);
        return make_ErrorStop_t(al, x->base.base.loc, m_code);
    }


    ASR::asr_t* duplicate_Exit(Exit_t* x) {
        return make_Exit_t(al, x->base.base.loc, x->m_stmt_name);
    }


    ASR::asr_t* duplicate_ForAllSingle(ForAllSingle_t* x) {
        ASR::do_loop_head_t m_head;
        m_head.loc = x->m_head.loc;
        m_head.m_v = duplicate_expr(x->m_head.m_v);
        m_head.m_start = duplicate_expr(x->m_head.m_start);
        m_head.m_end = duplicate_expr(x->m_head.m_end);
        m_head.m_increment = duplicate_expr(x->m_head.m_increment);
        stmt_t* m_assign_stmt = self().duplicate_stmt(x->m_assign_stmt);
        return make_ForAllSingle_t(al, x->base.base.loc, m_head, m_assign_stmt);
    }


    ASR::asr_t* duplicate_GoTo(GoTo_t* x) {
        return make_GoTo_t(al, x->base.base.loc, x->m_target_id, x->m_name);
    }


    ASR::asr_t* duplicate_GoToTarget(GoToTarget_t* x) {
        return make_GoToTarget_t(al, x->base.base.loc, x->m_id, x->m_name);
    }


    ASR::asr_t* duplicate_If(If_t* x) {
        expr_t* m_test = self().duplicate_expr(x->m_test);
        Vec<stmt_t*> m_body;
        m_body.reserve(al, x->n_body);
        for (size_t i = 0; i < x->n_body; i++) {
            m_body.push_back(al, self().duplicate_stmt(x->m_body[i]));
        }
        Vec<stmt_t*> m_orelse;
        m_orelse.reserve(al, x->n_orelse);
        for (size_t i = 0; i < x->n_orelse; i++) {
            m_orelse.push_back(al, self().duplicate_stmt(x->m_orelse[i]));
        }
        return make_If_t(al, x->base.base.loc, m_test, m_body.p, x->n_body, m_orelse.p, x->n_orelse);
    }


    ASR::asr_t* duplicate_IfArithmetic(IfArithmetic_t* x) {
        expr_t* m_test = self().duplicate_expr(x->m_test);
        return make_IfArithmetic_t(al, x->base.base.loc, m_test, x->m_lt_label, x->m_eq_label, x->m_gt_label);
    }


    ASR::asr_t* duplicate_Print(Print_t* x) {
        expr_t* m_text = self().duplicate_expr(x->m_text);
        return make_Print_t(al, x->base.base.loc, m_text);
    }


    ASR::asr_t* duplicate_FileOpen(FileOpen_t* x) {
        expr_t* m_newunit = self().duplicate_expr(x->m_newunit);
        expr_t* m_filename = self().duplicate_expr(x->m_filename);
        expr_t* m_status = self().duplicate_expr(x->m_status);
        expr_t* m_form = self().duplicate_expr(x->m_form);
        return make_FileOpen_t(al, x->base.base.loc, x->m_label, m_newunit, m_filename, m_status, m_form);
    }


    ASR::asr_t* duplicate_FileClose(FileClose_t* x) {
        expr_t* m_unit = self().duplicate_expr(x->m_unit);
        expr_t* m_iostat = self().duplicate_expr(x->m_iostat);
        expr_t* m_iomsg = self().duplicate_expr(x->m_iomsg);
        expr_t* m_err = self().duplicate_expr(x->m_err);
        expr_t* m_status = self().duplicate_expr(x->m_status);
        return make_FileClose_t(al, x->base.base.loc, x->m_label, m_unit, m_iostat, m_iomsg, m_err, m_status);
    }


    ASR::asr_t* duplicate_FileRead(FileRead_t* x) {
        expr_t* m_unit = self().duplicate_expr(x->m_unit);
        expr_t* m_fmt = self().duplicate_expr(x->m_fmt);
        expr_t* m_iomsg = self().duplicate_expr(x->m_iomsg);
        expr_t* m_iostat = self().duplicate_expr(x->m_iostat);
        expr_t* m_size = self().duplicate_expr(x->m_size);
        expr_t* m_id = self().duplicate_expr(x->m_id);
        Vec<expr_t*> m_values;
        m_values.reserve(al, x->n_values);
        for (size_t i = 0; i < x->n_values; i++) {
            m_values.push_back(al, self().duplicate_expr(x->m_values[i]));
        }
        stmt_t* m_overloaded = self().duplicate_stmt(x->m_overloaded);
        return make_FileRead_t(al, x->base.base.loc, x->m_label, m_unit, m_fmt, m_iomsg, m_iostat, m_size, m_id, m_values.p, x->n_values, m_overloaded);
    }


    ASR::asr_t* duplicate_FileBackspace(FileBackspace_t* x) {
        expr_t* m_unit = self().duplicate_expr(x->m_unit);
        expr_t* m_iostat = self().duplicate_expr(x->m_iostat);
        expr_t* m_err = self().duplicate_expr(x->m_err);
        return make_FileBackspace_t(al, x->base.base.loc, x->m_label, m_unit, m_iostat, m_err);
    }


    ASR::asr_t* duplicate_FileRewind(FileRewind_t* x) {
        expr_t* m_unit = self().duplicate_expr(x->m_unit);
        expr_t* m_iostat = self().duplicate_expr(x->m_iostat);
        expr_t* m_err = self().duplicate_expr(x->m_err);
        return make_FileRewind_t(al, x->base.base.loc, x->m_label, m_unit, m_iostat, m_err);
    }


    ASR::asr_t* duplicate_FileInquire(FileInquire_t* x) {
        expr_t* m_unit = self().duplicate_expr(x->m_unit);
        expr_t* m_file = self().duplicate_expr(x->m_file);
        expr_t* m_iostat = self().duplicate_expr(x->m_iostat);
        expr_t* m_err = self().duplicate_expr(x->m_err);
        expr_t* m_exist = self().duplicate_expr(x->m_exist);
        expr_t* m_opened = self().duplicate_expr(x->m_opened);
        expr_t* m_number = self().duplicate_expr(x->m_number);
        expr_t* m_named = self().duplicate_expr(x->m_named);
        expr_t* m_name = self().duplicate_expr(x->m_name);
        expr_t* m_access = self().duplicate_expr(x->m_access);
        expr_t* m_sequential = self().duplicate_expr(x->m_sequential);
        expr_t* m_direct = self().duplicate_expr(x->m_direct);
        expr_t* m_form = self().duplicate_expr(x->m_form);
        expr_t* m_formatted = self().duplicate_expr(x->m_formatted);
        expr_t* m_unformatted = self().duplicate_expr(x->m_unformatted);
        expr_t* m_recl = self().duplicate_expr(x->m_recl);
        expr_t* m_nextrec = self().duplicate_expr(x->m_nextrec);
        expr_t* m_blank = self().duplicate_expr(x->m_blank);
        expr_t* m_position = self().duplicate_expr(x->m_position);
        expr_t* m_action = self().duplicate_expr(x->m_action);
        expr_t* m_read = self().duplicate_expr(x->m_read);
        expr_t* m_write = self().duplicate_expr(x->m_write);
        expr_t* m_readwrite = self().duplicate_expr(x->m_readwrite);
        expr_t* m_delim = self().duplicate_expr(x->m_delim);
        expr_t* m_pad = self().duplicate_expr(x->m_pad);
        expr_t* m_flen = self().duplicate_expr(x->m_flen);
        expr_t* m_blocksize = self().duplicate_expr(x->m_blocksize);
        expr_t* m_convert = self().duplicate_expr(x->m_convert);
        expr_t* m_carriagecontrol = self().duplicate_expr(x->m_carriagecontrol);
        expr_t* m_size = self().duplicate_expr(x->m_size);
        expr_t* m_iolength = self().duplicate_expr(x->m_iolength);
        return make_FileInquire_t(al, x->base.base.loc, x->m_label, m_unit, m_file, m_iostat, m_err, m_exist, m_opened, m_number, m_named, m_name, m_access, m_sequential, m_direct, m_form, m_formatted, m_unformatted, m_recl, m_nextrec, m_blank, m_position, m_action, m_read, m_write, m_readwrite, m_delim, m_pad, m_flen, m_blocksize, m_convert, m_carriagecontrol, m_size, m_iolength);
    }


    ASR::asr_t* duplicate_FileWrite(FileWrite_t* x) {
        expr_t* m_unit = self().duplicate_expr(x->m_unit);
        expr_t* m_iomsg = self().duplicate_expr(x->m_iomsg);
        expr_t* m_iostat = self().duplicate_expr(x->m_iostat);
        expr_t* m_id = self().duplicate_expr(x->m_id);
        Vec<expr_t*> m_values;
        m_values.reserve(al, x->n_values);
        for (size_t i = 0; i < x->n_values; i++) {
            m_values.push_back(al, self().duplicate_expr(x->m_values[i]));
        }
        expr_t* m_separator = self().duplicate_expr(x->m_separator);
        expr_t* m_end = self().duplicate_expr(x->m_end);
        stmt_t* m_overloaded = self().duplicate_stmt(x->m_overloaded);
        return make_FileWrite_t(al, x->base.base.loc, x->m_label, m_unit, m_iomsg, m_iostat, m_id, m_values.p, x->n_values, m_separator, m_end, m_overloaded);
    }


    ASR::asr_t* duplicate_Return(Return_t* x) {
        return make_Return_t(al, x->base.base.loc);
    }


    ASR::asr_t* duplicate_Select(Select_t* x) {
        expr_t* m_test = self().duplicate_expr(x->m_test);
        Vec<case_stmt_t*> m_body;
        m_body.reserve(al, x->n_body);
        for (size_t i = 0; i < x->n_body; i++) {
            m_body.push_back(al, self().duplicate_case_stmt(x->m_body[i]));
        }
        Vec<stmt_t*> m_default;
        m_default.reserve(al, x->n_default);
        for (size_t i = 0; i < x->n_default; i++) {
            m_default.push_back(al, self().duplicate_stmt(x->m_default[i]));
        }
        return make_Select_t(al, x->base.base.loc, m_test, m_body.p, x->n_body, m_default.p, x->n_default, x->m_enable_fall_through);
    }


    ASR::asr_t* duplicate_Stop(Stop_t* x) {
        expr_t* m_code = self().duplicate_expr(x->m_code);
        return make_Stop_t(al, x->base.base.loc, m_code);
    }


    ASR::asr_t* duplicate_Assert(Assert_t* x) {
        expr_t* m_test = self().duplicate_expr(x->m_test);
        expr_t* m_msg = self().duplicate_expr(x->m_msg);
        return make_Assert_t(al, x->base.base.loc, m_test, m_msg);
    }


    ASR::asr_t* duplicate_SubroutineCall(SubroutineCall_t* x) {
        symbol_t* m_name = x->m_name;
        symbol_t* m_original_name = x->m_original_name;
        Vec<call_arg_t> m_args;
        m_args.reserve(al, x->n_args);
        for (size_t i = 0; i < x->n_args; i++) {
            ASR::call_arg_t call_arg_copy;
            call_arg_copy.loc = x->m_args[i].loc;
            call_arg_copy.m_value = self().duplicate_expr(x->m_args[i].m_value);
            m_args.push_back(al, call_arg_copy);
        }
        expr_t* m_dt = self().duplicate_expr(x->m_dt);
        return make_SubroutineCall_t(al, x->base.base.loc, m_name, m_original_name, m_args.p, x->n_args, m_dt);
    }


    ASR::asr_t* duplicate_IntrinsicImpureSubroutine(IntrinsicImpureSubroutine_t* x) {
        Vec<expr_t*> m_args;
        m_args.reserve(al, x->n_args);
        for (size_t i = 0; i < x->n_args; i++) {
            m_args.push_back(al, self().duplicate_expr(x->m_args[i]));
        }
        return make_IntrinsicImpureSubroutine_t(al, x->base.base.loc, x->m_sub_intrinsic_id, m_args.p, x->n_args, x->m_overload_id);
    }


    ASR::asr_t* duplicate_Where(Where_t* x) {
        expr_t* m_test = self().duplicate_expr(x->m_test);
        Vec<stmt_t*> m_body;
        m_body.reserve(al, x->n_body);
        for (size_t i = 0; i < x->n_body; i++) {
            m_body.push_back(al, self().duplicate_stmt(x->m_body[i]));
        }
        Vec<stmt_t*> m_orelse;
        m_orelse.reserve(al, x->n_orelse);
        for (size_t i = 0; i < x->n_orelse; i++) {
            m_orelse.push_back(al, self().duplicate_stmt(x->m_orelse[i]));
        }
        return make_Where_t(al, x->base.base.loc, m_test, m_body.p, x->n_body, m_orelse.p, x->n_orelse);
    }


    ASR::asr_t* duplicate_WhileLoop(WhileLoop_t* x) {
        expr_t* m_test = self().duplicate_expr(x->m_test);
        Vec<stmt_t*> m_body;
        m_body.reserve(al, x->n_body);
        for (size_t i = 0; i < x->n_body; i++) {
            m_body.push_back(al, self().duplicate_stmt(x->m_body[i]));
        }
        Vec<stmt_t*> m_orelse;
        m_orelse.reserve(al, x->n_orelse);
        for (size_t i = 0; i < x->n_orelse; i++) {
            m_orelse.push_back(al, self().duplicate_stmt(x->m_orelse[i]));
        }
        return make_WhileLoop_t(al, x->base.base.loc, x->m_name, m_test, m_body.p, x->n_body, m_orelse.p, x->n_orelse);
    }


    ASR::asr_t* duplicate_Nullify(Nullify_t* x) {
        Vec<expr_t*> m_vars;
        m_vars.reserve(al, x->n_vars);
        for (size_t i = 0; i < x->n_vars; i++) {
            m_vars.push_back(al, self().duplicate_expr(x->m_vars[i]));
        }
        return make_Nullify_t(al, x->base.base.loc, m_vars.p, x->n_vars);
    }


    ASR::asr_t* duplicate_Flush(Flush_t* x) {
        expr_t* m_unit = self().duplicate_expr(x->m_unit);
        expr_t* m_err = self().duplicate_expr(x->m_err);
        expr_t* m_iomsg = self().duplicate_expr(x->m_iomsg);
        expr_t* m_iostat = self().duplicate_expr(x->m_iostat);
        return make_Flush_t(al, x->base.base.loc, x->m_label, m_unit, m_err, m_iomsg, m_iostat);
    }


    ASR::asr_t* duplicate_ListAppend(ListAppend_t* x) {
        expr_t* m_a = self().duplicate_expr(x->m_a);
        expr_t* m_ele = self().duplicate_expr(x->m_ele);
        return make_ListAppend_t(al, x->base.base.loc, m_a, m_ele);
    }


    ASR::asr_t* duplicate_AssociateBlockCall(AssociateBlockCall_t* x) {
        symbol_t* m_m = x->m_m;
        return make_AssociateBlockCall_t(al, x->base.base.loc, m_m);
    }


    ASR::asr_t* duplicate_SelectType(SelectType_t* x) {
        expr_t* m_selector = self().duplicate_expr(x->m_selector);
        Vec<stmt_t*> m_default;
        m_default.reserve(al, x->n_default);
        for (size_t i = 0; i < x->n_default; i++) {
            m_default.push_back(al, self().duplicate_stmt(x->m_default[i]));
        }
        return make_SelectType_t(al, x->base.base.loc, m_selector, x->m_body, x->n_body, m_default.p, x->n_default);
    }


    ASR::asr_t* duplicate_CPtrToPointer(CPtrToPointer_t* x) {
        expr_t* m_cptr = self().duplicate_expr(x->m_cptr);
        expr_t* m_ptr = self().duplicate_expr(x->m_ptr);
        expr_t* m_shape = self().duplicate_expr(x->m_shape);
        expr_t* m_lower_bounds = self().duplicate_expr(x->m_lower_bounds);
        return make_CPtrToPointer_t(al, x->base.base.loc, m_cptr, m_ptr, m_shape, m_lower_bounds);
    }


    ASR::asr_t* duplicate_BlockCall(BlockCall_t* x) {
        symbol_t* m_m = x->m_m;
        return make_BlockCall_t(al, x->base.base.loc, x->m_label, m_m);
    }


    ASR::asr_t* duplicate_SetInsert(SetInsert_t* x) {
        expr_t* m_a = self().duplicate_expr(x->m_a);
        expr_t* m_ele = self().duplicate_expr(x->m_ele);
        return make_SetInsert_t(al, x->base.base.loc, m_a, m_ele);
    }


    ASR::asr_t* duplicate_SetRemove(SetRemove_t* x) {
        expr_t* m_a = self().duplicate_expr(x->m_a);
        expr_t* m_ele = self().duplicate_expr(x->m_ele);
        return make_SetRemove_t(al, x->base.base.loc, m_a, m_ele);
    }


    ASR::asr_t* duplicate_ListInsert(ListInsert_t* x) {
        expr_t* m_a = self().duplicate_expr(x->m_a);
        expr_t* m_pos = self().duplicate_expr(x->m_pos);
        expr_t* m_ele = self().duplicate_expr(x->m_ele);
        return make_ListInsert_t(al, x->base.base.loc, m_a, m_pos, m_ele);
    }


    ASR::asr_t* duplicate_ListRemove(ListRemove_t* x) {
        expr_t* m_a = self().duplicate_expr(x->m_a);
        expr_t* m_ele = self().duplicate_expr(x->m_ele);
        return make_ListRemove_t(al, x->base.base.loc, m_a, m_ele);
    }


    ASR::asr_t* duplicate_ListClear(ListClear_t* x) {
        expr_t* m_a = self().duplicate_expr(x->m_a);
        return make_ListClear_t(al, x->base.base.loc, m_a);
    }


    ASR::asr_t* duplicate_DictInsert(DictInsert_t* x) {
        expr_t* m_a = self().duplicate_expr(x->m_a);
        expr_t* m_key = self().duplicate_expr(x->m_key);
        expr_t* m_value = self().duplicate_expr(x->m_value);
        return make_DictInsert_t(al, x->base.base.loc, m_a, m_key, m_value);
    }


    ASR::asr_t* duplicate_Expr(Expr_t* x) {
        expr_t* m_expression = self().duplicate_expr(x->m_expression);
        return make_Expr_t(al, x->base.base.loc, m_expression);
    }


    ASR::asr_t* duplicate_IfExp(IfExp_t* x) {
        expr_t* m_test = self().duplicate_expr(x->m_test);
        expr_t* m_body = self().duplicate_expr(x->m_body);
        expr_t* m_orelse = self().duplicate_expr(x->m_orelse);
        ttype_t* m_type = self().duplicate_ttype(x->m_type);
        expr_t* m_value = self().duplicate_expr(x->m_value);
        return make_IfExp_t(al, x->base.base.loc, m_test, m_body, m_orelse, m_type, m_value);
    }


    ASR::asr_t* duplicate_ComplexConstructor(ComplexConstructor_t* x) {
        expr_t* m_re = self().duplicate_expr(x->m_re);
        expr_t* m_im = self().duplicate_expr(x->m_im);
        ttype_t* m_type = self().duplicate_ttype(x->m_type);
        expr_t* m_value = self().duplicate_expr(x->m_value);
        return make_ComplexConstructor_t(al, x->base.base.loc, m_re, m_im, m_type, m_value);
    }


    ASR::asr_t* duplicate_NamedExpr(NamedExpr_t* x) {
        expr_t* m_target = self().duplicate_expr(x->m_target);
        expr_t* m_value = self().duplicate_expr(x->m_value);
        ttype_t* m_type = self().duplicate_ttype(x->m_type);
        return make_NamedExpr_t(al, x->base.base.loc, m_target, m_value, m_type);
    }


    ASR::asr_t* duplicate_FunctionCall(FunctionCall_t* x) {
        symbol_t* m_name = x->m_name;
        symbol_t* m_original_name = x->m_original_name;
        Vec<call_arg_t> m_args;
        m_args.reserve(al, x->n_args);
        for (size_t i = 0; i < x->n_args; i++) {
            ASR::call_arg_t call_arg_copy;
            call_arg_copy.loc = x->m_args[i].loc;
            call_arg_copy.m_value = self().duplicate_expr(x->m_args[i].m_value);
            m_args.push_back(al, call_arg_copy);
        }
        ttype_t* m_type = self().duplicate_ttype(x->m_type);
        expr_t* m_value = self().duplicate_expr(x->m_value);
        expr_t* m_dt = self().duplicate_expr(x->m_dt);
        return make_FunctionCall_t(al, x->base.base.loc, m_name, m_original_name, m_args.p, x->n_args, m_type, m_value, m_dt);
    }


    ASR::asr_t* duplicate_IntrinsicElementalFunction(IntrinsicElementalFunction_t* x) {
        Vec<expr_t*> m_args;
        m_args.reserve(al, x->n_args);
        for (size_t i = 0; i < x->n_args; i++) {
            m_args.push_back(al, self().duplicate_expr(x->m_args[i]));
        }
        ttype_t* m_type = self().duplicate_ttype(x->m_type);
        expr_t* m_value = self().duplicate_expr(x->m_value);
        return make_IntrinsicElementalFunction_t(al, x->base.base.loc, x->m_intrinsic_id, m_args.p, x->n_args, x->m_overload_id, m_type, m_value);
    }


    ASR::asr_t* duplicate_IntrinsicArrayFunction(IntrinsicArrayFunction_t* x) {
        Vec<expr_t*> m_args;
        m_args.reserve(al, x->n_args);
        for (size_t i = 0; i < x->n_args; i++) {
            m_args.push_back(al, self().duplicate_expr(x->m_args[i]));
        }
        ttype_t* m_type = self().duplicate_ttype(x->m_type);
        expr_t* m_value = self().duplicate_expr(x->m_value);
        return make_IntrinsicArrayFunction_t(al, x->base.base.loc, x->m_arr_intrinsic_id, m_args.p, x->n_args, x->m_overload_id, m_type, m_value);
    }


    ASR::asr_t* duplicate_IntrinsicImpureFunction(IntrinsicImpureFunction_t* x) {
        Vec<expr_t*> m_args;
        m_args.reserve(al, x->n_args);
        for (size_t i = 0; i < x->n_args; i++) {
            m_args.push_back(al, self().duplicate_expr(x->m_args[i]));
        }
        ttype_t* m_type = self().duplicate_ttype(x->m_type);
        expr_t* m_value = self().duplicate_expr(x->m_value);
        return make_IntrinsicImpureFunction_t(al, x->base.base.loc, x->m_impure_intrinsic_id, m_args.p, x->n_args, x->m_overload_id, m_type, m_value);
    }


    ASR::asr_t* duplicate_TypeInquiry(TypeInquiry_t* x) {
        ttype_t* m_arg_type = self().duplicate_ttype(x->m_arg_type);
        expr_t* m_arg = self().duplicate_expr(x->m_arg);
        ttype_t* m_type = self().duplicate_ttype(x->m_type);
        expr_t* m_value = self().duplicate_expr(x->m_value);
        return make_TypeInquiry_t(al, x->base.base.loc, x->m_inquiry_id, m_arg_type, m_arg, m_type, m_value);
    }


    ASR::asr_t* duplicate_StructConstructor(StructConstructor_t* x) {
        symbol_t* m_dt_sym = x->m_dt_sym;
        Vec<call_arg_t> m_args;
        m_args.reserve(al, x->n_args);
        for (size_t i = 0; i < x->n_args; i++) {
            ASR::call_arg_t call_arg_copy;
            call_arg_copy.loc = x->m_args[i].loc;
            call_arg_copy.m_value = self().duplicate_expr(x->m_args[i].m_value);
            m_args.push_back(al, call_arg_copy);
        }
        ttype_t* m_type = self().duplicate_ttype(x->m_type);
        expr_t* m_value = self().duplicate_expr(x->m_value);
        return make_StructConstructor_t(al, x->base.base.loc, m_dt_sym, m_args.p, x->n_args, m_type, m_value);
    }


    ASR::asr_t* duplicate_StructConstant(StructConstant_t* x) {
        symbol_t* m_dt_sym = x->m_dt_sym;
        Vec<call_arg_t> m_args;
        m_args.reserve(al, x->n_args);
        for (size_t i = 0; i < x->n_args; i++) {
            ASR::call_arg_t call_arg_copy;
            call_arg_copy.loc = x->m_args[i].loc;
            call_arg_copy.m_value = self().duplicate_expr(x->m_args[i].m_value);
            m_args.push_back(al, call_arg_copy);
        }
        ttype_t* m_type = self().duplicate_ttype(x->m_type);
        return make_StructConstant_t(al, x->base.base.loc, m_dt_sym, m_args.p, x->n_args, m_type);
    }


    ASR::asr_t* duplicate_EnumConstructor(EnumConstructor_t* x) {
        symbol_t* m_dt_sym = x->m_dt_sym;
        Vec<expr_t*> m_args;
        m_args.reserve(al, x->n_args);
        for (size_t i = 0; i < x->n_args; i++) {
            m_args.push_back(al, self().duplicate_expr(x->m_args[i]));
        }
        ttype_t* m_type = self().duplicate_ttype(x->m_type);
        expr_t* m_value = self().duplicate_expr(x->m_value);
        return make_EnumConstructor_t(al, x->base.base.loc, m_dt_sym, m_args.p, x->n_args, m_type, m_value);
    }


    ASR::asr_t* duplicate_UnionConstructor(UnionConstructor_t* x) {
        symbol_t* m_dt_sym = x->m_dt_sym;
        Vec<expr_t*> m_args;
        m_args.reserve(al, x->n_args);
        for (size_t i = 0; i < x->n_args; i++) {
            m_args.push_back(al, self().duplicate_expr(x->m_args[i]));
        }
        ttype_t* m_type = self().duplicate_ttype(x->m_type);
        expr_t* m_value = self().duplicate_expr(x->m_value);
        return make_UnionConstructor_t(al, x->base.base.loc, m_dt_sym, m_args.p, x->n_args, m_type, m_value);
    }


    ASR::asr_t* duplicate_ImpliedDoLoop(ImpliedDoLoop_t* x) {
        Vec<expr_t*> m_values;
        m_values.reserve(al, x->n_values);
        for (size_t i = 0; i < x->n_values; i++) {
            m_values.push_back(al, self().duplicate_expr(x->m_values[i]));
        }
        expr_t* m_var = self().duplicate_expr(x->m_var);
        expr_t* m_start = self().duplicate_expr(x->m_start);
        expr_t* m_end = self().duplicate_expr(x->m_end);
        expr_t* m_increment = self().duplicate_expr(x->m_increment);
        ttype_t* m_type = self().duplicate_ttype(x->m_type);
        expr_t* m_value = self().duplicate_expr(x->m_value);
        return make_ImpliedDoLoop_t(al, x->base.base.loc, m_values.p, x->n_values, m_var, m_start, m_end, m_increment, m_type, m_value);
    }


    ASR::asr_t* duplicate_IntegerConstant(IntegerConstant_t* x) {
        ttype_t* m_type = self().duplicate_ttype(x->m_type);
        return make_IntegerConstant_t(al, x->base.base.loc, x->m_n, m_type, x->m_intboz_type);
    }


    ASR::asr_t* duplicate_IntegerBitNot(IntegerBitNot_t* x) {
        expr_t* m_arg = self().duplicate_expr(x->m_arg);
        ttype_t* m_type = self().duplicate_ttype(x->m_type);
        expr_t* m_value = self().duplicate_expr(x->m_value);
        return make_IntegerBitNot_t(al, x->base.base.loc, m_arg, m_type, m_value);
    }


    ASR::asr_t* duplicate_IntegerUnaryMinus(IntegerUnaryMinus_t* x) {
        expr_t* m_arg = self().duplicate_expr(x->m_arg);
        ttype_t* m_type = self().duplicate_ttype(x->m_type);
        expr_t* m_value = self().duplicate_expr(x->m_value);
        return make_IntegerUnaryMinus_t(al, x->base.base.loc, m_arg, m_type, m_value);
    }


    ASR::asr_t* duplicate_IntegerCompare(IntegerCompare_t* x) {
        expr_t* m_left = self().duplicate_expr(x->m_left);
        expr_t* m_right = self().duplicate_expr(x->m_right);
        ttype_t* m_type = self().duplicate_ttype(x->m_type);
        expr_t* m_value = self().duplicate_expr(x->m_value);
        return make_IntegerCompare_t(al, x->base.base.loc, m_left, x->m_op, m_right, m_type, m_value);
    }


    ASR::asr_t* duplicate_IntegerBinOp(IntegerBinOp_t* x) {
        expr_t* m_left = self().duplicate_expr(x->m_left);
        expr_t* m_right = self().duplicate_expr(x->m_right);
        ttype_t* m_type = self().duplicate_ttype(x->m_type);
        expr_t* m_value = self().duplicate_expr(x->m_value);
        return make_IntegerBinOp_t(al, x->base.base.loc, m_left, x->m_op, m_right, m_type, m_value);
    }


    ASR::asr_t* duplicate_UnsignedIntegerConstant(UnsignedIntegerConstant_t* x) {
        ttype_t* m_type = self().duplicate_ttype(x->m_type);
        return make_UnsignedIntegerConstant_t(al, x->base.base.loc, x->m_n, m_type);
    }


    ASR::asr_t* duplicate_UnsignedIntegerUnaryMinus(UnsignedIntegerUnaryMinus_t* x) {
        expr_t* m_arg = self().duplicate_expr(x->m_arg);
        ttype_t* m_type = self().duplicate_ttype(x->m_type);
        expr_t* m_value = self().duplicate_expr(x->m_value);
        return make_UnsignedIntegerUnaryMinus_t(al, x->base.base.loc, m_arg, m_type, m_value);
    }


    ASR::asr_t* duplicate_UnsignedIntegerBitNot(UnsignedIntegerBitNot_t* x) {
        expr_t* m_arg = self().duplicate_expr(x->m_arg);
        ttype_t* m_type = self().duplicate_ttype(x->m_type);
        expr_t* m_value = self().duplicate_expr(x->m_value);
        return make_UnsignedIntegerBitNot_t(al, x->base.base.loc, m_arg, m_type, m_value);
    }


    ASR::asr_t* duplicate_UnsignedIntegerCompare(UnsignedIntegerCompare_t* x) {
        expr_t* m_left = self().duplicate_expr(x->m_left);
        expr_t* m_right = self().duplicate_expr(x->m_right);
        ttype_t* m_type = self().duplicate_ttype(x->m_type);
        expr_t* m_value = self().duplicate_expr(x->m_value);
        return make_UnsignedIntegerCompare_t(al, x->base.base.loc, m_left, x->m_op, m_right, m_type, m_value);
    }


    ASR::asr_t* duplicate_UnsignedIntegerBinOp(UnsignedIntegerBinOp_t* x) {
        expr_t* m_left = self().duplicate_expr(x->m_left);
        expr_t* m_right = self().duplicate_expr(x->m_right);
        ttype_t* m_type = self().duplicate_ttype(x->m_type);
        expr_t* m_value = self().duplicate_expr(x->m_value);
        return make_UnsignedIntegerBinOp_t(al, x->base.base.loc, m_left, x->m_op, m_right, m_type, m_value);
    }


    ASR::asr_t* duplicate_RealConstant(RealConstant_t* x) {
        ttype_t* m_type = self().duplicate_ttype(x->m_type);
        return make_RealConstant_t(al, x->base.base.loc, x->m_r, m_type);
    }


    ASR::asr_t* duplicate_RealUnaryMinus(RealUnaryMinus_t* x) {
        expr_t* m_arg = self().duplicate_expr(x->m_arg);
        ttype_t* m_type = self().duplicate_ttype(x->m_type);
        expr_t* m_value = self().duplicate_expr(x->m_value);
        return make_RealUnaryMinus_t(al, x->base.base.loc, m_arg, m_type, m_value);
    }


    ASR::asr_t* duplicate_RealCompare(RealCompare_t* x) {
        expr_t* m_left = self().duplicate_expr(x->m_left);
        expr_t* m_right = self().duplicate_expr(x->m_right);
        ttype_t* m_type = self().duplicate_ttype(x->m_type);
        expr_t* m_value = self().duplicate_expr(x->m_value);
        return make_RealCompare_t(al, x->base.base.loc, m_left, x->m_op, m_right, m_type, m_value);
    }


    ASR::asr_t* duplicate_RealBinOp(RealBinOp_t* x) {
        expr_t* m_left = self().duplicate_expr(x->m_left);
        expr_t* m_right = self().duplicate_expr(x->m_right);
        ttype_t* m_type = self().duplicate_ttype(x->m_type);
        expr_t* m_value = self().duplicate_expr(x->m_value);
        return make_RealBinOp_t(al, x->base.base.loc, m_left, x->m_op, m_right, m_type, m_value);
    }


    ASR::asr_t* duplicate_RealCopySign(RealCopySign_t* x) {
        expr_t* m_target = self().duplicate_expr(x->m_target);
        expr_t* m_source = self().duplicate_expr(x->m_source);
        ttype_t* m_type = self().duplicate_ttype(x->m_type);
        expr_t* m_value = self().duplicate_expr(x->m_value);
        return make_RealCopySign_t(al, x->base.base.loc, m_target, m_source, m_type, m_value);
    }


    ASR::asr_t* duplicate_ComplexConstant(ComplexConstant_t* x) {
        ttype_t* m_type = self().duplicate_ttype(x->m_type);
        return make_ComplexConstant_t(al, x->base.base.loc, x->m_re, x->m_im, m_type);
    }


    ASR::asr_t* duplicate_ComplexUnaryMinus(ComplexUnaryMinus_t* x) {
        expr_t* m_arg = self().duplicate_expr(x->m_arg);
        ttype_t* m_type = self().duplicate_ttype(x->m_type);
        expr_t* m_value = self().duplicate_expr(x->m_value);
        return make_ComplexUnaryMinus_t(al, x->base.base.loc, m_arg, m_type, m_value);
    }


    ASR::asr_t* duplicate_ComplexCompare(ComplexCompare_t* x) {
        expr_t* m_left = self().duplicate_expr(x->m_left);
        expr_t* m_right = self().duplicate_expr(x->m_right);
        ttype_t* m_type = self().duplicate_ttype(x->m_type);
        expr_t* m_value = self().duplicate_expr(x->m_value);
        return make_ComplexCompare_t(al, x->base.base.loc, m_left, x->m_op, m_right, m_type, m_value);
    }


    ASR::asr_t* duplicate_ComplexBinOp(ComplexBinOp_t* x) {
        expr_t* m_left = self().duplicate_expr(x->m_left);
        expr_t* m_right = self().duplicate_expr(x->m_right);
        ttype_t* m_type = self().duplicate_ttype(x->m_type);
        expr_t* m_value = self().duplicate_expr(x->m_value);
        return make_ComplexBinOp_t(al, x->base.base.loc, m_left, x->m_op, m_right, m_type, m_value);
    }


    ASR::asr_t* duplicate_LogicalConstant(LogicalConstant_t* x) {
        ttype_t* m_type = self().duplicate_ttype(x->m_type);
        return make_LogicalConstant_t(al, x->base.base.loc, x->m_value, m_type);
    }


    ASR::asr_t* duplicate_LogicalNot(LogicalNot_t* x) {
        expr_t* m_arg = self().duplicate_expr(x->m_arg);
        ttype_t* m_type = self().duplicate_ttype(x->m_type);
        expr_t* m_value = self().duplicate_expr(x->m_value);
        return make_LogicalNot_t(al, x->base.base.loc, m_arg, m_type, m_value);
    }


    ASR::asr_t* duplicate_LogicalCompare(LogicalCompare_t* x) {
        expr_t* m_left = self().duplicate_expr(x->m_left);
        expr_t* m_right = self().duplicate_expr(x->m_right);
        ttype_t* m_type = self().duplicate_ttype(x->m_type);
        expr_t* m_value = self().duplicate_expr(x->m_value);
        return make_LogicalCompare_t(al, x->base.base.loc, m_left, x->m_op, m_right, m_type, m_value);
    }


    ASR::asr_t* duplicate_LogicalBinOp(LogicalBinOp_t* x) {
        expr_t* m_left = self().duplicate_expr(x->m_left);
        expr_t* m_right = self().duplicate_expr(x->m_right);
        ttype_t* m_type = self().duplicate_ttype(x->m_type);
        expr_t* m_value = self().duplicate_expr(x->m_value);
        return make_LogicalBinOp_t(al, x->base.base.loc, m_left, x->m_op, m_right, m_type, m_value);
    }


    ASR::asr_t* duplicate_ListConstant(ListConstant_t* x) {
        Vec<expr_t*> m_args;
        m_args.reserve(al, x->n_args);
        for (size_t i = 0; i < x->n_args; i++) {
            m_args.push_back(al, self().duplicate_expr(x->m_args[i]));
        }
        ttype_t* m_type = self().duplicate_ttype(x->m_type);
        return make_ListConstant_t(al, x->base.base.loc, m_args.p, x->n_args, m_type);
    }


    ASR::asr_t* duplicate_ListLen(ListLen_t* x) {
        expr_t* m_arg = self().duplicate_expr(x->m_arg);
        ttype_t* m_type = self().duplicate_ttype(x->m_type);
        expr_t* m_value = self().duplicate_expr(x->m_value);
        return make_ListLen_t(al, x->base.base.loc, m_arg, m_type, m_value);
    }


    ASR::asr_t* duplicate_ListConcat(ListConcat_t* x) {
        expr_t* m_left = self().duplicate_expr(x->m_left);
        expr_t* m_right = self().duplicate_expr(x->m_right);
        ttype_t* m_type = self().duplicate_ttype(x->m_type);
        expr_t* m_value = self().duplicate_expr(x->m_value);
        return make_ListConcat_t(al, x->base.base.loc, m_left, m_right, m_type, m_value);
    }


    ASR::asr_t* duplicate_ListCompare(ListCompare_t* x) {
        expr_t* m_left = self().duplicate_expr(x->m_left);
        expr_t* m_right = self().duplicate_expr(x->m_right);
        ttype_t* m_type = self().duplicate_ttype(x->m_type);
        expr_t* m_value = self().duplicate_expr(x->m_value);
        return make_ListCompare_t(al, x->base.base.loc, m_left, x->m_op, m_right, m_type, m_value);
    }


    ASR::asr_t* duplicate_ListCount(ListCount_t* x) {
        expr_t* m_arg = self().duplicate_expr(x->m_arg);
        expr_t* m_ele = self().duplicate_expr(x->m_ele);
        ttype_t* m_type = self().duplicate_ttype(x->m_type);
        expr_t* m_value = self().duplicate_expr(x->m_value);
        return make_ListCount_t(al, x->base.base.loc, m_arg, m_ele, m_type, m_value);
    }


    ASR::asr_t* duplicate_SetConstant(SetConstant_t* x) {
        Vec<expr_t*> m_elements;
        m_elements.reserve(al, x->n_elements);
        for (size_t i = 0; i < x->n_elements; i++) {
            m_elements.push_back(al, self().duplicate_expr(x->m_elements[i]));
        }
        ttype_t* m_type = self().duplicate_ttype(x->m_type);
        return make_SetConstant_t(al, x->base.base.loc, m_elements.p, x->n_elements, m_type);
    }


    ASR::asr_t* duplicate_SetLen(SetLen_t* x) {
        expr_t* m_arg = self().duplicate_expr(x->m_arg);
        ttype_t* m_type = self().duplicate_ttype(x->m_type);
        expr_t* m_value = self().duplicate_expr(x->m_value);
        return make_SetLen_t(al, x->base.base.loc, m_arg, m_type, m_value);
    }


    ASR::asr_t* duplicate_TupleConstant(TupleConstant_t* x) {
        Vec<expr_t*> m_elements;
        m_elements.reserve(al, x->n_elements);
        for (size_t i = 0; i < x->n_elements; i++) {
            m_elements.push_back(al, self().duplicate_expr(x->m_elements[i]));
        }
        ttype_t* m_type = self().duplicate_ttype(x->m_type);
        return make_TupleConstant_t(al, x->base.base.loc, m_elements.p, x->n_elements, m_type);
    }


    ASR::asr_t* duplicate_TupleLen(TupleLen_t* x) {
        expr_t* m_arg = self().duplicate_expr(x->m_arg);
        ttype_t* m_type = self().duplicate_ttype(x->m_type);
        expr_t* m_value = self().duplicate_expr(x->m_value);
        return make_TupleLen_t(al, x->base.base.loc, m_arg, m_type, m_value);
    }


    ASR::asr_t* duplicate_TupleCompare(TupleCompare_t* x) {
        expr_t* m_left = self().duplicate_expr(x->m_left);
        expr_t* m_right = self().duplicate_expr(x->m_right);
        ttype_t* m_type = self().duplicate_ttype(x->m_type);
        expr_t* m_value = self().duplicate_expr(x->m_value);
        return make_TupleCompare_t(al, x->base.base.loc, m_left, x->m_op, m_right, m_type, m_value);
    }


    ASR::asr_t* duplicate_TupleConcat(TupleConcat_t* x) {
        expr_t* m_left = self().duplicate_expr(x->m_left);
        expr_t* m_right = self().duplicate_expr(x->m_right);
        ttype_t* m_type = self().duplicate_ttype(x->m_type);
        expr_t* m_value = self().duplicate_expr(x->m_value);
        return make_TupleConcat_t(al, x->base.base.loc, m_left, m_right, m_type, m_value);
    }


    ASR::asr_t* duplicate_StringConstant(StringConstant_t* x) {
        ttype_t* m_type = self().duplicate_ttype(x->m_type);
        return make_StringConstant_t(al, x->base.base.loc, x->m_s, m_type);
    }


    ASR::asr_t* duplicate_StringConcat(StringConcat_t* x) {
        expr_t* m_left = self().duplicate_expr(x->m_left);
        expr_t* m_right = self().duplicate_expr(x->m_right);
        ttype_t* m_type = self().duplicate_ttype(x->m_type);
        expr_t* m_value = self().duplicate_expr(x->m_value);
        return make_StringConcat_t(al, x->base.base.loc, m_left, m_right, m_type, m_value);
    }


    ASR::asr_t* duplicate_StringRepeat(StringRepeat_t* x) {
        expr_t* m_left = self().duplicate_expr(x->m_left);
        expr_t* m_right = self().duplicate_expr(x->m_right);
        ttype_t* m_type = self().duplicate_ttype(x->m_type);
        expr_t* m_value = self().duplicate_expr(x->m_value);
        return make_StringRepeat_t(al, x->base.base.loc, m_left, m_right, m_type, m_value);
    }


    ASR::asr_t* duplicate_StringLen(StringLen_t* x) {
        expr_t* m_arg = self().duplicate_expr(x->m_arg);
        ttype_t* m_type = self().duplicate_ttype(x->m_type);
        expr_t* m_value = self().duplicate_expr(x->m_value);
        return make_StringLen_t(al, x->base.base.loc, m_arg, m_type, m_value);
    }


    ASR::asr_t* duplicate_StringItem(StringItem_t* x) {
        expr_t* m_arg = self().duplicate_expr(x->m_arg);
        expr_t* m_idx = self().duplicate_expr(x->m_idx);
        ttype_t* m_type = self().duplicate_ttype(x->m_type);
        expr_t* m_value = self().duplicate_expr(x->m_value);
        return make_StringItem_t(al, x->base.base.loc, m_arg, m_idx, m_type, m_value);
    }


    ASR::asr_t* duplicate_StringSection(StringSection_t* x) {
        expr_t* m_arg = self().duplicate_expr(x->m_arg);
        expr_t* m_start = self().duplicate_expr(x->m_start);
        expr_t* m_end = self().duplicate_expr(x->m_end);
        expr_t* m_step = self().duplicate_expr(x->m_step);
        ttype_t* m_type = self().duplicate_ttype(x->m_type);
        expr_t* m_value = self().duplicate_expr(x->m_value);
        return make_StringSection_t(al, x->base.base.loc, m_arg, m_start, m_end, m_step, m_type, m_value);
    }


    ASR::asr_t* duplicate_StringCompare(StringCompare_t* x) {
        expr_t* m_left = self().duplicate_expr(x->m_left);
        expr_t* m_right = self().duplicate_expr(x->m_right);
        ttype_t* m_type = self().duplicate_ttype(x->m_type);
        expr_t* m_value = self().duplicate_expr(x->m_value);
        return make_StringCompare_t(al, x->base.base.loc, m_left, x->m_op, m_right, m_type, m_value);
    }


    ASR::asr_t* duplicate_StringContains(StringContains_t* x) {
        expr_t* m_substr = self().duplicate_expr(x->m_substr);
        expr_t* m_str = self().duplicate_expr(x->m_str);
        ttype_t* m_type = self().duplicate_ttype(x->m_type);
        expr_t* m_value = self().duplicate_expr(x->m_value);
        return make_StringContains_t(al, x->base.base.loc, m_substr, m_str, m_type, m_value);
    }


    ASR::asr_t* duplicate_StringOrd(StringOrd_t* x) {
        expr_t* m_arg = self().duplicate_expr(x->m_arg);
        ttype_t* m_type = self().duplicate_ttype(x->m_type);
        expr_t* m_value = self().duplicate_expr(x->m_value);
        return make_StringOrd_t(al, x->base.base.loc, m_arg, m_type, m_value);
    }


    ASR::asr_t* duplicate_StringChr(StringChr_t* x) {
        expr_t* m_arg = self().duplicate_expr(x->m_arg);
        ttype_t* m_type = self().duplicate_ttype(x->m_type);
        expr_t* m_value = self().duplicate_expr(x->m_value);
        return make_StringChr_t(al, x->base.base.loc, m_arg, m_type, m_value);
    }


    ASR::asr_t* duplicate_StringFormat(StringFormat_t* x) {
        expr_t* m_fmt = self().duplicate_expr(x->m_fmt);
        Vec<expr_t*> m_args;
        m_args.reserve(al, x->n_args);
        for (size_t i = 0; i < x->n_args; i++) {
            m_args.push_back(al, self().duplicate_expr(x->m_args[i]));
        }
        ttype_t* m_type = self().duplicate_ttype(x->m_type);
        expr_t* m_value = self().duplicate_expr(x->m_value);
        return make_StringFormat_t(al, x->base.base.loc, m_fmt, m_args.p, x->n_args, x->m_kind, m_type, m_value);
    }


    ASR::asr_t* duplicate_StringPhysicalCast(StringPhysicalCast_t* x) {
        expr_t* m_arg = self().duplicate_expr(x->m_arg);
        ttype_t* m_type = self().duplicate_ttype(x->m_type);
        expr_t* m_value = self().duplicate_expr(x->m_value);
        return make_StringPhysicalCast_t(al, x->base.base.loc, m_arg, x->m_old, x->m_new, m_type, m_value);
    }


    ASR::asr_t* duplicate_CPtrCompare(CPtrCompare_t* x) {
        expr_t* m_left = self().duplicate_expr(x->m_left);
        expr_t* m_right = self().duplicate_expr(x->m_right);
        ttype_t* m_type = self().duplicate_ttype(x->m_type);
        expr_t* m_value = self().duplicate_expr(x->m_value);
        return make_CPtrCompare_t(al, x->base.base.loc, m_left, x->m_op, m_right, m_type, m_value);
    }


    ASR::asr_t* duplicate_SymbolicCompare(SymbolicCompare_t* x) {
        expr_t* m_left = self().duplicate_expr(x->m_left);
        expr_t* m_right = self().duplicate_expr(x->m_right);
        ttype_t* m_type = self().duplicate_ttype(x->m_type);
        expr_t* m_value = self().duplicate_expr(x->m_value);
        return make_SymbolicCompare_t(al, x->base.base.loc, m_left, x->m_op, m_right, m_type, m_value);
    }


    ASR::asr_t* duplicate_DictConstant(DictConstant_t* x) {
        Vec<expr_t*> m_keys;
        m_keys.reserve(al, x->n_keys);
        for (size_t i = 0; i < x->n_keys; i++) {
            m_keys.push_back(al, self().duplicate_expr(x->m_keys[i]));
        }
        Vec<expr_t*> m_values;
        m_values.reserve(al, x->n_values);
        for (size_t i = 0; i < x->n_values; i++) {
            m_values.push_back(al, self().duplicate_expr(x->m_values[i]));
        }
        ttype_t* m_type = self().duplicate_ttype(x->m_type);
        return make_DictConstant_t(al, x->base.base.loc, m_keys.p, x->n_keys, m_values.p, x->n_values, m_type);
    }


    ASR::asr_t* duplicate_DictLen(DictLen_t* x) {
        expr_t* m_arg = self().duplicate_expr(x->m_arg);
        ttype_t* m_type = self().duplicate_ttype(x->m_type);
        expr_t* m_value = self().duplicate_expr(x->m_value);
        return make_DictLen_t(al, x->base.base.loc, m_arg, m_type, m_value);
    }


    ASR::asr_t* duplicate_Var(Var_t* x) {
        symbol_t* m_v = x->m_v;
        return make_Var_t(al, x->base.base.loc, m_v);
    }


    ASR::asr_t* duplicate_FunctionParam(FunctionParam_t* x) {
        ttype_t* m_type = self().duplicate_ttype(x->m_type);
        expr_t* m_value = self().duplicate_expr(x->m_value);
        return make_FunctionParam_t(al, x->base.base.loc, x->m_param_number, m_type, m_value);
    }


    ASR::asr_t* duplicate_ArrayConstructor(ArrayConstructor_t* x) {
        Vec<expr_t*> m_args;
        m_args.reserve(al, x->n_args);
        for (size_t i = 0; i < x->n_args; i++) {
            m_args.push_back(al, self().duplicate_expr(x->m_args[i]));
        }
        ttype_t* m_type = self().duplicate_ttype(x->m_type);
        expr_t* m_value = self().duplicate_expr(x->m_value);
        return make_ArrayConstructor_t(al, x->base.base.loc, m_args.p, x->n_args, m_type, m_value, x->m_storage_format);
    }


    ASR::asr_t* duplicate_ArrayConstant(ArrayConstant_t* x) {
        ttype_t* m_type = self().duplicate_ttype(x->m_type);
        return make_ArrayConstant_t(al, x->base.base.loc, x->m_n_data, x->m_data, m_type, x->m_storage_format);
    }


    ASR::asr_t* duplicate_ArrayItem(ArrayItem_t* x) {
        expr_t* m_v = self().duplicate_expr(x->m_v);
        Vec<array_index_t> m_args;
        m_args.reserve(al, x->n_args);
        for (size_t i = 0; i < x->n_args; i++) {
            ASR::array_index_t array_index_copy;
            array_index_copy.loc = x->m_args[i].loc;
            array_index_copy.m_left = duplicate_expr(x->m_args[i].m_left);
            array_index_copy.m_right = duplicate_expr(x->m_args[i].m_right);
            array_index_copy.m_step = duplicate_expr(x->m_args[i].m_step);
            m_args.push_back(al, array_index_copy);
        }
        ttype_t* m_type = self().duplicate_ttype(x->m_type);
        expr_t* m_value = self().duplicate_expr(x->m_value);
        return make_ArrayItem_t(al, x->base.base.loc, m_v, m_args.p, x->n_args, m_type, x->m_storage_format, m_value);
    }


    ASR::asr_t* duplicate_ArraySection(ArraySection_t* x) {
        expr_t* m_v = self().duplicate_expr(x->m_v);
        Vec<array_index_t> m_args;
        m_args.reserve(al, x->n_args);
        for (size_t i = 0; i < x->n_args; i++) {
            ASR::array_index_t array_index_copy;
            array_index_copy.loc = x->m_args[i].loc;
            array_index_copy.m_left = duplicate_expr(x->m_args[i].m_left);
            array_index_copy.m_right = duplicate_expr(x->m_args[i].m_right);
            array_index_copy.m_step = duplicate_expr(x->m_args[i].m_step);
            m_args.push_back(al, array_index_copy);
        }
        ttype_t* m_type = self().duplicate_ttype(x->m_type);
        expr_t* m_value = self().duplicate_expr(x->m_value);
        return make_ArraySection_t(al, x->base.base.loc, m_v, m_args.p, x->n_args, m_type, m_value);
    }


    ASR::asr_t* duplicate_ArraySize(ArraySize_t* x) {
        expr_t* m_v = self().duplicate_expr(x->m_v);
        expr_t* m_dim = self().duplicate_expr(x->m_dim);
        ttype_t* m_type = self().duplicate_ttype(x->m_type);
        expr_t* m_value = self().duplicate_expr(x->m_value);
        return make_ArraySize_t(al, x->base.base.loc, m_v, m_dim, m_type, m_value);
    }


    ASR::asr_t* duplicate_ArrayBound(ArrayBound_t* x) {
        expr_t* m_v = self().duplicate_expr(x->m_v);
        expr_t* m_dim = self().duplicate_expr(x->m_dim);
        ttype_t* m_type = self().duplicate_ttype(x->m_type);
        expr_t* m_value = self().duplicate_expr(x->m_value);
        return make_ArrayBound_t(al, x->base.base.loc, m_v, m_dim, m_type, x->m_bound, m_value);
    }


    ASR::asr_t* duplicate_ArrayTranspose(ArrayTranspose_t* x) {
        expr_t* m_matrix = self().duplicate_expr(x->m_matrix);
        ttype_t* m_type = self().duplicate_ttype(x->m_type);
        expr_t* m_value = self().duplicate_expr(x->m_value);
        return make_ArrayTranspose_t(al, x->base.base.loc, m_matrix, m_type, m_value);
    }


    ASR::asr_t* duplicate_ArrayPack(ArrayPack_t* x) {
        expr_t* m_array = self().duplicate_expr(x->m_array);
        expr_t* m_mask = self().duplicate_expr(x->m_mask);
        expr_t* m_vector = self().duplicate_expr(x->m_vector);
        ttype_t* m_type = self().duplicate_ttype(x->m_type);
        expr_t* m_value = self().duplicate_expr(x->m_value);
        return make_ArrayPack_t(al, x->base.base.loc, m_array, m_mask, m_vector, m_type, m_value);
    }


    ASR::asr_t* duplicate_ArrayReshape(ArrayReshape_t* x) {
        expr_t* m_array = self().duplicate_expr(x->m_array);
        expr_t* m_shape = self().duplicate_expr(x->m_shape);
        ttype_t* m_type = self().duplicate_ttype(x->m_type);
        expr_t* m_value = self().duplicate_expr(x->m_value);
        return make_ArrayReshape_t(al, x->base.base.loc, m_array, m_shape, m_type, m_value);
    }


    ASR::asr_t* duplicate_ArrayBroadcast(ArrayBroadcast_t* x) {
        expr_t* m_array = self().duplicate_expr(x->m_array);
        expr_t* m_shape = self().duplicate_expr(x->m_shape);
        ttype_t* m_type = self().duplicate_ttype(x->m_type);
        expr_t* m_value = self().duplicate_expr(x->m_value);
        return make_ArrayBroadcast_t(al, x->base.base.loc, m_array, m_shape, m_type, m_value);
    }


    ASR::asr_t* duplicate_BitCast(BitCast_t* x) {
        expr_t* m_source = self().duplicate_expr(x->m_source);
        expr_t* m_mold = self().duplicate_expr(x->m_mold);
        expr_t* m_size = self().duplicate_expr(x->m_size);
        ttype_t* m_type = self().duplicate_ttype(x->m_type);
        expr_t* m_value = self().duplicate_expr(x->m_value);
        return make_BitCast_t(al, x->base.base.loc, m_source, m_mold, m_size, m_type, m_value);
    }


    ASR::asr_t* duplicate_StructInstanceMember(StructInstanceMember_t* x) {
        expr_t* m_v = self().duplicate_expr(x->m_v);
        symbol_t* m_m = x->m_m;
        ttype_t* m_type = self().duplicate_ttype(x->m_type);
        expr_t* m_value = self().duplicate_expr(x->m_value);
        return make_StructInstanceMember_t(al, x->base.base.loc, m_v, m_m, m_type, m_value);
    }


    ASR::asr_t* duplicate_StructStaticMember(StructStaticMember_t* x) {
        expr_t* m_v = self().duplicate_expr(x->m_v);
        symbol_t* m_m = x->m_m;
        ttype_t* m_type = self().duplicate_ttype(x->m_type);
        expr_t* m_value = self().duplicate_expr(x->m_value);
        return make_StructStaticMember_t(al, x->base.base.loc, m_v, m_m, m_type, m_value);
    }


    ASR::asr_t* duplicate_EnumStaticMember(EnumStaticMember_t* x) {
        expr_t* m_v = self().duplicate_expr(x->m_v);
        symbol_t* m_m = x->m_m;
        ttype_t* m_type = self().duplicate_ttype(x->m_type);
        expr_t* m_value = self().duplicate_expr(x->m_value);
        return make_EnumStaticMember_t(al, x->base.base.loc, m_v, m_m, m_type, m_value);
    }


    ASR::asr_t* duplicate_UnionInstanceMember(UnionInstanceMember_t* x) {
        expr_t* m_v = self().duplicate_expr(x->m_v);
        symbol_t* m_m = x->m_m;
        ttype_t* m_type = self().duplicate_ttype(x->m_type);
        expr_t* m_value = self().duplicate_expr(x->m_value);
        return make_UnionInstanceMember_t(al, x->base.base.loc, m_v, m_m, m_type, m_value);
    }


    ASR::asr_t* duplicate_EnumName(EnumName_t* x) {
        expr_t* m_v = self().duplicate_expr(x->m_v);
        ttype_t* m_enum_type = self().duplicate_ttype(x->m_enum_type);
        ttype_t* m_type = self().duplicate_ttype(x->m_type);
        expr_t* m_value = self().duplicate_expr(x->m_value);
        return make_EnumName_t(al, x->base.base.loc, m_v, m_enum_type, m_type, m_value);
    }


    ASR::asr_t* duplicate_EnumValue(EnumValue_t* x) {
        expr_t* m_v = self().duplicate_expr(x->m_v);
        ttype_t* m_enum_type = self().duplicate_ttype(x->m_enum_type);
        ttype_t* m_type = self().duplicate_ttype(x->m_type);
        expr_t* m_value = self().duplicate_expr(x->m_value);
        return make_EnumValue_t(al, x->base.base.loc, m_v, m_enum_type, m_type, m_value);
    }


    ASR::asr_t* duplicate_OverloadedCompare(OverloadedCompare_t* x) {
        expr_t* m_left = self().duplicate_expr(x->m_left);
        expr_t* m_right = self().duplicate_expr(x->m_right);
        ttype_t* m_type = self().duplicate_ttype(x->m_type);
        expr_t* m_value = self().duplicate_expr(x->m_value);
        expr_t* m_overloaded = self().duplicate_expr(x->m_overloaded);
        return make_OverloadedCompare_t(al, x->base.base.loc, m_left, x->m_op, m_right, m_type, m_value, m_overloaded);
    }


    ASR::asr_t* duplicate_OverloadedBinOp(OverloadedBinOp_t* x) {
        expr_t* m_left = self().duplicate_expr(x->m_left);
        expr_t* m_right = self().duplicate_expr(x->m_right);
        ttype_t* m_type = self().duplicate_ttype(x->m_type);
        expr_t* m_value = self().duplicate_expr(x->m_value);
        expr_t* m_overloaded = self().duplicate_expr(x->m_overloaded);
        return make_OverloadedBinOp_t(al, x->base.base.loc, m_left, x->m_op, m_right, m_type, m_value, m_overloaded);
    }


    ASR::asr_t* duplicate_OverloadedUnaryMinus(OverloadedUnaryMinus_t* x) {
        expr_t* m_arg = self().duplicate_expr(x->m_arg);
        ttype_t* m_type = self().duplicate_ttype(x->m_type);
        expr_t* m_value = self().duplicate_expr(x->m_value);
        expr_t* m_overloaded = self().duplicate_expr(x->m_overloaded);
        return make_OverloadedUnaryMinus_t(al, x->base.base.loc, m_arg, m_type, m_value, m_overloaded);
    }


    ASR::asr_t* duplicate_OverloadedStringConcat(OverloadedStringConcat_t* x) {
        expr_t* m_left = self().duplicate_expr(x->m_left);
        expr_t* m_right = self().duplicate_expr(x->m_right);
        ttype_t* m_type = self().duplicate_ttype(x->m_type);
        expr_t* m_value = self().duplicate_expr(x->m_value);
        expr_t* m_overloaded = self().duplicate_expr(x->m_overloaded);
        return make_OverloadedStringConcat_t(al, x->base.base.loc, m_left, m_right, m_type, m_value, m_overloaded);
    }


    ASR::asr_t* duplicate_Cast(Cast_t* x) {
        expr_t* m_arg = self().duplicate_expr(x->m_arg);
        ttype_t* m_type = self().duplicate_ttype(x->m_type);
        expr_t* m_value = self().duplicate_expr(x->m_value);
        return make_Cast_t(al, x->base.base.loc, m_arg, x->m_kind, m_type, m_value);
    }


    ASR::asr_t* duplicate_ArrayPhysicalCast(ArrayPhysicalCast_t* x) {
        expr_t* m_arg = self().duplicate_expr(x->m_arg);
        ttype_t* m_type = self().duplicate_ttype(x->m_type);
        expr_t* m_value = self().duplicate_expr(x->m_value);
        return make_ArrayPhysicalCast_t(al, x->base.base.loc, m_arg, x->m_old, x->m_new, m_type, m_value);
    }


    ASR::asr_t* duplicate_ComplexRe(ComplexRe_t* x) {
        expr_t* m_arg = self().duplicate_expr(x->m_arg);
        ttype_t* m_type = self().duplicate_ttype(x->m_type);
        expr_t* m_value = self().duplicate_expr(x->m_value);
        return make_ComplexRe_t(al, x->base.base.loc, m_arg, m_type, m_value);
    }


    ASR::asr_t* duplicate_ComplexIm(ComplexIm_t* x) {
        expr_t* m_arg = self().duplicate_expr(x->m_arg);
        ttype_t* m_type = self().duplicate_ttype(x->m_type);
        expr_t* m_value = self().duplicate_expr(x->m_value);
        return make_ComplexIm_t(al, x->base.base.loc, m_arg, m_type, m_value);
    }


    ASR::asr_t* duplicate_DictItem(DictItem_t* x) {
        expr_t* m_a = self().duplicate_expr(x->m_a);
        expr_t* m_key = self().duplicate_expr(x->m_key);
        expr_t* m_default = self().duplicate_expr(x->m_default);
        ttype_t* m_type = self().duplicate_ttype(x->m_type);
        expr_t* m_value = self().duplicate_expr(x->m_value);
        return make_DictItem_t(al, x->base.base.loc, m_a, m_key, m_default, m_type, m_value);
    }


    ASR::asr_t* duplicate_CLoc(CLoc_t* x) {
        expr_t* m_arg = self().duplicate_expr(x->m_arg);
        ttype_t* m_type = self().duplicate_ttype(x->m_type);
        expr_t* m_value = self().duplicate_expr(x->m_value);
        return make_CLoc_t(al, x->base.base.loc, m_arg, m_type, m_value);
    }


    ASR::asr_t* duplicate_PointerToCPtr(PointerToCPtr_t* x) {
        expr_t* m_arg = self().duplicate_expr(x->m_arg);
        ttype_t* m_type = self().duplicate_ttype(x->m_type);
        expr_t* m_value = self().duplicate_expr(x->m_value);
        return make_PointerToCPtr_t(al, x->base.base.loc, m_arg, m_type, m_value);
    }


    ASR::asr_t* duplicate_GetPointer(GetPointer_t* x) {
        expr_t* m_arg = self().duplicate_expr(x->m_arg);
        ttype_t* m_type = self().duplicate_ttype(x->m_type);
        expr_t* m_value = self().duplicate_expr(x->m_value);
        return make_GetPointer_t(al, x->base.base.loc, m_arg, m_type, m_value);
    }


    ASR::asr_t* duplicate_ListItem(ListItem_t* x) {
        expr_t* m_a = self().duplicate_expr(x->m_a);
        expr_t* m_pos = self().duplicate_expr(x->m_pos);
        ttype_t* m_type = self().duplicate_ttype(x->m_type);
        expr_t* m_value = self().duplicate_expr(x->m_value);
        return make_ListItem_t(al, x->base.base.loc, m_a, m_pos, m_type, m_value);
    }


    ASR::asr_t* duplicate_TupleItem(TupleItem_t* x) {
        expr_t* m_a = self().duplicate_expr(x->m_a);
        expr_t* m_pos = self().duplicate_expr(x->m_pos);
        ttype_t* m_type = self().duplicate_ttype(x->m_type);
        expr_t* m_value = self().duplicate_expr(x->m_value);
        return make_TupleItem_t(al, x->base.base.loc, m_a, m_pos, m_type, m_value);
    }


    ASR::asr_t* duplicate_ListSection(ListSection_t* x) {
        expr_t* m_a = self().duplicate_expr(x->m_a);
        ASR::array_index_t m_section;
        m_section.loc = x->m_section.loc;
        m_section.m_left = duplicate_expr(x->m_section.m_left);
        m_section.m_right = duplicate_expr(x->m_section.m_right);
        m_section.m_step = duplicate_expr(x->m_section.m_step);
        ttype_t* m_type = self().duplicate_ttype(x->m_type);
        expr_t* m_value = self().duplicate_expr(x->m_value);
        return make_ListSection_t(al, x->base.base.loc, m_a, m_section, m_type, m_value);
    }


    ASR::asr_t* duplicate_ListRepeat(ListRepeat_t* x) {
        expr_t* m_left = self().duplicate_expr(x->m_left);
        expr_t* m_right = self().duplicate_expr(x->m_right);
        ttype_t* m_type = self().duplicate_ttype(x->m_type);
        expr_t* m_value = self().duplicate_expr(x->m_value);
        return make_ListRepeat_t(al, x->base.base.loc, m_left, m_right, m_type, m_value);
    }


    ASR::asr_t* duplicate_DictPop(DictPop_t* x) {
        expr_t* m_a = self().duplicate_expr(x->m_a);
        expr_t* m_key = self().duplicate_expr(x->m_key);
        ttype_t* m_type = self().duplicate_ttype(x->m_type);
        expr_t* m_value = self().duplicate_expr(x->m_value);
        return make_DictPop_t(al, x->base.base.loc, m_a, m_key, m_type, m_value);
    }


    ASR::asr_t* duplicate_SetPop(SetPop_t* x) {
        expr_t* m_a = self().duplicate_expr(x->m_a);
        ttype_t* m_type = self().duplicate_ttype(x->m_type);
        expr_t* m_value = self().duplicate_expr(x->m_value);
        return make_SetPop_t(al, x->base.base.loc, m_a, m_type, m_value);
    }


    ASR::asr_t* duplicate_IntegerBitLen(IntegerBitLen_t* x) {
        expr_t* m_a = self().duplicate_expr(x->m_a);
        ttype_t* m_type = self().duplicate_ttype(x->m_type);
        expr_t* m_value = self().duplicate_expr(x->m_value);
        return make_IntegerBitLen_t(al, x->base.base.loc, m_a, m_type, m_value);
    }


    ASR::asr_t* duplicate_Ichar(Ichar_t* x) {
        expr_t* m_arg = self().duplicate_expr(x->m_arg);
        ttype_t* m_type = self().duplicate_ttype(x->m_type);
        expr_t* m_value = self().duplicate_expr(x->m_value);
        return make_Ichar_t(al, x->base.base.loc, m_arg, m_type, m_value);
    }


    ASR::asr_t* duplicate_Iachar(Iachar_t* x) {
        expr_t* m_arg = self().duplicate_expr(x->m_arg);
        ttype_t* m_type = self().duplicate_ttype(x->m_type);
        expr_t* m_value = self().duplicate_expr(x->m_value);
        return make_Iachar_t(al, x->base.base.loc, m_arg, m_type, m_value);
    }


    ASR::asr_t* duplicate_SizeOfType(SizeOfType_t* x) {
        ttype_t* m_arg = self().duplicate_ttype(x->m_arg);
        ttype_t* m_type = self().duplicate_ttype(x->m_type);
        expr_t* m_value = self().duplicate_expr(x->m_value);
        return make_SizeOfType_t(al, x->base.base.loc, m_arg, m_type, m_value);
    }


    ASR::asr_t* duplicate_PointerNullConstant(PointerNullConstant_t* x) {
        ttype_t* m_type = self().duplicate_ttype(x->m_type);
        return make_PointerNullConstant_t(al, x->base.base.loc, m_type);
    }


    ASR::asr_t* duplicate_PointerAssociated(PointerAssociated_t* x) {
        expr_t* m_ptr = self().duplicate_expr(x->m_ptr);
        expr_t* m_tgt = self().duplicate_expr(x->m_tgt);
        ttype_t* m_type = self().duplicate_ttype(x->m_type);
        expr_t* m_value = self().duplicate_expr(x->m_value);
        return make_PointerAssociated_t(al, x->base.base.loc, m_ptr, m_tgt, m_type, m_value);
    }


    ASR::asr_t* duplicate_RealSqrt(RealSqrt_t* x) {
        expr_t* m_arg = self().duplicate_expr(x->m_arg);
        ttype_t* m_type = self().duplicate_ttype(x->m_type);
        expr_t* m_value = self().duplicate_expr(x->m_value);
        return make_RealSqrt_t(al, x->base.base.loc, m_arg, m_type, m_value);
    }


    ASR::asr_t* duplicate_ArrayIsContiguous(ArrayIsContiguous_t* x) {
        expr_t* m_array = self().duplicate_expr(x->m_array);
        ttype_t* m_type = self().duplicate_ttype(x->m_type);
        expr_t* m_value = self().duplicate_expr(x->m_value);
        return make_ArrayIsContiguous_t(al, x->base.base.loc, m_array, m_type, m_value);
    }


    ASR::asr_t* duplicate_Integer(Integer_t* x) {
        return make_Integer_t(al, x->base.base.loc, x->m_kind);
    }


    ASR::asr_t* duplicate_UnsignedInteger(UnsignedInteger_t* x) {
        return make_UnsignedInteger_t(al, x->base.base.loc, x->m_kind);
    }


    ASR::asr_t* duplicate_Real(Real_t* x) {
        return make_Real_t(al, x->base.base.loc, x->m_kind);
    }


    ASR::asr_t* duplicate_Complex(Complex_t* x) {
        return make_Complex_t(al, x->base.base.loc, x->m_kind);
    }


    ASR::asr_t* duplicate_String(String_t* x) {
        expr_t* m_len_expr = self().duplicate_expr(x->m_len_expr);
        return make_String_t(al, x->base.base.loc, x->m_kind, x->m_len, m_len_expr, x->m_physical_type);
    }


    ASR::asr_t* duplicate_Logical(Logical_t* x) {
        return make_Logical_t(al, x->base.base.loc, x->m_kind);
    }


    ASR::asr_t* duplicate_Set(Set_t* x) {
        ttype_t* m_type = self().duplicate_ttype(x->m_type);
        return make_Set_t(al, x->base.base.loc, m_type);
    }


    ASR::asr_t* duplicate_List(List_t* x) {
        ttype_t* m_type = self().duplicate_ttype(x->m_type);
        return make_List_t(al, x->base.base.loc, m_type);
    }


    ASR::asr_t* duplicate_Tuple(Tuple_t* x) {
        Vec<ttype_t*> m_type;
        m_type.reserve(al, x->n_type);
        for (size_t i = 0; i < x->n_type; i++) {
            m_type.push_back(al, self().duplicate_ttype(x->m_type[i]));
        }
        return make_Tuple_t(al, x->base.base.loc, m_type.p, x->n_type);
    }


    ASR::asr_t* duplicate_StructType(StructType_t* x) {
        symbol_t* m_derived_type = x->m_derived_type;
        return make_StructType_t(al, x->base.base.loc, m_derived_type);
    }


    ASR::asr_t* duplicate_EnumType(EnumType_t* x) {
        symbol_t* m_enum_type = x->m_enum_type;
        return make_EnumType_t(al, x->base.base.loc, m_enum_type);
    }


    ASR::asr_t* duplicate_UnionType(UnionType_t* x) {
        symbol_t* m_union_type = x->m_union_type;
        return make_UnionType_t(al, x->base.base.loc, m_union_type);
    }


    ASR::asr_t* duplicate_ClassType(ClassType_t* x) {
        symbol_t* m_class_type = x->m_class_type;
        return make_ClassType_t(al, x->base.base.loc, m_class_type);
    }


    ASR::asr_t* duplicate_Dict(Dict_t* x) {
        ttype_t* m_key_type = self().duplicate_ttype(x->m_key_type);
        ttype_t* m_value_type = self().duplicate_ttype(x->m_value_type);
        return make_Dict_t(al, x->base.base.loc, m_key_type, m_value_type);
    }


    ASR::asr_t* duplicate_Pointer(Pointer_t* x) {
        ttype_t* m_type = self().duplicate_ttype(x->m_type);
        return make_Pointer_t(al, x->base.base.loc, m_type);
    }


    ASR::asr_t* duplicate_Allocatable(Allocatable_t* x) {
        ttype_t* m_type = self().duplicate_ttype(x->m_type);
        return make_Allocatable_t(al, x->base.base.loc, m_type);
    }


    ASR::asr_t* duplicate_CPtr(CPtr_t* x) {
        return make_CPtr_t(al, x->base.base.loc);
    }


    ASR::asr_t* duplicate_SymbolicExpression(SymbolicExpression_t* x) {
        return make_SymbolicExpression_t(al, x->base.base.loc);
    }


    ASR::asr_t* duplicate_TypeParameter(TypeParameter_t* x) {
        return make_TypeParameter_t(al, x->base.base.loc, x->m_param);
    }


    ASR::asr_t* duplicate_Array(Array_t* x) {
        ttype_t* m_type = self().duplicate_ttype(x->m_type);
        Vec<dimension_t> m_dims;
        m_dims.reserve(al, x->n_dims);
        for (size_t i = 0; i < x->n_dims; i++) {
            ASR::dimension_t dim_copy;
            dim_copy.loc = x->m_dims[i].loc;
            dim_copy.m_start = self().duplicate_expr(x->m_dims[i].m_start);
            dim_copy.m_length = self().duplicate_expr(x->m_dims[i].m_length);
            m_dims.push_back(al, dim_copy);
        }
        return make_Array_t(al, x->base.base.loc, m_type, m_dims.p, x->n_dims, x->m_physical_type);
    }


    ASR::asr_t* duplicate_FunctionType(FunctionType_t* x) {
        Vec<ttype_t*> m_arg_types;
        m_arg_types.reserve(al, x->n_arg_types);
        for (size_t i = 0; i < x->n_arg_types; i++) {
            m_arg_types.push_back(al, self().duplicate_ttype(x->m_arg_types[i]));
        }
        ttype_t* m_return_var_type = self().duplicate_ttype(x->m_return_var_type);
        Vec<symbol_t*> m_restrictions;
        m_restrictions.reserve(al, x->n_restrictions);
        for (size_t i = 0; i < x->n_restrictions; i++) {
            m_restrictions.push_back(al, x->m_restrictions[i]);
        }
        return make_FunctionType_t(al, x->base.base.loc, m_arg_types.p, x->n_arg_types, m_return_var_type, x->m_abi, x->m_deftype, x->m_bindc_name, x->m_elemental, x->m_pure, x->m_module, x->m_inline, x->m_static, m_restrictions.p, x->n_restrictions, x->m_is_restriction);
    }


    ASR::asr_t* duplicate_CaseStmt(CaseStmt_t* x) {
        Vec<expr_t*> m_test;
        m_test.reserve(al, x->n_test);
        for (size_t i = 0; i < x->n_test; i++) {
            m_test.push_back(al, self().duplicate_expr(x->m_test[i]));
        }
        Vec<stmt_t*> m_body;
        m_body.reserve(al, x->n_body);
        for (size_t i = 0; i < x->n_body; i++) {
            m_body.push_back(al, self().duplicate_stmt(x->m_body[i]));
        }
        return make_CaseStmt_t(al, x->base.base.loc, m_test.p, x->n_test, m_body.p, x->n_body, x->m_fall_through);
    }


    ASR::asr_t* duplicate_CaseStmt_Range(CaseStmt_Range_t* x) {
        expr_t* m_start = self().duplicate_expr(x->m_start);
        expr_t* m_end = self().duplicate_expr(x->m_end);
        Vec<stmt_t*> m_body;
        m_body.reserve(al, x->n_body);
        for (size_t i = 0; i < x->n_body; i++) {
            m_body.push_back(al, self().duplicate_stmt(x->m_body[i]));
        }
        return make_CaseStmt_Range_t(al, x->base.base.loc, m_start, m_end, m_body.p, x->n_body);
    }

    ASR::stmt_t* duplicate_stmt(ASR::stmt_t* x) {
        if( !x ) {
            return nullptr;
        }

        switch(x->type) {
            case ASR::stmtType::Allocate: {
                return down_cast<ASR::stmt_t>(self().duplicate_Allocate(down_cast<ASR::Allocate_t>(x)));
            }
            case ASR::stmtType::ReAlloc: {
                return down_cast<ASR::stmt_t>(self().duplicate_ReAlloc(down_cast<ASR::ReAlloc_t>(x)));
            }
            case ASR::stmtType::Assign: {
                return down_cast<ASR::stmt_t>(self().duplicate_Assign(down_cast<ASR::Assign_t>(x)));
            }
            case ASR::stmtType::Assignment: {
                return down_cast<ASR::stmt_t>(self().duplicate_Assignment(down_cast<ASR::Assignment_t>(x)));
            }
            case ASR::stmtType::Associate: {
                return down_cast<ASR::stmt_t>(self().duplicate_Associate(down_cast<ASR::Associate_t>(x)));
            }
            case ASR::stmtType::Cycle: {
                return down_cast<ASR::stmt_t>(self().duplicate_Cycle(down_cast<ASR::Cycle_t>(x)));
            }
            case ASR::stmtType::ExplicitDeallocate: {
                return down_cast<ASR::stmt_t>(self().duplicate_ExplicitDeallocate(down_cast<ASR::ExplicitDeallocate_t>(x)));
            }
            case ASR::stmtType::ImplicitDeallocate: {
                return down_cast<ASR::stmt_t>(self().duplicate_ImplicitDeallocate(down_cast<ASR::ImplicitDeallocate_t>(x)));
            }
            case ASR::stmtType::DoConcurrentLoop: {
                return down_cast<ASR::stmt_t>(self().duplicate_DoConcurrentLoop(down_cast<ASR::DoConcurrentLoop_t>(x)));
            }
            case ASR::stmtType::DoLoop: {
                return down_cast<ASR::stmt_t>(self().duplicate_DoLoop(down_cast<ASR::DoLoop_t>(x)));
            }
            case ASR::stmtType::ErrorStop: {
                return down_cast<ASR::stmt_t>(self().duplicate_ErrorStop(down_cast<ASR::ErrorStop_t>(x)));
            }
            case ASR::stmtType::Exit: {
                return down_cast<ASR::stmt_t>(self().duplicate_Exit(down_cast<ASR::Exit_t>(x)));
            }
            case ASR::stmtType::ForAllSingle: {
                return down_cast<ASR::stmt_t>(self().duplicate_ForAllSingle(down_cast<ASR::ForAllSingle_t>(x)));
            }
            case ASR::stmtType::GoTo: {
                return down_cast<ASR::stmt_t>(self().duplicate_GoTo(down_cast<ASR::GoTo_t>(x)));
            }
            case ASR::stmtType::GoToTarget: {
                return down_cast<ASR::stmt_t>(self().duplicate_GoToTarget(down_cast<ASR::GoToTarget_t>(x)));
            }
            case ASR::stmtType::If: {
                return down_cast<ASR::stmt_t>(self().duplicate_If(down_cast<ASR::If_t>(x)));
            }
            case ASR::stmtType::IfArithmetic: {
                return down_cast<ASR::stmt_t>(self().duplicate_IfArithmetic(down_cast<ASR::IfArithmetic_t>(x)));
            }
            case ASR::stmtType::Print: {
                return down_cast<ASR::stmt_t>(self().duplicate_Print(down_cast<ASR::Print_t>(x)));
            }
            case ASR::stmtType::FileOpen: {
                return down_cast<ASR::stmt_t>(self().duplicate_FileOpen(down_cast<ASR::FileOpen_t>(x)));
            }
            case ASR::stmtType::FileClose: {
                return down_cast<ASR::stmt_t>(self().duplicate_FileClose(down_cast<ASR::FileClose_t>(x)));
            }
            case ASR::stmtType::FileRead: {
                return down_cast<ASR::stmt_t>(self().duplicate_FileRead(down_cast<ASR::FileRead_t>(x)));
            }
            case ASR::stmtType::FileBackspace: {
                return down_cast<ASR::stmt_t>(self().duplicate_FileBackspace(down_cast<ASR::FileBackspace_t>(x)));
            }
            case ASR::stmtType::FileRewind: {
                return down_cast<ASR::stmt_t>(self().duplicate_FileRewind(down_cast<ASR::FileRewind_t>(x)));
            }
            case ASR::stmtType::FileInquire: {
                return down_cast<ASR::stmt_t>(self().duplicate_FileInquire(down_cast<ASR::FileInquire_t>(x)));
            }
            case ASR::stmtType::FileWrite: {
                return down_cast<ASR::stmt_t>(self().duplicate_FileWrite(down_cast<ASR::FileWrite_t>(x)));
            }
            case ASR::stmtType::Return: {
                return down_cast<ASR::stmt_t>(self().duplicate_Return(down_cast<ASR::Return_t>(x)));
            }
            case ASR::stmtType::Select: {
                return down_cast<ASR::stmt_t>(self().duplicate_Select(down_cast<ASR::Select_t>(x)));
            }
            case ASR::stmtType::Stop: {
                return down_cast<ASR::stmt_t>(self().duplicate_Stop(down_cast<ASR::Stop_t>(x)));
            }
            case ASR::stmtType::Assert: {
                return down_cast<ASR::stmt_t>(self().duplicate_Assert(down_cast<ASR::Assert_t>(x)));
            }
            case ASR::stmtType::SubroutineCall: {
                if( !allow_procedure_calls ) {
                    success = false;
                    return nullptr;
                }
                return down_cast<ASR::stmt_t>(self().duplicate_SubroutineCall(down_cast<ASR::SubroutineCall_t>(x)));
            }
            case ASR::stmtType::IntrinsicImpureSubroutine: {
                return down_cast<ASR::stmt_t>(self().duplicate_IntrinsicImpureSubroutine(down_cast<ASR::IntrinsicImpureSubroutine_t>(x)));
            }
            case ASR::stmtType::Where: {
                return down_cast<ASR::stmt_t>(self().duplicate_Where(down_cast<ASR::Where_t>(x)));
            }
            case ASR::stmtType::WhileLoop: {
                return down_cast<ASR::stmt_t>(self().duplicate_WhileLoop(down_cast<ASR::WhileLoop_t>(x)));
            }
            case ASR::stmtType::Nullify: {
                return down_cast<ASR::stmt_t>(self().duplicate_Nullify(down_cast<ASR::Nullify_t>(x)));
            }
            case ASR::stmtType::Flush: {
                return down_cast<ASR::stmt_t>(self().duplicate_Flush(down_cast<ASR::Flush_t>(x)));
            }
            case ASR::stmtType::ListAppend: {
                return down_cast<ASR::stmt_t>(self().duplicate_ListAppend(down_cast<ASR::ListAppend_t>(x)));
            }
            case ASR::stmtType::AssociateBlockCall: {
                return down_cast<ASR::stmt_t>(self().duplicate_AssociateBlockCall(down_cast<ASR::AssociateBlockCall_t>(x)));
            }
            case ASR::stmtType::SelectType: {
                return down_cast<ASR::stmt_t>(self().duplicate_SelectType(down_cast<ASR::SelectType_t>(x)));
            }
            case ASR::stmtType::CPtrToPointer: {
                return down_cast<ASR::stmt_t>(self().duplicate_CPtrToPointer(down_cast<ASR::CPtrToPointer_t>(x)));
            }
            case ASR::stmtType::BlockCall: {
                return down_cast<ASR::stmt_t>(self().duplicate_BlockCall(down_cast<ASR::BlockCall_t>(x)));
            }
            case ASR::stmtType::SetInsert: {
                return down_cast<ASR::stmt_t>(self().duplicate_SetInsert(down_cast<ASR::SetInsert_t>(x)));
            }
            case ASR::stmtType::SetRemove: {
                return down_cast<ASR::stmt_t>(self().duplicate_SetRemove(down_cast<ASR::SetRemove_t>(x)));
            }
            case ASR::stmtType::ListInsert: {
                return down_cast<ASR::stmt_t>(self().duplicate_ListInsert(down_cast<ASR::ListInsert_t>(x)));
            }
            case ASR::stmtType::ListRemove: {
                return down_cast<ASR::stmt_t>(self().duplicate_ListRemove(down_cast<ASR::ListRemove_t>(x)));
            }
            case ASR::stmtType::ListClear: {
                return down_cast<ASR::stmt_t>(self().duplicate_ListClear(down_cast<ASR::ListClear_t>(x)));
            }
            case ASR::stmtType::DictInsert: {
                return down_cast<ASR::stmt_t>(self().duplicate_DictInsert(down_cast<ASR::DictInsert_t>(x)));
            }
            case ASR::stmtType::Expr: {
                return down_cast<ASR::stmt_t>(self().duplicate_Expr(down_cast<ASR::Expr_t>(x)));
            }
            default: {
                LCOMPILERS_ASSERT_MSG(false, "Duplication of " + std::to_string(x->type) + " statement is not supported yet.");
            }
        }

        return nullptr;
    }

    ASR::expr_t* duplicate_expr(ASR::expr_t* x) {
        if( !x ) {
            return nullptr;
        }

        switch(x->type) {
            case ASR::exprType::IfExp: {
                return down_cast<ASR::expr_t>(self().duplicate_IfExp(down_cast<ASR::IfExp_t>(x)));
            }
            case ASR::exprType::ComplexConstructor: {
                return down_cast<ASR::expr_t>(self().duplicate_ComplexConstructor(down_cast<ASR::ComplexConstructor_t>(x)));
            }
            case ASR::exprType::NamedExpr: {
                return down_cast<ASR::expr_t>(self().duplicate_NamedExpr(down_cast<ASR::NamedExpr_t>(x)));
            }
            case ASR::exprType::FunctionCall: {
                if( !allow_procedure_calls ) {
                    success = false;
                    return nullptr;
                }
                return down_cast<ASR::expr_t>(self().duplicate_FunctionCall(down_cast<ASR::FunctionCall_t>(x)));
            }
            case ASR::exprType::IntrinsicElementalFunction: {
                return down_cast<ASR::expr_t>(self().duplicate_IntrinsicElementalFunction(down_cast<ASR::IntrinsicElementalFunction_t>(x)));
            }
            case ASR::exprType::IntrinsicArrayFunction: {
                return down_cast<ASR::expr_t>(self().duplicate_IntrinsicArrayFunction(down_cast<ASR::IntrinsicArrayFunction_t>(x)));
            }
            case ASR::exprType::IntrinsicImpureFunction: {
                return down_cast<ASR::expr_t>(self().duplicate_IntrinsicImpureFunction(down_cast<ASR::IntrinsicImpureFunction_t>(x)));
            }
            case ASR::exprType::TypeInquiry: {
                return down_cast<ASR::expr_t>(self().duplicate_TypeInquiry(down_cast<ASR::TypeInquiry_t>(x)));
            }
            case ASR::exprType::StructConstructor: {
                return down_cast<ASR::expr_t>(self().duplicate_StructConstructor(down_cast<ASR::StructConstructor_t>(x)));
            }
            case ASR::exprType::StructConstant: {
                return down_cast<ASR::expr_t>(self().duplicate_StructConstant(down_cast<ASR::StructConstant_t>(x)));
            }
            case ASR::exprType::EnumConstructor: {
                return down_cast<ASR::expr_t>(self().duplicate_EnumConstructor(down_cast<ASR::EnumConstructor_t>(x)));
            }
            case ASR::exprType::UnionConstructor: {
                return down_cast<ASR::expr_t>(self().duplicate_UnionConstructor(down_cast<ASR::UnionConstructor_t>(x)));
            }
            case ASR::exprType::ImpliedDoLoop: {
                return down_cast<ASR::expr_t>(self().duplicate_ImpliedDoLoop(down_cast<ASR::ImpliedDoLoop_t>(x)));
            }
            case ASR::exprType::IntegerConstant: {
                return down_cast<ASR::expr_t>(self().duplicate_IntegerConstant(down_cast<ASR::IntegerConstant_t>(x)));
            }
            case ASR::exprType::IntegerBitNot: {
                return down_cast<ASR::expr_t>(self().duplicate_IntegerBitNot(down_cast<ASR::IntegerBitNot_t>(x)));
            }
            case ASR::exprType::IntegerUnaryMinus: {
                return down_cast<ASR::expr_t>(self().duplicate_IntegerUnaryMinus(down_cast<ASR::IntegerUnaryMinus_t>(x)));
            }
            case ASR::exprType::IntegerCompare: {
                return down_cast<ASR::expr_t>(self().duplicate_IntegerCompare(down_cast<ASR::IntegerCompare_t>(x)));
            }
            case ASR::exprType::IntegerBinOp: {
                return down_cast<ASR::expr_t>(self().duplicate_IntegerBinOp(down_cast<ASR::IntegerBinOp_t>(x)));
            }
            case ASR::exprType::UnsignedIntegerConstant: {
                return down_cast<ASR::expr_t>(self().duplicate_UnsignedIntegerConstant(down_cast<ASR::UnsignedIntegerConstant_t>(x)));
            }
            case ASR::exprType::UnsignedIntegerUnaryMinus: {
                return down_cast<ASR::expr_t>(self().duplicate_UnsignedIntegerUnaryMinus(down_cast<ASR::UnsignedIntegerUnaryMinus_t>(x)));
            }
            case ASR::exprType::UnsignedIntegerBitNot: {
                return down_cast<ASR::expr_t>(self().duplicate_UnsignedIntegerBitNot(down_cast<ASR::UnsignedIntegerBitNot_t>(x)));
            }
            case ASR::exprType::UnsignedIntegerCompare: {
                return down_cast<ASR::expr_t>(self().duplicate_UnsignedIntegerCompare(down_cast<ASR::UnsignedIntegerCompare_t>(x)));
            }
            case ASR::exprType::UnsignedIntegerBinOp: {
                return down_cast<ASR::expr_t>(self().duplicate_UnsignedIntegerBinOp(down_cast<ASR::UnsignedIntegerBinOp_t>(x)));
            }
            case ASR::exprType::RealConstant: {
                return down_cast<ASR::expr_t>(self().duplicate_RealConstant(down_cast<ASR::RealConstant_t>(x)));
            }
            case ASR::exprType::RealUnaryMinus: {
                return down_cast<ASR::expr_t>(self().duplicate_RealUnaryMinus(down_cast<ASR::RealUnaryMinus_t>(x)));
            }
            case ASR::exprType::RealCompare: {
                return down_cast<ASR::expr_t>(self().duplicate_RealCompare(down_cast<ASR::RealCompare_t>(x)));
            }
            case ASR::exprType::RealBinOp: {
                return down_cast<ASR::expr_t>(self().duplicate_RealBinOp(down_cast<ASR::RealBinOp_t>(x)));
            }
            case ASR::exprType::RealCopySign: {
                return down_cast<ASR::expr_t>(self().duplicate_RealCopySign(down_cast<ASR::RealCopySign_t>(x)));
            }
            case ASR::exprType::ComplexConstant: {
                return down_cast<ASR::expr_t>(self().duplicate_ComplexConstant(down_cast<ASR::ComplexConstant_t>(x)));
            }
            case ASR::exprType::ComplexUnaryMinus: {
                return down_cast<ASR::expr_t>(self().duplicate_ComplexUnaryMinus(down_cast<ASR::ComplexUnaryMinus_t>(x)));
            }
            case ASR::exprType::ComplexCompare: {
                return down_cast<ASR::expr_t>(self().duplicate_ComplexCompare(down_cast<ASR::ComplexCompare_t>(x)));
            }
            case ASR::exprType::ComplexBinOp: {
                return down_cast<ASR::expr_t>(self().duplicate_ComplexBinOp(down_cast<ASR::ComplexBinOp_t>(x)));
            }
            case ASR::exprType::LogicalConstant: {
                return down_cast<ASR::expr_t>(self().duplicate_LogicalConstant(down_cast<ASR::LogicalConstant_t>(x)));
            }
            case ASR::exprType::LogicalNot: {
                return down_cast<ASR::expr_t>(self().duplicate_LogicalNot(down_cast<ASR::LogicalNot_t>(x)));
            }
            case ASR::exprType::LogicalCompare: {
                return down_cast<ASR::expr_t>(self().duplicate_LogicalCompare(down_cast<ASR::LogicalCompare_t>(x)));
            }
            case ASR::exprType::LogicalBinOp: {
                return down_cast<ASR::expr_t>(self().duplicate_LogicalBinOp(down_cast<ASR::LogicalBinOp_t>(x)));
            }
            case ASR::exprType::ListConstant: {
                return down_cast<ASR::expr_t>(self().duplicate_ListConstant(down_cast<ASR::ListConstant_t>(x)));
            }
            case ASR::exprType::ListLen: {
                return down_cast<ASR::expr_t>(self().duplicate_ListLen(down_cast<ASR::ListLen_t>(x)));
            }
            case ASR::exprType::ListConcat: {
                return down_cast<ASR::expr_t>(self().duplicate_ListConcat(down_cast<ASR::ListConcat_t>(x)));
            }
            case ASR::exprType::ListCompare: {
                return down_cast<ASR::expr_t>(self().duplicate_ListCompare(down_cast<ASR::ListCompare_t>(x)));
            }
            case ASR::exprType::ListCount: {
                return down_cast<ASR::expr_t>(self().duplicate_ListCount(down_cast<ASR::ListCount_t>(x)));
            }
            case ASR::exprType::SetConstant: {
                return down_cast<ASR::expr_t>(self().duplicate_SetConstant(down_cast<ASR::SetConstant_t>(x)));
            }
            case ASR::exprType::SetLen: {
                return down_cast<ASR::expr_t>(self().duplicate_SetLen(down_cast<ASR::SetLen_t>(x)));
            }
            case ASR::exprType::TupleConstant: {
                return down_cast<ASR::expr_t>(self().duplicate_TupleConstant(down_cast<ASR::TupleConstant_t>(x)));
            }
            case ASR::exprType::TupleLen: {
                return down_cast<ASR::expr_t>(self().duplicate_TupleLen(down_cast<ASR::TupleLen_t>(x)));
            }
            case ASR::exprType::TupleCompare: {
                return down_cast<ASR::expr_t>(self().duplicate_TupleCompare(down_cast<ASR::TupleCompare_t>(x)));
            }
            case ASR::exprType::TupleConcat: {
                return down_cast<ASR::expr_t>(self().duplicate_TupleConcat(down_cast<ASR::TupleConcat_t>(x)));
            }
            case ASR::exprType::StringConstant: {
                return down_cast<ASR::expr_t>(self().duplicate_StringConstant(down_cast<ASR::StringConstant_t>(x)));
            }
            case ASR::exprType::StringConcat: {
                return down_cast<ASR::expr_t>(self().duplicate_StringConcat(down_cast<ASR::StringConcat_t>(x)));
            }
            case ASR::exprType::StringRepeat: {
                return down_cast<ASR::expr_t>(self().duplicate_StringRepeat(down_cast<ASR::StringRepeat_t>(x)));
            }
            case ASR::exprType::StringLen: {
                return down_cast<ASR::expr_t>(self().duplicate_StringLen(down_cast<ASR::StringLen_t>(x)));
            }
            case ASR::exprType::StringItem: {
                return down_cast<ASR::expr_t>(self().duplicate_StringItem(down_cast<ASR::StringItem_t>(x)));
            }
            case ASR::exprType::StringSection: {
                return down_cast<ASR::expr_t>(self().duplicate_StringSection(down_cast<ASR::StringSection_t>(x)));
            }
            case ASR::exprType::StringCompare: {
                return down_cast<ASR::expr_t>(self().duplicate_StringCompare(down_cast<ASR::StringCompare_t>(x)));
            }
            case ASR::exprType::StringContains: {
                return down_cast<ASR::expr_t>(self().duplicate_StringContains(down_cast<ASR::StringContains_t>(x)));
            }
            case ASR::exprType::StringOrd: {
                return down_cast<ASR::expr_t>(self().duplicate_StringOrd(down_cast<ASR::StringOrd_t>(x)));
            }
            case ASR::exprType::StringChr: {
                return down_cast<ASR::expr_t>(self().duplicate_StringChr(down_cast<ASR::StringChr_t>(x)));
            }
            case ASR::exprType::StringFormat: {
                return down_cast<ASR::expr_t>(self().duplicate_StringFormat(down_cast<ASR::StringFormat_t>(x)));
            }
            case ASR::exprType::StringPhysicalCast: {
                return down_cast<ASR::expr_t>(self().duplicate_StringPhysicalCast(down_cast<ASR::StringPhysicalCast_t>(x)));
            }
            case ASR::exprType::CPtrCompare: {
                return down_cast<ASR::expr_t>(self().duplicate_CPtrCompare(down_cast<ASR::CPtrCompare_t>(x)));
            }
            case ASR::exprType::SymbolicCompare: {
                return down_cast<ASR::expr_t>(self().duplicate_SymbolicCompare(down_cast<ASR::SymbolicCompare_t>(x)));
            }
            case ASR::exprType::DictConstant: {
                return down_cast<ASR::expr_t>(self().duplicate_DictConstant(down_cast<ASR::DictConstant_t>(x)));
            }
            case ASR::exprType::DictLen: {
                return down_cast<ASR::expr_t>(self().duplicate_DictLen(down_cast<ASR::DictLen_t>(x)));
            }
            case ASR::exprType::Var: {
                return down_cast<ASR::expr_t>(self().duplicate_Var(down_cast<ASR::Var_t>(x)));
            }
            case ASR::exprType::FunctionParam: {
                return down_cast<ASR::expr_t>(self().duplicate_FunctionParam(down_cast<ASR::FunctionParam_t>(x)));
            }
            case ASR::exprType::ArrayConstructor: {
                return down_cast<ASR::expr_t>(self().duplicate_ArrayConstructor(down_cast<ASR::ArrayConstructor_t>(x)));
            }
            case ASR::exprType::ArrayConstant: {
                return down_cast<ASR::expr_t>(self().duplicate_ArrayConstant(down_cast<ASR::ArrayConstant_t>(x)));
            }
            case ASR::exprType::ArrayItem: {
                return down_cast<ASR::expr_t>(self().duplicate_ArrayItem(down_cast<ASR::ArrayItem_t>(x)));
            }
            case ASR::exprType::ArraySection: {
                return down_cast<ASR::expr_t>(self().duplicate_ArraySection(down_cast<ASR::ArraySection_t>(x)));
            }
            case ASR::exprType::ArraySize: {
                return down_cast<ASR::expr_t>(self().duplicate_ArraySize(down_cast<ASR::ArraySize_t>(x)));
            }
            case ASR::exprType::ArrayBound: {
                return down_cast<ASR::expr_t>(self().duplicate_ArrayBound(down_cast<ASR::ArrayBound_t>(x)));
            }
            case ASR::exprType::ArrayTranspose: {
                return down_cast<ASR::expr_t>(self().duplicate_ArrayTranspose(down_cast<ASR::ArrayTranspose_t>(x)));
            }
            case ASR::exprType::ArrayPack: {
                return down_cast<ASR::expr_t>(self().duplicate_ArrayPack(down_cast<ASR::ArrayPack_t>(x)));
            }
            case ASR::exprType::ArrayReshape: {
                if( !allow_reshape ) {
                    success = false;
                    return nullptr;
                }
                return down_cast<ASR::expr_t>(self().duplicate_ArrayReshape(down_cast<ASR::ArrayReshape_t>(x)));
            }
            case ASR::exprType::ArrayBroadcast: {
                return down_cast<ASR::expr_t>(self().duplicate_ArrayBroadcast(down_cast<ASR::ArrayBroadcast_t>(x)));
            }
            case ASR::exprType::BitCast: {
                return down_cast<ASR::expr_t>(self().duplicate_BitCast(down_cast<ASR::BitCast_t>(x)));
            }
            case ASR::exprType::StructInstanceMember: {
                return down_cast<ASR::expr_t>(self().duplicate_StructInstanceMember(down_cast<ASR::StructInstanceMember_t>(x)));
            }
            case ASR::exprType::StructStaticMember: {
                return down_cast<ASR::expr_t>(self().duplicate_StructStaticMember(down_cast<ASR::StructStaticMember_t>(x)));
            }
            case ASR::exprType::EnumStaticMember: {
                return down_cast<ASR::expr_t>(self().duplicate_EnumStaticMember(down_cast<ASR::EnumStaticMember_t>(x)));
            }
            case ASR::exprType::UnionInstanceMember: {
                return down_cast<ASR::expr_t>(self().duplicate_UnionInstanceMember(down_cast<ASR::UnionInstanceMember_t>(x)));
            }
            case ASR::exprType::EnumName: {
                return down_cast<ASR::expr_t>(self().duplicate_EnumName(down_cast<ASR::EnumName_t>(x)));
            }
            case ASR::exprType::EnumValue: {
                return down_cast<ASR::expr_t>(self().duplicate_EnumValue(down_cast<ASR::EnumValue_t>(x)));
            }
            case ASR::exprType::OverloadedCompare: {
                return down_cast<ASR::expr_t>(self().duplicate_OverloadedCompare(down_cast<ASR::OverloadedCompare_t>(x)));
            }
            case ASR::exprType::OverloadedBinOp: {
                return down_cast<ASR::expr_t>(self().duplicate_OverloadedBinOp(down_cast<ASR::OverloadedBinOp_t>(x)));
            }
            case ASR::exprType::OverloadedUnaryMinus: {
                return down_cast<ASR::expr_t>(self().duplicate_OverloadedUnaryMinus(down_cast<ASR::OverloadedUnaryMinus_t>(x)));
            }
            case ASR::exprType::OverloadedStringConcat: {
                return down_cast<ASR::expr_t>(self().duplicate_OverloadedStringConcat(down_cast<ASR::OverloadedStringConcat_t>(x)));
            }
            case ASR::exprType::Cast: {
                return down_cast<ASR::expr_t>(self().duplicate_Cast(down_cast<ASR::Cast_t>(x)));
            }
            case ASR::exprType::ArrayPhysicalCast: {
                return down_cast<ASR::expr_t>(self().duplicate_ArrayPhysicalCast(down_cast<ASR::ArrayPhysicalCast_t>(x)));
            }
            case ASR::exprType::ComplexRe: {
                return down_cast<ASR::expr_t>(self().duplicate_ComplexRe(down_cast<ASR::ComplexRe_t>(x)));
            }
            case ASR::exprType::ComplexIm: {
                return down_cast<ASR::expr_t>(self().duplicate_ComplexIm(down_cast<ASR::ComplexIm_t>(x)));
            }
            case ASR::exprType::DictItem: {
                return down_cast<ASR::expr_t>(self().duplicate_DictItem(down_cast<ASR::DictItem_t>(x)));
            }
            case ASR::exprType::CLoc: {
                return down_cast<ASR::expr_t>(self().duplicate_CLoc(down_cast<ASR::CLoc_t>(x)));
            }
            case ASR::exprType::PointerToCPtr: {
                return down_cast<ASR::expr_t>(self().duplicate_PointerToCPtr(down_cast<ASR::PointerToCPtr_t>(x)));
            }
            case ASR::exprType::GetPointer: {
                return down_cast<ASR::expr_t>(self().duplicate_GetPointer(down_cast<ASR::GetPointer_t>(x)));
            }
            case ASR::exprType::ListItem: {
                return down_cast<ASR::expr_t>(self().duplicate_ListItem(down_cast<ASR::ListItem_t>(x)));
            }
            case ASR::exprType::TupleItem: {
                return down_cast<ASR::expr_t>(self().duplicate_TupleItem(down_cast<ASR::TupleItem_t>(x)));
            }
            case ASR::exprType::ListSection: {
                return down_cast<ASR::expr_t>(self().duplicate_ListSection(down_cast<ASR::ListSection_t>(x)));
            }
            case ASR::exprType::ListRepeat: {
                return down_cast<ASR::expr_t>(self().duplicate_ListRepeat(down_cast<ASR::ListRepeat_t>(x)));
            }
            case ASR::exprType::DictPop: {
                return down_cast<ASR::expr_t>(self().duplicate_DictPop(down_cast<ASR::DictPop_t>(x)));
            }
            case ASR::exprType::SetPop: {
                return down_cast<ASR::expr_t>(self().duplicate_SetPop(down_cast<ASR::SetPop_t>(x)));
            }
            case ASR::exprType::IntegerBitLen: {
                return down_cast<ASR::expr_t>(self().duplicate_IntegerBitLen(down_cast<ASR::IntegerBitLen_t>(x)));
            }
            case ASR::exprType::Ichar: {
                return down_cast<ASR::expr_t>(self().duplicate_Ichar(down_cast<ASR::Ichar_t>(x)));
            }
            case ASR::exprType::Iachar: {
                return down_cast<ASR::expr_t>(self().duplicate_Iachar(down_cast<ASR::Iachar_t>(x)));
            }
            case ASR::exprType::SizeOfType: {
                return down_cast<ASR::expr_t>(self().duplicate_SizeOfType(down_cast<ASR::SizeOfType_t>(x)));
            }
            case ASR::exprType::PointerNullConstant: {
                return down_cast<ASR::expr_t>(self().duplicate_PointerNullConstant(down_cast<ASR::PointerNullConstant_t>(x)));
            }
            case ASR::exprType::PointerAssociated: {
                return down_cast<ASR::expr_t>(self().duplicate_PointerAssociated(down_cast<ASR::PointerAssociated_t>(x)));
            }
            case ASR::exprType::RealSqrt: {
                return down_cast<ASR::expr_t>(self().duplicate_RealSqrt(down_cast<ASR::RealSqrt_t>(x)));
            }
            case ASR::exprType::ArrayIsContiguous: {
                return down_cast<ASR::expr_t>(self().duplicate_ArrayIsContiguous(down_cast<ASR::ArrayIsContiguous_t>(x)));
            }
            default: {
                LCOMPILERS_ASSERT_MSG(false, "Duplication of " + std::to_string(x->type) + " expression is not supported yet.");
            }
        }

        return nullptr;
    }

    ASR::ttype_t* duplicate_ttype(ASR::ttype_t* x) {
        if( !x ) {
            return nullptr;
        }

        switch(x->type) {
            case ASR::ttypeType::Integer: {
                return down_cast<ASR::ttype_t>(self().duplicate_Integer(down_cast<ASR::Integer_t>(x)));
            }
            case ASR::ttypeType::UnsignedInteger: {
                return down_cast<ASR::ttype_t>(self().duplicate_UnsignedInteger(down_cast<ASR::UnsignedInteger_t>(x)));
            }
            case ASR::ttypeType::Real: {
                return down_cast<ASR::ttype_t>(self().duplicate_Real(down_cast<ASR::Real_t>(x)));
            }
            case ASR::ttypeType::Complex: {
                return down_cast<ASR::ttype_t>(self().duplicate_Complex(down_cast<ASR::Complex_t>(x)));
            }
            case ASR::ttypeType::String: {
                return down_cast<ASR::ttype_t>(self().duplicate_String(down_cast<ASR::String_t>(x)));
            }
            case ASR::ttypeType::Logical: {
                return down_cast<ASR::ttype_t>(self().duplicate_Logical(down_cast<ASR::Logical_t>(x)));
            }
            case ASR::ttypeType::Set: {
                return down_cast<ASR::ttype_t>(self().duplicate_Set(down_cast<ASR::Set_t>(x)));
            }
            case ASR::ttypeType::List: {
                return down_cast<ASR::ttype_t>(self().duplicate_List(down_cast<ASR::List_t>(x)));
            }
            case ASR::ttypeType::Tuple: {
                return down_cast<ASR::ttype_t>(self().duplicate_Tuple(down_cast<ASR::Tuple_t>(x)));
            }
            case ASR::ttypeType::StructType: {
                return down_cast<ASR::ttype_t>(self().duplicate_StructType(down_cast<ASR::StructType_t>(x)));
            }
            case ASR::ttypeType::EnumType: {
                return down_cast<ASR::ttype_t>(self().duplicate_EnumType(down_cast<ASR::EnumType_t>(x)));
            }
            case ASR::ttypeType::UnionType: {
                return down_cast<ASR::ttype_t>(self().duplicate_UnionType(down_cast<ASR::UnionType_t>(x)));
            }
            case ASR::ttypeType::ClassType: {
                return down_cast<ASR::ttype_t>(self().duplicate_ClassType(down_cast<ASR::ClassType_t>(x)));
            }
            case ASR::ttypeType::Dict: {
                return down_cast<ASR::ttype_t>(self().duplicate_Dict(down_cast<ASR::Dict_t>(x)));
            }
            case ASR::ttypeType::Pointer: {
                return down_cast<ASR::ttype_t>(self().duplicate_Pointer(down_cast<ASR::Pointer_t>(x)));
            }
            case ASR::ttypeType::Allocatable: {
                return down_cast<ASR::ttype_t>(self().duplicate_Allocatable(down_cast<ASR::Allocatable_t>(x)));
            }
            case ASR::ttypeType::CPtr: {
                return down_cast<ASR::ttype_t>(self().duplicate_CPtr(down_cast<ASR::CPtr_t>(x)));
            }
            case ASR::ttypeType::SymbolicExpression: {
                return down_cast<ASR::ttype_t>(self().duplicate_SymbolicExpression(down_cast<ASR::SymbolicExpression_t>(x)));
            }
            case ASR::ttypeType::TypeParameter: {
                return down_cast<ASR::ttype_t>(self().duplicate_TypeParameter(down_cast<ASR::TypeParameter_t>(x)));
            }
            case ASR::ttypeType::Array: {
                return down_cast<ASR::ttype_t>(self().duplicate_Array(down_cast<ASR::Array_t>(x)));
            }
            case ASR::ttypeType::FunctionType: {
                return down_cast<ASR::ttype_t>(self().duplicate_FunctionType(down_cast<ASR::FunctionType_t>(x)));
            }
            default: {
                LCOMPILERS_ASSERT_MSG(false, "Duplication of " + std::to_string(x->type) + " type is not supported yet.");
            }
        }

        return nullptr;
    }

    ASR::case_stmt_t* duplicate_case_stmt(ASR::case_stmt_t* x) {
        if( !x ) {
            return nullptr;
        }

        switch(x->type) {
            case ASR::case_stmtType::CaseStmt: {
                return down_cast<ASR::case_stmt_t>(self().duplicate_CaseStmt(down_cast<ASR::CaseStmt_t>(x)));
            }
            case ASR::case_stmtType::CaseStmt_Range: {
                return down_cast<ASR::case_stmt_t>(self().duplicate_CaseStmt_Range(down_cast<ASR::CaseStmt_Range_t>(x)));
            }
            default: {
                LCOMPILERS_ASSERT_MSG(false, "Duplication of " + std::to_string(x->type) + " case statement is not supported yet.");
            }
        }

        return nullptr;
    }

};


}
