---
stage: Create
group: Code Review
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://about.gitlab.com/handbook/product/ux/technical-writing/#assignments
---

<!--
This documentation is auto generated by a script.
Please do not edit this file directly. Run `make gen-docs` instead.
-->

# `glab release delete`

Delete a GitLab Release

## Synopsis

Delete release assets to GitLab Release

Deleting a release does not delete the associated tag unless `--with-tag` is specified.
Maintainer level access to the project is required to delete a release.

```plaintext
glab release delete <tag> [flags]
```

## Examples

```plaintext
Delete a release (with a confirmation prompt')
$ glab release delete v1.1.0'

Skip the confirmation prompt and force delete
$ glab release delete v1.0.1 -y

Delete release and associated tag
$ glab release delete v1.0.1 --with-tag

```

## Options

```plaintext
  -t, --with-tag   Delete associated tag
  -y, --yes        Skip confirmation prompt
```

## Options inherited from parent commands

```plaintext
      --help              Show help for command
  -R, --repo OWNER/REPO   Select another repository using the OWNER/REPO or `GROUP/NAMESPACE/REPO` format or full URL or git URL
```
