//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armdomainservices

import "time"

// ClientBeginCreateOrUpdateOptions contains the optional parameters for the Client.BeginCreateOrUpdate method.
type ClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ClientBeginDeleteOptions contains the optional parameters for the Client.BeginDelete method.
type ClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ClientBeginUpdateOptions contains the optional parameters for the Client.BeginUpdate method.
type ClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ClientGetOptions contains the optional parameters for the Client.Get method.
type ClientGetOptions struct {
	// placeholder for future optional parameters
}

// ClientListByResourceGroupOptions contains the optional parameters for the Client.ListByResourceGroup method.
type ClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// ClientListOptions contains the optional parameters for the Client.List method.
type ClientListOptions struct {
	// placeholder for future optional parameters
}

// CloudError - An error response from the Domain Services.
type CloudError struct {
	// An error response from the Domain Services.
	Error *CloudErrorBody `json:"error,omitempty"`
}

// CloudErrorBody - An error response from the Domain Services.
type CloudErrorBody struct {
	// An identifier for the error. Codes are invariant and are intended to be consumed programmatically.
	Code *string `json:"code,omitempty"`

	// A list of additional details about the error.
	Details []*CloudErrorBody `json:"details,omitempty"`

	// A message describing the error, intended to be suitable for display in a user interface.
	Message *string `json:"message,omitempty"`

	// The target of the particular error. For example, the name of the property in error.
	Target *string `json:"target,omitempty"`
}

// ConfigDiagnostics - Configuration Diagnostics
type ConfigDiagnostics struct {
	// Last domain configuration diagnostics DateTime
	LastExecuted *time.Time `json:"lastExecuted,omitempty"`

	// List of Configuration Diagnostics validator results.
	ValidatorResults []*ConfigDiagnosticsValidatorResult `json:"validatorResults,omitempty"`
}

// ConfigDiagnosticsValidatorResult - Config Diagnostics validator result data
type ConfigDiagnosticsValidatorResult struct {
	// List of resource config validation issues.
	Issues []*ConfigDiagnosticsValidatorResultIssue `json:"issues,omitempty"`

	// Replica set location and subnet name
	ReplicaSetSubnetDisplayName *string `json:"replicaSetSubnetDisplayName,omitempty"`

	// Status for individual validator after running diagnostics.
	Status *Status `json:"status,omitempty"`

	// Validator identifier
	ValidatorID *string `json:"validatorId,omitempty"`
}

// ConfigDiagnosticsValidatorResultIssue - Specific issue for a particular config diagnostics validator
type ConfigDiagnosticsValidatorResultIssue struct {
	// List of domain resource property name or values used to compose a rich description.
	DescriptionParams []*string `json:"descriptionParams,omitempty"`

	// Validation issue identifier.
	ID *string `json:"id,omitempty"`
}

// ContainerAccount - Container Account Description
type ContainerAccount struct {
	// The account name
	AccountName *string `json:"accountName,omitempty"`

	// The account password
	Password *string `json:"password,omitempty"`

	// The account spn
	Spn *string `json:"spn,omitempty"`
}

// DomainSecuritySettings - Domain Security Settings
type DomainSecuritySettings struct {
	// A flag to determine whether or not KerberosArmoring is enabled or disabled.
	KerberosArmoring *KerberosArmoring `json:"kerberosArmoring,omitempty"`

	// A flag to determine whether or not KerberosRc4Encryption is enabled or disabled.
	KerberosRc4Encryption *KerberosRc4Encryption `json:"kerberosRc4Encryption,omitempty"`

	// A flag to determine whether or not NtlmV1 is enabled or disabled.
	NtlmV1 *NtlmV1 `json:"ntlmV1,omitempty"`

	// A flag to determine whether or not SyncKerberosPasswords is enabled or disabled.
	SyncKerberosPasswords *SyncKerberosPasswords `json:"syncKerberosPasswords,omitempty"`

	// A flag to determine whether or not SyncNtlmPasswords is enabled or disabled.
	SyncNtlmPasswords *SyncNtlmPasswords `json:"syncNtlmPasswords,omitempty"`

	// A flag to determine whether or not SyncOnPremPasswords is enabled or disabled.
	SyncOnPremPasswords *SyncOnPremPasswords `json:"syncOnPremPasswords,omitempty"`

	// A flag to determine whether or not TlsV1 is enabled or disabled.
	TLSV1 *TLSV1 `json:"tlsV1,omitempty"`
}

// DomainService - Domain service.
type DomainService struct {
	// Resource etag
	Etag *string `json:"etag,omitempty"`

	// Resource location
	Location *string `json:"location,omitempty"`

	// Domain service properties
	Properties *DomainServiceProperties `json:"properties,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system meta data relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DomainServiceListResult - The response from the List Domain Services operation.
type DomainServiceListResult struct {
	// the list of domain services.
	Value []*DomainService `json:"value,omitempty"`

	// READ-ONLY; The continuation token for the next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// DomainServiceOperationsClientListOptions contains the optional parameters for the DomainServiceOperationsClient.List method.
type DomainServiceOperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// DomainServiceProperties - Properties of the Domain Service.
type DomainServiceProperties struct {
	// Configuration diagnostics data containing latest execution from client.
	ConfigDiagnostics *ConfigDiagnostics `json:"configDiagnostics,omitempty"`

	// Domain Configuration Type
	DomainConfigurationType *string `json:"domainConfigurationType,omitempty"`

	// The name of the Azure domain that the user would like to deploy Domain Services to.
	DomainName *string `json:"domainName,omitempty"`

	// DomainSecurity Settings
	DomainSecuritySettings *DomainSecuritySettings `json:"domainSecuritySettings,omitempty"`

	// Enabled or Disabled flag to turn on Group-based filtered sync
	FilteredSync *FilteredSync `json:"filteredSync,omitempty"`

	// Secure LDAP Settings
	LdapsSettings *LdapsSettings `json:"ldapsSettings,omitempty"`

	// Notification Settings
	NotificationSettings *NotificationSettings `json:"notificationSettings,omitempty"`

	// List of ReplicaSets
	ReplicaSets []*ReplicaSet `json:"replicaSets,omitempty"`

	// Resource Forest Settings
	ResourceForestSettings *ResourceForestSettings `json:"resourceForestSettings,omitempty"`

	// Sku Type
	SKU *string `json:"sku,omitempty"`

	// READ-ONLY; Deployment Id
	DeploymentID *string `json:"deploymentId,omitempty" azure:"ro"`

	// READ-ONLY; Migration Properties
	MigrationProperties *MigrationProperties `json:"migrationProperties,omitempty" azure:"ro"`

	// READ-ONLY; the current deployment or provisioning state, which only appears in the response.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; SyncOwner ReplicaSet Id
	SyncOwner *string `json:"syncOwner,omitempty" azure:"ro"`

	// READ-ONLY; Azure Active Directory Tenant Id
	TenantID *string `json:"tenantId,omitempty" azure:"ro"`

	// READ-ONLY; Data Model Version
	Version *int32 `json:"version,omitempty" azure:"ro"`
}

// ForestTrust - Forest Trust Setting
type ForestTrust struct {
	// Friendly Name
	FriendlyName *string `json:"friendlyName,omitempty"`

	// Remote Dns ips
	RemoteDNSIPs *string `json:"remoteDnsIps,omitempty"`

	// Trust Direction
	TrustDirection *string `json:"trustDirection,omitempty"`

	// Trust Password
	TrustPassword *string `json:"trustPassword,omitempty"`

	// Trusted Domain FQDN
	TrustedDomainFqdn *string `json:"trustedDomainFqdn,omitempty"`
}

// HealthAlert - Health Alert Description
type HealthAlert struct {
	// READ-ONLY; Health Alert Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Health Alert Issue
	Issue *string `json:"issue,omitempty" azure:"ro"`

	// READ-ONLY; Health Alert Last Detected DateTime
	LastDetected *time.Time `json:"lastDetected,omitempty" azure:"ro"`

	// READ-ONLY; Health Alert Name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Health Alert Raised DateTime
	Raised *time.Time `json:"raised,omitempty" azure:"ro"`

	// READ-ONLY; Health Alert TSG Link
	ResolutionURI *string `json:"resolutionUri,omitempty" azure:"ro"`

	// READ-ONLY; Health Alert Severity
	Severity *string `json:"severity,omitempty" azure:"ro"`
}

// HealthMonitor - Health Monitor Description
type HealthMonitor struct {
	// READ-ONLY; Health Monitor Details
	Details *string `json:"details,omitempty" azure:"ro"`

	// READ-ONLY; Health Monitor Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Health Monitor Name
	Name *string `json:"name,omitempty" azure:"ro"`
}

// LdapsSettings - Secure LDAP Settings
type LdapsSettings struct {
	// A flag to determine whether or not Secure LDAP access over the internet is enabled or disabled.
	ExternalAccess *ExternalAccess `json:"externalAccess,omitempty"`

	// A flag to determine whether or not Secure LDAP is enabled or disabled.
	Ldaps *Ldaps `json:"ldaps,omitempty"`

	// The certificate required to configure Secure LDAP. The parameter passed here should be a base64encoded representation of
	// the certificate pfx file.
	PfxCertificate *string `json:"pfxCertificate,omitempty"`

	// The password to decrypt the provided Secure LDAP certificate pfx file.
	PfxCertificatePassword *string `json:"pfxCertificatePassword,omitempty"`

	// READ-ONLY; NotAfter DateTime of configure ldaps certificate.
	CertificateNotAfter *time.Time `json:"certificateNotAfter,omitempty" azure:"ro"`

	// READ-ONLY; Thumbprint of configure ldaps certificate.
	CertificateThumbprint *string `json:"certificateThumbprint,omitempty" azure:"ro"`

	// READ-ONLY; Public certificate used to configure secure ldap.
	PublicCertificate *string `json:"publicCertificate,omitempty" azure:"ro"`
}

// MigrationProgress - Migration Progress
type MigrationProgress struct {
	// Completion Percentage
	CompletionPercentage *float64 `json:"completionPercentage,omitempty"`

	// Progress Message
	ProgressMessage *string `json:"progressMessage,omitempty"`
}

// MigrationProperties - Migration Properties
type MigrationProperties struct {
	// READ-ONLY; Migration Progress
	MigrationProgress *MigrationProgress `json:"migrationProgress,omitempty" azure:"ro"`

	// READ-ONLY; Old Subnet Id
	OldSubnetID *string `json:"oldSubnetId,omitempty" azure:"ro"`

	// READ-ONLY; Old Vnet Site Id
	OldVnetSiteID *string `json:"oldVnetSiteId,omitempty" azure:"ro"`
}

// NotificationSettings - Settings for notification
type NotificationSettings struct {
	// The list of additional recipients
	AdditionalRecipients []*string `json:"additionalRecipients,omitempty"`

	// Should domain controller admins be notified
	NotifyDcAdmins *NotifyDcAdmins `json:"notifyDcAdmins,omitempty"`

	// Should global admins be notified
	NotifyGlobalAdmins *NotifyGlobalAdmins `json:"notifyGlobalAdmins,omitempty"`
}

// OperationDisplayInfo - The operation supported by Domain Services.
type OperationDisplayInfo struct {
	// The description of the operation.
	Description *string `json:"description,omitempty"`

	// The action that users can perform, based on their permission level.
	Operation *string `json:"operation,omitempty"`

	// Service provider: Domain Services.
	Provider *string `json:"provider,omitempty"`

	// Resource on which the operation is performed.
	Resource *string `json:"resource,omitempty"`
}

// OperationEntity - The operation supported by Domain Services.
type OperationEntity struct {
	// The operation supported by Domain Services.
	Display *OperationDisplayInfo `json:"display,omitempty"`

	// Operation name: {provider}/{resource}/{operation}.
	Name *string `json:"name,omitempty"`

	// The origin of the operation.
	Origin *string `json:"origin,omitempty"`
}

// OperationEntityListResult - The list of domain service operation response.
type OperationEntityListResult struct {
	// The list of operations.
	Value []*OperationEntity `json:"value,omitempty"`

	// READ-ONLY; The continuation token for the next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// OuContainer - Resource for OuContainer.
type OuContainer struct {
	// Resource etag
	Etag *string `json:"etag,omitempty"`

	// Resource location
	Location *string `json:"location,omitempty"`

	// OuContainer properties
	Properties *OuContainerProperties `json:"properties,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system meta data relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// OuContainerClientBeginCreateOptions contains the optional parameters for the OuContainerClient.BeginCreate method.
type OuContainerClientBeginCreateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// OuContainerClientBeginDeleteOptions contains the optional parameters for the OuContainerClient.BeginDelete method.
type OuContainerClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// OuContainerClientBeginUpdateOptions contains the optional parameters for the OuContainerClient.BeginUpdate method.
type OuContainerClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// OuContainerClientGetOptions contains the optional parameters for the OuContainerClient.Get method.
type OuContainerClientGetOptions struct {
	// placeholder for future optional parameters
}

// OuContainerClientListOptions contains the optional parameters for the OuContainerClient.List method.
type OuContainerClientListOptions struct {
	// placeholder for future optional parameters
}

// OuContainerListResult - The response from the List OuContainer operation.
type OuContainerListResult struct {
	// The list of OuContainer.
	Value []*OuContainer `json:"value,omitempty"`

	// READ-ONLY; The continuation token for the next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// OuContainerOperationsClientListOptions contains the optional parameters for the OuContainerOperationsClient.List method.
type OuContainerOperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// OuContainerProperties - Properties of the OuContainer.
type OuContainerProperties struct {
	// The list of container accounts
	Accounts []*ContainerAccount `json:"accounts,omitempty"`

	// READ-ONLY; The OuContainer name
	ContainerID *string `json:"containerId,omitempty" azure:"ro"`

	// READ-ONLY; The Deployment id
	DeploymentID *string `json:"deploymentId,omitempty" azure:"ro"`

	// READ-ONLY; Distinguished Name of OuContainer instance
	DistinguishedName *string `json:"distinguishedName,omitempty" azure:"ro"`

	// READ-ONLY; The domain name of Domain Services.
	DomainName *string `json:"domainName,omitempty" azure:"ro"`

	// READ-ONLY; The current deployment or provisioning state, which only appears in the response.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; Status of OuContainer instance
	ServiceStatus *string `json:"serviceStatus,omitempty" azure:"ro"`

	// READ-ONLY; Azure Active Directory tenant id
	TenantID *string `json:"tenantId,omitempty" azure:"ro"`
}

// ReplicaSet - Replica Set Definition
type ReplicaSet struct {
	// Virtual network location
	Location *string `json:"location,omitempty"`

	// The name of the virtual network that Domain Services will be deployed on. The id of the subnet that Domain Services will
	// be deployed on. /virtualNetwork/vnetName/subnets/subnetName.
	SubnetID *string `json:"subnetId,omitempty"`

	// READ-ONLY; List of Domain Controller IP Address
	DomainControllerIPAddress []*string `json:"domainControllerIpAddress,omitempty" azure:"ro"`

	// READ-ONLY; External access ip address.
	ExternalAccessIPAddress *string `json:"externalAccessIpAddress,omitempty" azure:"ro"`

	// READ-ONLY; List of Domain Health Alerts
	HealthAlerts []*HealthAlert `json:"healthAlerts,omitempty" azure:"ro"`

	// READ-ONLY; Last domain evaluation run DateTime
	HealthLastEvaluated *time.Time `json:"healthLastEvaluated,omitempty" azure:"ro"`

	// READ-ONLY; List of Domain Health Monitors
	HealthMonitors []*HealthMonitor `json:"healthMonitors,omitempty" azure:"ro"`

	// READ-ONLY; ReplicaSet Id
	ReplicaSetID *string `json:"replicaSetId,omitempty" azure:"ro"`

	// READ-ONLY; Status of Domain Service instance
	ServiceStatus *string `json:"serviceStatus,omitempty" azure:"ro"`

	// READ-ONLY; Virtual network site id
	VnetSiteID *string `json:"vnetSiteId,omitempty" azure:"ro"`
}

// Resource - The Resource model definition.
type Resource struct {
	// Resource etag
	Etag *string `json:"etag,omitempty"`

	// Resource location
	Location *string `json:"location,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system meta data relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ResourceForestSettings - Settings for Resource Forest
type ResourceForestSettings struct {
	// Resource Forest
	ResourceForest *string `json:"resourceForest,omitempty"`

	// List of settings for Resource Forest
	Settings []*ForestTrust `json:"settings,omitempty"`
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time `json:"createdAt,omitempty"`

	// The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`

	// The type of identity that created the resource.
	CreatedByType *CreatedByType `json:"createdByType,omitempty"`

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time `json:"lastModifiedAt,omitempty"`

	// The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType `json:"lastModifiedByType,omitempty"`
}
