# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at http://mozilla.org/MPL/2.0/.


## Generative AI (GenAI) Settings section

genai-settings-chat-description = ᱵᱽᱨᱟᱣᱩᱡᱽ ᱥᱟᱶ ᱥᱟᱶᱛᱮ ᱩᱥᱟᱹᱨᱟ ᱮᱠᱥᱮᱥ ᱞᱟᱹᱜᱤᱫ, ᱥᱟᱭᱤᱰᱵᱟᱨ ᱨᱮ ᱟᱢᱟᱜ ᱠᱩᱥᱤ ᱞᱮᱠᱟᱱ ᱪᱟᱴᱵᱚᱴ ᱥᱮᱞᱮᱫ ᱢᱮ ᱾ <a data-l10n-name="connect">ᱢᱚᱱᱚᱛ ᱦᱟᱹᱴᱤᱧ ᱢᱮ</a>
genai-settings-chat-choose = ᱢᱤᱫᱴᱟᱝ ᱪᱟᱴᱵᱚᱴ ᱵᱟᱪᱷᱟᱣ ᱢᱮ
genai-settings-chat-choose-one-menuitem =
    .label = ᱢᱤᱫᱴᱟᱹᱝ ᱵᱟᱪᱷᱟᱣ ᱢᱮ
genai-settings-chat-links = ᱛᱤᱱᱨᱮ ᱟᱢ ᱪᱟᱴᱵᱚᱴ ᱮᱢ ᱵᱟᱪᱷᱟᱣᱟ, ᱟᱢ ᱫᱚ ᱮᱢᱚᱜᱤᱡ ᱟᱜ ᱵᱮᱵᱷᱟᱨ ᱨᱮᱭᱟᱜ ᱥᱟᱨᱛ ᱟᱨ ᱯᱨᱟᱭᱣᱮᱥᱤ ᱯᱚᱞᱤᱥᱤ ᱨᱮᱢ ᱦᱮᱸᱥᱮᱨᱤᱭᱟᱹᱜᱼᱟ ᱾
genai-settings-chat-chatgpt-links = ChatGPT ᱵᱟᱪᱷᱟᱣ ᱠᱟᱛᱮ, ᱟᱢ ᱚᱯᱮᱱ ᱮᱭᱟᱭ <a data-l10n-name="link1">ᱵᱮᱵᱷᱟᱨ ᱨᱮᱭᱟᱜ ᱥᱚᱨᱛᱚ</a> ᱟᱨ <a data-l10n-name="link2">ᱯᱨᱟᱭᱣᱮᱥᱤ ᱯᱚᱞᱤᱥᱤ</a> ᱥᱟᱶ ᱨᱮᱵᱮᱱ ᱢᱮᱱᱟᱢᱟ ᱾
genai-settings-chat-claude-links = Anthropic Claude ᱵᱟᱪᱷᱟᱣ ᱠᱟᱛᱮ, ᱟᱢ ᱮᱱᱛᱨᱚᱯᱤᱠ <a data-l10n-name="link1">ᱥᱮᱵᱟ ᱨᱮᱭᱟᱜ ᱠᱷᱟᱴᱚᱠ ᱥᱟᱨᱛ</a>, <a data-l10n-name="link2">ᱵᱮᱵᱷᱟᱨ ᱯᱚᱞᱤᱥᱤ</a> ᱨᱮᱢ ᱦᱮᱸᱥᱚᱜ ᱠᱟᱱᱟ, ᱟᱨ <a data-l10n-name="link3">ᱯᱨᱟᱭᱣᱮᱥᱤ ᱯᱚᱞᱤᱥᱤ</a>᱾
genai-settings-chat-copilot-links = Copilot ᱵᱟᱪᱷᱟᱣ ᱠᱟᱛᱮ, ᱟᱢ <a data-l10n-name="link1">Copilot AI ᱟᱹᱱᱟᱹᱭᱠᱟᱹᱣ ᱥᱟᱨᱛᱚ</a> ᱟᱨ <a data-l10n-name="link2">Microsoft  ᱯᱨᱟᱭᱣᱮᱥᱤ ᱵᱤᱵᱚᱨᱚᱱ</a> ᱨᱮᱢ ᱦᱮᱸᱥᱮᱨᱤᱭᱟᱹᱜ ᱠᱟᱱᱟ ᱾
genai-settings-chat-gemini-links = Google Gemini ᱵᱟᱪᱷᱟᱣ ᱠᱟᱛᱮ, ᱟᱢ <a data-l10n-name="link1">Google ᱥᱮᱵᱟ ᱨᱮᱭᱟᱜ ᱥᱟᱨᱛ</a>, <a data-l10n-name="link2">Generative AI ᱵᱟᱨᱚᱱ ᱵᱮᱵᱷᱟᱨ ᱯᱚᱞᱤᱥᱤ</a>, ᱟᱨ <a data-l10n-name="link3">Gemini ᱮᱯᱥ ᱯᱨᱟᱭᱣᱮᱥᱤ ᱱᱚᱴᱤᱥ</a>᱾
genai-settings-chat-huggingchat-links = HuggingChat ᱵᱟᱪᱷᱟᱣ ᱠᱟᱛᱮ, ᱟᱢ <a data-l10n-name="link1">HuggingChat ᱯᱨᱟᱭᱣᱮᱥᱤ ᱱᱚᱴᱤᱥ</a> ᱟᱨ <a data-l10n-name="link2">HuggingChat Face ᱯᱨᱟᱭᱣᱮᱥᱤ ᱯᱚᱞᱤᱥᱤ</a> ᱨᱮᱢ ᱦᱮᱸᱥᱮᱨᱤᱭᱟᱹᱜ ᱠᱟᱱᱟ ᱾
genai-settings-chat-lechat-links = Le Chat Mistral ᱵᱟᱪᱷᱟᱣ ᱠᱟᱛᱮ, ᱟᱢ ᱚᱯᱮᱱ ᱮᱭᱟᱭ <a data-l10n-name="link1">ᱵᱮᱵᱷᱟᱨ ᱨᱮᱭᱟᱜ ᱥᱚᱨᱛᱚ</a> ᱟᱨ <a data-l10n-name="link2">ᱯᱨᱟᱭᱣᱮᱥᱤ ᱯᱚᱞᱤᱥᱤ</a> ᱥᱟᱶ ᱨᱮᱵᱮᱱᱟ ᱾
genai-settings-chat-localhost-links = { -vendor-short-name } ᱨᱮᱭᱟᱜ ᱱᱟᱶᱟᱛᱮᱫ ᱫᱚᱞ ᱠᱷᱚᱱ ᱟᱢᱟᱜ ᱱᱤᱡᱮᱨᱟᱜ ᱞᱚᱠᱟᱞ ᱪᱟᱴᱵᱚᱴ ᱟᱹᱜᱩᱭ ᱢᱮ ᱡᱮᱞᱠᱟ <a data-l10n-name="link1">llamafile</a> ᱠᱷᱚᱱ ᱾
genai-settings-chat-shortcuts =
    .description = ᱟᱢ ᱚᱞ ᱵᱟᱪᱷᱟᱣ ᱠᱟᱛᱮ ᱴᱟᱴᱠᱟ ᱵᱟᱠᱚᱥ ᱞᱟᱹᱜᱤᱫ ᱥᱚᱴᱠᱟᱴ ᱩᱫᱩᱜᱚᱜᱼᱟ ᱾ { -brand-short-name } ᱚᱞ, ᱥᱟᱦᱴᱟ ᱢᱩᱴᱷᱟᱹᱱ, ᱟᱨ ᱪᱟᱴᱵᱚᱴ ᱴᱷᱮᱱ ᱴᱟᱴᱠᱟ ᱵᱟᱠᱚᱥ ᱵᱷᱮᱡᱟᱭᱟᱭ ᱾
    .label = ᱚᱞ ᱵᱟᱪᱷᱟᱣ ᱨᱮ ᱴᱟᱴᱠᱟ ᱵᱟᱠᱚᱥ ᱩᱫᱩᱜ ᱢᱮ

## Chatbot prompts
## Prompts are plain language ‘instructions’ sent to a chatbot.
## These prompts have been made concise and direct in English because some chatbot providers
## have character restrictions and being direct reduces the chance for misinterpretation.
## When localizing, please be concise and direct, but not at the expense of losing meaning.

# Prompt purpose: help users understand what a selection covers at a glance
genai-prompts-summarize =
    .label = ᱠᱷᱟᱴᱚᱢᱟᱪᱷᱟ
    .value = ᱫᱟᱭᱟ ᱠᱟᱛᱮ ᱵᱟᱪᱷᱟᱣ ᱨᱮᱭᱟᱜ ᱥᱚᱴᱷᱤᱠ ᱯᱟᱹᱨᱥᱤ ᱛᱮ ᱠᱷᱟᱴᱚᱧ ᱢᱮ ᱾ ᱠᱷᱟᱴᱚᱢᱟᱪᱷᱟ ᱨᱮ ᱦᱮᱰᱚᱨ ᱟᱨ ᱵᱩᱞᱮᱴᱰ ᱥᱩᱪᱤ ᱵᱮᱵᱷᱟᱨ ᱢᱮ, ᱱᱚᱣᱟ ᱵᱮᱥ ᱥᱚᱫᱚᱨ ᱪᱷᱚ ᱞᱟᱹᱜᱤᱫ ᱾ ᱢᱮᱱᱮᱛ ᱟᱨ ᱛᱟᱛᱷᱭᱚ ᱴᱷᱤᱠ ᱛᱟᱦᱮᱱ ᱫᱚᱦᱚ ᱠᱟᱜ ᱢᱮ ᱾
# Prompt purpose: make a selection easier to read
genai-prompts-simplify =
    .label = ᱯᱟᱹᱨᱥᱤ ᱟᱞᱜᱟ ᱢᱮ
    .value = ᱫᱟᱭᱟ ᱠᱟᱛᱮ ᱠᱷᱟᱴᱚ ᱟᱹᱭᱟᱹᱛ ᱠᱚ ᱟᱨ ᱟᱞᱜᱟ ᱟᱹᱲᱟᱹ ᱠᱚ ᱵᱮᱵᱷᱟᱨ ᱠᱟᱛᱮ ᱵᱟᱪᱷᱟᱣ ᱫᱚᱦᱲᱟ ᱚᱞ ᱢᱮ ᱾ ᱢᱮᱱᱮᱛ ᱟᱨ ᱛᱟᱛᱷᱚ ᱴᱷᱤᱠ ᱛᱟᱦᱮᱱ ᱫᱚᱦᱚ ᱠᱟᱜ ᱢᱮ ᱾
# Prompt purpose: test understanding of selection in an interactive way
genai-prompts-quiz =
    .label = ᱠᱩᱠᱞᱤ ᱠᱷᱮᱞ
    .value = ᱫᱟᱭᱟ ᱠᱟᱛᱮ ᱱᱚᱣᱟ ᱵᱟᱪᱷᱟᱣ ᱪᱮᱛᱟᱱ ᱨᱮ ᱠᱩᱠᱞᱤ ᱤᱧ ᱢᱮ ᱾ ᱤᱧ ᱟᱭᱢᱟ ᱞᱮᱠᱟᱱ ᱠᱩᱠᱞᱤ ᱠᱚ ᱠᱩᱞᱤᱭᱤᱧ ᱢᱮ, ᱫᱟᱹᱭᱠᱟᱹ ᱞᱮᱠᱟᱛᱮ ᱵᱟᱹᱲᱛᱤ ᱵᱟᱪᱷᱟᱣ, ᱥᱟᱹᱨᱤ ᱥᱮ ᱵᱟᱹᱲᱤᱡ, ᱟᱨ ᱠᱷᱟᱴᱚ ᱛᱮᱞᱟ ᱾ ᱫᱚᱥᱟᱨ ᱠᱩᱠᱞᱤ ᱨᱮ ᱥᱮᱱᱚᱜ ᱞᱟᱦᱟᱨᱮ ᱤᱧᱟᱜ ᱛᱮᱞᱟ ᱛᱟᱺᱜᱤ ᱢᱮ ᱾
# Prompt purpose: helps users understand words, phrases, concepts
genai-prompts-explain =
    .label = ᱱᱚᱣᱟ ᱞᱟᱹᱭ ᱢᱮ
    .value = ᱫᱟᱭᱟ ᱠᱟᱛᱮ ᱱᱚᱣᱟ ᱵᱟᱪᱷᱟᱣ ᱨᱮᱱᱟᱜ ᱢᱩᱲᱩᱫ ᱫᱷᱟᱨᱱᱟ ᱠᱚ ᱟᱞᱜᱟ ᱟᱹᱲᱟᱹ ᱠᱚ ᱵᱮᱵᱷᱟᱨ ᱠᱟᱛᱮ ᱞᱟᱹᱭ ᱢᱮ ᱾  ᱟᱨᱦᱚᱸ, ᱫᱟᱹᱭᱠᱟᱹ ᱠᱚ ᱵᱮᱵᱷᱟᱨ ᱢᱮ ᱾
# This prompt is added to the beginning of selection prompts sent to a chatbot.
# $tabTitle (string) - title of the webpage
# $selection (string) - selected text
genai-prompt-prefix-selection = ᱤᱧ ᱥᱟᱦᱴᱟ ᱨᱮ ᱢᱤᱱᱟᱹᱧᱟ “{ $tabTitle }” ᱥᱟᱶ “{ $selection }” ᱵᱟᱪᱷᱟᱣ ᱟᱠᱟᱱᱟ ᱾

## Chatbot menu shortcuts

genai-menu-ask-generic =
    .label = AI ᱪᱟᱴᱵᱚᱴ ᱠᱩᱞᱤ ᱮᱢ
# $provider (string) - name of the provider
genai-menu-ask-provider =
    .label = { $provider } ᱠᱩᱞᱤ ᱮᱢ
genai-input-ask-generic =
    .placeholder = AI ᱪᱟᱴᱵᱚᱴ ᱠᱩᱞᱤ ᱮᱢ …
# $provider (string) - name of the provider
genai-input-ask-provider =
    .placeholder = { $provider } ᱠᱩᱞᱤ ᱮᱢ …
genai-shortcuts-hide =
    .label = ᱪᱟᱴᱵᱚᱴ ᱥᱚᱴᱠᱟᱴ ᱩᱠᱩᱭ ᱢᱮ

## Chatbot header

genai-chatbot-title = AI ᱪᱟᱴᱵᱚᱴ
genai-header-provider-menu =
    .title = ᱢᱤᱫᱴᱟᱝ ᱪᱟᱴᱵᱚᱴ ᱵᱟᱪᱷᱟᱣ ᱢᱮ
genai-header-options-button =
    .title = ᱢᱮᱱᱩ ᱡᱷᱤᱡᱽ ᱢᱮ
genai-header-close-button =
    .title = ᱵᱚᱸᱫᱚᱭ ᱢᱮ
genai-provider-view-details =
    .label = ᱪᱟᱴᱵᱚᱴ ᱵᱤᱵᱨᱚᱬ ᱧᱮᱞ ᱢᱮ
genai-provider-about-chatbots =
    .label = ᱱᱚᱶᱟ ᱠᱚ ᱪᱟᱴᱵᱚᱴ ᱵᱟᱨᱮᱛᱮ
genai-options-reload-generic =
    .label = AI ᱪᱟᱴᱵᱚᱴ ᱫᱚᱦᱲᱟ ᱞᱟᱫᱮ ᱢᱮ
# $provider (string) - name of the provider
genai-options-reload-provider =
    .label = { $provider } ᱫᱩᱦᱲᱟᱹ ᱞᱟᱫᱮ ᱯᱮ
genai-options-show-shortcut =
    .label = ᱚᱞ ᱵᱟᱪᱷᱟᱣ ᱚᱠᱛᱚ ᱥᱚᱴᱠᱟᱴ ᱩᱫᱩᱜ ᱢᱮ
genai-options-hide-shortcut =
    .label = ᱚᱞ ᱵᱟᱪᱷᱟᱣ ᱚᱠᱛᱚ ᱥᱚᱴᱠᱟᱴ ᱩᱠᱩᱭ ᱢᱮ
genai-options-about-chatbot =
    .label = { -brand-short-name } ᱨᱮ AI ᱪᱟᱴᱵᱚᱴ ᱵᱟᱨᱮᱛᱮ

## Chatbot onboarding

genai-onboarding-header = ᱩᱥᱟᱹᱨᱟ ᱞᱟᱹᱭ ᱢᱮ, ᱦᱩᱫᱤᱥ ᱦᱚᱨᱟ ᱢᱮ, ᱟᱨ ᱟᱭᱢᱟ ᱡᱮᱞᱠᱟ ᱟᱢ ᱵᱽᱨᱟᱣᱩᱡᱽ ᱮᱫᱟᱢ
# "Switch anytime" refers to allowing the user to switch to a different chatbot.
genai-onboarding-description = { -brand-short-name } ᱥᱟᱭᱤᱰᱵᱟᱨ ᱨᱮ ᱵᱮᱵᱷᱟᱨ ᱞᱟᱹᱜᱤᱫ ᱢᱤᱫ AI ᱪᱟᱴᱵᱚᱴ ᱵᱟᱪᱷᱟᱣ ᱢᱮ ᱾ ᱟᱢ ᱵᱟᱪᱷᱟᱣ ᱠᱷᱟᱱ ᱟᱞᱮ ᱥᱟᱱᱟᱢ ᱪᱟᱴᱵᱚᱴ ᱵᱟᱵᱚᱛ ᱵᱤᱵᱨᱚᱬ ᱞᱮ ᱩᱫᱩᱜᱟ ᱾ ᱡᱟᱦᱟᱸ ᱚᱠᱛᱚ ᱨᱮᱜᱮ ᱵᱚᱫᱚᱞ ᱢᱮ ᱾<a data-l10n-name="learn-more">ᱵᱟᱹᱲᱛᱤ ᱵᱟᱲᱟᱭ ᱢᱮ</a>
genai-onboarding-primary = ᱞᱮᱛᱟᱲ
genai-onboarding-secondary = ᱵᱚᱸᱫᱚᱭ ᱢᱮ
genai-onboarding-claude-tooltip =
    .title = Anthropic Claude
genai-onboarding-claude-learn = Claude ᱵᱟᱵᱚᱛ ᱰᱷᱮᱨ ᱵᱟᱰᱟᱭ ᱢᱮ
genai-onboarding-chatgpt-tooltip =
    .title = ChatGPT
genai-onboarding-chatgpt-learn = ChatGPT ᱵᱟᱵᱚᱛ ᱵᱟᱹᱲᱛᱤ ᱵᱟᱲᱟᱭ ᱢᱮ
genai-onboarding-copilot-tooltip =
    .title = Copilot
genai-onboarding-copilot-learn = Copilot ᱵᱟᱵᱚᱛ ᱰᱷᱮᱨ ᱵᱟᱰᱟᱭ ᱢᱮ
genai-onboarding-gemini-tooltip =
    .title = Google Gemini
genai-onboarding-gemini-learn = Gemini ᱵᱟᱨᱮᱛᱮ ᱵᱟᱹᱲᱛᱤ ᱵᱟᱲᱟᱭ ᱢᱮ
genai-onboarding-huggingchat-tooltip =
    .title = HuggingChat
genai-onboarding-huggingchat-learn = HuggingChat ᱵᱟᱵᱚᱛ ᱵᱟᱹᱲᱛᱤ ᱵᱟᱲᱟᱭ ᱢᱮ
genai-onboarding-lechat-tooltip =
    .title = Le Chat Mistral
genai-onboarding-lechat-learn = Le Chat ᱵᱟᱵᱚᱛ ᱵᱟᱹᱲᱛᱤ ᱵᱟᱲᱟᱭ ᱢᱮ
genai-onboarding-select-header = ᱥᱚᱞᱦᱟ ᱠᱚ ᱧᱮᱞ ᱞᱟᱹᱜᱤᱫ ᱚᱞ ᱵᱟᱪᱷᱟᱣ ᱢᱮ
genai-onboarding-select-description = ᱟᱢ ᱡᱚᱠᱷᱚᱱ ᱚᱞ ᱮᱢ ᱵᱟᱪᱷᱟᱣᱟ, ᱟᱞᱮ ᱫᱚ ᱟᱢ ᱪᱟᱴᱵᱚᱴ ᱛᱮ ᱵᱷᱮᱡᱟ ᱞᱟᱹᱜᱤᱫ ᱞᱟᱹᱭ ᱮᱢᱟᱢᱟ ᱾ ᱟᱢ ᱟᱢᱟᱜ ᱱᱤᱡᱚᱨ ᱯᱨᱚᱢᱯᱴ ᱦᱚᱸ ᱚᱞ ᱫᱟᱲᱮᱭᱟᱜᱼᱟᱢ ᱾
genai-onboarding-select-primary = ᱪᱟᱴᱤᱝ ᱮᱦᱚᱵ ᱢᱮ

## Chatbot onboarding choices
## These describe features/capabilities of chatbot providers. These are not buttons/actions.

genai-onboarding-claude-generate = ᱚᱞ ᱟᱨ ᱠᱳᱰ ᱵᱮᱱᱟᱣ ᱢᱮ
genai-onboarding-claude-analyze = ᱫᱚᱞᱤᱞ ᱠᱚ ᱟᱨ ᱪᱤᱛᱟᱹᱨ ᱠᱚ ᱵᱤᱥᱲᱤ ᱢᱮ
genai-onboarding-claude-price = ᱯᱚᱞᱟ ᱟᱨ ᱠᱤᱨᱤᱧ ᱢᱚᱱᱮᱛᱟᱭᱟᱜ ᱠᱚ;  ᱠᱷᱟᱛᱟ ᱞᱟᱹᱠᱛᱤᱭᱟᱱᱟ
genai-onboarding-chatgpt-generate = ᱚᱞ, ᱪᱤᱛᱟᱹᱨ ᱟᱨ ᱠᱳᱰ ᱵᱮᱱᱟᱣ ᱢᱮ
genai-onboarding-chatgpt-analyze = ᱫᱚᱞᱤᱞ ᱠᱚ ᱟᱨ ᱪᱤᱛᱟᱹᱨ ᱠᱚ ᱵᱤᱥᱲᱤ ᱢᱮ
genai-onboarding-chatgpt-price = ᱯᱚᱞᱟ ᱟᱨ ᱠᱤᱨᱤᱧ ᱢᱚᱱᱮᱛᱮᱭᱟᱜ ᱠᱚ;  ᱛᱤᱱᱟᱹᱜ ᱜᱟᱱ ᱫᱤᱥᱚᱢ ᱟᱨ ᱠᱟᱹᱢᱤ ᱠᱚ ᱞᱟᱹᱜᱤᱫ ᱠᱷᱟᱛᱟ ᱞᱟᱹᱠᱛᱤᱭᱟᱱᱟ
genai-onboarding-copilot-generate = ᱚᱞ, ᱪᱤᱛᱟᱹᱨ ᱟᱨ ᱠᱳᱰ ᱵᱮᱱᱟᱣ ᱢᱮ
genai-onboarding-copilot-analyze = ᱪᱤᱛᱟᱹᱨ ᱵᱤᱥᱲᱤ
genai-onboarding-copilot-price = ᱯᱚᱞᱟ ᱟᱨ ᱠᱤᱨᱤᱧ ᱢᱚᱱᱮᱛᱟᱭᱟᱜ ᱠᱚ; ᱛᱤᱱᱟᱹᱜ ᱜᱟᱱ ᱠᱟᱹᱢᱤᱦᱚᱨᱟ ᱞᱟᱹᱜᱤᱫ ᱠᱷᱟᱛᱟ ᱞᱟᱹᱠᱛᱤᱭᱟᱱᱟ
genai-onboarding-gemini-generate = ᱚᱞ, ᱪᱤᱛᱟᱹᱨ ᱟᱨ ᱠᱳᱰ ᱵᱮᱱᱟᱣ ᱢᱮ
genai-onboarding-gemini-analyze = ᱪᱤᱛᱟᱹᱨ ᱠᱚ ᱵᱤᱥᱲᱤ ᱢᱮ (ᱯᱚᱞᱟ ᱛᱮ) ᱟᱨ ᱫᱚᱞᱤᱞ ᱠᱚ (ᱠᱤᱨᱤᱧ)
genai-onboarding-gemini-price = ᱯᱚᱞᱟ ᱟᱨ ᱠᱤᱨᱤᱧ ᱢᱚᱱᱮᱛᱟᱭᱟᱜ ᱠᱚ;  ᱠᱷᱟᱛᱟ ᱞᱟᱹᱠᱛᱤᱭᱟᱱᱟ
genai-onboarding-huggingchat-generate = ᱚᱞ ᱟᱨ ᱠᱳᱰ ᱵᱮᱱᱟᱣ ᱢᱮ
genai-onboarding-huggingchat-switch = ᱠᱷᱩᱞᱟᱹ ᱢᱳᱰᱮᱞ ᱨᱮᱭᱟᱜ ᱵᱷᱮᱜᱟᱨ ᱥᱮᱴ ᱛᱟᱞᱟ ᱨᱮ ᱵᱚᱫᱚᱞ ᱢᱮ
genai-onboarding-huggingchat-price-2 = ᱯᱚᱞᱟ ᱛᱮ;  ᱛᱤᱱᱟᱹᱜ ᱜᱟᱱ ᱱᱮᱦᱚᱨ ᱛᱟᱭᱚᱢ ᱠᱷᱟᱛᱟ ᱞᱟᱹᱠᱛᱤᱜ ᱠᱟᱱᱟ
genai-onboarding-huggingchat-price = ᱯᱚᱞᱟ ᱛᱮ;  ᱛᱤᱱᱟᱹᱜ ᱜᱟᱱ ᱠᱟᱹᱢᱤ ᱞᱟᱹᱜᱤᱫ ᱮᱠᱟᱣᱩᱱᱴ ᱞᱟᱹᱠᱛᱤᱜ ᱠᱟᱱᱟ
genai-onboarding-lechat-generate = ᱚᱞ ᱟᱨ ᱠᱳᱰ ᱵᱮᱱᱟᱣ ᱢᱮ
genai-onboarding-lechat-price = ᱯᱚᱞᱟ ᱛᱮ;  ᱠᱷᱟᱛᱟ ᱞᱟᱹᱠᱛᱤᱭᱟᱱᱟ
